/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.dataflow;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.concurrent.util.MapUtil;
import co.paralleluniverse.fibers.DefaultFiberScheduler;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.channels.Channel;
import co.paralleluniverse.strands.channels.Channels;
import co.paralleluniverse.strands.channels.ReceivePort;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;

@Instrumented
public class Var<T> {
    private static final byte UNKNOWN = 0;
    private static final byte VARFIBER = 1;
    private static final byte PLAIN = 2;
    private static final Object NULL = new Object();
    private final Channel<T> ch;
    private final SuspendableCallable<T> f;
    private final Set<VarFiber<?>> registeredFibers = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
    private final ThreadLocal<TLVar> tlv = new ThreadLocal<TLVar>(){

        @Override
        protected TLVar initialValue() {
            return new TLVar();
        }
    };
    public static final FlightRecorder RECORDER = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;

    public Var(int history, FiberScheduler scheduler, SuspendableCallable<T> f) {
        if (history < 0) {
            throw new IllegalArgumentException("history must be >= 0, but is " + history);
        }
        this.ch = Channels.newChannel(1 + history, Channels.OverflowPolicy.DISPLACE);
        this.f = f;
        if (f != null) {
            new VarFiber(scheduler != null ? scheduler : DefaultFiberScheduler.getInstance(), this).start();
        }
    }

    public Var(int history, SuspendableCallable<T> f) {
        this(history, null, f);
    }

    public Var(SuspendableCallable<T> f) {
        this(0, null, f);
    }

    public Var(FiberScheduler scheduler, SuspendableCallable<T> f) {
        this(0, scheduler, f);
    }

    public Var(int history) {
        this(history, null, null);
    }

    public Var() {
        this(0, null, null);
    }

    public void set(T val) {
        try {
            Var.record("set", "Set %s to %s", this, val);
            this.ch.send(val == null ? NULL : val);
            this.notifyRegistered();
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    private void notifyRegistered() {
        for (VarFiber<?> fiber : this.registeredFibers) {
            fiber.signalNewValue(this);
        }
    }

    boolean isRecording() {
        return RECORDER != null;
    }

    static void record(String method, String format) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Var", method, format, null));
        }
    }

    static void record(String method, String format, Object arg1) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Var", method, format, new Object[]{arg1}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Var", method, format, new Object[]{arg1, arg2}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Var", method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Var", method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("Var", method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }

    static /* synthetic */ SuspendableCallable access$100(Var x0) {
        return x0.f;
    }

    static /* synthetic */ Set access$200(Var x0) {
        return x0.registeredFibers;
    }

    static /* synthetic */ void access$300(Var x0) {
        x0.notifyRegistered();
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=166, methodEnd=198, suspendableCallSites={181, 184}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/ReceivePort.receive()Ljava/lang/Object;", "co/paralleluniverse/strands/channels/ReceivePort.tryReceive()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={189, 254})
    public T get() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=206, methodEnd=210, suspendableCallSites={208}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/ReceivePort.receive()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={104})
    public T getNext() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented
    private static class VarFiber<T>
    extends Fiber<Void> {
        private final WeakReference<Var<T>> var;
        final Set<Var<?>> registeredVars = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
        private volatile boolean hasNewVal;

        VarFiber(FiberScheduler scheduler, Var<T> v) {
            super(scheduler);
            this.var = new WeakReference<Var<Var<T>>>(v);
        }

        VarFiber(Var<T> v) {
            this.var = new WeakReference<Var<Var<T>>>(v);
        }

        void signalNewValue(Var var) {
            Var.record("signalNewValue", "Fiber %s for var %s signalled by %s", this, this.var, var);
            this.hasNewVal = true;
            this.unpark(var);
        }

        /*
         * Exception decompiling
         */
        @Override
        @Instrumented(methodOptimized=false, methodStart=235, methodEnd=261, suspendableCallSites={243, 243, 248, 257, 258, 253, 257, 258, 257, 258}, suspendableCallSiteNames={"co/paralleluniverse/strands/dataflow/Var.access$000(Lco/paralleluniverse/strands/dataflow/Var;)Lco/paralleluniverse/strands/channels/Channel;", "co/paralleluniverse/strands/dataflow/Var.access$300(Lco/paralleluniverse/strands/dataflow/Var;)V", "co/paralleluniverse/fibers/Fiber.park(Ljava/lang/Object;)V", "co/paralleluniverse/strands/SuspendableCallable.run()Ljava/lang/Object;", "co/paralleluniverse/strands/dataflow/Var.access$200(Lco/paralleluniverse/strands/dataflow/Var;)Ljava/util/Set;", "co/paralleluniverse/strands/dataflow/Var.access$100(Lco/paralleluniverse/strands/dataflow/Var;)Lco/paralleluniverse/strands/SuspendableCallable;"}, suspendableCallSitesOffsetsAfterInstr={175, 225, 308, 468, 560, 640, 773, 866, 1029, 1146})
        protected Void run() throws SuspendExecution, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class TLVar {
        final ReceivePort<T> c;
        byte type;
        T val;

        public TLVar() {
            this.c = Channels.newTickerConsumerFor(Var.this.ch);
        }
    }
}

