/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.common.reflection.GetAccessDeclaredConstructor;
import co.paralleluniverse.common.reflection.GetAccessDeclaredField;
import co.paralleluniverse.common.reflection.GetDeclaredField;
import co.paralleluniverse.common.util.UtilUnsafe;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import sun.misc.Unsafe;

public class ThreadAccess {
    private static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long targetOffset;
    private static final long threadLocalsOffset;
    private static final long inheritableThreadLocalsOffset;
    private static final long contextClassLoaderOffset;
    private static final long inheritedAccessControlContextOffset;
    private static final Class<?> threadLocalMapClass;
    private static final Constructor<?> threadLocalMapConstructor;
    private static final Constructor<?> threadLocalMapInheritedConstructor;
    private static final Field threadLocalMapTableField;
    private static final Field threadLocalMapSizeField;
    private static final Field threadLocalMapThresholdField;
    private static final Class<?> threadLocalMapEntryClass;
    private static final Constructor<?> threadLocalMapEntryConstructor;
    private static final Field threadLocalMapEntryValueField;

    public static Runnable getTarget(Thread thread) {
        return (Runnable)UNSAFE.getObject(thread, targetOffset);
    }

    public static void setTarget(Thread thread, Runnable target) {
        UNSAFE.putObject(thread, targetOffset, target);
    }

    public static Object getThreadLocals(Thread thread) {
        return UNSAFE.getObject(thread, threadLocalsOffset);
    }

    public static void setThreadLocals(Thread thread, Object threadLocals) {
        UNSAFE.putObject(thread, threadLocalsOffset, threadLocals);
    }

    public static Object getInheritableThreadLocals(Thread thread) {
        return UNSAFE.getObject(thread, inheritableThreadLocalsOffset);
    }

    public static void setInheritableThreadLocals(Thread thread, Object inheritableThreadLocals) {
        UNSAFE.putObject(thread, inheritableThreadLocalsOffset, inheritableThreadLocals);
    }

    private static Object createThreadLocalMap(ThreadLocal tl, Object firstValue) {
        try {
            return threadLocalMapConstructor.newInstance(tl, firstValue);
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static Object createInheritedMap(Object inheritableThreadLocals) {
        try {
            return threadLocalMapInheritedConstructor.newInstance(inheritableThreadLocals);
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static Object cloneThreadLocalMap(Object orig) {
        try {
            Object clone = ThreadAccess.createThreadLocalMap(new ThreadLocal(), null);
            Object origTable = threadLocalMapTableField.get(orig);
            int len = Array.getLength(origTable);
            Object tableClone = Array.newInstance(threadLocalMapEntryClass, len);
            for (int i = 0; i < len; ++i) {
                Object entry = Array.get(origTable, i);
                if (entry == null) continue;
                Array.set(tableClone, i, ThreadAccess.cloneThreadLocalMapEntry(entry));
            }
            threadLocalMapTableField.set(clone, tableClone);
            threadLocalMapSizeField.setInt(clone, threadLocalMapSizeField.getInt(orig));
            threadLocalMapThresholdField.setInt(clone, threadLocalMapThresholdField.getInt(orig));
            return clone;
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static Object cloneThreadLocalMapEntry(Object entry) {
        try {
            ThreadLocal key = (ThreadLocal)((Reference)entry).get();
            Object value = threadLocalMapEntryValueField.get(entry);
            return threadLocalMapEntryConstructor.newInstance(key, value);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static Map<ThreadLocal, Object> toMap(Object threadLocalMap) {
        try {
            HashMap<ThreadLocal, Object> map = new HashMap<ThreadLocal, Object>();
            Object table = threadLocalMapTableField.get(threadLocalMap);
            int len = Array.getLength(table);
            for (int i = 0; i < len; ++i) {
                Object entry = Array.get(table, i);
                if (entry == null) continue;
                map.put((ThreadLocal)((Reference)entry).get(), threadLocalMapEntryValueField.get(entry));
            }
            return map;
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static ClassLoader getContextClassLoader(Thread thread) {
        return (ClassLoader)UNSAFE.getObject(thread, contextClassLoaderOffset);
    }

    public static void setContextClassLoader(Thread thread, ClassLoader classLoader) {
        UNSAFE.putObject(thread, contextClassLoaderOffset, classLoader);
    }

    public static AccessControlContext getInheritedAccessControlContext(Thread thread) {
        if (inheritedAccessControlContextOffset < 0L) {
            return null;
        }
        return (AccessControlContext)UNSAFE.getObject(thread, inheritedAccessControlContextOffset);
    }

    public static void setInheritedAccessControlContext(Thread thread, AccessControlContext accessControlContext) {
        if (inheritedAccessControlContextOffset >= 0L) {
            UNSAFE.putObject(thread, inheritedAccessControlContextOffset, accessControlContext);
        }
    }

    static {
        try {
            long _inheritedAccessControlContextOffset;
            block5: {
                targetOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(Thread.class, "target")));
                threadLocalsOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(Thread.class, "threadLocals")));
                inheritableThreadLocalsOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(Thread.class, "inheritableThreadLocals")));
                contextClassLoaderOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(Thread.class, "contextClassLoader")));
                _inheritedAccessControlContextOffset = -1L;
                try {
                    _inheritedAccessControlContextOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(Thread.class, "inheritedAccessControlContext")));
                }
                catch (PrivilegedActionException e) {
                    Throwable t = e.getCause();
                    if (t instanceof NoSuchFieldException) break block5;
                    throw new RuntimeException(t);
                }
            }
            inheritedAccessControlContextOffset = _inheritedAccessControlContextOffset;
            threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            threadLocalMapConstructor = (Constructor)AccessController.doPrivileged(new GetAccessDeclaredConstructor(threadLocalMapClass, ThreadLocal.class, Object.class));
            threadLocalMapInheritedConstructor = (Constructor)AccessController.doPrivileged(new GetAccessDeclaredConstructor(threadLocalMapClass, threadLocalMapClass));
            threadLocalMapTableField = AccessController.doPrivileged(new GetAccessDeclaredField(threadLocalMapClass, "table"));
            threadLocalMapSizeField = AccessController.doPrivileged(new GetAccessDeclaredField(threadLocalMapClass, "size"));
            threadLocalMapThresholdField = AccessController.doPrivileged(new GetAccessDeclaredField(threadLocalMapClass, "threshold"));
            threadLocalMapEntryClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap$Entry");
            threadLocalMapEntryConstructor = (Constructor)AccessController.doPrivileged(new GetAccessDeclaredConstructor(threadLocalMapEntryClass, ThreadLocal.class, Object.class));
            threadLocalMapEntryValueField = AccessController.doPrivileged(new GetAccessDeclaredField(threadLocalMapEntryClass, "value"));
        }
        catch (PrivilegedActionException ex) {
            throw new AssertionError((Object)ex.getCause());
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

