/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.contracts;

import java.time.LocalDate;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.corda.core.serialization.CordaSerializable;
import net.corda.finance.contracts.BusinessCalendar;
import net.corda.finance.contracts.DateRollConvention;
import net.corda.finance.contracts.DayCountBasisDay;
import net.corda.finance.contracts.DayCountBasisYear;
import net.corda.finance.contracts.Tenor$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/corda/finance/contracts/Tenor;", "", "name", "", "(Ljava/lang/String;)V", "amount", "", "getName", "()Ljava/lang/String;", "unit", "Lnet/corda/finance/contracts/Tenor$TimeUnit;", "component1", "copy", "daysToMaturity", "startDate", "Ljava/time/LocalDate;", "calendar", "Lnet/corda/finance/contracts/BusinessCalendar;", "equals", "", "other", "hashCode", "toString", "TimeUnit", "contracts"})
public final class Tenor {
    private final int amount;
    private final TimeUnit unit;
    @NotNull
    private final String name;

    public final int daysToMaturity(@NotNull LocalDate startDate, @NotNull BusinessCalendar calendar) {
        LocalDate maturityDate;
        LocalDate localDate;
        Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        switch (Tenor$WhenMappings.$EnumSwitchMapping$0[this.unit.ordinal()]) {
            case 1: {
                localDate = startDate.plusDays(this.amount);
                break;
            }
            case 2: {
                localDate = startDate.plusWeeks(this.amount);
                break;
            }
            case 3: {
                localDate = startDate.plusMonths(this.amount);
                break;
            }
            case 4: {
                localDate = startDate.plusYears(this.amount);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        LocalDate localDate2 = maturityDate = localDate;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"maturityDate");
        LocalDate adjustedMaturityDate = calendar.applyRollConvention(localDate2, DateRollConvention.ModifiedFollowing);
        return BusinessCalendar.Companion.calculateDaysBetween(startDate, adjustedMaturityDate, DayCountBasisYear.Y360, DayCountBasisDay.DActual);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public Tenor(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        if (Intrinsics.areEqual((Object)this.name, (Object)"ON")) {
            this.amount = 1;
            this.unit = TimeUnit.Day;
        } else {
            void element$iv2;
            block5: {
                void $receiver$iv;
                int n;
                String string = "(\\d+)([DMYW])";
                Regex regex = new Regex(string);
                Object object = regex.matchEntire((CharSequence)this.name);
                if (object == null || (object = object.getGroupValues()) == null) {
                    throw (Throwable)new IllegalArgumentException("Unrecognised tenor name: " + this.name);
                }
                Object match = object;
                TimeUnit[] timeUnitArray = (TimeUnit[])match.get(1);
                Tenor tenor = this;
                tenor.amount = n = Integer.parseInt((String)timeUnitArray);
                timeUnitArray = TimeUnit.values();
                tenor = this;
                for (void element$iv2 : $receiver$iv) {
                    void it = element$iv2;
                    if (!Intrinsics.areEqual((Object)it.getCode(), (Object)((String)match.get(2)))) {
                        continue;
                    }
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            void var12_7 = element$iv2;
            tenor.unit = var12_7;
        }
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Tenor copy(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new Tenor(name);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Tenor copy$default(Tenor tenor, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = tenor.name;
        }
        return tenor.copy(string);
    }

    public int hashCode() {
        String string = this.name;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Tenor)) break block3;
                Tenor tenor = (Tenor)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)tenor.name)) break block3;
            }
            return true;
        }
        return false;
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/finance/contracts/Tenor$TimeUnit;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "Day", "Week", "Month", "Year", "contracts"})
    public static final class TimeUnit
    extends Enum<TimeUnit> {
        public static final /* enum */ TimeUnit Day;
        public static final /* enum */ TimeUnit Week;
        public static final /* enum */ TimeUnit Month;
        public static final /* enum */ TimeUnit Year;
        private static final /* synthetic */ TimeUnit[] $VALUES;
        @NotNull
        private final String code;

        static {
            TimeUnit[] timeUnitArray = new TimeUnit[4];
            TimeUnit[] timeUnitArray2 = timeUnitArray;
            timeUnitArray[0] = Day = new TimeUnit("D");
            timeUnitArray[1] = Week = new TimeUnit("W");
            timeUnitArray[2] = Month = new TimeUnit("M");
            timeUnitArray[3] = Year = new TimeUnit("Y");
            $VALUES = timeUnitArray;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        protected TimeUnit(String code) {
            Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
            this.code = code;
        }

        public static TimeUnit[] values() {
            return (TimeUnit[])$VALUES.clone();
        }

        public static TimeUnit valueOf(String string) {
            return Enum.valueOf(TimeUnit.class, string);
        }
    }
}

