/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands;

import co.paralleluniverse.common.reflection.GetAccessDeclaredMethod;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberFactory;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.StrandFactory;
import co.paralleluniverse.strands.SuspendableCallable;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class StrandFactoryBuilder {
    private Boolean fiber;
    private boolean daemon;
    private FiberScheduler fs;
    private String nameFormat;
    private Integer stackSize;
    private Integer priority;
    private Strand.UncaughtExceptionHandler ueh;
    private static final Method nextThreadNum;

    public static StrandFactory from(final ThreadFactory tf) {
        Preconditions.checkNotNull((Object)tf);
        return new StrandFactory(){

            @Override
            public Strand newStrand(SuspendableCallable<?> target) {
                return Strand.of(tf.newThread(Strand.toRunnable(target)));
            }
        };
    }

    public static StrandFactory from(final FiberFactory ff) {
        Preconditions.checkNotNull((Object)ff);
        return new StrandFactory(){

            @Override
            public Strand newStrand(SuspendableCallable<?> target) {
                return ff.newFiber(target);
            }
        };
    }

    public StrandFactoryBuilder setThread(boolean daemon) {
        this.fiber = false;
        this.fs = null;
        this.daemon = daemon;
        return this;
    }

    public StrandFactoryBuilder setFiber(FiberScheduler fs) {
        this.fiber = true;
        this.fs = fs;
        return this;
    }

    public StrandFactoryBuilder setNameFormat(String nameFormat) {
        String ignore = String.format(nameFormat, 0);
        this.nameFormat = nameFormat;
        return this;
    }

    public StrandFactoryBuilder setStackSize(int stackSize) {
        this.stackSize = stackSize;
        return this;
    }

    public StrandFactoryBuilder setPriority(int priority) {
        Preconditions.checkArgument((priority >= 1 ? 1 : 0) != 0, (String)"Strand priority (%s) must be >= %s", (int)priority, (int)1);
        Preconditions.checkArgument((priority <= 10 ? 1 : 0) != 0, (String)"Strand priority (%s) must be <= %s", (int)priority, (int)10);
        this.priority = priority;
        return this;
    }

    public StrandFactoryBuilder setUncaughtExceptionHandler(Strand.UncaughtExceptionHandler ueh) {
        this.ueh = ueh;
        return this;
    }

    public StrandFactory build() {
        if (this.fiber == null) {
            throw new IllegalStateException("setFiber or setThread must be called before calling build");
        }
        final boolean _fiber = this.fiber;
        final boolean _daemon = this.daemon;
        final FiberScheduler _fs = this.fs;
        final String _nameFormat = this.nameFormat;
        final Strand.UncaughtExceptionHandler _ueh = this.ueh;
        final int _stackSize = this.stackSize != null ? this.stackSize : 0;
        final Integer _priority = this.priority;
        final AtomicLong _count = this.nameFormat != null ? new AtomicLong(0L) : null;
        return new StrandFactory(){

            @Override
            public Strand newStrand(SuspendableCallable<?> target) {
                Strand s;
                String name;
                String string = name = _nameFormat != null ? String.format(_nameFormat, _count.getAndIncrement()) : null;
                if (_fiber) {
                    s = _fs != null ? new Fiber(name, _fs, _stackSize, target) : new Fiber(name, _stackSize, target);
                } else {
                    Thread t = new Thread(null, Strand.toRunnable(target), name != null ? name : "Thread-" + StrandFactoryBuilder.nextThreadNum(), _stackSize);
                    if (name != null) {
                        t.setName(name);
                    }
                    t.setDaemon(_daemon);
                    if (_priority != null) {
                        t.setPriority(_priority);
                    }
                    s = Strand.of(t);
                }
                if (_ueh != null) {
                    ((Strand)s).setUncaughtExceptionHandler(_ueh);
                }
                return s;
            }
        };
    }

    private static int nextThreadNum() {
        try {
            return (Integer)nextThreadNum.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    static {
        try {
            nextThreadNum = AccessController.doPrivileged(new GetAccessDeclaredMethod(Thread.class, "nextThreadNum", new Class[0]));
        }
        catch (PrivilegedActionException e) {
            throw new AssertionError((Object)e.getCause());
        }
    }
}

