/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import co.paralleluniverse.common.util.ExtendedStackTrace;
import co.paralleluniverse.common.util.ExtendedStackTraceElement;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ExtendedStackTraceClassContext
extends ExtendedStackTrace {
    private static final ClassContext classContextGenerator = AccessController.doPrivileged(new CreateClassContext());
    private ExtendedStackTraceElement[] est;
    private final Class[] classContext = classContextGenerator.getClassContext();

    ExtendedStackTraceClassContext() {
        super(new Throwable());
    }

    @Override
    public synchronized ExtendedStackTraceElement[] get() {
        StackTraceElement[] st;
        if (this.est == null && (st = this.t.getStackTrace()) != null) {
            this.est = new ExtendedStackTraceElement[st.length - 1];
            int i = 1;
            int k = 2;
            while (i < st.length) {
                if (ExtendedStackTraceClassContext.skipCTX(this.classContext[k])) {
                    --i;
                } else {
                    Class clazz;
                    StackTraceElement ste = st[i];
                    if (ExtendedStackTraceClassContext.skipSTE(st[i])) {
                        --k;
                        clazz = null;
                    } else {
                        clazz = this.classContext[k];
                    }
                    this.est[i - 1] = new ExtendedStackTrace.BasicExtendedStackTraceElement(this, ste, clazz);
                }
                ++i;
                ++k;
            }
        }
        return this.est;
    }

    static boolean skipSTE(StackTraceElement ste) {
        String className = ste.getClassName();
        return className.startsWith("sun.reflect") || className.equals("java.lang.reflect.Method") || className.startsWith("java.lang.invoke.") || className.contains("$$Lambda$");
    }

    private static boolean skipCTX(Class c) {
        String className = c.getName();
        return className.startsWith("java.lang.invoke.") || className.contains("$$Lambda$");
    }

    private static final class CreateClassContext
    implements PrivilegedAction<ClassContext> {
        private CreateClassContext() {
        }

        @Override
        public ClassContext run() {
            return new ClassContext();
        }
    }

    private static class ClassContext
    extends SecurityManager {
        private ClassContext() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

