/*
 * Decompiled with CFR 0.152.
 */
package net.corda.bank;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Currency;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.bank.BankOfCordaCordformKt;
import net.corda.bank.IssueCash$WhenMappings;
import net.corda.bank.api.BankOfCordaClientApi;
import net.corda.bank.api.BankOfCordaWebApi;
import net.corda.core.contracts.Amount;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.testing.core.TestConstants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001b\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0016\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lnet/corda/bank/IssueCash;", "", "()V", "createParams", "Lnet/corda/bank/api/BankOfCordaWebApi$IssueRequestParams;", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "notaryName", "Lnet/corda/core/identity/CordaX500Name;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "printHelp", "parser", "Ljoptsimple/OptionParser;", "requestRpcIssue", "Lnet/corda/core/transactions/SignedTransaction;", "requestWebIssue", "Role", "bank-of-corda-demo"})
public final class IssueCash {
    public static final IssueCash INSTANCE;

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        OptionSet optionSet;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec roleArg = parser.accepts("role").withRequiredArg().ofType(Role.class).describedAs("[ISSUER|ISSUE_CASH_RPC|ISSUE_CASH_WEB]");
        ArgumentAcceptingOptionSpec quantity = parser.accepts("quantity").withOptionalArg().ofType(Long.TYPE);
        ArgumentAcceptingOptionSpec currency = parser.accepts("currency").withOptionalArg().ofType(String.class).describedAs("[GBP|USD|CHF|EUR]");
        try {
            optionSet = parser.parse(Arrays.copyOf(args, args.length));
        }
        catch (Exception e) {
            String string = e.getMessage();
            System.out.println((Object)string);
            INSTANCE.printHelp(parser);
            int n = 1;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        OptionSet options = optionSet;
        Object object = options.valueOf((OptionSpec)roleArg);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Role role = (Role)((Object)object);
        Object object2 = options.valueOf((OptionSpec)quantity);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"options.valueOf(quantity)");
        Amount amount = new Amount(((Number)object2).longValue(), (Object)Currency.getInstance((String)options.valueOf((OptionSpec)currency)));
        switch (IssueCash$WhenMappings.$EnumSwitchMapping$0[role.ordinal()]) {
            case 1: {
                String string = "Requesting Cash via RPC ...";
                System.out.println((Object)string);
                SignedTransaction result = INSTANCE.requestRpcIssue((Amount<Currency>)amount);
                String string2 = "Success!! Your transaction receipt is " + result.getTx().getId();
                System.out.println((Object)string2);
                break;
            }
            case 2: {
                String string = "Requesting Cash via Web ...";
                System.out.println((Object)string);
                INSTANCE.requestWebIssue((Amount<Currency>)amount);
                string = "Successfully processed Cash Issue request";
                System.out.println((Object)string);
            }
        }
    }

    @NotNull
    public final SignedTransaction requestRpcIssue(@NotNull Amount<Currency> amount) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        return BankOfCordaClientApi.INSTANCE.requestRPCIssue(new NetworkHostAndPort("localhost", 10006), this.createParams(amount, BankOfCordaCordformKt.access$getNOTARY_NAME$p()));
    }

    private final void requestWebIssue(Amount<Currency> amount) {
        BankOfCordaClientApi.INSTANCE.requestWebIssue(new NetworkHostAndPort("localhost", 10007), this.createParams(amount, BankOfCordaCordformKt.access$getNOTARY_NAME$p()));
    }

    private final BankOfCordaWebApi.IssueRequestParams createParams(Amount<Currency> amount, CordaX500Name notaryName) {
        return new BankOfCordaWebApi.IssueRequestParams(amount, BankOfCordaCordformKt.getBIGCORP_NAME(), "1", TestConstants.BOC_NAME, notaryName);
    }

    private final void printHelp(OptionParser parser) {
        String string = StringsKt.trimIndent((String)"\n        Usage: bank-of-corda --role ISSUER\n               bank-of-corda --role (ISSUE_CASH_RPC|ISSUE_CASH_WEB) --quantity <quantity> --currency <currency>\n\n        Please refer to the documentation in docs/build/index.html for more info.\n\n        ");
        System.out.println((Object)string);
        parser.printHelpOn((OutputStream)System.out);
    }

    private IssueCash() {
    }

    static {
        IssueCash issueCash;
        INSTANCE = issueCash = new IssueCash();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/bank/IssueCash$Role;", "", "(Ljava/lang/String;I)V", "ISSUE_CASH_RPC", "ISSUE_CASH_WEB", "bank-of-corda-demo"})
    public static final class Role
    extends Enum<Role> {
        public static final /* enum */ Role ISSUE_CASH_RPC;
        public static final /* enum */ Role ISSUE_CASH_WEB;
        private static final /* synthetic */ Role[] $VALUES;

        static {
            Role[] roleArray = new Role[2];
            Role[] roleArray2 = roleArray;
            roleArray[0] = ISSUE_CASH_RPC = new Role();
            roleArray[1] = ISSUE_CASH_WEB = new Role();
            $VALUES = roleArray;
        }

        public static Role[] values() {
            return (Role[])$VALUES.clone();
        }

        public static Role valueOf(String string) {
            return Enum.valueOf(Role.class, string);
        }
    }
}

