# Learning Interpretability Tool (LIT)

<!--* freshness: { owner: 'lit-dev' reviewed: '2024-08-15' } *-->

<!-- [TOC] placeholder - DO NOT REMOVE -->

Welcome to 🔥LIT, the Learning Interpretability Tool!

If you want to jump in and start playing with the LIT UI, check out the hosted demos at https://pair-code.github.io/lit/demos/.

## Research

Found LIT useful in your research? Please cite our
[system demonstration paper](https://aclanthology.org/2020.emnlp-demos.15/)!

```
@misc{tenney2020language,
    title={The Language Interpretability Tool: Extensible, Interactive Visualizations and Analysis for {NLP} Models},
    author={Ian Tenney and James Wexler and Jasmijn Bastings and Tolga Bolukbasi and Andy Coenen and Sebastian Gehrmann and Ellen Jiang and Mahima Pushkarna and Carey Radebaugh and Emily Reif and Ann Yuan},
    booktitle = "Proceedings of the 2020 Conference on Empirical Methods in Natural Language Processing: System Demonstrations",
    year = "2020",
    publisher = "Association for Computational Linguistics",
    pages = "107--118",
    url = "https://www.aclweb.org/anthology/2020.emnlp-demos.15",
}
```


```{toctree}
   :maxdepth: 2

   Main Site <https://pair-code.github.io/lit/>
   Getting Started <getting_started.md>
   Examples <demos.md>
   UI Guide <ui_guide.md>
   Components & Features <components.md>
   Python API <api.md>
   Frontend Development <frontend_development.md>
   Running in Docker <docker.md>
   Glossary <glossary.md>
   FAQ <faq.md>
   GitHub <https://github.com/pair-code/lit>
```
