#  ___________________________________________________________________________
#
#  Pyomo: Python Optimization Modeling Objects
#  Copyright (c) 2008-2024
#  National Technology and Engineering Solutions of Sandia, LLC
#  Under the terms of Contract DE-NA0003525 with National Technology and
#  Engineering Solutions of Sandia, LLC, the U.S. Government retains certain
#  rights in this software.
#  This software is distributed under the 3-clause BSD License.
#  ___________________________________________________________________________

# If a user doesn't have numpy the needed collocation values can be read from
# the following dictionaries for up to 10 collocation points.

radau_tau_dict = dict()
radau_adot_dict = dict()
radau_adotdot_dict = dict()

radau_tau_dict[1] = [0.00000000000000000, 1.00000000000000000]
radau_adot_dict[1] = [
    [-1.00000000000000000, -1.00000000000000000],
    [1.00000000000000000, 1.00000000000000000],
]
radau_adotdot_dict[1] = [
    [0.00000000000000000, 0.00000000000000000],
    [0.00000000000000000, 0.00000000000000000],
]

radau_tau_dict[2] = [0.00000000000000000, 0.33333333333333331, 1.00000000000000000]
radau_adot_dict[2] = [
    [-4.00000000000000000, -2.00000000000000000, 2.00000000000000000],
    [4.49999999999999911, 1.50000000000000000, -4.49999999999999911],
    [-0.49999999999999994, 0.49999999999999983, 2.49999999999999956],
]
radau_adotdot_dict[2] = [
    [6.00000000000000000, 6.00000000000000000, 6.00000000000000000],
    [-8.99999999999999822, -8.99999999999999822, -8.99999999999999822],
    [2.99999999999999956, 2.99999999999999956, 2.99999999999999956],
]

radau_tau_dict[3] = [
    0.00000000000000000,
    0.15505102572168220,
    0.64494897427831788,
    1.00000000000000000,
]
radau_adot_dict[3] = [
    [
        -9.00000000000000000,
        -4.13938769133981310,
        1.73938769133981630,
        -2.99999999999999289,
    ],
    [
        10.04880939982741417,
        3.22474487139158850,
        -3.56784008469040437,
        5.53197264742180472,
    ],
    [
        -1.38214273316074876,
        1.16784008469040512,
        0.77525512860840951,
        -7.53197264742180739,
    ],
    [
        0.33333333333333343,
        -0.25319726474218079,
        1.05319726474218167,
        5.00000000000000089,
    ],
]
radau_adotdot_dict[3] = [
    [
        36.00000000000000000,
        26.69693845669907262,
        -2.69693845669906551,
        -23.99999999999998579,
    ],
    [
        -51.25918289415326967,
        -36.76428546632148908,
        9.03367350481121889,
        42.22550938934205078,
    ],
    [
        20.59251622748660893,
        12.29965982852211681,
        -13.90238120034517166,
        -32.89217605600872218,
    ],
    [
        -5.33333333333333393,
        -2.23231281889968969,
        7.56564615223302539,
        14.66666666666666963,
    ],
]

radau_tau_dict[4] = [
    0.00000000000000000,
    0.08858795951270398,
    0.40946686444073388,
    0.78765946176084856,
    1.00000000000000000,
]
radau_adot_dict[4] = [
    [
        -16.00000000000000000,
        -7.15559202347522572,
        2.50822508194848126,
        -1.96487795643240304,
        4.00000000000000000,
    ],
    [
        17.80758523451450515,
        5.64410787595007868,
        -5.04921463839143314,
        3.49246615862542953,
        -6.92348825644540966,
    ],
    [
        -2.37791303706810631,
        1.92350727705471236,
        1.22110002889472469,
        -3.98451789578249116,
        6.59523766962805347,
    ],
    [
        0.82032780255359539,
        -0.58590148210381310,
        1.75468098876082568,
        0.63479209515516966,
        -12.17174941318265979,
    ],
    [
        -0.25000000000000150,
        0.17387835257424678,
        -0.43479146121258294,
        1.82213759843428735,
        8.50000000000003375,
    ],
]
radau_adotdot_dict[4] = [
    [
        120.00000000000002842,
        80.77386659356440646,
        -6.12558744008319422,
        2.49457798937631026,
        59.99999999999991473,
    ],
    [
        -167.81099920936088665,
        -108.53014807707648970,
        19.13996123354024803,
        -5.55774820017956017,
        -102.50641734094637059,
    ],
    [
        64.47853847308765296,
        33.70195692546346322,
        -24.04456776658558681,
        16.01268812735257541,
        89.78248626844741409,
    ],
    [
        -24.16753926372676275,
        -8.29000996475936880,
        13.56458045001081913,
        -32.42528415633811534,
        -92.27606892750115719,
    ],
    [
        7.50000000000004352,
        2.34433452280806431,
        -2.53438647688229590,
        19.47576623978871879,
        45.00000000000021316,
    ],
]

radau_tau_dict[5] = [
    0.00000000000000000,
    0.05710419611451772,
    0.27684301363812430,
    0.58359043236891450,
    0.86024013565621971,
    1.00000000000000000,
]
radau_adot_dict[5] = [
    [
        -24.99999999999998934,
        -11.03867924120895161,
        3.58306852250104768,
        -2.34417155790386644,
        2.28263550020568218,
        -4.99999999999998934,
    ],
    [
        27.78093394406463190,
        8.75592397793835531,
        -7.16138072014532057,
        4.12216524624339797,
        -3.87866321972407846,
        8.41242422359434627,
    ],
    [
        -3.64147849804922608,
        2.89194261538012576,
        1.80607772408358258,
        -4.49601712581350110,
        3.39315191806494454,
        -6.97025611665680067,
    ],
    [
        1.25254772116912538,
        -0.87518639620026994,
        2.36379717606862361,
        0.85676524539728360,
        -5.18834090640715306,
        8.77711420415049659,
    ],
    [
        -0.59200316718453727,
        0.39970520793996167,
        -0.86590078028312090,
        2.51832094921101479,
        0.58123305258075575,
        -18.21928231108803686,
    ],
    [
        0.19999999999999910,
        -0.13370616384921521,
        0.27433807777519198,
        -0.65706275713435502,
        2.80998365527971972,
        12.99999999999998046,
    ],
]
radau_adotdot_dict[5] = [
    [
        299.99999999999988631,
        193.30767250574382388,
        -12.94260048470914626,
        4.01680944012088048,
        -2.65348639942789077,
        -120.00000000000011369,
    ],
    [
        -416.05571460180254917,
        -256.99169401863719031,
        39.31282295335989829,
        -8.59570089776997293,
        5.14998177149959702,
        200.87922525110633387,
    ],
    [
        155.76675211023618317,
        76.96489565450156078,
        -45.97406446951362113,
        21.61006933401930041,
        -7.68796759900843085,
        -161.94936171559132276,
    ],
    [
        -58.33482863565966170,
        -18.65076273063174028,
        23.95041306691950922,
        -35.27049804403287681,
        31.47710816272410739,
        186.04880918852478544,
    ],
    [
        28.22379112722612859,
        7.99493810747577882,
        -6.09624628722275475,
        22.52106574808429329,
        -69.76374346781608438,
        -212.97867272403951233,
    ],
    [
        -9.59999999999995346,
        -2.62504951845222578,
        1.74967522116616792,
        -4.28174558042124787,
        43.47810753202831080,
        107.99999999999987210,
    ],
]

radau_tau_dict[6] = [
    0.00000000000000000,
    0.03980985705146874,
    0.19801341787360807,
    0.43797481024738633,
    0.69546427335363914,
    0.90146491420116948,
    1.00000000000000000,
]
radau_adot_dict[6] = [
    [
        -36.00000000000000711,
        -15.78653932217885725,
        4.92210694074628208,
        -2.96075238465032697,
        2.43407205775748992,
        -2.63456859759603645,
        6.00000000000010658,
    ],
    [
        39.96978645997430846,
        12.55970347629152073,
        -9.80283871256804673,
        5.18215783855881540,
        -4.10823909345830174,
        4.38578506340130758,
        -9.94297742192795653,
    ],
    [
        -5.18155025366218513,
        4.07582598887629377,
        2.52508140796374825,
        -5.54452290952744065,
        3.49150290911372618,
        -3.46400504745112281,
        7.67606215723310026,
    ],
    [
        1.76075790144825750,
        -1.21720380846425580,
        3.13222586264732650,
        1.14161816684750228,
        -5.06987875099333429,
        3.95154245658764758,
        -8.23273712821850268,
    ],
    [
        -0.84940911985935841,
        0.56623186694414962,
        -1.15740999277439549,
        2.97497625382130559,
        0.71894419189765457,
        -6.81053943889139468,
        11.63870727736906652,
    ],
    [
        0.46708167876565621,
        -0.30710421225684736,
        0.58338219245412648,
        -1.17801932705885992,
        3.46004179608641227,
        0.55465275700018646,
        -25.63905488445393033,
    ],
    [
        -0.16666666666666141,
        0.10908601078800384,
        -0.20254769846904672,
        0.38454236200916614,
        -0.92644311040306937,
        4.01713280695099240,
        18.49999999999969447,
    ],
]
radau_adotdot_dict[6] = [
    [
        630.00000000000011369,
        396.54850560676482019,
        -24.85744144817510914,
        6.76009741970790401,
        -3.49992393717195682,
        2.92254147231687966,
        210.00000000000011369,
    ],
    [
        -869.78996132627571569,
        -524.25860998479038244,
        74.42097200503803833,
        -14.19811474379628180,
        6.62453168299316530,
        -5.31473351050760812,
        -347.17973033968110030,
    ],
    [
        320.73627342386896544,
        153.90868125004695344,
        -84.06617913255860230,
        33.55233528423758571,
        -9.01718779800921766,
        6.00595681392809411,
        264.87167990774685222,
    ],
    [
        -118.73411607342019636,
        -36.68950585393311314,
        41.92433232904805607,
        -50.48791488764605617,
        32.08939067396651978,
        -12.66778060664290706,
        -275.31458997144886780,
    ],
    [
        58.71474561680227566,
        15.95063527339483755,
        -10.49847307491926074,
        29.90013111545132318,
        -57.34807867927669633,
        58.56656747411289388,
        354.19642620195918425,
    ],
    [
        -32.59360830764193651,
        -8.42709970780833828,
        4.60480310763264100,
        -7.77295210269013381,
        38.56768819963112804,
        -135.50588398238815557,
        -428.24045246523792230,
    ],
    [
        11.66666666666629837,
        2.96739341632510722,
        -1.52801378606603855,
        2.24641791473642805,
        -7.41642014213210032,
        85.99333233918015651,
        221.66666666666105812,
    ],
]

radau_tau_dict[7] = [
    0.00000000000000000,
    0.02931642715978489,
    0.14807859966848425,
    0.33698469028114536,
    0.55867151877159871,
    0.76923386202996824,
    0.92694567131978900,
    1.00000000000000000,
]
radau_adot_dict[7] = [
    [
        -49.00000000000001421,
        -21.39849085856454991,
        6.51502179852680996,
        -3.73823715601904638,
        2.82962981889280485,
        -2.61247344089161970,
        3.00318659221646556,
        -6.99999999999705835,
    ],
    [
        54.37443689412862113,
        17.05528430442161181,
        -12.94898869881147618,
        6.52679743370207177,
        -4.76041564316764010,
        4.32945101663698750,
        -4.94362383351764834,
        11.49545520510287133,
    ],
    [
        -7.00002400425923099,
        5.47529951218552391,
        3.37658514545231903,
        -6.91230492548291586,
        3.99086031809394370,
        -3.35352800168034548,
        3.70480267602441060,
        -8.51707242305759848,
    ],
    [
        2.35566109198741191,
        -1.61858110519068976,
        4.05401350392539683,
        1.48374693100539568,
        -5.66068833365461455,
        3.69061793186311915,
        -3.74572843137643474,
        8.38103130196178014,
    ],
    [
        -1.13228906610625679,
        0.74965412823858335,
        -1.48631397600665593,
        3.59460335445588974,
        0.89498029378042587,
        -6.03730918727312726,
        4.78166562576183818,
        -10.03344165195551696,
    ],
    [
        0.64689132676740668,
        -0.42189137598304860,
        0.77285447377897387,
        -1.45021560122282223,
        3.73589939150200845,
        0.64999738660694650,
        -8.78338875592014467,
        15.09439394298104631,
    ],
    [
        -0.38753338537515553,
        0.25105021424626478,
        -0.44494694720083683,
        0.76703844918100050,
        -1.54197850254845936,
        4.57730094140838428,
        0.53940593872494835,
        -34.42036637506053154,
    ],
    [
        0.14285714285719683,
        -0.09232481935371889,
        0.16177470033544300,
        -0.27142848561999122,
        0.51171265709985936,
        -1.24405664667738725,
        5.44368018806711085,
        25.00000000000752820,
    ],
]
radau_adotdot_dict[7] = [
    [
        1176.00000000000113687,
        729.91469055677328015,
        -43.99705165440991550,
        11.09319581520685460,
        -5.06492585326554945,
        3.39620181819555000,
        -3.23987336608297483,
        -335.99999999998067324,
    ],
    [
        -1619.20889513581641950,
        -961.80954755690038382,
        130.61915202258592217,
        -23.05926748673505244,
        9.46476140435538582,
        -6.07426097472375659,
        5.68160564288905334,
        551.08748211418060237,
    ],
    [
        591.45764413503638934,
        278.97169877665686499,
        -144.67589881629601223,
        52.67022396165839382,
        -12.29601631010507390,
        6.43814372663587164,
        -5.51652673198668708,
        -405.85864880032022484,
    ],
    [
        -216.87396735187854802,
        -65.73232123018885886,
        70.29838369672336285,
        -76.03933271744909916,
        40.93682565375758031,
        -12.27856070330389571,
        8.65728797388706539,
        393.77000318215408470,
    ],
    [
        106.91082287427600761,
        28.40345847945117441,
        -17.27717360830020255,
        43.09652520936204212,
        -67.31347956551157097,
        49.49615347850028257,
        -20.80944990243477832,
        -456.20281388413985724,
    ],
    [
        -61.71343933596624254,
        -15.53132892474618387,
        7.70766003923121445,
        -11.01359672248797494,
        42.17208432901723825,
        -92.57530312896015801,
        101.90967791837387324,
        623.89986304565343289,
    ],
    [
        37.14212052863845770,
        9.12282838083766023,
        -4.14735163396773032,
        4.87648419403544153,
        -11.13416017545824133,
        63.99686169444935047,
        -241.58643821502599280,
        -778.69588565766764532,
    ],
    [
        -13.71428571429089871,
        -3.33947848188361718,
        1.47227995443322612,
        -1.62423225359393264,
        3.23491051720515799,
        -12.39923591080969345,
        154.90371668037039399,
        408.00000000014506440,
    ],
]

radau_tau_dict[8] = [
    0.00000000000000000,
    0.02247938643871247,
    0.11467905316090524,
    0.26578982278458346,
    0.45284637366946501,
    0.64737528288675206,
    0.81975930826325683,
    0.94373743946299427,
    1.00000000000000000,
]
radau_adot_dict[8] = [
    [
        -64.00000000000002842,
        -27.87425774413988933,
        8.35812744119628803,
        -4.65663103170724213,
        3.35840944912858674,
        -2.86447035203517686,
        2.83231625843346535,
        -3.38129885029598398,
        8.00000000000247269,
    ],
    [
        70.99500301886784825,
        22.24259996433606545,
        -16.59113019706197178,
        8.11823601782297288,
        -5.63972363739064519,
        4.73592709079161978,
        -4.64760820860593071,
        5.52797002411787730,
        -13.06099604196067787,
    ],
    [
        -9.09751570679000920,
        7.09031167389262862,
        4.35999414207241820,
        -8.54518895924011623,
        4.69201955824859773,
        -3.63184859257696058,
        3.43555148904386343,
        -4.01565632541511075,
        9.42749172353134313,
    ],
    [
        3.03984525984412146,
        -2.08073537915066398,
        5.12492476602846203,
        1.88118564797551024,
        -6.56903294216630407,
        3.92643535657839049,
        -3.38635187509532765,
        3.80301840720573914,
        -8.80358194947172734,
    ],
    [
        -1.45199315226135184,
        0.95733575045937824,
        -1.86370389789729907,
        4.35063566670475144,
        1.10412720311081358,
        -6.26803995680457149,
        4.16083546606599874,
        -4.27430073943198074,
        9.61382400774353130,
    ],
    [
        0.83299700675733690,
        -0.54072898089916266,
        0.97031561191428606,
        -1.74911317938669364,
        4.21599357684380305,
        0.77234953700976872,
        -7.26324408226995466,
        5.80646148379917015,
        -12.23423422630618695,
    ],
    [
        -0.52539452304389933,
        0.33849233242014176,
        -0.58549937027751453,
        0.96226841393810580,
        -1.78522686380385132,
        4.63313895406601084,
        0.60993512965452401,
        -11.08565997531045966,
        19.11652897581404886,
    ],
    [
        0.33205809662591163,
        -0.21314332000205732,
        0.36230408377735768,
        -0.57210967985645711,
        0.97087801789264661,
        -1.96084361169319576,
        5.86878601947365564,
        0.52980837586298679,
        -44.55903248937006822,
    ],
    [
        -0.12499999999989404,
        0.08012570308357210,
        -0.13533257975200122,
        0.21071710374945074,
        -0.34744436186362104,
        0.65735157466000993,
        -1.61022019669692296,
        7.08965759946875007,
        32.49999999997948663,
    ],
]
radau_adotdot_dict[8] = [
    [
        2015.99999999999886313,
        1239.99192861138817534,
        -72.88277336463374922,
        17.51997492950863489,
        -7.41622246398424068,
        4.42474470018237298,
        -3.45505836901634211,
        3.58288090366227152,
        503.99999999988972377,
    ],
    [
        -2770.90657995308492900,
        -1630.48585774586695152,
        215.22120434682165069,
        -36.18768862506749429,
        13.75495994294169577,
        -7.84190921667504881,
        5.98918207791984969,
        -6.14338585945915838,
        -822.24204069615143453,
    ],
    [
        1005.82154971304328228,
        469.21734459367257841,
        -235.46920462750665592,
        80.94817109223765783,
        -17.38851951467177059,
        8.02560787757533944,
        -5.55420891566086539,
        5.43221355039884202,
        591.48961950584555325,
    ],
    [
        -366.22614016052142460,
        -109.66547335908660443,
        112.51932381135310379,
        -114.03856697909043305,
        55.72970078745805722,
        -14.51442473251881893,
        8.09486048192019325,
        -7.18946818613449068,
        -548.25173186668189373,
    ],
    [
        179.44238293686481711,
        47.03619970306451137,
        -27.27385345069615141,
        62.88550229946103798,
        -87.72454888081045965,
        54.76103907909609347,
        -17.60455379230006656,
        12.88533658273627225,
        589.75733674210323443,
    ],
    [
        -104.05015745498809565,
        -25.78505782347295394,
        12.10417617061391127,
        -15.74842237796789846,
        52.65566281481832789,
        -94.24763499920995002,
        75.40796505095357816,
        -33.03228119939271323,
        -725.83568034391191759,
    ],
    [
        65.96867264341469195,
        15.90701699696889904,
        -6.76634970978365402,
        7.09449560455202288,
        -13.67330039262928665,
        60.91049804570101855,
        -144.88017667908607677,
        167.08595546179009261,
        1030.45215074421412282,
    ],
    [
        -41.79972772471506914,
        -9.94444549812449807,
        4.03330080026613302,
        -3.84025861091543419,
        6.09951986279361336,
        -16.26166633443870069,
        101.83369347076927625,
        -402.15401008789632442,
        -1312.36965408491005292,
    ],
    [
        15.74999999998665778,
        3.72834452145616169,
        -1.48582397643374797,
        1.36679266728232918,
        -2.03725215592977626,
        4.74374558035409954,
        -19.83170332537023484,
        259.53275883437237326,
        692.99999999946010121,
    ],
]

radau_tau_dict[9] = [
    0.00000000000000000,
    0.01777991514736346,
    0.09132360789979158,
    0.21430847939565514,
    0.37193216458318179,
    0.54518668480366450,
    0.71317524285503242,
    0.85563374295856065,
    0.95536604470969477,
    1.00000000000000000,
]
radau_adot_dict[9] = [
    [
        -81.00000000000004263,
        -35.21371041699546822,
        10.44981407275295737,
        -5.70845918991450674,
        3.99044636662769392,
        -3.24550641903763903,
        2.97505006484350076,
        -3.07507805297768755,
        3.76536828826786518,
        -8.99999999981996268,
    ],
    [
        89.83153970403780875,
        28.12161902100757516,
        -20.72548579052329387,
        9.94239702329991815,
        -6.69350725779439415,
        5.35846675253802118,
        -4.87323434555169399,
        5.01573191942259200,
        -6.12808267753871405,
        14.63498313988655752,
    ],
    [
        -11.47427660946841854,
        8.92081258803495913,
        5.47503555213022963,
        -10.42353285499872761,
        5.54233383841019744,
        -4.08518036375891924,
        3.57529706687566495,
        -3.60730450562997618,
        4.36265193579587596,
        -10.37866849427310001,
    ],
    [
        3.81419058476079265,
        -2.60409926909004330,
        6.34280963158119349,
        2.33308547290572088,
        -7.69671638040896333,
        4.37120622211315357,
        -3.47654384844780662,
        3.35357051926256311,
        -3.96795795485506630,
        9.36337005841867942,
    ],
    [
        -1.81155300867822211,
        1.19114944341875217,
        -2.29142421583034039,
        5.22939639019224956,
        1.34433116470738323,
        -6.88110084999686755,
        4.18930008478254123,
        -3.66506200710954655,
        4.15432435331247341,
        -9.65496582374520607,
    ],
    [
        1.03663781378883102,
        -0.67091586184818763,
        1.18833546410413593,
        -2.08959625363386436,
        4.84142188082576919,
        0.91711704250234427,
        -7.13810812296376085,
        4.78992579324240619,
        -4.95650725767213451,
        11.18360001233891587,
    ],
    [
        -0.66086568819289371,
        0.42434507579736425,
        -0.72329307386970176,
        1.15580121794353330,
        -2.04989127776244118,
        4.96429376658586285,
        0.70108995663206752,
        -8.70492717485264045,
        7.00050032393480937,
        -14.78888179412784076,
    ],
    [
        0.44418925628006972,
        -0.28400708051187401,
        0.47454560842802779,
        -0.72499641695966344,
        1.16617483172783665,
        -2.16618785819994564,
        5.66054337792040574,
        0.58436218058158362,
        -13.70873474131953351,
        23.69369348149827204,
    ],
    [
        -0.29097316363860704,
        0.18563208227508743,
        -0.30702892266744786,
        0.45891161293728622,
        -0.70715775483021392,
        1.19915865821626211,
        -2.43531772552310599,
        7.33383174778555080,
        0.52335960970632778,
        -56.05313057954246148,
    ],
    [
        0.11111111111065723,
        -0.07082558208817376,
        0.11669167389433072,
        -0.17300700177212647,
        0.26256458849637060,
        -0.43226695095043116,
        0.82192349146213350,
        -2.02505041947615805,
        8.95507812083548060,
        40.99999999984667909,
    ],
]
radau_adotdot_dict[9] = [
    [
        3240.00000000000545697,
        1980.53309732568800428,
        -114.42620712287225615,
        26.63664641748528084,
        -10.72896282322562911,
        5.95301849750194378,
        -4.17155544005800039,
        3.59391863655673660,
        -3.94128334911420097,
        -719.99999999865576683,
    ],
    [
        -4447.87608954420284135,
        -2600.49011655120557407,
        336.67820261409178784,
        -54.78724845336546423,
        19.80358715418515203,
        -10.49137062609861459,
        7.18257226707373775,
        -6.11080090247105545,
        6.65766018161684769,
        1170.26881319972017081,
    ],
    [
        1607.54452124670115154,
        744.33437038919225870,
        -365.33348732541799109,
        120.87120189172378559,
        -24.60077979956736272,
        10.50864141856436618,
        -6.48566513203763861,
        5.22342907786128308,
        -5.53176371170411585,
        -828.20732992586363252,
    ],
    [
        -582.30354415434635484,
        -172.96394992509254962,
        172.60201919117605485,
        -167.60896467269702725,
        76.96551743950431046,
        -18.40402891132839613,
        9.06302501116192616,
        -6.53885215341313142,
        6.55556828523890545,
        743.96162132556196411,
    ],
    [
        283.73027874165160256,
        73.72086649402709213,
        -41.42307807001634501,
        90.75418388888155619,
        -117.99250491479705261,
        66.81188544956808073,
        -18.67902008318611706,
        10.87078077136675347,
        -9.89253198551369906,
        -760.96221976575043300,
    ],
    [
        -164.13245300991698628,
        -40.27868700928837598,
        18.24889512084277499,
        -22.38102011530529012,
        68.90492055498853574,
        -110.01080844268177827,
        74.97435376749007219,
        -25.26014270155025088,
        18.97944038046850324,
        867.87634172628565921,
    ],
    [
        105.20693630086218207,
        25.08698381043046766,
        -10.24636666980788391,
        10.02687310635811002,
        -17.52572396327565230,
        68.20843745319996287,
        -132.64836072304211712,
        112.03634693407799716,
        -50.48223693779995358,
        -1109.56693125532456179,
    ],
    [
        -70.92038990742307192,
        -16.65141728224165973,
        6.43807006935959691,
        -5.64388925268779929,
        7.95732764518548663,
        -17.92857590897373399,
        87.40646672305888387,
        -219.03517600681502131,
        260.56142963016372960,
        1614.63866261219004627,
    ],
    [
        46.52851810437505264,
        10.83652812131320786,
        -4.07266872679007008,
        3.37989165362496635,
        -4.32543145384469341,
        8.04653426879890077,
        -23.52549031272401692,
        155.64156750393439665,
        -633.54724802539033135,
        -2084.67562457484245897,
    ],
    [
        -17.77777777770516465,
        -4.12767537282225661,
        1.53462091943353940,
        -1.24767446403127380,
        1.54205016083713886,
        -2.69373319840810233,
        6.88367392321031701,
        -30.42107115646609117,
        410.64096553667678791,
        1106.66666666225228255,
    ],
]

radau_tau_dict[10] = [
    0.00000000000000000,
    0.01441240964887660,
    0.07438738970919330,
    0.17611665616301075,
    0.30966757992765476,
    0.46197040108073445,
    0.61811723469592150,
    0.76282301518486062,
    0.88192102120915938,
    0.96374218711743631,
    1.00000000000000000,
]
radau_adot_dict[10] = [
    [
        -99.99999999999992895,
        -43.41678141933171986,
        12.78928064012717414,
        -6.89033214590773468,
        4.71424042220159834,
        -3.71562642618960126,
        3.25251070724323199,
        -3.12664012305617689,
        3.33194417248405728,
        -4.15343825603231664,
        10.00000000127609212,
    ],
    [
        110.88407538476806735,
        34.69232502969869358,
        -25.35018316532213589,
        11.99292010956605736,
        -7.90161259937806904,
        6.12918393752630664,
        -5.32194911936971948,
        5.09292790632591164,
        -5.41326630798914721,
        6.73840799406796975,
        -16.21476095669183337,
    ],
    [
        -14.13042563810675745,
        10.96676844740408185,
        6.72156936753501100,
        -12.53860551309362670,
        6.52193803323750032,
        -4.65517513349904100,
        3.88652064846417034,
        -3.64160562711778191,
        3.82491118384537998,
        -4.73094762798258017,
        11.35599782133387237,
    ],
    [
        4.67906394414677873,
        -3.18883618300925242,
        7.70653109821361504,
        2.83902732934281943,
        -9.00782587641477051,
        4.94836491503828491,
        -3.74822938920076343,
        3.34996523906387900,
        -3.43085593463729754,
        4.18801525759520477,
        -10.00215748986232356,
    ],
    [
        -2.21205943883240552,
        1.45174133981855347,
        -2.76982675905947850,
        6.22423848775331479,
        1.61463463535339669,
        -7.72023958723235815,
        4.46475705244499466,
        -3.60534661369233866,
        3.51747913458111894,
        -4.19212161008806028,
        9.92280056892257534,
    ],
    [
        1.26107133935179649,
        -0.81451429917717033,
        1.42999497143838195,
        -2.47315028972017448,
        5.58410178361652942,
        1.08232042324193944,
        -7.50084536449850159,
        4.61850801153105017,
        -4.07645816576527142,
        4.64746574640746335,
        -10.82798481006249425,
    ],
    [
        -0.80471029795411542,
        0.51556091762280776,
        -0.87030740153648645,
        1.36561463645567671,
        -2.35414707076444429,
        5.46793601540036356,
        0.80890803856539795,
        -8.19834549755231023,
        5.54059999854366225,
        -5.76068266835737575,
        13.02507861791643684,
    ],
    [
        0.54963518680933576,
        -0.35055212590198581,
        0.57940256827736913,
        -0.86719768277172593,
        1.35069903504403777,
        -2.39216273039997107,
        5.82508173308438071,
        0.65546003463534208,
        -10.34477943836590796,
        8.35305931088237230,
        -17.67770050629743039,
    ],
    [
        -0.38587167045980814,
        0.24546694513846129,
        -0.40091971022846828,
        0.58509830261706175,
        -0.86814375212516004,
        1.39097894572954850,
        -2.59346954582678180,
        6.81506156755171588,
        0.56694419152493958,
        -16.64851704635335139,
        28.82039979943904484,
    ],
    [
        0.25922119027812629,
        -0.16466772675814162,
        0.26724017988160370,
        -0.38490377803763709,
        0.55758559986584344,
        -0.85461660474897316,
        1.45316814749785306,
        -2.96559387245064165,
        8.97207959068006033,
        0.51881094967812857,
        -68.90167304690199046,
    ],
    [
        -0.10000000000111019,
        0.06348907449566861,
        -0.10278178932642598,
        0.14729054379857887,
        -0.21147021062723262,
        0.31903624519012241,
        -0.52645290827396329,
        1.00560897518571801,
        -2.48859842500850359,
        11.03994795085468539,
        50.50000000038610182,
    ],
]
radau_adotdot_dict[10] = [
    [
        4950.00000000001000444,
        3012.45818548576608009,
        -171.92807396683292609,
        39.12368254110151611,
        -15.22355173022060626,
        8.04299673200512188,
        -5.26196411361797800,
        4.09877529060122470,
        -3.77805277644074522,
        4.30969851431291318,
        990.00000001395073923,
    ],
    [
        -6789.50954148942582833,
        -3951.38566209134569363,
        504.57258995426855108,
        -80.23508601244702731,
        28.00752278820436914,
        -14.12196953781221964,
        9.02102948758601997,
        -6.93356185793709301,
        6.34198920238668506,
        -7.20421773849466263,
        -1604.78711251807726512,
    ],
    [
        2446.17058314418500231,
        1126.63684055919816274,
        -544.35613668750829675,
        175.31442005468170464,
        -34.37866077254329866,
        13.94478215590061154,
        -8.00810267008409937,
        5.80551036253291386,
        -5.13604733090323862,
        5.73012087396318748,
        1122.41852183828268608,
    ],
    [
        -882.67682717657521607,
        -260.69663442977798695,
        255.11056670417383430,
        -240.47405916706395601,
        105.80855022391517650,
        -23.91022250684795836,
        10.89634601251998447,
        -7.02802676028693440,
        5.83162488790799216,
        -6.28895769033908891,
        -985.93738770249115078,
    ],
    [
        428.12521662480554596,
        110.56237292172352227,
        -60.78008650703299054,
        128.55302924034060652,
        -159.40428515599177217,
        84.66857988589373463,
        -21.72650903317338589,
        11.18586400415455273,
        -8.30500240114122334,
        8.46864426583795193,
        973.45496651867551918,
    ],
    [
        -246.75473480762772738,
        -60.15460530445014342,
        26.60265923994862192,
        -31.34628853732772313,
        91.36150260216422225,
        -135.67104500401671885,
        83.93926689676683850,
        -24.64829978253280274,
        14.79173951493723393,
        -13.70190884599441006,
        -1053.37594860374701966,
    ],
    [
        158.33831307548763334,
        37.48000390509794499,
        -14.90091247305119282,
        13.93327820916493920,
        -22.86655933407018892,
        81.87194083529310262,
        -142.08646851108039755,
        102.56317033977524034,
        -35.72304028380662544,
        27.35746667833063839,
        1247.31787653834112461,
    ],
    [
        -108.48598176740225085,
        -25.25972749273964268,
        9.47223310966056431,
        -7.88015157350419315,
        10.32307656776792726,
        -21.08072888263477296,
        89.93322727799926497,
        -184.81219612064086277,
        161.98894275991787595,
        -74.48113721593693981,
        -1636.38016330825212208,
    ],
    [
        76.29926328362374477,
        17.59755050097978568,
        -6.38256792536444095,
        4.98018184338134517,
        -5.83759324925205192,
        9.63545795644580494,
        -23.85786681336078630,
        123.37859657347641473,
        -320.52177806741110544,
        389.67404182444494154,
        2422.70575486484585781,
    ],
    [
        -51.30629088729910592,
        -11.77232624230349245,
        4.19352221896064492,
        -3.16288229629453355,
        3.50555428416709702,
        -5.25633362139525673,
        10.75988955514463186,
        -33.40792424239023717,
        229.48283922249345324,
        -954.28836921297772733,
        -3158.41650766262318939,
    ],
    [
        19.80000000021980000,
        4.53400218785288978,
        -1.60379366721661398,
        1.19387569800088045,
        -1.29555622403296056,
        1.87654198775976155,
        -3.60884808750712338,
        9.79809219080568994,
        -44.97321472272450649,
        620.42461854547525490,
        1683.00000001738249011,
    ],
]


legendre_tau_dict = dict()
legendre_adot_dict = dict()
legendre_adotdot_dict = dict()
legendre_afinal_dict = dict()

legendre_tau_dict[1] = [0.00000000000000000, 0.50000000000000000]
legendre_adot_dict[1] = [
    [-2.00000000000000000, -2.00000000000000000],
    [2.00000000000000000, 2.00000000000000000],
]
legendre_adotdot_dict[1] = [
    [0.00000000000000000, 0.00000000000000000],
    [0.00000000000000000, 0.00000000000000000],
]
legendre_afinal_dict[1] = [-1.00000000000000000, 2.00000000000000000]

legendre_tau_dict[2] = [0.00000000000000000, 0.21132486540518713, 0.78867513459481287]
legendre_adot_dict[2] = [
    [-6.00000000000000000, -3.46410161513775439, 3.46410161513775350],
    [6.46410161513775350, 2.99999999999999867, -6.46410161513775527],
    [-0.46410161513775472, 0.46410161513775461, 3.00000000000000000],
]
legendre_adotdot_dict[2] = [
    [12.00000000000000000, 12.00000000000000000, 12.00000000000000000],
    [-16.39230484541326405, -16.39230484541326405, -16.39230484541326405],
    [4.39230484541326405, 4.39230484541326405, 4.39230484541326405],
]
legendre_afinal_dict[2] = [
    1.00000000000000000,
    -1.73205080756887853,
    1.73205080756887719,
]

legendre_tau_dict[3] = [
    0.00000000000000000,
    0.11270166537925834,
    0.49999999999999989,
    0.88729833462074226,
]
legendre_adot_dict[3] = [
    [
        -11.99999999999999645,
        -5.99999999999999822,
        3.00000000000000000,
        -6.00000000000001421,
    ],
    [
        13.12163891034569119,
        4.99999999999999645,
        -5.72748612183952233,
        10.16397779494323395,
    ],
    [
        -1.33333333333333304,
        1.16397779494322196,
        2.00000000000000533,
        -9.16397779494322151,
    ],
    [
        0.21169442298763785,
        -0.16397779494322201,
        0.72748612183951156,
        4.99999999999999289,
    ],
]
legendre_adotdot_dict[3] = [
    [
        59.99999999999997158,
        46.47580015448897939,
        0.00000000000002842,
        -46.47580015448902202,
    ],
    [
        -82.06316679540748282,
        -62.06316679540748993,
        6.66666666666661456,
        75.39650012874085405,
    ],
    [
        26.66666666666665009,
        17.65053343632599336,
        -13.33333333333329307,
        -44.31720010299263635,
    ],
    [
        -4.60349987125914950,
        -2.06316679540749437,
        6.66666666666664476,
        15.39650012874080076,
    ],
]
legendre_afinal_dict[3] = [
    -0.99999999999999645,
    1.66666666666665364,
    -1.33333333333332416,
    1.66666666666666163,
]

legendre_tau_dict[4] = [
    0.00000000000000000,
    0.06943184420297367,
    0.33000947820757198,
    0.66999052179243102,
    0.93056815579702290,
]
legendre_adot_dict[4] = [
    [
        -20.00000000000000355,
        -9.43327565893721243,
        3.72430573391146424,
        -3.72430573391140385,
        9.43327565893692110,
    ],
    [
        21.98973890127313524,
        7.73861278752584170,
        -7.20134099970690400,
        6.34362221862489939,
        -15.56386959855438334,
    ],
    [
        -2.46548206404896098,
        2.04508965030390266,
        2.26138721247418006,
        -5.97155645948191527,
        11.89278387805641479,
    ],
    [
        0.59815998477037069,
        -0.43707080239579987,
        1.44878203453368237,
        2.26138721247403662,
        -13.50080272596486530,
    ],
    [
        -0.12241682199454294,
        0.08664402350326535,
        -0.23313398121242734,
        1.09085276229439554,
        7.73861278752593940,
    ],
]
legendre_adotdot_dict[4] = [
    [
        179.99999999999997158,
        125.72670690061997334,
        -5.72670690061985965,
        -5.72670690061895016,
        125.72670690061771381,
    ],
    [
        -246.17014587396408842,
        -166.39765713180497642,
        22.70209346695287422,
        7.56503572918063583,
        -204.73823615716273139,
    ],
    [
        83.67739618075455610,
        47.34890006452557998,
        -30.21982057995266757,
        8.12075844540986225,
        144.46156392997050943,
    ],
    [
        -22.14082193765889883,
        -8.22019077277292176,
        15.07523677232551762,
        -23.26534225303723247,
        -105.33285463822021200,
    ],
    [
        4.63357163086848001,
        1.54224093943233154,
        -1.83080275870586817,
        13.30625497906559573,
        39.88281996479484093,
    ],
]
legendre_afinal_dict[4] = [
    1.00000000000005329,
    -1.64070532173932548,
    1.21439396979861636,
    -1.21439396979864811,
    1.64070532173930372,
]

legendre_tau_dict[5] = [
    0.00000000000000000,
    0.04691007703066801,
    0.23076534494715878,
    0.49999999999999767,
    0.76923465505284816,
    0.95308992296932671,
]
legendre_adot_dict[5] = [
    [
        -29.99999999999999645,
        -13.74066696148972966,
        4.85177807260082616,
        -3.75000000000000355,
        4.85177807260098248,
        -13.74066696148843292,
    ],
    [
        33.07195697163451342,
        11.18330013267038581,
        -9.44759960151609590,
        6.42011650355944496,
        -8.01592078481075987,
        22.42091502590413299,
    ],
    [
        -3.87041820427842742,
        3.13131216201181450,
        2.81669986732958266,
        -6.22012045466986141,
        6.19052235495304970,
        -16.19339023999791749,
    ],
    [
        1.06666666666666399,
        -0.75873179598080620,
        2.21788633227481746,
        2.00000000000017453,
        -7.39311627638205326,
        15.41544322156842561,
    ],
    [
        -0.34832238831592910,
        0.23910122335368422,
        -0.55712262029379156,
        1.86599528883173571,
        2.81669986732908306,
        -19.08560117865692263,
    ],
    [
        0.08011695429317560,
        -0.05431476056534416,
        0.11835794960467859,
        -0.31599133772139809,
        1.55003676631008291,
        11.18330013267076595,
    ],
]
legendre_adotdot_dict[5] = [
    [
        419.99999999999982947,
        278.49806922095024220,
        -14.71744604136580392,
        -0.00000000000119371,
        14.71744604136091539,
        -278.49806922093699768,
    ],
    [
        -574.30238250892273300,
        -366.95347781100224438,
        49.55003419903368922,
        -2.65879371365303996,
        -22.96209706247395843,
        451.99517324935129636,
    ],
    [
        198.68090298370464097,
        104.09960256052515604,
        -59.58901220959256761,
        21.32546038032049296,
        11.88065010454926096,
        -317.35420636372941772,
    ],
    [
        -59.73333333333316375,
        -20.31939521965934858,
        28.96972952388082945,
        -37.33333333333214910,
        13.27112041309614199,
        276.74521194934067125,
    ],
    [
        19.99370966420485374,
        6.00991412485087828,
        -5.20777714493021904,
        21.32546038032136337,
        -42.50058496011200759,
        -219.26451792806466301,
    ],
    [
        -4.63889680565338036,
        -1.33471287566461294,
        0.99447167297441119,
        -2.65879371365547845,
        25.59346546357988927,
        86.37640831403922448,
    ],
]
legendre_afinal_dict[5] = [
    -1.00000000000002487,
    1.62776671089034863,
    -1.16110004422356416,
    1.06666666666675636,
    -1.16110004422360458,
    1.62776671089023295,
]

legendre_tau_dict[6] = [
    0.00000000000000000,
    0.03376524289842411,
    0.16939530676686565,
    0.38069040695841061,
    0.61930959304157429,
    0.83060469323316066,
    0.96623475710156437,
]
legendre_adot_dict[6] = [
    [
        -41.99999999999993605,
        -18.91598687354210995,
        6.27707018598655964,
        -4.25786745784672149,
        4.25786745784724019,
        -6.27707018598746203,
        18.91598687353456398,
    ],
    [
        46.36937471058886473,
        15.32559943877114961,
        -12.27449151016940476,
        7.31525360482739728,
        -7.05084663619737029,
        10.24428508749317501,
        -30.68867482146182368,
    ],
    [
        -5.55188252334920573,
        4.42878459321007956,
        3.55364671186248504,
        -7.21466693863796849,
        5.51203293000726458,
        -7.41573149790712893,
        21.57160573829168371,
    ],
    [
        1.62055582214317195,
        -1.13579253120089896,
        3.10459433591240153,
        2.12075384936568234,
        -6.81758425836822912,
        7.14920104705762327,
        -19.25696288834685177,
    ],
    [
        -0.61233946054691502,
        0.41365582265250200,
        -0.89624888663108360,
        2.57607655963439974,
        2.12075384936873057,
        -9.35754649633609681,
        19.97909959689369330,
    ],
    [
        0.23091612123217989,
        -0.15373639381797002,
        0.30843807418374597,
        -0.69100775654152158,
        2.39364176517328087,
        3.55364671185861347,
        -25.84665393768474928,
    ],
    [
        -0.05662467006817981,
        0.03747594392724378,
        -0.07300891114466557,
        0.15145813919897436,
        -0.41586510782973252,
        2.10321533382305148,
        15.32559943877357078,
    ],
]
legendre_adotdot_dict[6] = [
    [
        840.00000000000034106,
        540.64365692702745037,
        -29.49852090486558609,
        4.30940943239363605,
        4.30940943240420893,
        -29.49852090482625044,
        540.64365692693490928,
    ],
    [
        -1148.45314479649096029,
        -710.55980476921922673,
        93.76115559609706906,
        -11.14423553547817392,
        -5.82317129649572962,
        47.09684608675820527,
        -874.82230924609734757,
    ],
    [
        400.80870642748203636,
        201.05438486370465512,
        -107.78321107866594275,
        37.68889433782248943,
        -1.12326115476952282,
        -30.27496837960165976,
        607.05266152757224063,
    ],
    [
        -127.61291622770889376,
        -41.36116953176949096,
        51.45159825594288350,
        -58.52913567412112172,
        28.22512610388042731,
        19.03118936364580804,
        -524.47443280328877790,
    ],
    [
        49.45902404982912515,
        14.09194011206182040,
        -10.35399107180189304,
        32.51797774040460354,
        -54.23628403759174432,
        22.06641782049389278,
        497.20520338354441492,
    ],
    [
        -18.84093488066641342,
        -5.09807019969807662,
        3.12511118370701624,
        -6.00264539161375055,
        32.80951010098536358,
        -74.38313151534973144,
        -411.09634686360561773,
    ],
    [
        4.63926542755519922,
        1.22906259789328987,
        -0.70214198041270404,
        1.15973509059472679,
        -4.16132914840768731,
        45.96216752888985013,
        165.49156707494972807,
    ],
]
legendre_afinal_dict[6] = [
    1.00000000000023448,
    -1.62038592448029561,
    1.13226285721569386,
    -0.99615775754512259,
    0.99615775754528868,
    -1.13226285721527953,
    1.62038592448068686,
]

legendre_tau_dict[7] = [
    0.00000000000000000,
    0.02544604382862073,
    0.12923440720030088,
    0.29707742431132150,
    0.49999999999991773,
    0.70292257568894334,
    0.87076559279929833,
    0.97455395617159768,
]
legendre_adot_dict[7] = [
    [
        -56.00000000000002132,
        -24.95699224983718167,
        7.97122139249848516,
        -5.00831198289676394,
        4.37500000000198241,
        -5.00831198289225199,
        7.97122139249369610,
        -24.95699225001910193,
    ],
    [
        61.88240931737417583,
        20.16247512645392703,
        -15.62938350372294138,
        8.62518797240788615,
        -7.25855126339792633,
        8.18261458478745851,
        -12.92982669404072027,
        40.35246077250539543,
    ],
    [
        -7.51136417565297521,
        5.93964959590168462,
        4.44314605069609136,
        -8.60507619697540882,
        5.72724300702663669,
        -5.95689502166200402,
        9.08643835931158250,
        -27.93020953999701916,
    ],
    [
        2.26239965382932429,
        -1.57134500657698739,
        4.12514030348138228,
        2.39437882284758219,
        -7.24530497884105618,
        5.83011981449630134,
        -8.13184727997964174,
        24.12919609619037331,
    ],
    [
        -0.91428571428556327,
        0.61175686984007160,
        -1.27015154289550058,
        3.35183473001727927,
        2.00000000001065326,
        -7.93086282864597791,
        8.55812538746169338,
        -23.42957835555795398,
    ],
    [
        0.40410445842773468,
        -0.26626825561008405,
        0.51006822163588073,
        -1.04136216880175159,
        3.06209619082384332,
        2.39437882281619707,
        -11.74691936186807517,
        25.43427284718976011,
    ],
    [
        -0.16545222365648835,
        0.10823443910957012,
        -0.20014625792467550,
        0.37364484914258889,
        -0.85000700650864436,
        3.02182602446248127,
        4.44314605078047542,
        -33.76162469667988120,
    ],
    [
        0.04218868396380355,
        -0.02751051928098867,
        0.05010533623131365,
        -0.09029602574135479,
        0.18952405088461124,
        -0.53286941335658655,
        2.74966214585377111,
        20.16247512639485961,
    ],
]
legendre_adotdot_dict[7] = [
    [
        1512.00000000000136424,
        955.17220976465057447,
        -52.52606617900892161,
        9.73362464766137236,
        0.00000000009731593,
        -9.73362464726801591,
        52.52606618036497821,
        -955.17220976860744486,
    ],
    [
        -2067.01606297140551760,
        -1253.38842277582011775,
        162.29068757425784497,
        -22.20263024048540501,
        1.55684226134417258,
        15.02840159386050800,
        -84.30664536676113130,
        1542.17857544127218716,
    ],
    [
        725.02875733512803436,
        353.97302134103586013,
        -181.99436659032426178,
        61.32957187503291152,
        -7.98517305023528934,
        -7.75911289876353294,
        56.23751353436750833,
        -1060.20229529192101836,
    ],
    [
        -238.15771727410418634,
        -74.93409607897174851,
        85.81194610517053434,
        -90.22157046901992317,
        42.42833078878044262,
        -0.81172913281977799,
        -43.91260651839991169,
        901.77606559404171094,
    ],
    [
        98.74285714284027904,
        27.24730481156274209,
        -18.13844470779939400,
        49.08672625341207407,
        -71.99999999991771915,
        40.18741229017862793,
        29.88538722871460607,
        -846.05300126176780395,
    ],
    [
        -44.10991564822214883,
        -11.52331314083262725,
        6.31082242915802993,
        -10.11865122731538236,
        42.42833078884853393,
        -80.91464837445812464,
        35.58851715762842360,
        838.36528265599690712,
    ],
    [
        18.15063352060668578,
        4.62062771987776166,
        -2.31837696631370704,
        3.09190071157253854,
        -7.98517305038422975,
        50.47855826441588079,
        -123.43847608959974593,
        -710.84990166802811018,
    ],
    [
        -4.63855210484354519,
        -1.16733164150181246,
        0.56379833485978015,
        -0.69897155085565510,
        1.55684226147673055,
        -6.47525709510402336,
        77.42024387376613959,
        289.95748429913328437,
    ],
]
legendre_afinal_dict[7] = [
    -0.99999999999388223,
    1.61577764856546224,
    -1.11479680011004589,
    0.95616200868280021,
    -0.91428571427904048,
    0.95616200868308665,
    -1.11479680010902915,
    1.61577764856526751,
]

legendre_tau_dict[8] = [
    0.00000000000000000,
    0.01985507175123186,
    0.10166676129318630,
    0.23723379504185715,
    0.40828267875199609,
    0.59171732124838583,
    0.76276620495730396,
    0.89833323870751702,
    0.98014492824851973,
]
legendre_adot_dict[8] = [
    [
        -72.00000000000004263,
        -31.86270482565715412,
        9.92334055134359971,
        -5.93566167153326774,
        4.77763876751639316,
        -4.77763876749992278,
        5.93566167152931712,
        -9.92334055137200011,
        31.86270482530939319,
    ],
    [
        79.61124909724310328,
        25.69261129630993423,
        -19.49249456998708752,
        10.23940120319386438,
        -7.93798136828674217,
        7.81415574863481766,
        -9.63317863204990488,
        16.04021892350741751,
        -51.40631755760969668,
    ],
    [
        -9.74954002373760176,
        7.66481813729861372,
        5.47461453891830097,
        -10.29567243097007001,
        6.30583618259248624,
        -5.71807461469641876,
        6.78823557065591743,
        -11.09128684263623477,
        35.23749930320694546,
    ],
    [
        2.99348956666212596,
        -2.06676630520107674,
        5.28490391970722939,
        2.76313437015332930,
        -8.09856974150162934,
        5.66351220251587861,
        -6.11808325036549583,
        9.57597223864975611,
        -29.85316461647738606,
    ],
    [
        -1.25563894938631093,
        0.83496783603208580,
        -1.68681681755419466,
        4.22037639163487555,
        2.06963979464328407,
        -7.90081639272045244,
        6.54772240184247778,
        -9.32567356746433340,
        27.99672577169900123,
    ],
    [
        0.59780304784827276,
        -0.39132273505648596,
        0.72822972542038944,
        -1.40514792078421857,
        3.76153680354067799,
        2.06963979452872326,
        -9.36295087277397542,
        10.28426065963418168,
        -28.44037087278024600,
    ],
    [
        -0.28956627242951177,
        0.18808607902682645,
        -0.33706178120576785,
        0.59181451004613739,
        -1.21539550814094355,
        3.65045304711559337,
        2.76313437031730214,
        -14.52381437699152933,
        31.73184484258205629,
    ],
    [
        0.12487260336651484,
        -0.08078444839529625,
        0.14205776470902098,
        -0.23893707246388124,
        0.44651701311020470,
        -1.03427858098404957,
        3.74637393269219920,
        5.47461453867772274,
        -42.82153299233600308,
    ],
    [
        -0.03266906956651982,
        0.02109496564258326,
        -0.03677333135146867,
        0.06069262072337806,
        -0.10922194347498948,
        0.23304756309989128,
        -0.66691519188618820,
        3.48904897803242653,
        25.69261129644409536,
    ],
]
legendre_adotdot_dict[8] = [
    [
        2520.00000000000090949,
        1572.25586665412492948,
        -86.56014613860952522,
        17.23854645588744461,
        -3.62760030437402747,
        -3.62760030387107690,
        17.23854645773781158,
        -86.56014613432716942,
        1572.25586664403408577,
    ],
    [
        -3444.78427169258975482,
        -2060.96622834076197250,
        263.09322421714250595,
        -37.62226036411175301,
        8.01486084150565148,
        5.01617110615279671,
        -27.30193785095434578,
        139.10983548470085225,
        -2534.46090176581992637,
    ],
    [
        1212.13971195587168950,
        581.23547563107376845,
        -290.55498788776435504,
        94.99384966198795155,
        -15.03020634190829696,
        -0.33203744280103820,
        16.97741290928615854,
        -93.59679903671849388,
        1730.46278385835080371,
    ],
    [
        -405.82587761327783937,
        -125.21659712030918854,
        135.83301402521612999,
        -135.56529566622776883,
        61.17079963492420802,
        -8.51073841508491569,
        -10.52680040431016550,
        75.87967463193643880,
        -1453.64344528041101512,
    ],
    [
        174.66117736495289137,
        47.20422794611815220,
        -29.47214380806019562,
        72.66995469746716196,
        -98.05855537444153924,
        53.43943395699633925,
        -0.75784903103797774,
        -64.04888961811138870,
        1340.70375614392560237,
    ],
    [
        -84.06306918099681980,
        -21.47679674537697991,
        10.94561364337234011,
        -15.69308523747156414,
        56.58233626219350754,
        -94.91565306948129432,
        57.73471849138900325,
        45.52235945297945818,
        -1314.97632494899630728,
    ],
    [
        40.93829020959897491,
        10.17119383366238239,
        -4.71026735117333573,
        5.52277345783835472,
        -11.88813680317882415,
        57.79340124653427324,
        -119.51572180418217783,
        55.24307204231907065,
        1338.59804199367067667,
    ],
    [
        -17.70364534892667407,
        -4.33504594341068561,
        1.91205346445837066,
        -2.04327807251040916,
        3.67058914491560628,
        -11.02757975338868057,
        75.97315868135521555,
        -195.04613538682781382,
        -1153.56235417437846991,
    ],
    [
        4.63768430536677023,
        1.12790408487965221,
        -0.48636016458222553,
        0.49879506714018795,
        -0.83408705964564955,
        2.16460267487280067,
        -9.82152744934405852,
        123.49702856379471427,
        474.62257752963921575,
    ],
]
legendre_afinal_dict[8] = [
    1.00000000001314504,
    -1.61270748589470259,
    1.10338136852272584,
    -0.93102825702025305,
    0.86638605190870366,
    -0.86638605191483098,
    0.93102825702786762,
    -1.10338136853157120,
    1.61270748588940305,
]

legendre_tau_dict[9] = [
    0.00000000000000000,
    0.01591988024618697,
    0.08198444633668106,
    0.19331428364971090,
    0.33787328829809649,
    0.49999999999998818,
    0.66212671170135462,
    0.80668571635292641,
    0.91801555365888399,
    0.98408011975617415,
]
legendre_adot_dict[9] = [
    [
        -90.00000000000000000,
        -39.63264119105327410,
        12.12851059859160330,
        -7.01511384936590332,
        5.34993851876735960,
        -4.92187499998496492,
        5.34993851884806304,
        -7.01511384918430281,
        12.12851059864581771,
        -39.63264119586531109,
    ],
    [
        99.55598909732766799,
        31.91536013986444686,
        -23.85489675486203964,
        12.11618628428273325,
        -8.89850012739771046,
        8.05731837847299914,
        -8.68811464214157070,
        11.34222819973757623,
        -19.56194797369650473,
        63.84742973644408437,
    ],
    [
        -12.26675218688180102,
        9.60473274422036560,
        6.64337085452452136,
        -12.25034031333548867,
        7.10415389171663669,
        -5.92064746522829122,
        6.14067981568525134,
        -7.85310000897673888,
        13.39356328769438598,
        -43.48024012045856779,
    ],
    [
        3.81449796394589002,
        -2.62273389966038506,
        6.58610571835654568,
        3.20628182148887131,
        -9.22059257050451109,
        5.91709260879362375,
        -5.57175633530281722,
        6.80325700462606520,
        -11.32921505756870495,
        36.36946459829309219,
    ],
    [
        -1.63735741828795756,
        1.08416937549847714,
        -2.14973507073915204,
        5.18980295717751616,
        2.23498718411912378,
        -8.39737137097137598,
        6.04369696171071880,
        -6.67786023102398563,
        10.61745319758343697,
        -33.38945107441553262,
    ],
    [
        0.81269841269890952,
        -0.52963293110420040,
        0.96659804977583874,
        -1.79681984060012656,
        4.53051415078996200,
        1.99999999999004086,
        -8.87840069313420521,
        7.49799173065867652,
        -10.82341936169495789,
        32.73901752203290272,
    ],
    [
        -0.42635267436474061,
        0.27563309854307844,
        -0.48385422077774165,
        0.81660051999053529,
        -1.57372259341792353,
        4.28505213279403385,
        2.23498718427579801,
        -11.05106266780826729,
        12.28333404764205561,
        -34.19798735097366915,
    ],
    [
        0.21905670058542259,
        -0.14099568546145785,
        0.24246040539180438,
        -0.39069336168487667,
        0.68134087316442227,
        -1.41797294259394535,
        4.33017710836382896,
        3.20628182069896717,
        -17.67286037208154426,
        38.85120281315978730,
    ],
    [
        -0.09783459447325787,
        0.06281779684442529,
        -0.10682157859191509,
        0.16806687860617453,
        -0.27984054103791955,
        0.52875030544621326,
        -1.24331461720656522,
        4.56530718293380744,
        6.64337085675415029,
        -53.02215506490960450,
    ],
    [
        0.02605469944986686,
        -0.01670944769147080,
        0.02826199833055563,
        -0.04397109655906577,
        0.07172121380402063,
        -0.13034664667884382,
        0.28210669905274688,
        -0.81792918111806878,
        4.32121077772326245,
        31.91536013826765483,
    ],
]
legendre_adotdot_dict[9] = [
    [
        3960.00000000000636646,
        2449.23244343801252398,
        -134.72506496165851786,
        27.59243049492033606,
        -7.75422491796734903,
        0.00000000015825208,
        7.75422491979861661,
        -27.59243048269217979,
        134.72506501639145426,
        -2449.23244361997058149,
    ],
    [
        -5412.95014989901119407,
        -3208.17855536706520070,
        405.21532815706814290,
        -58.90585893610386847,
        15.50211814563954249,
        -1.05991994689429703,
        -11.94607131914472120,
        44.04606764111395023,
        -216.54454283843188023,
        3943.53308403724895470,
    ],
    [
        1908.76955531210796835,
        903.84506570014468707,
        -442.97475672738892172,
        141.51681733822647402,
        -23.76992618115173173,
        4.64481285598685645,
        6.27911597627007723,
        -28.68584939636843956,
        145.91599082331322279,
        -2678.97675480543648519,
    ],
    [
        -647.14542122413854486,
        -196.98051639768942778,
        205.82487724277052621,
        -198.13462877746178492,
        86.35275504153446491,
        -14.91896698109690078,
        -1.13594661549632292,
        21.44316278575911383,
        -119.26246439417218426,
        2229.50369928581039858,
    ],
    [
        285.03219640428966386,
        75.93825793596778340,
        -45.36507552646082786,
        105.08180522210406593,
        -134.00851970147965631,
        70.00074073890996829,
        -10.26244339015119067,
        -14.33379414972739596,
        104.46842886771196390,
        -2027.93288474663859233,
    ],
    [
        -143.03492063500803511,
        -35.99505507929153225,
        17.46763759164375074,
        -23.23988396359330011,
        76.13984118543359614,
        -117.33333333354978834,
        69.83799490112349417,
        -0.81555950977733005,
        -92.02320890177000479,
        1954.49226417083968954,
    ],
    [
        75.45565334056746565,
        18.44693932638234912,
        -8.09689973784180950,
        8.72020106556462338,
        -16.74124431754972875,
        70.00074073864384161,
        -127.52971877335448880,
        82.02781000701139646,
        67.20025308688440191,
        -1970.44156610286177056,
    ],
    [
        -38.88710314434736404,
        -9.35646156393163864,
        3.89064078190580886,
        -3.77926700503652313,
        5.95224352173367777,
        -14.91896698113937703,
        79.26456490565843183,
        -172.91219898934127741,
        82.67177206120041433,
        2041.87964445595162033,
    ],
    [
        17.39708335182820420,
        4.14897602736370885,
        -1.67485523073538189,
        1.54156343853406241,
        -2.21561079444067488,
        4.64481285590496640,
        -15.27519941418322347,
        111.28940449399883050,
        -295.38391066845593969,
        -1779.28066500595127764,
    ],
    [
        -4.63689350629434749,
        -1.10109401989310340,
        0.43816841069640766,
        -0.39317887715633404,
        0.54256801829518952,
        -1.05991994662241940,
        3.01347881039413501,
        -14.46661239681800382,
        188.23261695225846779,
        736.45562233795976681,
    ],
]
legendre_afinal_dict[9] = [
    -0.99999999984402166,
    1.61055933587154243,
    -1.09549656564146680,
    0.91410685277652037,
    -0.83551882927246868,
    0.81269841260834375,
    -0.83551882923754750,
    0.91410685274218284,
    -1.09549656564436848,
    1.61055933583909083,
]

legendre_tau_dict[10] = [
    0.00000000000000000,
    0.01304673574141415,
    0.06746831665550607,
    0.16029521585049855,
    0.28330230293545766,
    0.42556283050819915,
    0.57443716949547696,
    0.71669769705075892,
    0.83970478417600680,
    0.93253168331535052,
    0.98695326427132968,
]
legendre_adot_dict[10] = [
    [
        -110.00000000000000000,
        -48.26653972946562732,
        14.58422455235377413,
        -8.23538166798414295,
        6.04826207842279473,
        -5.26156988704238415,
        5.26156988692375194,
        -6.04826207854462439,
        8.23538166830557827,
        -14.58422454882743580,
        48.26653977557000985,
    ],
    [
        121.71668148641451523,
        38.83037195180988022,
        -28.71203882173124100,
        14.23657237574714429,
        -10.06834355550596172,
        8.61965936425299617,
        -8.54958113447447943,
        9.78275763528138498,
        -13.28423132235461424,
        23.48844594115318785,
        -77.67431735310977103,
    ],
    [
        -15.06318841233079908,
        11.75963007377668035,
        7.94706076240921533,
        -14.45264154521517597,
        8.06821861591184231,
        -6.35474528458405885,
        6.05889437968213329,
        -6.78555270364352481,
        9.10074268431098687,
        -15.97775657714056585,
        52.65200477837512949,
    ],
    [
        4.72579792623377593,
        -3.23961139769343909,
        8.02980653270048705,
        3.71469204823513088,
        -10.55227936000298250,
        6.39426319021315681,
        -5.52846235915797024,
        5.90164742527308217,
        -7.71035559947130622,
        13.34112152034829357,
        -43.65284594318689670,
    ],
    [
        -2.06000933721320978,
        1.35985522900652800,
        -2.66061894362531248,
        6.26315920858189656,
        2.46254338424009367,
        -9.18573497129368377,
        6.05874885367380678,
        -5.83716019930944618,
        7.25338273975789427,
        -12.22554045458789140,
        39.50979365427744483,
    ],
    [
        1.04943919172252786,
        -0.68175463794580859,
        1.22717505143961469,
        -2.22249620311669460,
        5.37919464231942435,
        2.04533185354943869,
        -9.06690360499340997,
        6.64956687773602972,
        -7.45730831274040451,
        11.98082234878989460,
        -37.89646608805214356,
    ],
    [
        -0.57596963692359993,
        0.37112921771794782,
        -0.64216120107171593,
        1.05462287543726285,
        -1.94728092377517736,
        4.97623989924771859,
        2.04533185206467927,
        -10.08148059787618678,
        8.62518164085033590,
        -12.56583619935860696,
        38.20709151175913121,
    ],
    [
        0.32188251103402238,
        -0.20645439625097245,
        0.34963785032787242,
        -0.54732920655391304,
        0.91207343001765540,
        -1.77426384051519537,
        4.90124995783930828,
        2.46254338824522812,
        -12.96921273733125624,
        14.53652154514421113,
        -40.66319448303887185,
    ],
    [
        -0.17221184261765482,
        0.11015691724576598,
        -0.18425638727037441,
        0.28097150273762012,
        -0.44532931983758861,
        0.78184280770199233,
        -1.64764363828474392,
        5.09596125379848708,
        3.71469203771722212,
        -21.18667167713655530,
        46.78230043223167911,
    ],
    [
        0.07884777913692809,
        -0.05035660797934716,
        0.08363505704009452,
        -0.12569182927851971,
        0.19405981027277527,
        -0.32475123821449697,
        0.62060214289693660,
        -1.47672572334488761,
        5.47759069482251437,
        7.94706078390704374,
        -64.36127821899061985,
    ],
    [
        -0.02126966545649496,
        0.01357337977838241,
        -0.02246445257250070,
        0.03352244140928518,
        -0.05111880205551231,
        0.08372810675104618,
        -0.15380633584957715,
        0.33670472285016945,
        -0.98586349356738034,
        5.24605731940845121,
        38.83037193772991458,
    ],
]
legendre_adotdot_dict[10] = [
    [
        5940.00000000000909495,
        3650.60621119290635761,
        -200.52466195021406747,
        41.56886837981528515,
        -12.91007541273756942,
        3.20426898918685765,
        3.20426897979450587,
        -12.91007545982938609,
        41.56886820874206023,
        -200.52466253305647115,
        3650.60621304507822060,
    ],
    [
        -8119.10522564299571968,
        -4779.27030063000620430,
        598.81843352328723995,
        -87.59904001603354118,
        24.92233012101314671,
        -6.53052952505277062,
        -4.51486906193804316,
        20.37521927781926934,
        -66.55405223726302211,
        322.23777377075930417,
        -5872.73443966030481533,
    ],
    [
        2867.37516521958332305,
        1345.42951605546863902,
        -649.94810035075261112,
        204.01485853159874750,
        -35.02651281911676051,
        9.49687432999326120,
        0.88246687665969148,
        -12.51602976308367943,
        44.04307874586584148,
        -217.01232175581662887,
        3974.46886194086710020,
    ],
    [
        -980.71186352483744031,
        -295.59259832645250299,
        300.63274824953089137,
        -281.96171854019064540,
        119.60100102986473303,
        -22.05312417493166777,
        4.08331288535759995,
        7.85253436331038301,
        -34.58596905278147915,
        177.49349972571496892,
        -3284.49966308706598284,
    ],
    [
        438.65921908907404259,
        115.67084484753382867,
        -66.94251026972102636,
        148.36553501226637763,
        -181.80009152007932016,
        91.56386361022600795,
        -16.83729166214823181,
        -1.81163895240644024,
        27.81573489937818522,
        -156.65252812072441202,
        2956.06055632424750002,
    ],
    [
        -225.94461629644376899,
        -56.25092040827590267,
        26.35878647458429214,
        -33.26841222999621550,
        102.11755671384275956,
        -148.44767755223068662,
        84.71647733172090966,
        -12.93062571870521538,
        -19.38991195906297094,
        143.16011660558126550,
        -2808.05844193727216407,
    ],
    [
        124.70798457908202295,
        30.14434976384028175,
        -12.73992408228727413,
        12.92824859689875439,
        -22.96770178736812795,
        87.20767047396154226,
        -145.95648441593758093,
        92.08048065397863979,
        -0.95025169407655596,
        -129.54125424532398370,
        2781.95187139803192622,
    ],
    [
        -69.91591454459906174,
        -16.62021110238747212,
        6.63427221207166440,
        -6.03370483302470006,
        8.70100766266027392,
        -19.44652098139492580,
        88.95463428189493982,
        -171.28744490161898284,
        114.51609527899320540,
        96.34429015810216868,
        -2857.00992207556782887,
    ],
    [
        37.47643302516524244,
        8.82137958864823446,
        -3.40579539515837126,
        2.91455014697952919,
        -3.79403081005474263,
        6.97397976037029821,
        -19.16245728452330610,
        107.95443588945002489,
        -244.46119936197482048,
        119.73345306595348347,
        2997.72844436084369590,
    ],
    [
        -17.17740663749788510,
        -4.02026384351714050,
        1.52266744980528657,
        -1.25933966773422412,
        1.55357726414079522,
        -2.60959678371050963,
        6.00481066076588021,
        -20.95690586320498028,
        158.71244001051152850,
        -431.41311106981731882,
        -2633.05960863876953226,
    ],
    [
        4.63622473345746045,
        1.08199286224006919,
        -0.40591586114592104,
        0.33015461943831514,
        -0.39706044187436440,
        0.64079185494469826,
        -1.37486858908956577,
        4.15005048165886947,
        -20.71483283092484839,
        276.17474439959875099,
        1094.54612834228328211,
    ],
]
legendre_afinal_dict[10] = [
    0.99999999956071406,
    -1.60899754383213178,
    1.08981601730200239,
    -0.90212990629010470,
    0.81429784307270081,
    -0.77746068027003834,
    0.77746068041548966,
    -0.81429784304977582,
    0.90212990635984425,
    -1.08981601689073226,
    1.60899754350164637,
]
