/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;
import sandbox.java.util.zip.CRC32;
import sandbox.java.util.zip.Deflater;
import sandbox.java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc;
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;

    public GZIPOutputStream(OutputStream outputStream, int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.<init>:(Ljava/io/OutputStream;IZ)V");
        this(outputStream, n, false);
    }

    public GZIPOutputStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/Deflater");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.<init>:(IZ)V");
        Deflater deflater = new Deflater(-1, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterOutputStream.<init>:(Ljava/io/OutputStream;Ljava/util/zip/Deflater;IZ)V");
        super(outputStream, deflater, n, bl);
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/CRC32");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.<init>:()V");
        this.crc = new CRC32();
        this.usesDefaultDeflater = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.writeHeader:()V");
        this.writeHeader();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.reset:()V");
        this.crc.reset();
    }

    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.<init>:(Ljava/io/OutputStream;IZ)V");
        this(outputStream, 512, false);
    }

    public GZIPOutputStream(OutputStream outputStream, boolean bl) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.<init>:(Ljava/io/OutputStream;IZ)V");
        this(outputStream, 512, bl);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterOutputStream.write:([BII)V");
        super.write(byArray, n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.update:([BII)V");
        this.crc.update(byArray, n, n2);
    }

    @Override
    public void finish() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finished:()Z");
        boolean bl = this.def.finished();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finish:()V");
            this.def.finish();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finished:()Z");
                boolean bl2 = this.def.finished();
                RuntimeCostAccounter.recordJump();
                if (bl2) break;
                int n = this.buf.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.deflate:([BII)I");
                int n2 = this.def.deflate(this.buf, 0, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finished:()Z");
                boolean bl3 = this.def.finished();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    int n3 = this.buf.length - 8;
                    RuntimeCostAccounter.recordJump();
                    if (n2 <= n3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.writeTrailer:([BI)V");
                        this.writeTrailer(this.buf, n2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                        this.out.write(this.buf, 0, n2 += 8);
                        return;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (n2 > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                    this.out.write(this.buf, 0, n2);
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordArrayAllocation((int)8, (int)1);
            byte[] byArray = new byte[8];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.writeTrailer:([BI)V");
            this.writeTrailer(byArray, 0);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([B)V");
            this.out.write(byArray);
        }
    }

    private void writeHeader() throws IOException {
        RuntimeCostAccounter.recordArrayAllocation((int)10, (int)1);
        byte[] byArray = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([B)V");
        this.out.write(byArray);
    }

    private void writeTrailer(byte[] byArray, int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/CRC32.getValue:()J");
        int n2 = (int)this.crc.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.writeInt:(I[BI)V");
        this.writeInt(n2, byArray, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getTotalIn:()I");
        int n3 = this.def.getTotalIn();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.writeInt:(I[BI)V");
        this.writeInt(n3, byArray, n + 4);
    }

    private void writeInt(int n, byte[] byArray, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.writeShort:(I[BI)V");
        this.writeShort(n & 0xFFFF, byArray, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/GZIPOutputStream.writeShort:(I[BI)V");
        this.writeShort(n >> 16 & 0xFFFF, byArray, n2 + 2);
    }

    private void writeShort(int n, byte[] byArray, int n2) throws IOException {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
    }
}

