/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.atomic;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.util.function.IntBinaryOperator;
import sandbox.java.util.function.IntUnaryOperator;
import sandbox.sun.misc.Unsafe;

public class AtomicInteger
extends Number
implements Serializable {
    private static final long serialVersionUID = 6214790243416807050L;
    private static final Unsafe unsafe;
    private static final long valueOffset;
    private volatile int value;

    public AtomicInteger(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
        this.value = n;
    }

    public AtomicInteger() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
    }

    public final int get() {
        return this.value;
    }

    public final void set(int n) {
        this.value = n;
    }

    public final void lazySet(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
        unsafe.putOrderedInt((Object)this, valueOffset, n);
    }

    public final int getAndSet(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndSetInt:(Ljava/lang/Object;JI)I");
        return unsafe.getAndSetInt((Object)this, valueOffset, n);
    }

    public final boolean compareAndSet(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
        return unsafe.compareAndSwapInt((Object)this, valueOffset, n, n2);
    }

    public final boolean weakCompareAndSet(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
        return unsafe.compareAndSwapInt((Object)this, valueOffset, n, n2);
    }

    public final int getAndIncrement() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddInt:(Ljava/lang/Object;JI)I");
        return unsafe.getAndAddInt((Object)this, valueOffset, 1);
    }

    public final int getAndDecrement() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddInt:(Ljava/lang/Object;JI)I");
        return unsafe.getAndAddInt((Object)this, valueOffset, -1);
    }

    public final int getAndAdd(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddInt:(Ljava/lang/Object;JI)I");
        return unsafe.getAndAddInt((Object)this, valueOffset, n);
    }

    public final int incrementAndGet() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddInt:(Ljava/lang/Object;JI)I");
        return unsafe.getAndAddInt((Object)this, valueOffset, 1) + 1;
    }

    public final int decrementAndGet() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddInt:(Ljava/lang/Object;JI)I");
        return unsafe.getAndAddInt((Object)this, valueOffset, -1) - 1;
    }

    public final int addAndGet(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndAddInt:(Ljava/lang/Object;JI)I");
        return unsafe.getAndAddInt((Object)this, valueOffset, n) + n;
    }

    public final int getAndUpdate(IntUnaryOperator intUnaryOperator) {
        int n;
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            n = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntUnaryOperator.applyAsInt:(I)I");
            int n2 = intUnaryOperator.applyAsInt(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.compareAndSet:(II)Z");
            bl = this.compareAndSet(n, n2);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return n;
    }

    public final int updateAndGet(IntUnaryOperator intUnaryOperator) {
        int n;
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n2 = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntUnaryOperator.applyAsInt:(I)I");
            n = intUnaryOperator.applyAsInt(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.compareAndSet:(II)Z");
            bl = this.compareAndSet(n2, n);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return n;
    }

    public final int getAndAccumulate(int n, IntBinaryOperator intBinaryOperator) {
        int n2;
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            n2 = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntBinaryOperator.applyAsInt:(II)I");
            int n3 = intBinaryOperator.applyAsInt(n2, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.compareAndSet:(II)Z");
            bl = this.compareAndSet(n2, n3);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return n2;
    }

    public final int accumulateAndGet(int n, IntBinaryOperator intBinaryOperator) {
        int n2;
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n3 = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntBinaryOperator.applyAsInt:(II)I");
            n2 = intBinaryOperator.applyAsInt(n3, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.compareAndSet:(II)Z");
            bl = this.compareAndSet(n3, n2);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return n2;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        int n = this.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
        return Integer.toString(n);
    }

    @Override
    public int intValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        return this.get();
    }

    @Override
    public long longValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        return this.get();
    }

    @Override
    public float floatValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        return this.get();
    }

    @Override
    public double doubleValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        return this.get();
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
        unsafe = Unsafe.getUnsafe();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = AtomicInteger.class.getDeclaredField("value");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            valueOffset = unsafe.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }
}

