/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Closeable;
import sandbox.java.io.File;
import sandbox.java.io.FileDescriptor;
import sandbox.java.io.FileNotFoundException;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.nio.channels.FileChannel;
import sandbox.sun.nio.ch.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final String path;
    private FileChannel channel;
    private final Object closeLock;
    private volatile boolean closed;

    public FileInputStream(String string) throws FileNotFoundException {
        File file;
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
            file = new File(string);
            RuntimeCostAccounter.recordJump();
        } else {
            file = null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.<init>:(Ljava/io/File;)V");
        this(file);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
        this.channel = null;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.closeLock = new Object();
        this.closed = false;
        RuntimeCostAccounter.recordJump();
        if (file != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
            string = file.getPath();
            RuntimeCostAccounter.recordJump();
        } else {
            string = null;
        }
        String string2 = string;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(string2);
        }
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = file.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/FileNotFoundException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileNotFoundException.<init>:(Ljava/lang/String;)V");
            FileNotFoundException fileNotFoundException = new FileNotFoundException("Invalid file path");
            RuntimeCostAccounter.recordThrow();
            throw fileNotFoundException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileDescriptor");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.<init>:()V");
        this.fd = new FileDescriptor();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.attach:(Ljava/io/Closeable;)V");
        this.fd.attach(this);
        this.path = string2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.open:(Ljava/lang/String;)V");
        this.open(string2);
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.<init>:()V");
        this.channel = null;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.closeLock = new Object();
        this.closed = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (fileDescriptor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/io/FileDescriptor;)V");
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.path = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.attach:(Ljava/io/Closeable;)V");
        this.fd.attach(this);
    }

    private native void open(String var1) throws FileNotFoundException;

    @Override
    public int read() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.read0:()I");
        return this.read0();
    }

    private native int read0() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.readBytes:([BII)I");
        return this.readBytes(byArray, 0, n);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.readBytes:([BII)I");
        return this.readBytes(byArray, n, n2);
    }

    @Override
    public native long skip(long var1) throws IOException;

    @Override
    public native int available() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (this.channel != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/channels/FileChannel.close:()V");
            this.channel.close();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileInputStream$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream$1.<init>:(Ljava/io/FileInputStream;)V");
        Closeable closeable = new Closeable(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public void close() throws IOException {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.access$000:(Ljava/io/FileInputStream;)V");
                FileInputStream.access$000(FileInputStream.this);
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.closeAll:(Ljava/io/Closeable;)V");
        this.fd.closeAll(closeable);
    }

    public final FileDescriptor getFD() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.fd != null) {
            return this.fd;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:()V");
        IOException iOException = new IOException();
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.channel == null) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/nio/ch/FileChannelImpl.open:(Ljava/io/FileDescriptor;Ljava/lang/String;ZZLjava/lang/Object;)Ljava/nio/channels/FileChannel;");
                this.channel = FileChannelImpl.open((FileDescriptor)this.fd, (String)this.path, (boolean)true, (boolean)false, (Object)this);
            }
            return this.channel;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    protected void finalize() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.fd != null) {
            RuntimeCostAccounter.recordJump();
            if (this.fd != FileDescriptor.in) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.close:()V");
                this.close();
            }
        }
    }

    static /* synthetic */ void access$000(FileInputStream fileInputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.close0:()V");
        fileInputStream.close0();
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.initIDs:()V");
        FileInputStream.initIDs();
    }
}

