/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */

// #docregion Component
import {Component} from '@angular/core';
import {FormArray, FormControl, FormGroup} from '@angular/forms';

@Component({
  selector: 'example-app',
  template: `
    <form [formGroup]="form" (ngSubmit)="onSubmit()">
      <div formArrayName="cities">
        <div *ngFor="let city of cities.controls; let i=index">
          <input [formControlName]="i" placeholder="City">
        </div>
      </div>
      <button>Submit</button>
    </form>
    
    <button (click)="addCity()">Add City</button>
    <button (click)="setPreset()">Set preset</button>
  `,
})
export class NestedFormArray {
  form = new FormGroup({
    cities: new FormArray([
      new FormControl('SF'),
      new FormControl('NY'),
    ]),
  });

  get cities(): FormArray { return this.form.get('cities') as FormArray; }

  addCity() { this.cities.push(new FormControl()); }

  onSubmit() {
    console.log(this.cities.value);  // ['SF', 'NY']
    console.log(this.form.value);    // { cities: ['SF', 'NY'] }
  }

  setPreset() { this.cities.patchValue(['LA', 'MTV']); }
}
// #enddocregion
