/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.common.util.DelegatingEquals;
import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.Synchronization;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.ProducerException;
import co.paralleluniverse.strands.channels.SelectAction;
import co.paralleluniverse.strands.channels.SelectActionImpl;
import co.paralleluniverse.strands.channels.Selectable;
import co.paralleluniverse.strands.channels.StandardChannel;
import java.util.concurrent.TimeUnit;
import sun.misc.Unsafe;

@Instrumented
public class TransferChannel<Message>
implements StandardChannel<Message>,
Selectable<Message>,
Synchronization {
    private Throwable closeException;
    private volatile boolean sendClosed;
    private boolean receiveClosed;
    private static final Object CHANNEL_CLOSED = new Object();
    private static final Object NO_MATCH = new Object();
    private static final Object LOST = new Object();
    private static final long serialVersionUID = -3223113410248163686L;
    private static final boolean MP = Runtime.getRuntime().availableProcessors() > 1;
    private static final int FRONT_SPINS = 128;
    private static final int CHAINED_SPINS = 64;
    static final int SWEEP_THRESHOLD = 32;
    volatile transient Node head;
    private volatile transient Node tail;
    private volatile transient int sweepVotes;
    private static final int NOW = 0;
    private static final int ASYNC = 1;
    private static final int SYNC = 2;
    private static final int TIMED = 3;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long sweepVotesOffset;

    @Override
    public final int capacity() {
        return 0;
    }

    @Override
    public boolean isSingleProducer() {
        return false;
    }

    @Override
    public boolean isSingleConsumer() {
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof DelegatingEquals) {
            return other.equals(this);
        }
        return super.equals(other);
    }

    @Override
    public boolean trySend(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (this.isSendClosed()) {
            return true;
        }
        boolean res = this.trySendOrReceive(message, true) == null;
        return res;
    }

    @Override
    public void close() {
        if (!this.sendClosed) {
            this.sendClosed = true;
            this.signalWaitersOnClose();
        }
    }

    @Override
    public void close(Throwable t) {
        if (!this.sendClosed) {
            this.closeException = t;
            this.sendClosed = true;
            this.signalWaitersOnClose();
        }
    }

    private void setReceiveClosed() {
        if (!this.receiveClosed) {
            this.receiveClosed = true;
        }
    }

    private Message closeValue() {
        if (this.closeException != null) {
            throw new ProducerException(this.closeException);
        }
        return null;
    }

    @Override
    public Message tryReceive() {
        if (this.receiveClosed) {
            return null;
        }
        Object m = this.trySendOrReceive(null, false);
        if (m == CHANNEL_CLOSED) {
            return this.closeValue();
        }
        return (Message)m;
    }

    @Override
    public Object register() {
        return this.receive0();
    }

    @Override
    public Object register(SelectAction<Message> action) {
        return this.xfer0((SelectActionImpl)action);
    }

    @Override
    public boolean tryNow(Object token) {
        Token t = (Token)token;
        return t.n.isMatched();
    }

    @Override
    public void unregister(Object token) {
        Token t = (Token)token;
        if (token == null) {
            return;
        }
        Node p = t.n;
        Node pred = t.pred;
        Object x = p.item;
        if (x != p && x == null != p.isData && p.casItem(x, p)) {
            this.unsplice(pred, p);
        }
    }

    boolean isSendClosed() {
        return this.sendClosed;
    }

    @Override
    public boolean isClosed() {
        if (this.receiveClosed) {
            return true;
        }
        if (this.sendClosed && this.size() == 0) {
            this.setReceiveClosed();
            return true;
        }
        return false;
    }

    private void signalWaitersOnClose() {
        Node p = this.head;
        while (p != null) {
            Node n;
            if (!p.isMatched()) {
                if (!p.isData) {
                    if (p.casItem(null, CHANNEL_CLOSED)) {
                        Strand.unpark(p.waiter, this);
                    }
                } else {
                    p.tryMatchData();
                }
            }
            if ((n = p.next) != p) {
                p = n;
                continue;
            }
            p = this.head;
        }
    }

    private boolean casTail(Node cmp, Node val) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, cmp, val);
    }

    private boolean casHead(Node cmp, Node val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp, val);
    }

    private boolean casSweepVotes(int cmp, int val) {
        return UNSAFE.compareAndSwapInt(this, sweepVotesOffset, cmp, val);
    }

    static <E> E cast(Object item) {
        return (E)item;
    }

    private Object trySendOrReceive(Message e, boolean haveData) {
        if (haveData && e == null) {
            throw new NullPointerException();
        }
        Object item = this.tryMatch(null, e, haveData);
        if (item != NO_MATCH) {
            return item;
        }
        return e;
    }

    private Token receive0() {
        Node pred;
        Node s = new Node(null, false);
        do {
            Object item;
            if ((item = this.tryMatch(null, null, false)) == NO_MATCH) continue;
            s.item = item;
            return new Token(s, null);
        } while ((pred = this.tryAppend(s, false)) == null);
        if (this.sendClosed) {
            s.item = CHANNEL_CLOSED;
            this.unsplice(pred, s);
            this.setReceiveClosed();
            return new Token(s, null);
        }
        this.requestUnpark(s, Strand.currentStrand());
        return new Token(s, pred);
    }

    private Token xfer0(SelectActionImpl<Message> e) {
        Node pred;
        boolean haveData = e.isData();
        Node s = null;
        do {
            if (!e.lease()) {
                return null;
            }
            if (this.isClosed() || this.isSendClosed() && e.isData()) {
                e.setItem(null);
                e.won();
                return null;
            }
            Object item = this.tryMatch(e, e.message(), haveData);
            if (item == LOST) {
                return null;
            }
            if (item != NO_MATCH) {
                e.setItem(item == CHANNEL_CLOSED ? null : item);
                e.won();
                return null;
            }
            e.returnLease();
            if (s != null) continue;
            s = new Node(e);
            this.requestUnpark(s, e.selector().getWaiter());
        } while ((pred = this.tryAppend(s, haveData)) == null);
        return new Token(s, pred);
    }

    private Object tryMatch(SelectActionImpl sa, Message e, boolean haveData) {
        Node h;
        boolean closed = this.isSendClosed();
        Node p = h = this.head;
        while (p != null) {
            Node n;
            boolean isData = p.isData;
            Object item = p.item;
            if (item != p && item != null == isData) {
                boolean leasedp;
                if (isData == haveData) break;
                SelectActionImpl sa2 = p.sa;
                if (sa != null && sa2 != null && sa2.selector().id < sa.selector().id) {
                    sa.returnLease();
                    leasedp = sa2.lease();
                    if (!sa.lease()) {
                        if (leasedp) {
                            sa2.returnLease();
                        }
                        return LOST;
                    }
                } else {
                    leasedp = p.lease();
                }
                if (leasedp) {
                    if (p.casItem(item, e)) {
                        p.won();
                        Node q = p;
                        while (q != h) {
                            Node n2 = q.next;
                            if (this.head == h && this.casHead(h, n2 == null ? q : n2)) {
                                h.forgetNext();
                                break;
                            }
                            h = this.head;
                            if (h != null && (q = h.next) != null && q.isMatched()) continue;
                            break;
                        }
                        Strand.unpark(p.waiter, this);
                        return item;
                    }
                    p.returnLease();
                }
            }
            p = p != (n = p.next) ? n : this.head;
        }
        if (closed) {
            assert (!haveData);
            this.setReceiveClosed();
            return CHANNEL_CLOSED;
        }
        return NO_MATCH;
    }

    private Node tryAppend(Node s, boolean haveData) {
        Node t;
        Node p = t = this.tail;
        while (true) {
            if (p == null && (p = this.head) == null) {
                if (!this.casHead(null, s)) continue;
                return s;
            }
            if (p.cannotPrecede(haveData)) {
                return null;
            }
            Node n = p.next;
            if (n != null) {
                Node u;
                p = p != t && t != (u = this.tail) ? u : (p != n ? n : null);
                continue;
            }
            if (p.casNext(null, s)) break;
            p = p.next;
        }
        if (p != t) {
            while (!(this.tail == t && this.casTail(t, s) || (t = this.tail) == null || (s = t.next) == null || (s = s.next) == null || s == t)) {
            }
        }
        return p;
    }

    private void requestUnpark(Node s, Strand waiter) {
        s.waiter = waiter;
    }

    private static int spinsFor(Node pred, boolean haveData) {
        if (MP && pred != null) {
            if (pred.isData != haveData) {
                return 192;
            }
            if (pred.isMatched()) {
                return 128;
            }
            if (pred.waiter == null) {
                return 64;
            }
        }
        return 0;
    }

    final Node succ(Node p) {
        Node next = p.next;
        return p == next ? this.head : next;
    }

    private Node firstOfMode(boolean isData) {
        Node p = this.head;
        while (p != null) {
            if (!p.isMatched()) {
                return p.isData == isData ? p : null;
            }
            p = this.succ(p);
        }
        return null;
    }

    private int countOfMode(boolean data) {
        int count = 0;
        Node p = this.head;
        while (p != null) {
            Node n;
            if (!p.isMatched()) {
                if (p.isData != data) {
                    return 0;
                }
                if (++count == Integer.MAX_VALUE) break;
            }
            if ((n = p.next) != p) {
                p = n;
                continue;
            }
            count = 0;
            p = this.head;
        }
        return count;
    }

    final void unsplice(Node pred, Node s) {
        block6: {
            Node n;
            s.forgetContents();
            if (pred == null || pred == s || pred.next != s || (n = s.next) != null && (n == s || !pred.casNext(s, n) || !pred.isMatched())) break block6;
            while (true) {
                Node h;
                if ((h = this.head) == pred || h == s || h == null) {
                    return;
                }
                if (!h.isMatched()) break;
                Node hn = h.next;
                if (hn == null) {
                    return;
                }
                if (hn == h || !this.casHead(h, hn)) continue;
                h.forgetNext();
            }
            if (pred.next != pred && s.next != s) {
                while (true) {
                    int v;
                    if ((v = this.sweepVotes) < 32) {
                        if (!this.casSweepVotes(v, v + 1)) continue;
                        break block6;
                    }
                    if (this.casSweepVotes(v, 0)) break;
                }
                this.sweep();
            }
        }
    }

    private void sweep() {
        Node s;
        Node p = this.head;
        while (p != null && (s = p.next) != null) {
            if (!s.isMatched()) {
                p = s;
                continue;
            }
            Node n = s.next;
            if (n == null) break;
            if (s == n) {
                p = this.head;
                continue;
            }
            p.casNext(s, n);
        }
    }

    boolean isEmpty() {
        Node p = this.head;
        while (p != null) {
            if (!p.isMatched()) {
                return !p.isData;
            }
            p = this.succ(p);
        }
        return true;
    }

    boolean hasWaitingConsumer() {
        return this.firstOfMode(false) != null;
    }

    int size() {
        return this.countOfMode(true);
    }

    public int getWaitingConsumerCount() {
        return this.countOfMode(false);
    }

    static {
        try {
            UNSAFE = UtilUnsafe.getUnsafe();
            Class<TransferChannel> k = TransferChannel.class;
            headOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("tail"));
            sweepVotesOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("sweepVotes"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={77}, methodStart=73, methodEnd=79, methodOptimized=false)
    public void send(Message var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={87}, methodStart=83, methodEnd=91, methodOptimized=false)
    public boolean send(Message var1_1, long var2_2, TimeUnit var4_3) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={96}, methodStart=96, methodEnd=96, methodOptimized=false)
    public boolean send(Message var1_1, Timeout var2_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={185}, methodStart=182, methodEnd=193, methodOptimized=false)
    public Message receive() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={200}, methodStart=197, methodEnd=206, methodOptimized=false)
    protected Message receiveInternal(long var1_1, TimeUnit var3_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Instrumented(suspendableCallSites={211}, methodStart=211, methodEnd=211, methodOptimized=true)
    public Message receive(long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
        return this.receiveInternal(timeout, unit);
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={216}, methodStart=216, methodEnd=216, methodOptimized=false)
    public Message receive(Timeout var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={518}, methodStart=493, methodEnd=518, methodOptimized=false)
    private Object xfer1(Message var1_1, boolean var2_2, int var3_3, long var4_4) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={722, 728, 731}, methodStart=691, methodEnd=733, methodOptimized=false)
    private Message awaitMatch(Node var1_1, Node var2_2, Message var3_3, boolean var4_4, long var5_5) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class Token {
        final Node n;
        final Node pred;

        public Token(Node n, Node pred) {
            this.n = n;
            this.pred = pred;
        }
    }

    static final class Node {
        final boolean isData;
        volatile SelectActionImpl sa;
        volatile Object item;
        volatile Node next;
        volatile Strand waiter;
        private static final long serialVersionUID = -3375979862319811754L;
        private static final Unsafe UNSAFE;
        private static final long itemOffset;
        private static final long saOffset;
        private static final long nextOffset;
        private static final long waiterOffset;

        final boolean casNext(Node cmp, Node val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp, val);
        }

        final boolean casItem(Object cmp, Object val) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, cmp, val);
        }

        Node(SelectActionImpl sa) {
            UNSAFE.putObject(this, itemOffset, sa.message());
            UNSAFE.putObject(this, saOffset, sa);
            this.isData = sa.isData();
        }

        Node(Object item, boolean isData) {
            UNSAFE.putObject(this, itemOffset, item);
            this.isData = isData;
        }

        final void forgetNext() {
            UNSAFE.putObject(this, nextOffset, this);
        }

        final void forgetContents() {
            UNSAFE.putObject(this, itemOffset, this);
            UNSAFE.putObject(this, saOffset, null);
            UNSAFE.putObject(this, waiterOffset, null);
        }

        final boolean isMatched() {
            Object x = this.item;
            return x == this || x == null == this.isData;
        }

        final boolean isUnmatchedRequest() {
            return !this.isData && this.item == null;
        }

        final boolean cannotPrecede(boolean haveData) {
            Object x;
            boolean d = this.isData;
            return d != haveData && (x = this.item) != this && x != null == d;
        }

        final boolean tryMatchData() {
            Object x = this.item;
            if (x != null && x != this && this.casItem(x, null)) {
                Strand.unpark(this.waiter, this);
                return true;
            }
            return false;
        }

        boolean lease() {
            if (this.sa == null) {
                return true;
            }
            return this.sa.lease();
        }

        void returnLease() {
            if (this.sa != null) {
                this.sa.returnLease();
            }
        }

        void won() {
            if (this.sa != null) {
                Object x = this.item;
                this.sa.setItem(x == CHANNEL_CLOSED ? null : x);
                this.sa.won();
            }
        }

        static {
            try {
                UNSAFE = UtilUnsafe.getUnsafe();
                Class<Node> k = Node.class;
                itemOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("item"));
                saOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("sa"));
                nextOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("next"));
                waiterOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("waiter"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

