// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// DO NOT EDIT: this file is automatically generated by docgen
package templates

import (
	"github.com/projectdiscovery/yamldoc-go/encoder"
)

var (
	TemplateDoc                   encoder.Doc
	MODELInfoDoc                  encoder.Doc
	STRINGSLICEStringSliceDoc     encoder.Doc
	SEVERITYHolderDoc             encoder.Doc
	MODELClassificationDoc        encoder.Doc
	HTTPRequestDoc                encoder.Doc
	MATCHERSMatcherDoc            encoder.Doc
	MatcherTypeHolderDoc          encoder.Doc
	EXTRACTORSExtractorDoc        encoder.Doc
	ExtractorTypeHolderDoc        encoder.Doc
	GENERATORSAttackTypeHolderDoc encoder.Doc
	HTTPMethodTypeHolderDoc       encoder.Doc
	SignatureTypeHolderDoc        encoder.Doc
	DNSRequestDoc                 encoder.Doc
	DNSRequestTypeHolderDoc       encoder.Doc
	FILERequestDoc                encoder.Doc
	NETWORKRequestDoc             encoder.Doc
	NETWORKInputDoc               encoder.Doc
	NetworkInputTypeHolderDoc     encoder.Doc
	HEADLESSRequestDoc            encoder.Doc
	ENGINEActionDoc               encoder.Doc
	ActionTypeHolderDoc           encoder.Doc
	USERAGENTUserAgentHolderDoc   encoder.Doc
	SSLRequestDoc                 encoder.Doc
	WEBSOCKETRequestDoc           encoder.Doc
	WEBSOCKETInputDoc             encoder.Doc
	WHOISRequestDoc               encoder.Doc
	WORKFLOWSWorkflowTemplateDoc  encoder.Doc
	WORKFLOWSMatcherDoc           encoder.Doc
	HTTPSignatureTypeHolderDoc    encoder.Doc
	VARIABLESVariableDoc          encoder.Doc
)

func init() {
	TemplateDoc.Type = "Template"
	TemplateDoc.Comments[encoder.LineComment] = " Template is a YAML input file which defines all the requests and"
	TemplateDoc.Description = "Template is a YAML input file which defines all the requests and\n other metadata for a template."
	TemplateDoc.Fields = make([]encoder.Doc, 15)
	TemplateDoc.Fields[0].Name = "id"
	TemplateDoc.Fields[0].Type = "string"
	TemplateDoc.Fields[0].Note = ""
	TemplateDoc.Fields[0].Description = "ID is the unique id for the template.\n\n#### Good IDs\n\nA good ID uniquely identifies what the requests in the template\nare doing. Let's say you have a template that identifies a git-config\nfile on the webservers, a good name would be `git-config-exposure`. Another\nexample name is `azure-apps-nxdomain-takeover`."
	TemplateDoc.Fields[0].Comments[encoder.LineComment] = "ID is the unique id for the template."

	TemplateDoc.Fields[0].AddExample("ID Example", "CVE-2021-19520")
	TemplateDoc.Fields[1].Name = "info"
	TemplateDoc.Fields[1].Type = "model.Info"
	TemplateDoc.Fields[1].Note = ""
	TemplateDoc.Fields[1].Description = "Info contains metadata information about the template."
	TemplateDoc.Fields[1].Comments[encoder.LineComment] = "Info contains metadata information about the template."

	TemplateDoc.Fields[1].AddExample("", exampleInfoStructure)
	TemplateDoc.Fields[2].Name = "requests"
	TemplateDoc.Fields[2].Type = "[]http.Request"
	TemplateDoc.Fields[2].Note = ""
	TemplateDoc.Fields[2].Description = "Requests contains the http request to make in the template."
	TemplateDoc.Fields[2].Comments[encoder.LineComment] = "Requests contains the http request to make in the template."

	TemplateDoc.Fields[2].AddExample("", exampleNormalHTTPRequest)
	TemplateDoc.Fields[3].Name = "dns"
	TemplateDoc.Fields[3].Type = "[]dns.Request"
	TemplateDoc.Fields[3].Note = ""
	TemplateDoc.Fields[3].Description = "DNS contains the dns request to make in the template"
	TemplateDoc.Fields[3].Comments[encoder.LineComment] = "DNS contains the dns request to make in the template"

	TemplateDoc.Fields[3].AddExample("", exampleNormalDNSRequest)
	TemplateDoc.Fields[4].Name = "file"
	TemplateDoc.Fields[4].Type = "[]file.Request"
	TemplateDoc.Fields[4].Note = ""
	TemplateDoc.Fields[4].Description = "File contains the file request to make in the template"
	TemplateDoc.Fields[4].Comments[encoder.LineComment] = "File contains the file request to make in the template"

	TemplateDoc.Fields[4].AddExample("", exampleNormalFileRequest)
	TemplateDoc.Fields[5].Name = "network"
	TemplateDoc.Fields[5].Type = "[]network.Request"
	TemplateDoc.Fields[5].Note = ""
	TemplateDoc.Fields[5].Description = "Network contains the network request to make in the template"
	TemplateDoc.Fields[5].Comments[encoder.LineComment] = "Network contains the network request to make in the template"

	TemplateDoc.Fields[5].AddExample("", exampleNormalNetworkRequest)
	TemplateDoc.Fields[6].Name = "headless"
	TemplateDoc.Fields[6].Type = "[]headless.Request"
	TemplateDoc.Fields[6].Note = ""
	TemplateDoc.Fields[6].Description = "Headless contains the headless request to make in the template."
	TemplateDoc.Fields[6].Comments[encoder.LineComment] = "Headless contains the headless request to make in the template."
	TemplateDoc.Fields[7].Name = "ssl"
	TemplateDoc.Fields[7].Type = "[]ssl.Request"
	TemplateDoc.Fields[7].Note = ""
	TemplateDoc.Fields[7].Description = "SSL contains the SSL request to make in the template."
	TemplateDoc.Fields[7].Comments[encoder.LineComment] = "SSL contains the SSL request to make in the template."
	TemplateDoc.Fields[8].Name = "websocket"
	TemplateDoc.Fields[8].Type = "[]websocket.Request"
	TemplateDoc.Fields[8].Note = ""
	TemplateDoc.Fields[8].Description = "Websocket contains the Websocket request to make in the template."
	TemplateDoc.Fields[8].Comments[encoder.LineComment] = "Websocket contains the Websocket request to make in the template."
	TemplateDoc.Fields[9].Name = "whois"
	TemplateDoc.Fields[9].Type = "[]whois.Request"
	TemplateDoc.Fields[9].Note = ""
	TemplateDoc.Fields[9].Description = "WHOIS contains the WHOIS request to make in the template."
	TemplateDoc.Fields[9].Comments[encoder.LineComment] = "WHOIS contains the WHOIS request to make in the template."
	TemplateDoc.Fields[10].Name = "workflows"
	TemplateDoc.Fields[10].Type = "[]workflows.WorkflowTemplate"
	TemplateDoc.Fields[10].Note = ""
	TemplateDoc.Fields[10].Description = "Workflows is a list of workflows to execute for a template."
	TemplateDoc.Fields[10].Comments[encoder.LineComment] = "Workflows is a list of workflows to execute for a template."
	TemplateDoc.Fields[11].Name = "self-contained"
	TemplateDoc.Fields[11].Type = "bool"
	TemplateDoc.Fields[11].Note = ""
	TemplateDoc.Fields[11].Description = "Self Contained marks Requests for the template as self-contained"
	TemplateDoc.Fields[11].Comments[encoder.LineComment] = "Self Contained marks Requests for the template as self-contained"
	TemplateDoc.Fields[12].Name = "stop-at-first-match"
	TemplateDoc.Fields[12].Type = "bool"
	TemplateDoc.Fields[12].Note = ""
	TemplateDoc.Fields[12].Description = "Stop execution once first match is found"
	TemplateDoc.Fields[12].Comments[encoder.LineComment] = "Stop execution once first match is found"
	TemplateDoc.Fields[13].Name = "signature"
	TemplateDoc.Fields[13].Type = "http.SignatureTypeHolder"
	TemplateDoc.Fields[13].Note = ""
	TemplateDoc.Fields[13].Description = "Signature is the request signature method"
	TemplateDoc.Fields[13].Comments[encoder.LineComment] = "Signature is the request signature method"
	TemplateDoc.Fields[13].Values = []string{
		"AWS",
	}
	TemplateDoc.Fields[14].Name = "variables"
	TemplateDoc.Fields[14].Type = "variables.Variable"
	TemplateDoc.Fields[14].Note = ""
	TemplateDoc.Fields[14].Description = "Variables contains any variables for the current request."
	TemplateDoc.Fields[14].Comments[encoder.LineComment] = "Variables contains any variables for the current request."

	MODELInfoDoc.Type = "model.Info"
	MODELInfoDoc.Comments[encoder.LineComment] = " Info contains metadata information about a template"
	MODELInfoDoc.Description = "Info contains metadata information about a template"

	MODELInfoDoc.AddExample("", exampleInfoStructure)
	MODELInfoDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "info",
		},
	}
	MODELInfoDoc.Fields = make([]encoder.Doc, 9)
	MODELInfoDoc.Fields[0].Name = "name"
	MODELInfoDoc.Fields[0].Type = "string"
	MODELInfoDoc.Fields[0].Note = ""
	MODELInfoDoc.Fields[0].Description = "Name should be good short summary that identifies what the template does."
	MODELInfoDoc.Fields[0].Comments[encoder.LineComment] = "Name should be good short summary that identifies what the template does."

	MODELInfoDoc.Fields[0].AddExample("", "bower.json file disclosure")

	MODELInfoDoc.Fields[0].AddExample("", "Nagios Default Credentials Check")
	MODELInfoDoc.Fields[1].Name = "author"
	MODELInfoDoc.Fields[1].Type = "stringslice.StringSlice"
	MODELInfoDoc.Fields[1].Note = ""
	MODELInfoDoc.Fields[1].Description = "Author of the template.\n\nMultiple values can also be specified separated by commas."
	MODELInfoDoc.Fields[1].Comments[encoder.LineComment] = "Author of the template."

	MODELInfoDoc.Fields[1].AddExample("", "<username>")
	MODELInfoDoc.Fields[2].Name = "tags"
	MODELInfoDoc.Fields[2].Type = "stringslice.StringSlice"
	MODELInfoDoc.Fields[2].Note = ""
	MODELInfoDoc.Fields[2].Description = "Any tags for the template.\n\nMultiple values can also be specified separated by commas."
	MODELInfoDoc.Fields[2].Comments[encoder.LineComment] = "Any tags for the template."

	MODELInfoDoc.Fields[2].AddExample("Example tags", "cve,cve2019,grafana,auth-bypass,dos")
	MODELInfoDoc.Fields[3].Name = "description"
	MODELInfoDoc.Fields[3].Type = "string"
	MODELInfoDoc.Fields[3].Note = ""
	MODELInfoDoc.Fields[3].Description = "Description of the template.\n\nYou can go in-depth here on what the template actually does."
	MODELInfoDoc.Fields[3].Comments[encoder.LineComment] = "Description of the template."

	MODELInfoDoc.Fields[3].AddExample("", "Bower is a package manager which stores package information in the bower.json file")

	MODELInfoDoc.Fields[3].AddExample("", "Subversion ALM for the enterprise before 8.8.2 allows reflected XSS at multiple locations")
	MODELInfoDoc.Fields[4].Name = "reference"
	MODELInfoDoc.Fields[4].Type = "stringslice.StringSlice"
	MODELInfoDoc.Fields[4].Note = ""
	MODELInfoDoc.Fields[4].Description = "References for the template.\n\nThis should contain links relevant to the template."
	MODELInfoDoc.Fields[4].Comments[encoder.LineComment] = "References for the template."

	MODELInfoDoc.Fields[4].AddExample("", []string{"https://github.com/strapi/strapi", "https://github.com/getgrav/grav"})
	MODELInfoDoc.Fields[5].Name = "severity"
	MODELInfoDoc.Fields[5].Type = "severity.Holder"
	MODELInfoDoc.Fields[5].Note = ""
	MODELInfoDoc.Fields[5].Description = "Severity of the template."
	MODELInfoDoc.Fields[5].Comments[encoder.LineComment] = "Severity of the template."
	MODELInfoDoc.Fields[6].Name = "metadata"
	MODELInfoDoc.Fields[6].Type = "map[string]interface{}"
	MODELInfoDoc.Fields[6].Note = ""
	MODELInfoDoc.Fields[6].Description = "Metadata of the template."
	MODELInfoDoc.Fields[6].Comments[encoder.LineComment] = "Metadata of the template."

	MODELInfoDoc.Fields[6].AddExample("", map[string]string{"customField1": "customValue1"})
	MODELInfoDoc.Fields[7].Name = "classification"
	MODELInfoDoc.Fields[7].Type = "model.Classification"
	MODELInfoDoc.Fields[7].Note = ""
	MODELInfoDoc.Fields[7].Description = "Classification contains classification information about the template."
	MODELInfoDoc.Fields[7].Comments[encoder.LineComment] = "Classification contains classification information about the template."
	MODELInfoDoc.Fields[8].Name = "remediation"
	MODELInfoDoc.Fields[8].Type = "string"
	MODELInfoDoc.Fields[8].Note = ""
	MODELInfoDoc.Fields[8].Description = "Remediation steps for the template.\n\nYou can go in-depth here on how to mitigate the problem found by this template."
	MODELInfoDoc.Fields[8].Comments[encoder.LineComment] = "Remediation steps for the template."

	MODELInfoDoc.Fields[8].AddExample("", "Change the default administrative username and password of Apache ActiveMQ by editing the file jetty-realm.properties")

	STRINGSLICEStringSliceDoc.Type = "stringslice.StringSlice"
	STRINGSLICEStringSliceDoc.Comments[encoder.LineComment] = " StringSlice represents a single (in-lined) or multiple string value(s)."
	STRINGSLICEStringSliceDoc.Description = "StringSlice represents a single (in-lined) or multiple string value(s).\n The unmarshaller does not automatically convert in-lined strings to []string, hence the interface{} type is required."

	STRINGSLICEStringSliceDoc.AddExample("", "<username>")

	STRINGSLICEStringSliceDoc.AddExample("Example tags", "cve,cve2019,grafana,auth-bypass,dos")

	STRINGSLICEStringSliceDoc.AddExample("", []string{"https://github.com/strapi/strapi", "https://github.com/getgrav/grav"})

	STRINGSLICEStringSliceDoc.AddExample("", "CVE-2020-14420")

	STRINGSLICEStringSliceDoc.AddExample("", "CWE-22")
	STRINGSLICEStringSliceDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "model.Info",
			FieldName: "author",
		},
		{
			TypeName:  "model.Info",
			FieldName: "tags",
		},
		{
			TypeName:  "model.Info",
			FieldName: "reference",
		},
		{
			TypeName:  "model.Classification",
			FieldName: "cve-id",
		},
		{
			TypeName:  "model.Classification",
			FieldName: "cwe-id",
		},
		{
			TypeName:  "workflows.WorkflowTemplate",
			FieldName: "tags",
		},
		{
			TypeName:  "workflows.Matcher",
			FieldName: "name",
		},
	}
	STRINGSLICEStringSliceDoc.Fields = make([]encoder.Doc, 0)

	SEVERITYHolderDoc.Type = "severity.Holder"
	SEVERITYHolderDoc.Comments[encoder.LineComment] = " Holder holds a Severity type. Required for un/marshalling purposes"
	SEVERITYHolderDoc.Description = "Holder holds a Severity type. Required for un/marshalling purposes"
	SEVERITYHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "model.Info",
			FieldName: "severity",
		},
	}
	SEVERITYHolderDoc.Fields = make([]encoder.Doc, 1)
	SEVERITYHolderDoc.Fields[0].Name = ""
	SEVERITYHolderDoc.Fields[0].Type = "Severity"
	SEVERITYHolderDoc.Fields[0].Note = ""
	SEVERITYHolderDoc.Fields[0].Description = ""
	SEVERITYHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	SEVERITYHolderDoc.Fields[0].EnumFields = []string{
		"undefined",
		"info",
		"low",
		"medium",
		"high",
		"critical",
		"unknown",
	}

	MODELClassificationDoc.Type = "model.Classification"
	MODELClassificationDoc.Comments[encoder.LineComment] = ""
	MODELClassificationDoc.Description = ""
	MODELClassificationDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "model.Info",
			FieldName: "classification",
		},
	}
	MODELClassificationDoc.Fields = make([]encoder.Doc, 4)
	MODELClassificationDoc.Fields[0].Name = "cve-id"
	MODELClassificationDoc.Fields[0].Type = "stringslice.StringSlice"
	MODELClassificationDoc.Fields[0].Note = ""
	MODELClassificationDoc.Fields[0].Description = "CVE ID for the template"
	MODELClassificationDoc.Fields[0].Comments[encoder.LineComment] = "CVE ID for the template"

	MODELClassificationDoc.Fields[0].AddExample("", "CVE-2020-14420")
	MODELClassificationDoc.Fields[1].Name = "cwe-id"
	MODELClassificationDoc.Fields[1].Type = "stringslice.StringSlice"
	MODELClassificationDoc.Fields[1].Note = ""
	MODELClassificationDoc.Fields[1].Description = "CWE ID for the template."
	MODELClassificationDoc.Fields[1].Comments[encoder.LineComment] = "CWE ID for the template."

	MODELClassificationDoc.Fields[1].AddExample("", "CWE-22")
	MODELClassificationDoc.Fields[2].Name = "cvss-metrics"
	MODELClassificationDoc.Fields[2].Type = "string"
	MODELClassificationDoc.Fields[2].Note = ""
	MODELClassificationDoc.Fields[2].Description = "CVSS Metrics for the template."
	MODELClassificationDoc.Fields[2].Comments[encoder.LineComment] = "CVSS Metrics for the template."

	MODELClassificationDoc.Fields[2].AddExample("", "3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H")
	MODELClassificationDoc.Fields[3].Name = "cvss-score"
	MODELClassificationDoc.Fields[3].Type = "float64"
	MODELClassificationDoc.Fields[3].Note = ""
	MODELClassificationDoc.Fields[3].Description = "CVSS Score for the template."
	MODELClassificationDoc.Fields[3].Comments[encoder.LineComment] = "CVSS Score for the template."

	MODELClassificationDoc.Fields[3].AddExample("", "9.8")

	HTTPRequestDoc.Type = "http.Request"
	HTTPRequestDoc.Comments[encoder.LineComment] = " Request contains a http request to be made from a template"
	HTTPRequestDoc.Description = "Request contains a http request to be made from a template"

	HTTPRequestDoc.AddExample("", exampleNormalHTTPRequest)
	HTTPRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "requests",
		},
	}
	HTTPRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "request",
			Value: "HTTP request made from the client",
		},
		{
			Key:   "response",
			Value: "HTTP response received from server",
		},
		{
			Key:   "status_code",
			Value: "Status Code received from the Server",
		},
		{
			Key:   "body",
			Value: "HTTP response body received from server (default)",
		},
		{
			Key:   "content_length",
			Value: "HTTP Response content length",
		},
		{
			Key:   "header,all_headers",
			Value: "HTTP response headers",
		},
		{
			Key:   "duration",
			Value: "HTTP request time duration",
		},
		{
			Key:   "all",
			Value: "HTTP response body + headers",
		},
		{
			Key:   "cookies_from_response",
			Value: "HTTP response cookies in name:value format",
		},
		{
			Key:   "headers_from_response",
			Value: "HTTP response headers in name:value format",
		},
	}
	HTTPRequestDoc.Fields = make([]encoder.Doc, 32)
	HTTPRequestDoc.Fields[0].Name = "matchers"
	HTTPRequestDoc.Fields[0].Type = "[]matchers.Matcher"
	HTTPRequestDoc.Fields[0].Note = ""
	HTTPRequestDoc.Fields[0].Description = "Matchers contains the detection mechanism for the request to identify\nwhether the request was successful by doing pattern matching\non request/responses.\n\nMultiple matchers can be combined with `matcher-condition` flag\nwhich accepts either `and` or `or` as argument."
	HTTPRequestDoc.Fields[0].Comments[encoder.LineComment] = "Matchers contains the detection mechanism for the request to identify"
	HTTPRequestDoc.Fields[1].Name = "extractors"
	HTTPRequestDoc.Fields[1].Type = "[]extractors.Extractor"
	HTTPRequestDoc.Fields[1].Note = ""
	HTTPRequestDoc.Fields[1].Description = "Extractors contains the extraction mechanism for the request to identify\nand extract parts of the response."
	HTTPRequestDoc.Fields[1].Comments[encoder.LineComment] = "Extractors contains the extraction mechanism for the request to identify"
	HTTPRequestDoc.Fields[2].Name = "matchers-condition"
	HTTPRequestDoc.Fields[2].Type = "string"
	HTTPRequestDoc.Fields[2].Note = ""
	HTTPRequestDoc.Fields[2].Description = "MatchersCondition is the condition between the matchers. Default is OR."
	HTTPRequestDoc.Fields[2].Comments[encoder.LineComment] = "MatchersCondition is the condition between the matchers. Default is OR."
	HTTPRequestDoc.Fields[2].Values = []string{
		"and",
		"or",
	}
	HTTPRequestDoc.Fields[3].Name = "path"
	HTTPRequestDoc.Fields[3].Type = "[]string"
	HTTPRequestDoc.Fields[3].Note = ""
	HTTPRequestDoc.Fields[3].Description = "Path contains the path/s for the HTTP requests. It supports variables\nas placeholders."
	HTTPRequestDoc.Fields[3].Comments[encoder.LineComment] = "Path contains the path/s for the HTTP requests. It supports variables"

	HTTPRequestDoc.Fields[3].AddExample("Some example path values", []string{"{{BaseURL}}", "{{BaseURL}}/+CSCOU+/../+CSCOE+/files/file_list.json?path=/sessions"})
	HTTPRequestDoc.Fields[4].Name = "raw"
	HTTPRequestDoc.Fields[4].Type = "[]string"
	HTTPRequestDoc.Fields[4].Note = ""
	HTTPRequestDoc.Fields[4].Description = "Raw contains HTTP Requests in Raw format."
	HTTPRequestDoc.Fields[4].Comments[encoder.LineComment] = "Raw contains HTTP Requests in Raw format."

	HTTPRequestDoc.Fields[4].AddExample("Some example raw requests", []string{"GET /etc/passwd HTTP/1.1\nHost:\nContent-Length: 4", "POST /.%0d./.%0d./.%0d./.%0d./bin/sh HTTP/1.1\nHost: {{Hostname}}\nUser-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0\nContent-Length: 1\nConnection: close\n\necho\necho\ncat /etc/passwd 2>&1"})
	HTTPRequestDoc.Fields[5].Name = "id"
	HTTPRequestDoc.Fields[5].Type = "string"
	HTTPRequestDoc.Fields[5].Note = ""
	HTTPRequestDoc.Fields[5].Description = "ID is the optional id of the request"
	HTTPRequestDoc.Fields[5].Comments[encoder.LineComment] = " ID is the optional id of the request"
	HTTPRequestDoc.Fields[6].Name = "name"
	HTTPRequestDoc.Fields[6].Type = "string"
	HTTPRequestDoc.Fields[6].Note = ""
	HTTPRequestDoc.Fields[6].Description = "Name is the optional name of the request.\n\nIf a name is specified, all the named request in a template can be matched upon\nin a combined manner allowing multi-request based matchers."
	HTTPRequestDoc.Fields[6].Comments[encoder.LineComment] = "Name is the optional name of the request."
	HTTPRequestDoc.Fields[7].Name = "attack"
	HTTPRequestDoc.Fields[7].Type = "generators.AttackTypeHolder"
	HTTPRequestDoc.Fields[7].Note = ""
	HTTPRequestDoc.Fields[7].Description = "Attack is the type of payload combinations to perform.\n\nbatteringram is inserts the same payload into all defined payload positions at once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	HTTPRequestDoc.Fields[7].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	HTTPRequestDoc.Fields[7].Values = []string{
		"batteringram",
		"pitchfork",
		"clusterbomb",
	}
	HTTPRequestDoc.Fields[8].Name = "method"
	HTTPRequestDoc.Fields[8].Type = "HTTPMethodTypeHolder"
	HTTPRequestDoc.Fields[8].Note = ""
	HTTPRequestDoc.Fields[8].Description = "Method is the HTTP Request Method."
	HTTPRequestDoc.Fields[8].Comments[encoder.LineComment] = "Method is the HTTP Request Method."
	HTTPRequestDoc.Fields[9].Name = "body"
	HTTPRequestDoc.Fields[9].Type = "string"
	HTTPRequestDoc.Fields[9].Note = ""
	HTTPRequestDoc.Fields[9].Description = "Body is an optional parameter which contains HTTP Request body."
	HTTPRequestDoc.Fields[9].Comments[encoder.LineComment] = "Body is an optional parameter which contains HTTP Request body."

	HTTPRequestDoc.Fields[9].AddExample("Same Body for a Login POST request", "username=test&password=test")
	HTTPRequestDoc.Fields[10].Name = "payloads"
	HTTPRequestDoc.Fields[10].Type = "map[string]interface{}"
	HTTPRequestDoc.Fields[10].Note = ""
	HTTPRequestDoc.Fields[10].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	HTTPRequestDoc.Fields[10].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."
	HTTPRequestDoc.Fields[11].Name = "headers"
	HTTPRequestDoc.Fields[11].Type = "map[string]string"
	HTTPRequestDoc.Fields[11].Note = ""
	HTTPRequestDoc.Fields[11].Description = "Headers contains HTTP Headers to send with the request."
	HTTPRequestDoc.Fields[11].Comments[encoder.LineComment] = "Headers contains HTTP Headers to send with the request."

	HTTPRequestDoc.Fields[11].AddExample("", map[string]string{"Content-Type": "application/x-www-form-urlencoded", "Content-Length": "1", "Any-Header": "Any-Value"})
	HTTPRequestDoc.Fields[12].Name = "race_count"
	HTTPRequestDoc.Fields[12].Type = "int"
	HTTPRequestDoc.Fields[12].Note = ""
	HTTPRequestDoc.Fields[12].Description = "RaceCount is the number of times to send a request in Race Condition Attack."
	HTTPRequestDoc.Fields[12].Comments[encoder.LineComment] = "RaceCount is the number of times to send a request in Race Condition Attack."

	HTTPRequestDoc.Fields[12].AddExample("Send a request 5 times", 5)
	HTTPRequestDoc.Fields[13].Name = "max-redirects"
	HTTPRequestDoc.Fields[13].Type = "int"
	HTTPRequestDoc.Fields[13].Note = ""
	HTTPRequestDoc.Fields[13].Description = "MaxRedirects is the maximum number of redirects that should be followed."
	HTTPRequestDoc.Fields[13].Comments[encoder.LineComment] = "MaxRedirects is the maximum number of redirects that should be followed."

	HTTPRequestDoc.Fields[13].AddExample("Follow up to 5 redirects", 5)
	HTTPRequestDoc.Fields[14].Name = "pipeline-concurrent-connections"
	HTTPRequestDoc.Fields[14].Type = "int"
	HTTPRequestDoc.Fields[14].Note = ""
	HTTPRequestDoc.Fields[14].Description = "PipelineConcurrentConnections is number of connections to create during pipelining."
	HTTPRequestDoc.Fields[14].Comments[encoder.LineComment] = "PipelineConcurrentConnections is number of connections to create during pipelining."

	HTTPRequestDoc.Fields[14].AddExample("Create 40 concurrent connections", 40)
	HTTPRequestDoc.Fields[15].Name = "pipeline-requests-per-connection"
	HTTPRequestDoc.Fields[15].Type = "int"
	HTTPRequestDoc.Fields[15].Note = ""
	HTTPRequestDoc.Fields[15].Description = "PipelineRequestsPerConnection is number of requests to send per connection when pipelining."
	HTTPRequestDoc.Fields[15].Comments[encoder.LineComment] = "PipelineRequestsPerConnection is number of requests to send per connection when pipelining."

	HTTPRequestDoc.Fields[15].AddExample("Send 100 requests per pipeline connection", 100)
	HTTPRequestDoc.Fields[16].Name = "threads"
	HTTPRequestDoc.Fields[16].Type = "int"
	HTTPRequestDoc.Fields[16].Note = ""
	HTTPRequestDoc.Fields[16].Description = "Threads specifies number of threads to use sending requests. This enables Connection Pooling.\n\nConnection: Close attribute must not be used in request while using threads flag, otherwise\npooling will fail and engine will continue to close connections after requests."
	HTTPRequestDoc.Fields[16].Comments[encoder.LineComment] = "Threads specifies number of threads to use sending requests. This enables Connection Pooling."

	HTTPRequestDoc.Fields[16].AddExample("Send requests using 10 concurrent threads", 10)
	HTTPRequestDoc.Fields[17].Name = "max-size"
	HTTPRequestDoc.Fields[17].Type = "int"
	HTTPRequestDoc.Fields[17].Note = ""
	HTTPRequestDoc.Fields[17].Description = "MaxSize is the maximum size of http response body to read in bytes."
	HTTPRequestDoc.Fields[17].Comments[encoder.LineComment] = "MaxSize is the maximum size of http response body to read in bytes."

	HTTPRequestDoc.Fields[17].AddExample("Read max 2048 bytes of the response", 2048)
	HTTPRequestDoc.Fields[18].Name = "signature"
	HTTPRequestDoc.Fields[18].Type = "SignatureTypeHolder"
	HTTPRequestDoc.Fields[18].Note = ""
	HTTPRequestDoc.Fields[18].Description = "Signature is the request signature method"
	HTTPRequestDoc.Fields[18].Comments[encoder.LineComment] = "Signature is the request signature method"
	HTTPRequestDoc.Fields[18].Values = []string{
		"AWS",
	}
	HTTPRequestDoc.Fields[19].Name = "cookie-reuse"
	HTTPRequestDoc.Fields[19].Type = "bool"
	HTTPRequestDoc.Fields[19].Note = ""
	HTTPRequestDoc.Fields[19].Description = "CookieReuse is an optional setting that enables cookie reuse for\nall requests defined in raw section."
	HTTPRequestDoc.Fields[19].Comments[encoder.LineComment] = "CookieReuse is an optional setting that enables cookie reuse for"
	HTTPRequestDoc.Fields[20].Name = "read-all"
	HTTPRequestDoc.Fields[20].Type = "bool"
	HTTPRequestDoc.Fields[20].Note = ""
	HTTPRequestDoc.Fields[20].Description = "Enables force reading of the entire raw unsafe request body ignoring\nany specified content length headers."
	HTTPRequestDoc.Fields[20].Comments[encoder.LineComment] = "Enables force reading of the entire raw unsafe request body ignoring"
	HTTPRequestDoc.Fields[21].Name = "redirects"
	HTTPRequestDoc.Fields[21].Type = "bool"
	HTTPRequestDoc.Fields[21].Note = ""
	HTTPRequestDoc.Fields[21].Description = "Redirects specifies whether redirects should be followed by the HTTP Client.\n\nThis can be used in conjunction with `max-redirects` to control the HTTP request redirects."
	HTTPRequestDoc.Fields[21].Comments[encoder.LineComment] = "Redirects specifies whether redirects should be followed by the HTTP Client."
	HTTPRequestDoc.Fields[22].Name = "host-redirects"
	HTTPRequestDoc.Fields[22].Type = "bool"
	HTTPRequestDoc.Fields[22].Note = ""
	HTTPRequestDoc.Fields[22].Description = "Redirects specifies whether only redirects to the same host should be followed by the HTTP Client.\n\nThis can be used in conjunction with `max-redirects` to control the HTTP request redirects."
	HTTPRequestDoc.Fields[22].Comments[encoder.LineComment] = "Redirects specifies whether only redirects to the same host should be followed by the HTTP Client."
	HTTPRequestDoc.Fields[23].Name = "pipeline"
	HTTPRequestDoc.Fields[23].Type = "bool"
	HTTPRequestDoc.Fields[23].Note = ""
	HTTPRequestDoc.Fields[23].Description = "Pipeline defines if the attack should be performed with HTTP 1.1 Pipelining\n\nAll requests must be idempotent (GET/POST). This can be used for race conditions/billions requests."
	HTTPRequestDoc.Fields[23].Comments[encoder.LineComment] = "Pipeline defines if the attack should be performed with HTTP 1.1 Pipelining"
	HTTPRequestDoc.Fields[24].Name = "unsafe"
	HTTPRequestDoc.Fields[24].Type = "bool"
	HTTPRequestDoc.Fields[24].Note = ""
	HTTPRequestDoc.Fields[24].Description = "Unsafe specifies whether to use rawhttp engine for sending Non RFC-Compliant requests.\n\nThis uses the [rawhttp](https://github.com/projectdiscovery/rawhttp) engine to achieve complete\ncontrol over the request, with no normalization performed by the client."
	HTTPRequestDoc.Fields[24].Comments[encoder.LineComment] = "Unsafe specifies whether to use rawhttp engine for sending Non RFC-Compliant requests."
	HTTPRequestDoc.Fields[25].Name = "race"
	HTTPRequestDoc.Fields[25].Type = "bool"
	HTTPRequestDoc.Fields[25].Note = ""
	HTTPRequestDoc.Fields[25].Description = "Race determines if all the request have to be attempted at the same time (Race Condition)\n\nThe actual number of requests that will be sent is determined by the `race_count`  field."
	HTTPRequestDoc.Fields[25].Comments[encoder.LineComment] = "Race determines if all the request have to be attempted at the same time (Race Condition)"
	HTTPRequestDoc.Fields[26].Name = "req-condition"
	HTTPRequestDoc.Fields[26].Type = "bool"
	HTTPRequestDoc.Fields[26].Note = ""
	HTTPRequestDoc.Fields[26].Description = "ReqCondition automatically assigns numbers to requests and preserves their history.\n\nThis allows matching on them later for multi-request conditions."
	HTTPRequestDoc.Fields[26].Comments[encoder.LineComment] = "ReqCondition automatically assigns numbers to requests and preserves their history."
	HTTPRequestDoc.Fields[27].Name = "stop-at-first-match"
	HTTPRequestDoc.Fields[27].Type = "bool"
	HTTPRequestDoc.Fields[27].Note = ""
	HTTPRequestDoc.Fields[27].Description = "StopAtFirstMatch stops the execution of the requests and template as soon as a match is found."
	HTTPRequestDoc.Fields[27].Comments[encoder.LineComment] = "StopAtFirstMatch stops the execution of the requests and template as soon as a match is found."
	HTTPRequestDoc.Fields[28].Name = "skip-variables-check"
	HTTPRequestDoc.Fields[28].Type = "bool"
	HTTPRequestDoc.Fields[28].Note = ""
	HTTPRequestDoc.Fields[28].Description = "SkipVariablesCheck skips the check for unresolved variables in request"
	HTTPRequestDoc.Fields[28].Comments[encoder.LineComment] = "SkipVariablesCheck skips the check for unresolved variables in request"
	HTTPRequestDoc.Fields[29].Name = "iterate-all"
	HTTPRequestDoc.Fields[29].Type = "bool"
	HTTPRequestDoc.Fields[29].Note = ""
	HTTPRequestDoc.Fields[29].Description = "IterateAll iterates all the values extracted from internal extractors"
	HTTPRequestDoc.Fields[29].Comments[encoder.LineComment] = "IterateAll iterates all the values extracted from internal extractors"
	HTTPRequestDoc.Fields[30].Name = "digest-username"
	HTTPRequestDoc.Fields[30].Type = "string"
	HTTPRequestDoc.Fields[30].Note = ""
	HTTPRequestDoc.Fields[30].Description = "DigestAuthUsername specifies the username for digest authentication"
	HTTPRequestDoc.Fields[30].Comments[encoder.LineComment] = "DigestAuthUsername specifies the username for digest authentication"
	HTTPRequestDoc.Fields[31].Name = "digest-password"
	HTTPRequestDoc.Fields[31].Type = "string"
	HTTPRequestDoc.Fields[31].Note = ""
	HTTPRequestDoc.Fields[31].Description = "DigestAuthPassword specifies the password for digest authentication"
	HTTPRequestDoc.Fields[31].Comments[encoder.LineComment] = "DigestAuthPassword specifies the password for digest authentication"

	MATCHERSMatcherDoc.Type = "matchers.Matcher"
	MATCHERSMatcherDoc.Comments[encoder.LineComment] = " Matcher is used to match a part in the output from a protocol."
	MATCHERSMatcherDoc.Description = "Matcher is used to match a part in the output from a protocol."
	MATCHERSMatcherDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "matchers",
		},
		{
			TypeName:  "dns.Request",
			FieldName: "matchers",
		},
		{
			TypeName:  "file.Request",
			FieldName: "matchers",
		},
		{
			TypeName:  "network.Request",
			FieldName: "matchers",
		},
		{
			TypeName:  "headless.Request",
			FieldName: "matchers",
		},
		{
			TypeName:  "ssl.Request",
			FieldName: "matchers",
		},
		{
			TypeName:  "websocket.Request",
			FieldName: "matchers",
		},
		{
			TypeName:  "whois.Request",
			FieldName: "matchers",
		},
	}
	MATCHERSMatcherDoc.Fields = make([]encoder.Doc, 14)
	MATCHERSMatcherDoc.Fields[0].Name = "type"
	MATCHERSMatcherDoc.Fields[0].Type = "MatcherTypeHolder"
	MATCHERSMatcherDoc.Fields[0].Note = ""
	MATCHERSMatcherDoc.Fields[0].Description = "Type is the type of the matcher."
	MATCHERSMatcherDoc.Fields[0].Comments[encoder.LineComment] = "Type is the type of the matcher."
	MATCHERSMatcherDoc.Fields[1].Name = "condition"
	MATCHERSMatcherDoc.Fields[1].Type = "string"
	MATCHERSMatcherDoc.Fields[1].Note = ""
	MATCHERSMatcherDoc.Fields[1].Description = "Condition is the optional condition between two matcher variables. By default,\nthe condition is assumed to be OR."
	MATCHERSMatcherDoc.Fields[1].Comments[encoder.LineComment] = "Condition is the optional condition between two matcher variables. By default,"
	MATCHERSMatcherDoc.Fields[1].Values = []string{
		"and",
		"or",
	}
	MATCHERSMatcherDoc.Fields[2].Name = "part"
	MATCHERSMatcherDoc.Fields[2].Type = "string"
	MATCHERSMatcherDoc.Fields[2].Note = ""
	MATCHERSMatcherDoc.Fields[2].Description = "Part is the part of the request response to match data from.\n\nEach protocol exposes a lot of different parts which are well\ndocumented in docs for each request type."
	MATCHERSMatcherDoc.Fields[2].Comments[encoder.LineComment] = "Part is the part of the request response to match data from."

	MATCHERSMatcherDoc.Fields[2].AddExample("", "body")

	MATCHERSMatcherDoc.Fields[2].AddExample("", "raw")
	MATCHERSMatcherDoc.Fields[3].Name = "negative"
	MATCHERSMatcherDoc.Fields[3].Type = "bool"
	MATCHERSMatcherDoc.Fields[3].Note = ""
	MATCHERSMatcherDoc.Fields[3].Description = "Negative specifies if the match should be reversed\nIt will only match if the condition is not true."
	MATCHERSMatcherDoc.Fields[3].Comments[encoder.LineComment] = "Negative specifies if the match should be reversed"
	MATCHERSMatcherDoc.Fields[4].Name = "name"
	MATCHERSMatcherDoc.Fields[4].Type = "string"
	MATCHERSMatcherDoc.Fields[4].Note = ""
	MATCHERSMatcherDoc.Fields[4].Description = "Name of the matcher. Name should be lowercase and must not contain\nspaces or underscores (_)."
	MATCHERSMatcherDoc.Fields[4].Comments[encoder.LineComment] = "Name of the matcher. Name should be lowercase and must not contain"

	MATCHERSMatcherDoc.Fields[4].AddExample("", "cookie-matcher")
	MATCHERSMatcherDoc.Fields[5].Name = "status"
	MATCHERSMatcherDoc.Fields[5].Type = "[]int"
	MATCHERSMatcherDoc.Fields[5].Note = ""
	MATCHERSMatcherDoc.Fields[5].Description = "Status are the acceptable status codes for the response."
	MATCHERSMatcherDoc.Fields[5].Comments[encoder.LineComment] = "Status are the acceptable status codes for the response."

	MATCHERSMatcherDoc.Fields[5].AddExample("", []int{200, 302})
	MATCHERSMatcherDoc.Fields[6].Name = "size"
	MATCHERSMatcherDoc.Fields[6].Type = "[]int"
	MATCHERSMatcherDoc.Fields[6].Note = ""
	MATCHERSMatcherDoc.Fields[6].Description = "Size is the acceptable size for the response"
	MATCHERSMatcherDoc.Fields[6].Comments[encoder.LineComment] = "Size is the acceptable size for the response"

	MATCHERSMatcherDoc.Fields[6].AddExample("", []int{3029, 2042})
	MATCHERSMatcherDoc.Fields[7].Name = "words"
	MATCHERSMatcherDoc.Fields[7].Type = "[]string"
	MATCHERSMatcherDoc.Fields[7].Note = ""
	MATCHERSMatcherDoc.Fields[7].Description = "Words contains word patterns required to be present in the response part."
	MATCHERSMatcherDoc.Fields[7].Comments[encoder.LineComment] = "Words contains word patterns required to be present in the response part."

	MATCHERSMatcherDoc.Fields[7].AddExample("Match for Outlook mail protection domain", []string{"mail.protection.outlook.com"})

	MATCHERSMatcherDoc.Fields[7].AddExample("Match for application/json in response headers", []string{"application/json"})
	MATCHERSMatcherDoc.Fields[8].Name = "regex"
	MATCHERSMatcherDoc.Fields[8].Type = "[]string"
	MATCHERSMatcherDoc.Fields[8].Note = ""
	MATCHERSMatcherDoc.Fields[8].Description = "Regex contains Regular Expression patterns required to be present in the response part."
	MATCHERSMatcherDoc.Fields[8].Comments[encoder.LineComment] = "Regex contains Regular Expression patterns required to be present in the response part."

	MATCHERSMatcherDoc.Fields[8].AddExample("Match for Linkerd Service via Regex", []string{`(?mi)^Via\\s*?:.*?linkerd.*$`})

	MATCHERSMatcherDoc.Fields[8].AddExample("Match for Open Redirect via Location header", []string{`(?m)^(?:Location\\s*?:\\s*?)(?:https?://|//)?(?:[a-zA-Z0-9\\-_\\.@]*)example\\.com.*$`})
	MATCHERSMatcherDoc.Fields[9].Name = "binary"
	MATCHERSMatcherDoc.Fields[9].Type = "[]string"
	MATCHERSMatcherDoc.Fields[9].Note = ""
	MATCHERSMatcherDoc.Fields[9].Description = "Binary are the binary patterns required to be present in the response part."
	MATCHERSMatcherDoc.Fields[9].Comments[encoder.LineComment] = "Binary are the binary patterns required to be present in the response part."

	MATCHERSMatcherDoc.Fields[9].AddExample("Match for Springboot Heapdump Actuator \"JAVA PROFILE\", \"HPROF\", \"Gunzip magic byte\"", []string{"4a4156412050524f46494c45", "4850524f46", "1f8b080000000000"})

	MATCHERSMatcherDoc.Fields[9].AddExample("Match for 7zip files", []string{"377ABCAF271C"})
	MATCHERSMatcherDoc.Fields[10].Name = "dsl"
	MATCHERSMatcherDoc.Fields[10].Type = "[]string"
	MATCHERSMatcherDoc.Fields[10].Note = ""
	MATCHERSMatcherDoc.Fields[10].Description = "DSL are the dsl expressions that will be evaluated as part of nuclei matching rules.\nA list of these helper functions are available [here](https://nuclei.projectdiscovery.io/templating-guide/helper-functions/)."
	MATCHERSMatcherDoc.Fields[10].Comments[encoder.LineComment] = "DSL are the dsl expressions that will be evaluated as part of nuclei matching rules."

	MATCHERSMatcherDoc.Fields[10].AddExample("DSL Matcher for package.json file", []string{"contains(body, 'packages') && contains(tolower(all_headers), 'application/octet-stream') && status_code == 200"})

	MATCHERSMatcherDoc.Fields[10].AddExample("DSL Matcher for missing strict transport security header", []string{"!contains(tolower(all_headers), ''strict-transport-security'')"})
	MATCHERSMatcherDoc.Fields[11].Name = "encoding"
	MATCHERSMatcherDoc.Fields[11].Type = "string"
	MATCHERSMatcherDoc.Fields[11].Note = ""
	MATCHERSMatcherDoc.Fields[11].Description = "Encoding specifies the encoding for the words field if any."
	MATCHERSMatcherDoc.Fields[11].Comments[encoder.LineComment] = "Encoding specifies the encoding for the words field if any."
	MATCHERSMatcherDoc.Fields[11].Values = []string{
		"hex",
	}
	MATCHERSMatcherDoc.Fields[12].Name = "case-insensitive"
	MATCHERSMatcherDoc.Fields[12].Type = "bool"
	MATCHERSMatcherDoc.Fields[12].Note = ""
	MATCHERSMatcherDoc.Fields[12].Description = "CaseInsensitive enables case-insensitive matches. Default is false."
	MATCHERSMatcherDoc.Fields[12].Comments[encoder.LineComment] = "CaseInsensitive enables case-insensitive matches. Default is false."
	MATCHERSMatcherDoc.Fields[12].Values = []string{
		"false",
		"true",
	}
	MATCHERSMatcherDoc.Fields[13].Name = "match-all"
	MATCHERSMatcherDoc.Fields[13].Type = "bool"
	MATCHERSMatcherDoc.Fields[13].Note = ""
	MATCHERSMatcherDoc.Fields[13].Description = "MatchAll enables matching for all matcher values. Default is false."
	MATCHERSMatcherDoc.Fields[13].Comments[encoder.LineComment] = "MatchAll enables matching for all matcher values. Default is false."
	MATCHERSMatcherDoc.Fields[13].Values = []string{
		"false",
		"true",
	}

	MatcherTypeHolderDoc.Type = "MatcherTypeHolder"
	MatcherTypeHolderDoc.Comments[encoder.LineComment] = " MatcherTypeHolder is used to hold internal type of the matcher"
	MatcherTypeHolderDoc.Description = "MatcherTypeHolder is used to hold internal type of the matcher"
	MatcherTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "matchers.Matcher",
			FieldName: "type",
		},
	}
	MatcherTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	MatcherTypeHolderDoc.Fields[0].Name = ""
	MatcherTypeHolderDoc.Fields[0].Type = "MatcherType"
	MatcherTypeHolderDoc.Fields[0].Note = ""
	MatcherTypeHolderDoc.Fields[0].Description = ""
	MatcherTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	MatcherTypeHolderDoc.Fields[0].EnumFields = []string{
		"word",
		"regex",
		"binary",
		"status",
		"size",
		"dsl",
	}

	EXTRACTORSExtractorDoc.Type = "extractors.Extractor"
	EXTRACTORSExtractorDoc.Comments[encoder.LineComment] = " Extractor is used to extract part of response using a regex."
	EXTRACTORSExtractorDoc.Description = "Extractor is used to extract part of response using a regex."
	EXTRACTORSExtractorDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "extractors",
		},
		{
			TypeName:  "dns.Request",
			FieldName: "extractors",
		},
		{
			TypeName:  "file.Request",
			FieldName: "extractors",
		},
		{
			TypeName:  "network.Request",
			FieldName: "extractors",
		},
		{
			TypeName:  "headless.Request",
			FieldName: "extractors",
		},
		{
			TypeName:  "ssl.Request",
			FieldName: "extractors",
		},
		{
			TypeName:  "websocket.Request",
			FieldName: "extractors",
		},
		{
			TypeName:  "whois.Request",
			FieldName: "extractors",
		},
	}
	EXTRACTORSExtractorDoc.Fields = make([]encoder.Doc, 11)
	EXTRACTORSExtractorDoc.Fields[0].Name = "name"
	EXTRACTORSExtractorDoc.Fields[0].Type = "string"
	EXTRACTORSExtractorDoc.Fields[0].Note = ""
	EXTRACTORSExtractorDoc.Fields[0].Description = "Name of the extractor. Name should be lowercase and must not contain\nspaces or underscores (_)."
	EXTRACTORSExtractorDoc.Fields[0].Comments[encoder.LineComment] = "Name of the extractor. Name should be lowercase and must not contain"

	EXTRACTORSExtractorDoc.Fields[0].AddExample("", "cookie-extractor")
	EXTRACTORSExtractorDoc.Fields[1].Name = "type"
	EXTRACTORSExtractorDoc.Fields[1].Type = "ExtractorTypeHolder"
	EXTRACTORSExtractorDoc.Fields[1].Note = ""
	EXTRACTORSExtractorDoc.Fields[1].Description = "Type is the type of the extractor."
	EXTRACTORSExtractorDoc.Fields[1].Comments[encoder.LineComment] = "Type is the type of the extractor."
	EXTRACTORSExtractorDoc.Fields[2].Name = "regex"
	EXTRACTORSExtractorDoc.Fields[2].Type = "[]string"
	EXTRACTORSExtractorDoc.Fields[2].Note = ""
	EXTRACTORSExtractorDoc.Fields[2].Description = "Regex contains the regular expression patterns to extract from a part.\n\nGo regex engine does not support lookaheads or lookbehinds, so as a result\nthey are also not supported in nuclei."
	EXTRACTORSExtractorDoc.Fields[2].Comments[encoder.LineComment] = "Regex contains the regular expression patterns to extract from a part."

	EXTRACTORSExtractorDoc.Fields[2].AddExample("Braintree Access Token Regex", []string{"access_token\\$production\\$[0-9a-z]{16}\\$[0-9a-f]{32}"})

	EXTRACTORSExtractorDoc.Fields[2].AddExample("Wordpress Author Extraction regex", []string{"Author:(?:[A-Za-z0-9 -\\_=\"]+)?<span(?:[A-Za-z0-9 -\\_=\"]+)?>([A-Za-z0-9]+)<\\/span>"})
	EXTRACTORSExtractorDoc.Fields[3].Name = "group"
	EXTRACTORSExtractorDoc.Fields[3].Type = "int"
	EXTRACTORSExtractorDoc.Fields[3].Note = ""
	EXTRACTORSExtractorDoc.Fields[3].Description = "Group specifies a numbered group to extract from the regex."
	EXTRACTORSExtractorDoc.Fields[3].Comments[encoder.LineComment] = "Group specifies a numbered group to extract from the regex."

	EXTRACTORSExtractorDoc.Fields[3].AddExample("Example Regex Group", 1)
	EXTRACTORSExtractorDoc.Fields[4].Name = "kval"
	EXTRACTORSExtractorDoc.Fields[4].Type = "[]string"
	EXTRACTORSExtractorDoc.Fields[4].Note = ""
	EXTRACTORSExtractorDoc.Fields[4].Description = "description: |\n   kval contains the key-value pairs present in the HTTP response header.\n   kval extractor can be used to extract HTTP response header and cookie key-value pairs.\n   kval extractor inputs are case-insensitive, and does not support dash (-) in input which can replaced with underscores (_)\n 	 For example, Content-Type should be replaced with content_type\n\n   A list of supported parts is available in docs for request types.\n examples:\n   - name: Extract Server Header From HTTP Response\n     value: >\n       []string{\"server\"}\n   - name: Extracting value of PHPSESSID Cookie\n     value: >\n       []string{\"phpsessid\"}\n   - name: Extracting value of Content-Type Cookie\n     value: >\n       []string{\"content_type\"}"
	EXTRACTORSExtractorDoc.Fields[4].Comments[encoder.LineComment] = " description: |"
	EXTRACTORSExtractorDoc.Fields[5].Name = "json"
	EXTRACTORSExtractorDoc.Fields[5].Type = "[]string"
	EXTRACTORSExtractorDoc.Fields[5].Note = ""
	EXTRACTORSExtractorDoc.Fields[5].Description = "JSON allows using jq-style syntax to extract items from json response"
	EXTRACTORSExtractorDoc.Fields[5].Comments[encoder.LineComment] = "JSON allows using jq-style syntax to extract items from json response"

	EXTRACTORSExtractorDoc.Fields[5].AddExample("", []string{".[] | .id"})

	EXTRACTORSExtractorDoc.Fields[5].AddExample("", []string{".batters | .batter | .[] | .id"})
	EXTRACTORSExtractorDoc.Fields[6].Name = "xpath"
	EXTRACTORSExtractorDoc.Fields[6].Type = "[]string"
	EXTRACTORSExtractorDoc.Fields[6].Note = ""
	EXTRACTORSExtractorDoc.Fields[6].Description = "XPath allows using xpath expressions to extract items from html response"
	EXTRACTORSExtractorDoc.Fields[6].Comments[encoder.LineComment] = "XPath allows using xpath expressions to extract items from html response"

	EXTRACTORSExtractorDoc.Fields[6].AddExample("", []string{"/html/body/div/p[2]/a"})
	EXTRACTORSExtractorDoc.Fields[7].Name = "attribute"
	EXTRACTORSExtractorDoc.Fields[7].Type = "string"
	EXTRACTORSExtractorDoc.Fields[7].Note = ""
	EXTRACTORSExtractorDoc.Fields[7].Description = "Attribute is an optional attribute to extract from response XPath."
	EXTRACTORSExtractorDoc.Fields[7].Comments[encoder.LineComment] = "Attribute is an optional attribute to extract from response XPath."

	EXTRACTORSExtractorDoc.Fields[7].AddExample("", "href")
	EXTRACTORSExtractorDoc.Fields[8].Name = "part"
	EXTRACTORSExtractorDoc.Fields[8].Type = "string"
	EXTRACTORSExtractorDoc.Fields[8].Note = ""
	EXTRACTORSExtractorDoc.Fields[8].Description = "Part is the part of the request response to extract data from.\n\nEach protocol exposes a lot of different parts which are well\ndocumented in docs for each request type."
	EXTRACTORSExtractorDoc.Fields[8].Comments[encoder.LineComment] = "Part is the part of the request response to extract data from."

	EXTRACTORSExtractorDoc.Fields[8].AddExample("", "body")

	EXTRACTORSExtractorDoc.Fields[8].AddExample("", "raw")
	EXTRACTORSExtractorDoc.Fields[9].Name = "internal"
	EXTRACTORSExtractorDoc.Fields[9].Type = "bool"
	EXTRACTORSExtractorDoc.Fields[9].Note = ""
	EXTRACTORSExtractorDoc.Fields[9].Description = "Internal, when set to true will allow using the value extracted\nin the next request for some protocols (like HTTP)."
	EXTRACTORSExtractorDoc.Fields[9].Comments[encoder.LineComment] = "Internal, when set to true will allow using the value extracted"
	EXTRACTORSExtractorDoc.Fields[10].Name = "case-insensitive"
	EXTRACTORSExtractorDoc.Fields[10].Type = "bool"
	EXTRACTORSExtractorDoc.Fields[10].Note = ""
	EXTRACTORSExtractorDoc.Fields[10].Description = "CaseInsensitive enables case-insensitive extractions. Default is false."
	EXTRACTORSExtractorDoc.Fields[10].Comments[encoder.LineComment] = "CaseInsensitive enables case-insensitive extractions. Default is false."
	EXTRACTORSExtractorDoc.Fields[10].Values = []string{
		"false",
		"true",
	}

	ExtractorTypeHolderDoc.Type = "ExtractorTypeHolder"
	ExtractorTypeHolderDoc.Comments[encoder.LineComment] = " ExtractorTypeHolder is used to hold internal type of the extractor"
	ExtractorTypeHolderDoc.Description = "ExtractorTypeHolder is used to hold internal type of the extractor"
	ExtractorTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "extractors.Extractor",
			FieldName: "type",
		},
	}
	ExtractorTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	ExtractorTypeHolderDoc.Fields[0].Name = ""
	ExtractorTypeHolderDoc.Fields[0].Type = "ExtractorType"
	ExtractorTypeHolderDoc.Fields[0].Note = ""
	ExtractorTypeHolderDoc.Fields[0].Description = ""
	ExtractorTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	ExtractorTypeHolderDoc.Fields[0].EnumFields = []string{
		"regex",
		"kval",
		"xpath",
		"json",
		"dsl",
	}

	GENERATORSAttackTypeHolderDoc.Type = "generators.AttackTypeHolder"
	GENERATORSAttackTypeHolderDoc.Comments[encoder.LineComment] = " AttackTypeHolder is used to hold internal type of the protocol"
	GENERATORSAttackTypeHolderDoc.Description = "AttackTypeHolder is used to hold internal type of the protocol"
	GENERATORSAttackTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "attack",
		},
		{
			TypeName:  "network.Request",
			FieldName: "attack",
		},
		{
			TypeName:  "headless.Request",
			FieldName: "attack",
		},
		{
			TypeName:  "websocket.Request",
			FieldName: "attack",
		},
	}
	GENERATORSAttackTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	GENERATORSAttackTypeHolderDoc.Fields[0].Name = ""
	GENERATORSAttackTypeHolderDoc.Fields[0].Type = "AttackType"
	GENERATORSAttackTypeHolderDoc.Fields[0].Note = ""
	GENERATORSAttackTypeHolderDoc.Fields[0].Description = ""
	GENERATORSAttackTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	GENERATORSAttackTypeHolderDoc.Fields[0].EnumFields = []string{
		"batteringram",
		"pitchfork",
		"clusterbomb",
	}

	HTTPMethodTypeHolderDoc.Type = "HTTPMethodTypeHolder"
	HTTPMethodTypeHolderDoc.Comments[encoder.LineComment] = " HTTPMethodTypeHolder is used to hold internal type of the HTTP Method"
	HTTPMethodTypeHolderDoc.Description = "HTTPMethodTypeHolder is used to hold internal type of the HTTP Method"
	HTTPMethodTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "method",
		},
	}
	HTTPMethodTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	HTTPMethodTypeHolderDoc.Fields[0].Name = ""
	HTTPMethodTypeHolderDoc.Fields[0].Type = "HTTPMethodType"
	HTTPMethodTypeHolderDoc.Fields[0].Note = ""
	HTTPMethodTypeHolderDoc.Fields[0].Description = ""
	HTTPMethodTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	HTTPMethodTypeHolderDoc.Fields[0].EnumFields = []string{
		"GET",
		"GET",
		"POST",
		"PUT",
		"DELETE",
		"CONNECT",
		"OPTIONS",
		"TRACE",
		"PATCH",
		"PURGE",
		"Debug",
	}

	SignatureTypeHolderDoc.Type = "SignatureTypeHolder"
	SignatureTypeHolderDoc.Comments[encoder.LineComment] = " SignatureTypeHolder is used to hold internal type of the signature"
	SignatureTypeHolderDoc.Description = "SignatureTypeHolder is used to hold internal type of the signature"
	SignatureTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "signature",
		},
	}
	SignatureTypeHolderDoc.Fields = make([]encoder.Doc, 0)

	DNSRequestDoc.Type = "dns.Request"
	DNSRequestDoc.Comments[encoder.LineComment] = " Request contains a DNS protocol request to be made from a template"
	DNSRequestDoc.Description = "Request contains a DNS protocol request to be made from a template"

	DNSRequestDoc.AddExample("", exampleNormalDNSRequest)
	DNSRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "dns",
		},
	}
	DNSRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "request",
			Value: "Request contains the DNS request in text format",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "rcode",
			Value: "Rcode field returned for the DNS request",
		},
		{
			Key:   "question",
			Value: "Question contains the DNS question field",
		},
		{
			Key:   "extra",
			Value: "Extra contains the DNS response extra field",
		},
		{
			Key:   "answer",
			Value: "Answer contains the DNS response answer field",
		},
		{
			Key:   "ns",
			Value: "NS contains the DNS response NS field",
		},
		{
			Key:   "raw,body,all",
			Value: "Raw contains the raw DNS response (default)",
		},
		{
			Key:   "trace",
			Value: "Trace contains trace data for DNS request if enabled",
		},
	}
	DNSRequestDoc.Fields = make([]encoder.Doc, 12)
	DNSRequestDoc.Fields[0].Name = "matchers"
	DNSRequestDoc.Fields[0].Type = "[]matchers.Matcher"
	DNSRequestDoc.Fields[0].Note = ""
	DNSRequestDoc.Fields[0].Description = "Matchers contains the detection mechanism for the request to identify\nwhether the request was successful by doing pattern matching\non request/responses.\n\nMultiple matchers can be combined with `matcher-condition` flag\nwhich accepts either `and` or `or` as argument."
	DNSRequestDoc.Fields[0].Comments[encoder.LineComment] = "Matchers contains the detection mechanism for the request to identify"
	DNSRequestDoc.Fields[1].Name = "extractors"
	DNSRequestDoc.Fields[1].Type = "[]extractors.Extractor"
	DNSRequestDoc.Fields[1].Note = ""
	DNSRequestDoc.Fields[1].Description = "Extractors contains the extraction mechanism for the request to identify\nand extract parts of the response."
	DNSRequestDoc.Fields[1].Comments[encoder.LineComment] = "Extractors contains the extraction mechanism for the request to identify"
	DNSRequestDoc.Fields[2].Name = "matchers-condition"
	DNSRequestDoc.Fields[2].Type = "string"
	DNSRequestDoc.Fields[2].Note = ""
	DNSRequestDoc.Fields[2].Description = "MatchersCondition is the condition between the matchers. Default is OR."
	DNSRequestDoc.Fields[2].Comments[encoder.LineComment] = "MatchersCondition is the condition between the matchers. Default is OR."
	DNSRequestDoc.Fields[2].Values = []string{
		"and",
		"or",
	}
	DNSRequestDoc.Fields[3].Name = "id"
	DNSRequestDoc.Fields[3].Type = "string"
	DNSRequestDoc.Fields[3].Note = ""
	DNSRequestDoc.Fields[3].Description = "ID is the optional id of the request"
	DNSRequestDoc.Fields[3].Comments[encoder.LineComment] = " ID is the optional id of the request"
	DNSRequestDoc.Fields[4].Name = "name"
	DNSRequestDoc.Fields[4].Type = "string"
	DNSRequestDoc.Fields[4].Note = ""
	DNSRequestDoc.Fields[4].Description = "Name is the Hostname to make DNS request for.\n\nGenerally, it is set to {{FQDN}} which is the domain we get from input."
	DNSRequestDoc.Fields[4].Comments[encoder.LineComment] = "Name is the Hostname to make DNS request for."

	DNSRequestDoc.Fields[4].AddExample("", "{{FQDN}}")
	DNSRequestDoc.Fields[5].Name = "type"
	DNSRequestDoc.Fields[5].Type = "DNSRequestTypeHolder"
	DNSRequestDoc.Fields[5].Note = ""
	DNSRequestDoc.Fields[5].Description = "RequestType is the type of DNS request to make."
	DNSRequestDoc.Fields[5].Comments[encoder.LineComment] = "RequestType is the type of DNS request to make."
	DNSRequestDoc.Fields[6].Name = "class"
	DNSRequestDoc.Fields[6].Type = "string"
	DNSRequestDoc.Fields[6].Note = ""
	DNSRequestDoc.Fields[6].Description = "Class is the class of the DNS request.\n\nUsually it's enough to just leave it as INET."
	DNSRequestDoc.Fields[6].Comments[encoder.LineComment] = "Class is the class of the DNS request."
	DNSRequestDoc.Fields[6].Values = []string{
		"inet",
		"csnet",
		"chaos",
		"hesiod",
		"none",
		"any",
	}
	DNSRequestDoc.Fields[7].Name = "retries"
	DNSRequestDoc.Fields[7].Type = "int"
	DNSRequestDoc.Fields[7].Note = ""
	DNSRequestDoc.Fields[7].Description = "Retries is the number of retries for the DNS request"
	DNSRequestDoc.Fields[7].Comments[encoder.LineComment] = "Retries is the number of retries for the DNS request"

	DNSRequestDoc.Fields[7].AddExample("Use a retry of 3 to 5 generally", 5)
	DNSRequestDoc.Fields[8].Name = "trace"
	DNSRequestDoc.Fields[8].Type = "bool"
	DNSRequestDoc.Fields[8].Note = ""
	DNSRequestDoc.Fields[8].Description = "Trace performs a trace operation for the target."
	DNSRequestDoc.Fields[8].Comments[encoder.LineComment] = "Trace performs a trace operation for the target."
	DNSRequestDoc.Fields[9].Name = "trace-max-recursion"
	DNSRequestDoc.Fields[9].Type = "int"
	DNSRequestDoc.Fields[9].Note = ""
	DNSRequestDoc.Fields[9].Description = "TraceMaxRecursion is the number of max recursion allowed for trace operations"
	DNSRequestDoc.Fields[9].Comments[encoder.LineComment] = "TraceMaxRecursion is the number of max recursion allowed for trace operations"

	DNSRequestDoc.Fields[9].AddExample("Use a retry of 100 to 150 generally", 100)
	DNSRequestDoc.Fields[10].Name = "recursion"
	DNSRequestDoc.Fields[10].Type = "dns.bool"
	DNSRequestDoc.Fields[10].Note = ""
	DNSRequestDoc.Fields[10].Description = "Recursion determines if resolver should recurse all records to get fresh results."
	DNSRequestDoc.Fields[10].Comments[encoder.LineComment] = "Recursion determines if resolver should recurse all records to get fresh results."
	DNSRequestDoc.Fields[11].Name = "resolvers"
	DNSRequestDoc.Fields[11].Type = "[]string"
	DNSRequestDoc.Fields[11].Note = ""
	DNSRequestDoc.Fields[11].Description = "Resolvers to use for the dns requests"
	DNSRequestDoc.Fields[11].Comments[encoder.LineComment] = " Resolvers to use for the dns requests"

	DNSRequestTypeHolderDoc.Type = "DNSRequestTypeHolder"
	DNSRequestTypeHolderDoc.Comments[encoder.LineComment] = " DNSRequestTypeHolder is used to hold internal type of the DNS type"
	DNSRequestTypeHolderDoc.Description = "DNSRequestTypeHolder is used to hold internal type of the DNS type"
	DNSRequestTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "dns.Request",
			FieldName: "type",
		},
	}
	DNSRequestTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	DNSRequestTypeHolderDoc.Fields[0].Name = ""
	DNSRequestTypeHolderDoc.Fields[0].Type = "DNSRequestType"
	DNSRequestTypeHolderDoc.Fields[0].Note = ""
	DNSRequestTypeHolderDoc.Fields[0].Description = ""
	DNSRequestTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	DNSRequestTypeHolderDoc.Fields[0].EnumFields = []string{
		"A",
		"NS",
		"DS",
		"CNAME",
		"SOA",
		"PTR",
		"MX",
		"TXT",
		"AAAA",
		"CAA",
	}

	FILERequestDoc.Type = "file.Request"
	FILERequestDoc.Comments[encoder.LineComment] = " Request contains a File matching mechanism for local disk operations."
	FILERequestDoc.Description = "Request contains a File matching mechanism for local disk operations."

	FILERequestDoc.AddExample("", exampleNormalFileRequest)
	FILERequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "file",
		},
	}
	FILERequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "path",
			Value: "Path is the path of file on local filesystem",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "raw,body,all,data",
			Value: "Raw contains the raw file contents",
		},
	}
	FILERequestDoc.Fields = make([]encoder.Doc, 8)
	FILERequestDoc.Fields[0].Name = "matchers"
	FILERequestDoc.Fields[0].Type = "[]matchers.Matcher"
	FILERequestDoc.Fields[0].Note = ""
	FILERequestDoc.Fields[0].Description = "Matchers contains the detection mechanism for the request to identify\nwhether the request was successful by doing pattern matching\non request/responses.\n\nMultiple matchers can be combined with `matcher-condition` flag\nwhich accepts either `and` or `or` as argument."
	FILERequestDoc.Fields[0].Comments[encoder.LineComment] = "Matchers contains the detection mechanism for the request to identify"
	FILERequestDoc.Fields[1].Name = "extractors"
	FILERequestDoc.Fields[1].Type = "[]extractors.Extractor"
	FILERequestDoc.Fields[1].Note = ""
	FILERequestDoc.Fields[1].Description = "Extractors contains the extraction mechanism for the request to identify\nand extract parts of the response."
	FILERequestDoc.Fields[1].Comments[encoder.LineComment] = "Extractors contains the extraction mechanism for the request to identify"
	FILERequestDoc.Fields[2].Name = "matchers-condition"
	FILERequestDoc.Fields[2].Type = "string"
	FILERequestDoc.Fields[2].Note = ""
	FILERequestDoc.Fields[2].Description = "MatchersCondition is the condition between the matchers. Default is OR."
	FILERequestDoc.Fields[2].Comments[encoder.LineComment] = "MatchersCondition is the condition between the matchers. Default is OR."
	FILERequestDoc.Fields[2].Values = []string{
		"and",
		"or",
	}
	FILERequestDoc.Fields[3].Name = "extensions"
	FILERequestDoc.Fields[3].Type = "[]string"
	FILERequestDoc.Fields[3].Note = ""
	FILERequestDoc.Fields[3].Description = "Extensions is the list of extensions or mime types to perform matching on."
	FILERequestDoc.Fields[3].Comments[encoder.LineComment] = "Extensions is the list of extensions or mime types to perform matching on."

	FILERequestDoc.Fields[3].AddExample("", []string{".txt", ".go", ".json"})
	FILERequestDoc.Fields[4].Name = "denylist"
	FILERequestDoc.Fields[4].Type = "[]string"
	FILERequestDoc.Fields[4].Note = ""
	FILERequestDoc.Fields[4].Description = "DenyList is the list of file, directories, mime types or extensions to deny during matching.\n\nBy default, it contains some non-interesting extensions that are hardcoded\nin nuclei."
	FILERequestDoc.Fields[4].Comments[encoder.LineComment] = "DenyList is the list of file, directories, mime types or extensions to deny during matching."

	FILERequestDoc.Fields[4].AddExample("", []string{".avi", ".mov", ".mp3"})
	FILERequestDoc.Fields[5].Name = "id"
	FILERequestDoc.Fields[5].Type = "string"
	FILERequestDoc.Fields[5].Note = ""
	FILERequestDoc.Fields[5].Description = "ID is the optional id of the request"
	FILERequestDoc.Fields[5].Comments[encoder.LineComment] = " ID is the optional id of the request"
	FILERequestDoc.Fields[6].Name = "max-size"
	FILERequestDoc.Fields[6].Type = "string"
	FILERequestDoc.Fields[6].Note = ""
	FILERequestDoc.Fields[6].Description = "MaxSize is the maximum size of the file to run request on.\n\nBy default, nuclei will process 1 GB of content and not go more than that.\nIt can be set to much lower or higher depending on use.\nIf set to \"no\" then all content will be processed"
	FILERequestDoc.Fields[6].Comments[encoder.LineComment] = "MaxSize is the maximum size of the file to run request on."

	FILERequestDoc.Fields[6].AddExample("", "5Mb")
	FILERequestDoc.Fields[7].Name = "no-recursive"
	FILERequestDoc.Fields[7].Type = "bool"
	FILERequestDoc.Fields[7].Note = ""
	FILERequestDoc.Fields[7].Description = "NoRecursive specifies whether to not do recursive checks if folders are provided."
	FILERequestDoc.Fields[7].Comments[encoder.LineComment] = "NoRecursive specifies whether to not do recursive checks if folders are provided."

	NETWORKRequestDoc.Type = "network.Request"
	NETWORKRequestDoc.Comments[encoder.LineComment] = " Request contains a Network protocol request to be made from a template"
	NETWORKRequestDoc.Description = "Request contains a Network protocol request to be made from a template"

	NETWORKRequestDoc.AddExample("", exampleNormalNetworkRequest)
	NETWORKRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "network",
		},
	}
	NETWORKRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "request",
			Value: "Network request made from the client",
		},
		{
			Key:   "body,all,data",
			Value: "Network response received from server (default)",
		},
		{
			Key:   "raw",
			Value: "Full Network protocol data",
		},
	}
	NETWORKRequestDoc.Fields = make([]encoder.Doc, 10)
	NETWORKRequestDoc.Fields[0].Name = "id"
	NETWORKRequestDoc.Fields[0].Type = "string"
	NETWORKRequestDoc.Fields[0].Note = ""
	NETWORKRequestDoc.Fields[0].Description = "ID is the optional id of the request"
	NETWORKRequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	NETWORKRequestDoc.Fields[1].Name = "host"
	NETWORKRequestDoc.Fields[1].Type = "[]string"
	NETWORKRequestDoc.Fields[1].Note = ""
	NETWORKRequestDoc.Fields[1].Description = "Host to send network requests to.\n\nUsually it's set to `{{Hostname}}`. If you want to enable TLS for\nTCP Connection, you can use `tls://{{Hostname}}`."
	NETWORKRequestDoc.Fields[1].Comments[encoder.LineComment] = "Host to send network requests to."

	NETWORKRequestDoc.Fields[1].AddExample("", []string{"{{Hostname}}"})
	NETWORKRequestDoc.Fields[2].Name = "attack"
	NETWORKRequestDoc.Fields[2].Type = "generators.AttackTypeHolder"
	NETWORKRequestDoc.Fields[2].Note = ""
	NETWORKRequestDoc.Fields[2].Description = "Attack is the type of payload combinations to perform.\n\nBatteringram is inserts the same payload into all defined payload positions at once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	NETWORKRequestDoc.Fields[2].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	NETWORKRequestDoc.Fields[3].Name = "payloads"
	NETWORKRequestDoc.Fields[3].Type = "map[string]interface{}"
	NETWORKRequestDoc.Fields[3].Note = ""
	NETWORKRequestDoc.Fields[3].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	NETWORKRequestDoc.Fields[3].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."
	NETWORKRequestDoc.Fields[4].Name = "inputs"
	NETWORKRequestDoc.Fields[4].Type = "[]network.Input"
	NETWORKRequestDoc.Fields[4].Note = ""
	NETWORKRequestDoc.Fields[4].Description = "Inputs contains inputs for the network socket"
	NETWORKRequestDoc.Fields[4].Comments[encoder.LineComment] = "Inputs contains inputs for the network socket"
	NETWORKRequestDoc.Fields[5].Name = "read-size"
	NETWORKRequestDoc.Fields[5].Type = "int"
	NETWORKRequestDoc.Fields[5].Note = ""
	NETWORKRequestDoc.Fields[5].Description = "ReadSize is the size of response to read at the end\n\nDefault value for read-size is 1024."
	NETWORKRequestDoc.Fields[5].Comments[encoder.LineComment] = "ReadSize is the size of response to read at the end"

	NETWORKRequestDoc.Fields[5].AddExample("", 2048)
	NETWORKRequestDoc.Fields[6].Name = "read-all"
	NETWORKRequestDoc.Fields[6].Type = "bool"
	NETWORKRequestDoc.Fields[6].Note = ""
	NETWORKRequestDoc.Fields[6].Description = "ReadAll determines if the data stream should be read till the end regardless of the size\n\nDefault value for read-all is false."
	NETWORKRequestDoc.Fields[6].Comments[encoder.LineComment] = "ReadAll determines if the data stream should be read till the end regardless of the size"

	NETWORKRequestDoc.Fields[6].AddExample("", false)
	NETWORKRequestDoc.Fields[7].Name = "matchers"
	NETWORKRequestDoc.Fields[7].Type = "[]matchers.Matcher"
	NETWORKRequestDoc.Fields[7].Note = ""
	NETWORKRequestDoc.Fields[7].Description = "Matchers contains the detection mechanism for the request to identify\nwhether the request was successful by doing pattern matching\non request/responses.\n\nMultiple matchers can be combined with `matcher-condition` flag\nwhich accepts either `and` or `or` as argument."
	NETWORKRequestDoc.Fields[7].Comments[encoder.LineComment] = "Matchers contains the detection mechanism for the request to identify"
	NETWORKRequestDoc.Fields[8].Name = "extractors"
	NETWORKRequestDoc.Fields[8].Type = "[]extractors.Extractor"
	NETWORKRequestDoc.Fields[8].Note = ""
	NETWORKRequestDoc.Fields[8].Description = "Extractors contains the extraction mechanism for the request to identify\nand extract parts of the response."
	NETWORKRequestDoc.Fields[8].Comments[encoder.LineComment] = "Extractors contains the extraction mechanism for the request to identify"
	NETWORKRequestDoc.Fields[9].Name = "matchers-condition"
	NETWORKRequestDoc.Fields[9].Type = "string"
	NETWORKRequestDoc.Fields[9].Note = ""
	NETWORKRequestDoc.Fields[9].Description = "MatchersCondition is the condition between the matchers. Default is OR."
	NETWORKRequestDoc.Fields[9].Comments[encoder.LineComment] = "MatchersCondition is the condition between the matchers. Default is OR."
	NETWORKRequestDoc.Fields[9].Values = []string{
		"and",
		"or",
	}

	NETWORKInputDoc.Type = "network.Input"
	NETWORKInputDoc.Comments[encoder.LineComment] = ""
	NETWORKInputDoc.Description = ""
	NETWORKInputDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "network.Request",
			FieldName: "inputs",
		},
	}
	NETWORKInputDoc.Fields = make([]encoder.Doc, 4)
	NETWORKInputDoc.Fields[0].Name = "data"
	NETWORKInputDoc.Fields[0].Type = "string"
	NETWORKInputDoc.Fields[0].Note = ""
	NETWORKInputDoc.Fields[0].Description = "Data is the data to send as the input.\n\nIt supports DSL Helper Functions as well as normal expressions."
	NETWORKInputDoc.Fields[0].Comments[encoder.LineComment] = "Data is the data to send as the input."

	NETWORKInputDoc.Fields[0].AddExample("", "TEST")

	NETWORKInputDoc.Fields[0].AddExample("", "hex_decode('50494e47')")
	NETWORKInputDoc.Fields[1].Name = "type"
	NETWORKInputDoc.Fields[1].Type = "NetworkInputTypeHolder"
	NETWORKInputDoc.Fields[1].Note = ""
	NETWORKInputDoc.Fields[1].Description = "Type is the type of input specified in `data` field.\n\nDefault value is text, but hex can be used for hex formatted data."
	NETWORKInputDoc.Fields[1].Comments[encoder.LineComment] = "Type is the type of input specified in `data` field."
	NETWORKInputDoc.Fields[1].Values = []string{
		"hex",
		"text",
	}
	NETWORKInputDoc.Fields[2].Name = "read"
	NETWORKInputDoc.Fields[2].Type = "int"
	NETWORKInputDoc.Fields[2].Note = ""
	NETWORKInputDoc.Fields[2].Description = "Read is the number of bytes to read from socket.\n\nThis can be used for protocols which expect an immediate response. You can\nread and write responses one after another and eventually perform matching\non every data captured with `name` attribute.\n\nThe [network docs](https://nuclei.projectdiscovery.io/templating-guide/protocols/network/) highlight more on how to do this."
	NETWORKInputDoc.Fields[2].Comments[encoder.LineComment] = "Read is the number of bytes to read from socket."

	NETWORKInputDoc.Fields[2].AddExample("", 1024)
	NETWORKInputDoc.Fields[3].Name = "name"
	NETWORKInputDoc.Fields[3].Type = "string"
	NETWORKInputDoc.Fields[3].Note = ""
	NETWORKInputDoc.Fields[3].Description = "Name is the optional name of the data read to provide matching on."
	NETWORKInputDoc.Fields[3].Comments[encoder.LineComment] = "Name is the optional name of the data read to provide matching on."

	NETWORKInputDoc.Fields[3].AddExample("", "prefix")

	NetworkInputTypeHolderDoc.Type = "NetworkInputTypeHolder"
	NetworkInputTypeHolderDoc.Comments[encoder.LineComment] = " NetworkInputTypeHolder is used to hold internal type of the Network type"
	NetworkInputTypeHolderDoc.Description = "NetworkInputTypeHolder is used to hold internal type of the Network type"
	NetworkInputTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "network.Input",
			FieldName: "type",
		},
	}
	NetworkInputTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	NetworkInputTypeHolderDoc.Fields[0].Name = ""
	NetworkInputTypeHolderDoc.Fields[0].Type = "NetworkInputType"
	NetworkInputTypeHolderDoc.Fields[0].Note = ""
	NetworkInputTypeHolderDoc.Fields[0].Description = ""
	NetworkInputTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	NetworkInputTypeHolderDoc.Fields[0].EnumFields = []string{
		"hex",
		"text",
	}

	HEADLESSRequestDoc.Type = "headless.Request"
	HEADLESSRequestDoc.Comments[encoder.LineComment] = " Request contains a Headless protocol request to be made from a template"
	HEADLESSRequestDoc.Description = "Request contains a Headless protocol request to be made from a template"
	HEADLESSRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "headless",
		},
	}
	HEADLESSRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "req",
			Value: "Headless request made from the client",
		},
		{
			Key:   "resp,body,data",
			Value: "Headless response received from client (default)",
		},
	}
	HEADLESSRequestDoc.Fields = make([]encoder.Doc, 9)
	HEADLESSRequestDoc.Fields[0].Name = "id"
	HEADLESSRequestDoc.Fields[0].Type = "string"
	HEADLESSRequestDoc.Fields[0].Note = ""
	HEADLESSRequestDoc.Fields[0].Description = "ID is the optional id of the request"
	HEADLESSRequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	HEADLESSRequestDoc.Fields[1].Name = "attack"
	HEADLESSRequestDoc.Fields[1].Type = "generators.AttackTypeHolder"
	HEADLESSRequestDoc.Fields[1].Note = ""
	HEADLESSRequestDoc.Fields[1].Description = "Attack is the type of payload combinations to perform.\n\nBatteringram is inserts the same payload into all defined payload positions at once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	HEADLESSRequestDoc.Fields[1].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	HEADLESSRequestDoc.Fields[2].Name = "payloads"
	HEADLESSRequestDoc.Fields[2].Type = "map[string]interface{}"
	HEADLESSRequestDoc.Fields[2].Note = ""
	HEADLESSRequestDoc.Fields[2].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	HEADLESSRequestDoc.Fields[2].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."
	HEADLESSRequestDoc.Fields[3].Name = "steps"
	HEADLESSRequestDoc.Fields[3].Type = "[]engine.Action"
	HEADLESSRequestDoc.Fields[3].Note = ""
	HEADLESSRequestDoc.Fields[3].Description = "Steps is the list of actions to run for headless request"
	HEADLESSRequestDoc.Fields[3].Comments[encoder.LineComment] = "Steps is the list of actions to run for headless request"
	HEADLESSRequestDoc.Fields[4].Name = "user_agent"
	HEADLESSRequestDoc.Fields[4].Type = "userAgent.UserAgentHolder"
	HEADLESSRequestDoc.Fields[4].Note = ""
	HEADLESSRequestDoc.Fields[4].Description = "descriptions: |\n 	 User-Agent is the type of user-agent to use for the request."
	HEADLESSRequestDoc.Fields[4].Comments[encoder.LineComment] = " descriptions: |"
	HEADLESSRequestDoc.Fields[5].Name = "custom_user_agent"
	HEADLESSRequestDoc.Fields[5].Type = "string"
	HEADLESSRequestDoc.Fields[5].Note = ""
	HEADLESSRequestDoc.Fields[5].Description = "description: |\n 	 If UserAgent is set to custom, customUserAgent is the custom user-agent to use for the request."
	HEADLESSRequestDoc.Fields[5].Comments[encoder.LineComment] = " description: |"
	HEADLESSRequestDoc.Fields[6].Name = "matchers"
	HEADLESSRequestDoc.Fields[6].Type = "[]matchers.Matcher"
	HEADLESSRequestDoc.Fields[6].Note = ""
	HEADLESSRequestDoc.Fields[6].Description = "Matchers contains the detection mechanism for the request to identify\nwhether the request was successful by doing pattern matching\non request/responses.\n\nMultiple matchers can be combined with `matcher-condition` flag\nwhich accepts either `and` or `or` as argument."
	HEADLESSRequestDoc.Fields[6].Comments[encoder.LineComment] = "Matchers contains the detection mechanism for the request to identify"
	HEADLESSRequestDoc.Fields[7].Name = "extractors"
	HEADLESSRequestDoc.Fields[7].Type = "[]extractors.Extractor"
	HEADLESSRequestDoc.Fields[7].Note = ""
	HEADLESSRequestDoc.Fields[7].Description = "Extractors contains the extraction mechanism for the request to identify\nand extract parts of the response."
	HEADLESSRequestDoc.Fields[7].Comments[encoder.LineComment] = "Extractors contains the extraction mechanism for the request to identify"
	HEADLESSRequestDoc.Fields[8].Name = "matchers-condition"
	HEADLESSRequestDoc.Fields[8].Type = "string"
	HEADLESSRequestDoc.Fields[8].Note = ""
	HEADLESSRequestDoc.Fields[8].Description = "MatchersCondition is the condition between the matchers. Default is OR."
	HEADLESSRequestDoc.Fields[8].Comments[encoder.LineComment] = "MatchersCondition is the condition between the matchers. Default is OR."
	HEADLESSRequestDoc.Fields[8].Values = []string{
		"and",
		"or",
	}

	ENGINEActionDoc.Type = "engine.Action"
	ENGINEActionDoc.Comments[encoder.LineComment] = " Action is an action taken by the browser to reach a navigation"
	ENGINEActionDoc.Description = "Action is an action taken by the browser to reach a navigation\n\n Each step that the browser executes is an action. Most navigations\n usually start from the ActionLoadURL event, and further navigations\n are discovered on the found page. We also keep track and only\n scrape new navigation from pages we haven't crawled yet."
	ENGINEActionDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "headless.Request",
			FieldName: "steps",
		},
	}
	ENGINEActionDoc.Fields = make([]encoder.Doc, 4)
	ENGINEActionDoc.Fields[0].Name = "args"
	ENGINEActionDoc.Fields[0].Type = "map[string]string"
	ENGINEActionDoc.Fields[0].Note = ""
	ENGINEActionDoc.Fields[0].Description = "Args contain arguments for the headless action.\nPer action arguments are described in detail [here](https://nuclei.projectdiscovery.io/templating-guide/protocols/headless/)."
	ENGINEActionDoc.Fields[0].Comments[encoder.LineComment] = "Args contain arguments for the headless action."
	ENGINEActionDoc.Fields[1].Name = "name"
	ENGINEActionDoc.Fields[1].Type = "string"
	ENGINEActionDoc.Fields[1].Note = ""
	ENGINEActionDoc.Fields[1].Description = "Name is the name assigned to the headless action.\n\nThis can be used to execute code, for instance in browser\nDOM using script action, and get the result in a variable\nwhich can be matched upon by nuclei. An Example template [here](https://github.com/projectdiscovery/nuclei-templates/blob/master/headless/prototype-pollution-check.yaml)."
	ENGINEActionDoc.Fields[1].Comments[encoder.LineComment] = "Name is the name assigned to the headless action."
	ENGINEActionDoc.Fields[2].Name = "description"
	ENGINEActionDoc.Fields[2].Type = "string"
	ENGINEActionDoc.Fields[2].Note = ""
	ENGINEActionDoc.Fields[2].Description = "Description is the optional description of the headless action"
	ENGINEActionDoc.Fields[2].Comments[encoder.LineComment] = "Description is the optional description of the headless action"
	ENGINEActionDoc.Fields[3].Name = "action"
	ENGINEActionDoc.Fields[3].Type = "ActionTypeHolder"
	ENGINEActionDoc.Fields[3].Note = ""
	ENGINEActionDoc.Fields[3].Description = "Action is the type of the action to perform."
	ENGINEActionDoc.Fields[3].Comments[encoder.LineComment] = "Action is the type of the action to perform."

	ActionTypeHolderDoc.Type = "ActionTypeHolder"
	ActionTypeHolderDoc.Comments[encoder.LineComment] = " ActionTypeHolder is used to hold internal type of the action"
	ActionTypeHolderDoc.Description = "ActionTypeHolder is used to hold internal type of the action"
	ActionTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "engine.Action",
			FieldName: "action",
		},
	}
	ActionTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	ActionTypeHolderDoc.Fields[0].Name = ""
	ActionTypeHolderDoc.Fields[0].Type = "ActionType"
	ActionTypeHolderDoc.Fields[0].Note = ""
	ActionTypeHolderDoc.Fields[0].Description = ""
	ActionTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	ActionTypeHolderDoc.Fields[0].EnumFields = []string{
		"navigate",
		"script",
		"click",
		"rightclick",
		"text",
		"screenshot",
		"time",
		"select",
		"files",
		"waitload",
		"getresource",
		"extract",
		"setmethod",
		"addheader",
		"setheader",
		"deleteheader",
		"setbody",
		"waitevent",
		"keyboard",
		"debug",
		"sleep",
		"waitvisible",
	}

	USERAGENTUserAgentHolderDoc.Type = "userAgent.UserAgentHolder"
	USERAGENTUserAgentHolderDoc.Comments[encoder.LineComment] = " UserAgentHolder holds a UserAgent type. Required for un/marshalling purposes"
	USERAGENTUserAgentHolderDoc.Description = "UserAgentHolder holds a UserAgent type. Required for un/marshalling purposes"
	USERAGENTUserAgentHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "headless.Request",
			FieldName: "user_agent",
		},
	}
	USERAGENTUserAgentHolderDoc.Fields = make([]encoder.Doc, 1)
	USERAGENTUserAgentHolderDoc.Fields[0].Name = ""
	USERAGENTUserAgentHolderDoc.Fields[0].Type = "UserAgent"
	USERAGENTUserAgentHolderDoc.Fields[0].Note = ""
	USERAGENTUserAgentHolderDoc.Fields[0].Description = ""
	USERAGENTUserAgentHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	USERAGENTUserAgentHolderDoc.Fields[0].EnumFields = []string{
		"random",
		"off",
		"default",
		"custom",
	}

	SSLRequestDoc.Type = "ssl.Request"
	SSLRequestDoc.Comments[encoder.LineComment] = " Request is a request for the SSL protocol"
	SSLRequestDoc.Description = "Request is a request for the SSL protocol"
	SSLRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "ssl",
		},
	}
	SSLRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "response",
			Value: "JSON SSL protocol handshake details",
		},
		{
			Key:   "not_after",
			Value: "Timestamp after which the remote cert expires",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
	}
	SSLRequestDoc.Fields = make([]encoder.Doc, 7)
	SSLRequestDoc.Fields[0].Name = "matchers"
	SSLRequestDoc.Fields[0].Type = "[]matchers.Matcher"
	SSLRequestDoc.Fields[0].Note = ""
	SSLRequestDoc.Fields[0].Description = "Matchers contains the detection mechanism for the request to identify\nwhether the request was successful by doing pattern matching\non request/responses.\n\nMultiple matchers can be combined with `matcher-condition` flag\nwhich accepts either `and` or `or` as argument."
	SSLRequestDoc.Fields[0].Comments[encoder.LineComment] = "Matchers contains the detection mechanism for the request to identify"
	SSLRequestDoc.Fields[1].Name = "extractors"
	SSLRequestDoc.Fields[1].Type = "[]extractors.Extractor"
	SSLRequestDoc.Fields[1].Note = ""
	SSLRequestDoc.Fields[1].Description = "Extractors contains the extraction mechanism for the request to identify\nand extract parts of the response."
	SSLRequestDoc.Fields[1].Comments[encoder.LineComment] = "Extractors contains the extraction mechanism for the request to identify"
	SSLRequestDoc.Fields[2].Name = "matchers-condition"
	SSLRequestDoc.Fields[2].Type = "string"
	SSLRequestDoc.Fields[2].Note = ""
	SSLRequestDoc.Fields[2].Description = "MatchersCondition is the condition between the matchers. Default is OR."
	SSLRequestDoc.Fields[2].Comments[encoder.LineComment] = "MatchersCondition is the condition between the matchers. Default is OR."
	SSLRequestDoc.Fields[2].Values = []string{
		"and",
		"or",
	}
	SSLRequestDoc.Fields[3].Name = "address"
	SSLRequestDoc.Fields[3].Type = "string"
	SSLRequestDoc.Fields[3].Note = ""
	SSLRequestDoc.Fields[3].Description = "Address contains address for the request"
	SSLRequestDoc.Fields[3].Comments[encoder.LineComment] = "Address contains address for the request"
	SSLRequestDoc.Fields[4].Name = "min_version"
	SSLRequestDoc.Fields[4].Type = "string"
	SSLRequestDoc.Fields[4].Note = ""
	SSLRequestDoc.Fields[4].Description = "Minimum tls version - auto if not specified."
	SSLRequestDoc.Fields[4].Comments[encoder.LineComment] = "Minimum tls version - auto if not specified."
	SSLRequestDoc.Fields[4].Values = []string{
		"sslv3",
		"tls10",
		"tls11",
		"tls12",
		"tls13",
	}
	SSLRequestDoc.Fields[5].Name = "max_version"
	SSLRequestDoc.Fields[5].Type = "string"
	SSLRequestDoc.Fields[5].Note = ""
	SSLRequestDoc.Fields[5].Description = "Max tls version - auto if not specified."
	SSLRequestDoc.Fields[5].Comments[encoder.LineComment] = "Max tls version - auto if not specified."
	SSLRequestDoc.Fields[5].Values = []string{
		"sslv3",
		"tls10",
		"tls11",
		"tls12",
		"tls13",
	}
	SSLRequestDoc.Fields[6].Name = "cipher_suites"
	SSLRequestDoc.Fields[6].Type = "[]string"
	SSLRequestDoc.Fields[6].Note = ""
	SSLRequestDoc.Fields[6].Description = "Client Cipher Suites  - auto if not specified."
	SSLRequestDoc.Fields[6].Comments[encoder.LineComment] = "Client Cipher Suites  - auto if not specified."

	WEBSOCKETRequestDoc.Type = "websocket.Request"
	WEBSOCKETRequestDoc.Comments[encoder.LineComment] = " Request is a request for the Websocket protocol"
	WEBSOCKETRequestDoc.Description = "Request is a request for the Websocket protocol"
	WEBSOCKETRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "websocket",
		},
	}
	WEBSOCKETRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "success",
			Value: "Success specifies whether websocket connection was successful",
		},
		{
			Key:   "request",
			Value: "Websocket request made to the server",
		},
		{
			Key:   "response",
			Value: "Websocket response received from the server",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
	}
	WEBSOCKETRequestDoc.Fields = make([]encoder.Doc, 8)
	WEBSOCKETRequestDoc.Fields[0].Name = "matchers"
	WEBSOCKETRequestDoc.Fields[0].Type = "[]matchers.Matcher"
	WEBSOCKETRequestDoc.Fields[0].Note = ""
	WEBSOCKETRequestDoc.Fields[0].Description = "Matchers contains the detection mechanism for the request to identify\nwhether the request was successful by doing pattern matching\non request/responses.\n\nMultiple matchers can be combined with `matcher-condition` flag\nwhich accepts either `and` or `or` as argument."
	WEBSOCKETRequestDoc.Fields[0].Comments[encoder.LineComment] = "Matchers contains the detection mechanism for the request to identify"
	WEBSOCKETRequestDoc.Fields[1].Name = "extractors"
	WEBSOCKETRequestDoc.Fields[1].Type = "[]extractors.Extractor"
	WEBSOCKETRequestDoc.Fields[1].Note = ""
	WEBSOCKETRequestDoc.Fields[1].Description = "Extractors contains the extraction mechanism for the request to identify\nand extract parts of the response."
	WEBSOCKETRequestDoc.Fields[1].Comments[encoder.LineComment] = "Extractors contains the extraction mechanism for the request to identify"
	WEBSOCKETRequestDoc.Fields[2].Name = "matchers-condition"
	WEBSOCKETRequestDoc.Fields[2].Type = "string"
	WEBSOCKETRequestDoc.Fields[2].Note = ""
	WEBSOCKETRequestDoc.Fields[2].Description = "MatchersCondition is the condition between the matchers. Default is OR."
	WEBSOCKETRequestDoc.Fields[2].Comments[encoder.LineComment] = "MatchersCondition is the condition between the matchers. Default is OR."
	WEBSOCKETRequestDoc.Fields[2].Values = []string{
		"and",
		"or",
	}
	WEBSOCKETRequestDoc.Fields[3].Name = "address"
	WEBSOCKETRequestDoc.Fields[3].Type = "string"
	WEBSOCKETRequestDoc.Fields[3].Note = ""
	WEBSOCKETRequestDoc.Fields[3].Description = "Address contains address for the request"
	WEBSOCKETRequestDoc.Fields[3].Comments[encoder.LineComment] = "Address contains address for the request"
	WEBSOCKETRequestDoc.Fields[4].Name = "inputs"
	WEBSOCKETRequestDoc.Fields[4].Type = "[]websocket.Input"
	WEBSOCKETRequestDoc.Fields[4].Note = ""
	WEBSOCKETRequestDoc.Fields[4].Description = "Inputs contains inputs for the websocket protocol"
	WEBSOCKETRequestDoc.Fields[4].Comments[encoder.LineComment] = "Inputs contains inputs for the websocket protocol"
	WEBSOCKETRequestDoc.Fields[5].Name = "headers"
	WEBSOCKETRequestDoc.Fields[5].Type = "map[string]string"
	WEBSOCKETRequestDoc.Fields[5].Note = ""
	WEBSOCKETRequestDoc.Fields[5].Description = "Headers contains headers for the request."
	WEBSOCKETRequestDoc.Fields[5].Comments[encoder.LineComment] = "Headers contains headers for the request."
	WEBSOCKETRequestDoc.Fields[6].Name = "attack"
	WEBSOCKETRequestDoc.Fields[6].Type = "generators.AttackTypeHolder"
	WEBSOCKETRequestDoc.Fields[6].Note = ""
	WEBSOCKETRequestDoc.Fields[6].Description = "Attack is the type of payload combinations to perform.\n\nSniper is each payload once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	WEBSOCKETRequestDoc.Fields[6].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	WEBSOCKETRequestDoc.Fields[7].Name = "payloads"
	WEBSOCKETRequestDoc.Fields[7].Type = "map[string]interface{}"
	WEBSOCKETRequestDoc.Fields[7].Note = ""
	WEBSOCKETRequestDoc.Fields[7].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	WEBSOCKETRequestDoc.Fields[7].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."

	WEBSOCKETInputDoc.Type = "websocket.Input"
	WEBSOCKETInputDoc.Comments[encoder.LineComment] = ""
	WEBSOCKETInputDoc.Description = ""
	WEBSOCKETInputDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "websocket.Request",
			FieldName: "inputs",
		},
	}
	WEBSOCKETInputDoc.Fields = make([]encoder.Doc, 2)
	WEBSOCKETInputDoc.Fields[0].Name = "data"
	WEBSOCKETInputDoc.Fields[0].Type = "string"
	WEBSOCKETInputDoc.Fields[0].Note = ""
	WEBSOCKETInputDoc.Fields[0].Description = "Data is the data to send as the input.\n\nIt supports DSL Helper Functions as well as normal expressions."
	WEBSOCKETInputDoc.Fields[0].Comments[encoder.LineComment] = "Data is the data to send as the input."

	WEBSOCKETInputDoc.Fields[0].AddExample("", "TEST")

	WEBSOCKETInputDoc.Fields[0].AddExample("", "hex_decode('50494e47')")
	WEBSOCKETInputDoc.Fields[1].Name = "name"
	WEBSOCKETInputDoc.Fields[1].Type = "string"
	WEBSOCKETInputDoc.Fields[1].Note = ""
	WEBSOCKETInputDoc.Fields[1].Description = "Name is the optional name of the data read to provide matching on."
	WEBSOCKETInputDoc.Fields[1].Comments[encoder.LineComment] = "Name is the optional name of the data read to provide matching on."

	WEBSOCKETInputDoc.Fields[1].AddExample("", "prefix")

	WHOISRequestDoc.Type = "whois.Request"
	WHOISRequestDoc.Comments[encoder.LineComment] = " Request is a request for the WHOIS protocol"
	WHOISRequestDoc.Description = "Request is a request for the WHOIS protocol"
	WHOISRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "whois",
		},
	}
	WHOISRequestDoc.Fields = make([]encoder.Doc, 5)
	WHOISRequestDoc.Fields[0].Name = "matchers"
	WHOISRequestDoc.Fields[0].Type = "[]matchers.Matcher"
	WHOISRequestDoc.Fields[0].Note = ""
	WHOISRequestDoc.Fields[0].Description = "Matchers contains the detection mechanism for the request to identify\nwhether the request was successful by doing pattern matching\non request/responses.\n\nMultiple matchers can be combined with `matcher-condition` flag\nwhich accepts either `and` or `or` as argument."
	WHOISRequestDoc.Fields[0].Comments[encoder.LineComment] = "Matchers contains the detection mechanism for the request to identify"
	WHOISRequestDoc.Fields[1].Name = "extractors"
	WHOISRequestDoc.Fields[1].Type = "[]extractors.Extractor"
	WHOISRequestDoc.Fields[1].Note = ""
	WHOISRequestDoc.Fields[1].Description = "Extractors contains the extraction mechanism for the request to identify\nand extract parts of the response."
	WHOISRequestDoc.Fields[1].Comments[encoder.LineComment] = "Extractors contains the extraction mechanism for the request to identify"
	WHOISRequestDoc.Fields[2].Name = "matchers-condition"
	WHOISRequestDoc.Fields[2].Type = "string"
	WHOISRequestDoc.Fields[2].Note = ""
	WHOISRequestDoc.Fields[2].Description = "MatchersCondition is the condition between the matchers. Default is OR."
	WHOISRequestDoc.Fields[2].Comments[encoder.LineComment] = "MatchersCondition is the condition between the matchers. Default is OR."
	WHOISRequestDoc.Fields[2].Values = []string{
		"and",
		"or",
	}
	WHOISRequestDoc.Fields[3].Name = "query"
	WHOISRequestDoc.Fields[3].Type = "string"
	WHOISRequestDoc.Fields[3].Note = ""
	WHOISRequestDoc.Fields[3].Description = "Query contains query for the request"
	WHOISRequestDoc.Fields[3].Comments[encoder.LineComment] = "Query contains query for the request"
	WHOISRequestDoc.Fields[4].Name = "server"
	WHOISRequestDoc.Fields[4].Type = "string"
	WHOISRequestDoc.Fields[4].Note = ""
	WHOISRequestDoc.Fields[4].Description = "description: |\n 	 Optional WHOIS server URL.\n\n 	 If present, specifies the WHOIS server to execute the Request on.\n   Otherwise, nil enables bootstrapping"
	WHOISRequestDoc.Fields[4].Comments[encoder.LineComment] = " description: |"

	WORKFLOWSWorkflowTemplateDoc.Type = "workflows.WorkflowTemplate"
	WORKFLOWSWorkflowTemplateDoc.Comments[encoder.LineComment] = ""
	WORKFLOWSWorkflowTemplateDoc.Description = ""
	WORKFLOWSWorkflowTemplateDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "workflows",
		},
		{
			TypeName:  "workflows.WorkflowTemplate",
			FieldName: "subtemplates",
		},
		{
			TypeName:  "workflows.Matcher",
			FieldName: "subtemplates",
		},
	}
	WORKFLOWSWorkflowTemplateDoc.Fields = make([]encoder.Doc, 4)
	WORKFLOWSWorkflowTemplateDoc.Fields[0].Name = "template"
	WORKFLOWSWorkflowTemplateDoc.Fields[0].Type = "string"
	WORKFLOWSWorkflowTemplateDoc.Fields[0].Note = ""
	WORKFLOWSWorkflowTemplateDoc.Fields[0].Description = "Template is a single template or directory to execute as part of workflow."
	WORKFLOWSWorkflowTemplateDoc.Fields[0].Comments[encoder.LineComment] = "Template is a single template or directory to execute as part of workflow."

	WORKFLOWSWorkflowTemplateDoc.Fields[0].AddExample("A single template", "dns/worksites-detection.yaml")

	WORKFLOWSWorkflowTemplateDoc.Fields[0].AddExample("A template directory", "misconfigurations/aem")
	WORKFLOWSWorkflowTemplateDoc.Fields[1].Name = "tags"
	WORKFLOWSWorkflowTemplateDoc.Fields[1].Type = "stringslice.StringSlice"
	WORKFLOWSWorkflowTemplateDoc.Fields[1].Note = ""
	WORKFLOWSWorkflowTemplateDoc.Fields[1].Description = "Tags to run templates based on."
	WORKFLOWSWorkflowTemplateDoc.Fields[1].Comments[encoder.LineComment] = "Tags to run templates based on."
	WORKFLOWSWorkflowTemplateDoc.Fields[2].Name = "matchers"
	WORKFLOWSWorkflowTemplateDoc.Fields[2].Type = "[]workflows.Matcher"
	WORKFLOWSWorkflowTemplateDoc.Fields[2].Note = ""
	WORKFLOWSWorkflowTemplateDoc.Fields[2].Description = "Matchers perform name based matching to run subtemplates for a workflow."
	WORKFLOWSWorkflowTemplateDoc.Fields[2].Comments[encoder.LineComment] = "Matchers perform name based matching to run subtemplates for a workflow."
	WORKFLOWSWorkflowTemplateDoc.Fields[3].Name = "subtemplates"
	WORKFLOWSWorkflowTemplateDoc.Fields[3].Type = "[]workflows.WorkflowTemplate"
	WORKFLOWSWorkflowTemplateDoc.Fields[3].Note = ""
	WORKFLOWSWorkflowTemplateDoc.Fields[3].Description = "Subtemplates are run if the `template` field Template matches."
	WORKFLOWSWorkflowTemplateDoc.Fields[3].Comments[encoder.LineComment] = "Subtemplates are run if the `template` field Template matches."

	WORKFLOWSMatcherDoc.Type = "workflows.Matcher"
	WORKFLOWSMatcherDoc.Comments[encoder.LineComment] = ""
	WORKFLOWSMatcherDoc.Description = ""
	WORKFLOWSMatcherDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "workflows.WorkflowTemplate",
			FieldName: "matchers",
		},
	}
	WORKFLOWSMatcherDoc.Fields = make([]encoder.Doc, 3)
	WORKFLOWSMatcherDoc.Fields[0].Name = "name"
	WORKFLOWSMatcherDoc.Fields[0].Type = "stringslice.StringSlice"
	WORKFLOWSMatcherDoc.Fields[0].Note = ""
	WORKFLOWSMatcherDoc.Fields[0].Description = "Name is the name of the items to match."
	WORKFLOWSMatcherDoc.Fields[0].Comments[encoder.LineComment] = "Name is the name of the items to match."
	WORKFLOWSMatcherDoc.Fields[1].Name = "condition"
	WORKFLOWSMatcherDoc.Fields[1].Type = "string"
	WORKFLOWSMatcherDoc.Fields[1].Note = ""
	WORKFLOWSMatcherDoc.Fields[1].Description = "Condition is the optional condition between names. By default,\nthe condition is assumed to be OR."
	WORKFLOWSMatcherDoc.Fields[1].Comments[encoder.LineComment] = "Condition is the optional condition between names. By default,"
	WORKFLOWSMatcherDoc.Fields[1].Values = []string{
		"and",
		"or",
	}
	WORKFLOWSMatcherDoc.Fields[2].Name = "subtemplates"
	WORKFLOWSMatcherDoc.Fields[2].Type = "[]workflows.WorkflowTemplate"
	WORKFLOWSMatcherDoc.Fields[2].Note = ""
	WORKFLOWSMatcherDoc.Fields[2].Description = "Subtemplates are run if the name of matcher matches."
	WORKFLOWSMatcherDoc.Fields[2].Comments[encoder.LineComment] = "Subtemplates are run if the name of matcher matches."

	HTTPSignatureTypeHolderDoc.Type = "http.SignatureTypeHolder"
	HTTPSignatureTypeHolderDoc.Comments[encoder.LineComment] = " SignatureTypeHolder is used to hold internal type of the signature"
	HTTPSignatureTypeHolderDoc.Description = "SignatureTypeHolder is used to hold internal type of the signature"
	HTTPSignatureTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "signature",
		},
	}
	HTTPSignatureTypeHolderDoc.Fields = make([]encoder.Doc, 0)

	VARIABLESVariableDoc.Type = "variables.Variable"
	VARIABLESVariableDoc.Comments[encoder.LineComment] = " Variable is a key-value pair of strings that can be used"
	VARIABLESVariableDoc.Description = "Variable is a key-value pair of strings that can be used\n throughout template."
	VARIABLESVariableDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "variables",
		},
	}
	VARIABLESVariableDoc.Fields = make([]encoder.Doc, 0)
}

// GetTemplateDoc returns documentation for the file templates_doc.go.
func GetTemplateDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "Template",
		Description: "",
		Structs: []*encoder.Doc{
			&TemplateDoc,
			&MODELInfoDoc,
			&STRINGSLICEStringSliceDoc,
			&SEVERITYHolderDoc,
			&MODELClassificationDoc,
			&HTTPRequestDoc,
			&MATCHERSMatcherDoc,
			&MatcherTypeHolderDoc,
			&EXTRACTORSExtractorDoc,
			&ExtractorTypeHolderDoc,
			&GENERATORSAttackTypeHolderDoc,
			&HTTPMethodTypeHolderDoc,
			&SignatureTypeHolderDoc,
			&DNSRequestDoc,
			&DNSRequestTypeHolderDoc,
			&FILERequestDoc,
			&NETWORKRequestDoc,
			&NETWORKInputDoc,
			&NetworkInputTypeHolderDoc,
			&HEADLESSRequestDoc,
			&ENGINEActionDoc,
			&ActionTypeHolderDoc,
			&USERAGENTUserAgentHolderDoc,
			&SSLRequestDoc,
			&WEBSOCKETRequestDoc,
			&WEBSOCKETInputDoc,
			&WHOISRequestDoc,
			&WORKFLOWSWorkflowTemplateDoc,
			&WORKFLOWSMatcherDoc,
			&HTTPSignatureTypeHolderDoc,
			&VARIABLESVariableDoc,
		},
	}
}
