/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.parcelize.test.runners;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/parcelize/parcelize-compiler/testData/codegen")
@TestDataPath("$PROJECT_ROOT")
public class ParcelizeBytecodeListingTestGenerated extends AbstractParcelizeBytecodeListingTest {
    @Test
    public void testAllFilesPresentInCodegen() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/parcelize/parcelize-compiler/testData/codegen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
    }

    @Test
    @TestMetadata("classLoaderValues.kt")
    public void testClassLoaderValues() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/classLoaderValues.kt");
    }

    @Test
    @TestMetadata("customDescribeContents.kt")
    public void testCustomDescribeContents() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/customDescribeContents.kt");
    }

    @Test
    @TestMetadata("customParcelablesDifferentModule.kt")
    public void testCustomParcelablesDifferentModule() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/customParcelablesDifferentModule.kt");
    }

    @Test
    @TestMetadata("customParcelablesSameModule.kt")
    public void testCustomParcelablesSameModule() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/customParcelablesSameModule.kt");
    }

    @Test
    @TestMetadata("customSimple.kt")
    public void testCustomSimple() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/customSimple.kt");
    }

    @Test
    @TestMetadata("customSimpleWithNewArray.kt")
    public void testCustomSimpleWithNewArray() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/customSimpleWithNewArray.kt");
    }

    @Test
    @TestMetadata("describeContentsFromSuperType.kt")
    public void testDescribeContentsFromSuperType() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/describeContentsFromSuperType.kt");
    }

    @Test
    @TestMetadata("duplicatingClinit.kt")
    public void testDuplicatingClinit() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/duplicatingClinit.kt");
    }

    @Test
    @TestMetadata("efficientParcelable.kt")
    public void testEfficientParcelable() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/efficientParcelable.kt");
    }

    @Test
    @TestMetadata("generics.kt")
    public void testGenerics() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/generics.kt");
    }

    @Test
    @TestMetadata("IBinderIInterface.kt")
    public void testIBinderIInterface() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/IBinderIInterface.kt");
    }

    @Test
    @TestMetadata("kt25839.kt")
    public void testKt25839() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/kt25839.kt");
    }

    @Test
    @TestMetadata("listInsideList.kt")
    public void testListInsideList() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/listInsideList.kt");
    }

    @Test
    @TestMetadata("nullableNotNullSize.kt")
    public void testNullableNotNullSize() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/nullableNotNullSize.kt");
    }

    @Test
    @TestMetadata("parcelable.kt")
    public void testParcelable() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/parcelable.kt");
    }

    @Test
    @TestMetadata("parcelableCreator.kt")
    public void testParcelableCreator() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/parcelableCreator.kt");
    }

    @Test
    @TestMetadata("serializable.kt")
    public void testSerializable() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/serializable.kt");
    }

    @Test
    @TestMetadata("serializeValue.kt")
    public void testSerializeValue() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/serializeValue.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/simple.kt");
    }

    @Test
    @TestMetadata("simpleList.kt")
    public void testSimpleList() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/simpleList.kt");
    }

    @Test
    @TestMetadata("size.kt")
    public void testSize() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/size.kt");
    }

    @Test
    @TestMetadata("unsignedPrimitiveArrays.kt")
    public void testUnsignedPrimitiveArrays() throws Exception {
        runTest("plugins/parcelize/parcelize-compiler/testData/codegen/unsignedPrimitiveArrays.kt");
    }
}
