/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.noarg;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/noarg/noarg-cli/testData/box")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IrBlackBoxCodegenTestForNoArgGenerated extends AbstractIrBlackBoxCodegenTestForNoArg {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM_IR, testDataFilePath);
    }

    public void testAllFilesPresentInBox() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/noarg/noarg-cli/testData/box"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @TestMetadata("initializers.kt")
    public void testInitializers() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/initializers.kt");
    }

    @TestMetadata("initializersWithoutInvokeInitializers.kt")
    public void testInitializersWithoutInvokeInitializers() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/initializersWithoutInvokeInitializers.kt");
    }

    @TestMetadata("kt18245.kt")
    public void testKt18245() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/kt18245.kt");
    }

    @TestMetadata("kt18667.kt")
    public void testKt18667() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/kt18667.kt");
    }

    @TestMetadata("kt18668.kt")
    public void testKt18668() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/kt18668.kt");
    }

    @TestMetadata("localClassInInitiailzer.kt")
    public void testLocalClassInInitiailzer() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/localClassInInitiailzer.kt");
    }

    @TestMetadata("nestedClass.kt")
    public void testNestedClass() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/nestedClass.kt");
    }

    @TestMetadata("sealedClassWithExistingNoargCtor.kt")
    public void testSealedClassWithExistingNoargCtor() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/sealedClassWithExistingNoargCtor.kt");
    }

    @TestMetadata("simple.kt")
    public void testSimple() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/simple.kt");
    }

    @TestMetadata("subclass.kt")
    public void testSubclass() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/box/subclass.kt");
    }
}
