/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.lombok;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/lombok/lombok-compiler-plugin/testData/compile")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class LombokCompileTestGenerated extends AbstractLombokCompileTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
    }

    @TestMetadata("accessorsStripPrefix.kt")
    public void testAccessorsStripPrefix() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/accessorsStripPrefix.kt");
    }

    @TestMetadata("accessorsStripPrefixCombined.kt")
    public void testAccessorsStripPrefixCombined() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/accessorsStripPrefixCombined.kt");
    }

    @TestMetadata("accessorsStripPrefixConfig.kt")
    public void testAccessorsStripPrefixConfig() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/accessorsStripPrefixConfig.kt");
    }

    @TestMetadata("allArgsConstructor.kt")
    public void testAllArgsConstructor() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/allArgsConstructor.kt");
    }

    @TestMetadata("allArgsConstructorStatic.kt")
    public void testAllArgsConstructorStatic() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/allArgsConstructorStatic.kt");
    }

    public void testAllFilesPresentInCompile() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/lombok/lombok-compiler-plugin/testData/compile"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @TestMetadata("clashAccessors.kt")
    public void testClashAccessors() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/clashAccessors.kt");
    }

    @TestMetadata("configAccessors.kt")
    public void testConfigAccessors() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/configAccessors.kt");
    }

    @TestMetadata("configAccessorsOverride.kt")
    public void testConfigAccessorsOverride() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/configAccessorsOverride.kt");
    }

    @TestMetadata("configCaseInsensitive.kt")
    public void testConfigCaseInsensitive() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/configCaseInsensitive.kt");
    }

    @TestMetadata("configSimple.kt")
    public void testConfigSimple() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/configSimple.kt");
    }

    @TestMetadata("data.kt")
    public void testData() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/data.kt");
    }

    @TestMetadata("genericsAccessors.kt")
    public void testGenericsAccessors() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/genericsAccessors.kt");
    }

    @TestMetadata("genericsConstructors.kt")
    public void testGenericsConstructors() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/genericsConstructors.kt");
    }

    @TestMetadata("genericsConstructorsStatic.kt")
    public void testGenericsConstructorsStatic() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/genericsConstructorsStatic.kt");
    }

    @TestMetadata("getters.kt")
    public void testGetters() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/getters.kt");
    }

    @TestMetadata("gettersClassLevel.kt")
    public void testGettersClassLevel() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/gettersClassLevel.kt");
    }

    @TestMetadata("gettersFluent.kt")
    public void testGettersFluent() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/gettersFluent.kt");
    }

    @TestMetadata("noArgsConstructor.kt")
    public void testNoArgsConstructor() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/noArgsConstructor.kt");
    }

    @TestMetadata("noArgsConstructorStatic.kt")
    public void testNoArgsConstructorStatic() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/noArgsConstructorStatic.kt");
    }

    @TestMetadata("nullability.kt")
    public void testNullability() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/nullability.kt");
    }

    @TestMetadata("propertyFromSuper.kt")
    public void testPropertyFromSuper() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/propertyFromSuper.kt");
    }

    @TestMetadata("requiredArgsConstructor.kt")
    public void testRequiredArgsConstructor() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/requiredArgsConstructor.kt");
    }

    @TestMetadata("requiredArgsConstructorStatic.kt")
    public void testRequiredArgsConstructorStatic() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/requiredArgsConstructorStatic.kt");
    }

    @TestMetadata("setters.kt")
    public void testSetters() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/setters.kt");
    }

    @TestMetadata("settersClassLevel.kt")
    public void testSettersClassLevel() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/settersClassLevel.kt");
    }

    @TestMetadata("settersVariations.kt")
    public void testSettersVariations() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/settersVariations.kt");
    }

    @TestMetadata("simple.kt")
    public void testSimple() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/simple.kt");
    }

    @TestMetadata("value.kt")
    public void testValue() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/value.kt");
    }

    @TestMetadata("with.kt")
    public void testWith() throws Exception {
        runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/with.kt");
    }

    @TestMetadata("plugins/lombok/lombok-compiler-plugin/testData/compile/processErrors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ProcessErrors extends AbstractLombokCompileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInProcessErrors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/lombok/lombok-compiler-plugin/testData/compile/processErrors"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @TestMetadata("annotationTypes.kt")
        public void testAnnotationTypes() throws Exception {
            runTest("plugins/lombok/lombok-compiler-plugin/testData/compile/processErrors/annotationTypes.kt");
        }
    }
}
