/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.kapt.cli.test;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/kapt3/kapt3-cli/testData/argumentParsing")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class ArgumentParsingTestGenerated extends AbstractArgumentParsingTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
    }

    public void testAllFilesPresentInArgumentParsing() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/kapt3/kapt3-cli/testData/argumentParsing"), Pattern.compile("^(.+)\\.txt$"), null, true);
    }

    @TestMetadata("errorFlag.txt")
    public void testErrorFlag() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/argumentParsing/errorFlag.txt");
    }

    @TestMetadata("errorKeyValue.txt")
    public void testErrorKeyValue() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/argumentParsing/errorKeyValue.txt");
    }

    @TestMetadata("errorValue.txt")
    public void testErrorValue() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/argumentParsing/errorValue.txt");
    }

    @TestMetadata("kotlincHelp.txt")
    public void testKotlincHelp() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/argumentParsing/kotlincHelp.txt");
    }

    @TestMetadata("simple.txt")
    public void testSimple() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/argumentParsing/simple.txt");
    }
}
