/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.fir.plugin.runners;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/fir-plugin-prototype/testData/diagnostics")
@TestDataPath("$PROJECT_ROOT")
public class FirPluginDiagnosticTestGenerated extends AbstractFirPluginDiagnosticTest {
    @Test
    public void testAllFilesPresentInDiagnostics() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/fir-plugin-prototype/testData/diagnostics"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Nested
    @TestMetadata("plugins/fir-plugin-prototype/testData/diagnostics/checkers")
    @TestDataPath("$PROJECT_ROOT")
    public class Checkers {
        @Test
        public void testAllFilesPresentInCheckers() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/fir-plugin-prototype/testData/diagnostics/checkers"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("signedNumbersCheckers.kt")
        public void testSignedNumbersCheckers() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/checkers/signedNumbersCheckers.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/checkers/simple.kt");
        }
    }

    @Nested
    @TestMetadata("plugins/fir-plugin-prototype/testData/diagnostics/memberGen")
    @TestDataPath("$PROJECT_ROOT")
    public class MemberGen {
        @Test
        public void testAllFilesPresentInMemberGen() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/fir-plugin-prototype/testData/diagnostics/memberGen"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("classWithCompanionObject.kt")
        public void testClassWithCompanionObject() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/memberGen/classWithCompanionObject.kt");
        }

        @Test
        @TestMetadata("classWithGeneratedMembersAndNestedClass.kt")
        public void testClassWithGeneratedMembersAndNestedClass() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/memberGen/classWithGeneratedMembersAndNestedClass.kt");
        }

        @Test
        @TestMetadata("generatedClassWithMembersAndNestedClasses.kt")
        public void testGeneratedClassWithMembersAndNestedClasses() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/memberGen/generatedClassWithMembersAndNestedClasses.kt");
        }

        @Test
        @TestMetadata("topLevelCallables.kt")
        public void testTopLevelCallables() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/memberGen/topLevelCallables.kt");
        }
    }

    @Nested
    @TestMetadata("plugins/fir-plugin-prototype/testData/diagnostics/receivers")
    @TestDataPath("$PROJECT_ROOT")
    public class Receivers {
        @Test
        public void testAllFilesPresentInReceivers() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/fir-plugin-prototype/testData/diagnostics/receivers"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("receiverInjection.kt")
        public void testReceiverInjection() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/receivers/receiverInjection.kt");
        }
    }

    @Nested
    @TestMetadata("plugins/fir-plugin-prototype/testData/diagnostics/status")
    @TestDataPath("$PROJECT_ROOT")
    public class Status {
        @Test
        public void testAllFilesPresentInStatus() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/fir-plugin-prototype/testData/diagnostics/status"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("metaAnnotation.kt")
        public void testMetaAnnotation() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/status/metaAnnotation.kt");
        }

        @Test
        @TestMetadata("simpleAnnotation.kt")
        public void testSimpleAnnotation() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/status/simpleAnnotation.kt");
        }

        @Test
        @TestMetadata("visibilityTransformation.kt")
        public void testVisibilityTransformation() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/status/visibilityTransformation.kt");
        }
    }

    @Nested
    @TestMetadata("plugins/fir-plugin-prototype/testData/diagnostics/supertypes")
    @TestDataPath("$PROJECT_ROOT")
    public class Supertypes {
        @Test
        public void testAllFilesPresentInSupertypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/fir-plugin-prototype/testData/diagnostics/supertypes"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("plugins/fir-plugin-prototype/testData/diagnostics/supertypes/simple.kt");
        }
    }
}
