/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlinx.atomicfu;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/atomicfu/atomicfu-compiler/testData/box")
@TestDataPath("$PROJECT_ROOT")
public class AtomicfuJsIrTestGenerated extends AbstractAtomicfuJsIrTest {
    @Test
    public void testAllFilesPresentInBox() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("plugins/atomicfu/atomicfu-compiler/testData/box"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JS_IR, true);
    }

    @Test
    @TestMetadata("ArithmeticTest.kt")
    public void testArithmeticTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/ArithmeticTest.kt");
    }

    @Test
    @TestMetadata("ArrayInlineFunctionTest.kt")
    public void testArrayInlineFunctionTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/ArrayInlineFunctionTest.kt");
    }

    @Test
    @TestMetadata("AtomicArrayTest.kt")
    public void testAtomicArrayTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/AtomicArrayTest.kt");
    }

    @Test
    @TestMetadata("DelegatedPropertiesTest.kt")
    public void testDelegatedPropertiesTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/DelegatedPropertiesTest.kt");
    }

    @Test
    @TestMetadata("ExtensionsTest.kt")
    public void testExtensionsTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/ExtensionsTest.kt");
    }

    @Test
    @TestMetadata("IndexArrayElementGetterTest.kt")
    public void testIndexArrayElementGetterTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/IndexArrayElementGetterTest.kt");
    }

    @Test
    @TestMetadata("InlineExtensionWithTypeParameterTest.kt")
    public void testInlineExtensionWithTypeParameterTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/InlineExtensionWithTypeParameterTest.kt");
    }

    @Test
    @TestMetadata("LockFreeIntBitsTest.kt")
    public void testLockFreeIntBitsTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/LockFreeIntBitsTest.kt");
    }

    @Test
    @TestMetadata("LockFreeLongCounterTest.kt")
    public void testLockFreeLongCounterTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/LockFreeLongCounterTest.kt");
    }

    @Test
    @TestMetadata("LockFreeQueueTest.kt")
    public void testLockFreeQueueTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/LockFreeQueueTest.kt");
    }

    @Test
    @TestMetadata("LockFreeStackTest.kt")
    public void testLockFreeStackTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/LockFreeStackTest.kt");
    }

    @Test
    @TestMetadata("LockTest.kt")
    public void testLockTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/LockTest.kt");
    }

    @Test
    @TestMetadata("LoopTest.kt")
    public void testLoopTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/LoopTest.kt");
    }

    @Test
    @TestMetadata("MultiInitTest.kt")
    public void testMultiInitTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/MultiInitTest.kt");
    }

    @Test
    @TestMetadata("ParameterizedInlineFunExtensionTest.kt")
    public void testParameterizedInlineFunExtensionTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/ParameterizedInlineFunExtensionTest.kt");
    }

    @Test
    @TestMetadata("PropertyDeclarationTest.kt")
    public void testPropertyDeclarationTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/PropertyDeclarationTest.kt");
    }

    @Test
    @TestMetadata("ReentrantLockTest.kt")
    public void testReentrantLockTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/ReentrantLockTest.kt");
    }

    @Test
    @TestMetadata("ScopeTest.kt")
    public void testScopeTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/ScopeTest.kt");
    }

    @Test
    @TestMetadata("SimpleLockTest.kt")
    public void testSimpleLockTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/SimpleLockTest.kt");
    }

    @Test
    @TestMetadata("SynchronizedObjectTest.kt")
    public void testSynchronizedObjectTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/SynchronizedObjectTest.kt");
    }

    @Test
    @TestMetadata("TopLevelTest.kt")
    public void testTopLevelTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/TopLevelTest.kt");
    }

    @Test
    @TestMetadata("TraceTest.kt")
    public void testTraceTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/TraceTest.kt");
    }

    @Test
    @TestMetadata("UncheckedCastTest.kt")
    public void testUncheckedCastTest() throws Exception {
        runTest("plugins/atomicfu/atomicfu-compiler/testData/box/UncheckedCastTest.kt");
    }
}
