/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.konan.blackboxtest;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.konan.blackboxtest.support.EnforcedProperty;
import org.jetbrains.kotlin.konan.blackboxtest.support.ClassLevelProperty;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/klibABI")
@TestDataPath("$PROJECT_ROOT")
@EnforcedProperty(property = ClassLevelProperty.CACHE_MODE, propertyValue = "NO")
public class KlibABITestGenerated extends AbstractNativeKlibABITest {
    @Test
    public void testAllFilesPresentInKlibABI() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klibABI"), Pattern.compile("^([^_](.+))$"), null, false);
    }

    @Test
    @TestMetadata("removeClassAsParameterType")
    public void testRemoveClassAsParameterType() throws Exception {
        runTest("compiler/testData/klibABI/removeClassAsParameterType/");
    }

    @Test
    @TestMetadata("removeClassAsReturnType")
    public void testRemoveClassAsReturnType() throws Exception {
        runTest("compiler/testData/klibABI/removeClassAsReturnType/");
    }

    @Test
    @TestMetadata("removeClassAsSuperTypeArgument")
    public void testRemoveClassAsSuperTypeArgument() throws Exception {
        runTest("compiler/testData/klibABI/removeClassAsSuperTypeArgument/");
    }

    @Test
    @TestMetadata("removeClassAsTypeArgument")
    public void testRemoveClassAsTypeArgument() throws Exception {
        runTest("compiler/testData/klibABI/removeClassAsTypeArgument/");
    }

    @Test
    @TestMetadata("removeFunction")
    public void testRemoveFunction() throws Exception {
        runTest("compiler/testData/klibABI/removeFunction/");
    }
}
