/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package test.math

//
// NOTE: THIS FILE IS AUTO-GENERATED by the mathTestGeneratorMain.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import kotlin.math.*
import kotlin.test.*



class TrigonometryTest {
    private val arguments = arrayOf(
        0xfff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
        0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x3da5fd7fe1796495UL, 
        0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
        0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
        0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
        0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
        0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0xbff0000000000000UL, 
        0xbfeffffffffea028UL,     0xbff000000000afecUL,     0xbfe0000000000000UL,     0xc000000000000000UL, 
        0xbfd0000000000000UL,     0xc010000000000000UL,     0x400921fb54442d18UL,     0x400921fb5444850eUL, 
        0x400921fb5443d522UL,     0x3ff921fb54442d18UL,     0x401921fb54442d18UL,     0x3fe921fb54442d18UL, 
        0x402921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb5443d522UL,     0xc00921fb5444850eUL, 
        0xbff921fb54442d18UL,     0xc01921fb54442d18UL,     0xbfe921fb54442d18UL,     0xc02921fb54442d18UL, 
    
    )
    
    
    @Test
    fun testSin() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x1UL,     0x3f7452fc98b34e97UL, 
            0x7ff8000000000000UL,     0x3fedcf338109c34bUL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3feaed548f090ceeUL,     0x3feaed548f09cb08UL,     0x3feaed548f084ed4UL,     0x3fdeaee8744b05f0UL, 
            0x3fed18f6ead1b446UL,     0x3fcfaaeed4f31577UL,     0xbfe837b9dddc1eaeUL,     0xbfeaed548f090ceeUL, 
            0xbfeaed548f084ed4UL,     0xbfeaed548f09cb08UL,     0xbfdeaee8744b05f0UL,     0xbfed18f6ead1b446UL, 
            0xbfcfaaeed4f31577UL,     0x3fe837b9dddc1eaeUL,     0x3ca1a62633145c07UL,     0xbda5fd6e59d9ccecUL, 
            0x3da5fd91a6263314UL,     0x3ff0000000000000UL,     0xbcb1a62633145c07UL,     0x3fe6a09e667f3bccUL, 
            0xbcc1a62633145c07UL,     0xbca1a62633145c07UL,     0xbda5fd91a6263314UL,     0x3da5fd6e59d9ccecUL, 
            0xbff0000000000000UL,     0x3cb1a62633145c07UL,     0xbfe6a09e667f3bccUL,     0x3cc1a62633145c07UL, 
    
        )
    
    
        checkAnswers(::sin, arguments, answers, true)
    }
    
    @Test
    fun testCos() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0xbfefffe62ecfab75UL, 
            0x7ff8000000000000UL,     0x3fd745ba83a7adcaUL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3fe14a280fb5068cUL,     0x3fe14a280fb3de7bUL,     0x3fe14a280fb62e9dUL,     0x3fec1528065b7d50UL, 
            0xbfdaa22657537205UL,     0x3fef01549f7deea1UL,     0xbfe4eaa606db24c1UL,     0x3fe14a280fb5068cUL, 
            0x3fe14a280fb62e9dUL,     0x3fe14a280fb3de7bUL,     0x3fec1528065b7d50UL,     0xbfdaa22657537205UL, 
            0x3fef01549f7deea1UL,     0xbfe4eaa606db24c1UL,     0xbff0000000000000UL,     0xbff0000000000000UL, 
            0xbff0000000000000UL,     0x3c91a62633145c07UL,     0x3ff0000000000000UL,     0x3fe6a09e667f3bcdUL, 
            0x3ff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL, 
            0x3c91a62633145c07UL,     0x3ff0000000000000UL,     0x3fe6a09e667f3bcdUL,     0x3ff0000000000000UL, 
    
        )
    
    
        checkAnswers(::cos, arguments, answers, true)
    }
    
    @Test
    fun testTan() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x1UL,     0xbf74530cfe729484UL, 
            0x7ff8000000000000UL,     0x40047e879c4b7f73UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3ff8eb245cbee3a6UL,     0x3ff8eb245cc13e45UL,     0x3ff8eb245cbc8906UL,     0x3fe17b4f5bf3474aUL, 
            0xc0017af62e0950f8UL,     0x3fd05785a43c4c56UL,     0x3ff2866f9be4de13UL,     0xbff8eb245cbee3a6UL, 
            0xbff8eb245cbc8906UL,     0xbff8eb245cc13e45UL,     0xbfe17b4f5bf3474aUL,     0x40017af62e0950f8UL, 
            0xbfd05785a43c4c56UL,     0xbff2866f9be4de13UL,     0xbca1a62633145c07UL,     0x3da5fd6e59d9ccecUL, 
            0xbda5fd91a6263314UL,     0x434d02967c31cdb5UL,     0xbcb1a62633145c07UL,     0x3fefffffffffffffUL, 
            0xbcc1a62633145c07UL,     0x3ca1a62633145c07UL,     0x3da5fd91a6263314UL,     0xbda5fd6e59d9ccecUL, 
            0xc34d02967c31cdb5UL,     0x3cb1a62633145c07UL,     0xbfefffffffffffffUL,     0x3cc1a62633145c07UL, 
    
        )
    
    
        checkAnswers(::tan, arguments, answers, false)
    }
    
    @Test
    fun testAsin() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x1UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3ff921fb54442d18UL,     0x7ff8000000000000UL,     0x3ff921f6a3c9521bUL,     0x3fe0c152382d7366UL, 
            0x7ff8000000000000UL,     0x3fd02be9ce0b87cdUL,     0x7ff8000000000000UL,     0xbff921fb54442d18UL, 
            0xbff921f6a3c9521bUL,     0x7ff8000000000000UL,     0xbfe0c152382d7366UL,     0x7ff8000000000000UL, 
            0xbfd02be9ce0b87cdUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3fece8276c3e139cUL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xbfece8276c3e139cUL,     0x7ff8000000000000UL, 
    
        )
    
    
        checkAnswers(::asin, arguments, answers, true)
    }
    
    @Test
    fun testAtan() {
        val answers = arrayOf(
            0xbff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x1UL,     0x3ff921fb54442d18UL, 
            0x7ff8000000000000UL,     0x3ff921fb54442d18UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3fe921fb54442d18UL,     0x3fe921fb5444dd04UL,     0x3fe921fb54437d2cUL,     0x3fddac670561bb4fUL, 
            0x3ff1b6e192ebbe44UL,     0x3fcf5b75f92c80ddUL,     0x3ff5368c951e9cfdUL,     0xbfe921fb54442d18UL, 
            0xbfe921fb54437d2cUL,     0xbfe921fb5444dd04UL,     0xbfddac670561bb4fUL,     0xbff1b6e192ebbe44UL, 
            0xbfcf5b75f92c80ddUL,     0xbff5368c951e9cfdUL,     0x3ff433b8a322ddd2UL,     0x3ff433b8a322ee02UL, 
            0x3ff433b8a322cda3UL,     0x3ff00fe987ed02ffUL,     0x3ff69b8154baf42eUL,     0x3fe54e04c05d06a0UL, 
            0x3ff7dcb7c5c399ecUL,     0xbff433b8a322ddd2UL,     0xbff433b8a322cda3UL,     0xbff433b8a322ee02UL, 
            0xbff00fe987ed02ffUL,     0xbff69b8154baf42eUL,     0xbfe54e04c05d06a0UL,     0xbff7dcb7c5c399ecUL, 
    
        )
    
    
        checkAnswers(::atan, arguments, answers, true)
    }
    
    @Test
    fun testAtan2() {
        val answers = arrayOf(
            0xc002d97c7f3321d2UL,     0xbfe921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0x7ff8000000000000UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0x4002d97c7f3321d2UL,     0x3fe921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x7ff8000000000000UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3fe921fb54442d18UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff921fb54442d18UL,     0x174876e800UL, 
            0x400921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x174876e800UL,     0x400921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x1UL,     0x1UL,     0x1UL,     0x2UL, 
            0x0UL,     0x4UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x0UL,     0x0UL, 
            0x0UL,     0x1UL,     0x0UL,     0x1UL, 
            0x0UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x3fe921fb54442d18UL, 
            0x7ff8000000000000UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d19UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d19UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d19UL, 
            0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL, 
            0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL, 
            0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x2a83b03385a2fc08UL, 
            0x7ff8000000000000UL,     0x3fe921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d19UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d19UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d19UL, 
            0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL, 
            0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL, 
            0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL,     0x3ff921fb54442d19UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x2bfbUL, 
            0x7ff8000000000000UL,     0x1311dee714150ee9UL,     0x3ff921fb54442d18UL,     0x3fe921fb54442d18UL, 
            0x4002d97c7f3321d2UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3fe921fb54442d18UL,     0x4002d97c7f3321d2UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe17872ccUL,     0x3da5fd7fe17a565eUL,     0x3db5fd7fe1796495UL, 
            0x3d95fd7fe1796495UL,     0x3dc5fd7fe1796495UL,     0x3d85fd7fe1796495UL,     0x400921fb5443d522UL, 
            0x400921fb5443d522UL,     0x400921fb5443d522UL,     0x400921fb54437d2cUL,     0x400921fb5444011dUL, 
            0x400921fb5442cd40UL,     0x400921fb5444171bUL,     0x3d8bffb390866e47UL,     0x3d8bffb390860c49UL, 
            0x3d8bffb39086d045UL,     0x3d9bffb390866e47UL,     0x3d7bffb390866e47UL,     0x3dabffb390866e47UL, 
            0x3d6bffb390866e47UL,     0x400921fb54441119UL,     0x400921fb54441119UL,     0x400921fb54441119UL, 
            0x400921fb5443f519UL,     0x400921fb54441f18UL,     0x400921fb5443bd19UL,     0x400921fb54442618UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8000000000002bfbUL, 
            0x7ff8000000000000UL,     0x9311dee714150ee9UL,     0xbff921fb54442d18UL,     0xbfe921fb54442d18UL, 
            0xc002d97c7f3321d2UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbfe921fb54442d18UL,     0xc002d97c7f3321d2UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbda5fd7fe1796495UL,     0xbda5fd7fe17872ccUL,     0xbda5fd7fe17a565eUL,     0xbdb5fd7fe1796495UL, 
            0xbd95fd7fe1796495UL,     0xbdc5fd7fe1796495UL,     0xbd85fd7fe1796495UL,     0xc00921fb5443d522UL, 
            0xc00921fb5443d522UL,     0xc00921fb5443d522UL,     0xc00921fb54437d2cUL,     0xc00921fb5444011dUL, 
            0xc00921fb5442cd40UL,     0xc00921fb5444171bUL,     0xbd8bffb390866e47UL,     0xbd8bffb390860c49UL, 
            0xbd8bffb39086d045UL,     0xbd9bffb390866e47UL,     0xbd7bffb390866e47UL,     0xbdabffb390866e47UL, 
            0xbd6bffb390866e47UL,     0xc00921fb54441119UL,     0xc00921fb54441119UL,     0xc00921fb54441119UL, 
            0xc00921fb5443f519UL,     0xc00921fb54441f18UL,     0xc00921fb5443bd19UL,     0xc00921fb54442618UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x400921fb54442d18UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL,     0x400921fb54442d18UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x7ff8000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x2bfbUL, 
            0x7ff8000000000000UL,     0x1311dee714150ee9UL,     0x3ff921fb54442d18UL,     0x3fe921fb54442d18UL, 
            0x4002d97c7f3321d2UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3fe921fb54442d18UL,     0x4002d97c7f3321d2UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe17872ccUL,     0x3da5fd7fe17a565eUL,     0x3db5fd7fe1796495UL, 
            0x3d95fd7fe1796495UL,     0x3dc5fd7fe1796495UL,     0x3d85fd7fe1796495UL,     0x400921fb5443d522UL, 
            0x400921fb5443d522UL,     0x400921fb5443d522UL,     0x400921fb54437d2cUL,     0x400921fb5444011dUL, 
            0x400921fb5442cd40UL,     0x400921fb5444171bUL,     0x3d8bffb390866e47UL,     0x3d8bffb390860c49UL, 
            0x3d8bffb39086d045UL,     0x3d9bffb390866e47UL,     0x3d7bffb390866e47UL,     0x3dabffb390866e47UL, 
            0x3d6bffb390866e47UL,     0x400921fb54441119UL,     0x400921fb54441119UL,     0x400921fb54441119UL, 
            0x400921fb5443f519UL,     0x400921fb54441f18UL,     0x400921fb5443bd19UL,     0x400921fb54442618UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8000000000002bfbUL, 
            0x7ff8000000000000UL,     0x9311dee714150ee9UL,     0xbff921fb54442d18UL,     0xbfe921fb54442d18UL, 
            0xc002d97c7f3321d2UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbfe921fb54442d18UL,     0xc002d97c7f3321d2UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbda5fd7fe1796495UL,     0xbda5fd7fe17872ccUL,     0xbda5fd7fe17a565eUL,     0xbdb5fd7fe1796495UL, 
            0xbd95fd7fe1796495UL,     0xbdc5fd7fe1796495UL,     0xbd85fd7fe1796495UL,     0xc00921fb5443d522UL, 
            0xc00921fb5443d522UL,     0xc00921fb5443d522UL,     0xc00921fb54437d2cUL,     0xc00921fb5444011dUL, 
            0xc00921fb5442cd40UL,     0xc00921fb5444171bUL,     0xbd8bffb390866e47UL,     0xbd8bffb390860c49UL, 
            0xbd8bffb39086d045UL,     0xbd9bffb390866e47UL,     0xbd7bffb390866e47UL,     0xbdabffb390866e47UL, 
            0xbd6bffb390866e47UL,     0xc00921fb54441119UL,     0xc00921fb54441119UL,     0xc00921fb54441119UL, 
            0xc00921fb5443f519UL,     0xc00921fb54441f18UL,     0xc00921fb5443bd19UL,     0xc00921fb54442618UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x7ff8000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x7ff8000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x7ff8000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x7ff8000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL,     0xc00921fb54442d18UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x4000000000000UL, 
            0x7ff8000000000000UL,     0x155a015c0bc0eef1UL,     0x3ff921fb54442d18UL,     0x3ff921fb54437d2cUL, 
            0x3ff921fb5444dd05UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54437d2cUL,     0x3ff921fb5444dd05UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3fe921fb54442d18UL,     0x3fe921fb54437d2cUL,     0x3fe921fb5444dd04UL,     0x3ff1b6e192ebbe44UL, 
            0x3fddac670561bb4fUL,     0x3ff5368c951e9cfdUL,     0x3fcf5b75f92c80ddUL,     0x4002d97c7f3321d2UL, 
            0x4002d97c7f32f5d7UL,     0x4002d97c7f334dcdUL,     0x4000468a8ace4df6UL,     0x40056c6e7397f5aeUL, 
            0x3ffd0d6a1369bd34UL,     0x40072c43f4b1650aUL,     0x3fd3b90ac4853d17UL,     0x3fd3b90ac484fc59UL, 
            0x3fd3b90ac4857dd4UL,     0x3fe2242398ae5432UL,     0x3fc433cffc49c751UL,     0x3fecf5f1e82b5390UL, 
            0x3fb45438e80932c3UL,     0x4006aad9fbb38575UL,     0x4006aad9fbb37d5eUL,     0x4006aad9fbb38d8dUL, 
            0x400498f26e18980cUL,     0x4007debe547f90a3UL,     0x4001e47eda395834UL,     0x40087f598d03e382UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x4000000002bfbUL, 
            0x7ff8000000000000UL,     0x155a015c0bc20cdfUL,     0x3ff921fb54442d18UL,     0x3ff921fb54437d2cUL, 
            0x3ff921fb5444dd05UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54437d2cUL,     0x3ff921fb5444dd05UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3fe921fb5444dd04UL,     0x3fe921fb54442d18UL,     0x3fe921fb54458cf0UL,     0x3ff1b6e192ec04a3UL, 
            0x3fddac670562d4c9UL,     0x3ff5368c951ec661UL,     0x3fcf5b75f92dcc03UL,     0x4002d97c7f32f5d7UL, 
            0x4002d97c7f32c9dcUL,     0x4002d97c7f3321d2UL,     0x4000468a8ace2ac7UL,     0x40056c6e7397d27fUL, 
            0x3ffd0d6a136993d0UL,     0x40072c43f4b15058UL,     0x3fd3b90ac4860878UL,     0x3fd3b90ac485c7bcUL, 
            0x3fd3b90ac4864936UL,     0x3fe2242398aef396UL,     0x3fc433cffc4aa1c6UL,     0x3fecf5f1e82bfe79UL, 
            0x3fb45438e80a1158UL,     0x4006aad9fbb36c09UL,     0x4006aad9fbb363f2UL,     0x4006aad9fbb37421UL, 
            0x400498f26e187033UL,     0x4007debe547f82fcUL,     0x4001e47eda392d7aUL,     0x40087f598d03dc8eUL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x3ffffffffd405UL, 
            0x7ff8000000000000UL,     0x155a015c0bbfd103UL,     0x3ff921fb54442d18UL,     0x3ff921fb54437d2cUL, 
            0x3ff921fb5444dd05UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54437d2cUL,     0x3ff921fb5444dd05UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3fe921fb54437d2cUL,     0x3fe921fb5442cd40UL,     0x3fe921fb54442d18UL,     0x3ff1b6e192eb77e6UL, 
            0x3fddac670560a1d6UL,     0x3ff5368c951e7398UL,     0x3fcf5b75f92b35b8UL,     0x4002d97c7f334dcdUL, 
            0x4002d97c7f3321d2UL,     0x4002d97c7f3379c8UL,     0x4000468a8ace7126UL,     0x40056c6e739818deUL, 
            0x3ffd0d6a1369e699UL,     0x40072c43f4b179bdUL,     0x3fd3b90ac48471b4UL,     0x3fd3b90ac48430f8UL, 
            0x3fd3b90ac484b272UL,     0x3fe2242398adb4ceUL,     0x3fc433cffc48ecdcUL,     0x3fecf5f1e82aa8a7UL, 
            0x3fb45438e808542eUL,     0x4006aad9fbb39ee2UL,     0x4006aad9fbb396caUL,     0x4006aad9fbb3a6f9UL, 
            0x400498f26e18bfe5UL,     0x4007debe547f9e4aUL,     0x4001e47eda3982eeUL,     0x40087f598d03ea77UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x2000000000000UL, 
            0x7ff8000000000000UL,     0x154a015c0bc0eef1UL,     0x3ff921fb54442d18UL,     0x3ff921fb5442cd40UL, 
            0x3ff921fb54458cf1UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb5442cd40UL,     0x3ff921fb54458cf1UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3fddac670561bb4fUL,     0x3fddac670560a1d6UL,     0x3fddac670562d4c9UL,     0x3fe921fb54442d18UL, 
            0x3fcf5b75f92c80ddUL,     0x3ff1b6e192ebbe44UL,     0x3fbfd5ba9aac2f6eUL,     0x40056c6e7397f5aeUL, 
            0x40056c6e7397d27fUL,     0x40056c6e739818deUL,     0x4002d97c7f3321d2UL,     0x40072c43f4b1650aUL, 
            0x4000468a8ace4df6UL,     0x4008234d7f6ecb9dUL,     0x3fc433cffc49c751UL,     0x3fc433cffc4981c7UL, 
            0x3fc433cffc4a0cdaUL,     0x3fd3b90ac4853d17UL,     0x3fb45438e80932c3UL,     0x3fe2242398ae5432UL, 
            0x3fa45c708d443772UL,     0x4007debe547f90a3UL,     0x4007debe547f8c4bUL,     0x4007debe547f94fcUL, 
            0x4006aad9fbb38575UL,     0x40087f598d03e382UL,     0x400498f26e18980cUL,     0x4008d089920f1c3aUL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x8000000000000UL, 
            0x7ff8000000000000UL,     0x156a015c0bc0eef1UL,     0x3ff921fb54442d18UL,     0x3ff921fb5443d522UL, 
            0x3ff921fb5444850fUL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb5443d522UL,     0x3ff921fb5444850fUL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff1b6e192ebbe44UL,     0x3ff1b6e192eb77e6UL,     0x3ff1b6e192ec04a3UL,     0x3ff5368c951e9cfdUL, 
            0x3fe921fb54442d18UL,     0x3ff7249faa996a21UL,     0x3fddac670561bb4fUL,     0x4000468a8ace4df6UL, 
            0x4000468a8ace2ac7UL,     0x4000468a8ace7126UL,     0x3ffd0d6a1369bd34UL,     0x4002d97c7f3321d2UL, 
            0x3ffb1f56fdeef010UL,     0x40056c6e7397f5aeUL,     0x3fe2242398ae5432UL,     0x3fe2242398ae2175UL, 
            0x3fe2242398ae86eeUL,     0x3fecf5f1e82b5390UL,     0x3fd3b90ac4853d17UL,     0x3ff32545abb24f20UL, 
            0x3fc433cffc49c751UL,     0x400498f26e18980cUL,     0x400498f26e188b5dUL,     0x400498f26e18a4bbUL, 
            0x4001e47eda395834UL,     0x4006aad9fbb38575UL,     0x3fff1eb0fcd60b11UL,     0x4007debe547f90a3UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x1000000000000UL, 
            0x7ff8000000000000UL,     0x153a015c0bc0eef1UL,     0x3ff921fb54442d18UL,     0x3ff921fb54416d68UL, 
            0x3ff921fb5446ecc9UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54416d68UL,     0x3ff921fb5446ecc9UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3fcf5b75f92c80ddUL,     0x3fcf5b75f92b35b8UL,     0x3fcf5b75f92dcc03UL,     0x3fddac670561bb4fUL, 
            0x3fbfd5ba9aac2f6eUL,     0x3fe921fb54442d18UL,     0x3faff55bb72cfdeaUL,     0x40072c43f4b1650aUL, 
            0x40072c43f4b15058UL,     0x40072c43f4b179bdUL,     0x40056c6e7397f5aeUL,     0x4008234d7f6ecb9dUL, 
            0x4002d97c7f3321d2UL,     0x4008a225e5677921UL,     0x3fb45438e80932c3UL,     0x3fb45438e808ebe9UL, 
            0x3fb45438e809799dUL,     0x3fc433cffc49c751UL,     0x3fa45c708d443772UL,     0x3fd3b90ac4853d17UL, 
            0x3f945e8055946782UL,     0x40087f598d03e382UL,     0x40087f598d03e14bUL,     0x40087f598d03e5b9UL, 
            0x4007debe547f90a3UL,     0x4008d089920f1c3aUL,     0x4006aad9fbb38575UL,     0x4008f93e53990449UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x10000000000001UL, 
            0x7ff8000000000000UL,     0x157a015c0bc0eef1UL,     0x3ff921fb54442d18UL,     0x3ff921fb5444011dUL, 
            0x3ff921fb54445914UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb5444011dUL,     0x3ff921fb54445914UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff5368c951e9cfdUL,     0x3ff5368c951e7398UL,     0x3ff5368c951ec661UL,     0x3ff7249faa996a21UL, 
            0x3ff1b6e192ebbe44UL,     0x3ff82250768ac529UL,     0x3fe921fb54442d18UL,     0x3ffd0d6a1369bd34UL, 
            0x3ffd0d6a136993d0UL,     0x3ffd0d6a1369e699UL,     0x3ffb1f56fdeef010UL,     0x4000468a8ace4df6UL, 
            0x3ffa21a631fd9508UL,     0x4002d97c7f3321d2UL,     0x3fecf5f1e82b5390UL,     0x3fecf5f1e82b1d29UL, 
            0x3fecf5f1e82b89f7UL,     0x3ff32545abb24f20UL,     0x3fe2242398ae5432UL,     0x3ff607d636e70256UL, 
            0x3fd3b90ac4853d17UL,     0x4001e47eda395834UL,     0x4001e47eda394a9aUL,     0x4001e47eda3965ceUL, 
            0x3fff1eb0fcd60b11UL,     0x400498f26e18980cUL,     0x3ffc3c2071a157dbUL,     0x4006aad9fbb38575UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8004000000000000UL, 
            0x7ff8000000000000UL,     0x955a015c0bc0eef1UL,     0xbff921fb54442d18UL,     0xbff921fb54437d2cUL, 
            0xbff921fb5444dd05UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54437d2cUL,     0xbff921fb5444dd05UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbfe921fb54442d18UL,     0xbfe921fb54437d2cUL,     0xbfe921fb5444dd04UL,     0xbff1b6e192ebbe44UL, 
            0xbfddac670561bb4fUL,     0xbff5368c951e9cfdUL,     0xbfcf5b75f92c80ddUL,     0xc002d97c7f3321d2UL, 
            0xc002d97c7f32f5d7UL,     0xc002d97c7f334dcdUL,     0xc000468a8ace4df6UL,     0xc0056c6e7397f5aeUL, 
            0xbffd0d6a1369bd34UL,     0xc0072c43f4b1650aUL,     0xbfd3b90ac4853d17UL,     0xbfd3b90ac484fc59UL, 
            0xbfd3b90ac4857dd4UL,     0xbfe2242398ae5432UL,     0xbfc433cffc49c751UL,     0xbfecf5f1e82b5390UL, 
            0xbfb45438e80932c3UL,     0xc006aad9fbb38575UL,     0xc006aad9fbb37d5eUL,     0xc006aad9fbb38d8dUL, 
            0xc00498f26e18980cUL,     0xc007debe547f90a3UL,     0xc001e47eda395834UL,     0xc0087f598d03e382UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8003ffffffffd405UL, 
            0x7ff8000000000000UL,     0x955a015c0bbfd103UL,     0xbff921fb54442d18UL,     0xbff921fb54437d2cUL, 
            0xbff921fb5444dd05UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54437d2cUL,     0xbff921fb5444dd05UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbfe921fb54437d2cUL,     0xbfe921fb5442cd40UL,     0xbfe921fb54442d18UL,     0xbff1b6e192eb77e6UL, 
            0xbfddac670560a1d6UL,     0xbff5368c951e7398UL,     0xbfcf5b75f92b35b8UL,     0xc002d97c7f334dcdUL, 
            0xc002d97c7f3321d2UL,     0xc002d97c7f3379c8UL,     0xc000468a8ace7126UL,     0xc0056c6e739818deUL, 
            0xbffd0d6a1369e699UL,     0xc0072c43f4b179bdUL,     0xbfd3b90ac48471b4UL,     0xbfd3b90ac48430f8UL, 
            0xbfd3b90ac484b272UL,     0xbfe2242398adb4ceUL,     0xbfc433cffc48ecdcUL,     0xbfecf5f1e82aa8a7UL, 
            0xbfb45438e808542eUL,     0xc006aad9fbb39ee2UL,     0xc006aad9fbb396caUL,     0xc006aad9fbb3a6f9UL, 
            0xc00498f26e18bfe5UL,     0xc007debe547f9e4aUL,     0xc001e47eda3982eeUL,     0xc0087f598d03ea77UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8004000000002bfbUL, 
            0x7ff8000000000000UL,     0x955a015c0bc20cdfUL,     0xbff921fb54442d18UL,     0xbff921fb54437d2cUL, 
            0xbff921fb5444dd05UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54437d2cUL,     0xbff921fb5444dd05UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbfe921fb5444dd04UL,     0xbfe921fb54442d18UL,     0xbfe921fb54458cf0UL,     0xbff1b6e192ec04a3UL, 
            0xbfddac670562d4c9UL,     0xbff5368c951ec661UL,     0xbfcf5b75f92dcc03UL,     0xc002d97c7f32f5d7UL, 
            0xc002d97c7f32c9dcUL,     0xc002d97c7f3321d2UL,     0xc000468a8ace2ac7UL,     0xc0056c6e7397d27fUL, 
            0xbffd0d6a136993d0UL,     0xc0072c43f4b15058UL,     0xbfd3b90ac4860878UL,     0xbfd3b90ac485c7bcUL, 
            0xbfd3b90ac4864936UL,     0xbfe2242398aef396UL,     0xbfc433cffc4aa1c6UL,     0xbfecf5f1e82bfe79UL, 
            0xbfb45438e80a1158UL,     0xc006aad9fbb36c09UL,     0xc006aad9fbb363f2UL,     0xc006aad9fbb37421UL, 
            0xc00498f26e187033UL,     0xc007debe547f82fcUL,     0xc001e47eda392d7aUL,     0xc0087f598d03dc8eUL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8002000000000000UL, 
            0x7ff8000000000000UL,     0x954a015c0bc0eef1UL,     0xbff921fb54442d18UL,     0xbff921fb5442cd40UL, 
            0xbff921fb54458cf1UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb5442cd40UL,     0xbff921fb54458cf1UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbfddac670561bb4fUL,     0xbfddac670560a1d6UL,     0xbfddac670562d4c9UL,     0xbfe921fb54442d18UL, 
            0xbfcf5b75f92c80ddUL,     0xbff1b6e192ebbe44UL,     0xbfbfd5ba9aac2f6eUL,     0xc0056c6e7397f5aeUL, 
            0xc0056c6e7397d27fUL,     0xc0056c6e739818deUL,     0xc002d97c7f3321d2UL,     0xc0072c43f4b1650aUL, 
            0xc000468a8ace4df6UL,     0xc008234d7f6ecb9dUL,     0xbfc433cffc49c751UL,     0xbfc433cffc4981c7UL, 
            0xbfc433cffc4a0cdaUL,     0xbfd3b90ac4853d17UL,     0xbfb45438e80932c3UL,     0xbfe2242398ae5432UL, 
            0xbfa45c708d443772UL,     0xc007debe547f90a3UL,     0xc007debe547f8c4bUL,     0xc007debe547f94fcUL, 
            0xc006aad9fbb38575UL,     0xc0087f598d03e382UL,     0xc00498f26e18980cUL,     0xc008d089920f1c3aUL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8008000000000000UL, 
            0x7ff8000000000000UL,     0x956a015c0bc0eef1UL,     0xbff921fb54442d18UL,     0xbff921fb5443d522UL, 
            0xbff921fb5444850fUL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb5443d522UL,     0xbff921fb5444850fUL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff1b6e192ebbe44UL,     0xbff1b6e192eb77e6UL,     0xbff1b6e192ec04a3UL,     0xbff5368c951e9cfdUL, 
            0xbfe921fb54442d18UL,     0xbff7249faa996a21UL,     0xbfddac670561bb4fUL,     0xc000468a8ace4df6UL, 
            0xc000468a8ace2ac7UL,     0xc000468a8ace7126UL,     0xbffd0d6a1369bd34UL,     0xc002d97c7f3321d2UL, 
            0xbffb1f56fdeef010UL,     0xc0056c6e7397f5aeUL,     0xbfe2242398ae5432UL,     0xbfe2242398ae2175UL, 
            0xbfe2242398ae86eeUL,     0xbfecf5f1e82b5390UL,     0xbfd3b90ac4853d17UL,     0xbff32545abb24f20UL, 
            0xbfc433cffc49c751UL,     0xc00498f26e18980cUL,     0xc00498f26e188b5dUL,     0xc00498f26e18a4bbUL, 
            0xc001e47eda395834UL,     0xc006aad9fbb38575UL,     0xbfff1eb0fcd60b11UL,     0xc007debe547f90a3UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8001000000000000UL, 
            0x7ff8000000000000UL,     0x953a015c0bc0eef1UL,     0xbff921fb54442d18UL,     0xbff921fb54416d68UL, 
            0xbff921fb5446ecc9UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54416d68UL,     0xbff921fb5446ecc9UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbfcf5b75f92c80ddUL,     0xbfcf5b75f92b35b8UL,     0xbfcf5b75f92dcc03UL,     0xbfddac670561bb4fUL, 
            0xbfbfd5ba9aac2f6eUL,     0xbfe921fb54442d18UL,     0xbfaff55bb72cfdeaUL,     0xc0072c43f4b1650aUL, 
            0xc0072c43f4b15058UL,     0xc0072c43f4b179bdUL,     0xc0056c6e7397f5aeUL,     0xc008234d7f6ecb9dUL, 
            0xc002d97c7f3321d2UL,     0xc008a225e5677921UL,     0xbfb45438e80932c3UL,     0xbfb45438e808ebe9UL, 
            0xbfb45438e809799dUL,     0xbfc433cffc49c751UL,     0xbfa45c708d443772UL,     0xbfd3b90ac4853d17UL, 
            0xbf945e8055946782UL,     0xc0087f598d03e382UL,     0xc0087f598d03e14bUL,     0xc0087f598d03e5b9UL, 
            0xc007debe547f90a3UL,     0xc008d089920f1c3aUL,     0xc006aad9fbb38575UL,     0xc008f93e53990449UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8010000000000001UL, 
            0x7ff8000000000000UL,     0x957a015c0bc0eef1UL,     0xbff921fb54442d18UL,     0xbff921fb5444011dUL, 
            0xbff921fb54445914UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb5444011dUL,     0xbff921fb54445914UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff5368c951e9cfdUL,     0xbff5368c951e7398UL,     0xbff5368c951ec661UL,     0xbff7249faa996a21UL, 
            0xbff1b6e192ebbe44UL,     0xbff82250768ac529UL,     0xbfe921fb54442d18UL,     0xbffd0d6a1369bd34UL, 
            0xbffd0d6a136993d0UL,     0xbffd0d6a1369e699UL,     0xbffb1f56fdeef010UL,     0xc000468a8ace4df6UL, 
            0xbffa21a631fd9508UL,     0xc002d97c7f3321d2UL,     0xbfecf5f1e82b5390UL,     0xbfecf5f1e82b1d29UL, 
            0xbfecf5f1e82b89f7UL,     0xbff32545abb24f20UL,     0xbfe2242398ae5432UL,     0xbff607d636e70256UL, 
            0xbfd3b90ac4853d17UL,     0xc001e47eda395834UL,     0xc001e47eda394a9aUL,     0xc001e47eda3965ceUL, 
            0xbfff1eb0fcd60b11UL,     0xc00498f26e18980cUL,     0xbffc3c2071a157dbUL,     0xc006aad9fbb38575UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0xc90fdaa22168cUL, 
            0x7ff8000000000000UL,     0x15746cad8f3fcefcUL,     0x3ff921fb54442d18UL,     0x3ff921fb5443f519UL, 
            0x3ff921fb54446518UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb5443f519UL,     0x3ff921fb54446518UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff433b8a322ddd2UL,     0x3ff433b8a322aafaUL,     0x3ff433b8a32310abUL,     0x3ff69b8154baf42eUL, 
            0x3ff00fe987ed02ffUL,     0x3ff7dcb7c5c399ecUL,     0x3fe54e04c05d06a0UL,     0x3ffe103e05657c5fUL, 
            0x3ffe103e05654986UL,     0x3ffe103e0565af37UL,     0x3ffba87553cd6603UL,     0x40011a06904dab99UL, 
            0x3ffa673ee2c4c045UL,     0x4003ce7a242ceb70UL,     0x3fe921fb54442d18UL,     0x3fe921fb5443f519UL, 
            0x3fe921fb54446517UL,     0x3ff1b6e192ebbe44UL,     0x3fddac670561bb4fUL,     0x3ff5368c951e9cfdUL, 
            0x3fcf5b75f92c80ddUL,     0x4002d97c7f3321d2UL,     0x4002d97c7f3313d2UL,     0x4002d97c7f332fd2UL, 
            0x4000468a8ace4df6UL,     0x40056c6e7397f5aeUL,     0x3ffd0d6a1369bd34UL,     0x40072c43f4b1650aUL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0xc90fdaa224287UL, 
            0x7ff8000000000000UL,     0x15746cad8f401678UL,     0x3ff921fb54442d18UL,     0x3ff921fb5443f519UL, 
            0x3ff921fb54446518UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb5443f519UL,     0x3ff921fb54446518UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff433b8a322ee02UL,     0x3ff433b8a322bb29UL,     0x3ff433b8a32320daUL,     0x3ff69b8154bafcdfUL, 
            0x3ff00fe987ed1c5dUL,     0x3ff7dcb7c5c39e5aUL,     0x3fe54e04c05d3d07UL,     0x3ffe103e05656c2fUL, 
            0x3ffe103e05653957UL,     0x3ffe103e05659f08UL,     0x3ffba87553cd5d52UL,     0x40011a06904d9eeaUL, 
            0x3ffa673ee2c4bbd7UL,     0x4003ce7a242cddd6UL,     0x3fe921fb54446517UL,     0x3fe921fb54442d18UL, 
            0x3fe921fb54449d17UL,     0x3ff1b6e192ebd4aaUL,     0x3fddac67056214e7UL,     0x3ff5368c951eaa2aUL, 
            0x3fcf5b75f92cea45UL,     0x4002d97c7f3313d2UL,     0x4002d97c7f3305d2UL,     0x4002d97c7f3321d2UL, 
            0x4000468a8ace42c4UL,     0x40056c6e7397ea7bUL,     0x3ffd0d6a1369b007UL,     0x40072c43f4b15e74UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0xc90fdaa21ea91UL, 
            0x7ff8000000000000UL,     0x15746cad8f3f8780UL,     0x3ff921fb54442d18UL,     0x3ff921fb5443f519UL, 
            0x3ff921fb54446518UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb5443f519UL,     0x3ff921fb54446518UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff433b8a322cda3UL,     0x3ff433b8a3229acbUL,     0x3ff433b8a323007cUL,     0x3ff69b8154baeb7dUL, 
            0x3ff00fe987ece9a1UL,     0x3ff7dcb7c5c3957eUL,     0x3fe54e04c05cd039UL,     0x3ffe103e05658c8eUL, 
            0x3ffe103e056559b5UL,     0x3ffe103e0565bf66UL,     0x3ffba87553cd6eb4UL,     0x40011a06904db848UL, 
            0x3ffa673ee2c4c4b3UL,     0x4003ce7a242cf90aUL,     0x3fe921fb5443f519UL,     0x3fe921fb5443bd19UL, 
            0x3fe921fb54442d18UL,     0x3ff1b6e192eba7deUL,     0x3fddac67056161b7UL,     0x3ff5368c951e8fcfUL, 
            0x3fcf5b75f92c1775UL,     0x4002d97c7f332fd2UL,     0x4002d97c7f3321d2UL,     0x4002d97c7f333dd2UL, 
            0x4000468a8ace592aUL,     0x40056c6e739800e1UL,     0x3ffd0d6a1369ca62UL,     0x40072c43f4b16ba1UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x6487ed5110b46UL, 
            0x7ff8000000000000UL,     0x15646cad8f3fcefcUL,     0x3ff921fb54442d18UL,     0x3ff921fb5443bd19UL, 
            0x3ff921fb54449d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb5443bd19UL,     0x3ff921fb54449d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff00fe987ed02ffUL,     0x3ff00fe987ecb34dUL,     0x3ff00fe987ed52b1UL,     0x3ff433b8a322ddd2UL, 
            0x3fe54e04c05d06a0UL,     0x3ff69b8154baf42eUL,     0x3fd7f2d6a24777e1UL,     0x40011a06904dab99UL, 
            0x40011a06904d83c0UL,     0x40011a06904dd372UL,     0x3ffe103e05657c5fUL,     0x4003ce7a242ceb70UL, 
            0x3ffba87553cd6603UL,     0x400623a07ffb3e1cUL,     0x3fddac670561bb4fUL,     0x3fddac67056161b7UL, 
            0x3fddac67056214e7UL,     0x3fe921fb54442d18UL,     0x3fcf5b75f92c80ddUL,     0x3ff1b6e192ebbe44UL, 
            0x3fbfd5ba9aac2f6eUL,     0x40056c6e7397f5aeUL,     0x40056c6e7397ea7bUL,     0x40056c6e739800e1UL, 
            0x4002d97c7f3321d2UL,     0x40072c43f4b1650aUL,     0x4000468a8ace4df6UL,     0x4008234d7f6ecb9dUL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x1921fb54442d19UL, 
            0x7ff8000000000000UL,     0x15846cad8f3fcefcUL,     0x3ff921fb54442d18UL,     0x3ff921fb54441119UL, 
            0x3ff921fb54444918UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54441119UL,     0x3ff921fb54444918UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff69b8154baf42eUL,     0x3ff69b8154bad8e0UL,     0x3ff69b8154bb0f7dUL,     0x3ff7dcb7c5c399ecUL, 
            0x3ff433b8a322ddd2UL,     0x3ff87f17cfda0b5dUL,     0x3ff00fe987ed02ffUL,     0x3ffba87553cd6603UL, 
            0x3ffba87553cd4ab4UL,     0x3ffba87553cd8151UL,     0x3ffa673ee2c4c045UL,     0x3ffe103e05657c5fUL, 
            0x3ff9c4ded8ae4ed4UL,     0x40011a06904dab99UL,     0x3ff1b6e192ebbe44UL,     0x3ff1b6e192eba7deUL, 
            0x3ff1b6e192ebd4aaUL,     0x3ff5368c951e9cfdUL,     0x3fe921fb54442d18UL,     0x3ff7249faa996a21UL, 
            0x3fddac670561bb4fUL,     0x4000468a8ace4df6UL,     0x4000468a8ace42c4UL,     0x4000468a8ace592aUL, 
            0x3ffd0d6a1369bd34UL,     0x4002d97c7f3321d2UL,     0x3ffb1f56fdeef010UL,     0x40056c6e7397f5aeUL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x3243f6a8885a3UL, 
            0x7ff8000000000000UL,     0x15546cad8f3fcefcUL,     0x3ff921fb54442d18UL,     0x3ff921fb54434d1bUL, 
            0x3ff921fb54450d16UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54434d1bUL,     0x3ff921fb54450d16UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3fe54e04c05d06a0UL,     0x3fe54e04c05c5bb7UL,     0x3fe54e04c05db189UL,     0x3ff00fe987ed02ffUL, 
            0x3fd7f2d6a24777e1UL,     0x3ff433b8a322ddd2UL,     0x3fc8d128eae95614UL,     0x4003ce7a242ceb70UL, 
            0x4003ce7a242cc0b6UL,     0x4003ce7a242d162aUL,     0x40011a06904dab99UL,     0x400623a07ffb3e1cUL, 
            0x3ffe103e05657c5fUL,     0x400794e8c59597b7UL,     0x3fcf5b75f92c80ddUL,     0x3fcf5b75f92c1775UL, 
            0x3fcf5b75f92cea45UL,     0x3fddac670561bb4fUL,     0x3fbfd5ba9aac2f6eUL,     0x3fe921fb54442d18UL, 
            0x3faff55bb72cfdeaUL,     0x40072c43f4b1650aUL,     0x40072c43f4b15e74UL,     0x40072c43f4b16ba1UL, 
            0x40056c6e7397f5aeUL,     0x4008234d7f6ecb9dUL,     0x4002d97c7f3321d2UL,     0x4008a225e5677921UL, 
            0x400921fb54442d18UL,     0x0UL,     0x3ff921fb54442d18UL,     0x2921fb54442d19UL, 
            0x7ff8000000000000UL,     0x15946cad8f3fcefcUL,     0x3ff921fb54442d18UL,     0x3ff921fb54441f18UL, 
            0x3ff921fb54443b19UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54441f18UL,     0x3ff921fb54443b19UL, 
            0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL,     0x3ff921fb54442d18UL, 
            0x3ff7dcb7c5c399ecUL,     0x3ff7dcb7c5c38c03UL,     0x3ff7dcb7c5c3a7d5UL,     0x3ff87f17cfda0b5dUL, 
            0x3ff69b8154baf42eUL,     0x3ff8d08152eddb7aUL,     0x3ff433b8a322ddd2UL,     0x3ffa673ee2c4c045UL, 
            0x3ffa673ee2c4b25cUL,     0x3ffa673ee2c4ce2eUL,     0x3ff9c4ded8ae4ed4UL,     0x3ffba87553cd6603UL, 
            0x3ff97375559a7eb7UL,     0x3ffe103e05657c5fUL,     0x3ff5368c951e9cfdUL,     0x3ff5368c951e8fcfUL, 
            0x3ff5368c951eaa2aUL,     0x3ff7249faa996a21UL,     0x3ff1b6e192ebbe44UL,     0x3ff82250768ac529UL, 
            0x3fe921fb54442d18UL,     0x3ffd0d6a1369bd34UL,     0x3ffd0d6a1369b007UL,     0x3ffd0d6a1369ca62UL, 
            0x3ffb1f56fdeef010UL,     0x4000468a8ace4df6UL,     0x3ffa21a631fd9508UL,     0x4002d97c7f3321d2UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x800c90fdaa22168cUL, 
            0x7ff8000000000000UL,     0x95746cad8f3fcefcUL,     0xbff921fb54442d18UL,     0xbff921fb5443f519UL, 
            0xbff921fb54446518UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb5443f519UL,     0xbff921fb54446518UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff433b8a322ddd2UL,     0xbff433b8a322aafaUL,     0xbff433b8a32310abUL,     0xbff69b8154baf42eUL, 
            0xbff00fe987ed02ffUL,     0xbff7dcb7c5c399ecUL,     0xbfe54e04c05d06a0UL,     0xbffe103e05657c5fUL, 
            0xbffe103e05654986UL,     0xbffe103e0565af37UL,     0xbffba87553cd6603UL,     0xc0011a06904dab99UL, 
            0xbffa673ee2c4c045UL,     0xc003ce7a242ceb70UL,     0xbfe921fb54442d18UL,     0xbfe921fb5443f519UL, 
            0xbfe921fb54446517UL,     0xbff1b6e192ebbe44UL,     0xbfddac670561bb4fUL,     0xbff5368c951e9cfdUL, 
            0xbfcf5b75f92c80ddUL,     0xc002d97c7f3321d2UL,     0xc002d97c7f3313d2UL,     0xc002d97c7f332fd2UL, 
            0xc000468a8ace4df6UL,     0xc0056c6e7397f5aeUL,     0xbffd0d6a1369bd34UL,     0xc0072c43f4b1650aUL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x800c90fdaa21ea91UL, 
            0x7ff8000000000000UL,     0x95746cad8f3f8780UL,     0xbff921fb54442d18UL,     0xbff921fb5443f519UL, 
            0xbff921fb54446518UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb5443f519UL,     0xbff921fb54446518UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff433b8a322cda3UL,     0xbff433b8a3229acbUL,     0xbff433b8a323007cUL,     0xbff69b8154baeb7dUL, 
            0xbff00fe987ece9a1UL,     0xbff7dcb7c5c3957eUL,     0xbfe54e04c05cd039UL,     0xbffe103e05658c8eUL, 
            0xbffe103e056559b5UL,     0xbffe103e0565bf66UL,     0xbffba87553cd6eb4UL,     0xc0011a06904db848UL, 
            0xbffa673ee2c4c4b3UL,     0xc003ce7a242cf90aUL,     0xbfe921fb5443f519UL,     0xbfe921fb5443bd19UL, 
            0xbfe921fb54442d18UL,     0xbff1b6e192eba7deUL,     0xbfddac67056161b7UL,     0xbff5368c951e8fcfUL, 
            0xbfcf5b75f92c1775UL,     0xc002d97c7f332fd2UL,     0xc002d97c7f3321d2UL,     0xc002d97c7f333dd2UL, 
            0xc000468a8ace592aUL,     0xc0056c6e739800e1UL,     0xbffd0d6a1369ca62UL,     0xc0072c43f4b16ba1UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x800c90fdaa224287UL, 
            0x7ff8000000000000UL,     0x95746cad8f401678UL,     0xbff921fb54442d18UL,     0xbff921fb5443f519UL, 
            0xbff921fb54446518UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb5443f519UL,     0xbff921fb54446518UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff433b8a322ee02UL,     0xbff433b8a322bb29UL,     0xbff433b8a32320daUL,     0xbff69b8154bafcdfUL, 
            0xbff00fe987ed1c5dUL,     0xbff7dcb7c5c39e5aUL,     0xbfe54e04c05d3d07UL,     0xbffe103e05656c2fUL, 
            0xbffe103e05653957UL,     0xbffe103e05659f08UL,     0xbffba87553cd5d52UL,     0xc0011a06904d9eeaUL, 
            0xbffa673ee2c4bbd7UL,     0xc003ce7a242cddd6UL,     0xbfe921fb54446517UL,     0xbfe921fb54442d18UL, 
            0xbfe921fb54449d17UL,     0xbff1b6e192ebd4aaUL,     0xbfddac67056214e7UL,     0xbff5368c951eaa2aUL, 
            0xbfcf5b75f92cea45UL,     0xc002d97c7f3313d2UL,     0xc002d97c7f3305d2UL,     0xc002d97c7f3321d2UL, 
            0xc000468a8ace42c4UL,     0xc0056c6e7397ea7bUL,     0xbffd0d6a1369b007UL,     0xc0072c43f4b15e74UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8006487ed5110b46UL, 
            0x7ff8000000000000UL,     0x95646cad8f3fcefcUL,     0xbff921fb54442d18UL,     0xbff921fb5443bd19UL, 
            0xbff921fb54449d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb5443bd19UL,     0xbff921fb54449d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff00fe987ed02ffUL,     0xbff00fe987ecb34dUL,     0xbff00fe987ed52b1UL,     0xbff433b8a322ddd2UL, 
            0xbfe54e04c05d06a0UL,     0xbff69b8154baf42eUL,     0xbfd7f2d6a24777e1UL,     0xc0011a06904dab99UL, 
            0xc0011a06904d83c0UL,     0xc0011a06904dd372UL,     0xbffe103e05657c5fUL,     0xc003ce7a242ceb70UL, 
            0xbffba87553cd6603UL,     0xc00623a07ffb3e1cUL,     0xbfddac670561bb4fUL,     0xbfddac67056161b7UL, 
            0xbfddac67056214e7UL,     0xbfe921fb54442d18UL,     0xbfcf5b75f92c80ddUL,     0xbff1b6e192ebbe44UL, 
            0xbfbfd5ba9aac2f6eUL,     0xc0056c6e7397f5aeUL,     0xc0056c6e7397ea7bUL,     0xc0056c6e739800e1UL, 
            0xc002d97c7f3321d2UL,     0xc0072c43f4b1650aUL,     0xc000468a8ace4df6UL,     0xc008234d7f6ecb9dUL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x801921fb54442d19UL, 
            0x7ff8000000000000UL,     0x95846cad8f3fcefcUL,     0xbff921fb54442d18UL,     0xbff921fb54441119UL, 
            0xbff921fb54444918UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54441119UL,     0xbff921fb54444918UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff69b8154baf42eUL,     0xbff69b8154bad8e0UL,     0xbff69b8154bb0f7dUL,     0xbff7dcb7c5c399ecUL, 
            0xbff433b8a322ddd2UL,     0xbff87f17cfda0b5dUL,     0xbff00fe987ed02ffUL,     0xbffba87553cd6603UL, 
            0xbffba87553cd4ab4UL,     0xbffba87553cd8151UL,     0xbffa673ee2c4c045UL,     0xbffe103e05657c5fUL, 
            0xbff9c4ded8ae4ed4UL,     0xc0011a06904dab99UL,     0xbff1b6e192ebbe44UL,     0xbff1b6e192eba7deUL, 
            0xbff1b6e192ebd4aaUL,     0xbff5368c951e9cfdUL,     0xbfe921fb54442d18UL,     0xbff7249faa996a21UL, 
            0xbfddac670561bb4fUL,     0xc000468a8ace4df6UL,     0xc000468a8ace42c4UL,     0xc000468a8ace592aUL, 
            0xbffd0d6a1369bd34UL,     0xc002d97c7f3321d2UL,     0xbffb1f56fdeef010UL,     0xc0056c6e7397f5aeUL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x8003243f6a8885a3UL, 
            0x7ff8000000000000UL,     0x95546cad8f3fcefcUL,     0xbff921fb54442d18UL,     0xbff921fb54434d1bUL, 
            0xbff921fb54450d16UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54434d1bUL,     0xbff921fb54450d16UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbfe54e04c05d06a0UL,     0xbfe54e04c05c5bb7UL,     0xbfe54e04c05db189UL,     0xbff00fe987ed02ffUL, 
            0xbfd7f2d6a24777e1UL,     0xbff433b8a322ddd2UL,     0xbfc8d128eae95614UL,     0xc003ce7a242ceb70UL, 
            0xc003ce7a242cc0b6UL,     0xc003ce7a242d162aUL,     0xc0011a06904dab99UL,     0xc00623a07ffb3e1cUL, 
            0xbffe103e05657c5fUL,     0xc00794e8c59597b7UL,     0xbfcf5b75f92c80ddUL,     0xbfcf5b75f92c1775UL, 
            0xbfcf5b75f92cea45UL,     0xbfddac670561bb4fUL,     0xbfbfd5ba9aac2f6eUL,     0xbfe921fb54442d18UL, 
            0xbfaff55bb72cfdeaUL,     0xc0072c43f4b1650aUL,     0xc0072c43f4b15e74UL,     0xc0072c43f4b16ba1UL, 
            0xc0056c6e7397f5aeUL,     0xc008234d7f6ecb9dUL,     0xc002d97c7f3321d2UL,     0xc008a225e5677921UL, 
            0xc00921fb54442d18UL,     0x8000000000000000UL,     0xbff921fb54442d18UL,     0x802921fb54442d19UL, 
            0x7ff8000000000000UL,     0x95946cad8f3fcefcUL,     0xbff921fb54442d18UL,     0xbff921fb54441f18UL, 
            0xbff921fb54443b19UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54441f18UL,     0xbff921fb54443b19UL, 
            0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL,     0xbff921fb54442d18UL, 
            0xbff7dcb7c5c399ecUL,     0xbff7dcb7c5c38c03UL,     0xbff7dcb7c5c3a7d5UL,     0xbff87f17cfda0b5dUL, 
            0xbff69b8154baf42eUL,     0xbff8d08152eddb7aUL,     0xbff433b8a322ddd2UL,     0xbffa673ee2c4c045UL, 
            0xbffa673ee2c4b25cUL,     0xbffa673ee2c4ce2eUL,     0xbff9c4ded8ae4ed4UL,     0xbffba87553cd6603UL, 
            0xbff97375559a7eb7UL,     0xbffe103e05657c5fUL,     0xbff5368c951e9cfdUL,     0xbff5368c951e8fcfUL, 
            0xbff5368c951eaa2aUL,     0xbff7249faa996a21UL,     0xbff1b6e192ebbe44UL,     0xbff82250768ac529UL, 
            0xbfe921fb54442d18UL,     0xbffd0d6a1369bd34UL,     0xbffd0d6a1369b007UL,     0xbffd0d6a1369ca62UL, 
            0xbffb1f56fdeef010UL,     0xc000468a8ace4df6UL,     0xbffa21a631fd9508UL,     0xc002d97c7f3321d2UL, 
    
        )
    
    
        checkAnswers(::atan2, arguments, answers, true)
    }
    
    @Test
    fun testSinh() {
        val answers = arrayOf(
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3ff2cd9fc44eb982UL,     0x3ff2cd9fc44fc8f8UL,     0x3ff2cd9fc44daa0cUL,     0x3fe0acd00fe63b97UL, 
            0x400d03cf63b6e1a0UL,     0x3fd02accd9d08102UL,     0x403b4a3803703630UL,     0xbff2cd9fc44eb982UL, 
            0xbff2cd9fc44daa0cUL,     0xbff2cd9fc44fc8f8UL,     0xbfe0acd00fe63b97UL,     0xc00d03cf63b6e1a0UL, 
            0xbfd02accd9d08102UL,     0xc03b4a3803703630UL,     0x402718f45d72e672UL,     0x402718f45d73e55aUL, 
            0x402718f45d71e789UL,     0x4002690f661dd820UL,     0x4070bbeb1603926aUL,     0x3febcc270b522736UL, 
            0x4101807d40a5fb0aUL,     0xc02718f45d72e672UL,     0xc02718f45d71e789UL,     0xc02718f45d73e55aUL, 
            0xc002690f661dd820UL,     0xc070bbeb1603926aUL,     0xbfebcc270b522736UL,     0xc101807d40a5fb0aUL, 
    
        )
    
    
        checkAnswers(::sinh, arguments, answers, true)
    }
    
    @Test
    fun testCosh() {
        val answers = arrayOf(
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff8b07551d9f551UL,     0x3ff8b07551dac40fUL,     0x3ff8b07551d92692UL,     0x3ff20ac1862ae8d0UL, 
            0x400e18fa0df2d9bcUL,     0x3ff080ab05ca6146UL,     0x403b4ee858de3e80UL,     0x3ff8b07551d9f551UL, 
            0x3ff8b07551d92692UL,     0x3ff8b07551dac40fUL,     0x3ff20ac1862ae8d0UL,     0x400e18fa0df2d9bcUL, 
            0x3ff080ab05ca6146UL,     0x403b4ee858de3e80UL,     0x40272f147fee4000UL,     0x40272f147fef3df6UL, 
            0x40272f147fed420bUL,     0x400412cc2a8d4e9eUL,     0x4070bbf2bc2b69c6UL,     0x3ff531994ce525b9UL, 
            0x4101807d40a7cf1aUL,     0x40272f147fee4000UL,     0x40272f147fed420bUL,     0x40272f147fef3df6UL, 
            0x400412cc2a8d4e9eUL,     0x4070bbf2bc2b69c6UL,     0x3ff531994ce525b9UL,     0x4101807d40a7cf1aUL, 
    
        )
    
    
        checkAnswers(::cosh, arguments, answers, true)
    }
    
    @Test
    fun testTanh() {
        val answers = arrayOf(
            0xbff0000000000000UL,     0x3ff0000000000000UL,     0x1UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3fe85efab514f394UL,     0x3fe85efab5158758UL,     0x3fe85efab5145fcfUL,     0x3fdd9353d7568af3UL, 
            0x3feed9505e1bc3d4UL,     0x3fcf597ea69a1c86UL,     0x3feffa81708a0b42UL,     0xbfe85efab514f394UL, 
            0xbfe85efab5145fcfUL,     0xbfe85efab5158758UL,     0xbfdd9353d7568af3UL,     0xbfeed9505e1bc3d4UL, 
            0xbfcf597ea69a1c86UL,     0xbfeffa81708a0b42UL,     0x3fefe175fa292810UL,     0x3fefe175fa292aaeUL, 
            0x3fefe175fa292571UL,     0x3fed594fdae482baUL,     0x3feffff15f81f9abUL,     0x3fe4fc441fa6d6d6UL, 
            0x3feffffffffca835UL,     0xbfefe175fa292810UL,     0xbfefe175fa292571UL,     0xbfefe175fa292aaeUL, 
            0xbfed594fdae482baUL,     0xbfeffff15f81f9abUL,     0xbfe4fc441fa6d6d6UL,     0xbfeffffffffca835UL, 
    
        )
    
    
        checkAnswers(::tanh, arguments, answers, true)
    }
    
    @Test
    fun testAsinh() {
        val answers = arrayOf(
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x408633ce8fb9f87dUL, 
            0x7ff8000000000000UL,     0x407d8ef0e521dbc8UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3fec34366179d426UL,     0x3fec3436617accf1UL,     0x3fec34366178db5dUL,     0x3fdecc2caec5160aUL, 
            0x3ff719218313d087UL,     0x3fcfacfb2399e637UL,     0x4000c1f8a6e80eebUL,     0xbfec34366179d426UL, 
            0xbfec34366178db5dUL,     0xbfec3436617accf1UL,     0xbfdecc2caec5160aUL,     0xbff719218313d087UL, 
            0xbfcfacfb2399e637UL,     0xc000c1f8a6e80eebUL,     0x3ffdcbf69f10006dUL,     0x3ffdcbf69f1035c9UL, 
            0x3ffdcbf69f0fcb10UL,     0x3ff3bc04e847ec05UL,     0x40044c62a1e4f804UL,     0x3fe7144779e3f0bcUL, 
            0x4009ce5672c85ff0UL,     0xbffdcbf69f10006dUL,     0xbffdcbf69f0fcb10UL,     0xbffdcbf69f1035c9UL, 
            0xbff3bc04e847ec05UL,     0xc0044c62a1e4f804UL,     0xbfe7144779e3f0bcUL,     0xc009ce5672c85ff0UL, 
    
        )
    
    
        checkAnswers(::asinh, arguments, answers, false)
    }
    
    @Test
    fun testAcosh() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x408633ce8fb9f87dUL, 
            0x7ff8000000000000UL,     0x407d8ef0e521dbc8UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x0UL,     0x3ed2c1eb6bf6c712UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3ff5124271980434UL,     0x7ff8000000000000UL,     0x400081eb4b421592UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ffcfc02f90106c2UL,     0x3ffcfc02f90141d3UL, 
            0x3ffcfc02f900cbb0UL,     0x3ff05f23c6cbaf31UL,     0x400432718f372526UL,     0x7ff8000000000000UL, 
            0x4009c7da6362eaa7UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
    
        )
    
    
        checkAnswers(::acosh, arguments, answers, false)
    }
    
    @Test
    fun testAtanh() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x1UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x402a058678adc34fUL,     0x3fe193ea7aad030bUL, 
            0x7ff8000000000000UL,     0x3fd058aefa811452UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0xc02a058678adc34fUL,     0x7ff8000000000000UL,     0xbfe193ea7aad030bUL,     0x7ff8000000000000UL, 
            0xbfd058aefa811452UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0f2eb07023068UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xbff0f2eb07023069UL,     0x7ff8000000000000UL, 
    
        )
    
    
        checkAnswers(::atanh, arguments, answers, false)
    }
    
}
        
