/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package test.math

//
// NOTE: THIS FILE IS AUTO-GENERATED by the mathTestGeneratorMain.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import kotlin.math.*
import kotlin.test.*



class RoundingsTest {
    private val arguments = arrayOf(
        0xfff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
        0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3fd999999999999aUL,     0x3fd99999999c594aUL, 
        0x3fd999999996d9eaUL,     0x3fc999999999999aUL,     0x3fe999999999999aUL,     0x3fb999999999999aUL, 
        0x3ff999999999999aUL,     0xbfd999999999999aUL,     0xbfd999999996d9eaUL,     0xbfd99999999c594aUL, 
        0xbfc999999999999aUL,     0xbfe999999999999aUL,     0xbfb999999999999aUL,     0xbff999999999999aUL, 
        0x3fe0000000000000UL,     0x3fe0000000015fd8UL,     0x3fdffffffffd4050UL,     0x3fd0000000000000UL, 
        0x3ff0000000000000UL,     0x3fc0000000000000UL,     0x4000000000000000UL,     0xbfe0000000000000UL, 
        0xbfdffffffffd4050UL,     0xbfe0000000015fd8UL,     0xbfd0000000000000UL,     0xbff0000000000000UL, 
        0xbfc0000000000000UL,     0xc000000000000000UL,     0x3fe3333333333333UL,     0x3fe333333334930bUL, 
        0x3fe333333331d35bUL,     0x3fd3333333333333UL,     0x3ff3333333333333UL,     0x3fc3333333333333UL, 
        0x4003333333333333UL,     0xbfe3333333333333UL,     0xbfe333333331d35bUL,     0xbfe333333334930bUL, 
        0xbfd3333333333333UL,     0xbff3333333333333UL,     0xbfc3333333333333UL,     0xc003333333333333UL, 
        0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
        0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0xbff0000000000000UL, 
        0xbfeffffffffea028UL,     0xbff000000000afecUL,     0xbfe0000000000000UL,     0xc000000000000000UL, 
        0xbfd0000000000000UL,     0xc010000000000000UL, 
    )
    
    
    @Test
    fun testCeil() {
        val answers = arrayOf(
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x4000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xbff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x4000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xbff0000000000000UL, 
            0x8000000000000000UL,     0xc000000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x4000000000000000UL,     0x3ff0000000000000UL, 
            0x4008000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xbff0000000000000UL,     0x8000000000000000UL,     0xc000000000000000UL, 
            0x3ff0000000000000UL,     0x4000000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x4000000000000000UL,     0x3ff0000000000000UL,     0x4010000000000000UL,     0xbff0000000000000UL, 
            0x8000000000000000UL,     0xbff0000000000000UL,     0x8000000000000000UL,     0xc000000000000000UL, 
            0x8000000000000000UL,     0xc010000000000000UL, 
        )
    
    
        checkAnswers(::ceil, arguments, answers, true)
    }
    
    @Test
    fun testFloor() {
        val answers = arrayOf(
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0x0UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL, 
            0xbff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL,     0xc000000000000000UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x4000000000000000UL,     0xbff0000000000000UL, 
            0xbff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL, 
            0xbff0000000000000UL,     0xc000000000000000UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x4000000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL, 
            0xbff0000000000000UL,     0xc000000000000000UL,     0xbff0000000000000UL,     0xc008000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x0UL, 
            0x4000000000000000UL,     0x0UL,     0x4010000000000000UL,     0xbff0000000000000UL, 
            0xbff0000000000000UL,     0xc000000000000000UL,     0xbff0000000000000UL,     0xc000000000000000UL, 
            0xbff0000000000000UL,     0xc010000000000000UL, 
        )
    
    
        checkAnswers(::floor, arguments, answers, true)
    }
    
    @Test
    fun testTruncate() {
        val answers = arrayOf(
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0x0UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xbff0000000000000UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x4000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0xbff0000000000000UL, 
            0x8000000000000000UL,     0xc000000000000000UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x4000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xbff0000000000000UL,     0x8000000000000000UL,     0xc000000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x0UL, 
            0x4000000000000000UL,     0x0UL,     0x4010000000000000UL,     0xbff0000000000000UL, 
            0x8000000000000000UL,     0xbff0000000000000UL,     0x8000000000000000UL,     0xc000000000000000UL, 
            0x8000000000000000UL,     0xc010000000000000UL, 
        )
    
    
        checkAnswers(::truncate, arguments, answers, true)
    }
    
    @Test
    fun testRound() {
        val answers = arrayOf(
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0x0UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x4000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xbff0000000000000UL,     0x8000000000000000UL,     0xc000000000000000UL, 
            0x0UL,     0x3ff0000000000000UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x4000000000000000UL,     0x8000000000000000UL, 
            0x8000000000000000UL,     0xbff0000000000000UL,     0x8000000000000000UL,     0xbff0000000000000UL, 
            0x8000000000000000UL,     0xc000000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x4000000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL,     0xbff0000000000000UL, 
            0x8000000000000000UL,     0xbff0000000000000UL,     0x8000000000000000UL,     0xc000000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL, 
            0x4000000000000000UL,     0x0UL,     0x4010000000000000UL,     0xbff0000000000000UL, 
            0xbff0000000000000UL,     0xbff0000000000000UL,     0x8000000000000000UL,     0xc000000000000000UL, 
            0x8000000000000000UL,     0xc010000000000000UL, 
        )
    
    
        checkAnswers(::round, arguments, answers, true)
    }
    
}
        
