/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package test.math

//
// NOTE: THIS FILE IS AUTO-GENERATED by the mathTestGeneratorMain.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import kotlin.math.*
import kotlin.test.*



class PowersTest {
    private val arguments = arrayOf(
        0xfff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
        0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x3da5fd7fe1796495UL, 
        0xbda5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
        0x0UL,     0x8000000000000000UL,     0x3da5fd7fe1796495UL,     0xbda5fd7fe1796495UL, 
        0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
        0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
        0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0xbff0000000000000UL, 
        0xbfeffffffffea028UL,     0xbff000000000afecUL,     0xbfe0000000000000UL,     0xc000000000000000UL, 
        0xbfd0000000000000UL,     0xc010000000000000UL, 
    )
    
    
    @Test
    fun testHypot() {
        val answers = arrayOf(
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x1UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x1UL,     0x1UL,     0x1UL, 
            0x1UL,     0x1UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x1UL,     0x1UL,     0x1UL,     0x1UL, 
            0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
            0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3ff000000000afecUL,     0x3fe0000000000000UL,     0x4000000000000000UL, 
            0x3fd0000000000000UL,     0x4010000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7fefffffffffffffUL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7fefffffffffffffUL, 
            0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL, 
            0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL, 
            0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL, 
            0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL, 
            0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL, 
            0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL, 
            0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL,     0x7fefffffffffffffUL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x6a83b03385a2fc07UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a8bd7ebc51518adUL, 
            0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL, 
            0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL, 
            0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL, 
            0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL, 
            0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL, 
            0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL, 
            0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL,     0x6a83b03385a2fc07UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
            0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3ff000000000afecUL,     0x3fe0000000000000UL,     0x4000000000000000UL, 
            0x3fd0000000000000UL,     0x4010000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x3da5fd7fe1796495UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x3da5fd7fe1796495UL,     0x3daf19508903685eUL,     0x3daf19508903685eUL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x3daf19508903685eUL,     0x3daf19508903685eUL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL, 
            0x3feffffffffea028UL,     0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL, 
            0x4010000000000000UL,     0x3ff0000000000000UL,     0x3feffffffffea028UL,     0x3ff000000000afecUL, 
            0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x3da5fd7fe1796495UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3da5fd7fe1796495UL,     0x3daf19508903685eUL, 
            0x3daf19508903685eUL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3daf19508903685eUL,     0x3daf19508903685eUL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
            0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3ff000000000afecUL,     0x3fe0000000000000UL,     0x4000000000000000UL, 
            0x3fd0000000000000UL,     0x4010000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x1UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL, 
            0x3feffffffffea028UL,     0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL, 
            0x4010000000000000UL,     0x3ff0000000000000UL,     0x3feffffffffea028UL,     0x3ff000000000afecUL, 
            0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
            0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3ff000000000afecUL,     0x3fe0000000000000UL,     0x4000000000000000UL, 
            0x3fd0000000000000UL,     0x4010000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x1UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL, 
            0x3feffffffffea028UL,     0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL, 
            0x4010000000000000UL,     0x3ff0000000000000UL,     0x3feffffffffea028UL,     0x3ff000000000afecUL, 
            0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
            0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3ff000000000afecUL,     0x3fe0000000000000UL,     0x4000000000000000UL, 
            0x3fd0000000000000UL,     0x4010000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x1UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL, 
            0x3feffffffffea028UL,     0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL, 
            0x4010000000000000UL,     0x3ff0000000000000UL,     0x3feffffffffea028UL,     0x3ff000000000afecUL, 
            0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x3da5fd7fe1796495UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3da5fd7fe1796495UL,     0x3daf19508903685eUL, 
            0x3daf19508903685eUL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3daf19508903685eUL,     0x3daf19508903685eUL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
            0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3ff000000000afecUL,     0x3fe0000000000000UL,     0x4000000000000000UL, 
            0x3fd0000000000000UL,     0x4010000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x3da5fd7fe1796495UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x3da5fd7fe1796495UL,     0x3daf19508903685eUL,     0x3daf19508903685eUL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x3daf19508903685eUL,     0x3daf19508903685eUL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL, 
            0x3feffffffffea028UL,     0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL, 
            0x4010000000000000UL,     0x3ff0000000000000UL,     0x3feffffffffea028UL,     0x3ff000000000afecUL, 
            0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
            0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3ff000000000afecUL,     0x3fe0000000000000UL,     0x4000000000000000UL, 
            0x3fd0000000000000UL,     0x4010000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x1UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL, 
            0x3feffffffffea028UL,     0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL, 
            0x4010000000000000UL,     0x3ff0000000000000UL,     0x3feffffffffea028UL,     0x3ff000000000afecUL, 
            0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x0UL,     0x3da5fd7fe1796495UL, 
            0x3da5fd7fe1796495UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL,     0x3fe0000000000000UL, 
            0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3ff000000000afecUL,     0x3fe0000000000000UL,     0x4000000000000000UL, 
            0x3fd0000000000000UL,     0x4010000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x1UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x0UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe1796495UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL, 
            0x3feffffffffea028UL,     0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL, 
            0x4010000000000000UL,     0x3ff0000000000000UL,     0x3feffffffffea028UL,     0x3ff000000000afecUL, 
            0x3fe0000000000000UL,     0x4000000000000000UL,     0x3fd0000000000000UL,     0x4010000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff6a09e667f3bcdUL,     0x3ff6a09e667fb832UL,     0x3ff6a09e667ebf67UL,     0x3ff1e3779b97f4a8UL, 
            0x4001e3779b97f4a8UL,     0x3ff07e0f66afed07UL,     0x40107e0f66afed07UL,     0x3ff6a09e667f3bcdUL, 
            0x3ff6a09e667ebf67UL,     0x3ff6a09e667fb832UL,     0x3ff1e3779b97f4a8UL,     0x4001e3779b97f4a8UL, 
            0x3ff07e0f66afed07UL,     0x40107e0f66afed07UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x3ff000000000afecUL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff6a09e667fb832UL,     0x3ff6a09e66803497UL, 
            0x3ff6a09e667f3bcdUL,     0x3ff1e3779b989201UL,     0x4001e3779b981bfeUL,     0x3ff07e0f66b097b2UL, 
            0x40107e0f66aff7b2UL,     0x3ff6a09e667fb832UL,     0x3ff6a09e667f3bcdUL,     0x3ff6a09e66803497UL, 
            0x3ff1e3779b989201UL,     0x4001e3779b981bfeUL,     0x3ff07e0f66b097b2UL,     0x40107e0f66aff7b2UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x3feffffffffea028UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3ff6a09e667ebf67UL,     0x3ff6a09e667f3bcdUL,     0x3ff6a09e667e4302UL,     0x3ff1e3779b97574eUL, 
            0x4001e3779b97cd51UL,     0x3ff07e0f66af425cUL,     0x40107e0f66afe25cUL,     0x3ff6a09e667ebf67UL, 
            0x3ff6a09e667e4302UL,     0x3ff6a09e667f3bcdUL,     0x3ff1e3779b97574eUL,     0x4001e3779b97cd51UL, 
            0x3ff07e0f66af425cUL,     0x40107e0f66afe25cUL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x3fe0000000000000UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL, 
            0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL, 
            0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL, 
            0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3ff1e3779b97f4a8UL,     0x3ff1e3779b989201UL, 
            0x3ff1e3779b97574eUL,     0x3fe6a09e667f3bcdUL,     0x40007e0f66afed07UL,     0x3fe1e3779b97f4a8UL, 
            0x40101fe03f61bad0UL,     0x3ff1e3779b97f4a8UL,     0x3ff1e3779b97574eUL,     0x3ff1e3779b989201UL, 
            0x3fe6a09e667f3bcdUL,     0x40007e0f66afed07UL,     0x3fe1e3779b97f4a8UL,     0x40101fe03f61bad0UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x4000000000000000UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x4000000000000000UL,     0x4000000000000000UL, 
            0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL, 
            0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL, 
            0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL, 
            0x4001e3779b97f4a8UL,     0x4001e3779b981bfeUL,     0x4001e3779b97cd51UL,     0x40007e0f66afed07UL, 
            0x4006a09e667f3bcdUL,     0x40001fe03f61bad0UL,     0x4011e3779b97f4a8UL,     0x4001e3779b97f4a8UL, 
            0x4001e3779b97cd51UL,     0x4001e3779b981bfeUL,     0x40007e0f66afed07UL,     0x4006a09e667f3bcdUL, 
            0x40001fe03f61bad0UL,     0x4011e3779b97f4a8UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x3fd0000000000000UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL, 
            0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL, 
            0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL, 
            0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3ff07e0f66afed07UL,     0x3ff07e0f66b097b2UL, 
            0x3ff07e0f66af425cUL,     0x3fe1e3779b97f4a8UL,     0x40001fe03f61bad0UL,     0x3fd6a09e667f3bcdUL, 
            0x401007fe00ff6070UL,     0x3ff07e0f66afed07UL,     0x3ff07e0f66af425cUL,     0x3ff07e0f66b097b2UL, 
            0x3fe1e3779b97f4a8UL,     0x40001fe03f61bad0UL,     0x3fd6a09e667f3bcdUL,     0x401007fe00ff6070UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x4010000000000000UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x4010000000000000UL,     0x4010000000000000UL, 
            0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL, 
            0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL, 
            0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL, 
            0x40107e0f66afed07UL,     0x40107e0f66aff7b2UL,     0x40107e0f66afe25cUL,     0x40101fe03f61bad0UL, 
            0x4011e3779b97f4a8UL,     0x401007fe00ff6070UL,     0x4016a09e667f3bcdUL,     0x40107e0f66afed07UL, 
            0x40107e0f66afe25cUL,     0x40107e0f66aff7b2UL,     0x40101fe03f61bad0UL,     0x4011e3779b97f4a8UL, 
            0x401007fe00ff6070UL,     0x4016a09e667f3bcdUL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff6a09e667f3bcdUL,     0x3ff6a09e667fb832UL, 
            0x3ff6a09e667ebf67UL,     0x3ff1e3779b97f4a8UL,     0x4001e3779b97f4a8UL,     0x3ff07e0f66afed07UL, 
            0x40107e0f66afed07UL,     0x3ff6a09e667f3bcdUL,     0x3ff6a09e667ebf67UL,     0x3ff6a09e667fb832UL, 
            0x3ff1e3779b97f4a8UL,     0x4001e3779b97f4a8UL,     0x3ff07e0f66afed07UL,     0x40107e0f66afed07UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x3feffffffffea028UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3ff6a09e667ebf67UL,     0x3ff6a09e667f3bcdUL,     0x3ff6a09e667e4302UL,     0x3ff1e3779b97574eUL, 
            0x4001e3779b97cd51UL,     0x3ff07e0f66af425cUL,     0x40107e0f66afe25cUL,     0x3ff6a09e667ebf67UL, 
            0x3ff6a09e667e4302UL,     0x3ff6a09e667f3bcdUL,     0x3ff1e3779b97574eUL,     0x4001e3779b97cd51UL, 
            0x3ff07e0f66af425cUL,     0x40107e0f66afe25cUL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x3ff000000000afecUL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff000000000afecUL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff6a09e667fb832UL,     0x3ff6a09e66803497UL, 
            0x3ff6a09e667f3bcdUL,     0x3ff1e3779b989201UL,     0x4001e3779b981bfeUL,     0x3ff07e0f66b097b2UL, 
            0x40107e0f66aff7b2UL,     0x3ff6a09e667fb832UL,     0x3ff6a09e667f3bcdUL,     0x3ff6a09e66803497UL, 
            0x3ff1e3779b989201UL,     0x4001e3779b981bfeUL,     0x3ff07e0f66b097b2UL,     0x40107e0f66aff7b2UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x3fe0000000000000UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL, 
            0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL, 
            0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL, 
            0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL,     0x3fe0000000000000UL, 
            0x3ff1e3779b97f4a8UL,     0x3ff1e3779b989201UL,     0x3ff1e3779b97574eUL,     0x3fe6a09e667f3bcdUL, 
            0x40007e0f66afed07UL,     0x3fe1e3779b97f4a8UL,     0x40101fe03f61bad0UL,     0x3ff1e3779b97f4a8UL, 
            0x3ff1e3779b97574eUL,     0x3ff1e3779b989201UL,     0x3fe6a09e667f3bcdUL,     0x40007e0f66afed07UL, 
            0x3fe1e3779b97f4a8UL,     0x40101fe03f61bad0UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x4000000000000000UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL, 
            0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL, 
            0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL,     0x4000000000000000UL, 
            0x4000000000000000UL,     0x4000000000000000UL,     0x4001e3779b97f4a8UL,     0x4001e3779b981bfeUL, 
            0x4001e3779b97cd51UL,     0x40007e0f66afed07UL,     0x4006a09e667f3bcdUL,     0x40001fe03f61bad0UL, 
            0x4011e3779b97f4a8UL,     0x4001e3779b97f4a8UL,     0x4001e3779b97cd51UL,     0x4001e3779b981bfeUL, 
            0x40007e0f66afed07UL,     0x4006a09e667f3bcdUL,     0x40001fe03f61bad0UL,     0x4011e3779b97f4a8UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x3fd0000000000000UL,     0x7fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x6a83b03385a2fc07UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL, 
            0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL, 
            0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL, 
            0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL,     0x3fd0000000000000UL, 
            0x3ff07e0f66afed07UL,     0x3ff07e0f66b097b2UL,     0x3ff07e0f66af425cUL,     0x3fe1e3779b97f4a8UL, 
            0x40001fe03f61bad0UL,     0x3fd6a09e667f3bcdUL,     0x401007fe00ff6070UL,     0x3ff07e0f66afed07UL, 
            0x3ff07e0f66af425cUL,     0x3ff07e0f66b097b2UL,     0x3fe1e3779b97f4a8UL,     0x40001fe03f61bad0UL, 
            0x3fd6a09e667f3bcdUL,     0x401007fe00ff6070UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x4010000000000000UL,     0x7fefffffffffffffUL,     0x7ff8000000000000UL,     0x6a83b03385a2fc07UL, 
            0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL, 
            0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL, 
            0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL,     0x4010000000000000UL, 
            0x4010000000000000UL,     0x4010000000000000UL,     0x40107e0f66afed07UL,     0x40107e0f66aff7b2UL, 
            0x40107e0f66afe25cUL,     0x40101fe03f61bad0UL,     0x4011e3779b97f4a8UL,     0x401007fe00ff6070UL, 
            0x4016a09e667f3bcdUL,     0x40107e0f66afed07UL,     0x40107e0f66afe25cUL,     0x40107e0f66aff7b2UL, 
            0x40101fe03f61bad0UL,     0x4011e3779b97f4a8UL,     0x401007fe00ff6070UL,     0x4016a09e667f3bcdUL, 
    
        )
    
    
        checkAnswers(::hypot, arguments, answers, true)
    }
    
    @Test
    fun testSqrt() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x1e60000000000000UL,     0x5fefffffffffffffUL, 
            0x7ff8000000000000UL,     0x553919ad633b2c6fUL,     0x0UL,     0x3eca86f0875fcf94UL, 
            0x7ff8000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3eca86f0875fcf94UL,     0x7ff8000000000000UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3ff0000000000000UL,     0x3ff00000000057f6UL,     0x3fefffffffff5014UL,     0x3fe6a09e667f3bcdUL, 
            0x3ff6a09e667f3bcdUL,     0x3fe0000000000000UL,     0x4000000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL, 
        )
    
    
        checkAnswers(::sqrt, arguments, answers, true)
    }
    
    @Test
    fun testExp() {
        val answers = arrayOf(
            0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL, 
            0x3feffffffffea028UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3feffffffffea028UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x4005bf0a8b145769UL,     0x4005bf0a8b154684UL,     0x4005bf0a8b13684fUL,     0x3ffa61298e1e069cUL, 
            0x401d8e64b8d4ddaeUL,     0x3ff48b5e3c3e8186UL,     0x404b4c902e273a58UL,     0x3fd78b56362cef38UL, 
            0x3fd78b56362df217UL,     0x3fd78b56362bec59UL,     0x3fe368b2fc6f960aUL,     0x3fc152aaa3bf81ccUL, 
            0x3fe8ebef9eac820bUL,     0x3f92c155b8213cf4UL, 
        )
    
    
        checkAnswers(::exp, arguments, answers, false)
    }
    
    @Test
    fun testExpm1() {
        val answers = arrayOf(
            0xbff0000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x0UL,     0x3da5fd7fe179dd7aUL, 
            0xbda5fd7fe178ebb0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe179dd7aUL,     0xbda5fd7fe178ebb0UL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3ffb7e151628aed2UL,     0x3ffb7e15162a8d07UL,     0x3ffb7e151626d09eUL,     0x3fe4c2531c3c0d38UL, 
            0x40198e64b8d4ddaeUL,     0x3fd22d78f0fa061aUL,     0x404acc902e273a58UL,     0xbfe43a54e4e98864UL, 
            0xbfe43a54e4e906f4UL,     0xbfe43a54e4ea09d4UL,     0xbfd92e9a0720d3ecUL,     0xbfebab5557101f8dUL, 
            0xbfcc5041854df7d4UL,     0xbfef69f5523ef618UL, 
        )
    
    
        checkAnswers(::expm1, arguments, answers, true)
    }
    
    @Test
    fun testLog() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x8000000000000000UL,     0x3ff0000000000000UL,     0xbff0c80000000000UL, 
            0x7ff8000000000000UL,     0xbff938eef4e0b321UL,     0x7ff8000000000000UL,     0x403d6437a5e7a7edUL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x403d6437a5e7a7edUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0xc2d0ed360f2ec685UL,     0x42d0ed360f2e0c68UL,     0x4090c80000000000UL, 
            0xc090c80000000000UL,     0x4080c80000000000UL,     0xc080c80000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x0UL, 
            0xbfee829f39aef509UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x3ff80c54d0b019deUL, 
            0x7ff8000000000000UL,     0xc03c05ed8c8adffeUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0xc03c05ed8c8adffeUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x42d0237a93013752UL, 
            0xc2d0237a930085dfUL,     0xc090000000000000UL,     0x4090000000000000UL,     0xc080000000000000UL, 
            0x4080000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x0UL, 
            0xbfe44ca6c0f49887UL,     0x3fe54a64e56089faUL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0xc032a509f4f571e9UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0xc032a509f4f571e9UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x42c5799abcf4bf66UL, 
            0xc2c5799abcf3d346UL,     0xc0854a64e56089faUL,     0x40854a64e56089faUL,     0xc0754a64e56089faUL, 
            0x40754a64e56089faUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x8000000000000000UL, 
            0x3fa16b8647ffa4d2UL,     0xbfa245465683a05eUL,     0x7ff8000000000000UL,     0xbfab75fe5085436dUL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xc2826dc9d8770db4UL, 
            0x42826dc9d8764312UL,     0x404245465683a05eUL,     0xc04245465683a05eUL,     0x403245465683a05eUL, 
            0xc03245465683a05eUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x8000000000000000UL,     0x3fa16b8647ffa4d2UL,     0xbfa245465683a05eUL, 
            0x7ff8000000000000UL,     0xbfab75fe5085436dUL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0xc2826dc9d8770db4UL,     0x42826dc9d8764312UL,     0x404245465683a05eUL, 
            0xc04245465683a05eUL,     0x403245465683a05eUL,     0xc03245465683a05eUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xfff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0xfff0000000000000UL,     0x7ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x0UL,     0x8000000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x8000000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x8000000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x0UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x0UL,     0x8000000000000000UL,     0x0UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x0UL, 
            0xbd0e3f8c7be694a5UL,     0x3d0fb9a6d7f356e7UL,     0x7ff8000000000000UL,     0x3d17d776d6c2c683UL, 
            0x7ff8000000000000UL,     0xbd5bc85281584214UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0xbd5bc85281584214UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0xbfeffffffffea027UL,     0xbdafb9a6d7f356e7UL,     0x3dafb9a6d7f356e7UL,     0xbd9fb9a6d7f356e7UL, 
            0x3d9fb9a6d7f356e7UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x8000000000000000UL,     0x3d0e3f8c7be7e13cUL,     0xbd0fb9a6d7f4b3bbUL, 
            0x7ff8000000000000UL,     0xbd17d776d6c3cca9UL,     0x7ff8000000000000UL,     0x3d5bc8528159738eUL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3d5bc8528159738eUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0xbff000000000afedUL,     0x3ff0000000000000UL,     0x3dafb9a6d7f4b3bbUL, 
            0xbdafb9a6d7f4b3bbUL,     0x3d9fb9a6d7f4b3bbUL,     0xbd9fb9a6d7f4b3bbUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x8000000000000000UL, 
            0x3f4e829f39aef509UL,     0xbf50000000000000UL,     0x7ff8000000000000UL,     0xbf580c54d0b019deUL, 
            0x7ff8000000000000UL,     0x3f9c05ed8c8adffeUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3f9c05ed8c8adffeUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xc230237a93013752UL, 
            0x4230237a930085dfUL,     0x3ff0000000000000UL,     0xbff0000000000000UL,     0x3fe0000000000000UL, 
            0xbfe0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x0UL,     0xbf4e829f39aef509UL,     0x3f50000000000000UL, 
            0x7ff8000000000000UL,     0x3f580c54d0b019deUL,     0x7ff8000000000000UL,     0xbf9c05ed8c8adffeUL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xbf9c05ed8c8adffeUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x4230237a93013752UL,     0xc230237a930085dfUL,     0xbff0000000000000UL, 
            0x3ff0000000000000UL,     0xbfe0000000000000UL,     0x3fe0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x8000000000000000UL, 
            0x3f5e829f39aef509UL,     0xbf60000000000000UL,     0x7ff8000000000000UL,     0xbf680c54d0b019deUL, 
            0x7ff8000000000000UL,     0x3fac05ed8c8adffeUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3fac05ed8c8adffeUL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xc240237a93013752UL, 
            0x4240237a930085dfUL,     0x4000000000000000UL,     0xc000000000000000UL,     0x3ff0000000000000UL, 
            0xbff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x0UL,     0xbf5e829f39aef509UL,     0x3f60000000000000UL, 
            0x7ff8000000000000UL,     0x3f680c54d0b019deUL,     0x7ff8000000000000UL,     0xbfac05ed8c8adffeUL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0xbfac05ed8c8adffeUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x4240237a93013752UL,     0xc240237a930085dfUL,     0xc000000000000000UL, 
            0x4000000000000000UL,     0xbff0000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
    
        )
    
    
        checkAnswers(::log, arguments, answers, false)
    }
    
    @Test
    fun testLn() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0xc0874385446d71c3UL,     0x40862e42fefa39efUL, 
            0x7ff8000000000000UL,     0x407d83d9c3a25eabUL,     0xfff0000000000000UL,     0xc0395414621954feUL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL, 
            0xfff0000000000000UL,     0xfff0000000000000UL,     0xc0395414621954feUL,     0x7ff8000000000000UL, 
            0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL, 
            0x0UL,     0x3da5fd7fffff871bUL,     0xbda5fd80000078e5UL,     0xbfe62e42fefa39efUL, 
            0x3fe62e42fefa39efUL,     0xbff62e42fefa39efUL,     0x3ff62e42fefa39efUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL, 
        )
    
    
        checkAnswers(::ln, arguments, answers, false)
        val specialFunctionPointArguments = arrayOf(
            0x4005bf0a8b145769UL,     0x4005bf0a8b14af5fUL,     0x4005bf0a8b13ff73UL,     0x3ff5bf0a8b145769UL, 
            0x4015bf0a8b145769UL,     0x3fe5bf0a8b145769UL,     0x4025bf0a8b145769UL,     0xc005bf0a8b145769UL, 
            0xc005bf0a8b13ff73UL,     0xc005bf0a8b14af5fUL,     0xbff5bf0a8b145769UL,     0xc015bf0a8b145769UL, 
            0xbfe5bf0a8b145769UL,     0xc025bf0a8b145769UL, 
        )
    
        val specialFunctionPointResults = arrayOf(
            0x3ff0000000000000UL,     0x3ff00000000040b8UL,     0x3fefffffffff7e90UL,     0x3fd3a37a020b8c21UL, 
            0x3ffb17217f7d1cf7UL,     0xbfd8b90bfbe8e7beUL,     0x400317217f7d1cf7UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL, 
        )
    
        checkAnswers(::ln, specialFunctionPointArguments, specialFunctionPointResults, false)
    }
    
    @Test
    fun testLog10() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0xc07434e6420f4374UL,     0x40734413509f79ffUL, 
            0x7ff8000000000000UL,     0x4069a2edb0d17ca0UL,     0xfff0000000000000UL,     0xc026000000000000UL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL, 
            0xfff0000000000000UL,     0xfff0000000000000UL,     0xc026000000000000UL,     0x7ff8000000000000UL, 
            0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL, 
            0x0UL,     0x3d9319b8b8ecad6eUL,     0xbd9319b8b8ed7f71UL,     0xbfd34413509f79ffUL, 
            0x3fd34413509f79ffUL,     0xbfe34413509f79ffUL,     0x3fe34413509f79ffUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL, 
        )
    
    
        checkAnswers(::log10, arguments, answers, false)
        val specialFunctionPointArguments = arrayOf(
            0x4024000000000000UL,     0x40240000000015fdUL,     0x4023ffffffffea03UL,     0x4014000000000000UL, 
            0x4034000000000000UL,     0x4004000000000000UL,     0x4044000000000000UL,     0xc024000000000000UL, 
            0xc023ffffffffea03UL,     0xc0240000000015fdUL,     0xc014000000000000UL,     0xc034000000000000UL, 
            0xc004000000000000UL,     0xc044000000000000UL, 
        )
    
        val specialFunctionPointResults = arrayOf(
            0x3ff0000000000000UL,     0x3ff00000000007a4UL,     0x3feffffffffff0b9UL,     0x3fe65df657b04301UL, 
            0x3ff4d104d427de80UL,     0x3fd977d95ec10c02UL,     0x3ff9a209a84fbcffUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL, 
        )
    
        checkAnswers(::log10, specialFunctionPointArguments, specialFunctionPointResults, false)
    }
    
    @Test
    fun testLog2() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0xc090c80000000000UL,     0x4090000000000000UL, 
            0x7ff8000000000000UL,     0x40854a64e56089faUL,     0xfff0000000000000UL,     0xc04245465683a05eUL, 
            0x7ff8000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL, 
            0xfff0000000000000UL,     0xfff0000000000000UL,     0xc04245465683a05eUL,     0x7ff8000000000000UL, 
            0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL,     0xfff0000000000000UL, 
            0x0UL,     0x3dafb9a6d7f356e7UL,     0xbdafb9a6d7f4b3bbUL,     0xbff0000000000000UL, 
            0x3ff0000000000000UL,     0xc000000000000000UL,     0x4000000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL, 
        )
    
    
        checkAnswers(::log2, arguments, answers, false)
        val specialFunctionPointArguments = arrayOf(
            0x4000000000000000UL,     0x40000000000057f6UL,     0x3fffffffffff5014UL,     0x3ff0000000000000UL, 
            0x4010000000000000UL,     0x3fe0000000000000UL,     0x4020000000000000UL,     0xc000000000000000UL, 
            0xbfffffffffff5014UL,     0xc0000000000057f6UL,     0xbff0000000000000UL,     0xc010000000000000UL, 
            0xbfe0000000000000UL,     0xc020000000000000UL, 
        )
    
        val specialFunctionPointResults = arrayOf(
            0x3ff0000000000000UL,     0x3ff0000000007ee7UL,     0x3fefffffffff0233UL,     0x0UL, 
            0x4000000000000000UL,     0xbff0000000000000UL,     0x4008000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL, 
        )
    
        checkAnswers(::log2, specialFunctionPointArguments, specialFunctionPointResults, false)
    }
    
    @Test
    fun testLn1p() {
        val answers = arrayOf(
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x1UL,     0x40862e42fefa39efUL, 
            0x7ff8000000000000UL,     0x407d83d9c3a25eabUL,     0x0UL,     0x3da5fd7fe178ebb0UL, 
            0xbda5fd7fe179dd7aUL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x8000000000000000UL,     0x3da5fd7fe178ebb0UL,     0xbda5fd7fe179dd7aUL, 
            0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL,     0x8000000000000000UL, 
            0x3fe62e42fefa39efUL,     0x3fe62e42fefae9dbUL,     0x3fe62e42fef98a03UL,     0x3fd9f323ecbf984cUL, 
            0x3ff193ea7aad030aUL,     0x3fcc8ff7c79a9a22UL,     0x3ff9c041f7ed8d33UL,     0xfff0000000000000UL, 
            0xc039541460b5f6ffUL,     0x7ff8000000000000UL,     0xbfe62e42fefa39efUL,     0x7ff8000000000000UL, 
            0xbfd269621134db92UL,     0x7ff8000000000000UL, 
        )
    
    
        checkAnswers(::ln1p, arguments, answers, true)
        val specialFunctionPointArguments = arrayOf(
            0x4005bf0a8b145769UL,     0x4005bf0a8b14af5fUL,     0x4005bf0a8b13ff73UL,     0x3ff5bf0a8b145769UL, 
            0x4015bf0a8b145769UL,     0x3fe5bf0a8b145769UL,     0x4025bf0a8b145769UL,     0xc005bf0a8b145769UL, 
            0xc005bf0a8b13ff73UL,     0xc005bf0a8b14af5fUL,     0xbff5bf0a8b145769UL,     0xc015bf0a8b145769UL, 
            0xbfe5bf0a8b145769UL,     0xc025bf0a8b145769UL, 
        )
    
        val specialFunctionPointResults = arrayOf(
            0x3ff5031eafefb049UL,     0x3ff5031eafefdf99UL,     0x3ff5031eafef80f9UL,     0x3feb772c638242deUL, 
            0x3ffdcabb104c08abUL,     0x3fe097dd2c264e2aUL,     0x4003cb5212f5a2d3UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0xbff235a0dc5281b6UL,     0x7ff8000000000000UL, 
        )
    
        checkAnswers(::ln1p, specialFunctionPointArguments, specialFunctionPointResults, true)
    }
    
    @Test
    fun testPowWrapper() {
        val answers = arrayOf(
            0x0UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff0000000000000UL, 
            0x0UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff0000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x8000000000000000UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7ff0000000000000UL,     0x0UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x7ff0000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff0000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x3feffffffc00d970UL, 
            0x3ff0000001ff9348UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3feffffffc00d970UL,     0x3ff0000001ff9348UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x1UL,     0x1UL,     0x1UL,     0x1e60000000000000UL, 
            0x0UL,     0x2f26a09e667f3bcdUL,     0x0UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x6180000000000000UL,     0x7ff0000000000000UL, 
            0x50b6a09e667f3bcdUL,     0x7ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000001e7c24cUL,     0x3feffffffc307b69UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000001e7c24cUL,     0x3feffffffc307b69UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x7fefffffffffffffUL,     0x7ff0000000000000UL, 
            0x7feffffffc307b63UL,     0x5ff0000000000000UL,     0x7ff0000000000000UL,     0x4ff0000000000000UL, 
            0x7ff0000000000000UL,     0x4000000000000UL,     0x400000079f094UL,     0x3ffffff860f6dUL, 
            0x1ff0000000000000UL,     0x0UL,     0x2ff0000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000001448575UL,     0x3feffffffd76f516UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000001448575UL,     0x3feffffffd76f516UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x6a83b03385a2fc07UL,     0x6a83b03387325055UL, 
            0x6a83b0338413a7b9UL,     0x553919ad633b2c6fUL,     0x7ff0000000000000UL,     0x4a940a42b9189f4dUL, 
            0x7ff0000000000000UL,     0x155a015c0bc0eef1UL,     0x155a015c0dd06365UL,     0x155a015c09b17a7dUL, 
            0x2aa465ede115d454UL,     0x0UL,     0x35498c7e1e7729feUL,     0x0UL, 
            0x7ff0000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3fefffffffdd3059UL,     0x3ff00000001167d3UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3fefffffffdd3059UL,     0x3ff00000001167d3UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3da5fd7fe1796495UL,     0x3da5fd7fe161788bUL, 
            0x3da5fd7fe191509fUL,     0x3eca86f0875fcf94UL,     0x3b5e392010175ee5UL,     0x3f5d22a4fa316facUL, 
            0x36cc8b8218854565UL,     0x42374876e8000000UL,     0x42374876e7e6abecUL,     0x42374876e8195415UL, 
            0x41134d0f1066b7cdUL,     0x4480f0cf064dd593UL,     0x408192bb08b38ecdUL,     0x4911efc659cf7d4dUL, 
            0x7ff0000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0xbda5fd7fe1796495UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3b5e392010175ee5UL,     0x7ff8000000000000UL,     0x36cc8b8218854565UL,     0xc2374876e8000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x4480f0cf064dd593UL, 
            0x7ff8000000000000UL,     0x4911efc659cf7d4dUL,     0x7ff0000000000000UL,     0x0UL, 
            0x0UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x0UL, 
            0x0UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x0UL, 
            0x0UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x8000000000000000UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x3fefffffffdd3059UL, 
            0x3ff00000001167d3UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3fefffffffdd3059UL,     0x3ff00000001167d3UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3da5fd7fe1796495UL,     0x3da5fd7fe161788bUL,     0x3da5fd7fe191509fUL,     0x3eca86f0875fcf94UL, 
            0x3b5e392010175ee5UL,     0x3f5d22a4fa316facUL,     0x36cc8b8218854565UL,     0x42374876e8000000UL, 
            0x42374876e7e6abecUL,     0x42374876e8195415UL,     0x41134d0f1066b7cdUL,     0x4480f0cf064dd593UL, 
            0x408192bb08b38ecdUL,     0x4911efc659cf7d4dUL,     0x7ff0000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0xbda5fd7fe1796495UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3b5e392010175ee5UL,     0x7ff8000000000000UL, 
            0x36cc8b8218854565UL,     0xc2374876e8000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x4480f0cf064dd593UL,     0x7ff8000000000000UL,     0x4911efc659cf7d4dUL, 
            0x7ff0000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x8000000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0xfff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x0UL, 
            0x0UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x8000000000000000UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x8000000000000000UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0xfff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x0UL, 
            0x0UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x8000000000000000UL,     0x0UL, 
            0x0UL,     0x0UL,     0x0UL,     0x0UL, 
            0x0UL,     0xfff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff000000000afecUL,     0x3ff000000000afecUL, 
            0x3ff000000000afecUL,     0x3ff00000000057f6UL,     0x3ff0000000015fd8UL,     0x3ff0000000002bfbUL, 
            0x3ff000000002bfb0UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL, 
            0x3fefffffffff5014UL,     0x3feffffffffd4050UL,     0x3fefffffffffa80aUL,     0x3feffffffffa80a0UL, 
            0x7ff0000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3feffffffffea028UL,     0x3fefffffffff5014UL, 
            0x3feffffffffd4050UL,     0x3fefffffffffa80aUL,     0x3feffffffffa80a0UL,     0x3ff000000000afecUL, 
            0x3ff000000000afecUL,     0x3ff000000000afecUL,     0x3ff00000000057f6UL,     0x3ff0000000015fd8UL, 
            0x3ff0000000002bfbUL,     0x3ff000000002bfb0UL,     0x7ff0000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3fefffffffff0c1fUL,     0x3ff00000000079f1UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3fefffffffff0c1fUL,     0x3ff00000000079f1UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3fe0000000000000UL,     0x3fdfffffffff0c1fUL, 
            0x3fe00000000079f1UL,     0x3fe6a09e667f3bcdUL,     0x3fd0000000000000UL,     0x3feae89f995ad3adUL, 
            0x3fb0000000000000UL,     0x4000000000000000UL,     0x3fffffffffff0c1fUL,     0x40000000000079f1UL, 
            0x3ff6a09e667f3bcdUL,     0x4010000000000000UL,     0x3ff306fe0a31b715UL,     0x4030000000000000UL, 
            0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff00000000079f1UL, 
            0x3fefffffffff0c1fUL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff00000000079f1UL,     0x3fefffffffff0c1fUL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x4000000000000000UL,     0x40000000000079f1UL,     0x3fffffffffff0c1fUL,     0x3ff6a09e667f3bcdUL, 
            0x4010000000000000UL,     0x3ff306fe0a31b715UL,     0x4030000000000000UL,     0x3fe0000000000000UL, 
            0x3fe00000000079f1UL,     0x3fdfffffffff0c1fUL,     0x3fe6a09e667f3bcdUL,     0x3fd0000000000000UL, 
            0x3feae89f995ad3adUL,     0x3fb0000000000000UL,     0x7ff0000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x3ff0000000000000UL,     0x3feffffffffe183eUL,     0x3ff000000000f3e1UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3feffffffffe183eUL,     0x3ff000000000f3e1UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3fd0000000000000UL,     0x3fcffffffffe183eUL, 
            0x3fd000000000f3e1UL,     0x3fe0000000000000UL,     0x3fb0000000000000UL,     0x3fe6a09e667f3bcdUL, 
            0x3f70000000000000UL,     0x4010000000000000UL,     0x400ffffffffe183eUL,     0x401000000000f3e1UL, 
            0x4000000000000000UL,     0x4030000000000000UL,     0x3ff6a09e667f3bcdUL,     0x4070000000000000UL, 
            0x0UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff000000000f3e1UL, 
            0x3feffffffffe183eUL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff000000000f3e1UL,     0x3feffffffffe183eUL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x4010000000000000UL,     0x401000000000f3e1UL,     0x400ffffffffe183eUL,     0x4000000000000000UL, 
            0x4030000000000000UL,     0x3ff6a09e667f3bcdUL,     0x4070000000000000UL,     0x3fd0000000000000UL, 
            0x3fd000000000f3e1UL,     0x3fcffffffffe183eUL,     0x3fe0000000000000UL,     0x3fb0000000000000UL, 
            0x3fe6a09e667f3bcdUL,     0x3f70000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0xbff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL, 
            0x3ff0000000000000UL,     0xbff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x7ff0000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0xbfeffffffffea028UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3feffffffffd4050UL,     0x7ff8000000000000UL,     0x3feffffffffa80a0UL,     0xbff000000000afecUL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000015fd8UL, 
            0x7ff8000000000000UL,     0x3ff000000002bfb0UL,     0x0UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0xbff000000000afecUL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000015fd8UL,     0x7ff8000000000000UL, 
            0x3ff000000002bfb0UL,     0xbfeffffffffea028UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3feffffffffd4050UL,     0x7ff8000000000000UL,     0x3feffffffffa80a0UL, 
            0x7ff0000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0xbfe0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3fd0000000000000UL,     0x7ff8000000000000UL,     0x3fb0000000000000UL,     0xc000000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x4010000000000000UL, 
            0x7ff8000000000000UL,     0x4030000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0xc000000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x4010000000000000UL,     0x7ff8000000000000UL, 
            0x4030000000000000UL,     0xbfe0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3fd0000000000000UL,     0x7ff8000000000000UL,     0x3fb0000000000000UL, 
            0x7ff0000000000000UL,     0x0UL,     0x7ff8000000000000UL,     0x0UL, 
            0x7ff8000000000000UL,     0x0UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0xbfd0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x3fb0000000000000UL,     0x7ff8000000000000UL,     0x3f70000000000000UL,     0xc010000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x4030000000000000UL, 
            0x7ff8000000000000UL,     0x4070000000000000UL,     0x0UL,     0x7ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff0000000000000UL, 
            0x3ff0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x3ff0000000000000UL,     0x3ff0000000000000UL, 
            0x3ff0000000000000UL,     0x3ff0000000000000UL,     0xc010000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x7ff8000000000000UL,     0x4030000000000000UL,     0x7ff8000000000000UL, 
            0x4070000000000000UL,     0xbfd0000000000000UL,     0x7ff8000000000000UL,     0x7ff8000000000000UL, 
            0x7ff8000000000000UL,     0x3fb0000000000000UL,     0x7ff8000000000000UL,     0x3f70000000000000UL, 
    
        )
    
    
        checkAnswers(::powWrapper, arguments, answers, false)
    }
    
}
        
