/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.text

//
// NOTE: THIS FILE IS AUTO-GENERATED by the GenerateUnicodeData.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

// 174 ranges totally
private val rangeStart = intArrayOf(
    0x0041, 0x00c0, 0x00d8, 0x0100, 0x0130, 0x0132, 0x0139, 0x014a, 0x0178, 0x0179, 0x0181, 0x0182, 0x0186, 0x0187, 0x0189, 0x018b, 0x018e, 0x018f, 0x0190, 0x0191, 
    0x0193, 0x0194, 0x0196, 0x0197, 0x0198, 0x019c, 0x019d, 0x019f, 0x01a0, 0x01a6, 0x01a7, 0x01a9, 0x01ac, 0x01ae, 0x01af, 0x01b1, 0x01b3, 0x01b7, 0x01b8, 0x01c4, 
    0x01c5, 0x01c7, 0x01c8, 0x01ca, 0x01cb, 0x01de, 0x01f1, 0x01f2, 0x01f6, 0x01f7, 0x01f8, 0x0220, 0x0222, 0x023a, 0x023b, 0x023d, 0x023e, 0x0241, 0x0243, 0x0244, 
    0x0245, 0x0246, 0x0370, 0x0376, 0x037f, 0x0386, 0x0388, 0x038c, 0x038e, 0x0391, 0x03a3, 0x03cf, 0x03d8, 0x03f4, 0x03f7, 0x03f9, 0x03fa, 0x03fd, 0x0400, 0x0410, 
    0x0460, 0x048a, 0x04c0, 0x04c1, 0x04d0, 0x0531, 0x10a0, 0x10c7, 0x13a0, 0x13f0, 0x1c90, 0x1cbd, 0x1e00, 0x1e9e, 0x1ea0, 0x1f08, 0x1f18, 0x1f28, 0x1f38, 0x1f48, 
    0x1f59, 0x1f68, 0x1f88, 0x1f98, 0x1fa8, 0x1fb8, 0x1fba, 0x1fbc, 0x1fc8, 0x1fcc, 0x1fd8, 0x1fda, 0x1fe8, 0x1fea, 0x1fec, 0x1ff8, 0x1ffa, 0x1ffc, 0x2126, 0x212a, 
    0x212b, 0x2132, 0x2160, 0x2183, 0x24b6, 0x2c00, 0x2c60, 0x2c62, 0x2c63, 0x2c64, 0x2c67, 0x2c6d, 0x2c6e, 0x2c6f, 0x2c70, 0x2c72, 0x2c7e, 0x2c80, 0x2ceb, 0x2cf2, 
    0xa640, 0xa680, 0xa722, 0xa732, 0xa779, 0xa77d, 0xa77e, 0xa78b, 0xa78d, 0xa790, 0xa796, 0xa7aa, 0xa7ab, 0xa7ac, 0xa7ad, 0xa7ae, 0xa7b0, 0xa7b1, 0xa7b2, 0xa7b3, 
    0xa7b4, 0xa7c2, 0xa7c4, 0xa7c5, 0xa7c6, 0xa7c7, 0xa7f5, 0xff21, 0x10400, 0x104b0, 0x10c80, 0x118a0, 0x16e40, 0x1e900, 
)

private val rangeLength = intArrayOf(
    0x2011a, 0x20117, 0x20107, 0x122f, -0xc6eff, 0x1205, 0x120f, 0x122d, -0x78eff, 0x1205, 0xd2101, 0x1203, 0xce101, 0x1101, 0xcd102, 0x1101, 0x4f101, 0xca101, 0xcb101, 0x1101, 
    0xcd101, 0xcf101, 0xd3101, 0xd1101, 0x1101, 0xd3101, 0xd5101, 0xd6101, 0x1205, 0xda101, 0x1101, 0xda101, 0x1101, 0xda101, 0x1101, 0xd9102, 0x1203, 0xdb101, 0x1405, 0x2101, 
    0x1101, 0x2101, 0x1101, 0x2101, 0x1211, 0x1211, 0x2101, 0x1203, -0x60eff, -0x37eff, 0x1227, -0x81eff, 0x1211, 0x2a2b101, 0x1101, -0xa2eff, 0x2a28101, 0x1101, -0xc2eff, 0x45101, 
    0x47101, 0x1209, 0x1203, 0x1101, 0x74101, 0x26101, 0x25103, 0x40101, 0x3f102, 0x20111, 0x20109, 0x8101, 0x1217, -0x3beff, 0x1101, -0x6eff, 0x1101, -0x81efd, 0x50110, 0x20120, 
    0x1221, 0x1235, 0xf101, 0x120d, 0x125f, 0x30126, 0x1c60126, 0x1c60607, 0x97d0150, 0x8106, -0xbbfed5, -0xbbfefd, 0x1295, -0x1dbeeff, 0x125f, -0x7ef8, -0x7efa, -0x7ef8, -0x7ef8, -0x7efa, 
    -0x7df9, -0x7ef8, -0x7ef8, -0x7ef8, -0x7ef8, -0x7efe, -0x49efe, -0x8eff, -0x55efc, -0x8eff, -0x7efe, -0x63efe, -0x7efe, -0x6fefe, -0x6eff, -0x7fefe, -0x7defe, -0x8eff, -0x1d5ceff, -0x20beeff, 
    -0x2045eff, 0x1c101, 0x10110, 0x1101, 0x1a11a, 0x3012f, 0x1101, -0x29f6eff, -0xee5eff, -0x29e6eff, 0x1205, -0x2a1beff, -0x29fceff, -0x2a1eeff, -0x2a1deff, 0x1304, -0x2a3eefe, 0x1263, 0x1203, 0x1101, 
    0x122d, 0x121b, 0x120d, 0x123d, 0x1203, -0x8a03eff, 0x1209, 0x1101, -0xa527eff, 0x1203, 0x1213, -0xa543eff, -0xa54eeff, -0xa54aeff, -0xa540eff, -0xa543eff, -0xa511eff, -0xa529eff, -0xa514eff, 0x3a0101, 
    0x120b, 0x1101, -0x2feff, -0xa542eff, -0x8a37eff, 0x1203, 0x1101, 0x2011a, 0x28128, 0x28124, 0x40133, 0x20120, 0x20120, 0x22122, 
)

internal fun Int.lowercaseCodePoint(): Int {
    if (this in 0x41..0x5a) {
        return this + 32
    }
    if (this < 0x80) {
        return this
    }
    val index = binarySearchRange(rangeStart, this)
    return equalDistanceMapping(this, rangeStart[index], rangeLength[index])
}

internal fun Char.lowercaseCharImpl(): Char {
    return code.lowercaseCodePoint().toChar()
}
