/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */


package test.generated.minmax

//
// NOTE: THIS FILE IS AUTO-GENERATED by the MinMaxTestGenerator.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import kotlin.math.pow
import kotlin.test.*
import test.*

class MinMaxUIntArrayTest {

    
    private fun expectMinMax(min: UInt, max: UInt, elements: UIntArray) {
        assertEquals(min, elements.minOrNull())
        assertEquals(max, elements.maxOrNull())
        assertEquals(min, elements.min())
        assertEquals(max, elements.max())
    }

    @Test
    fun minMax() {
        expectMinMax(1U, 1U, uintArrayOf(1U))
        expectMinMax(1U, 2U, uintArrayOf(1U, 2U))
        expectMinMax(1U, UInt.MAX_VALUE, uintArrayOf(1U, 2U, UInt.MAX_VALUE))
                    
    }

    @Test
    fun minMaxEmpty() {
        val empty = uintArrayOf()
        assertNull(empty.minOrNull())
        assertNull(empty.maxOrNull())
        assertFailsWith<NoSuchElementException> { empty.min() }
        assertFailsWith<NoSuchElementException> { empty.max() }
    }



    private fun expectMinMaxWith(min: UInt, max: UInt, elements: UIntArray, comparator: Comparator<UInt>) {
        assertEquals(min, elements.minWithOrNull(comparator))
        assertEquals(max, elements.maxWithOrNull(comparator))
        assertEquals(min, elements.minWith(comparator))
        assertEquals(max, elements.maxWith(comparator))
    }

    @Test
    fun minMaxWith() {
        expectMinMaxWith(1U, 1U, uintArrayOf(1U), naturalOrder())
        expectMinMaxWith(1U, 2U, uintArrayOf(1U, 2U), naturalOrder())
        expectMinMaxWith(1U, UInt.MAX_VALUE, uintArrayOf(1U, 2U, UInt.MAX_VALUE), naturalOrder())

    }

    @Test
    fun minMaxWithEmpty() {
        val empty = uintArrayOf()
        assertNull(empty.minWithOrNull(naturalOrder()))
        assertNull(empty.maxWithOrNull(naturalOrder()))
        assertFailsWith<NoSuchElementException> { empty.minWith(naturalOrder()) }
        assertFailsWith<NoSuchElementException> { empty.maxWith(naturalOrder()) }
    }


    private inline fun <K : Comparable<K>> expectMinMaxBy(min: UInt, max: UInt, elements: UIntArray, selector: (UInt) -> K) {
        assertEquals(min, elements.minBy(selector))
        assertEquals(min, elements.minByOrNull(selector))
        assertEquals(max, elements.maxBy(selector))
        assertEquals(max, elements.maxByOrNull(selector))
    }

    @Test
    fun minMaxBy() {
        expectMinMaxBy(1U, 1U, uintArrayOf(1U), { it })
        expectMinMaxBy(1U, 2U, uintArrayOf(1U, 2U), { it })
        expectMinMaxBy(1U, UInt.MAX_VALUE, uintArrayOf(1U, 2U, UInt.MAX_VALUE), { it })

    }

    @Test
    fun minMaxByEmpty() {
        val empty = uintArrayOf()
        assertNull(empty.minByOrNull { it.toString() })
        assertNull(empty.maxByOrNull { it.toString() })
        assertFailsWith<NoSuchElementException> { empty.minBy { it.toString() } }
        assertFailsWith<NoSuchElementException> { empty.maxBy { it.toString() } }                       
    }

    @Test 
    fun minBySelectorEvaluateOnce() {
        val source = uintArrayOf(1U, 2U, UInt.MAX_VALUE)
        var c = 0
        source.minBy { c++ }
        assertEquals(3, c)
        c = 0
        source.minByOrNull { c++ }
        assertEquals(3, c)
    }

    @Test 
    fun maxBySelectorEvaluateOnce() {
        val source = uintArrayOf(1U, 2U, UInt.MAX_VALUE)
        var c = 0
        source.maxBy { c++ }
        assertEquals(3, c)
        c = 0
        source.maxByOrNull { c++ }
        assertEquals(3, c)
    }
    
    
    private inline fun <R : Comparable<R>> expectMinMaxOf(min: R, max: R, elements: UIntArray, selector: (UInt) -> R) {
        assertEquals(min, elements.minOf(selector))
        assertEquals(min, elements.minOfOrNull(selector))
        assertEquals(max, elements.maxOf(selector))
        assertEquals(max, elements.maxOfOrNull(selector))
    }
    
    @Test
    fun minMaxOf() {
        expectMinMaxOf((0u - 1U).toUInt(), (0u - 1U).toUInt(), uintArrayOf(1U), { (0u - it).toUInt() })
        expectMinMaxOf((0u - 2U).toUInt(), (0u - 1U).toUInt(), uintArrayOf(1U, 2U), { (0u - it).toUInt() })
        expectMinMaxOf((0u - UInt.MAX_VALUE).toUInt(), (0u - 1U).toUInt(), uintArrayOf(1U, 2U, UInt.MAX_VALUE), { (0u - it).toUInt() })

    }
    
    @Test
    fun minMaxOfDouble() {
        val middle = 2U
        val items = uintArrayOf(1U, 2U, UInt.MAX_VALUE).apply { shuffle() }
        assertTrue(items.minOf { it.compareTo(middle).toDouble().pow(0.5) }.isNaN())
        assertTrue(items.minOfOrNull { it.compareTo(middle).toDouble().pow(0.5) }!!.isNaN())
        assertTrue(items.maxOf { it.compareTo(middle).toDouble().pow(0.5) }.isNaN())
        assertTrue(items.maxOfOrNull { it.compareTo(middle).toDouble().pow(0.5) }!!.isNaN())
        
        assertIsNegativeZero(items.minOf { it.compareTo(middle) * 0.0 })
        assertIsNegativeZero(items.minOfOrNull { it.compareTo(middle) * 0.0 }!!)
        assertIsPositiveZero(items.maxOf { it.compareTo(middle) * 0.0 })
        assertIsPositiveZero(items.maxOfOrNull { it.compareTo(middle) * 0.0 }!!)
    }
    
    @Test
    fun minMaxOfFloat() {
        val middle = 2U
        val items = uintArrayOf(1U, 2U, UInt.MAX_VALUE).apply { shuffle() }
        assertTrue(items.minOf { it.compareTo(middle).toFloat().pow(0.5F) }.isNaN())
        assertTrue(items.minOfOrNull { it.compareTo(middle).toFloat().pow(0.5F) }!!.isNaN())
        assertTrue(items.maxOf { it.compareTo(middle).toFloat().pow(0.5F) }.isNaN())
        assertTrue(items.maxOfOrNull { it.compareTo(middle).toFloat().pow(0.5F) }!!.isNaN())
        
        assertIsNegativeZero(items.minOf { it.compareTo(middle) * 0.0F }.toDouble())
        assertIsNegativeZero(items.minOfOrNull { it.compareTo(middle) * 0.0F }!!.toDouble())
        assertIsPositiveZero(items.maxOf { it.compareTo(middle) * 0.0F }.toDouble())
        assertIsPositiveZero(items.maxOfOrNull { it.compareTo(middle) * 0.0F }!!.toDouble())
    }
    
    @Test
    fun minMaxOfEmpty() {
        val empty = uintArrayOf()

        assertNull(empty.minOfOrNull { it.toString() })
        assertNull(empty.maxOfOrNull { it.toString() })
        assertFailsWith<NoSuchElementException> { empty.minOf { it.toString() } }
        assertFailsWith<NoSuchElementException> { empty.maxOf { it.toString() } }                       


        assertNull(empty.minOfOrNull { 0.0 })
        assertNull(empty.maxOfOrNull { 0.0 })
        assertFailsWith<NoSuchElementException> { empty.minOf { 0.0 } }
        assertFailsWith<NoSuchElementException> { empty.maxOf { 0.0 } }                       


        assertNull(empty.minOfOrNull { 0.0F })
        assertNull(empty.maxOfOrNull { 0.0F })
        assertFailsWith<NoSuchElementException> { empty.minOf { 0.0F } }
        assertFailsWith<NoSuchElementException> { empty.maxOf { 0.0F } }                       


    }
    
    
    private inline fun <R> expectMinMaxOfWith(min: R, max: R, elements: UIntArray, comparator: Comparator<R>, selector: (UInt) -> R) {
        assertEquals(min, elements.minOfWith(comparator, selector))
        assertEquals(min, elements.minOfWithOrNull(comparator, selector))
        assertEquals(max, elements.maxOfWith(comparator, selector))
        assertEquals(max, elements.maxOfWithOrNull(comparator, selector))
    }
    
    @Test
    fun minMaxOfWith() {
        expectMinMaxOfWith((0u - 1U).toUInt(), (0u - 1U).toUInt(), uintArrayOf(1U), reverseOrder(), { (0u - it).toUInt() })
        expectMinMaxOfWith((0u - 1U).toUInt(), (0u - 2U).toUInt(), uintArrayOf(1U, 2U), reverseOrder(), { (0u - it).toUInt() })
        expectMinMaxOfWith((0u - 1U).toUInt(), (0u - UInt.MAX_VALUE).toUInt(), uintArrayOf(1U, 2U, UInt.MAX_VALUE), reverseOrder(), { (0u - it).toUInt() })

    }
    
    @Test
    fun minMaxOfWithEmpty() {
        val empty = uintArrayOf()
        assertNull(empty.minOfWithOrNull(naturalOrder()) { it.toString() })
        assertNull(empty.maxOfWithOrNull(naturalOrder()) { it.toString() })
        assertFailsWith<NoSuchElementException> { empty.minOfWith(naturalOrder()) { it.toString() } }
        assertFailsWith<NoSuchElementException> { empty.maxOfWith(naturalOrder()) { it.toString() } }
    }

}
