/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.text

//
// NOTE: THIS FILE IS AUTO-GENERATED by the GenerateUnicodeData.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

// 189 ranges totally
@SharedImmutable
private val rangeStart = intArrayOf(
    0x0061, 0x00b5, 0x00e0, 0x00f8, 0x00ff, 0x0101, 0x0131, 0x0133, 0x013a, 0x014b, 0x017a, 0x017f, 0x0180, 0x0183, 0x0188, 0x0192, 0x0195, 0x0199, 0x019a, 0x019e, 
    0x01a1, 0x01a8, 0x01b0, 0x01b6, 0x01bd, 0x01bf, 0x01c5, 0x01c6, 0x01c8, 0x01c9, 0x01cb, 0x01cc, 0x01ce, 0x01dd, 0x01df, 0x01f2, 0x01f3, 0x01f5, 0x01fb, 0x0223, 
    0x023c, 0x023f, 0x0242, 0x0249, 0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0256, 0x0259, 0x025b, 0x025c, 0x0260, 0x0261, 0x0263, 0x0265, 0x0266, 0x0268, 0x0269, 
    0x026a, 0x026b, 0x026c, 0x026f, 0x0271, 0x0272, 0x0275, 0x027d, 0x0280, 0x0282, 0x0283, 0x0287, 0x0288, 0x0289, 0x028a, 0x028c, 0x0292, 0x029d, 0x029e, 0x0345, 
    0x0371, 0x0377, 0x037b, 0x03ac, 0x03ad, 0x03b1, 0x03c2, 0x03c3, 0x03cc, 0x03cd, 0x03d0, 0x03d1, 0x03d5, 0x03d6, 0x03d7, 0x03d9, 0x03f0, 0x03f1, 0x03f2, 0x03f3, 
    0x03f5, 0x03f8, 0x0430, 0x0450, 0x0461, 0x048b, 0x04c2, 0x04cf, 0x04d1, 0x0561, 0x10d0, 0x10fd, 0x13f8, 0x1c80, 0x1c81, 0x1c82, 0x1c83, 0x1c85, 0x1c86, 0x1c87, 
    0x1c88, 0x1d79, 0x1d7d, 0x1d8e, 0x1e01, 0x1e9b, 0x1ea1, 0x1f00, 0x1f10, 0x1f20, 0x1f30, 0x1f40, 0x1f51, 0x1f60, 0x1f70, 0x1f72, 0x1f76, 0x1f78, 0x1f7a, 0x1f7c, 
    0x1f80, 0x1f90, 0x1fa0, 0x1fb0, 0x1fb3, 0x1fbe, 0x1fc3, 0x1fd0, 0x1fe0, 0x1fe5, 0x1ff3, 0x214e, 0x2170, 0x2184, 0x24d0, 0x2c30, 0x2c61, 0x2c65, 0x2c66, 0x2c68, 
    0x2c73, 0x2c81, 0x2cec, 0x2cf3, 0x2d00, 0x2d27, 0xa641, 0xa681, 0xa723, 0xa733, 0xa77a, 0xa77f, 0xa78c, 0xa793, 0xa794, 0xa797, 0xa7b5, 0xa7c3, 0xa7ca, 0xa7f6, 
    0xab53, 0xab70, 0xff41, 0x10428, 0x104d8, 0x10cc0, 0x118c0, 0x16e60, 0x1e922, 
)

@SharedImmutable
private val rangeLength = intArrayOf(
    -0x1fee6, 0x2e7101, -0x1fee9, -0x1fef9, 0x79101, -0x0dd1, -0xe7eff, -0x0dfb, -0x0df1, -0x0dd3, -0x0dfb, -0x12beff, 0xc3101, -0x0dfd, -0x0bfb, -0x0eff, 0x61101, -0x0eff, 0xa3101, 0x82101, 
    -0x0dfb, -0x0afa, -0x0bfb, -0x0cfc, -0x0eff, 0x38101, -0x0eff, -0x1eff, -0x0eff, -0x1eff, -0x0eff, -0x1eff, -0x0df1, -0x4eeff, -0x0def, -0x0eff, -0x1eff, -0x0bfb, -0x0ddb, -0x0def, 
    -0x0eff, 0x2a3f102, -0x0afa, -0x0df9, 0x2a1f101, 0x2a1c101, 0x2a1e101, -0xd1eff, -0xcdeff, -0xccefe, -0xc9eff, -0xcaeff, 0xa54f101, -0xcceff, 0xa54b101, -0xceeff, 0xa528101, 0xa544101, -0xd0eff, -0xd2eff, 
    0xa544101, 0x29f7101, 0xa541101, -0xd2eff, 0x29fd101, -0xd4eff, -0xd5eff, 0x29e7101, -0xd9eff, 0xa543101, -0xd9eff, 0xa52a101, -0xd9eff, -0x44eff, -0xd8efe, -0x46eff, -0xdaeff, 0xa515101, 0xa512101, 0x54101, 
    -0x0dfd, -0x0eff, 0x82103, -0x25eff, -0x24efd, -0x1feef, -0x1eeff, -0x1fef7, -0x3feff, -0x3eefe, -0x3deff, -0x38eff, -0x2eeff, -0x35eff, -0x7eff, -0x0de9, -0x55eff, -0x4feff, 0x7101, -0x73eff, 
    -0x5feff, -0x0cfc, -0x1fee0, -0x4fef0, -0x0ddf, -0x0dcb, -0x0df3, -0xeeff, -0x0da1, -0x2feda, 0xbc012b, 0xbc0103, -0x7efa, -0x186deff, -0x186ceff, -0x1863eff, -0x1861efe, -0x1862eff, -0x185beff, -0x1824eff, 
    0x89c2101, 0x8a04101, 0xee6101, 0x8a38101, -0x0d6b, -0x3aeff, -0x0da1, 0x8108, 0x8106, 0x8108, 0x8108, 0x8106, 0x8207, 0x8108, 0x4a102, 0x56104, 0x64102, 0x80102, 0x70102, 0x7e102, 
    0x8108, 0x8108, 0x8108, 0x8102, 0x9101, -0x1c24eff, 0x9101, 0x8102, 0x8102, 0x7101, 0x9101, -0x1beff, -0xfef0, -0x0eff, -0x19ee6, -0x2fed1, -0x0eff, -0x2a2aeff, -0x2a27eff, -0x0dfb, 
    -0x0cfc, -0x0d9d, -0x0dfd, -0x0eff, -0x1c5feda, -0x1c5f9f9, -0x0dd3, -0x0de5, -0x0df3, -0x0dc3, -0x0dfd, -0x0df7, -0x0afa, -0x0eff, 0x30101, -0x0ded, -0x0df5, -0x0afa, -0x0eff, -0x0eff, 
    -0x39feff, -0x97cfeb0, -0x1fee6, -0x27ed8, -0x27edc, -0x3fecd, -0x1fee0, -0x1fee0, -0x21ede, 
)

internal fun equalDistanceMapping(code: Int, start: Int, pattern: Int): Int {
    val diff = code - start

    val length = pattern and 0xff
    if (diff >= length) {
        return code
    }

    val distance = (pattern shr 8) and 0xf
    if (diff % distance != 0) {
        return code
    }

    val mapping = pattern shr 12
    return code + mapping
}

internal fun Int.uppercaseCodePoint(): Int {
    if (this in 0x61..0x7a) {
        return this - 32
    }
    if (this < 0x80) {
        return this
    }
    val index = binarySearchRange(rangeStart, this)
    return equalDistanceMapping(this, rangeStart[index], rangeLength[index])
}

internal fun Char.uppercaseCharImpl(): Char {
    return code.uppercaseCodePoint().toChar()
}
