/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.text

//
// NOTE: THIS FILE IS AUTO-GENERATED by the GenerateUnicodeData.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

// 222 ranges totally
@SharedImmutable
private val rangeStart = intArrayOf(
    0x0041, 0x0061, 0x00aa, 0x00ba, 0x00c0, 0x00d8, 0x00df, 0x00f8, 0x00ff, 0x0138, 0x0149, 0x0172, 0x0181, 0x0190, 0x019f, 0x01ae, 0x01bd, 0x01cc, 0x01dd, 0x01e9, 
    0x01f8, 0x0231, 0x0240, 0x024f, 0x0294, 0x02a3, 0x02b2, 0x02ec, 0x0370, 0x037f, 0x038e, 0x039d, 0x03ac, 0x03c8, 0x03d7, 0x03ee, 0x03fd, 0x0430, 0x045f, 0x048a, 
    0x04c1, 0x04cf, 0x0531, 0x0559, 0x0560, 0x05d0, 0x066e, 0x06e5, 0x06ff, 0x074d, 0x07f4, 0x081a, 0x0840, 0x08b6, 0x0950, 0x0985, 0x09aa, 0x09bd, 0x09df, 0x0a05, 
    0x0a2a, 0x0a39, 0x0a72, 0x0a93, 0x0ab5, 0x0ae0, 0x0b0f, 0x0b32, 0x0b5c, 0x0b83, 0x0b92, 0x0ba3, 0x0bd0, 0x0c12, 0x0c58, 0x0c85, 0x0caa, 0x0cde, 0x0d04, 0x0d3d, 
    0x0d5f, 0x0d9a, 0x0dc0, 0x0e40, 0x0e86, 0x0ea7, 0x0ec0, 0x0f00, 0x0f88, 0x1050, 0x1065, 0x108e, 0x10a0, 0x10bf, 0x10d0, 0x10f1, 0x1100, 0x124a, 0x125a, 0x1290, 
    0x12c0, 0x12d8, 0x1380, 0x13a0, 0x13f8, 0x1401, 0x166f, 0x16f1, 0x1720, 0x176e, 0x17dc, 0x1887, 0x1900, 0x1980, 0x1a20, 0x1b45, 0x1bba, 0x1c5a, 0x1c80, 0x1c90, 
    0x1cbd, 0x1ce9, 0x1cfa, 0x1d00, 0x1d2c, 0x1d6a, 0x1d79, 0x1d9b, 0x1e00, 0x1e95, 0x1e9d, 0x1f00, 0x1f0f, 0x1f20, 0x1f2f, 0x1f3e, 0x1f4d, 0x1f5d, 0x1f6c, 0x1f7b, 
    0x1f8a, 0x1f99, 0x1fa8, 0x1fae, 0x1fbe, 0x1fd0, 0x1fe0, 0x1ff2, 0x2071, 0x2102, 0x210f, 0x2124, 0x2131, 0x2145, 0x2183, 0x2c00, 0x2c30, 0x2c60, 0x2c6f, 0x2c7e, 
    0x2c80, 0x2ce4, 0x2cf3, 0x2d00, 0x2d27, 0x2d36, 0x2da0, 0x2db8, 0x2dd0, 0x3005, 0x3041, 0x30fc, 0x31a0, 0x3400, 0x4e00, 0xa000, 0xa4d0, 0xa610, 0xa640, 0xa66e, 
    0xa680, 0xa69c, 0xa722, 0xa731, 0xa770, 0xa77f, 0xa78e, 0xa79d, 0xa7ac, 0xa7bb, 0xa7ca, 0xa7f5, 0xa804, 0xa840, 0xa8fb, 0xa930, 0xa9cf, 0xa9fa, 0xaa44, 0xaa7e, 
    0xaab9, 0xaadb, 0xab01, 0xab20, 0xab30, 0xab5c, 0xab70, 0xabc0, 0xd7b0, 0xf900, 0xfa70, 0xfb00, 0xfb13, 0xfb22, 0xfb3e, 0xfb4d, 0xfd50, 0xfe70, 0xff21, 0xff41, 
    0xff66, 0xffd2, 
)

@SharedImmutable
private val rangeLength = intArrayOf(
    0x001a, 0x001a, 0x000c, 0x0001, 0x0017, 0x0007, 0x0018, 0x0007, 0x0039, 0x0011, 0x0029, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x0011, 0x000c, 0x000f, 
    0x0039, 0x000f, 0x000f, 0x0045, 0x000f, 0x000f, 0x0033, 0x0003, 0x000e, 0x000e, 0x000f, 0x000f, 0x001c, 0x000f, 0x0017, 0x000f, 0x0033, 0x002f, 0x0023, 0x0037, 
    0x000e, 0x0061, 0x0026, 0x0001, 0x0029, 0x007b, 0x0068, 0x0018, 0x0031, 0x009e, 0x0022, 0x000f, 0x0075, 0x0088, 0x0031, 0x0024, 0x0010, 0x0021, 0x001e, 0x0024, 
    0x000f, 0x0026, 0x0020, 0x0021, 0x001c, 0x002d, 0x0022, 0x000c, 0x0016, 0x000e, 0x000e, 0x0017, 0x0041, 0x002c, 0x0029, 0x0024, 0x0014, 0x0015, 0x0037, 0x001a, 
    0x0038, 0x0024, 0x0074, 0x0045, 0x0020, 0x0017, 0x0020, 0x006d, 0x00b8, 0x0012, 0x001d, 0x0001, 0x001f, 0x000f, 0x0021, 0x000f, 0x0149, 0x000f, 0x0034, 0x002f, 
    0x0017, 0x0083, 0x0010, 0x0056, 0x0006, 0x026c, 0x007c, 0x0021, 0x004d, 0x006a, 0x00a9, 0x006f, 0x0075, 0x0097, 0x0114, 0x006b, 0x0096, 0x0024, 0x0009, 0x002b, 
    0x0003, 0x000e, 0x0001, 0x002c, 0x003e, 0x000f, 0x0022, 0x0025, 0x0095, 0x0008, 0x0063, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 
    0x000f, 0x000f, 0x0006, 0x000f, 0x000f, 0x000c, 0x000d, 0x000b, 0x002c, 0x000d, 0x000f, 0x000d, 0x000f, 0x000a, 0x0002, 0x002f, 0x002f, 0x000f, 0x000f, 0x0002, 
    0x0064, 0x000f, 0x0001, 0x0026, 0x000f, 0x0061, 0x0017, 0x0017, 0x0060, 0x0038, 0x00ba, 0x0093, 0x0060, 0x19c0, 0x51fd, 0x048d, 0x013d, 0x001c, 0x002e, 0x0012, 
    0x001c, 0x0084, 0x000f, 0x003f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x0001, 0x000f, 0x001f, 0x00b8, 0x002b, 0x0083, 0x0021, 0x0049, 0x0037, 0x0039, 
    0x000a, 0x001a, 0x0016, 0x000f, 0x002b, 0x000e, 0x0050, 0x2be4, 0x004c, 0x016e, 0x006a, 0x0007, 0x000f, 0x001b, 0x000f, 0x01f1, 0x00ac, 0x008d, 0x001a, 0x001a, 
    0x006a, 0x000b, 
)

@SharedImmutable
private val rangeCategory = intArrayOf(
    0x0006, 0x0005, 0x1400003, 0x0007, 0x0006, 0x0006, 0x0005, 0x0005, 0x0019, 0x0019, 0x0019, 0x5599a666, 0x696a699a, 0x5a56a69a, 0x5966999a, 0x6d699a9a, 0x79e7bfd5, 0x0019, 0x0019, 0x699e5999, 
    0x0016, 0x5a695559, 0x66666a99, 0x0005, 0x55555557, 0x7d555555, 0x70c0840, 0x0013, 0x15706366, 0x18a88002, 0x6aaaaa9a, 0x6aaaa2aa, 0x0005, 0x56a59555, 0x0019, 0x56986556, 0x0006, 0x0005, 0x0019, 0x0016, 
    0x0016, 0x0019, 0x0006, 0x0007, 0x0005, 0x1684086c, 0xe30208, 0x5020e08, 0x812004, 0xc011764, 0x2810808, 0x1811204, 0x1a8b0e64, 0x1b67848, 0x78a0e04, 0x1020420, 0x181021c, 0x6812004, 0x5021c0c, 0x1020818, 
    0x73cf3fff, 0x843e04, 0x89200c, 0x870258, 0x9010614, 0x5812e08, 0x960408, 0x1850208, 0x7830208, 0x1860204, 0x1f33c0ff, 0x1830608, 0x886804, 0x190025c, 0xf020a0c, 0x830220, 0x1850228, 0x7820204, 0x830224, 0x2812004, 
    0x286300c, 0x890260, 0xb0741c, 0x82741c, 0x980214, 0x4820228, 0xa810214, 0x887e04, 0xa2be614, 0x1840818, 0x2030e08, 0x0007, 0x0006, 0x60022aaa, 0x0005, 0x55c55555, 0x0007, 0x870410, 0xa90410, 0x1040284, 
    0x1040204, 0x10402e4, 0x0007, 0x0006, 0x0005, 0x0007, 0x29a0244, 0x8d0e20, 0x7121c48, 0x11b41e0c, 0x3d98604, 0x2810288, 0x11e627c, 0x1b1a08b0, 0x2e81a4d4, 0x69e6e1c, 0x14a434b0, 0x0007, 0x0005, 0x0006, 
    0x0006, 0x860210, 0x0007, 0x0005, 0x0007, 0x75555557, 0x0005, 0x0007, 0x0016, 0x0005, 0x0019, 0x6aaa5555, 0x6aa81556, 0x6aaa5555, 0x6aa95556, 0x6aa0555a, 0x62155542, 0x6a955562, 0x555555aa, 0x7d555415, 
    0x75555fff, 0x55557fff, 0x0007, 0x7aa5155f, 0x7aa51501, 0x1aa5055, 0x6aa5555, 0x7aa515, 0x8011a04, 0x5a90802, 0x6aa021a9, 0x64aa222, 0x6941ff6a, 0x140156, 0x0016, 0x0006, 0x0005, 0x699996a6, 0x7d55659a, 0x0006, 
    0x0016, 0x60198001, 0x0005, 0x0005, 0x7ffc1001, 0x8010ec8, 0x87021c, 0x87021c, 0x2807021c, 0x2855408, 0x830d58, 0xab0a10, 0x6080, 0x0007, 0x0007, 0x0007, 0x04b8, 0x1440, 0x0016, 0x2004, 
    0x0016, 0x18c60408, 0x56666666, 0x0019, 0x69995557, 0x660d9999, 0x6666566d, 0x69999999, 0x6666aa6a, 0x66a98199, 0x0005, 0x73fff7f6, 0x840208, 0x1f321cd0, 0x5820204, 0x39d325c, 0x852004, 0xba90214, 0x1972820, 0x18102c8, 
    0x810414, 0x38b040c, 0x1060418, 0x021c, 0x0005, 0x1d5555ff, 0x0005, 0x3a8c, 0x085c, 0x0007, 0x0007, 0x0005, 0x7f300155, 0x8d021c, 0x7fff3cf3, 0x4394, 0x14360500, 0x0214, 0x0006, 0x0005, 
    0x1060764, 0x0418, 
)


/**
 * Returns `true` if this character is a letter.
 */
internal fun Char.isLetterImpl(): Boolean {
    return getLetterType() != 0
}

/**
 * Returns `true` if this character is a lower case letter, or it has contributory property `Other_Lowercase`.
 */
internal fun Char.isLowerCaseImpl(): Boolean {
    return getLetterType() == 1 || code.isOtherLowercase()
}

/**
 * Returns `true` if this character is an upper case letter, or it has contributory property `Other_Uppercase`.
 */
internal fun Char.isUpperCaseImpl(): Boolean {
    return getLetterType() == 2 || code.isOtherUppercase()
}

/**
 * Returns
 *   - `1` if the character is a lower case letter,
 *   - `2` if the character is an upper case letter,
 *   - `3` if the character is a letter but not a lower or upper case letter,
 *   - `0` otherwise.
 */
private fun Char.getLetterType(): Int {
    val ch = this.code
    val index = binarySearchRange(rangeStart, ch)

    val rangeStart = rangeStart[index]
    val rangeEnd = rangeStart + rangeLength[index] - 1
    val code = rangeCategory[index]

    if (ch > rangeEnd) {
        return 0
    }

    val lastTwoBits = code and 0x3

    if (lastTwoBits == 0) { // gap pattern
        var shift = 2
        var threshold = rangeStart
        for (i in 0..1) {
            threshold += (code shr shift) and 0x7f
            if (threshold > ch) {
                return 3
            }
            shift += 7
            threshold += (code shr shift) and 0x7f
            if (threshold > ch) {
                return 0
            }
            shift += 7
        }
        return 3
    }

    if (code <= 0x7) {
        return lastTwoBits
    }

    val distance = (ch - rangeStart)
    val shift = if (code <= 0x1F) distance % 2 else distance
    return (code shr (2 * shift)) and 0x3
}
