/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package test.text

//
// NOTE: THIS FILE IS AUTO-GENERATED by the GenerateUnicodeData.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import kotlin.test.*

@SharedImmutable
private val casedRanges = arrayOf<IntRange>(
    0x0041..0x005a,
    0x0061..0x007a,
    0x00aa..0x00aa,
    0x00b5..0x00b5,
    0x00ba..0x00ba,
    0x00c0..0x00d6,
    0x00d8..0x00f6,
    0x00f8..0x01ba,
    0x01bc..0x01bf,
    0x01c4..0x0293,
    0x0295..0x02af,
    0x02b0..0x02b8,
    0x02c0..0x02c1,
    0x02e0..0x02e4,
    0x0345..0x0345,
    0x0370..0x0373,
    0x0376..0x0377,
    0x037a..0x037a,
    0x037b..0x037d,
    0x037f..0x037f,
    0x0386..0x0386,
    0x0388..0x038a,
    0x038c..0x038c,
    0x038e..0x03a1,
    0x03a3..0x03f5,
    0x03f7..0x0481,
    0x048a..0x052f,
    0x0531..0x0556,
    0x0560..0x0588,
    0x10a0..0x10c5,
    0x10c7..0x10c7,
    0x10cd..0x10cd,
    0x10d0..0x10fa,
    0x10fd..0x10ff,
    0x13a0..0x13f5,
    0x13f8..0x13fd,
    0x1c80..0x1c88,
    0x1c90..0x1cba,
    0x1cbd..0x1cbf,
    0x1d00..0x1d2b,
    0x1d2c..0x1d6a,
    0x1d6b..0x1d77,
    0x1d78..0x1d78,
    0x1d79..0x1d9a,
    0x1d9b..0x1dbf,
    0x1e00..0x1f15,
    0x1f18..0x1f1d,
    0x1f20..0x1f45,
    0x1f48..0x1f4d,
    0x1f50..0x1f57,
    0x1f59..0x1f59,
    0x1f5b..0x1f5b,
    0x1f5d..0x1f5d,
    0x1f5f..0x1f7d,
    0x1f80..0x1fb4,
    0x1fb6..0x1fbc,
    0x1fbe..0x1fbe,
    0x1fc2..0x1fc4,
    0x1fc6..0x1fcc,
    0x1fd0..0x1fd3,
    0x1fd6..0x1fdb,
    0x1fe0..0x1fec,
    0x1ff2..0x1ff4,
    0x1ff6..0x1ffc,
    0x2071..0x2071,
    0x207f..0x207f,
    0x2090..0x209c,
    0x2102..0x2102,
    0x2107..0x2107,
    0x210a..0x2113,
    0x2115..0x2115,
    0x2119..0x211d,
    0x2124..0x2124,
    0x2126..0x2126,
    0x2128..0x2128,
    0x212a..0x212d,
    0x212f..0x2134,
    0x2139..0x2139,
    0x213c..0x213f,
    0x2145..0x2149,
    0x214e..0x214e,
    0x2160..0x217f,
    0x2183..0x2184,
    0x24b6..0x24e9,
    0x2c00..0x2c2e,
    0x2c30..0x2c5e,
    0x2c60..0x2c7b,
    0x2c7c..0x2c7d,
    0x2c7e..0x2ce4,
    0x2ceb..0x2cee,
    0x2cf2..0x2cf3,
    0x2d00..0x2d25,
    0x2d27..0x2d27,
    0x2d2d..0x2d2d,
    0xa640..0xa66d,
    0xa680..0xa69b,
    0xa69c..0xa69d,
    0xa722..0xa76f,
    0xa770..0xa770,
    0xa771..0xa787,
    0xa78b..0xa78e,
    0xa790..0xa7bf,
    0xa7c2..0xa7ca,
    0xa7f5..0xa7f6,
    0xa7f8..0xa7f9,
    0xa7fa..0xa7fa,
    0xab30..0xab5a,
    0xab5c..0xab5f,
    0xab60..0xab68,
    0xab70..0xabbf,
    0xfb00..0xfb06,
    0xfb13..0xfb17,
    0xff21..0xff3a,
    0xff41..0xff5a,
    0x10400..0x1044f,
    0x104b0..0x104d3,
    0x104d8..0x104fb,
    0x10c80..0x10cb2,
    0x10cc0..0x10cf2,
    0x118a0..0x118df,
    0x16e40..0x16e7f,
    0x1d400..0x1d454,
    0x1d456..0x1d49c,
    0x1d49e..0x1d49f,
    0x1d4a2..0x1d4a2,
    0x1d4a5..0x1d4a6,
    0x1d4a9..0x1d4ac,
    0x1d4ae..0x1d4b9,
    0x1d4bb..0x1d4bb,
    0x1d4bd..0x1d4c3,
    0x1d4c5..0x1d505,
    0x1d507..0x1d50a,
    0x1d50d..0x1d514,
    0x1d516..0x1d51c,
    0x1d51e..0x1d539,
    0x1d53b..0x1d53e,
    0x1d540..0x1d544,
    0x1d546..0x1d546,
    0x1d54a..0x1d550,
    0x1d552..0x1d6a5,
    0x1d6a8..0x1d6c0,
    0x1d6c2..0x1d6da,
    0x1d6dc..0x1d6fa,
    0x1d6fc..0x1d714,
    0x1d716..0x1d734,
    0x1d736..0x1d74e,
    0x1d750..0x1d76e,
    0x1d770..0x1d788,
    0x1d78a..0x1d7a8,
    0x1d7aa..0x1d7c2,
    0x1d7c4..0x1d7cb,
    0x1e900..0x1e943,
    0x1f130..0x1f149,
    0x1f150..0x1f169,
    0x1f170..0x1f189,
)

class IsCasedTest {
    @Test
    fun isCased() {
        var lastChecked = -1
        for (range in casedRanges) {
            for (codePoint in lastChecked + 1 until range.first) {
                assertFalse(codePoint.isCased())
            }
            for (codePoint in range.first..range.last) {
                assertTrue(codePoint.isCased())
            }
            lastChecked = range.last
        }
        for (codePoint in lastChecked + 1..0x10FFFF) {
            assertFalse(codePoint.isCased())
        }
    }
}
