/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.js.testOld.wasm.semantics;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class JsTranslatorWasmTestGenerated extends AbstractJsTranslatorWasmTest {
    @TestMetadata("js/js.translator/testData/box/main")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Main extends AbstractJsTranslatorWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInMain() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/box/main"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("differentMains.kt")
        public void testDifferentMains() throws Exception {
            runTest("js/js.translator/testData/box/main/differentMains.kt");
        }

        @TestMetadata("incremental.kt")
        public void testIncremental() throws Exception {
            runTest("js/js.translator/testData/box/main/incremental.kt");
        }

        @TestMetadata("noArgs.kt")
        public void testNoArgs() throws Exception {
            runTest("js/js.translator/testData/box/main/noArgs.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("js/js.translator/testData/box/main/simple.kt");
        }

        @TestMetadata("suspendMain.kt")
        public void testSuspendMain() throws Exception {
            runTest("js/js.translator/testData/box/main/suspendMain.kt");
        }

        @TestMetadata("suspendMainNoArgs.kt")
        public void testSuspendMainNoArgs() throws Exception {
            runTest("js/js.translator/testData/box/main/suspendMainNoArgs.kt");
        }

        @TestMetadata("suspendMainThrows.kt")
        public void testSuspendMainThrows() throws Exception {
            runTest("js/js.translator/testData/box/main/suspendMainThrows.kt");
        }

        @TestMetadata("twoMains.kt")
        public void testTwoMains() throws Exception {
            runTest("js/js.translator/testData/box/main/twoMains.kt");
        }
    }

    @TestMetadata("js/js.translator/testData/box/kotlin.test")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Kotlin_test extends AbstractJsTranslatorWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInKotlin_test() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/box/kotlin.test"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("beforeAfter.kt")
        public void testBeforeAfter() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/beforeAfter.kt");
        }

        @TestMetadata("ignore.kt")
        public void testIgnore() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/ignore.kt");
        }

        @TestMetadata("illegalParameters.kt")
        public void testIllegalParameters() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/illegalParameters.kt");
        }

        @TestMetadata("incremental.kt")
        public void testIncremental() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/incremental.kt");
        }

        @TestMetadata("inherited.kt")
        public void testInherited() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/inherited.kt");
        }

        @TestMetadata("mpp.kt")
        public void testMpp() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/mpp.kt");
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/nested.kt");
        }

        @TestMetadata("returnTestResult.kt")
        public void testReturnTestResult() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/returnTestResult.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("js/js.translator/testData/box/kotlin.test/simple.kt");
        }
    }

    @TestMetadata("js/js.translator/testData/box/native")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Native extends AbstractJsTranslatorWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("accessToCompanionObjectFromInlineFun.kt")
        public void testAccessToCompanionObjectFromInlineFun() throws Exception {
            runTest("js/js.translator/testData/box/native/accessToCompanionObjectFromInlineFun.kt");
        }

        public void testAllFilesPresentInNative() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/box/native"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("castToNativeClassChecked.kt")
        public void testCastToNativeClassChecked() throws Exception {
            runTest("js/js.translator/testData/box/native/castToNativeClassChecked.kt");
        }

        @TestMetadata("castToNativeInterface.kt")
        public void testCastToNativeInterface() throws Exception {
            runTest("js/js.translator/testData/box/native/castToNativeInterface.kt");
        }

        @TestMetadata("castToNativeInterfaceChecked.kt")
        public void testCastToNativeInterfaceChecked() throws Exception {
            runTest("js/js.translator/testData/box/native/castToNativeInterfaceChecked.kt");
        }

        @TestMetadata("castToNullableNativeInterface.kt")
        public void testCastToNullableNativeInterface() throws Exception {
            runTest("js/js.translator/testData/box/native/castToNullableNativeInterface.kt");
        }

        @TestMetadata("castToTypeParamBoundedByNativeInterface.kt")
        public void testCastToTypeParamBoundedByNativeInterface() throws Exception {
            runTest("js/js.translator/testData/box/native/castToTypeParamBoundedByNativeInterface.kt");
        }

        @TestMetadata("class.kt")
        public void testClass() throws Exception {
            runTest("js/js.translator/testData/box/native/class.kt");
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("js/js.translator/testData/box/native/classObject.kt");
        }

        @TestMetadata("kt2209.kt")
        public void testKt2209() throws Exception {
            runTest("js/js.translator/testData/box/native/kt2209.kt");
        }

        @TestMetadata("nestedElements.kt")
        public void testNestedElements() throws Exception {
            runTest("js/js.translator/testData/box/native/nestedElements.kt");
        }

        @TestMetadata("objectFunWithVararg.kt")
        public void testObjectFunWithVararg() throws Exception {
            runTest("js/js.translator/testData/box/native/objectFunWithVararg.kt");
        }

        @TestMetadata("passExtLambdaToNative.kt")
        public void testPassExtLambdaToNative() throws Exception {
            runTest("js/js.translator/testData/box/native/passExtLambdaToNative.kt");
        }

        @TestMetadata("passMemberOrExtFromNative.kt")
        public void testPassMemberOrExtFromNative() throws Exception {
            runTest("js/js.translator/testData/box/native/passMemberOrExtFromNative.kt");
        }

        @TestMetadata("passMemberOrExtToNative.kt")
        public void testPassMemberOrExtToNative() throws Exception {
            runTest("js/js.translator/testData/box/native/passMemberOrExtToNative.kt");
        }

        @TestMetadata("passTopLevelFunctionFromNative.kt")
        public void testPassTopLevelFunctionFromNative() throws Exception {
            runTest("js/js.translator/testData/box/native/passTopLevelFunctionFromNative.kt");
        }

        @TestMetadata("passTopLevelOrLocalFunctionToNative.kt")
        public void testPassTopLevelOrLocalFunctionToNative() throws Exception {
            runTest("js/js.translator/testData/box/native/passTopLevelOrLocalFunctionToNative.kt");
        }

        @TestMetadata("privateExternal.kt")
        public void testPrivateExternal() throws Exception {
            runTest("js/js.translator/testData/box/native/privateExternal.kt");
        }

        @TestMetadata("safeCastToNativeInterface.kt")
        public void testSafeCastToNativeInterface() throws Exception {
            runTest("js/js.translator/testData/box/native/safeCastToNativeInterface.kt");
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            runTest("js/js.translator/testData/box/native/secondaryConstructor.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("js/js.translator/testData/box/native/simple.kt");
        }

        @TestMetadata("simpleUndefined.kt")
        public void testSimpleUndefined() throws Exception {
            runTest("js/js.translator/testData/box/native/simpleUndefined.kt");
        }

        @TestMetadata("useClassFromInlineFun.kt")
        public void testUseClassFromInlineFun() throws Exception {
            runTest("js/js.translator/testData/box/native/useClassFromInlineFun.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("js/js.translator/testData/box/native/vararg.kt");
        }
    }
}
