/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.js.testOld.wasm.semantics;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.utils.TransformersFunctions;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/box")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IrCodegenBoxWasmTestGenerated extends AbstractIrCodegenBoxWasmTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
    }

    public void testAllFilesPresentInBox() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true, "compileKotlinAgainstKotlin");
    }

    @TestMetadata("compiler/testData/codegen/box/annotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotations extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("genericAnnotations.kt")
        public void testGenericAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/genericAnnotations.kt");
        }

        @TestMetadata("nestedAnnotation.kt")
        public void testNestedAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedAnnotation.kt");
        }

        @TestMetadata("nestedClassesInAnnotations.kt")
        public void testNestedClassesInAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedClassesInAnnotations.kt");
        }

        @TestMetadata("parameters.kt")
        public void testParameters() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameters.kt");
        }

        @TestMetadata("resolveWithLowPriorityAnnotation.kt")
        public void testResolveWithLowPriorityAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/resolveWithLowPriorityAnnotation.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/annotatedLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotatedLambda extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotatedLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/annotatedLambda"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/instances")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Instances extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInstances() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/instances"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("annotationEqHc.kt")
            public void testAnnotationEqHc() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationEqHc.kt");
            }

            @TestMetadata("annotationFromStdlib.kt")
            public void testAnnotationFromStdlib() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationFromStdlib.kt");
            }

            @TestMetadata("annotationInstances.kt")
            public void testAnnotationInstances() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationInstances.kt");
            }

            @TestMetadata("annotationInstancesEmptyDefault.kt")
            public void testAnnotationInstancesEmptyDefault() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationInstancesEmptyDefault.kt");
            }

            @TestMetadata("annotationToString.kt")
            public void testAnnotationToString() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationToString.kt");
            }

            @TestMetadata("inInlineFunction.kt")
            public void testInInlineFunction() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/inInlineFunction.kt");
            }

            @TestMetadata("multifileEqHc.kt")
            public void testMultifileEqHc() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/multifileEqHc.kt");
            }

            @TestMetadata("multiplatformInstantiation.kt")
            public void testMultiplatformInstantiation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/multiplatformInstantiation.kt");
            }

            @TestMetadata("nestedAnnotationInstances.kt")
            public void testNestedAnnotationInstances() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/nestedAnnotationInstances.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/kClassMapping")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KClassMapping extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInKClassMapping() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/kClassMapping"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/repeatable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Repeatable extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInRepeatable() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/repeatable"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/typeAnnotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeAnnotations extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInTypeAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/typeAnnotations"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("checkingNotincorporatedInputTypes.kt")
            public void testCheckingNotincorporatedInputTypes() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/checkingNotincorporatedInputTypes.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArgumentOrder extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/argumentOrder"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("argumentOrderInObjectSuperCall.kt")
        public void testArgumentOrderInObjectSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInObjectSuperCall.kt");
        }

        @TestMetadata("argumentOrderInSuperCall.kt")
        public void testArgumentOrderInSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInSuperCall.kt");
        }

        @TestMetadata("arguments.kt")
        public void testArguments() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/arguments.kt");
        }

        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/captured.kt");
        }

        @TestMetadata("capturedInExtension.kt")
        public void testCapturedInExtension() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/capturedInExtension.kt");
        }

        @TestMetadata("defaults.kt")
        public void testDefaults() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/defaults.kt");
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/extension.kt");
        }

        @TestMetadata("extensionInClass.kt")
        public void testExtensionInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/extensionInClass.kt");
        }

        @TestMetadata("kt17691WithEnabledFeature.kt")
        public void testKt17691WithEnabledFeature() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt17691WithEnabledFeature.kt");
        }

        @TestMetadata("kt9277.kt")
        public void testKt9277() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt9277.kt");
        }

        @TestMetadata("lambdaMigration.kt")
        public void testLambdaMigration() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigration.kt");
        }

        @TestMetadata("lambdaMigrationInClass.kt")
        public void testLambdaMigrationInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigrationInClass.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/simple.kt");
        }

        @TestMetadata("simpleInClass.kt")
        public void testSimpleInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/simpleInClass.kt");
        }

        @TestMetadata("singleSideEffect.kt")
        public void testSingleSideEffect() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/singleSideEffect.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/arrays")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Arrays extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInArrays() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("arrayConstructorWithNonInlineLambda.kt")
        public void testArrayConstructorWithNonInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayConstructorWithNonInlineLambda.kt");
        }

        @TestMetadata("arrayConstructorsSimple.kt")
        public void testArrayConstructorsSimple() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayConstructorsSimple.kt");
        }

        @TestMetadata("arrayGetAssignMultiIndex.kt")
        public void testArrayGetAssignMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayGetAssignMultiIndex.kt");
        }

        @TestMetadata("arrayGetMultiIndex.kt")
        public void testArrayGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayGetMultiIndex.kt");
        }

        @TestMetadata("arrayInstanceOf.kt")
        public void testArrayInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayInstanceOf.kt");
        }

        @TestMetadata("arrayPlusAssign.kt")
        public void testArrayPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayPlusAssign.kt");
        }

        @TestMetadata("arraysAreCloneable.kt")
        public void testArraysAreCloneable() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arraysAreCloneable.kt");
        }

        @TestMetadata("cloneArray.kt")
        public void testCloneArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/cloneArray.kt");
        }

        @TestMetadata("clonePrimitiveArrays.kt")
        public void testClonePrimitiveArrays() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/clonePrimitiveArrays.kt");
        }

        @TestMetadata("collectionAssignGetMultiIndex.kt")
        public void testCollectionAssignGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/collectionAssignGetMultiIndex.kt");
        }

        @TestMetadata("collectionGetMultiIndex.kt")
        public void testCollectionGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/collectionGetMultiIndex.kt");
        }

        @TestMetadata("constantArrayOfAny.kt")
        public void testConstantArrayOfAny() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/constantArrayOfAny.kt");
        }

        @TestMetadata("forEachBooleanArray.kt")
        public void testForEachBooleanArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachBooleanArray.kt");
        }

        @TestMetadata("forEachByteArray.kt")
        public void testForEachByteArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachByteArray.kt");
        }

        @TestMetadata("forEachCharArray.kt")
        public void testForEachCharArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachCharArray.kt");
        }

        @TestMetadata("forEachDoubleArray.kt")
        public void testForEachDoubleArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachDoubleArray.kt");
        }

        @TestMetadata("forEachFloatArray.kt")
        public void testForEachFloatArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachFloatArray.kt");
        }

        @TestMetadata("forEachIntArray.kt")
        public void testForEachIntArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachIntArray.kt");
        }

        @TestMetadata("forEachLongArray.kt")
        public void testForEachLongArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachLongArray.kt");
        }

        @TestMetadata("forEachShortArray.kt")
        public void testForEachShortArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachShortArray.kt");
        }

        @TestMetadata("genericArrayInObjectLiteralConstructor.kt")
        public void testGenericArrayInObjectLiteralConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/genericArrayInObjectLiteralConstructor.kt");
        }

        @TestMetadata("hashMap.kt")
        public void testHashMap() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/hashMap.kt");
        }

        @TestMetadata("inProjectionAsParameter.kt")
        public void testInProjectionAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionAsParameter.kt");
        }

        @TestMetadata("inProjectionOfArray.kt")
        public void testInProjectionOfArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionOfArray.kt");
        }

        @TestMetadata("inProjectionOfList.kt")
        public void testInProjectionOfList() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionOfList.kt");
        }

        @TestMetadata("indices.kt")
        public void testIndices() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/indices.kt");
        }

        @TestMetadata("indicesChar.kt")
        public void testIndicesChar() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/indicesChar.kt");
        }

        @TestMetadata("inlineInitializer.kt")
        public void testInlineInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inlineInitializer.kt");
        }

        @TestMetadata("iterator.kt")
        public void testIterator() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iterator.kt");
        }

        @TestMetadata("iteratorBooleanArray.kt")
        public void testIteratorBooleanArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorBooleanArray.kt");
        }

        @TestMetadata("iteratorByteArray.kt")
        public void testIteratorByteArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorByteArray.kt");
        }

        @TestMetadata("iteratorByteArrayNextByte.kt")
        public void testIteratorByteArrayNextByte() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorByteArrayNextByte.kt");
        }

        @TestMetadata("iteratorCharArray.kt")
        public void testIteratorCharArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorCharArray.kt");
        }

        @TestMetadata("iteratorDoubleArray.kt")
        public void testIteratorDoubleArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorDoubleArray.kt");
        }

        @TestMetadata("iteratorFloatArray.kt")
        public void testIteratorFloatArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorFloatArray.kt");
        }

        @TestMetadata("iteratorIntArray.kt")
        public void testIteratorIntArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorIntArray.kt");
        }

        @TestMetadata("iteratorLongArray.kt")
        public void testIteratorLongArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorLongArray.kt");
        }

        @TestMetadata("iteratorLongArrayNextLong.kt")
        public void testIteratorLongArrayNextLong() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorLongArrayNextLong.kt");
        }

        @TestMetadata("iteratorShortArray.kt")
        public void testIteratorShortArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorShortArray.kt");
        }

        @TestMetadata("kt1291.kt")
        public void testKt1291() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt1291.kt");
        }

        @TestMetadata("kt238.kt")
        public void testKt238() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt238.kt");
        }

        @TestMetadata("kt2997.kt")
        public void testKt2997() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt2997.kt");
        }

        @TestMetadata("kt33.kt")
        public void testKt33() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt33.kt");
        }

        @TestMetadata("kt34291_16dimensions.kt")
        public void testKt34291_16dimensions() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt34291_16dimensions.kt");
        }

        @TestMetadata("kt3771.kt")
        public void testKt3771() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt3771.kt");
        }

        @TestMetadata("kt4118.kt")
        public void testKt4118() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4118.kt");
        }

        @TestMetadata("kt42932.kt")
        public void testKt42932() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt42932.kt");
        }

        @TestMetadata("kt4348.kt")
        public void testKt4348() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4348.kt");
        }

        @TestMetadata("kt4357.kt")
        public void testKt4357() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4357.kt");
        }

        @TestMetadata("kt47483.kt")
        public void testKt47483() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt47483.kt");
        }

        @TestMetadata("kt503.kt")
        public void testKt503() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt503.kt");
        }

        @TestMetadata("kt594.kt")
        public void testKt594() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt594.kt");
        }

        @TestMetadata("kt7009.kt")
        public void testKt7009() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7009.kt");
        }

        @TestMetadata("kt7288.kt")
        public void testKt7288() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7288.kt");
        }

        @TestMetadata("kt7338.kt")
        public void testKt7338() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7338.kt");
        }

        @TestMetadata("kt779.kt")
        public void testKt779() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt779.kt");
        }

        @TestMetadata("kt945.kt")
        public void testKt945() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt945.kt");
        }

        @TestMetadata("kt950.kt")
        public void testKt950() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt950.kt");
        }

        @TestMetadata("longAsIndex.kt")
        public void testLongAsIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/longAsIndex.kt");
        }

        @TestMetadata("multiArrayConstructors.kt")
        public void testMultiArrayConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/multiArrayConstructors.kt");
        }

        @TestMetadata("nonLocalReturnArrayConstructor.kt")
        public void testNonLocalReturnArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/nonLocalReturnArrayConstructor.kt");
        }

        @TestMetadata("nonNullArray.kt")
        public void testNonNullArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/nonNullArray.kt");
        }

        @TestMetadata("primitiveArrays.kt")
        public void testPrimitiveArrays() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/primitiveArrays.kt");
        }

        @TestMetadata("stdlib.kt")
        public void testStdlib() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/stdlib.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/arraysOfInlineClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ArraysOfInlineClass extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("accessArrayOfInlineClass.kt")
            public void testAccessArrayOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfInlineClass.kt");
            }

            @TestMetadata("accessArrayOfUnsigned.kt")
            public void testAccessArrayOfUnsigned() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfUnsigned.kt");
            }

            public void testAllFilesPresentInArraysOfInlineClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/arraysOfInlineClass"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("arrayOfInlineClassOfArrayOfInlineClass.kt")
            public void testArrayOfInlineClassOfArrayOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/arrayOfInlineClassOfArrayOfInlineClass.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/forInReversed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInReversed extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInForInReversed() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/forInReversed"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("reversedArrayOriginalUpdatedInLoopBody.kt")
            public void testReversedArrayOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArrayOriginalUpdatedInLoopBody.kt");
            }

            @TestMetadata("reversedArrayReversedArrayOriginalUpdatedInLoopBody.kt")
            public void testReversedArrayReversedArrayOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArrayReversedArrayOriginalUpdatedInLoopBody.kt");
            }

            @TestMetadata("reversedOriginalUpdatedInLoopBody.kt")
            public void testReversedOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedOriginalUpdatedInLoopBody.kt");
            }

            @TestMetadata("reversedReversedOriginalUpdatedInLoopBody.kt")
            public void testReversedReversedOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedReversedOriginalUpdatedInLoopBody.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/forInUnsignedArray")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInUnsignedArray extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInForInUnsignedArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/forInUnsignedArray"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("forInUnsignedArray.kt")
            public void testForInUnsignedArray() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArray.kt");
            }

            @TestMetadata("forInUnsignedArrayIndices.kt")
            public void testForInUnsignedArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayIndices.kt");
            }

            @TestMetadata("forInUnsignedArrayIndicesReversed.kt")
            public void testForInUnsignedArrayIndicesReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayIndicesReversed.kt");
            }

            @TestMetadata("forInUnsignedArrayReversed.kt")
            public void testForInUnsignedArrayReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayReversed.kt");
            }

            @TestMetadata("forInUnsignedArrayWithIndex.kt")
            public void testForInUnsignedArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndex.kt");
            }

            @TestMetadata("forInUnsignedArrayWithIndexNoElementVar.kt")
            public void testForInUnsignedArrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInUnsignedArrayWithIndexNoIndexVar.kt")
            public void testForInUnsignedArrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInUnsignedArrayWithIndexReversed.kt")
            public void testForInUnsignedArrayWithIndexReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexReversed.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiDecl extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInMultiDecl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt15560.kt")
            public void testKt15560() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15560.kt");
            }

            @TestMetadata("kt15568.kt")
            public void testKt15568() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15568.kt");
            }

            @TestMetadata("kt15575.kt")
            public void testKt15575() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15575.kt");
            }

            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclFor.kt");
            }

            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
            }

            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForValCaptured.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/int")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Int extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInInt() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/int"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/long")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Long extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInLong() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/long"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/assert")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Assert extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInAssert() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/assert"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("alwaysDisable.kt")
        public void testAlwaysDisable() throws Exception {
            runTest("compiler/testData/codegen/box/assert/alwaysDisable.kt");
        }

        @TestMetadata("alwaysEnable.kt")
        public void testAlwaysEnable() throws Exception {
            runTest("compiler/testData/codegen/box/assert/alwaysEnable.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/assert/jvm")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Jvm extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInJvm() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/assert/jvm"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/binaryOp")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BinaryOp extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInBinaryOp() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/binaryOp"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("bitwiseOp.kt")
        public void testBitwiseOp() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOp.kt");
        }

        @TestMetadata("bitwiseOpAny.kt")
        public void testBitwiseOpAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpAny.kt");
        }

        @TestMetadata("bitwiseOpNullable.kt")
        public void testBitwiseOpNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpNullable.kt");
        }

        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/call.kt");
        }

        @TestMetadata("callAny.kt")
        public void testCallAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/callAny.kt");
        }

        @TestMetadata("callNullable.kt")
        public void testCallNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/callNullable.kt");
        }

        @TestMetadata("compareBoxedChars.kt")
        public void testCompareBoxedChars() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareBoxedChars.kt");
        }

        @TestMetadata("divisionByZero.kt")
        public void testDivisionByZero() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/divisionByZero.kt");
        }

        @TestMetadata("eqNullableDoubles.kt")
        public void testEqNullableDoubles() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoubles.kt");
        }

        @TestMetadata("eqNullableDoublesToInt.kt")
        public void testEqNullableDoublesToInt() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesToInt.kt");
        }

        @TestMetadata("eqNullableDoublesToIntWithTP.kt")
        public void testEqNullableDoublesToIntWithTP() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesToIntWithTP.kt");
        }

        @TestMetadata("eqNullableDoublesWithTP.kt")
        public void testEqNullableDoublesWithTP() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesWithTP.kt");
        }

        @TestMetadata("eqNullableShortToShort.kt")
        public void testEqNullableShortToShort() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableShortToShort.kt");
        }

        @TestMetadata("eqNullableToPrimitiveWithSideEffects.kt")
        public void testEqNullableToPrimitiveWithSideEffects() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableToPrimitiveWithSideEffects.kt");
        }

        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsic.kt");
        }

        @TestMetadata("intrinsicAny.kt")
        public void testIntrinsicAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsicAny.kt");
        }

        @TestMetadata("intrinsicNullable.kt")
        public void testIntrinsicNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsicNullable.kt");
        }

        @TestMetadata("kt11163.kt")
        public void testKt11163() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt11163.kt");
        }

        @TestMetadata("kt11163_properIeee754comparisons.kt")
        public void testKt11163_properIeee754comparisons() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt11163_properIeee754comparisons.kt");
        }

        @TestMetadata("kt23030_properIeee754comparisons.kt")
        public void testKt23030_properIeee754comparisons() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt23030_properIeee754comparisons.kt");
        }

        @TestMetadata("kt44402.kt")
        public void testKt44402() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt44402.kt");
        }

        @TestMetadata("kt6747_identityEquals.kt")
        public void testKt6747_identityEquals() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt6747_identityEquals.kt");
        }

        @TestMetadata("overflowChar.kt")
        public void testOverflowChar() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowChar.kt");
        }

        @TestMetadata("overflowInt.kt")
        public void testOverflowInt() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowInt.kt");
        }

        @TestMetadata("overflowLong.kt")
        public void testOverflowLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowLong.kt");
        }

        @TestMetadata("primitiveEqualsSafeCall.kt")
        public void testPrimitiveEqualsSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/primitiveEqualsSafeCall.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BoxingOptimization extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInBoxingOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/boxingOptimization"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("boxedIntegersCmp.kt")
        public void testBoxedIntegersCmp() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedIntegersCmp.kt");
        }

        @TestMetadata("boxedPrimitivesAreEqual.kt")
        public void testBoxedPrimitivesAreEqual() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedPrimitivesAreEqual.kt");
        }

        @TestMetadata("boxedRealsCmp.kt")
        public void testBoxedRealsCmp() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedRealsCmp.kt");
        }

        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/casts.kt");
        }

        @TestMetadata("checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/checkcastAndInstanceOf.kt");
        }

        @TestMetadata("explicitEqualsOnDouble.kt")
        public void testExplicitEqualsOnDouble() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/explicitEqualsOnDouble.kt");
        }

        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/fold.kt");
        }

        @TestMetadata("foldRange.kt")
        public void testFoldRange() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/foldRange.kt");
        }

        @TestMetadata("intCompareTo.kt")
        public void testIntCompareTo() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/intCompareTo.kt");
        }

        @TestMetadata("kt15871.kt")
        public void testKt15871() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt15871.kt");
        }

        @TestMetadata("kt19767.kt")
        public void testKt19767() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767.kt");
        }

        @TestMetadata("kt19767_2.kt")
        public void testKt19767_2() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_2.kt");
        }

        @TestMetadata("kt19767_chain.kt")
        public void testKt19767_chain() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_chain.kt");
        }

        @TestMetadata("kt46859.kt")
        public void testKt46859() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt46859.kt");
        }

        @TestMetadata("kt48394.kt")
        public void testKt48394() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt48394.kt");
        }

        @TestMetadata("kt49092a.kt")
        public void testKt49092a() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092a.kt");
        }

        @TestMetadata("kt49092b.kt")
        public void testKt49092b() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092b.kt");
        }

        @TestMetadata("kt49092c.kt")
        public void testKt49092c() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092c.kt");
        }

        @TestMetadata("kt49092d.kt")
        public void testKt49092d() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092d.kt");
        }

        @TestMetadata("kt49092e.kt")
        public void testKt49092e() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092e.kt");
        }

        @TestMetadata("kt49092f.kt")
        public void testKt49092f() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092f.kt");
        }

        @TestMetadata("kt49548.kt")
        public void testKt49548() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49548.kt");
        }

        @TestMetadata("kt49548a.kt")
        public void testKt49548a() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49548a.kt");
        }

        @TestMetadata("kt5493.kt")
        public void testKt5493() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5493.kt");
        }

        @TestMetadata("kt5588.kt")
        public void testKt5588() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5588.kt");
        }

        @TestMetadata("kt5844.kt")
        public void testKt5844() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5844.kt");
        }

        @TestMetadata("kt6842.kt")
        public void testKt6842() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt6842.kt");
        }

        @TestMetadata("maxMinByOrNull.kt")
        public void testMaxMinByOrNull() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/maxMinByOrNull.kt");
        }

        @TestMetadata("nullCheck.kt")
        public void testNullCheck() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/nullCheck.kt");
        }

        @TestMetadata("progressions.kt")
        public void testProgressions() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/progressions.kt");
        }

        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvis.kt");
        }

        @TestMetadata("safeCallWithElvisMultipleFiles.kt")
        public void testSafeCallWithElvisMultipleFiles() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/simple.kt");
        }

        @TestMetadata("simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/simpleUninitializedMerge.kt");
        }

        @TestMetadata("taintedValues.kt")
        public void testTaintedValues() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/taintedValues.kt");
        }

        @TestMetadata("taintedValuesBox.kt")
        public void testTaintedValuesBox() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/taintedValuesBox.kt");
        }

        @TestMetadata("unsafeRemoving.kt")
        public void testUnsafeRemoving() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/unsafeRemoving.kt");
        }

        @TestMetadata("unsignedArrayForEach.kt")
        public void testUnsignedArrayForEach() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/unsignedArrayForEach.kt");
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/variables.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/bridges")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Bridges extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("abstractOverrideBridge.kt")
        public void testAbstractOverrideBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/abstractOverrideBridge.kt");
        }

        public void testAllFilesPresentInBridges() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bridges"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("complexMultiInheritance.kt")
        public void testComplexMultiInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/complexMultiInheritance.kt");
        }

        @TestMetadata("complexTraitImpl.kt")
        public void testComplexTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/complexTraitImpl.kt");
        }

        @TestMetadata("covariantGenericDiamond.kt")
        public void testCovariantGenericDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/covariantGenericDiamond.kt");
        }

        @TestMetadata("delegation.kt")
        public void testDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegation.kt");
        }

        @TestMetadata("delegationComplex.kt")
        public void testDelegationComplex() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationComplex.kt");
        }

        @TestMetadata("delegationComplexWithList.kt")
        public void testDelegationComplexWithList() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationComplexWithList.kt");
        }

        @TestMetadata("delegationProperty.kt")
        public void testDelegationProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationProperty.kt");
        }

        @TestMetadata("diamond.kt")
        public void testDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/diamond.kt");
        }

        @TestMetadata("fakeCovariantOverride.kt")
        public void testFakeCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeCovariantOverride.kt");
        }

        @TestMetadata("fakeGenericCovariantOverride.kt")
        public void testFakeGenericCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverride.kt");
        }

        @TestMetadata("fakeGenericCovariantOverrideWithDelegation.kt")
        public void testFakeGenericCovariantOverrideWithDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverrideWithDelegation.kt");
        }

        @TestMetadata("fakeOverrideFromInterfaceThroughIntermediateClass.kt")
        public void testFakeOverrideFromInterfaceThroughIntermediateClass() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideFromInterfaceThroughIntermediateClass.kt");
        }

        @TestMetadata("fakeOverrideMultiFile.kt")
        public void testFakeOverrideMultiFile() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideMultiFile.kt");
        }

        @TestMetadata("fakeOverrideOfTraitImpl.kt")
        public void testFakeOverrideOfTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideOfTraitImpl.kt");
        }

        @TestMetadata("fakeOverrideThroughGenericSuperclass.kt")
        public void testFakeOverrideThroughGenericSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideThroughGenericSuperclass.kt");
        }

        @TestMetadata("fakeOverrideWithSeveralSuperDeclarations.kt")
        public void testFakeOverrideWithSeveralSuperDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSeveralSuperDeclarations.kt");
        }

        @TestMetadata("fakeOverrideWithSynthesizedImplementation.kt")
        public void testFakeOverrideWithSynthesizedImplementation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSynthesizedImplementation.kt");
        }

        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/genericProperty.kt");
        }

        @TestMetadata("innerClassTypeParameters.kt")
        public void testInnerClassTypeParameters() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/innerClassTypeParameters.kt");
        }

        @TestMetadata("kt12416.kt")
        public void testKt12416() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt12416.kt");
        }

        @TestMetadata("kt1939.kt")
        public void testKt1939() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt1939.kt");
        }

        @TestMetadata("kt1959.kt")
        public void testKt1959() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt1959.kt");
        }

        @TestMetadata("kt2498.kt")
        public void testKt2498() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2498.kt");
        }

        @TestMetadata("kt2702.kt")
        public void testKt2702() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2702.kt");
        }

        @TestMetadata("kt2833.kt")
        public void testKt2833() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2833.kt");
        }

        @TestMetadata("kt2920.kt")
        public void testKt2920() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2920.kt");
        }

        @TestMetadata("kt318.kt")
        public void testKt318() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt318.kt");
        }

        @TestMetadata("kt42137.kt")
        public void testKt42137() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt42137.kt");
        }

        @TestMetadata("kt46389.kt")
        public void testKt46389() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt46389.kt");
        }

        @TestMetadata("kt46389_jvmDefault.kt")
        public void testKt46389_jvmDefault() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt46389_jvmDefault.kt");
        }

        @TestMetadata("longChainOneBridge.kt")
        public void testLongChainOneBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/longChainOneBridge.kt");
        }

        @TestMetadata("manyTypeArgumentsSubstitutedSuccessively.kt")
        public void testManyTypeArgumentsSubstitutedSuccessively() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/manyTypeArgumentsSubstitutedSuccessively.kt");
        }

        @TestMetadata("methodFromTrait.kt")
        public void testMethodFromTrait() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/methodFromTrait.kt");
        }

        @TestMetadata("noBridgeOnMutableCollectionInheritance.kt")
        public void testNoBridgeOnMutableCollectionInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/noBridgeOnMutableCollectionInheritance.kt");
        }

        @TestMetadata("overrideAbstractProperty.kt")
        public void testOverrideAbstractProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideAbstractProperty.kt");
        }

        @TestMetadata("overrideReturnType.kt")
        public void testOverrideReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideReturnType.kt");
        }

        @TestMetadata("overrideWithValueClassReturn.kt")
        public void testOverrideWithValueClassReturn() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideWithValueClassReturn.kt");
        }

        @TestMetadata("propertyAccessorsWithoutBody.kt")
        public void testPropertyAccessorsWithoutBody() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyAccessorsWithoutBody.kt");
        }

        @TestMetadata("propertyDiamond.kt")
        public void testPropertyDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyDiamond.kt");
        }

        @TestMetadata("propertyDiamondFakeOverride.kt")
        public void testPropertyDiamondFakeOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyDiamondFakeOverride.kt");
        }

        @TestMetadata("propertyInConstructor.kt")
        public void testPropertyInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyInConstructor.kt");
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertySetter.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simple.kt");
        }

        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleEnum.kt");
        }

        @TestMetadata("simpleGenericMethod.kt")
        public void testSimpleGenericMethod() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleGenericMethod.kt");
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleObject.kt");
        }

        @TestMetadata("simpleReturnType.kt")
        public void testSimpleReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleReturnType.kt");
        }

        @TestMetadata("simpleTraitImpl.kt")
        public void testSimpleTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleTraitImpl.kt");
        }

        @TestMetadata("simpleUpperBound.kt")
        public void testSimpleUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleUpperBound.kt");
        }

        @TestMetadata("strListContains.kt")
        public void testStrListContains() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/strListContains.kt");
        }

        @TestMetadata("traitImplInheritsTraitImpl.kt")
        public void testTraitImplInheritsTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/traitImplInheritsTraitImpl.kt");
        }

        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges.kt");
        }

        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges2.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges2() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges2.kt");
        }

        @TestMetadata("twoParentsWithTheSameMethodOneBridge.kt")
        public void testTwoParentsWithTheSameMethodOneBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithTheSameMethodOneBridge.kt");
        }

        @TestMetadata("typeParameterInExtensionReceiver.kt")
        public void testTypeParameterInExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/typeParameterInExtensionReceiver.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SubstitutionInSuperClass extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("abstractFun.kt")
            public void testAbstractFun() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/abstractFun.kt");
            }

            public void testAllFilesPresentInSubstitutionInSuperClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bridges/substitutionInSuperClass"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("boundedTypeArguments.kt")
            public void testBoundedTypeArguments() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/boundedTypeArguments.kt");
            }

            @TestMetadata("delegation.kt")
            public void testDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/delegation.kt");
            }

            @TestMetadata("differentErasureInSuperClass.kt")
            public void testDifferentErasureInSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClass.kt");
            }

            @TestMetadata("differentErasureInSuperClassComplex.kt")
            public void testDifferentErasureInSuperClassComplex() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClassComplex.kt");
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/enum.kt");
            }

            @TestMetadata("genericMethod.kt")
            public void testGenericMethod() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/genericMethod.kt");
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/object.kt");
            }

            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/property.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/simple.kt");
            }

            @TestMetadata("upperBound.kt")
            public void testUpperBound() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/upperBound.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BuiltinStubMethods extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInBuiltinStubMethods() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("customReadOnlyIterator.kt")
        public void testCustomReadOnlyIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/customReadOnlyIterator.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BridgesForStubs extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBridgesForStubs() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtendJavaClasses extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("abstractSet.kt")
            public void testAbstractSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractSet.kt");
            }

            public void testAllFilesPresentInExtendJavaClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("arrayList.kt")
            public void testArrayList() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/arrayList.kt");
            }

            @TestMetadata("extendArrayListThroughKotlin.kt")
            public void testExtendArrayListThroughKotlin() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/extendArrayListThroughKotlin.kt");
            }

            @TestMetadata("hashMap.kt")
            public void testHashMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/hashMap.kt");
            }

            @TestMetadata("hashSet.kt")
            public void testHashSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/hashSet.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MapGetOrDefault extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInMapGetOrDefault() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapRemove")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MapRemove extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInMapRemove() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapRemove"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInCallableReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayConstructor.kt");
        }

        @TestMetadata("arrayConstructorArgument.kt")
        public void testArrayConstructorArgument() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayConstructorArgument.kt");
        }

        @TestMetadata("arrayOf.kt")
        public void testArrayOf() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayOf.kt");
        }

        @TestMetadata("callableReferenceOfCompanionConst.kt")
        public void testCallableReferenceOfCompanionConst() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionConst.kt");
        }

        @TestMetadata("callableReferenceOfCompanionMethod.kt")
        public void testCallableReferenceOfCompanionMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionMethod.kt");
        }

        @TestMetadata("callableReferenceOfCompanionProperty.kt")
        public void testCallableReferenceOfCompanionProperty() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionProperty.kt");
        }

        @TestMetadata("callableReferenceOfKotlinNestedClass.kt")
        public void testCallableReferenceOfKotlinNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfKotlinNestedClass.kt");
        }

        @TestMetadata("callableReferenceOfObjectMethod.kt")
        public void testCallableReferenceOfObjectMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfObjectMethod.kt");
        }

        @TestMetadata("charArrayOf.kt")
        public void testCharArrayOf() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/charArrayOf.kt");
        }

        @TestMetadata("genericConstructorReference.kt")
        public void testGenericConstructorReference() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/genericConstructorReference.kt");
        }

        @TestMetadata("genericLocalClassConstructorReference.kt")
        public void testGenericLocalClassConstructorReference() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/genericLocalClassConstructorReference.kt");
        }

        @TestMetadata("inlineArrayConstructors.kt")
        public void testInlineArrayConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/inlineArrayConstructors.kt");
        }

        @TestMetadata("kt21014.kt")
        public void testKt21014() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt21014.kt");
        }

        @TestMetadata("kt21092a.kt")
        public void testKt21092a() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt21092a.kt");
        }

        @TestMetadata("kt37604.kt")
        public void testKt37604() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt37604.kt");
        }

        @TestMetadata("kt44483.kt")
        public void testKt44483() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt44483.kt");
        }

        @TestMetadata("kt46902.kt")
        public void testKt46902() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt46902.kt");
        }

        @TestMetadata("kt47988.kt")
        public void testKt47988() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt47988.kt");
        }

        @TestMetadata("kt49526.kt")
        public void testKt49526() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526.kt");
        }

        @TestMetadata("kt49526_sam.kt")
        public void testKt49526_sam() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526_sam.kt");
        }

        @TestMetadata("kt49526a.kt")
        public void testKt49526a() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526a.kt");
        }

        @TestMetadata("kt49526b.kt")
        public void testKt49526b() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526b.kt");
        }

        @TestMetadata("kt50172.kt")
        public void testKt50172() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt50172.kt");
        }

        @TestMetadata("kt51844.kt")
        public void testKt51844() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt51844.kt");
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/nested.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/adaptedReferences")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AdaptedReferences extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("adaptedArrayOf.kt")
            public void testAdaptedArrayOf() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/adaptedArrayOf.kt");
            }

            @TestMetadata("adaptedVarargFunImportedFromObject.kt")
            public void testAdaptedVarargFunImportedFromObject() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/adaptedVarargFunImportedFromObject.kt");
            }

            public void testAllFilesPresentInAdaptedReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/adaptedReferences"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("bothWithCoercionToUnit.kt")
            public void testBothWithCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/bothWithCoercionToUnit.kt");
            }

            @TestMetadata("boundReferences.kt")
            public void testBoundReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/boundReferences.kt");
            }

            @TestMetadata("defaultAfterVararg.kt")
            public void testDefaultAfterVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/defaultAfterVararg.kt");
            }

            @TestMetadata("defaultWithGenericExpectedType.kt")
            public void testDefaultWithGenericExpectedType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/defaultWithGenericExpectedType.kt");
            }

            @TestMetadata("emptyVarargAndDefault.kt")
            public void testEmptyVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/emptyVarargAndDefault.kt");
            }

            @TestMetadata("inlineBound.kt")
            public void testInlineBound() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineBound.kt");
            }

            @TestMetadata("inlineDefault.kt")
            public void testInlineDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineDefault.kt");
            }

            @TestMetadata("inlineVararg.kt")
            public void testInlineVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVararg.kt");
            }

            @TestMetadata("inlineVarargAndDefault.kt")
            public void testInlineVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
            }

            @TestMetadata("inlineVarargInts.kt")
            public void testInlineVarargInts() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVarargInts.kt");
            }

            @TestMetadata("innerConstructorWithVararg.kt")
            public void testInnerConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/innerConstructorWithVararg.kt");
            }

            @TestMetadata("largeVararg.kt")
            public void testLargeVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/largeVararg.kt");
            }

            @TestMetadata("localFunctionWithDefault.kt")
            public void testLocalFunctionWithDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/localFunctionWithDefault.kt");
            }

            @TestMetadata("manyDefaultsAndVararg.kt")
            public void testManyDefaultsAndVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/manyDefaultsAndVararg.kt");
            }

            @TestMetadata("noNameClashForReferencesToSameFunction.kt")
            public void testNoNameClashForReferencesToSameFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noNameClashForReferencesToSameFunction.kt");
            }

            @TestMetadata("referenceToVarargWithDefaults.kt")
            public void testReferenceToVarargWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/referenceToVarargWithDefaults.kt");
            }

            @TestMetadata("simpleDefaultArgument.kt")
            public void testSimpleDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/simpleDefaultArgument.kt");
            }

            @TestMetadata("simpleEmptyVararg.kt")
            public void testSimpleEmptyVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/simpleEmptyVararg.kt");
            }

            @TestMetadata("suspendUnitConversion.kt")
            public void testSuspendUnitConversion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendUnitConversion.kt");
            }

            @TestMetadata("unboundReferences.kt")
            public void testUnboundReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/unboundReferences.kt");
            }

            @TestMetadata("varargFromBaseClass.kt")
            public void testVarargFromBaseClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargFromBaseClass.kt");
            }

            @TestMetadata("varargViewedAsArray.kt")
            public void testVarargViewedAsArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargViewedAsArray.kt");
            }

            @TestMetadata("varargViewedAsPrimitiveArray.kt")
            public void testVarargViewedAsPrimitiveArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargViewedAsPrimitiveArray.kt");
            }

            @TestMetadata("varargWithDefaultValue.kt")
            public void testVarargWithDefaultValue() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargWithDefaultValue.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SuspendConversion extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                @TestMetadata("adaptedWithCoercionToUnit.kt")
                public void testAdaptedWithCoercionToUnit() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithCoercionToUnit.kt");
                }

                @TestMetadata("adaptedWithDefaultArguments.kt")
                public void testAdaptedWithDefaultArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithDefaultArguments.kt");
                }

                @TestMetadata("adaptedWithVarargs.kt")
                public void testAdaptedWithVarargs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithVarargs.kt");
                }

                public void testAllFilesPresentInSuspendConversion() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("bound.kt")
                public void testBound() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/bound.kt");
                }

                @TestMetadata("boundExtension.kt")
                public void testBoundExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/boundExtension.kt");
                }

                @TestMetadata("crossInline.kt")
                public void testCrossInline() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/crossInline.kt");
                }

                @TestMetadata("inlineAdaptedWithCoercionToUnit.kt")
                public void testInlineAdaptedWithCoercionToUnit() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithCoercionToUnit.kt");
                }

                @TestMetadata("inlineAdaptedWithDefaultArguments.kt")
                public void testInlineAdaptedWithDefaultArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithDefaultArguments.kt");
                }

                @TestMetadata("inlineAdaptedWithVarargs.kt")
                public void testInlineAdaptedWithVarargs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithVarargs.kt");
                }

                @TestMetadata("inlineBound.kt")
                public void testInlineBound() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineBound.kt");
                }

                @TestMetadata("inlineSimple.kt")
                public void testInlineSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineSimple.kt");
                }

                @TestMetadata("inlineWithParameters.kt")
                public void testInlineWithParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithParameters.kt");
                }

                @TestMetadata("isAs.kt")
                public void testIsAs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/isAs.kt");
                }

                @TestMetadata("nullableParameter.kt")
                public void testNullableParameter() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/nullableParameter.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/simple.kt");
                }

                @TestMetadata("withParameters.kt")
                public void testWithParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/withParameters.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("adapted.kt")
            public void testAdapted() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/adapted.kt");
            }

            public void testAllFilesPresentInBound() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/array.kt");
            }

            @TestMetadata("arrayConstructorArgument.kt")
            public void testArrayConstructorArgument() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/arrayConstructorArgument.kt");
            }

            @TestMetadata("arrayGetIntrinsic.kt")
            public void testArrayGetIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/arrayGetIntrinsic.kt");
            }

            @TestMetadata("boundReferenceToOverloadedFunction.kt")
            public void testBoundReferenceToOverloadedFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/boundReferenceToOverloadedFunction.kt");
            }

            @TestMetadata("captureVarInInitBlock.kt")
            public void testCaptureVarInInitBlock() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/captureVarInInitBlock.kt");
            }

            @TestMetadata("captureVarInPropertyInit.kt")
            public void testCaptureVarInPropertyInit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/captureVarInPropertyInit.kt");
            }

            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/coercionToUnit.kt");
            }

            @TestMetadata("companionObjectReceiver.kt")
            public void testCompanionObjectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/companionObjectReceiver.kt");
            }

            @TestMetadata("dontShareReceiver.kt")
            public void testDontShareReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/dontShareReceiver.kt");
            }

            @TestMetadata("emptyLHS.kt")
            public void testEmptyLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/emptyLHS.kt");
            }

            @TestMetadata("enumEntryMember.kt")
            public void testEnumEntryMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/enumEntryMember.kt");
            }

            @TestMetadata("genericBoundPropertyAsCrossinline.kt")
            public void testGenericBoundPropertyAsCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/genericBoundPropertyAsCrossinline.kt");
            }

            @TestMetadata("genericValOnLHS.kt")
            public void testGenericValOnLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/genericValOnLHS.kt");
            }

            @TestMetadata("kCallableNameIntrinsic.kt")
            public void testKCallableNameIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kCallableNameIntrinsic.kt");
            }

            @TestMetadata("kt12738.kt")
            public void testKt12738() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt12738.kt");
            }

            @TestMetadata("kt15446.kt")
            public void testKt15446() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt15446.kt");
            }

            @TestMetadata("kt44636_localExtension.kt")
            public void testKt44636_localExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt44636_localExtension.kt");
            }

            @TestMetadata("multiCase.kt")
            public void testMultiCase() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/multiCase.kt");
            }

            @TestMetadata("nullReceiver.kt")
            public void testNullReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/nullReceiver.kt");
            }

            @TestMetadata("objectReceiver.kt")
            public void testObjectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/objectReceiver.kt");
            }

            @TestMetadata("primitiveReceiver.kt")
            public void testPrimitiveReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/primitiveReceiver.kt");
            }

            @TestMetadata("receiverEvaluatedOnce.kt")
            public void testReceiverEvaluatedOnce() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/receiverEvaluatedOnce.kt");
            }

            @TestMetadata("simpleFunction.kt")
            public void testSimpleFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/simpleFunction.kt");
            }

            @TestMetadata("simpleProperty.kt")
            public void testSimpleProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/simpleProperty.kt");
            }

            @TestMetadata("smartCastForExtensionReceiver.kt")
            public void testSmartCastForExtensionReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/smartCastForExtensionReceiver.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/bound/equals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Equals extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInEquals() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound/equals"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("nullableReceiverInEquals.kt")
                public void testNullableReceiverInEquals() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/nullableReceiverInEquals.kt");
                }

                @TestMetadata("receiverInEquals.kt")
                public void testReceiverInEquals() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/receiverInEquals.kt");
                }

                @TestMetadata("reflectionReference.kt")
                public void testReflectionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/reflectionReference.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/equality")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equality extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInEquality() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/equality"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("capturedDefaults.kt")
            public void testCapturedDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/capturedDefaults.kt");
            }

            @TestMetadata("capturedVararg.kt")
            public void testCapturedVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/capturedVararg.kt");
            }

            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnit.kt");
            }

            @TestMetadata("coercionToUnitWithDefaults.kt")
            public void testCoercionToUnitWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnitWithDefaults.kt");
            }

            @TestMetadata("coercionToUnitWithVararg.kt")
            public void testCoercionToUnitWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnitWithVararg.kt");
            }

            @TestMetadata("extensionReceiverVsDefault.kt")
            public void testExtensionReceiverVsDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/extensionReceiverVsDefault.kt");
            }

            @TestMetadata("noCoercionToUnitIfFunctionAlreadyReturnsUnit.kt")
            public void testNoCoercionToUnitIfFunctionAlreadyReturnsUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/noCoercionToUnitIfFunctionAlreadyReturnsUnit.kt");
            }

            @TestMetadata("simpleEquality.kt")
            public void testSimpleEquality() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/simpleEquality.kt");
            }

            @TestMetadata("suspendConversion.kt")
            public void testSuspendConversion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/suspendConversion.kt");
            }

            @TestMetadata("varargAsArrayMemberOrExtension.kt")
            public void testVarargAsArrayMemberOrExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargAsArrayMemberOrExtension.kt");
            }

            @TestMetadata("varargAsArrayWithDefaults.kt")
            public void testVarargAsArrayWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargAsArrayWithDefaults.kt");
            }

            @TestMetadata("varargWithDefaults.kt")
            public void testVarargWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargWithDefaults.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/funInterfaceConstructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunInterfaceConstructor extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInFunInterfaceConstructor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/funInterfaceConstructor"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("funInterfaceConstructedObjectsEquality.kt")
            public void testFunInterfaceConstructedObjectsEquality() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructedObjectsEquality.kt");
            }

            @TestMetadata("funInterfaceConstructor.kt")
            public void testFunInterfaceConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructor.kt");
            }

            @TestMetadata("funInterfaceConstructorEquality.kt")
            public void testFunInterfaceConstructorEquality() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorEquality.kt");
            }

            @TestMetadata("funInterfaceConstructorIsKFunction.kt")
            public void testFunInterfaceConstructorIsKFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorIsKFunction.kt");
            }

            @TestMetadata("funInterfaceConstructorOfImplicitKFunctionType.kt")
            public void testFunInterfaceConstructorOfImplicitKFunctionType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorOfImplicitKFunctionType.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("abstractClassMember.kt")
            public void testAbstractClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/abstractClassMember.kt");
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("argumentTypes.kt")
            public void testArgumentTypes() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/argumentTypes.kt");
            }

            @TestMetadata("argumentTypesNoinline.kt")
            public void testArgumentTypesNoinline() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/argumentTypesNoinline.kt");
            }

            @TestMetadata("booleanNotIntrinsic.kt")
            public void testBooleanNotIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/booleanNotIntrinsic.kt");
            }

            @TestMetadata("classMemberFromClass.kt")
            public void testClassMemberFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromClass.kt");
            }

            @TestMetadata("classMemberFromCompanionObject.kt")
            public void testClassMemberFromCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromCompanionObject.kt");
            }

            @TestMetadata("classMemberFromExtension.kt")
            public void testClassMemberFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromExtension.kt");
            }

            @TestMetadata("classMemberFromTopLevelStringNoArgs.kt")
            public void testClassMemberFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("classMemberFromTopLevelStringOneStringArg.kt")
            public void testClassMemberFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("classMemberFromTopLevelUnitNoArgs.kt")
            public void testClassMemberFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("classMemberFromTopLevelUnitOneStringArg.kt")
            public void testClassMemberFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/coercionToUnit.kt");
            }

            @TestMetadata("constructorFromTopLevelNoArgs.kt")
            public void testConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("constructorFromTopLevelOneStringArg.kt")
            public void testConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("enumValueOfMethod.kt")
            public void testEnumValueOfMethod() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/enumValueOfMethod.kt");
            }

            @TestMetadata("equalsIntrinsic.kt")
            public void testEqualsIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/equalsIntrinsic.kt");
            }

            @TestMetadata("extensionFromClass.kt")
            public void testExtensionFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromClass.kt");
            }

            @TestMetadata("extensionFromExtension.kt")
            public void testExtensionFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromExtension.kt");
            }

            @TestMetadata("extensionFromTopLevelStringNoArgs.kt")
            public void testExtensionFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("extensionFromTopLevelStringOneStringArg.kt")
            public void testExtensionFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("extensionFromTopLevelUnitNoArgs.kt")
            public void testExtensionFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("extensionFromTopLevelUnitOneStringArg.kt")
            public void testExtensionFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("genericCallableReferenceArguments.kt")
            public void testGenericCallableReferenceArguments() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferenceArguments.kt");
            }

            @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
            public void testGenericCallableReferencesWithNullableTypes() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
            }

            @TestMetadata("genericCallableReferencesWithOverload.kt")
            public void testGenericCallableReferencesWithOverload() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithOverload.kt");
            }

            @TestMetadata("genericMember.kt")
            public void testGenericMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericMember.kt");
            }

            @TestMetadata("genericWithDependentType.kt")
            public void testGenericWithDependentType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericWithDependentType.kt");
            }

            @TestMetadata("getArityViaFunctionImpl.kt")
            public void testGetArityViaFunctionImpl() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/getArityViaFunctionImpl.kt");
            }

            @TestMetadata("innerClassConstructorWithTwoReceivers.kt")
            public void testInnerClassConstructorWithTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerClassConstructorWithTwoReceivers.kt");
            }

            @TestMetadata("innerConstructorFromClass.kt")
            public void testInnerConstructorFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromClass.kt");
            }

            @TestMetadata("innerConstructorFromExtension.kt")
            public void testInnerConstructorFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromExtension.kt");
            }

            @TestMetadata("innerConstructorFromTopLevelNoArgs.kt")
            public void testInnerConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("innerConstructorFromTopLevelOneStringArg.kt")
            public void testInnerConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("kt21787.kt")
            public void testKt21787() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt21787.kt");
            }

            @TestMetadata("kt32462.kt")
            public void testKt32462() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt32462.kt");
            }

            @TestMetadata("kt47741.kt")
            public void testKt47741() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt47741.kt");
            }

            @TestMetadata("nestedConstructorFromClass.kt")
            public void testNestedConstructorFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromClass.kt");
            }

            @TestMetadata("nestedConstructorFromTopLevelNoArgs.kt")
            public void testNestedConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("nestedConstructorFromTopLevelOneStringArg.kt")
            public void testNestedConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("newArray.kt")
            public void testNewArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/newArray.kt");
            }

            @TestMetadata("overloadedFun.kt")
            public void testOverloadedFun() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/overloadedFun.kt");
            }

            @TestMetadata("overloadedFunVsVal.kt")
            public void testOverloadedFunVsVal() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/overloadedFunVsVal.kt");
            }

            @TestMetadata("privateClassMember.kt")
            public void testPrivateClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/privateClassMember.kt");
            }

            @TestMetadata("referenceToCompanionMember.kt")
            public void testReferenceToCompanionMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/referenceToCompanionMember.kt");
            }

            @TestMetadata("sortListOfStrings.kt")
            public void testSortListOfStrings() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/sortListOfStrings.kt");
            }

            @TestMetadata("specialCalls.kt")
            public void testSpecialCalls() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/specialCalls.kt");
            }

            @TestMetadata("topLevelFromClass.kt")
            public void testTopLevelFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromClass.kt");
            }

            @TestMetadata("topLevelFromExtension.kt")
            public void testTopLevelFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromExtension.kt");
            }

            @TestMetadata("topLevelFromTopLevelStringNoArgs.kt")
            public void testTopLevelFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("topLevelFromTopLevelStringOneStringArg.kt")
            public void testTopLevelFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("topLevelFromTopLevelUnitManyArgs.kt")
            public void testTopLevelFromTopLevelUnitManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitManyArgs.kt");
            }

            @TestMetadata("topLevelFromTopLevelUnitNoArgs.kt")
            public void testTopLevelFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("topLevelFromTopLevelUnitOneStringArg.kt")
            public void testTopLevelFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("traitImplMethodWithClassReceiver.kt")
            public void testTraitImplMethodWithClassReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/traitImplMethodWithClassReceiver.kt");
            }

            @TestMetadata("traitMember.kt")
            public void testTraitMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/traitMember.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/function/local")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Local extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInLocal() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function/local"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("captureOuter.kt")
                public void testCaptureOuter() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/captureOuter.kt");
                }

                @TestMetadata("classMember.kt")
                public void testClassMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/classMember.kt");
                }

                @TestMetadata("closureWithSideEffect.kt")
                public void testClosureWithSideEffect() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/closureWithSideEffect.kt");
                }

                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/constructor.kt");
                }

                @TestMetadata("constructorWithInitializer.kt")
                public void testConstructorWithInitializer() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/constructorWithInitializer.kt");
                }

                @TestMetadata("enumExtendsTrait.kt")
                public void testEnumExtendsTrait() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/enumExtendsTrait.kt");
                }

                @TestMetadata("equalsHashCode.kt")
                public void testEqualsHashCode() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/equalsHashCode.kt");
                }

                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extension.kt");
                }

                @TestMetadata("extensionToLocalClass.kt")
                public void testExtensionToLocalClass() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToLocalClass.kt");
                }

                @TestMetadata("extensionToPrimitive.kt")
                public void testExtensionToPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToPrimitive.kt");
                }

                @TestMetadata("extensionWithClosure.kt")
                public void testExtensionWithClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionWithClosure.kt");
                }

                @TestMetadata("genericMember.kt")
                public void testGenericMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/genericMember.kt");
                }

                @TestMetadata("localClassMember.kt")
                public void testLocalClassMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localClassMember.kt");
                }

                @TestMetadata("localFunctionName.kt")
                public void testLocalFunctionName() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localFunctionName.kt");
                }

                @TestMetadata("localLocal.kt")
                public void testLocalLocal() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localLocal.kt");
                }

                @TestMetadata("recursiveClosure.kt")
                public void testRecursiveClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/recursiveClosure.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simple.kt");
                }

                @TestMetadata("simpleClosure.kt")
                public void testSimpleClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simpleClosure.kt");
                }

                @TestMetadata("simpleWithArg.kt")
                public void testSimpleWithArg() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simpleWithArg.kt");
                }

                @TestMetadata("unitWithSideEffect.kt")
                public void testUnitWithSideEffect() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/unitWithSideEffect.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("accessViaSubclass.kt")
            public void testAccessViaSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/accessViaSubclass.kt");
            }

            @TestMetadata("accessorForPropertyWithPrivateSetter.kt")
            public void testAccessorForPropertyWithPrivateSetter() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/accessorForPropertyWithPrivateSetter.kt");
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/property"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("delegated.kt")
            public void testDelegated() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/delegated.kt");
            }

            @TestMetadata("delegatedMutable.kt")
            public void testDelegatedMutable() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/delegatedMutable.kt");
            }

            @TestMetadata("enumNameOrdinal.kt")
            public void testEnumNameOrdinal() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/enumNameOrdinal.kt");
            }

            @TestMetadata("extensionToArray.kt")
            public void testExtensionToArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/extensionToArray.kt");
            }

            @TestMetadata("genericProperty.kt")
            public void testGenericProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/genericProperty.kt");
            }

            @TestMetadata("inEnum.kt")
            public void testInEnum() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/inEnum.kt");
            }

            @TestMetadata("inReceiverOfAnother.kt")
            public void testInReceiverOfAnother() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/inReceiverOfAnother.kt");
            }

            @TestMetadata("invokePropertyReference.kt")
            public void testInvokePropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/invokePropertyReference.kt");
            }

            @TestMetadata("javaBeanConvention.kt")
            public void testJavaBeanConvention() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/javaBeanConvention.kt");
            }

            @TestMetadata("kClassInstanceIsInitializedFirst.kt")
            public void testKClassInstanceIsInitializedFirst() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kClassInstanceIsInitializedFirst.kt");
            }

            @TestMetadata("kt12044.kt")
            public void testKt12044() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt12044.kt");
            }

            @TestMetadata("kt12982_protectedPropertyReference.kt")
            public void testKt12982_protectedPropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt12982_protectedPropertyReference.kt");
            }

            @TestMetadata("kt14330.kt")
            public void testKt14330() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt14330.kt");
            }

            @TestMetadata("kt14330_2.kt")
            public void testKt14330_2() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt14330_2.kt");
            }

            @TestMetadata("kt15447.kt")
            public void testKt15447() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt15447.kt");
            }

            @TestMetadata("kt6870_privatePropertyReference.kt")
            public void testKt6870_privatePropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt6870_privatePropertyReference.kt");
            }

            @TestMetadata("listOfStringsMapLength.kt")
            public void testListOfStringsMapLength() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/listOfStringsMapLength.kt");
            }

            @TestMetadata("localClassVar.kt")
            public void testLocalClassVar() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/localClassVar.kt");
            }

            @TestMetadata("overriddenInSubclass.kt")
            public void testOverriddenInSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/overriddenInSubclass.kt");
            }

            @TestMetadata("privateSetOuterClass.kt")
            public void testPrivateSetOuterClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetOuterClass.kt");
            }

            @TestMetadata("privateSetterInsideClass.kt")
            public void testPrivateSetterInsideClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetterInsideClass.kt");
            }

            @TestMetadata("privateSetterOutsideClass.kt")
            public void testPrivateSetterOutsideClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetterOutsideClass.kt");
            }

            @TestMetadata("receiverEvaluatedOnce.kt")
            public void testReceiverEvaluatedOnce() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/receiverEvaluatedOnce.kt");
            }

            @TestMetadata("simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleExtension.kt");
            }

            @TestMetadata("simpleMember.kt")
            public void testSimpleMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMember.kt");
            }

            @TestMetadata("simpleMutableExtension.kt")
            public void testSimpleMutableExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableExtension.kt");
            }

            @TestMetadata("simpleMutableMember.kt")
            public void testSimpleMutableMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableMember.kt");
            }

            @TestMetadata("simpleMutableTopLevel.kt")
            public void testSimpleMutableTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableTopLevel.kt");
            }

            @TestMetadata("simpleTopLevel.kt")
            public void testSimpleTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleTopLevel.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/serializability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Serializability extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSerializability() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/serializability"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/casts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Casts extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInCasts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("as.kt")
        public void testAs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/as.kt");
        }

        @TestMetadata("asForConstants.kt")
        public void testAsForConstants() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asForConstants.kt");
        }

        @TestMetadata("asSafe.kt")
        public void testAsSafe() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafe.kt");
        }

        @TestMetadata("asSafeFail.kt")
        public void testAsSafeFail() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafeFail.kt");
        }

        @TestMetadata("asSafeForConstants.kt")
        public void testAsSafeForConstants() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafeForConstants.kt");
        }

        @TestMetadata("asUnit.kt")
        public void testAsUnit() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asUnit.kt");
        }

        @TestMetadata("asWithGeneric.kt")
        public void testAsWithGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asWithGeneric.kt");
        }

        @TestMetadata("castGenericNull.kt")
        public void testCastGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/casts/castGenericNull.kt");
        }

        @TestMetadata("castToDefinitelyNotNullType.kt")
        public void testCastToDefinitelyNotNullType() throws Exception {
            runTest("compiler/testData/codegen/box/casts/castToDefinitelyNotNullType.kt");
        }

        @TestMetadata("dontCreateInconsistentTypeDuringStarProjectionSubstitution.kt")
        public void testDontCreateInconsistentTypeDuringStarProjectionSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/casts/dontCreateInconsistentTypeDuringStarProjectionSubstitution.kt");
        }

        @TestMetadata("intersectionTypeMultipleBounds.kt")
        public void testIntersectionTypeMultipleBounds() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBounds.kt");
        }

        @TestMetadata("intersectionTypeMultipleBoundsImplicitReceiver.kt")
        public void testIntersectionTypeMultipleBoundsImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBoundsImplicitReceiver.kt");
        }

        @TestMetadata("intersectionTypeSmartcast.kt")
        public void testIntersectionTypeSmartcast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeSmartcast.kt");
        }

        @TestMetadata("intersectionTypeWithMultipleBoundsAsReceiver.kt")
        public void testIntersectionTypeWithMultipleBoundsAsReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeWithMultipleBoundsAsReceiver.kt");
        }

        @TestMetadata("intersectionTypeWithoutGenericsAsReceiver.kt")
        public void testIntersectionTypeWithoutGenericsAsReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeWithoutGenericsAsReceiver.kt");
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/is.kt");
        }

        @TestMetadata("isNullablePrimitive.kt")
        public void testIsNullablePrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/casts/isNullablePrimitive.kt");
        }

        @TestMetadata("kt22714.kt")
        public void testKt22714() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt22714.kt");
        }

        @TestMetadata("kt48927_privateMethodOnDerivedCastToBase.kt")
        public void testKt48927_privateMethodOnDerivedCastToBase() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt48927_privateMethodOnDerivedCastToBase.kt");
        }

        @TestMetadata("kt50577.kt")
        public void testKt50577() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt50577.kt");
        }

        @TestMetadata("lambdaToUnitCast.kt")
        public void testLambdaToUnitCast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/lambdaToUnitCast.kt");
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/notIs.kt");
        }

        @TestMetadata("nullableSafeCastToTypeParameterWithInterfaceUpperBound.kt")
        public void testNullableSafeCastToTypeParameterWithInterfaceUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/casts/nullableSafeCastToTypeParameterWithInterfaceUpperBound.kt");
        }

        @TestMetadata("objectToPrimitiveWithAssertion.kt")
        public void testObjectToPrimitiveWithAssertion() throws Exception {
            runTest("compiler/testData/codegen/box/casts/objectToPrimitiveWithAssertion.kt");
        }

        @TestMetadata("unitAsAny.kt")
        public void testUnitAsAny() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsAny.kt");
        }

        @TestMetadata("unitAsSafeAny.kt")
        public void testUnitAsSafeAny() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsSafeAny.kt");
        }

        @TestMetadata("unitNullableCast.kt")
        public void testUnitNullableCast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitNullableCast.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/casts/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/functions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("asFunKBig.kt")
            public void testAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/asFunKBig.kt");
            }

            @TestMetadata("asFunKSmall.kt")
            public void testAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/asFunKSmall.kt");
            }

            @TestMetadata("isFunKBig.kt")
            public void testIsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/isFunKBig.kt");
            }

            @TestMetadata("isFunKSmall.kt")
            public void testIsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/isFunKSmall.kt");
            }

            @TestMetadata("reifiedAsFunKBig.kt")
            public void testReifiedAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKBig.kt");
            }

            @TestMetadata("reifiedAsFunKSmall.kt")
            public void testReifiedAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKSmall.kt");
            }

            @TestMetadata("reifiedIsFunKBig.kt")
            public void testReifiedIsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKBig.kt");
            }

            @TestMetadata("reifiedIsFunKSmall.kt")
            public void testReifiedIsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKSmall.kt");
            }

            @TestMetadata("reifiedSafeAsFunKBig.kt")
            public void testReifiedSafeAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKBig.kt");
            }

            @TestMetadata("reifiedSafeAsFunKSmall.kt")
            public void testReifiedSafeAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKSmall.kt");
            }

            @TestMetadata("safeAsFunKBig.kt")
            public void testSafeAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKBig.kt");
            }

            @TestMetadata("safeAsFunKSmall.kt")
            public void testSafeAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKSmall.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/javaInterop")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaInterop extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInJavaInterop() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/javaInterop"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LiteralExpressionAsGenericArgument extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInLiteralExpressionAsGenericArgument() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("binaryExpressionCast.kt")
            public void testBinaryExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/binaryExpressionCast.kt");
            }

            @TestMetadata("labeledExpressionCast.kt")
            public void testLabeledExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/labeledExpressionCast.kt");
            }

            @TestMetadata("parenthesizedExpressionCast.kt")
            public void testParenthesizedExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/parenthesizedExpressionCast.kt");
            }

            @TestMetadata("superConstructor.kt")
            public void testSuperConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/superConstructor.kt");
            }

            @TestMetadata("unaryExpressionCast.kt")
            public void testUnaryExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/unaryExpressionCast.kt");
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/vararg.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/mutableCollections")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MutableCollections extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInMutableCollections() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/mutableCollections"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("asWithMutable.kt")
            public void testAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/asWithMutable.kt");
            }

            @TestMetadata("isWithMutable.kt")
            public void testIsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/isWithMutable.kt");
            }

            @TestMetadata("reifiedAsWithMutable.kt")
            public void testReifiedAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedAsWithMutable.kt");
            }

            @TestMetadata("reifiedIsWithMutable.kt")
            public void testReifiedIsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedIsWithMutable.kt");
            }

            @TestMetadata("reifiedSafeAsWithMutable.kt")
            public void testReifiedSafeAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedSafeAsWithMutable.kt");
            }

            @TestMetadata("safeAsWithMutable.kt")
            public void testSafeAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/safeAsWithMutable.kt");
            }

            @TestMetadata("weirdMutableCasts.kt")
            public void testWeirdMutableCasts() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/weirdMutableCasts.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/nativeCCEMessage")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NativeCCEMessage extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInNativeCCEMessage() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/nativeCCEMessage"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/checkcastOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CheckcastOptimization extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInCheckcastOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/checkcastOptimization"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("kt19128.kt")
        public void testKt19128() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt19128.kt");
        }

        @TestMetadata("kt19246.kt")
        public void testKt19246() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt19246.kt");
        }

        @TestMetadata("kt47851.kt")
        public void testKt47851() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt47851.kt");
        }

        @TestMetadata("kt50215.kt")
        public void testKt50215() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt50215.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/classLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassLiteral extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInClassLiteral() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("bareArray.kt")
        public void testBareArray() throws Exception {
            runTest("compiler/testData/codegen/box/classLiteral/bareArray.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/classLiteral/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBound() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/bound"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("primitives.kt")
            public void testPrimitives() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/primitives.kt");
            }

            @TestMetadata("sideEffect.kt")
            public void testSideEffect() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/sideEffect.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/simple.kt");
            }

            @TestMetadata("smartCast.kt")
            public void testSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/smartCast.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/classLiteral/java")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Java extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInJava() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/java"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt11943.kt")
            public void testKt11943() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/kt11943.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/classes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Classes extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classes"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("boxPrimitiveTypeInClinitOfClassObject.kt")
        public void testBoxPrimitiveTypeInClinitOfClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/boxPrimitiveTypeInClinitOfClassObject.kt");
        }

        @TestMetadata("classNamedAsOldPackageFacade.kt")
        public void testClassNamedAsOldPackageFacade() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classNamedAsOldPackageFacade.kt");
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObject.kt");
        }

        @TestMetadata("classObjectAsExtensionReceiver.kt")
        public void testClassObjectAsExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectAsExtensionReceiver.kt");
        }

        @TestMetadata("classObjectAsStaticInitializer.kt")
        public void testClassObjectAsStaticInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectAsStaticInitializer.kt");
        }

        @TestMetadata("classObjectField.kt")
        public void testClassObjectField() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectField.kt");
        }

        @TestMetadata("classObjectInTrait.kt")
        public void testClassObjectInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectInTrait.kt");
        }

        @TestMetadata("classObjectNotOfEnum.kt")
        public void testClassObjectNotOfEnum() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectNotOfEnum.kt");
        }

        @TestMetadata("classObjectWithPrivateGenericMember.kt")
        public void testClassObjectWithPrivateGenericMember() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectWithPrivateGenericMember.kt");
        }

        @TestMetadata("classObjectsWithParentClasses.kt")
        public void testClassObjectsWithParentClasses() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectsWithParentClasses.kt");
        }

        @TestMetadata("comanionObjectFieldVsClassField.kt")
        public void testComanionObjectFieldVsClassField() throws Exception {
            runTest("compiler/testData/codegen/box/classes/comanionObjectFieldVsClassField.kt");
        }

        @TestMetadata("defaultObjectSameNamesAsInOuter.kt")
        public void testDefaultObjectSameNamesAsInOuter() throws Exception {
            runTest("compiler/testData/codegen/box/classes/defaultObjectSameNamesAsInOuter.kt");
        }

        @TestMetadata("delegateConstructorCallWithKeywords.kt")
        public void testDelegateConstructorCallWithKeywords() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegateConstructorCallWithKeywords.kt");
        }

        @TestMetadata("delegation2.kt")
        public void testDelegation2() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation2.kt");
        }

        @TestMetadata("delegation3.kt")
        public void testDelegation3() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation3.kt");
        }

        @TestMetadata("delegation4.kt")
        public void testDelegation4() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation4.kt");
        }

        @TestMetadata("delegationGenericArg.kt")
        public void testDelegationGenericArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericArg.kt");
        }

        @TestMetadata("delegationGenericArgUpperBound.kt")
        public void testDelegationGenericArgUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericArgUpperBound.kt");
        }

        @TestMetadata("delegationGenericLongArg.kt")
        public void testDelegationGenericLongArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericLongArg.kt");
        }

        @TestMetadata("delegationJava.kt")
        public void testDelegationJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationJava.kt");
        }

        @TestMetadata("delegationMethodsWithArgs.kt")
        public void testDelegationMethodsWithArgs() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationMethodsWithArgs.kt");
        }

        @TestMetadata("exceptionConstructor.kt")
        public void testExceptionConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/classes/exceptionConstructor.kt");
        }

        @TestMetadata("extensionFunWithDefaultParam.kt")
        public void testExtensionFunWithDefaultParam() throws Exception {
            runTest("compiler/testData/codegen/box/classes/extensionFunWithDefaultParam.kt");
        }

        @TestMetadata("extensionOnNamedClassObject.kt")
        public void testExtensionOnNamedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/extensionOnNamedClassObject.kt");
        }

        @TestMetadata("funDelegation.kt")
        public void testFunDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/funDelegation.kt");
        }

        @TestMetadata("implementComparableInSubclass.kt")
        public void testImplementComparableInSubclass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/implementComparableInSubclass.kt");
        }

        @TestMetadata("inheritSetAndHashSet.kt")
        public void testInheritSetAndHashSet() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritSetAndHashSet.kt");
        }

        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritance.kt");
        }

        @TestMetadata("inheritedInnerClass.kt")
        public void testInheritedInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritedInnerClass.kt");
        }

        @TestMetadata("inheritedMethod.kt")
        public void testInheritedMethod() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritedMethod.kt");
        }

        @TestMetadata("initializerBlock.kt")
        public void testInitializerBlock() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlock.kt");
        }

        @TestMetadata("initializerBlockDImpl.kt")
        public void testInitializerBlockDImpl() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlockDImpl.kt");
        }

        @TestMetadata("initializerBlockResetToDefault.kt")
        public void testInitializerBlockResetToDefault() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlockResetToDefault.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/innerClass.kt");
        }

        @TestMetadata("kt1018.kt")
        public void testKt1018() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1018.kt");
        }

        @TestMetadata("kt1120.kt")
        public void testKt1120() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1120.kt");
        }

        @TestMetadata("kt1157.kt")
        public void testKt1157() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1157.kt");
        }

        @TestMetadata("kt1247.kt")
        public void testKt1247() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1247.kt");
        }

        @TestMetadata("kt1345.kt")
        public void testKt1345() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1345.kt");
        }

        @TestMetadata("kt1439.kt")
        public void testKt1439() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1439.kt");
        }

        @TestMetadata("kt1535.kt")
        public void testKt1535() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1535.kt");
        }

        @TestMetadata("kt1538.kt")
        public void testKt1538() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1538.kt");
        }

        @TestMetadata("kt1578.kt")
        public void testKt1578() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1578.kt");
        }

        @TestMetadata("kt1611.kt")
        public void testKt1611() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1611.kt");
        }

        @TestMetadata("kt1721.kt")
        public void testKt1721() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1721.kt");
        }

        @TestMetadata("kt1726.kt")
        public void testKt1726() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1726.kt");
        }

        @TestMetadata("kt1759.kt")
        public void testKt1759() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1759.kt");
        }

        @TestMetadata("kt1891.kt")
        public void testKt1891() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1891.kt");
        }

        @TestMetadata("kt1918.kt")
        public void testKt1918() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1918.kt");
        }

        @TestMetadata("kt1976.kt")
        public void testKt1976() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1976.kt");
        }

        @TestMetadata("kt1980.kt")
        public void testKt1980() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1980.kt");
        }

        @TestMetadata("kt2224.kt")
        public void testKt2224() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2224.kt");
        }

        @TestMetadata("kt2384.kt")
        public void testKt2384() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2384.kt");
        }

        @TestMetadata("kt2390.kt")
        public void testKt2390() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2390.kt");
        }

        @TestMetadata("kt2391.kt")
        public void testKt2391() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2391.kt");
        }

        @TestMetadata("kt2417.kt")
        public void testKt2417() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2417.kt");
        }

        @TestMetadata("kt2477.kt")
        public void testKt2477() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2477.kt");
        }

        @TestMetadata("kt2480.kt")
        public void testKt2480() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2480.kt");
        }

        @TestMetadata("kt2482.kt")
        public void testKt2482() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2482.kt");
        }

        @TestMetadata("kt2485.kt")
        public void testKt2485() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2485.kt");
        }

        @TestMetadata("kt249.kt")
        public void testKt249() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt249.kt");
        }

        @TestMetadata("kt2532.kt")
        public void testKt2532() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2532.kt");
        }

        @TestMetadata("kt2566.kt")
        public void testKt2566() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2566.kt");
        }

        @TestMetadata("kt2566_2.kt")
        public void testKt2566_2() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2566_2.kt");
        }

        @TestMetadata("kt2607.kt")
        public void testKt2607() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2607.kt");
        }

        @TestMetadata("kt2626.kt")
        public void testKt2626() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2626.kt");
        }

        @TestMetadata("kt2711.kt")
        public void testKt2711() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2711.kt");
        }

        @TestMetadata("kt2784.kt")
        public void testKt2784() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2784.kt");
        }

        @TestMetadata("kt285.kt")
        public void testKt285() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt285.kt");
        }

        @TestMetadata("kt3001.kt")
        public void testKt3001() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3001.kt");
        }

        @TestMetadata("kt3114.kt")
        public void testKt3114() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3114.kt");
        }

        @TestMetadata("kt3414.kt")
        public void testKt3414() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3414.kt");
        }

        @TestMetadata("kt343.kt")
        public void testKt343() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt343.kt");
        }

        @TestMetadata("kt3546.kt")
        public void testKt3546() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3546.kt");
        }

        @TestMetadata("kt40332.kt")
        public void testKt40332() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt40332.kt");
        }

        @TestMetadata("kt454.kt")
        public void testKt454() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt454.kt");
        }

        @TestMetadata("kt471.kt")
        public void testKt471() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt471.kt");
        }

        @TestMetadata("kt48.kt")
        public void testKt48() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt48.kt");
        }

        @TestMetadata("kt496.kt")
        public void testKt496() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt496.kt");
        }

        @TestMetadata("kt500.kt")
        public void testKt500() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt500.kt");
        }

        @TestMetadata("kt501.kt")
        public void testKt501() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt501.kt");
        }

        @TestMetadata("kt504.kt")
        public void testKt504() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt504.kt");
        }

        @TestMetadata("kt508.kt")
        public void testKt508() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt508.kt");
        }

        @TestMetadata("kt5347.kt")
        public void testKt5347() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt5347.kt");
        }

        @TestMetadata("kt6136.kt")
        public void testKt6136() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt6136.kt");
        }

        @TestMetadata("kt633.kt")
        public void testKt633() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt633.kt");
        }

        @TestMetadata("kt6816.kt")
        public void testKt6816() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt6816.kt");
        }

        @TestMetadata("kt707.kt")
        public void testKt707() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt707.kt");
        }

        @TestMetadata("kt723.kt")
        public void testKt723() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt723.kt");
        }

        @TestMetadata("kt725.kt")
        public void testKt725() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt725.kt");
        }

        @TestMetadata("kt8011.kt")
        public void testKt8011() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt8011.kt");
        }

        @TestMetadata("kt8011a.kt")
        public void testKt8011a() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt8011a.kt");
        }

        @TestMetadata("kt940.kt")
        public void testKt940() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt940.kt");
        }

        @TestMetadata("kt9642.kt")
        public void testKt9642() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt9642.kt");
        }

        @TestMetadata("namedClassObject.kt")
        public void testNamedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/namedClassObject.kt");
        }

        @TestMetadata("outerThis.kt")
        public void testOuterThis() throws Exception {
            runTest("compiler/testData/codegen/box/classes/outerThis.kt");
        }

        @TestMetadata("overloadBinaryOperator.kt")
        public void testOverloadBinaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadBinaryOperator.kt");
        }

        @TestMetadata("overloadPlusAssign.kt")
        public void testOverloadPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusAssign.kt");
        }

        @TestMetadata("overloadPlusAssignReturn.kt")
        public void testOverloadPlusAssignReturn() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusAssignReturn.kt");
        }

        @TestMetadata("overloadPlusToPlusAssign.kt")
        public void testOverloadPlusToPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusToPlusAssign.kt");
        }

        @TestMetadata("overloadUnaryOperator.kt")
        public void testOverloadUnaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadUnaryOperator.kt");
        }

        @TestMetadata("privateOuterFunctions.kt")
        public void testPrivateOuterFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateOuterFunctions.kt");
        }

        @TestMetadata("privateOuterProperty.kt")
        public void testPrivateOuterProperty() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateOuterProperty.kt");
        }

        @TestMetadata("privateToThis.kt")
        public void testPrivateToThis() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateToThis.kt");
        }

        @TestMetadata("propertyDelegation.kt")
        public void testPropertyDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/propertyDelegation.kt");
        }

        @TestMetadata("propertyInInitializer.kt")
        public void testPropertyInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/classes/propertyInInitializer.kt");
        }

        @TestMetadata("quotedClassName.kt")
        public void testQuotedClassName() throws Exception {
            runTest("compiler/testData/codegen/box/classes/quotedClassName.kt");
        }

        @TestMetadata("rightHandOverride.kt")
        public void testRightHandOverride() throws Exception {
            runTest("compiler/testData/codegen/box/classes/rightHandOverride.kt");
        }

        @TestMetadata("selfcreate.kt")
        public void testSelfcreate() throws Exception {
            runTest("compiler/testData/codegen/box/classes/selfcreate.kt");
        }

        @TestMetadata("simpleBox.kt")
        public void testSimpleBox() throws Exception {
            runTest("compiler/testData/codegen/box/classes/simpleBox.kt");
        }

        @TestMetadata("superConstructorCallWithComplexArg.kt")
        public void testSuperConstructorCallWithComplexArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/superConstructorCallWithComplexArg.kt");
        }

        @TestMetadata("typedDelegation.kt")
        public void testTypedDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/typedDelegation.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/classes/inner")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inner extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInner() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classes/inner"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("extensionWithOuter.kt")
            public void testExtensionWithOuter() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/extensionWithOuter.kt");
            }

            @TestMetadata("instantiateInDerived.kt")
            public void testInstantiateInDerived() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerived.kt");
            }

            @TestMetadata("instantiateInDerivedLabeled.kt")
            public void testInstantiateInDerivedLabeled() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerivedLabeled.kt");
            }

            @TestMetadata("instantiateInSameClass.kt")
            public void testInstantiateInSameClass() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInSameClass.kt");
            }

            @TestMetadata("kt6708.kt")
            public void testKt6708() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/kt6708.kt");
            }

            @TestMetadata("properOuter.kt")
            public void testProperOuter() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/properOuter.kt");
            }

            @TestMetadata("properSuperLinking.kt")
            public void testProperSuperLinking() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/properSuperLinking.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/closures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Closures extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInClosures() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("anonymousObjectAsLastExpressionInLambda.kt")
        public void testAnonymousObjectAsLastExpressionInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/closures/anonymousObjectAsLastExpressionInLambda.kt");
        }

        @TestMetadata("captureExtensionReceiver.kt")
        public void testCaptureExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/closures/captureExtensionReceiver.kt");
        }

        @TestMetadata("captureExtensionReceiverX2.kt")
        public void testCaptureExtensionReceiverX2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/captureExtensionReceiverX2.kt");
        }

        @TestMetadata("capturedLocalGenericFun.kt")
        public void testCapturedLocalGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/closures/capturedLocalGenericFun.kt");
        }

        @TestMetadata("closureInsideConstrucor.kt")
        public void testClosureInsideConstrucor() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureInsideConstrucor.kt");
        }

        @TestMetadata("closureOnTopLevel1.kt")
        public void testClosureOnTopLevel1() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureOnTopLevel1.kt");
        }

        @TestMetadata("closureOnTopLevel2.kt")
        public void testClosureOnTopLevel2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureOnTopLevel2.kt");
        }

        @TestMetadata("closureWithParameter.kt")
        public void testClosureWithParameter() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureWithParameter.kt");
        }

        @TestMetadata("closureWithParameterAndBoxing.kt")
        public void testClosureWithParameterAndBoxing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureWithParameterAndBoxing.kt");
        }

        @TestMetadata("crossinlineLocalDeclaration.kt")
        public void testCrossinlineLocalDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/closures/crossinlineLocalDeclaration.kt");
        }

        @TestMetadata("doubleEnclosedLocalVariable.kt")
        public void testDoubleEnclosedLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/doubleEnclosedLocalVariable.kt");
        }

        @TestMetadata("enclosingLocalVariable.kt")
        public void testEnclosingLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/enclosingLocalVariable.kt");
        }

        @TestMetadata("enclosingThis.kt")
        public void testEnclosingThis() throws Exception {
            runTest("compiler/testData/codegen/box/closures/enclosingThis.kt");
        }

        @TestMetadata("extensionClosure.kt")
        public void testExtensionClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/extensionClosure.kt");
        }

        @TestMetadata("kt10044.kt")
        public void testKt10044() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt10044.kt");
        }

        @TestMetadata("kt11634.kt")
        public void testKt11634() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634.kt");
        }

        @TestMetadata("kt11634_2.kt")
        public void testKt11634_2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_2.kt");
        }

        @TestMetadata("kt11634_3.kt")
        public void testKt11634_3() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_3.kt");
        }

        @TestMetadata("kt11634_4.kt")
        public void testKt11634_4() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_4.kt");
        }

        @TestMetadata("kt19389.kt")
        public void testKt19389() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt19389.kt");
        }

        @TestMetadata("kt19389_set.kt")
        public void testKt19389_set() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt19389_set.kt");
        }

        @TestMetadata("kt2151.kt")
        public void testKt2151() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt2151.kt");
        }

        @TestMetadata("kt3152.kt")
        public void testKt3152() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3152.kt");
        }

        @TestMetadata("kt3523.kt")
        public void testKt3523() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3523.kt");
        }

        @TestMetadata("kt3738.kt")
        public void testKt3738() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3738.kt");
        }

        @TestMetadata("kt3905.kt")
        public void testKt3905() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3905.kt");
        }

        @TestMetadata("kt4106.kt")
        public void testKt4106() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt4106.kt");
        }

        @TestMetadata("kt4137.kt")
        public void testKt4137() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt4137.kt");
        }

        @TestMetadata("kt47840.kt")
        public void testKt47840() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47840.kt");
        }

        @TestMetadata("kt47894_inlineFunWithObjectWithNothing.kt")
        public void testKt47894_inlineFunWithObjectWithNothing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47894_inlineFunWithObjectWithNothing.kt");
        }

        @TestMetadata("kt5589.kt")
        public void testKt5589() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt5589.kt");
        }

        @TestMetadata("localClassFunClosure.kt")
        public void testLocalClassFunClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localClassFunClosure.kt");
        }

        @TestMetadata("localClassLambdaClosure.kt")
        public void testLocalClassLambdaClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localClassLambdaClosure.kt");
        }

        @TestMetadata("localFunInInit.kt")
        public void testLocalFunInInit() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunInInit.kt");
        }

        @TestMetadata("localFunctionInFunction.kt")
        public void testLocalFunctionInFunction() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInFunction.kt");
        }

        @TestMetadata("localFunctionInInitBlock.kt")
        public void testLocalFunctionInInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInInitBlock.kt");
        }

        @TestMetadata("localFunctionInInitializer.kt")
        public void testLocalFunctionInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInInitializer.kt");
        }

        @TestMetadata("localGenericFun.kt")
        public void testLocalGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localGenericFun.kt");
        }

        @TestMetadata("localReturn.kt")
        public void testLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localReturn.kt");
        }

        @TestMetadata("localReturnWithAutolabel.kt")
        public void testLocalReturnWithAutolabel() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localReturnWithAutolabel.kt");
        }

        @TestMetadata("recursiveClosure.kt")
        public void testRecursiveClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/recursiveClosure.kt");
        }

        @TestMetadata("simplestClosure.kt")
        public void testSimplestClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/simplestClosure.kt");
        }

        @TestMetadata("simplestClosureAndBoxing.kt")
        public void testSimplestClosureAndBoxing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/simplestClosureAndBoxing.kt");
        }

        @TestMetadata("subclosuresWithinInitializers.kt")
        public void testSubclosuresWithinInitializers() throws Exception {
            runTest("compiler/testData/codegen/box/closures/subclosuresWithinInitializers.kt");
        }

        @TestMetadata("underscoreParameters.kt")
        public void testUnderscoreParameters() throws Exception {
            runTest("compiler/testData/codegen/box/closures/underscoreParameters.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/closures/captureInSuperConstructorCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CaptureInSuperConstructorCall extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInCaptureInSuperConstructorCall() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/captureInSuperConstructorCall"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("constructorParameterAndLocalCapturedInLambdaInLocalClass.kt")
            public void testConstructorParameterAndLocalCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterAndLocalCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("constructorParameterCapturedInLambdaInLocalClass.kt")
            public void testConstructorParameterCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("constructorParameterCapturedInLambdaInLocalClass2.kt")
            public void testConstructorParameterCapturedInLambdaInLocalClass2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass2.kt");
            }

            @TestMetadata("kt13454.kt")
            public void testKt13454() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt13454.kt");
            }

            @TestMetadata("kt14148.kt")
            public void testKt14148() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt14148.kt");
            }

            @TestMetadata("kt4174.kt")
            public void testKt4174() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174.kt");
            }

            @TestMetadata("kt4174a.kt")
            public void testKt4174a() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174a.kt");
            }

            @TestMetadata("localCapturedInAnonymousObjectInLocalClass.kt")
            public void testLocalCapturedInAnonymousObjectInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass.kt");
            }

            @TestMetadata("localCapturedInAnonymousObjectInLocalClass2.kt")
            public void testLocalCapturedInAnonymousObjectInLocalClass2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass2.kt");
            }

            @TestMetadata("localCapturedInLambdaInInnerClassInLocalClass.kt")
            public void testLocalCapturedInLambdaInInnerClassInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInInnerClassInLocalClass.kt");
            }

            @TestMetadata("localCapturedInLambdaInLocalClass.kt")
            public void testLocalCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("localFunctionCapturedInLambda.kt")
            public void testLocalFunctionCapturedInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localFunctionCapturedInLambda.kt");
            }

            @TestMetadata("outerAndLocalCapturedInLocalClass.kt")
            public void testOuterAndLocalCapturedInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerAndLocalCapturedInLocalClass.kt");
            }

            @TestMetadata("outerCapturedAsImplicitThisInBoundReference.kt")
            public void testOuterCapturedAsImplicitThisInBoundReference() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedAsImplicitThisInBoundReference.kt");
            }

            @TestMetadata("outerCapturedInFunctionLiteral.kt")
            public void testOuterCapturedInFunctionLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInFunctionLiteral.kt");
            }

            @TestMetadata("outerCapturedInInlineLambda.kt")
            public void testOuterCapturedInInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda.kt");
            }

            @TestMetadata("outerCapturedInInlineLambda2.kt")
            public void testOuterCapturedInInlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda2.kt");
            }

            @TestMetadata("outerCapturedInLambda.kt")
            public void testOuterCapturedInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda.kt");
            }

            @TestMetadata("outerCapturedInLambda2.kt")
            public void testOuterCapturedInLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda2.kt");
            }

            @TestMetadata("outerCapturedInLambdaInSecondaryConstructor.kt")
            public void testOuterCapturedInLambdaInSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSecondaryConstructor.kt");
            }

            @TestMetadata("outerCapturedInLambdaInSubExpression.kt")
            public void testOuterCapturedInLambdaInSubExpression() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSubExpression.kt");
            }

            @TestMetadata("outerCapturedInLocalClass.kt")
            public void testOuterCapturedInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLocalClass.kt");
            }

            @TestMetadata("outerCapturedInNestedLambda.kt")
            public void testOuterCapturedInNestedLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedLambda.kt");
            }

            @TestMetadata("outerCapturedInNestedObject.kt")
            public void testOuterCapturedInNestedObject() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedObject.kt");
            }

            @TestMetadata("outerCapturedInObject.kt")
            public void testOuterCapturedInObject() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject.kt");
            }

            @TestMetadata("outerCapturedInObject2.kt")
            public void testOuterCapturedInObject2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject2.kt");
            }

            @TestMetadata("outerCapturedInPrimaryConstructorDefaultParameter.kt")
            public void testOuterCapturedInPrimaryConstructorDefaultParameter() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInPrimaryConstructorDefaultParameter.kt");
            }

            @TestMetadata("outerCapturedInSecondaryConstructorDefaultParameter.kt")
            public void testOuterCapturedInSecondaryConstructorDefaultParameter() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInSecondaryConstructorDefaultParameter.kt");
            }

            @TestMetadata("outerEnumEntryCapturedInLambdaInInnerClass.kt")
            public void testOuterEnumEntryCapturedInLambdaInInnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerEnumEntryCapturedInLambdaInInnerClass.kt");
            }

            @TestMetadata("properValueCapturedByClosure1.kt")
            public void testProperValueCapturedByClosure1() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure1.kt");
            }

            @TestMetadata("properValueCapturedByClosure2.kt")
            public void testProperValueCapturedByClosure2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure2.kt");
            }

            @TestMetadata("referenceToCapturedVariablesInMultipleLambdas.kt")
            public void testReferenceToCapturedVariablesInMultipleLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/referenceToCapturedVariablesInMultipleLambdas.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/captureOuterProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CaptureOuterProperty extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInCaptureOuterProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/captureOuterProperty"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("captureFunctionInProperty.kt")
            public void testCaptureFunctionInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/captureFunctionInProperty.kt");
            }

            @TestMetadata("inFunction.kt")
            public void testInFunction() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inFunction.kt");
            }

            @TestMetadata("inProperty.kt")
            public void testInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inProperty.kt");
            }

            @TestMetadata("inPropertyDeepObjectChain.kt")
            public void testInPropertyDeepObjectChain() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyDeepObjectChain.kt");
            }

            @TestMetadata("inPropertyFromSuperClass.kt")
            public void testInPropertyFromSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperClass.kt");
            }

            @TestMetadata("inPropertyFromSuperSuperClass.kt")
            public void testInPropertyFromSuperSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperSuperClass.kt");
            }

            @TestMetadata("kt4176.kt")
            public void testKt4176() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4176.kt");
            }

            @TestMetadata("kt4656.kt")
            public void testKt4656() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4656.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/capturedVarsOptimization")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CapturedVarsOptimization extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInCapturedVarsOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/capturedVarsOptimization"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("capturedInCrossinline.kt")
            public void testCapturedInCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInCrossinline.kt");
            }

            @TestMetadata("capturedInInlineOnlyAssign.kt")
            public void testCapturedInInlineOnlyAssign() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyAssign.kt");
            }

            @TestMetadata("capturedInInlineOnlyCAO.kt")
            public void testCapturedInInlineOnlyCAO() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyCAO.kt");
            }

            @TestMetadata("capturedInInlineOnlyIncrDecr.kt")
            public void testCapturedInInlineOnlyIncrDecr() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIncrDecr.kt");
            }

            @TestMetadata("capturedInInlineOnlyIndexedCAO.kt")
            public void testCapturedInInlineOnlyIndexedCAO() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIndexedCAO.kt");
            }

            @TestMetadata("capturedVarsOfSize2.kt")
            public void testCapturedVarsOfSize2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedVarsOfSize2.kt");
            }

            @TestMetadata("kt17200.kt")
            public void testKt17200() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17200.kt");
            }

            @TestMetadata("kt17588.kt")
            public void testKt17588() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17588.kt");
            }

            @TestMetadata("kt44347.kt")
            public void testKt44347() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt44347.kt");
            }

            @TestMetadata("kt45446.kt")
            public void testKt45446() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt45446.kt");
            }

            @TestMetadata("sharedSlotsWithCapturedVars.kt")
            public void testSharedSlotsWithCapturedVars() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
            }

            @TestMetadata("withCoroutines.kt")
            public void testWithCoroutines() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutines.kt");
            }

            @TestMetadata("withCoroutinesNoStdLib.kt")
            public void testWithCoroutinesNoStdLib() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutinesNoStdLib.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/closureInsideClosure")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClosureInsideClosure extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInClosureInsideClosure() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/closureInsideClosure"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("localFunInsideLocalFun.kt")
            public void testLocalFunInsideLocalFun() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFun.kt");
            }

            @TestMetadata("localFunInsideLocalFunDifferentSignatures.kt")
            public void testLocalFunInsideLocalFunDifferentSignatures() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFunDifferentSignatures.kt");
            }

            @TestMetadata("propertyAndFunctionNameClash.kt")
            public void testPropertyAndFunctionNameClash() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/propertyAndFunctionNameClash.kt");
            }

            @TestMetadata("threeLevels.kt")
            public void testThreeLevels() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevels.kt");
            }

            @TestMetadata("threeLevelsDifferentSignatures.kt")
            public void testThreeLevelsDifferentSignatures() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevelsDifferentSignatures.kt");
            }

            @TestMetadata("varAsFunInsideLocalFun.kt")
            public void testVarAsFunInsideLocalFun() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/varAsFunInsideLocalFun.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/collectionLiterals")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CollectionLiterals extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInCollectionLiterals() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/collectionLiterals"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/collections")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Collections extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("addCollectionStubWithCovariantOverride.kt")
        public void testAddCollectionStubWithCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/collections/addCollectionStubWithCovariantOverride.kt");
        }

        public void testAllFilesPresentInCollections() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/collections"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("inSetWithSmartCast.kt")
        public void testInSetWithSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inSetWithSmartCast.kt");
        }

        @TestMetadata("inheritFromAbstractMutableListInt.kt")
        public void testInheritFromAbstractMutableListInt() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inheritFromAbstractMutableListInt.kt");
        }

        @TestMetadata("internalRemove.kt")
        public void testInternalRemove() throws Exception {
            runTest("compiler/testData/codegen/box/collections/internalRemove.kt");
        }

        @TestMetadata("kt41123.kt")
        public void testKt41123() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt41123.kt");
        }

        @TestMetadata("removeClash.kt")
        public void testRemoveClash() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClash.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/companion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Companion extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInCompanion() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/companion"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("delegatedPropertyOnCompanion.kt")
        public void testDelegatedPropertyOnCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/companion/delegatedPropertyOnCompanion.kt");
        }

        @TestMetadata("genericLambdaOnStringCompanion.kt")
        public void testGenericLambdaOnStringCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/companion/genericLambdaOnStringCompanion.kt");
        }

        @TestMetadata("inlineFunctionCompanionPropertyAccess.kt")
        public void testInlineFunctionCompanionPropertyAccess() throws Exception {
            runTest("compiler/testData/codegen/box/companion/inlineFunctionCompanionPropertyAccess.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/compatibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Compatibility extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInCompatibility() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compatibility"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("privateCompanionObject.kt")
        public void testPrivateCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/compatibility/privateCompanionObject.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constants")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constants extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInConstants() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constants"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("comparisonFalse.kt")
        public void testComparisonFalse() throws Exception {
            runTest("compiler/testData/codegen/box/constants/comparisonFalse.kt");
        }

        @TestMetadata("constValFromAnotherModuleInConsVal.kt")
        public void testConstValFromAnotherModuleInConsVal() throws Exception {
            runTest("compiler/testData/codegen/box/constants/constValFromAnotherModuleInConsVal.kt");
        }

        @TestMetadata("constantsInWhen.kt")
        public void testConstantsInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/constants/constantsInWhen.kt");
        }

        @TestMetadata("divisionByZero.kt")
        public void testDivisionByZero() throws Exception {
            runTest("compiler/testData/codegen/box/constants/divisionByZero.kt");
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("compiler/testData/codegen/box/constants/float.kt");
        }

        @TestMetadata("foldingBinaryOpsUnsigned.kt")
        public void testFoldingBinaryOpsUnsigned() throws Exception {
            runTest("compiler/testData/codegen/box/constants/foldingBinaryOpsUnsigned.kt");
        }

        @TestMetadata("foldingBinaryOpsUnsignedConst.kt")
        public void testFoldingBinaryOpsUnsignedConst() throws Exception {
            runTest("compiler/testData/codegen/box/constants/foldingBinaryOpsUnsignedConst.kt");
        }

        @TestMetadata("kt9532.kt")
        public void testKt9532() throws Exception {
            runTest("compiler/testData/codegen/box/constants/kt9532.kt");
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("compiler/testData/codegen/box/constants/long.kt");
        }

        @TestMetadata("numberLiteralCoercionToInferredType.kt")
        public void testNumberLiteralCoercionToInferredType() throws Exception {
            runTest("compiler/testData/codegen/box/constants/numberLiteralCoercionToInferredType.kt");
        }

        @TestMetadata("privateConst.kt")
        public void testPrivateConst() throws Exception {
            runTest("compiler/testData/codegen/box/constants/privateConst.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constructor")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constructor extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInConstructor() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constructor"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constructorCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConstructorCall extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInConstructorCall() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constructorCall"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/contracts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Contracts extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInContracts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/contracts"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("constructorArgument.kt")
        public void testConstructorArgument() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/constructorArgument.kt");
        }

        @TestMetadata("destructuredVariable.kt")
        public void testDestructuredVariable() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/destructuredVariable.kt");
        }

        @TestMetadata("exactlyOnceNotInline.kt")
        public void testExactlyOnceNotInline() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/exactlyOnceNotInline.kt");
        }

        @TestMetadata("exception.kt")
        public void testException() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/exception.kt");
        }

        @TestMetadata("fieldInConstructorParens.kt")
        public void testFieldInConstructorParens() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/fieldInConstructorParens.kt");
        }

        @TestMetadata("fieldReadInConstructor.kt")
        public void testFieldReadInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/fieldReadInConstructor.kt");
        }

        @TestMetadata("forLoop.kt")
        public void testForLoop() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/forLoop.kt");
        }

        @TestMetadata("functionParameter.kt")
        public void testFunctionParameter() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/functionParameter.kt");
        }

        @TestMetadata("kt39374.kt")
        public void testKt39374() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt39374.kt");
        }

        @TestMetadata("kt45236.kt")
        public void testKt45236() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt45236.kt");
        }

        @TestMetadata("kt47168.kt")
        public void testKt47168() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt47168.kt");
        }

        @TestMetadata("kt47300.kt")
        public void testKt47300() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt47300.kt");
        }

        @TestMetadata("lambdaParameter.kt")
        public void testLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/lambdaParameter.kt");
        }

        @TestMetadata("listAppend.kt")
        public void testListAppend() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/listAppend.kt");
        }

        @TestMetadata("nestedLambdaInNonInlineCallExactlyOnce.kt")
        public void testNestedLambdaInNonInlineCallExactlyOnce() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/nestedLambdaInNonInlineCallExactlyOnce.kt");
        }

        @TestMetadata("valInWhen.kt")
        public void testValInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/valInWhen.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ControlStructures extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInControlStructures() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("bottles.kt")
        public void testBottles() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/bottles.kt");
        }

        @TestMetadata("breakInFinally.kt")
        public void testBreakInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/breakInFinally.kt");
        }

        @TestMetadata("breakInWhen.kt")
        public void testBreakInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/breakInWhen.kt");
        }

        @TestMetadata("compareBoxedIntegerToZero.kt")
        public void testCompareBoxedIntegerToZero() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/compareBoxedIntegerToZero.kt");
        }

        @TestMetadata("conditionOfEmptyIf.kt")
        public void testConditionOfEmptyIf() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/conditionOfEmptyIf.kt");
        }

        @TestMetadata("continueInExpr.kt")
        public void testContinueInExpr() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInExpr.kt");
        }

        @TestMetadata("continueInFor.kt")
        public void testContinueInFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInFor.kt");
        }

        @TestMetadata("continueInForCondition.kt")
        public void testContinueInForCondition() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInForCondition.kt");
        }

        @TestMetadata("continueInWhen.kt")
        public void testContinueInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInWhen.kt");
        }

        @TestMetadata("continueInWhile.kt")
        public void testContinueInWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInWhile.kt");
        }

        @TestMetadata("continueToLabelInFor.kt")
        public void testContinueToLabelInFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueToLabelInFor.kt");
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhile.kt");
        }

        @TestMetadata("doWhileFib.kt")
        public void testDoWhileFib() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhileFib.kt");
        }

        @TestMetadata("doWhileWithContinue.kt")
        public void testDoWhileWithContinue() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhileWithContinue.kt");
        }

        @TestMetadata("emptyDoWhile.kt")
        public void testEmptyDoWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyDoWhile.kt");
        }

        @TestMetadata("emptyFor.kt")
        public void testEmptyFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyFor.kt");
        }

        @TestMetadata("emptyWhile.kt")
        public void testEmptyWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyWhile.kt");
        }

        @TestMetadata("factorialTest.kt")
        public void testFactorialTest() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/factorialTest.kt");
        }

        @TestMetadata("finallyOnEmptyReturn.kt")
        public void testFinallyOnEmptyReturn() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/finallyOnEmptyReturn.kt");
        }

        @TestMetadata("forArrayList.kt")
        public void testForArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forArrayList.kt");
        }

        @TestMetadata("forArrayListMultiDecl.kt")
        public void testForArrayListMultiDecl() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forArrayListMultiDecl.kt");
        }

        @TestMetadata("forInCharSequence.kt")
        public void testForInCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInCharSequence.kt");
        }

        @TestMetadata("forInCharSequenceMut.kt")
        public void testForInCharSequenceMut() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceMut.kt");
        }

        @TestMetadata("forInSmartCastToArray.kt")
        public void testForInSmartCastToArray() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInSmartCastToArray.kt");
        }

        @TestMetadata("forLoopMemberExtensionAll.kt")
        public void testForLoopMemberExtensionAll() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionAll.kt");
        }

        @TestMetadata("forLoopMemberExtensionHasNext.kt")
        public void testForLoopMemberExtensionHasNext() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionHasNext.kt");
        }

        @TestMetadata("forLoopMemberExtensionNext.kt")
        public void testForLoopMemberExtensionNext() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionNext.kt");
        }

        @TestMetadata("forNullableCharInString.kt")
        public void testForNullableCharInString() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forNullableCharInString.kt");
        }

        @TestMetadata("forUserType.kt")
        public void testForUserType() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forUserType.kt");
        }

        @TestMetadata("ifConst1.kt")
        public void testIfConst1() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifConst1.kt");
        }

        @TestMetadata("ifConst2.kt")
        public void testIfConst2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifConst2.kt");
        }

        @TestMetadata("ifIncompatibleBranches.kt")
        public void testIfIncompatibleBranches() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifIncompatibleBranches.kt");
        }

        @TestMetadata("inRangeConditionsInWhen.kt")
        public void testInRangeConditionsInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/inRangeConditionsInWhen.kt");
        }

        @TestMetadata("kt12908.kt")
        public void testKt12908() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt12908.kt");
        }

        @TestMetadata("kt12908_2.kt")
        public void testKt12908_2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt12908_2.kt");
        }

        @TestMetadata("kt1441.kt")
        public void testKt1441() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1441.kt");
        }

        @TestMetadata("kt14839.kt")
        public void testKt14839() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt14839.kt");
        }

        @TestMetadata("kt15726.kt")
        public void testKt15726() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt15726.kt");
        }

        @TestMetadata("kt1688.kt")
        public void testKt1688() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1688.kt");
        }

        @TestMetadata("kt17110.kt")
        public void testKt17110() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17110.kt");
        }

        @TestMetadata("kt1742.kt")
        public void testKt1742() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1742.kt");
        }

        @TestMetadata("kt17590.kt")
        public void testKt17590() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17590.kt");
        }

        @TestMetadata("kt17590_long.kt")
        public void testKt17590_long() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17590_long.kt");
        }

        @TestMetadata("kt1899.kt")
        public void testKt1899() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1899.kt");
        }

        @TestMetadata("kt2147.kt")
        public void testKt2147() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2147.kt");
        }

        @TestMetadata("kt2259.kt")
        public void testKt2259() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2259.kt");
        }

        @TestMetadata("kt2291.kt")
        public void testKt2291() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2291.kt");
        }

        @TestMetadata("kt237.kt")
        public void testKt237() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt237.kt");
        }

        @TestMetadata("kt2416.kt")
        public void testKt2416() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2416.kt");
        }

        @TestMetadata("kt2577.kt")
        public void testKt2577() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2577.kt");
        }

        @TestMetadata("kt2597.kt")
        public void testKt2597() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2597.kt");
        }

        @TestMetadata("kt299.kt")
        public void testKt299() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt299.kt");
        }

        @TestMetadata("kt3087.kt")
        public void testKt3087() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3087.kt");
        }

        @TestMetadata("kt3203_1.kt")
        public void testKt3203_1() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3203_1.kt");
        }

        @TestMetadata("kt3203_2.kt")
        public void testKt3203_2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3203_2.kt");
        }

        @TestMetadata("kt3273.kt")
        public void testKt3273() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3273.kt");
        }

        @TestMetadata("kt3280.kt")
        public void testKt3280() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3280.kt");
        }

        @TestMetadata("kt416.kt")
        public void testKt416() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt416.kt");
        }

        @TestMetadata("kt42455.kt")
        public void testKt42455() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt42455.kt");
        }

        @TestMetadata("kt47245.kt")
        public void testKt47245() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt47245.kt");
        }

        @TestMetadata("kt513.kt")
        public void testKt513() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt513.kt");
        }

        @TestMetadata("kt628.kt")
        public void testKt628() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt628.kt");
        }

        @TestMetadata("kt769.kt")
        public void testKt769() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt769.kt");
        }

        @TestMetadata("kt772.kt")
        public void testKt772() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt772.kt");
        }

        @TestMetadata("kt773.kt")
        public void testKt773() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt773.kt");
        }

        @TestMetadata("kt8148.kt")
        public void testKt8148() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148.kt");
        }

        @TestMetadata("kt8148_break.kt")
        public void testKt8148_break() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148_break.kt");
        }

        @TestMetadata("kt8148_continue.kt")
        public void testKt8148_continue() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148_continue.kt");
        }

        @TestMetadata("kt870.kt")
        public void testKt870() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt870.kt");
        }

        @TestMetadata("kt9022Return.kt")
        public void testKt9022Return() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt9022Return.kt");
        }

        @TestMetadata("kt9022Throw.kt")
        public void testKt9022Throw() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt9022Throw.kt");
        }

        @TestMetadata("kt910.kt")
        public void testKt910() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt910.kt");
        }

        @TestMetadata("kt958.kt")
        public void testKt958() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt958.kt");
        }

        @TestMetadata("longRange.kt")
        public void testLongRange() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/longRange.kt");
        }

        @TestMetadata("parameterWithNameForFunctionType.kt")
        public void testParameterWithNameForFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/parameterWithNameForFunctionType.kt");
        }

        @TestMetadata("quicksort.kt")
        public void testQuicksort() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/quicksort.kt");
        }

        @TestMetadata("tcbInEliminatedCondition.kt")
        public void testTcbInEliminatedCondition() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tcbInEliminatedCondition.kt");
        }

        @TestMetadata("tryCatchExpression.kt")
        public void testTryCatchExpression() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchExpression.kt");
        }

        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinally.kt");
        }

        @TestMetadata("tryCatchFinallyChain.kt")
        public void testTryCatchFinallyChain() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinallyChain.kt");
        }

        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryFinally.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BreakContinueInExpressions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBreakContinueInExpressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("breakFromOuter.kt")
            public void testBreakFromOuter() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakFromOuter.kt");
            }

            @TestMetadata("breakInDoWhile.kt")
            public void testBreakInDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInDoWhile.kt");
            }

            @TestMetadata("breakInExpr.kt")
            public void testBreakInExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInExpr.kt");
            }

            @TestMetadata("breakInLoopConditions.kt")
            public void testBreakInLoopConditions() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInLoopConditions.kt");
            }

            @TestMetadata("continueInDoWhile.kt")
            public void testContinueInDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInDoWhile.kt");
            }

            @TestMetadata("continueInExpr.kt")
            public void testContinueInExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInExpr.kt");
            }

            @TestMetadata("inlineWithStack.kt")
            public void testInlineWithStack() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlineWithStack.kt");
            }

            @TestMetadata("innerLoopWithStack.kt")
            public void testInnerLoopWithStack() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/innerLoopWithStack.kt");
            }

            @TestMetadata("kt14581.kt")
            public void testKt14581() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt14581.kt");
            }

            @TestMetadata("kt16713.kt")
            public void testKt16713() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713.kt");
            }

            @TestMetadata("kt16713_2.kt")
            public void testKt16713_2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713_2.kt");
            }

            @TestMetadata("kt17384.kt")
            public void testKt17384() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt17384.kt");
            }

            @TestMetadata("kt45704_elvisInInlineFun.kt")
            public void testKt45704_elvisInInlineFun() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt45704_elvisInInlineFun.kt");
            }

            @TestMetadata("kt9022And.kt")
            public void testKt9022And() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022And.kt");
            }

            @TestMetadata("kt9022Or.kt")
            public void testKt9022Or() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022Or.kt");
            }

            @TestMetadata("pathologicalDoWhile.kt")
            public void testPathologicalDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/pathologicalDoWhile.kt");
            }

            @TestMetadata("popSizes.kt")
            public void testPopSizes() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/popSizes.kt");
            }

            @TestMetadata("tryFinally1.kt")
            public void testTryFinally1() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally1.kt");
            }

            @TestMetadata("tryFinally2.kt")
            public void testTryFinally2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally2.kt");
            }

            @TestMetadata("whileTrueBreak.kt")
            public void testWhileTrueBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/whileTrueBreak.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArray")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInArray extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInForInArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArray"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("forInArraySpecializedToUntil.kt")
            public void testForInArraySpecializedToUntil() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArraySpecializedToUntil.kt");
            }

            @TestMetadata("forInArrayWithArrayPropertyUpdatedInLoopBody.kt")
            public void testForInArrayWithArrayPropertyUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayPropertyUpdatedInLoopBody.kt");
            }

            @TestMetadata("forInArrayWithArrayVarUpdatedInLoopBody13.kt")
            public void testForInArrayWithArrayVarUpdatedInLoopBody13() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayVarUpdatedInLoopBody13.kt");
            }

            @TestMetadata("forInDelegatedPropertyUpdatedInLoopBody.kt")
            public void testForInDelegatedPropertyUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDelegatedPropertyUpdatedInLoopBody.kt");
            }

            @TestMetadata("forInDoubleArrayWithUpcast.kt")
            public void testForInDoubleArrayWithUpcast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDoubleArrayWithUpcast.kt");
            }

            @TestMetadata("forInFieldUpdatedInLoopBody.kt")
            public void testForInFieldUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInFieldUpdatedInLoopBody.kt");
            }

            @TestMetadata("forInInlineClassArrayWithUpcast.kt")
            public void testForInInlineClassArrayWithUpcast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInInlineClassArrayWithUpcast.kt");
            }

            @TestMetadata("forIntArray.kt")
            public void testForIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forIntArray.kt");
            }

            @TestMetadata("forNullableIntArray.kt")
            public void testForNullableIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forNullableIntArray.kt");
            }

            @TestMetadata("forPrimitiveIntArray.kt")
            public void testForPrimitiveIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forPrimitiveIntArray.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInArrayWithIndex extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInForInArrayWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("forInArrayOfObjectArrayWithIndex.kt")
            public void testForInArrayOfObjectArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfObjectArrayWithIndex.kt");
            }

            @TestMetadata("forInArrayOfPrimArrayWithIndex.kt")
            public void testForInArrayOfPrimArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfPrimArrayWithIndex.kt");
            }

            @TestMetadata("forInArrayWithIndexBreakAndContinue.kt")
            public void testForInArrayWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexBreakAndContinue.kt");
            }

            @TestMetadata("forInArrayWithIndexContinuesAsUnmodified.kt")
            public void testForInArrayWithIndexContinuesAsUnmodified() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexContinuesAsUnmodified.kt");
            }

            @TestMetadata("forInArrayWithIndexNoElementVar.kt")
            public void testForInArrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInArrayWithIndexNoIndexOrElementVar.kt")
            public void testForInArrayWithIndexNoIndexOrElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoIndexOrElementVar.kt");
            }

            @TestMetadata("forInArrayWithIndexNoIndexVar.kt")
            public void testForInArrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInArrayWithIndexNotDestructured.kt")
            public void testForInArrayWithIndexNotDestructured() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNotDestructured.kt");
            }

            @TestMetadata("forInArrayWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInArrayWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexWithExplicitlyTypedIndexVariable.kt");
            }

            @TestMetadata("forInByteArrayWithIndex.kt")
            public void testForInByteArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndex.kt");
            }

            @TestMetadata("forInByteArrayWithIndexWithSmartCast.kt")
            public void testForInByteArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInEmptyArrayWithIndex.kt")
            public void testForInEmptyArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
            }

            @TestMetadata("forInGenericArrayOfIntsWithIndex.kt")
            public void testForInGenericArrayOfIntsWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndex.kt");
            }

            @TestMetadata("forInGenericArrayOfIntsWithIndexWithSmartCast.kt")
            public void testForInGenericArrayOfIntsWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInGenericArrayWithIndex.kt")
            public void testForInGenericArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayWithIndex.kt");
            }

            @TestMetadata("forInIntArrayWithIndex.kt")
            public void testForInIntArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndex.kt");
            }

            @TestMetadata("forInIntArrayWithIndexWithSmartCast.kt")
            public void testForInIntArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInObjectArrayWithIndex.kt")
            public void testForInObjectArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
            }

            @TestMetadata("forInShortArrayWithIndex.kt")
            public void testForInShortArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndex.kt");
            }

            @TestMetadata("forInShortArrayWithIndexWithSmartCast.kt")
            public void testForInShortArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndexWithSmartCast.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInCharSequenceWithIndex extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInForInCharSequenceWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("forInCharSeqWithIndexStops.kt")
            public void testForInCharSeqWithIndexStops() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSeqWithIndexStops.kt");
            }

            @TestMetadata("forInCharSequenceTypeParameterWithIndex.kt")
            public void testForInCharSequenceTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceTypeParameterWithIndex.kt");
            }

            @TestMetadata("forInCharSequenceWithIndex.kt")
            public void testForInCharSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
            }

            @TestMetadata("forInCharSequenceWithIndexBreakAndContinue.kt")
            public void testForInCharSequenceWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexBreakAndContinue.kt");
            }

            @TestMetadata("forInCharSequenceWithIndexCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexCheckSideEffects.kt");
            }

            @TestMetadata("forInCharSequenceWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexNoElementVarCheckSideEffects.kt");
            }

            @TestMetadata("forInCharSequenceWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @TestMetadata("forInEmptyStringWithIndex.kt")
            public void testForInEmptyStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
            }

            @TestMetadata("forInStringWithIndex.kt")
            public void testForInStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndex.kt");
            }

            @TestMetadata("forInStringWithIndexNoElementVar.kt")
            public void testForInStringWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInStringWithIndexNoIndexOrElementVar.kt")
            public void testForInStringWithIndexNoIndexOrElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexOrElementVar.kt");
            }

            @TestMetadata("forInStringWithIndexNoIndexVar.kt")
            public void testForInStringWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInStringWithIndexNotDestructured.kt")
            public void testForInStringWithIndexNotDestructured() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNotDestructured.kt");
            }

            @TestMetadata("forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIterableWithIndex extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInForInIterableWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("forInEmptyListWithIndex.kt")
            public void testForInEmptyListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInEmptyListWithIndex.kt");
            }

            @TestMetadata("forInIterableTypeParameterWithIndex.kt")
            public void testForInIterableTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
            }

            @TestMetadata("forInIterableWithIndexCheckSideEffects.kt")
            public void testForInIterableWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexCheckSideEffects.kt");
            }

            @TestMetadata("forInIterableWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInIterableWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexNoElementVarCheckSideEffects.kt");
            }

            @TestMetadata("forInIterableWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInIterableWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @TestMetadata("forInListWithIndex.kt")
            public void testForInListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndex.kt");
            }

            @TestMetadata("forInListWithIndexBreak.kt")
            public void testForInListWithIndexBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexBreak.kt");
            }

            @TestMetadata("forInListWithIndexBreakAndContinue.kt")
            public void testForInListWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexBreakAndContinue.kt");
            }

            @TestMetadata("forInListWithIndexContinue.kt")
            public void testForInListWithIndexContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexContinue.kt");
            }

            @TestMetadata("forInListWithIndexNoElementVar.kt")
            public void testForInListWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInListWithIndexNoIndexVar.kt")
            public void testForInListWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInListWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIterator extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInForInIterator() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterator"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInSequenceWithIndex extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInForInSequenceWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("forInEmptySequenceWithIndex.kt")
            public void testForInEmptySequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
            }

            @TestMetadata("forInSequenceTypeParameterWithIndex.kt")
            public void testForInSequenceTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
            }

            @TestMetadata("forInSequenceWithIndex.kt")
            public void testForInSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndex.kt");
            }

            @TestMetadata("forInSequenceWithIndexBreakAndContinue.kt")
            public void testForInSequenceWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexBreakAndContinue.kt");
            }

            @TestMetadata("forInSequenceWithIndexCheckSideEffects.kt")
            public void testForInSequenceWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexCheckSideEffects.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoElementVar.kt")
            public void testForInSequenceWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInSequenceWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVarCheckSideEffects.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoIndexVar.kt")
            public void testForInSequenceWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInSequenceWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @TestMetadata("forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReturnsNothing extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInReturnsNothing() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/returnsNothing"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("ifElse.kt")
            public void testIfElse() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/ifElse.kt");
            }

            @TestMetadata("inlineMethod.kt")
            public void testInlineMethod() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/inlineMethod.kt");
            }

            @TestMetadata("propertyGetter.kt")
            public void testPropertyGetter() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/propertyGetter.kt");
            }

            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/tryCatch.kt");
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/when.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/slowDsl")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SlowDsl extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSlowDsl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/slowDsl"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TryCatchInExpressions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInTryCatchInExpressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("catch.kt")
            public void testCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/catch.kt");
            }

            @TestMetadata("complexChain.kt")
            public void testComplexChain() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/complexChain.kt");
            }

            @TestMetadata("deadTryCatch.kt")
            public void testDeadTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/deadTryCatch.kt");
            }

            @TestMetadata("differentTypes.kt")
            public void testDifferentTypes() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/differentTypes.kt");
            }

            @TestMetadata("expectException.kt")
            public void testExpectException() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/expectException.kt");
            }

            @TestMetadata("finally.kt")
            public void testFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/finally.kt");
            }

            @TestMetadata("inlineTryCatch.kt")
            public void testInlineTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryCatch.kt");
            }

            @TestMetadata("inlineTryExpr.kt")
            public void testInlineTryExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryExpr.kt");
            }

            @TestMetadata("inlineTryFinally.kt")
            public void testInlineTryFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryFinally.kt");
            }

            @TestMetadata("kt17572.kt")
            public void testKt17572() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572.kt");
            }

            @TestMetadata("kt17572_2.kt")
            public void testKt17572_2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2.kt");
            }

            @TestMetadata("kt17572_2_ext.kt")
            public void testKt17572_2_ext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2_ext.kt");
            }

            @TestMetadata("kt17572_ext.kt")
            public void testKt17572_ext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_ext.kt");
            }

            @TestMetadata("kt17572_nested.kt")
            public void testKt17572_nested() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_nested.kt");
            }

            @TestMetadata("kt17573.kt")
            public void testKt17573() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573.kt");
            }

            @TestMetadata("kt17573_nested.kt")
            public void testKt17573_nested() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573_nested.kt");
            }

            @TestMetadata("kt8608.kt")
            public void testKt8608() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt8608.kt");
            }

            @TestMetadata("kt9644try.kt")
            public void testKt9644try() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt9644try.kt");
            }

            @TestMetadata("multipleCatchBlocks.kt")
            public void testMultipleCatchBlocks() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/multipleCatchBlocks.kt");
            }

            @TestMetadata("nonLocalReturnInTryFinally.kt")
            public void testNonLocalReturnInTryFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/nonLocalReturnInTryFinally.kt");
            }

            @TestMetadata("splitTry.kt")
            public void testSplitTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTry.kt");
            }

            @TestMetadata("splitTryCorner1.kt")
            public void testSplitTryCorner1() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner1.kt");
            }

            @TestMetadata("splitTryCorner2.kt")
            public void testSplitTryCorner2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner2.kt");
            }

            @TestMetadata("try.kt")
            public void testTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/try.kt");
            }

            @TestMetadata("tryAfterTry.kt")
            public void testTryAfterTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAfterTry.kt");
            }

            @TestMetadata("tryAndBreak.kt")
            public void testTryAndBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndBreak.kt");
            }

            @TestMetadata("tryAndContinue.kt")
            public void testTryAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndContinue.kt");
            }

            @TestMetadata("tryCatchAfterWhileTrue.kt")
            public void testTryCatchAfterWhileTrue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryCatchAfterWhileTrue.kt");
            }

            @TestMetadata("tryInsideCatch.kt")
            public void testTryInsideCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideCatch.kt");
            }

            @TestMetadata("tryInsideTry.kt")
            public void testTryInsideTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideTry.kt");
            }

            @TestMetadata("unmatchedInlineMarkers.kt")
            public void testUnmatchedInlineMarkers() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/unmatchedInlineMarkers.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Coroutines extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("32defaultParametersInSuspend.kt")
        public void test32defaultParametersInSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/32defaultParametersInSuspend.kt");
        }

        @TestMetadata("accessorForSuspend.kt")
        public void testAccessorForSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/accessorForSuspend.kt");
        }

        public void testAllFilesPresentInCoroutines() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("asyncIteratorNullMerge_1_3.kt")
        public void testAsyncIteratorNullMerge_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorNullMerge_1_3.kt");
        }

        @TestMetadata("asyncIteratorToList_1_3.kt")
        public void testAsyncIteratorToList_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorToList_1_3.kt");
        }

        @TestMetadata("asyncIterator_1_3.kt")
        public void testAsyncIterator_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIterator_1_3.kt");
        }

        @TestMetadata("await.kt")
        public void testAwait() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/await.kt");
        }

        @TestMetadata("beginWithException.kt")
        public void testBeginWithException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/beginWithException.kt");
        }

        @TestMetadata("beginWithExceptionNoHandleException.kt")
        public void testBeginWithExceptionNoHandleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/beginWithExceptionNoHandleException.kt");
        }

        @TestMetadata("builderInferenceAndGenericArrayAcessCall.kt")
        public void testBuilderInferenceAndGenericArrayAcessCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/builderInferenceAndGenericArrayAcessCall.kt");
        }

        @TestMetadata("captureInfixFun.kt")
        public void testCaptureInfixFun() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureInfixFun.kt");
        }

        @TestMetadata("captureMutableLocalVariableInsideCoroutineBlock.kt")
        public void testCaptureMutableLocalVariableInsideCoroutineBlock() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureMutableLocalVariableInsideCoroutineBlock.kt");
        }

        @TestMetadata("captureUnaryOperator.kt")
        public void testCaptureUnaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureUnaryOperator.kt");
        }

        @TestMetadata("capturedVarInSuspendLambda.kt")
        public void testCapturedVarInSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/capturedVarInSuspendLambda.kt");
        }

        @TestMetadata("castWithSuspend.kt")
        public void testCastWithSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/castWithSuspend.kt");
        }

        @TestMetadata("catchWithInlineInsideSuspend.kt")
        public void testCatchWithInlineInsideSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/catchWithInlineInsideSuspend.kt");
        }

        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coercionToUnit.kt");
        }

        @TestMetadata("controllerAccessFromInnerLambda.kt")
        public void testControllerAccessFromInnerLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/controllerAccessFromInnerLambda.kt");
        }

        @TestMetadata("coroutineContextInInlinedLambda.kt")
        public void testCoroutineContextInInlinedLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coroutineContextInInlinedLambda.kt");
        }

        @TestMetadata("createCoroutineSafe.kt")
        public void testCreateCoroutineSafe() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/createCoroutineSafe.kt");
        }

        @TestMetadata("createCoroutinesOnManualInstances.kt")
        public void testCreateCoroutinesOnManualInstances() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/createCoroutinesOnManualInstances.kt");
        }

        @TestMetadata("crossInlineWithCapturedOuterReceiver.kt")
        public void testCrossInlineWithCapturedOuterReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/crossInlineWithCapturedOuterReceiver.kt");
        }

        @TestMetadata("defaultParametersInSuspend.kt")
        public void testDefaultParametersInSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/defaultParametersInSuspend.kt");
        }

        @TestMetadata("delegatedSuspendMember.kt")
        public void testDelegatedSuspendMember() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/delegatedSuspendMember.kt");
        }

        @TestMetadata("dispatchResume.kt")
        public void testDispatchResume() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/dispatchResume.kt");
        }

        @TestMetadata("doubleColonExpressionsGenerationInBuilderInference.kt")
        public void testDoubleColonExpressionsGenerationInBuilderInference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/doubleColonExpressionsGenerationInBuilderInference.kt");
        }

        @TestMetadata("emptyClosure.kt")
        public void testEmptyClosure() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/emptyClosure.kt");
        }

        @TestMetadata("emptyCommonConstraintSystemForCoroutineInferenceCall.kt")
        public void testEmptyCommonConstraintSystemForCoroutineInferenceCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/emptyCommonConstraintSystemForCoroutineInferenceCall.kt");
        }

        @TestMetadata("epam.kt")
        public void testEpam() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/epam.kt");
        }

        @TestMetadata("falseUnitCoercion.kt")
        public void testFalseUnitCoercion() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/falseUnitCoercion.kt");
        }

        @TestMetadata("generate.kt")
        public void testGenerate() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/generate.kt");
        }

        @TestMetadata("handleException.kt")
        public void testHandleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleException.kt");
        }

        @TestMetadata("handleResultCallEmptyBody.kt")
        public void testHandleResultCallEmptyBody() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultCallEmptyBody.kt");
        }

        @TestMetadata("handleResultNonUnitExpression.kt")
        public void testHandleResultNonUnitExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultNonUnitExpression.kt");
        }

        @TestMetadata("handleResultSuspended.kt")
        public void testHandleResultSuspended() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultSuspended.kt");
        }

        @TestMetadata("indirectInlineUsedAsNonInline.kt")
        public void testIndirectInlineUsedAsNonInline() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/indirectInlineUsedAsNonInline.kt");
        }

        @TestMetadata("inlineFunInGenericClass.kt")
        public void testInlineFunInGenericClass() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineFunInGenericClass.kt");
        }

        @TestMetadata("inlineGenericFunCalledFromSubclass.kt")
        public void testInlineGenericFunCalledFromSubclass() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineGenericFunCalledFromSubclass.kt");
        }

        @TestMetadata("inlineSuspendFunction.kt")
        public void testInlineSuspendFunction() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineSuspendFunction.kt");
        }

        @TestMetadata("inlineSuspendLambdaNonLocalReturn.kt")
        public void testInlineSuspendLambdaNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineSuspendLambdaNonLocalReturn.kt");
        }

        @TestMetadata("inlinedTryCatchFinally.kt")
        public void testInlinedTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlinedTryCatchFinally.kt");
        }

        @TestMetadata("innerSuspensionCalls.kt")
        public void testInnerSuspensionCalls() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/innerSuspensionCalls.kt");
        }

        @TestMetadata("instanceOfContinuation.kt")
        public void testInstanceOfContinuation() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/instanceOfContinuation.kt");
        }

        @TestMetadata("iterateOverArray.kt")
        public void testIterateOverArray() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/iterateOverArray.kt");
        }

        @TestMetadata("kt12958.kt")
        public void testKt12958() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt12958.kt");
        }

        @TestMetadata("kt15016.kt")
        public void testKt15016() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15016.kt");
        }

        @TestMetadata("kt15017.kt")
        public void testKt15017() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15017.kt");
        }

        @TestMetadata("kt15930.kt")
        public void testKt15930() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15930.kt");
        }

        @TestMetadata("kt21080.kt")
        public void testKt21080() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt21080.kt");
        }

        @TestMetadata("kt21605.kt")
        public void testKt21605() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt21605.kt");
        }

        @TestMetadata("kt24135.kt")
        public void testKt24135() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt24135.kt");
        }

        @TestMetadata("kt25912.kt")
        public void testKt25912() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt25912.kt");
        }

        @TestMetadata("kt28844.kt")
        public void testKt28844() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt28844.kt");
        }

        @TestMetadata("kt30858.kt")
        public void testKt30858() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt30858.kt");
        }

        @TestMetadata("kt31784.kt")
        public void testKt31784() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt31784.kt");
        }

        @TestMetadata("kt35967.kt")
        public void testKt35967() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt35967.kt");
        }

        @TestMetadata("kt42028.kt")
        public void testKt42028() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt42028.kt");
        }

        @TestMetadata("kt42554.kt")
        public void testKt42554() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt42554.kt");
        }

        @TestMetadata("kt44221.kt")
        public void testKt44221() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44221.kt");
        }

        @TestMetadata("kt44710.kt")
        public void testKt44710() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44710.kt");
        }

        @TestMetadata("kt44781.kt")
        public void testKt44781() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44781.kt");
        }

        @TestMetadata("kt45377.kt")
        public void testKt45377() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt45377.kt");
        }

        @TestMetadata("kt46813.kt")
        public void testKt46813() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt46813.kt");
        }

        @TestMetadata("kt49168.kt")
        public void testKt49168() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt49168.kt");
        }

        @TestMetadata("kt49317.kt")
        public void testKt49317() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt49317.kt");
        }

        @TestMetadata("kt51530.kt")
        public void testKt51530() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt51530.kt");
        }

        @TestMetadata("kt51718.kt")
        public void testKt51718() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt51718.kt");
        }

        @TestMetadata("lastExpressionIsLoop.kt")
        public void testLastExpressionIsLoop() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastExpressionIsLoop.kt");
        }

        @TestMetadata("lastStatementInc.kt")
        public void testLastStatementInc() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastStatementInc.kt");
        }

        @TestMetadata("lastStementAssignment.kt")
        public void testLastStementAssignment() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastStementAssignment.kt");
        }

        @TestMetadata("lastUnitExpression.kt")
        public void testLastUnitExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastUnitExpression.kt");
        }

        @TestMetadata("localCallableRef.kt")
        public void testLocalCallableRef() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/localCallableRef.kt");
        }

        @TestMetadata("localDelegate.kt")
        public void testLocalDelegate() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/localDelegate.kt");
        }

        @TestMetadata("longRangeInSuspendCall.kt")
        public void testLongRangeInSuspendCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/longRangeInSuspendCall.kt");
        }

        @TestMetadata("longRangeInSuspendFun.kt")
        public void testLongRangeInSuspendFun() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/longRangeInSuspendFun.kt");
        }

        @TestMetadata("mergeNullAndString.kt")
        public void testMergeNullAndString() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/mergeNullAndString.kt");
        }

        @TestMetadata("multipleInvokeCalls.kt")
        public void testMultipleInvokeCalls() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCalls.kt");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda1.kt")
        public void testMultipleInvokeCallsInsideInlineLambda1() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda1.kt");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda2.kt")
        public void testMultipleInvokeCallsInsideInlineLambda2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda2.kt");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda3.kt")
        public void testMultipleInvokeCallsInsideInlineLambda3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda3.kt");
        }

        @TestMetadata("nestedTryCatch.kt")
        public void testNestedTryCatch() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nestedTryCatch.kt");
        }

        @TestMetadata("noSuspensionPoints.kt")
        public void testNoSuspensionPoints() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/noSuspensionPoints.kt");
        }

        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturn.kt");
        }

        @TestMetadata("nonLocalReturnFromInlineLambda.kt")
        public void testNonLocalReturnFromInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambda.kt");
        }

        @TestMetadata("nonLocalReturnFromInlineLambdaDeep.kt")
        public void testNonLocalReturnFromInlineLambdaDeep() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambdaDeep.kt");
        }

        @TestMetadata("nullableSuspendFunctionType.kt")
        public void testNullableSuspendFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nullableSuspendFunctionType.kt");
        }

        @TestMetadata("overrideDefaultArgument.kt")
        public void testOverrideDefaultArgument() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/overrideDefaultArgument.kt");
        }

        @TestMetadata("recursiveSuspend.kt")
        public void testRecursiveSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/recursiveSuspend.kt");
        }

        @TestMetadata("returnByLabel.kt")
        public void testReturnByLabel() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/returnByLabel.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simple.kt");
        }

        @TestMetadata("simpleException.kt")
        public void testSimpleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleException.kt");
        }

        @TestMetadata("simpleSuspendCallableReference.kt")
        public void testSimpleSuspendCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleSuspendCallableReference.kt");
        }

        @TestMetadata("simpleWithDefaultValue.kt")
        public void testSimpleWithDefaultValue() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleWithDefaultValue.kt");
        }

        @TestMetadata("simpleWithHandleResult.kt")
        public void testSimpleWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleWithHandleResult.kt");
        }

        @TestMetadata("statementLikeLastExpression.kt")
        public void testStatementLikeLastExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/statementLikeLastExpression.kt");
        }

        @TestMetadata("stopAfter.kt")
        public void testStopAfter() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/stopAfter.kt");
        }

        @TestMetadata("suspendCallsInArguments.kt")
        public void testSuspendCallsInArguments() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCallsInArguments.kt");
        }

        @TestMetadata("suspendCoroutineFromStateMachine.kt")
        public void testSuspendCoroutineFromStateMachine() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCoroutineFromStateMachine.kt");
        }

        @TestMetadata("suspendDefaultImpl.kt")
        public void testSuspendDefaultImpl() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendDefaultImpl.kt");
        }

        @TestMetadata("suspendDelegation.kt")
        public void testSuspendDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendDelegation.kt");
        }

        @TestMetadata("suspendFromInlineLambda.kt")
        public void testSuspendFromInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFromInlineLambda.kt");
        }

        @TestMetadata("suspendFunImportedFromObject.kt")
        public void testSuspendFunImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunImportedFromObject.kt");
        }

        @TestMetadata("suspendFunctionAsSupertype.kt")
        public void testSuspendFunctionAsSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsSupertype.kt");
        }

        @TestMetadata("suspendFunctionAsSupertypeCall.kt")
        public void testSuspendFunctionAsSupertypeCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsSupertypeCall.kt");
        }

        @TestMetadata("suspendFunctionMethodReference.kt")
        public void testSuspendFunctionMethodReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionMethodReference.kt");
        }

        @TestMetadata("suspendInCycle.kt")
        public void testSuspendInCycle() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInCycle.kt");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstruction.kt")
        public void testSuspendInTheMiddleOfObjectConstruction() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstruction.kt");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt")
        public void testSuspendInTheMiddleOfObjectConstructionEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstructionWithJumpOut.kt")
        public void testSuspendInTheMiddleOfObjectConstructionWithJumpOut() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionWithJumpOut.kt");
        }

        @TestMetadata("suspendInlineReference.kt")
        public void testSuspendInlineReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInlineReference.kt");
        }

        @TestMetadata("suspendLambdaInInterface.kt")
        public void testSuspendLambdaInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendLambdaInInterface.kt");
        }

        @TestMetadata("suspendLambdaWithArgumentRearrangement.kt")
        public void testSuspendLambdaWithArgumentRearrangement() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendLambdaWithArgumentRearrangement.kt");
        }

        @TestMetadata("suspensionInsideSafeCall.kt")
        public void testSuspensionInsideSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCall.kt");
        }

        @TestMetadata("suspensionInsideSafeCallWithElvis.kt")
        public void testSuspensionInsideSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCallWithElvis.kt");
        }

        @TestMetadata("tailCallToNothing.kt")
        public void testTailCallToNothing() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tailCallToNothing.kt");
        }

        @TestMetadata("tryCatchFinallyWithHandleResult.kt")
        public void testTryCatchFinallyWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryCatchFinallyWithHandleResult.kt");
        }

        @TestMetadata("tryCatchWithHandleResult.kt")
        public void testTryCatchWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryCatchWithHandleResult.kt");
        }

        @TestMetadata("tryFinallyInsideInlineLambda.kt")
        public void testTryFinallyInsideInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryFinallyInsideInlineLambda.kt");
        }

        @TestMetadata("tryFinallyWithHandleResult.kt")
        public void testTryFinallyWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryFinallyWithHandleResult.kt");
        }

        @TestMetadata("varCaptuedInCoroutineIntrinsic.kt")
        public void testVarCaptuedInCoroutineIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varCaptuedInCoroutineIntrinsic.kt");
        }

        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varValueConflictsWithTable.kt");
        }

        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varValueConflictsWithTableSameSort.kt");
        }

        @TestMetadata("varargCallFromSuspend.kt")
        public void testVarargCallFromSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varargCallFromSuspend.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/bridges")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bridges extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBridges() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/bridges"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("interfaceGenericDefault.kt")
            public void testInterfaceGenericDefault() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/interfaceGenericDefault.kt");
            }

            @TestMetadata("interfaceSpecialization.kt")
            public void testInterfaceSpecialization() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/interfaceSpecialization.kt");
            }

            @TestMetadata("lambdaWithLongReceiver.kt")
            public void testLambdaWithLongReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/lambdaWithLongReceiver.kt");
            }

            @TestMetadata("lambdaWithMultipleParameters.kt")
            public void testLambdaWithMultipleParameters() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/lambdaWithMultipleParameters.kt");
            }

            @TestMetadata("mapSuspendAbstractClear.kt")
            public void testMapSuspendAbstractClear() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/mapSuspendAbstractClear.kt");
            }

            @TestMetadata("mapSuspendClear.kt")
            public void testMapSuspendClear() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/mapSuspendClear.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/controlFlow")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlFlow extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInControlFlow() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/controlFlow"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("breakFinally.kt")
            public void testBreakFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/breakFinally.kt");
            }

            @TestMetadata("breakStatement.kt")
            public void testBreakStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/breakStatement.kt");
            }

            @TestMetadata("complexChainSuspend.kt")
            public void testComplexChainSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/complexChainSuspend.kt");
            }

            @TestMetadata("doWhileStatement.kt")
            public void testDoWhileStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doWhileStatement.kt");
            }

            @TestMetadata("doWhileWithInline.kt")
            public void testDoWhileWithInline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doWhileWithInline.kt");
            }

            @TestMetadata("doubleBreak.kt")
            public void testDoubleBreak() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doubleBreak.kt");
            }

            @TestMetadata("finallyCatch.kt")
            public void testFinallyCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/finallyCatch.kt");
            }

            @TestMetadata("forContinue.kt")
            public void testForContinue() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forContinue.kt");
            }

            @TestMetadata("forStatement.kt")
            public void testForStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forStatement.kt");
            }

            @TestMetadata("forWithStep.kt")
            public void testForWithStep() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forWithStep.kt");
            }

            @TestMetadata("ifStatement.kt")
            public void testIfStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/ifStatement.kt");
            }

            @TestMetadata("kt22694_1_3.kt")
            public void testKt22694_1_3() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/kt22694_1_3.kt");
            }

            @TestMetadata("labeledWhile.kt")
            public void testLabeledWhile() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/labeledWhile.kt");
            }

            @TestMetadata("multipleCatchBlocksSuspend.kt")
            public void testMultipleCatchBlocksSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/multipleCatchBlocksSuspend.kt");
            }

            @TestMetadata("returnFromFinally.kt")
            public void testReturnFromFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/returnFromFinally.kt");
            }

            @TestMetadata("returnWithFinally.kt")
            public void testReturnWithFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/returnWithFinally.kt");
            }

            @TestMetadata("suspendInStringTemplate.kt")
            public void testSuspendInStringTemplate() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/suspendInStringTemplate.kt");
            }

            @TestMetadata("switchLikeWhen.kt")
            public void testSwitchLikeWhen() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/switchLikeWhen.kt");
            }

            @TestMetadata("throwFromCatch.kt")
            public void testThrowFromCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwFromCatch.kt");
            }

            @TestMetadata("throwFromFinally.kt")
            public void testThrowFromFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwFromFinally.kt");
            }

            @TestMetadata("throwInTryWithHandleResult.kt")
            public void testThrowInTryWithHandleResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwInTryWithHandleResult.kt");
            }

            @TestMetadata("whenWithSuspensions.kt")
            public void testWhenWithSuspensions() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/whenWithSuspensions.kt");
            }

            @TestMetadata("whileStatement.kt")
            public void testWhileStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/whileStatement.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/debug")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Debug extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDebug() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/debug"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FeatureIntersection extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInFeatureIntersection() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("breakWithNonEmptyStack.kt")
            public void testBreakWithNonEmptyStack() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/breakWithNonEmptyStack.kt");
            }

            @TestMetadata("defaultExpect.kt")
            public void testDefaultExpect() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/defaultExpect.kt");
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/delegate.kt");
            }

            @TestMetadata("destructuringInLambdas.kt")
            public void testDestructuringInLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/destructuringInLambdas.kt");
            }

            @TestMetadata("funInterface.kt")
            public void testFunInterface() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface.kt");
            }

            @TestMetadata("inlineSuspendFinally.kt")
            public void testInlineSuspendFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/inlineSuspendFinally.kt");
            }

            @TestMetadata("interfaceMethodWithBody.kt")
            public void testInterfaceMethodWithBody() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/interfaceMethodWithBody.kt");
            }

            @TestMetadata("interfaceMethodWithBodyGeneric.kt")
            public void testInterfaceMethodWithBodyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/interfaceMethodWithBodyGeneric.kt");
            }

            @TestMetadata("overrideInInlineClass.kt")
            public void testOverrideInInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/overrideInInlineClass.kt");
            }

            @TestMetadata("overrideInInnerClass.kt")
            public void testOverrideInInnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/overrideInInnerClass.kt");
            }

            @TestMetadata("safeCallOnTwoReceivers.kt")
            public void testSafeCallOnTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceivers.kt");
            }

            @TestMetadata("safeCallOnTwoReceiversLong.kt")
            public void testSafeCallOnTwoReceiversLong() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceiversLong.kt");
            }

            @TestMetadata("suspendDestructuringInLambdas.kt")
            public void testSuspendDestructuringInLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendDestructuringInLambdas.kt");
            }

            @TestMetadata("suspendFunctionAsSupertypeIsCheckWithArity.kt")
            public void testSuspendFunctionAsSupertypeIsCheckWithArity() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionAsSupertypeIsCheckWithArity.kt");
            }

            @TestMetadata("suspendFunctionIsAs.kt")
            public void testSuspendFunctionIsAs() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionIsAs.kt");
            }

            @TestMetadata("suspendInlineSuspendFinally.kt")
            public void testSuspendInlineSuspendFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendInlineSuspendFinally.kt");
            }

            @TestMetadata("suspendOperatorPlus.kt")
            public void testSuspendOperatorPlus() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlus.kt");
            }

            @TestMetadata("suspendOperatorPlusAssign.kt")
            public void testSuspendOperatorPlusAssign() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusAssign.kt");
            }

            @TestMetadata("suspendOperatorPlusCallFromLambda.kt")
            public void testSuspendOperatorPlusCallFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusCallFromLambda.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallableReference extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInCallableReference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("bigArity.kt")
                public void testBigArity() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bigArity.kt");
                }

                @TestMetadata("lambdaParameterUsed.kt")
                public void testLambdaParameterUsed() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/lambdaParameterUsed.kt");
                }

                @TestMetadata("longArgs.kt")
                public void testLongArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/longArgs.kt");
                }

                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Bound extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInBound() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }

                    @TestMetadata("emptyLHS.kt")
                    public void testEmptyLHS() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound/emptyLHS.kt");
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Function extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    @TestMetadata("adapted.kt")
                    public void testAdapted() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/adapted.kt");
                    }

                    public void testAllFilesPresentInFunction() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }

                    @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
                    public void testGenericCallableReferencesWithNullableTypes() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
                    }

                    @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Local extends AbstractIrCodegenBoxWasmTest {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                        }

                        public void testAllFilesPresentInLocal() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                        }

                        @TestMetadata("equalsHashCode.kt")
                        public void testEqualsHashCode() throws Exception {
                            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local/equalsHashCode.kt");
                        }
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunInterface extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInFunInterface() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("kt47549.kt")
                public void testKt47549() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt47549.kt");
                }

                @TestMetadata("kt47549_1.kt")
                public void testKt47549_1() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt47549_1.kt");
                }

                @TestMetadata("kt49294.kt")
                public void testKt49294() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt49294.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JvmDefault extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInJvmDefault() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Kt46007 extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInKt46007() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Tailrec extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInTailrec() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("controlFlowIf.kt")
                public void testControlFlowIf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowIf.kt");
                }

                @TestMetadata("controlFlowWhen.kt")
                public void testControlFlowWhen() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowWhen.kt");
                }

                @TestMetadata("extention.kt")
                public void testExtention() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/extention.kt");
                }

                @TestMetadata("infixCall.kt")
                public void testInfixCall() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixCall.kt");
                }

                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixRecursiveCall.kt");
                }

                @TestMetadata("kt38920_localTailrec.kt")
                public void testKt38920_localTailrec() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/kt38920_localTailrec.kt");
                }

                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realIteratorFoldl.kt");
                }

                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringEscape.kt");
                }

                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringRepeat.kt");
                }

                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/returnInParentheses.kt");
                }

                @TestMetadata("sum.kt")
                public void testSum() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/sum.kt");
                }

                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInBlockInParentheses.kt");
                }

                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInParentheses.kt");
                }

                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/whenWithIs.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineClasses extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("genericParameterResult.kt")
            public void testGenericParameterResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/genericParameterResult.kt");
            }

            @TestMetadata("kt47129.kt")
            public void testKt47129() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/kt47129.kt");
            }

            @TestMetadata("nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/nonLocalReturn.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/direct")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Direct extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInDirect() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/direct"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxReturnValueOfSuspendLambda.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void testBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxTypeParameterOfSuperType.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void testBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxTypeParameterOfSuperTypeResult.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Any.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Int.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Long.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_NAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/bridgeGenerationCrossinline.kt");
                }

                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/bridgeGenerationNonInline.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/createMangling.kt");
                }

                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/createOverride.kt");
                }

                @TestMetadata("defaultStub.kt")
                public void testDefaultStub() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/defaultStub.kt");
                }

                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableAny.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny_null.kt")
                public void testGenericOverrideSuspendFun_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableAny_null.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableInt.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt_null.kt")
                public void testGenericOverrideSuspendFun_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableInt_null.kt");
                }

                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/interfaceDelegateWithInlineClass.kt");
                }

                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/invokeOperator.kt");
                }

                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun.kt");
                }

                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any_itf.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any_this.kt");
                }

                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Int.kt");
                }

                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/returnResult.kt");
                }

                @TestMetadata("syntheticAccessor.kt")
                public void testSyntheticAccessor() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/syntheticAccessor.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/resume")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Resume extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInResume() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/resume"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxReturnValueOfSuspendLambda.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void testBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxTypeParameterOfSuperType.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void testBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxTypeParameterOfSuperTypeResult.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Any.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Int.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Long.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_NAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/bridgeGenerationCrossinline.kt");
                }

                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/bridgeGenerationNonInline.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/createMangling.kt");
                }

                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/createOverride.kt");
                }

                @TestMetadata("defaultStub.kt")
                public void testDefaultStub() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/defaultStub.kt");
                }

                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableAny.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny_null.kt")
                public void testGenericOverrideSuspendFun_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableAny_null.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableInt.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt_null.kt")
                public void testGenericOverrideSuspendFun_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableInt_null.kt");
                }

                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/interfaceDelegateWithInlineClass.kt");
                }

                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/invokeOperator.kt");
                }

                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun.kt");
                }

                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any_itf.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any_this.kt");
                }

                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Int.kt");
                }

                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/returnResult.kt");
                }

                @TestMetadata("syntheticAccessor.kt")
                public void testSyntheticAccessor() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/syntheticAccessor.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ResumeWithException extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInResumeWithException() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxReturnValueOfSuspendLambda.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void testBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxTypeParameterOfSuperType.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void testBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxTypeParameterOfSuperTypeResult.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Any.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Int.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Long.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_NAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/bridgeGenerationCrossinline.kt");
                }

                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/bridgeGenerationNonInline.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/createMangling.kt");
                }

                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/createOverride.kt");
                }

                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_NullableAny.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_NullableInt.kt");
                }

                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/interfaceDelegateWithInlineClass.kt");
                }

                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/invokeOperator.kt");
                }

                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun.kt");
                }

                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any_itf.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any_this.kt");
                }

                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Int.kt");
                }

                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/returnResult.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntLikeVarSpilling extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intLikeVarSpilling"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/complicatedMerge.kt");
            }

            @TestMetadata("i2bResult.kt")
            public void testI2bResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/i2bResult.kt");
            }

            @TestMetadata("listThrowablePairInOneSlot.kt")
            public void testListThrowablePairInOneSlot() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/listThrowablePairInOneSlot.kt");
            }

            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
            }

            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
            }

            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/noVariableInTable.kt");
            }

            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
            }

            @TestMetadata("unusedCatchVar.kt")
            public void testUnusedCatchVar() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/unusedCatchVar.kt");
            }

            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
            }

            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInVarStore.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/intrinsicSemantics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntrinsicSemantics extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInIntrinsicSemantics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intrinsicSemantics"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("coroutineContext.kt")
            public void testCoroutineContext() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContext.kt");
            }

            @TestMetadata("coroutineContextReceiver.kt")
            public void testCoroutineContextReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiver.kt");
            }

            @TestMetadata("coroutineContextReceiverNotIntrinsic.kt")
            public void testCoroutineContextReceiverNotIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiverNotIntrinsic.kt");
            }

            @TestMetadata("intercepted.kt")
            public void testIntercepted() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/intercepted.kt");
            }

            @TestMetadata("resultExceptionOrNullInLambda.kt")
            public void testResultExceptionOrNullInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/resultExceptionOrNullInLambda.kt");
            }

            @TestMetadata("startCoroutine.kt")
            public void testStartCoroutine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutine.kt");
            }

            @TestMetadata("startCoroutineUninterceptedOrReturn.kt")
            public void testStartCoroutineUninterceptedOrReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturn.kt");
            }

            @TestMetadata("startCoroutineUninterceptedOrReturnInterception.kt")
            public void testStartCoroutineUninterceptedOrReturnInterception() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturnInterception.kt");
            }

            @TestMetadata("suspendCoroutineUninterceptedOrReturn.kt")
            public void testSuspendCoroutineUninterceptedOrReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/suspendCoroutineUninterceptedOrReturn.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/javaInterop")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaInterop extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInJavaInterop() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/javaInterop"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalFunctions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/anonymous")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Anonymous extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInAnonymous() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/anonymous"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/anonymous/simple.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/named")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Named extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInNamed() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/named"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("callTopLevelFromLocal.kt")
                public void testCallTopLevelFromLocal() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/callTopLevelFromLocal.kt");
                }

                @TestMetadata("capturedParameters.kt")
                public void testCapturedParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedParameters.kt");
                }

                @TestMetadata("capturedVariables.kt")
                public void testCapturedVariables() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedVariables.kt");
                }

                @TestMetadata("defaultArgument.kt")
                public void testDefaultArgument() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/defaultArgument.kt");
                }

                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/extension.kt");
                }

                @TestMetadata("infix.kt")
                public void testInfix() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/infix.kt");
                }

                @TestMetadata("insideLambda.kt")
                public void testInsideLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/insideLambda.kt");
                }

                @TestMetadata("nestedLocals.kt")
                public void testNestedLocals() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/nestedLocals.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/simple.kt");
                }

                @TestMetadata("simpleSuspensionPoint.kt")
                public void testSimpleSuspensionPoint() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/simpleSuspensionPoint.kt");
                }

                @TestMetadata("stateMachine.kt")
                public void testStateMachine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/stateMachine.kt");
                }

                @TestMetadata("withArguments.kt")
                public void testWithArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/withArguments.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/multiModule")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiModule extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInMultiModule() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/multiModule"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("inlineCrossModule.kt")
            public void testInlineCrossModule() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineCrossModule.kt");
            }

            @TestMetadata("inlineFunctionWithOptionalParam.kt")
            public void testInlineFunctionWithOptionalParam() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineFunctionWithOptionalParam.kt");
            }

            @TestMetadata("inlineMultiModule.kt")
            public void testInlineMultiModule() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModule.kt");
            }

            @TestMetadata("inlineMultiModuleOverride.kt")
            public void testInlineMultiModuleOverride() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleOverride.kt");
            }

            @TestMetadata("inlineMultiModuleWithController.kt")
            public void testInlineMultiModuleWithController() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithController.kt");
            }

            @TestMetadata("inlineMultiModuleWithInnerInlining.kt")
            public void testInlineMultiModuleWithInnerInlining() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithInnerInlining.kt");
            }

            @TestMetadata("inlineTailCall.kt")
            public void testInlineTailCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineTailCall.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/simple.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/redundantLocalsElimination")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RedundantLocalsElimination extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInRedundantLocalsElimination() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/redundantLocalsElimination"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("ktor_receivedMessage.kt")
            public void testKtor_receivedMessage() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/redundantLocalsElimination/ktor_receivedMessage.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/reflect")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reflect extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInReflect() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/reflect"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/stackUnwinding")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StackUnwinding extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInStackUnwinding() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/stackUnwinding"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("exception.kt")
            public void testException() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/exception.kt");
            }

            @TestMetadata("inlineSuspendFunction.kt")
            public void testInlineSuspendFunction() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/inlineSuspendFunction.kt");
            }

            @TestMetadata("rethrowInFinally.kt")
            public void testRethrowInFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinally.kt");
            }

            @TestMetadata("rethrowInFinallyWithSuspension.kt")
            public void testRethrowInFinallyWithSuspension() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinallyWithSuspension.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/simple.kt");
            }

            @TestMetadata("suspendInCycle.kt")
            public void testSuspendInCycle() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/suspendInCycle.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendConversion")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuspendConversion extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSuspendConversion() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendConversion"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("intersectionTypeToSubtypeConversion.kt")
            public void testIntersectionTypeToSubtypeConversion() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/intersectionTypeToSubtypeConversion.kt");
            }

            @TestMetadata("onArgument.kt")
            public void testOnArgument() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/onArgument.kt");
            }

            @TestMetadata("onInlineArgument.kt")
            public void testOnInlineArgument() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/onInlineArgument.kt");
            }

            @TestMetadata("subtypeOfFunctionalTypeToSuspendConversion.kt")
            public void testSubtypeOfFunctionalTypeToSuspendConversion() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/subtypeOfFunctionalTypeToSuspendConversion.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuspendFunctionAsCoroutine extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSuspendFunctionAsCoroutine() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("dispatchResume.kt")
            public void testDispatchResume() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/dispatchResume.kt");
            }

            @TestMetadata("handleException.kt")
            public void testHandleException() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/handleException.kt");
            }

            @TestMetadata("ifExpressionInsideCoroutine_1_3.kt")
            public void testIfExpressionInsideCoroutine_1_3() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/ifExpressionInsideCoroutine_1_3.kt");
            }

            @TestMetadata("inline.kt")
            public void testInline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inline.kt");
            }

            @TestMetadata("inlineTwoReceivers.kt")
            public void testInlineTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inlineTwoReceivers.kt");
            }

            @TestMetadata("member.kt")
            public void testMember() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/member.kt");
            }

            @TestMetadata("noinlineTwoReceivers.kt")
            public void testNoinlineTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/noinlineTwoReceivers.kt");
            }

            @TestMetadata("operators.kt")
            public void testOperators() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/operators.kt");
            }

            @TestMetadata("privateFunctions.kt")
            public void testPrivateFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateFunctions.kt");
            }

            @TestMetadata("privateInFile.kt")
            public void testPrivateInFile() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateInFile.kt");
            }

            @TestMetadata("returnNoSuspend.kt")
            public void testReturnNoSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/returnNoSuspend.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/simple.kt");
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCall.kt");
            }

            @TestMetadata("superCallAbstractClass.kt")
            public void testSuperCallAbstractClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallAbstractClass.kt");
            }

            @TestMetadata("superCallInterface.kt")
            public void testSuperCallInterface() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallInterface.kt");
            }

            @TestMetadata("superCallOverload.kt")
            public void testSuperCallOverload() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallOverload.kt");
            }

            @TestMetadata("withVariables.kt")
            public void testWithVariables() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/withVariables.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuspendFunctionTypeCall extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSuspendFunctionTypeCall() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/localVal.kt");
            }

            @TestMetadata("manyParameters.kt")
            public void testManyParameters() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParameters.kt");
            }

            @TestMetadata("manyParametersNoCapture.kt")
            public void testManyParametersNoCapture() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParametersNoCapture.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/simple.kt");
            }

            @TestMetadata("suspendModifier.kt")
            public void testSuspendModifier() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/suspendModifier.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TailCallOptimizations extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInTailCallOptimizations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("crossinline.kt")
            public void testCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/crossinline.kt");
            }

            @TestMetadata("inlineWithoutStateMachine.kt")
            public void testInlineWithoutStateMachine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithoutStateMachine.kt");
            }

            @TestMetadata("innerObjectRetransformation.kt")
            public void testInnerObjectRetransformation() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/innerObjectRetransformation.kt");
            }

            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatch.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Unit extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInUnit() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/tailOperations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TailOperations extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInTailOperations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailOperations"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("suspendWithIf.kt")
            public void testSuspendWithIf() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithIf.kt");
            }

            @TestMetadata("suspendWithTryCatch.kt")
            public void testSuspendWithTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithTryCatch.kt");
            }

            @TestMetadata("suspendWithWhen.kt")
            public void testSuspendWithWhen() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithWhen.kt");
            }

            @TestMetadata("tailInlining.kt")
            public void testTailInlining() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/tailInlining.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/unitTypeReturn")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnitTypeReturn extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInUnitTypeReturn() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/unitTypeReturn"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("coroutineNonLocalReturn.kt")
            public void testCoroutineNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineNonLocalReturn.kt");
            }

            @TestMetadata("coroutineReturn.kt")
            public void testCoroutineReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineReturn.kt");
            }

            @TestMetadata("inlineUnitFunction.kt")
            public void testInlineUnitFunction() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/inlineUnitFunction.kt");
            }

            @TestMetadata("interfaceDelegation.kt")
            public void testInterfaceDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/interfaceDelegation.kt");
            }

            @TestMetadata("suspendNonLocalReturn.kt")
            public void testSuspendNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendNonLocalReturn.kt");
            }

            @TestMetadata("suspendReturn.kt")
            public void testSuspendReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendReturn.kt");
            }

            @TestMetadata("unitSafeCall.kt")
            public void testUnitSafeCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/unitSafeCall.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class VarSpilling extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInVarSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("fakeInlinerVariables.kt")
            public void testFakeInlinerVariables() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/fakeInlinerVariables.kt");
            }

            @TestMetadata("kt19475.kt")
            public void testKt19475() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt19475.kt");
            }

            @TestMetadata("kt38925.kt")
            public void testKt38925() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt38925.kt");
            }

            @TestMetadata("kt49834.kt")
            public void testKt49834() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt49834.kt");
            }

            @TestMetadata("lvtWithInlineOnly.kt")
            public void testLvtWithInlineOnly() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/lvtWithInlineOnly.kt");
            }

            @TestMetadata("nullSpilling.kt")
            public void testNullSpilling() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/nullSpilling.kt");
            }

            @TestMetadata("refinedIntTypesAnalysis.kt")
            public void testRefinedIntTypesAnalysis() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/refinedIntTypesAnalysis.kt");
            }

            @TestMetadata("safeCallElvis.kt")
            public void testSafeCallElvis() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/safeCallElvis.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/correctFrontendCode")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CorrectFrontendCode extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInCorrectFrontendCode() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/correctFrontendCode"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("privateNestedClassInSuper.kt")
        public void testPrivateNestedClassInSuper() throws Exception {
            runTest("compiler/testData/codegen/box/correctFrontendCode/privateNestedClassInSuper.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/dataClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DataClasses extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDataClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("arrayParams.kt")
        public void testArrayParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/arrayParams.kt");
        }

        @TestMetadata("changingVarParam.kt")
        public void testChangingVarParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/changingVarParam.kt");
        }

        @TestMetadata("dataClassWithManyFields.kt")
        public void testDataClassWithManyFields() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/dataClassWithManyFields.kt");
        }

        @TestMetadata("doubleParam.kt")
        public void testDoubleParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/doubleParam.kt");
        }

        @TestMetadata("floatParam.kt")
        public void testFloatParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/floatParam.kt");
        }

        @TestMetadata("genericParam.kt")
        public void testGenericParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/genericParam.kt");
        }

        @TestMetadata("kt49715.kt")
        public void testKt49715() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt49715.kt");
        }

        @TestMetadata("kt49715_behaviorChange.kt")
        public void testKt49715_behaviorChange() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt49715_behaviorChange.kt");
        }

        @TestMetadata("mixedParams.kt")
        public void testMixedParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/mixedParams.kt");
        }

        @TestMetadata("multiDeclaration.kt")
        public void testMultiDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/multiDeclaration.kt");
        }

        @TestMetadata("multiDeclarationFor.kt")
        public void testMultiDeclarationFor() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/multiDeclarationFor.kt");
        }

        @TestMetadata("nonTrivialFinalMemberInSuperClass.kt")
        public void testNonTrivialFinalMemberInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/nonTrivialFinalMemberInSuperClass.kt");
        }

        @TestMetadata("nonTrivialMemberInSuperClass.kt")
        public void testNonTrivialMemberInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/nonTrivialMemberInSuperClass.kt");
        }

        @TestMetadata("privateValParams.kt")
        public void testPrivateValParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/privateValParams.kt");
        }

        @TestMetadata("twoValParams.kt")
        public void testTwoValParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/twoValParams.kt");
        }

        @TestMetadata("twoVarParams.kt")
        public void testTwoVarParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/twoVarParams.kt");
        }

        @TestMetadata("unitComponent.kt")
        public void testUnitComponent() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/unitComponent.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/components")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Components extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInComponents() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/components"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt49812.kt")
            public void testKt49812() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/components/kt49812.kt");
            }

            @TestMetadata("kt49936.kt")
            public void testKt49936() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/components/kt49936.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/copy")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Copy extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInCopy() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/copy"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("constructorWithDefaultParam.kt")
            public void testConstructorWithDefaultParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/constructorWithDefaultParam.kt");
            }

            @TestMetadata("copyInObjectNestedDataClass.kt")
            public void testCopyInObjectNestedDataClass() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/copyInObjectNestedDataClass.kt");
            }

            @TestMetadata("kt12708.kt")
            public void testKt12708() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/kt12708.kt");
            }

            @TestMetadata("kt3033.kt")
            public void testKt3033() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/kt3033.kt");
            }

            @TestMetadata("valInConstructorParams.kt")
            public void testValInConstructorParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/valInConstructorParams.kt");
            }

            @TestMetadata("varInConstructorParams.kt")
            public void testVarInConstructorParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/varInConstructorParams.kt");
            }

            @TestMetadata("withGenericParameter.kt")
            public void testWithGenericParameter() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/withGenericParameter.kt");
            }

            @TestMetadata("withSecondaryConstructor.kt")
            public void testWithSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/withSecondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/equals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equals extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInEquals() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/equals"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclared.kt");
            }

            @TestMetadata("genericarray.kt")
            public void testGenericarray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/genericarray.kt");
            }

            @TestMetadata("intarray.kt")
            public void testIntarray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/intarray.kt");
            }

            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/null.kt");
            }

            @TestMetadata("nullother.kt")
            public void testNullother() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/nullother.kt");
            }

            @TestMetadata("sameinstance.kt")
            public void testSameinstance() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/sameinstance.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/hashCode")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class HashCode extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInHashCode() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/hashCode"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclared.kt");
            }

            @TestMetadata("boolean.kt")
            public void testBoolean() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/boolean.kt");
            }

            @TestMetadata("byte.kt")
            public void testByte() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/byte.kt");
            }

            @TestMetadata("char.kt")
            public void testChar() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/char.kt");
            }

            @TestMetadata("double.kt")
            public void testDouble() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/double.kt");
            }

            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/float.kt");
            }

            @TestMetadata("genericNull.kt")
            public void testGenericNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/genericNull.kt");
            }

            @TestMetadata("int.kt")
            public void testInt() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/int.kt");
            }

            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/long.kt");
            }

            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/null.kt");
            }

            @TestMetadata("short.kt")
            public void testShort() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/short.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/toString")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ToString extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInToString() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/toString"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclared.kt");
            }

            @TestMetadata("arrayParams.kt")
            public void testArrayParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/arrayParams.kt");
            }

            @TestMetadata("changingVarParam.kt")
            public void testChangingVarParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/changingVarParam.kt");
            }

            @TestMetadata("genericParam.kt")
            public void testGenericParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/genericParam.kt");
            }

            @TestMetadata("mixedParams.kt")
            public void testMixedParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/mixedParams.kt");
            }

            @TestMetadata("primitiveArrays.kt")
            public void testPrimitiveArrays() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/primitiveArrays.kt");
            }

            @TestMetadata("unitComponent.kt")
            public void testUnitComponent() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/unitComponent.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeadCodeElimination extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDeadCodeElimination() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/deadCodeElimination"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("emptyVariableRange.kt")
        public void testEmptyVariableRange() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/emptyVariableRange.kt");
        }

        @TestMetadata("intersectingVariableRange.kt")
        public void testIntersectingVariableRange() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRange.kt");
        }

        @TestMetadata("intersectingVariableRangeInFinally.kt")
        public void testIntersectingVariableRangeInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRangeInFinally.kt");
        }

        @TestMetadata("kt14357.kt")
        public void testKt14357() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/kt14357.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DefaultArguments extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("callDefaultFromInitializer.kt")
        public void testCallDefaultFromInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/callDefaultFromInitializer.kt");
        }

        @TestMetadata("captureInTailrec.kt")
        public void testCaptureInTailrec() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/captureInTailrec.kt");
        }

        @TestMetadata("complexInheritance.kt")
        public void testComplexInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/complexInheritance.kt");
        }

        @TestMetadata("implementedByFake.kt")
        public void testImplementedByFake() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake.kt");
        }

        @TestMetadata("implementedByFake2.kt")
        public void testImplementedByFake2() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake2.kt");
        }

        @TestMetadata("implementedByFake3.kt")
        public void testImplementedByFake3() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake3.kt");
        }

        @TestMetadata("inheritedFromInterfaceViaAbstractSuperclass.kt")
        public void testInheritedFromInterfaceViaAbstractSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/inheritedFromInterfaceViaAbstractSuperclass.kt");
        }

        @TestMetadata("kt36853.kt")
        public void testKt36853() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853.kt");
        }

        @TestMetadata("kt36853_fibonacci.kt")
        public void testKt36853_fibonacci() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853_fibonacci.kt");
        }

        @TestMetadata("kt36853_nestedObject.kt")
        public void testKt36853_nestedObject() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853_nestedObject.kt");
        }

        @TestMetadata("kt36853a.kt")
        public void testKt36853a() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853a.kt");
        }

        @TestMetadata("kt46189.kt")
        public void testKt46189() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt46189.kt");
        }

        @TestMetadata("kt47073.kt")
        public void testKt47073() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt47073.kt");
        }

        @TestMetadata("kt47073_nested.kt")
        public void testKt47073_nested() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt47073_nested.kt");
        }

        @TestMetadata("kt48391.kt")
        public void testKt48391() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt48391.kt");
        }

        @TestMetadata("kt6382.kt")
        public void testKt6382() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt6382.kt");
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/protected.kt");
        }

        @TestMetadata("recursiveDefaultArguments.kt")
        public void testRecursiveDefaultArguments() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/recursiveDefaultArguments.kt");
        }

        @TestMetadata("referenceAsArg.kt")
        public void testReferenceAsArg() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/referenceAsArg.kt");
        }

        @TestMetadata("simpleFromOtherFile.kt")
        public void testSimpleFromOtherFile() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/simpleFromOtherFile.kt");
        }

        @TestMetadata("useNextParamInLambda.kt")
        public void testUseNextParamInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useNextParamInLambda.kt");
        }

        @TestMetadata("useNextParamInLambdaTailrec.kt")
        public void testUseNextParamInLambdaTailrec() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useNextParamInLambdaTailrec.kt");
        }

        @TestMetadata("useThisInLambda.kt")
        public void testUseThisInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useThisInLambda.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/constructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructor extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInConstructor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/constructor"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("annotation.kt")
            public void testAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotation.kt");
            }

            @TestMetadata("annotationWithEmptyArray.kt")
            public void testAnnotationWithEmptyArray() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotationWithEmptyArray.kt");
            }

            @TestMetadata("defArgs1.kt")
            public void testDefArgs1() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1.kt");
            }

            @TestMetadata("defArgs1InnerClass.kt")
            public void testDefArgs1InnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1InnerClass.kt");
            }

            @TestMetadata("defArgs2.kt")
            public void testDefArgs2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs2.kt");
            }

            @TestMetadata("doubleDefArgs1InnerClass.kt")
            public void testDoubleDefArgs1InnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/doubleDefArgs1InnerClass.kt");
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enum.kt");
            }

            @TestMetadata("enumWithOneDefArg.kt")
            public void testEnumWithOneDefArg() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithOneDefArg.kt");
            }

            @TestMetadata("enumWithTwoDefArgs.kt")
            public void testEnumWithTwoDefArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDefArgs.kt");
            }

            @TestMetadata("enumWithTwoDoubleDefArgs.kt")
            public void testEnumWithTwoDoubleDefArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDoubleDefArgs.kt");
            }

            @TestMetadata("innerClass32Args.kt")
            public void testInnerClass32Args() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/innerClass32Args.kt");
            }

            @TestMetadata("kt2852.kt")
            public void testKt2852() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt2852.kt");
            }

            @TestMetadata("kt30517.kt")
            public void testKt30517() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt30517.kt");
            }

            @TestMetadata("kt3060.kt")
            public void testKt3060() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt3060.kt");
            }

            @TestMetadata("objectExpressionDelegatingToSecondaryConstructor.kt")
            public void testObjectExpressionDelegatingToSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/objectExpressionDelegatingToSecondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/convention")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Convention extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInConvention() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/convention"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("incWithDefaultInGetter.kt")
            public void testIncWithDefaultInGetter() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaultInGetter.kt");
            }

            @TestMetadata("incWithDefaults.kt")
            public void testIncWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaults.kt");
            }

            @TestMetadata("kt16520.kt")
            public void testKt16520() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt16520.kt");
            }

            @TestMetadata("kt9140.kt")
            public void testKt9140() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt9140.kt");
            }

            @TestMetadata("plusAssignWithDefaultInGetter.kt")
            public void testPlusAssignWithDefaultInGetter() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaultInGetter.kt");
            }

            @TestMetadata("plusAssignWithDefaults.kt")
            public void testPlusAssignWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaults.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("abstractClass.kt")
            public void testAbstractClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/abstractClass.kt");
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/function"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("complexInheritance.kt")
            public void testComplexInheritance() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/complexInheritance.kt");
            }

            @TestMetadata("covariantOverride.kt")
            public void testCovariantOverride() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverride.kt");
            }

            @TestMetadata("covariantOverrideGeneric.kt")
            public void testCovariantOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverrideGeneric.kt");
            }

            @TestMetadata("defaultLambdaInline.kt")
            public void testDefaultLambdaInline() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/defaultLambdaInline.kt");
            }

            @TestMetadata("extensionFunctionManyArgs.kt")
            public void testExtensionFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extensionFunctionManyArgs.kt");
            }

            @TestMetadata("extentionFunction.kt")
            public void testExtentionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunction.kt");
            }

            @TestMetadata("extentionFunctionDouble.kt")
            public void testExtentionFunctionDouble() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDouble.kt");
            }

            @TestMetadata("extentionFunctionDoubleTwoArgs.kt")
            public void testExtentionFunctionDoubleTwoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDoubleTwoArgs.kt");
            }

            @TestMetadata("extentionFunctionInClassObject.kt")
            public void testExtentionFunctionInClassObject() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInClassObject.kt");
            }

            @TestMetadata("extentionFunctionInObject.kt")
            public void testExtentionFunctionInObject() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInObject.kt");
            }

            @TestMetadata("extentionFunctionWithOneDefArg.kt")
            public void testExtentionFunctionWithOneDefArg() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionWithOneDefArg.kt");
            }

            @TestMetadata("funInTrait.kt")
            public void testFunInTrait() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/funInTrait.kt");
            }

            @TestMetadata("funInTraitChain.kt")
            public void testFunInTraitChain() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/funInTraitChain.kt");
            }

            @TestMetadata("innerExtentionFunction.kt")
            public void testInnerExtentionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunction.kt");
            }

            @TestMetadata("innerExtentionFunctionDouble.kt")
            public void testInnerExtentionFunctionDouble() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDouble.kt");
            }

            @TestMetadata("innerExtentionFunctionDoubleTwoArgs.kt")
            public void testInnerExtentionFunctionDoubleTwoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDoubleTwoArgs.kt");
            }

            @TestMetadata("innerExtentionFunctionManyArgs.kt")
            public void testInnerExtentionFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionManyArgs.kt");
            }

            @TestMetadata("kt15971.kt")
            public void testKt15971() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971.kt");
            }

            @TestMetadata("kt15971_2.kt")
            public void testKt15971_2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971_2.kt");
            }

            @TestMetadata("kt15971_3.kt")
            public void testKt15971_3() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971_3.kt");
            }

            @TestMetadata("kt36188.kt")
            public void testKt36188() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt36188.kt");
            }

            @TestMetadata("kt36188_2.kt")
            public void testKt36188_2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt36188_2.kt");
            }

            @TestMetadata("kt5232.kt")
            public void testKt5232() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt5232.kt");
            }

            @TestMetadata("memberFunctionManyArgs.kt")
            public void testMemberFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/memberFunctionManyArgs.kt");
            }

            @TestMetadata("mixingNamedAndPositioned.kt")
            public void testMixingNamedAndPositioned() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/mixingNamedAndPositioned.kt");
            }

            @TestMetadata("topLevelManyArgs.kt")
            public void testTopLevelManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/topLevelManyArgs.kt");
            }

            @TestMetadata("trait.kt")
            public void testTrait() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/trait.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/private")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Private extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInPrivate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/private"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("memberExtensionFunction.kt")
            public void testMemberExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/memberExtensionFunction.kt");
            }

            @TestMetadata("memberFunction.kt")
            public void testMemberFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/memberFunction.kt");
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/primaryConstructor.kt");
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/secondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/signature")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Signature extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSignature() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/signature"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt2789.kt")
            public void testKt2789() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt2789.kt");
            }

            @TestMetadata("kt9428.kt")
            public void testKt9428() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9428.kt");
            }

            @TestMetadata("kt9924.kt")
            public void testKt9924() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9924.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DelegatedProperty extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("accessTopLevelDelegatedPropertyInClinit.kt")
        public void testAccessTopLevelDelegatedPropertyInClinit() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/accessTopLevelDelegatedPropertyInClinit.kt");
        }

        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("beforeDeclarationContainerOptimization.kt")
        public void testBeforeDeclarationContainerOptimization() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/beforeDeclarationContainerOptimization.kt");
        }

        @TestMetadata("capturePropertyInClosure.kt")
        public void testCapturePropertyInClosure() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/capturePropertyInClosure.kt");
        }

        @TestMetadata("castGetReturnType.kt")
        public void testCastGetReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/castGetReturnType.kt");
        }

        @TestMetadata("castSetParameter.kt")
        public void testCastSetParameter() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/castSetParameter.kt");
        }

        @TestMetadata("delegateAsInnerClass.kt")
        public void testDelegateAsInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateAsInnerClass.kt");
        }

        @TestMetadata("delegateByOtherProperty.kt")
        public void testDelegateByOtherProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByOtherProperty.kt");
        }

        @TestMetadata("delegateByTopLevelFun.kt")
        public void testDelegateByTopLevelFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelFun.kt");
        }

        @TestMetadata("delegateByTopLevelProperty.kt")
        public void testDelegateByTopLevelProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelProperty.kt");
        }

        @TestMetadata("delegateForExtProperty.kt")
        public void testDelegateForExtProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtProperty.kt");
        }

        @TestMetadata("delegateForExtPropertyInClass.kt")
        public void testDelegateForExtPropertyInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtPropertyInClass.kt");
        }

        @TestMetadata("delegateToConstructorParameter.kt")
        public void testDelegateToConstructorParameter() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateToConstructorParameter.kt");
        }

        @TestMetadata("delegateWithPrivateSet.kt")
        public void testDelegateWithPrivateSet() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateWithPrivateSet.kt");
        }

        @TestMetadata("delegatedPropertyInEnum.kt")
        public void testDelegatedPropertyInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegatedPropertyInEnum.kt");
        }

        @TestMetadata("extensionDelegatesWithSameNames.kt")
        public void testExtensionDelegatesWithSameNames() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/extensionDelegatesWithSameNames.kt");
        }

        @TestMetadata("extensionPropertyAndExtensionGetValue.kt")
        public void testExtensionPropertyAndExtensionGetValue() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/extensionPropertyAndExtensionGetValue.kt");
        }

        @TestMetadata("functionRefDelefate.kt")
        public void testFunctionRefDelefate() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/functionRefDelefate.kt");
        }

        @TestMetadata("genericDelegate.kt")
        public void testGenericDelegate() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegate.kt");
        }

        @TestMetadata("genericDelegateUncheckedCast1.kt")
        public void testGenericDelegateUncheckedCast1() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast1.kt");
        }

        @TestMetadata("genericDelegateUncheckedCast2.kt")
        public void testGenericDelegateUncheckedCast2() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast2.kt");
        }

        @TestMetadata("genericSetValueViaSyntheticAccessor.kt")
        public void testGenericSetValueViaSyntheticAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericSetValueViaSyntheticAccessor.kt");
        }

        @TestMetadata("getAsExtensionFun.kt")
        public void testGetAsExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFun.kt");
        }

        @TestMetadata("getAsExtensionFunInClass.kt")
        public void testGetAsExtensionFunInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFunInClass.kt");
        }

        @TestMetadata("getDelegateWithoutReflection.kt")
        public void testGetDelegateWithoutReflection() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getDelegateWithoutReflection.kt");
        }

        @TestMetadata("inClassVal.kt")
        public void testInClassVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inClassVal.kt");
        }

        @TestMetadata("inClassVar.kt")
        public void testInClassVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inClassVar.kt");
        }

        @TestMetadata("inTrait.kt")
        public void testInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inTrait.kt");
        }

        @TestMetadata("inferredPropertyType.kt")
        public void testInferredPropertyType() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inferredPropertyType.kt");
        }

        @TestMetadata("insideInlinedObjectMultiModule.kt")
        public void testInsideInlinedObjectMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/insideInlinedObjectMultiModule.kt");
        }

        @TestMetadata("kt35707.kt")
        public void testKt35707() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt35707.kt");
        }

        @TestMetadata("kt37204.kt")
        public void testKt37204() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt37204.kt");
        }

        @TestMetadata("kt4138.kt")
        public void testKt4138() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt4138.kt");
        }

        @TestMetadata("kt45431.kt")
        public void testKt45431() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt45431.kt");
        }

        @TestMetadata("kt6722.kt")
        public void testKt6722() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt6722.kt");
        }

        @TestMetadata("kt9712.kt")
        public void testKt9712() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt9712.kt");
        }

        @TestMetadata("privateVar.kt")
        public void testPrivateVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateVar.kt");
        }

        @TestMetadata("protectedVarWithPrivateSet.kt")
        public void testProtectedVarWithPrivateSet() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/protectedVarWithPrivateSet.kt");
        }

        @TestMetadata("referenceEnclosingClassFieldInReceiver.kt")
        public void testReferenceEnclosingClassFieldInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/referenceEnclosingClassFieldInReceiver.kt");
        }

        @TestMetadata("referenceEnclosingClassFieldInReceiver2.kt")
        public void testReferenceEnclosingClassFieldInReceiver2() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/referenceEnclosingClassFieldInReceiver2.kt");
        }

        @TestMetadata("setAsExtensionFun.kt")
        public void testSetAsExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFun.kt");
        }

        @TestMetadata("setAsExtensionFunInClass.kt")
        public void testSetAsExtensionFunInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFunInClass.kt");
        }

        @TestMetadata("topLevelVal.kt")
        public void testTopLevelVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVal.kt");
        }

        @TestMetadata("topLevelVar.kt")
        public void testTopLevelVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVar.kt");
        }

        @TestMetadata("twoPropByOneDelegete.kt")
        public void testTwoPropByOneDelegete() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/twoPropByOneDelegete.kt");
        }

        @TestMetadata("useKPropertyLater.kt")
        public void testUseKPropertyLater() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/useKPropertyLater.kt");
        }

        @TestMetadata("useReflectionOnKProperty.kt")
        public void testUseReflectionOnKProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/useReflectionOnKProperty.kt");
        }

        @TestMetadata("valByMapDelegatedProperty.kt")
        public void testValByMapDelegatedProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/valByMapDelegatedProperty.kt");
        }

        @TestMetadata("valInInnerClass.kt")
        public void testValInInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/valInInnerClass.kt");
        }

        @TestMetadata("varInInnerClass.kt")
        public void testVarInInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/varInInnerClass.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/delegateToAnother")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DelegateToAnother extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDelegateToAnother() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/delegateToAnother"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("custom.kt")
            public void testCustom() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/custom.kt");
            }

            @TestMetadata("kt49793_companionObject.kt")
            public void testKt49793_companionObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_companionObject.kt");
            }

            @TestMetadata("kt49793_interfaceCompanionObject.kt")
            public void testKt49793_interfaceCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_interfaceCompanionObject.kt");
            }

            @TestMetadata("kt49793_object.kt")
            public void testKt49793_object() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_object.kt");
            }

            @TestMetadata("kt50019_noOptimizedCallableReferences.kt")
            public void testKt50019_noOptimizedCallableReferences() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt50019_noOptimizedCallableReferences.kt");
            }

            @TestMetadata("mutable.kt")
            public void testMutable() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/mutable.kt");
            }

            @TestMetadata("openProperty.kt")
            public void testOpenProperty() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/openProperty.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/simple.kt");
            }

            @TestMetadata("withSideEffects.kt")
            public void testWithSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/withSideEffects.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/local")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Local extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInLocal() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/local"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("capturedLocalVal.kt")
            public void testCapturedLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVal.kt");
            }

            @TestMetadata("capturedLocalValNoInline.kt")
            public void testCapturedLocalValNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalValNoInline.kt");
            }

            @TestMetadata("capturedLocalVar.kt")
            public void testCapturedLocalVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVar.kt");
            }

            @TestMetadata("capturedLocalVarNoInline.kt")
            public void testCapturedLocalVarNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVarNoInline.kt");
            }

            @TestMetadata("inlineGetValue.kt")
            public void testInlineGetValue() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineGetValue.kt");
            }

            @TestMetadata("inlineOperators.kt")
            public void testInlineOperators() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineOperators.kt");
            }

            @TestMetadata("kt12891.kt")
            public void testKt12891() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt12891.kt");
            }

            @TestMetadata("kt13557.kt")
            public void testKt13557() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt13557.kt");
            }

            @TestMetadata("kt16864.kt")
            public void testKt16864() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt16864.kt");
            }

            @TestMetadata("kt19690.kt")
            public void testKt19690() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt19690.kt");
            }

            @TestMetadata("kt21085.kt")
            public void testKt21085() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt21085.kt");
            }

            @TestMetadata("kt23117.kt")
            public void testKt23117() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt23117.kt");
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVal.kt");
            }

            @TestMetadata("localValNoExplicitType.kt")
            public void testLocalValNoExplicitType() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localValNoExplicitType.kt");
            }

            @TestMetadata("localVar.kt")
            public void testLocalVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVar.kt");
            }

            @TestMetadata("localVarNoExplicitType.kt")
            public void testLocalVarNoExplicitType() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVarNoExplicitType.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OptimizedDelegatedProperties extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInOptimizedDelegatedProperties() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("definedInSources.kt")
            public void testDefinedInSources() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/definedInSources.kt");
            }

            @TestMetadata("definedInSourcesWithNonNullParameter.kt")
            public void testDefinedInSourcesWithNonNullParameter() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/definedInSourcesWithNonNullParameter.kt");
            }

            @TestMetadata("inSeparateModule.kt")
            public void testInSeparateModule() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/inSeparateModule.kt");
            }

            @TestMetadata("inSeparateModuleWithNonNullParameter.kt")
            public void testInSeparateModuleWithNonNullParameter() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/inSeparateModuleWithNonNullParameter.kt");
            }

            @TestMetadata("kt40815.kt")
            public void testKt40815() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815.kt");
            }

            @TestMetadata("kt40815_2.kt")
            public void testKt40815_2() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815_2.kt");
            }

            @TestMetadata("kt40815_3.kt")
            public void testKt40815_3() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815_3.kt");
            }

            @TestMetadata("kt42253.kt")
            public void testKt42253() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt42253.kt");
            }

            @TestMetadata("kt48825.kt")
            public void testKt48825() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt48825.kt");
            }

            @TestMetadata("lazy.kt")
            public void testLazy() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/lazy.kt");
            }

            @TestMetadata("mixedArgumentSizes.kt")
            public void testMixedArgumentSizes() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/mixedArgumentSizes.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/provideDelegate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProvideDelegate extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInProvideDelegate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/provideDelegate"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("delegatedPropertyWithIdProvideDelegate.kt")
            public void testDelegatedPropertyWithIdProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/delegatedPropertyWithIdProvideDelegate.kt");
            }

            @TestMetadata("differentReceivers.kt")
            public void testDifferentReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/differentReceivers.kt");
            }

            @TestMetadata("evaluationOrder.kt")
            public void testEvaluationOrder() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrder.kt");
            }

            @TestMetadata("evaluationOrderVar.kt")
            public void testEvaluationOrderVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrderVar.kt");
            }

            @TestMetadata("extensionDelegated.kt")
            public void testExtensionDelegated() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/extensionDelegated.kt");
            }

            @TestMetadata("generic.kt")
            public void testGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/generic.kt");
            }

            @TestMetadata("genericDelegateWithNoAdditionalInfo.kt")
            public void testGenericDelegateWithNoAdditionalInfo() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/genericDelegateWithNoAdditionalInfo.kt");
            }

            @TestMetadata("genericProvideDelegateOnNumberLiteral.kt")
            public void testGenericProvideDelegateOnNumberLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/genericProvideDelegateOnNumberLiteral.kt");
            }

            @TestMetadata("hostCheck.kt")
            public void testHostCheck() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/hostCheck.kt");
            }

            @TestMetadata("inClass.kt")
            public void testInClass() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inClass.kt");
            }

            @TestMetadata("inlineProvideDelegate.kt")
            public void testInlineProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inlineProvideDelegate.kt");
            }

            @TestMetadata("kt15437.kt")
            public void testKt15437() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt15437.kt");
            }

            @TestMetadata("kt16441.kt")
            public void testKt16441() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt16441.kt");
            }

            @TestMetadata("kt18902.kt")
            public void testKt18902() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt18902.kt");
            }

            @TestMetadata("kt39588.kt")
            public void testKt39588() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt39588.kt");
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/local.kt");
            }

            @TestMetadata("localCaptured.kt")
            public void testLocalCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localCaptured.kt");
            }

            @TestMetadata("localDifferentReceivers.kt")
            public void testLocalDifferentReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localDifferentReceivers.kt");
            }

            @TestMetadata("memberExtension.kt")
            public void testMemberExtension() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/memberExtension.kt");
            }

            @TestMetadata("propertyMetadata.kt")
            public void testPropertyMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/propertyMetadata.kt");
            }

            @TestMetadata("provideDelegateByExtensionFunction.kt")
            public void testProvideDelegateByExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/provideDelegateByExtensionFunction.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/delegation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Delegation extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDelegation() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegation"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("delegationDifferentModule.kt")
        public void testDelegationDifferentModule() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationDifferentModule.kt");
        }

        @TestMetadata("delegationWithPrivateConstructor.kt")
        public void testDelegationWithPrivateConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationWithPrivateConstructor.kt");
        }

        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/genericProperty.kt");
        }

        @TestMetadata("hiddenSuperOverrideIn1.0.kt")
        public void testHiddenSuperOverrideIn1_0() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/hiddenSuperOverrideIn1.0.kt");
        }

        @TestMetadata("inDataClass.kt")
        public void testInDataClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/inDataClass.kt");
        }

        @TestMetadata("kt30102_comparable.kt")
        public void testKt30102_comparable() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/kt30102_comparable.kt");
        }

        @TestMetadata("kt8154.kt")
        public void testKt8154() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/kt8154.kt");
        }

        @TestMetadata("viaTypeAlias.kt")
        public void testViaTypeAlias() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/viaTypeAlias.kt");
        }

        @TestMetadata("withDefaultParameters.kt")
        public void testWithDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/withDefaultParameters.kt");
        }

        @TestMetadata("withDefaultsMultipleFilesOrder.kt")
        public void testWithDefaultsMultipleFilesOrder() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/withDefaultsMultipleFilesOrder.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/deprecated")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Deprecated extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDeprecated() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/deprecated"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DestructuringDeclInLambdaParam extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDestructuringDeclInLambdaParam() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/destructuringDeclInLambdaParam"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("extensionComponents.kt")
        public void testExtensionComponents() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/extensionComponents.kt");
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/generic.kt");
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/inline.kt");
        }

        @TestMetadata("otherParameters.kt")
        public void testOtherParameters() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/otherParameters.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/simple.kt");
        }

        @TestMetadata("stdlibUsages.kt")
        public void testStdlibUsages() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/stdlibUsages.kt");
        }

        @TestMetadata("underscoreNames.kt")
        public void testUnderscoreNames() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/underscoreNames.kt");
        }

        @TestMetadata("withIndexed.kt")
        public void testWithIndexed() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/withIndexed.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/diagnostics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Diagnostics extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDiagnostics() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/diagnostics/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/inference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inference extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInInference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/inference"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("kt6176.kt")
                public void testKt6176() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/inference/kt6176.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invoke extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInInvoke() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnObjects extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInOnObjects() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }

                    @TestMetadata("invokeOnClassObject1.kt")
                    public void testInvokeOnClassObject1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject1.kt");
                    }

                    @TestMetadata("invokeOnClassObject2.kt")
                    public void testInvokeOnClassObject2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject2.kt");
                    }

                    @TestMetadata("invokeOnClassObjectOfNestedClass1.kt")
                    public void testInvokeOnClassObjectOfNestedClass1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass1.kt");
                    }

                    @TestMetadata("invokeOnClassObjectOfNestedClass2.kt")
                    public void testInvokeOnClassObjectOfNestedClass2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass2.kt");
                    }

                    @TestMetadata("invokeOnEnum1.kt")
                    public void testInvokeOnEnum1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum1.kt");
                    }

                    @TestMetadata("invokeOnEnum2.kt")
                    public void testInvokeOnEnum2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum2.kt");
                    }

                    @TestMetadata("invokeOnImportedEnum1.kt")
                    public void testInvokeOnImportedEnum1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum1.kt");
                    }

                    @TestMetadata("invokeOnImportedEnum2.kt")
                    public void testInvokeOnImportedEnum2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum2.kt");
                    }

                    @TestMetadata("invokeOnObject1.kt")
                    public void testInvokeOnObject1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject1.kt");
                    }

                    @TestMetadata("invokeOnObject2.kt")
                    public void testInvokeOnObject2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject2.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TailRecursion extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInTailRecursion() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/tailRecursion"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs.kt");
                }

                @TestMetadata("defaultArgs2.kt")
                public void testDefaultArgs2() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs2.kt");
                }

                @TestMetadata("defaultArgsOverridden.kt")
                public void testDefaultArgsOverridden() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsOverridden.kt");
                }

                @TestMetadata("defaultArgsWithSideEffects.kt")
                public void testDefaultArgsWithSideEffects() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffects.kt");
                }

                @TestMetadata("defaultArgsWithSideEffects2.kt")
                public void testDefaultArgsWithSideEffects2() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffects2.kt");
                }

                @TestMetadata("extensionTailCall.kt")
                public void testExtensionTailCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/extensionTailCall.kt");
                }

                @TestMetadata("functionWithNoTails.kt")
                public void testFunctionWithNoTails() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNoTails.kt");
                }

                @TestMetadata("functionWithNonTailRecursions.kt")
                public void testFunctionWithNonTailRecursions() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNonTailRecursions.kt");
                }

                @TestMetadata("functionWithoutAnnotation.kt")
                public void testFunctionWithoutAnnotation() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithoutAnnotation.kt");
                }

                @TestMetadata("infixCall.kt")
                public void testInfixCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixCall.kt");
                }

                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixRecursiveCall.kt");
                }

                @TestMetadata("insideElvis.kt")
                public void testInsideElvis() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/insideElvis.kt");
                }

                @TestMetadata("kt47084_lambdaInDefaultArgument.kt")
                public void testKt47084_lambdaInDefaultArgument() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/kt47084_lambdaInDefaultArgument.kt");
                }

                @TestMetadata("labeledThisReferences.kt")
                public void testLabeledThisReferences() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/labeledThisReferences.kt");
                }

                @TestMetadata("loops.kt")
                public void testLoops() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/loops.kt");
                }

                @TestMetadata("multilevelBlocks.kt")
                public void testMultilevelBlocks() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/multilevelBlocks.kt");
                }

                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realIteratorFoldl.kt");
                }

                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringEscape.kt");
                }

                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringRepeat.kt");
                }

                @TestMetadata("recursiveCallInInlineLambda.kt")
                public void testRecursiveCallInInlineLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInInlineLambda.kt");
                }

                @TestMetadata("recursiveCallInInlineLambdaWithCapture.kt")
                public void testRecursiveCallInInlineLambdaWithCapture() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInInlineLambdaWithCapture.kt");
                }

                @TestMetadata("recursiveCallInLambda.kt")
                public void testRecursiveCallInLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLambda.kt");
                }

                @TestMetadata("recursiveCallInLocalFunction.kt")
                public void testRecursiveCallInLocalFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLocalFunction.kt");
                }

                @TestMetadata("recursiveInnerFunction.kt")
                public void testRecursiveInnerFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveInnerFunction.kt");
                }

                @TestMetadata("returnIf.kt")
                public void testReturnIf() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnIf.kt");
                }

                @TestMetadata("returnInCatch.kt")
                public void testReturnInCatch() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInCatch.kt");
                }

                @TestMetadata("returnInFinally.kt")
                public void testReturnInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInFinally.kt");
                }

                @TestMetadata("returnInIfInFinally.kt")
                public void testReturnInIfInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInIfInFinally.kt");
                }

                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInParentheses.kt");
                }

                @TestMetadata("returnInTry.kt")
                public void testReturnInTry() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInTry.kt");
                }

                @TestMetadata("simpleBlock.kt")
                public void testSimpleBlock() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleBlock.kt");
                }

                @TestMetadata("simpleReturn.kt")
                public void testSimpleReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturn.kt");
                }

                @TestMetadata("simpleReturnWithElse.kt")
                public void testSimpleReturnWithElse() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturnWithElse.kt");
                }

                @TestMetadata("sum.kt")
                public void testSum() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/sum.kt");
                }

                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInBlockInParentheses.kt");
                }

                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInParentheses.kt");
                }

                @TestMetadata("tailRecursionInFinally.kt")
                public void testTailRecursionInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailRecursionInFinally.kt");
                }

                @TestMetadata("tailrecWithExplicitCompanionObjectDispatcher.kt")
                public void testTailrecWithExplicitCompanionObjectDispatcher() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailrecWithExplicitCompanionObjectDispatcher.kt");
                }

                @TestMetadata("tailrecWithExplicitObjectDispatcher.kt")
                public void testTailrecWithExplicitObjectDispatcher() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailrecWithExplicitObjectDispatcher.kt");
                }

                @TestMetadata("thisReferences.kt")
                public void testThisReferences() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/thisReferences.kt");
                }

                @TestMetadata("unitBlocks.kt")
                public void testUnitBlocks() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/unitBlocks.kt");
                }

                @TestMetadata("whenWithCondition.kt")
                public void testWhenWithCondition() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithCondition.kt");
                }

                @TestMetadata("whenWithInRange.kt")
                public void testWhenWithInRange() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithInRange.kt");
                }

                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithIs.kt");
                }

                @TestMetadata("whenWithoutCondition.kt")
                public void testWhenWithoutCondition() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithoutCondition.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/diagnostics/vararg")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Vararg extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInVararg() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/vararg"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt4172.kt")
            public void testKt4172() throws Exception {
                runTest("compiler/testData/codegen/box/diagnostics/vararg/kt4172.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/differentDependencyVersion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DifferentDependencyVersion extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDifferentDependencyVersion() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/differentDependencyVersion"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/directInvokeOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DirectInvokeOptimization extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDirectInvokeOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/directInvokeOptimization"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("boundInnerContructorRef.kt")
        public void testBoundInnerContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/boundInnerContructorRef.kt");
        }

        @TestMetadata("boundMemberRef.kt")
        public void testBoundMemberRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/boundMemberRef.kt");
        }

        @TestMetadata("capturingLambda.kt")
        public void testCapturingLambda() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/capturingLambda.kt");
        }

        @TestMetadata("contructorRef.kt")
        public void testContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/contructorRef.kt");
        }

        @TestMetadata("nestedLambdas.kt")
        public void testNestedLambdas() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/nestedLambdas.kt");
        }

        @TestMetadata("simpleAnonymousFun.kt")
        public void testSimpleAnonymousFun() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleAnonymousFun.kt");
        }

        @TestMetadata("simpleFunRef.kt")
        public void testSimpleFunRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleFunRef.kt");
        }

        @TestMetadata("simpleLambda.kt")
        public void testSimpleLambda() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleLambda.kt");
        }

        @TestMetadata("unboundInnerContructorRef.kt")
        public void testUnboundInnerContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/unboundInnerContructorRef.kt");
        }

        @TestMetadata("unboundMemberRef.kt")
        public void testUnboundMemberRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/unboundMemberRef.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/elvis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Elvis extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInElvis() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/elvis"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("genericElvisWithMoreSpecificLHS.kt")
        public void testGenericElvisWithMoreSpecificLHS() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericElvisWithMoreSpecificLHS.kt");
        }

        @TestMetadata("genericElvisWithNullLHS.kt")
        public void testGenericElvisWithNullLHS() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericElvisWithNullLHS.kt");
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericNull.kt");
        }

        @TestMetadata("kt24209.kt")
        public void testKt24209() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/kt24209.kt");
        }

        @TestMetadata("kt6694ExactAnnotationForElvis.kt")
        public void testKt6694ExactAnnotationForElvis() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/kt6694ExactAnnotationForElvis.kt");
        }

        @TestMetadata("nullNullOk.kt")
        public void testNullNullOk() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/nullNullOk.kt");
        }

        @TestMetadata("ofNonNullableResultType.kt")
        public void testOfNonNullableResultType() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/ofNonNullableResultType.kt");
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/primitive.kt");
        }

        @TestMetadata("withReturn.kt")
        public void testWithReturn() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/withReturn.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("abstractMethodInEnum.kt")
        public void testAbstractMethodInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/abstractMethodInEnum.kt");
        }

        @TestMetadata("abstractNestedClass.kt")
        public void testAbstractNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/abstractNestedClass.kt");
        }

        public void testAllFilesPresentInEnum() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/enum"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("asReturnExpression.kt")
        public void testAsReturnExpression() throws Exception {
            runTest("compiler/testData/codegen/box/enum/asReturnExpression.kt");
        }

        @TestMetadata("companionAccessingEnumValue.kt")
        public void testCompanionAccessingEnumValue() throws Exception {
            runTest("compiler/testData/codegen/box/enum/companionAccessingEnumValue.kt");
        }

        @TestMetadata("companionObjectInEnum.kt")
        public void testCompanionObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/companionObjectInEnum.kt");
        }

        @TestMetadata("constructorWithReordering.kt")
        public void testConstructorWithReordering() throws Exception {
            runTest("compiler/testData/codegen/box/enum/constructorWithReordering.kt");
        }

        @TestMetadata("deepInnerClassInEnumEntryClass.kt")
        public void testDeepInnerClassInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass.kt");
        }

        @TestMetadata("deepInnerClassInEnumEntryClass2.kt")
        public void testDeepInnerClassInEnumEntryClass2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass2.kt");
        }

        @TestMetadata("emptyConstructor.kt")
        public void testEmptyConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/enum/emptyConstructor.kt");
        }

        @TestMetadata("emptyEnumValuesValueOf.kt")
        public void testEmptyEnumValuesValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/emptyEnumValuesValueOf.kt");
        }

        @TestMetadata("enumCompanionInitJsAndWasm.kt")
        public void testEnumCompanionInitJsAndWasm() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumCompanionInitJsAndWasm.kt");
        }

        @TestMetadata("enumConstructorParameterClashWithDefaults.kt")
        public void testEnumConstructorParameterClashWithDefaults() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumConstructorParameterClashWithDefaults.kt");
        }

        @TestMetadata("enumEntryMembers.kt")
        public void testEnumEntryMembers() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryMembers.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor1.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor1() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor1.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor2.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor2.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor3.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor3() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor3.kt");
        }

        @TestMetadata("enumInheritedFromTrait.kt")
        public void testEnumInheritedFromTrait() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumInheritedFromTrait.kt");
        }

        @TestMetadata("enumMultiModule.kt")
        public void testEnumMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumMultiModule.kt");
        }

        @TestMetadata("enumShort.kt")
        public void testEnumShort() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumShort.kt");
        }

        @TestMetadata("enumValueOf.kt")
        public void testEnumValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumValueOf.kt");
        }

        @TestMetadata("enumWithLambdaParameter.kt")
        public void testEnumWithLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumWithLambdaParameter.kt");
        }

        @TestMetadata("getEnumEntityByOrdinal.kt")
        public void testGetEnumEntityByOrdinal() throws Exception {
            runTest("compiler/testData/codegen/box/enum/getEnumEntityByOrdinal.kt");
        }

        @TestMetadata("inPackage.kt")
        public void testInPackage() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inPackage.kt");
        }

        @TestMetadata("inclassobj.kt")
        public void testInclassobj() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inclassobj.kt");
        }

        @TestMetadata("initEntriesInCompanionObject.kt")
        public void testInitEntriesInCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInCompanionObject.kt");
        }

        @TestMetadata("initEntriesInCompanionObject2.kt")
        public void testInitEntriesInCompanionObject2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInCompanionObject2.kt");
        }

        @TestMetadata("initEntriesInValueOf.kt")
        public void testInitEntriesInValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInValueOf.kt");
        }

        @TestMetadata("initEnumAfterObjectAccessJsAndWasm.kt")
        public void testInitEnumAfterObjectAccessJsAndWasm() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEnumAfterObjectAccessJsAndWasm.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inner.kt");
        }

        @TestMetadata("innerClassInEnumEntryClass.kt")
        public void testInnerClassInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassInEnumEntryClass.kt");
        }

        @TestMetadata("innerClassMethodInEnumEntryClass.kt")
        public void testInnerClassMethodInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass.kt");
        }

        @TestMetadata("innerClassMethodInEnumEntryClass2.kt")
        public void testInnerClassMethodInEnumEntryClass2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass2.kt");
        }

        @TestMetadata("innerWithExistingClassObject.kt")
        public void testInnerWithExistingClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerWithExistingClassObject.kt");
        }

        @TestMetadata("kt1119.kt")
        public void testKt1119() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt1119.kt");
        }

        @TestMetadata("kt18731.kt")
        public void testKt18731() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt18731.kt");
        }

        @TestMetadata("kt18731_2.kt")
        public void testKt18731_2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt18731_2.kt");
        }

        @TestMetadata("kt20651.kt")
        public void testKt20651() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651.kt");
        }

        @TestMetadata("kt20651_inlineLambda.kt")
        public void testKt20651_inlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651_inlineLambda.kt");
        }

        @TestMetadata("kt20651a.kt")
        public void testKt20651a() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651a.kt");
        }

        @TestMetadata("kt20651b.kt")
        public void testKt20651b() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651b.kt");
        }

        @TestMetadata("kt2350.kt")
        public void testKt2350() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt2350.kt");
        }

        @TestMetadata("kt38996.kt")
        public void testKt38996() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt38996.kt");
        }

        @TestMetadata("kt44744.kt")
        public void testKt44744() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt44744.kt");
        }

        @TestMetadata("kt44744_innerClass.kt")
        public void testKt44744_innerClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt44744_innerClass.kt");
        }

        @TestMetadata("kt46605.kt")
        public void testKt46605() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt46605.kt");
        }

        @TestMetadata("kt7257.kt")
        public void testKt7257() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257.kt");
        }

        @TestMetadata("kt7257_anonObjectInit.kt")
        public void testKt7257_anonObjectInit() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectInit.kt");
        }

        @TestMetadata("kt7257_anonObjectMethod.kt")
        public void testKt7257_anonObjectMethod() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectMethod.kt");
        }

        @TestMetadata("kt7257_boundReference1.kt")
        public void testKt7257_boundReference1() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReference1.kt");
        }

        @TestMetadata("kt7257_boundReference2.kt")
        public void testKt7257_boundReference2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReference2.kt");
        }

        @TestMetadata("kt7257_boundReferenceWithImplicitReceiver.kt")
        public void testKt7257_boundReferenceWithImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReferenceWithImplicitReceiver.kt");
        }

        @TestMetadata("kt7257_explicitReceiver.kt")
        public void testKt7257_explicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_explicitReceiver.kt");
        }

        @TestMetadata("kt7257_fullyQualifiedReceiver.kt")
        public void testKt7257_fullyQualifiedReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_fullyQualifiedReceiver.kt");
        }

        @TestMetadata("kt7257_namedLocalFun.kt")
        public void testKt7257_namedLocalFun() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_namedLocalFun.kt");
        }

        @TestMetadata("kt7257_notInline.kt")
        public void testKt7257_notInline() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_notInline.kt");
        }

        @TestMetadata("kt9711.kt")
        public void testKt9711() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt9711.kt");
        }

        @TestMetadata("kt9711_2.kt")
        public void testKt9711_2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt9711_2.kt");
        }

        @TestMetadata("manyDefaultParameters.kt")
        public void testManyDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/enum/manyDefaultParameters.kt");
        }

        @TestMetadata("objectInEnum.kt")
        public void testObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/objectInEnum.kt");
        }

        @TestMetadata("ordinal.kt")
        public void testOrdinal() throws Exception {
            runTest("compiler/testData/codegen/box/enum/ordinal.kt");
        }

        @TestMetadata("ordinalsWithEnumEntitiesOverrides.kt")
        public void testOrdinalsWithEnumEntitiesOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/enum/ordinalsWithEnumEntitiesOverrides.kt");
        }

        @TestMetadata("overloadedEnumValues.kt")
        public void testOverloadedEnumValues() throws Exception {
            runTest("compiler/testData/codegen/box/enum/overloadedEnumValues.kt");
        }

        @TestMetadata("refToThis.kt")
        public void testRefToThis() throws Exception {
            runTest("compiler/testData/codegen/box/enum/refToThis.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simple.kt");
        }

        @TestMetadata("sortEnumEntries.kt")
        public void testSortEnumEntries() throws Exception {
            runTest("compiler/testData/codegen/box/enum/sortEnumEntries.kt");
        }

        @TestMetadata("superCallInEnumLiteral.kt")
        public void testSuperCallInEnumLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/enum/superCallInEnumLiteral.kt");
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("compiler/testData/codegen/box/enum/toString.kt");
        }

        @TestMetadata("valueof.kt")
        public void testValueof() throws Exception {
            runTest("compiler/testData/codegen/box/enum/valueof.kt");
        }

        @TestMetadata("whenInObject.kt")
        public void testWhenInObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/whenInObject.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/enum/defaultCtor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultCtor extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultCtor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/enum/defaultCtor"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("constructorWithDefaultArguments.kt")
            public void testConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithDefaultArguments.kt");
            }

            @TestMetadata("constructorWithVararg.kt")
            public void testConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithVararg.kt");
            }

            @TestMetadata("entryClassConstructorWithDefaultArguments.kt")
            public void testEntryClassConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithDefaultArguments.kt");
            }

            @TestMetadata("entryClassConstructorWithVarargs.kt")
            public void testEntryClassConstructorWithVarargs() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithVarargs.kt");
            }

            @TestMetadata("secondaryConstructorWithDefaultArguments.kt")
            public void testSecondaryConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithDefaultArguments.kt");
            }

            @TestMetadata("secondaryConstructorWithVararg.kt")
            public void testSecondaryConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithVararg.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/evaluate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Evaluate extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInEvaluate() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/evaluate"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("kt9443.kt")
        public void testKt9443() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/kt9443.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/exclExcl")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExclExcl extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInExclExcl() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/exclExcl"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/genericNull.kt");
        }

        @TestMetadata("kt48440.kt")
        public void testKt48440() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/kt48440.kt");
        }

        @TestMetadata("kt48440_2.kt")
        public void testKt48440_2() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/kt48440_2.kt");
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/primitive.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionClasses extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInExtensionClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionClasses"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionFunctions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionFunctions extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInExtensionFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("classMethodCallExtensionSuper.kt")
        public void testClassMethodCallExtensionSuper() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/classMethodCallExtensionSuper.kt");
        }

        @TestMetadata("defaultMethodInterfaceCallExtensionSuper.kt")
        public void testDefaultMethodInterfaceCallExtensionSuper() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/defaultMethodInterfaceCallExtensionSuper.kt");
        }

        @TestMetadata("executionOrder.kt")
        public void testExecutionOrder() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/executionOrder.kt");
        }

        @TestMetadata("extensionFunctionAsSupertype.kt")
        public void testExtensionFunctionAsSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsSupertype.kt");
        }

        @TestMetadata("kt1061.kt")
        public void testKt1061() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1061.kt");
        }

        @TestMetadata("kt1249.kt")
        public void testKt1249() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1249.kt");
        }

        @TestMetadata("kt1290.kt")
        public void testKt1290() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1290.kt");
        }

        @TestMetadata("kt13312.kt")
        public void testKt13312() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt13312.kt");
        }

        @TestMetadata("kt1776.kt")
        public void testKt1776() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1776.kt");
        }

        @TestMetadata("kt1953.kt")
        public void testKt1953() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1953.kt");
        }

        @TestMetadata("kt1953_class.kt")
        public void testKt1953_class() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1953_class.kt");
        }

        @TestMetadata("kt23675.kt")
        public void testKt23675() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt23675.kt");
        }

        @TestMetadata("kt3285.kt")
        public void testKt3285() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3285.kt");
        }

        @TestMetadata("kt3298.kt")
        public void testKt3298() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3298.kt");
        }

        @TestMetadata("kt3646.kt")
        public void testKt3646() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3646.kt");
        }

        @TestMetadata("kt3969.kt")
        public void testKt3969() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3969.kt");
        }

        @TestMetadata("kt4228.kt")
        public void testKt4228() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt4228.kt");
        }

        @TestMetadata("kt475.kt")
        public void testKt475() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt475.kt");
        }

        @TestMetadata("kt5467.kt")
        public void testKt5467() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt5467.kt");
        }

        @TestMetadata("kt606.kt")
        public void testKt606() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt606.kt");
        }

        @TestMetadata("kt865.kt")
        public void testKt865() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt865.kt");
        }

        @TestMetadata("memberExtensionEqualsHashCodeToStringInInterface.kt")
        public void testMemberExtensionEqualsHashCodeToStringInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/memberExtensionEqualsHashCodeToStringInInterface.kt");
        }

        @TestMetadata("nested2.kt")
        public void testNested2() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/nested2.kt");
        }

        @TestMetadata("shared.kt")
        public void testShared() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/shared.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/simple.kt");
        }

        @TestMetadata("thisMethodInObjectLiteral.kt")
        public void testThisMethodInObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/thisMethodInObjectLiteral.kt");
        }

        @TestMetadata("virtual.kt")
        public void testVirtual() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/virtual.kt");
        }

        @TestMetadata("whenFail.kt")
        public void testWhenFail() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/whenFail.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/extensionFunctions/contextReceivers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ContextReceivers extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInContextReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions/contextReceivers"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FromKEEP extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInFromKEEP() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionProperties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionProperties extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("accessorForPrivateSetter.kt")
        public void testAccessorForPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/accessorForPrivateSetter.kt");
        }

        public void testAllFilesPresentInExtensionProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionProperties"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("genericValForPrimitiveType.kt")
        public void testGenericValForPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericValForPrimitiveType.kt");
        }

        @TestMetadata("genericVarForPrimitiveType.kt")
        public void testGenericVarForPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericVarForPrimitiveType.kt");
        }

        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClass.kt");
        }

        @TestMetadata("inClassLongTypeInReceiver.kt")
        public void testInClassLongTypeInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassLongTypeInReceiver.kt");
        }

        @TestMetadata("inClassWithGetter.kt")
        public void testInClassWithGetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithGetter.kt");
        }

        @TestMetadata("inClassWithPrivateGetter.kt")
        public void testInClassWithPrivateGetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateGetter.kt");
        }

        @TestMetadata("inClassWithPrivateSetter.kt")
        public void testInClassWithPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateSetter.kt");
        }

        @TestMetadata("inClassWithSetter.kt")
        public void testInClassWithSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithSetter.kt");
        }

        @TestMetadata("kt46952.kt")
        public void testKt46952() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt46952.kt");
        }

        @TestMetadata("kt9897.kt")
        public void testKt9897() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt9897.kt");
        }

        @TestMetadata("kt9897_topLevel.kt")
        public void testKt9897_topLevel() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt9897_topLevel.kt");
        }

        @TestMetadata("nonAbstractInInterface.kt")
        public void testNonAbstractInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/nonAbstractInInterface.kt");
        }

        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/topLevel.kt");
        }

        @TestMetadata("topLevelLongTypeInReceiver.kt")
        public void testTopLevelLongTypeInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/topLevelLongTypeInReceiver.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/external")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class External extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInExternal() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/external"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fakeOverride")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FakeOverride extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInFakeOverride() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fakeOverride"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("diamondFunction.kt")
        public void testDiamondFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/diamondFunction.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/function.kt");
        }

        @TestMetadata("internalFromFriendModule.kt")
        public void testInternalFromFriendModule() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/internalFromFriendModule.kt");
        }

        @TestMetadata("kt49371.kt")
        public void testKt49371() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/kt49371.kt");
        }

        @TestMetadata("privateFakeOverrides0.kt")
        public void testPrivateFakeOverrides0() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/privateFakeOverrides0.kt");
        }

        @TestMetadata("privateFakeOverrides1.kt")
        public void testPrivateFakeOverrides1() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/privateFakeOverrides1.kt");
        }

        @TestMetadata("propertyGetter.kt")
        public void testPropertyGetter() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/propertyGetter.kt");
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/propertySetter.kt");
        }

        @TestMetadata("varianceOverload.kt")
        public void testVarianceOverload() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/varianceOverload.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fieldRename")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FieldRename extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInFieldRename() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fieldRename"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("constructorAndClassObject.kt")
        public void testConstructorAndClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/constructorAndClassObject.kt");
        }

        @TestMetadata("delegates.kt")
        public void testDelegates() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/delegates.kt");
        }

        @TestMetadata("genericPropertyWithItself.kt")
        public void testGenericPropertyWithItself() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/genericPropertyWithItself.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/finally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Finally extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInFinally() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/finally"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("breakAndOuterFinally.kt")
        public void testBreakAndOuterFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/breakAndOuterFinally.kt");
        }

        @TestMetadata("continueAndOuterFinally.kt")
        public void testContinueAndOuterFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/continueAndOuterFinally.kt");
        }

        @TestMetadata("finallyAndFinally.kt")
        public void testFinallyAndFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/finallyAndFinally.kt");
        }

        @TestMetadata("kt31923_break.kt")
        public void testKt31923_break() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_break.kt");
        }

        @TestMetadata("kt31923_continue.kt")
        public void testKt31923_continue() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_continue.kt");
        }

        @TestMetadata("kt31923_return.kt")
        public void testKt31923_return() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_return.kt");
        }

        @TestMetadata("kt3549.kt")
        public void testKt3549() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3549.kt");
        }

        @TestMetadata("kt3706.kt")
        public void testKt3706() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3706.kt");
        }

        @TestMetadata("kt3867.kt")
        public void testKt3867() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3867.kt");
        }

        @TestMetadata("kt3874.kt")
        public void testKt3874() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3874.kt");
        }

        @TestMetadata("kt3894.kt")
        public void testKt3894() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3894.kt");
        }

        @TestMetadata("kt4134.kt")
        public void testKt4134() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt4134.kt");
        }

        @TestMetadata("loopAndFinally.kt")
        public void testLoopAndFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/loopAndFinally.kt");
        }

        @TestMetadata("nestedFinallyAndNonFinallyTry.kt")
        public void testNestedFinallyAndNonFinallyTry() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry.kt");
        }

        @TestMetadata("nestedFinallyAndNonFinallyTry2.kt")
        public void testNestedFinallyAndNonFinallyTry2() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry2.kt");
        }

        @TestMetadata("nestedFinallyAndNonFinallyTry3.kt")
        public void testNestedFinallyAndNonFinallyTry3() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry3.kt");
        }

        @TestMetadata("nestedFinallyAndNonFinallyTry4.kt")
        public void testNestedFinallyAndNonFinallyTry4() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry4.kt");
        }

        @TestMetadata("notChainCatch.kt")
        public void testNotChainCatch() throws Exception {
            runTest("compiler/testData/codegen/box/finally/notChainCatch.kt");
        }

        @TestMetadata("objectInFinally.kt")
        public void testObjectInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/objectInFinally.kt");
        }

        @TestMetadata("someStuff.kt")
        public void testSomeStuff() throws Exception {
            runTest("compiler/testData/codegen/box/finally/someStuff.kt");
        }

        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/tryFinally.kt");
        }

        @TestMetadata("tryLoopTry.kt")
        public void testTryLoopTry() throws Exception {
            runTest("compiler/testData/codegen/box/finally/tryLoopTry.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fir")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Fir extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInFir() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fir"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("classCanNotBeCastedToVoid.kt")
        public void testClassCanNotBeCastedToVoid() throws Exception {
            runTest("compiler/testData/codegen/box/fir/classCanNotBeCastedToVoid.kt");
        }

        @TestMetadata("falsePositiveBoundSmartcast.kt")
        public void testFalsePositiveBoundSmartcast() throws Exception {
            runTest("compiler/testData/codegen/box/fir/falsePositiveBoundSmartcast.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fullJdk")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FullJdk extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInFullJdk() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/fullJdk/native")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Native extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInNative() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/native"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/fullJdk/regressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Regressions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInRegressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/regressions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/funInterface")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FunInterface extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInFunInterface() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/funInterface"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("basicFunInterface.kt")
        public void testBasicFunInterface() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterface.kt");
        }

        @TestMetadata("basicFunInterfaceConversion.kt")
        public void testBasicFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterfaceConversion.kt");
        }

        @TestMetadata("basicFunInterfaceConversionClash.kt")
        public void testBasicFunInterfaceConversionClash() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterfaceConversionClash.kt");
        }

        @TestMetadata("castFromAny.kt")
        public void testCastFromAny() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/castFromAny.kt");
        }

        @TestMetadata("contravariantIntersectionType.kt")
        public void testContravariantIntersectionType() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionType.kt");
        }

        @TestMetadata("contravariantIntersectionTypeWithNonTrivialCommonSupertype.kt")
        public void testContravariantIntersectionTypeWithNonTrivialCommonSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionTypeWithNonTrivialCommonSupertype.kt");
        }

        @TestMetadata("contravariantIntersectionTypeWithNonTrivialCommonSupertype2.kt")
        public void testContravariantIntersectionTypeWithNonTrivialCommonSupertype2() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionTypeWithNonTrivialCommonSupertype2.kt");
        }

        @TestMetadata("funConversionInVararg.kt")
        public void testFunConversionInVararg() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funConversionInVararg.kt");
        }

        @TestMetadata("funInterfaceCallInLambda.kt")
        public void testFunInterfaceCallInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceCallInLambda.kt");
        }

        @TestMetadata("funInterfaceInheritance.kt")
        public void testFunInterfaceInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceInheritance.kt");
        }

        @TestMetadata("funInterfaceWithReceiver.kt")
        public void testFunInterfaceWithReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceWithReceiver.kt");
        }

        @TestMetadata("inlinedSamWrapper.kt")
        public void testInlinedSamWrapper() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/inlinedSamWrapper.kt");
        }

        @TestMetadata("intersectionTypeToFunInterfaceConversion.kt")
        public void testIntersectionTypeToFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/intersectionTypeToFunInterfaceConversion.kt");
        }

        @TestMetadata("irrelevantPrivateDeclarations.kt")
        public void testIrrelevantPrivateDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/irrelevantPrivateDeclarations.kt");
        }

        @TestMetadata("kt45444_privateFunInterface.kt")
        public void testKt45444_privateFunInterface() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt45444_privateFunInterface.kt");
        }

        @TestMetadata("kt46512_indyFunInterfaceOverCallableReference.kt")
        public void testKt46512_indyFunInterfaceOverCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt46512_indyFunInterfaceOverCallableReference.kt");
        }

        @TestMetadata("kt46908_functionSupertype.kt")
        public void testKt46908_functionSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt46908_functionSupertype.kt");
        }

        @TestMetadata("multimodule.kt")
        public void testMultimodule() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/multimodule.kt");
        }

        @TestMetadata("noOptimizedCallableReferences.kt")
        public void testNoOptimizedCallableReferences() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/noOptimizedCallableReferences.kt");
        }

        @TestMetadata("nonAbstractMethod.kt")
        public void testNonAbstractMethod() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/nonAbstractMethod.kt");
        }

        @TestMetadata("nullableSam.kt")
        public void testNullableSam() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/nullableSam.kt");
        }

        @TestMetadata("partialSam.kt")
        public void testPartialSam() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/partialSam.kt");
        }

        @TestMetadata("primitiveConversions.kt")
        public void testPrimitiveConversions() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/primitiveConversions.kt");
        }

        @TestMetadata("receiverEvaluatedOnce.kt")
        public void testReceiverEvaluatedOnce() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/receiverEvaluatedOnce.kt");
        }

        @TestMetadata("samConstructorExplicitInvocation.kt")
        public void testSamConstructorExplicitInvocation() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/samConstructorExplicitInvocation.kt");
        }

        @TestMetadata("samConversionToGenericInterfaceInGenericFun.kt")
        public void testSamConversionToGenericInterfaceInGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/samConversionToGenericInterfaceInGenericFun.kt");
        }

        @TestMetadata("subtypeOfFunctionalTypeToFunInterfaceConversion.kt")
        public void testSubtypeOfFunctionalTypeToFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/subtypeOfFunctionalTypeToFunInterfaceConversion.kt");
        }

        @TestMetadata("suspendFunInterfaceConversionCodegen.kt")
        public void testSuspendFunInterfaceConversionCodegen() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/suspendFunInterfaceConversionCodegen.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/funInterface/equality")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equality extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInEquality() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/funInterface/equality"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("functionReferencesBound.kt")
            public void testFunctionReferencesBound() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/functionReferencesBound.kt");
            }

            @TestMetadata("functionReferencesUnbound.kt")
            public void testFunctionReferencesUnbound() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/functionReferencesUnbound.kt");
            }

            @TestMetadata("lambdaRuntimeConversion.kt")
            public void testLambdaRuntimeConversion() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/lambdaRuntimeConversion.kt");
            }

            @TestMetadata("localFunctionReferences.kt")
            public void testLocalFunctionReferences() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/localFunctionReferences.kt");
            }

            @TestMetadata("simpleLambdas.kt")
            public void testSimpleLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/simpleLambdas.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/functions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Functions extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("coerceVoidToArray.kt")
        public void testCoerceVoidToArray() throws Exception {
            runTest("compiler/testData/codegen/box/functions/coerceVoidToArray.kt");
        }

        @TestMetadata("coerceVoidToObject.kt")
        public void testCoerceVoidToObject() throws Exception {
            runTest("compiler/testData/codegen/box/functions/coerceVoidToObject.kt");
        }

        @TestMetadata("defaultargs.kt")
        public void testDefaultargs() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs.kt");
        }

        @TestMetadata("defaultargs1.kt")
        public void testDefaultargs1() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs1.kt");
        }

        @TestMetadata("defaultargs2.kt")
        public void testDefaultargs2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs2.kt");
        }

        @TestMetadata("defaultargs3.kt")
        public void testDefaultargs3() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs3.kt");
        }

        @TestMetadata("defaultargs4.kt")
        public void testDefaultargs4() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs4.kt");
        }

        @TestMetadata("defaultargs5.kt")
        public void testDefaultargs5() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs5.kt");
        }

        @TestMetadata("defaultargs6.kt")
        public void testDefaultargs6() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs6.kt");
        }

        @TestMetadata("defaultargs7.kt")
        public void testDefaultargs7() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs7.kt");
        }

        @TestMetadata("ea33909.kt")
        public void testEa33909() throws Exception {
            runTest("compiler/testData/codegen/box/functions/ea33909.kt");
        }

        @TestMetadata("fakeDescriptorWithSeveralOverridenOne.kt")
        public void testFakeDescriptorWithSeveralOverridenOne() throws Exception {
            runTest("compiler/testData/codegen/box/functions/fakeDescriptorWithSeveralOverridenOne.kt");
        }

        @TestMetadata("functionNtoString.kt")
        public void testFunctionNtoString() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoString.kt");
        }

        @TestMetadata("functionNtoStringGeneric.kt")
        public void testFunctionNtoStringGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoStringGeneric.kt");
        }

        @TestMetadata("functionNtoStringNoReflect.kt")
        public void testFunctionNtoStringNoReflect() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoStringNoReflect.kt");
        }

        @TestMetadata("infixRecursiveCall.kt")
        public void testInfixRecursiveCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/infixRecursiveCall.kt");
        }

        @TestMetadata("kt1038.kt")
        public void testKt1038() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1038.kt");
        }

        @TestMetadata("kt1199.kt")
        public void testKt1199() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1199.kt");
        }

        @TestMetadata("kt1413.kt")
        public void testKt1413() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1413.kt");
        }

        @TestMetadata("kt1649_1.kt")
        public void testKt1649_1() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1649_1.kt");
        }

        @TestMetadata("kt1649_2.kt")
        public void testKt1649_2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1649_2.kt");
        }

        @TestMetadata("kt1739.kt")
        public void testKt1739() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1739.kt");
        }

        @TestMetadata("kt2270.kt")
        public void testKt2270() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2270.kt");
        }

        @TestMetadata("kt2271.kt")
        public void testKt2271() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2271.kt");
        }

        @TestMetadata("kt2280.kt")
        public void testKt2280() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2280.kt");
        }

        @TestMetadata("kt2481.kt")
        public void testKt2481() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2481.kt");
        }

        @TestMetadata("kt2716.kt")
        public void testKt2716() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2716.kt");
        }

        @TestMetadata("kt2739.kt")
        public void testKt2739() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2739.kt");
        }

        @TestMetadata("kt2929.kt")
        public void testKt2929() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2929.kt");
        }

        @TestMetadata("kt3214.kt")
        public void testKt3214() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3214.kt");
        }

        @TestMetadata("kt3313.kt")
        public void testKt3313() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3313.kt");
        }

        @TestMetadata("kt3573.kt")
        public void testKt3573() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3573.kt");
        }

        @TestMetadata("kt3724.kt")
        public void testKt3724() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3724.kt");
        }

        @TestMetadata("kt395.kt")
        public void testKt395() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt395.kt");
        }

        @TestMetadata("kt47449.kt")
        public void testKt47449() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt47449.kt");
        }

        @TestMetadata("kt47527.kt")
        public void testKt47527() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt47527.kt");
        }

        @TestMetadata("kt48058.kt")
        public void testKt48058() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt48058.kt");
        }

        @TestMetadata("kt785.kt")
        public void testKt785() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt785.kt");
        }

        @TestMetadata("kt873.kt")
        public void testKt873() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt873.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/functions/localFunction.kt");
        }

        @TestMetadata("localReturnInsideFunctionExpression.kt")
        public void testLocalReturnInsideFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/box/functions/localReturnInsideFunctionExpression.kt");
        }

        @TestMetadata("mutualInline.kt")
        public void testMutualInline() throws Exception {
            runTest("compiler/testData/codegen/box/functions/mutualInline.kt");
        }

        @TestMetadata("nothisnoclosure.kt")
        public void testNothisnoclosure() throws Exception {
            runTest("compiler/testData/codegen/box/functions/nothisnoclosure.kt");
        }

        @TestMetadata("overloadByInterfaceType.kt")
        public void testOverloadByInterfaceType() throws Exception {
            runTest("compiler/testData/codegen/box/functions/overloadByInterfaceType.kt");
        }

        @TestMetadata("prefixRecursiveCall.kt")
        public void testPrefixRecursiveCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/prefixRecursiveCall.kt");
        }

        @TestMetadata("recursiveCompareTo.kt")
        public void testRecursiveCompareTo() throws Exception {
            runTest("compiler/testData/codegen/box/functions/recursiveCompareTo.kt");
        }

        @TestMetadata("recursiveIncrementCall.kt")
        public void testRecursiveIncrementCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/recursiveIncrementCall.kt");
        }

        @TestMetadata("typeParameterAsUpperBound.kt")
        public void testTypeParameterAsUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/functions/typeParameterAsUpperBound.kt");
        }

        @TestMetadata("typeParametersInLocalFunction.kt")
        public void testTypeParametersInLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/functions/typeParametersInLocalFunction.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/functions/bigArity")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BigArity extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBigArity() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/bigArity"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("function255.kt")
            public void testFunction255() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/function255.kt");
            }

            @TestMetadata("instanceOfCallableReference.kt")
            public void testInstanceOfCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/instanceOfCallableReference.kt");
            }

            @TestMetadata("invokeCallableReference.kt")
            public void testInvokeCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeCallableReference.kt");
            }

            @TestMetadata("invokeLambda.kt")
            public void testInvokeLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeLambda.kt");
            }

            @TestMetadata("invokeMemberCallableReference.kt")
            public void testInvokeMemberCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeMemberCallableReference.kt");
            }

            @TestMetadata("nestedBigArityFunCalls.kt")
            public void testNestedBigArityFunCalls() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/nestedBigArityFunCalls.kt");
            }

            @TestMetadata("subclass.kt")
            public void testSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/subclass.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/functionExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionExpression extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionExpression() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/functionExpression"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("functionExpression.kt")
            public void testFunctionExpression() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpression.kt");
            }

            @TestMetadata("functionExpressionWithThisReference.kt")
            public void testFunctionExpressionWithThisReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpressionWithThisReference.kt");
            }

            @TestMetadata("functionLiteralExpression.kt")
            public void testFunctionLiteralExpression() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionLiteralExpression.kt");
            }

            @TestMetadata("insideGenericLambda.kt")
            public void testInsideGenericLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/insideGenericLambda.kt");
            }

            @TestMetadata("underscoreParameters.kt")
            public void testUnderscoreParameters() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/underscoreParameters.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/invoke")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Invoke extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInvoke() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/invoke"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("castFunctionToExtension.kt")
            public void testCastFunctionToExtension() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/castFunctionToExtension.kt");
            }

            @TestMetadata("extensionInvokeOnExpr.kt")
            public void testExtensionInvokeOnExpr() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/extensionInvokeOnExpr.kt");
            }

            @TestMetadata("implicitInvokeInCompanionObjectWithFunctionalArgument.kt")
            public void testImplicitInvokeInCompanionObjectWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeInCompanionObjectWithFunctionalArgument.kt");
            }

            @TestMetadata("implicitInvokeWithFunctionLiteralArgument.kt")
            public void testImplicitInvokeWithFunctionLiteralArgument() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeWithFunctionLiteralArgument.kt");
            }

            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invoke.kt");
            }

            @TestMetadata("invokeOnExprByConvention.kt")
            public void testInvokeOnExprByConvention() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invokeOnExprByConvention.kt");
            }

            @TestMetadata("kt3189.kt")
            public void testKt3189() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3189.kt");
            }

            @TestMetadata("kt3190.kt")
            public void testKt3190() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3190.kt");
            }

            @TestMetadata("kt3297.kt")
            public void testKt3297() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3297.kt");
            }

            @TestMetadata("kt3450getAndInvoke.kt")
            public void testKt3450getAndInvoke() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3450getAndInvoke.kt");
            }

            @TestMetadata("kt3631invokeOnString.kt")
            public void testKt3631invokeOnString() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3631invokeOnString.kt");
            }

            @TestMetadata("kt3772.kt")
            public void testKt3772() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3772.kt");
            }

            @TestMetadata("kt3821invokeOnThis.kt")
            public void testKt3821invokeOnThis() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3821invokeOnThis.kt");
            }

            @TestMetadata("kt3822invokeOnThis.kt")
            public void testKt3822invokeOnThis() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3822invokeOnThis.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalFunctions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/localFunctions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("boundTypeParameterInSupertype.kt")
            public void testBoundTypeParameterInSupertype() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/boundTypeParameterInSupertype.kt");
            }

            @TestMetadata("boundTypeParameterInVararg.kt")
            public void testBoundTypeParameterInVararg() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/boundTypeParameterInVararg.kt");
            }

            @TestMetadata("callBetweenLocalFunctions.kt")
            public void testCallBetweenLocalFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/callBetweenLocalFunctions.kt");
            }

            @TestMetadata("callInlineLocalInLambda.kt")
            public void testCallInlineLocalInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/callInlineLocalInLambda.kt");
            }

            @TestMetadata("captureUpperBoundedTypeParameter.kt")
            public void testCaptureUpperBoundedTypeParameter() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/captureUpperBoundedTypeParameter.kt");
            }

            @TestMetadata("definedWithinLambda.kt")
            public void testDefinedWithinLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambda.kt");
            }

            @TestMetadata("definedWithinLambdaInnerUsage1.kt")
            public void testDefinedWithinLambdaInnerUsage1() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage1.kt");
            }

            @TestMetadata("definedWithinLambdaInnerUsage2.kt")
            public void testDefinedWithinLambdaInnerUsage2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage2.kt");
            }

            @TestMetadata("kt2895.kt")
            public void testKt2895() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt2895.kt");
            }

            @TestMetadata("kt3308.kt")
            public void testKt3308() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3308.kt");
            }

            @TestMetadata("kt3978.kt")
            public void testKt3978() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978.kt");
            }

            @TestMetadata("kt3978_2.kt")
            public void testKt3978_2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978_2.kt");
            }

            @TestMetadata("kt4119.kt")
            public void testKt4119() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119.kt");
            }

            @TestMetadata("kt4119_2.kt")
            public void testKt4119_2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119_2.kt");
            }

            @TestMetadata("kt4514.kt")
            public void testKt4514() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4514.kt");
            }

            @TestMetadata("kt4777.kt")
            public void testKt4777() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4777.kt");
            }

            @TestMetadata("kt4783.kt")
            public void testKt4783() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4783.kt");
            }

            @TestMetadata("kt4784.kt")
            public void testKt4784() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4784.kt");
            }

            @TestMetadata("kt4989.kt")
            public void testKt4989() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4989.kt");
            }

            @TestMetadata("localExtensionOnNullableParameter.kt")
            public void testLocalExtensionOnNullableParameter() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localExtensionOnNullableParameter.kt");
            }

            @TestMetadata("localFunctionInConstructor.kt")
            public void testLocalFunctionInConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionInConstructor.kt");
            }

            @TestMetadata("localFunctionVsLocalVariable.kt")
            public void testLocalFunctionVsLocalVariable() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionVsLocalVariable.kt");
            }

            @TestMetadata("nameClash.kt")
            public void testNameClash() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/nameClash.kt");
            }

            @TestMetadata("nameClashAcrossDifferentContainers.kt")
            public void testNameClashAcrossDifferentContainers() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/nameClashAcrossDifferentContainers.kt");
            }

            @TestMetadata("overloadedLocalFunWithoutClosure.kt")
            public void testOverloadedLocalFunWithoutClosure() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunWithoutClosure.kt");
            }

            @TestMetadata("overloadedLocalFunction.kt")
            public void testOverloadedLocalFunction() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction.kt");
            }

            @TestMetadata("overloadedLocalFunction1.kt")
            public void testOverloadedLocalFunction1() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction1.kt");
            }

            @TestMetadata("overloadedLocalFunction2.kt")
            public void testOverloadedLocalFunction2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction2.kt");
            }

            @TestMetadata("overloadedLocalFunction3.kt")
            public void testOverloadedLocalFunction3() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction3.kt");
            }

            @TestMetadata("parameterAsDefaultValue.kt")
            public void testParameterAsDefaultValue() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/parameterAsDefaultValue.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/hashPMap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class HashPMap extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInHashPMap() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/hashPMap"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/ieee754")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ieee754 extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInIeee754() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ieee754"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("anyCastToPrimitiveCompareTo1.kt")
        public void testAnyCastToPrimitiveCompareTo1() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyCastToPrimitiveCompareTo1.kt");
        }

        @TestMetadata("anyCastToPrimitiveCompareTo2.kt")
        public void testAnyCastToPrimitiveCompareTo2() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyCastToPrimitiveCompareTo2.kt");
        }

        @TestMetadata("anyToReal.kt")
        public void testAnyToReal() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyToReal.kt");
        }

        @TestMetadata("asComparableToDouble.kt")
        public void testAsComparableToDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble.kt");
        }

        @TestMetadata("asComparableToDouble_properIeeeComparisons.kt")
        public void testAsComparableToDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("comparableToTWithT_properIeeeComparisons.kt")
        public void testComparableToTWithT_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableToTWithT_properIeeeComparisons.kt");
        }

        @TestMetadata("comparableTypeCast.kt")
        public void testComparableTypeCast() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableTypeCast.kt");
        }

        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/dataClass.kt");
        }

        @TestMetadata("differentTypesComparison.kt")
        public void testDifferentTypesComparison() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/differentTypesComparison.kt");
        }

        @TestMetadata("equalsDouble.kt")
        public void testEqualsDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsDouble.kt");
        }

        @TestMetadata("equalsDouble_properIeeeComparisons.kt")
        public void testEqualsDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsFloat.kt")
        public void testEqualsFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsFloat.kt");
        }

        @TestMetadata("equalsFloat_properIeeeComparisons.kt")
        public void testEqualsFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNaN.kt")
        public void testEqualsNaN() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNaN.kt");
        }

        @TestMetadata("equalsNaN_properIeeeComparisons.kt")
        public void testEqualsNaN_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNaN_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNullableDouble.kt")
        public void testEqualsNullableDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble.kt");
        }

        @TestMetadata("equalsNullableDouble_properIeeeComparisons.kt")
        public void testEqualsNullableDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNullableFloat.kt")
        public void testEqualsNullableFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat.kt");
        }

        @TestMetadata("equalsNullableFloat_properIeeeComparisons.kt")
        public void testEqualsNullableFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("explicitCompareCall.kt")
        public void testExplicitCompareCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitCompareCall.kt");
        }

        @TestMetadata("explicitEqualsCall.kt")
        public void testExplicitEqualsCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitEqualsCall.kt");
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/generic.kt");
        }

        @TestMetadata("greaterDouble.kt")
        public void testGreaterDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterDouble.kt");
        }

        @TestMetadata("greaterDouble_properIeeeComparisons.kt")
        public void testGreaterDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("greaterFloat.kt")
        public void testGreaterFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterFloat.kt");
        }

        @TestMetadata("greaterFloat_properIeeeComparisons.kt")
        public void testGreaterFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/inline.kt");
        }

        @TestMetadata("lessDouble.kt")
        public void testLessDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble.kt");
        }

        @TestMetadata("lessDouble_properIeeeAndNewInference.kt")
        public void testLessDouble_properIeeeAndNewInference() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeAndNewInference.kt");
        }

        @TestMetadata("lessDouble_properIeeeComparisons.kt")
        public void testLessDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("lessFloat.kt")
        public void testLessFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessFloat.kt");
        }

        @TestMetadata("lessFloat_properIeeeComparisons.kt")
        public void testLessFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("nullableAnyToReal.kt")
        public void testNullableAnyToReal() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableAnyToReal.kt");
        }

        @TestMetadata("nullableDoubleEquals.kt")
        public void testNullableDoubleEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEquals.kt");
        }

        @TestMetadata("nullableDoubleEqualsLV13.kt")
        public void testNullableDoubleEqualsLV13() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEqualsLV13.kt");
        }

        @TestMetadata("nullableDoubleNotEquals.kt")
        public void testNullableDoubleNotEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleNotEquals.kt");
        }

        @TestMetadata("nullableFloatEquals.kt")
        public void testNullableFloatEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatEquals.kt");
        }

        @TestMetadata("nullableFloatNotEquals.kt")
        public void testNullableFloatNotEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatNotEquals.kt");
        }

        @TestMetadata("nullableIntEquals.kt")
        public void testNullableIntEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableIntEquals.kt");
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/safeCall.kt");
        }

        @TestMetadata("smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt")
        public void testSmartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDifferentTypes.kt")
        public void testSmartCastToDifferentTypes() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes.kt");
        }

        @TestMetadata("smartCastToDifferentTypesWithNumericPromotion.kt")
        public void testSmartCastToDifferentTypesWithNumericPromotion() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion.kt");
        }

        @TestMetadata("smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt")
        public void testSmartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDifferentTypes_properIeeeComparisons.kt")
        public void testSmartCastToDifferentTypes_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDoubleAndComparableToDouble.kt")
        public void testSmartCastToDoubleAndComparableToDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDoubleAndComparableToDouble.kt");
        }

        @TestMetadata("smartCastToInt.kt")
        public void testSmartCastToInt() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToInt.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when.kt");
        }

        @TestMetadata("whenNoSubject.kt")
        public void testWhenNoSubject() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNoSubject.kt");
        }

        @TestMetadata("whenNoSubject_properIeeeComparisons.kt")
        public void testWhenNoSubject_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNoSubject_properIeeeComparisons.kt");
        }

        @TestMetadata("whenNullableSmartCast.kt")
        public void testWhenNullableSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNullableSmartCast.kt");
        }

        @TestMetadata("when_properIeeeComparisons.kt")
        public void testWhen_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when_properIeeeComparisons.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/increment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Increment extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInIncrement() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/increment"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("argumentWithSideEffects.kt")
        public void testArgumentWithSideEffects() throws Exception {
            runTest("compiler/testData/codegen/box/increment/argumentWithSideEffects.kt");
        }

        @TestMetadata("arrayElement.kt")
        public void testArrayElement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/arrayElement.kt");
        }

        @TestMetadata("assignPlusOnSmartCast.kt")
        public void testAssignPlusOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/assignPlusOnSmartCast.kt");
        }

        @TestMetadata("augmentedAssignmentWithComplexRhs.kt")
        public void testAugmentedAssignmentWithComplexRhs() throws Exception {
            runTest("compiler/testData/codegen/box/increment/augmentedAssignmentWithComplexRhs.kt");
        }

        @TestMetadata("classNaryGetSet.kt")
        public void testClassNaryGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classNaryGetSet.kt");
        }

        @TestMetadata("classVarargGetSet.kt")
        public void testClassVarargGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classVarargGetSet.kt");
        }

        @TestMetadata("classVarargGetSetEvaluationOrder.kt")
        public void testClassVarargGetSetEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classVarargGetSetEvaluationOrder.kt");
        }

        @TestMetadata("classWithGetSet.kt")
        public void testClassWithGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classWithGetSet.kt");
        }

        @TestMetadata("extOnLong.kt")
        public void testExtOnLong() throws Exception {
            runTest("compiler/testData/codegen/box/increment/extOnLong.kt");
        }

        @TestMetadata("genericClassWithGetSet.kt")
        public void testGenericClassWithGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/genericClassWithGetSet.kt");
        }

        @TestMetadata("kt36956.kt")
        public void testKt36956() throws Exception {
            runTest("compiler/testData/codegen/box/increment/kt36956.kt");
        }

        @TestMetadata("memberExtOnLong.kt")
        public void testMemberExtOnLong() throws Exception {
            runTest("compiler/testData/codegen/box/increment/memberExtOnLong.kt");
        }

        @TestMetadata("mutableListElement.kt")
        public void testMutableListElement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/mutableListElement.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("compiler/testData/codegen/box/increment/nullable.kt");
        }

        @TestMetadata("postfixIncrementDoubleSmartCast.kt")
        public void testPostfixIncrementDoubleSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementDoubleSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnClass.kt")
        public void testPostfixIncrementOnClass() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClass.kt");
        }

        @TestMetadata("postfixIncrementOnClassSmartCast.kt")
        public void testPostfixIncrementOnClassSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClassSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnShortSmartCast.kt")
        public void testPostfixIncrementOnShortSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnShortSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnSmartCast.kt")
        public void testPostfixIncrementOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnSmartCast.kt");
        }

        @TestMetadata("postfixNullableClassIncrement.kt")
        public void testPostfixNullableClassIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixNullableClassIncrement.kt");
        }

        @TestMetadata("postfixNullableIncrement.kt")
        public void testPostfixNullableIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixNullableIncrement.kt");
        }

        @TestMetadata("prefixIncrementOnClass.kt")
        public void testPrefixIncrementOnClass() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClass.kt");
        }

        @TestMetadata("prefixIncrementOnClassSmartCast.kt")
        public void testPrefixIncrementOnClassSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClassSmartCast.kt");
        }

        @TestMetadata("prefixIncrementOnSmartCast.kt")
        public void testPrefixIncrementOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnSmartCast.kt");
        }

        @TestMetadata("prefixNullableClassIncrement.kt")
        public void testPrefixNullableClassIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixNullableClassIncrement.kt");
        }

        @TestMetadata("prefixNullableIncrement.kt")
        public void testPrefixNullableIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixNullableIncrement.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/inference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inference extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("approximateNonTopLevelCapturedTypes.kt")
        public void testApproximateNonTopLevelCapturedTypes() throws Exception {
            runTest("compiler/testData/codegen/box/inference/approximateNonTopLevelCapturedTypes.kt");
        }

        @TestMetadata("builderInferenceLeakingVariable.kt")
        public void testBuilderInferenceLeakingVariable() throws Exception {
            runTest("compiler/testData/codegen/box/inference/builderInferenceLeakingVariable.kt");
        }

        @TestMetadata("capturedStarProjection.kt")
        public void testCapturedStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/capturedStarProjection.kt");
        }

        @TestMetadata("capturedTypesSubstitutionIntoAbbreviation.kt")
        public void testCapturedTypesSubstitutionIntoAbbreviation() throws Exception {
            runTest("compiler/testData/codegen/box/inference/capturedTypesSubstitutionIntoAbbreviation.kt");
        }

        @TestMetadata("coercionToUnitWithLastLambdaExpression.kt")
        public void testCoercionToUnitWithLastLambdaExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inference/coercionToUnitWithLastLambdaExpression.kt");
        }

        @TestMetadata("coerctionToUnitForLastExpressionWithStarProjection.kt")
        public void testCoerctionToUnitForLastExpressionWithStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/coerctionToUnitForLastExpressionWithStarProjection.kt");
        }

        @TestMetadata("earlyReturnInsideCrossinlineLambda.kt")
        public void testEarlyReturnInsideCrossinlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inference/earlyReturnInsideCrossinlineLambda.kt");
        }

        @TestMetadata("inferenceWithTypeVariableInsideCapturedType.kt")
        public void testInferenceWithTypeVariableInsideCapturedType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/inferenceWithTypeVariableInsideCapturedType.kt");
        }

        @TestMetadata("integerLiteralTypeInLamdaReturnType.kt")
        public void testIntegerLiteralTypeInLamdaReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/integerLiteralTypeInLamdaReturnType.kt");
        }

        @TestMetadata("kt10822.kt")
        public void testKt10822() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt10822.kt");
        }

        @TestMetadata("kt35684.kt")
        public void testKt35684() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt35684.kt");
        }

        @TestMetadata("kt36446.kt")
        public void testKt36446() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt36446.kt");
        }

        @TestMetadata("kt38664.kt")
        public void testKt38664() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt38664.kt");
        }

        @TestMetadata("kt39824.kt")
        public void testKt39824() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt39824.kt");
        }

        @TestMetadata("kt42042.kt")
        public void testKt42042() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt42042.kt");
        }

        @TestMetadata("kt42130.kt")
        public void testKt42130() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt42130.kt");
        }

        @TestMetadata("kt45118.kt")
        public void testKt45118() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt45118.kt");
        }

        @TestMetadata("kt49838.kt")
        public void testKt49838() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt49838.kt");
        }

        @TestMetadata("lambdaWithStarReturn.kt")
        public void testLambdaWithStarReturn() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lambdaWithStarReturn.kt");
        }

        @TestMetadata("lambdasWithExtensionFunctionType.kt")
        public void testLambdasWithExtensionFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lambdasWithExtensionFunctionType.kt");
        }

        @TestMetadata("lastExpressionOfLambdaWithNothingConstraint.kt")
        public void testLastExpressionOfLambdaWithNothingConstraint() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lastExpressionOfLambdaWithNothingConstraint.kt");
        }

        @TestMetadata("mapCollectChainWithNullResult.kt")
        public void testMapCollectChainWithNullResult() throws Exception {
            runTest("compiler/testData/codegen/box/inference/mapCollectChainWithNullResult.kt");
        }

        @TestMetadata("noCoercionToUniForNullableLambdaReturnType.kt")
        public void testNoCoercionToUniForNullableLambdaReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/noCoercionToUniForNullableLambdaReturnType.kt");
        }

        @TestMetadata("noCoercionToUnitWithEqualityConstraintForNullableReturnType.kt")
        public void testNoCoercionToUnitWithEqualityConstraintForNullableReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/noCoercionToUnitWithEqualityConstraintForNullableReturnType.kt");
        }

        @TestMetadata("plusAssignInsideLambda.kt")
        public void testPlusAssignInsideLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inference/plusAssignInsideLambda.kt");
        }

        @TestMetadata("recursiveConstraintInsideTypeArgumentWithStarProjection.kt")
        public void testRecursiveConstraintInsideTypeArgumentWithStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/recursiveConstraintInsideTypeArgumentWithStarProjection.kt");
        }

        @TestMetadata("referenceToCatchParameterFromLambdaExpression.kt")
        public void testReferenceToCatchParameterFromLambdaExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inference/referenceToCatchParameterFromLambdaExpression.kt");
        }

        @TestMetadata("specialCallsWithCallableReferences.kt")
        public void testSpecialCallsWithCallableReferences() throws Exception {
            runTest("compiler/testData/codegen/box/inference/specialCallsWithCallableReferences.kt");
        }

        @TestMetadata("sumOfOverloads.kt")
        public void testSumOfOverloads() throws Exception {
            runTest("compiler/testData/codegen/box/inference/sumOfOverloads.kt");
        }

        @TestMetadata("suspendExtensionRecevierFromConstraint.kt")
        public void testSuspendExtensionRecevierFromConstraint() throws Exception {
            runTest("compiler/testData/codegen/box/inference/suspendExtensionRecevierFromConstraint.kt");
        }

        @TestMetadata("unsafeVarianceCodegen.kt")
        public void testUnsafeVarianceCodegen() throws Exception {
            runTest("compiler/testData/codegen/box/inference/unsafeVarianceCodegen.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/inference/builderInference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BuilderInference extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBuilderInference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/builderInference"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("builderCallAsReturnTypeInLocalClass.kt")
            public void testBuilderCallAsReturnTypeInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/builderCallAsReturnTypeInLocalClass.kt");
            }

            @TestMetadata("callableReferenceAndCoercionToUnit.kt")
            public void testCallableReferenceAndCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/callableReferenceAndCoercionToUnit.kt");
            }

            @TestMetadata("callableReferencesProperCompletion.kt")
            public void testCallableReferencesProperCompletion() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/callableReferencesProperCompletion.kt");
            }

            @TestMetadata("capturedTypes.kt")
            public void testCapturedTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/capturedTypes.kt");
            }

            @TestMetadata("changingResolveIfDontUseBuilderInferenceDisabledFeature.kt")
            public void testChangingResolveIfDontUseBuilderInferenceDisabledFeature() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/changingResolveIfDontUseBuilderInferenceDisabledFeature.kt");
            }

            @TestMetadata("constraintsBetweenTwoStubVariables.kt")
            public void testConstraintsBetweenTwoStubVariables() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/constraintsBetweenTwoStubVariables.kt");
            }

            @TestMetadata("kt41164.kt")
            public void testKt41164() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt41164.kt");
            }

            @TestMetadata("kt42139.kt")
            public void testKt42139() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt42139.kt");
            }

            @TestMetadata("kt44241.kt")
            public void testKt44241() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt44241.kt");
            }

            @TestMetadata("kt45083.kt")
            public void testKt45083() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt45083.kt");
            }

            @TestMetadata("kt47052.kt")
            public void testKt47052() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt47052.kt");
            }

            @TestMetadata("kt47744.kt")
            public void testKt47744() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt47744.kt");
            }

            @TestMetadata("kt48445.kt")
            public void testKt48445() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt48445.kt");
            }

            @TestMetadata("kt49887.kt")
            public void testKt49887() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt49887.kt");
            }

            @TestMetadata("kt51988.kt")
            public void testKt51988() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt51988.kt");
            }

            @TestMetadata("labaledCall.kt")
            public void testLabaledCall() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/labaledCall.kt");
            }

            @TestMetadata("lackOfNullCheckOnNullableInsideBuild.kt")
            public void testLackOfNullCheckOnNullableInsideBuild() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/lackOfNullCheckOnNullableInsideBuild.kt");
            }

            @TestMetadata("memberScope.kt")
            public void testMemberScope() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/memberScope.kt");
            }

            @TestMetadata("nullability.kt")
            public void testNullability() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/nullability.kt");
            }

            @TestMetadata("propagateInferenceSessionIntoDeclarationAnalyzers.kt")
            public void testPropagateInferenceSessionIntoDeclarationAnalyzers() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/propagateInferenceSessionIntoDeclarationAnalyzers.kt");
            }

            @TestMetadata("specialCallsWithCallableReferences.kt")
            public void testSpecialCallsWithCallableReferences() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferences.kt");
            }

            @TestMetadata("specialCallsWithCallableReferencesDontRewriteAtSlice.kt")
            public void testSpecialCallsWithCallableReferencesDontRewriteAtSlice() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferencesDontRewriteAtSlice.kt");
            }

            @TestMetadata("specialCallsWithCallableReferencesErrorType.kt")
            public void testSpecialCallsWithCallableReferencesErrorType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferencesErrorType.kt");
            }

            @TestMetadata("specialCallsWithLambdas.kt")
            public void testSpecialCallsWithLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithLambdas.kt");
            }

            @TestMetadata("substituteStubTypeIntoCR.kt")
            public void testSubstituteStubTypeIntoCR() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substituteStubTypeIntoCR.kt");
            }

            @TestMetadata("substituteStubTypeIntolambdaParameterDescriptor.kt")
            public void testSubstituteStubTypeIntolambdaParameterDescriptor() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substituteStubTypeIntolambdaParameterDescriptor.kt");
            }

            @TestMetadata("substitutelambdaExtensionReceiverType.kt")
            public void testSubstitutelambdaExtensionReceiverType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substitutelambdaExtensionReceiverType.kt");
            }

            @TestMetadata("topDownCompletionBreakedByNonBuilderInferenceSession.kt")
            public void testTopDownCompletionBreakedByNonBuilderInferenceSession() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionBreakedByNonBuilderInferenceSession.kt");
            }

            @TestMetadata("topDownCompletionWithThreeBuilderInferenceCalls.kt")
            public void testTopDownCompletionWithThreeBuilderInferenceCalls() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithThreeBuilderInferenceCalls.kt");
            }

            @TestMetadata("topDownCompletionWithThreeBuilderInferenceCallsSameLevel.kt")
            public void testTopDownCompletionWithThreeBuilderInferenceCallsSameLevel() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithThreeBuilderInferenceCallsSameLevel.kt");
            }

            @TestMetadata("topDownCompletionWithTwoBuilderInferenceCalls.kt")
            public void testTopDownCompletionWithTwoBuilderInferenceCalls() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithTwoBuilderInferenceCalls.kt");
            }

            @TestMetadata("withExpectedType.kt")
            public void testWithExpectedType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/withExpectedType.kt");
            }

            @TestMetadata("withoutAnnotation.kt")
            public void testWithoutAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/withoutAnnotation.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/inlineArgsInPlace")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineArgsInPlace extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInlineArgsInPlace() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineArgsInPlace"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("arrayDequeRemoveAll.kt")
        public void testArrayDequeRemoveAll() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/arrayDequeRemoveAll.kt");
        }

        @TestMetadata("breakInArgumentExpression.kt")
        public void testBreakInArgumentExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/breakInArgumentExpression.kt");
        }

        @TestMetadata("continueInArgumentExpression.kt")
        public void testContinueInArgumentExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/continueInArgumentExpression.kt");
        }

        @TestMetadata("inlineCircularDedepency.kt")
        public void testInlineCircularDedepency() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/inlineCircularDedepency.kt");
        }

        @TestMetadata("kotlinReflect.kt")
        public void testKotlinReflect() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kotlinReflect.kt");
        }

        @TestMetadata("kt49370.kt")
        public void testKt49370() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kt49370.kt");
        }

        @TestMetadata("kt49407.kt")
        public void testKt49407() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kt49407.kt");
        }

        @TestMetadata("mapSet.kt")
        public void testMapSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/mapSet.kt");
        }

        @TestMetadata("mutableCollectionPlusAssign.kt")
        public void testMutableCollectionPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/mutableCollectionPlusAssign.kt");
        }

        @TestMetadata("noinlineParameter.kt")
        public void testNoinlineParameter() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/noinlineParameter.kt");
        }

        @TestMetadata("suspensionPointInsideArgument.kt")
        public void testSuspensionPointInsideArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/suspensionPointInsideArgument.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineClasses extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
            KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("annotatedMemberExtensionProperty.kt")
        public void testAnnotatedMemberExtensionProperty() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/annotatedMemberExtensionProperty.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("annotatedMemberExtensionPropertyGeneric.kt")
        public void testAnnotatedMemberExtensionPropertyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/annotatedMemberExtensionPropertyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("anySuperCall.kt")
        public void testAnySuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/anySuperCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("anySuperCallGeneric.kt")
        public void testAnySuperCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/anySuperCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boundCallableReferencePassedToInlineFunction.kt")
        public void testBoundCallableReferencePassedToInlineFunction() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunction.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boundCallableReferencePassedToInlineFunctionGeneric.kt")
        public void testBoundCallableReferencePassedToInlineFunctionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunctionGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boundCallableReferencePassedToInlineFunctionGeneric2.kt")
        public void testBoundCallableReferencePassedToInlineFunctionGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunctionGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxImplDoesNotExecuteInSecondaryConstructor.kt")
        public void testBoxImplDoesNotExecuteInSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInSecondaryConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxImplDoesNotExecuteInSecondaryConstructorGeneric.kt")
        public void testBoxImplDoesNotExecuteInSecondaryConstructorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInSecondaryConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxImplDoesNotExecuteInitBlock.kt")
        public void testBoxImplDoesNotExecuteInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInitBlock.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxImplDoesNotExecuteInitBlockGeneric.kt")
        public void testBoxImplDoesNotExecuteInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInitBlockGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableForFakeOverride.kt")
        public void testBoxNullableForFakeOverride() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverride.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableForFakeOverrideGeneric.kt")
        public void testBoxNullableForFakeOverrideGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverrideGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableForFakeOverrideGeneric2.kt")
        public void testBoxNullableForFakeOverrideGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverrideGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxResultInlineClassOfConstructorCall.kt")
        public void testBoxResultInlineClassOfConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxResultInlineClassOfConstructorCallGeneric.kt")
        public void testBoxResultInlineClassOfConstructorCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxResultInlineClassOfConstructorCallGeneric2.kt")
        public void testBoxResultInlineClassOfConstructorCallGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCallGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSet.kt")
        public void testBoxUnboxInlineClassesWithOperatorsGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSet.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSetGeneric.kt")
        public void testBoxUnboxInlineClassesWithOperatorsGetSetGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSetGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxUnboxOfInlineClassForCapturedVars.kt")
        public void testBoxUnboxOfInlineClassForCapturedVars() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVars.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("boxUnboxOfInlineClassForCapturedVarsGeneric.kt")
        public void testBoxUnboxOfInlineClassForCapturedVarsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVarsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("bridgeForFunctionReturningInlineClass.kt")
        public void testBridgeForFunctionReturningInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("bridgeForFunctionReturningInlineClassGeneric.kt")
        public void testBridgeForFunctionReturningInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("bridgeGenerationWithInlineClassOverAny.kt")
        public void testBridgeGenerationWithInlineClassOverAny() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("bridgeGenerationWithInlineClassOverAnyGeneric.kt")
        public void testBridgeGenerationWithInlineClassOverAnyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("bridgeGenerationWithInlineClassOverAnyGeneric2.kt")
        public void testBridgeGenerationWithInlineClassOverAnyGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAnyGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("bridgesWhenInlineClassImplementsGenericInterface.kt")
        public void testBridgesWhenInlineClassImplementsGenericInterface() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterface.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("bridgesWhenInlineClassImplementsGenericInterfaceGeneric.kt")
        public void testBridgesWhenInlineClassImplementsGenericInterfaceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterfaceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("callComputablePropertyInsideInlineClass.kt")
        public void testCallComputablePropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callComputablePropertyInsideInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("callableReferencesWithInlineClasses.kt")
        public void testCallableReferencesWithInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClasses.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("callableReferencesWithInlineClassesGeneric.kt")
        public void testCallableReferencesWithInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClassesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("castInsideWhenExpression.kt")
        public void testCastInsideWhenExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpression.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("castInsideWhenExpressionGeneric.kt")
        public void testCastInsideWhenExpressionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpressionGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctions.kt")
        public void testCheckBoxUnboxOfArgumentsOnInlinedFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctions.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctionsGeneric.kt")
        public void testCheckBoxUnboxOfArgumentsOnInlinedFunctionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctionsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingAfterAssertionOperator.kt")
        public void testCheckBoxingAfterAssertionOperator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperator.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingAfterAssertionOperatorGeneric.kt")
        public void testCheckBoxingAfterAssertionOperatorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperatorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingForComplexClassHierarchy.kt")
        public void testCheckBoxingForComplexClassHierarchy() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchy.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingForComplexClassHierarchyGeneric.kt")
        public void testCheckBoxingForComplexClassHierarchyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingForNonLocalAndLabeledReturns.kt")
        public void testCheckBoxingForNonLocalAndLabeledReturns() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturns.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingForNonLocalAndLabeledReturnsGeneric.kt")
        public void testCheckBoxingForNonLocalAndLabeledReturnsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturnsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingFromReturnTypeForInlineClasses.kt")
        public void testCheckBoxingFromReturnTypeForInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClasses.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingFromReturnTypeForInlineClassesGeneric.kt")
        public void testCheckBoxingFromReturnTypeForInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClassesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingOnFunctionCalls.kt")
        public void testCheckBoxingOnFunctionCalls() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCalls.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingOnFunctionCallsGeneric.kt")
        public void testCheckBoxingOnFunctionCallsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCallsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingOnLocalVariableAssignments.kt")
        public void testCheckBoxingOnLocalVariableAssignments() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignments.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingOnLocalVariableAssignmentsGeneric.kt")
        public void testCheckBoxingOnLocalVariableAssignmentsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignmentsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt")
        public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric.kt")
        public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkCallingMembersInsideInlineClass.kt")
        public void testCheckCallingMembersInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkCallingMembersInsideInlineClassGeneric.kt")
        public void testCheckCallingMembersInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkCastToInlineClass.kt")
        public void testCheckCastToInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkCastToInlineClassGeneric.kt")
        public void testCheckCastToInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkForInstanceOfInlineClass.kt")
        public void testCheckForInstanceOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkForInstanceOfInlineClassGeneric.kt")
        public void testCheckForInstanceOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkLambdaWithInlineClassesInFunctionalType.kt")
        public void testCheckLambdaWithInlineClassesInFunctionalType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkLambdaWithInlineClassesInFunctionalTypeGeneric.kt")
        public void testCheckLambdaWithInlineClassesInFunctionalTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkUnboxingResultFromTypeVariable.kt")
        public void testCheckUnboxingResultFromTypeVariable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariable.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkUnboxingResultFromTypeVariableGeneric.kt")
        public void testCheckUnboxingResultFromTypeVariableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariableGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("checkUnboxingResultFromTypeVariableGeneric2.kt")
        public void testCheckUnboxingResultFromTypeVariableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariableGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("classInInlineClassInit.kt")
        public void testClassInInlineClassInit() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classInInlineClassInit.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("classInInlineClassInitGeneric.kt")
        public void testClassInInlineClassInitGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classInInlineClassInitGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("computablePropertyInsideInlineClass.kt")
        public void testComputablePropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/computablePropertyInsideInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("conformToComparableAndCallInterfaceMethod.kt")
        public void testConformToComparableAndCallInterfaceMethod() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethod.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("conformToComparableAndCallInterfaceMethodGeneric.kt")
        public void testConformToComparableAndCallInterfaceMethodGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethodGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("constructorCallableReference.kt")
        public void testConstructorCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorCallableReference.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("constructorCallableReferenceGeneric.kt")
        public void testConstructorCallableReferenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorCallableReferenceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("correctBoxingForBranchExpressions.kt")
        public void testCorrectBoxingForBranchExpressions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressions.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("correctBoxingForBranchExpressionsGeneric.kt")
        public void testCorrectBoxingForBranchExpressionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressionsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("createInlineClassInArgumentPosition.kt")
        public void testCreateInlineClassInArgumentPosition() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPosition.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("createInlineClassInArgumentPositionGeneric.kt")
        public void testCreateInlineClassInArgumentPositionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPositionGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("crossinlineWithInlineClassInParameter.kt")
        public void testCrossinlineWithInlineClassInParameter() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameter.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("crossinlineWithInlineClassInParameterGeneric.kt")
        public void testCrossinlineWithInlineClassInParameterGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameterGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("crossinlineWithInlineClassInParameterGeneric2.kt")
        public void testCrossinlineWithInlineClassInParameterGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameterGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("customIterator.kt")
        public void testCustomIterator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/customIterator.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("defaultFunctionsFromAnyForInlineClass.kt")
        public void testDefaultFunctionsFromAnyForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("defaultFunctionsFromAnyForInlineClassGeneric.kt")
        public void testDefaultFunctionsFromAnyForInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("defaultInterfaceMethodsInInlineClass.kt")
        public void testDefaultInterfaceMethodsInInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultInterfaceMethodsInInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("defaultInterfaceMethodsInInlineClassGeneric.kt")
        public void testDefaultInterfaceMethodsInInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultInterfaceMethodsInInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("defaultWithInlineClassArgument.kt")
        public void testDefaultWithInlineClassArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultWithInlineClassArgument.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("defaultWithInlineClassArgumentGeneric.kt")
        public void testDefaultWithInlineClassArgumentGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultWithInlineClassArgumentGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("elvisWithInlineClassAndNullConstant.kt")
        public void testElvisWithInlineClassAndNullConstant() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstant.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("elvisWithInlineClassAndNullConstantGeneric.kt")
        public void testElvisWithInlineClassAndNullConstantGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstantGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("emptyConstructorForInlineClass.kt")
        public void testEmptyConstructorForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("emptyConstructorForInlineClassGeneric.kt")
        public void testEmptyConstructorForInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksInlineClassNonNull.kt")
        public void testEqualityChecksInlineClassNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksInlineClassNonNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksInlineClassNonNullGeneric.kt")
        public void testEqualityChecksInlineClassNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksInlineClassNonNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksMixedNullability.kt")
        public void testEqualityChecksMixedNullability() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksMixedNullability.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksMixedNullabilityGeneric.kt")
        public void testEqualityChecksMixedNullabilityGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksMixedNullabilityGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedInlineClassNonNull.kt")
        public void testEqualityChecksNegatedInlineClassNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedInlineClassNonNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedInlineClassNonNullGeneric.kt")
        public void testEqualityChecksNegatedInlineClassNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedInlineClassNonNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedNonNull.kt")
        public void testEqualityChecksNegatedNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNonNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedNonNullGeneric.kt")
        public void testEqualityChecksNegatedNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNonNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedNullable.kt")
        public void testEqualityChecksNegatedNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullable.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedNullableGeneric.kt")
        public void testEqualityChecksNegatedNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullableGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedNullableGeneric2.kt")
        public void testEqualityChecksNegatedNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullableGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedPrimitive.kt")
        public void testEqualityChecksNegatedPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedPrimitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNegatedPrimitiveGeneric.kt")
        public void testEqualityChecksNegatedPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedPrimitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNonNull.kt")
        public void testEqualityChecksNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNonNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNonNullGeneric.kt")
        public void testEqualityChecksNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNonNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNullable.kt")
        public void testEqualityChecksNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullable.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNullableGeneric.kt")
        public void testEqualityChecksNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullableGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksNullableGeneric2.kt")
        public void testEqualityChecksNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullableGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksPrimitive.kt")
        public void testEqualityChecksPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityChecksPrimitiveGeneric.kt")
        public void testEqualityChecksPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClass.kt")
        public void testEqualityForBoxesOfNullableValuesOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClassGeneric.kt")
        public void testEqualityForBoxesOfNullableValuesOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsCallsLeftArgument.kt")
        public void testEqualsCallsLeftArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsCallsLeftArgument.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsCallsLeftArgumentGeneric.kt")
        public void testEqualsCallsLeftArgumentGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsCallsLeftArgumentGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderInlineClass.kt")
        public void testEqualsEvaluationOrderInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderInlineClassGeneric.kt")
        public void testEqualsEvaluationOrderInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderNonNull.kt")
        public void testEqualsEvaluationOrderNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNonNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderNonNullGeneric.kt")
        public void testEqualsEvaluationOrderNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNonNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderNullable.kt")
        public void testEqualsEvaluationOrderNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullable.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderNullableGeneric.kt")
        public void testEqualsEvaluationOrderNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullableGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderNullableGeneric2.kt")
        public void testEqualsEvaluationOrderNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullableGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderPrimitive.kt")
        public void testEqualsEvaluationOrderPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderPrimitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsEvaluationOrderPrimitiveGeneric.kt")
        public void testEqualsEvaluationOrderPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderPrimitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsOperatorWithGenericCall.kt")
        public void testEqualsOperatorWithGenericCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("equalsOperatorWithGenericCallGeneric.kt")
        public void testEqualsOperatorWithGenericCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("extLambdaInInlineClassFun.kt")
        public void testExtLambdaInInlineClassFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("extLambdaInInlineClassFun2.kt")
        public void testExtLambdaInInlineClassFun2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("extLambdaInInlineClassFun2Generic.kt")
        public void testExtLambdaInInlineClassFun2Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("extLambdaInInlineClassFunGeneric.kt")
        public void testExtLambdaInInlineClassFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("fieldNameClash.kt")
        public void testFieldNameClash() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/fieldNameClash.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("fieldNameClashGeneric.kt")
        public void testFieldNameClashGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/fieldNameClashGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("funInterfaceDoubleSuffux.kt")
        public void testFunInterfaceDoubleSuffux() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/funInterfaceDoubleSuffux.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("funInterfaceDoubleSuffux2.kt")
        public void testFunInterfaceDoubleSuffux2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/funInterfaceDoubleSuffux2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/functionExpression.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("functionExpressionGeneric.kt")
        public void testFunctionExpressionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/functionExpressionGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("genericInlineClassSynthMembers.kt")
        public void testGenericInlineClassSynthMembers() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/genericInlineClassSynthMembers.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("genericVararg2ndConstructor.kt")
        public void testGenericVararg2ndConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/genericVararg2ndConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("initBlock.kt")
        public void testInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/initBlock.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("initBlockGeneric.kt")
        public void testInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/initBlockGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassAsLastExpressionInInLambda.kt")
        public void testInlineClassAsLastExpressionInInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambda.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassAsLastExpressionInInLambdaGeneric.kt")
        public void testInlineClassAsLastExpressionInInLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambdaGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt")
        public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointData() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric.kt")
        public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassFieldHandling.kt")
        public void testInlineClassFieldHandling() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFieldHandling.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassFieldHandlingGeneric.kt")
        public void testInlineClassFieldHandlingGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFieldHandlingGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassFunctionInvoke.kt")
        public void testInlineClassFunctionInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvoke.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassFunctionInvokeGeneric.kt")
        public void testInlineClassFunctionInvokeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvokeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassInInitBlock.kt")
        public void testInlineClassInInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInInitBlock.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassInInitBlockGeneric.kt")
        public void testInlineClassInInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInInitBlockGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassInStringTemplate.kt")
        public void testInlineClassInStringTemplate() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplate.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassInStringTemplateGeneric.kt")
        public void testInlineClassInStringTemplateGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplateGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassPropertyReferenceGetAndSet.kt")
        public void testInlineClassPropertyReferenceGetAndSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSet.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassPropertyReferenceGetAndSetGeneric.kt")
        public void testInlineClassPropertyReferenceGetAndSetGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSetGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassValueCapturedInInlineLambda.kt")
        public void testInlineClassValueCapturedInInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambda.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassValueCapturedInInlineLambdaGeneric.kt")
        public void testInlineClassValueCapturedInInlineLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambdaGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassValueCapturedInNonInlineLambda.kt")
        public void testInlineClassValueCapturedInNonInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambda.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassValueCapturedInNonInlineLambdaGeneric.kt")
        public void testInlineClassValueCapturedInNonInlineLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambdaGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassValuesInsideStrings.kt")
        public void testInlineClassValuesInsideStrings() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStrings.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassValuesInsideStringsGeneric.kt")
        public void testInlineClassValuesInsideStringsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStringsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassWithCustomEquals.kt")
        public void testInlineClassWithCustomEquals() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEquals.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassWithCustomEqualsGeneric.kt")
        public void testInlineClassWithCustomEqualsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEqualsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassWithDefaultFunctionsFromAny.kt")
        public void testInlineClassWithDefaultFunctionsFromAny() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassWithDefaultFunctionsFromAnyGeneric.kt")
        public void testInlineClassWithDefaultFunctionsFromAnyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassesAsInlineFunParameters.kt")
        public void testInlineClassesAsInlineFunParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParameters.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassesAsInlineFunParametersGeneric.kt")
        public void testInlineClassesAsInlineFunParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParametersGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassesCheckCast.kt")
        public void testInlineClassesCheckCast() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCast.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassesCheckCastGeneric.kt")
        public void testInlineClassesCheckCastGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCastGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassesInInlineLambdaParameters.kt")
        public void testInlineClassesInInlineLambdaParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParameters.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassesInInlineLambdaParametersGeneric.kt")
        public void testInlineClassesInInlineLambdaParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParametersGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassesRefTypesInInlineLambdaParameters.kt")
        public void testInlineClassesRefTypesInInlineLambdaParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParameters.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineClassesRefTypesInInlineLambdaParametersGeneric.kt")
        public void testInlineClassesRefTypesInInlineLambdaParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParametersGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineExtLambdaInInlineClassFun.kt")
        public void testInlineExtLambdaInInlineClassFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineExtLambdaInInlineClassFun2.kt")
        public void testInlineExtLambdaInInlineClassFun2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineExtLambdaInInlineClassFun2Generic.kt")
        public void testInlineExtLambdaInInlineClassFun2Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineExtLambdaInInlineClassFunGeneric.kt")
        public void testInlineExtLambdaInInlineClassFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineFunctionInsideInlineClass.kt")
        public void testInlineFunctionInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("inlineFunctionInsideInlineClassGeneric.kt")
        public void testInlineFunctionInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("iterateOverArrayOfInlineClassValues.kt")
        public void testIterateOverArrayOfInlineClassValues() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValues.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("iterateOverArrayOfInlineClassValuesGeneric.kt")
        public void testIterateOverArrayOfInlineClassValuesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValuesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("iterateOverListOfInlineClassValues.kt")
        public void testIterateOverListOfInlineClassValues() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValues.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("iterateOverListOfInlineClassValuesGeneric.kt")
        public void testIterateOverListOfInlineClassValuesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValuesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("jvmInline.kt")
        public void testJvmInline() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmInline.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt25246.kt")
        public void testKt25246() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25246.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt25750.kt")
        public void testKt25750() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25750.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt25750Generic.kt")
        public void testKt25750Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25750Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt25771.kt")
        public void testKt25771() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25771.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt26103.kt")
        public void testKt26103() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt26103_contravariantUnderlyingType.kt")
        public void testKt26103_contravariantUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_contravariantUnderlyingType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt26103_covariantUnderlyingType.kt")
        public void testKt26103_covariantUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_covariantUnderlyingType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt26103_original.kt")
        public void testKt26103_original() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_original.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096.kt")
        public void testKt27096() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096Generic.kt")
        public void testKt27096Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_enum.kt")
        public void testKt27096_enum() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_enum.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_enumGeneric.kt")
        public void testKt27096_enumGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_enumGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_functional.kt")
        public void testKt27096_functional() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_functional.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_functionalGeneric.kt")
        public void testKt27096_functionalGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_functionalGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_innerClass.kt")
        public void testKt27096_innerClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_innerClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_nullablePrimitive.kt")
        public void testKt27096_nullablePrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_nullablePrimitiveGeneric.kt")
        public void testKt27096_nullablePrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_nullablePrimitiveGeneric2.kt")
        public void testKt27096_nullablePrimitiveGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitiveGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_nullableReference.kt")
        public void testKt27096_nullableReference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReference.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_nullableReferenceGeneric.kt")
        public void testKt27096_nullableReferenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReferenceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_nullableReferenceGeneric2.kt")
        public void testKt27096_nullableReferenceGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReferenceGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_primitive.kt")
        public void testKt27096_primitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_primitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_primitiveGeneric.kt")
        public void testKt27096_primitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_primitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_reference.kt")
        public void testKt27096_reference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_reference.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27096_referenceGeneric.kt")
        public void testKt27096_referenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_referenceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27113.kt")
        public void testKt27113() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27113a.kt")
        public void testKt27113a() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113a.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27113aGeneric.kt")
        public void testKt27113aGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113aGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27132.kt")
        public void testKt27132() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27132.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27132Generic.kt")
        public void testKt27132Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27132Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27140.kt")
        public void testKt27140() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27140.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27140Generic.kt")
        public void testKt27140Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27140Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27705.kt")
        public void testKt27705() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27705.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27705Generic.kt")
        public void testKt27705Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27705Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27706.kt")
        public void testKt27706() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27706.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt27706Generic.kt")
        public void testKt27706Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27706Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt28405.kt")
        public void testKt28405() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28405.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt28585.kt")
        public void testKt28585() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28585.kt");
        }

        @TestMetadata("kt31994.kt")
        public void testKt31994() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt31994.kt");
        }

        @TestMetadata("kt32793.kt")
        public void testKt32793() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt32793.kt");
        }

        @TestMetadata("kt33119.kt")
        public void testKt33119() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt33119.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt33119Generic.kt")
        public void testKt33119Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt33119Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt34268.kt")
        public void testKt34268() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt34268.kt");
        }

        @TestMetadata("kt34902.kt")
        public void testKt34902() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt34902.kt");
        }

        @TestMetadata("kt37998.kt")
        public void testKt37998() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt37998.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt37998Generic.kt")
        public void testKt37998Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt37998Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt38680.kt")
        public void testKt38680() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt38680Generic.kt")
        public void testKt38680Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt38680a.kt")
        public void testKt38680a() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680a.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt38680aGeneric.kt")
        public void testKt38680aGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680aGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt38680b.kt")
        public void testKt38680b() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680b.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt38680bGeneric.kt")
        public void testKt38680bGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680bGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt44141.kt")
        public void testKt44141() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44141.kt");
        }

        @TestMetadata("kt44867.kt")
        public void testKt44867() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44867.kt");
        }

        @TestMetadata("kt44978.kt")
        public void testKt44978() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44978.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt45084.kt")
        public void testKt45084() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45084.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt45084Generic.kt")
        public void testKt45084Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45084Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt45991.kt")
        public void testKt45991() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45991.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt46554.kt")
        public void testKt46554() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt46554.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt46554Generic.kt")
        public void testKt46554Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt46554Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt47762.kt")
        public void testKt47762() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt47762.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt47762Generic.kt")
        public void testKt47762Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt47762Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("kt51157.kt")
        public void testKt51157() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51157.kt");
        }

        @TestMetadata("kt51254.kt")
        public void testKt51254() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51254.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("mangledDefaultParameterFunction.kt")
        public void testMangledDefaultParameterFunction() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledDefaultParameterFunction.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("mangledDefaultParameterFunctionGeneric.kt")
        public void testMangledDefaultParameterFunctionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledDefaultParameterFunctionGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("mangledSuperCalls.kt")
        public void testMangledSuperCalls() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledSuperCalls.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("mangledSuperCallsGeneric.kt")
        public void testMangledSuperCallsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledSuperCallsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("multifileClass.kt")
        public void testMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/multifileClass.kt");
        }

        @TestMetadata("nestedInlineClass.kt")
        public void testNestedInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nestedInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("nestedInlineClassGeneric.kt")
        public void testNestedInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nestedInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("noAssertionsOnInlineClassBasedOnNullableType.kt")
        public void testNoAssertionsOnInlineClassBasedOnNullableType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noAssertionsOnInlineClassBasedOnNullableType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("noAssertionsOnInlineClassBasedOnNullableTypeGeneric.kt")
        public void testNoAssertionsOnInlineClassBasedOnNullableTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noAssertionsOnInlineClassBasedOnNullableTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("noReturnTypeMangling.kt")
        public void testNoReturnTypeMangling() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeMangling.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("noReturnTypeManglingGeneric.kt")
        public void testNoReturnTypeManglingGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeManglingGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("nullableEqeqNonNull.kt")
        public void testNullableEqeqNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableEqeqNonNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("nullableEqeqNonNullGeneric.kt")
        public void testNullableEqeqNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableEqeqNonNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("nullableWrapperEquality.kt")
        public void testNullableWrapperEquality() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEquality.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("nullableWrapperEqualityGeneric.kt")
        public void testNullableWrapperEqualityGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEqualityGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("nullableWrapperEqualityGeneric2.kt")
        public void testNullableWrapperEqualityGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEqualityGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("overrideReturnNothing.kt")
        public void testOverrideReturnNothing() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overrideReturnNothing.kt");
        }

        @TestMetadata("overridingFunCallingPrivateFun.kt")
        public void testOverridingFunCallingPrivateFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overridingFunCallingPrivateFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("overridingFunCallingPrivateFunGeneric.kt")
        public void testOverridingFunCallingPrivateFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overridingFunCallingPrivateFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("passInlineClassAsVararg.kt")
        public void testPassInlineClassAsVararg() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassAsVararg.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("passInlineClassAsVarargGeneric.kt")
        public void testPassInlineClassAsVarargGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassAsVarargGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("passInlineClassWithSpreadOperatorToVarargs.kt")
        public void testPassInlineClassWithSpreadOperatorToVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassWithSpreadOperatorToVarargs.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("passInlineClassWithSpreadOperatorToVarargsGeneric.kt")
        public void testPassInlineClassWithSpreadOperatorToVarargsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassWithSpreadOperatorToVarargsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("privateConstructorFunInterfaceMultiModule.kt")
        public void testPrivateConstructorFunInterfaceMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/privateConstructorFunInterfaceMultiModule.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("privateConstructorFunInterfaceMultiModuleGeneric.kt")
        public void testPrivateConstructorFunInterfaceMultiModuleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/privateConstructorFunInterfaceMultiModuleGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("propertyLoweringOrder.kt")
        public void testPropertyLoweringOrder() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/propertyLoweringOrder.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("propertyLoweringOrderGeneric.kt")
        public void testPropertyLoweringOrderGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/propertyLoweringOrderGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("referToPropertyInCompanionObjectOfInlineClass.kt")
        public void testReferToPropertyInCompanionObjectOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToPropertyInCompanionObjectOfInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("referToPropertyInCompanionObjectOfInlineClassGeneric.kt")
        public void testReferToPropertyInCompanionObjectOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToPropertyInCompanionObjectOfInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("referToUnderlyingPropertyInsideInlineClass.kt")
        public void testReferToUnderlyingPropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyInsideInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("referToUnderlyingPropertyInsideInlineClassGeneric.kt")
        public void testReferToUnderlyingPropertyInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyInsideInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("referToUnderlyingPropertyOfInlineClass.kt")
        public void testReferToUnderlyingPropertyOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyOfInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("referToUnderlyingPropertyOfInlineClassGeneric.kt")
        public void testReferToUnderlyingPropertyOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyOfInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("removeInInlineCollectionOfInlineClassAsInt.kt")
        public void testRemoveInInlineCollectionOfInlineClassAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/removeInInlineCollectionOfInlineClassAsInt.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("result.kt")
        public void testResult() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/result.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("resultGeneric.kt")
        public void testResultGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("resultGeneric2.kt")
        public void testResultGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("resultInlining.kt")
        public void testResultInlining() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultInlining.kt");
        }

        @TestMetadata("resultRunCatchingOrElse.kt")
        public void testResultRunCatchingOrElse() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultRunCatchingOrElse.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("safeAsOfTypeParameterWithInlineClassBound.kt")
        public void testSafeAsOfTypeParameterWithInlineClassBound() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/safeAsOfTypeParameterWithInlineClassBound.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("safeAsOfTypeParameterWithInlineClassBoundGeneric.kt")
        public void testSafeAsOfTypeParameterWithInlineClassBoundGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/safeAsOfTypeParameterWithInlineClassBoundGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("samWrapperDifferentModule.kt")
        public void testSamWrapperDifferentModule() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/samWrapperDifferentModule.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("samWrapperDifferentModuleGeneric.kt")
        public void testSamWrapperDifferentModuleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/samWrapperDifferentModuleGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("secondaryConstructorWithVararg.kt")
        public void testSecondaryConstructorWithVararg() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorWithVararg.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("secondaryConstructorWithVarargGeneric.kt")
        public void testSecondaryConstructorWithVarargGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorWithVarargGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("secondaryConstructorsInsideInlineClass.kt")
        public void testSecondaryConstructorsInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("secondaryConstructorsInsideInlineClassGeneric.kt")
        public void testSecondaryConstructorsInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("secondaryConstructorsInsideInlineClassWithPrimitiveCarrierType.kt")
        public void testSecondaryConstructorsInsideInlineClassWithPrimitiveCarrierType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassWithPrimitiveCarrierType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("secondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric.kt")
        public void testSecondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("simpleSecondaryConstructor.kt")
        public void testSimpleSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/simpleSecondaryConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("simpleSecondaryConstructorGeneric.kt")
        public void testSimpleSecondaryConstructorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/simpleSecondaryConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("smartCastOnThisOfInlineClassType.kt")
        public void testSmartCastOnThisOfInlineClassType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/smartCastOnThisOfInlineClassType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("smartCastOnThisOfInlineClassTypeGeneric.kt")
        public void testSmartCastOnThisOfInlineClassTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/smartCastOnThisOfInlineClassTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("stringPlus.kt")
        public void testStringPlus() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/stringPlus.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("stringPlusGeneric.kt")
        public void testStringPlusGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/stringPlusGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("toStringCallingPrivateFun.kt")
        public void testToStringCallingPrivateFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringCallingPrivateFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("toStringCallingPrivateFunGeneric.kt")
        public void testToStringCallingPrivateFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringCallingPrivateFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("toStringOfUnboxedNullable.kt")
        public void testToStringOfUnboxedNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringOfUnboxedNullable.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("toStringOfUnboxedNullableGeneric.kt")
        public void testToStringOfUnboxedNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringOfUnboxedNullableGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("typeChecksForInlineClasses.kt")
        public void testTypeChecksForInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/typeChecksForInlineClasses.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("typeChecksForInlineClassesGeneric.kt")
        public void testTypeChecksForInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/typeChecksForInlineClassesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("UIntArraySortExample.kt")
        public void testUIntArraySortExample() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntArraySortExample.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("UIntArraySortExampleGeneric.kt")
        public void testUIntArraySortExampleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntArraySortExampleGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("UIntSafeAsInt.kt")
        public void testUIntSafeAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntSafeAsInt.kt");
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithNonNullUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNonNullUnderlyingType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI.kt")
        public void testUnboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2.kt")
        public void testUnboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithPrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxParameterOfSuspendLambdaBeforeInvoke.kt")
        public void testUnboxParameterOfSuspendLambdaBeforeInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxParameterOfSuspendLambdaBeforeInvoke.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxParameterOfSuspendLambdaBeforeInvokeGeneric.kt")
        public void testUnboxParameterOfSuspendLambdaBeforeInvokeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxParameterOfSuspendLambdaBeforeInvokeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxReceiverOnCallingMethodFromInlineClass.kt")
        public void testUnboxReceiverOnCallingMethodFromInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxReceiverOnCallingMethodFromInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxReceiverOnCallingMethodFromInlineClassGeneric.kt")
        public void testUnboxReceiverOnCallingMethodFromInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxReceiverOnCallingMethodFromInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxResultParameterWhenCapturingToCrossinlineLambda.kt")
        public void testUnboxResultParameterWhenCapturingToCrossinlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxResultParameterWhenCapturingToCrossinlineLambda.kt");
        }

        @TestMetadata("unboxValueFromPlatformType.kt")
        public void testUnboxValueFromPlatformType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueFromPlatformType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxValueFromPlatformTypeGeneric.kt")
        public void testUnboxValueFromPlatformTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueFromPlatformTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxValueOfAnyBeforeMethodInvocation.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocation() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocation.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxValueOfAnyBeforeMethodInvocationGeneric.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocationGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocationGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("unboxValueOfAnyBeforeMethodInvocationGeneric2.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocationGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocationGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("useInlineClassesInsideElvisOperator.kt")
        public void testUseInlineClassesInsideElvisOperator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineClassesInsideElvisOperator.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("useInlineClassesInsideElvisOperatorGeneric.kt")
        public void testUseInlineClassesInsideElvisOperatorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineClassesInsideElvisOperatorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("useInlineFunctionInsideInlineClass.kt")
        public void testUseInlineFunctionInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineFunctionInsideInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("useInlineFunctionInsideInlineClassGeneric.kt")
        public void testUseInlineFunctionInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineFunctionInsideInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("useThisInsideInlineClass.kt")
        public void testUseThisInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useThisInsideInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("useThisInsideInlineClassGeneric.kt")
        public void testUseThisInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useThisInsideInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("whenWithSubject.kt")
        public void testWhenWithSubject() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/whenWithSubject.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("whenWithSubjectGeneric.kt")
        public void testWhenWithSubjectGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/whenWithSubjectGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BoxReturnValueInLambda extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBoxReturnValueInLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("boxAny.kt")
            public void testBoxAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxAnyGeneric.kt")
            public void testBoxAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxFunLiteralAny.kt")
            public void testBoxFunLiteralAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxFunLiteralAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxFunLiteralAnyGeneric.kt")
            public void testBoxFunLiteralAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxFunLiteralAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxInt.kt")
            public void testBoxInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxInt.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxIntGeneric.kt")
            public void testBoxIntGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxIntGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableAny.kt")
            public void testBoxNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableAnyGeneric.kt")
            public void testBoxNullableAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableAnyGeneric2.kt")
            public void testBoxNullableAnyGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableAnyNull.kt")
            public void testBoxNullableAnyNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableAnyNullGeneric.kt")
            public void testBoxNullableAnyNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableAnyNullGeneric2.kt")
            public void testBoxNullableAnyNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNullGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableInt.kt")
            public void testBoxNullableInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableInt.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableIntGeneric.kt")
            public void testBoxNullableIntGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableIntGeneric2.kt")
            public void testBoxNullableIntGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableIntNull.kt")
            public void testBoxNullableIntNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableIntNullGeneric.kt")
            public void testBoxNullableIntNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableIntNullGeneric2.kt")
            public void testBoxNullableIntNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNullGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableString.kt")
            public void testBoxNullableString() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableString.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableStringGeneric.kt")
            public void testBoxNullableStringGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableStringGeneric2.kt")
            public void testBoxNullableStringGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableStringNull.kt")
            public void testBoxNullableStringNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableStringNullGeneric.kt")
            public void testBoxNullableStringNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxNullableStringNullGeneric2.kt")
            public void testBoxNullableStringNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNullGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxString.kt")
            public void testBoxString() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxString.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxStringGeneric.kt")
            public void testBoxStringGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxStringGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt27586_1.kt")
            public void testKt27586_1() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/kt27586_1.kt");
            }

            @TestMetadata("kt27586_2.kt")
            public void testKt27586_2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/kt27586_2.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BoxReturnValueOnOverride extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBoxReturnValueOnOverride() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("boxReturnValueInDefaultMethod.kt")
            public void testBoxReturnValueInDefaultMethod() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/boxReturnValueInDefaultMethod.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boxReturnValueInDefaultMethodGenericInt.kt")
            public void testBoxReturnValueInDefaultMethodGenericInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/boxReturnValueInDefaultMethodGenericInt.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideChainErasedToAny.kt")
            public void testCovariantOverrideChainErasedToAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideChainErasedToAnyGeneric.kt")
            public void testCovariantOverrideChainErasedToAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideChainErasedToNullableAny.kt")
            public void testCovariantOverrideChainErasedToNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideChainErasedToNullableAnyGeneric.kt")
            public void testCovariantOverrideChainErasedToNullableAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideChainErasedToNullableAnyGeneric2.kt")
            public void testCovariantOverrideChainErasedToNullableAnyGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAnyGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideErasedToAny.kt")
            public void testCovariantOverrideErasedToAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideErasedToAnyGeneric.kt")
            public void testCovariantOverrideErasedToAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideErasedToInterface.kt")
            public void testCovariantOverrideErasedToInterface() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToInterface.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideErasedToInterfaceGeneric.kt")
            public void testCovariantOverrideErasedToInterfaceGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToInterfaceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideErasedToPrimitive.kt")
            public void testCovariantOverrideErasedToPrimitive() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToPrimitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideErasedToPrimitiveGeneric.kt")
            public void testCovariantOverrideErasedToPrimitiveGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToPrimitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideListVsMutableList.kt")
            public void testCovariantOverrideListVsMutableList() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideListVsMutableList.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideListVsMutableListGeneric.kt")
            public void testCovariantOverrideListVsMutableListGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideListVsMutableListGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideUnrelatedInterfaces.kt")
            public void testCovariantOverrideUnrelatedInterfaces() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideUnrelatedInterfaces.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("covariantOverrideUnrelatedInterfacesGeneric.kt")
            public void testCovariantOverrideUnrelatedInterfacesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideUnrelatedInterfacesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericOverride.kt")
            public void testGenericOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverride.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericOverrideGeneric.kt")
            public void testGenericOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericOverrideSpecialized.kt")
            public void testGenericOverrideSpecialized() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideSpecialized.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericOverrideSpecializedGeneric.kt")
            public void testGenericOverrideSpecializedGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideSpecializedGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassInOverriddenReturnTypes.kt")
            public void testInlineClassInOverriddenReturnTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/inlineClassInOverriddenReturnTypes.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassInOverriddenReturnTypesGeneric.kt")
            public void testInlineClassInOverriddenReturnTypesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/inlineClassInOverriddenReturnTypesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt28483.kt")
            public void testKt28483() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt28483Generic.kt")
            public void testKt28483Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt28483Generic2.kt")
            public void testKt28483Generic2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483Generic2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt31585.kt")
            public void testKt31585() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt31585.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt31585Generic.kt")
            public void testKt31585Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt31585Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt35234.kt")
            public void testKt35234() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt35234Generic.kt")
            public void testKt35234Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt35234a.kt")
            public void testKt35234a() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234a.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithInlineClass.kt")
            public void testOverrideGenericWithInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithInlineClassGeneric.kt")
            public void testOverrideGenericWithInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullAny.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG2.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNull.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullAny.kt")
            public void testOverrideNullableInlineClassWithNonNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullAnyGeneric.kt")
            public void testOverrideNullableInlineClassWithNonNullAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAny.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyGeneric.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyGeneric2.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyNull.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyNull.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyNullGeneric.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyNullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyNullGeneric2.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyNullGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("relatedReturnTypes1a.kt")
            public void testRelatedReturnTypes1a() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes1a.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("relatedReturnTypes1aGeneric.kt")
            public void testRelatedReturnTypes1aGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes1aGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("relatedReturnTypes1b.kt")
            public void testRelatedReturnTypes1b() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes1b.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("relatedReturnTypes1bGeneric.kt")
            public void testRelatedReturnTypes1bGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes1bGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("relatedReturnTypes2a.kt")
            public void testRelatedReturnTypes2a() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes2a.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("relatedReturnTypes2aGeneric.kt")
            public void testRelatedReturnTypes2aGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes2aGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("relatedReturnTypes2b.kt")
            public void testRelatedReturnTypes2b() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes2b.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("relatedReturnTypes2bGeneric.kt")
            public void testRelatedReturnTypes2bGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes2bGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("uncastInlineClassToAnyAndBack.kt")
            public void testUncastInlineClassToAnyAndBack() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/uncastInlineClassToAnyAndBack.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("uncastInlineClassToAnyAndBackGeneric.kt")
            public void testUncastInlineClassToAnyAndBackGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/uncastInlineClassToAnyAndBackGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("unrelatedGenerics.kt")
            public void testUnrelatedGenerics() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/unrelatedGenerics.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("unrelatedGenericsGeneric.kt")
            public void testUnrelatedGenericsGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/unrelatedGenericsGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/callableReferences")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallableReferences extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInCallableReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/callableReferences"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("boundInlineClassExtensionFun.kt")
            public void testBoundInlineClassExtensionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassExtensionFunGeneric.kt")
            public void testBoundInlineClassExtensionFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassExtensionVal.kt")
            public void testBoundInlineClassExtensionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassExtensionValGeneric.kt")
            public void testBoundInlineClassExtensionValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassMemberFun.kt")
            public void testBoundInlineClassMemberFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassMemberFunGeneric.kt")
            public void testBoundInlineClassMemberFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassMemberVal.kt")
            public void testBoundInlineClassMemberVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassMemberValGeneric.kt")
            public void testBoundInlineClassMemberValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassPrimaryVal.kt")
            public void testBoundInlineClassPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassPrimaryVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("boundInlineClassPrimaryValGeneric.kt")
            public void testBoundInlineClassPrimaryValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassPrimaryValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("constructorWithInlineClassParameters.kt")
            public void testConstructorWithInlineClassParameters() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/constructorWithInlineClassParameters.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("constructorWithInlineClassParametersGeneric.kt")
            public void testConstructorWithInlineClassParametersGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/constructorWithInlineClassParametersGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("equalsHashCodeToString.kt")
            public void testEqualsHashCodeToString() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/equalsHashCodeToString.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("equalsHashCodeToStringGeneric.kt")
            public void testEqualsHashCodeToStringGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/equalsHashCodeToStringGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("funWithInlineClassParameters.kt")
            public void testFunWithInlineClassParameters() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/funWithInlineClassParameters.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("funWithInlineClassParametersGeneric.kt")
            public void testFunWithInlineClassParametersGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/funWithInlineClassParametersGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassExtensionFun.kt")
            public void testInlineClassExtensionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassExtensionFunGeneric.kt")
            public void testInlineClassExtensionFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassExtensionVal.kt")
            public void testInlineClassExtensionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassExtensionValGeneric.kt")
            public void testInlineClassExtensionValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassInternalPrimaryVal.kt")
            public void testInlineClassInternalPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassInternalPrimaryVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassInternalPrimaryValGeneric.kt")
            public void testInlineClassInternalPrimaryValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassInternalPrimaryValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassMemberFun.kt")
            public void testInlineClassMemberFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassMemberFunGeneric.kt")
            public void testInlineClassMemberFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassMemberVal.kt")
            public void testInlineClassMemberVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassMemberValGeneric.kt")
            public void testInlineClassMemberValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrimaryConstructor.kt")
            public void testInlineClassPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrimaryConstructorGeneric.kt")
            public void testInlineClassPrimaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrimaryVal.kt")
            public void testInlineClassPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrimaryValGeneric.kt")
            public void testInlineClassPrimaryValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrivatePrimaryVal.kt")
            public void testInlineClassPrivatePrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrivatePrimaryVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrivatePrimaryValGeneric.kt")
            public void testInlineClassPrivatePrimaryValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrivatePrimaryValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassTypeBoundMemberVar.kt")
            public void testInlineClassTypeBoundMemberVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeBoundMemberVar.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassTypeBoundMemberVarGeneric.kt")
            public void testInlineClassTypeBoundMemberVarGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeBoundMemberVarGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassTypeMemberVar.kt")
            public void testInlineClassTypeMemberVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeMemberVar.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassTypeMemberVarGeneric.kt")
            public void testInlineClassTypeMemberVarGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeMemberVarGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassTypeTopLevelVar.kt")
            public void testInlineClassTypeTopLevelVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeTopLevelVar.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassTypeTopLevelVarGeneric.kt")
            public void testInlineClassTypeTopLevelVarGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeTopLevelVarGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt37986.kt")
            public void testKt37986() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/kt37986.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt37986Generic.kt")
            public void testKt37986Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/kt37986Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/callableReferences/let")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Let extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                    KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInLet() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/callableReferences/let"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/any.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyGeneric.kt")
                public void testAnyGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/anyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/anyN.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyNGeneric.kt")
                public void testAnyNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/anyNGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyNGeneric2.kt")
                public void testAnyNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/anyNGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("int.kt")
                public void testInt() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/int.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("intGeneric.kt")
                public void testIntGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/intGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("intN.kt")
                public void testIntN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/intN.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("intNGeneric.kt")
                public void testIntNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/intNGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("intNGeneric2.kt")
                public void testIntNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/intNGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("null.kt")
                public void testNull() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/null.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("nullGeneric.kt")
                public void testNullGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/nullGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("result.kt")
                public void testResult() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/result.kt");
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/string.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("stringGeneric.kt")
                public void testStringGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/stringGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("stringN.kt")
                public void testStringN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/stringN.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("stringNGeneric.kt")
                public void testStringNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/stringNGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("stringNGeneric2.kt")
                public void testStringNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/stringNGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ContextsAndAccessors extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethod.kt")
            public void testAccessPrivateInlineClassCompanionMethod() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethod.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethod2.kt")
            public void testAccessPrivateInlineClassCompanionMethod2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethod2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethod2Generic.kt")
            public void testAccessPrivateInlineClassCompanionMethod2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethod2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethodGeneric.kt")
            public void testAccessPrivateInlineClassCompanionMethodGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethodGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromCompanion.kt")
            public void testAccessPrivateInlineClassConstructorFromCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromCompanion.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromCompanionGeneric.kt")
            public void testAccessPrivateInlineClassConstructorFromCompanionGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromCompanionGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromLambda.kt")
            public void testAccessPrivateInlineClassConstructorFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromLambda.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromLambdaGeneric.kt")
            public void testAccessPrivateInlineClassConstructorFromLambdaGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromLambdaGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanion.kt")
            public void testAccessPrivateInlineClassMethodFromCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanion.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanion2.kt")
            public void testAccessPrivateInlineClassMethodFromCompanion2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanion2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanion2Generic.kt")
            public void testAccessPrivateInlineClassMethodFromCompanion2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanion2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanionGeneric.kt")
            public void testAccessPrivateInlineClassMethodFromCompanionGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanionGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambda.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambda.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambda2.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambda2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambda2Generic.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambda2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambda2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambdaGeneric.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambdaGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambdaGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambda.kt")
            public void testAccessPrivateInlineClassMethodFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambda.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambda2.kt")
            public void testAccessPrivateInlineClassMethodFromLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambda2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambda2Generic.kt")
            public void testAccessPrivateInlineClassMethodFromLambda2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambda2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambdaGeneric.kt")
            public void testAccessPrivateInlineClassMethodFromLambdaGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambdaGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            public void testAllFilesPresentInContextsAndAccessors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("captureInlineClassInstanceInLambda.kt")
            public void testCaptureInlineClassInstanceInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambda.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("captureInlineClassInstanceInLambda2.kt")
            public void testCaptureInlineClassInstanceInLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambda2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("captureInlineClassInstanceInLambda2Generic.kt")
            public void testCaptureInlineClassInstanceInLambda2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambda2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("captureInlineClassInstanceInLambdaGeneric.kt")
            public void testCaptureInlineClassInstanceInLambdaGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambdaGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("captureInlineClassInstanceInObject.kt")
            public void testCaptureInlineClassInstanceInObject() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInObject.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("captureInlineClassInstanceInObjectGeneric.kt")
            public void testCaptureInlineClassInstanceInObjectGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInObjectGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineLambdaInInlineClassFun.kt")
            public void testInlineLambdaInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/inlineLambdaInInlineClassFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineLambdaInInlineClassFunGeneric.kt")
            public void testInlineLambdaInInlineClassFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/inlineLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt26858.kt")
            public void testKt26858() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt26858.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt26858Generic.kt")
            public void testKt26858Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt26858Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt27513.kt")
            public void testKt27513() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt27513.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt27513Generic.kt")
            public void testKt27513Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt27513Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt30780.kt")
            public void testKt30780() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt30780.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt30780Generic.kt")
            public void testKt30780Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt30780Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("lambdaInInlineClassFun.kt")
            public void testLambdaInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/lambdaInInlineClassFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("lambdaInInlineClassFunGeneric.kt")
            public void testLambdaInInlineClassFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/lambdaInInlineClassFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("objectInInlineClassFun.kt")
            public void testObjectInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/objectInInlineClassFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("objectInInlineClassFunGeneric.kt")
            public void testObjectInInlineClassFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/objectInInlineClassFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("toPrivateCompanionFun.kt")
            public void testToPrivateCompanionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("toPrivateCompanionFunGeneric.kt")
            public void testToPrivateCompanionFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("toPrivateCompanionVal.kt")
            public void testToPrivateCompanionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionVal.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("toPrivateCompanionValGeneric.kt")
            public void testToPrivateCompanionValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionValGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/defaultParameterValues")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultParameterValues extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultParameterValues() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/defaultParameterValues"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("defaultConstructorParameterValuesOfInlineClassType.kt")
            public void testDefaultConstructorParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultConstructorParameterValuesOfInlineClassType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultConstructorParameterValuesOfInlineClassTypeGeneric.kt")
            public void testDefaultConstructorParameterValuesOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultConstructorParameterValuesOfInlineClassTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultInterfaceFunParameterValuesOfInlineClassType.kt")
            public void testDefaultInterfaceFunParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultInterfaceFunParameterValuesOfInlineClassType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultInterfaceFunParameterValuesOfInlineClassTypeGeneric.kt")
            public void testDefaultInterfaceFunParameterValuesOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultInterfaceFunParameterValuesOfInlineClassTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultParameterValuesOfInlineClassType.kt")
            public void testDefaultParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultParameterValuesOfInlineClassTypeBoxing.kt")
            public void testDefaultParameterValuesOfInlineClassTypeBoxing() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassTypeBoxing.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultParameterValuesOfInlineClassTypeBoxingGeneric.kt")
            public void testDefaultParameterValuesOfInlineClassTypeBoxingGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassTypeBoxingGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultParameterValuesOfInlineClassTypeGeneric.kt")
            public void testDefaultParameterValuesOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFun.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFunGeneric.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFunInInlineClass.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFunInInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFunInInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFunInInlineClassGeneric.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFunInInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFunInInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassFun.kt")
            public void testInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassFun.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassFunGeneric.kt")
            public void testInlineClassFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassFunGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrimaryConstructor.kt")
            public void testInlineClassPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrimaryConstructorGeneric.kt")
            public void testInlineClassPrimaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrimaryConstructorWithInlineClassValue.kt")
            public void testInlineClassPrimaryConstructorWithInlineClassValue() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructorWithInlineClassValue.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassPrimaryConstructorWithInlineClassValueGeneric.kt")
            public void testInlineClassPrimaryConstructorWithInlineClassValueGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructorWithInlineClassValueGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassSecondaryConstructor.kt")
            public void testInlineClassSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassSecondaryConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineClassSecondaryConstructorGeneric.kt")
            public void testInlineClassSecondaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassSecondaryConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt26554.kt")
            public void testKt26554() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/kt26554.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt27416.kt")
            public void testKt27416() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/kt27416.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt27416Generic.kt")
            public void testKt27416Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/kt27416Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DefaultWithDefaultParameter extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInDefaultWithDefaultParameter() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OverrideFunctionWithDefaultParameter extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInOverrideFunctionWithDefaultParameter() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DelegationByUnderlyingType extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDelegationByUnderlyingType() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("default.kt")
            public void testDefault() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/default.kt");
            }

            @TestMetadata("defaultArgument.kt")
            public void testDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/defaultArgument.kt");
            }

            @TestMetadata("defaultArgumentGeneric.kt")
            public void testDefaultArgumentGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/defaultArgumentGeneric.kt");
            }

            @TestMetadata("defaultGeneric.kt")
            public void testDefaultGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/defaultGeneric.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/simple.kt");
            }

            @TestMetadata("simpleGeneric.kt")
            public void testSimpleGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/simpleGeneric.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/funInterface")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunInterface extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInFunInterface() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/funInterface"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("argumentIC.kt")
            public void testArgumentIC() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/argumentIC.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("argumentICGeneric.kt")
            public void testArgumentICGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/argumentICGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("argumentICGeneric2.kt")
            public void testArgumentICGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/argumentICGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("argumentResult.kt")
            public void testArgumentResult() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/argumentResult.kt");
            }

            @TestMetadata("kt51121.kt")
            public void testKt51121() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/kt51121.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt51121_2.kt")
            public void testKt51121_2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/kt51121_2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mangledSamWrappers.kt")
            public void testMangledSamWrappers() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/mangledSamWrappers.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mangledSamWrappersGeneric.kt")
            public void testMangledSamWrappersGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/mangledSamWrappersGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("returnIC.kt")
            public void testReturnIC() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/returnIC.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("returnICGeneric.kt")
            public void testReturnICGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/returnICGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("returnICGeneric2.kt")
            public void testReturnICGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/returnICGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("returnResult.kt")
            public void testReturnResult() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/returnResult.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/functionNameMangling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionNameMangling extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionNameMangling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/functionNameMangling"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("anonymousObjectInFunctionWithMangledName.kt")
            public void testAnonymousObjectInFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/anonymousObjectInFunctionWithMangledName.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("anonymousObjectInFunctionWithMangledNameGeneric.kt")
            public void testAnonymousObjectInFunctionWithMangledNameGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/anonymousObjectInFunctionWithMangledNameGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("extensionFunctionsDoNotClash.kt")
            public void testExtensionFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/extensionFunctionsDoNotClash.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("extensionFunctionsDoNotClashGeneric.kt")
            public void testExtensionFunctionsDoNotClashGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/extensionFunctionsDoNotClashGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("functionsWithDifferentNullabilityDoNotClash.kt")
            public void testFunctionsWithDifferentNullabilityDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/functionsWithDifferentNullabilityDoNotClash.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("functionsWithDifferentNullabilityDoNotClashGeneric.kt")
            public void testFunctionsWithDifferentNullabilityDoNotClashGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/functionsWithDifferentNullabilityDoNotClashGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericFunctionsDoNotClash.kt")
            public void testGenericFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/genericFunctionsDoNotClash.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericFunctionsDoNotClashGeneric.kt")
            public void testGenericFunctionsDoNotClashGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/genericFunctionsDoNotClashGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("localClassInFunctionWithMangledName.kt")
            public void testLocalClassInFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/localClassInFunctionWithMangledName.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("localClassInFunctionWithMangledNameGeneric.kt")
            public void testLocalClassInFunctionWithMangledNameGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/localClassInFunctionWithMangledNameGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mangledFunctionsCanBeOverridden.kt")
            public void testMangledFunctionsCanBeOverridden() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsCanBeOverridden.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mangledFunctionsCanBeOverriddenGeneric.kt")
            public void testMangledFunctionsCanBeOverriddenGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsCanBeOverriddenGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mangledFunctionsDoNotClash.kt")
            public void testMangledFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsDoNotClash.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mangledFunctionsDoNotClashGeneric.kt")
            public void testMangledFunctionsDoNotClashGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsDoNotClashGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mangledFunctionsPresentInStackTrace.kt")
            public void testMangledFunctionsPresentInStackTrace() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsPresentInStackTrace.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mangledFunctionsPresentInStackTraceGeneric.kt")
            public void testMangledFunctionsPresentInStackTraceGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsPresentInStackTraceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mixedSignatureFunctionsDoNotClash.kt")
            public void testMixedSignatureFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mixedSignatureFunctionsDoNotClash.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("mixedSignatureFunctionsDoNotClashGeneric.kt")
            public void testMixedSignatureFunctionsDoNotClashGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mixedSignatureFunctionsDoNotClashGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overridingMethodInGenericClass.kt")
            public void testOverridingMethodInGenericClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/overridingMethodInGenericClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overridingMethodInGenericClass2.kt")
            public void testOverridingMethodInGenericClass2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/overridingMethodInGenericClass2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overridingMethodInGenericClass2Generic.kt")
            public void testOverridingMethodInGenericClass2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/overridingMethodInGenericClass2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overridingMethodInGenericClassGeneric.kt")
            public void testOverridingMethodInGenericClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/overridingMethodInGenericClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("propertySetterWithInlineClassTypeArgument.kt")
            public void testPropertySetterWithInlineClassTypeArgument() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/propertySetterWithInlineClassTypeArgument.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("propertySetterWithInlineClassTypeArgumentGeneric.kt")
            public void testPropertySetterWithInlineClassTypeArgumentGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/propertySetterWithInlineClassTypeArgumentGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("reflectionForFunctionWithMangledName.kt")
            public void testReflectionForFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/reflectionForFunctionWithMangledName.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("reflectionForFunctionWithMangledNameGeneric.kt")
            public void testReflectionForFunctionWithMangledNameGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/reflectionForFunctionWithMangledNameGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("reflectionForPropertyOfInlineClassType.kt")
            public void testReflectionForPropertyOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/reflectionForPropertyOfInlineClassType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("reflectionForPropertyOfInlineClassTypeGeneric.kt")
            public void testReflectionForPropertyOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/reflectionForPropertyOfInlineClassTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("syntheticAccessorForFunctionWithMangledName.kt")
            public void testSyntheticAccessorForFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/syntheticAccessorForFunctionWithMangledName.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("syntheticAccessorForFunctionWithMangledNameGeneric.kt")
            public void testSyntheticAccessorForFunctionWithMangledNameGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/syntheticAccessorForFunctionWithMangledNameGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("syntheticAccessorsForPropertyOfInlineClassType.kt")
            public void testSyntheticAccessorsForPropertyOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/syntheticAccessorsForPropertyOfInlineClassType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("syntheticAccessorsForPropertyOfInlineClassTypeGeneric.kt")
            public void testSyntheticAccessorsForPropertyOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/syntheticAccessorsForPropertyOfInlineClassTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class GenericUnderlyingValue extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInGenericUnderlyingValue() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue/array.kt");
            }

            @TestMetadata("arrayIC.kt")
            public void testArrayIC() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue/arrayIC.kt");
            }

            @TestMetadata("primitive.kt")
            public void testPrimitive() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue/primitive.kt");
            }

            @TestMetadata("recursive.kt")
            public void testRecursive() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue/recursive.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue/simple.kt");
            }

            @TestMetadata("simple2.kt")
            public void testSimple2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue/simple2.kt");
            }

            @TestMetadata("upperBound.kt")
            public void testUpperBound() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/genericUnderlyingValue/upperBound.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/hiddenConstructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class HiddenConstructor extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInHiddenConstructor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/hiddenConstructor"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("constructorReferencedFromOtherFile1.kt")
            public void testConstructorReferencedFromOtherFile1() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/constructorReferencedFromOtherFile1.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("constructorReferencedFromOtherFile1Generic.kt")
            public void testConstructorReferencedFromOtherFile1Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/constructorReferencedFromOtherFile1Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("constructorReferencedFromOtherFile2.kt")
            public void testConstructorReferencedFromOtherFile2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/constructorReferencedFromOtherFile2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("constructorReferencedFromOtherFile2Generic.kt")
            public void testConstructorReferencedFromOtherFile2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/constructorReferencedFromOtherFile2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("constructorWithDefaultParameters.kt")
            public void testConstructorWithDefaultParameters() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/constructorWithDefaultParameters.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("constructorWithDefaultParametersGeneric.kt")
            public void testConstructorWithDefaultParametersGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/constructorWithDefaultParametersGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatingSuperConstructorCall.kt")
            public void testDelegatingSuperConstructorCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingSuperConstructorCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatingSuperConstructorCallGeneric.kt")
            public void testDelegatingSuperConstructorCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingSuperConstructorCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatingSuperConstructorCallInSecondaryConstructor.kt")
            public void testDelegatingSuperConstructorCallInSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingSuperConstructorCallInSecondaryConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatingSuperConstructorCallInSecondaryConstructorGeneric.kt")
            public void testDelegatingSuperConstructorCallInSecondaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingSuperConstructorCallInSecondaryConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatingThisConstructorCall.kt")
            public void testDelegatingThisConstructorCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingThisConstructorCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatingThisConstructorCallGeneric.kt")
            public void testDelegatingThisConstructorCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingThisConstructorCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("enumClassConstructor.kt")
            public void testEnumClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/enumClassConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("enumClassConstructorGeneric.kt")
            public void testEnumClassConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/enumClassConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("innerClassConstructor.kt")
            public void testInnerClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/innerClassConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("innerClassConstructorGeneric.kt")
            public void testInnerClassConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/innerClassConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt28855.kt")
            public void testKt28855() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/kt28855.kt");
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/primaryConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("primaryConstructorGeneric.kt")
            public void testPrimaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/primaryConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("privateConstructor.kt")
            public void testPrivateConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/privateConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("privateConstructorGeneric.kt")
            public void testPrivateConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/privateConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("sealedClassConstructor.kt")
            public void testSealedClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/sealedClassConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("sealedClassConstructorGeneric.kt")
            public void testSealedClassConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/sealedClassConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/secondaryConstructor.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("secondaryConstructorGeneric.kt")
            public void testSecondaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/secondaryConstructorGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/inlineClassCollection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineClassCollection extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInlineClassCollection() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/inlineClassCollection"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("inlineCollectionOfInlineClass.kt")
            public void testInlineCollectionOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/inlineClassCollection/inlineCollectionOfInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineCollectionOfInlineClassGeneric.kt")
            public void testInlineCollectionOfInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/inlineClassCollection/inlineCollectionOfInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineListOfInlineClass.kt")
            public void testInlineListOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/inlineClassCollection/inlineListOfInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineListOfInlineClassGeneric.kt")
            public void testInlineListOfInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/inlineClassCollection/inlineListOfInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineMapOfInlineClass.kt")
            public void testInlineMapOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/inlineClassCollection/inlineMapOfInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("inlineMapOfInlineClassGeneric.kt")
            public void testInlineMapOfInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/inlineClassCollection/inlineMapOfInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/interfaceDelegation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InterfaceDelegation extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInterfaceDelegation() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/interfaceDelegation"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("interfaceImplementationByDelegation.kt")
            public void testInterfaceImplementationByDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/interfaceImplementationByDelegation.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("interfaceImplementationByDelegationGeneric.kt")
            public void testInterfaceImplementationByDelegationGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/interfaceImplementationByDelegationGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt38337.kt")
            public void testKt38337() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/kt38337.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt38337Generic.kt")
            public void testKt38337Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/kt38337Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberExtValDelegationWithInlineClassParameterTypes.kt")
            public void testMemberExtValDelegationWithInlineClassParameterTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberExtValDelegationWithInlineClassParameterTypes.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberExtValDelegationWithInlineClassParameterTypesGeneric.kt")
            public void testMemberExtValDelegationWithInlineClassParameterTypesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberExtValDelegationWithInlineClassParameterTypesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberExtVarDelegationWithInlineClassParameterTypes.kt")
            public void testMemberExtVarDelegationWithInlineClassParameterTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberExtVarDelegationWithInlineClassParameterTypes.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberFunDelegatedToInlineClassInt.kt")
            public void testMemberFunDelegatedToInlineClassInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberFunDelegatedToInlineClassInt.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberFunDelegatedToInlineClassIntGeneric.kt")
            public void testMemberFunDelegatedToInlineClassIntGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberFunDelegatedToInlineClassIntGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberFunDelegatedToInlineClassLong.kt")
            public void testMemberFunDelegatedToInlineClassLong() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberFunDelegatedToInlineClassLong.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberFunDelegatedToInlineClassLongGeneric.kt")
            public void testMemberFunDelegatedToInlineClassLongGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberFunDelegatedToInlineClassLongGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberFunDelegationToInlineClassWithInlineClassParameterTypes.kt")
            public void testMemberFunDelegationToInlineClassWithInlineClassParameterTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberFunDelegationToInlineClassWithInlineClassParameterTypes.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberFunDelegationToInlineClassWithInlineClassParameterTypesGeneric.kt")
            public void testMemberFunDelegationToInlineClassWithInlineClassParameterTypesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberFunDelegationToInlineClassWithInlineClassParameterTypesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberFunDelegationWithInlineClassParameterTypes.kt")
            public void testMemberFunDelegationWithInlineClassParameterTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberFunDelegationWithInlineClassParameterTypes.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("memberFunDelegationWithInlineClassParameterTypesGeneric.kt")
            public void testMemberFunDelegationWithInlineClassParameterTypesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceDelegation/memberFunDelegationWithInlineClassParameterTypesGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InterfaceMethodCalls extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInterfaceMethodCalls() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("complexGenericMethodWithInlineClassOverride.kt")
            public void testComplexGenericMethodWithInlineClassOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/complexGenericMethodWithInlineClassOverride.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("complexGenericMethodWithInlineClassOverride2.kt")
            public void testComplexGenericMethodWithInlineClassOverride2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/complexGenericMethodWithInlineClassOverride2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("complexGenericMethodWithInlineClassOverride2Generic.kt")
            public void testComplexGenericMethodWithInlineClassOverride2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/complexGenericMethodWithInlineClassOverride2Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("complexGenericMethodWithInlineClassOverride3.kt")
            public void testComplexGenericMethodWithInlineClassOverride3() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/complexGenericMethodWithInlineClassOverride3.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("complexGenericMethodWithInlineClassOverride3Generic.kt")
            public void testComplexGenericMethodWithInlineClassOverride3Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/complexGenericMethodWithInlineClassOverride3Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("complexGenericMethodWithInlineClassOverrideGeneric.kt")
            public void testComplexGenericMethodWithInlineClassOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/complexGenericMethodWithInlineClassOverrideGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultInterfaceExtensionFunCall.kt")
            public void testDefaultInterfaceExtensionFunCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/defaultInterfaceExtensionFunCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultInterfaceExtensionFunCallGeneric.kt")
            public void testDefaultInterfaceExtensionFunCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/defaultInterfaceExtensionFunCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultInterfaceMethodCall.kt")
            public void testDefaultInterfaceMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/defaultInterfaceMethodCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("defaultInterfaceMethodCallGeneric.kt")
            public void testDefaultInterfaceMethodCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/defaultInterfaceMethodCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericDefaultInterfaceExtensionFunCall.kt")
            public void testGenericDefaultInterfaceExtensionFunCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericDefaultInterfaceExtensionFunCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericDefaultInterfaceExtensionFunCallGeneric.kt")
            public void testGenericDefaultInterfaceExtensionFunCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericDefaultInterfaceExtensionFunCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericDefaultInterfaceMethodCall.kt")
            public void testGenericDefaultInterfaceMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericDefaultInterfaceMethodCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericDefaultInterfaceMethodCallGeneric.kt")
            public void testGenericDefaultInterfaceMethodCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericDefaultInterfaceMethodCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericInterfaceMethodCall.kt")
            public void testGenericInterfaceMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericInterfaceMethodCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericInterfaceMethodCallGeneric.kt")
            public void testGenericInterfaceMethodCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericInterfaceMethodCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericMethodWithInlineClassOverride.kt")
            public void testGenericMethodWithInlineClassOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericMethodWithInlineClassOverride.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("genericMethodWithInlineClassOverrideGeneric.kt")
            public void testGenericMethodWithInlineClassOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericMethodWithInlineClassOverrideGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("interfaceSuperCall.kt")
            public void testInterfaceSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/interfaceSuperCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("interfaceSuperCallGeneric.kt")
            public void testInterfaceSuperCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/interfaceSuperCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overriddenDefaultInterfaceMethodCall.kt")
            public void testOverriddenDefaultInterfaceMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/overriddenDefaultInterfaceMethodCall.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("overriddenDefaultInterfaceMethodCallGeneric.kt")
            public void testOverriddenDefaultInterfaceMethodCallGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/overriddenDefaultInterfaceMethodCallGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/javaInterop")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaInterop extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInJavaInterop() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/javaInterop"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/jvm8DefaultInterfaceMethods")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Jvm8DefaultInterfaceMethods extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInJvm8DefaultInterfaceMethods() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/jvm8DefaultInterfaceMethods"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/propertyDelegation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyDelegation extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInPropertyDelegation() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/propertyDelegation"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("captureLocalVarDelegatedToInlineClass.kt")
            public void testCaptureLocalVarDelegatedToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/captureLocalVarDelegatedToInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("captureLocalVarDelegatedToInlineClassGeneric.kt")
            public void testCaptureLocalVarDelegatedToInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/captureLocalVarDelegatedToInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateClassVarToInlineClass.kt")
            public void testDelegateClassVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateClassVarToInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateClassVarToInlineClassGeneric.kt")
            public void testDelegateClassVarToInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateClassVarToInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateClassVarToInlineClassWithProvideDelegate.kt")
            public void testDelegateClassVarToInlineClassWithProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateClassVarToInlineClassWithProvideDelegate.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateClassVarToInlineClassWithProvideDelegateGeneric.kt")
            public void testDelegateClassVarToInlineClassWithProvideDelegateGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateClassVarToInlineClassWithProvideDelegateGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateCompanionVarToInlineClass.kt")
            public void testDelegateCompanionVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateCompanionVarToInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateCompanionVarToInlineClassGeneric.kt")
            public void testDelegateCompanionVarToInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateCompanionVarToInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateLocalVarToInlineClass.kt")
            public void testDelegateLocalVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateLocalVarToInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateLocalVarToInlineClassGeneric.kt")
            public void testDelegateLocalVarToInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateLocalVarToInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateObjectVarToInlineClass.kt")
            public void testDelegateObjectVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateObjectVarToInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateObjectVarToInlineClassGeneric.kt")
            public void testDelegateObjectVarToInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateObjectVarToInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatePrivateCompanionVarToInlineClass.kt")
            public void testDelegatePrivateCompanionVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegatePrivateCompanionVarToInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatePrivateCompanionVarToInlineClassGeneric.kt")
            public void testDelegatePrivateCompanionVarToInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegatePrivateCompanionVarToInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateTopLevelVarToInlineClass.kt")
            public void testDelegateTopLevelVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateTopLevelVarToInlineClass.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegateTopLevelVarToInlineClassGeneric.kt")
            public void testDelegateTopLevelVarToInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateTopLevelVarToInlineClassGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatedPropertyOfInlineClassType.kt")
            public void testDelegatedPropertyOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegatedPropertyOfInlineClassType.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("delegatedPropertyOfInlineClassTypeGeneric.kt")
            public void testDelegatedPropertyOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegatedPropertyOfInlineClassTypeGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt27070.kt")
            public void testKt27070() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/kt27070.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt27070Generic.kt")
            public void testKt27070Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/kt27070Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt42933.kt")
            public void testKt42933() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/kt42933.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }

            @TestMetadata("kt42933Generic.kt")
            public void testKt42933Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/kt42933Generic.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/result")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Result extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInResult() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/result"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("directCall1.kt")
            public void testDirectCall1() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/result/directCall1.kt");
            }

            @TestMetadata("directCall2.kt")
            public void testDirectCall2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/result/directCall2.kt");
            }

            @TestMetadata("doubleOverride.kt")
            public void testDoubleOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/result/doubleOverride.kt");
            }

            @TestMetadata("extensionOverride.kt")
            public void testExtensionOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/result/extensionOverride.kt");
            }

            @TestMetadata("inlineMethodOnResult.kt")
            public void testInlineMethodOnResult() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/result/inlineMethodOnResult.kt");
            }

            @TestMetadata("lambdaTakesResultThroughBridge.kt")
            public void testLambdaTakesResultThroughBridge() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/result/lambdaTakesResultThroughBridge.kt");
            }

            @TestMetadata("returnGenericMultiModule.kt")
            public void testReturnGenericMultiModule() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/result/returnGenericMultiModule.kt");
            }

            @TestMetadata("returnGenericSingleModule.kt")
            public void testReturnGenericSingleModule() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/result/returnGenericSingleModule.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/returnResult")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReturnResult extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInReturnResult() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/returnResult"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("class.kt")
            public void testClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/returnResult/class.kt");
            }

            @TestMetadata("classAnyOverride.kt")
            public void testClassAnyOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/returnResult/classAnyOverride.kt");
            }

            @TestMetadata("classGenericOverride.kt")
            public void testClassGenericOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/returnResult/classGenericOverride.kt");
            }

            @TestMetadata("classResultOverride.kt")
            public void testClassResultOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/returnResult/classResultOverride.kt");
            }

            @TestMetadata("interface.kt")
            public void testInterface() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/returnResult/interface.kt");
            }

            @TestMetadata("topLevel.kt")
            public void testTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/returnResult/topLevel.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnboxGenericParameter extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInUnboxGenericParameter() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunInterface extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                    KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInFunInterface() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/any.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyGeneric.kt")
                public void testAnyGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/anyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/anyN.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyNGeneric.kt")
                public void testAnyNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/anyNGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyNGeneric2.kt")
                public void testAnyNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/anyNGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/iface.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/ifaceChild.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceChildGeneric.kt")
                public void testIfaceChildGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/ifaceChildGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceGeneric.kt")
                public void testIfaceGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/ifaceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("nullableResult.kt")
                public void testNullableResult() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/nullableResult.kt");
                }

                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/primitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("primitiveGeneric.kt")
                public void testPrimitiveGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/primitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("result.kt")
                public void testResult() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/result.kt");
                }

                @TestMetadata("resultAny.kt")
                public void testResultAny() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/resultAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("resultAnyGeneric.kt")
                public void testResultAnyGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/resultAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/string.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("stringGeneric.kt")
                public void testStringGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/funInterface/stringGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Lambda extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                    KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInLambda() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/any.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyGeneric.kt")
                public void testAnyGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/anyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/anyN.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyNGeneric.kt")
                public void testAnyNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/anyNGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyNGeneric2.kt")
                public void testAnyNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/anyNGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/iface.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/ifaceChild.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceChildGeneric.kt")
                public void testIfaceChildGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/ifaceChildGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceGeneric.kt")
                public void testIfaceGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/ifaceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("nullableResult.kt")
                public void testNullableResult() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/nullableResult.kt");
                }

                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/primitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("primitiveGeneric.kt")
                public void testPrimitiveGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/primitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("result.kt")
                public void testResult() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/result.kt");
                }

                @TestMetadata("resultAny.kt")
                public void testResultAny() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/resultAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("resultAnyGeneric.kt")
                public void testResultAnyGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/resultAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/string.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("stringGeneric.kt")
                public void testStringGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/lambda/stringGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ObjectLiteral extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                    KotlinTestUtils.runTest0(path -> doTestWithTransformer(path, transformer), TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInObjectLiteral() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/any.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyGeneric.kt")
                public void testAnyGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/anyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/anyN.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyNGeneric.kt")
                public void testAnyNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/anyNGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("anyNGeneric2.kt")
                public void testAnyNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/anyNGeneric2.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/iface.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/ifaceChild.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceChildGeneric.kt")
                public void testIfaceChildGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/ifaceChildGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("ifaceGeneric.kt")
                public void testIfaceGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/ifaceGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("nullableResult.kt")
                public void testNullableResult() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/nullableResult.kt");
                }

                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/primitive.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("primitiveGeneric.kt")
                public void testPrimitiveGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/primitiveGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("result.kt")
                public void testResult() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/result.kt");
                }

                @TestMetadata("resultAny.kt")
                public void testResultAny() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/resultAny.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("resultAnyGeneric.kt")
                public void testResultAnyGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/resultAnyGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/string.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }

                @TestMetadata("stringGeneric.kt")
                public void testStringGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/unboxGenericParameter/objectLiteral/stringGeneric.kt", TransformersFunctions.getRemoveOptionalJvmInlineAnnotation());
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/innerNested")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InnerNested extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInnerNested() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/innerNested"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("createNestedClass.kt")
        public void testCreateNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/createNestedClass.kt");
        }

        @TestMetadata("createdNestedInOuterMember.kt")
        public void testCreatedNestedInOuterMember() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/createdNestedInOuterMember.kt");
        }

        @TestMetadata("extenderNestedClass.kt")
        public void testExtenderNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/extenderNestedClass.kt");
        }

        @TestMetadata("extensionFun.kt")
        public void testExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/extensionFun.kt");
        }

        @TestMetadata("extensionToNested.kt")
        public void testExtensionToNested() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/extensionToNested.kt");
        }

        @TestMetadata("importNestedClass.kt")
        public void testImportNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/importNestedClass.kt");
        }

        @TestMetadata("innerGeneric.kt")
        public void testInnerGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerGeneric.kt");
        }

        @TestMetadata("innerImplicitParameter.kt")
        public void testInnerImplicitParameter() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerImplicitParameter.kt");
        }

        @TestMetadata("innerLabeledThis.kt")
        public void testInnerLabeledThis() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerLabeledThis.kt");
        }

        @TestMetadata("innerSimple.kt")
        public void testInnerSimple() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerSimple.kt");
        }

        @TestMetadata("innerWithDefaultArgument.kt")
        public void testInnerWithDefaultArgument() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerWithDefaultArgument.kt");
        }

        @TestMetadata("innerWithDefaultInner.kt")
        public void testInnerWithDefaultInner() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerWithDefaultInner.kt");
        }

        @TestMetadata("kt3132.kt")
        public void testKt3132() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt3132.kt");
        }

        @TestMetadata("kt3927.kt")
        public void testKt3927() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt3927.kt");
        }

        @TestMetadata("kt46829.kt")
        public void testKt46829() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt46829.kt");
        }

        @TestMetadata("kt5363.kt")
        public void testKt5363() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt5363.kt");
        }

        @TestMetadata("kt6804.kt")
        public void testKt6804() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt6804.kt");
        }

        @TestMetadata("nestedClassInObject.kt")
        public void testNestedClassInObject() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedClassInObject.kt");
        }

        @TestMetadata("nestedClassObject.kt")
        public void testNestedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedClassObject.kt");
        }

        @TestMetadata("nestedEnumConstant.kt")
        public void testNestedEnumConstant() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedEnumConstant.kt");
        }

        @TestMetadata("nestedGeneric.kt")
        public void testNestedGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedGeneric.kt");
        }

        @TestMetadata("nestedInPackage.kt")
        public void testNestedInPackage() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedInPackage.kt");
        }

        @TestMetadata("nestedInnerClass.kt")
        public void testNestedInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedInnerClass.kt");
        }

        @TestMetadata("nestedObjects.kt")
        public void testNestedObjects() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedObjects.kt");
        }

        @TestMetadata("nestedSimple.kt")
        public void testNestedSimple() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedSimple.kt");
        }

        @TestMetadata("passingOuterRef.kt")
        public void testPassingOuterRef() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/passingOuterRef.kt");
        }

        @TestMetadata("protectedNestedClass.kt")
        public void testProtectedNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/protectedNestedClass.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuperConstructorCall extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSuperConstructorCall() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/innerNested/superConstructorCall"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("deepInnerHierarchy.kt")
            public void testDeepInnerHierarchy() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/deepInnerHierarchy.kt");
            }

            @TestMetadata("deepLocalHierarchy.kt")
            public void testDeepLocalHierarchy() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/deepLocalHierarchy.kt");
            }

            @TestMetadata("innerExtendsInnerViaSecondaryConstuctor.kt")
            public void testInnerExtendsInnerViaSecondaryConstuctor() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/innerExtendsInnerViaSecondaryConstuctor.kt");
            }

            @TestMetadata("innerExtendsInnerWithProperOuterCapture.kt")
            public void testInnerExtendsInnerWithProperOuterCapture() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/innerExtendsInnerWithProperOuterCapture.kt");
            }

            @TestMetadata("kt11833_1.kt")
            public void testKt11833_1() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/kt11833_1.kt");
            }

            @TestMetadata("kt11833_2.kt")
            public void testKt11833_2() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/kt11833_2.kt");
            }

            @TestMetadata("localClassOuterDiffersFromInnerOuter.kt")
            public void testLocalClassOuterDiffersFromInnerOuter() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/localClassOuterDiffersFromInnerOuter.kt");
            }

            @TestMetadata("localExtendsInner.kt")
            public void testLocalExtendsInner() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/localExtendsInner.kt");
            }

            @TestMetadata("localExtendsLocalWithClosure.kt")
            public void testLocalExtendsLocalWithClosure() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/localExtendsLocalWithClosure.kt");
            }

            @TestMetadata("localWithClosureExtendsLocalWithClosure.kt")
            public void testLocalWithClosureExtendsLocalWithClosure() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/localWithClosureExtendsLocalWithClosure.kt");
            }

            @TestMetadata("objectExtendsClassDefaultArgument.kt")
            public void testObjectExtendsClassDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsClassDefaultArgument.kt");
            }

            @TestMetadata("objectExtendsClassVararg.kt")
            public void testObjectExtendsClassVararg() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsClassVararg.kt");
            }

            @TestMetadata("objectExtendsInner.kt")
            public void testObjectExtendsInner() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInner.kt");
            }

            @TestMetadata("objectExtendsInnerDefaultArgument.kt")
            public void testObjectExtendsInnerDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerDefaultArgument.kt");
            }

            @TestMetadata("objectExtendsInnerOfLocalVarargAndDefault.kt")
            public void testObjectExtendsInnerOfLocalVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerOfLocalVarargAndDefault.kt");
            }

            @TestMetadata("objectExtendsInnerOfLocalWithCapture.kt")
            public void testObjectExtendsInnerOfLocalWithCapture() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerOfLocalWithCapture.kt");
            }

            @TestMetadata("objectExtendsInnerWithDelegatingConstructor.kt")
            public void testObjectExtendsInnerWithDelegatingConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerWithDelegatingConstructor.kt");
            }

            @TestMetadata("objectExtendsLocalCaptureInSuperCall.kt")
            public void testObjectExtendsLocalCaptureInSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsLocalCaptureInSuperCall.kt");
            }

            @TestMetadata("objectExtendsLocalWithClosure.kt")
            public void testObjectExtendsLocalWithClosure() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsLocalWithClosure.kt");
            }

            @TestMetadata("objectExtendsLocal_kt16858.kt")
            public void testObjectExtendsLocal_kt16858() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsLocal_kt16858.kt");
            }

            @TestMetadata("objectOuterDiffersFromInnerOuter.kt")
            public void testObjectOuterDiffersFromInnerOuter() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectOuterDiffersFromInnerOuter.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/instructions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Instructions extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInstructions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/instructions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/instructions/swap")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Swap extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSwap() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/instructions/swap"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("swapRefToSharedVarInt.kt")
            public void testSwapRefToSharedVarInt() throws Exception {
                runTest("compiler/testData/codegen/box/instructions/swap/swapRefToSharedVarInt.kt");
            }

            @TestMetadata("swapRefToSharedVarLong.kt")
            public void testSwapRefToSharedVarLong() throws Exception {
                runTest("compiler/testData/codegen/box/instructions/swap/swapRefToSharedVarLong.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/intrinsics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Intrinsics extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInIntrinsics() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/intrinsics"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("charToInt.kt")
        public void testCharToInt() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/charToInt.kt");
        }

        @TestMetadata("ea35953.kt")
        public void testEa35953() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/ea35953.kt");
        }

        @TestMetadata("incWithLabel.kt")
        public void testIncWithLabel() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/incWithLabel.kt");
        }

        @TestMetadata("kt10131.kt")
        public void testKt10131() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt10131.kt");
        }

        @TestMetadata("kt10131a.kt")
        public void testKt10131a() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt10131a.kt");
        }

        @TestMetadata("kt12125.kt")
        public void testKt12125() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt12125.kt");
        }

        @TestMetadata("kt12125_2.kt")
        public void testKt12125_2() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt12125_2.kt");
        }

        @TestMetadata("kt12125_inc.kt")
        public void testKt12125_inc() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt12125_inc.kt");
        }

        @TestMetadata("kt12125_inc_2.kt")
        public void testKt12125_inc_2() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt12125_inc_2.kt");
        }

        @TestMetadata("kt52163_boolean.kt")
        public void testKt52163_boolean() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt52163_boolean.kt");
        }

        @TestMetadata("kt52163_doubleCompareToInt.kt")
        public void testKt52163_doubleCompareToInt() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt52163_doubleCompareToInt.kt");
        }

        @TestMetadata("kt8666.kt")
        public void testKt8666() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt8666.kt");
        }

        @TestMetadata("longRangeWithExplicitDot.kt")
        public void testLongRangeWithExplicitDot() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/longRangeWithExplicitDot.kt");
        }

        @TestMetadata("nonShortCircuitAnd.kt")
        public void testNonShortCircuitAnd() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/nonShortCircuitAnd.kt");
        }

        @TestMetadata("nullPlusString.kt")
        public void testNullPlusString() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/nullPlusString.kt");
        }

        @TestMetadata("prefixIncDec.kt")
        public void testPrefixIncDec() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/prefixIncDec.kt");
        }

        @TestMetadata("rangeFromCollection.kt")
        public void testRangeFromCollection() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/rangeFromCollection.kt");
        }

        @TestMetadata("stringFromCollection.kt")
        public void testStringFromCollection() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/stringFromCollection.kt");
        }

        @TestMetadata("throwable.kt")
        public void testThrowable() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/throwable.kt");
        }

        @TestMetadata("throwableCallableReference.kt")
        public void testThrowableCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/throwableCallableReference.kt");
        }

        @TestMetadata("throwableParamOrder.kt")
        public void testThrowableParamOrder() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/throwableParamOrder.kt");
        }

        @TestMetadata("tostring.kt")
        public void testTostring() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/tostring.kt");
        }

        @TestMetadata("trimMarginWithBlankString.kt")
        public void testTrimMarginWithBlankString() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/trimMarginWithBlankString.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/invokedynamic")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Invokedynamic extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInvokedynamic() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/invokedynamic/lambdas")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lambdas extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInLambdas() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/lambdas"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/invokedynamic/lambdas/inlineClassInSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InlineClassInSignature extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInInlineClassInSignature() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/lambdas/inlineClassInSignature"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/invokedynamic/sam")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Sam extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/sam"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/invokedynamic/sam/functionExprToJavaInterface")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunctionExprToJavaInterface extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInFunctionExprToJavaInterface() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/sam/functionExprToJavaInterface"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/invokedynamic/sam/functionRefToJavaInterface")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunctionRefToJavaInterface extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInFunctionRefToJavaInterface() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/sam/functionRefToJavaInterface"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/invokedynamic/sam/functionRefToJavaInterface/specialFunctions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class SpecialFunctions extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInSpecialFunctions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/sam/functionRefToJavaInterface/specialFunctions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/invokedynamic/sam/functionRefToJavaInterface/withAccessor")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class WithAccessor extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInWithAccessor() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/sam/functionRefToJavaInterface/withAccessor"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/invokedynamic/sam/inlineClassInSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InlineClassInSignature extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInInlineClassInSignature() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/sam/inlineClassInSignature"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/invokedynamic/sam/specializedGenerics")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SpecializedGenerics extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInSpecializedGenerics() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/sam/specializedGenerics"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/invokedynamic/serializable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Serializable extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSerializable() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/invokedynamic/serializable"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/ir")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ir extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInIr() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ir"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("anonymousClassLeak.kt")
        public void testAnonymousClassLeak() throws Exception {
            runTest("compiler/testData/codegen/box/ir/anonymousClassLeak.kt");
        }

        @TestMetadata("anonymousObjectInForLoopIteratorAndBody.kt")
        public void testAnonymousObjectInForLoopIteratorAndBody() throws Exception {
            runTest("compiler/testData/codegen/box/ir/anonymousObjectInForLoopIteratorAndBody.kt");
        }

        @TestMetadata("anonymousObjectInGenericFun.kt")
        public void testAnonymousObjectInGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/ir/anonymousObjectInGenericFun.kt");
        }

        @TestMetadata("anonymousObjectInsideElvis.kt")
        public void testAnonymousObjectInsideElvis() throws Exception {
            runTest("compiler/testData/codegen/box/ir/anonymousObjectInsideElvis.kt");
        }

        @TestMetadata("classInitializers.kt")
        public void testClassInitializers() throws Exception {
            runTest("compiler/testData/codegen/box/ir/classInitializers.kt");
        }

        @TestMetadata("enumClass.kt")
        public void testEnumClass() throws Exception {
            runTest("compiler/testData/codegen/box/ir/enumClass.kt");
        }

        @TestMetadata("enumClass2.kt")
        public void testEnumClass2() throws Exception {
            runTest("compiler/testData/codegen/box/ir/enumClass2.kt");
        }

        @TestMetadata("enumClass3.kt")
        public void testEnumClass3() throws Exception {
            runTest("compiler/testData/codegen/box/ir/enumClass3.kt");
        }

        @TestMetadata("fileClassInitializers.kt")
        public void testFileClassInitializers() throws Exception {
            runTest("compiler/testData/codegen/box/ir/fileClassInitializers.kt");
        }

        @TestMetadata("genericCompanion.kt")
        public void testGenericCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/ir/genericCompanion.kt");
        }

        @TestMetadata("hashCodeOnGenericSubstitutedWithPrimitive.kt")
        public void testHashCodeOnGenericSubstitutedWithPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/ir/hashCodeOnGenericSubstitutedWithPrimitive.kt");
        }

        @TestMetadata("kt25405.kt")
        public void testKt25405() throws Exception {
            runTest("compiler/testData/codegen/box/ir/kt25405.kt");
        }

        @TestMetadata("kt40083.kt")
        public void testKt40083() throws Exception {
            runTest("compiler/testData/codegen/box/ir/kt40083.kt");
        }

        @TestMetadata("kt41765.kt")
        public void testKt41765() throws Exception {
            runTest("compiler/testData/codegen/box/ir/kt41765.kt");
        }

        @TestMetadata("lambdaWithLoop.kt")
        public void testLambdaWithLoop() throws Exception {
            runTest("compiler/testData/codegen/box/ir/lambdaWithLoop.kt");
        }

        @TestMetadata("objectClass.kt")
        public void testObjectClass() throws Exception {
            runTest("compiler/testData/codegen/box/ir/objectClass.kt");
        }

        @TestMetadata("recursiveGeneric.kt")
        public void testRecursiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/ir/recursiveGeneric.kt");
        }

        @TestMetadata("recursiveGeneric2.kt")
        public void testRecursiveGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/ir/recursiveGeneric2.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/ir/simple.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/ir/closureConversion")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClosureConversion extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInClosureConversion() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ir/closureConversion"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("closureConversion1.kt")
            public void testClosureConversion1() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/closureConversion1.kt");
            }

            @TestMetadata("closureConversion2.kt")
            public void testClosureConversion2() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/closureConversion2.kt");
            }

            @TestMetadata("closureConversion3.kt")
            public void testClosureConversion3() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/closureConversion3.kt");
            }

            @TestMetadata("closureConversion4.kt")
            public void testClosureConversion4() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/closureConversion4.kt");
            }

            @TestMetadata("innerClass1.kt")
            public void testInnerClass1() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/innerClass1.kt");
            }

            @TestMetadata("innerClass2.kt")
            public void testInnerClass2() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/innerClass2.kt");
            }

            @TestMetadata("mutable1.kt")
            public void testMutable1() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/mutable1.kt");
            }

            @TestMetadata("mutablePrimitives.kt")
            public void testMutablePrimitives() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/mutablePrimitives.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ir/primitiveNumberComparisons")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PrimitiveNumberComparisons extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInPrimitiveNumberComparisons() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ir/primitiveNumberComparisons"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("comparableToDouble.kt")
            public void testComparableToDouble() throws Exception {
                runTest("compiler/testData/codegen/box/ir/primitiveNumberComparisons/comparableToDouble.kt");
            }

            @TestMetadata("doubleEqeq.kt")
            public void testDoubleEqeq() throws Exception {
                runTest("compiler/testData/codegen/box/ir/primitiveNumberComparisons/doubleEqeq.kt");
            }

            @TestMetadata("floatEqeq.kt")
            public void testFloatEqeq() throws Exception {
                runTest("compiler/testData/codegen/box/ir/primitiveNumberComparisons/floatEqeq.kt");
            }

            @TestMetadata("mixedNumberTypes.kt")
            public void testMixedNumberTypes() throws Exception {
                runTest("compiler/testData/codegen/box/ir/primitiveNumberComparisons/mixedNumberTypes.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ir/privateSignatures")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PrivateSignatures extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInPrivateSignatures() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ir/privateSignatures"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("enumEntryArguments.kt")
            public void testEnumEntryArguments() throws Exception {
                runTest("compiler/testData/codegen/box/ir/privateSignatures/enumEntryArguments.kt");
            }

            @TestMetadata("privateLeakThroughInline.kt")
            public void testPrivateLeakThroughInline() throws Exception {
                runTest("compiler/testData/codegen/box/ir/privateSignatures/privateLeakThroughInline.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ir/serializationRegressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SerializationRegressions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSerializationRegressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ir/serializationRegressions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("anonFakeOverride.kt")
            public void testAnonFakeOverride() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/anonFakeOverride.kt");
            }

            @TestMetadata("deepGenericDelegatedProperty.kt")
            public void testDeepGenericDelegatedProperty() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/deepGenericDelegatedProperty.kt");
            }

            @TestMetadata("dispatchReceiverValue.kt")
            public void testDispatchReceiverValue() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/dispatchReceiverValue.kt");
            }

            @TestMetadata("genericProperty.kt")
            public void testGenericProperty() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/genericProperty.kt");
            }

            @TestMetadata("innerClassInEnumEntryClass.kt")
            public void testInnerClassInEnumEntryClass() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/innerClassInEnumEntryClass.kt");
            }

            @TestMetadata("signatureClash.kt")
            public void testSignatureClash() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/signatureClash.kt");
            }

            @TestMetadata("transitiveClash.kt")
            public void testTransitiveClash() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/transitiveClash.kt");
            }

            @TestMetadata("useImportedMember.kt")
            public void testUseImportedMember() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/useImportedMember.kt");
            }

            @TestMetadata("varAsFunctionCall.kt")
            public void testVarAsFunctionCall() throws Exception {
                runTest("compiler/testData/codegen/box/ir/serializationRegressions/varAsFunctionCall.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/javaInterop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JavaInterop extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJavaInterop() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaInterop"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/generics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Generics extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInGenerics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/generics"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt42824.kt")
            public void testKt42824() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/generics/kt42824.kt");
            }

            @TestMetadata("kt42825.kt")
            public void testKt42825() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/generics/kt42825.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/notNullAssertions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NotNullAssertions extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInNotNullAssertions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/notNullAssertions"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("mapPut.kt")
            public void testMapPut() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/mapPut.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class EnhancedNullability extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInEnhancedNullability() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/javaInterop/notNullAssertions/nullCheckOnLambdaReturnValue")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NullCheckOnLambdaReturnValue extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInNullCheckOnLambdaReturnValue() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/notNullAssertions/nullCheckOnLambdaReturnValue"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/objectMethods")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ObjectMethods extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInObjectMethods() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/objectMethods"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("cloneCallsConstructor.kt")
            public void testCloneCallsConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsConstructor.kt");
            }

            @TestMetadata("cloneCallsSuper.kt")
            public void testCloneCallsSuper() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsSuper.kt");
            }

            @TestMetadata("cloneCallsSuperAndModifies.kt")
            public void testCloneCallsSuperAndModifies() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsSuperAndModifies.kt");
            }

            @TestMetadata("cloneableClassWithoutClone.kt")
            public void testCloneableClassWithoutClone() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneableClassWithoutClone.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/javaVisibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JavaVisibility extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJavaVisibility() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaVisibility"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/javaVisibility/package")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Package extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInPackage() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaVisibility/package"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/javaVisibility/protectedAndPackage")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProtectedAndPackage extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInProtectedAndPackage() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaVisibility/protectedAndPackage"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/javaVisibility/protectedStatic")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProtectedStatic extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInProtectedStatic() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/javaVisibility/protectedStatic"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jdk")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jdk extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJdk() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jdk"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("arrayList.kt")
        public void testArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/arrayList.kt");
        }

        @TestMetadata("hashMap.kt")
        public void testHashMap() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/hashMap.kt");
        }

        @TestMetadata("iteratingOverHashMap.kt")
        public void testIteratingOverHashMap() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/iteratingOverHashMap.kt");
        }

        @TestMetadata("kt1397.kt")
        public void testKt1397() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/kt1397.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jvm8 extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJvm8() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/jvm8/defaults")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Defaults extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaults() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/allCompatibility")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AllCompatibility extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInAllCompatibility() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/allCompatibility"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/allCompatibility/delegationBy")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class DelegationBy extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInDelegationBy() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/allCompatibility/delegationBy"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/compatibility")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Compatibility extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInCompatibility() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/compatibility"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/delegationBy")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DelegationBy extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInDelegationBy() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/delegationBy"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/noDefaultImpls")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NoDefaultImpls extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInNoDefaultImpls() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/noDefaultImpls"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/noDefaultImpls/delegationBy")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class DelegationBy extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInDelegationBy() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/noDefaultImpls/delegationBy"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/noDefaultImpls/specialization")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Specialization extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInSpecialization() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/noDefaultImpls/specialization"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/noDefaultImpls/withCompatibility")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class WithCompatibility extends AbstractIrCodegenBoxWasmTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                    }

                    public void testAllFilesPresentInWithCompatibility() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/noDefaultImpls/withCompatibility"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/noDelegation")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NoDelegation extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInNoDelegation() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/noDelegation"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/nonDefaultInheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonDefaultInheritance extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInNonDefaultInheritance() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/nonDefaultInheritance"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/reflection")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Reflection extends AbstractIrCodegenBoxWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInReflection() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/reflection"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/jvm8/interfaceFlag")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InterfaceFlag extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInterfaceFlag() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/interfaceFlag"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/jvm8/javaDefaults")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaDefaults extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInJavaDefaults() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvm8/javaDefaults"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmField")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmField extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmField() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvmField"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmName extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmName() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvmName"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/jvmName/fileFacades")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FileFacades extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInFileFacades() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvmName/fileFacades"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmOverloads")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmOverloads extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmOverloads() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvmOverloads"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmPackageName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmPackageName extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmPackageName() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvmPackageName"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmStatic")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmStatic extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmStatic() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvmStatic"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/jvmStatic/protectedInSuperClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProtectedInSuperClass extends AbstractIrCodegenBoxWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInProtectedInSuperClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/jvmStatic/protectedInSuperClass"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/labels")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Labels extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInLabels() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/labels"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("controlLabelClashesWithFuncitonName.kt")
        public void testControlLabelClashesWithFuncitonName() throws Exception {
            runTest("compiler/testData/codegen/box/labels/controlLabelClashesWithFuncitonName.kt");
        }

        @TestMetadata("infixCallLabelling.kt")
        public void testInfixCallLabelling() throws Exception {
            runTest("compiler/testData/codegen/box/labels/infixCallLabelling.kt");
        }

        @TestMetadata("labeledDeclarations.kt")
        public void testLabeledDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/labels/labeledDeclarations.kt");
        }

        @TestMetadata("propertyAccessor.kt")
        public void testPropertyAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyAccessor.kt");
        }

        @TestMetadata("propertyAccessorFunctionLiteral.kt")
        public void testPropertyAccessorFunctionLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyAccessorFunctionLiteral.kt");
        }

        @TestMetadata("propertyAccessorInnerExtensionFun.kt")
        public void testPropertyAccessorInnerExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyAccessorInnerExtensionFun.kt");
        }

        @TestMetadata("propertyAccessorObject.kt")
        public void testPropertyAccessorObject() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyAccessorObject.kt");
        }

        @TestMetadata("propertyInClassAccessor.kt")
        public void testPropertyInClassAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyInClassAccessor.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/lazyCodegen")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LazyCodegen extends AbstractIrCodegenBoxWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInLazyCodegen() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/lazyCodegen"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("exceptionInFieldInitializer.kt")
        public void testExceptionInFieldInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/exceptionInFieldInitializer.kt");
        }

        @TestMetadata("ifElse.kt")
        public void testIfElse() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/ifElse.kt");
        }

        @TestMetadata("increment.kt")
        public void testIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/increment.kt");
        }

        @TestMetadata("safeAssign.kt")
        public void testSafeAssign() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/safeAssign.kt");
        }

        @TestMetadata("safeAssignComplex.kt")
        public void testSafeAssignComplex() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/safeAssignComplex.kt");
        }

        @TestMetadata("safeCallAndArray.kt")
        public void testSafeCallAndArray() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/safeCallAndArray.kt");
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/toString.kt");
        }

        @TestMetadata("tryCatchExpression.kt")
        public void testTryCatchExpression() throws Exception {
            runTest("c