/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.js.testOld.wasm.semantics;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/boxInline")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IrCodegenBoxInlineWasmTestGenerated extends AbstractIrCodegenBoxInlineWasmTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
    }

    public void testAllFilesPresentInBoxInline() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
    }

    @TestMetadata("compiler/testData/codegen/boxInline/annotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotations extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("annotationInstanceInlining.kt")
        public void testAnnotationInstanceInlining() throws Exception {
            runTest("compiler/testData/codegen/boxInline/annotations/annotationInstanceInlining.kt");
        }

        @TestMetadata("instanceInAnonymousClass.kt")
        public void testInstanceInAnonymousClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/annotations/instanceInAnonymousClass.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AnonymousObject extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInAnonymousObject() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("anonymousObjectInDefault.kt")
        public void testAnonymousObjectInDefault() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInDefault.kt");
        }

        @TestMetadata("anonymousObjectOnCallSite.kt")
        public void testAnonymousObjectOnCallSite() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSite.kt");
        }

        @TestMetadata("anonymousObjectOnCallSiteSuperParams.kt")
        public void testAnonymousObjectOnCallSiteSuperParams() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSiteSuperParams.kt");
        }

        @TestMetadata("anonymousObjectOnDeclarationSite.kt")
        public void testAnonymousObjectOnDeclarationSite() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSite.kt");
        }

        @TestMetadata("anonymousObjectOnDeclarationSiteSuperParams.kt")
        public void testAnonymousObjectOnDeclarationSiteSuperParams() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSiteSuperParams.kt");
        }

        @TestMetadata("capturedLambdaInInline.kt")
        public void testCapturedLambdaInInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline.kt");
        }

        @TestMetadata("capturedLambdaInInline2.kt")
        public void testCapturedLambdaInInline2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline2.kt");
        }

        @TestMetadata("capturedLambdaInInline3.kt")
        public void testCapturedLambdaInInline3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline3.kt");
        }

        @TestMetadata("capturedLambdaInInlineObject.kt")
        public void testCapturedLambdaInInlineObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInlineObject.kt");
        }

        @TestMetadata("capturedLocalFun.kt")
        public void testCapturedLocalFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFun.kt");
        }

        @TestMetadata("capturedLocalFunRef.kt")
        public void testCapturedLocalFunRef() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFunRef.kt");
        }

        @TestMetadata("changingReturnType.kt")
        public void testChangingReturnType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/changingReturnType.kt");
        }

        @TestMetadata("constructOriginalInRegenerated.kt")
        public void testConstructOriginalInRegenerated() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/constructOriginalInRegenerated.kt");
        }

        @TestMetadata("constructorVisibility.kt")
        public void testConstructorVisibility() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibility.kt");
        }

        @TestMetadata("constructorVisibilityInConstLambda.kt")
        public void testConstructorVisibilityInConstLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInConstLambda.kt");
        }

        @TestMetadata("constructorVisibilityInLambda.kt")
        public void testConstructorVisibilityInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInLambda.kt");
        }

        @TestMetadata("defineClass.kt")
        public void testDefineClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/defineClass.kt");
        }

        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/functionExpression.kt");
        }

        @TestMetadata("inlineCallInsideInlineLambda.kt")
        public void testInlineCallInsideInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/inlineCallInsideInlineLambda.kt");
        }

        @TestMetadata("kt13182.kt")
        public void testKt13182() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13182.kt");
        }

        @TestMetadata("kt13374.kt")
        public void testKt13374() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13374.kt");
        }

        @TestMetadata("kt14011.kt")
        public void testKt14011() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011.kt");
        }

        @TestMetadata("kt14011_2.kt")
        public void testKt14011_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_2.kt");
        }

        @TestMetadata("kt14011_3.kt")
        public void testKt14011_3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_3.kt");
        }

        @TestMetadata("kt15751.kt")
        public void testKt15751() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt15751.kt");
        }

        @TestMetadata("kt17972.kt")
        public void testKt17972() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972.kt");
        }

        @TestMetadata("kt17972_2.kt")
        public void testKt17972_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_2.kt");
        }

        @TestMetadata("kt17972_3.kt")
        public void testKt17972_3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_3.kt");
        }

        @TestMetadata("kt17972_4.kt")
        public void testKt17972_4() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_4.kt");
        }

        @TestMetadata("kt17972_5.kt")
        public void testKt17972_5() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_5.kt");
        }

        @TestMetadata("kt17972_super.kt")
        public void testKt17972_super() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super.kt");
        }

        @TestMetadata("kt17972_super2.kt")
        public void testKt17972_super2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super2.kt");
        }

        @TestMetadata("kt17972_super3.kt")
        public void testKt17972_super3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super3.kt");
        }

        @TestMetadata("kt19389.kt")
        public void testKt19389() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19389.kt");
        }

        @TestMetadata("kt19399.kt")
        public void testKt19399() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19399.kt");
        }

        @TestMetadata("kt19723.kt")
        public void testKt19723() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19723.kt");
        }

        @TestMetadata("kt34656.kt")
        public void testKt34656() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt34656.kt");
        }

        @TestMetadata("kt38197.kt")
        public void testKt38197() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt38197.kt");
        }

        @TestMetadata("kt42815.kt")
        public void testKt42815() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815.kt");
        }

        @TestMetadata("kt42815_delegated.kt")
        public void testKt42815_delegated() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815_delegated.kt");
        }

        @TestMetadata("kt6007.kt")
        public void testKt6007() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6007.kt");
        }

        @TestMetadata("kt6552.kt")
        public void testKt6552() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6552.kt");
        }

        @TestMetadata("kt8133.kt")
        public void testKt8133() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt8133.kt");
        }

        @TestMetadata("kt9064.kt")
        public void testKt9064() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064.kt");
        }

        @TestMetadata("kt9064v2.kt")
        public void testKt9064v2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064v2.kt");
        }

        @TestMetadata("kt9591.kt")
        public void testKt9591() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9591.kt");
        }

        @TestMetadata("kt9877.kt")
        public void testKt9877() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877.kt");
        }

        @TestMetadata("kt9877_2.kt")
        public void testKt9877_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877_2.kt");
        }

        @TestMetadata("objectInLambdaCapturesAnotherObject.kt")
        public void testObjectInLambdaCapturesAnotherObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/objectInLambdaCapturesAnotherObject.kt");
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall.kt");
        }

        @TestMetadata("safeCall_2.kt")
        public void testSafeCall_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall_2.kt");
        }

        @TestMetadata("sharedFromCrossinline.kt")
        public void testSharedFromCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/sharedFromCrossinline.kt");
        }

        @TestMetadata("superConstructorWithObjectParameter.kt")
        public void testSuperConstructorWithObjectParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/superConstructorWithObjectParameter.kt");
        }

        @TestMetadata("typeInfo.kt")
        public void testTypeInfo() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/typeInfo.kt");
        }

        @TestMetadata("withInlineMethod.kt")
        public void testWithInlineMethod() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/withInlineMethod.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumWhen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EnumWhen extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInEnumWhen() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumWhen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("callSite.kt")
            public void testCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/callSite.kt");
            }

            @TestMetadata("declSite.kt")
            public void testDeclSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSite.kt");
            }

            @TestMetadata("declSiteSeveralMappings.kt")
            public void testDeclSiteSeveralMappings() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappings.kt");
            }

            @TestMetadata("declSiteSeveralMappingsDifOrder.kt")
            public void testDeclSiteSeveralMappingsDifOrder() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappingsDifOrder.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProperRecapturing extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInProperRecapturing() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("inlineChain.kt")
            public void testInlineChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/inlineChain.kt");
            }

            @TestMetadata("lambdaChain.kt")
            public void testLambdaChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain.kt");
            }

            @TestMetadata("lambdaChainSimple.kt")
            public void testLambdaChainSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChainSimple.kt");
            }

            @TestMetadata("lambdaChain_2.kt")
            public void testLambdaChain_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_2.kt");
            }

            @TestMetadata("lambdaChain_3.kt")
            public void testLambdaChain_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_3.kt");
            }

            @TestMetadata("noInlineLambda.kt")
            public void testNoInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/noInlineLambda.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProperRecapturingInClass extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInProperRecapturingInClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("inlineChain.kt")
            public void testInlineChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlineChain.kt");
            }

            @TestMetadata("inlinelambdaChain.kt")
            public void testInlinelambdaChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlinelambdaChain.kt");
            }

            @TestMetadata("lambdaChain.kt")
            public void testLambdaChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain.kt");
            }

            @TestMetadata("lambdaChainSimple.kt")
            public void testLambdaChainSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple.kt");
            }

            @TestMetadata("lambdaChainSimple_2.kt")
            public void testLambdaChainSimple_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple_2.kt");
            }

            @TestMetadata("lambdaChain_2.kt")
            public void testLambdaChain_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_2.kt");
            }

            @TestMetadata("lambdaChain_3.kt")
            public void testLambdaChain_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_3.kt");
            }

            @TestMetadata("noCapturedThisOnCallSite.kt")
            public void testNoCapturedThisOnCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noCapturedThisOnCallSite.kt");
            }

            @TestMetadata("noInlineLambda.kt")
            public void testNoInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noInlineLambda.kt");
            }

            @TestMetadata("twoInlineLambda.kt")
            public void testTwoInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambda.kt");
            }

            @TestMetadata("twoInlineLambdaComplex.kt")
            public void testTwoInlineLambdaComplex() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex.kt");
            }

            @TestMetadata("twoInlineLambdaComplex_2.kt")
            public void testTwoInlineLambdaComplex_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex_2.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/sam")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Sam extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TwoCapturedReceivers extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInTwoCapturedReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt8668.kt")
            public void testKt8668() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668.kt");
            }

            @TestMetadata("kt8668_2.kt")
            public void testKt8668_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_2.kt");
            }

            @TestMetadata("kt8668_3.kt")
            public void testKt8668_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_3.kt");
            }

            @TestMetadata("kt8668_nested.kt")
            public void testKt8668_nested() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested.kt");
            }

            @TestMetadata("kt8668_nested_2.kt")
            public void testKt8668_nested_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested_2.kt");
            }

            @TestMetadata("twoDifferentDispatchReceivers.kt")
            public void testTwoDifferentDispatchReceivers() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoDifferentDispatchReceivers.kt");
            }

            @TestMetadata("twoExtensionReceivers.kt")
            public void testTwoExtensionReceivers() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoExtensionReceivers.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArgumentOrder extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("boundFunctionReference.kt")
        public void testBoundFunctionReference() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference.kt");
        }

        @TestMetadata("boundFunctionReference2.kt")
        public void testBoundFunctionReference2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference2.kt");
        }

        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/captured.kt");
        }

        @TestMetadata("capturedInExtension.kt")
        public void testCapturedInExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/capturedInExtension.kt");
        }

        @TestMetadata("defaultParametersAndLastVararg.kt")
        public void testDefaultParametersAndLastVararg() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVararg.kt");
        }

        @TestMetadata("defaultParametersAndLastVarargWithCorrectOrder.kt")
        public void testDefaultParametersAndLastVarargWithCorrectOrder() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVarargWithCorrectOrder.kt");
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/extension.kt");
        }

        @TestMetadata("extensionInClass.kt")
        public void testExtensionInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/extensionInClass.kt");
        }

        @TestMetadata("lambdaMigration.kt")
        public void testLambdaMigration() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigration.kt");
        }

        @TestMetadata("lambdaMigrationInClass.kt")
        public void testLambdaMigrationInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigrationInClass.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/simple.kt");
        }

        @TestMetadata("simpleInClass.kt")
        public void testSimpleInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/simpleInClass.kt");
        }

        @TestMetadata("varargAndDefaultParameters.kt")
        public void testVarargAndDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParameters.kt");
        }

        @TestMetadata("varargAndDefaultParametersWithCorrectOrder.kt")
        public void testVarargAndDefaultParametersWithCorrectOrder() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParametersWithCorrectOrder.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/arrayConvention")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArrayConvention extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInArrayConvention() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/arrayConvention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("simpleAccess.kt")
        public void testSimpleAccess() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccess.kt");
        }

        @TestMetadata("simpleAccessInClass.kt")
        public void testSimpleAccessInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessInClass.kt");
        }

        @TestMetadata("simpleAccessWithDefault.kt")
        public void testSimpleAccessWithDefault() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefault.kt");
        }

        @TestMetadata("simpleAccessWithDefaultInClass.kt")
        public void testSimpleAccessWithDefaultInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefaultInClass.kt");
        }

        @TestMetadata("simpleAccessWithLambda.kt")
        public void testSimpleAccessWithLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambda.kt");
        }

        @TestMetadata("simpleAccessWithLambdaInClass.kt")
        public void testSimpleAccessWithLambdaInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambdaInClass.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/assert")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Assert extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInAssert() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/builders")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Builders extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInBuilders() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/builders"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/bytecodePreprocessing")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BytecodePreprocessing extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInBytecodePreprocessing() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/bytecodePreprocessing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("adapted.kt")
        public void testAdapted() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/adapted.kt");
        }

        public void testAllFilesPresentInCallableReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("classLevel.kt")
        public void testClassLevel() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/classLevel.kt");
        }

        @TestMetadata("classLevel2.kt")
        public void testClassLevel2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/classLevel2.kt");
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/constructor.kt");
        }

        @TestMetadata("innerGenericConstuctor.kt")
        public void testInnerGenericConstuctor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/innerGenericConstuctor.kt");
        }

        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/intrinsic.kt");
        }

        @TestMetadata("kt15449.kt")
        public void testKt15449() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/kt15449.kt");
        }

        @TestMetadata("kt15751_2.kt")
        public void testKt15751_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/kt15751_2.kt");
        }

        @TestMetadata("kt16411.kt")
        public void testKt16411() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/kt16411.kt");
        }

        @TestMetadata("kt35101.kt")
        public void testKt35101() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/kt35101.kt");
        }

        @TestMetadata("propertyIntrinsic.kt")
        public void testPropertyIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/propertyIntrinsic.kt");
        }

        @TestMetadata("propertyReference.kt")
        public void testPropertyReference() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/propertyReference.kt");
        }

        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/topLevel.kt");
        }

        @TestMetadata("topLevelExtension.kt")
        public void testTopLevelExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/topLevelExtension.kt");
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/topLevelProperty.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/callableReference/adaptedReferences")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AdaptedReferences extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInAdaptedReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("inlineBound.kt")
            public void testInlineBound() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineBound.kt");
            }

            @TestMetadata("inlineDefault.kt")
            public void testInlineDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineDefault.kt");
            }

            @TestMetadata("inlineVararg.kt")
            public void testInlineVararg() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVararg.kt");
            }

            @TestMetadata("inlineVarargAndDefault.kt")
            public void testInlineVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
            }

            @TestMetadata("inlineVarargInts.kt")
            public void testInlineVarargInts() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargInts.kt");
            }

            @TestMetadata("multipleCallableReferenceUsage.kt")
            public void testMultipleCallableReferenceUsage() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/multipleCallableReferenceUsage.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInBound() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("classProperty.kt")
            public void testClassProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/classProperty.kt");
            }

            @TestMetadata("doubleBoundToThis.kt")
            public void testDoubleBoundToThis() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/doubleBoundToThis.kt");
            }

            @TestMetadata("emptyLhsFunction.kt")
            public void testEmptyLhsFunction() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsFunction.kt");
            }

            @TestMetadata("emptyLhsOnInlineProperty.kt")
            public void testEmptyLhsOnInlineProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsOnInlineProperty.kt");
            }

            @TestMetadata("emptyLhsProperty.kt")
            public void testEmptyLhsProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsProperty.kt");
            }

            @TestMetadata("expression.kt")
            public void testExpression() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/expression.kt");
            }

            @TestMetadata("extensionReceiver.kt")
            public void testExtensionReceiver() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/extensionReceiver.kt");
            }

            @TestMetadata("filter.kt")
            public void testFilter() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/filter.kt");
            }

            @TestMetadata("inlineValueParameterInsteadOfReceiver.kt")
            public void testInlineValueParameterInsteadOfReceiver() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/inlineValueParameterInsteadOfReceiver.kt");
            }

            @TestMetadata("innerGenericConstuctor.kt")
            public void testInnerGenericConstuctor() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/innerGenericConstuctor.kt");
            }

            @TestMetadata("intrinsic.kt")
            public void testIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/intrinsic.kt");
            }

            @TestMetadata("kt18728.kt")
            public void testKt18728() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728.kt");
            }

            @TestMetadata("kt18728_2.kt")
            public void testKt18728_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_2.kt");
            }

            @TestMetadata("kt18728_3.kt")
            public void testKt18728_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_3.kt");
            }

            @TestMetadata("kt18728_4.kt")
            public void testKt18728_4() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_4.kt");
            }

            @TestMetadata("kt30933.kt")
            public void testKt30933() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt30933.kt");
            }

            @TestMetadata("lambdaOnLhs.kt")
            public void testLambdaOnLhs() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/lambdaOnLhs.kt");
            }

            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/map.kt");
            }

            @TestMetadata("mixed.kt")
            public void testMixed() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/mixed.kt");
            }

            @TestMetadata("objectProperty.kt")
            public void testObjectProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/objectProperty.kt");
            }

            @TestMetadata("propertyImportedFromObject.kt")
            public void testPropertyImportedFromObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/propertyImportedFromObject.kt");
            }

            @TestMetadata("sideEffect.kt")
            public void testSideEffect() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/sideEffect.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/simple.kt");
            }

            @TestMetadata("simpleVal.kt")
            public void testSimpleVal() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal.kt");
            }

            @TestMetadata("simpleVal2.kt")
            public void testSimpleVal2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal2.kt");
            }

            @TestMetadata("topLevelExtensionProperty.kt")
            public void testTopLevelExtensionProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/topLevelExtensionProperty.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/capture")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Capture extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInCapture() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/capture"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("captureInlinable.kt")
        public void testCaptureInlinable() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/captureInlinable.kt");
        }

        @TestMetadata("captureInlinableAndOther.kt")
        public void testCaptureInlinableAndOther() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/captureInlinableAndOther.kt");
        }

        @TestMetadata("captureThisAndReceiver.kt")
        public void testCaptureThisAndReceiver() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/captureThisAndReceiver.kt");
        }

        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/generics.kt");
        }

        @TestMetadata("kt48230.kt")
        public void testKt48230() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/kt48230.kt");
        }

        @TestMetadata("kt48230_2.kt")
        public void testKt48230_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/kt48230_2.kt");
        }

        @TestMetadata("simpleCapturingInClass.kt")
        public void testSimpleCapturingInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInClass.kt");
        }

        @TestMetadata("simpleCapturingInPackage.kt")
        public void testSimpleCapturingInPackage() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInPackage.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/complex")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Complex extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInComplex() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("closureChain.kt")
        public void testClosureChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/closureChain.kt");
        }

        @TestMetadata("kt44429.kt")
        public void testKt44429() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/kt44429.kt");
        }

        @TestMetadata("swapAndWith.kt")
        public void testSwapAndWith() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/swapAndWith.kt");
        }

        @TestMetadata("swapAndWith2.kt")
        public void testSwapAndWith2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/swapAndWith2.kt");
        }

        @TestMetadata("use.kt")
        public void testUse() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/use.kt");
        }

        @TestMetadata("with.kt")
        public void testWith() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/with.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/complexStack")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ComplexStack extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInComplexStack() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complexStack"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("asCheck.kt")
        public void testAsCheck() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/asCheck.kt");
        }

        @TestMetadata("asCheck2.kt")
        public void testAsCheck2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/asCheck2.kt");
        }

        @TestMetadata("breakContinueInInlineLambdaArgument.kt")
        public void testBreakContinueInInlineLambdaArgument() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/breakContinueInInlineLambdaArgument.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simple.kt");
        }

        @TestMetadata("simple2.kt")
        public void testSimple2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simple2.kt");
        }

        @TestMetadata("simple3.kt")
        public void testSimple3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simple3.kt");
        }

        @TestMetadata("simple4.kt")
        public void testSimple4() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simple4.kt");
        }

        @TestMetadata("simpleExtension.kt")
        public void testSimpleExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simpleExtension.kt");
        }

        @TestMetadata("spillConstructorArgumentsAndInlineLambdaParameter.kt")
        public void testSpillConstructorArgumentsAndInlineLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/spillConstructorArgumentsAndInlineLambdaParameter.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/contracts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Contracts extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInContracts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("cfgDependendValInitialization.kt")
        public void testCfgDependendValInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/cfgDependendValInitialization.kt");
        }

        @TestMetadata("complexInitializer.kt")
        public void testComplexInitializer() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/complexInitializer.kt");
        }

        @TestMetadata("complexInitializerWithStackTransformation.kt")
        public void testComplexInitializerWithStackTransformation() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/complexInitializerWithStackTransformation.kt");
        }

        @TestMetadata("crossinlineCallableReference.kt")
        public void testCrossinlineCallableReference() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/crossinlineCallableReference.kt");
        }

        @TestMetadata("definiteLongValInitialization.kt")
        public void testDefiniteLongValInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/definiteLongValInitialization.kt");
        }

        @TestMetadata("definiteNestedValInitialization.kt")
        public void testDefiniteNestedValInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/definiteNestedValInitialization.kt");
        }

        @TestMetadata("definiteValInitInInitializer.kt")
        public void testDefiniteValInitInInitializer() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitInInitializer.kt");
        }

        @TestMetadata("definiteValInitialization.kt")
        public void testDefiniteValInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitialization.kt");
        }

        @TestMetadata("exactlyOnceCrossinline.kt")
        public void testExactlyOnceCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline.kt");
        }

        @TestMetadata("exactlyOnceCrossinline2.kt")
        public void testExactlyOnceCrossinline2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline2.kt");
        }

        @TestMetadata("exactlyOnceNoinline.kt")
        public void testExactlyOnceNoinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceNoinline.kt");
        }

        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturn.kt");
        }

        @TestMetadata("nonLocalReturnWithCycle.kt")
        public void testNonLocalReturnWithCycle() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturnWithCycle.kt");
        }

        @TestMetadata("propertyInitialization.kt")
        public void testPropertyInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/propertyInitialization.kt");
        }

        @TestMetadata("valInitializationAndUsageInNestedLambda.kt")
        public void testValInitializationAndUsageInNestedLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/valInitializationAndUsageInNestedLambda.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/defaultValues")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DefaultValues extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("33Parameters.kt")
        public void test33Parameters() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/33Parameters.kt");
        }

        @TestMetadata("33ParametersInConstructor.kt")
        public void test33ParametersInConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/33ParametersInConstructor.kt");
        }

        public void testAllFilesPresentInDefaultValues() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("defaultInExtension.kt")
        public void testDefaultInExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/defaultInExtension.kt");
        }

        @TestMetadata("defaultMethod.kt")
        public void testDefaultMethod() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethod.kt");
        }

        @TestMetadata("defaultMethodInClass.kt")
        public void testDefaultMethodInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethodInClass.kt");
        }

        @TestMetadata("defaultParamRemapping.kt")
        public void testDefaultParamRemapping() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/defaultParamRemapping.kt");
        }

        @TestMetadata("inlineInDefaultParameter.kt")
        public void testInlineInDefaultParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/inlineInDefaultParameter.kt");
        }

        @TestMetadata("inlineLambdaInNoInlineDefault.kt")
        public void testInlineLambdaInNoInlineDefault() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/inlineLambdaInNoInlineDefault.kt");
        }

        @TestMetadata("kt11479.kt")
        public void testKt11479() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479.kt");
        }

        @TestMetadata("kt11479InlinedDefaultParameter.kt")
        public void testKt11479InlinedDefaultParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479InlinedDefaultParameter.kt");
        }

        @TestMetadata("kt14564.kt")
        public void testKt14564() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564.kt");
        }

        @TestMetadata("kt14564_2.kt")
        public void testKt14564_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564_2.kt");
        }

        @TestMetadata("kt16496.kt")
        public void testKt16496() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt16496.kt");
        }

        @TestMetadata("kt18689.kt")
        public void testKt18689() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689.kt");
        }

        @TestMetadata("kt18689_2.kt")
        public void testKt18689_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_2.kt");
        }

        @TestMetadata("kt18689_3.kt")
        public void testKt18689_3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_3.kt");
        }

        @TestMetadata("kt18689_4.kt")
        public void testKt18689_4() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_4.kt");
        }

        @TestMetadata("kt5685.kt")
        public void testKt5685() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt5685.kt");
        }

        @TestMetadata("simpleDefaultMethod.kt")
        public void testSimpleDefaultMethod() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/simpleDefaultMethod.kt");
        }

        @TestMetadata("varArgNoInline.kt")
        public void testVarArgNoInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/varArgNoInline.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LambdaInlining extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInLambdaInlining() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("checkLambdaClassIsPresent.kt")
            public void testCheckLambdaClassIsPresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassIsPresent.kt");
            }

            @TestMetadata("checkLambdaClassesArePresent.kt")
            public void testCheckLambdaClassesArePresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassesArePresent.kt");
            }

            @TestMetadata("checkObjectClassIsPresent.kt")
            public void testCheckObjectClassIsPresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkObjectClassIsPresent.kt");
            }

            @TestMetadata("checkStaticLambdaClassIsPresent.kt")
            public void testCheckStaticLambdaClassIsPresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassIsPresent.kt");
            }

            @TestMetadata("checkStaticLambdaClassesArePresent.kt")
            public void testCheckStaticLambdaClassesArePresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassesArePresent.kt");
            }

            @TestMetadata("checkStaticObjectClassIsPresent.kt")
            public void testCheckStaticObjectClassIsPresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticObjectClassIsPresent.kt");
            }

            @TestMetadata("defaultAfterCapturing.kt")
            public void testDefaultAfterCapturing() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultAfterCapturing.kt");
            }

            @TestMetadata("defaultCallInDefaultLambda.kt")
            public void testDefaultCallInDefaultLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultCallInDefaultLambda.kt");
            }

            @TestMetadata("defaultLambdaInNoInline.kt")
            public void testDefaultLambdaInNoInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultLambdaInNoInline.kt");
            }

            @TestMetadata("differentInvokeSignature.kt")
            public void testDifferentInvokeSignature() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/differentInvokeSignature.kt");
            }

            @TestMetadata("genericLambda.kt")
            public void testGenericLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/genericLambda.kt");
            }

            @TestMetadata("instanceCapturedInClass.kt")
            public void testInstanceCapturedInClass() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInClass.kt");
            }

            @TestMetadata("instanceCapturedInInterface.kt")
            public void testInstanceCapturedInInterface() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInInterface.kt");
            }

            @TestMetadata("kt21827.kt")
            public void testKt21827() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21827.kt");
            }

            @TestMetadata("kt21946.kt")
            public void testKt21946() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21946.kt");
            }

            @TestMetadata("kt24477.kt")
            public void testKt24477() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt24477.kt");
            }

            @TestMetadata("kt25106.kt")
            public void testKt25106() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt25106.kt");
            }

            @TestMetadata("lambdaTakesResult.kt")
            public void testLambdaTakesResult() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/lambdaTakesResult.kt");
            }

            @TestMetadata("noInline.kt")
            public void testNoInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/noInline.kt");
            }

            @TestMetadata("nonDefaultInlineInNoInline.kt")
            public void testNonDefaultInlineInNoInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/nonDefaultInlineInNoInline.kt");
            }

            @TestMetadata("receiverClash.kt")
            public void testReceiverClash() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash.kt");
            }

            @TestMetadata("receiverClash2.kt")
            public void testReceiverClash2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash2.kt");
            }

            @TestMetadata("receiverClashInClass.kt")
            public void testReceiverClashInClass() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass.kt");
            }

            @TestMetadata("receiverClashInClass2.kt")
            public void testReceiverClashInClass2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass2.kt");
            }

            @TestMetadata("reordering.kt")
            public void testReordering() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/reordering.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simple.kt");
            }

            @TestMetadata("simpleErased.kt")
            public void testSimpleErased() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErased.kt");
            }

            @TestMetadata("simpleErasedStaticInstance.kt")
            public void testSimpleErasedStaticInstance() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErasedStaticInstance.kt");
            }

            @TestMetadata("simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleExtension.kt");
            }

            @TestMetadata("simpleGeneric.kt")
            public void testSimpleGeneric() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleGeneric.kt");
            }

            @TestMetadata("simpleStaticInstance.kt")
            public void testSimpleStaticInstance() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleStaticInstance.kt");
            }

            @TestMetadata("thisClash.kt")
            public void testThisClash() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClash.kt");
            }

            @TestMetadata("thisClashInClass.kt")
            public void testThisClashInClass() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClashInClass.kt");
            }

            @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallableReferences extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInCallableReferences() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("boundFunctionReference.kt")
                public void testBoundFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReference.kt");
                }

                @TestMetadata("boundFunctionReferenceOnInt.kt")
                public void testBoundFunctionReferenceOnInt() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnInt.kt");
                }

                @TestMetadata("boundFunctionReferenceOnLong.kt")
                public void testBoundFunctionReferenceOnLong() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnLong.kt");
                }

                @TestMetadata("boundInlineClassMethod.kt")
                public void testBoundInlineClassMethod() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethod.kt");
                }

                @TestMetadata("boundInlineClassMethodWithAny.kt")
                public void testBoundInlineClassMethodWithAny() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithAny.kt");
                }

                @TestMetadata("boundInlineClassMethodWithInt.kt")
                public void testBoundInlineClassMethodWithInt() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithInt.kt");
                }

                @TestMetadata("boundPropertyReference.kt")
                public void testBoundPropertyReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReference.kt");
                }

                @TestMetadata("boundPropertyReferenceOnInt.kt")
                public void testBoundPropertyReferenceOnInt() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnInt.kt");
                }

                @TestMetadata("boundPropertyReferenceOnLong.kt")
                public void testBoundPropertyReferenceOnLong() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnLong.kt");
                }

                @TestMetadata("constuctorReference.kt")
                public void testConstuctorReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/constuctorReference.kt");
                }

                @TestMetadata("defaultAfterBoundReference.kt")
                public void testDefaultAfterBoundReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/defaultAfterBoundReference.kt");
                }

                @TestMetadata("differentInvokeSignature.kt")
                public void testDifferentInvokeSignature() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature.kt");
                }

                @TestMetadata("differentInvokeSignature2.kt")
                public void testDifferentInvokeSignature2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature2.kt");
                }

                @TestMetadata("differentInvokeSignature3.kt")
                public void testDifferentInvokeSignature3() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature3.kt");
                }

                @TestMetadata("functionImportedFromObject.kt")
                public void testFunctionImportedFromObject() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionImportedFromObject.kt");
                }

                @TestMetadata("functionReference.kt")
                public void testFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReference.kt");
                }

                @TestMetadata("functionReferenceFromClass.kt")
                public void testFunctionReferenceFromClass() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromClass.kt");
                }

                @TestMetadata("functionReferenceFromObject.kt")
                public void testFunctionReferenceFromObject() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromObject.kt");
                }

                @TestMetadata("innerClassConstuctorReference.kt")
                public void testInnerClassConstuctorReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/innerClassConstuctorReference.kt");
                }

                @TestMetadata("mutableBoundPropertyReferenceFromClass.kt")
                public void testMutableBoundPropertyReferenceFromClass() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutableBoundPropertyReferenceFromClass.kt");
                }

                @TestMetadata("mutablePropertyReferenceFromClass.kt")
                public void testMutablePropertyReferenceFromClass() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutablePropertyReferenceFromClass.kt");
                }

                @TestMetadata("privateFunctionReference.kt")
                public void testPrivateFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privateFunctionReference.kt");
                }

                @TestMetadata("privatePropertyReference.kt")
                public void testPrivatePropertyReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privatePropertyReference.kt");
                }

                @TestMetadata("propertyImportedFromObject.kt")
                public void testPropertyImportedFromObject() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyImportedFromObject.kt");
                }

                @TestMetadata("propertyReference.kt")
                public void testPropertyReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReference.kt");
                }

                @TestMetadata("propertyReferenceFromClass.kt")
                public void testPropertyReferenceFromClass() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromClass.kt");
                }

                @TestMetadata("propertyReferenceFromObject.kt")
                public void testPropertyReferenceFromObject() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromObject.kt");
                }

                @TestMetadata("withInlineClassParameter.kt")
                public void testWithInlineClassParameter() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/withInlineClassParameter.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/maskElimination")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MaskElimination extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            @TestMetadata("32Parameters.kt")
            public void test32Parameters() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/32Parameters.kt");
            }

            @TestMetadata("33Parameters.kt")
            public void test33Parameters() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/33Parameters.kt");
            }

            public void testAllFilesPresentInMaskElimination() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/maskElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt18792.kt")
            public void testKt18792() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt18792.kt");
            }

            @TestMetadata("kt19679.kt")
            public void testKt19679() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679.kt");
            }

            @TestMetadata("kt19679_2.kt")
            public void testKt19679_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_2.kt");
            }

            @TestMetadata("kt19679_3.kt")
            public void testKt19679_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_3.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/simple.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DelegatedProperty extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("kt16864.kt")
        public void testKt16864() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt16864.kt");
        }

        @TestMetadata("kt48498.kt")
        public void testKt48498() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt48498.kt");
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/local.kt");
        }

        @TestMetadata("localDeclaredInLambda.kt")
        public void testLocalDeclaredInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/localDeclaredInLambda.kt");
        }

        @TestMetadata("localInAnonymousObject.kt")
        public void testLocalInAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInAnonymousObject.kt");
        }

        @TestMetadata("localInLambda.kt")
        public void testLocalInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInLambda.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/enclosingInfo")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class EnclosingInfo extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInEnclosingInfo() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInEnum() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("kt10569.kt")
        public void testKt10569() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/kt10569.kt");
        }

        @TestMetadata("kt18254.kt")
        public void testKt18254() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/kt18254.kt");
        }

        @TestMetadata("valueOf.kt")
        public void testValueOf() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOf.kt");
        }

        @TestMetadata("valueOfCapturedType.kt")
        public void testValueOfCapturedType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOfCapturedType.kt");
        }

        @TestMetadata("valueOfChain.kt")
        public void testValueOfChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOfChain.kt");
        }

        @TestMetadata("valueOfChainCapturedType.kt")
        public void testValueOfChainCapturedType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOfChainCapturedType.kt");
        }

        @TestMetadata("valueOfNonReified.kt")
        public void testValueOfNonReified() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOfNonReified.kt");
        }

        @TestMetadata("values.kt")
        public void testValues() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/values.kt");
        }

        @TestMetadata("valuesAsArray.kt")
        public void testValuesAsArray() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesAsArray.kt");
        }

        @TestMetadata("valuesCapturedType.kt")
        public void testValuesCapturedType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesCapturedType.kt");
        }

        @TestMetadata("valuesChain.kt")
        public void testValuesChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesChain.kt");
        }

        @TestMetadata("valuesChainCapturedType.kt")
        public void testValuesChainCapturedType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesChainCapturedType.kt");
        }

        @TestMetadata("valuesNonReified.kt")
        public void testValuesNonReified() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesNonReified.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/functionExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FunctionExpression extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInFunctionExpression() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/functionExpression/extension.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/inlineArgsInplace")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineArgsInplace extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInlineArgsInplace() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineArgsInplace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("callArgumentReordering.kt")
        public void testCallArgumentReordering() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineArgsInplace/callArgumentReordering.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineClasses extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("anonymousObject.kt")
        public void testAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/anonymousObject.kt");
        }

        @TestMetadata("inlineClassWithInlineValReturningInlineClass.kt")
        public void testInlineClassWithInlineValReturningInlineClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineClassWithInlineValReturningInlineClass.kt");
        }

        @TestMetadata("inlineFunctionInsideInlineClassesBox.kt")
        public void testInlineFunctionInsideInlineClassesBox() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineFunctionInsideInlineClassesBox.kt");
        }

        @TestMetadata("noReturnTypeManglingFun.kt")
        public void testNoReturnTypeManglingFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFun.kt");
        }

        @TestMetadata("noReturnTypeManglingVal.kt")
        public void testNoReturnTypeManglingVal() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingVal.kt");
        }

        @TestMetadata("withReturnTypeManglingFun.kt")
        public void testWithReturnTypeManglingFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFun.kt");
        }

        @TestMetadata("withReturnTypeManglingVal.kt")
        public void testWithReturnTypeManglingVal() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingVal.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnboxGenericParameter extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInUnboxGenericParameter() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunInterface extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInFunInterface() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/any.kt");
                }

                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/anyN.kt");
                }

                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/iface.kt");
                }

                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/ifaceChild.kt");
                }

                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/primitive.kt");
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/string.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Lambda extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInLambda() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/any.kt");
                }

                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/anyN.kt");
                }

                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/iface.kt");
                }

                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/ifaceChild.kt");
                }

                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/primitive.kt");
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/string.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ObjectLiteral extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInObjectLiteral() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/any.kt");
                }

                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/anyN.kt");
                }

                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/iface.kt");
                }

                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/ifaceChild.kt");
                }

                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/primitive.kt");
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/string.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/innerClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InnerClasses extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInnerClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("captureThisAndOuter.kt")
        public void testCaptureThisAndOuter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/captureThisAndOuter.kt");
        }

        @TestMetadata("fakeOverride.kt")
        public void testFakeOverride() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/fakeOverride.kt");
        }

        @TestMetadata("innerInlineFunCapturesOuter.kt")
        public void testInnerInlineFunCapturesOuter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuter.kt");
        }

        @TestMetadata("innerInlineFunCapturesOuterByAnotherInlineFun.kt")
        public void testInnerInlineFunCapturesOuterByAnotherInlineFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterByAnotherInlineFun.kt");
        }

        @TestMetadata("innerInlineFunCapturesOuterDeep.kt")
        public void testInnerInlineFunCapturesOuterDeep() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterDeep.kt");
        }

        @TestMetadata("innerInlineFunCapturesOuterFunRef.kt")
        public void testInnerInlineFunCapturesOuterFunRef() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterFunRef.kt");
        }

        @TestMetadata("innerInlineFunCapturesOuterWithInlineClass.kt")
        public void testInnerInlineFunCapturesOuterWithInlineClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterWithInlineClass.kt");
        }

        @TestMetadata("kt12126.kt")
        public void testKt12126() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/kt12126.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Invokedynamic extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInInvokedynamic() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic/lambdas")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lambdas extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInLambdas() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic/sam")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Sam extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/jvmName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmName extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmName() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/jvmPackageName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmPackageName extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmPackageName() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmPackageName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/lambdaClassClash")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LambdaClassClash extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInLambdaClassClash() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaClassClash"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("lambdaClassClash.kt")
        public void testLambdaClassClash() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaClassClash/lambdaClassClash.kt");
        }

        @TestMetadata("noInlineLambdaX2.kt")
        public void testNoInlineLambdaX2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaClassClash/noInlineLambdaX2.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/lambdaTransformation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LambdaTransformation extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInLambdaTransformation() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaTransformation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("lambdaCloning.kt")
        public void testLambdaCloning() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaCloning.kt");
        }

        @TestMetadata("lambdaInLambdaNoInline.kt")
        public void testLambdaInLambdaNoInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambdaNoInline.kt");
        }

        @TestMetadata("regeneratedLambdaName.kt")
        public void testRegeneratedLambdaName() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName.kt");
        }

        @TestMetadata("regeneratedLambdaName2.kt")
        public void testRegeneratedLambdaName2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName2.kt");
        }

        @TestMetadata("sameCaptured.kt")
        public void testSameCaptured() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/sameCaptured.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/localFunInLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LocalFunInLambda extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInLocalFunInLambda() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/localFunInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("defaultParam.kt")
        public void testDefaultParam() throws Exception {
            runTest("compiler/testData/codegen/boxInline/localFunInLambda/defaultParam.kt");
        }

        @TestMetadata("lambdaInLambdaCapturesAnotherFun.kt")
        public void testLambdaInLambdaCapturesAnotherFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/localFunInLambda/lambdaInLambdaCapturesAnotherFun.kt");
        }

        @TestMetadata("localFunInLambda.kt")
        public void testLocalFunInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambda.kt");
        }

        @TestMetadata("localFunInLambdaCapturesAnotherFun.kt")
        public void testLocalFunInLambdaCapturesAnotherFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambdaCapturesAnotherFun.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/multiModule")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiModule extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInMultiModule() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("tryCatchWithRecursiveInline.kt")
        public void testTryCatchWithRecursiveInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/multiModule/tryCatchWithRecursiveInline.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultifileClasses extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/multiplatform")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Multiplatform extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInMultiplatform() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("compiler/testData/codegen/boxInline/multiplatform/defaultArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultArguments extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultArguments() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("receiversAndParametersInLambda.kt")
            public void testReceiversAndParametersInLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/multiplatform/defaultArguments/receiversAndParametersInLambda.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/noInline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NoInline extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInNoInline() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/noInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("extensionReceiver.kt")
        public void testExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/extensionReceiver.kt");
        }

        @TestMetadata("lambdaAsGeneric.kt")
        public void testLambdaAsGeneric() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsGeneric.kt");
        }

        @TestMetadata("lambdaAsNonFunction.kt")
        public void testLambdaAsNonFunction() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsNonFunction.kt");
        }

        @TestMetadata("noInline.kt")
        public void testNoInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/noInline.kt");
        }

        @TestMetadata("noInlineLambdaChain.kt")
        public void testNoInlineLambdaChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChain.kt");
        }

        @TestMetadata("noInlineLambdaChainWithCapturedInline.kt")
        public void testNoInlineLambdaChainWithCapturedInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChainWithCapturedInline.kt");
        }

        @TestMetadata("withoutInline.kt")
        public void testWithoutInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/withoutInline.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NonLocalReturns extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInNonLocalReturns() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("explicitLocalReturn.kt")
        public void testExplicitLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/explicitLocalReturn.kt");
        }

        @TestMetadata("fromArrayGenerator.kt")
        public void testFromArrayGenerator() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGenerator.kt");
        }

        @TestMetadata("fromArrayGeneratorCatch.kt")
        public void testFromArrayGeneratorCatch() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorCatch.kt");
        }

        @TestMetadata("fromArrayGeneratorNested.kt")
        public void testFromArrayGeneratorNested() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorNested.kt");
        }

        @TestMetadata("fromArrayGeneratorWithCapture.kt")
        public void testFromArrayGeneratorWithCapture() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCapture.kt");
        }

        @TestMetadata("fromArrayGeneratorWithCatch.kt")
        public void testFromArrayGeneratorWithCatch() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCatch.kt");
        }

        @TestMetadata("fromArrayGeneratorWithFinally.kt")
        public void testFromArrayGeneratorWithFinally() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinally.kt");
        }

        @TestMetadata("fromArrayGeneratorWithFinallyX2.kt")
        public void testFromArrayGeneratorWithFinallyX2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2.kt");
        }

        @TestMetadata("fromArrayGeneratorWithFinallyX2_2.kt")
        public void testFromArrayGeneratorWithFinallyX2_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2_2.kt");
        }

        @TestMetadata("fromInterfaceDefaultGetter.kt")
        public void testFromInterfaceDefaultGetter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromInterfaceDefaultGetter.kt");
        }

        @TestMetadata("justReturnInLambda.kt")
        public void testJustReturnInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/justReturnInLambda.kt");
        }

        @TestMetadata("kt5199.kt")
        public void testKt5199() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt5199.kt");
        }

        @TestMetadata("kt8948.kt")
        public void testKt8948() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948.kt");
        }

        @TestMetadata("kt8948v2.kt")
        public void testKt8948v2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948v2.kt");
        }

        @TestMetadata("kt9304.kt")
        public void testKt9304() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt9304.kt");
        }

        @TestMetadata("nestedNonLocals.kt")
        public void testNestedNonLocals() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nestedNonLocals.kt");
        }

        @TestMetadata("noInlineLocalReturn.kt")
        public void testNoInlineLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/noInlineLocalReturn.kt");
        }

        @TestMetadata("nonLocalReturnFromOuterLambda.kt")
        public void testNonLocalReturnFromOuterLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nonLocalReturnFromOuterLambda.kt");
        }

        @TestMetadata("propertyAccessors.kt")
        public void testPropertyAccessors() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/propertyAccessors.kt");
        }

        @TestMetadata("returnFromFunctionExpr.kt")
        public void testReturnFromFunctionExpr() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/returnFromFunctionExpr.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simple.kt");
        }

        @TestMetadata("simpleFunctional.kt")
        public void testSimpleFunctional() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleFunctional.kt");
        }

        @TestMetadata("simpleVoid.kt")
        public void testSimpleVoid() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleVoid.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Deparenthesize extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDeparenthesize() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("bracket.kt")
            public void testBracket() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/bracket.kt");
            }

            @TestMetadata("labeled.kt")
            public void testLabeled() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/labeled.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TryFinally extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInTryFinally() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt16417.kt")
            public void testKt16417() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt16417.kt");
            }

            @TestMetadata("kt20433.kt")
            public void testKt20433() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433.kt");
            }

            @TestMetadata("kt20433_2.kt")
            public void testKt20433_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2.kt");
            }

            @TestMetadata("kt20433_2_void.kt")
            public void testKt20433_2_void() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2_void.kt");
            }

            @TestMetadata("kt20433_void.kt")
            public void testKt20433_void() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_void.kt");
            }

            @TestMetadata("kt26384.kt")
            public void testKt26384() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384.kt");
            }

            @TestMetadata("kt26384_2.kt")
            public void testKt26384_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384_2.kt");
            }

            @TestMetadata("kt28546.kt")
            public void testKt28546() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt28546.kt");
            }

            @TestMetadata("kt6956.kt")
            public void testKt6956() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt6956.kt");
            }

            @TestMetadata("kt7273.kt")
            public void testKt7273() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt7273.kt");
            }

            @TestMetadata("nonLocalReturnFromCatchBlock.kt")
            public void testNonLocalReturnFromCatchBlock() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromCatchBlock.kt");
            }

            @TestMetadata("nonLocalReturnFromOuterLambda.kt")
            public void testNonLocalReturnFromOuterLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromOuterLambda.kt");
            }

            @TestMetadata("nonLocalReturnToCatchBlock.kt")
            public void testNonLocalReturnToCatchBlock() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnToCatchBlock.kt");
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallSite extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInCallSite() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("callSite.kt")
                public void testCallSite() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSite.kt");
                }

                @TestMetadata("callSiteComplex.kt")
                public void testCallSiteComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSiteComplex.kt");
                }

                @TestMetadata("exceptionTableSplit.kt")
                public void testExceptionTableSplit() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplit.kt");
                }

                @TestMetadata("exceptionTableSplitNoReturn.kt")
                public void testExceptionTableSplitNoReturn() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplitNoReturn.kt");
                }

                @TestMetadata("finallyInFinally.kt")
                public void testFinallyInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/finallyInFinally.kt");
                }

                @TestMetadata("wrongVarInterval.kt")
                public void testWrongVarInterval() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/wrongVarInterval.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Chained extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInChained() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("finallyInFinally.kt")
                public void testFinallyInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally.kt");
                }

                @TestMetadata("finallyInFinally2.kt")
                public void testFinallyInFinally2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally2.kt");
                }

                @TestMetadata("intReturn.kt")
                public void testIntReturn() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturn.kt");
                }

                @TestMetadata("intReturnComplex.kt")
                public void testIntReturnComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex.kt");
                }

                @TestMetadata("intReturnComplex2.kt")
                public void testIntReturnComplex2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex2.kt");
                }

                @TestMetadata("intReturnComplex3.kt")
                public void testIntReturnComplex3() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex3.kt");
                }

                @TestMetadata("intReturnComplex4.kt")
                public void testIntReturnComplex4() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex4.kt");
                }

                @TestMetadata("nestedLambda.kt")
                public void testNestedLambda() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/nestedLambda.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DeclSite extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInDeclSite() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("complex.kt")
                public void testComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/complex.kt");
                }

                @TestMetadata("intReturn.kt")
                public void testIntReturn() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturn.kt");
                }

                @TestMetadata("intReturnComplex.kt")
                public void testIntReturnComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturnComplex.kt");
                }

                @TestMetadata("longReturn.kt")
                public void testLongReturn() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/longReturn.kt");
                }

                @TestMetadata("nested.kt")
                public void testNested() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/nested.kt");
                }

                @TestMetadata("returnInFinally.kt")
                public void testReturnInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInFinally.kt");
                }

                @TestMetadata("returnInTry.kt")
                public void testReturnInTry() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTry.kt");
                }

                @TestMetadata("returnInTryAndFinally.kt")
                public void testReturnInTryAndFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTryAndFinally.kt");
                }

                @TestMetadata("severalInTry.kt")
                public void testSeveralInTry() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTry.kt");
                }

                @TestMetadata("severalInTryComplex.kt")
                public void testSeveralInTryComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTryComplex.kt");
                }

                @TestMetadata("voidInlineFun.kt")
                public void testVoidInlineFun() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidInlineFun.kt");
                }

                @TestMetadata("voidNonLocal.kt")
                public void testVoidNonLocal() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidNonLocal.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExceptionTable extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInExceptionTable() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("break.kt")
                public void testBreak() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/break.kt");
                }

                @TestMetadata("continue.kt")
                public void testContinue() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/continue.kt");
                }

                @TestMetadata("exceptionInFinally.kt")
                public void testExceptionInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/exceptionInFinally.kt");
                }

                @TestMetadata("forInFinally.kt")
                public void testForInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/forInFinally.kt");
                }

                @TestMetadata("innerAndExternal.kt")
                public void testInnerAndExternal() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternal.kt");
                }

                @TestMetadata("innerAndExternalNested.kt")
                public void testInnerAndExternalNested() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalNested.kt");
                }

                @TestMetadata("innerAndExternalSimple.kt")
                public void testInnerAndExternalSimple() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalSimple.kt");
                }

                @TestMetadata("kt31653.kt")
                public void testKt31653() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653.kt");
                }

                @TestMetadata("kt31653_2.kt")
                public void testKt31653_2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653_2.kt");
                }

                @TestMetadata("kt31923.kt")
                public void testKt31923() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923.kt");
                }

                @TestMetadata("kt31923_2.kt")
                public void testKt31923_2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_2.kt");
                }

                @TestMetadata("nested.kt")
                public void testNested() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nested.kt");
                }

                @TestMetadata("nestedWithReturns.kt")
                public void testNestedWithReturns() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturns.kt");
                }

                @TestMetadata("nestedWithReturnsSimple.kt")
                public void testNestedWithReturnsSimple() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturnsSimple.kt");
                }

                @TestMetadata("noFinally.kt")
                public void testNoFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/noFinally.kt");
                }

                @TestMetadata("severalCatchClause.kt")
                public void testSeveralCatchClause() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/severalCatchClause.kt");
                }

                @TestMetadata("simpleThrow.kt")
                public void testSimpleThrow() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/simpleThrow.kt");
                }

                @TestMetadata("synchonized.kt")
                public void testSynchonized() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/synchonized.kt");
                }

                @TestMetadata("throwInFinally.kt")
                public void testThrowInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/throwInFinally.kt");
                }

                @TestMetadata("tryCatchInFinally.kt")
                public void testTryCatchInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/tryCatchInFinally.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Variables extends AbstractIrCodegenBoxInlineWasmTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
                }

                public void testAllFilesPresentInVariables() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
                }

                @TestMetadata("kt7792.kt")
                public void testKt7792() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables/kt7792.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/optimizations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Optimizations extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInOptimizations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/optimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("kt20844.kt")
        public void testKt20844() throws Exception {
            runTest("compiler/testData/codegen/boxInline/optimizations/kt20844.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/private")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Private extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        @TestMetadata("accessorForConst.kt")
        public void testAccessorForConst() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/accessorForConst.kt");
        }

        @TestMetadata("accessorStability.kt")
        public void testAccessorStability() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/accessorStability.kt");
        }

        @TestMetadata("accessorStabilityInClass.kt")
        public void testAccessorStabilityInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/accessorStabilityInClass.kt");
        }

        public void testAllFilesPresentInPrivate() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("effectivePrivate.kt")
        public void testEffectivePrivate() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/effectivePrivate.kt");
        }

        @TestMetadata("kt6453.kt")
        public void testKt6453() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/kt6453.kt");
        }

        @TestMetadata("kt8094.kt")
        public void testKt8094() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/kt8094.kt");
        }

        @TestMetadata("kt8095.kt")
        public void testKt8095() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/kt8095.kt");
        }

        @TestMetadata("nestedInPrivateClass.kt")
        public void testNestedInPrivateClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass.kt");
        }

        @TestMetadata("privateClass.kt")
        public void testPrivateClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/privateClass.kt");
        }

        @TestMetadata("privateClassExtensionLambda.kt")
        public void testPrivateClassExtensionLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/privateClassExtensionLambda.kt");
        }

        @TestMetadata("privateInline.kt")
        public void testPrivateInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/privateInline.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/property")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Property extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("augAssignmentAndInc.kt")
        public void testAugAssignmentAndInc() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndInc.kt");
        }

        @TestMetadata("augAssignmentAndIncInClass.kt")
        public void testAugAssignmentAndIncInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClass.kt");
        }

        @TestMetadata("augAssignmentAndIncInClassViaConvention.kt")
        public void testAugAssignmentAndIncInClassViaConvention() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClassViaConvention.kt");
        }

        @TestMetadata("augAssignmentAndIncOnExtension.kt")
        public void testAugAssignmentAndIncOnExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtension.kt");
        }

        @TestMetadata("augAssignmentAndIncOnExtensionInClass.kt")
        public void testAugAssignmentAndIncOnExtensionInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtensionInClass.kt");
        }

        @TestMetadata("augAssignmentAndIncViaConvention.kt")
        public void testAugAssignmentAndIncViaConvention() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncViaConvention.kt");
        }

        @TestMetadata("fromObject.kt")
        public void testFromObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/fromObject.kt");
        }

        @TestMetadata("kt22649.kt")
        public void testKt22649() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/kt22649.kt");
        }

        @TestMetadata("property.kt")
        public void testProperty() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/property.kt");
        }

        @TestMetadata("reifiedVal.kt")
        public void testReifiedVal() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/reifiedVal.kt");
        }

        @TestMetadata("reifiedVar.kt")
        public void testReifiedVar() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/reifiedVar.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/simple.kt");
        }

        @TestMetadata("simpleExtension.kt")
        public void testSimpleExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/simpleExtension.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/reified")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reified extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInReified() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/arrayConstructor.kt");
        }

        @TestMetadata("arrayOf.kt")
        public void testArrayOf() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/arrayOf.kt");
        }

        @TestMetadata("capturedLambda.kt")
        public void testCapturedLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/capturedLambda.kt");
        }

        @TestMetadata("capturedLambda2.kt")
        public void testCapturedLambda2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/capturedLambda2.kt");
        }

        @TestMetadata("dontSubstituteNonReified.kt")
        public void testDontSubstituteNonReified() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/dontSubstituteNonReified.kt");
        }

        @TestMetadata("kt15956.kt")
        public void testKt15956() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt15956.kt");
        }

        @TestMetadata("kt18977.kt")
        public void testKt18977() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt18977.kt");
        }

        @TestMetadata("kt28234.kt")
        public void testKt28234() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt28234.kt");
        }

        @TestMetadata("kt35511.kt")
        public void testKt35511() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt35511.kt");
        }

        @TestMetadata("kt35511_try.kt")
        public void testKt35511_try() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt35511_try.kt");
        }

        @TestMetadata("kt35511_try_valueOf.kt")
        public void testKt35511_try_valueOf() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_valueOf.kt");
        }

        @TestMetadata("kt35511_try_values.kt")
        public void testKt35511_try_values() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_values.kt");
        }

        @TestMetadata("kt46584.kt")
        public void testKt46584() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt46584.kt");
        }

        @TestMetadata("kt46584_2.kt")
        public void testKt46584_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt46584_2.kt");
        }

        @TestMetadata("kt7017.kt")
        public void testKt7017() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt7017.kt");
        }

        @TestMetadata("kt8047.kt")
        public void testKt8047() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt8047.kt");
        }

        @TestMetadata("kt8047_2.kt")
        public void testKt8047_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt8047_2.kt");
        }

        @TestMetadata("kt9637_2.kt")
        public void testKt9637_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt9637_2.kt");
        }

        @TestMetadata("nameClash.kt")
        public void testNameClash() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/nameClash.kt");
        }

        @TestMetadata("nonCapturingObjectInLambda.kt")
        public void testNonCapturingObjectInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/nonCapturingObjectInLambda.kt");
        }

        @TestMetadata("singletonLambda.kt")
        public void testSingletonLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/singletonLambda.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/reified/checkCast")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CheckCast extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInCheckCast() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/checkCast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("chain.kt")
            public void testChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/chain.kt");
            }

            @TestMetadata("kt26435.kt")
            public void testKt26435() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435.kt");
            }

            @TestMetadata("kt26435_2.kt")
            public void testKt26435_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_2.kt");
            }

            @TestMetadata("kt26435_3.kt")
            public void testKt26435_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_3.kt");
            }

            @TestMetadata("kt8043.kt")
            public void testKt8043() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt8043.kt");
            }

            @TestMetadata("maxStack.kt")
            public void testMaxStack() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/maxStack.kt");
            }

            @TestMetadata("nullable.kt")
            public void testNullable() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/nullable.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple.kt");
            }

            @TestMetadata("simpleSafe.kt")
            public void testSimpleSafe() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/simpleSafe.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/reified/defaultLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultLambda extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/reified/isCheck")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IsCheck extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInIsCheck() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/isCheck"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("chain.kt")
            public void testChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/isCheck/chain.kt");
            }

            @TestMetadata("nullable.kt")
            public void testNullable() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/isCheck/nullable.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/isCheck/simple.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/signature")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Signature extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInSignature() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/signatureMangling")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SignatureMangling extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInSignatureMangling() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signatureMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/simple")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Simple extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInSimple() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/simple"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("captureAndArgumentIncompatibleTypes.kt")
        public void testCaptureAndArgumentIncompatibleTypes() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/captureAndArgumentIncompatibleTypes.kt");
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/classObject.kt");
        }

        @TestMetadata("destructuring.kt")
        public void testDestructuring() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/destructuring.kt");
        }

        @TestMetadata("destructuringIndexClash.kt")
        public void testDestructuringIndexClash() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/destructuringIndexClash.kt");
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/extension.kt");
        }

        @TestMetadata("extensionLambda.kt")
        public void testExtensionLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/extensionLambda.kt");
        }

        @TestMetadata("funImportedFromObject.kt")
        public void testFunImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/funImportedFromObject.kt");
        }

        @TestMetadata("inlineCallInInlineLambda.kt")
        public void testInlineCallInInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/inlineCallInInlineLambda.kt");
        }

        @TestMetadata("kt17431.kt")
        public void testKt17431() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/kt17431.kt");
        }

        @TestMetadata("kt28547.kt")
        public void testKt28547() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/kt28547.kt");
        }

        @TestMetadata("kt28547_2.kt")
        public void testKt28547_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/kt28547_2.kt");
        }

        @TestMetadata("params.kt")
        public void testParams() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/params.kt");
        }

        @TestMetadata("rootConstructor.kt")
        public void testRootConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/rootConstructor.kt");
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/safeCall.kt");
        }

        @TestMetadata("severalClosures.kt")
        public void testSeveralClosures() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/severalClosures.kt");
        }

        @TestMetadata("severalUsage.kt")
        public void testSeveralUsage() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/severalUsage.kt");
        }

        @TestMetadata("simpleDouble.kt")
        public void testSimpleDouble() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleDouble.kt");
        }

        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleEnum.kt");
        }

        @TestMetadata("simpleGenerics.kt")
        public void testSimpleGenerics() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleGenerics.kt");
        }

        @TestMetadata("simpleInt.kt")
        public void testSimpleInt() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleInt.kt");
        }

        @TestMetadata("simpleLambda.kt")
        public void testSimpleLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleLambda.kt");
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleObject.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/vararg.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/smap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Smap extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInSmap() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("assertion.kt")
        public void testAssertion() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/assertion.kt");
        }

        @TestMetadata("classCycle.kt")
        public void testClassCycle() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/classCycle.kt");
        }

        @TestMetadata("classFromDefaultPackage.kt")
        public void testClassFromDefaultPackage() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/classFromDefaultPackage.kt");
        }

        @TestMetadata("crossroutines.kt")
        public void testCrossroutines() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/crossroutines.kt");
        }

        @TestMetadata("defaultFunction.kt")
        public void testDefaultFunction() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/defaultFunction.kt");
        }

        @TestMetadata("defaultFunctionWithInlineCall.kt")
        public void testDefaultFunctionWithInlineCall() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/defaultFunctionWithInlineCall.kt");
        }

        @TestMetadata("forInline.kt")
        public void testForInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/forInline.kt");
        }

        @TestMetadata("interleavedFiles.kt")
        public void testInterleavedFiles() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/interleavedFiles.kt");
        }

        @TestMetadata("kt23369.kt")
        public void testKt23369() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/kt23369.kt");
        }

        @TestMetadata("kt23369_2.kt")
        public void testKt23369_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/kt23369_2.kt");
        }

        @TestMetadata("kt23369_3.kt")
        public void testKt23369_3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/kt23369_3.kt");
        }

        @TestMetadata("kt35006.kt")
        public void testKt35006() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/kt35006.kt");
        }

        @TestMetadata("oneFile.kt")
        public void testOneFile() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/oneFile.kt");
        }

        @TestMetadata("rangeFolding.kt")
        public void testRangeFolding() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/rangeFolding.kt");
        }

        @TestMetadata("rangeFoldingInClass.kt")
        public void testRangeFoldingInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/rangeFoldingInClass.kt");
        }

        @TestMetadata("smap.kt")
        public void testSmap() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/smap.kt");
        }

        @TestMetadata("smapWithNewSyntax.kt")
        public void testSmapWithNewSyntax() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/smapWithNewSyntax.kt");
        }

        @TestMetadata("smapWithOldSyntax.kt")
        public void testSmapWithOldSyntax() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/smapWithOldSyntax.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/anonymous")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Anonymous extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInAnonymous() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/anonymous"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("kt19175.kt")
            public void testKt19175() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/kt19175.kt");
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambda.kt");
            }

            @TestMetadata("lambdaOnCallSite.kt")
            public void testLambdaOnCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnCallSite.kt");
            }

            @TestMetadata("lambdaOnInlineCallSite.kt")
            public void testLambdaOnInlineCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnInlineCallSite.kt");
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/object.kt");
            }

            @TestMetadata("objectOnCallSite.kt")
            public void testObjectOnCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnCallSite.kt");
            }

            @TestMetadata("objectOnInlineCallSite.kt")
            public void testObjectOnInlineCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite.kt");
            }

            @TestMetadata("objectOnInlineCallSite2.kt")
            public void testObjectOnInlineCallSite2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite2.kt");
            }

            @TestMetadata("objectOnInlineCallSiteWithCapture.kt")
            public void testObjectOnInlineCallSiteWithCapture() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSiteWithCapture.kt");
            }

            @TestMetadata("severalMappingsForDefaultFile.kt")
            public void testSeveralMappingsForDefaultFile() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/severalMappingsForDefaultFile.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/defaultLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultLambda extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("defaultLambdaInAnonymous.kt")
            public void testDefaultLambdaInAnonymous() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/defaultLambdaInAnonymous.kt");
            }

            @TestMetadata("inlinInDefault.kt")
            public void testInlinInDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlinInDefault.kt");
            }

            @TestMetadata("inlinInDefault2.kt")
            public void testInlinInDefault2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlinInDefault2.kt");
            }

            @TestMetadata("inlineAnonymousInDefault.kt")
            public void testInlineAnonymousInDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault.kt");
            }

            @TestMetadata("inlineAnonymousInDefault2.kt")
            public void testInlineAnonymousInDefault2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault2.kt");
            }

            @TestMetadata("kt21827.kt")
            public void testKt21827() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/kt21827.kt");
            }

            @TestMetadata("nested.kt")
            public void testNested() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/nested.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple.kt");
            }

            @TestMetadata("simple2.kt")
            public void testSimple2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple2.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/inlineOnly")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineOnly extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInlineOnly() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/inlineOnly"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("noSmap.kt")
            public void testNoSmap() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmap.kt");
            }

            @TestMetadata("noSmapWithProperty.kt")
            public void testNoSmapWithProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmapWithProperty.kt");
            }

            @TestMetadata("stdlibInlineOnly.kt")
            public void testStdlibInlineOnly() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnly.kt");
            }

            @TestMetadata("stdlibInlineOnlyOneLine.kt")
            public void testStdlibInlineOnlyOneLine() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnlyOneLine.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/newsmap")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Newsmap extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInNewsmap() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/newsmap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("differentMapping.kt")
            public void testDifferentMapping() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/newsmap/differentMapping.kt");
            }

            @TestMetadata("mappingInInlineFunLambda.kt")
            public void testMappingInInlineFunLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInInlineFunLambda.kt");
            }

            @TestMetadata("mappingInSubInlineLambda.kt")
            public void testMappingInSubInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambda.kt");
            }

            @TestMetadata("mappingInSubInlineLambdaSameFileInline.kt")
            public void testMappingInSubInlineLambdaSameFileInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambdaSameFileInline.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/resolve")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Resolve extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInResolve() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/resolve"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("inlineComponent.kt")
            public void testInlineComponent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineComponent.kt");
            }

            @TestMetadata("inlineIterator.kt")
            public void testInlineIterator() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineIterator.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/special")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Special extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInSpecial() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/special"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("identityCheck.kt")
        public void testIdentityCheck() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/identityCheck.kt");
        }

        @TestMetadata("ifBranches.kt")
        public void testIfBranches() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/ifBranches.kt");
        }

        @TestMetadata("iinc.kt")
        public void testIinc() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/iinc.kt");
        }

        @TestMetadata("inlineChain.kt")
        public void testInlineChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/inlineChain.kt");
        }

        @TestMetadata("loopInStoreLoadChains.kt")
        public void testLoopInStoreLoadChains() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains.kt");
        }

        @TestMetadata("loopInStoreLoadChains2.kt")
        public void testLoopInStoreLoadChains2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains2.kt");
        }

        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/plusAssign.kt");
        }

        @TestMetadata("stackHeightBug.kt")
        public void testStackHeightBug() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/stackHeightBug.kt");
        }

        @TestMetadata("unusedInlineLambda.kt")
        public void testUnusedInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/unusedInlineLambda.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/stackOnReturn")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StackOnReturn extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInStackOnReturn() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/stackOnReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("elvis.kt")
        public void testElvis() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/elvis.kt");
        }

        @TestMetadata("ifThenElse.kt")
        public void testIfThenElse() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/ifThenElse.kt");
        }

        @TestMetadata("kt11499.kt")
        public void testKt11499() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt11499.kt");
        }

        @TestMetadata("kt17591.kt")
        public void testKt17591() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591.kt");
        }

        @TestMetadata("kt17591a.kt")
        public void testKt17591a() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591a.kt");
        }

        @TestMetadata("kt17591b.kt")
        public void testKt17591b() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591b.kt");
        }

        @TestMetadata("mixedTypesOnStack1.kt")
        public void testMixedTypesOnStack1() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack1.kt");
        }

        @TestMetadata("mixedTypesOnStack2.kt")
        public void testMixedTypesOnStack2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack2.kt");
        }

        @TestMetadata("mixedTypesOnStack3.kt")
        public void testMixedTypesOnStack3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack3.kt");
        }

        @TestMetadata("nonLocalReturn1.kt")
        public void testNonLocalReturn1() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn1.kt");
        }

        @TestMetadata("nonLocalReturn2.kt")
        public void testNonLocalReturn2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn2.kt");
        }

        @TestMetadata("nonLocalReturn3.kt")
        public void testNonLocalReturn3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn3.kt");
        }

        @TestMetadata("poppedLocalReturn.kt")
        public void testPoppedLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn.kt");
        }

        @TestMetadata("poppedLocalReturn2.kt")
        public void testPoppedLocalReturn2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn2.kt");
        }

        @TestMetadata("returnLong.kt")
        public void testReturnLong() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/returnLong.kt");
        }

        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/tryFinally.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/suspend")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Suspend extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInSuspend() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("capturedVariables.kt")
        public void testCapturedVariables() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/capturedVariables.kt");
        }

        @TestMetadata("crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt")
        public void testCrossinlineSuspendLambdaInsideCrossinlineSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt");
        }

        @TestMetadata("delegatedProperties.kt")
        public void testDelegatedProperties() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/delegatedProperties.kt");
        }

        @TestMetadata("doubleRegenerationWithNonSuspendingLambda.kt")
        public void testDoubleRegenerationWithNonSuspendingLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/doubleRegenerationWithNonSuspendingLambda.kt");
        }

        @TestMetadata("inlineOrdinaryOfCrossinlineSuspend.kt")
        public void testInlineOrdinaryOfCrossinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfCrossinlineSuspend.kt");
        }

        @TestMetadata("inlineOrdinaryOfNoinlineSuspend.kt")
        public void testInlineOrdinaryOfNoinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfNoinlineSuspend.kt");
        }

        @TestMetadata("inlinePassthrough.kt")
        public void testInlinePassthrough() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthrough.kt");
        }

        @TestMetadata("inlineSuspendOfCrossinlineOrdinary.kt")
        public void testInlineSuspendOfCrossinlineOrdinary() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineOrdinary.kt");
        }

        @TestMetadata("inlineSuspendOfCrossinlineSuspend.kt")
        public void testInlineSuspendOfCrossinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineSuspend.kt");
        }

        @TestMetadata("inlineSuspendOfNoinlineOrdinary.kt")
        public void testInlineSuspendOfNoinlineOrdinary() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineOrdinary.kt");
        }

        @TestMetadata("inlineSuspendOfNoinlineSuspend.kt")
        public void testInlineSuspendOfNoinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineSuspend.kt");
        }

        @TestMetadata("inlineSuspendOfOrdinary.kt")
        public void testInlineSuspendOfOrdinary() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfOrdinary.kt");
        }

        @TestMetadata("inlineSuspendOfSuspend.kt")
        public void testInlineSuspendOfSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfSuspend.kt");
        }

        @TestMetadata("kt26658.kt")
        public void testKt26658() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/kt26658.kt");
        }

        @TestMetadata("maxStackWithCrossinline.kt")
        public void testMaxStackWithCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/maxStackWithCrossinline.kt");
        }

        @TestMetadata("multipleLocals.kt")
        public void testMultipleLocals() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/multipleLocals.kt");
        }

        @TestMetadata("multipleSuspensionPoints.kt")
        public void testMultipleSuspensionPoints() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/multipleSuspensionPoints.kt");
        }

        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/nonLocalReturn.kt");
        }

        @TestMetadata("nonSuspendCrossinline.kt")
        public void testNonSuspendCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/nonSuspendCrossinline.kt");
        }

        @TestMetadata("returnValue.kt")
        public void testReturnValue() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/returnValue.kt");
        }

        @TestMetadata("tryCatchReceiver.kt")
        public void testTryCatchReceiver() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/tryCatchReceiver.kt");
        }

        @TestMetadata("tryCatchStackTransform.kt")
        public void testTryCatchStackTransform() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/tryCatchStackTransform.kt");
        }

        @TestMetadata("twiceRegeneratedAnonymousObject.kt")
        public void testTwiceRegeneratedAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedAnonymousObject.kt");
        }

        @TestMetadata("twiceRegeneratedSuspendLambda.kt")
        public void testTwiceRegeneratedSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedSuspendLambda.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/suspend/callableReference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallableReference extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInCallableReference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("isAsReified.kt")
            public void testIsAsReified() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified.kt");
            }

            @TestMetadata("isAsReified2.kt")
            public void testIsAsReified2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified2.kt");
            }

            @TestMetadata("nonTailCall.kt")
            public void testNonTailCall() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/nonTailCall.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/simple.kt");
            }

            @TestMetadata("unitReturn.kt")
            public void testUnitReturn() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/unitReturn.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/suspend/defaultParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultParameter extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultParameter() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/defaultParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("defaultInlineLambda.kt")
            public void testDefaultInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineLambda.kt");
            }

            @TestMetadata("defaultInlineReference.kt")
            public void testDefaultInlineReference() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineReference.kt");
            }

            @TestMetadata("defaultValueCrossinline.kt")
            public void testDefaultValueCrossinline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueCrossinline.kt");
            }

            @TestMetadata("defaultValueInClass.kt")
            public void testDefaultValueInClass() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInClass.kt");
            }

            @TestMetadata("defaultValueInline.kt")
            public void testDefaultValueInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInline.kt");
            }

            @TestMetadata("defaultValueInlineFromMultiFileFacade.kt")
            public void testDefaultValueInlineFromMultiFileFacade() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInlineFromMultiFileFacade.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/suspend/inlineClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineClass extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInlineClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("returnBoxedFromLambda.kt")
            public void testReturnBoxedFromLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnBoxedFromLambda.kt");
            }

            @TestMetadata("returnUnboxedDirect.kt")
            public void testReturnUnboxedDirect() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedDirect.kt");
            }

            @TestMetadata("returnUnboxedFromLambda.kt")
            public void testReturnUnboxedFromLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedFromLambda.kt");
            }

            @TestMetadata("returnUnboxedResume.kt")
            public void testReturnUnboxedResume() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedResume.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineUsedAsNoinline extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInInlineUsedAsNoinline() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("inlineOnly.kt")
            public void testInlineOnly() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/inlineOnly.kt");
            }

            @TestMetadata("simpleNamed.kt")
            public void testSimpleNamed() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/simpleNamed.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/suspend/receiver")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Receiver extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInReceiver() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/receiver"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("inlineOrdinaryOfCrossinlineSuspend.kt")
            public void testInlineOrdinaryOfCrossinlineSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfCrossinlineSuspend.kt");
            }

            @TestMetadata("inlineOrdinaryOfNoinlineSuspend.kt")
            public void testInlineOrdinaryOfNoinlineSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfNoinlineSuspend.kt");
            }

            @TestMetadata("inlineSuspendOfCrossinlineOrdinary.kt")
            public void testInlineSuspendOfCrossinlineOrdinary() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineOrdinary.kt");
            }

            @TestMetadata("inlineSuspendOfCrossinlineSuspend.kt")
            public void testInlineSuspendOfCrossinlineSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineSuspend.kt");
            }

            @TestMetadata("inlineSuspendOfNoinlineOrdinary.kt")
            public void testInlineSuspendOfNoinlineOrdinary() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineOrdinary.kt");
            }

            @TestMetadata("inlineSuspendOfNoinlineSuspend.kt")
            public void testInlineSuspendOfNoinlineSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineSuspend.kt");
            }

            @TestMetadata("inlineSuspendOfOrdinary.kt")
            public void testInlineSuspendOfOrdinary() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfOrdinary.kt");
            }

            @TestMetadata("inlineSuspendOfSuspend.kt")
            public void testInlineSuspendOfSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfSuspend.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/suspend/stateMachine")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StateMachine extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInStateMachine() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("crossingCoroutineBoundaries.kt")
            public void testCrossingCoroutineBoundaries() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/crossingCoroutineBoundaries.kt");
            }

            @TestMetadata("independentInline.kt")
            public void testIndependentInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/independentInline.kt");
            }

            @TestMetadata("innerLambda.kt")
            public void testInnerLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambda.kt");
            }

            @TestMetadata("innerLambdaInsideLambda.kt")
            public void testInnerLambdaInsideLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaInsideLambda.kt");
            }

            @TestMetadata("innerLambdaWithoutCrossinline.kt")
            public void testInnerLambdaWithoutCrossinline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaWithoutCrossinline.kt");
            }

            @TestMetadata("innerMadness.kt")
            public void testInnerMadness() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadness.kt");
            }

            @TestMetadata("innerMadnessCallSite.kt")
            public void testInnerMadnessCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadnessCallSite.kt");
            }

            @TestMetadata("innerObject.kt")
            public void testInnerObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObject.kt");
            }

            @TestMetadata("innerObjectInsideInnerObject.kt")
            public void testInnerObjectInsideInnerObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectInsideInnerObject.kt");
            }

            @TestMetadata("innerObjectRetransformation.kt")
            public void testInnerObjectRetransformation() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectRetransformation.kt");
            }

            @TestMetadata("innerObjectSeveralFunctions.kt")
            public void testInnerObjectSeveralFunctions() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectSeveralFunctions.kt");
            }

            @TestMetadata("innerObjectWithoutCapturingCrossinline.kt")
            public void testInnerObjectWithoutCapturingCrossinline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectWithoutCapturingCrossinline.kt");
            }

            @TestMetadata("insideObject.kt")
            public void testInsideObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/insideObject.kt");
            }

            @TestMetadata("kt30708.kt")
            public void testKt30708() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/kt30708.kt");
            }

            @TestMetadata("lambdaTransformation.kt")
            public void testLambdaTransformation() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/lambdaTransformation.kt");
            }

            @TestMetadata("normalInline.kt")
            public void testNormalInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/normalInline.kt");
            }

            @TestMetadata("numberOfSuspentions.kt")
            public void testNumberOfSuspentions() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/numberOfSuspentions.kt");
            }

            @TestMetadata("objectInsideLambdas.kt")
            public void testObjectInsideLambdas() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/objectInsideLambdas.kt");
            }

            @TestMetadata("oneInlineTwoCaptures.kt")
            public void testOneInlineTwoCaptures() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/oneInlineTwoCaptures.kt");
            }

            @TestMetadata("passLambda.kt")
            public void testPassLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passLambda.kt");
            }

            @TestMetadata("passParameter.kt")
            public void testPassParameter() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameter.kt");
            }

            @TestMetadata("passParameterLambda.kt")
            public void testPassParameterLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameterLambda.kt");
            }

            @TestMetadata("unreachableSuspendMarker.kt")
            public void testUnreachableSuspendMarker() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/unreachableSuspendMarker.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/syntheticAccessors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SyntheticAccessors extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInSyntheticAccessors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("constField.kt")
        public void testConstField() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/constField.kt");
        }

        @TestMetadata("packagePrivateMembers.kt")
        public void testPackagePrivateMembers() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/packagePrivateMembers.kt");
        }

        @TestMetadata("propertyModifiers.kt")
        public void testPropertyModifiers() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/propertyModifiers.kt");
        }

        @TestMetadata("protectedMembers.kt")
        public void testProtectedMembers() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembers.kt");
        }

        @TestMetadata("protectedMembersFromSuper.kt")
        public void testProtectedMembersFromSuper() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembersFromSuper.kt");
        }

        @TestMetadata("superCall.kt")
        public void testSuperCall() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCall.kt");
        }

        @TestMetadata("superCallFromMultipleSubclasses.kt")
        public void testSuperCallFromMultipleSubclasses() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCallFromMultipleSubclasses.kt");
        }

        @TestMetadata("superProperty.kt")
        public void testSuperProperty() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superProperty.kt");
        }

        @TestMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class WithinInlineLambda extends AbstractIrCodegenBoxInlineWasmTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
            }

            public void testAllFilesPresentInWithinInlineLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
            }

            @TestMetadata("directFieldAccess.kt")
            public void testDirectFieldAccess() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccess.kt");
            }

            @TestMetadata("directFieldAccessInCrossInline.kt")
            public void testDirectFieldAccessInCrossInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccessInCrossInline.kt");
            }

            @TestMetadata("privateCall.kt")
            public void testPrivateCall() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateCall.kt");
            }

            @TestMetadata("privateInCrossInline.kt")
            public void testPrivateInCrossInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInCrossInline.kt");
            }

            @TestMetadata("privateInDefaultStubArgument.kt")
            public void testPrivateInDefaultStubArgument() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInDefaultStubArgument.kt");
            }

            @TestMetadata("protectedInCrossinline.kt")
            public void testProtectedInCrossinline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedInCrossinline.kt");
            }

            @TestMetadata("protectedMembersFromSuper.kt")
            public void testProtectedMembersFromSuper() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedMembersFromSuper.kt");
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superCall.kt");
            }

            @TestMetadata("superInCrossInline.kt")
            public void testSuperInCrossInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superInCrossInline.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/trait")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Trait extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInTrait() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/trait"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("trait.kt")
        public void testTrait() throws Exception {
            runTest("compiler/testData/codegen/boxInline/trait/trait.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/tryCatchFinally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TryCatchFinally extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInTryCatchFinally() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/tryCatchFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("kt5863.kt")
        public void testKt5863() throws Exception {
            runTest("compiler/testData/codegen/boxInline/tryCatchFinally/kt5863.kt");
        }

        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch.kt");
        }

        @TestMetadata("tryCatch2.kt")
        public void testTryCatch2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch2.kt");
        }

        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatchFinally.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/varargs")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Varargs extends AbstractIrCodegenBoxInlineWasmTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest0(this::doTest, TargetBackend.WASM, testDataFilePath);
        }

        public void testAllFilesPresentInVarargs() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.WASM, true);
        }

        @TestMetadata("kt17653.kt")
        public void testKt17653() throws Exception {
            runTest("compiler/testData/codegen/boxInline/varargs/kt17653.kt");
        }

        @TestMetadata("varargAndDefaultParameters.kt")
        public void testVarargAndDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters.kt");
        }

        @TestMetadata("varargAndDefaultParameters2.kt")
        public void testVarargAndDefaultParameters2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters2.kt");
        }
    }
}
