/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.js.test.ir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("js/js.translator/testData/typescript-export")
@TestDataPath("$PROJECT_ROOT")
public class IrJsTypeScriptExportTestGenerated extends AbstractIrJsTypeScriptExportTest {
    @Test
    public void testAllFilesPresentInTypescript_export() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/classes")
    @TestDataPath("$PROJECT_ROOT")
    public class Classes {
        @Test
        public void testAllFilesPresentInClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/classes"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("inner-class.kt")
        public void testInner_class() throws Exception {
            runTest("js/js.translator/testData/typescript-export/classes/inner-class.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/constructors")
    @TestDataPath("$PROJECT_ROOT")
    public class Constructors {
        @Test
        public void testAllFilesPresentInConstructors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/constructors"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("constructors.kt")
        public void testConstructors() throws Exception {
            runTest("js/js.translator/testData/typescript-export/constructors/constructors.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/declarations")
    @TestDataPath("$PROJECT_ROOT")
    public class Declarations {
        @Test
        public void testAllFilesPresentInDeclarations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/declarations"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("declarations.kt")
        public void testDeclarations() throws Exception {
            runTest("js/js.translator/testData/typescript-export/declarations/declarations.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/escapedDeclarations")
    @TestDataPath("$PROJECT_ROOT")
    public class EscapedDeclarations {
        @Test
        public void testAllFilesPresentInEscapedDeclarations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/escapedDeclarations"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("escapedDeclarations.kt")
        public void testEscapedDeclarations() throws Exception {
            runTest("js/js.translator/testData/typescript-export/escapedDeclarations/escapedDeclarations.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/implicitExport")
    @TestDataPath("$PROJECT_ROOT")
    public class ImplicitExport {
        @Test
        public void testAllFilesPresentInImplicitExport() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/implicitExport"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("declarations.kt")
        public void testDeclarations() throws Exception {
            runTest("js/js.translator/testData/typescript-export/implicitExport/declarations.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/inheritance")
    @TestDataPath("$PROJECT_ROOT")
    public class Inheritance {
        @Test
        public void testAllFilesPresentInInheritance() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/inheritance"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            runTest("js/js.translator/testData/typescript-export/inheritance/inheritance.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/moduleSystems")
    @TestDataPath("$PROJECT_ROOT")
    public class ModuleSystems {
        @Test
        public void testAllFilesPresentInModuleSystems() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/moduleSystems"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("commonjs.kt")
        public void testCommonjs() throws Exception {
            runTest("js/js.translator/testData/typescript-export/moduleSystems/commonjs.kt");
        }

        @Test
        @TestMetadata("plain.kt")
        public void testPlain() throws Exception {
            runTest("js/js.translator/testData/typescript-export/moduleSystems/plain.kt");
        }

        @Test
        @TestMetadata("umd.kt")
        public void testUmd() throws Exception {
            runTest("js/js.translator/testData/typescript-export/moduleSystems/umd.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/namespaces")
    @TestDataPath("$PROJECT_ROOT")
    public class Namespaces {
        @Test
        public void testAllFilesPresentInNamespaces() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/namespaces"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("namespaces.kt")
        public void testNamespaces() throws Exception {
            runTest("js/js.translator/testData/typescript-export/namespaces/namespaces.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/primitives")
    @TestDataPath("$PROJECT_ROOT")
    public class Primitives {
        @Test
        public void testAllFilesPresentInPrimitives() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/primitives"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("primitives.kt")
        public void testPrimitives() throws Exception {
            runTest("js/js.translator/testData/typescript-export/primitives/primitives.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/selectiveExport")
    @TestDataPath("$PROJECT_ROOT")
    public class SelectiveExport {
        @Test
        public void testAllFilesPresentInSelectiveExport() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/selectiveExport"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("selectiveExport.kt")
        public void testSelectiveExport() throws Exception {
            runTest("js/js.translator/testData/typescript-export/selectiveExport/selectiveExport.kt");
        }
    }

    @Nested
    @TestMetadata("js/js.translator/testData/typescript-export/visibility")
    @TestDataPath("$PROJECT_ROOT")
    public class Visibility {
        @Test
        public void testAllFilesPresentInVisibility() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/typescript-export/visibility"), Pattern.compile("^([^_](.+))\\.kt$"), null, TargetBackend.JS_IR, true);
        }

        @Test
        @TestMetadata("visibility.kt")
        public void testVisibility() throws Exception {
            runTest("js/js.translator/testData/typescript-export/visibility/visibility.kt");
        }
    }
}
