/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.js.test.ir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/boxWasmJsInterop")
@TestDataPath("$PROJECT_ROOT")
public class IrCodegenWasmJsInteropJsTestGenerated extends AbstractIrCodegenWasmJsInteropJsTest {
    @Test
    public void testAllFilesPresentInBoxWasmJsInterop() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxWasmJsInterop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JS_IR, true);
    }

    @Test
    @TestMetadata("defaultValues.kt")
    public void testDefaultValues() throws Exception {
        runTest("compiler/testData/codegen/boxWasmJsInterop/defaultValues.kt");
    }

    @Test
    @TestMetadata("externalTypeOperators.kt")
    public void testExternalTypeOperators() throws Exception {
        runTest("compiler/testData/codegen/boxWasmJsInterop/externalTypeOperators.kt");
    }

    @Test
    @TestMetadata("externals.kt")
    public void testExternals() throws Exception {
        runTest("compiler/testData/codegen/boxWasmJsInterop/externals.kt");
    }

    @Test
    @TestMetadata("functionTypes.kt")
    public void testFunctionTypes() throws Exception {
        runTest("compiler/testData/codegen/boxWasmJsInterop/functionTypes.kt");
    }

    @Test
    @TestMetadata("jsExport.kt")
    public void testJsExport() throws Exception {
        runTest("compiler/testData/codegen/boxWasmJsInterop/jsExport.kt");
    }

    @Test
    @TestMetadata("types.kt")
    public void testTypes() throws Exception {
        runTest("compiler/testData/codegen/boxWasmJsInterop/types.kt");
    }
}
