/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.js.test;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("js/js.translator/testData/outputPrefixPostfix")
@TestDataPath("$PROJECT_ROOT")
public class OutputPrefixPostfixTestGenerated extends AbstractOutputPrefixPostfixTest {
    @Test
    public void testAllFilesPresentInOutputPrefixPostfix() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/outputPrefixPostfix"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JS, true);
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() throws Exception {
        runTest("js/js.translator/testData/outputPrefixPostfix/simple.kt");
    }

    @Test
    @TestMetadata("simpleWithPostfix.kt")
    public void testSimpleWithPostfix() throws Exception {
        runTest("js/js.translator/testData/outputPrefixPostfix/simpleWithPostfix.kt");
    }

    @Test
    @TestMetadata("simpleWithPrefix.kt")
    public void testSimpleWithPrefix() throws Exception {
        runTest("js/js.translator/testData/outputPrefixPostfix/simpleWithPrefix.kt");
    }

    @Test
    @TestMetadata("simpleWithPrefixAndPostfix.kt")
    public void testSimpleWithPrefixAndPostfix() throws Exception {
        runTest("js/js.translator/testData/outputPrefixPostfix/simpleWithPrefixAndPostfix.kt");
    }
}
