/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.incremental;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("js/js.translator/testData/incremental/invalidation")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class InvalidationTestGenerated extends AbstractInvalidationTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.JS_IR, testDataFilePath);
    }

    public void testAllFilesPresentInInvalidation() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("js/js.translator/testData/incremental/invalidation"), Pattern.compile("^([^_](.+))$"), null, TargetBackend.JS_IR, false);
    }

    @TestMetadata("class")
    public void testClass() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/class/");
    }

    @TestMetadata("classFunctionsAndFields")
    public void testClassFunctionsAndFields() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/classFunctionsAndFields/");
    }

    @TestMetadata("constVals")
    public void testConstVals() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/constVals/");
    }

    @TestMetadata("crossModuleReferences")
    public void testCrossModuleReferences() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/crossModuleReferences/");
    }

    @TestMetadata("fakeOverride")
    public void testFakeOverride() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/fakeOverride/");
    }

    @TestMetadata("fastPath1")
    public void testFastPath1() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/fastPath1/");
    }

    @TestMetadata("fastPath2")
    public void testFastPath2() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/fastPath2/");
    }

    @TestMetadata("functionDefaultParams")
    public void testFunctionDefaultParams() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/functionDefaultParams/");
    }

    @TestMetadata("functionSignature")
    public void testFunctionSignature() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/functionSignature/");
    }

    @TestMetadata("genericFunctions")
    public void testGenericFunctions() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/genericFunctions/");
    }

    @TestMetadata("genericInlineFunctions")
    public void testGenericInlineFunctions() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/genericInlineFunctions/");
    }

    @TestMetadata("gettersAndSettersInlining")
    public void testGettersAndSettersInlining() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/gettersAndSettersInlining/");
    }

    @TestMetadata("inlineBecomeNonInline")
    public void testInlineBecomeNonInline() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/inlineBecomeNonInline/");
    }

    @TestMetadata("inlineFunctionAsParam")
    public void testInlineFunctionAsParam() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/inlineFunctionAsParam/");
    }

    @TestMetadata("inlineFunctionDefaultParams")
    public void testInlineFunctionDefaultParams() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/inlineFunctionDefaultParams/");
    }

    @TestMetadata("jsCode")
    public void testJsCode() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/jsCode/");
    }

    @TestMetadata("jsExport")
    public void testJsExport() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/jsExport/");
    }

    @TestMetadata("mainModuleInvalidation")
    public void testMainModuleInvalidation() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/mainModuleInvalidation/");
    }

    @TestMetadata("moveFilesBetweenModules")
    public void testMoveFilesBetweenModules() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/moveFilesBetweenModules/");
    }

    @TestMetadata("moveInlineFunctionBetweenModules")
    public void testMoveInlineFunctionBetweenModules() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/moveInlineFunctionBetweenModules/");
    }

    @TestMetadata("nonInlineBecomeInline")
    public void testNonInlineBecomeInline() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/nonInlineBecomeInline/");
    }

    @TestMetadata("privateInlineFunction1")
    public void testPrivateInlineFunction1() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/privateInlineFunction1/");
    }

    @TestMetadata("removeFile")
    public void testRemoveFile() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/removeFile/");
    }

    @TestMetadata("removeModule")
    public void testRemoveModule() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/removeModule/");
    }

    @TestMetadata("removeUnusedFile")
    public void testRemoveUnusedFile() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/removeUnusedFile/");
    }

    @TestMetadata("renameFile")
    public void testRenameFile() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/renameFile/");
    }

    @TestMetadata("simple")
    public void testSimple() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/simple/");
    }

    @TestMetadata("suspendFunctions")
    public void testSuspendFunctions() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/suspendFunctions/");
    }

    @TestMetadata("transitiveInlineFunction")
    public void testTransitiveInlineFunction() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/transitiveInlineFunction/");
    }

    @TestMetadata("unicodeSerializationAndDeserialization")
    public void testUnicodeSerializationAndDeserialization() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/unicodeSerializationAndDeserialization/");
    }

    @TestMetadata("variance")
    public void testVariance() throws Exception {
        runTest("js/js.translator/testData/incremental/invalidation/variance/");
    }
}
