# CHANGELOG


## 1.5.32

### Tools. Gradle. Multiplatform

- [`KT-49798`](https://youtrack.jetbrains.com/issue/KT-49798) [MPP] [Android] AGP 7.1.0+ android target publications leak 'AgpVersionAttr' attribute


## 1.5.31

### Compiler

#### Fixes

- [`KT-48659`](https://youtrack.jetbrains.com/issue/KT-48659) JVM / IR: Referential equality returns true for different instances
- [`KT-48613`](https://youtrack.jetbrains.com/issue/KT-48613) Kotlin/Native fails to compile debug binaries for watchosArm64 target
- [`KT-48316`](https://youtrack.jetbrains.com/issue/KT-48316) "No value passed for parameter" regression with Java annotation default values with JSR-305
- [`KT-48343`](https://youtrack.jetbrains.com/issue/KT-48343) Mistake in an error message for uninferred type variable without unrestricted builder inference
- [`KT-48543`](https://youtrack.jetbrains.com/issue/KT-48543) Native compiler crashes because of bridges for $default stubs
- [`KT-48349`](https://youtrack.jetbrains.com/issue/KT-48349) OptIn markers are forbidden on local variable / value parameter / property getter only in presence of explicit Target annotation
- [`KT-48295`](https://youtrack.jetbrains.com/issue/KT-48295) JVM / IR: VerifyError: Bad access to protected data in getfield
- [`KT-48551`](https://youtrack.jetbrains.com/issue/KT-48551) JVM / IR: "IllegalStateException: Inline class has no primary constructor" caused by inline class from one module and `fun interface` from another
- [`KT-47917`](https://youtrack.jetbrains.com/issue/KT-47917) JVM: "UTF8 string too large" caused by a big string
- [`KT-48440`](https://youtrack.jetbrains.com/issue/KT-48440) JVM IR: Missing checkcast in generated bytecode causes VerifyError in Kotlin 1.5.30
- [`KT-48361`](https://youtrack.jetbrains.com/issue/KT-48361) INTEGER_OPERATOR_RESOLVE_WILL_CHANGE is not reported in some positions
- [`KT-48267`](https://youtrack.jetbrains.com/issue/KT-48267) JVM IR: CCE on callable reference to Array constructor passed to inline function

### IDE

- [`KTIJ-15744`](https://youtrack.jetbrains.com/issue/KTIJ-15744) Reopening build.gradle.kts-based project reports MISSING_SCRIPT_BASE_CLASS KotlinBuildScript until re-import
- [`KTIJ-19005`](https://youtrack.jetbrains.com/issue/KTIJ-19005) JDK 17: "PermittedSubclasses requires ASM9" exception multiple times per second during analysis
- [`KTIJ-19504`](https://youtrack.jetbrains.com/issue/KTIJ-19504) IDE highlighting: Kotlin plugin 1.5.30 started showing some valid classes from multiplatform libraries as not existing

### Native

- [`KT-48591`](https://youtrack.jetbrains.com/issue/KT-48591) Kotlin/Native: Char.isHighSurrogate and Char.isLowSurrogate return wrong result for macosArm64 and iosArm64 with compiler cache enabled
- [`KT-48491`](https://youtrack.jetbrains.com/issue/KT-48491) CInterop broke in Kotlin 1.5.30


## 1.5.30

### Backend. Native. Debug

- [`KT-47405`](https://youtrack.jetbrains.com/issue/KT-47405) Incorrect path from inlined method in stacktrace on iOS-simulator ARM64
- [`KT-47408`](https://youtrack.jetbrains.com/issue/KT-47408) Incorrect line number of inlined method on iOS-simulator ARM64

### Compiler

#### New Features

- [`KT-44261`](https://youtrack.jetbrains.com/issue/KT-44261) Support RxJava 3 nullability annotations
- [`KT-32443`](https://youtrack.jetbrains.com/issue/KT-32443) Experimental declarations should be contagious even when they are not explicitly used
- [`KT-45844`](https://youtrack.jetbrains.com/issue/KT-45844) Forbid using experimental markers on override declarations
- [`KT-45845`](https://youtrack.jetbrains.com/issue/KT-45845) Forbid using experimental markers on getter
- [`KT-46644`](https://youtrack.jetbrains.com/issue/KT-46644) Resolve overrides for IrProperty on deserialization
- [`KT-46967`](https://youtrack.jetbrains.com/issue/KT-46967) Support class type parameters annotations in FIR
- [`KT-47402`](https://youtrack.jetbrains.com/issue/KT-47402) Native: optimize access to object declarations that have only const vals and no init blocks
- [`KT-47709`](https://youtrack.jetbrains.com/issue/KT-47709) Make when statements with enum, sealed, and Boolean subjects exhaustive by default
- [`KT-47699`](https://youtrack.jetbrains.com/issue/KT-47699) Support programmatic creation of class annotations and corresponding feature flag on JVM

#### Performance Improvements

- [`KT-45103`](https://youtrack.jetbrains.com/issue/KT-45103) Direct invoke optimization
- [`KT-47785`](https://youtrack.jetbrains.com/issue/KT-47785) Compilation time increased when trying to compile AssertJ DB expression in 1.5.21

#### Fixes

- [`KT-48361`](https://youtrack.jetbrains.com/issue/KT-48361) INTEGER_OPERATOR_RESOLVE_WILL_CHANGE is not reported in some positions
- [`KT-48180`](https://youtrack.jetbrains.com/issue/KT-48180) JVM / IR: AssertionError: "Lambda with offset already exists" caused by calling inline function with default lambda parameter
- [`KT-47328`](https://youtrack.jetbrains.com/issue/KT-47328) JVM / IR: NoSuchFieldError with missing CHECKCAST
- [`KT-48172`](https://youtrack.jetbrains.com/issue/KT-48172) "IllegalStateException: Cannot serialize error type: [ERROR : <LOOP IN SUPERTYPES>]" in 1.5.21 with java kotlin interop
- [`KT-48230`](https://youtrack.jetbrains.com/issue/KT-48230) JVM IR: CCE for multiple receivers case
- [`KT-48262`](https://youtrack.jetbrains.com/issue/KT-48262) "Inconsistent type" with JSpecify @NullMarked
- [`KT-48167`](https://youtrack.jetbrains.com/issue/KT-48167) JVM / IR: If Map#entrySet is implemented in an interface, Kotlin compiler generates incorrect code for its implementation
- [`KT-47988`](https://youtrack.jetbrains.com/issue/KT-47988) JVM / IR: "VerifyError: Bad type on operand stack" when invoking apply with a local method reference
- [`KT-48163`](https://youtrack.jetbrains.com/issue/KT-48163) JVM / IR: "VerifyError: Bad type on operand stack" when throwing result of smartcast
- [`KT-47833`](https://youtrack.jetbrains.com/issue/KT-47833) False positive "Type argument is not within its bounds " with upcasting in 1.5.30-M1
- [`KT-47830`](https://youtrack.jetbrains.com/issue/KT-47830) Some code doesn't compile with unrestricted builder inference
- [`KT-39883`](https://youtrack.jetbrains.com/issue/KT-39883) Deprecate computing constant values if complex boolean expressions in when condition branches and conditions of loops
- [`KT-47037`](https://youtrack.jetbrains.com/issue/KT-47037) Eliminate builder inference restrictions
- [`KT-46726`](https://youtrack.jetbrains.com/issue/KT-46726) IR + BuilderInference: AssertionError: Unbound private symbol <ERROR CLASS> on usage of this in a BuilderInference lambda
- [`KT-43855`](https://youtrack.jetbrains.com/issue/KT-43855) Support gradual introduction of new nullability annotations
- [`KT-43142`](https://youtrack.jetbrains.com/issue/KT-43142) FIR: Check UPPER_BOUND_VIOLATED for type alias constructors properly
- [`KT-45228`](https://youtrack.jetbrains.com/issue/KT-45228) Leaking builder inference type variables though callable references
- [`KT-42270`](https://youtrack.jetbrains.com/issue/KT-42270) NI: NEW_INFERENCE_NO_INFORMATION_FOR_PARAMETER for BuilderInference with extension functions
- [`KT-46029`](https://youtrack.jetbrains.com/issue/KT-46029) JVM / IR: "Unbound private symbol: <ERROR CLASS>" when trying to save SequenceScope in property
- [`KT-45258`](https://youtrack.jetbrains.com/issue/KT-45258) Wrong CST between types which contain stub type
- [`KT-45224`](https://youtrack.jetbrains.com/issue/KT-45224) Type safety problem through leaking of the builder inference scope
- [`KT-22852`](https://youtrack.jetbrains.com/issue/KT-22852) Report diagnostics on implicit usages of experimental API
- [`KT-22941`](https://youtrack.jetbrains.com/issue/KT-22941) Experimental marker annotation with SOURCE retention is compiled without error
- [`KT-24993`](https://youtrack.jetbrains.com/issue/KT-24993) Inference for buildSequence/yield doesn't work for labeled lambdas
- [`KT-31728`](https://youtrack.jetbrains.com/issue/KT-31728) Incorrect EXPERIMENTAL_OVERRIDE_ERROR for override of experimental function in anonymous object
- [`KT-33364`](https://youtrack.jetbrains.com/issue/KT-33364) Kotlin/Native debugger: execution stops only at next line for breakpoint at when expression without parameter
- [`KT-42139`](https://youtrack.jetbrains.com/issue/KT-42139) NI: NEW_INFERENCE_NO_INFORMATION_FOR_PARAMETER for emptyList / listOf (with no arguments) / emptyMap / mapOf (with no arguments) inside if block inside `sequence` block
- [`KT-44241`](https://youtrack.jetbrains.com/issue/KT-44241) NI: BuilderInference regression
- [`KT-44372`](https://youtrack.jetbrains.com/issue/KT-44372) FIR: KClass::java cannot be resolved as callable reference
- [`KT-44547`](https://youtrack.jetbrains.com/issue/KT-44547) Native: wrong RTTI when overriding functions with equal signatures but different type arguments
- [`KT-44571`](https://youtrack.jetbrains.com/issue/KT-44571) Segfault on unnecessary int unboxing
- [`KT-45083`](https://youtrack.jetbrains.com/issue/KT-45083) Problem with property reference in builder inference
- [`KT-45315`](https://youtrack.jetbrains.com/issue/KT-45315) Deprecate (V)::a reference resolution to companion in FE 1.0
- [`KT-46393`](https://youtrack.jetbrains.com/issue/KT-46393) AE: "1 trailing arguments were found in Any<T> type" for private function with implicit anonymous return type inside generic class
- [`KT-46661`](https://youtrack.jetbrains.com/issue/KT-46661) FIR: Investigate inference issue with self-types and star projection
- [`KT-46775`](https://youtrack.jetbrains.com/issue/KT-46775) [Native] [IR] Support multiple suspend lambdas as class supertypes
- [`KT-46836`](https://youtrack.jetbrains.com/issue/KT-46836) Error: Invalid LLVM module on inlineClasses external tests
- [`KT-46838`](https://youtrack.jetbrains.com/issue/KT-46838) NullPointerException: Parameter specified as non-null is null in CollectionsKt.joinToString()
- [`KT-46896`](https://youtrack.jetbrains.com/issue/KT-46896) Native IR: NPE when using irBuiltIns.suspendFunction
- [`KT-46996`](https://youtrack.jetbrains.com/issue/KT-46996) FIR: INFERENCE_NO_INFORMATION_FOR_PARAMETER on type aliases with non-trivial expansions
- [`KT-47034`](https://youtrack.jetbrains.com/issue/KT-47034) KtValueArgument.getArgumentExpression could lead to StubBasedPsiElementBase.notBoundInExistingAst
- [`KT-47052`](https://youtrack.jetbrains.com/issue/KT-47052) BuilderInference case with flatMapTo doesn't work properly
- [`KT-47082`](https://youtrack.jetbrains.com/issue/KT-47082) Stub type variable is leaked (reproduces with K/N during deserialization)
- [`KT-47143`](https://youtrack.jetbrains.com/issue/KT-47143) ClassicTypeSystemContext couldn't handle: Captured(*) in Kotlin 1.5.0
- [`KT-47148`](https://youtrack.jetbrains.com/issue/KT-47148) Type mismatch: inferred type is Any? but T? was expected
- [`KT-47180`](https://youtrack.jetbrains.com/issue/KT-47180) Forbid using OptIn markers on local variable, value parameter or field
- [`KT-47181`](https://youtrack.jetbrains.com/issue/KT-47181) Forbid using OptIn markers on types or type parameters
- [`KT-47183`](https://youtrack.jetbrains.com/issue/KT-47183) Segfault on int unboxing
- [`KT-47208`](https://youtrack.jetbrains.com/issue/KT-47208) Backend Internal error: Exception during IR lowering: assert at IrOverridingUtilKt.buildFakeOverrideMember
- [`KT-47276`](https://youtrack.jetbrains.com/issue/KT-47276) Nullability annotations without target are ignored if type enhancement improvements are enabled
- [`KT-47450`](https://youtrack.jetbrains.com/issue/KT-47450) StackOverflowException in psi2ir with many chained binary expressions
- [`KT-47462`](https://youtrack.jetbrains.com/issue/KT-47462) K/N: AssertionError: Unbound private symbol org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl@6cb748db (NON-PUBLIC API): deserialized class Companion
- [`KT-47941`](https://youtrack.jetbrains.com/issue/KT-47941) "IllegalStateException: Expected some types" on a call with several excepted type constraints
- [`KT-47854`](https://youtrack.jetbrains.com/issue/KT-47854) "IllegalArgumentException: Type is inconsistent" with Android's @Nullable annotation starting in Kotlin 1.5.20
- [`KT-47899`](https://youtrack.jetbrains.com/issue/KT-47899) "AssertionError: Intersection type should not be marked nullable" with 1.5.21
- [`KT-47846`](https://youtrack.jetbrains.com/issue/KT-47846) Stack overflow when handling enhanced recursive type parameter
- [`KT-47747`](https://youtrack.jetbrains.com/issue/KT-47747) Introduce specific error for calls which could be resolved only with unrestricted builder inference
- [`KT-47739`](https://youtrack.jetbrains.com/issue/KT-47739) JVM / IR: NoSuchFieldError with generic sealed classes
- [`KT-47422`](https://youtrack.jetbrains.com/issue/KT-47422) -Xjspecify-annotations: If a class has a @Nullable type-parameter bound, Kotlin should still treat some users' type arguments as platform types
- [`KT-47437`](https://youtrack.jetbrains.com/issue/KT-47437) Type inference failure with raw types under -Xjspecify-annotations=strict
- [`KT-47396`](https://youtrack.jetbrains.com/issue/KT-47396) <?> in @NullMarked code should permit nullable types
- [`KT-47729`](https://youtrack.jetbrains.com/issue/KT-47729) False positive INTEGER_OPERATOR_RESOLVE_WILL_CHANGE warning: "expression will be resolved to Int in future releases"
- [`KT-47333`](https://youtrack.jetbrains.com/issue/KT-47333) Xcode 13: Compilation for iOS simulator fails
- [`KT-47772`](https://youtrack.jetbrains.com/issue/KT-47772) False negative WRONG_ANNOTATION_TARGET on type argument to function call
- [`KT-47467`](https://youtrack.jetbrains.com/issue/KT-47467) JVM / IR: "AssertionError: Annotation class expected: deserialized class Array" caused by java annotation as a parameter of another annotation
- [`KT-47744`](https://youtrack.jetbrains.com/issue/KT-47744) UninitializedPropertyAccessException compiler exception on nested builder inference calls
- [`KT-47724`](https://youtrack.jetbrains.com/issue/KT-47724) Type inference: False positive "Returning type parameter has been inferred to Nothing implicitly"
- [`KT-47660`](https://youtrack.jetbrains.com/issue/KT-47660) JVM / IR: Mockito verification fails when named parameters are ordered differently
- [`KT-47589`](https://youtrack.jetbrains.com/issue/KT-47589) Using RequiresOptIn annotation on constructor property results in error even if the annotation has no VALUE_PARAMETER target

### Docs & Examples

- [`KT-47649`](https://youtrack.jetbrains.com/issue/KT-47649) Important note about KJS IR compiler and stdlib compatibility in 1.5.30

### IDE

- [`KT-44643`](https://youtrack.jetbrains.com/issue/KT-44643) ISE: Could not generate LightClass for some declared in <null> on initialisation by `lazy` in a JVM module of a multiplatform project
- [`KT-47947`](https://youtrack.jetbrains.com/issue/KT-47947) Add language version 1.6 to the compiler configuration preferences

### IDE. Gradle Integration

- [`KT-47163`](https://youtrack.jetbrains.com/issue/KT-47163) KJS / Gradle: `Could not resolve <artifact>` despite being resolvable & project buildable

### IDE. JS

- [`KT-46548`](https://youtrack.jetbrains.com/issue/KT-46548) KJS: Create an IDE plugin to help with migration to and keeping compatibility with JS IR BE
- [`KT-47557`](https://youtrack.jetbrains.com/issue/KT-47557) KJS: With NPM dependency IDEA import fails when performed before Gradle build

### JavaScript

- [`KT-46204`](https://youtrack.jetbrains.com/issue/KT-46204) KJS / IR: Support `SuspendFunctionN` as super type
- [`KT-38363`](https://youtrack.jetbrains.com/issue/KT-38363) JS IR BE: support IC for lowerings
- [`KT-41651`](https://youtrack.jetbrains.com/issue/KT-41651) JS IR BE: DCE removes `render` method from react components passed to the kotlinx.react
- [`KT-46520`](https://youtrack.jetbrains.com/issue/KT-46520) KJS / IR: ISE "Can't find name for declaration FUN name:CharArray_init_$Create$" on callable reference to Array constructor
- [`KT-45738`](https://youtrack.jetbrains.com/issue/KT-45738) KJS / IR: Wrong generated code for `when` statement
- [`KT-46551`](https://youtrack.jetbrains.com/issue/KT-46551) KJS / IR: Add a basic sourcemap generation

### Libraries

- [`KT-47477`](https://youtrack.jetbrains.com/issue/KT-47477) Could not resolve kotlin-test during project import in case of multiplatform with only JVM target platform
- [`KT-47675`](https://youtrack.jetbrains.com/issue/KT-47675) Converting Double to Duration may expose inexactness
- [`KT-47419`](https://youtrack.jetbrains.com/issue/KT-47419) Remove method of the MapBuilder iterator throws IOOBE instead of IllegalStateException
- [`KT-47211`](https://youtrack.jetbrains.com/issue/KT-47211) Kotlin Native - AbstractMutableList.addAll (with index) does not throw IndexOutOfBoundsException if elements is empty
- [`KT-23351`](https://youtrack.jetbrains.com/issue/KT-23351) Regex.splitToSequence, CharSequence.splitToSequence(Regex)
- [`KT-42851`](https://youtrack.jetbrains.com/issue/KT-42851) kotlin.time.Duration toString() shows wrong result for seconds
- [`KT-45325`](https://youtrack.jetbrains.com/issue/KT-45325) Parsing Duration from String
- [`KT-34021`](https://youtrack.jetbrains.com/issue/KT-34021) Regex.matchAt / matchesAt

### Native

- [`KT-35001`](https://youtrack.jetbrains.com/issue/KT-35001) warning: linking module flags 'SDK Version': IDs have conflicting values ('[2 x i32] [i32 13, i32 2]'
- [`KT-43475`](https://youtrack.jetbrains.com/issue/KT-43475) Kotlin/Native compiler: Including a static C library increased cross-compilation time from 3.5minutes to 1 hour 40 minutes
- [`KT-44148`](https://youtrack.jetbrains.com/issue/KT-44148) Escape analysis failure: Heap space out of memory

### Native. C and ObjC Import

- [`KT-46711`](https://youtrack.jetbrains.com/issue/KT-46711) platform.windows._LARGE_INTEGER cannot be passed by value

### Native. ObjC Export

- [`KT-43780`](https://youtrack.jetbrains.com/issue/KT-43780) Improve Swift/Obj-C ergonomics for object and companion object
- [`KT-46431`](https://youtrack.jetbrains.com/issue/KT-46431) KMP accessing a property of an anonymous inner class that inherits from an abstract class causes a 'NSGenericException', reason: '[Shared_kobjcc0 ] is abstract' exception.
- [`KT-47042`](https://youtrack.jetbrains.com/issue/KT-47042) Kotlin/Native: Concurrency Interoperability with Objective-C (Swift 5.5)

### Native. Stdlib

- [`KT-47915`](https://youtrack.jetbrains.com/issue/KT-47915) Kotlin/Native: Provide access to test cases generated by the compiler

### Native. Platforms

- [`KT-44321`](https://youtrack.jetbrains.com/issue/KT-44321) Support Apple Silicon without Rosetta 2

### Reflection

- [`KT-18277`](https://youtrack.jetbrains.com/issue/KT-18277) InvalidProtocolBufferException: Stream closed on multithreaded access to built-ins data in reflection
- [`KT-44977`](https://youtrack.jetbrains.com/issue/KT-44977) Reflection: ClassCastException caused by annotations with "AnnotationTarget.TYPE" usage on array attributes access
- [`KT-47650`](https://youtrack.jetbrains.com/issue/KT-47650) KClass::nestedClasses throws ClassCastException for script classes with type aliases

### Tools. CLI

- [`KT-47623`](https://youtrack.jetbrains.com/issue/KT-47623) Deprecate -Xuse-experimental
- [`KT-30778`](https://youtrack.jetbrains.com/issue/KT-30778) kotlin-compiler.jar contains shaded but not relocated kotlinx.coroutines
- [`KT-40979`](https://youtrack.jetbrains.com/issue/KT-40979) CLI: Executing "kotlinc.bat" at a root path, errors are not reported with a correct filepath
- [`KT-40994`](https://youtrack.jetbrains.com/issue/KT-40994) CLI: Add documentation for -J argument in `kotlinc -help`
- [`KT-46764`](https://youtrack.jetbrains.com/issue/KT-46764) CLI: Java record defined in a single file root is not resolved

### Tools. Commonizer

- [`KT-47433`](https://youtrack.jetbrains.com/issue/KT-47433) [Commonizer] Commonize functions/properties with TA/Class types in signature
- [`KT-47691`](https://youtrack.jetbrains.com/issue/KT-47691) [Commonizer] Commonize `var` and `val`  properties
- [`KT-47434`](https://youtrack.jetbrains.com/issue/KT-47434) [Commonizer] Commonize parameterized (type-alias + class) types
- [`KT-47432`](https://youtrack.jetbrains.com/issue/KT-47432) [Commonizer] Commonize (type-alias + class) types used in functions
- [`KT-45992`](https://youtrack.jetbrains.com/issue/KT-45992) [Commonizer] Allow commonization of TypeAlias and Class with same name
- [`KT-46716`](https://youtrack.jetbrains.com/issue/KT-46716) [Commonizer] Analyze leaf source sets with original platform libraries
- [`KT-46957`](https://youtrack.jetbrains.com/issue/KT-46957) [Commonizer] Unresolved classifier: platform/posix/ptrdiff_t for linuxMips32
- [`KT-47133`](https://youtrack.jetbrains.com/issue/KT-47133) Forbid cinterop commonization with hierarchical commonization turned off
- [`KT-47301`](https://youtrack.jetbrains.com/issue/KT-47301) [Commonizer] Associative commonization

### Tools. Compiler Plugins

- [`KT-46723`](https://youtrack.jetbrains.com/issue/KT-46723) Kotlin Lombok: JPS: config file is searched in directory relative to compiler daemon
- [`KT-46739`](https://youtrack.jetbrains.com/issue/KT-46739) @SerialInfo NPE with default parameter

### Tools. Daemon

- [`KT-47152`](https://youtrack.jetbrains.com/issue/KT-47152) Incremental Compilation with Kotlin compile daemon and JDK 17 fails with IllegalAccessException

### Tools. Gradle

#### New Features

- [`KT-45757`](https://youtrack.jetbrains.com/issue/KT-45757) Add an easier way to explicitly set Kotlin daemon jvm arguments

#### Fixes

- [`KT-47940`](https://youtrack.jetbrains.com/issue/KT-47940) Kotlin JVM toolchain breaks configuration cache
- [`KT-46626`](https://youtrack.jetbrains.com/issue/KT-46626) kotlin-android plugin with kotlin-dsl: Extension with name 'android' does not exist. Currently registered extension names: [ext, kotlin, kotlinTestRegistry]
- [`KT-47754`](https://youtrack.jetbrains.com/issue/KT-47754) “'compileDebugUnitTestJavaWithJavac' task (current target is 1.8)” during build android project without specified target and with jvmToolchain = JDK 11
- [`KT-47520`](https://youtrack.jetbrains.com/issue/KT-47520) Kotlin and Java target compatibility check produces false positive on using Gradle toolchains
- [`KT-46978`](https://youtrack.jetbrains.com/issue/KT-46978) Duplicate resource errors on gradle 7 with multi-module multiplatform project with withJava
- [`KT-27687`](https://youtrack.jetbrains.com/issue/KT-27687) Empty directories in source set causes gradle cache miss for KotlinCompile task
- [`KT-47635`](https://youtrack.jetbrains.com/issue/KT-47635) Kotlin version conflict on using 'noarg' Gradle plugin
- [`KT-47636`](https://youtrack.jetbrains.com/issue/KT-47636) Kotlin version conflict on using 'sam-with-receiver' Gradle plugin
- [`KT-47354`](https://youtrack.jetbrains.com/issue/KT-47354) Kotlin version conflict on using 'allopen' Gradle plugin
- [`KT-45202`](https://youtrack.jetbrains.com/issue/KT-45202) Kapt crashes with java.io.UTFDataFormatException
- [`KT-13258`](https://youtrack.jetbrains.com/issue/KT-13258) Kotlin compiler doesn't respect Gradle's "sourceCompatibility" and "targetCompatibility"
- [`KT-43095`](https://youtrack.jetbrains.com/issue/KT-43095) Add support for Java Toolchain to the Gradle plugin
- [`KT-45611`](https://youtrack.jetbrains.com/issue/KT-45611) KGP should declare JDK version as input
- [`KT-47185`](https://youtrack.jetbrains.com/issue/KT-47185) Migrate Gradle Integration tests to use cache redirector
- [`KT-48226`](https://youtrack.jetbrains.com/issue/KT-48226) Kotlin toolchain does not set 'jvmTarget' for Kotlin tasks on configuration cache reuse
- [`KT-44279`](https://youtrack.jetbrains.com/issue/KT-44279) Kotlin-Android Gradle Plugin (KGP) should react to application of AGP rather than assume it was applied first
- [`KT-44041`](https://youtrack.jetbrains.com/issue/KT-44041) PersistentEnumeratorBase$CorruptedException: PersistentEnumerator storage corrupted
-
### Tools. Gradle. JS

- [`KT-47436`](https://youtrack.jetbrains.com/issue/KT-47436) KJS / IR: Compiler plugins not provided to link task
- [`KT-46693`](https://youtrack.jetbrains.com/issue/KT-46693) KJS: Update node.js version used inside gradle to latest 14.x
- [`KT-47559`](https://youtrack.jetbrains.com/issue/KT-47559) KJS / Gradle: Run task created using eager API and breaks task configuration avoidance
- [`KT-47176`](https://youtrack.jetbrains.com/issue/KT-47176) KJS: Actualize NPM dependencies
- [`KT-47154`](https://youtrack.jetbrains.com/issue/KT-47154) KJS / Gradle: Compile task reads dependencies metadata from filesystem too long on large projects
- [`KT-47114`](https://youtrack.jetbrains.com/issue/KT-47114) KJS / IR: Could not resolve `coroutines-core-js`
- [`KT-43379`](https://youtrack.jetbrains.com/issue/KT-43379) KJS / Gradle: On windows, an invalid regex is generated for Webpack ProgressPlugin

### Tools. Gradle. Multiplatform

- [`KT-47210`](https://youtrack.jetbrains.com/issue/KT-47210) [Commonizer] Avoid commonization of test source set hierarchy if possible
- [`KT-46279`](https://youtrack.jetbrains.com/issue/KT-46279) [Commonizer] Gradle 7.0 will emit warning for metadata compilation in multimodule builds
- [`KT-47126`](https://youtrack.jetbrains.com/issue/KT-47126) ios() target shortcuts should not include Apple Silicon by default
- [`KT-38111`](https://youtrack.jetbrains.com/issue/KT-38111) Gradle DSL: rename useExperimentalAnnotation function
- [`KT-47126`](https://youtrack.jetbrains.com/issue/KT-47126) ios() target shortcuts should not include Apple Silicon by default
- [`KT-47612`](https://youtrack.jetbrains.com/issue/KT-47612) Task :buildKotlinToolingMetadata is incompatible with Gradle configuration cache
- [`KT-47611`](https://youtrack.jetbrains.com/issue/KT-47611) Task :generateMetadataFileForKotlinMultiplatformPublication is incompatible with Gradle configuration cache

### Tools. Gradle. Native

- [`KT-42023`](https://youtrack.jetbrains.com/issue/KT-42023) Kotlin Native Cocoapods plugin fails when Xcode project has custom CONFIGURATION names
- [`KT-47653`](https://youtrack.jetbrains.com/issue/KT-47653) Support multi arch build via embedAndSign task
- [`KT-47078`](https://youtrack.jetbrains.com/issue/KT-47078) Support Apple Silicon in cocoapods gradle plugin
- [`KT-47077`](https://youtrack.jetbrains.com/issue/KT-47077) Support Apple Silicon in embedAndSign task

### Tools. Incremental Compile

- [`KT-27660`](https://youtrack.jetbrains.com/issue/KT-27660) JS Incremental compilation fails with java.io.IOException: java.lang.ArrayIndexOutOfBoundsException: Array index out of range: 0
- [`KT-36865`](https://youtrack.jetbrains.com/issue/KT-36865) IC: "ArrayIndexOutOfBoundsException: Array index out of range: 0"
- [`KT-35532`](https://youtrack.jetbrains.com/issue/KT-35532) Incremental compilation often fails on @JVMMultifileClass
- [`KT-19806`](https://youtrack.jetbrains.com/issue/KT-19806) IncrementalPackagePartProvider cache corruption causes frontend exception

### Tools. JPS

- [`KT-47753`](https://youtrack.jetbrains.com/issue/KT-47753) JPS: "IndexOutOfBoundsException: Index 0 out of bounds for length 0": Rebuild triggered due to IOOBE in `kotlin.incremental.LookupStorage.<init>`
- [`KT-46804`](https://youtrack.jetbrains.com/issue/KT-46804) Slow Kotlin incremental build: LookupStorage operations
- [`KT-45763`](https://youtrack.jetbrains.com/issue/KT-45763) Failing tests in KotlinIDE

### Tools. Maven

- [`KT-45689`](https://youtrack.jetbrains.com/issue/KT-45689) JDK-16: kotlin-maven-plugin fails with `IllegalAccessError: class com.intellij.util.io.FileChannelUtil` when using incremental compilation

### Tools. Scripts

- [`KT-43917`](https://youtrack.jetbrains.com/issue/KT-43917) Gradle dependency conflict with resolutionStrategy failOnVersionConflict and kotlin 1.4
- [`KT-46646`](https://youtrack.jetbrains.com/issue/KT-46646) Scripts: ArrayIndexOutOfBoundsException on an empty script running

### Tools. REPL

- [`KT-47783`](https://youtrack.jetbrains.com/issue/KT-47783) REPL: Keywords completion appears after numeric and string literals

### Tools. kapt

- [`KT-47583`](https://youtrack.jetbrains.com/issue/KT-47583) KaptJavaLog fails on Java 17 due to removed constructor in com.sun.tools.javac.util.Log
- [`KT-47347`](https://youtrack.jetbrains.com/issue/KT-47347) KAPT: Stub generation in Gradle cache is not consistently relocatable
- [`KT-46651`](https://youtrack.jetbrains.com/issue/KT-46651) KAPT: "Source file or directory not found" - kaptGenerateStubsDebugKotlin task does not track source files properly with configuration cache enabled


## 1.5.30-RC

### Backend. Native. Debug

- [`KT-47405`](https://youtrack.jetbrains.com/issue/KT-47405) Incorrect path from inlined method in stacktrace on iOS-simulator ARM64
- [`KT-47408`](https://youtrack.jetbrains.com/issue/KT-47408) Incorrect line number of inlined method on iOS-simulator ARM64

### Compiler

#### New Features

- [`KT-47709`](https://youtrack.jetbrains.com/issue/KT-47709) Make when statements with enum, sealed, and Boolean subjects exhaustive by default
- [`KT-47699`](https://youtrack.jetbrains.com/issue/KT-47699) Support programmatic creation of class annotations and corresponding feature flag on JVM

#### Performance Improvements

- [`KT-47785`](https://youtrack.jetbrains.com/issue/KT-47785) Compilation time increased when trying to compile AssertJ DB expression in 1.5.21

#### Fixes

- [`KT-47941`](https://youtrack.jetbrains.com/issue/KT-47941) "IllegalStateException: Expected some types" on a call with several excepted type constraints
- [`KT-47854`](https://youtrack.jetbrains.com/issue/KT-47854) "IllegalArgumentException: Type is inconsistent" with Android's @Nullable annotation starting in Kotlin 1.5.20
- [`KT-47899`](https://youtrack.jetbrains.com/issue/KT-47899) "AssertionError: Intersection type should not be marked nullable" with 1.5.21
- [`KT-47846`](https://youtrack.jetbrains.com/issue/KT-47846) Stack overflow when handling enhanced recursive type parameter
- [`KT-47747`](https://youtrack.jetbrains.com/issue/KT-47747) Introduce specific error for calls which could be resolved only with unrestricted builder inference
- [`KT-47739`](https://youtrack.jetbrains.com/issue/KT-47739) JVM / IR: NoSuchFieldError with generic sealed classes
- [`KT-47422`](https://youtrack.jetbrains.com/issue/KT-47422) -Xjspecify-annotations: If a class has a @Nullable type-parameter bound, Kotlin should still treat some users' type arguments as platform types
- [`KT-47437`](https://youtrack.jetbrains.com/issue/KT-47437) Type inference failure with raw types under -Xjspecify-annotations=strict
- [`KT-47396`](https://youtrack.jetbrains.com/issue/KT-47396) <?> in @NullMarked code should permit nullable types
- [`KT-47729`](https://youtrack.jetbrains.com/issue/KT-47729) False positive INTEGER_OPERATOR_RESOLVE_WILL_CHANGE warning: "expression will be resolved to Int in future releases"
- [`KT-47333`](https://youtrack.jetbrains.com/issue/KT-47333) Xcode 13: Compilation for iOS simulator fails
- [`KT-47772`](https://youtrack.jetbrains.com/issue/KT-47772) False negative WRONG_ANNOTATION_TARGET on type argument to function call
- [`KT-47467`](https://youtrack.jetbrains.com/issue/KT-47467) JVM / IR: "AssertionError: Annotation class expected: deserialized class Array" caused by java annotation as a parameter of another annotation
- [`KT-47744`](https://youtrack.jetbrains.com/issue/KT-47744) UninitializedPropertyAccessException compiler exception on nested builder inference calls
- [`KT-47724`](https://youtrack.jetbrains.com/issue/KT-47724) Type inference: False positive "Returning type parameter has been inferred to Nothing implicitly"
- [`KT-47660`](https://youtrack.jetbrains.com/issue/KT-47660) JVM / IR: Mockito verification fails when named parameters are ordered differently
- [`KT-47589`](https://youtrack.jetbrains.com/issue/KT-47589) Using RequiresOptIn annotation on constructor property results in error even if the annotation has no VALUE_PARAMETER target

### IDE

- [`KT-47947`](https://youtrack.jetbrains.com/issue/KT-47947) Add language version 1.6 to the compiler configuration preferences

### Libraries

- [`KT-23351`](https://youtrack.jetbrains.com/issue/KT-23351) Regex.splitToSequence, CharSequence.splitToSequence(Regex)
- [`KT-42851`](https://youtrack.jetbrains.com/issue/KT-42851) kotlin.time.Duration toString() shows wrong result for seconds
- [`KT-45325`](https://youtrack.jetbrains.com/issue/KT-45325) Parsing Duration from String
- [`KT-34021`](https://youtrack.jetbrains.com/issue/KT-34021) Regex.matchAt / matchesAt

### Native. Stdlib

- [`KT-47915`](https://youtrack.jetbrains.com/issue/KT-47915) Kotlin/Native: Provide access to test cases generated by the compiler

### Reflection

- [`KT-47650`](https://youtrack.jetbrains.com/issue/KT-47650) KClass::nestedClasses throws ClassCastException for script classes with type aliases

### Tools. CLI

- [`KT-47623`](https://youtrack.jetbrains.com/issue/KT-47623) Deprecate -Xuse-experimental
- [`KT-30778`](https://youtrack.jetbrains.com/issue/KT-30778) kotlin-compiler.jar contains shaded but not relocated kotlinx.coroutines

### Tools. Commonizer

- [`KT-47433`](https://youtrack.jetbrains.com/issue/KT-47433) [Commonizer] Commonize functions/properties with TA/Class types in signature
- [`KT-47691`](https://youtrack.jetbrains.com/issue/KT-47691) [Commonizer] Commonize `var` and `val`  properties
- [`KT-47434`](https://youtrack.jetbrains.com/issue/KT-47434) [Commonizer] Commonize parameterized (type-alias + class) types
- [`KT-47432`](https://youtrack.jetbrains.com/issue/KT-47432) [Commonizer] Commonize (type-alias + class) types used in functions

### Tools. Daemon

- [`KT-47152`](https://youtrack.jetbrains.com/issue/KT-47152) Incremental Compilation with Kotlin compile daemon and JDK 17 fails with IllegalAccessException

### Tools. Gradle

#### New Features

- [`KT-45757`](https://youtrack.jetbrains.com/issue/KT-45757) Add an easier way to explicitly set Kotlin daemon jvm arguments

#### Fixes

- [`KT-47940`](https://youtrack.jetbrains.com/issue/KT-47940) Kotlin JVM toolchain breaks configuration cache
- [`KT-46626`](https://youtrack.jetbrains.com/issue/KT-46626) kotlin-android plugin with kotlin-dsl: Extension with name 'android' does not exist. Currently registered extension names: [ext, kotlin, kotlinTestRegistry]
- [`KT-47754`](https://youtrack.jetbrains.com/issue/KT-47754) “'compileDebugUnitTestJavaWithJavac' task (current target is 1.8)” during build android project without specified target and with jvmToolchain = JDK 11
- [`KT-47520`](https://youtrack.jetbrains.com/issue/KT-47520) Kotlin and Java target compatibility check produces false positive on using Gradle toolchains
- [`KT-46978`](https://youtrack.jetbrains.com/issue/KT-46978) Duplicate resource errors on gradle 7 with multi-module multiplatform project with withJava
- [`KT-27687`](https://youtrack.jetbrains.com/issue/KT-27687) Empty directories in source set causes gradle cache miss for KotlinCompile task
- [`KT-47635`](https://youtrack.jetbrains.com/issue/KT-47635) Kotlin version conflict on using 'noarg' Gradle plugin
- [`KT-47636`](https://youtrack.jetbrains.com/issue/KT-47636) Kotlin version conflict on using 'sam-with-receiver' Gradle plugin
- [`KT-47354`](https://youtrack.jetbrains.com/issue/KT-47354) Kotlin version conflict on using 'allopen' Gradle plugin
- [`KT-45202`](https://youtrack.jetbrains.com/issue/KT-45202) Kapt crashes with java.io.UTFDataFormatException

### Tools. Gradle. JS

- [`KT-47559`](https://youtrack.jetbrains.com/issue/KT-47559) KJS / Gradle: Run task created using eager API and breaks task configuration avoidance

### Tools. Gradle. Multiplatform

- [`KT-38111`](https://youtrack.jetbrains.com/issue/KT-38111) Gradle DSL: rename useExperimentalAnnotation function
- [`KT-47612`](https://youtrack.jetbrains.com/issue/KT-47612) Task :buildKotlinToolingMetadata is incompatible with Gradle configuration cache
- [`KT-47611`](https://youtrack.jetbrains.com/issue/KT-47611) Task :generateMetadataFileForKotlinMultiplatformPublication is incompatible with Gradle configuration cache

### Tools. Gradle. Native

- [`KT-47653`](https://youtrack.jetbrains.com/issue/KT-47653) Support multi arch build via embedAndSign task
- [`KT-47078`](https://youtrack.jetbrains.com/issue/KT-47078) Support Apple Silicon in cocoapods gradle plugin
- [`KT-47077`](https://youtrack.jetbrains.com/issue/KT-47077) Support Apple Silicon in embedAndSign task

### Tools. Maven

- [`KT-45689`](https://youtrack.jetbrains.com/issue/KT-45689) JDK-16: kotlin-maven-plugin fails with `IllegalAccessError: class com.intellij.util.io.FileChannelUtil` when using incremental compilation

### Tools. Scripts

- [`KT-43917`](https://youtrack.jetbrains.com/issue/KT-43917) Gradle dependency conflict with resolutionStrategy failOnVersionConflict and kotlin 1.4


## 1.5.30-M1

### Compiler

#### New Features

- [`KT-32443`](https://youtrack.jetbrains.com/issue/KT-32443) Experimental declarations should be contagious even when they are not explicitly used
- [`KT-45844`](https://youtrack.jetbrains.com/issue/KT-45844) Forbid using experimental markers on override declarations
- [`KT-45845`](https://youtrack.jetbrains.com/issue/KT-45845) Forbid using experimental markers on getter
- [`KT-46644`](https://youtrack.jetbrains.com/issue/KT-46644) Resolve overrides for IrProperty on deserialization
- [`KT-46967`](https://youtrack.jetbrains.com/issue/KT-46967) Support class type parameters annotations in FIR
- [`KT-47402`](https://youtrack.jetbrains.com/issue/KT-47402) Native: optimize access to object declarations that have only const vals and no init blocks

#### Fixes

- [`KT-22852`](https://youtrack.jetbrains.com/issue/KT-22852) Report diagnostics on implicit usages of experimental API
- [`KT-22941`](https://youtrack.jetbrains.com/issue/KT-22941) Experimental marker annotation with SOURCE retention is compiled without error
- [`KT-24993`](https://youtrack.jetbrains.com/issue/KT-24993) Inference for buildSequence/yield doesn't work for labeled lambdas
- [`KT-31728`](https://youtrack.jetbrains.com/issue/KT-31728) Incorrect EXPERIMENTAL_OVERRIDE_ERROR for override of experimental function in anonymous object
- [`KT-33364`](https://youtrack.jetbrains.com/issue/KT-33364) Kotlin/Native debugger: execution stops only at next line for breakpoint at when expression without parameter
- [`KT-42139`](https://youtrack.jetbrains.com/issue/KT-42139) NI: NEW_INFERENCE_NO_INFORMATION_FOR_PARAMETER for emptyList / listOf (with no arguments) / emptyMap / mapOf (with no arguments) inside if block inside `sequence` block
- [`KT-44241`](https://youtrack.jetbrains.com/issue/KT-44241) NI: BuilderInference regression
- [`KT-44372`](https://youtrack.jetbrains.com/issue/KT-44372) FIR: KClass::java cannot be resolved as callable reference
- [`KT-44547`](https://youtrack.jetbrains.com/issue/KT-44547) Native: wrong RTTI when overriding functions with equal signatures but different type arguments
- [`KT-44571`](https://youtrack.jetbrains.com/issue/KT-44571) Segfault on unnecessary int unboxing
- [`KT-45083`](https://youtrack.jetbrains.com/issue/KT-45083) Problem with property reference in builder inference
- [`KT-45315`](https://youtrack.jetbrains.com/issue/KT-45315) Deprecate (V)::a reference resolution to companion in FE 1.0
- [`KT-46393`](https://youtrack.jetbrains.com/issue/KT-46393) AE: "1 trailing arguments were found in Any<T> type" for private function with implicit anonymous return type inside generic class
- [`KT-46661`](https://youtrack.jetbrains.com/issue/KT-46661) FIR: Investigate inference issue with self-types and star projection
- [`KT-46775`](https://youtrack.jetbrains.com/issue/KT-46775) [Native] [IR] Support multiple suspend lambdas as class supertypes
- [`KT-46836`](https://youtrack.jetbrains.com/issue/KT-46836) Error: Invalid LLVM module on inlineClasses external tests
- [`KT-46838`](https://youtrack.jetbrains.com/issue/KT-46838) NullPointerException: Parameter specified as non-null is null in CollectionsKt.joinToString()
- [`KT-46896`](https://youtrack.jetbrains.com/issue/KT-46896) Native IR: NPE when using irBuiltIns.suspendFunction
- [`KT-46996`](https://youtrack.jetbrains.com/issue/KT-46996) FIR: INFERENCE_NO_INFORMATION_FOR_PARAMETER on type aliases with non-trivial expansions
- [`KT-47034`](https://youtrack.jetbrains.com/issue/KT-47034) KtValueArgument.getArgumentExpression could lead to StubBasedPsiElementBase.notBoundInExistingAst
- [`KT-47052`](https://youtrack.jetbrains.com/issue/KT-47052) BuilderInference case with flatMapTo doesn't work properly
- [`KT-47082`](https://youtrack.jetbrains.com/issue/KT-47082) Stub type variable is leaked (reproduces with K/N during deserialization)
- [`KT-47143`](https://youtrack.jetbrains.com/issue/KT-47143) ClassicTypeSystemContext couldn't handle: Captured(*) in Kotlin 1.5.0
- [`KT-47148`](https://youtrack.jetbrains.com/issue/KT-47148) Type mismatch: inferred type is Any? but T? was expected
- [`KT-47180`](https://youtrack.jetbrains.com/issue/KT-47180) Forbid using OptIn markers on local variable, value parameter or field
- [`KT-47181`](https://youtrack.jetbrains.com/issue/KT-47181) Forbid using OptIn markers on types or type parameters
- [`KT-47183`](https://youtrack.jetbrains.com/issue/KT-47183) Segfault on int unboxing
- [`KT-47208`](https://youtrack.jetbrains.com/issue/KT-47208) Backend Internal error: Exception during IR lowering: assert at IrOverridingUtilKt.buildFakeOverrideMember
- [`KT-47276`](https://youtrack.jetbrains.com/issue/KT-47276) Nullability annotations without target are ignored if type enhancement improvements are enabled
- [`KT-47450`](https://youtrack.jetbrains.com/issue/KT-47450) StackOverflowException in psi2ir with many chained binary expressions
- [`KT-47462`](https://youtrack.jetbrains.com/issue/KT-47462) K/N: AssertionError: Unbound private symbol org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl@6cb748db (NON-PUBLIC API): deserialized class Companion

### IDE

- [`KT-44643`](https://youtrack.jetbrains.com/issue/KT-44643) ISE: Could not generate LightClass for some declared in <null> on initialisation by `lazy` in a JVM module of a multiplatform project

### IDE. Gradle Integration

- [`KT-47163`](https://youtrack.jetbrains.com/issue/KT-47163) KJS / Gradle: `Could not resolve <artifact>` despite being resolvable & project buildable

### IDE. JS

- [`KT-47557`](https://youtrack.jetbrains.com/issue/KT-47557) KJS: With NPM dependency IDEA import fails when performed before Gradle build

### JavaScript

- [`KT-38363`](https://youtrack.jetbrains.com/issue/KT-38363) JS IR BE: support IC for lowerings
- [`KT-45738`](https://youtrack.jetbrains.com/issue/KT-45738) KJS / IR: Wrong generated code for `when` statement
- [`KT-46520`](https://youtrack.jetbrains.com/issue/KT-46520) KJS / IR: ISE "Can't find name for declaration FUN name:CharArray_init_$Create$" on callable reference to Array constructor
- [`KT-46551`](https://youtrack.jetbrains.com/issue/KT-46551) KJS / IR: Add a basic sourcemap generation

### Libraries

- [`KT-47477`](https://youtrack.jetbrains.com/issue/KT-47477) Could not resolve kotlin-test during project import in case of multiplatform with only JVM target platform

### Native

- [`KT-35001`](https://youtrack.jetbrains.com/issue/KT-35001) warning: linking module flags 'SDK Version': IDs have conflicting values ('[2 x i32] [i32 13, i32 2]'
- [`KT-43475`](https://youtrack.jetbrains.com/issue/KT-43475) Kotlin/Native compiler: Including a static C library increased cross-compilation time from 3.5minutes to 1 hour 40 minutes
- [`KT-44148`](https://youtrack.jetbrains.com/issue/KT-44148) Escape analysis failure: Heap space out of memory

### Native. C and ObjC Import

- [`KT-46711`](https://youtrack.jetbrains.com/issue/KT-46711) platform.windows._LARGE_INTEGER cannot be passed by value

### Native. ObjC Export

- [`KT-43780`](https://youtrack.jetbrains.com/issue/KT-43780) Improve Swift/Obj-C ergonomics for object and companion object
- [`KT-46431`](https://youtrack.jetbrains.com/issue/KT-46431) KMP accessing a property of an anonymous inner class that inherits from an abstract class causes a 'NSGenericException', reason: '[Shared_kobjcc0 ] is abstract' exception.
- [`KT-47042`](https://youtrack.jetbrains.com/issue/KT-47042) Kotlin/Native: Concurrency Interoperability with Objective-C (Swift 5.5)

### Native. Platforms

- [`KT-44321`](https://youtrack.jetbrains.com/issue/KT-44321) Support Apple Silicon without Rosetta 2

### Reflection

- [`KT-18277`](https://youtrack.jetbrains.com/issue/KT-18277) InvalidProtocolBufferException: Stream closed on multithreaded access to built-ins data in reflection
- [`KT-44977`](https://youtrack.jetbrains.com/issue/KT-44977) Reflection: ClassCastException caused by annotations with "AnnotationTarget.TYPE" usage on array attributes access

### Tools. CLI

- [`KT-40979`](https://youtrack.jetbrains.com/issue/KT-40979) CLI: Executing "kotlinc.bat" at a root path, errors are not reported with a correct filepath
- [`KT-40994`](https://youtrack.jetbrains.com/issue/KT-40994) CLI: Add documentation for -J argument in `kotlinc -help`
- [`KT-46764`](https://youtrack.jetbrains.com/issue/KT-46764) CLI: Java record defined in a single file root is not resolved

### Tools. Commonizer

- [`KT-45992`](https://youtrack.jetbrains.com/issue/KT-45992) [Commonizer] Allow commonization of TypeAlias and Class with same name
- [`KT-46716`](https://youtrack.jetbrains.com/issue/KT-46716) [Commonizer] Analyze leaf source sets with original platform libraries
- [`KT-46957`](https://youtrack.jetbrains.com/issue/KT-46957) [Commonizer] Unresolved classifier: platform/posix/ptrdiff_t for linuxMips32
- [`KT-47133`](https://youtrack.jetbrains.com/issue/KT-47133) Forbid cinterop commonization with hierarchical commonization turned off
- [`KT-47301`](https://youtrack.jetbrains.com/issue/KT-47301) [Commonizer] Associative commonization

### Tools. Compiler Plugins

- [`KT-46723`](https://youtrack.jetbrains.com/issue/KT-46723) Kotlin Lombok: JPS: config file is searched in directory relative to compiler daemon
- [`KT-46739`](https://youtrack.jetbrains.com/issue/KT-46739) @SerialInfo NPE with default parameter

### Tools. Gradle

- [`KT-13258`](https://youtrack.jetbrains.com/issue/KT-13258) Kotlin compiler doesn't respect Gradle's "sourceCompatibility" and "targetCompatibility"
- [`KT-43095`](https://youtrack.jetbrains.com/issue/KT-43095) Add support for Java Toolchain to the Gradle plugin
- [`KT-45611`](https://youtrack.jetbrains.com/issue/KT-45611) KGP should declare JDK version as input
- [`KT-47185`](https://youtrack.jetbrains.com/issue/KT-47185) Migrate Gradle Integration tests to use cache redirector

### Tools. Gradle. JS

- [`KT-47176`](https://youtrack.jetbrains.com/issue/KT-47176) KJS: Actualize NPM dependencies
- [`KT-47154`](https://youtrack.jetbrains.com/issue/KT-47154) KJS / Gradle: Compile task reads dependencies metadata from filesystem too long on large projects
- [`KT-47114`](https://youtrack.jetbrains.com/issue/KT-47114) KJS / IR: Could not resolve `coroutines-core-js`
- [`KT-43379`](https://youtrack.jetbrains.com/issue/KT-43379) KJS / Gradle: On windows, an invalid regex is generated for Webpack ProgressPlugin

### Tools. Gradle. Multiplatform

- [`KT-47126`](https://youtrack.jetbrains.com/issue/KT-47126) ios() target shortcuts should not include Apple Silicon by default

### Tools. Gradle. Native

- [`KT-42023`](https://youtrack.jetbrains.com/issue/KT-42023) Kotlin Native Cocoapods plugin fails when Xcode project has custom CONFIGURATION names

### Tools. Incremental Compile

- [`KT-27660`](https://youtrack.jetbrains.com/issue/KT-27660) JS Incremental compilation fails with java.io.IOException: java.lang.ArrayIndexOutOfBoundsException: Array index out of range: 0

### Tools. JPS

- [`KT-45763`](https://youtrack.jetbrains.com/issue/KT-45763) Failing tests in KotlinIDE

### Tools. Scripts

- [`KT-46646`](https://youtrack.jetbrains.com/issue/KT-46646) Scripts: ArrayIndexOutOfBoundsException on an empty script running


## 1.5.21

### Compiler

- [`KT-47320`](https://youtrack.jetbrains.com/issue/KT-47320) "StringConcatException: Mismatched number of concat arguments" String concatenation fails when template contains special character
- [`KT-47445`](https://youtrack.jetbrains.com/issue/KT-47445) "definitely not null type parameters is only available since language version 1.6" error in cast expression
- [`KT-47446`](https://youtrack.jetbrains.com/issue/KT-47446) Improve warning message INTEGER_OPERATOR_RESOLVE_WILL_CHANGE
- [`KT-47447`](https://youtrack.jetbrains.com/issue/KT-47447) False positive INTEGER_OPERATOR_RESOLVE_WILL_CHANGE warning: "expression will be resolved to Int in future releases"
- [`KT-47449`](https://youtrack.jetbrains.com/issue/KT-47449) JVM / IR: ClassCastException IrStarProjectionImpl  cannot be cast to IrTypeProjection
- [`KT-47459`](https://youtrack.jetbrains.com/issue/KT-47459) "IndexOutOfBoundsException: Index 0 out of bounds for length 0" caused by MarkertManager dependency
- [`KT-47480`](https://youtrack.jetbrains.com/issue/KT-47480) StackOverflowError: Recursion on erasion of raw type with interdependent type parameters

### Tools. Compiler Plugins

- [`KT-47161`](https://youtrack.jetbrains.com/issue/KT-47161) Serializable class can't be inherited from serializable class in other module with: e: org.jetbrains.kotlin.codegen.CompilationException: Back-end (JVM) Internal error: Couldn't transform method node: write$Self
- [`KT-47455`](https://youtrack.jetbrains.com/issue/KT-47455) Kotlin lombok plugin NullPointerException
- [`KT-47513`](https://youtrack.jetbrains.com/issue/KT-47513) Lombok compiler plugin failed with 'Recursion detected in a lazy value under LockBasedStorageManager@1c21db60 (TopDownAnalyzer for JVM)'

### Tools. Gradle

- [`KT-47444`](https://youtrack.jetbrains.com/issue/KT-47444) Gradle Plugin: Publishing project with "maven-publish" fails when dependency versions are omitted (NPE in MppDependencyRewritingUtilsKt.associateDependenciesWithActualModuleDependencies)

### Tools. kapt

- [`KT-47416`](https://youtrack.jetbrains.com/issue/KT-47416) Kapt Gradle DSL ignores javaCompilerOptions in 1.5.20

## 1.5.20

### Compiler

#### New Features

- [`KT-43262`](https://youtrack.jetbrains.com/issue/KT-43262) No error for Java generic class @NotNull type parameter used in Kotlin with nullable type argument
- [`KT-44373`](https://youtrack.jetbrains.com/issue/KT-44373) FIR: support error / warning suppression
- [`KT-45189`](https://youtrack.jetbrains.com/issue/KT-45189) Support nullability annotations at module level
- [`KT-45284`](https://youtrack.jetbrains.com/issue/KT-45284) Emit warnings based on jspecify annotations
- [`KT-45525`](https://youtrack.jetbrains.com/issue/KT-45525) Allow to omit JvmInline annotation for expect value classes
- [`KT-46545`](https://youtrack.jetbrains.com/issue/KT-46545) Emit annotations on function type parameters into bytecode for -jvm-target 1.8 and above

#### Performance Improvements

- [`KT-36646`](https://youtrack.jetbrains.com/issue/KT-36646) Don't box primitive values in equality comparison with objects in JVM_IR

#### Fixes

- [`KT-8325`](https://youtrack.jetbrains.com/issue/KT-8325) Unresolved annotation should be an error
- [`KT-19455`](https://youtrack.jetbrains.com/issue/KT-19455) Type annotation unresolved on a type parameter of a supertype in anonymous object expression
- [`KT-24643`](https://youtrack.jetbrains.com/issue/KT-24643) Prohibit using a type parameter declared for an extension property inside delegate
- [`KT-25876`](https://youtrack.jetbrains.com/issue/KT-25876) Annotations on return types and supertypes are not analyzed
- [`KT-28449`](https://youtrack.jetbrains.com/issue/KT-28449) Annotation target is not analyzed in several cases for type annotations
- [`KT-36770`](https://youtrack.jetbrains.com/issue/KT-36770) Prohibit unsafe calls with expected @NotNull T and given Kotlin generic parameter with nullable bound
- [`KT-36880`](https://youtrack.jetbrains.com/issue/KT-36880) K/N IR: Reference to expect property in actual declaration is not remapped
- [`KT-38325`](https://youtrack.jetbrains.com/issue/KT-38325) IllegalStateException: No parameter with index 0-0 when iterating Scala 2.12.11 List
- [`KT-38342`](https://youtrack.jetbrains.com/issue/KT-38342) FIR: Consider renaming diagnostic from AMBIGUITY to OVERLOAD_RESOLUTION_AMBIGUITY
- [`KT-38476`](https://youtrack.jetbrains.com/issue/KT-38476) [FIR] Forgotten type approximation
- [`KT-38540`](https://youtrack.jetbrains.com/issue/KT-38540) Kotlin/Native Set<T>.contains fails with specific enum setup
- [`KT-40425`](https://youtrack.jetbrains.com/issue/KT-40425) IrGenerationExtension. Support simple reporting to compiler output (for development/debug)
- [`KT-41620`](https://youtrack.jetbrains.com/issue/KT-41620) ClassCastException: Class cannot be cast to java.lang.Void
- [`KT-41679`](https://youtrack.jetbrains.com/issue/KT-41679) NI: TYPE_MISMATCH wrong type inference of collection with type Any and integer literal
- [`KT-41818`](https://youtrack.jetbrains.com/issue/KT-41818) NI: False positive IMPLICIT_NOTHING_TYPE_ARGUMENT_IN_RETURN_POSITION leads to NothingValueException on delegated properties
- [`KT-42239`](https://youtrack.jetbrains.com/issue/KT-42239) IR: Report compilation error instead of throwing an exception (effectively crash compiler) when some declaration wasn't found while deserialization
- [`KT-42631`](https://youtrack.jetbrains.com/issue/KT-42631) ArrayIndexOutOfBoundsException was thrown during IR lowering
- [`KT-43258`](https://youtrack.jetbrains.com/issue/KT-43258) NI: False positive "Suspend function 'invoke' should be called only from a coroutine or another suspend function" when calling suspend operator fun on object property from last expression of a crossinlined suspend lambda
- [`KT-44036`](https://youtrack.jetbrains.com/issue/KT-44036) Enum initialization order
- [`KT-44511`](https://youtrack.jetbrains.com/issue/KT-44511) FIR DFA: smartcast after `if (nullable ?: boolean)`
- [`KT-44554`](https://youtrack.jetbrains.com/issue/KT-44554) RAW FIR: NPE in RawFirBuilder
- [`KT-44682`](https://youtrack.jetbrains.com/issue/KT-44682) raw FIR: incorrect source for qualified access
- [`KT-44695`](https://youtrack.jetbrains.com/issue/KT-44695) *_TYPE_MISMATCH_ON_OVERRIDE checkers do not work for anonymous objects
- [`KT-44699`](https://youtrack.jetbrains.com/issue/KT-44699) FIR: incorrect lambda return type (led to a false alarm: PROPERTY_TYPE_MISMATCH_ON_OVERRIDE)
- [`KT-44802`](https://youtrack.jetbrains.com/issue/KT-44802) FIR bootstrap: trying to access package private class
- [`KT-44813`](https://youtrack.jetbrains.com/issue/KT-44813) FIR bootstrap: various errors in collection-like classes
- [`KT-44814`](https://youtrack.jetbrains.com/issue/KT-44814) FIR bootstrap: incorrect cast in when branch
- [`KT-44942`](https://youtrack.jetbrains.com/issue/KT-44942) [FIR] ClassCastException in boostrap tests
- [`KT-44995`](https://youtrack.jetbrains.com/issue/KT-44995) FIR: false positive for ANNOTATION_ARGUMENT_MUST_BE_CONST
- [`KT-45010`](https://youtrack.jetbrains.com/issue/KT-45010) FIR: lambda arguments of inapplicable call is not resolved
- [`KT-45048`](https://youtrack.jetbrains.com/issue/KT-45048) FIR bootstrap: VerifyError on KtUltraLightClass
- [`KT-45052`](https://youtrack.jetbrains.com/issue/KT-45052) FIR bootstrap: inapplicable candidate in GenerateSpecTests.kt
- [`KT-45121`](https://youtrack.jetbrains.com/issue/KT-45121) FIR IDE: redundant vararg parameter type transformation
- [`KT-45136`](https://youtrack.jetbrains.com/issue/KT-45136) Native: dividing Int.MIN_VALUE by -1 crashes or hangs
- [`KT-45236`](https://youtrack.jetbrains.com/issue/KT-45236) JVM / IR: "IllegalStateException: Symbol with IrTypeParameterSymbolImpl is unbound" caused by contracts and sealed class
- [`KT-45308`](https://youtrack.jetbrains.com/issue/KT-45308) Psi2ir: "AssertionError: TypeAliasDescriptor expected" caused by using typealias from one module as a type in another module without a transitive dependency
- [`KT-45316`](https://youtrack.jetbrains.com/issue/KT-45316) [FIR] Ambiguity between two implicit invokes with receiver
- [`KT-45344`](https://youtrack.jetbrains.com/issue/KT-45344) FIR: Wrong inferred type for nullable type parameter
- [`KT-45385`](https://youtrack.jetbrains.com/issue/KT-45385) FIR: false positive MUST_BE_INITIALIZED_OR_BE_ABSTRACT after rethrow
- [`KT-45475`](https://youtrack.jetbrains.com/issue/KT-45475) [FIR] No smartcast after throw in if inside try block
- [`KT-45508`](https://youtrack.jetbrains.com/issue/KT-45508) False negative ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED on a fake override with an abstract super class member
- [`KT-45578`](https://youtrack.jetbrains.com/issue/KT-45578) REPL: Unresolved imports are cached for the subsequent compilations
- [`KT-45685`](https://youtrack.jetbrains.com/issue/KT-45685) JVM IR: capturing a variable into crossinline suspend lambda makes the function inside inline function no longer unbox Result
- [`KT-45584`](https://youtrack.jetbrains.com/issue/KT-45584) [FIR] Fix overriding property and java function in java class
- [`KT-45697`](https://youtrack.jetbrains.com/issue/KT-45697) JVM IR: ISE "Function has no body" on getter of private field in a class present both in sources and dependencies
- [`KT-45842`](https://youtrack.jetbrains.com/issue/KT-45842) Compiler doesn't allow a shared class to inherit a platform-specific sealed class
- [`KT-45848`](https://youtrack.jetbrains.com/issue/KT-45848) False negative [SEALED_INHERITOR_IN_DIFFERENT_MODULE] error in compiler for a platform-specific inheritor of a shared sealed class
- [`KT-45931`](https://youtrack.jetbrains.com/issue/KT-45931) There is no warning based on nullability java annotation
- [`KT-45998`](https://youtrack.jetbrains.com/issue/KT-45998) JVM IR: AE when an accessor to a protected companion object member is being generated in child class
- [`KT-46048`](https://youtrack.jetbrains.com/issue/KT-46048) Enum entries init order in companion object
- [`KT-46074`](https://youtrack.jetbrains.com/issue/KT-46074) FIR: private-in-file fun interface is considered invisible in this file
- [`KT-46173`](https://youtrack.jetbrains.com/issue/KT-46173) No error reporting on annotations on target type of `as` expression in return
- [`KT-46235`](https://youtrack.jetbrains.com/issue/KT-46235) JVM IR: Stack overflow error on large expressions
- [`KT-46270`](https://youtrack.jetbrains.com/issue/KT-46270) [FIR] Support `@PublishedAPI` in inline checker
- [`KT-46539`](https://youtrack.jetbrains.com/issue/KT-46539) Generate annotations on type parameters bounds in bytecode
- [`KT-46578`](https://youtrack.jetbrains.com/issue/KT-46578) JVM IR: IllegalAccessError accessing property delegated to java super class protected field reference
- [`KT-46597`](https://youtrack.jetbrains.com/issue/KT-46597) JVM IR: AssertionError: SyntheticAccessorLowering should not attempt to modify other files - crossinline accessor
- [`KT-46601`](https://youtrack.jetbrains.com/issue/KT-46601) JVM / IR: IllegalStateException: "Can't find method 'invokeinvoke`" when default lambda takes inline class parameters
- [`KT-46670`](https://youtrack.jetbrains.com/issue/KT-46670) StackOverflowError on inheritance from raw type where class has protobuf-like recursive generics
- [`KT-46715`](https://youtrack.jetbrains.com/issue/KT-46715) JVM / IR: "AssertionError: Unbound symbols not allowed IrConstructorSymbolImpl" with enum classes with the same name in test and src folders
- [`KT-46759`](https://youtrack.jetbrains.com/issue/KT-46759) JVM IR: CCE in LateinitUsageLowering on @JvmStatic lateinit property in object
- [`KT-46777`](https://youtrack.jetbrains.com/issue/KT-46777) [Native] [IR] Support suspend function as super type
- [`KT-46802`](https://youtrack.jetbrains.com/issue/KT-46802) JVM / IR: "UnsupportedOperationException: Unknown structure of ADAPTER_FOR_CALLABLE_REFERENCE" caused by function reference on @JvmStatic function with unused default parameters
- [`KT-46813`](https://youtrack.jetbrains.com/issue/KT-46813) JVM / IR: "ClassCastException: Integer cannot be cast to class Result" with Flow and `fold` method
- [`KT-46822`](https://youtrack.jetbrains.com/issue/KT-46822) JVM IR: StackOverflowError on compiling a large data class
- [`KT-46837`](https://youtrack.jetbrains.com/issue/KT-46837) Backend Internal error: Exception during IR lowering: assert at IrOverridingUtilKt.buildFakeOverrideMember
- [`KT-46921`](https://youtrack.jetbrains.com/issue/KT-46921) JVM / IR: "IndexOutOfBoundsException: Cannot pop operand off an empty stack" caused by crossinline parameter and label return
- [`KT-46984`](https://youtrack.jetbrains.com/issue/KT-46984) Type parameter bounds aren't used to report corresponding mismatch warnings
- [`KT-46985`](https://youtrack.jetbrains.com/issue/KT-46985) There aren't warnings by java nullability annotations
- [`KT-46986`](https://youtrack.jetbrains.com/issue/KT-46986) There aren't warnings by java nullability annotations
- [`KT-46989`](https://youtrack.jetbrains.com/issue/KT-46989) There aren't warnings by java nullability annotations
- [`KT-46990`](https://youtrack.jetbrains.com/issue/KT-46990) There aren't warnings by java nullability annotations on method's violated type arguments
- [`KT-47019`](https://youtrack.jetbrains.com/issue/KT-47019) K/N: IrProperty.overriddenSymbols can't be used in common IR backend modules yet because it doesn't fully work in Native

### Docs & Examples

- [`KT-33783`](https://youtrack.jetbrains.com/issue/KT-33783) Document when a range created with rangeTo is empty

### IDE

- [`KT-44638`](https://youtrack.jetbrains.com/issue/KT-44638) `clone()` call is unresolved in JVM module of a multiplatform project
- [`KT-45629`](https://youtrack.jetbrains.com/issue/KT-45629) [ULC] KtUltraLightFieldForSourceDeclaration.nameIdentifier returns null
- [`KT-44825`](https://youtrack.jetbrains.com/issue/KT-44825) Can't open Kotlin compiler settings in newly created project
- [`KT-45908`](https://youtrack.jetbrains.com/issue/KT-45908) Reproduciable 'org.jetbrains.kotlin.idea.caches.resolve.KotlinIdeaResolutionException: Kotlin resolution encountered a problem while analyzing KtNameReferenceExpression'

### IDE. FIR

- [`KT-45175`](https://youtrack.jetbrains.com/issue/KT-45175) FIR IDE: Exception with local property in `init` block
- [`KT-45199`](https://youtrack.jetbrains.com/issue/KT-45199) FIR IDE: Error while collecting diagnostic on stale element after replacing element in quickfix
- [`KT-45312`](https://youtrack.jetbrains.com/issue/KT-45312) FIR IDE: FIR plugin throws exception on synthetic function

### IDE. Gradle Integration

- [`KT-34401`](https://youtrack.jetbrains.com/issue/KT-34401) KotlinGradleModelBuilder builds models for non-kotlin modules and always trigger full task configuration.
- [`KT-45277`](https://youtrack.jetbrains.com/issue/KT-45277) Wrong jvm target in gradle module in IDEA
- [`KT-46488`](https://youtrack.jetbrains.com/issue/KT-46488) Import of a multiplatform project with MPP module depending on Kotlin/JVM one fails

### IDE. Inspections and Intentions

- [`KT-45075`](https://youtrack.jetbrains.com/issue/KT-45075) Inspection: Redundant creation of Json format
- [`KT-45347`](https://youtrack.jetbrains.com/issue/KT-45347) Sealed interfaces: quickfix to move to package/module of sealed class/interface should not be shown in case of read-only declaration
- [`KT-45348`](https://youtrack.jetbrains.com/issue/KT-45348) Sealed interfaces: show error for usage of sealed class/interface from a library in Java source code
- [`KT-46063`](https://youtrack.jetbrains.com/issue/KT-46063) In multiplatform code, suggest to generate remaining `when` branches at least for shared sealed classes

### IDE. Refactorings

- [`KT-44431`](https://youtrack.jetbrains.com/issue/KT-44431) Quickfix to move class/interface to proper location: it is allowed to choose test source in JPS project while compiler does not allow it

### IDE. Native

- [`KT-39320`](https://youtrack.jetbrains.com/issue/KT-39320) [Commonizer] Reduce memory consumption

### JavaScript

- [`KT-40235`](https://youtrack.jetbrains.com/issue/KT-40235) KJS: IR. Broken support for external interface companion
- [`KT-40689`](https://youtrack.jetbrains.com/issue/KT-40689) KJS / IR: strange and slow code for kotlin.math.max and kotlin.math.min for Double
- [`KT-44138`](https://youtrack.jetbrains.com/issue/KT-44138) KJS / IR: Constant folding works incorrectly with unsigned arithmetic
- [`KT-44394`](https://youtrack.jetbrains.com/issue/KT-44394) KJS / IR: `null` companion object for existed stdlib interfaces `NodeFilter` and `SVGUnitTypes`
- [`KT-44950`](https://youtrack.jetbrains.com/issue/KT-44950) KJS / IR: "IllegalStateException: Can't find name for declaration" in case of extending export declared class without @JsExport annotation
- [`KT-45057`](https://youtrack.jetbrains.com/issue/KT-45057) KJS / IR: "ClassCastException" when using `js` function in init block
- [`KT-45361`](https://youtrack.jetbrains.com/issue/KT-45361) KJS / IR: `IrConstructorCall` representing annotation always returns `Unit`
- [`KT-46608`](https://youtrack.jetbrains.com/issue/KT-46608) KJS: "Could not load content..." for source maps
- [`KT-45655`](https://youtrack.jetbrains.com/issue/KT-45655) KJS: "REINTERPRET_CAST" is not copyable
- [`KT-45866`](https://youtrack.jetbrains.com/issue/KT-45866) Default parameter with generic in expect-actual declarations
- [`KT-46859`](https://youtrack.jetbrains.com/issue/KT-46859) Exception during IR lowering: NullPointerException was thrown at: optimizations.FoldConstantLowering.tryFoldingUnaryOps

### KMM Plugin

- [`KT-43899`](https://youtrack.jetbrains.com/issue/KT-43899) KMM: Fix "stale framework" usage by XCode & AppCode in default build script

### Libraries

- [`KT-43701`](https://youtrack.jetbrains.com/issue/KT-43701) Stdlib: Expand KDoc of inc() and dec() for operators
- [`KT-46002`](https://youtrack.jetbrains.com/issue/KT-46002) Support all Unicode digit chars in digitToInt (JS and Native)
- [`KT-46183`](https://youtrack.jetbrains.com/issue/KT-46183) Add default value for ignoreCase in K/N String.replace/replaceFirst
- [`KT-46184`](https://youtrack.jetbrains.com/issue/KT-46184) Equivalize isLowerCase and isUpperCase behavior in all platforms

### Native

- [`KT-33175`](https://youtrack.jetbrains.com/issue/KT-33175) IR: String constants with incorrect surrogate pairs aren't preserved during serialization/deserialization
- [`KT-44799`](https://youtrack.jetbrains.com/issue/KT-44799) Different behavior with functional interfaces in Kotlin/Native on iOS

### Native. C Export

- [`KT-42796`](https://youtrack.jetbrains.com/issue/KT-42796) [Reverse C Interop] Package with no public methods generate empty struct in the header, leading to an error

### Native. ObjC Export

- [`KT-38600`](https://youtrack.jetbrains.com/issue/KT-38600) Kotlin MP iOS Target doesn't contain kdoc comments
- [`KT-45127`](https://youtrack.jetbrains.com/issue/KT-45127) KMM: hard to pass an error to Kotlin code from implementation of Kotlin method in Swift code

### Native. Runtime. Memory

- [`KT-45063`](https://youtrack.jetbrains.com/issue/KT-45063) Profiling indicates that a lot of time is spent on updateHeapRef on Apple platforms when running KMP code

### Reflection

- [`KT-10838`](https://youtrack.jetbrains.com/issue/KT-10838) Provide sensible toString() for property accessors in reflection
- [`KT-13490`](https://youtrack.jetbrains.com/issue/KT-13490) Equality doesn't work for KProperty.Accessor implementations

### Tools. CLI

- [`KT-14772`](https://youtrack.jetbrains.com/issue/KT-14772) ISE (FNFE "Not a directory") on compilation with destination argument clashing with an existing file which is not a directory
- [`KT-18184`](https://youtrack.jetbrains.com/issue/KT-18184) CompileEnvironmentException: Invalid jar path on "-d" with .jar in non-existing directory
- [`KT-40977`](https://youtrack.jetbrains.com/issue/KT-40977) Report a readable diagnostic on empty -J argument in CLI

### Tools. Commonizer

- [`KT-45497`](https://youtrack.jetbrains.com/issue/KT-45497) [Commonizer] c-interop commonization: Dependency commonization
- [`KT-46077`](https://youtrack.jetbrains.com/issue/KT-46077) [Commonizer] Add `commonizer_target` to commonized klib's manifest
- [`KT-46107`](https://youtrack.jetbrains.com/issue/KT-46107) [Commonizer] CInteropCommonizerTask receives faulty dependencies in multi module projects containing multiple c-interops
- [`KT-46248`](https://youtrack.jetbrains.com/issue/KT-46248) MPP: Compile KotlinMetadata fails with Unresolved reference if only one native platform from shared source set is available
- [`KT-46856`](https://youtrack.jetbrains.com/issue/KT-46856) [Commonizer] Many targets can fail with 'filename too long'

### Tools. Compiler Plugins

- [`KT-7112`](https://youtrack.jetbrains.com/issue/KT-7112) Support calling Lombok-generated methods within same module
- [`KT-45538`](https://youtrack.jetbrains.com/issue/KT-45538) Serialization, JVM IR: "AssertionError: No such type argument slot in IrConstructorCallImpl" with inner classes
- [`KT-45541`](https://youtrack.jetbrains.com/issue/KT-45541) JVM / IR / Serialization: NullPointerException caused by "Serializable" annotation and local data class
- [`KT-46469`](https://youtrack.jetbrains.com/issue/KT-46469) Kotlin Lombok: accessors with `AccessLevel.MODULE` fail to resolve
- [`KT-46529`](https://youtrack.jetbrains.com/issue/KT-46529) Kotlin Lombok: with `@Accessors` without explicit `prefix` the prefix from lombok.config is not taken into account
- [`KT-46531`](https://youtrack.jetbrains.com/issue/KT-46531) Kotlin Lombok: `lombok.getter.noIsPrefix` is processed depending on character case
- [`KT-46920`](https://youtrack.jetbrains.com/issue/KT-46920) NullPointerException in CodeGeneratorVisitor when packing for xcode

### Tools. Gradle

- [`KT-24533`](https://youtrack.jetbrains.com/issue/KT-24533) Kapt should not run when annotation processors are not configured
- [`KT-43988`](https://youtrack.jetbrains.com/issue/KT-43988) Enable plugin validation during build
- [`KT-45301`](https://youtrack.jetbrains.com/issue/KT-45301) Gradle: Empty `build/kotlin` dir with custom build directory
- [`KT-45519`](https://youtrack.jetbrains.com/issue/KT-45519) loadAndroidPluginVersion() impacts performance negatively and noticeably in multimodule Android build
- [`KT-45744`](https://youtrack.jetbrains.com/issue/KT-45744) Create Kotlin Gradle Plugin JUnit5 basic test setup
- [`KT-45834`](https://youtrack.jetbrains.com/issue/KT-45834) Gradle Plugin read system property related to kotlinCompilerClasspath breaks use of configuration cache
- [`KT-46401`](https://youtrack.jetbrains.com/issue/KT-46401) Deprecate 'kotlin.parallel.tasks.in.project' build property
- [`KT-46820`](https://youtrack.jetbrains.com/issue/KT-46820) Gradle: kotlinc (1.5.0) race condition causes a NullPointerException
- [`KT-47317`](https://youtrack.jetbrains.com/issue/KT-47317) Restore 'kotlinPluginVersion' property in 'KotlinBasePluginWrapper'

### Tools. Gradle. JS

- [`KT-42911`](https://youtrack.jetbrains.com/issue/KT-42911) Support Gradle configuration cache for K/JS tasks
- [`KT-45294`](https://youtrack.jetbrains.com/issue/KT-45294) KJS / Gradle: Number of modules in project affects JS tasks configuration cache state size
- [`KT-45754`](https://youtrack.jetbrains.com/issue/KT-45754) KJS / IR: Remove adding option of source maps in Gradle plugin
- [`KT-46178`](https://youtrack.jetbrains.com/issue/KT-46178) KJS / Dukat: Added as a dependency always without condition
- [`KT-46976`](https://youtrack.jetbrains.com/issue/KT-46976) KJS: Broken support for dynamically created `webpack.config.d`
- [`KT-47045`](https://youtrack.jetbrains.com/issue/KT-47045) [Gradle, JS] Task requirements are added to all compilations with same name

### Tools. Gradle. Multiplatform

- [`KT-36679`](https://youtrack.jetbrains.com/issue/KT-36679) MPP Gradle plugin: Improve messaging for the commonizer
- [`KT-45832`](https://youtrack.jetbrains.com/issue/KT-45832) CInteropCommonization: Filter out illegal dependencies
- [`KT-46394`](https://youtrack.jetbrains.com/issue/KT-46394) Multiplatform: Gradle 7 support
- [`KT-46517`](https://youtrack.jetbrains.com/issue/KT-46517) Add kotlin-project-model as api dependency to kotlin-gradle-plugin-api

### Tools. Gradle. Native

- [`KT-27240`](https://youtrack.jetbrains.com/issue/KT-27240) MPP Gradle plugin: Provide a framework packing task for Kotlin/Native
- [`KT-39016`](https://youtrack.jetbrains.com/issue/KT-39016) Missing stdlib when the downloading process was aborted
- [`KT-40907`](https://youtrack.jetbrains.com/issue/KT-40907) Xcode error after switching between device and simulator: Building for iOS, but the linked and embedded framework was built for iOS Simulator.
- [`KT-44059`](https://youtrack.jetbrains.com/issue/KT-44059) iosSimTest tasks are never up-to-date
- [`KT-45801`](https://youtrack.jetbrains.com/issue/KT-45801) compileIosMainKotlinMetadata compilation property of gradle task is not initialized and fails with  `Execution failed for task ':shared:generateProjectStructureMetadata'`
- [`KT-46680`](https://youtrack.jetbrains.com/issue/KT-46680) Register concrete "embedAndSign" tasks instead umbrella
- [`KT-46892`](https://youtrack.jetbrains.com/issue/KT-46892) Kotlin Multiplatform Gradle Plugin: EmbedAndSign task always contains a default framework name

### Tools. Incremental Compile

- [`KT-44741`](https://youtrack.jetbrains.com/issue/KT-44741) Incremental compilation: inspectClassesForKotlinIC doesn't determine changes with imported constant

### Tools. JPS

- [`KT-34351`](https://youtrack.jetbrains.com/issue/KT-34351) KotlinTargetsIndex creation takes too long even if project doesn't have any kotlin
- [`KT-45191`](https://youtrack.jetbrains.com/issue/KT-45191) [JPS] Marking method as "default" in Java SAM interface doesn't affect dependencies
- [`KT-46242`](https://youtrack.jetbrains.com/issue/KT-46242) Support Lombok kotlin plugin in JPS and maven

### Tools. kapt

#### Performance Improvements

- [`KT-28901`](https://youtrack.jetbrains.com/issue/KT-28901) Consider caching annotation processors classloaders

#### Fixes

- [`KT-27123`](https://youtrack.jetbrains.com/issue/KT-27123) kapt: missing space in error log makes location non-clickable
- [`KT-29929`](https://youtrack.jetbrains.com/issue/KT-29929) [Kapt] Stub generator uses constant value in method annotation instead of constant name 2.
- [`KT-31146`](https://youtrack.jetbrains.com/issue/KT-31146) kapt: executableElement.getAnnotation(JvmOverloads::class.java) returns null
- [`KT-32202`](https://youtrack.jetbrains.com/issue/KT-32202) Gradle task kaptKotlin fails: "module not found" in Java 11 modular application
- [`KT-34838`](https://youtrack.jetbrains.com/issue/KT-34838) Kapt: 'cannot find symbol' for a top-level property with anonymous delegate
- [`KT-35104`](https://youtrack.jetbrains.com/issue/KT-35104) Support @JvmStatic in KAPT stubs
- [`KT-35167`](https://youtrack.jetbrains.com/issue/KT-35167) Kapt Gradle plugin doesn't handle --module-path javac argument
- [`KT-37586`](https://youtrack.jetbrains.com/issue/KT-37586) KAPT: When delegated property use an unknown type (to-be-generated class), `correctTypeError` will mess up the `$delegate` field type
- [`KT-39060`](https://youtrack.jetbrains.com/issue/KT-39060) Kapt: correctErrorTypes don't retain return type of getter in Java stub
- [`KT-39715`](https://youtrack.jetbrains.com/issue/KT-39715) KaptGenerateStubsTask resolves annotation processor options too early (before execution time)
- [`KT-41581`](https://youtrack.jetbrains.com/issue/KT-41581) Kapt doesn't have line breaks between warnings
- [`KT-43804`](https://youtrack.jetbrains.com/issue/KT-43804) Kapt fails to preserve parameter names in open suspend functions
- [`KT-43686`](https://youtrack.jetbrains.com/issue/KT-43686) KaptWithoutKotlincTask should use `@CompileClasspath` for `kotlinStdlibClasspath` for cache relocateability.
- [`KT-45032`](https://youtrack.jetbrains.com/issue/KT-45032) Kapt: NullPointerException: insnList.first must not be null
- [`KT-46176`](https://youtrack.jetbrains.com/issue/KT-46176) Kapt: "java.lang.IndexOutOfBoundsException: Index -1 out of bounds for length 3" with delegation and property reference


## 1.5.10

### Compiler

#### Fixes

- [`KT-41078`](https://youtrack.jetbrains.com/issue/KT-41078) Incorrect type substitution in contracts with type parameters
- [`KT-44770`](https://youtrack.jetbrains.com/issue/KT-44770) JVM / IR: "IllegalArgumentException: Unrecognized Type: [null]" Jackson doesn't recognize type
- [`KT-45084`](https://youtrack.jetbrains.com/issue/KT-45084) JVM IR: "NoSuchElementException: Sequence contains no element matching the predicate" when inline class is passed to lambda with >22 parameters
- [`KT-45779`](https://youtrack.jetbrains.com/issue/KT-45779) JVM / IR: java.lang.NoSuchMethodError: 'int java.lang.Integer.plus(int)' caused by function reference
- [`KT-45941`](https://youtrack.jetbrains.com/issue/KT-45941) JVM IR: local functions use generic type parameters of the outer class in the bytecode, which breaks Bytebuddy and MockK
- [`KT-46149`](https://youtrack.jetbrains.com/issue/KT-46149) Generate synthetic classes for SAM adapters with erased instead of generic supertype
- [`KT-46189`](https://youtrack.jetbrains.com/issue/KT-46189) JVM IR: tailrec function with capturing lambda in default parameter value leads to NoSuchMethodError at runtime
- [`KT-46214`](https://youtrack.jetbrains.com/issue/KT-46214) JVM / IR: "IllegalStateException: No mapping for symbol: VALUE_PARAMETER INSTANCE_RECEIVER" on a suspend function in an inner class
- [`KT-46238`](https://youtrack.jetbrains.com/issue/KT-46238) JVM IR: BootstrapMethodError in JDK 11+ on intersection type passed in arguments of SAM adapter where SAM interface's type parameter has a non-trivial upper bound
- [`KT-46259`](https://youtrack.jetbrains.com/issue/KT-46259) JVM IR: local function for adapted function reference is not declared as ACC_SYNTHETIC
- [`KT-46284`](https://youtrack.jetbrains.com/issue/KT-46284) JVM IR: "Unbound private symbol IrClassSymbol" on class reference to script class
- [`KT-46402`](https://youtrack.jetbrains.com/issue/KT-46402) IllegalAccessError: "CapturedLambdaInterpreter (in unnamed module @0x71b06418) cannot access class jdk.internal.org.objectweb.asm.Type" caused by inline function with a suspend parameter in Maven project
- [`KT-46408`](https://youtrack.jetbrains.com/issue/KT-46408) JVM IR: BootstrapMethodError due to missing bridge for subclass of generic Java interface
- [`KT-46426`](https://youtrack.jetbrains.com/issue/KT-46426) JVM IR: Corrupted .class file when passing Array constructor reference as (inline) lambda
- [`KT-46455`](https://youtrack.jetbrains.com/issue/KT-46455) OOM on parsing invalid code with string interpolation
- [`KT-46503`](https://youtrack.jetbrains.com/issue/KT-46503) JVM IR: "AssertionError: Unexpected variance in super type argument: out @1"
- [`KT-46505`](https://youtrack.jetbrains.com/issue/KT-46505) JVM IR: NullPointerException caused by a callable reference with nullable inline value class parameter
- [`KT-46512`](https://youtrack.jetbrains.com/issue/KT-46512) JVM / IR: NoSuchMethodError on SAM conversion of a function reference
- [`KT-46515`](https://youtrack.jetbrains.com/issue/KT-46515) IndexOutOfBoundsException: "Empty list doesn't contain element at index 0." on bad variable name in 1.5.0
- [`KT-46516`](https://youtrack.jetbrains.com/issue/KT-46516) JVM IR: "AnalyzerException: Expected I, but found R" on subclassing AbstractMutableList<Int>
- [`KT-46524`](https://youtrack.jetbrains.com/issue/KT-46524) Cannot use unsigned literals with api-version < 1.5 even with opt-in
- [`KT-46537`](https://youtrack.jetbrains.com/issue/KT-46537) JVM / IR: "IllegalStateException: No noarg super constructor for CLASS" caused by "No-arg" plugin with annotation on child class
- [`KT-46540`](https://youtrack.jetbrains.com/issue/KT-46540) JVM / IR: AnalyzerException: Expected an object reference, but found J caused by java.function.Supplier
- [`KT-46554`](https://youtrack.jetbrains.com/issue/KT-46554) JVM IR: "IllegalStateException: No mapping for symbol: VAR IR_TEMPORARY_VARIABLE" with value class constructor delegation call
- [`KT-46555`](https://youtrack.jetbrains.com/issue/KT-46555) JVM IR: IllegalAccessError when using Java method reference
- [`KT-46562`](https://youtrack.jetbrains.com/issue/KT-46562) Kotlin 1.5.0 generates non-serializable lambdas when they should be serializable
- [`KT-46568`](https://youtrack.jetbrains.com/issue/KT-46568) JVM IR: "AssertionError: IrCall expected inside JvmStatic wrapper" on compiling protected static function with return type Nothing inside companion object of abstract class
- [`KT-46574`](https://youtrack.jetbrains.com/issue/KT-46574) JVM / IR: ClassCastException caused by runBlocking awaiting call while returning Kotlin.Result type.
- [`KT-46579`](https://youtrack.jetbrains.com/issue/KT-46579) JVM IR: "IllegalArgumentException: Sequence contains more than one matching element" for Java enum with overloaded values() static method
- [`KT-46584`](https://youtrack.jetbrains.com/issue/KT-46584) JVM IR: Intrinsics.needClassReification (UnsupportedOperationException thrown). Property delegate provider crossinline lambda inlining/reification issue
- [`KT-46751`](https://youtrack.jetbrains.com/issue/KT-46751) JVM / IR:"ClassCastException: java.lang.String cannot be cast to java.lang.Void" in extension function in Kotlin 1.5

### IDE

- [`KT-45981`](https://youtrack.jetbrains.com/issue/KT-45981) failed to analyze: java.lang.AssertionError: diagnostic callback has been already registered: Code analysis get stuck in AS 2020.3.1.14 & Kotlin v1.5.0-M2
- [`KT-46622`](https://youtrack.jetbrains.com/issue/KT-46622) 60+ second freezes with Kotlin plugin 1.5.0: GetModuleInfoKt.findJvmStdlibAcrossDependencies

### IDE. Gradle Integration

- [`KT-46417`](https://youtrack.jetbrains.com/issue/KT-46417) [UNRESOLVED_REFERENCE] For project to project dependencies of native platform test source sets

### Libraries

- [`KT-46280`](https://youtrack.jetbrains.com/issue/KT-46280) JvmRecord annotation missing constructor in common

### Middle-end. IR

- [`KT-44013`](https://youtrack.jetbrains.com/issue/KT-44013) NPE: When calling constructor of a function type while inheriting from it, despite it's an interface

### Tools. Android Extensions

- [`KT-46590`](https://youtrack.jetbrains.com/issue/KT-46590) Kotlin Android Extensions 1.5.0 generates bad writeToParcel() method for nullable Array types

### Tools. Gradle

- [`KT-41142`](https://youtrack.jetbrains.com/issue/KT-41142) Kotlin version conflict when using Kotlin Gradle plugins in pre-compiled script plugin
- [`KT-46353`](https://youtrack.jetbrains.com/issue/KT-46353) Optimizations disabled in Gradle 7 for KAPT when generating sources
- [`KT-46368`](https://youtrack.jetbrains.com/issue/KT-46368) Memory leak with 1.5.0-RC when building with Gradle
- [`KT-46689`](https://youtrack.jetbrains.com/issue/KT-46689) Track -Xuse-old-backend flag usage

### Tools. Gradle. JS

- [`KT-46006`](https://youtrack.jetbrains.com/issue/KT-46006) KJS \ Gradle: Task without declaring an explicit or implicit dependency on `jsGenerateExternalsIntegrated` in Gradle 7
- [`KT-46162`](https://youtrack.jetbrains.com/issue/KT-46162) KJS: Exported items unavailable on dev server
- [`KT-46331`](https://youtrack.jetbrains.com/issue/KT-46331) KJS: With `kotlin.js.webpack.major.version=4` browserXRun tasks fail

### Tools. Parcelize

- [`KT-46567`](https://youtrack.jetbrains.com/issue/KT-46567) Kotlin 1.5.0 parcelize compilation fails in new backend when using TypeParceller with nested generics

### Tools. kapt

- [`KT-45532`](https://youtrack.jetbrains.com/issue/KT-45532) Do not create Kapt stubs directory during configuration time


## 1.5.0

### Backend. Native

- [`KT-42053`](https://youtrack.jetbrains.com/issue/KT-42053) Support compiler caches for linux_x64
- [`KT-43690`](https://youtrack.jetbrains.com/issue/KT-43690) Support compiler caches for ios_arm64

### Backend. IR

- [`KT-42684`](https://youtrack.jetbrains.com/issue/KT-42684) StackOverflowError on recursive inline arguments in inline fun

### Compiler

#### New Features

- [`KT-28791`](https://youtrack.jetbrains.com/issue/KT-28791) Kotlin serialization with inline classes
- [`KT-30222`](https://youtrack.jetbrains.com/issue/KT-30222) Support JVM target version selection in Kotlin bytecode tool window
- [`KT-41884`](https://youtrack.jetbrains.com/issue/KT-41884) Support 'file' target for JvmSynthetic annotation
- [`KT-43677`](https://youtrack.jetbrains.com/issue/KT-43677) Support for Java records
- [`KT-43920`](https://youtrack.jetbrains.com/issue/KT-43920) Support loading binary Java annotations on fields
- [`KT-44278`](https://youtrack.jetbrains.com/issue/KT-44278) Generate SAM-converted lambdas and function references using 'invokedynamic' on JDK 1.8+
- [`KT-44650`](https://youtrack.jetbrains.com/issue/KT-44650) Deprecate JVM target version 1.6
- [`KT-44787`](https://youtrack.jetbrains.com/issue/KT-44787) Suspend functions in fun interfaces
- [`KT-44865`](https://youtrack.jetbrains.com/issue/KT-44865) Allow to declare protected constructors in sealed classes
- [`KT-44869`](https://youtrack.jetbrains.com/issue/KT-44869) Compiling sealed interface with version less than 1.5: error message from future could be provided


#### Performance Improvements

- [`KT-6336`](https://youtrack.jetbrains.com/issue/KT-6336) Optimize generation of local functions
- [`KT-7307`](https://youtrack.jetbrains.com/issue/KT-7307) Optimize infix call of String.plus
- [`KT-18692`](https://youtrack.jetbrains.com/issue/KT-18692) Optimize '<optimizable_range> step x' for-in loop
- [`KT-19978`](https://youtrack.jetbrains.com/issue/KT-19978) Inefficient bytecode generated for function references undergoing Java SAM conversion
- [`KT-23565`](https://youtrack.jetbrains.com/issue/KT-23565) OperationsMapGenerated.kt generates unreasonable amount of bytecode
- [`KT-23825`](https://youtrack.jetbrains.com/issue/KT-23825) Tail suspend call utilizing elvis operator does not take advantage of suspend tail call optimization
- [`KT-23826`](https://youtrack.jetbrains.com/issue/KT-23826) A suspend function on the right side of a returned || condition is not tail call optimized
- [`KT-25348`](https://youtrack.jetbrains.com/issue/KT-25348) No compile time unsigned integer conversion when using hex literal
- [`KT-26060`](https://youtrack.jetbrains.com/issue/KT-26060) Support a compiler mode to compile lambda expressions using `invokedynamic` instruction
- [`KT-26590`](https://youtrack.jetbrains.com/issue/KT-26590) Do not generate create method for suspend lambdas if its arity >= 2
- [`KT-27427`](https://youtrack.jetbrains.com/issue/KT-27427) Optimize nullable check introduced with 'as' cast
- [`KT-28246`](https://youtrack.jetbrains.com/issue/KT-28246) Redundant boxing/unboxing isn't eliminated by the compiler in case of inline classes and javaClass intrinsic
- [`KT-30605`](https://youtrack.jetbrains.com/issue/KT-30605) Constant folding doesn't evaluate inv() function
- [`KT-36845`](https://youtrack.jetbrains.com/issue/KT-36845) Generate enum-based TABLESWITCH/LOOKUPSWITCH on a value with smart cast to enum in JVM_IR
- [`KT-39585`](https://youtrack.jetbrains.com/issue/KT-39585) JVM BE generates redundant accessor calls when accessing static final field lifted from companion
- [`KT-40886`](https://youtrack.jetbrains.com/issue/KT-40886) Old JVM BE unspills ACONST_NULL from continuation
- [`KT-42621`](https://youtrack.jetbrains.com/issue/KT-42621) Kotlin binary size considerably larger for code extensively using stream API
- [`KT-44153`](https://youtrack.jetbrains.com/issue/KT-44153) NI: Low Memory and IntelliJ hangs when quotes in split() are missed
- [`KT-45410`](https://youtrack.jetbrains.com/issue/KT-45410) JVM / IR: Extreme performance regression on arithmetic operations inside a loop

#### Fixes

- [`KT-6007`](https://youtrack.jetbrains.com/issue/KT-6007) Support changed return type of inlined generic function when lambda returns anonymous object
- [`KT-6055`](https://youtrack.jetbrains.com/issue/KT-6055) Failed invoke plus assign on array element accessed via several args through local get/set convention extensions
- [`KT-6879`](https://youtrack.jetbrains.com/issue/KT-6879) CompilationException when local classes hierarchy is placed within other local or inner declaration
- [`KT-8120`](https://youtrack.jetbrains.com/issue/KT-8120) NoSuchMethodError on local class constructor call inside a local class
- [`KT-8199`](https://youtrack.jetbrains.com/issue/KT-8199) "Cannot pop operand off an empty stack" for local class using a captured variable as default value for constructor parameter
- [`KT-10835`](https://youtrack.jetbrains.com/issue/KT-10835) "AssertionError: Non-outer parameter incorrectly mapped to outer" when inlining object literal extending inner class
- [`KT-12790`](https://youtrack.jetbrains.com/issue/KT-12790) Don't generate synthetic accessors for private inline function/properties
- [`KT-13213`](https://youtrack.jetbrains.com/issue/KT-13213) IllegalArgumentException in ByteVector.putUTF8 on attempt to compile file with moderately long string literal
- [`KT-14628`](https://youtrack.jetbrains.com/issue/KT-14628) "UnsupportedOperationException: Don't know how to generate outer expression" for nested class inheriting from inner class with a companion object
- [`KT-14833`](https://youtrack.jetbrains.com/issue/KT-14833) JVM internal error: Augment assignment and increment are not supported for local delegated properties and inline properties
- [`KT-15403`](https://youtrack.jetbrains.com/issue/KT-15403) Suspend operator get wrong code generated by BE (NoSuchMethodError)
- [`KT-15404`](https://youtrack.jetbrains.com/issue/KT-15404) Suspend operator set wrong code generated
- [`KT-16084`](https://youtrack.jetbrains.com/issue/KT-16084) Proguard can't find enclosing class of let closure inside apply closure
- [`KT-16151`](https://youtrack.jetbrains.com/issue/KT-16151) Internal compiler error when using plusAssign operator with mutable map
- [`KT-16221`](https://youtrack.jetbrains.com/issue/KT-16221) Support in/!in suspend operators
- [`KT-16282`](https://youtrack.jetbrains.com/issue/KT-16282) "Cannot pop operand off an empty stack" for plusAssign with default parameters in setter operator
- [`KT-16445`](https://youtrack.jetbrains.com/issue/KT-16445) `java.lang.VerifyError: Bad type on operand stack` when delegating an interface through a private reified function inside an object
- [`KT-16520`](https://youtrack.jetbrains.com/issue/KT-16520) Invalid bytecode semantics for set call by convention with default parameters
- [`KT-16567`](https://youtrack.jetbrains.com/issue/KT-16567) Inliner creates redundant objects on source inlining
- [`KT-16752`](https://youtrack.jetbrains.com/issue/KT-16752) Delegating function interface to function reference does not work
- [`KT-17554`](https://youtrack.jetbrains.com/issue/KT-17554) Incorrect cast to Unit generated on annotated when-expression with a single-branch if inside
- [`KT-17738`](https://youtrack.jetbrains.com/issue/KT-17738) Java cannot extend class implementing kotlin.collections.Map
- [`KT-17753`](https://youtrack.jetbrains.com/issue/KT-17753) Strange behavior of if and return statements
- [`KT-18583`](https://youtrack.jetbrains.com/issue/KT-18583) "ISE: Recursive call in a lazy value" for generic sealed class with nested subclass in a `when(this)` with inferred return type
- [`KT-19861`](https://youtrack.jetbrains.com/issue/KT-19861) "IllegalStateException: Label wasn't found during iterating through instructions" for `plusAssign` with safe call
- [`KT-20306`](https://youtrack.jetbrains.com/issue/KT-20306) Make 'when' over an 'expect' enum class non-exhaustive
- [`KT-20869`](https://youtrack.jetbrains.com/issue/KT-20869) kotlin.jvm.internal.DefaultConstructorMarker should be public
- [`KT-20996`](https://youtrack.jetbrains.com/issue/KT-20996) IllegalStateException: Cannot get FQ name of local class: class <no name provided> in metadata serialization for common code
- [`KT-21014`](https://youtrack.jetbrains.com/issue/KT-21014) Incorrect bytecode generated for 'PrimitiveArray::size'
- [`KT-21092`](https://youtrack.jetbrains.com/issue/KT-21092) Reference `javaClass` for generic property: "couldn't transform method node: get()"
- [`KT-21778`](https://youtrack.jetbrains.com/issue/KT-21778) "IllegalStateException: Couldn't build context" for inline function inside an anonymous object
- [`KT-21900`](https://youtrack.jetbrains.com/issue/KT-21900) VerifyError on equals on generic primitive type
- [`KT-22098`](https://youtrack.jetbrains.com/issue/KT-22098) "UnsupportedOperationException: Don't know how to generate outer expression" on extension function call inside lambda in anonymous object super constructor call
- [`KT-22488`](https://youtrack.jetbrains.com/issue/KT-22488) Bad line numbers generated for '&&' expression
- [`KT-22972`](https://youtrack.jetbrains.com/issue/KT-22972) A compiler bug(?) in Number class descendants
- [`KT-23619`](https://youtrack.jetbrains.com/issue/KT-23619) Transform stateless singleton lambda during inline
- [`KT-23881`](https://youtrack.jetbrains.com/issue/KT-23881) Declaration of lambda in inlined apply block holds reference to superfluous references causing leak
- [`KT-24135`](https://youtrack.jetbrains.com/issue/KT-24135) Calling invoke on crossinline suspend lambda leads to no state-machine
- [`KT-24193`](https://youtrack.jetbrains.com/issue/KT-24193) NoClassDefFoundError: java/lang/Cloneable$DefaultImpls on inheritance from Cloneable through an interface
- [`KT-24305`](https://youtrack.jetbrains.com/issue/KT-24305) ClassNotFoundException when using Java reflection on local class in an inlined lambda
- [`KT-24564`](https://youtrack.jetbrains.com/issue/KT-24564) Custom operator fun set on ByteArray resolves properly but is miscompiled
- [`KT-25400`](https://youtrack.jetbrains.com/issue/KT-25400) "NoClassDefFoundError: kotlin/KotlinPackage" with Turkish system locale on macOS
- [`KT-26130`](https://youtrack.jetbrains.com/issue/KT-26130) Incorrect method signature for a generic function with inline class as a type parameter upper bound
- [`KT-26360`](https://youtrack.jetbrains.com/issue/KT-26360) "Method from super interface has a different signature" for Interface that extends both interfaces with and without @JvmDefault
- [`KT-26473`](https://youtrack.jetbrains.com/issue/KT-26473) Error on compiling inline class with calls of super methods equals(), hashCode(), toString()
- [`KT-26474`](https://youtrack.jetbrains.com/issue/KT-26474) VE “Bad type on operand stack” at runtime on calling toString() method of inline class with calls of super methods (toString(), equals(), hashCode()) inside
- [`KT-26592`](https://youtrack.jetbrains.com/issue/KT-26592) Do not generate private suspend functions as synthetic package-private
- [`KT-27449`](https://youtrack.jetbrains.com/issue/KT-27449) NoSuchMethodError for local suspend function with suspend lambda parameter with default value
- [`KT-27469`](https://youtrack.jetbrains.com/issue/KT-27469) "Cannot pop operand off an empty stack" for compound assignment (plusAssign) with a `vararg` operator get
- [`KT-27825`](https://youtrack.jetbrains.com/issue/KT-27825) Gradually prohibit non-abstract classes containing abstract members invisible from that classes (internal/package-private)
- [`KT-27830`](https://youtrack.jetbrains.com/issue/KT-27830) "Incompatible stack heights" with suspend inline function in do while loop that executes suspend lambda
- [`KT-28042`](https://youtrack.jetbrains.com/issue/KT-28042) "Cannot pop operand off an empty stack" for a bound callable reference of lambda inside inline function
- [`KT-28166`](https://youtrack.jetbrains.com/issue/KT-28166) "Argument 1: expected I, but found R" for generic method with generic parameter or receiver with inline class upper bound
- [`KT-28331`](https://youtrack.jetbrains.com/issue/KT-28331) Consider generating accessors for lateinit properties to avoid assertion on each call
- [`KT-28573`](https://youtrack.jetbrains.com/issue/KT-28573) Inliner does not update references to transformed object
- [`KT-29331`](https://youtrack.jetbrains.com/issue/KT-29331) "AnalyzerException: Argument 1: expected R, but found I" with local generic extension property called on `Int` receiver
- [`KT-29595`](https://youtrack.jetbrains.com/issue/KT-29595) NoClassDefFoundError with inline reified function with lambda argument returning anonymous object
- [`KT-29802`](https://youtrack.jetbrains.com/issue/KT-29802) Incorrect reification when the same type parameter name is used for different reified types
- [`KT-30041`](https://youtrack.jetbrains.com/issue/KT-30041) "AnalyzerException: Expected an object reference, but found ." on nested suspend function calls outer suspend function
- [`KT-30066`](https://youtrack.jetbrains.com/issue/KT-30066) Consider adding annotations to ConeKotlinType
- [`KT-30280`](https://youtrack.jetbrains.com/issue/KT-30280) Inline class class literal gets unwrapped in annotation arguments
- [`KT-30402`](https://youtrack.jetbrains.com/issue/KT-30402) Constant folding works incorrectly with unsigned arithmetics
- [`KT-30548`](https://youtrack.jetbrains.com/issue/KT-30548) "java.lang.IndexOutOfBoundsException: Cannot pop operand off an empty stack" while compiling access to a private lateinit companion field
- [`KT-30629`](https://youtrack.jetbrains.com/issue/KT-30629) `java.lang.VerifyError: Bad type on operand stack` when using a function reference to a generic property
- [`KT-30933`](https://youtrack.jetbrains.com/issue/KT-30933) Inline function produces IllegalAccessError on property reference from different package
- [`KT-31136`](https://youtrack.jetbrains.com/issue/KT-31136) "AnalyzerException: Argument 1: expected R, but found I" on x::javaClass when x is inline class object built around primitive type
- [`KT-31227`](https://youtrack.jetbrains.com/issue/KT-31227) Prohibit using array based on non-reified type parameters as reified type arguments on JVM
- [`KT-31592`](https://youtrack.jetbrains.com/issue/KT-31592) NoSuchMethodException when inlining public function accessing a protected static Java class member
- [`KT-31727`](https://youtrack.jetbrains.com/issue/KT-31727) Object expression captures all variables used in constructor
- [`KT-32023`](https://youtrack.jetbrains.com/issue/KT-32023) "AnalyzerException: Expected I, but found R" with inline suspend function used with callable reference
- [`KT-32115`](https://youtrack.jetbrains.com/issue/KT-32115) NPE during initialization of enum class with delegated property
- [`KT-32153`](https://youtrack.jetbrains.com/issue/KT-32153) "AnalyzerException: Expected an object reference, but found ." with recursive suspend local function
- [`KT-32351`](https://youtrack.jetbrains.com/issue/KT-32351) ClassNotFoundException for anonymous object implementing interface inside a lambda with data class and inline methods
- [`KT-32384`](https://youtrack.jetbrains.com/issue/KT-32384) Safe cast to generic type argument with inline class upper-bound throws NPE instead of ClassCastException
- [`KT-32579`](https://youtrack.jetbrains.com/issue/KT-32579) java.lang.VerifyError: Bad type on operand stack on calling inner class of inherited class in super class when casting to inherited class
- [`KT-32749`](https://youtrack.jetbrains.com/issue/KT-32749) "VerifyError: Call to wrong <init> method" with inline function and accessing class field from anonymous object
- [`KT-32793`](https://youtrack.jetbrains.com/issue/KT-32793) Generated code crashes by ClassCastException with local suspend function and inline class
- [`KT-32812`](https://youtrack.jetbrains.com/issue/KT-32812) "AnalyzerException: Argument 1: expected R, but found I" invoking function with default parameter inherited by inline class
- [`KT-32821`](https://youtrack.jetbrains.com/issue/KT-32821) Missing unboxing of inline class for complex hierarchy of suspend calls
- [`KT-33155`](https://youtrack.jetbrains.com/issue/KT-33155) ClassNotFoundException for qualified this in anonymous object and as a result of inline function call
- [`KT-33173`](https://youtrack.jetbrains.com/issue/KT-33173) Internal error: "AnalyzerException: Expected I, but found R" for supercall inside inline lambda from HashSet.remove implementation
- [`KT-33577`](https://youtrack.jetbrains.com/issue/KT-33577) NoSuchFieldError with nested anonymous objects accessing outer instance property
- [`KT-33836`](https://youtrack.jetbrains.com/issue/KT-33836) Wrong code generated for a local tailrec suspend function.
- [`KT-33873`](https://youtrack.jetbrains.com/issue/KT-33873) ClassCastException invoking UByte setter function via reflection
- [`KT-34018`](https://youtrack.jetbrains.com/issue/KT-34018) "Cannot pop operand off an empty stack" with inline lambda with callable reference
- [`KT-34186`](https://youtrack.jetbrains.com/issue/KT-34186) JDK11: class file contains malformed variable arity method for vararg sealed class constructor
- [`KT-34202`](https://youtrack.jetbrains.com/issue/KT-34202) IllegalAccessError on callable reference of function from multifile facade from standard library
- [`KT-34255`](https://youtrack.jetbrains.com/issue/KT-34255) @JvmStatic tailrec function: "Cannot pop operand off an empty stack"
- [`KT-34507`](https://youtrack.jetbrains.com/issue/KT-34507) Incorrect generated code for mutable collection stub methods in case of presence of functions with similar signature
- [`KT-34665`](https://youtrack.jetbrains.com/issue/KT-34665) Possible index overflow in optimized "for" loop over withIndex()
- [`KT-34754`](https://youtrack.jetbrains.com/issue/KT-34754) Flow builder: "AnalyzerException: Expected an object reference, but found ." with recursive suspend local function
- [`KT-34816`](https://youtrack.jetbrains.com/issue/KT-34816) "AnalyzerException: Expected an object reference, but found I" on "this" in inline class member extension suspend function
- [`KT-34841`](https://youtrack.jetbrains.com/issue/KT-34841) ClassNotFoundException when invoke param function inside anonymous object method
- [`KT-35008`](https://youtrack.jetbrains.com/issue/KT-35008) "AnalyzerException: Expected an object reference, but found I" in inline class companion calling private constructor
- [`KT-35166`](https://youtrack.jetbrains.com/issue/KT-35166) `NoSuchMethodError` at runtime with local property delegate on anonymous object referencing another anonymous object
- [`KT-35224`](https://youtrack.jetbrains.com/issue/KT-35224) It's possible to pass non-spread arrays after arguments with SAM-conversion
- [`KT-35301`](https://youtrack.jetbrains.com/issue/KT-35301) MethodInliner fails with "AssertionError: <init> call doesn't correspond to object transformation info" for qualified this in SAM constructor used as parameter of anonymous object inside inline lambda
- [`KT-35419`](https://youtrack.jetbrains.com/issue/KT-35419) `Failed to generate expression: KtNamedFunction` for local suspend tailrec function with receiver
- [`KT-35511`](https://youtrack.jetbrains.com/issue/KT-35511) VerifyError: "Bad type on operand stack" after reification
- [`KT-35553`](https://youtrack.jetbrains.com/issue/KT-35553) Kotlin compiler generates methods that always have line number 1 for Inline Classes
- [`KT-35725`](https://youtrack.jetbrains.com/issue/KT-35725) "AssertionError: Couldn't find a context for a super-call" for `super` member call in property initializer of companion object
- [`KT-36420`](https://youtrack.jetbrains.com/issue/KT-36420) ClassCastException with inline class Foo extending generic Comparable<Foo>
- [`KT-36713`](https://youtrack.jetbrains.com/issue/KT-36713) AnalyzerException: "Incompatible stack heights" with suspend and inline suspend functions
- [`KT-36794`](https://youtrack.jetbrains.com/issue/KT-36794) Move $assertionsDisabled field to the top-level class
- [`KT-36853`](https://youtrack.jetbrains.com/issue/KT-36853) IR: UninitializedPropertyAccessException on tailrec with object expression in default argument
- [`KT-36875`](https://youtrack.jetbrains.com/issue/KT-36875) "RuntimeException: Trying to access skipped parameter" on synthetic local variable access from inline function
- [`KT-36916`](https://youtrack.jetbrains.com/issue/KT-36916) AnalyzerException: Argument 1: expected I, but found R when using inline class with rxjava
- [`KT-36957`](https://youtrack.jetbrains.com/issue/KT-36957) Exception during codegen: cannot pop operand off an empty stack (Nothing variable in string interpolation)
- [`KT-36984`](https://youtrack.jetbrains.com/issue/KT-36984) SAM adapter classes should be generated as anonymous inner classes in JVM_IR
- [`KT-37704`](https://youtrack.jetbrains.com/issue/KT-37704) Incorrect SMAP syntax
- [`KT-37716`](https://youtrack.jetbrains.com/issue/KT-37716) "AssertionError: <init> call doesn't correspond to object transformation info" with inline reified type parameter, anonymous object and lambda in constructor call
- [`KT-37972`](https://youtrack.jetbrains.com/issue/KT-37972) IllegalAccessError on initializing property reference for a property declared in JvmMultifileClass with -Xmultifile-parts-inherit
- [`KT-38100`](https://youtrack.jetbrains.com/issue/KT-38100) Support local delegated properties (not inlined) in new JVM default modes
- [`KT-38833`](https://youtrack.jetbrains.com/issue/KT-38833) JVM: java.lang.ClassCastException when loop variable is nullable in for loop over unsigned progression
- [`KT-38849`](https://youtrack.jetbrains.com/issue/KT-38849) Read-only variable initialized in non-inline lambda using contract callsInPlace EXACTLY_ONCE is not captured correctly in nested lambdas
- [`KT-38869`](https://youtrack.jetbrains.com/issue/KT-38869) JVM BE produces invalid bytecode when inheriting from AbstractList and declaring methods that look like MutableList implementors (but they aren't)
- [`KT-38965`](https://youtrack.jetbrains.com/issue/KT-38965) "UnsupportedOperationException: Don't know how to generate outer expression: Closure" with reference to local variable in block argument of anonymous object `by` delegation
- [`KT-39289`](https://youtrack.jetbrains.com/issue/KT-39289) CCE in if-else inside annotated 'if' statement
- [`KT-39425`](https://youtrack.jetbrains.com/issue/KT-39425) AbstractMethodError: "Receiver class does not define or inherit an implementation of the resolved method" using classes with complex Java and Kotlin inheritance hierarchies.
- [`KT-39434`](https://youtrack.jetbrains.com/issue/KT-39434) IllegalAccessError with local delegated property in lambda in inlined function
- [`KT-39687`](https://youtrack.jetbrains.com/issue/KT-39687) "Couldn't find captured this" when more than 3 inline functions are nested
- [`KT-39784`](https://youtrack.jetbrains.com/issue/KT-39784) "IndexOutOfBoundsException: Cannot pop operand off an empty stack" caused by JvmOverloads annotation inside an inline class
- [`KT-40165`](https://youtrack.jetbrains.com/issue/KT-40165) ClassCastException caused by SAM conversion used on a functional interface with suspended function
- [`KT-40179`](https://youtrack.jetbrains.com/issue/KT-40179) "VerifyError: Bad type on operand stack" with parent class `get` extension function and child class `set` extension function which used inside child class `plusAssign` extension function
- [`KT-40277`](https://youtrack.jetbrains.com/issue/KT-40277) Fix generic types in special bridge methods
- [`KT-40308`](https://youtrack.jetbrains.com/issue/KT-40308) NoSuchFieldError for multiple delegated extension properties with the same name in a companion object
- [`KT-40338`](https://youtrack.jetbrains.com/issue/KT-40338) NoSuchFieldError on property without backing field that is called as function reference
- [`KT-40392`](https://youtrack.jetbrains.com/issue/KT-40392) Deprecate JvmDefault annotation and old -Xjvm-default modes
- [`KT-40396`](https://youtrack.jetbrains.com/issue/KT-40396) NI: Exceptions when ambiguous type argument and generic invoke
- [`KT-40510`](https://youtrack.jetbrains.com/issue/KT-40510) "AssertionError: DELEGATION slice must override something" for ByteBuffer delegation
- [`KT-40601`](https://youtrack.jetbrains.com/issue/KT-40601) VerifyError: "interface method reference is in an indirect superinterface" when calling @JvmDefault suspend method
- [`KT-40809`](https://youtrack.jetbrains.com/issue/KT-40809) "Couldn't find captured field" compiler error with local function with recursive call through method reference
- [`KT-41056`](https://youtrack.jetbrains.com/issue/KT-41056) Increase stub version due to new "contract" keyword
- [`KT-41105`](https://youtrack.jetbrains.com/issue/KT-41105) IllegalStateException: 'Couldn't find declaration file <class name>' with inline delegate declared in another file
- [`KT-41165`](https://youtrack.jetbrains.com/issue/KT-41165) "IllegalStateException: Concrete fake override public final fun" when an enum class inherits an interface with a variable 'name' or 'ordinal'
- [`KT-41222`](https://youtrack.jetbrains.com/issue/KT-41222) "IllegalStateException: Concrete fake override public final fun" when a class property is inherited as merged 'var' from 'val' and 'var' from parent abstract class and interface properties
- [`KT-41255`](https://youtrack.jetbrains.com/issue/KT-41255) JDK 11: "VerifyError: Bad type on operand stack" with long function body with annotated `when` expression
- [`KT-41427`](https://youtrack.jetbrains.com/issue/KT-41427) NoSuchMethodError caused by implementation by delegation to function reference
- [`KT-41508`](https://youtrack.jetbrains.com/issue/KT-41508) ClassNotFoundException caused by object with overridden function inside a lambda with safe cast receiver
- [`KT-41750`](https://youtrack.jetbrains.com/issue/KT-41750) Inline classes: ClassCastExceptionError when calling .withIndex() on Iterator over Array
- [`KT-41758`](https://youtrack.jetbrains.com/issue/KT-41758) Deprecate kotlin.Metadata.bytecodeVersion and avoid using it in the compiler
- [`KT-41770`](https://youtrack.jetbrains.com/issue/KT-41770) AssertionError: "Asm parameter types should be the same length as Kotlin parameter types" cause by fun interface
- [`KT-41874`](https://youtrack.jetbrains.com/issue/KT-41874) "IllegalStateException: Couldn't obtain compiled function body" on extension delegated property with inline operator getValue in a different file
- [`KT-41917`](https://youtrack.jetbrains.com/issue/KT-41917) [FIR] Incorrect calculating property type for override from intersection scope
- [`KT-42012`](https://youtrack.jetbrains.com/issue/KT-42012) IllegalAccess to protected field instead of getter
- [`KT-42017`](https://youtrack.jetbrains.com/issue/KT-42017) "AssertionError: Unsigned type expected: UInt?" during codegen when a variable of nullable unsigned type is checking for presence in the range
- [`KT-42032`](https://youtrack.jetbrains.com/issue/KT-42032) "AnalyzerException: Expected I, but found R" while using Flow.reduce() with suspend function reference
- [`KT-42034`](https://youtrack.jetbrains.com/issue/KT-42034) ArrayIndexOutOfBoundsException in PopBackwardPropagationTransformer on external override of function in inline class
- [`KT-42064`](https://youtrack.jetbrains.com/issue/KT-42064) "Parameter specified as non-null is null" with default value of the parameter in operator fun
- [`KT-42069`](https://youtrack.jetbrains.com/issue/KT-42069) JVM IR: -Xreport-output-files doesn't report any source files for META-INF/*.kotlin_module files
- [`KT-42083`](https://youtrack.jetbrains.com/issue/KT-42083) AbstractMethodError when 'remove' with irrelevant generic parameter but matching JVM signature is present in Kotlin collection class
- [`KT-42092`](https://youtrack.jetbrains.com/issue/KT-42092) JVM / IR: "AnalyzerException: Argument 1: expected R, but found J" when trying to add to ArrayList the result of a function applied to int
- [`KT-42175`](https://youtrack.jetbrains.com/issue/KT-42175) Psi2ir: "AssertionError: Undefined parameter referenced: <this>" on augmented assignment on this in a BuilderInference lambda
- [`KT-42179`](https://youtrack.jetbrains.com/issue/KT-42179) Platform declaration clash when extending abstract Java class implementing 'java.util.Collection' by abstract Kotlin class implementing Kotlin Set or List
- [`KT-42321`](https://youtrack.jetbrains.com/issue/KT-42321) JVM IR: do not cast integer value based on the type of a literal receiver of an operator call
- [`KT-42337`](https://youtrack.jetbrains.com/issue/KT-42337) NoSuchMethodError in JVM backend with inheritance of private functions in the interface
- [`KT-42404`](https://youtrack.jetbrains.com/issue/KT-42404) "Supertypes of the following classes cannot be resolved" in Rider project
- [`KT-42472`](https://youtrack.jetbrains.com/issue/KT-42472) No TYPE_INFERENCE_UPPER_BOUND_VIOLATED for Delegated Properties do not check types (in Kotlin 1.4.10)
- [`KT-42487`](https://youtrack.jetbrains.com/issue/KT-42487) "IndexOutOfBoundsException: Cannot pop operand off an empty stack" caused by USELESS_IS_CHECK of Double type
- [`KT-42533`](https://youtrack.jetbrains.com/issue/KT-42533) `(N until MIN_VALUE).reversed()` should be an empty progression in for loops
- [`KT-42588`](https://youtrack.jetbrains.com/issue/KT-42588) "IllegalStateException: Concrete fake override public open fun" caused by `val` override with `var` with delegation.
- [`KT-42634`](https://youtrack.jetbrains.com/issue/KT-42634) Different bridges and abstract stubs behavior in abstract class implementing Map<K, String> in JVM and JVM_IR
- [`KT-42635`](https://youtrack.jetbrains.com/issue/KT-42635) ClassCastException with inline class in for loop
- [`KT-42662`](https://youtrack.jetbrains.com/issue/KT-42662) AbstractMethodError when using partially specialized generic Map class
- [`KT-42694`](https://youtrack.jetbrains.com/issue/KT-42694) @get:Synchronized causes the JVM getter method not to be generated
- [`KT-42753`](https://youtrack.jetbrains.com/issue/KT-42753) "VerifyError: Bad invokespecial instruction: interface method reference is in an indirect superinterface" with `jvm-default=all`
- [`KT-42879`](https://youtrack.jetbrains.com/issue/KT-42879) JVM: Declaration clash in fun interface implementation returning an inline class
- [`KT-42900`](https://youtrack.jetbrains.com/issue/KT-42900) "VerifyError: Bad return type" incorrect bytecode when a property and an extension property in inline class have the same names
- [`KT-42946`](https://youtrack.jetbrains.com/issue/KT-42946) FIR2IR:  Fix super-calls to Java overrides of special built-in
- [`KT-42971`](https://youtrack.jetbrains.com/issue/KT-42971) JVM: "AssertionError: Unsigned type expected: T" with UInt loop range
- [`KT-42990`](https://youtrack.jetbrains.com/issue/KT-42990) "AssertionError: Next value after NEW should be one generated by DUP" caused by extension properties with accessors annotataed as @JvmStatic
- [`KT-43034`](https://youtrack.jetbrains.com/issue/KT-43034) AssertionError: Compiler fails with complicated tailrec + inline case
- [`KT-43048`](https://youtrack.jetbrains.com/issue/KT-43048) JVM_IR: Implement coroutines state clearing
- [`KT-43050`](https://youtrack.jetbrains.com/issue/KT-43050) JVM IR: incorrect mangling for method with type parameter with inline class bound in the signature
- [`KT-43059`](https://youtrack.jetbrains.com/issue/KT-43059) Different bridges  behavior in class implementing Map<String, String> in JVM and JVM_IR
- [`KT-43063`](https://youtrack.jetbrains.com/issue/KT-43063) Redundant DefaultImpls delegate is generated in old JVM backend on explicit "duplicate" inheritance from interface
- [`KT-43069`](https://youtrack.jetbrains.com/issue/KT-43069) JVM: incorrect generic signature for method with implicit return type Nothing overriding a method from Collection
- [`KT-43099`](https://youtrack.jetbrains.com/issue/KT-43099) Tailrec call in not tail-call position leads to internal compiler error
- [`KT-43106`](https://youtrack.jetbrains.com/issue/KT-43106) JVM: custom `remove` in Iterator subclass results in a synthetic bridge
- [`KT-43120`](https://youtrack.jetbrains.com/issue/KT-43120) JVM: "Expected an object reference, but found ." caused by function which is passed as reference to suspend parameter
- [`KT-43167`](https://youtrack.jetbrains.com/issue/KT-43167) JVM IR, serialization: "No mapping for symbol: VALUE_PARAMETER INSTANCE_RECEIVER" with data class containing property defined in body
- [`KT-43255`](https://youtrack.jetbrains.com/issue/KT-43255) Verify error when inheriting from an abstract class implementing Collection with stub-like method in superclass
- [`KT-43303`](https://youtrack.jetbrains.com/issue/KT-43303) NI: False negative TYPE_INFERENCE_UPPER_BOUND_VIOLATED when inferred type argument is not a subtype of type parameter upper bound
- [`KT-43333`](https://youtrack.jetbrains.com/issue/KT-43333) AbstractMethodError when calling 'toArray' from Java on a Kotlin Collection with custom internal 'toArray'
- [`KT-43334`](https://youtrack.jetbrains.com/issue/KT-43334) AbstractMethodError when calling 'remove' from Java on a Kotlin Collection with custom internal 'remove'
- [`KT-43342`](https://youtrack.jetbrains.com/issue/KT-43342) [FIR2IR] No getter or backing field found for delegated member call
- [`KT-43347`](https://youtrack.jetbrains.com/issue/KT-43347) [FIR] Synthetic setter with unmatched parameter type isn't found
- [`KT-43401`](https://youtrack.jetbrains.com/issue/KT-43401) JVM_IR. Additional `synchronized` flag on JvmOverloads-generated adapter for Synchronized function
- [`KT-43405`](https://youtrack.jetbrains.com/issue/KT-43405) Turkish locale, Linux Mint: "NoSuchMethodError: 'int[] kotlin.jvm.internal.Intrinsics$Kotlin.intArrayOf(int[])'" with `intArrayOf` function call
- [`KT-43460`](https://youtrack.jetbrains.com/issue/KT-43460) JVM: redundant private setter is generated in case of multifile facade
- [`KT-43473`](https://youtrack.jetbrains.com/issue/KT-43473) "VerifyError: Bad type on operand stack" caused by operator `get` with optional argument in superclass when called via square brackets on subclass
- [`KT-43518`](https://youtrack.jetbrains.com/issue/KT-43518) JVM_IR. Additional `strictfp` flag on JvmOverloads-generated adapter for Strictfp function
- [`KT-43569`](https://youtrack.jetbrains.com/issue/KT-43569) FIR: inapplicable candidate(s): kotlin/collections/set
- [`KT-43616`](https://youtrack.jetbrains.com/issue/KT-43616) [FIR] Nullable type parameter-based type after merge in if
- [`KT-43669`](https://youtrack.jetbrains.com/issue/KT-43669) FIR: No real overrides for FUN IR_EXTERNAL_DECLARATION_STUB
- [`KT-43682`](https://youtrack.jetbrains.com/issue/KT-43682) Inline extension method of a multifile library inline class not found
- [`KT-43687`](https://youtrack.jetbrains.com/issue/KT-43687) FIR: UnusedChecker does not take annotation arguments into account
- [`KT-43688`](https://youtrack.jetbrains.com/issue/KT-43688) FIR: unused checker doesn't handle invokes properly
- [`KT-43749`](https://youtrack.jetbrains.com/issue/KT-43749) "UnsupportedOperationException: Don't know how to generate outer expression: Closure" caused by Flow and collect method with function reference as a parameter
- [`KT-43812`](https://youtrack.jetbrains.com/issue/KT-43812) JVM IR: SAM wrapper class with generic supertype mentions missing type parameter in the signature
- [`KT-43832`](https://youtrack.jetbrains.com/issue/KT-43832) JVM IR: missing bridges for inheritance of class from interface in a complex generic diamond hierarchy
- [`KT-43851`](https://youtrack.jetbrains.com/issue/KT-43851) JVM IR: function call returning object instance is removed during constant propagation
- [`KT-43864`](https://youtrack.jetbrains.com/issue/KT-43864) JVM: "Assertion error after mandatory stack transformations: incorrect bytecode" with lateinit property of type T, which has a primitive type upperbound
- [`KT-43887`](https://youtrack.jetbrains.com/issue/KT-43887) Problem with FunctionReferenceLowering$FunctionReferenceBuilder in kotlin native
- [`KT-43912`](https://youtrack.jetbrains.com/issue/KT-43912) JVM internal error: Augment assignment and increment are not supported for local delegated properties and inline properties
- [`KT-43915`](https://youtrack.jetbrains.com/issue/KT-43915) Back-end (JVM) Internal error: wrong bytecode generated for default method
- [`KT-43938`](https://youtrack.jetbrains.com/issue/KT-43938) NSME when calling 'kotlin.Number' methods on instance of Java class extending Kolin abstract class extending 'kotlin.Number'
- [`KT-43942`](https://youtrack.jetbrains.com/issue/KT-43942) org.jetbrains.kotlin.codegen.CompilationException: Back-end (JVM) Internal error: Failed to generate function
- [`KT-43949`](https://youtrack.jetbrains.com/issue/KT-43949) FIR: unresolved callable reference as lambda return
- [`KT-43983`](https://youtrack.jetbrains.com/issue/KT-43983) IllegalStateException: "Couldn't obtain compiled function body for public final suspend inline fun" after moving inline extension function to library
- [`KT-43984`](https://youtrack.jetbrains.com/issue/KT-43984) FIR: recursion in overridden symbols
- [`KT-43984`](https://youtrack.jetbrains.com/issue/KT-43984) FIR: recursion in overridden symbols
- [`KT-44010`](https://youtrack.jetbrains.com/issue/KT-44010) FIR: Inapplicable constructor due to an unresolved reference
- [`KT-44030`](https://youtrack.jetbrains.com/issue/KT-44030) FIR2IR: uncached type parameters in delegated property
- [`KT-44032`](https://youtrack.jetbrains.com/issue/KT-44032) FIR2IR: uncached type parameters in Java field
- [`KT-44050`](https://youtrack.jetbrains.com/issue/KT-44050) FIR: anonymous object as IR parent
- [`KT-44054`](https://youtrack.jetbrains.com/issue/KT-44054) FIR2IR: incorrect IR origin for substituted override function
- [`KT-44058`](https://youtrack.jetbrains.com/issue/KT-44058) CompilationException: open suspend fun with @JvmStatic in open class companion
- [`KT-44069`](https://youtrack.jetbrains.com/issue/KT-44069) please remove deprecated usages
- [`KT-44066`](https://youtrack.jetbrains.com/issue/KT-44066) FIR Java: override ambiguity with vararg value type
- [`KT-44114`](https://youtrack.jetbrains.com/issue/KT-44114) CompilationException when inlining a extension suspend function declared in interface companion with 'this' reference to extension receiver
- [`KT-44131`](https://youtrack.jetbrains.com/issue/KT-44131) "UnsupportedOperationException: Don't know how to generate outer expression: Closure" when using suspend lambda and a function reference
- [`KT-44140`](https://youtrack.jetbrains.com/issue/KT-44140) JVM IR: compilation of kotlin.Result crashes with IOOBE while generating toString-impl
- [`KT-44141`](https://youtrack.jetbrains.com/issue/KT-44141) JVM IR: "ISE: There should be underlying type for inline class type" on usage of type parameter with Result upper bound inside a lambda
- [`KT-44192`](https://youtrack.jetbrains.com/issue/KT-44192) Allow a greater number of constants in an enum class
- [`KT-44202`](https://youtrack.jetbrains.com/issue/KT-44202) "ClassCastException" when getting delegated property with inline class and Any/Any? type
- [`KT-44210`](https://youtrack.jetbrains.com/issue/KT-44210) KJS / IR: "AssertionError: Undefined parameter referenced: <this> defined" caused by plus assign operators in build blocks
- [`KT-44233`](https://youtrack.jetbrains.com/issue/KT-44233) [IR] Collection Stub generation not correctly considering java.util Collection iterators
- [`KT-44234`](https://youtrack.jetbrains.com/issue/KT-44234) Private companion property with explicit setter generates invalid bytecode
- [`KT-44269`](https://youtrack.jetbrains.com/issue/KT-44269) "[TAILREC_ON_VIRTUAL_MEMBER_ERROR] Tailrec is not allowed on open members" with Spring annotation and private tailrec function
- [`KT-44284`](https://youtrack.jetbrains.com/issue/KT-44284) Make Kotlin binaries publicly unavailable (set KotlinCompilerVersion.IS_PRE_RELEASE = true)
- [`KT-44316`](https://youtrack.jetbrains.com/issue/KT-44316) ReenteringLazyValueComputationException when analyzing complex lazy delegate
- [`KT-44347`](https://youtrack.jetbrains.com/issue/KT-44347) Back-end (JVM) Internal error: Couldn't transform method node for suspend function with wrong local for Continuation
- [`KT-44368`](https://youtrack.jetbrains.com/issue/KT-44368) "IllegalStateException: Error type encountered" when inlining 'invoke' operator without enough information on type variable
- [`KT-44412`](https://youtrack.jetbrains.com/issue/KT-44412) JVM IR backend fails to compile break in condition of do while
- [`KT-44420`](https://youtrack.jetbrains.com/issue/KT-44420) False NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATION with 1.4.30-RC
- [`KT-44429`](https://youtrack.jetbrains.com/issue/KT-44429) JVM IR: unnecessary integer unboxing leads to NPE when using mockito-kotlin
- [`KT-44439`](https://youtrack.jetbrains.com/issue/KT-44439) Type inference of generic types failing java interop
- [`KT-44440`](https://youtrack.jetbrains.com/issue/KT-44440) Too many Nothings in inferred type
- [`KT-44471`](https://youtrack.jetbrains.com/issue/KT-44471) Fix failing script tests after switching to 1.5
- [`KT-44474`](https://youtrack.jetbrains.com/issue/KT-44474) Compiler expects sealed type inheritors from platform specific source-sets in when expression in common source-set
- [`KT-44483`](https://youtrack.jetbrains.com/issue/KT-44483) JVM IR: CCE on calling generic vararg function reference with Array expected type
- [`KT-44527`](https://youtrack.jetbrains.com/issue/KT-44527) Suspend function with kotlin.Result: ClassCastException class kotlin.Result cannot be cast to class ...
- [`KT-44529`](https://youtrack.jetbrains.com/issue/KT-44529) Inline class calls wrong iterator method in for loop
- [`KT-44533`](https://youtrack.jetbrains.com/issue/KT-44533) JVM IR: ClassFormatError on synthetic $suspendImpl method generated in interface for a @JvmDefault function
- [`KT-44540`](https://youtrack.jetbrains.com/issue/KT-44540) Regression in 1.4.30 in intellij-community: type mismatch for generic function call with generic Java class
- [`KT-44546`](https://youtrack.jetbrains.com/issue/KT-44546) NI: changed variable fixation order (that can lead to changed resolution)
- [`KT-44550`](https://youtrack.jetbrains.com/issue/KT-44550) KotlinBinaryClassCache leaks Kotlin plugin classloader on plugin unload
- [`KT-44563`](https://youtrack.jetbrains.com/issue/KT-44563) Type Inference loosing type annotations in lambda type expectation for function calls with block parameters
- [`KT-44583`](https://youtrack.jetbrains.com/issue/KT-44583) "Supertypes of the following classes cannot be resolved" error message gives no context
- [`KT-44627`](https://youtrack.jetbrains.com/issue/KT-44627) JVM IR: ACCIDENTAL_OVERRIDE when overriding a generic field where the type parameter has a primitive bound
- [`KT-44631`](https://youtrack.jetbrains.com/issue/KT-44631) "IndexOutOfBoundsException: Cannot pop operand off an empty stack" caused by a default param in inner class constructor which uses method or field from receiver
- [`KT-44647`](https://youtrack.jetbrains.com/issue/KT-44647) "IllegalAccessError: class TestKt tried to access private method" with String Builder `get` and `inc` operator
- [`KT-44651`](https://youtrack.jetbrains.com/issue/KT-44651) JVM / IR: "IllegalStateException: Illegal type substitutor" with if-else inside class constructor argument inside another if-else
- [`KT-44660`](https://youtrack.jetbrains.com/issue/KT-44660) Internal inline functions in companion object with inline class return type fails compilation
- [`KT-44671`](https://youtrack.jetbrains.com/issue/KT-44671) JVM_IR: ClassCastException: Result$Failure cannot be cast to Result with multithreaded coroutines
- [`KT-44703`](https://youtrack.jetbrains.com/issue/KT-44703) JVM / IR: "IllegalStateException: Unhandled special name in mangledNameFor" caused by a reference to inline class inside interface's companion with lazy initialization
- [`KT-44712`](https://youtrack.jetbrains.com/issue/KT-44712) JVM / IR: Behavior change after enabling with Mockito
- [`KT-44714`](https://youtrack.jetbrains.com/issue/KT-44714) Debugger / Coroutines: Local variables are trimmed out too aggressively
- [`KT-44722`](https://youtrack.jetbrains.com/issue/KT-44722) JVM IR: ClassCastException with inline class, let and bound function reference
- [`KT-44726`](https://youtrack.jetbrains.com/issue/KT-44726) JVM IR: Incorrect KType nullability for platform type reified as non-null
- [`KT-44781`](https://youtrack.jetbrains.com/issue/KT-44781) JVM IR: java.lang.NoSuchFieldError: $noName_0 when calling a crossinline lambda within a suspending lambda
- [`KT-44798`](https://youtrack.jetbrains.com/issue/KT-44798) JVM IR: Inherited platform declarations clash for class implementing both List and Set
- [`KT-44801`](https://youtrack.jetbrains.com/issue/KT-44801) 1.4.30 JVM IR: Unbound symbols not allowed with anonymous object
- [`KT-44803`](https://youtrack.jetbrains.com/issue/KT-44803) FIR bootstrap: incorrect nullability is set for type alias-based type
- [`KT-44827`](https://youtrack.jetbrains.com/issue/KT-44827) Non-existing outer class is written in anonymous class for SAM wrapper in inline lambda with capture
- [`KT-44837`](https://youtrack.jetbrains.com/issue/KT-44837) JVM / IR: ClassCastException with Result object when it is used by a generic method in a suspend call
- [`KT-44875`](https://youtrack.jetbrains.com/issue/KT-44875) JVM_IR. `hashCode` call is generated  on interface target in fun interface equality
- [`KT-44878`](https://youtrack.jetbrains.com/issue/KT-44878) JVM_IR: "IllegalStateException: Unexpected types" when checking non-nullable variable is `in` range between nullable ones with smart-cast
- [`KT-44926`](https://youtrack.jetbrains.com/issue/KT-44926) MPP: Actual typealias to compiled inline class incompatible with expect inline class
- [`KT-44947`](https://youtrack.jetbrains.com/issue/KT-44947) Sealed interfaces: Sealed fun interface leads to "NoWhenBranchMatchedException"
- [`KT-44993`](https://youtrack.jetbrains.com/issue/KT-44993) JVM IR: VerifyError on getfield with Kotlin generic field and elvis operator
- [`KT-45008`](https://youtrack.jetbrains.com/issue/KT-45008) JVM IR: hashCode is generated as invokeinterface if smart cast to interface is present
- [`KT-45011`](https://youtrack.jetbrains.com/issue/KT-45011) JVM / IR: "AssertionError: Unbound symbols not allowed"
- [`KT-45022`](https://youtrack.jetbrains.com/issue/KT-45022) IR: "AssertionError: Undefined variable referenced" from psi2ir caused by plusAssign operator of object
- [`KT-45064`](https://youtrack.jetbrains.com/issue/KT-45064) JVM IR: "java.lang.AssertionError: SyntheticAccessorLowering should not attempt to modify other files!" with member reference to property in another file with private setter
- [`KT-45067`](https://youtrack.jetbrains.com/issue/KT-45067) "IllegalArgumentException: Wildcard mast have a bound for annotation of WILDCARD_BOUND position" with BEAM SDK 2.27
- [`KT-45069`](https://youtrack.jetbrains.com/issue/KT-45069) JVM / IR: New SAM conversions mode fails when converting from Unit to Any
- [`KT-45131`](https://youtrack.jetbrains.com/issue/KT-45131) JVM / IR: "RuntimeException: Lambda, SAM or anonymous object should have only one constructor" caused by inline class that type cast to reified type parameter inside lambda in inline function
- [`KT-45139`](https://youtrack.jetbrains.com/issue/KT-45139) Inline class: AssertionError: Expected top level inline class
- [`KT-45166`](https://youtrack.jetbrains.com/issue/KT-45166) JVM / IR: "AbstractMethodError: Receiver class does not define or inherit an implementation of the resolved method of interface" caused by interface with suspend function
- [`KT-45187`](https://youtrack.jetbrains.com/issue/KT-45187) JVM /  IR: ClassCastException caused by substituting generic type of vararg parameter with java.lang.Void
- [`KT-45195`](https://youtrack.jetbrains.com/issue/KT-45195) JVM IR: annotation methods are generated as default interface methods if `allopen` is used
- [`KT-45243`](https://youtrack.jetbrains.com/issue/KT-45243) "IllegalStateException: Lambdas shouldn't be visited by ESExpressionVisitor" caused by lambda inside `kotlin.test.assertNotNull`
- [`KT-45259`](https://youtrack.jetbrains.com/issue/KT-45259) JVM: ClassCastException caused by Result as lambda parameter type
- [`KT-45292`](https://youtrack.jetbrains.com/issue/KT-45292) AssertionError with recursive inline extension property
- [`KT-45300`](https://youtrack.jetbrains.com/issue/KT-45300) Deprecate super calls in public-api inline functions
- [`KT-45409`](https://youtrack.jetbrains.com/issue/KT-45409) Rename jspecify annotations’ package and default not null annotation
- [`KT-45446`](https://youtrack.jetbrains.com/issue/KT-45446) JVM / IR: NullPointerException caused by unreachable code and comparison
- [`KT-45721`](https://youtrack.jetbrains.com/issue/KT-45721) JVM / IR: "Unbound symbols not allowed" caused by class reference in sequence lambda
- [`KT-45853`](https://youtrack.jetbrains.com/issue/KT-45853) JVM / IR: "Accidental override" caused by inheriting Throwable.getCause from Java interface
- [`KT-45861`](https://youtrack.jetbrains.com/issue/KT-45861) Turning warnings into errors for calls with type parameters annotated by @OnlyInputTypes
- [`KT-45865`](https://youtrack.jetbrains.com/issue/KT-45865) JVM IR: "VerifyError: Bad type on operand stack" with `enumValueOf` on a value from a list of strings
- [`KT-45868`](https://youtrack.jetbrains.com/issue/KT-45868) JVM IR: ClassCastException with SAM function in init block when SAM is generated via invokedynamic
- [`KT-45920`](https://youtrack.jetbrains.com/issue/KT-45920) JVM IR: "Accidental override" on redefining `get()` in custom Map class
- [`KT-45934`](https://youtrack.jetbrains.com/issue/KT-45934) JVM IR: "java.lang.IllegalStateException: Function has no body" for class implementing interface by delegation
- [`KT-45945`](https://youtrack.jetbrains.com/issue/KT-45945) JVM / IR: "AssertionError: Unexpected variance in super type argument" with contravariance and intersection types
- [`KT-45963`](https://youtrack.jetbrains.com/issue/KT-45963) JVM / IR: "AbstractMethodError: Receiver class does not define or inherit an implementation of the resolved method" in Dokka tests
- [`KT-45967`](https://youtrack.jetbrains.com/issue/KT-45967) JVM IR: "IllegalAccessError" with invokedynamic to Java SAM over callable reference to private function
- [`KT-45982`](https://youtrack.jetbrains.com/issue/KT-45982) Wrong subtyping result on captured types with postponed type variables
- [`KT-46007`](https://youtrack.jetbrains.com/issue/KT-46007) JVM / IR: "ClassCastException: kotlin.Unit cannot be cast to java.lang.String" caused by default suspend function in interface
- [`KT-46060`](https://youtrack.jetbrains.com/issue/KT-46060) JVM IR: NullPointerException from RangeContainsLowering when `contains` is a @JvmStatic function in object
- [`KT-46069`](https://youtrack.jetbrains.com/issue/KT-46069) JVM IR: unbound type parameter on generic bound adapted function reference
- [`KT-46092`](https://youtrack.jetbrains.com/issue/KT-46092) JVM IR: AssertionError "Array type expected: @[FlexibleNullability] kotlin.CharArray?" on super call to Java constructor with primitive vararg
- [`KT-46104`](https://youtrack.jetbrains.com/issue/KT-46104) The message on inline -> value class migration should not say that inline classes are deprecated
- [`KT-46131`](https://youtrack.jetbrains.com/issue/KT-46131) Kotlin 1.5.0-RC errors when reading class file
- [`KT-46160`](https://youtrack.jetbrains.com/issue/KT-46160) JVM IR: IllegalAccessException at runtime for member reference to JvmMultifileClass member from stdlib
- [`KT-46186`](https://youtrack.jetbrains.com/issue/KT-46186) Type inference regression in Kotlin 1.5 with constrained generic return types

### Docs & Examples

- [`KT-45884`](https://youtrack.jetbrains.com/issue/KT-45884) Incorrect description for JVM `toUpperCase` method

### IDE

- [`KT-33233`](https://youtrack.jetbrains.com/issue/KT-33233) Use dependency of library to build built-ins in IDE, instead of loading them from the current classloader
- [`KT-34023`](https://youtrack.jetbrains.com/issue/KT-34023) kotlin.KotlinNullPointerException at org.jetbrains.kotlin.backend.common.FunctionsFromAnyGenerator.getPrimaryConstructorProperties(FunctionsFromAnyGenerator.kt:66)
- [`KT-35947`](https://youtrack.jetbrains.com/issue/KT-35947) KFunctionN.call is unresolved in IDE in Kotlin/JVM project
- [`KT-37702`](https://youtrack.jetbrains.com/issue/KT-37702) Code analysis speed: on-the-fly analysis diagnostics reporting
- [`KT-41048`](https://youtrack.jetbrains.com/issue/KT-41048) [FIR-IDE] Properly implement methods in KtFirPackageScope
- [`KT-41671`](https://youtrack.jetbrains.com/issue/KT-41671) Missing nullability information in properties using type inference from get()
- [`KT-43824`](https://youtrack.jetbrains.com/issue/KT-43824) KtLightClassForSourceDeclaration#isInheritor works in a different way than java implementation
- [`KT-44128`](https://youtrack.jetbrains.com/issue/KT-44128) IDE: Kotlin JVM record has incorrect property accessors as seen from Java
- [`KT-44487`](https://youtrack.jetbrains.com/issue/KT-44487) MPP, IDE: No error in IDE when sealed class inheritor from common source-set is not used in exhaustive when expression in platform source-set
- [`KT-45254`](https://youtrack.jetbrains.com/issue/KT-45254) Highlighting for files with certain errors appears only on second opening
- [`KT-46097`](https://youtrack.jetbrains.com/issue/KT-46097) Light classes: Incomplete nullability information for a getter method of a kotlin property defined in private constructor

### IDE. Decompiler, Indexing, Stubs

- [`KT-43699`](https://youtrack.jetbrains.com/issue/KT-43699) IDE: Unresolved extension method from Java code for simple class with typealias and generics (IllegalStateException: Unknown type parameter)
- [`KT-44756`](https://youtrack.jetbrains.com/issue/KT-44756) Infinite "UpToDateStubIndexMismatch: PSI and index do not match." with IDEA 2021.1 EAP upon attempt to open "org.gradle.configurationcache" even they seem to be the same

### IDE. Gradle Integration

- [`KT-37127`](https://youtrack.jetbrains.com/issue/KT-37127) Implement precise importing of platforms of root source sets (commonMain/commonTest) when hierarchical multiplatform support is enabled
- [`KT-42048`](https://youtrack.jetbrains.com/issue/KT-42048) KJS / Gradle integration: Could not determine the dependencies of task ':webApp:testPackageJson' in Android Studio 4.2 Canary 11

### IDE. Gradle. Script

- [`KT-46215`](https://youtrack.jetbrains.com/issue/KT-46215) Dead lock on closing project during the import in IJ211 through ScriptDefinitionsManager

### IDE. Inspections and Intentions

- [`KT-23824`](https://youtrack.jetbrains.com/issue/KT-23824) Return lifted out of if condition causes suspend tail call optimization to no longer apply
- [`KT-38155`](https://youtrack.jetbrains.com/issue/KT-38155) Lift assignment out of 'if' produces type mismatch without manually adding a semicolon
- [`KT-44821`](https://youtrack.jetbrains.com/issue/KT-44821) IDE: False positive NO_ELSE_IN_WHEN caused by sealed class and when in another module
- [`KT-46088`](https://youtrack.jetbrains.com/issue/KT-46088) [IDEA] Incorrect behavior of replace inline class with value class intention

### IDE. Misc

- [`KT-44675`](https://youtrack.jetbrains.com/issue/KT-44675) Incorrect reference to resource into 202 plugin

### IDE. Refactorings

- [`KT-44079`](https://youtrack.jetbrains.com/issue/KT-44079) Sealed Interfaces: Move refactoring should warn about violation of hierarchy restrictions
- [`KT-44839`](https://youtrack.jetbrains.com/issue/KT-44839) Sealed interfaces: move refactoring warnings works with "more freedom for sealed classes" rules for language level < 1.5

### IDE. Script

- [`KT-43288`](https://youtrack.jetbrains.com/issue/KT-43288) Allow push notifications about script configuration /dependencies changes via the `ScriptDefinitionsProvider` EP

### JavaScript

- [`KT-39272`](https://youtrack.jetbrains.com/issue/KT-39272) KJS / IR: Can't use javascript keywords as JsName
- [`KT-41650`](https://youtrack.jetbrains.com/issue/KT-41650) JS IR BE: `default` should be a reserved identifier
- [`KT-42176`](https://youtrack.jetbrains.com/issue/KT-42176) KJS / IR: Interface default method in sub-interface not resolved correctly from extension on super-interface
- [`KT-44103`](https://youtrack.jetbrains.com/issue/KT-44103) [JSIR] TypeError when bumping from 1.4.20 to 1.4.30-M1
- [`KT-44180`](https://youtrack.jetbrains.com/issue/KT-44180) KJS / IR: NPE in ConstTransformer of compileDevelopmentExecutableKotlinJs/compileProductionExecutableKotlinJs tasks
- [`KT-44415`](https://youtrack.jetbrains.com/issue/KT-44415) Kotlin/JS with IR and kotlin-react: "too much recursion" error in runtime in browser
- [`KT-44433`](https://youtrack.jetbrains.com/issue/KT-44433) KJS IR: support function interfaces with suspend member
- [`KT-44469`](https://youtrack.jetbrains.com/issue/KT-44469) KJS / IR: Incorrect export functions with bridges
- [`KT-44718`](https://youtrack.jetbrains.com/issue/KT-44718) MPP/ KJS: "IllegalStateException: Unsupported operation" with serialization plugin and incremental compilation
- [`KT-44796`](https://youtrack.jetbrains.com/issue/KT-44796) KJS / IR: default parameter of function with @JsName leads to "RangeError: Maximum call stack size exceeded"
- [`KT-45059`](https://youtrack.jetbrains.com/issue/KT-45059) KJS / IR: Add possibility for runtime diagnostics of DCE result

### Libraries

- [`KT-12109`](https://youtrack.jetbrains.com/issue/KT-12109) Add stdlib method that combines mapNotNull() and first/firstOrNull()
- [`KT-25571`](https://youtrack.jetbrains.com/issue/KT-25571) Make random implementations serializable
- [`KT-26234`](https://youtrack.jetbrains.com/issue/KT-26234) Floored division and remainder function for numeric types
- [`KT-32996`](https://youtrack.jetbrains.com/issue/KT-32996) kotlin.test: add assertContentEquals for comparing content of arrays, iterables, sequences
- [`KT-39177`](https://youtrack.jetbrains.com/issue/KT-39177) Make CharCategory available in common multiplatform code
- [`KT-40225`](https://youtrack.jetbrains.com/issue/KT-40225) Support adding kotlin-test as a single dependency, as it should be with a multiplatform library
- [`KT-42071`](https://youtrack.jetbrains.com/issue/KT-42071) Strict version of String.toBoolean()
- [`KT-42720`](https://youtrack.jetbrains.com/issue/KT-42720) Kotlin ArrayDeque on JVM: provide optimized toArray method
- [`KT-42840`](https://youtrack.jetbrains.com/issue/KT-42840) Commonize and generalize String.contentEquals that is currently JVM-only
- [`KT-43772`](https://youtrack.jetbrains.com/issue/KT-43772) Kotlin/Native unfinished workers detected.
- [`KT-44168`](https://youtrack.jetbrains.com/issue/KT-44168) Prevent storing NaN and negative zero in kotlin.time.Duration
- [`KT-44369`](https://youtrack.jetbrains.com/issue/KT-44369) Commonize Char.titlecaseChar() and Char.titlecase() that are currently JVM-only
- [`KT-44783`](https://youtrack.jetbrains.com/issue/KT-44783) Add IS_VALUE flag for value classes to kotlinx-metadata-jvm
- [`KT-44815`](https://youtrack.jetbrains.com/issue/KT-44815) Remove kotlin-annotations-android and JVM compiler support for @ParameterName/@DefaultValue/@DefaultNull
- [`KT-45213`](https://youtrack.jetbrains.com/issue/KT-45213) Update Unicode version used in K/N for Char and String case conversion functions

### Middle-end. IR

- [`KT-43831`](https://youtrack.jetbrains.com/issue/KT-43831) Compilation failed, IrSimpleFunctionPublicSymbolImpl is already bound
- [`KT-44100`](https://youtrack.jetbrains.com/issue/KT-44100) KJS / IR: Top level declarations added in IR plugin are not referenceable from other modules
- [`KT-45170`](https://youtrack.jetbrains.com/issue/KT-45170) IR: "AssertionError: Single expression value for GET_OBJECT" caused by inc operator of field inside scope function inside object

### Native

- [`KT-42446`](https://youtrack.jetbrains.com/issue/KT-42446) Native: SIGSEGV in Kotlin_Array_get on linuxArm64
- [`KT-43502`](https://youtrack.jetbrains.com/issue/KT-43502) [K/N] relocation R_X86_64_PC32 cannot be used against symbol __environ; recompile with -fPIC
- [`KT-44295`](https://youtrack.jetbrains.com/issue/KT-44295) 1.4.21 Kotlin native ndk compiler crash
- [`KT-44774`](https://youtrack.jetbrains.com/issue/KT-44774) ld fails with CALL16 reloc at 0x48f00 not against global symbol (Linux MIPS)
- [`KT-44746`](https://youtrack.jetbrains.com/issue/KT-44746) Different hashCode() results for Kotlin/Native stdlib

### Native. C and ObjC Import

- [`KT-44824`](https://youtrack.jetbrains.com/issue/KT-44824) cinterop tool no longer appends .klib to produced klibs

### Native. C Export

- [`KT-36639`](https://youtrack.jetbrains.com/issue/KT-36639) MPP: Build ios "staticLib" or "sharedLib" binary failed if interface contains member extension function
- [`KT-41725`](https://youtrack.jetbrains.com/issue/KT-41725) Dynamic library doesn't load on raspberrypi

### Native. ObjC Export

- [`KT-44549`](https://youtrack.jetbrains.com/issue/KT-44549) In the Xcode debug session, call stack is missing a frame when the iOS app fails

### Native. Platforms

- [`KT-45094`](https://youtrack.jetbrains.com/issue/KT-45094) Fail to compile Kotlin Native sources under Oracle Linux 7

### Reflection

- [`KT-44594`](https://youtrack.jetbrains.com/issue/KT-44594) Avoid using unnecessary array types reflection in kotlin-reflect
- [`KT-44782`](https://youtrack.jetbrains.com/issue/KT-44782) Add KClass.isValue to kotlin-reflect

### Tools. Ant

- [`KT-16227`](https://youtrack.jetbrains.com/issue/KT-16227) Ant task: do not include runtime by default if destination is a jar
- [`KT-44293`](https://youtrack.jetbrains.com/issue/KT-44293) Support fork mode in kotlinc Ant task

### Tools. CLI

- [`KT-17344`](https://youtrack.jetbrains.com/issue/KT-17344) Include kotlin-reflect to resulting jar if "-include-runtime" is specified
- [`KT-43220`](https://youtrack.jetbrains.com/issue/KT-43220) -include-runtime should add .kotlin_builtins to the output
- [`KT-43704`](https://youtrack.jetbrains.com/issue/KT-43704) Illegal reflective access by com.intellij.util.ReflectionUtil to method java.util.ResourceBundle.setParent(java.util.ResourceBundle)
- [`KT-44078`](https://youtrack.jetbrains.com/issue/KT-44078) Do not include module-info.class of kotlin-stdlib.jar to the resulting jar with -include-runtime
- [`KT-44232`](https://youtrack.jetbrains.com/issue/KT-44232) CLI: do not pass -noverify to java process starting from JDK 13
- [`KT-45566`](https://youtrack.jetbrains.com/issue/KT-45566) JDK 16 - e: java.lang.NoClassDefFoundError: Could not initialize class org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel

### Tools. CLI. Native

- [`KT-43874`](https://youtrack.jetbrains.com/issue/KT-43874) Native / CLI: provide a way to show difference between Jvm and Native compilers

### Tools. Compiler Plugins

- [`KT-45783`](https://youtrack.jetbrains.com/issue/KT-45783) Serialization: "AnalyzerException: Expected an object reference, but found I" caused by `JvmInline` and `Serializable` annotations

### Tools. Gradle

- [`KT-31027`](https://youtrack.jetbrains.com/issue/KT-31027) java.lang.NoSuchMethodError: No static method hashCode(Z)I in class Ljava/lang/Boolean; or its super classes (declaration of 'java.lang.Boolean' appears in /system/framework/core-libart.jar)
- [`KT-43605`](https://youtrack.jetbrains.com/issue/KT-43605) Kotlin Gradle Plugin 1.4.20 undeclared system property reads cause problems with Gradle configuration cache enabled
- [`KT-44204`](https://youtrack.jetbrains.com/issue/KT-44204) Kotlin Gradle Plugin 1.4.21 makes impossible to use ANTLR in other plugins
- [`KT-44361`](https://youtrack.jetbrains.com/issue/KT-44361) Gradle: deprecate options includeRuntime, noStdlib, noReflect
- [`KT-44462`](https://youtrack.jetbrains.com/issue/KT-44462) Kotlin Gradle plugin creates `compile` configuration with Gradle 7.0
- [`KT-44834`](https://youtrack.jetbrains.com/issue/KT-44834) Gradle Kotlin DSL: Add `languageSettings` configuration lambda without `apply` call
- [`KT-44949`](https://youtrack.jetbrains.com/issue/KT-44949) Compatibility with Gradle 7.0
- [`KT-44957`](https://youtrack.jetbrains.com/issue/KT-44957) gradle - target.compilations seems to be deprecated
- [`KT-45340`](https://youtrack.jetbrains.com/issue/KT-45340) Update minimal supported version of Kotlin Gradle Plugin to 6.1

### Tools. Gradle. JS

- [`KT-43237`](https://youtrack.jetbrains.com/issue/KT-43237) KJS: `-jsLegacy` Naming Convention is incompatible with NPM
- [`KT-43869`](https://youtrack.jetbrains.com/issue/KT-43869) Error in webpack configuration not displayed
- [`KT-44614`](https://youtrack.jetbrains.com/issue/KT-44614) Update Node.JS and Yarn versions
- [`KT-44616`](https://youtrack.jetbrains.com/issue/KT-44616) Kotlin/JS: IR backend with React: "Uncaught TypeError: _this__0 is undefined" runtime error in browser
- [`KT-45574`](https://youtrack.jetbrains.com/issue/KT-45574) Sync Kotlin/JS compile tasks into one folder (build/js/packages/<package>/kotlin)

### Tools. Gradle. Multiplatform

- [`KT-42098`](https://youtrack.jetbrains.com/issue/KT-42098) Commonizer is re-launched for every included Gradle build
- [`KT-43116`](https://youtrack.jetbrains.com/issue/KT-43116) Merge together MultiplatformHighlightingTest and MultiplatformAnalysisTest
- [`KT-44322`](https://youtrack.jetbrains.com/issue/KT-44322) KotlinTargetComponent maintenance for -sources.jar
- [`KT-44900`](https://youtrack.jetbrains.com/issue/KT-44900) Support gradle configuration cache with kotlin.multiplatform plugin

### Tools. Gradle. Native

- [`KT-46122`](https://youtrack.jetbrains.com/issue/KT-46122) kotlinx-serialization and kotlinx-datetime can't be built with 1.5.0-RC

### Tools. JPS

- [`KT-13631`](https://youtrack.jetbrains.com/issue/KT-13631) Compilation fails on Turkish locale because of locale-sensitive uppercasing
- [`KT-44644`](https://youtrack.jetbrains.com/issue/KT-44644) Mark all `@JvmMultifileClass` parts compiled in the previous round as dirty in the JPS plugin, similarly to how it’s done in the Gradle plugin

### Tools. Scripts

- [`KT-45194`](https://youtrack.jetbrains.com/issue/KT-45194) KT: Generate Kotlin Entities script: it doesn't work
- [`KT-44580`](https://youtrack.jetbrains.com/issue/KT-44580) Scripts: Unable to set new file annotation hooks after first snippet compilation

### Tools. kapt

- [`KT-43686`](https://youtrack.jetbrains.com/issue/KT-43686) KaptWithoutKotlincTask should use `@CompileClasspath` for `kotlinStdlibClasspath` for cache relocateability.
- [`KT-44130`](https://youtrack.jetbrains.com/issue/KT-44130) KAPT changes field order in 1.4.30-M1
- [`KT-44909`](https://youtrack.jetbrains.com/issue/KT-44909) Kapt: ReenteringLazyValueComputationException without stacktrace caused by `when` expression with sealed class function without explicit return type
- [`KT-45168`](https://youtrack.jetbrains.com/issue/KT-45168) KAPT: Java stubs generated for Kotlin files generated by annotation processors


## Recent ChangeLogs:
### [ChangeLog-1.4.X](docs/changelogs/ChangeLog-1.4.X.md)
### [ChangeLog-1.3.X](docs/changelogs/ChangeLog-1.3.X.md)
### [ChangeLog-1.2.X](docs/changelogs/ChangeLog-1.2.X.md)
### [ChangeLog-1.1.X](docs/changelogs/ChangeLog-1.1.X.md)
### [ChangeLog-1.0.X](docs/changelogs/ChangeLog-1.0.X.md)
