/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.visualizer.psi;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/visualizer/testData/uncommonCases/testFiles")
@TestDataPath("$PROJECT_ROOT")
public class PsiVisualizerForUncommonCasesGenerated extends AbstractPsiVisualizerTest {
    @Test
    public void testAllFilesPresentInTestFiles() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/visualizer/testData/uncommonCases/testFiles"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("dataClass.kt")
    public void testDataClass() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/dataClass.kt");
    }

    @Test
    @TestMetadata("delegation.kt")
    public void testDelegation() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/delegation.kt");
    }

    @Test
    @TestMetadata("innerWith.kt")
    public void testInnerWith() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/innerWith.kt");
    }

    @Test
    @TestMetadata("lists.kt")
    public void testLists() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/lists.kt");
    }

    @Test
    @TestMetadata("overrideEquals.kt")
    public void testOverrideEquals() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/overrideEquals.kt");
    }

    @Test
    @TestMetadata("properties.kt")
    public void testProperties() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/properties.kt");
    }

    @Test
    @TestMetadata("receiver.kt")
    public void testReceiver() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/receiver.kt");
    }

    @Test
    @TestMetadata("superTypes.kt")
    public void testSuperTypes() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/superTypes.kt");
    }

    @Test
    @TestMetadata("variance.kt")
    public void testVariance() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/variance.kt");
    }

    @Test
    @TestMetadata("where.kt")
    public void testWhere() throws Exception {
        runTest("compiler/visualizer/testData/uncommonCases/testFiles/where.kt");
    }
}
