/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.spec.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/tests-spec/testData/codegen/box")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BlackBoxCodegenTestSpecGenerated extends AbstractBlackBoxCodegenTestSpec {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
    }

    public void testAllFilesPresentInBox() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box"), Pattern.compile("^(.+)\\.kt$"), null, true, "helpers", "templates", "linked/exceptions", "linked/operator-call", "linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver", "linked/overloadable-operators");
    }

    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Linked extends AbstractBlackBoxCodegenTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInLinked() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked"), Pattern.compile("^(.+)\\.kt$"), null, true, "exceptions", "operator-call", "overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver", "overloadable-operators");
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Expressions extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInExpressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/additive-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Additive_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInAdditive_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/additive-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/additive-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/additive-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/additive-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/additive-expression/p-2/pos/1.1.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/additive-expression/p-2/pos/2.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/additive-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Built_in_types_and_their_semantics extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInBuilt_in_types_and_their_semantics() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Kotlin_nothing_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInKotlin_nothing_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.10.kt")
                            public void test1_10() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.10.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.5.kt");
                            }

                            @TestMetadata("1.6.kt")
                            public void test1_6() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.6.kt");
                            }

                            @TestMetadata("1.7.kt")
                            public void test1_7() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.7.kt");
                            }

                            @TestMetadata("1.8.kt")
                            public void test1_8() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.8.kt");
                            }

                            @TestMetadata("1.9.kt")
                            public void test1_9() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.9.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.unit")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Kotlin_unit extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInKotlin_unit() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.unit"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/cast-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Cast_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInCast_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/cast-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/cast-expression/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/cast-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/cast-expression/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/cast-expression/p-1/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/cast-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Comparison_expressions extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInComparison_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions/p-1/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions/p-1/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions/p-1/pos/2.3.kt");
                        }

                        @TestMetadata("2.4.kt")
                        public void test2_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions/p-1/pos/2.4.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/comparison-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Conditional_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInConditional_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos/2.3.kt");
                        }

                        @TestMetadata("2.4.kt")
                        public void test2_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos/2.4.kt");
                        }

                        @TestMetadata("2.5.kt")
                        public void test2_5() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos/2.5.kt");
                        }

                        @TestMetadata("2.6.kt")
                        public void test2_6() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos/2.6.kt");
                        }

                        @TestMetadata("2.7.kt")
                        public void test2_7() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos/2.7.kt");
                        }

                        @TestMetadata("2.8.kt")
                        public void test2_8() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos/2.8.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-2/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-6")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_6 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_6() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-6/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-6/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/conditional-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Constant_literals extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInConstant_literals() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Boolean_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInBoolean_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.10.kt")
                            public void test2_10() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.10.kt");
                            }

                            @TestMetadata("2.11.kt")
                            public void test2_11() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.11.kt");
                            }

                            @TestMetadata("2.12.kt")
                            public void test2_12() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.12.kt");
                            }

                            @TestMetadata("2.13.kt")
                            public void test2_13() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.13.kt");
                            }

                            @TestMetadata("2.14.kt")
                            public void test2_14() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.14.kt");
                            }

                            @TestMetadata("2.15.kt")
                            public void test2_15() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.15.kt");
                            }

                            @TestMetadata("2.16.kt")
                            public void test2_16() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.16.kt");
                            }

                            @TestMetadata("2.17.kt")
                            public void test2_17() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.17.kt");
                            }

                            @TestMetadata("2.18.kt")
                            public void test2_18() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.18.kt");
                            }

                            @TestMetadata("2.19.kt")
                            public void test2_19() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.19.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.20.kt")
                            public void test2_20() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.20.kt");
                            }

                            @TestMetadata("2.21.kt")
                            public void test2_21() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.21.kt");
                            }

                            @TestMetadata("2.22.kt")
                            public void test2_22() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.22.kt");
                            }

                            @TestMetadata("2.23.kt")
                            public void test2_23() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.23.kt");
                            }

                            @TestMetadata("2.24.kt")
                            public void test2_24() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.24.kt");
                            }

                            @TestMetadata("2.25.kt")
                            public void test2_25() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.25.kt");
                            }

                            @TestMetadata("2.26.kt")
                            public void test2_26() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.26.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.5.kt");
                            }

                            @TestMetadata("2.6.kt")
                            public void test2_6() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.6.kt");
                            }

                            @TestMetadata("2.7.kt")
                            public void test2_7() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.7.kt");
                            }

                            @TestMetadata("2.8.kt")
                            public void test2_8() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.8.kt");
                            }

                            @TestMetadata("2.9.kt")
                            public void test2_9() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.9.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/boolean-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/character-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Character_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInCharacter_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/character-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/character-literals/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/character-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/character-literals/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/character-literals/p-4/pos/2.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/character-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Integer_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInInteger_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/binary-integer-literals")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Binary_integer_literals extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInBinary_integer_literals() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/binary-integer-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/pos/1.1.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/pos/2.1.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                                }
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/decimal-integer-literals")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Decimal_integer_literals extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInDecimal_integer_literals() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/decimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/pos/1.1.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/pos/2.1.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                                }
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Hexadecimal_integer_literals extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInHexadecimal_integer_literals() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/1.1.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/2.1.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                                }
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Real_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInReal_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-1/pos/3.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-2/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-2/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos/1.4.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos/2.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4/pos/1.5.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/real-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class The_types_for_integer_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInThe_types_for_integer_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/1.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/elvis-operator-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Elvis_operator_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInElvis_operator_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/elvis-operator-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/elvis-operator-expression/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/elvis-operator-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/elvis-operator-expression/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/elvis-operator-expression/p-1/pos/2.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/elvis-operator-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Equality_expressions extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInEquality_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Reference_equality_expressions extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInReference_equality_expressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1/pos/2.5.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1/pos/3.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-3"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-3/pos/1.1.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-3/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-3/pos/2.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/reference-equality-expressions/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Value_equality_expressions extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInValue_equality_expressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/1.5.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos/2.5.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/equality-expressions/value-equality-expressions/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Indexing_expressions extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInIndexing_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_3 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_3() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3/pos/1.5.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/indexing-expressions/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Jump_expressions extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInJump_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Break_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInBreak_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression/p-3/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression/p-3/pos/1.2.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression/p-3/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression/p-3/pos/2.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/break-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Continue_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInContinue_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression/p-3/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression/p-3/pos/1.2.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression/p-3/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression/p-3/pos/2.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/continue-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Return_expressions extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInReturn_expressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-1/pos/1.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-3"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-3/pos/2.1.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-3/pos/3.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/jump-expressions/return-expressions/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Logical_conjunction_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInLogical_conjunction_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression/p-1/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression/p-1/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression/p-1/pos/2.3.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-conjunction-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Logical_disjunction_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInLogical_disjunction_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression/p-1/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression/p-1/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression/p-1/pos/2.3.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/logical-disjunction-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Multiplicative_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInMultiplicative_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression/p-2/pos/1.1.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression/p-2/pos/2.1.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression/p-2/pos/3.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/multiplicative-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Not_null_assertion_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInNot_null_assertion_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression/p-2/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression/p-2/pos/2.2.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression/p-2/pos/3.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/not-null-assertion-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Postfix_operator_expressions extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInPostfix_operator_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Postfix_decrement_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInPostfix_decrement_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-1/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-4/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-5/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-6")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_6 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_6() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-6/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-6/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-6/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-decrement-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Postfix_increment_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInPostfix_increment_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-1/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-4/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-5/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-6")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_6 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_6() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-6/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-6/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-6/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/postfix-operator-expressions/postfix-increment-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Prefix_expressions extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInPrefix_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/logical-not-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Logical_not_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInLogical_not_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/logical-not-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/logical-not-expression/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/logical-not-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/logical-not-expression/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/logical-not-expression/p-2/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/logical-not-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Prefix_decrement_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInPrefix_decrement_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-1/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-6")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_6 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_6() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-6/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-6/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-6/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-decrement-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Prefix_increment_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInPrefix_increment_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-1/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-6")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_6 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_6() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-6/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-6/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-6/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/prefix-increment-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-minus-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Unary_minus_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInUnary_minus_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-minus-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-minus-expression/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-minus-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-minus-expression/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-minus-expression/p-2/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-minus-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-plus-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Unary_plus_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInUnary_plus_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-plus-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-plus-expression/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-plus-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-plus-expression/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-plus-expression/p-2/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/prefix-expressions/unary-plus-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/range-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Range_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInRange_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/range-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/range-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/range-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/range-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/range-expression/p-2/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/range-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Try_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInTry_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/neg/2.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/pos/2.3.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/pos/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/pos/3.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5/neg/3.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5/pos/1.1.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5/pos/2.1.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5/pos/3.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-6")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_6 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_6() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-6/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-6/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-7")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_7 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_7() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-7"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-7/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-7/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/try-expression/p-7/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_checking_and_containment_checking_expressions extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInType_checking_and_containment_checking_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Containment_checking_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInContainment_checking_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-2/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-2/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-4/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Type_checking_expression extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInType_checking_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-1/pos/3.1.kt");
                            }

                            @TestMetadata("3.2.kt")
                            public void test3_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-1/pos/3.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-2/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-2/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-5/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class When_expression extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInWhen_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_4() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/neg/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/neg/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/neg/1.4.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/pos/1.4.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-5/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-5/neg/2.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-5/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/expressions/when-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Overload_resolution extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInOverload_resolution() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution"), Pattern.compile("^(.+)\\.kt$"), null, true, "building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver");
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Building_the_overload_candidate_set_ocs extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInBuilding_the_overload_candidate_set_ocs() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs"), Pattern.compile("^(.+)\\.kt$"), null, true, "call-with-an-explicit-receiver");
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Infix_function_call extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInInfix_function_call() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/2.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Operator_call extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInOperator_call() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.5.kt");
                            }

                            @TestMetadata("2.6.kt")
                            public void test2_6() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.6.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.10.kt")
                            public void test2_10() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.10.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.5.kt");
                            }

                            @TestMetadata("2.6.kt")
                            public void test2_6() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.6.kt");
                            }

                            @TestMetadata("2.7.kt")
                            public void test2_7() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.7.kt");
                            }

                            @TestMetadata("2.8.kt")
                            public void test2_8() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.8.kt");
                            }

                            @TestMetadata("2.9.kt")
                            public void test2_9() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.9.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.1.kt");
                            }

                            @TestMetadata("3.10.kt")
                            public void test3_10() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.10.kt");
                            }

                            @TestMetadata("3.2.kt")
                            public void test3_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.2.kt");
                            }

                            @TestMetadata("3.3.kt")
                            public void test3_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.3.kt");
                            }

                            @TestMetadata("3.4.kt")
                            public void test3_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.4.kt");
                            }

                            @TestMetadata("3.5.kt")
                            public void test3_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.5.kt");
                            }

                            @TestMetadata("3.6.kt")
                            public void test3_6() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.6.kt");
                            }

                            @TestMetadata("3.7.kt")
                            public void test3_7() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.7.kt");
                            }

                            @TestMetadata("3.8.kt")
                            public void test3_8() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.8.kt");
                            }

                            @TestMetadata("3.9.kt")
                            public void test3_9() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.9.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Callables_and_invoke_convention extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInCallables_and_invoke_convention() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.1.kt");
                        }

                        @TestMetadata("1.10.kt")
                        public void test1_10() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.10.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.2.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.5.kt");
                        }

                        @TestMetadata("1.6.kt")
                        public void test1_6() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.6.kt");
                        }

                        @TestMetadata("1.7.kt")
                        public void test1_7() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.7.kt");
                        }

                        @TestMetadata("1.8.kt")
                        public void test1_8() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.8.kt");
                        }

                        @TestMetadata("1.9.kt")
                        public void test1_9() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos/1.9.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/callables-and-invoke-convention/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Choosing_the_most_specific_candidate_from_the_overload_candidate_set extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInChoosing_the_most_specific_candidate_from_the_overload_candidate_set() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Algorithm_of_msc_selection extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInAlgorithm_of_msc_selection() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Receivers extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInReceivers() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_6 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_6() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6/pos/2.2.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6/pos/3.1.kt");
                        }

                        @TestMetadata("4.2.kt")
                        public void test4_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6/pos/4.2.kt");
                        }

                        @TestMetadata("5.1.kt")
                        public void test5_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6/pos/5.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/overload-resolution/receivers/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Statements extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInStatements() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements"), Pattern.compile("^(.+)\\.kt$"), null, true);
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Assignments extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInAssignments() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Operator_assignments extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInOperator_assignments() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("10.1.kt")
                            public void test10_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/10.1.kt");
                            }

                            @TestMetadata("10.2.kt")
                            public void test10_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/10.2.kt");
                            }

                            @TestMetadata("13.1.kt")
                            public void test13_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/13.1.kt");
                            }

                            @TestMetadata("13.2.kt")
                            public void test13_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/13.2.kt");
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/1.2.kt");
                            }

                            @TestMetadata("4.1.kt")
                            public void test4_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/4.1.kt");
                            }

                            @TestMetadata("4.2.kt")
                            public void test4_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/4.2.kt");
                            }

                            @TestMetadata("7.1.kt")
                            public void test7_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/7.1.kt");
                            }

                            @TestMetadata("7.2.kt")
                            public void test7_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg/7.2.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("10.1.kt")
                            public void test10_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/10.1.kt");
                            }

                            @TestMetadata("10.2.kt")
                            public void test10_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/10.2.kt");
                            }

                            @TestMetadata("13.1.kt")
                            public void test13_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/13.1.kt");
                            }

                            @TestMetadata("13.2.kt")
                            public void test13_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/13.2.kt");
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/1.2.kt");
                            }

                            @TestMetadata("4.1.kt")
                            public void test4_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/4.1.kt");
                            }

                            @TestMetadata("4.2.kt")
                            public void test4_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/4.2.kt");
                            }

                            @TestMetadata("7.1.kt")
                            public void test7_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/7.1.kt");
                            }

                            @TestMetadata("7.2.kt")
                            public void test7_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos/7.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/operator-assignments/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Simple_assignments extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInSimple_assignments() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/1.5.kt");
                            }

                            @TestMetadata("1.6.kt")
                            public void test1_6() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/1.6.kt");
                            }

                            @TestMetadata("1.7.kt")
                            public void test1_7() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/1.7.kt");
                            }

                            @TestMetadata("1.8.kt")
                            public void test1_8() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/1.8.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos/2.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-6")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_6 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_6() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-6"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-6/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-6/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/assignments/simple-assignments/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Loop_statements extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInLoop_statements() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/do-while-loop-statement")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Do_while_loop_statement extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInDo_while_loop_statement() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/do-while-loop-statement"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/do-while-loop-statement/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/do-while-loop-statement/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/do-while-loop-statement/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/do-while-loop-statement/p-1/pos/3.1.kt");
                            }

                            @TestMetadata("3.2.kt")
                            public void test3_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/do-while-loop-statement/p-1/pos/3.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/do-while-loop-statement/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/while-loop-statement")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class While_loop_statement extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInWhile_loop_statement() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/while-loop-statement"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/while-loop-statement/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/while-loop-statement/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/while-loop-statement/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/while-loop-statement/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/while-loop-statement/p-1/pos/2.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/statements/loop-statements/while-loop-statement/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Type_system extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInType_system() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system"), Pattern.compile("^(.+)\\.kt$"), null, true);
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system/introduction-1")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Introduction_1 extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInIntroduction_1() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system/introduction-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system/introduction-1/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system/introduction-1/p-5"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system/introduction-1/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/type-system/introduction-1/p-5/pos/2.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system/introduction-1/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_kinds extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInType_kinds() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Built_in_types extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInBuilt_in_types() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types/kotlin.nothing")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Kotlin_nothing extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInKotlin_nothing() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types/kotlin.nothing"), Pattern.compile("^(.+)\\.kt$"), null, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1"), Pattern.compile("^(.+)\\.kt$"), null, true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos/1.1.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos/1.2.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NotLinked extends AbstractBlackBoxCodegenTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInNotLinked() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/flexibility")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Flexibility extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInFlexibility() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/flexibility"), Pattern.compile("^(.+)\\.kt$"), null, true);
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/flexibility/neg")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                @TestMetadata("1.kt")
                public void test1() throws Exception {
                    runTest("compiler/tests-spec/testData/codegen/box/notLinked/flexibility/neg/1.kt");
                }

                @TestMetadata("2.kt")
                public void test2() throws Exception {
                    runTest("compiler/tests-spec/testData/codegen/box/notLinked/flexibility/neg/2.kt");
                }

                public void testAllFilesPresentInNeg() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/flexibility/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/objects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Objects extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInObjects() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/objects"), Pattern.compile("^(.+)\\.kt$"), null, true);
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inheritance extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInInheritance() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance"), Pattern.compile("^(.+)\\.kt$"), null, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/1.kt");
                    }

                    @TestMetadata("10.kt")
                    public void test10() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/10.kt");
                    }

                    @TestMetadata("11.kt")
                    public void test11() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/11.kt");
                    }

                    @TestMetadata("12.kt")
                    public void test12() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/12.kt");
                    }

                    @TestMetadata("2.kt")
                    public void test2() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/2.kt");
                    }

                    @TestMetadata("3.kt")
                    public void test3() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/3.kt");
                    }

                    @TestMetadata("4.kt")
                    public void test4() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/4.kt");
                    }

                    @TestMetadata("5.kt")
                    public void test5() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/5.kt");
                    }

                    @TestMetadata("6.kt")
                    public void test6() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/6.kt");
                    }

                    @TestMetadata("7.kt")
                    public void test7() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/7.kt");
                    }

                    @TestMetadata("8.kt")
                    public void test8() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/8.kt");
                    }

                    @TestMetadata("9.kt")
                    public void test9() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/9.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/pos/1.kt");
                    }

                    @TestMetadata("2.kt")
                    public void test2() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/pos/2.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/pos"), Pattern.compile("^(.+)\\.kt$"), null, true);
                    }
                }
            }
        }
    }
}
