/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.spec.checkers;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/tests-spec/testData/diagnostics")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class DiagnosticsTestSpecGenerated extends AbstractDiagnosticsTestSpec {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
    }

    public void testAllFilesPresentInDiagnostics() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "helpers", "linked/annotations", "linked/built-in-types-and-their-semantics", "linked/control--and-data-flow-analysis.control-flow-graph.expressions-1.conditional-expressions", "linked/control--and-data-flow-analysis/performing-analysis-on-the-control-flow-graph", "linked/declarations/classifier-declaration/class-declaration/nested-and-inner-classifiers", "linked/declarations/classifier-declaration/classifier-initialization", "linked/declarations/classifier-declaration/data-class-declaration", "linked/declarations/function-declaration", "linked/declarations/property-declaration/property-initialization", "linked/declarations/type-alias", "linked/expressions/call-and-property-access-expressions", "linked/expressions/function-literals", "linked/inheritance", "linked/overload-resolution/c-level-partition", "linked/overload-resolution/determining-function-applicability-for-a-specific-call/rationale", "linked/overloadable-operators", "linked/statements/assignments/simple-assignments", "linked/type-inference/local-type-inference", "linked/type-inference/smart-casts/smart-cast-types", "linked/type-system/subtyping/subtyping-for-nullable-types", "linked/type-system/type-kinds/type-parameters");
    }

    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Linked extends AbstractDiagnosticsTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInLinked() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "annotations", "built-in-types-and-their-semantics", "control--and-data-flow-analysis.control-flow-graph.expressions-1.conditional-expressions", "control--and-data-flow-analysis/performing-analysis-on-the-control-flow-graph", "declarations/classifier-declaration/class-declaration/nested-and-inner-classifiers", "declarations/classifier-declaration/classifier-initialization", "declarations/classifier-declaration/data-class-declaration", "declarations/function-declaration", "declarations/property-declaration/property-initialization", "declarations/type-alias", "expressions/call-and-property-access-expressions", "expressions/function-literals", "inheritance", "overload-resolution/c-level-partition", "overload-resolution/determining-function-applicability-for-a-specific-call/rationale", "overloadable-operators", "statements/assignments/simple-assignments", "type-inference/local-type-inference", "type-inference/smart-casts/smart-cast-types", "type-system/subtyping/subtyping-for-nullable-types", "type-system/type-kinds/type-parameters");
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Control__and_data_flow_analysis extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInControl__and_data_flow_analysis() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "performing-analysis-on-the-control-flow-graph");
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Control_flow_graph extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInControl_flow_graph() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Expressions_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInExpressions_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Conditional_expressions extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInConditional_expressions() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/1.1.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/1.2.kt");
                                }

                                @TestMetadata("1.3.kt")
                                public void test1_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/1.3.kt");
                                }

                                @TestMetadata("1.4.kt")
                                public void test1_4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/1.4.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg/2.1.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos/1.1.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos/1.2.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos/2.1.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/control--and-data-flow-analysis/control-flow-graph/expressions-1/conditional-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Declarations extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInDeclarations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "classifier-declaration/class-declaration/nested-and-inner-classifiers", "classifier-declaration/classifier-initialization", "classifier-declaration/data-class-declaration", "function-declaration", "property-declaration/property-initialization", "type-alias");
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Classifier_declaration extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInClassifier_declaration() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "class-declaration/nested-and-inner-classifiers", "classifier-initialization", "data-class-declaration");
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Class_declaration extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInClass_declaration() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "nested-and-inner-classifiers");
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Abstract_classes extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInAbstract_classes() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/neg/1.1.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/neg/2.1.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/pos/2.1.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_2 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_2() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.1.kt");
                                }

                                @TestMetadata("1.10.kt")
                                public void test1_10() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.10.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.2.kt");
                                }

                                @TestMetadata("1.3.kt")
                                public void test1_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.3.kt");
                                }

                                @TestMetadata("1.4.kt")
                                public void test1_4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.4.kt");
                                }

                                @TestMetadata("1.5.kt")
                                public void test1_5() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.5.kt");
                                }

                                @TestMetadata("1.6.kt")
                                public void test1_6() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.6.kt");
                                }

                                @TestMetadata("1.7.kt")
                                public void test1_7() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.7.kt");
                                }

                                @TestMetadata("1.8.kt")
                                public void test1_8() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.8.kt");
                                }

                                @TestMetadata("1.9.kt")
                                public void test1_9() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg/1.9.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos/1.1.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos/1.2.kt");
                                }

                                @TestMetadata("1.3.kt")
                                public void test1_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos/1.3.kt");
                                }

                                @TestMetadata("1.4.kt")
                                public void test1_4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos/1.4.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/abstract-classes/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Constructor_declaration extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInConstructor_declaration() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_4 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_4() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4/pos/1.1.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_5 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_5() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg/1.1.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg/1.2.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg/2.1.kt");
                                }

                                @TestMetadata("3.1.kt")
                                public void test3_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg/3.1.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.1.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.2.kt");
                                }

                                @TestMetadata("1.3.kt")
                                public void test1_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.3.kt");
                                }

                                @TestMetadata("1.4.kt")
                                public void test1_4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.4.kt");
                                }

                                @TestMetadata("1.5.kt")
                                public void test1_5() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/1.5.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/2.1.kt");
                                }

                                @TestMetadata("2.2.kt")
                                public void test2_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/2.2.kt");
                                }

                                @TestMetadata("2.3.kt")
                                public void test2_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/2.3.kt");
                                }

                                @TestMetadata("2.4.kt")
                                public void test2_4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/2.4.kt");
                                }

                                @TestMetadata("3.1.kt")
                                public void test3_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/3.1.kt");
                                }

                                @TestMetadata("3.2.kt")
                                public void test3_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/3.2.kt");
                                }

                                @TestMetadata("3.3.kt")
                                public void test3_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/3.3.kt");
                                }

                                @TestMetadata("3.4.kt")
                                public void test3_4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos/3.4.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/classifier-declaration/class-declaration/constructor-declaration/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Property_declaration extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInProperty_declaration() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "property-initialization");
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Local_property_declaration extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInLocal_property_declaration() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/declarations/property-declaration/local-property-declaration/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Expressions extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInExpressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "call-and-property-access-expressions", "function-literals");
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Additive_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInAdditive_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_4 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_4() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/additive-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Built_in_types_and_their_semantics extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInBuilt_in_types_and_their_semantics() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Kotlin_nothing_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInKotlin_nothing_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.nothing-1/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Kotlin_unit extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInKotlin_unit() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/built-in-types-and-their-semantics/kotlin.unit/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Comparison_expressions extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInComparison_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1/neg/2.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_4 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_4() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4/neg/1.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/comparison-expressions/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Conditional_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInConditional_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_6 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_6() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/neg/1.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/conditional-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Constant_literals extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInConstant_literals() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Boolean_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInBoolean_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/neg/2.1.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/neg/3.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos/3.1.kt");
                            }

                            @TestMetadata("3.2.kt")
                            public void test3_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos/3.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/boolean-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Character_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInCharacter_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/character-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Integer_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInInteger_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Binary_integer_literals extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInBinary_integer_literals() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg/1.1.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.1.kt");
                                }

                                @TestMetadata("2.2.kt")
                                public void test2_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.2.kt");
                                }

                                @TestMetadata("2.3.kt")
                                public void test2_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.3.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/binary-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Decimal_integer_literals extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInDecimal_integer_literals() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/2.1.kt");
                                }

                                @TestMetadata("2.2.kt")
                                public void test2_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/2.2.kt");
                                }

                                @TestMetadata("2.3.kt")
                                public void test2_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/2.3.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/decimal-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Hexadecimal_integer_literals extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInHexadecimal_integer_literals() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/1.1.kt");
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.1.kt");
                                }

                                @TestMetadata("2.2.kt")
                                public void test2_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.2.kt");
                                }

                                @TestMetadata("2.3.kt")
                                public void test2_3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.3.kt");
                                }

                                @TestMetadata("2.4.kt")
                                public void test2_4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.4.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Real_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInReal_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/neg/3.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos/3.1.kt");
                            }

                            @TestMetadata("3.2.kt")
                            public void test3_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos/3.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg/1.4.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg/1.2.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg/2.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/1.5.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos/2.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/1.2.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg/2.3.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos/1.5.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos/1.5.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/real-literals/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class The_types_for_integer_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInThe_types_for_integer_literals() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/1.3.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg/2.5.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos/2.5.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/constant-literals/the-types-for-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Elvis_operator_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInElvis_operator_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_3 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_3() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/elvis-operator-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Equality_expressions extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInEquality_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Value_equality_expressions extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInValue_equality_expressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/equality-expressions/value-equality-expressions/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Jump_expressions extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInJump_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Break_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInBreak_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/break-expression/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Continue_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInContinue_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/continue-expression/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Return_expressions extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInReturn_expressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/jump-expressions/return-expressions/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Logical_conjunction_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInLogical_conjunction_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/neg/1.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-conjunction-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Logical_disjunction_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInLogical_disjunction_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/neg/1.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/logical-disjunction-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Multiplicative_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInMultiplicative_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/multiplicative-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Not_null_assertion_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInNot_null_assertion_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_3 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_3() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/not-null-assertion-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Prefix_expressions extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInPrefix_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Logical_not_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInLogical_not_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/logical-not-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Prefix_decrement_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInPrefix_decrement_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/neg/2.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-decrement-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Prefix_increment_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInPrefix_increment_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/neg/2.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/prefix-increment-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Unary_minus_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInUnary_minus_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-minus-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Unary_plus_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInUnary_plus_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/prefix-expressions/unary-plus-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Range_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInRange_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_4 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_4() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/range-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Try_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInTry_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg/1.1.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg/3.1.kt");
                        }

                        @TestMetadata("4.1.kt")
                        public void test4_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg/4.1.kt");
                        }

                        @TestMetadata("5.1.kt")
                        public void test5_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg/5.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/1.1.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/3.2.kt");
                        }

                        @TestMetadata("4.1.kt")
                        public void test4_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/4.1.kt");
                        }

                        @TestMetadata("4.2.kt")
                        public void test4_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos/4.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2/pos/2.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5/pos/1.1.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5/pos/2.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_8 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_8() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/neg/1.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/try-expression/p-8/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_checking_and_containment_checking_expressions extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInType_checking_and_containment_checking_expressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Containment_checking_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInContainment_checking_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/pos/2.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/containment-checking-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Type_checking_expression extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInType_checking_expression() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/type-checking-and-containment-checking-expressions/type-checking-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class When_expression extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInWhen_expression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Exhaustive_when_expressions extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInExhaustive_when_expressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("11.1.kt")
                            public void test11_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/11.1.kt");
                            }

                            @TestMetadata("11.2.kt")
                            public void test11_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/11.2.kt");
                            }

                            @TestMetadata("11.3.kt")
                            public void test11_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/11.3.kt");
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/1.2.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/3.1.kt");
                            }

                            @TestMetadata("9.1.kt")
                            public void test9_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg/9.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("10.1.kt")
                            public void test10_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/10.1.kt");
                            }

                            @TestMetadata("11.1.kt")
                            public void test11_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/11.1.kt");
                            }

                            @TestMetadata("11.2.kt")
                            public void test11_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/11.2.kt");
                            }

                            @TestMetadata("11.3.kt")
                            public void test11_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/11.3.kt");
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/1.3.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/3.1.kt");
                            }

                            @TestMetadata("7.1.kt")
                            public void test7_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos/7.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/exhaustive-when-expressions/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1/pos/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1/pos/3.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/neg/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/neg/2.2.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/1.2.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos/2.3.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_3 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_3() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3/neg/2.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_4 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_4() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/neg/1.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/pos/1.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/pos/1.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_6 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_6() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/1.2.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/3.2.kt");
                        }

                        @TestMetadata("7.1.kt")
                        public void test7_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/7.1.kt");
                        }

                        @TestMetadata("7.2.kt")
                        public void test7_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg/7.2.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/1.4.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/3.2.kt");
                        }

                        @TestMetadata("5.1.kt")
                        public void test5_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/5.1.kt");
                        }

                        @TestMetadata("5.2.kt")
                        public void test5_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/5.2.kt");
                        }

                        @TestMetadata("6.1.kt")
                        public void test6_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/6.1.kt");
                        }

                        @TestMetadata("7.1.kt")
                        public void test7_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/7.1.kt");
                        }

                        @TestMetadata("7.2.kt")
                        public void test7_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos/7.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/expressions/when-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Overload_resolution extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInOverload_resolution() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "c-level-partition", "determining-function-applicability-for-a-specific-call/rationale");
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Building_the_overload_candidate_set_ocs extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInBuilding_the_overload_candidate_set_ocs() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Call_with_an_explicit_receiver extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInCall_with_an_explicit_receiver() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Call_with_an_explicit_type_receiver extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInCall_with_an_explicit_type_receiver() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_3 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_3() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3/pos/2.1.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/call-with-an-explicit-type-receiver/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_6 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_6() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/1.5.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/2.4.kt");
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/3.1.kt");
                            }

                            @TestMetadata("3.2.kt")
                            public void test3_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/3.2.kt");
                            }

                            @TestMetadata("4.1.kt")
                            public void test4_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/4.1.kt");
                            }

                            @TestMetadata("4.2.kt")
                            public void test4_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/4.2.kt");
                            }

                            @TestMetadata("5.1.kt")
                            public void test5_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/5.1.kt");
                            }

                            @TestMetadata("5.2.kt")
                            public void test5_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/5.2.kt");
                            }

                            @TestMetadata("6.1.kt")
                            public void test6_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos/6.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-an-explicit-receiver/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Call_with_named_parameters extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInCall_with_named_parameters() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.10.kt")
                            public void test2_10() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.10.kt");
                            }

                            @TestMetadata("2.11.kt")
                            public void test2_11() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.11.kt");
                            }

                            @TestMetadata("2.12.kt")
                            public void test2_12() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.12.kt");
                            }

                            @TestMetadata("2.13.kt")
                            public void test2_13() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.13.kt");
                            }

                            @TestMetadata("2.14.kt")
                            public void test2_14() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.14.kt");
                            }

                            @TestMetadata("2.15.kt")
                            public void test2_15() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.15.kt");
                            }

                            @TestMetadata("2.16.kt")
                            public void test2_16() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.16.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.5.kt");
                            }

                            @TestMetadata("2.6.kt")
                            public void test2_6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.6.kt");
                            }

                            @TestMetadata("2.7.kt")
                            public void test2_7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.7.kt");
                            }

                            @TestMetadata("2.8.kt")
                            public void test2_8() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.8.kt");
                            }

                            @TestMetadata("2.9.kt")
                            public void test2_9() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos/2.9.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-named-parameters/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Call_with_specified_type_parameters extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInCall_with_specified_type_parameters() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-specified-type-parameters/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Call_with_trailing_lambda_expressions extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInCall_with_trailing_lambda_expressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.10.kt")
                            public void test2_10() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.10.kt");
                            }

                            @TestMetadata("2.11.kt")
                            public void test2_11() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.11.kt");
                            }

                            @TestMetadata("2.12.kt")
                            public void test2_12() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.12.kt");
                            }

                            @TestMetadata("2.13.kt")
                            public void test2_13() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.13.kt");
                            }

                            @TestMetadata("2.14.kt")
                            public void test2_14() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.14.kt");
                            }

                            @TestMetadata("2.15.kt")
                            public void test2_15() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.15.kt");
                            }

                            @TestMetadata("2.16.kt")
                            public void test2_16() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.16.kt");
                            }

                            @TestMetadata("2.17.kt")
                            public void test2_17() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.17.kt");
                            }

                            @TestMetadata("2.18.kt")
                            public void test2_18() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.18.kt");
                            }

                            @TestMetadata("2.19.kt")
                            public void test2_19() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.19.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.20.kt")
                            public void test2_20() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.20.kt");
                            }

                            @TestMetadata("2.21.kt")
                            public void test2_21() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.21.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.5.kt");
                            }

                            @TestMetadata("2.6.kt")
                            public void test2_6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.6.kt");
                            }

                            @TestMetadata("2.7.kt")
                            public void test2_7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.7.kt");
                            }

                            @TestMetadata("2.8.kt")
                            public void test2_8() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.8.kt");
                            }

                            @TestMetadata("2.9.kt")
                            public void test2_9() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos/2.9.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-with-trailing-lambda-expressions/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Call_without_an_explicit_receiver extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInCall_without_an_explicit_receiver() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/2.5.kt");
                            }

                            @TestMetadata("4.1.kt")
                            public void test4_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/4.1.kt");
                            }

                            @TestMetadata("4.2.kt")
                            public void test4_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/4.2.kt");
                            }

                            @TestMetadata("6.1.kt")
                            public void test6_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/6.1.kt");
                            }

                            @TestMetadata("6.4.kt")
                            public void test6_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg/6.4.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/2.5.kt");
                            }

                            @TestMetadata("4.1.kt")
                            public void test4_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.1.kt");
                            }

                            @TestMetadata("4.2.kt")
                            public void test4_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.2.kt");
                            }

                            @TestMetadata("4.3.kt")
                            public void test4_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.3.kt");
                            }

                            @TestMetadata("4.4.kt")
                            public void test4_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.4.kt");
                            }

                            @TestMetadata("4.5.kt")
                            public void test4_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.5.kt");
                            }

                            @TestMetadata("4.6.kt")
                            public void test4_6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/4.6.kt");
                            }

                            @TestMetadata("5.1.kt")
                            public void test5_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/5.1.kt");
                            }

                            @TestMetadata("6.1.kt")
                            public void test6_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/6.1.kt");
                            }

                            @TestMetadata("6.2.kt")
                            public void test6_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/6.2.kt");
                            }

                            @TestMetadata("6.3.kt")
                            public void test6_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/6.3.kt");
                            }

                            @TestMetadata("7.1.kt")
                            public void test7_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos/7.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/call-without-an-explicit-receiver/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Infix_function_call extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInInfix_function_call() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/1.4.kt");
                            }

                            @TestMetadata("4.5.kt")
                            public void test4_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg/4.5.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("4.1.kt")
                            public void test4_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.1.kt");
                            }

                            @TestMetadata("4.2.kt")
                            public void test4_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.2.kt");
                            }

                            @TestMetadata("4.3.kt")
                            public void test4_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.3.kt");
                            }

                            @TestMetadata("4.4.kt")
                            public void test4_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.4.kt");
                            }

                            @TestMetadata("4.5.kt")
                            public void test4_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos/4.5.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Operator_call extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInOperator_call() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.2.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.5.kt");
                            }

                            @TestMetadata("2.6.kt")
                            public void test2_6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.6.kt");
                            }

                            @TestMetadata("2.7.kt")
                            public void test2_7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.7.kt");
                            }

                            @TestMetadata("2.8.kt")
                            public void test2_8() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.8.kt");
                            }

                            @TestMetadata("2.9.kt")
                            public void test2_9() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg/2.9.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos/2.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("3.1.kt")
                            public void test3_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.1.kt");
                            }

                            @TestMetadata("3.2.kt")
                            public void test3_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.2.kt");
                            }

                            @TestMetadata("3.3.kt")
                            public void test3_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.3.kt");
                            }

                            @TestMetadata("3.4.kt")
                            public void test3_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.4.kt");
                            }

                            @TestMetadata("3.5.kt")
                            public void test3_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.5.kt");
                            }

                            @TestMetadata("3.6.kt")
                            public void test3_6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos/3.6.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/building-the-overload-candidate-set-ocs/operator-call/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Callables_and_invoke_convention extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInCallables_and_invoke_convention() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("10.1.kt")
                        public void test10_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos/10.1.kt");
                        }

                        @TestMetadata("8.1.kt")
                        public void test8_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos/8.1.kt");
                        }

                        @TestMetadata("9.1.kt")
                        public void test9_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos/9.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/callables-and-invoke-convention/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Choosing_the_most_specific_candidate_from_the_overload_candidate_set extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInChoosing_the_most_specific_candidate_from_the_overload_candidate_set() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Algorithm_of_msc_selection extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInAlgorithm_of_msc_selection() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_11 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_11() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/1.2.kt");
                            }

                            @TestMetadata("4.1.kt")
                            public void test4_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.1.kt");
                            }

                            @TestMetadata("4.2.kt")
                            public void test4_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.2.kt");
                            }

                            @TestMetadata("4.3.kt")
                            public void test4_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.3.kt");
                            }

                            @TestMetadata("4.4.kt")
                            public void test4_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.4.kt");
                            }

                            @TestMetadata("4.5.kt")
                            public void test4_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/4.5.kt");
                            }

                            @TestMetadata("5.1.kt")
                            public void test5_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos/5.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-11/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_12 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_12() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.5.kt");
                            }

                            @TestMetadata("2.6.kt")
                            public void test2_6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.6.kt");
                            }

                            @TestMetadata("2.7.kt")
                            public void test2_7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos/2.7.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-12/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_14 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_14() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.5.kt");
                            }

                            @TestMetadata("1.6.kt")
                            public void test1_6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.6.kt");
                            }

                            @TestMetadata("1.7.kt")
                            public void test1_7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg/1.7.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-14/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_17 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_17() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17/neg/2.2.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-17/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos/1.4.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_9 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_9() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg/2.3.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/algorithm-of-msc-selection/p-9/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Rationale_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInRationale_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/choosing-the-most-specific-candidate-from-the-overload-candidate-set/rationale-1/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Determining_function_applicability_for_a_specific_call extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInDetermining_function_applicability_for_a_specific_call() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "rationale");
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Description extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInDescription() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2/neg/2.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/determining-function-applicability-for-a-specific-call/description/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Receivers extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInReceivers() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos/2.1.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos/3.1.kt");
                        }

                        @TestMetadata("5.1.kt")
                        public void test5_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos/5.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/receivers/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Resolving_callable_references extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInResolving_callable_references() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Bidirectional_resolution_for_callable_calls extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInBidirectional_resolution_for_callable_calls() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos/1.4.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/bidirectional-resolution-for-callable-calls/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2/pos/2.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Resolving_callable_references_not_used_as_arguments_to_a_call extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInResolving_callable_references_not_used_as_arguments_to_a_call() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg/1.5.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos/1.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/overload-resolution/resolving-callable-references/resolving-callable-references-not-used-as-arguments-to-a-call/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Statements extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInStatements() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "assignments/simple-assignments");
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Assignments extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInAssignments() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "simple-assignments");
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Operator_assignments extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInOperator_assignments() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/operator-assignments/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1/neg/2.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2/neg/1.2.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/assignments/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Loop_statements extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInLoop_statements() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Do_while_loop_statement extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInDo_while_loop_statement() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/do-while-loop-statement/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class While_loop_statement extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInWhile_loop_statement() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_3 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_3() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/statements/loop-statements/while-loop-statement/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Type_inference extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInType_inference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "local-type-inference", "smart-casts/smart-cast-types");
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Smart_casts extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInSmart_casts() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "smart-cast-types");
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Smart_cast_sink_stability extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInSmart_cast_sink_stability() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_5 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_5() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-cast-sink-stability/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Type_system extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInType_system() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "subtyping/subtyping-for-nullable-types", "type-kinds/type-parameters");
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Introduction_1 extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInIntroduction_1() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_6 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_6() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg/2.3.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_8 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_8() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8/pos/1.1.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8/pos/2.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/introduction-1/p-8/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Subtyping extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInSubtyping() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "subtyping-for-nullable-types");
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Subtyping_for_intersection_types extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInSubtyping_for_intersection_types() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos/1.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-for-intersection-types/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Subtyping_rules extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInSubtyping_rules() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2/pos/1.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/subtyping/subtyping-rules/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_contexts_and_scopes extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInType_contexts_and_scopes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Inner_and_nested_type_contexts extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInInner_and_nested_type_contexts() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg/1.2.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg/2.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/pos/1.2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-contexts-and-scopes/inner-and-nested-type-contexts/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_kinds extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInType_kinds() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true, "type-parameters");
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Built_in_types extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInBuilt_in_types() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Kotlin_any extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInKotlin_any() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1/pos/1.1.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1/pos/1.2.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.any/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Kotlin_nothing extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInKotlin_nothing() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class P_1 extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInP_1() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("2.1.kt")
                                public void test2_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/neg/2.1.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.1.kt")
                                public void test1_1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos/1.1.kt");
                                }

                                @TestMetadata("1.2.kt")
                                public void test1_2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos/1.2.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-system/type-kinds/built-in-types/kotlin.nothing/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NotLinked extends AbstractDiagnosticsTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInNotLinked() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Annotation_classes extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInAnnotation_classes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg/1.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_annotations extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInType_annotations() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/1.kt");
                    }

                    @TestMetadata("10.kt")
                    public void test10() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/10.kt");
                    }

                    @TestMetadata("11.kt")
                    public void test11() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/11.kt");
                    }

                    @TestMetadata("2.kt")
                    public void test2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/2.kt");
                    }

                    @TestMetadata("3.kt")
                    public void test3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/3.kt");
                    }

                    @TestMetadata("4.kt")
                    public void test4() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/4.kt");
                    }

                    @TestMetadata("5.kt")
                    public void test5() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/5.kt");
                    }

                    @TestMetadata("6.kt")
                    public void test6() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/6.kt");
                    }

                    @TestMetadata("7.kt")
                    public void test7() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/7.kt");
                    }

                    @TestMetadata("8.kt")
                    public void test8() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/8.kt");
                    }

                    @TestMetadata("9.kt")
                    public void test9() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/9.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Coercion_to_unit extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInCoercion_to_unit() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit/neg")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Neg extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                @TestMetadata("1.kt")
                public void test1() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit/neg/1.kt");
                }

                public void testAllFilesPresentInNeg() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/coercion-to-unit/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Contracts extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInContracts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Analysis extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInAnalysis() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Common extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInCommon() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg/1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos/1.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos/2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ControlFlow extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInControlFlow() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Initialization extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInInitialization() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/1.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/2.kt");
                            }

                            @TestMetadata("3.kt")
                            public void test3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/3.kt");
                            }

                            @TestMetadata("4.kt")
                            public void test4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/4.kt");
                            }

                            @TestMetadata("5.kt")
                            public void test5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/5.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/1.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/2.kt");
                            }

                            @TestMetadata("3.kt")
                            public void test3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/3.kt");
                            }

                            @TestMetadata("4.kt")
                            public void test4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/4.kt");
                            }

                            @TestMetadata("5.kt")
                            public void test5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/5.kt");
                            }

                            @TestMetadata("6.kt")
                            public void test6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/6.kt");
                            }

                            @TestMetadata("7.kt")
                            public void test7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/7.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class UnreachableCode extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInUnreachableCode() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg/1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/1.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/2.kt");
                            }

                            @TestMetadata("3.kt")
                            public void test3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/3.kt");
                            }

                            @TestMetadata("4.kt")
                            public void test4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/4.kt");
                            }

                            @TestMetadata("5.kt")
                            public void test5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/5.kt");
                            }

                            @TestMetadata("6.kt")
                            public void test6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/6.kt");
                            }

                            @TestMetadata("7.kt")
                            public void test7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/7.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Smartcasts extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInSmartcasts() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/1.kt");
                        }

                        @TestMetadata("10.kt")
                        public void test10() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/10.kt");
                        }

                        @TestMetadata("11.kt")
                        public void test11() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/11.kt");
                        }

                        @TestMetadata("12.kt")
                        public void test12() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/12.kt");
                        }

                        @TestMetadata("13.kt")
                        public void test13() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/13.kt");
                        }

                        @TestMetadata("14.kt")
                        public void test14() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/14.kt");
                        }

                        @TestMetadata("15.kt")
                        public void test15() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/15.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/2.kt");
                        }

                        @TestMetadata("3.kt")
                        public void test3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/3.kt");
                        }

                        @TestMetadata("4.kt")
                        public void test4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/4.kt");
                        }

                        @TestMetadata("5.kt")
                        public void test5() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/5.kt");
                        }

                        @TestMetadata("6.kt")
                        public void test6() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/6.kt");
                        }

                        @TestMetadata("7.kt")
                        public void test7() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/7.kt");
                        }

                        @TestMetadata("8.kt")
                        public void test8() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/8.kt");
                        }

                        @TestMetadata("9.kt")
                        public void test9() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/9.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/1.kt");
                        }

                        @TestMetadata("10.kt")
                        public void test10() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/10.kt");
                        }

                        @TestMetadata("11.kt")
                        public void test11() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/11.kt");
                        }

                        @TestMetadata("12.kt")
                        public void test12() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/12.kt");
                        }

                        @TestMetadata("13.kt")
                        public void test13() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/13.kt");
                        }

                        @TestMetadata("14.kt")
                        public void test14() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/14.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/2.kt");
                        }

                        @TestMetadata("3.kt")
                        public void test3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/3.kt");
                        }

                        @TestMetadata("4.kt")
                        public void test4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/4.kt");
                        }

                        @TestMetadata("5.kt")
                        public void test5() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/5.kt");
                        }

                        @TestMetadata("6.kt")
                        public void test6() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/6.kt");
                        }

                        @TestMetadata("7.kt")
                        public void test7() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/7.kt");
                        }

                        @TestMetadata("8.kt")
                        public void test8() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/8.kt");
                        }

                        @TestMetadata("9.kt")
                        public void test9() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/9.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Declarations extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInDeclarations() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ContractBuilder extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInContractBuilder() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Common extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInCommon() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/1.kt");
                            }

                            @TestMetadata("10.kt")
                            public void test10() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/10.kt");
                            }

                            @TestMetadata("11.kt")
                            public void test11() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/11.kt");
                            }

                            @TestMetadata("12.kt")
                            public void test12() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/12.kt");
                            }

                            @TestMetadata("13.kt")
                            public void test13() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/13.kt");
                            }

                            @TestMetadata("14.kt")
                            public void test14() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/14.kt");
                            }

                            @TestMetadata("15.kt")
                            public void test15() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/15.kt");
                            }

                            @TestMetadata("16.kt")
                            public void test16() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/16.kt");
                            }

                            @TestMetadata("17.kt")
                            public void test17() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/17.kt");
                            }

                            @TestMetadata("19.kt")
                            public void test19() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/19.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/2.kt");
                            }

                            @TestMetadata("3.kt")
                            public void test3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/3.kt");
                            }

                            @TestMetadata("4.kt")
                            public void test4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/4.kt");
                            }

                            @TestMetadata("5.kt")
                            public void test5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/5.kt");
                            }

                            @TestMetadata("6.kt")
                            public void test6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/6.kt");
                            }

                            @TestMetadata("7.kt")
                            public void test7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/7.kt");
                            }

                            @TestMetadata("8.kt")
                            public void test8() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/8.kt");
                            }

                            @TestMetadata("9.kt")
                            public void test9() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/9.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos/1.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos/2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Effects extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        public void testAllFilesPresentInEffects() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class CallsInPlace extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInCallsInPlace() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg/1.kt");
                                }

                                @TestMetadata("2.kt")
                                public void test2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg/2.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/1.kt");
                                }

                                @TestMetadata("2.kt")
                                public void test2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/2.kt");
                                }

                                @TestMetadata("3.kt")
                                public void test3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/3.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Common extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInCommon() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg/1.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Returns extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                            }

                            public void testAllFilesPresentInReturns() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/1.kt");
                                }

                                @TestMetadata("2.kt")
                                public void test2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/2.kt");
                                }

                                @TestMetadata("3.kt")
                                public void test3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/3.kt");
                                }

                                @TestMetadata("4.kt")
                                public void test4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/4.kt");
                                }

                                @TestMetadata("5.kt")
                                public void test5() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/5.kt");
                                }

                                @TestMetadata("6.kt")
                                public void test6() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/6.kt");
                                }

                                @TestMetadata("7.kt")
                                public void test7() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/7.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/1.kt");
                                }

                                @TestMetadata("2.kt")
                                public void test2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/2.kt");
                                }

                                @TestMetadata("3.kt")
                                public void test3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/3.kt");
                                }

                                @TestMetadata("4.kt")
                                public void test4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/4.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                                }
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ContractFunction extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInContractFunction() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/1.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/2.kt");
                        }

                        @TestMetadata("3.kt")
                        public void test3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/3.kt");
                        }

                        @TestMetadata("4.kt")
                        public void test4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/4.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos/1.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos/2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/dfa")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Dfa extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInDfa() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/dfa"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Neg extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                @TestMetadata("1.kt")
                public void test1() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/1.kt");
                }

                @TestMetadata("10.kt")
                public void test10() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/10.kt");
                }

                @TestMetadata("11.kt")
                public void test11() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/11.kt");
                }

                @TestMetadata("12.kt")
                public void test12() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/12.kt");
                }

                @TestMetadata("13.kt")
                public void test13() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/13.kt");
                }

                @TestMetadata("14.kt")
                public void test14() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/14.kt");
                }

                @TestMetadata("15.kt")
                public void test15() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/15.kt");
                }

                @TestMetadata("16.kt")
                public void test16() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/16.kt");
                }

                @TestMetadata("17.kt")
                public void test17() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/17.kt");
                }

                @TestMetadata("18.kt")
                public void test18() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/18.kt");
                }

                @TestMetadata("19.kt")
                public void test19() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/19.kt");
                }

                @TestMetadata("2.kt")
                public void test2() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/2.kt");
                }

                @TestMetadata("20.kt")
                public void test20() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/20.kt");
                }

                @TestMetadata("21.kt")
                public void test21() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/21.kt");
                }

                @TestMetadata("22.kt")
                public void test22() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/22.kt");
                }

                @TestMetadata("23.kt")
                public void test23() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/23.kt");
                }

                @TestMetadata("24.kt")
                public void test24() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/24.kt");
                }

                @TestMetadata("25.kt")
                public void test25() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/25.kt");
                }

                @TestMetadata("26.kt")
                public void test26() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/26.kt");
                }

                @TestMetadata("27.kt")
                public void test27() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/27.kt");
                }

                @TestMetadata("28.kt")
                public void test28() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/28.kt");
                }

                @TestMetadata("29.kt")
                public void test29() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/29.kt");
                }

                @TestMetadata("3.kt")
                public void test3() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/3.kt");
                }

                @TestMetadata("30.kt")
                public void test30() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/30.kt");
                }

                @TestMetadata("31.kt")
                public void test31() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/31.kt");
                }

                @TestMetadata("32.kt")
                public void test32() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/32.kt");
                }

                @TestMetadata("33.kt")
                public void test33() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/33.kt");
                }

                @TestMetadata("34.kt")
                public void test34() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/34.kt");
                }

                @TestMetadata("35.kt")
                public void test35() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/35.kt");
                }

                @TestMetadata("36.kt")
                public void test36() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/36.kt");
                }

                @TestMetadata("37.kt")
                public void test37() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/37.kt");
                }

                @TestMetadata("38.kt")
                public void test38() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/38.kt");
                }

                @TestMetadata("39.kt")
                public void test39() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/39.kt");
                }

                @TestMetadata("4.kt")
                public void test4() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/4.kt");
                }

                @TestMetadata("40.kt")
                public void test40() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/40.kt");
                }

                @TestMetadata("41.kt")
                public void test41() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/41.kt");
                }

                @TestMetadata("42.kt")
                public void test42() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/42.kt");
                }

                @TestMetadata("43.kt")
                public void test43() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/43.kt");
                }

                @TestMetadata("44.kt")
                public void test44() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/44.kt");
                }

                @TestMetadata("45.kt")
                public void test45() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/45.kt");
                }

                @TestMetadata("5.kt")
                public void test5() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/5.kt");
                }

                @TestMetadata("6.kt")
                public void test6() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/6.kt");
                }

                @TestMetadata("7.kt")
                public void test7() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/7.kt");
                }

                @TestMetadata("8.kt")
                public void test8() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/8.kt");
                }

                @TestMetadata("9.kt")
                public void test9() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg/9.kt");
                }

                public void testAllFilesPresentInNeg() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/dfa/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Pos extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                @TestMetadata("1.kt")
                public void test1() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/1.kt");
                }

                @TestMetadata("10.kt")
                public void test10() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/10.kt");
                }

                @TestMetadata("11.kt")
                public void test11() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/11.kt");
                }

                @TestMetadata("12.kt")
                public void test12() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/12.kt");
                }

                @TestMetadata("13.kt")
                public void test13() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/13.kt");
                }

                @TestMetadata("14.kt")
                public void test14() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/14.kt");
                }

                @TestMetadata("15.kt")
                public void test15() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/15.kt");
                }

                @TestMetadata("16.kt")
                public void test16() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/16.kt");
                }

                @TestMetadata("17.kt")
                public void test17() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/17.kt");
                }

                @TestMetadata("18.kt")
                public void test18() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/18.kt");
                }

                @TestMetadata("19.kt")
                public void test19() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/19.kt");
                }

                @TestMetadata("2.kt")
                public void test2() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/2.kt");
                }

                @TestMetadata("20.kt")
                public void test20() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/20.kt");
                }

                @TestMetadata("21.kt")
                public void test21() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/21.kt");
                }

                @TestMetadata("22.kt")
                public void test22() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/22.kt");
                }

                @TestMetadata("23.kt")
                public void test23() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/23.kt");
                }

                @TestMetadata("24.kt")
                public void test24() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/24.kt");
                }

                @TestMetadata("25.kt")
                public void test25() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/25.kt");
                }

                @TestMetadata("26.kt")
                public void test26() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/26.kt");
                }

                @TestMetadata("27.kt")
                public void test27() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/27.kt");
                }

                @TestMetadata("28.kt")
                public void test28() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/28.kt");
                }

                @TestMetadata("29.kt")
                public void test29() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/29.kt");
                }

                @TestMetadata("3.kt")
                public void test3() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/3.kt");
                }

                @TestMetadata("30.kt")
                public void test30() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/30.kt");
                }

                @TestMetadata("31.kt")
                public void test31() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/31.kt");
                }

                @TestMetadata("32.kt")
                public void test32() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/32.kt");
                }

                @TestMetadata("33.kt")
                public void test33() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/33.kt");
                }

                @TestMetadata("34.kt")
                public void test34() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/34.kt");
                }

                @TestMetadata("35.kt")
                public void test35() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/35.kt");
                }

                @TestMetadata("36.kt")
                public void test36() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/36.kt");
                }

                @TestMetadata("37.kt")
                public void test37() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/37.kt");
                }

                @TestMetadata("38.kt")
                public void test38() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/38.kt");
                }

                @TestMetadata("39.kt")
                public void test39() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/39.kt");
                }

                @TestMetadata("4.kt")
                public void test4() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/4.kt");
                }

                @TestMetadata("40.kt")
                public void test40() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/40.kt");
                }

                @TestMetadata("41.kt")
                public void test41() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/41.kt");
                }

                @TestMetadata("42.kt")
                public void test42() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/42.kt");
                }

                @TestMetadata("43.kt")
                public void test43() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/43.kt");
                }

                @TestMetadata("44.kt")
                public void test44() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/44.kt");
                }

                @TestMetadata("45.kt")
                public void test45() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/45.kt");
                }

                @TestMetadata("46.kt")
                public void test46() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/46.kt");
                }

                @TestMetadata("47.kt")
                public void test47() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/47.kt");
                }

                @TestMetadata("48.kt")
                public void test48() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/48.kt");
                }

                @TestMetadata("49.kt")
                public void test49() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/49.kt");
                }

                @TestMetadata("5.kt")
                public void test5() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/5.kt");
                }

                @TestMetadata("50.kt")
                public void test50() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/50.kt");
                }

                @TestMetadata("51.kt")
                public void test51() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/51.kt");
                }

                @TestMetadata("52.kt")
                public void test52() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/52.kt");
                }

                @TestMetadata("53.kt")
                public void test53() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/53.kt");
                }

                @TestMetadata("54.kt")
                public void test54() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/54.kt");
                }

                @TestMetadata("55.kt")
                public void test55() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/55.kt");
                }

                @TestMetadata("56.kt")
                public void test56() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/56.kt");
                }

                @TestMetadata("57.kt")
                public void test57() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/57.kt");
                }

                @TestMetadata("58.kt")
                public void test58() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/58.kt");
                }

                @TestMetadata("59.kt")
                public void test59() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/59.kt");
                }

                @TestMetadata("6.kt")
                public void test6() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/6.kt");
                }

                @TestMetadata("60.kt")
                public void test60() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/60.kt");
                }

                @TestMetadata("61.kt")
                public void test61() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/61.kt");
                }

                @TestMetadata("62.kt")
                public void test62() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/62.kt");
                }

                @TestMetadata("63.kt")
                public void test63() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/63.kt");
                }

                @TestMetadata("64.kt")
                public void test64() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/64.kt");
                }

                @TestMetadata("65.kt")
                public void test65() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/65.kt");
                }

                @TestMetadata("66.kt")
                public void test66() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/66.kt");
                }

                @TestMetadata("67.kt")
                public void test67() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/67.kt");
                }

                @TestMetadata("68.kt")
                public void test68() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/68.kt");
                }

                @TestMetadata("69.kt")
                public void test69() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/69.kt");
                }

                @TestMetadata("7.kt")
                public void test7() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/7.kt");
                }

                @TestMetadata("70.kt")
                public void test70() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/70.kt");
                }

                @TestMetadata("71.kt")
                public void test71() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/71.kt");
                }

                @TestMetadata("72.kt")
                public void test72() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/72.kt");
                }

                @TestMetadata("73.kt")
                public void test73() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/73.kt");
                }

                @TestMetadata("8.kt")
                public void test8() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/8.kt");
                }

                @TestMetadata("9.kt")
                public void test9() throws Exception {
                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos/9.kt");
                }

                public void testAllFilesPresentInPos() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/dfa/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Local_variables extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInLocal_variables() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_parameters extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInType_parameters() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg/1.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/objects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Objects extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInObjects() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/objects"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inheritance extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInInheritance() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/1.kt");
                    }

                    @TestMetadata("2.kt")
                    public void test2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/2.kt");
                    }

                    @TestMetadata("3.kt")
                    public void test3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/3.kt");
                    }

                    @TestMetadata("4.kt")
                    public void test4() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/4.kt");
                    }

                    @TestMetadata("5.kt")
                    public void test5() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/5.kt");
                    }

                    @TestMetadata("6.kt")
                    public void test6() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/6.kt");
                    }

                    @TestMetadata("7.kt")
                    public void test7() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg/7.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/objects/inheritance/neg"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Overload_resolution extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInOverload_resolution() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Building_the_overload_candidate_set_ocs extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInBuilding_the_overload_candidate_set_ocs() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Infix_function_call extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInInfix_function_call() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos/1.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos/2.kt");
                        }

                        @TestMetadata("3.kt")
                        public void test3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos/3.kt");
                        }

                        @TestMetadata("4.kt")
                        public void test4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos/4.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/overload-resolution/building-the-overload-candidate-set-ocs/infix-function-call/pos"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }
                    }
                }
            }
        }
    }
}
