/*
 * KOTLIN CODEGEN BOX SPEC TEST (POSITIVE)
 *
 * SPEC VERSION: 0.1-300
 * MAIN LINK: expressions, constant-literals, boolean-literals -> paragraph 1 -> sentence 2
 * NUMBER: 15
 * DESCRIPTION: The use of Boolean literals as the identifier (with backtick) in the parameter.
 * NOTE: this test data is generated by FeatureInteractionTestDataGenerator. DO NOT MODIFY CODE MANUALLY!
 * HELPERS: reflect
 */

fun f1(`true`: Boolean) = !!!`true`
fun f2(`false`: Boolean, `true`: Boolean) = `false` && `true`
fun f3(`false`: Boolean, `true`: Boolean = `false`) = `false` || !`true`

class A {
    var x1: Boolean = false
        set(`false`) {
            field = !`false`
        }
}

fun box(): String? {
    val a = A()
    a.x1 = false

    if (f1(true)) return null
    if (!f2(true, true)) return null
    if (f3(false, true)) return null
    if (!a.x1) return null

    if (!checkParameter(::f1, "true")) return null
    if (!checkParameters(::f2, listOf("false", "true"))) return null
    if (!checkParameters(::f3, listOf("false", "true"))) return null
    if (!checkSetterParameterName(A::x1, "false")) return null

    return "OK"
}
