/*
 * KOTLIN CODEGEN BOX SPEC TEST (POSITIVE)
 *
 * SPEC VERSION: 0.1-300
 * MAIN LINK: expressions, constant-literals, boolean-literals -> paragraph 1 -> sentence 2
 * NUMBER: 1
 * DESCRIPTION: The use of Boolean literals as the identifier (with backtick) in the class.
 * NOTE: this test data is generated by FeatureInteractionTestDataGenerator. DO NOT MODIFY CODE MANUALLY!
 * HELPERS: reflect
 * UNEXPECTED BEHAVIOUR
 */

open class `true` {
    val x1 = true
}

internal open class A: `true`() {
    val x2 = false
}

@Target(AnnotationTarget.CLASS, AnnotationTarget.TYPE)
annotation class `false`(val x2: Boolean)

@`false`(false) internal class B: @`false`(false) A() {}

@`false`(true) interface C

fun box(): String? {
    val o1 = `true`()
    val o2 = A()
    val o3 = B()

    if (o1.x1 != true) return null
    if (o2.x1 != true || o2.x2 != false || o3.x2 != false || o3.x1 != true) return null

    if (!checkAnnotation("B", "false")) return null
    if (!checkAnnotation("C", "false")) return null
    if (!checkSuperClass(B::class, "A")) return null
    if (!checkSuperTypeAnnotation(B::class, "A", "false")) return null
    if (!checkClassName(`false`::class, "false")) return null
    if (!checkClassName(`true`::class, "true")) return null

    return "OK"
}
