/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.jvm.compiler;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/loadJava8/compiledJava")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class LoadJava8WithPsiClassReadingTestGenerated extends AbstractLoadJava8WithPsiClassReadingTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTestCompiledJava, this, testDataFilePath);
    }

    public void testAllFilesPresentInCompiledJava() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/loadJava8/compiledJava"), Pattern.compile("^(.+)\\.java$"), null, true, "typeUseAnnotations", "typeParameterAnnotations");
    }

    @TestMetadata("InnerClassTypeAnnotation.java")
    public void testInnerClassTypeAnnotation() throws Exception {
        runTest("compiler/testData/loadJava8/compiledJava/InnerClassTypeAnnotation.java");
    }

    @TestMetadata("MapRemove.java")
    public void testMapRemove() throws Exception {
        runTest("compiler/testData/loadJava8/compiledJava/MapRemove.java");
    }

    @TestMetadata("ParameterNames.java")
    public void testParameterNames() throws Exception {
        runTest("compiler/testData/loadJava8/compiledJava/ParameterNames.java");
    }
}
