/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.parsing;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class ParsingTestGenerated extends AbstractParsingTest {
    @TestMetadata("compiler/testData/psi")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Psi extends AbstractParsingTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
        }

        @TestMetadata("AbsentInnerType.kt")
        public void testAbsentInnerType() throws Exception {
            runTest("compiler/testData/psi/AbsentInnerType.kt");
        }

        public void testAllFilesPresentInPsi() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi"), Pattern.compile("^(.*)\\.kts?$"), null, true);
        }

        @TestMetadata("AnnotatedIntersections.kt")
        public void testAnnotatedIntersections() throws Exception {
            runTest("compiler/testData/psi/AnnotatedIntersections.kt");
        }

        @TestMetadata("AnonymousInitializer.kt")
        public void testAnonymousInitializer() throws Exception {
            runTest("compiler/testData/psi/AnonymousInitializer.kt");
        }

        @TestMetadata("AssertNotNull.kt")
        public void testAssertNotNull() throws Exception {
            runTest("compiler/testData/psi/AssertNotNull.kt");
        }

        @TestMetadata("BabySteps.kt")
        public void testBabySteps() throws Exception {
            runTest("compiler/testData/psi/BabySteps.kt");
        }

        @TestMetadata("BabySteps_ERR.kt")
        public void testBabySteps_ERR() throws Exception {
            runTest("compiler/testData/psi/BabySteps_ERR.kt");
        }

        @TestMetadata("BackslashInString.kt")
        public void testBackslashInString() throws Exception {
            runTest("compiler/testData/psi/BackslashInString.kt");
        }

        @TestMetadata("BlockCommentAtBeginningOfFile1.kt")
        public void testBlockCommentAtBeginningOfFile1() throws Exception {
            runTest("compiler/testData/psi/BlockCommentAtBeginningOfFile1.kt");
        }

        @TestMetadata("BlockCommentAtBeginningOfFile2.kt")
        public void testBlockCommentAtBeginningOfFile2() throws Exception {
            runTest("compiler/testData/psi/BlockCommentAtBeginningOfFile2.kt");
        }

        @TestMetadata("BlockCommentAtBeginningOfFile3.kt")
        public void testBlockCommentAtBeginningOfFile3() throws Exception {
            runTest("compiler/testData/psi/BlockCommentAtBeginningOfFile3.kt");
        }

        @TestMetadata("BlockCommentAtBeginningOfFile4.kt")
        public void testBlockCommentAtBeginningOfFile4() throws Exception {
            runTest("compiler/testData/psi/BlockCommentAtBeginningOfFile4.kt");
        }

        @TestMetadata("BlockCommentUnmatchedClosing_ERR.kt")
        public void testBlockCommentUnmatchedClosing_ERR() throws Exception {
            runTest("compiler/testData/psi/BlockCommentUnmatchedClosing_ERR.kt");
        }

        @TestMetadata("ByClauses.kt")
        public void testByClauses() throws Exception {
            runTest("compiler/testData/psi/ByClauses.kt");
        }

        @TestMetadata("CallWithManyClosures.kt")
        public void testCallWithManyClosures() throws Exception {
            runTest("compiler/testData/psi/CallWithManyClosures.kt");
        }

        @TestMetadata("CallsInWhen.kt")
        public void testCallsInWhen() throws Exception {
            runTest("compiler/testData/psi/CallsInWhen.kt");
        }

        @TestMetadata("CollectionLiterals.kt")
        public void testCollectionLiterals() throws Exception {
            runTest("compiler/testData/psi/CollectionLiterals.kt");
        }

        @TestMetadata("CollectionLiterals_ERR.kt")
        public void testCollectionLiterals_ERR() throws Exception {
            runTest("compiler/testData/psi/CollectionLiterals_ERR.kt");
        }

        @TestMetadata("CommentsBinding.kt")
        public void testCommentsBinding() throws Exception {
            runTest("compiler/testData/psi/CommentsBinding.kt");
        }

        @TestMetadata("CommentsBindingInLambda.kt")
        public void testCommentsBindingInLambda() throws Exception {
            runTest("compiler/testData/psi/CommentsBindingInLambda.kt");
        }

        @TestMetadata("CommentsBindingInStatementBlock.kt")
        public void testCommentsBindingInStatementBlock() throws Exception {
            runTest("compiler/testData/psi/CommentsBindingInStatementBlock.kt");
        }

        @TestMetadata("Constructors.kt")
        public void testConstructors() throws Exception {
            runTest("compiler/testData/psi/Constructors.kt");
        }

        @TestMetadata("ControlStructures.kt")
        public void testControlStructures() throws Exception {
            runTest("compiler/testData/psi/ControlStructures.kt");
        }

        @TestMetadata("DefaultKeyword.kt")
        public void testDefaultKeyword() throws Exception {
            runTest("compiler/testData/psi/DefaultKeyword.kt");
        }

        @TestMetadata("DefinitelyNotNullType.kt")
        public void testDefinitelyNotNullType() throws Exception {
            runTest("compiler/testData/psi/DefinitelyNotNullType.kt");
        }

        @TestMetadata("destructuringInLambdas.kt")
        public void testDestructuringInLambdas() throws Exception {
            runTest("compiler/testData/psi/destructuringInLambdas.kt");
        }

        @TestMetadata("destructuringInLambdas_ERR.kt")
        public void testDestructuringInLambdas_ERR() throws Exception {
            runTest("compiler/testData/psi/destructuringInLambdas_ERR.kt");
        }

        @TestMetadata("diagnosticTags_ERR.kt")
        public void testDiagnosticTags_ERR() throws Exception {
            runTest("compiler/testData/psi/diagnosticTags_ERR.kt");
        }

        @TestMetadata("DocCommentAfterFileAnnotations.kt")
        public void testDocCommentAfterFileAnnotations() throws Exception {
            runTest("compiler/testData/psi/DocCommentAfterFileAnnotations.kt");
        }

        @TestMetadata("DocCommentForFirstDeclaration.kt")
        public void testDocCommentForFirstDeclaration() throws Exception {
            runTest("compiler/testData/psi/DocCommentForFirstDeclaration.kt");
        }

        @TestMetadata("DocCommentOnPackageDirectiveLine.kt")
        public void testDocCommentOnPackageDirectiveLine() throws Exception {
            runTest("compiler/testData/psi/DocCommentOnPackageDirectiveLine.kt");
        }

        @TestMetadata("DocCommentsBinding.kt")
        public void testDocCommentsBinding() throws Exception {
            runTest("compiler/testData/psi/DocCommentsBinding.kt");
        }

        @TestMetadata("DoubleColon.kt")
        public void testDoubleColon() throws Exception {
            runTest("compiler/testData/psi/DoubleColon.kt");
        }

        @TestMetadata("DoubleColonWhitespaces.kt")
        public void testDoubleColonWhitespaces() throws Exception {
            runTest("compiler/testData/psi/DoubleColonWhitespaces.kt");
        }

        @TestMetadata("DoubleColon_ERR.kt")
        public void testDoubleColon_ERR() throws Exception {
            runTest("compiler/testData/psi/DoubleColon_ERR.kt");
        }

        @TestMetadata("DuplicateAccessor.kt")
        public void testDuplicateAccessor() throws Exception {
            runTest("compiler/testData/psi/DuplicateAccessor.kt");
        }

        @TestMetadata("DynamicReceiver.kt")
        public void testDynamicReceiver() throws Exception {
            runTest("compiler/testData/psi/DynamicReceiver.kt");
        }

        @TestMetadata("DynamicSoftKeyword.kt")
        public void testDynamicSoftKeyword() throws Exception {
            runTest("compiler/testData/psi/DynamicSoftKeyword.kt");
        }

        @TestMetadata("DynamicTypes.kt")
        public void testDynamicTypes() throws Exception {
            runTest("compiler/testData/psi/DynamicTypes.kt");
        }

        @TestMetadata("EOLsInComments.kt")
        public void testEOLsInComments() throws Exception {
            runTest("compiler/testData/psi/EOLsInComments.kt");
        }

        @TestMetadata("EOLsOnRollback.kt")
        public void testEOLsOnRollback() throws Exception {
            runTest("compiler/testData/psi/EOLsOnRollback.kt");
        }

        @TestMetadata("EmptyFile.kt")
        public void testEmptyFile() throws Exception {
            runTest("compiler/testData/psi/EmptyFile.kt");
        }

        @TestMetadata("EmptyName.kt")
        public void testEmptyName() throws Exception {
            runTest("compiler/testData/psi/EmptyName.kt");
        }

        @TestMetadata("EnumCommas.kt")
        public void testEnumCommas() throws Exception {
            runTest("compiler/testData/psi/EnumCommas.kt");
        }

        @TestMetadata("EnumEntryCommaAnnotatedMember.kt")
        public void testEnumEntryCommaAnnotatedMember() throws Exception {
            runTest("compiler/testData/psi/EnumEntryCommaAnnotatedMember.kt");
        }

        @TestMetadata("EnumEntryCommaInlineMember.kt")
        public void testEnumEntryCommaInlineMember() throws Exception {
            runTest("compiler/testData/psi/EnumEntryCommaInlineMember.kt");
        }

        @TestMetadata("EnumEntryCommaMember.kt")
        public void testEnumEntryCommaMember() throws Exception {
            runTest("compiler/testData/psi/EnumEntryCommaMember.kt");
        }

        @TestMetadata("EnumEntryCommaPublicMember.kt")
        public void testEnumEntryCommaPublicMember() throws Exception {
            runTest("compiler/testData/psi/EnumEntryCommaPublicMember.kt");
        }

        @TestMetadata("EnumEntrySemicolonInlineMember.kt")
        public void testEnumEntrySemicolonInlineMember() throws Exception {
            runTest("compiler/testData/psi/EnumEntrySemicolonInlineMember.kt");
        }

        @TestMetadata("EnumEntrySemicolonMember.kt")
        public void testEnumEntrySemicolonMember() throws Exception {
            runTest("compiler/testData/psi/EnumEntrySemicolonMember.kt");
        }

        @TestMetadata("EnumEntrySpaceInlineMember.kt")
        public void testEnumEntrySpaceInlineMember() throws Exception {
            runTest("compiler/testData/psi/EnumEntrySpaceInlineMember.kt");
        }

        @TestMetadata("EnumEntrySpaceMember.kt")
        public void testEnumEntrySpaceMember() throws Exception {
            runTest("compiler/testData/psi/EnumEntrySpaceMember.kt");
        }

        @TestMetadata("EnumEntryTwoCommas.kt")
        public void testEnumEntryTwoCommas() throws Exception {
            runTest("compiler/testData/psi/EnumEntryTwoCommas.kt");
        }

        @TestMetadata("EnumIn.kt")
        public void testEnumIn() throws Exception {
            runTest("compiler/testData/psi/EnumIn.kt");
        }

        @TestMetadata("EnumInline.kt")
        public void testEnumInline() throws Exception {
            runTest("compiler/testData/psi/EnumInline.kt");
        }

        @TestMetadata("EnumInlinePublic.kt")
        public void testEnumInlinePublic() throws Exception {
            runTest("compiler/testData/psi/EnumInlinePublic.kt");
        }

        @TestMetadata("EnumMissingName.kt")
        public void testEnumMissingName() throws Exception {
            runTest("compiler/testData/psi/EnumMissingName.kt");
        }

        @TestMetadata("EnumOldConstructorSyntax.kt")
        public void testEnumOldConstructorSyntax() throws Exception {
            runTest("compiler/testData/psi/EnumOldConstructorSyntax.kt");
        }

        @TestMetadata("EnumShortCommas.kt")
        public void testEnumShortCommas() throws Exception {
            runTest("compiler/testData/psi/EnumShortCommas.kt");
        }

        @TestMetadata("EnumShortWithOverload.kt")
        public void testEnumShortWithOverload() throws Exception {
            runTest("compiler/testData/psi/EnumShortWithOverload.kt");
        }

        @TestMetadata("EnumWithAnnotationKeyword.kt")
        public void testEnumWithAnnotationKeyword() throws Exception {
            runTest("compiler/testData/psi/EnumWithAnnotationKeyword.kt");
        }

        @TestMetadata("Enums.kt")
        public void testEnums() throws Exception {
            runTest("compiler/testData/psi/Enums.kt");
        }

        @TestMetadata("Expressions_ERR.kt")
        public void testExpressions_ERR() throws Exception {
            runTest("compiler/testData/psi/Expressions_ERR.kt");
        }

        @TestMetadata("ExtensionsWithQNReceiver.kt")
        public void testExtensionsWithQNReceiver() throws Exception {
            runTest("compiler/testData/psi/ExtensionsWithQNReceiver.kt");
        }

        @TestMetadata("FileStart_ERR.kt")
        public void testFileStart_ERR() throws Exception {
            runTest("compiler/testData/psi/FileStart_ERR.kt");
        }

        @TestMetadata("FloatingPointLiteral.kt")
        public void testFloatingPointLiteral() throws Exception {
            runTest("compiler/testData/psi/FloatingPointLiteral.kt");
        }

        @TestMetadata("ForWithMultiDecl.kt")
        public void testForWithMultiDecl() throws Exception {
            runTest("compiler/testData/psi/ForWithMultiDecl.kt");
        }

        @TestMetadata("FunctionCalls.kt")
        public void testFunctionCalls() throws Exception {
            runTest("compiler/testData/psi/FunctionCalls.kt");
        }

        @TestMetadata("FunctionExpressions.kt")
        public void testFunctionExpressions() throws Exception {
            runTest("compiler/testData/psi/FunctionExpressions.kt");
        }

        @TestMetadata("FunctionExpressions_ERR.kt")
        public void testFunctionExpressions_ERR() throws Exception {
            runTest("compiler/testData/psi/FunctionExpressions_ERR.kt");
        }

        @TestMetadata("FunctionLiterals.kt")
        public void testFunctionLiterals() throws Exception {
            runTest("compiler/testData/psi/FunctionLiterals.kt");
        }

        @TestMetadata("FunctionLiterals_ERR.kt")
        public void testFunctionLiterals_ERR() throws Exception {
            runTest("compiler/testData/psi/FunctionLiterals_ERR.kt");
        }

        @TestMetadata("FunctionNoParameterList.kt")
        public void testFunctionNoParameterList() throws Exception {
            runTest("compiler/testData/psi/FunctionNoParameterList.kt");
        }

        @TestMetadata("FunctionTypes.kt")
        public void testFunctionTypes() throws Exception {
            runTest("compiler/testData/psi/FunctionTypes.kt");
        }

        @TestMetadata("Functions.kt")
        public void testFunctions() throws Exception {
            runTest("compiler/testData/psi/Functions.kt");
        }

        @TestMetadata("FunctionsWithoutName.kt")
        public void testFunctionsWithoutName() throws Exception {
            runTest("compiler/testData/psi/FunctionsWithoutName.kt");
        }

        @TestMetadata("FunctionsWithoutName_ERR.kt")
        public void testFunctionsWithoutName_ERR() throws Exception {
            runTest("compiler/testData/psi/FunctionsWithoutName_ERR.kt");
        }

        @TestMetadata("Functions_ERR.kt")
        public void testFunctions_ERR() throws Exception {
            runTest("compiler/testData/psi/Functions_ERR.kt");
        }

        @TestMetadata("HangOnLonelyModifier.kt")
        public void testHangOnLonelyModifier() throws Exception {
            runTest("compiler/testData/psi/HangOnLonelyModifier.kt");
        }

        @TestMetadata("IfWithPropery.kt")
        public void testIfWithPropery() throws Exception {
            runTest("compiler/testData/psi/IfWithPropery.kt");
        }

        @TestMetadata("ImportSoftKW.kt")
        public void testImportSoftKW() throws Exception {
            runTest("compiler/testData/psi/ImportSoftKW.kt");
        }

        @TestMetadata("Imports.kt")
        public void testImports() throws Exception {
            runTest("compiler/testData/psi/Imports.kt");
        }

        @TestMetadata("Imports_ERR.kt")
        public void testImports_ERR() throws Exception {
            runTest("compiler/testData/psi/Imports_ERR.kt");
        }

        @TestMetadata("IncompleteFunctionLiteral.kt")
        public void testIncompleteFunctionLiteral() throws Exception {
            runTest("compiler/testData/psi/IncompleteFunctionLiteral.kt");
        }

        @TestMetadata("Inner.kt")
        public void testInner() throws Exception {
            runTest("compiler/testData/psi/Inner.kt");
        }

        @TestMetadata("IntegerLiteral.kt")
        public void testIntegerLiteral() throws Exception {
            runTest("compiler/testData/psi/IntegerLiteral.kt");
        }

        @TestMetadata("Interface.kt")
        public void testInterface() throws Exception {
            runTest("compiler/testData/psi/Interface.kt");
        }

        @TestMetadata("InterfaceWithEnumKeyword.kt")
        public void testInterfaceWithEnumKeyword() throws Exception {
            runTest("compiler/testData/psi/InterfaceWithEnumKeyword.kt");
        }

        @TestMetadata("kotlinFunInterface_ERR.kt")
        public void testKotlinFunInterface_ERR() throws Exception {
            runTest("compiler/testData/psi/kotlinFunInterface_ERR.kt");
        }

        @TestMetadata("Labels.kt")
        public void testLabels() throws Exception {
            runTest("compiler/testData/psi/Labels.kt");
        }

        @TestMetadata("LineCommentAfterFileAnnotations.kt")
        public void testLineCommentAfterFileAnnotations() throws Exception {
            runTest("compiler/testData/psi/LineCommentAfterFileAnnotations.kt");
        }

        @TestMetadata("LineCommentForFirstDeclaration.kt")
        public void testLineCommentForFirstDeclaration() throws Exception {
            runTest("compiler/testData/psi/LineCommentForFirstDeclaration.kt");
        }

        @TestMetadata("LineCommentsInBlock.kt")
        public void testLineCommentsInBlock() throws Exception {
            runTest("compiler/testData/psi/LineCommentsInBlock.kt");
        }

        @TestMetadata("LocalDeclarations.kt")
        public void testLocalDeclarations() throws Exception {
            runTest("compiler/testData/psi/LocalDeclarations.kt");
        }

        @TestMetadata("LongPackageName.kt")
        public void testLongPackageName() throws Exception {
            runTest("compiler/testData/psi/LongPackageName.kt");
        }

        @TestMetadata("ModifierAsSelector.kt")
        public void testModifierAsSelector() throws Exception {
            runTest("compiler/testData/psi/ModifierAsSelector.kt");
        }

        @TestMetadata("MultiVariableDeclarations.kt")
        public void testMultiVariableDeclarations() throws Exception {
            runTest("compiler/testData/psi/MultiVariableDeclarations.kt");
        }

        @TestMetadata("NamedClassObject.kt")
        public void testNamedClassObject() throws Exception {
            runTest("compiler/testData/psi/NamedClassObject.kt");
        }

        @TestMetadata("namelessObjectAsEnumMember.kt")
        public void testNamelessObjectAsEnumMember() throws Exception {
            runTest("compiler/testData/psi/namelessObjectAsEnumMember.kt");
        }

        @TestMetadata("NestedComments.kt")
        public void testNestedComments() throws Exception {
            runTest("compiler/testData/psi/NestedComments.kt");
        }

        @TestMetadata("NewLinesValidOperations.kt")
        public void testNewLinesValidOperations() throws Exception {
            runTest("compiler/testData/psi/NewLinesValidOperations.kt");
        }

        @TestMetadata("NewlinesInParentheses.kt")
        public void testNewlinesInParentheses() throws Exception {
            runTest("compiler/testData/psi/NewlinesInParentheses.kt");
        }

        @TestMetadata("noCommaBetweenArguments.kt")
        public void testNoCommaBetweenArguments() throws Exception {
            runTest("compiler/testData/psi/noCommaBetweenArguments.kt");
        }

        @TestMetadata("NonTypeBeforeDotInBaseClass.kt")
        public void testNonTypeBeforeDotInBaseClass() throws Exception {
            runTest("compiler/testData/psi/NonTypeBeforeDotInBaseClass.kt");
        }

        @TestMetadata("NotIsAndNotIn.kt")
        public void testNotIsAndNotIn() throws Exception {
            runTest("compiler/testData/psi/NotIsAndNotIn.kt");
        }

        @TestMetadata("ObjectLiteralAsStatement.kt")
        public void testObjectLiteralAsStatement() throws Exception {
            runTest("compiler/testData/psi/ObjectLiteralAsStatement.kt");
        }

        @TestMetadata("ParameterNameMising.kt")
        public void testParameterNameMising() throws Exception {
            runTest("compiler/testData/psi/ParameterNameMising.kt");
        }

        @TestMetadata("ParameterType.kt")
        public void testParameterType() throws Exception {
            runTest("compiler/testData/psi/ParameterType.kt");
        }

        @TestMetadata("ParameterType_ERR.kt")
        public void testParameterType_ERR() throws Exception {
            runTest("compiler/testData/psi/ParameterType_ERR.kt");
        }

        @TestMetadata("Precedence.kt")
        public void testPrecedence() throws Exception {
            runTest("compiler/testData/psi/Precedence.kt");
        }

        @TestMetadata("PrimaryConstructorModifiers_ERR.kt")
        public void testPrimaryConstructorModifiers_ERR() throws Exception {
            runTest("compiler/testData/psi/PrimaryConstructorModifiers_ERR.kt");
        }

        @TestMetadata("Properties.kt")
        public void testProperties() throws Exception {
            runTest("compiler/testData/psi/Properties.kt");
        }

        @TestMetadata("PropertiesFollowedByInitializers.kt")
        public void testPropertiesFollowedByInitializers() throws Exception {
            runTest("compiler/testData/psi/PropertiesFollowedByInitializers.kt");
        }

        @TestMetadata("Properties_ERR.kt")
        public void testProperties_ERR() throws Exception {
            runTest("compiler/testData/psi/Properties_ERR.kt");
        }

        @TestMetadata("PropertyInvokes.kt")
        public void testPropertyInvokes() throws Exception {
            runTest("compiler/testData/psi/PropertyInvokes.kt");
        }

        @TestMetadata("QuotedIdentifiers.kt")
        public void testQuotedIdentifiers() throws Exception {
            runTest("compiler/testData/psi/QuotedIdentifiers.kt");
        }

        @TestMetadata("Reserved.kt")
        public void testReserved() throws Exception {
            runTest("compiler/testData/psi/Reserved.kt");
        }

        @TestMetadata("SemicolonAfterIf.kt")
        public void testSemicolonAfterIf() throws Exception {
            runTest("compiler/testData/psi/SemicolonAfterIf.kt");
        }

        @TestMetadata("semicolonBetweenDeclarations.kt")
        public void testSemicolonBetweenDeclarations() throws Exception {
            runTest("compiler/testData/psi/semicolonBetweenDeclarations.kt");
        }

        @TestMetadata("SimpleClassMembers.kt")
        public void testSimpleClassMembers() throws Exception {
            runTest("compiler/testData/psi/SimpleClassMembers.kt");
        }

        @TestMetadata("SimpleClassMembers_ERR.kt")
        public void testSimpleClassMembers_ERR() throws Exception {
            runTest("compiler/testData/psi/SimpleClassMembers_ERR.kt");
        }

        @TestMetadata("SimpleExpressions.kt")
        public void testSimpleExpressions() throws Exception {
            runTest("compiler/testData/psi/SimpleExpressions.kt");
        }

        @TestMetadata("SimpleIntersections.kt")
        public void testSimpleIntersections() throws Exception {
            runTest("compiler/testData/psi/SimpleIntersections.kt");
        }

        @TestMetadata("SimpleModifiers.kt")
        public void testSimpleModifiers() throws Exception {
            runTest("compiler/testData/psi/SimpleModifiers.kt");
        }

        @TestMetadata("SoftKeywords.kt")
        public void testSoftKeywords() throws Exception {
            runTest("compiler/testData/psi/SoftKeywords.kt");
        }

        @TestMetadata("SoftKeywordsInTypeArguments.kt")
        public void testSoftKeywordsInTypeArguments() throws Exception {
            runTest("compiler/testData/psi/SoftKeywordsInTypeArguments.kt");
        }

        @TestMetadata("StringTemplates.kt")
        public void testStringTemplates() throws Exception {
            runTest("compiler/testData/psi/StringTemplates.kt");
        }

        @TestMetadata("Super.kt")
        public void testSuper() throws Exception {
            runTest("compiler/testData/psi/Super.kt");
        }

        @TestMetadata("trailingCommaAllowed.kt")
        public void testTrailingCommaAllowed() throws Exception {
            runTest("compiler/testData/psi/trailingCommaAllowed.kt");
        }

        @TestMetadata("trailingCommaForbidden.kt")
        public void testTrailingCommaForbidden() throws Exception {
            runTest("compiler/testData/psi/trailingCommaForbidden.kt");
        }

        @TestMetadata("TraitConstructor.kt")
        public void testTraitConstructor() throws Exception {
            runTest("compiler/testData/psi/TraitConstructor.kt");
        }

        @TestMetadata("TripleDot.kt")
        public void testTripleDot() throws Exception {
            runTest("compiler/testData/psi/TripleDot.kt");
        }

        @TestMetadata("TryRecovery.kt")
        public void testTryRecovery() throws Exception {
            runTest("compiler/testData/psi/TryRecovery.kt");
        }

        @TestMetadata("TypeAlias.kt")
        public void testTypeAlias() throws Exception {
            runTest("compiler/testData/psi/TypeAlias.kt");
        }

        @TestMetadata("TypeAlias_ERR.kt")
        public void testTypeAlias_ERR() throws Exception {
            runTest("compiler/testData/psi/TypeAlias_ERR.kt");
        }

        @TestMetadata("TypeConstraints.kt")
        public void testTypeConstraints() throws Exception {
            runTest("compiler/testData/psi/TypeConstraints.kt");
        }

        @TestMetadata("TypeExpressionAmbiguities_ERR.kt")
        public void testTypeExpressionAmbiguities_ERR() throws Exception {
            runTest("compiler/testData/psi/TypeExpressionAmbiguities_ERR.kt");
        }

        @TestMetadata("TypeModifiers.kt")
        public void testTypeModifiers() throws Exception {
            runTest("compiler/testData/psi/TypeModifiers.kt");
        }

        @TestMetadata("TypeModifiersParenthesized.kt")
        public void testTypeModifiersParenthesized() throws Exception {
            runTest("compiler/testData/psi/TypeModifiersParenthesized.kt");
        }

        @TestMetadata("TypeModifiers_ERR.kt")
        public void testTypeModifiers_ERR() throws Exception {
            runTest("compiler/testData/psi/TypeModifiers_ERR.kt");
        }

        @TestMetadata("TypeParametersBeforeName.kt")
        public void testTypeParametersBeforeName() throws Exception {
            runTest("compiler/testData/psi/TypeParametersBeforeName.kt");
        }

        @TestMetadata("TypealiasIsKeyword.kt")
        public void testTypealiasIsKeyword() throws Exception {
            runTest("compiler/testData/psi/TypealiasIsKeyword.kt");
        }

        @TestMetadata("UnderscoredTypeArgumentsOfCall.kt")
        public void testUnderscoredTypeArgumentsOfCall() throws Exception {
            runTest("compiler/testData/psi/UnderscoredTypeArgumentsOfCall.kt");
        }

        @TestMetadata("UnderscoredTypeArgumentsOfCallIllegal.kt")
        public void testUnderscoredTypeArgumentsOfCallIllegal() throws Exception {
            runTest("compiler/testData/psi/UnderscoredTypeArgumentsOfCallIllegal.kt");
        }

        @TestMetadata("UnderscoredTypeArgumentsOfType.kt")
        public void testUnderscoredTypeArgumentsOfType() throws Exception {
            runTest("compiler/testData/psi/UnderscoredTypeArgumentsOfType.kt");
        }

        @TestMetadata("UnderscoredTypeParameters.kt")
        public void testUnderscoredTypeParameters() throws Exception {
            runTest("compiler/testData/psi/UnderscoredTypeParameters.kt");
        }

        @TestMetadata("UnsignedLiteral.kt")
        public void testUnsignedLiteral() throws Exception {
            runTest("compiler/testData/psi/UnsignedLiteral.kt");
        }

        @TestMetadata("validKotlinFunInterface.kt")
        public void testValidKotlinFunInterface() throws Exception {
            runTest("compiler/testData/psi/validKotlinFunInterface.kt");
        }

        @TestMetadata("valueClass.kt")
        public void testValueClass() throws Exception {
            runTest("compiler/testData/psi/valueClass.kt");
        }

        @TestMetadata("When.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/psi/When.kt");
        }

        @TestMetadata("WhenWithSubjectVariable.kt")
        public void testWhenWithSubjectVariable() throws Exception {
            runTest("compiler/testData/psi/WhenWithSubjectVariable.kt");
        }

        @TestMetadata("WhenWithSubjectVariable_ERR.kt")
        public void testWhenWithSubjectVariable_ERR() throws Exception {
            runTest("compiler/testData/psi/WhenWithSubjectVariable_ERR.kt");
        }

        @TestMetadata("WhenWithSubjectVariable_SoftModifierName.kt")
        public void testWhenWithSubjectVariable_SoftModifierName() throws Exception {
            runTest("compiler/testData/psi/WhenWithSubjectVariable_SoftModifierName.kt");
        }

        @TestMetadata("When_ERR.kt")
        public void testWhen_ERR() throws Exception {
            runTest("compiler/testData/psi/When_ERR.kt");
        }

        @TestMetadata("compiler/testData/psi/annotation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotation extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotation() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("AnnotatedExpressions.kt")
            public void testAnnotatedExpressions() throws Exception {
                runTest("compiler/testData/psi/annotation/AnnotatedExpressions.kt");
            }

            @TestMetadata("Annotations.kt")
            public void testAnnotations() throws Exception {
                runTest("compiler/testData/psi/annotation/Annotations.kt");
            }

            @TestMetadata("annotationsOnNullableTypes.kt")
            public void testAnnotationsOnNullableTypes() throws Exception {
                runTest("compiler/testData/psi/annotation/annotationsOnNullableTypes.kt");
            }

            @TestMetadata("annotationsOnParenthesizedTypes.kt")
            public void testAnnotationsOnParenthesizedTypes() throws Exception {
                runTest("compiler/testData/psi/annotation/annotationsOnParenthesizedTypes.kt");
            }

            @TestMetadata("AnnotationsOnPatterns.kt")
            public void testAnnotationsOnPatterns() throws Exception {
                runTest("compiler/testData/psi/annotation/AnnotationsOnPatterns.kt");
            }

            @TestMetadata("Annotations_ERR.kt")
            public void testAnnotations_ERR() throws Exception {
                runTest("compiler/testData/psi/annotation/Annotations_ERR.kt");
            }

            @TestMetadata("forParameters.kt")
            public void testForParameters() throws Exception {
                runTest("compiler/testData/psi/annotation/forParameters.kt");
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/testData/psi/annotation/lambda.kt");
            }

            @TestMetadata("lambdaRecovery.kt")
            public void testLambdaRecovery() throws Exception {
                runTest("compiler/testData/psi/annotation/lambdaRecovery.kt");
            }

            @TestMetadata("multiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                runTest("compiler/testData/psi/annotation/multiDeclaration.kt");
            }

            @TestMetadata("noParameterYet.kt")
            public void testNoParameterYet() throws Exception {
                runTest("compiler/testData/psi/annotation/noParameterYet.kt");
            }

            @TestMetadata("oldAnnotationsRecovery.kt")
            public void testOldAnnotationsRecovery() throws Exception {
                runTest("compiler/testData/psi/annotation/oldAnnotationsRecovery.kt");
            }

            @TestMetadata("ShortAnnotations.kt")
            public void testShortAnnotations() throws Exception {
                runTest("compiler/testData/psi/annotation/ShortAnnotations.kt");
            }

            @TestMetadata("compiler/testData/psi/annotation/at")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class At extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInAt() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/at"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("annotationAtFileStart.kt")
                public void testAnnotationAtFileStart() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/annotationAtFileStart.kt");
                }

                @TestMetadata("annotationValueArgumentsAmbiguity.kt")
                public void testAnnotationValueArgumentsAmbiguity() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/annotationValueArgumentsAmbiguity.kt");
                }

                @TestMetadata("blockLevelExpressions.kt")
                public void testBlockLevelExpressions() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/blockLevelExpressions.kt");
                }

                @TestMetadata("blockLevelExpressionsNoNewLine.kt")
                public void testBlockLevelExpressionsNoNewLine() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/blockLevelExpressionsNoNewLine.kt");
                }

                @TestMetadata("danglingBlockLevelAnnotations.kt")
                public void testDanglingBlockLevelAnnotations() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/danglingBlockLevelAnnotations.kt");
                }

                @TestMetadata("declarationsJustAtTyped.kt")
                public void testDeclarationsJustAtTyped() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/declarationsJustAtTyped.kt");
                }

                @TestMetadata("enumEntries.kt")
                public void testEnumEntries() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/enumEntries.kt");
                }

                @TestMetadata("expressionJustAtTyped.kt")
                public void testExpressionJustAtTyped() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/expressionJustAtTyped.kt");
                }

                @TestMetadata("kt21055.kt")
                public void testKt21055() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/kt21055.kt");
                }

                @TestMetadata("modifierAtFileStart.kt")
                public void testModifierAtFileStart() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/modifierAtFileStart.kt");
                }

                @TestMetadata("primaryConstructor.kt")
                public void testPrimaryConstructor() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/primaryConstructor.kt");
                }

                @TestMetadata("recoveryWhitespaceBeforeColon.kt")
                public void testRecoveryWhitespaceBeforeColon() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/recoveryWhitespaceBeforeColon.kt");
                }

                @TestMetadata("recoveryWhitespaceBeforeColon_ERR.kt")
                public void testRecoveryWhitespaceBeforeColon_ERR() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/recoveryWhitespaceBeforeColon_ERR.kt");
                }

                @TestMetadata("validDeclarations.kt")
                public void testValidDeclarations() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/validDeclarations.kt");
                }

                @TestMetadata("validExpressions.kt")
                public void testValidExpressions() throws Exception {
                    runTest("compiler/testData/psi/annotation/at/validExpressions.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/functionalTypes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunctionalTypes extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInFunctionalTypes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/functionalTypes"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("compiler/testData/psi/annotation/functionalTypes/regressionForSimilarSyntax")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class RegressionForSimilarSyntax extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInRegressionForSimilarSyntax() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/functionalTypes/regressionForSimilarSyntax"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("forDestructuring.kt")
                    public void testForDestructuring() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/regressionForSimilarSyntax/forDestructuring.kt");
                    }

                    @TestMetadata("lambdaParameterDeclaration.kt")
                    public void testLambdaParameterDeclaration() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/regressionForSimilarSyntax/lambdaParameterDeclaration.kt");
                    }

                    @TestMetadata("variableDestructuring.kt")
                    public void testVariableDestructuring() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/regressionForSimilarSyntax/variableDestructuring.kt");
                    }
                }

                @TestMetadata("compiler/testData/psi/annotation/functionalTypes/withParentheses")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class WithParentheses extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInWithParentheses() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/functionalTypes/withParentheses"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("withParameter.kt")
                    public void testWithParameter() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/withParentheses/withParameter.kt");
                    }

                    @TestMetadata("withoutParameter.kt")
                    public void testWithoutParameter() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/withParentheses/withoutParameter.kt");
                    }
                }

                @TestMetadata("compiler/testData/psi/annotation/functionalTypes/withoutParentheses")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class WithoutParentheses extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInWithoutParentheses() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/functionalTypes/withoutParentheses"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("annotationList.kt")
                    public void testAnnotationList() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/withoutParentheses/annotationList.kt");
                    }

                    @TestMetadata("withParameter.kt")
                    public void testWithParameter() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/withoutParentheses/withParameter.kt");
                    }

                    @TestMetadata("withReveiver.kt")
                    public void testWithReveiver() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/withoutParentheses/withReveiver.kt");
                    }

                    @TestMetadata("withoutParameter.kt")
                    public void testWithoutParameter() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/withoutParentheses/withoutParameter.kt");
                    }

                    @TestMetadata("withoutParameterOnSuspend.kt")
                    public void testWithoutParameterOnSuspend() throws Exception {
                        runTest("compiler/testData/psi/annotation/functionalTypes/withoutParentheses/withoutParameterOnSuspend.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/list")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class List extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInList() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/list"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("basic.kt")
                public void testBasic() throws Exception {
                    runTest("compiler/testData/psi/annotation/list/basic.kt");
                }

                @TestMetadata("recovery.kt")
                public void testRecovery() throws Exception {
                    runTest("compiler/testData/psi/annotation/list/recovery.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/modifiersMigration")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ModifiersMigration extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInModifiersMigration() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/modifiersMigration"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("newModifiers.kt")
                public void testNewModifiers() throws Exception {
                    runTest("compiler/testData/psi/annotation/modifiersMigration/newModifiers.kt");
                }

                @TestMetadata("oldUsages.kt")
                public void testOldUsages() throws Exception {
                    runTest("compiler/testData/psi/annotation/modifiersMigration/oldUsages.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/options")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Options extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInOptions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/options"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("annotationAsArg.kt")
                public void testAnnotationAsArg() throws Exception {
                    runTest("compiler/testData/psi/annotation/options/annotationAsArg.kt");
                }

                @TestMetadata("annotationAsArgComplex.kt")
                public void testAnnotationAsArgComplex() throws Exception {
                    runTest("compiler/testData/psi/annotation/options/annotationAsArgComplex.kt");
                }

                @TestMetadata("java.kt")
                public void testJava() throws Exception {
                    runTest("compiler/testData/psi/annotation/options/java.kt");
                }

                @TestMetadata("local.kt")
                public void testLocal() throws Exception {
                    runTest("compiler/testData/psi/annotation/options/local.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/targeted")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Targeted extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInTargeted() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/targeted"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("compiler/testData/psi/annotation/targeted/onField")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnField extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInOnField() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/targeted/onField"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("delegate.kt")
                    public void testDelegate() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onField/delegate.kt");
                    }

                    @TestMetadata("fqName.kt")
                    public void testFqName() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onField/fqName.kt");
                    }

                    @TestMetadata("inWrongPlace.kt")
                    public void testInWrongPlace() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onField/inWrongPlace.kt");
                    }

                    @TestMetadata("manyInOneAnnotationBlock.kt")
                    public void testManyInOneAnnotationBlock() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onField/manyInOneAnnotationBlock.kt");
                    }

                    @TestMetadata("simpleFieldAnnotation.kt")
                    public void testSimpleFieldAnnotation() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onField/simpleFieldAnnotation.kt");
                    }
                }

                @TestMetadata("compiler/testData/psi/annotation/targeted/onFile")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnFile extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInOnFile() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/targeted/onFile"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("fileAnnotationInWrongPlace.kt")
                    public void testFileAnnotationInWrongPlace() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onFile/fileAnnotationInWrongPlace.kt");
                    }

                    @TestMetadata("manyAnnotationBlocks.kt")
                    public void testManyAnnotationBlocks() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onFile/manyAnnotationBlocks.kt");
                    }

                    @TestMetadata("manyInOneAnnotationBlock.kt")
                    public void testManyInOneAnnotationBlock() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onFile/manyInOneAnnotationBlock.kt");
                    }

                    @TestMetadata("nonFIleAnnotationBeforePackage.kt")
                    public void testNonFIleAnnotationBeforePackage() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onFile/nonFIleAnnotationBeforePackage.kt");
                    }

                    @TestMetadata("single.kt")
                    public void testSingle() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onFile/single.kt");
                    }

                    @TestMetadata("withoutFileAnnotationAndPackageDeclaration.kt")
                    public void testWithoutFileAnnotationAndPackageDeclaration() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onFile/withoutFileAnnotationAndPackageDeclaration.kt");
                    }

                    @TestMetadata("withoutPackage.kt")
                    public void testWithoutPackage() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onFile/withoutPackage.kt");
                    }

                    @TestMetadata("withoutPackageWithSimpleAnnotation.kt")
                    public void testWithoutPackageWithSimpleAnnotation() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onFile/withoutPackageWithSimpleAnnotation.kt");
                    }
                }

                @TestMetadata("compiler/testData/psi/annotation/targeted/onGetSetSparam")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnGetSetSparam extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInOnGetSetSparam() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/targeted/onGetSetSparam"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("inWrongPlace.kt")
                    public void testInWrongPlace() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onGetSetSparam/inWrongPlace.kt");
                    }

                    @TestMetadata("simple.kt")
                    public void testSimple() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onGetSetSparam/simple.kt");
                    }

                    @TestMetadata("twoAnnotationLists.kt")
                    public void testTwoAnnotationLists() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onGetSetSparam/twoAnnotationLists.kt");
                    }
                }

                @TestMetadata("compiler/testData/psi/annotation/targeted/onParam")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnParam extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInOnParam() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/annotation/targeted/onParam"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("modifiers.kt")
                    public void testModifiers() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onParam/modifiers.kt");
                    }

                    @TestMetadata("recovery.kt")
                    public void testRecovery() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onParam/recovery.kt");
                    }

                    @TestMetadata("simple.kt")
                    public void testSimple() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onParam/simple.kt");
                    }

                    @TestMetadata("targetExpected.kt")
                    public void testTargetExpected() throws Exception {
                        runTest("compiler/testData/psi/annotation/targeted/onParam/targetExpected.kt");
                    }
                }
            }
        }

        @TestMetadata("compiler/testData/psi/contracts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Contracts extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInContracts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/contracts"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("FunctionWithMultilineContract.kt")
            public void testFunctionWithMultilineContract() throws Exception {
                runTest("compiler/testData/psi/contracts/FunctionWithMultilineContract.kt");
            }

            @TestMetadata("FunctionsWithTypeConstraintsAndContract.kt")
            public void testFunctionsWithTypeConstraintsAndContract() throws Exception {
                runTest("compiler/testData/psi/contracts/FunctionsWithTypeConstraintsAndContract.kt");
            }

            @TestMetadata("PropertyAccessorsContracts.kt")
            public void testPropertyAccessorsContracts() throws Exception {
                runTest("compiler/testData/psi/contracts/PropertyAccessorsContracts.kt");
            }

            @TestMetadata("SimpleFunctionWithContract.kt")
            public void testSimpleFunctionWithContract() throws Exception {
                runTest("compiler/testData/psi/contracts/SimpleFunctionWithContract.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/examples")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Examples extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInExamples() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/examples"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("AnonymousObjects.kt")
            public void testAnonymousObjects() throws Exception {
                runTest("compiler/testData/psi/examples/AnonymousObjects.kt");
            }

            @TestMetadata("BinaryTree.kt")
            public void testBinaryTree() throws Exception {
                runTest("compiler/testData/psi/examples/BinaryTree.kt");
            }

            @TestMetadata("BitArith.kt")
            public void testBitArith() throws Exception {
                runTest("compiler/testData/psi/examples/BitArith.kt");
            }

            @TestMetadata("Builder.kt")
            public void testBuilder() throws Exception {
                runTest("compiler/testData/psi/examples/Builder.kt");
            }

            @TestMetadata("Color.kt")
            public void testColor() throws Exception {
                runTest("compiler/testData/psi/examples/Color.kt");
            }

            @TestMetadata("FunctionsAndTypes.kt")
            public void testFunctionsAndTypes() throws Exception {
                runTest("compiler/testData/psi/examples/FunctionsAndTypes.kt");
            }

            @TestMetadata("Graph.kt")
            public void testGraph() throws Exception {
                runTest("compiler/testData/psi/examples/Graph.kt");
            }

            @TestMetadata("IPushPop.kt")
            public void testIPushPop() throws Exception {
                runTest("compiler/testData/psi/examples/IPushPop.kt");
            }

            @TestMetadata("LINQ.kt")
            public void testLINQ() throws Exception {
                runTest("compiler/testData/psi/examples/LINQ.kt");
            }

            @TestMetadata("Queue.kt")
            public void testQueue() throws Exception {
                runTest("compiler/testData/psi/examples/Queue.kt");
            }

            @TestMetadata("Stack.kt")
            public void testStack() throws Exception {
                runTest("compiler/testData/psi/examples/Stack.kt");
            }

            @TestMetadata("UnionFind.kt")
            public void testUnionFind() throws Exception {
                runTest("compiler/testData/psi/examples/UnionFind.kt");
            }

            @TestMetadata("UpdateOperation.kt")
            public void testUpdateOperation() throws Exception {
                runTest("compiler/testData/psi/examples/UpdateOperation.kt");
            }

            @TestMetadata("With.kt")
            public void testWith() throws Exception {
                runTest("compiler/testData/psi/examples/With.kt");
            }

            @TestMetadata("compiler/testData/psi/examples/array")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Array extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInArray() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/examples/array"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("MutableArray.kt")
                public void testMutableArray() throws Exception {
                    runTest("compiler/testData/psi/examples/array/MutableArray.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/examples/collections")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Collections extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInCollections() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/examples/collections"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("ArrayList.kt")
                public void testArrayList() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/ArrayList.kt");
                }

                @TestMetadata("HashMap.kt")
                public void testHashMap() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/HashMap.kt");
                }

                @TestMetadata("IIterable.kt")
                public void testIIterable() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/IIterable.kt");
                }

                @TestMetadata("IIterator.kt")
                public void testIIterator() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/IIterator.kt");
                }

                @TestMetadata("IList.kt")
                public void testIList() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/IList.kt");
                }

                @TestMetadata("IMutableIterable.kt")
                public void testIMutableIterable() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/IMutableIterable.kt");
                }

                @TestMetadata("IMutableIterator.kt")
                public void testIMutableIterator() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/IMutableIterator.kt");
                }

                @TestMetadata("IMutableList.kt")
                public void testIMutableList() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/IMutableList.kt");
                }

                @TestMetadata("IMutableSet.kt")
                public void testIMutableSet() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/IMutableSet.kt");
                }

                @TestMetadata("ISet.kt")
                public void testISet() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/ISet.kt");
                }

                @TestMetadata("ISized.kt")
                public void testISized() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/ISized.kt");
                }

                @TestMetadata("LinkedList.kt")
                public void testLinkedList() throws Exception {
                    runTest("compiler/testData/psi/examples/collections/LinkedList.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/examples/io")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Io extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInIo() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/examples/io"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("IOSamples.kt")
                public void testIOSamples() throws Exception {
                    runTest("compiler/testData/psi/examples/io/IOSamples.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/examples/map")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Map extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInMap() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/examples/map"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("IMap.kt")
                public void testIMap() throws Exception {
                    runTest("compiler/testData/psi/examples/map/IMap.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/examples/priorityqueues")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Priorityqueues extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInPriorityqueues() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/examples/priorityqueues"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("BinaryHeap.kt")
                public void testBinaryHeap() throws Exception {
                    runTest("compiler/testData/psi/examples/priorityqueues/BinaryHeap.kt");
                }

                @TestMetadata("IPriorityQueue.kt")
                public void testIPriorityQueue() throws Exception {
                    runTest("compiler/testData/psi/examples/priorityqueues/IPriorityQueue.kt");
                }

                @TestMetadata("PriorityQueueAsPushPop.kt")
                public void testPriorityQueueAsPushPop() throws Exception {
                    runTest("compiler/testData/psi/examples/priorityqueues/PriorityQueueAsPushPop.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/examples/util")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Util extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInUtil() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/examples/util"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("Comparison.kt")
                public void testComparison() throws Exception {
                    runTest("compiler/testData/psi/examples/util/Comparison.kt");
                }

                @TestMetadata("IComparable.kt")
                public void testIComparable() throws Exception {
                    runTest("compiler/testData/psi/examples/util/IComparable.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/psi/functionReceivers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionReceivers extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/functionReceivers"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("FunctionTypesWithFunctionReceivers.kt")
            public void testFunctionTypesWithFunctionReceivers() throws Exception {
                runTest("compiler/testData/psi/functionReceivers/FunctionTypesWithFunctionReceivers.kt");
            }

            @TestMetadata("FunctionsWithFunctionReceivers.kt")
            public void testFunctionsWithFunctionReceivers() throws Exception {
                runTest("compiler/testData/psi/functionReceivers/FunctionsWithFunctionReceivers.kt");
            }

            @TestMetadata("FunctionsWithFunctionReceiversAnnotations.kt")
            public void testFunctionsWithFunctionReceiversAnnotations() throws Exception {
                runTest("compiler/testData/psi/functionReceivers/FunctionsWithFunctionReceiversAnnotations.kt");
            }

            @TestMetadata("FunctionsWithFunctionReceiversRecovery.kt")
            public void testFunctionsWithFunctionReceiversRecovery() throws Exception {
                runTest("compiler/testData/psi/functionReceivers/FunctionsWithFunctionReceiversRecovery.kt");
            }

            @TestMetadata("PropertiesWithFunctionReceivers.kt")
            public void testPropertiesWithFunctionReceivers() throws Exception {
                runTest("compiler/testData/psi/functionReceivers/PropertiesWithFunctionReceivers.kt");
            }

            @TestMetadata("PropertiesWithFunctionReceiversAnnotations.kt")
            public void testPropertiesWithFunctionReceiversAnnotations() throws Exception {
                runTest("compiler/testData/psi/functionReceivers/PropertiesWithFunctionReceiversAnnotations.kt");
            }

            @TestMetadata("PropertiesWithFunctionReceiversRecovery.kt")
            public void testPropertiesWithFunctionReceiversRecovery() throws Exception {
                runTest("compiler/testData/psi/functionReceivers/PropertiesWithFunctionReceiversRecovery.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/greatSyntacticShift")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class GreatSyntacticShift extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInGreatSyntacticShift() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/greatSyntacticShift"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("functionLiterals.kt")
            public void testFunctionLiterals() throws Exception {
                runTest("compiler/testData/psi/greatSyntacticShift/functionLiterals.kt");
            }

            @TestMetadata("functionTypes.kt")
            public void testFunctionTypes() throws Exception {
                runTest("compiler/testData/psi/greatSyntacticShift/functionTypes.kt");
            }

            @TestMetadata("FunctionTypesAsArguments.kt")
            public void testFunctionTypesAsArguments() throws Exception {
                runTest("compiler/testData/psi/greatSyntacticShift/FunctionTypesAsArguments.kt");
            }

            @TestMetadata("nullableTypes.kt")
            public void testNullableTypes() throws Exception {
                runTest("compiler/testData/psi/greatSyntacticShift/nullableTypes.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/kdoc")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Kdoc extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInKdoc() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/kdoc"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("AtTags.kt")
            public void testAtTags() throws Exception {
                runTest("compiler/testData/psi/kdoc/AtTags.kt");
            }

            @TestMetadata("DocCommentAtBeginningOfFile1.kt")
            public void testDocCommentAtBeginningOfFile1() throws Exception {
                runTest("compiler/testData/psi/kdoc/DocCommentAtBeginningOfFile1.kt");
            }

            @TestMetadata("DocCommentAtBeginningOfFile2.kt")
            public void testDocCommentAtBeginningOfFile2() throws Exception {
                runTest("compiler/testData/psi/kdoc/DocCommentAtBeginningOfFile2.kt");
            }

            @TestMetadata("DocCommentAtBeginningOfFile3.kt")
            public void testDocCommentAtBeginningOfFile3() throws Exception {
                runTest("compiler/testData/psi/kdoc/DocCommentAtBeginningOfFile3.kt");
            }

            @TestMetadata("DocCommentAtBeginningOfFile4.kt")
            public void testDocCommentAtBeginningOfFile4() throws Exception {
                runTest("compiler/testData/psi/kdoc/DocCommentAtBeginningOfFile4.kt");
            }

            @TestMetadata("EndOnLeadingAsterisks.kt")
            public void testEndOnLeadingAsterisks() throws Exception {
                runTest("compiler/testData/psi/kdoc/EndOnLeadingAsterisks.kt");
            }

            @TestMetadata("EndRightAfterText.kt")
            public void testEndRightAfterText() throws Exception {
                runTest("compiler/testData/psi/kdoc/EndRightAfterText.kt");
            }

            @TestMetadata("HttpLink.kt")
            public void testHttpLink() throws Exception {
                runTest("compiler/testData/psi/kdoc/HttpLink.kt");
            }

            @TestMetadata("Incomplete.kt")
            public void testIncomplete() throws Exception {
                runTest("compiler/testData/psi/kdoc/Incomplete.kt");
            }

            @TestMetadata("Markdown.kt")
            public void testMarkdown() throws Exception {
                runTest("compiler/testData/psi/kdoc/Markdown.kt");
            }

            @TestMetadata("MarkdownLinkWithError.kt")
            public void testMarkdownLinkWithError() throws Exception {
                runTest("compiler/testData/psi/kdoc/MarkdownLinkWithError.kt");
            }

            @TestMetadata("MarkdownLinkWithLabel.kt")
            public void testMarkdownLinkWithLabel() throws Exception {
                runTest("compiler/testData/psi/kdoc/MarkdownLinkWithLabel.kt");
            }

            @TestMetadata("MarkdownQualifiedName.kt")
            public void testMarkdownQualifiedName() throws Exception {
                runTest("compiler/testData/psi/kdoc/MarkdownQualifiedName.kt");
            }

            @TestMetadata("ParamTag.kt")
            public void testParamTag() throws Exception {
                runTest("compiler/testData/psi/kdoc/ParamTag.kt");
            }

            @TestMetadata("ParamTagAtStart.kt")
            public void testParamTagAtStart() throws Exception {
                runTest("compiler/testData/psi/kdoc/ParamTagAtStart.kt");
            }

            @TestMetadata("ReturnWithBrackets.kt")
            public void testReturnWithBrackets() throws Exception {
                runTest("compiler/testData/psi/kdoc/ReturnWithBrackets.kt");
            }

            @TestMetadata("Sections.kt")
            public void testSections() throws Exception {
                runTest("compiler/testData/psi/kdoc/Sections.kt");
            }

            @TestMetadata("SeeEmpty.kt")
            public void testSeeEmpty() throws Exception {
                runTest("compiler/testData/psi/kdoc/SeeEmpty.kt");
            }

            @TestMetadata("SeeLink.kt")
            public void testSeeLink() throws Exception {
                runTest("compiler/testData/psi/kdoc/SeeLink.kt");
            }

            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/psi/kdoc/Simple.kt");
            }

            @TestMetadata("TextRightAfterLeadAsterisks.kt")
            public void testTextRightAfterLeadAsterisks() throws Exception {
                runTest("compiler/testData/psi/kdoc/TextRightAfterLeadAsterisks.kt");
            }

            @TestMetadata("TwoTags.kt")
            public void testTwoTags() throws Exception {
                runTest("compiler/testData/psi/kdoc/TwoTags.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/newLabels")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NewLabels extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInNewLabels() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/newLabels"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                runTest("compiler/testData/psi/newLabels/basic.kt");
            }

            @TestMetadata("oldSyntaxExpressions.kt")
            public void testOldSyntaxExpressions() throws Exception {
                runTest("compiler/testData/psi/newLabels/oldSyntaxExpressions.kt");
            }

            @TestMetadata("recovery.kt")
            public void testRecovery() throws Exception {
                runTest("compiler/testData/psi/newLabels/recovery.kt");
            }

            @TestMetadata("spaceBeforeLabelReference.kt")
            public void testSpaceBeforeLabelReference() throws Exception {
                runTest("compiler/testData/psi/newLabels/spaceBeforeLabelReference.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/packages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Packages extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInPackages() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/packages"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("PackageBlockFirst.kt")
            public void testPackageBlockFirst() throws Exception {
                runTest("compiler/testData/psi/packages/PackageBlockFirst.kt");
            }

            @TestMetadata("PackageLeadingDotDoubleID.kt")
            public void testPackageLeadingDotDoubleID() throws Exception {
                runTest("compiler/testData/psi/packages/PackageLeadingDotDoubleID.kt");
            }

            @TestMetadata("PackageLongNameBetweenDots.kt")
            public void testPackageLongNameBetweenDots() throws Exception {
                runTest("compiler/testData/psi/packages/PackageLongNameBetweenDots.kt");
            }

            @TestMetadata("PackageLongNameDoubleID.kt")
            public void testPackageLongNameDoubleID() throws Exception {
                runTest("compiler/testData/psi/packages/PackageLongNameDoubleID.kt");
            }

            @TestMetadata("PackageLongNameLeadingDot.kt")
            public void testPackageLongNameLeadingDot() throws Exception {
                runTest("compiler/testData/psi/packages/PackageLongNameLeadingDot.kt");
            }

            @TestMetadata("PackageLongNameLeadingDoubleDot.kt")
            public void testPackageLongNameLeadingDoubleDot() throws Exception {
                runTest("compiler/testData/psi/packages/PackageLongNameLeadingDoubleDot.kt");
            }

            @TestMetadata("PackageModifiers.kt")
            public void testPackageModifiers() throws Exception {
                runTest("compiler/testData/psi/packages/PackageModifiers.kt");
            }

            @TestMetadata("PackageNameDoubleDot.kt")
            public void testPackageNameDoubleDot() throws Exception {
                runTest("compiler/testData/psi/packages/PackageNameDoubleDot.kt");
            }

            @TestMetadata("PackageNameJustDot.kt")
            public void testPackageNameJustDot() throws Exception {
                runTest("compiler/testData/psi/packages/PackageNameJustDot.kt");
            }

            @TestMetadata("PackageSimpleNameLeadingDot.kt")
            public void testPackageSimpleNameLeadingDot() throws Exception {
                runTest("compiler/testData/psi/packages/PackageSimpleNameLeadingDot.kt");
            }

            @TestMetadata("PackageSimpleNameLeadingDoubleDot.kt")
            public void testPackageSimpleNameLeadingDoubleDot() throws Exception {
                runTest("compiler/testData/psi/packages/PackageSimpleNameLeadingDoubleDot.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/platformTypesRecovery")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PlatformTypesRecovery extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInPlatformTypesRecovery() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/platformTypesRecovery"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("Array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/Array.kt");
            }

            @TestMetadata("BeforeDot.kt")
            public void testBeforeDot() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/BeforeDot.kt");
            }

            @TestMetadata("Collections.kt")
            public void testCollections() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/Collections.kt");
            }

            @TestMetadata("FunctionsNotPlatform.kt")
            public void testFunctionsNotPlatform() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/FunctionsNotPlatform.kt");
            }

            @TestMetadata("MapEntry.kt")
            public void testMapEntry() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/MapEntry.kt");
            }

            @TestMetadata("ParenthesizedNotPlatform.kt")
            public void testParenthesizedNotPlatform() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/ParenthesizedNotPlatform.kt");
            }

            @TestMetadata("Qualified.kt")
            public void testQualified() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/Qualified.kt");
            }

            @TestMetadata("QualifiedCollections.kt")
            public void testQualifiedCollections() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/QualifiedCollections.kt");
            }

            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/Simple.kt");
            }

            @TestMetadata("WrongWordInParentheses.kt")
            public void testWrongWordInParentheses() throws Exception {
                runTest("compiler/testData/psi/platformTypesRecovery/WrongWordInParentheses.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/primaryConstructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PrimaryConstructor extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInPrimaryConstructor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/primaryConstructor"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/psi/primaryConstructor/local.kt");
            }

            @TestMetadata("nestedClassAmbiguity.kt")
            public void testNestedClassAmbiguity() throws Exception {
                runTest("compiler/testData/psi/primaryConstructor/nestedClassAmbiguity.kt");
            }

            @TestMetadata("recovery.kt")
            public void testRecovery() throws Exception {
                runTest("compiler/testData/psi/primaryConstructor/recovery.kt");
            }

            @TestMetadata("recoveryNestedClassAmbiguity.kt")
            public void testRecoveryNestedClassAmbiguity() throws Exception {
                runTest("compiler/testData/psi/primaryConstructor/recoveryNestedClassAmbiguity.kt");
            }

            @TestMetadata("valid.kt")
            public void testValid() throws Exception {
                runTest("compiler/testData/psi/primaryConstructor/valid.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/propertyBackingField")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyBackingField extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInPropertyBackingField() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/propertyBackingField"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("explicitBackingField.kt")
            public void testExplicitBackingField() throws Exception {
                runTest("compiler/testData/psi/propertyBackingField/explicitBackingField.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/propertyDelegate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyDelegate extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInPropertyDelegate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/propertyDelegate"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("BracketsInDelegate.kt")
            public void testBracketsInDelegate() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/BracketsInDelegate.kt");
            }

            @TestMetadata("DelegateAndInitializer.kt")
            public void testDelegateAndInitializer() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/DelegateAndInitializer.kt");
            }

            @TestMetadata("GetterInSameLine.kt")
            public void testGetterInSameLine() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/GetterInSameLine.kt");
            }

            @TestMetadata("LocalProperty.kt")
            public void testLocalProperty() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/LocalProperty.kt");
            }

            @TestMetadata("OnlyBy.kt")
            public void testOnlyBy() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/OnlyBy.kt");
            }

            @TestMetadata("PropertyInClass.kt")
            public void testPropertyInClass() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/PropertyInClass.kt");
            }

            @TestMetadata("PropertyWithGetter.kt")
            public void testPropertyWithGetter() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/PropertyWithGetter.kt");
            }

            @TestMetadata("PropertyWithInitializer.kt")
            public void testPropertyWithInitializer() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/PropertyWithInitializer.kt");
            }

            @TestMetadata("PropertyWithoutTypeRef.kt")
            public void testPropertyWithoutTypeRef() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/PropertyWithoutTypeRef.kt");
            }

            @TestMetadata("TopLevelProperty.kt")
            public void testTopLevelProperty() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/TopLevelProperty.kt");
            }

            @TestMetadata("TwoProperties.kt")
            public void testTwoProperties() throws Exception {
                runTest("compiler/testData/psi/propertyDelegate/TwoProperties.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/recovery")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Recovery extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            @TestMetadata("AbsentLeftHandSide.kt")
            public void testAbsentLeftHandSide() throws Exception {
                runTest("compiler/testData/psi/recovery/AbsentLeftHandSide.kt");
            }

            public void testAllFilesPresentInRecovery() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/recovery"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("BareVal.kt")
            public void testBareVal() throws Exception {
                runTest("compiler/testData/psi/recovery/BareVal.kt");
            }

            @TestMetadata("BrokenFunctionSuperType.kt")
            public void testBrokenFunctionSuperType() throws Exception {
                runTest("compiler/testData/psi/recovery/BrokenFunctionSuperType.kt");
            }

            @TestMetadata("CatchKeywordRBrace.kt")
            public void testCatchKeywordRBrace() throws Exception {
                runTest("compiler/testData/psi/recovery/CatchKeywordRBrace.kt");
            }

            @TestMetadata("CloseBraceAtTopLevel.kt")
            public void testCloseBraceAtTopLevel() throws Exception {
                runTest("compiler/testData/psi/recovery/CloseBraceAtTopLevel.kt");
            }

            @TestMetadata("DeclarationAfterDotSelectorExpected.kt")
            public void testDeclarationAfterDotSelectorExpected() throws Exception {
                runTest("compiler/testData/psi/recovery/DeclarationAfterDotSelectorExpected.kt");
            }

            @TestMetadata("DeclarationAfterIncompleteElvis.kt")
            public void testDeclarationAfterIncompleteElvis() throws Exception {
                runTest("compiler/testData/psi/recovery/DeclarationAfterIncompleteElvis.kt");
            }

            @TestMetadata("DoWhileWithEmptyCondition.kt")
            public void testDoWhileWithEmptyCondition() throws Exception {
                runTest("compiler/testData/psi/recovery/DoWhileWithEmptyCondition.kt");
            }

            @TestMetadata("DoWhileWithoutLPar.kt")
            public void testDoWhileWithoutLPar() throws Exception {
                runTest("compiler/testData/psi/recovery/DoWhileWithoutLPar.kt");
            }

            @TestMetadata("enumWthoutClass.kt")
            public void testEnumWthoutClass() throws Exception {
                runTest("compiler/testData/psi/recovery/enumWthoutClass.kt");
            }

            @TestMetadata("ForEmptyParentheses.kt")
            public void testForEmptyParentheses() throws Exception {
                runTest("compiler/testData/psi/recovery/ForEmptyParentheses.kt");
            }

            @TestMetadata("ForEmptyWithoutBody.kt")
            public void testForEmptyWithoutBody() throws Exception {
                runTest("compiler/testData/psi/recovery/ForEmptyWithoutBody.kt");
            }

            @TestMetadata("ForNoBodyBeforeRBrace.kt")
            public void testForNoBodyBeforeRBrace() throws Exception {
                runTest("compiler/testData/psi/recovery/ForNoBodyBeforeRBrace.kt");
            }

            @TestMetadata("ForRecovery.kt")
            public void testForRecovery() throws Exception {
                runTest("compiler/testData/psi/recovery/ForRecovery.kt");
            }

            @TestMetadata("ForWithOnlyOneLParInEOF.kt")
            public void testForWithOnlyOneLParInEOF() throws Exception {
                runTest("compiler/testData/psi/recovery/ForWithOnlyOneLParInEOF.kt");
            }

            @TestMetadata("ForWithoutBodyInEOF.kt")
            public void testForWithoutBodyInEOF() throws Exception {
                runTest("compiler/testData/psi/recovery/ForWithoutBodyInEOF.kt");
            }

            @TestMetadata("ForWithoutLPar.kt")
            public void testForWithoutLPar() throws Exception {
                runTest("compiler/testData/psi/recovery/ForWithoutLPar.kt");
            }

            @TestMetadata("ForWithoutLParInEOF.kt")
            public void testForWithoutLParInEOF() throws Exception {
                runTest("compiler/testData/psi/recovery/ForWithoutLParInEOF.kt");
            }

            @TestMetadata("ForWithoutParamButWithRange.kt")
            public void testForWithoutParamButWithRange() throws Exception {
                runTest("compiler/testData/psi/recovery/ForWithoutParamButWithRange.kt");
            }

            @TestMetadata("ForWithoutRange.kt")
            public void testForWithoutRange() throws Exception {
                runTest("compiler/testData/psi/recovery/ForWithoutRange.kt");
            }

            @TestMetadata("FunFun.kt")
            public void testFunFun() throws Exception {
                runTest("compiler/testData/psi/recovery/FunFun.kt");
            }

            @TestMetadata("IfKeywordRBrace.kt")
            public void testIfKeywordRBrace() throws Exception {
                runTest("compiler/testData/psi/recovery/IfKeywordRBrace.kt");
            }

            @TestMetadata("IfWithEmptyCondition.kt")
            public void testIfWithEmptyCondition() throws Exception {
                runTest("compiler/testData/psi/recovery/IfWithEmptyCondition.kt");
            }

            @TestMetadata("IfWithoutLPar.kt")
            public void testIfWithoutLPar() throws Exception {
                runTest("compiler/testData/psi/recovery/IfWithoutLPar.kt");
            }

            @TestMetadata("ImportRecovery.kt")
            public void testImportRecovery() throws Exception {
                runTest("compiler/testData/psi/recovery/ImportRecovery.kt");
            }

            @TestMetadata("importsWithConflict.kt")
            public void testImportsWithConflict() throws Exception {
                runTest("compiler/testData/psi/recovery/importsWithConflict.kt");
            }

            @TestMetadata("IncompleteAccessor1.kt")
            public void testIncompleteAccessor1() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteAccessor1.kt");
            }

            @TestMetadata("IncompleteAccessor2.kt")
            public void testIncompleteAccessor2() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteAccessor2.kt");
            }

            @TestMetadata("IncompleteClassDeclaration.kt")
            public void testIncompleteClassDeclaration() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteClassDeclaration.kt");
            }

            @TestMetadata("IncompleteClassTypeParameters.kt")
            public void testIncompleteClassTypeParameters() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteClassTypeParameters.kt");
            }

            @TestMetadata("IncompleteForRBrace.kt")
            public void testIncompleteForRBrace() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteForRBrace.kt");
            }

            @TestMetadata("IncompleteFun.kt")
            public void testIncompleteFun() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteFun.kt");
            }

            @TestMetadata("IncompleteFunDeclaration.kt")
            public void testIncompleteFunDeclaration() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteFunDeclaration.kt");
            }

            @TestMetadata("IncompleteFunTypeParameters.kt")
            public void testIncompleteFunTypeParameters() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteFunTypeParameters.kt");
            }

            @TestMetadata("IncompleteTypeParameters.kt")
            public void testIncompleteTypeParameters() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteTypeParameters.kt");
            }

            @TestMetadata("IncompleteTypeRefWithPackageKeyword.kt")
            public void testIncompleteTypeRefWithPackageKeyword() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteTypeRefWithPackageKeyword.kt");
            }

            @TestMetadata("IncompleteValTypeParameters.kt")
            public void testIncompleteValTypeParameters() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteValTypeParameters.kt");
            }

            @TestMetadata("IncompleteWhenElse.kt")
            public void testIncompleteWhenElse() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteWhenElse.kt");
            }

            @TestMetadata("IncompleteWhere.kt")
            public void testIncompleteWhere() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteWhere.kt");
            }

            @TestMetadata("IncompleteWhere2.kt")
            public void testIncompleteWhere2() throws Exception {
                runTest("compiler/testData/psi/recovery/IncompleteWhere2.kt");
            }

            @TestMetadata("initRecovery.kt")
            public void testInitRecovery() throws Exception {
                runTest("compiler/testData/psi/recovery/initRecovery.kt");
            }

            @TestMetadata("InterfaceInExpressionPosition.kt")
            public void testInterfaceInExpressionPosition() throws Exception {
                runTest("compiler/testData/psi/recovery/InterfaceInExpressionPosition.kt");
            }

            @TestMetadata("InvalidCharAfterPropertyName.kt")
            public void testInvalidCharAfterPropertyName() throws Exception {
                runTest("compiler/testData/psi/recovery/InvalidCharAfterPropertyName.kt");
            }

            @TestMetadata("InvalidCharInSingleLineLambda.kt")
            public void testInvalidCharInSingleLineLambda() throws Exception {
                runTest("compiler/testData/psi/recovery/InvalidCharInSingleLineLambda.kt");
            }

            @TestMetadata("kt2172.kt")
            public void testKt2172() throws Exception {
                runTest("compiler/testData/psi/recovery/kt2172.kt");
            }

            @TestMetadata("kt24158.kt")
            public void testKt24158() throws Exception {
                runTest("compiler/testData/psi/recovery/kt24158.kt");
            }

            @TestMetadata("kt5102.kt")
            public void testKt5102() throws Exception {
                runTest("compiler/testData/psi/recovery/kt5102.kt");
            }

            @TestMetadata("lambdaExpressionInString_1.kt")
            public void testLambdaExpressionInString_1() throws Exception {
                runTest("compiler/testData/psi/recovery/lambdaExpressionInString_1.kt");
            }

            @TestMetadata("lambdaExpressionInString_2.kt")
            public void testLambdaExpressionInString_2() throws Exception {
                runTest("compiler/testData/psi/recovery/lambdaExpressionInString_2.kt");
            }

            @TestMetadata("MissingCommaInConstructorValueParameterList.kt")
            public void testMissingCommaInConstructorValueParameterList() throws Exception {
                runTest("compiler/testData/psi/recovery/MissingCommaInConstructorValueParameterList.kt");
            }

            @TestMetadata("MissingCommaInValueArgumentList.kt")
            public void testMissingCommaInValueArgumentList() throws Exception {
                runTest("compiler/testData/psi/recovery/MissingCommaInValueArgumentList.kt");
            }

            @TestMetadata("MissingCommaInValueParameterList.kt")
            public void testMissingCommaInValueParameterList() throws Exception {
                runTest("compiler/testData/psi/recovery/MissingCommaInValueParameterList.kt");
            }

            @TestMetadata("MissingCommaInValueParameterListWithValOrVar.kt")
            public void testMissingCommaInValueParameterListWithValOrVar() throws Exception {
                runTest("compiler/testData/psi/recovery/MissingCommaInValueParameterListWithValOrVar.kt");
            }

            @TestMetadata("NoArrowInWhen.kt")
            public void testNoArrowInWhen() throws Exception {
                runTest("compiler/testData/psi/recovery/NoArrowInWhen.kt");
            }

            @TestMetadata("NoGTInTypeArguments.kt")
            public void testNoGTInTypeArguments() throws Exception {
                runTest("compiler/testData/psi/recovery/NoGTInTypeArguments.kt");
            }

            @TestMetadata("PackageNewLineRecovery.kt")
            public void testPackageNewLineRecovery() throws Exception {
                runTest("compiler/testData/psi/recovery/PackageNewLineRecovery.kt");
            }

            @TestMetadata("PackageRecovery.kt")
            public void testPackageRecovery() throws Exception {
                runTest("compiler/testData/psi/recovery/PackageRecovery.kt");
            }

            @TestMetadata("SameLineStatementRecovery.kt")
            public void testSameLineStatementRecovery() throws Exception {
                runTest("compiler/testData/psi/recovery/SameLineStatementRecovery.kt");
            }

            @TestMetadata("UnfinishedExtension.kt")
            public void testUnfinishedExtension() throws Exception {
                runTest("compiler/testData/psi/recovery/UnfinishedExtension.kt");
            }

            @TestMetadata("ValNoName.kt")
            public void testValNoName() throws Exception {
                runTest("compiler/testData/psi/recovery/ValNoName.kt");
            }

            @TestMetadata("ValWithNoNameBeforeNextDeclarationWithModifiers.kt")
            public void testValWithNoNameBeforeNextDeclarationWithModifiers() throws Exception {
                runTest("compiler/testData/psi/recovery/ValWithNoNameBeforeNextDeclarationWithModifiers.kt");
            }

            @TestMetadata("ValWithNoNameInBlock.kt")
            public void testValWithNoNameInBlock() throws Exception {
                runTest("compiler/testData/psi/recovery/ValWithNoNameInBlock.kt");
            }

            @TestMetadata("ValueParameterNoTypeRecovery.kt")
            public void testValueParameterNoTypeRecovery() throws Exception {
                runTest("compiler/testData/psi/recovery/ValueParameterNoTypeRecovery.kt");
            }

            @TestMetadata("valueParameterRecovery.kt")
            public void testValueParameterRecovery() throws Exception {
                runTest("compiler/testData/psi/recovery/valueParameterRecovery.kt");
            }

            @TestMetadata("valueParameterRecoveryWithTypes.kt")
            public void testValueParameterRecoveryWithTypes() throws Exception {
                runTest("compiler/testData/psi/recovery/valueParameterRecoveryWithTypes.kt");
            }

            @TestMetadata("WhenWithoutBraces.kt")
            public void testWhenWithoutBraces() throws Exception {
                runTest("compiler/testData/psi/recovery/WhenWithoutBraces.kt");
            }

            @TestMetadata("WhileWithEmptyCondition.kt")
            public void testWhileWithEmptyCondition() throws Exception {
                runTest("compiler/testData/psi/recovery/WhileWithEmptyCondition.kt");
            }

            @TestMetadata("WhileWithoutLPar.kt")
            public void testWhileWithoutLPar() throws Exception {
                runTest("compiler/testData/psi/recovery/WhileWithoutLPar.kt");
            }

            @TestMetadata("WithWithoutInAndMultideclaration.kt")
            public void testWithWithoutInAndMultideclaration() throws Exception {
                runTest("compiler/testData/psi/recovery/WithWithoutInAndMultideclaration.kt");
            }

            @TestMetadata("compiler/testData/psi/recovery/objects")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Objects extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInObjects() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/recovery/objects"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("compiler/testData/psi/recovery/objects/declarations")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Declarations extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInDeclarations() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/recovery/objects/declarations"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("ConstructorModifiers.kt")
                    public void testConstructorModifiers() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/declarations/ConstructorModifiers.kt");
                    }

                    @TestMetadata("EmptyParentheses.kt")
                    public void testEmptyParentheses() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/declarations/EmptyParentheses.kt");
                    }

                    @TestMetadata("Everything.kt")
                    public void testEverything() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/declarations/Everything.kt");
                    }

                    @TestMetadata("FollowedByModifiers.kt")
                    public void testFollowedByModifiers() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/declarations/FollowedByModifiers.kt");
                    }

                    @TestMetadata("ParametersInParentheses.kt")
                    public void testParametersInParentheses() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/declarations/ParametersInParentheses.kt");
                    }

                    @TestMetadata("TypeParametersAndParentheses.kt")
                    public void testTypeParametersAndParentheses() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/declarations/TypeParametersAndParentheses.kt");
                    }

                    @TestMetadata("TypeParameterss.kt")
                    public void testTypeParameterss() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/declarations/TypeParameterss.kt");
                    }

                    @TestMetadata("Where.kt")
                    public void testWhere() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/declarations/Where.kt");
                    }
                }

                @TestMetadata("compiler/testData/psi/recovery/objects/expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Expressions extends AbstractParsingTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                    }

                    public void testAllFilesPresentInExpressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/recovery/objects/expressions"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                    }

                    @TestMetadata("ConstructorModifiers.kt")
                    public void testConstructorModifiers() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/ConstructorModifiers.kt");
                    }

                    @TestMetadata("ConstructorModifiersAndName.kt")
                    public void testConstructorModifiersAndName() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/ConstructorModifiersAndName.kt");
                    }

                    @TestMetadata("EmptyParentheses.kt")
                    public void testEmptyParentheses() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/EmptyParentheses.kt");
                    }

                    @TestMetadata("Everything.kt")
                    public void testEverything() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/Everything.kt");
                    }

                    @TestMetadata("InFunction.kt")
                    public void testInFunction() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/InFunction.kt");
                    }

                    @TestMetadata("ParametersInParentheses.kt")
                    public void testParametersInParentheses() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/ParametersInParentheses.kt");
                    }

                    @TestMetadata("TypeParametersAndParentheses.kt")
                    public void testTypeParametersAndParentheses() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/TypeParametersAndParentheses.kt");
                    }

                    @TestMetadata("TypeParameterss.kt")
                    public void testTypeParameterss() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/TypeParameterss.kt");
                    }

                    @TestMetadata("Where.kt")
                    public void testWhere() throws Exception {
                        runTest("compiler/testData/psi/recovery/objects/expressions/Where.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/psi/recovery/qualifiedExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class QualifiedExpression extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInQualifiedExpression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/recovery/qualifiedExpression"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("noQualifiedExpression.kt")
                public void testNoQualifiedExpression() throws Exception {
                    runTest("compiler/testData/psi/recovery/qualifiedExpression/noQualifiedExpression.kt");
                }

                @TestMetadata("noSafeQualifiedExpression.kt")
                public void testNoSafeQualifiedExpression() throws Exception {
                    runTest("compiler/testData/psi/recovery/qualifiedExpression/noSafeQualifiedExpression.kt");
                }

                @TestMetadata("qualifiedExpressionWithSelector.kt")
                public void testQualifiedExpressionWithSelector() throws Exception {
                    runTest("compiler/testData/psi/recovery/qualifiedExpression/qualifiedExpressionWithSelector.kt");
                }

                @TestMetadata("qualifiedExpressionWithoutSelector.kt")
                public void testQualifiedExpressionWithoutSelector() throws Exception {
                    runTest("compiler/testData/psi/recovery/qualifiedExpression/qualifiedExpressionWithoutSelector.kt");
                }

                @TestMetadata("safeQualifiedExpressionWithSelector.kt")
                public void testSafeQualifiedExpressionWithSelector() throws Exception {
                    runTest("compiler/testData/psi/recovery/qualifiedExpression/safeQualifiedExpressionWithSelector.kt");
                }

                @TestMetadata("safeQualifiedExpressionWithoutSelector.kt")
                public void testSafeQualifiedExpressionWithoutSelector() throws Exception {
                    runTest("compiler/testData/psi/recovery/qualifiedExpression/safeQualifiedExpressionWithoutSelector.kt");
                }
            }

            @TestMetadata("compiler/testData/psi/recovery/unnamedParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UnnamedParameter extends AbstractParsingTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
                }

                public void testAllFilesPresentInUnnamedParameter() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/recovery/unnamedParameter"), Pattern.compile("^(.*)\\.kts?$"), null, true);
                }

                @TestMetadata("firstInFunction.kt")
                public void testFirstInFunction() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/firstInFunction.kt");
                }

                @TestMetadata("firstInFunctionalType.kt")
                public void testFirstInFunctionalType() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/firstInFunctionalType.kt");
                }

                @TestMetadata("firstInLambda.kt")
                public void testFirstInLambda() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/firstInLambda.kt");
                }

                @TestMetadata("firstInPrimaryConstructor.kt")
                public void testFirstInPrimaryConstructor() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/firstInPrimaryConstructor.kt");
                }

                @TestMetadata("firstInSecondaryConstructor.kt")
                public void testFirstInSecondaryConstructor() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/firstInSecondaryConstructor.kt");
                }

                @TestMetadata("firstInSetter.kt")
                public void testFirstInSetter() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/firstInSetter.kt");
                }

                @TestMetadata("secondInFunction.kt")
                public void testSecondInFunction() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/secondInFunction.kt");
                }

                @TestMetadata("secondInFunctionalType.kt")
                public void testSecondInFunctionalType() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/secondInFunctionalType.kt");
                }

                @TestMetadata("secondInLambda.kt")
                public void testSecondInLambda() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/secondInLambda.kt");
                }

                @TestMetadata("secondInPrimaryConstructor.kt")
                public void testSecondInPrimaryConstructor() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/secondInPrimaryConstructor.kt");
                }

                @TestMetadata("secondInSecondaryConstructor.kt")
                public void testSecondInSecondaryConstructor() throws Exception {
                    runTest("compiler/testData/psi/recovery/unnamedParameter/secondInSecondaryConstructor.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/psi/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInScript() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/script"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("ComplexScript.kts")
            public void testComplexScript() throws Exception {
                runTest("compiler/testData/psi/script/ComplexScript.kts");
            }

            @TestMetadata("FunctionComment.kts")
            public void testFunctionComment() throws Exception {
                runTest("compiler/testData/psi/script/FunctionComment.kts");
            }

            @TestMetadata("Import.kts")
            public void testImport() throws Exception {
                runTest("compiler/testData/psi/script/Import.kts");
            }

            @TestMetadata("manyAnnotationsOnFile.kts")
            public void testManyAnnotationsOnFile() throws Exception {
                runTest("compiler/testData/psi/script/manyAnnotationsOnFile.kts");
            }

            @TestMetadata("OneLiner.kts")
            public void testOneLiner() throws Exception {
                runTest("compiler/testData/psi/script/OneLiner.kts");
            }

            @TestMetadata("Shebang.kts")
            public void testShebang() throws Exception {
                runTest("compiler/testData/psi/script/Shebang.kts");
            }

            @TestMetadata("ShebangIncorrect.kts")
            public void testShebangIncorrect() throws Exception {
                runTest("compiler/testData/psi/script/ShebangIncorrect.kts");
            }

            @TestMetadata("ShebangWithImports.kts")
            public void testShebangWithImports() throws Exception {
                runTest("compiler/testData/psi/script/ShebangWithImports.kts");
            }

            @TestMetadata("ShebangWithPackage.kts")
            public void testShebangWithPackage() throws Exception {
                runTest("compiler/testData/psi/script/ShebangWithPackage.kts");
            }

            @TestMetadata("SimpleScript.kts")
            public void testSimpleScript() throws Exception {
                runTest("compiler/testData/psi/script/SimpleScript.kts");
            }

            @TestMetadata("topLevelPropertiesWithGetSet.kts")
            public void testTopLevelPropertiesWithGetSet() throws Exception {
                runTest("compiler/testData/psi/script/topLevelPropertiesWithGetSet.kts");
            }

            @TestMetadata("unexpectedSymbol.kts")
            public void testUnexpectedSymbol() throws Exception {
                runTest("compiler/testData/psi/script/unexpectedSymbol.kts");
            }
        }

        @TestMetadata("compiler/testData/psi/secondaryConstructors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SecondaryConstructors extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInSecondaryConstructors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/secondaryConstructors"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("anonymousInitializer.kt")
            public void testAnonymousInitializer() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/anonymousInitializer.kt");
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/basic.kt");
            }

            @TestMetadata("emptyBody.kt")
            public void testEmptyBody() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/emptyBody.kt");
            }

            @TestMetadata("enumParsing.kt")
            public void testEnumParsing() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/enumParsing.kt");
            }

            @TestMetadata("recoveryEmptyDelegationType.kt")
            public void testRecoveryEmptyDelegationType() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/recoveryEmptyDelegationType.kt");
            }

            @TestMetadata("recoveryJustConstructorKeyword.kt")
            public void testRecoveryJustConstructorKeyword() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/recoveryJustConstructorKeyword.kt");
            }

            @TestMetadata("recoveryJustConstructorKeywordSameLineBrace.kt")
            public void testRecoveryJustConstructorKeywordSameLineBrace() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/recoveryJustConstructorKeywordSameLineBrace.kt");
            }

            @TestMetadata("recoveryNoDelegationCallAfterColon.kt")
            public void testRecoveryNoDelegationCallAfterColon() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/recoveryNoDelegationCallAfterColon.kt");
            }

            @TestMetadata("recoveryWithoutBodyWrongDelegationName.kt")
            public void testRecoveryWithoutBodyWrongDelegationName() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/recoveryWithoutBodyWrongDelegationName.kt");
            }

            @TestMetadata("recoveryWithoutParameterList.kt")
            public void testRecoveryWithoutParameterList() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/recoveryWithoutParameterList.kt");
            }

            @TestMetadata("recoveryWrongDelegationName.kt")
            public void testRecoveryWrongDelegationName() throws Exception {
                runTest("compiler/testData/psi/secondaryConstructors/recoveryWrongDelegationName.kt");
            }
        }

        @TestMetadata("compiler/testData/psi/stringTemplates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringTemplates extends AbstractParsingTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInStringTemplates() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/psi/stringTemplates"), Pattern.compile("^(.*)\\.kts?$"), null, true);
            }

            @TestMetadata("RawStringsWithManyQuotes.kt")
            public void testRawStringsWithManyQuotes() throws Exception {
                runTest("compiler/testData/psi/stringTemplates/RawStringsWithManyQuotes.kt");
            }

            @TestMetadata("StringTemplateWithTryWithoutBlockInLongEntry.kt")
            public void testStringTemplateWithTryWithoutBlockInLongEntry() throws Exception {
                runTest("compiler/testData/psi/stringTemplates/StringTemplateWithTryWithoutBlockInLongEntry.kt");
            }

            @TestMetadata("StringTemplateWithTryWithoutBlockInShortEntry.kt")
            public void testStringTemplateWithTryWithoutBlockInShortEntry() throws Exception {
                runTest("compiler/testData/psi/stringTemplates/StringTemplateWithTryWithoutBlockInShortEntry.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/parseCodeFragment/expression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expression extends AbstractParsingTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doExpressionCodeFragmentParsingTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInExpression() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/parseCodeFragment/expression"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @TestMetadata("error.kt")
        public void testError() throws Exception {
            runTest("compiler/testData/parseCodeFragment/expression/error.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/parseCodeFragment/expression/simple.kt");
        }
    }

    @TestMetadata("compiler/testData/parseCodeFragment/block")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Block extends AbstractParsingTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doBlockCodeFragmentParsingTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInBlock() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/parseCodeFragment/block"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @TestMetadata("expressionOnTopLevel.kt")
        public void testExpressionOnTopLevel() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/expressionOnTopLevel.kt");
        }

        @TestMetadata("imports.kt")
        public void testImports() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/imports.kt");
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/localFun.kt");
        }

        @TestMetadata("oneLine.kt")
        public void testOneLine() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/oneLine.kt");
        }

        @TestMetadata("oneStatement.kt")
        public void testOneStatement() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/oneStatement.kt");
        }

        @TestMetadata("packageAndImport.kt")
        public void testPackageAndImport() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/packageAndImport.kt");
        }

        @TestMetadata("packageDirective.kt")
        public void testPackageDirective() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/packageDirective.kt");
        }

        @TestMetadata("severalExpressions.kt")
        public void testSeveralExpressions() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/severalExpressions.kt");
        }

        @TestMetadata("severalStatements.kt")
        public void testSeveralStatements() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/severalStatements.kt");
        }

        @TestMetadata("unexpectedSymbol.kt")
        public void testUnexpectedSymbol() throws Exception {
            runTest("compiler/testData/parseCodeFragment/block/unexpectedSymbol.kt");
        }
    }
}
