/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.jvm.compiler;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class LoadJava17TestGenerated extends AbstractLoadJava17Test {
    @TestMetadata("compiler/testData/loadJava17")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CompiledJava extends AbstractLoadJava17Test {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestCompiledJava, this, testDataFilePath);
        }

        public void testAllFilesPresentInCompiledJava() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/loadJava17"), Pattern.compile("^(.+)\\.java$"), null, true);
        }

        @TestMetadata("GenericRecord.java")
        public void testGenericRecord() throws Exception {
            runTest("compiler/testData/loadJava17/GenericRecord.java");
        }

        @TestMetadata("SimpleRecord.java")
        public void testSimpleRecord() throws Exception {
            runTest("compiler/testData/loadJava17/SimpleRecord.java");
        }
    }

    @TestMetadata("compiler/testData/loadJava17")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SourceJava extends AbstractLoadJava17Test {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestSourceJava, this, testDataFilePath);
        }

        public void testAllFilesPresentInSourceJava() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/loadJava17"), Pattern.compile("^(.+)\\.java$"), null, true);
        }

        @TestMetadata("GenericRecord.java")
        public void testGenericRecord() throws Exception {
            runTest("compiler/testData/loadJava17/GenericRecord.java");
        }

        @TestMetadata("SimpleRecord.java")
        public void testSimpleRecord() throws Exception {
            runTest("compiler/testData/loadJava17/SimpleRecord.java");
        }
    }
}
