/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.utils.TransformersFunctions;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/box")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class LightAnalysisModeTestGenerated extends AbstractLightAnalysisModeTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
    }

    public void testAllFilesPresentInBox() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, "ranges/stepped", "compileKotlinAgainstKotlin", "testsWithJava9", "testsWithJava15", "testsWithJava17");
    }

    @TestMetadata("compiler/testData/codegen/box/annotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotations extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("annotatedAnnotationParameter.kt")
        public void testAnnotatedAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedAnnotationParameter.kt");
        }

        @TestMetadata("annotatedEnumEntry.kt")
        public void testAnnotatedEnumEntry() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedEnumEntry.kt");
        }

        @TestMetadata("annotatedObjectLiteral.kt")
        public void testAnnotatedObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedObjectLiteral.kt");
        }

        @TestMetadata("annotationOnWhen.kt")
        public void testAnnotationOnWhen() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationOnWhen.kt");
        }

        @TestMetadata("annotationProperty.kt")
        public void testAnnotationProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationProperty.kt");
        }

        @TestMetadata("annotationTargets.kt")
        public void testAnnotationTargets() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationTargets.kt");
        }

        @TestMetadata("annotationWithKotlinProperty.kt")
        public void testAnnotationWithKotlinProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationWithKotlinProperty.kt");
        }

        @TestMetadata("annotationWithKotlinPropertyFromInterfaceCompanion.kt")
        public void testAnnotationWithKotlinPropertyFromInterfaceCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationWithKotlinPropertyFromInterfaceCompanion.kt");
        }

        @TestMetadata("annotationsOnDefault.kt")
        public void testAnnotationsOnDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnDefault.kt");
        }

        @TestMetadata("annotationsOnLateinitAccessors.kt")
        public void testAnnotationsOnLateinitAccessors() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnLateinitAccessors.kt");
        }

        @TestMetadata("annotationsOnLateinitFields.kt")
        public void testAnnotationsOnLateinitFields() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnLateinitFields.kt");
        }

        @TestMetadata("annotationsOnNonExistentAccessors.kt")
        public void testAnnotationsOnNonExistentAccessors() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnNonExistentAccessors.kt");
        }

        @TestMetadata("annotationsOnTypeAliases.kt")
        public void testAnnotationsOnTypeAliases() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnTypeAliases.kt");
        }

        @TestMetadata("constValInAnnotation.kt")
        public void testConstValInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/constValInAnnotation.kt");
        }

        @TestMetadata("defaultParameterValues.kt")
        public void testDefaultParameterValues() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/defaultParameterValues.kt");
        }

        @TestMetadata("delegatedPropertySetter.kt")
        public void testDelegatedPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/delegatedPropertySetter.kt");
        }

        @TestMetadata("divisionByZeroInJava.kt")
        public void testDivisionByZeroInJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/divisionByZeroInJava.kt");
        }

        @TestMetadata("fileClassWithFileAnnotation.kt")
        public void testFileClassWithFileAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/fileClassWithFileAnnotation.kt");
        }

        @TestMetadata("genericAnnotations.kt")
        public void testGenericAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/genericAnnotations.kt");
        }

        @TestMetadata("javaAnnotationArrayValueDefault.kt")
        public void testJavaAnnotationArrayValueDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationArrayValueDefault.kt");
        }

        @TestMetadata("javaAnnotationArrayValueNoDefault.kt")
        public void testJavaAnnotationArrayValueNoDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationArrayValueNoDefault.kt");
        }

        @TestMetadata("javaAnnotationCall.kt")
        public void testJavaAnnotationCall() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationCall.kt");
        }

        @TestMetadata("javaAnnotationDefault.kt")
        public void testJavaAnnotationDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationDefault.kt");
        }

        @TestMetadata("javaAnnotationOnProperty.kt")
        public void testJavaAnnotationOnProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationOnProperty.kt");
        }

        @TestMetadata("javaAnnotationOnSecondaryConstructorOfLocalClass.kt")
        public void testJavaAnnotationOnSecondaryConstructorOfLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationOnSecondaryConstructorOfLocalClass.kt");
        }

        @TestMetadata("javaAnnotationWithSingleArrayArgument.kt")
        public void testJavaAnnotationWithSingleArrayArgument() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationWithSingleArrayArgument.kt");
        }

        @TestMetadata("javaNegativePropertyAsAnnotationParameter.kt")
        public void testJavaNegativePropertyAsAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaNegativePropertyAsAnnotationParameter.kt");
        }

        @TestMetadata("javaPropertyAsAnnotationParameter.kt")
        public void testJavaPropertyAsAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaPropertyAsAnnotationParameter.kt");
        }

        @TestMetadata("javaPropertyWithIntInitializer.kt")
        public void testJavaPropertyWithIntInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaPropertyWithIntInitializer.kt");
        }

        @TestMetadata("jvmAnnotationFlags.kt")
        public void testJvmAnnotationFlags() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/jvmAnnotationFlags.kt");
        }

        @TestMetadata("kotlinPropertyFromClassObjectAsParameter.kt")
        public void testKotlinPropertyFromClassObjectAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kotlinPropertyFromClassObjectAsParameter.kt");
        }

        @TestMetadata("kotlinTopLevelPropertyAsParameter.kt")
        public void testKotlinTopLevelPropertyAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kotlinTopLevelPropertyAsParameter.kt");
        }

        @TestMetadata("kt10136.kt")
        public void testKt10136() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kt10136.kt");
        }

        @TestMetadata("kt25489.kt")
        public void testKt25489() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kt25489.kt");
        }

        @TestMetadata("mustBeDocumented.kt")
        public void testMustBeDocumented() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/mustBeDocumented.kt");
        }

        @TestMetadata("nestedAnnotation.kt")
        public void testNestedAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedAnnotation.kt");
        }

        @TestMetadata("nestedClassPropertyAsParameter.kt")
        public void testNestedClassPropertyAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedClassPropertyAsParameter.kt");
        }

        @TestMetadata("nestedClassesInAnnotations.kt")
        public void testNestedClassesInAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedClassesInAnnotations.kt");
        }

        @TestMetadata("parameterAnnotationInDefaultImpls.kt")
        public void testParameterAnnotationInDefaultImpls() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameterAnnotationInDefaultImpls.kt");
        }

        @TestMetadata("parameterWithPrimitiveType.kt")
        public void testParameterWithPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameterWithPrimitiveType.kt");
        }

        @TestMetadata("parameters.kt")
        public void testParameters() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameters.kt");
        }

        @TestMetadata("propertyWithPropertyInInitializerAsParameter.kt")
        public void testPropertyWithPropertyInInitializerAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/propertyWithPropertyInInitializerAsParameter.kt");
        }

        @TestMetadata("resolveWithLowPriorityAnnotation.kt")
        public void testResolveWithLowPriorityAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/resolveWithLowPriorityAnnotation.kt");
        }

        @TestMetadata("retentionInJava.kt")
        public void testRetentionInJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/retentionInJava.kt");
        }

        @TestMetadata("singleAssignmentToVarargInAnnotation.kt")
        public void testSingleAssignmentToVarargInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/singleAssignmentToVarargInAnnotation.kt");
        }

        @TestMetadata("syntheticMethodForJvmStaticProperty.kt")
        public void testSyntheticMethodForJvmStaticProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/syntheticMethodForJvmStaticProperty.kt");
        }

        @TestMetadata("syntheticMethodForProperty.kt")
        public void testSyntheticMethodForProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/syntheticMethodForProperty.kt");
        }

        @TestMetadata("typeAnnotationOnJdk6.kt")
        public void testTypeAnnotationOnJdk6() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/typeAnnotationOnJdk6.kt");
        }

        @TestMetadata("useTypeParameterAnnotationFromJava.kt")
        public void testUseTypeParameterAnnotationFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/useTypeParameterAnnotationFromJava.kt");
        }

        @TestMetadata("useTypeUseAnnotationFromJava.kt")
        public void testUseTypeUseAnnotationFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/useTypeUseAnnotationFromJava.kt");
        }

        @TestMetadata("varargInAnnotationParameter.kt")
        public void testVarargInAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/varargInAnnotationParameter.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/annotatedLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotatedLambda extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotatedLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/annotatedLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("funExpression.kt")
            public void testFunExpression() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/funExpression.kt");
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/lambda.kt");
            }

            @TestMetadata("samFunExpression.kt")
            public void testSamFunExpression() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samFunExpression.kt");
            }

            @TestMetadata("samFunReference.kt")
            public void testSamFunReference() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samFunReference.kt");
            }

            @TestMetadata("samLambda.kt")
            public void testSamLambda() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samLambda.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/instances")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Instances extends AbstractLightAnalysisModeTest {
            @TestMetadata("annotationEqHc.kt")
            public void ignoreAnnotationEqHc() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationEqHc.kt");
            }

            @TestMetadata("annotationFromStdlib.kt")
            public void ignoreAnnotationFromStdlib() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationFromStdlib.kt");
            }

            @TestMetadata("annotationInstances.kt")
            public void ignoreAnnotationInstances() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationInstances.kt");
            }

            @TestMetadata("annotationInstancesEmptyDefault.kt")
            public void ignoreAnnotationInstancesEmptyDefault() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationInstancesEmptyDefault.kt");
            }

            @TestMetadata("annotationToString.kt")
            public void ignoreAnnotationToString() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationToString.kt");
            }

            @TestMetadata("inInlineFunction.kt")
            public void ignoreInInlineFunction() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/inInlineFunction.kt");
            }

            @TestMetadata("multifileEqHc.kt")
            public void ignoreMultifileEqHc() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/multifileEqHc.kt");
            }

            @TestMetadata("multiplatformInstantiation.kt")
            public void ignoreMultiplatformInstantiation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/multiplatformInstantiation.kt");
            }

            @TestMetadata("nestedAnnotationInstances.kt")
            public void ignoreNestedAnnotationInstances() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/nestedAnnotationInstances.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInstances() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/instances"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/kClassMapping")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KClassMapping extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInKClassMapping() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/kClassMapping"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("arrayClassParameter.kt")
            public void testArrayClassParameter() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/arrayClassParameter.kt");
            }

            @TestMetadata("arrayClassParameterOnJavaClass.kt")
            public void testArrayClassParameterOnJavaClass() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/arrayClassParameterOnJavaClass.kt");
            }

            @TestMetadata("classParameter.kt")
            public void testClassParameter() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/classParameter.kt");
            }

            @TestMetadata("classParameterOnJavaClass.kt")
            public void testClassParameterOnJavaClass() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/classParameterOnJavaClass.kt");
            }

            @TestMetadata("varargClassParameter.kt")
            public void testVarargClassParameter() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/varargClassParameter.kt");
            }

            @TestMetadata("varargClassParameterOnJavaClass.kt")
            public void testVarargClassParameterOnJavaClass() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/varargClassParameterOnJavaClass.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/repeatable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Repeatable extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInRepeatable() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/typeAnnotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeAnnotations extends AbstractLightAnalysisModeTest {
            @TestMetadata("classTypeParameterBoundsJava.kt")
            public void ignoreClassTypeParameterBoundsJava() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/classTypeParameterBoundsJava.kt");
            }

            @TestMetadata("methodTypeParameters.kt")
            public void ignoreMethodTypeParameters() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/methodTypeParameters.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInTypeAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/typeAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("checkingNotincorporatedInputTypes.kt")
            public void testCheckingNotincorporatedInputTypes() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/checkingNotincorporatedInputTypes.kt");
            }

            @TestMetadata("classTypeParameterBound.kt")
            public void testClassTypeParameterBound() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/classTypeParameterBound.kt");
            }

            @TestMetadata("functionTypeParameterBound.kt")
            public void testFunctionTypeParameterBound() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/functionTypeParameterBound.kt");
            }

            @TestMetadata("implicitReturn.kt")
            public void testImplicitReturn() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/implicitReturn.kt");
            }

            @TestMetadata("implicitReturnAgainstCompiled.kt")
            public void testImplicitReturnAgainstCompiled() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/implicitReturnAgainstCompiled.kt");
            }

            @TestMetadata("kt41484.kt")
            public void testKt41484() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/kt41484.kt");
            }

            @TestMetadata("methodParameters.kt")
            public void testMethodParameters() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/methodParameters.kt");
            }

            @TestMetadata("typeAnnotationTarget6.kt")
            public void testTypeAnnotationTarget6() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/typeAnnotationTarget6.kt");
            }

            @TestMetadata("typeUseAnnotation.kt")
            public void testTypeUseAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/typeUseAnnotation.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArgumentOrder extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("argumentOrderInObjectSuperCall.kt")
        public void testArgumentOrderInObjectSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInObjectSuperCall.kt");
        }

        @TestMetadata("argumentOrderInObjectSuperCallWithPlatformType.kt")
        public void testArgumentOrderInObjectSuperCallWithPlatformType() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInObjectSuperCallWithPlatformType.kt");
        }

        @TestMetadata("argumentOrderInSuperCall.kt")
        public void testArgumentOrderInSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInSuperCall.kt");
        }

        @TestMetadata("arguments.kt")
        public void testArguments() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/arguments.kt");
        }

        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/captured.kt");
        }

        @TestMetadata("capturedInExtension.kt")
        public void testCapturedInExtension() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/capturedInExtension.kt");
        }

        @TestMetadata("defaults.kt")
        public void testDefaults() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/defaults.kt");
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/extension.kt");
        }

        @TestMetadata("extensionInClass.kt")
        public void testExtensionInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/extensionInClass.kt");
        }

        @TestMetadata("kt17691.kt")
        public void testKt17691() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt17691.kt");
        }

        @TestMetadata("kt17691WithEnabledFeature.kt")
        public void testKt17691WithEnabledFeature() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt17691WithEnabledFeature.kt");
        }

        @TestMetadata("kt9277.kt")
        public void testKt9277() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt9277.kt");
        }

        @TestMetadata("lambdaMigration.kt")
        public void testLambdaMigration() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigration.kt");
        }

        @TestMetadata("lambdaMigrationInClass.kt")
        public void testLambdaMigrationInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigrationInClass.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/simple.kt");
        }

        @TestMetadata("simpleInClass.kt")
        public void testSimpleInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/simpleInClass.kt");
        }

        @TestMetadata("singleSideEffect.kt")
        public void testSingleSideEffect() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/singleSideEffect.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/arrays")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Arrays extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInArrays() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("arrayConstructorWithNonInlineLambda.kt")
        public void testArrayConstructorWithNonInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayConstructorWithNonInlineLambda.kt");
        }

        @TestMetadata("arrayConstructorsSimple.kt")
        public void testArrayConstructorsSimple() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayConstructorsSimple.kt");
        }

        @TestMetadata("arrayGetAssignMultiIndex.kt")
        public void testArrayGetAssignMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayGetAssignMultiIndex.kt");
        }

        @TestMetadata("arrayGetMultiIndex.kt")
        public void testArrayGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayGetMultiIndex.kt");
        }

        @TestMetadata("arrayInstanceOf.kt")
        public void testArrayInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayInstanceOf.kt");
        }

        @TestMetadata("arrayPlusAssign.kt")
        public void testArrayPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayPlusAssign.kt");
        }

        @TestMetadata("arraysAreCloneable.kt")
        public void testArraysAreCloneable() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arraysAreCloneable.kt");
        }

        @TestMetadata("cloneArray.kt")
        public void testCloneArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/cloneArray.kt");
        }

        @TestMetadata("clonePrimitiveArrays.kt")
        public void testClonePrimitiveArrays() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/clonePrimitiveArrays.kt");
        }

        @TestMetadata("collectionAssignGetMultiIndex.kt")
        public void testCollectionAssignGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/collectionAssignGetMultiIndex.kt");
        }

        @TestMetadata("collectionGetMultiIndex.kt")
        public void testCollectionGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/collectionGetMultiIndex.kt");
        }

        @TestMetadata("constantArrayOfAny.kt")
        public void testConstantArrayOfAny() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/constantArrayOfAny.kt");
        }

        @TestMetadata("forEachBooleanArray.kt")
        public void testForEachBooleanArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachBooleanArray.kt");
        }

        @TestMetadata("forEachByteArray.kt")
        public void testForEachByteArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachByteArray.kt");
        }

        @TestMetadata("forEachCharArray.kt")
        public void testForEachCharArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachCharArray.kt");
        }

        @TestMetadata("forEachDoubleArray.kt")
        public void testForEachDoubleArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachDoubleArray.kt");
        }

        @TestMetadata("forEachFloatArray.kt")
        public void testForEachFloatArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachFloatArray.kt");
        }

        @TestMetadata("forEachIntArray.kt")
        public void testForEachIntArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachIntArray.kt");
        }

        @TestMetadata("forEachLongArray.kt")
        public void testForEachLongArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachLongArray.kt");
        }

        @TestMetadata("forEachShortArray.kt")
        public void testForEachShortArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachShortArray.kt");
        }

        @TestMetadata("genericArrayInObjectLiteralConstructor.kt")
        public void testGenericArrayInObjectLiteralConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/genericArrayInObjectLiteralConstructor.kt");
        }

        @TestMetadata("hashMap.kt")
        public void testHashMap() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/hashMap.kt");
        }

        @TestMetadata("inProjectionAsParameter.kt")
        public void testInProjectionAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionAsParameter.kt");
        }

        @TestMetadata("inProjectionOfArray.kt")
        public void testInProjectionOfArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionOfArray.kt");
        }

        @TestMetadata("inProjectionOfList.kt")
        public void testInProjectionOfList() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionOfList.kt");
        }

        @TestMetadata("indices.kt")
        public void testIndices() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/indices.kt");
        }

        @TestMetadata("indicesChar.kt")
        public void testIndicesChar() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/indicesChar.kt");
        }

        @TestMetadata("inlineInitializer.kt")
        public void testInlineInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inlineInitializer.kt");
        }

        @TestMetadata("iterator.kt")
        public void testIterator() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iterator.kt");
        }

        @TestMetadata("iteratorBooleanArray.kt")
        public void testIteratorBooleanArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorBooleanArray.kt");
        }

        @TestMetadata("iteratorByteArray.kt")
        public void testIteratorByteArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorByteArray.kt");
        }

        @TestMetadata("iteratorByteArrayNextByte.kt")
        public void testIteratorByteArrayNextByte() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorByteArrayNextByte.kt");
        }

        @TestMetadata("iteratorCharArray.kt")
        public void testIteratorCharArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorCharArray.kt");
        }

        @TestMetadata("iteratorDoubleArray.kt")
        public void testIteratorDoubleArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorDoubleArray.kt");
        }

        @TestMetadata("iteratorFloatArray.kt")
        public void testIteratorFloatArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorFloatArray.kt");
        }

        @TestMetadata("iteratorIntArray.kt")
        public void testIteratorIntArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorIntArray.kt");
        }

        @TestMetadata("iteratorLongArray.kt")
        public void testIteratorLongArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorLongArray.kt");
        }

        @TestMetadata("iteratorLongArrayNextLong.kt")
        public void testIteratorLongArrayNextLong() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorLongArrayNextLong.kt");
        }

        @TestMetadata("iteratorShortArray.kt")
        public void testIteratorShortArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorShortArray.kt");
        }

        @TestMetadata("kt1291.kt")
        public void testKt1291() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt1291.kt");
        }

        @TestMetadata("kt17134.kt")
        public void testKt17134() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt17134.kt");
        }

        @TestMetadata("kt238.kt")
        public void testKt238() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt238.kt");
        }

        @TestMetadata("kt2997.kt")
        public void testKt2997() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt2997.kt");
        }

        @TestMetadata("kt33.kt")
        public void testKt33() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt33.kt");
        }

        @TestMetadata("kt34291_16dimensions.kt")
        public void testKt34291_16dimensions() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt34291_16dimensions.kt");
        }

        @TestMetadata("kt3771.kt")
        public void testKt3771() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt3771.kt");
        }

        @TestMetadata("kt4118.kt")
        public void testKt4118() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4118.kt");
        }

        @TestMetadata("kt42932.kt")
        public void testKt42932() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt42932.kt");
        }

        @TestMetadata("kt4348.kt")
        public void testKt4348() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4348.kt");
        }

        @TestMetadata("kt4357.kt")
        public void testKt4357() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4357.kt");
        }

        @TestMetadata("kt45410.kt")
        public void testKt45410() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt45410.kt");
        }

        @TestMetadata("kt47483.kt")
        public void testKt47483() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt47483.kt");
        }

        @TestMetadata("kt47499.kt")
        public void testKt47499() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt47499.kt");
        }

        @TestMetadata("kt503.kt")
        public void testKt503() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt503.kt");
        }

        @TestMetadata("kt594.kt")
        public void testKt594() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt594.kt");
        }

        @TestMetadata("kt602.kt")
        public void testKt602() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt602.kt");
        }

        @TestMetadata("kt7009.kt")
        public void testKt7009() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7009.kt");
        }

        @TestMetadata("kt7288.kt")
        public void testKt7288() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7288.kt");
        }

        @TestMetadata("kt7338.kt")
        public void testKt7338() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7338.kt");
        }

        @TestMetadata("kt779.kt")
        public void testKt779() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt779.kt");
        }

        @TestMetadata("kt945.kt")
        public void testKt945() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt945.kt");
        }

        @TestMetadata("kt950.kt")
        public void testKt950() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt950.kt");
        }

        @TestMetadata("longAsIndex.kt")
        public void testLongAsIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/longAsIndex.kt");
        }

        @TestMetadata("multiArrayConstructors.kt")
        public void testMultiArrayConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/multiArrayConstructors.kt");
        }

        @TestMetadata("nonLocalReturnArrayConstructor.kt")
        public void testNonLocalReturnArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/nonLocalReturnArrayConstructor.kt");
        }

        @TestMetadata("nonNullArray.kt")
        public void testNonNullArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/nonNullArray.kt");
        }

        @TestMetadata("primitiveArrays.kt")
        public void testPrimitiveArrays() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/primitiveArrays.kt");
        }

        @TestMetadata("stdlib.kt")
        public void testStdlib() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/stdlib.kt");
        }

        @TestMetadata("varargsWithJava.kt")
        public void testVarargsWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/varargsWithJava.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/arraysOfInlineClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ArraysOfInlineClass extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("accessArrayOfInlineClass.kt")
            public void testAccessArrayOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfInlineClass.kt");
            }

            @TestMetadata("accessArrayOfUnsigned.kt")
            public void testAccessArrayOfUnsigned() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfUnsigned.kt");
            }

            public void testAllFilesPresentInArraysOfInlineClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/arraysOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("arrayOfInlineClassOfArrayOfInlineClass.kt")
            public void testArrayOfInlineClassOfArrayOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/arrayOfInlineClassOfArrayOfInlineClass.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/forInReversed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInReversed extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInReversed() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("reversedArrayOriginalUpdatedInLoopBody.kt")
            public void testReversedArrayOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArrayOriginalUpdatedInLoopBody.kt");
            }

            @TestMetadata("reversedArrayReversedArrayOriginalUpdatedInLoopBody.kt")
            public void testReversedArrayReversedArrayOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArrayReversedArrayOriginalUpdatedInLoopBody.kt");
            }

            @TestMetadata("reversedOriginalUpdatedInLoopBody.kt")
            public void testReversedOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedOriginalUpdatedInLoopBody.kt");
            }

            @TestMetadata("reversedReversedOriginalUpdatedInLoopBody.kt")
            public void testReversedReversedOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedReversedOriginalUpdatedInLoopBody.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/forInUnsignedArray")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInUnsignedArray extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInUnsignedArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/forInUnsignedArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("forInUnsignedArray.kt")
            public void testForInUnsignedArray() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArray.kt");
            }

            @TestMetadata("forInUnsignedArrayIndices.kt")
            public void testForInUnsignedArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayIndices.kt");
            }

            @TestMetadata("forInUnsignedArrayIndicesReversed.kt")
            public void testForInUnsignedArrayIndicesReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayIndicesReversed.kt");
            }

            @TestMetadata("forInUnsignedArrayReversed.kt")
            public void testForInUnsignedArrayReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayReversed.kt");
            }

            @TestMetadata("forInUnsignedArrayWithIndex.kt")
            public void testForInUnsignedArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndex.kt");
            }

            @TestMetadata("forInUnsignedArrayWithIndexNoElementVar.kt")
            public void testForInUnsignedArrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInUnsignedArrayWithIndexNoIndexVar.kt")
            public void testForInUnsignedArrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInUnsignedArrayWithIndexReversed.kt")
            public void testForInUnsignedArrayWithIndexReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexReversed.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiDecl extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMultiDecl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("kt15560.kt")
            public void testKt15560() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15560.kt");
            }

            @TestMetadata("kt15568.kt")
            public void testKt15568() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15568.kt");
            }

            @TestMetadata("kt15575.kt")
            public void testKt15575() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15575.kt");
            }

            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclFor.kt");
            }

            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
            }

            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForValCaptured.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/int")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Int extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInt() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/int"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/long")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Long extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInLong() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/long"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/assert")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Assert extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInAssert() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("alwaysDisable.kt")
        public void testAlwaysDisable() throws Exception {
            runTest("compiler/testData/codegen/box/assert/alwaysDisable.kt");
        }

        @TestMetadata("alwaysEnable.kt")
        public void testAlwaysEnable() throws Exception {
            runTest("compiler/testData/codegen/box/assert/alwaysEnable.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/assert/jvm")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Jvm extends AbstractLightAnalysisModeTest {
            @TestMetadata("classAssertionsForInnerClasses.kt")
            public void ignoreClassAssertionsForInnerClasses() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForInnerClasses.kt");
            }

            @TestMetadata("classAssertionsForLocalClasses.kt")
            public void ignoreClassAssertionsForLocalClasses() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForLocalClasses.kt");
            }

            @TestMetadata("classAssertionsForNestedClasses.kt")
            public void ignoreClassAssertionsForNestedClasses() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForNestedClasses.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInJvm() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/assert/jvm"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("assertionsEnabledBeforeClassInitializers.kt")
            public void testAssertionsEnabledBeforeClassInitializers() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/assertionsEnabledBeforeClassInitializers.kt");
            }

            @TestMetadata("classAssertions.kt")
            public void testClassAssertions() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertions.kt");
            }

            @TestMetadata("classAssertionsForCompanion.kt")
            public void testClassAssertionsForCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForCompanion.kt");
            }

            @TestMetadata("interfaceAssertionsDisabled.kt")
            public void testInterfaceAssertionsDisabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/interfaceAssertionsDisabled.kt");
            }

            @TestMetadata("interfaceAssertionsEnabled.kt")
            public void testInterfaceAssertionsEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/interfaceAssertionsEnabled.kt");
            }

            @TestMetadata("lambdaNotEvaluated.kt")
            public void testLambdaNotEvaluated() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/lambdaNotEvaluated.kt");
            }

            @TestMetadata("localAnonymousFunction.kt")
            public void testLocalAnonymousFunction() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localAnonymousFunction.kt");
            }

            @TestMetadata("localClass.kt")
            public void testLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localClass.kt");
            }

            @TestMetadata("localFunction.kt")
            public void testLocalFunction() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localFunction.kt");
            }

            @TestMetadata("localLambda.kt")
            public void testLocalLambda() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localLambda.kt");
            }

            @TestMetadata("localObject.kt")
            public void testLocalObject() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localObject.kt");
            }

            @TestMetadata("noUnnecessaryClassInitialization.kt")
            public void testNoUnnecessaryClassInitialization() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/noUnnecessaryClassInitialization.kt");
            }

            @TestMetadata("nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/nonLocalReturn.kt");
            }

            @TestMetadata("ordinary.kt")
            public void testOrdinary() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/ordinary.kt");
            }

            @TestMetadata("superClassInitializer.kt")
            public void testSuperClassInitializer() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/superClassInitializer.kt");
            }

            @TestMetadata("suspendFunctionAssertionDisabled.kt")
            public void testSuspendFunctionAssertionDisabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionDisabled.kt");
            }

            @TestMetadata("suspendFunctionAssertionsEnabled.kt")
            public void testSuspendFunctionAssertionsEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionsEnabled.kt");
            }

            @TestMetadata("suspendLambdaAssertionsDisabled.kt")
            public void testSuspendLambdaAssertionsDisabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsDisabled.kt");
            }

            @TestMetadata("suspendLambdaAssertionsEnabled.kt")
            public void testSuspendLambdaAssertionsEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsEnabled.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/binaryOp")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BinaryOp extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInBinaryOp() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/binaryOp"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("bitwiseOp.kt")
        public void testBitwiseOp() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOp.kt");
        }

        @TestMetadata("bitwiseOpAny.kt")
        public void testBitwiseOpAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpAny.kt");
        }

        @TestMetadata("bitwiseOpNullable.kt")
        public void testBitwiseOpNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpNullable.kt");
        }

        @TestMetadata("boxingOfLiteralReceiverWithIntegerValueType.kt")
        public void testBoxingOfLiteralReceiverWithIntegerValueType() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/boxingOfLiteralReceiverWithIntegerValueType.kt");
        }

        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/call.kt");
        }

        @TestMetadata("callAny.kt")
        public void testCallAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/callAny.kt");
        }

        @TestMetadata("callNullable.kt")
        public void testCallNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/callNullable.kt");
        }

        @TestMetadata("compareBoxedChars.kt")
        public void testCompareBoxedChars() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareBoxedChars.kt");
        }

        @TestMetadata("compareWithBoxedDouble.kt")
        public void testCompareWithBoxedDouble() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedDouble.kt");
        }

        @TestMetadata("compareWithBoxedLong.kt")
        public void testCompareWithBoxedLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedLong.kt");
        }

        @TestMetadata("compareWithBoxedNotNullDouble.kt")
        public void testCompareWithBoxedNotNullDouble() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedNotNullDouble.kt");
        }

        @TestMetadata("compareWithBoxedNotNullLong.kt")
        public void testCompareWithBoxedNotNullLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedNotNullLong.kt");
        }

        @TestMetadata("divisionByZero.kt")
        public void testDivisionByZero() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/divisionByZero.kt");
        }

        @TestMetadata("eqNullableDoubles.kt")
        public void testEqNullableDoubles() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoubles.kt");
        }

        @TestMetadata("eqNullableDoublesToInt.kt")
        public void testEqNullableDoublesToInt() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesToInt.kt");
        }

        @TestMetadata("eqNullableDoublesToIntWithTP.kt")
        public void testEqNullableDoublesToIntWithTP() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesToIntWithTP.kt");
        }

        @TestMetadata("eqNullableDoublesWithTP.kt")
        public void testEqNullableDoublesWithTP() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesWithTP.kt");
        }

        @TestMetadata("eqNullableShortToShort.kt")
        public void testEqNullableShortToShort() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableShortToShort.kt");
        }

        @TestMetadata("eqNullableToPrimitiveWithSideEffects.kt")
        public void testEqNullableToPrimitiveWithSideEffects() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableToPrimitiveWithSideEffects.kt");
        }

        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsic.kt");
        }

        @TestMetadata("intrinsicAny.kt")
        public void testIntrinsicAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsicAny.kt");
        }

        @TestMetadata("intrinsicNullable.kt")
        public void testIntrinsicNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsicNullable.kt");
        }

        @TestMetadata("kt11163.kt")
        public void testKt11163() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt11163.kt");
        }

        @TestMetadata("kt11163_properIeee754comparisons.kt")
        public void testKt11163_properIeee754comparisons() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt11163_properIeee754comparisons.kt");
        }

        @TestMetadata("kt23030_properIeee754comparisons.kt")
        public void testKt23030_properIeee754comparisons() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt23030_properIeee754comparisons.kt");
        }

        @TestMetadata("kt44402.kt")
        public void testKt44402() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt44402.kt");
        }

        @TestMetadata("kt6747_identityEquals.kt")
        public void testKt6747_identityEquals() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt6747_identityEquals.kt");
        }

        @TestMetadata("overflowChar.kt")
        public void testOverflowChar() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowChar.kt");
        }

        @TestMetadata("overflowInt.kt")
        public void testOverflowInt() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowInt.kt");
        }

        @TestMetadata("overflowLong.kt")
        public void testOverflowLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowLong.kt");
        }

        @TestMetadata("primitiveEqualsSafeCall.kt")
        public void testPrimitiveEqualsSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/primitiveEqualsSafeCall.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BoxingOptimization extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInBoxingOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("boxedIntegersCmp.kt")
        public void testBoxedIntegersCmp() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedIntegersCmp.kt");
        }

        @TestMetadata("boxedPrimitivesAreEqual.kt")
        public void testBoxedPrimitivesAreEqual() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedPrimitivesAreEqual.kt");
        }

        @TestMetadata("boxedRealsCmp.kt")
        public void testBoxedRealsCmp() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedRealsCmp.kt");
        }

        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/casts.kt");
        }

        @TestMetadata("checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/checkcastAndInstanceOf.kt");
        }

        @TestMetadata("explicitEqualsOnDouble.kt")
        public void testExplicitEqualsOnDouble() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/explicitEqualsOnDouble.kt");
        }

        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/fold.kt");
        }

        @TestMetadata("foldRange.kt")
        public void testFoldRange() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/foldRange.kt");
        }

        @TestMetadata("intCompareTo.kt")
        public void testIntCompareTo() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/intCompareTo.kt");
        }

        @TestMetadata("kClassEquals.kt")
        public void testKClassEquals() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kClassEquals.kt");
        }

        @TestMetadata("kt15871.kt")
        public void testKt15871() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt15871.kt");
        }

        @TestMetadata("kt17748.kt")
        public void testKt17748() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt17748.kt");
        }

        @TestMetadata("kt19767.kt")
        public void testKt19767() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767.kt");
        }

        @TestMetadata("kt19767_2.kt")
        public void testKt19767_2() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_2.kt");
        }

        @TestMetadata("kt19767_3.kt")
        public void testKt19767_3() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_3.kt");
        }

        @TestMetadata("kt19767_chain.kt")
        public void testKt19767_chain() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_chain.kt");
        }

        @TestMetadata("kt46859.kt")
        public void testKt46859() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt46859.kt");
        }

        @TestMetadata("kt48394.kt")
        public void testKt48394() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt48394.kt");
        }

        @TestMetadata("kt49092a.kt")
        public void testKt49092a() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092a.kt");
        }

        @TestMetadata("kt49092b.kt")
        public void testKt49092b() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092b.kt");
        }

        @TestMetadata("kt49092c.kt")
        public void testKt49092c() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092c.kt");
        }

        @TestMetadata("kt49092d.kt")
        public void testKt49092d() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092d.kt");
        }

        @TestMetadata("kt49092e.kt")
        public void testKt49092e() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092e.kt");
        }

        @TestMetadata("kt49092f.kt")
        public void testKt49092f() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092f.kt");
        }

        @TestMetadata("kt49548.kt")
        public void testKt49548() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49548.kt");
        }

        @TestMetadata("kt49548a.kt")
        public void testKt49548a() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49548a.kt");
        }

        @TestMetadata("kt5493.kt")
        public void testKt5493() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5493.kt");
        }

        @TestMetadata("kt5588.kt")
        public void testKt5588() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5588.kt");
        }

        @TestMetadata("kt5844.kt")
        public void testKt5844() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5844.kt");
        }

        @TestMetadata("kt6047.kt")
        public void testKt6047() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt6047.kt");
        }

        @TestMetadata("kt6842.kt")
        public void testKt6842() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt6842.kt");
        }

        @TestMetadata("maxMinByOrNull.kt")
        public void testMaxMinByOrNull() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/maxMinByOrNull.kt");
        }

        @TestMetadata("nullCheck.kt")
        public void testNullCheck() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/nullCheck.kt");
        }

        @TestMetadata("progressions.kt")
        public void testProgressions() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/progressions.kt");
        }

        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvis.kt");
        }

        @TestMetadata("safeCallWithElvisAndEnhancedNullability.kt")
        public void testSafeCallWithElvisAndEnhancedNullability() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvisAndEnhancedNullability.kt");
        }

        @TestMetadata("safeCallWithElvisMultipleFiles.kt")
        public void testSafeCallWithElvisMultipleFiles() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/simple.kt");
        }

        @TestMetadata("simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/simpleUninitializedMerge.kt");
        }

        @TestMetadata("taintedValues.kt")
        public void testTaintedValues() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/taintedValues.kt");
        }

        @TestMetadata("taintedValuesBox.kt")
        public void testTaintedValuesBox() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/taintedValuesBox.kt");
        }

        @TestMetadata("unsafeRemoving.kt")
        public void testUnsafeRemoving() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/unsafeRemoving.kt");
        }

        @TestMetadata("unsignedArrayForEach.kt")
        public void testUnsignedArrayForEach() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/unsignedArrayForEach.kt");
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/variables.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/bridges")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Bridges extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt24193.kt")
        public void ignoreKt24193() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt24193.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("abstractOverrideBridge.kt")
        public void testAbstractOverrideBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/abstractOverrideBridge.kt");
        }

        public void testAllFilesPresentInBridges() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("bridgeInInterface.kt")
        public void testBridgeInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/bridgeInInterface.kt");
        }

        @TestMetadata("bridgeInInterfaceWithProperties.kt")
        public void testBridgeInInterfaceWithProperties() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/bridgeInInterfaceWithProperties.kt");
        }

        @TestMetadata("complexMultiInheritance.kt")
        public void testComplexMultiInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/complexMultiInheritance.kt");
        }

        @TestMetadata("complexTraitImpl.kt")
        public void testComplexTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/complexTraitImpl.kt");
        }

        @TestMetadata("covariantGenericDiamond.kt")
        public void testCovariantGenericDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/covariantGenericDiamond.kt");
        }

        @TestMetadata("delegation.kt")
        public void testDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegation.kt");
        }

        @TestMetadata("delegationComplex.kt")
        public void testDelegationComplex() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationComplex.kt");
        }

        @TestMetadata("delegationComplexWithList.kt")
        public void testDelegationComplexWithList() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationComplexWithList.kt");
        }

        @TestMetadata("delegationProperty.kt")
        public void testDelegationProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationProperty.kt");
        }

        @TestMetadata("diamond.kt")
        public void testDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/diamond.kt");
        }

        @TestMetadata("fakeCovariantOverride.kt")
        public void testFakeCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeCovariantOverride.kt");
        }

        @TestMetadata("fakeGenericCovariantOverride.kt")
        public void testFakeGenericCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverride.kt");
        }

        @TestMetadata("fakeGenericCovariantOverrideWithDelegation.kt")
        public void testFakeGenericCovariantOverrideWithDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverrideWithDelegation.kt");
        }

        @TestMetadata("fakeOverrideFromInterfaceThroughIntermediateClass.kt")
        public void testFakeOverrideFromInterfaceThroughIntermediateClass() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideFromInterfaceThroughIntermediateClass.kt");
        }

        @TestMetadata("fakeOverrideMultiFile.kt")
        public void testFakeOverrideMultiFile() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideMultiFile.kt");
        }

        @TestMetadata("fakeOverrideOfTraitImpl.kt")
        public void testFakeOverrideOfTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideOfTraitImpl.kt");
        }

        @TestMetadata("fakeOverrideThroughGenericSuperclass.kt")
        public void testFakeOverrideThroughGenericSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideThroughGenericSuperclass.kt");
        }

        @TestMetadata("fakeOverrideWithSeveralSuperDeclarations.kt")
        public void testFakeOverrideWithSeveralSuperDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSeveralSuperDeclarations.kt");
        }

        @TestMetadata("fakeOverrideWithSynthesizedImplementation.kt")
        public void testFakeOverrideWithSynthesizedImplementation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSynthesizedImplementation.kt");
        }

        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/genericProperty.kt");
        }

        @TestMetadata("innerClassTypeParameters.kt")
        public void testInnerClassTypeParameters() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/innerClassTypeParameters.kt");
        }

        @TestMetadata("kt12416.kt")
        public void testKt12416() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt12416.kt");
        }

        @TestMetadata("kt1939.kt")
        public void testKt1939() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt1939.kt");
        }

        @TestMetadata("kt1959.kt")
        public void testKt1959() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt1959.kt");
        }

        @TestMetadata("kt2498.kt")
        public void testKt2498() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2498.kt");
        }

        @TestMetadata("kt2702.kt")
        public void testKt2702() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2702.kt");
        }

        @TestMetadata("kt2833.kt")
        public void testKt2833() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2833.kt");
        }

        @TestMetadata("kt2920.kt")
        public void testKt2920() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2920.kt");
        }

        @TestMetadata("kt318.kt")
        public void testKt318() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt318.kt");
        }

        @TestMetadata("kt42137.kt")
        public void testKt42137() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt42137.kt");
        }

        @TestMetadata("kt46389.kt")
        public void testKt46389() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt46389.kt");
        }

        @TestMetadata("kt46389_jvmDefault.kt")
        public void testKt46389_jvmDefault() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt46389_jvmDefault.kt");
        }

        @TestMetadata("longChainOneBridge.kt")
        public void testLongChainOneBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/longChainOneBridge.kt");
        }

        @TestMetadata("manyTypeArgumentsSubstitutedSuccessively.kt")
        public void testManyTypeArgumentsSubstitutedSuccessively() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/manyTypeArgumentsSubstitutedSuccessively.kt");
        }

        @TestMetadata("methodFromTrait.kt")
        public void testMethodFromTrait() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/methodFromTrait.kt");
        }

        @TestMetadata("noBridgeOnMutableCollectionInheritance.kt")
        public void testNoBridgeOnMutableCollectionInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/noBridgeOnMutableCollectionInheritance.kt");
        }

        @TestMetadata("objectClone.kt")
        public void testObjectClone() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/objectClone.kt");
        }

        @TestMetadata("overrideAbstractProperty.kt")
        public void testOverrideAbstractProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideAbstractProperty.kt");
        }

        @TestMetadata("overrideReturnType.kt")
        public void testOverrideReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideReturnType.kt");
        }

        @TestMetadata("overrideWithValueClassReturn.kt")
        public void testOverrideWithValueClassReturn() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideWithValueClassReturn.kt");
        }

        @TestMetadata("propertyAccessorsWithoutBody.kt")
        public void testPropertyAccessorsWithoutBody() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyAccessorsWithoutBody.kt");
        }

        @TestMetadata("propertyDiamond.kt")
        public void testPropertyDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyDiamond.kt");
        }

        @TestMetadata("propertyDiamondFakeOverride.kt")
        public void testPropertyDiamondFakeOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyDiamondFakeOverride.kt");
        }

        @TestMetadata("propertyInConstructor.kt")
        public void testPropertyInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyInConstructor.kt");
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertySetter.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simple.kt");
        }

        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleEnum.kt");
        }

        @TestMetadata("simpleGenericMethod.kt")
        public void testSimpleGenericMethod() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleGenericMethod.kt");
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleObject.kt");
        }

        @TestMetadata("simpleReturnType.kt")
        public void testSimpleReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleReturnType.kt");
        }

        @TestMetadata("simpleTraitImpl.kt")
        public void testSimpleTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleTraitImpl.kt");
        }

        @TestMetadata("simpleUpperBound.kt")
        public void testSimpleUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleUpperBound.kt");
        }

        @TestMetadata("strListContains.kt")
        public void testStrListContains() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/strListContains.kt");
        }

        @TestMetadata("strListRemove.kt")
        public void testStrListRemove() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/strListRemove.kt");
        }

        @TestMetadata("traitImplInheritsTraitImpl.kt")
        public void testTraitImplInheritsTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/traitImplInheritsTraitImpl.kt");
        }

        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges.kt");
        }

        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges2.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges2() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges2.kt");
        }

        @TestMetadata("twoParentsWithTheSameMethodOneBridge.kt")
        public void testTwoParentsWithTheSameMethodOneBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithTheSameMethodOneBridge.kt");
        }

        @TestMetadata("typeParameterInExtensionReceiver.kt")
        public void testTypeParameterInExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/typeParameterInExtensionReceiver.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SubstitutionInSuperClass extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractFun.kt")
            public void testAbstractFun() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/abstractFun.kt");
            }

            public void testAllFilesPresentInSubstitutionInSuperClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bridges/substitutionInSuperClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("boundedTypeArguments.kt")
            public void testBoundedTypeArguments() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/boundedTypeArguments.kt");
            }

            @TestMetadata("delegation.kt")
            public void testDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/delegation.kt");
            }

            @TestMetadata("differentErasureInSuperClass.kt")
            public void testDifferentErasureInSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClass.kt");
            }

            @TestMetadata("differentErasureInSuperClassComplex.kt")
            public void testDifferentErasureInSuperClassComplex() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClassComplex.kt");
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/enum.kt");
            }

            @TestMetadata("genericMethod.kt")
            public void testGenericMethod() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/genericMethod.kt");
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/object.kt");
            }

            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/property.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/simple.kt");
            }

            @TestMetadata("upperBound.kt")
            public void testUpperBound() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/upperBound.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BuiltinStubMethods extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("abstractMember.kt")
        public void testAbstractMember() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/abstractMember.kt");
        }

        public void testAllFilesPresentInBuiltinStubMethods() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("Collection.kt")
        public void testCollection() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Collection.kt");
        }

        @TestMetadata("customReadOnlyIterator.kt")
        public void testCustomReadOnlyIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/customReadOnlyIterator.kt");
        }

        @TestMetadata("delegationToArrayList.kt")
        public void testDelegationToArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/delegationToArrayList.kt");
        }

        @TestMetadata("immutableRemove.kt")
        public void testImmutableRemove() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/immutableRemove.kt");
        }

        @TestMetadata("implementationInTrait.kt")
        public void testImplementationInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/implementationInTrait.kt");
        }

        @TestMetadata("inheritedImplementations.kt")
        public void testInheritedImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/inheritedImplementations.kt");
        }

        @TestMetadata("int2IntMap.kt")
        public void testInt2IntMap() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/int2IntMap.kt");
        }

        @TestMetadata("Iterator.kt")
        public void testIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Iterator.kt");
        }

        @TestMetadata("IteratorWithRemove.kt")
        public void testIteratorWithRemove() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/IteratorWithRemove.kt");
        }

        @TestMetadata("List.kt")
        public void testList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/List.kt");
        }

        @TestMetadata("ListIterator.kt")
        public void testListIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListIterator.kt");
        }

        @TestMetadata("ListWithAllImplementations.kt")
        public void testListWithAllImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListWithAllImplementations.kt");
        }

        @TestMetadata("ListWithAllInheritedImplementations.kt")
        public void testListWithAllInheritedImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListWithAllInheritedImplementations.kt");
        }

        @TestMetadata("manyTypeParametersWithUpperBounds.kt")
        public void testManyTypeParametersWithUpperBounds() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/manyTypeParametersWithUpperBounds.kt");
        }

        @TestMetadata("Map.kt")
        public void testMap() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Map.kt");
        }

        @TestMetadata("MapEntry.kt")
        public void testMapEntry() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapEntry.kt");
        }

        @TestMetadata("MapEntryWithSetValue.kt")
        public void testMapEntryWithSetValue() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapEntryWithSetValue.kt");
        }

        @TestMetadata("MapWithAllImplementations.kt")
        public void testMapWithAllImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapWithAllImplementations.kt");
        }

        @TestMetadata("nonTrivialSubstitution.kt")
        public void testNonTrivialSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/nonTrivialSubstitution.kt");
        }

        @TestMetadata("nonTrivialUpperBound.kt")
        public void testNonTrivialUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/nonTrivialUpperBound.kt");
        }

        @TestMetadata("substitutedIterable.kt")
        public void testSubstitutedIterable() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/substitutedIterable.kt");
        }

        @TestMetadata("SubstitutedList.kt")
        public void testSubstitutedList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/SubstitutedList.kt");
        }

        @TestMetadata("substitutedListWithExtraSuperInterface.kt")
        public void testSubstitutedListWithExtraSuperInterface() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/substitutedListWithExtraSuperInterface.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BridgesForStubs extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBridgesForStubs() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("derivedEmptyListAdd.kt")
            public void testDerivedEmptyListAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyListAdd.kt");
            }

            @TestMetadata("derivedEmptyListSeveralModulesAdd.kt")
            public void testDerivedEmptyListSeveralModulesAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyListSeveralModulesAdd.kt");
            }

            @TestMetadata("derivedEmptyStringListAdd.kt")
            public void testDerivedEmptyStringListAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyStringListAdd.kt");
            }

            @TestMetadata("emptyListAdd.kt")
            public void testEmptyListAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListAdd.kt");
            }

            @TestMetadata("emptyListAddWithIndex.kt")
            public void testEmptyListAddWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListAddWithIndex.kt");
            }

            @TestMetadata("emptyListSet.kt")
            public void testEmptyListSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListSet.kt");
            }

            @TestMetadata("emptyStringListAdd.kt")
            public void testEmptyStringListAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyStringListAdd.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtendJavaClasses extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractList.kt")
            public void testAbstractList() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractList.kt");
            }

            @TestMetadata("abstractMap.kt")
            public void testAbstractMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractMap.kt");
            }

            @TestMetadata("abstractSet.kt")
            public void testAbstractSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractSet.kt");
            }

            public void testAllFilesPresentInExtendJavaClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("arrayList.kt")
            public void testArrayList() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/arrayList.kt");
            }

            @TestMetadata("charSequenceGetOverriddenInJavaSuperClass.kt")
            public void testCharSequenceGetOverriddenInJavaSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/charSequenceGetOverriddenInJavaSuperClass.kt");
            }

            @TestMetadata("extendArrayListThroughKotlin.kt")
            public void testExtendArrayListThroughKotlin() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/extendArrayListThroughKotlin.kt");
            }

            @TestMetadata("hashMap.kt")
            public void testHashMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/hashMap.kt");
            }

            @TestMetadata("hashSet.kt")
            public void testHashSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/hashSet.kt");
            }

            @TestMetadata("mapEntry.kt")
            public void testMapEntry() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/mapEntry.kt");
            }

            @TestMetadata("numberMixedHierarchy.kt")
            public void testNumberMixedHierarchy() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/numberMixedHierarchy.kt");
            }

            @TestMetadata("removeAtBridgeToJavaClass.kt")
            public void testRemoveAtBridgeToJavaClass() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaClass.kt");
            }

            @TestMetadata("removeAtBridgeToJavaDefault.kt")
            public void testRemoveAtBridgeToJavaDefault() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaDefault.kt");
            }

            @TestMetadata("removeAtBridgeToJavaSuperClass.kt")
            public void testRemoveAtBridgeToJavaSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaSuperClass.kt");
            }

            @TestMetadata("superCallToFakeRemoveAt.kt")
            public void testSuperCallToFakeRemoveAt() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToFakeRemoveAt.kt");
            }

            @TestMetadata("superCallToRemoveAt.kt")
            public void testSuperCallToRemoveAt() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToRemoveAt.kt");
            }

            @TestMetadata("superCallToRemoveAtInJavaDefault.kt")
            public void testSuperCallToRemoveAtInJavaDefault() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToRemoveAtInJavaDefault.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MapGetOrDefault extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMapGetOrDefault() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("noTypeSafeBridge.kt")
            public void testNoTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/noTypeSafeBridge.kt");
            }

            @TestMetadata("typeSafeBridge.kt")
            public void testTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/typeSafeBridge.kt");
            }

            @TestMetadata("typeSafeBridgeNotNullAny.kt")
            public void testTypeSafeBridgeNotNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/typeSafeBridgeNotNullAny.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapRemove")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MapRemove extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMapRemove() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapRemove"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("noDefaultImpls.kt")
            public void testNoDefaultImpls() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/noDefaultImpls.kt");
            }

            @TestMetadata("readOnlyMap.kt")
            public void testReadOnlyMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/readOnlyMap.kt");
            }

            @TestMetadata("typeSafeBridge.kt")
            public void testTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/typeSafeBridge.kt");
            }

            @TestMetadata("typeSafeBridgeNotNullAny.kt")
            public void testTypeSafeBridgeNotNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/typeSafeBridgeNotNullAny.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt16752.kt")
        public void ignoreKt16752() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt16752.kt");
        }

        @TestMetadata("kt21014.kt")
        public void ignoreKt21014() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt21014.kt");
        }

        @TestMetadata("kt21092a.kt")
        public void ignoreKt21092a() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt21092a.kt");
        }

        @TestMetadata("kt21092b.kt")
        public void ignoreKt21092b() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt21092b.kt");
        }

        @TestMetadata("kt49526_sam.kt")
        public void ignoreKt49526_sam() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526_sam.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCallableReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayConstructor.kt");
        }

        @TestMetadata("arrayConstructorArgument.kt")
        public void testArrayConstructorArgument() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayConstructorArgument.kt");
        }

        @TestMetadata("arrayOf.kt")
        public void testArrayOf() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayOf.kt");
        }

        @TestMetadata("builtinFunctionReferenceOwner.kt")
        public void testBuiltinFunctionReferenceOwner() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/builtinFunctionReferenceOwner.kt");
        }

        @TestMetadata("callableReferenceOfCompanionConst.kt")
        public void testCallableReferenceOfCompanionConst() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionConst.kt");
        }

        @TestMetadata("callableReferenceOfCompanionMethod.kt")
        public void testCallableReferenceOfCompanionMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionMethod.kt");
        }

        @TestMetadata("callableReferenceOfCompanionProperty.kt")
        public void testCallableReferenceOfCompanionProperty() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionProperty.kt");
        }

        @TestMetadata("callableReferenceOfJavaNestedClass.kt")
        public void testCallableReferenceOfJavaNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfJavaNestedClass.kt");
        }

        @TestMetadata("callableReferenceOfKotlinNestedClass.kt")
        public void testCallableReferenceOfKotlinNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfKotlinNestedClass.kt");
        }

        @TestMetadata("callableReferenceOfNestedClass.kt")
        public void testCallableReferenceOfNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfNestedClass.kt");
        }

        @TestMetadata("callableReferenceOfObjectMethod.kt")
        public void testCallableReferenceOfObjectMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfObjectMethod.kt");
        }

        @TestMetadata("callableReferenceOfStaticField.kt")
        public void testCallableReferenceOfStaticField() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfStaticField.kt");
        }

        @TestMetadata("callableReferenceOfStaticMethod.kt")
        public void testCallableReferenceOfStaticMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfStaticMethod.kt");
        }

        @TestMetadata("charArrayOf.kt")
        public void testCharArrayOf() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/charArrayOf.kt");
        }

        @TestMetadata("classesAreSynthetic.kt")
        public void testClassesAreSynthetic() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/classesAreSynthetic.kt");
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/constructor.kt");
        }

        @TestMetadata("genericConstructorReference.kt")
        public void testGenericConstructorReference() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/genericConstructorReference.kt");
        }

        @TestMetadata("genericLocalClassConstructorReference.kt")
        public void testGenericLocalClassConstructorReference() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/genericLocalClassConstructorReference.kt");
        }

        @TestMetadata("inlineArrayConstructors.kt")
        public void testInlineArrayConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/inlineArrayConstructors.kt");
        }

        @TestMetadata("javaField.kt")
        public void testJavaField() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/javaField.kt");
        }

        @TestMetadata("kt16412.kt")
        public void testKt16412() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt16412.kt");
        }

        @TestMetadata("kt37604.kt")
        public void testKt37604() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt37604.kt");
        }

        @TestMetadata("kt44483.kt")
        public void testKt44483() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt44483.kt");
        }

        @TestMetadata("kt46902.kt")
        public void testKt46902() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt46902.kt");
        }

        @TestMetadata("kt47988.kt")
        public void testKt47988() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt47988.kt");
        }

        @TestMetadata("kt49526.kt")
        public void testKt49526() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526.kt");
        }

        @TestMetadata("kt49526a.kt")
        public void testKt49526a() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526a.kt");
        }

        @TestMetadata("kt49526b.kt")
        public void testKt49526b() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526b.kt");
        }

        @TestMetadata("kt50172.kt")
        public void testKt50172() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt50172.kt");
        }

        @TestMetadata("kt51844.kt")
        public void testKt51844() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt51844.kt");
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/nested.kt");
        }

        @TestMetadata("optimizedSuperclasses_after.kt")
        public void testOptimizedSuperclasses_after() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/optimizedSuperclasses_after.kt");
        }

        @TestMetadata("optimizedSuperclasses_before.kt")
        public void testOptimizedSuperclasses_before() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/optimizedSuperclasses_before.kt");
        }

        @TestMetadata("publicFinalField.kt")
        public void testPublicFinalField() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/publicFinalField.kt");
        }

        @TestMetadata("publicMutableField.kt")
        public void testPublicMutableField() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/publicMutableField.kt");
        }

        @TestMetadata("staticMethod.kt")
        public void testStaticMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/staticMethod.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/adaptedReferences")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AdaptedReferences extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("adaptedArrayOf.kt")
            public void testAdaptedArrayOf() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/adaptedArrayOf.kt");
            }

            @TestMetadata("adaptedVarargFunImportedFromObject.kt")
            public void testAdaptedVarargFunImportedFromObject() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/adaptedVarargFunImportedFromObject.kt");
            }

            public void testAllFilesPresentInAdaptedReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("bothWithCoercionToUnit.kt")
            public void testBothWithCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/bothWithCoercionToUnit.kt");
            }

            @TestMetadata("boundReferences.kt")
            public void testBoundReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/boundReferences.kt");
            }

            @TestMetadata("defaultAfterVararg.kt")
            public void testDefaultAfterVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/defaultAfterVararg.kt");
            }

            @TestMetadata("defaultWithGenericExpectedType.kt")
            public void testDefaultWithGenericExpectedType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/defaultWithGenericExpectedType.kt");
            }

            @TestMetadata("emptyVarargAndDefault.kt")
            public void testEmptyVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/emptyVarargAndDefault.kt");
            }

            @TestMetadata("inlineBound.kt")
            public void testInlineBound() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineBound.kt");
            }

            @TestMetadata("inlineDefault.kt")
            public void testInlineDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineDefault.kt");
            }

            @TestMetadata("inlineVararg.kt")
            public void testInlineVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVararg.kt");
            }

            @TestMetadata("inlineVarargAndDefault.kt")
            public void testInlineVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
            }

            @TestMetadata("inlineVarargInts.kt")
            public void testInlineVarargInts() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVarargInts.kt");
            }

            @TestMetadata("innerConstructorWithVararg.kt")
            public void testInnerConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/innerConstructorWithVararg.kt");
            }

            @TestMetadata("jvmStatic.kt")
            public void testJvmStatic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/jvmStatic.kt");
            }

            @TestMetadata("largeVararg.kt")
            public void testLargeVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/largeVararg.kt");
            }

            @TestMetadata("localFunctionWithDefault.kt")
            public void testLocalFunctionWithDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/localFunctionWithDefault.kt");
            }

            @TestMetadata("manyDefaultsAndVararg.kt")
            public void testManyDefaultsAndVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/manyDefaultsAndVararg.kt");
            }

            @TestMetadata("noAdaptedReferencesIfNoOptimizedReferencesEnabled.kt")
            public void testNoAdaptedReferencesIfNoOptimizedReferencesEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noAdaptedReferencesIfNoOptimizedReferencesEnabled.kt");
            }

            @TestMetadata("noNameClashForReferencesToSameFunction.kt")
            public void testNoNameClashForReferencesToSameFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noNameClashForReferencesToSameFunction.kt");
            }

            @TestMetadata("noReflectionForAdaptedCallableReferences.kt")
            public void testNoReflectionForAdaptedCallableReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noReflectionForAdaptedCallableReferences.kt");
            }

            @TestMetadata("noReflectionForAdaptedCallableReferencesWithSuspendConversion.kt")
            public void testNoReflectionForAdaptedCallableReferencesWithSuspendConversion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noReflectionForAdaptedCallableReferencesWithSuspendConversion.kt");
            }

            @TestMetadata("referenceToVarargWithDefaults.kt")
            public void testReferenceToVarargWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/referenceToVarargWithDefaults.kt");
            }

            @TestMetadata("reflectionForVarargAsArray.kt")
            public void testReflectionForVarargAsArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/reflectionForVarargAsArray.kt");
            }

            @TestMetadata("simpleDefaultArgument.kt")
            public void testSimpleDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/simpleDefaultArgument.kt");
            }

            @TestMetadata("simpleEmptyVararg.kt")
            public void testSimpleEmptyVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/simpleEmptyVararg.kt");
            }

            @TestMetadata("suspendUnitConversion.kt")
            public void testSuspendUnitConversion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendUnitConversion.kt");
            }

            @TestMetadata("toStringNoReflect.kt")
            public void testToStringNoReflect() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/toStringNoReflect.kt");
            }

            @TestMetadata("unboundReferences.kt")
            public void testUnboundReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/unboundReferences.kt");
            }

            @TestMetadata("varargFromBaseClass.kt")
            public void testVarargFromBaseClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargFromBaseClass.kt");
            }

            @TestMetadata("varargViewedAsArray.kt")
            public void testVarargViewedAsArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargViewedAsArray.kt");
            }

            @TestMetadata("varargViewedAsPrimitiveArray.kt")
            public void testVarargViewedAsPrimitiveArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargViewedAsPrimitiveArray.kt");
            }

            @TestMetadata("varargWithDefaultValue.kt")
            public void testVarargWithDefaultValue() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargWithDefaultValue.kt");
            }

            @TestMetadata("withReceiver.kt")
            public void testWithReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/withReceiver.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SuspendConversion extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                @TestMetadata("adaptedWithCoercionToUnit.kt")
                public void testAdaptedWithCoercionToUnit() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithCoercionToUnit.kt");
                }

                @TestMetadata("adaptedWithDefaultArguments.kt")
                public void testAdaptedWithDefaultArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithDefaultArguments.kt");
                }

                @TestMetadata("adaptedWithVarargs.kt")
                public void testAdaptedWithVarargs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithVarargs.kt");
                }

                public void testAllFilesPresentInSuspendConversion() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("bound.kt")
                public void testBound() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/bound.kt");
                }

                @TestMetadata("boundExtension.kt")
                public void testBoundExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/boundExtension.kt");
                }

                @TestMetadata("crossInline.kt")
                public void testCrossInline() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/crossInline.kt");
                }

                @TestMetadata("inlineAdaptedWithCoercionToUnit.kt")
                public void testInlineAdaptedWithCoercionToUnit() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithCoercionToUnit.kt");
                }

                @TestMetadata("inlineAdaptedWithDefaultArguments.kt")
                public void testInlineAdaptedWithDefaultArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithDefaultArguments.kt");
                }

                @TestMetadata("inlineAdaptedWithVarargs.kt")
                public void testInlineAdaptedWithVarargs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithVarargs.kt");
                }

                @TestMetadata("inlineBound.kt")
                public void testInlineBound() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineBound.kt");
                }

                @TestMetadata("inlineSimple.kt")
                public void testInlineSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineSimple.kt");
                }

                @TestMetadata("inlineWithParameters.kt")
                public void testInlineWithParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithParameters.kt");
                }

                @TestMetadata("isAs.kt")
                public void testIsAs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/isAs.kt");
                }

                @TestMetadata("nullableParameter.kt")
                public void testNullableParameter() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/nullableParameter.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/simple.kt");
                }

                @TestMetadata("withParameters.kt")
                public void testWithParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/withParameters.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractLightAnalysisModeTest {
            @TestMetadata("kt44636_localExtension.kt")
            public void ignoreKt44636_localExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt44636_localExtension.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("adapted.kt")
            public void testAdapted() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/adapted.kt");
            }

            public void testAllFilesPresentInBound() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/array.kt");
            }

            @TestMetadata("arrayConstructorArgument.kt")
            public void testArrayConstructorArgument() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/arrayConstructorArgument.kt");
            }

            @TestMetadata("arrayGetIntrinsic.kt")
            public void testArrayGetIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/arrayGetIntrinsic.kt");
            }

            @TestMetadata("boundJvmFieldInInterfaceCompanion.kt")
            public void testBoundJvmFieldInInterfaceCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/boundJvmFieldInInterfaceCompanion.kt");
            }

            @TestMetadata("boundReferenceToOverloadedFunction.kt")
            public void testBoundReferenceToOverloadedFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/boundReferenceToOverloadedFunction.kt");
            }

            @TestMetadata("captureVarInInitBlock.kt")
            public void testCaptureVarInInitBlock() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/captureVarInInitBlock.kt");
            }

            @TestMetadata("captureVarInPropertyInit.kt")
            public void testCaptureVarInPropertyInit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/captureVarInPropertyInit.kt");
            }

            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/coercionToUnit.kt");
            }

            @TestMetadata("companionObjectReceiver.kt")
            public void testCompanionObjectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/companionObjectReceiver.kt");
            }

            @TestMetadata("dontShareReceiver.kt")
            public void testDontShareReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/dontShareReceiver.kt");
            }

            @TestMetadata("emptyLHS.kt")
            public void testEmptyLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/emptyLHS.kt");
            }

            @TestMetadata("enumEntryMember.kt")
            public void testEnumEntryMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/enumEntryMember.kt");
            }

            @TestMetadata("genericBoundPropertyAsCrossinline.kt")
            public void testGenericBoundPropertyAsCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/genericBoundPropertyAsCrossinline.kt");
            }

            @TestMetadata("genericValOnLHS.kt")
            public void testGenericValOnLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/genericValOnLHS.kt");
            }

            @TestMetadata("javaField.kt")
            public void testJavaField() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/javaField.kt");
            }

            @TestMetadata("kCallableNameIntrinsic.kt")
            public void testKCallableNameIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kCallableNameIntrinsic.kt");
            }

            @TestMetadata("kt12738.kt")
            public void testKt12738() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt12738.kt");
            }

            @TestMetadata("kt15446.kt")
            public void testKt15446() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt15446.kt");
            }

            @TestMetadata("localUnitFunction.kt")
            public void testLocalUnitFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/localUnitFunction.kt");
            }

            @TestMetadata("multiCase.kt")
            public void testMultiCase() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/multiCase.kt");
            }

            @TestMetadata("nullReceiver.kt")
            public void testNullReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/nullReceiver.kt");
            }

            @TestMetadata("objectReceiver.kt")
            public void testObjectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/objectReceiver.kt");
            }

            @TestMetadata("primitiveReceiver.kt")
            public void testPrimitiveReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/primitiveReceiver.kt");
            }

            @TestMetadata("receiverEvaluatedOnce.kt")
            public void testReceiverEvaluatedOnce() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/receiverEvaluatedOnce.kt");
            }

            @TestMetadata("referenceToGetSetMethodsFromVararg.kt")
            public void testReferenceToGetSetMethodsFromVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/referenceToGetSetMethodsFromVararg.kt");
            }

            @TestMetadata("simpleFunction.kt")
            public void testSimpleFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/simpleFunction.kt");
            }

            @TestMetadata("simpleProperty.kt")
            public void testSimpleProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/simpleProperty.kt");
            }

            @TestMetadata("smartCastForExtensionReceiver.kt")
            public void testSmartCastForExtensionReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/smartCastForExtensionReceiver.kt");
            }

            @TestMetadata("syntheticExtensionOnLHS.kt")
            public void testSyntheticExtensionOnLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/syntheticExtensionOnLHS.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/bound/equals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Equals extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInEquals() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound/equals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("nullableReceiverInEquals.kt")
                public void testNullableReceiverInEquals() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/nullableReceiverInEquals.kt");
                }

                @TestMetadata("receiverInEquals.kt")
                public void testReceiverInEquals() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/receiverInEquals.kt");
                }

                @TestMetadata("reflectionReference.kt")
                public void testReflectionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/reflectionReference.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/equality")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equality extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInEquality() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/equality"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("capturedDefaults.kt")
            public void testCapturedDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/capturedDefaults.kt");
            }

            @TestMetadata("capturedVararg.kt")
            public void testCapturedVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/capturedVararg.kt");
            }

            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnit.kt");
            }

            @TestMetadata("coercionToUnitWithDefaults.kt")
            public void testCoercionToUnitWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnitWithDefaults.kt");
            }

            @TestMetadata("coercionToUnitWithVararg.kt")
            public void testCoercionToUnitWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnitWithVararg.kt");
            }

            @TestMetadata("extensionReceiverVsDefault.kt")
            public void testExtensionReceiverVsDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/extensionReceiverVsDefault.kt");
            }

            @TestMetadata("noCoercionToUnitIfFunctionAlreadyReturnsUnit.kt")
            public void testNoCoercionToUnitIfFunctionAlreadyReturnsUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/noCoercionToUnitIfFunctionAlreadyReturnsUnit.kt");
            }

            @TestMetadata("simpleEquality.kt")
            public void testSimpleEquality() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/simpleEquality.kt");
            }

            @TestMetadata("suspendConversion.kt")
            public void testSuspendConversion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/suspendConversion.kt");
            }

            @TestMetadata("varargAsArrayMemberOrExtension.kt")
            public void testVarargAsArrayMemberOrExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargAsArrayMemberOrExtension.kt");
            }

            @TestMetadata("varargAsArrayWithDefaults.kt")
            public void testVarargAsArrayWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargAsArrayWithDefaults.kt");
            }

            @TestMetadata("varargWithDefaults.kt")
            public void testVarargWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargWithDefaults.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/funInterfaceConstructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunInterfaceConstructor extends AbstractLightAnalysisModeTest {
            @TestMetadata("funInterfaceConstructedObjectsEquality.kt")
            public void ignoreFunInterfaceConstructedObjectsEquality() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructedObjectsEquality.kt");
            }

            @TestMetadata("funInterfaceConstructor.kt")
            public void ignoreFunInterfaceConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructor.kt");
            }

            @TestMetadata("funInterfaceConstructorOfImplicitKFunctionType.kt")
            public void ignoreFunInterfaceConstructorOfImplicitKFunctionType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorOfImplicitKFunctionType.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunInterfaceConstructor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/funInterfaceConstructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractClassMember.kt")
            public void testAbstractClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/abstractClassMember.kt");
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("argumentTypes.kt")
            public void testArgumentTypes() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/argumentTypes.kt");
            }

            @TestMetadata("argumentTypesNoinline.kt")
            public void testArgumentTypesNoinline() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/argumentTypesNoinline.kt");
            }

            @TestMetadata("booleanNotIntrinsic.kt")
            public void testBooleanNotIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/booleanNotIntrinsic.kt");
            }

            @TestMetadata("classMemberFromClass.kt")
            public void testClassMemberFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromClass.kt");
            }

            @TestMetadata("classMemberFromCompanionObject.kt")
            public void testClassMemberFromCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromCompanionObject.kt");
            }

            @TestMetadata("classMemberFromExtension.kt")
            public void testClassMemberFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromExtension.kt");
            }

            @TestMetadata("classMemberFromTopLevelStringNoArgs.kt")
            public void testClassMemberFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("classMemberFromTopLevelStringOneStringArg.kt")
            public void testClassMemberFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("classMemberFromTopLevelUnitNoArgs.kt")
            public void testClassMemberFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("classMemberFromTopLevelUnitOneStringArg.kt")
            public void testClassMemberFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/coercionToUnit.kt");
            }

            @TestMetadata("constructorFromTopLevelNoArgs.kt")
            public void testConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("constructorFromTopLevelOneStringArg.kt")
            public void testConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("dispatchReceiverType.kt")
            public void testDispatchReceiverType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/dispatchReceiverType.kt");
            }

            @TestMetadata("enumValueOfMethod.kt")
            public void testEnumValueOfMethod() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/enumValueOfMethod.kt");
            }

            @TestMetadata("equalsIntrinsic.kt")
            public void testEqualsIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/equalsIntrinsic.kt");
            }

            @TestMetadata("extensionFromClass.kt")
            public void testExtensionFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromClass.kt");
            }

            @TestMetadata("extensionFromExtension.kt")
            public void testExtensionFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromExtension.kt");
            }

            @TestMetadata("extensionFromTopLevelStringNoArgs.kt")
            public void testExtensionFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("extensionFromTopLevelStringOneStringArg.kt")
            public void testExtensionFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("extensionFromTopLevelUnitNoArgs.kt")
            public void testExtensionFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("extensionFromTopLevelUnitOneStringArg.kt")
            public void testExtensionFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("extensionProperty.kt")
            public void testExtensionProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionProperty.kt");
            }

            @TestMetadata("genericCallableReferenceArguments.kt")
            public void testGenericCallableReferenceArguments() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferenceArguments.kt");
            }

            @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
            public void testGenericCallableReferencesWithNullableTypes() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
            }

            @TestMetadata("genericCallableReferencesWithOverload.kt")
            public void testGenericCallableReferencesWithOverload() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithOverload.kt");
            }

            @TestMetadata("genericMember.kt")
            public void testGenericMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericMember.kt");
            }

            @TestMetadata("genericWithDependentType.kt")
            public void testGenericWithDependentType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericWithDependentType.kt");
            }

            @TestMetadata("getArityViaFunctionImpl.kt")
            public void testGetArityViaFunctionImpl() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/getArityViaFunctionImpl.kt");
            }

            @TestMetadata("innerClassConstructorWithTwoReceivers.kt")
            public void testInnerClassConstructorWithTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerClassConstructorWithTwoReceivers.kt");
            }

            @TestMetadata("innerConstructorFromClass.kt")
            public void testInnerConstructorFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromClass.kt");
            }

            @TestMetadata("innerConstructorFromExtension.kt")
            public void testInnerConstructorFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromExtension.kt");
            }

            @TestMetadata("innerConstructorFromTopLevelNoArgs.kt")
            public void testInnerConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("innerConstructorFromTopLevelOneStringArg.kt")
            public void testInnerConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("javaCollectionsStaticMethod.kt")
            public void testJavaCollectionsStaticMethod() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/javaCollectionsStaticMethod.kt");
            }

            @TestMetadata("kt21787.kt")
            public void testKt21787() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt21787.kt");
            }

            @TestMetadata("kt32462.kt")
            public void testKt32462() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt32462.kt");
            }

            @TestMetadata("kt47741.kt")
            public void testKt47741() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt47741.kt");
            }

            @TestMetadata("nestedConstructorFromClass.kt")
            public void testNestedConstructorFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromClass.kt");
            }

            @TestMetadata("nestedConstructorFromTopLevelNoArgs.kt")
            public void testNestedConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("nestedConstructorFromTopLevelOneStringArg.kt")
            public void testNestedConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("newArray.kt")
            public void testNewArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/newArray.kt");
            }

            @TestMetadata("overloadedFun.kt")
            public void testOverloadedFun() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/overloadedFun.kt");
            }

            @TestMetadata("overloadedFunVsVal.kt")
            public void testOverloadedFunVsVal() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/overloadedFunVsVal.kt");
            }

            @TestMetadata("privateClassMember.kt")
            public void testPrivateClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/privateClassMember.kt");
            }

            @TestMetadata("referenceToCompanionMember.kt")
            public void testReferenceToCompanionMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/referenceToCompanionMember.kt");
            }

            @TestMetadata("sortListOfStrings.kt")
            public void testSortListOfStrings() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/sortListOfStrings.kt");
            }

            @TestMetadata("specialCalls.kt")
            public void testSpecialCalls() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/specialCalls.kt");
            }

            @TestMetadata("staticFunctionReference.kt")
            public void testStaticFunctionReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/staticFunctionReference.kt");
            }

            @TestMetadata("topLevelFromClass.kt")
            public void testTopLevelFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromClass.kt");
            }

            @TestMetadata("topLevelFromExtension.kt")
            public void testTopLevelFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromExtension.kt");
            }

            @TestMetadata("topLevelFromTopLevelStringNoArgs.kt")
            public void testTopLevelFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("topLevelFromTopLevelStringOneStringArg.kt")
            public void testTopLevelFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("topLevelFromTopLevelUnitManyArgs.kt")
            public void testTopLevelFromTopLevelUnitManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitManyArgs.kt");
            }

            @TestMetadata("topLevelFromTopLevelUnitNoArgs.kt")
            public void testTopLevelFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("topLevelFromTopLevelUnitOneStringArg.kt")
            public void testTopLevelFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("traitImplMethodWithClassReceiver.kt")
            public void testTraitImplMethodWithClassReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/traitImplMethodWithClassReceiver.kt");
            }

            @TestMetadata("traitMember.kt")
            public void testTraitMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/traitMember.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/function/local")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Local extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInLocal() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("captureOuter.kt")
                public void testCaptureOuter() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/captureOuter.kt");
                }

                @TestMetadata("classMember.kt")
                public void testClassMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/classMember.kt");
                }

                @TestMetadata("closureWithSideEffect.kt")
                public void testClosureWithSideEffect() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/closureWithSideEffect.kt");
                }

                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/constructor.kt");
                }

                @TestMetadata("constructorWithInitializer.kt")
                public void testConstructorWithInitializer() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/constructorWithInitializer.kt");
                }

                @TestMetadata("enumExtendsTrait.kt")
                public void testEnumExtendsTrait() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/enumExtendsTrait.kt");
                }

                @TestMetadata("equalsHashCode.kt")
                public void testEqualsHashCode() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/equalsHashCode.kt");
                }

                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extension.kt");
                }

                @TestMetadata("extensionToLocalClass.kt")
                public void testExtensionToLocalClass() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToLocalClass.kt");
                }

                @TestMetadata("extensionToPrimitive.kt")
                public void testExtensionToPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToPrimitive.kt");
                }

                @TestMetadata("extensionWithClosure.kt")
                public void testExtensionWithClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionWithClosure.kt");
                }

                @TestMetadata("genericMember.kt")
                public void testGenericMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/genericMember.kt");
                }

                @TestMetadata("localClassMember.kt")
                public void testLocalClassMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localClassMember.kt");
                }

                @TestMetadata("localFunctionName.kt")
                public void testLocalFunctionName() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localFunctionName.kt");
                }

                @TestMetadata("localLocal.kt")
                public void testLocalLocal() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localLocal.kt");
                }

                @TestMetadata("recursiveClosure.kt")
                public void testRecursiveClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/recursiveClosure.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simple.kt");
                }

                @TestMetadata("simpleClosure.kt")
                public void testSimpleClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simpleClosure.kt");
                }

                @TestMetadata("simpleWithArg.kt")
                public void testSimpleWithArg() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simpleWithArg.kt");
                }

                @TestMetadata("unitWithSideEffect.kt")
                public void testUnitWithSideEffect() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/unitWithSideEffect.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("accessViaSubclass.kt")
            public void testAccessViaSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/accessViaSubclass.kt");
            }

            @TestMetadata("accessorForPropertyWithPrivateSetter.kt")
            public void testAccessorForPropertyWithPrivateSetter() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/accessorForPropertyWithPrivateSetter.kt");
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("delegated.kt")
            public void testDelegated() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/delegated.kt");
            }

            @TestMetadata("delegatedMutable.kt")
            public void testDelegatedMutable() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/delegatedMutable.kt");
            }

            @TestMetadata("enumNameOrdinal.kt")
            public void testEnumNameOrdinal() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/enumNameOrdinal.kt");
            }

            @TestMetadata("extensionToArray.kt")
            public void testExtensionToArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/extensionToArray.kt");
            }

            @TestMetadata("genericProperty.kt")
            public void testGenericProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/genericProperty.kt");
            }

            @TestMetadata("inEnum.kt")
            public void testInEnum() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/inEnum.kt");
            }

            @TestMetadata("inReceiverOfAnother.kt")
            public void testInReceiverOfAnother() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/inReceiverOfAnother.kt");
            }

            @TestMetadata("invokePropertyReference.kt")
            public void testInvokePropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/invokePropertyReference.kt");
            }

            @TestMetadata("javaBeanConvention.kt")
            public void testJavaBeanConvention() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/javaBeanConvention.kt");
            }

            @TestMetadata("kClassInstanceIsInitializedFirst.kt")
            public void testKClassInstanceIsInitializedFirst() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kClassInstanceIsInitializedFirst.kt");
            }

            @TestMetadata("kt12044.kt")
            public void testKt12044() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt12044.kt");
            }

            @TestMetadata("kt12982_protectedPropertyReference.kt")
            public void testKt12982_protectedPropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt12982_protectedPropertyReference.kt");
            }

            @TestMetadata("kt14330.kt")
            public void testKt14330() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt14330.kt");
            }

            @TestMetadata("kt14330_2.kt")
            public void testKt14330_2() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt14330_2.kt");
            }

            @TestMetadata("kt15447.kt")
            public void testKt15447() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt15447.kt");
            }

            @TestMetadata("kt6870_privatePropertyReference.kt")
            public void testKt6870_privatePropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt6870_privatePropertyReference.kt");
            }

            @TestMetadata("listOfStringsMapLength.kt")
            public void testListOfStringsMapLength() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/listOfStringsMapLength.kt");
            }

            @TestMetadata("localClassVar.kt")
            public void testLocalClassVar() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/localClassVar.kt");
            }

            @TestMetadata("overriddenInSubclass.kt")
            public void testOverriddenInSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/overriddenInSubclass.kt");
            }

            @TestMetadata("privateSetOuterClass.kt")
            public void testPrivateSetOuterClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetOuterClass.kt");
            }

            @TestMetadata("privateSetterInsideClass.kt")
            public void testPrivateSetterInsideClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetterInsideClass.kt");
            }

            @TestMetadata("privateSetterOutsideClass.kt")
            public void testPrivateSetterOutsideClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetterOutsideClass.kt");
            }

            @TestMetadata("receiverEvaluatedOnce.kt")
            public void testReceiverEvaluatedOnce() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/receiverEvaluatedOnce.kt");
            }

            @TestMetadata("simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleExtension.kt");
            }

            @TestMetadata("simpleMember.kt")
            public void testSimpleMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMember.kt");
            }

            @TestMetadata("simpleMutableExtension.kt")
            public void testSimpleMutableExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableExtension.kt");
            }

            @TestMetadata("simpleMutableMember.kt")
            public void testSimpleMutableMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableMember.kt");
            }

            @TestMetadata("simpleMutableTopLevel.kt")
            public void testSimpleMutableTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableTopLevel.kt");
            }

            @TestMetadata("simpleTopLevel.kt")
            public void testSimpleTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleTopLevel.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/serializability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Serializability extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("adaptedReferences.kt")
            public void testAdaptedReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/adaptedReferences.kt");
            }

            public void testAllFilesPresentInSerializability() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/serializability"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("boundWithNotSerializableReceiver.kt")
            public void testBoundWithNotSerializableReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/boundWithNotSerializableReceiver.kt");
            }

            @TestMetadata("boundWithSerializableReceiver.kt")
            public void testBoundWithSerializableReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/boundWithSerializableReceiver.kt");
            }

            @TestMetadata("noReflect.kt")
            public void testNoReflect() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/noReflect.kt");
            }

            @TestMetadata("reflectedIsNotSerialized.kt")
            public void testReflectedIsNotSerialized() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/reflectedIsNotSerialized.kt");
            }

            @TestMetadata("withReflect.kt")
            public void testWithReflect() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/withReflect.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/casts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Casts extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCasts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("as.kt")
        public void testAs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/as.kt");
        }

        @TestMetadata("asForConstants.kt")
        public void testAsForConstants() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asForConstants.kt");
        }

        @TestMetadata("asSafe.kt")
        public void testAsSafe() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafe.kt");
        }

        @TestMetadata("asSafeFail.kt")
        public void testAsSafeFail() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafeFail.kt");
        }

        @TestMetadata("asSafeForConstants.kt")
        public void testAsSafeForConstants() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafeForConstants.kt");
        }

        @TestMetadata("asThrowsNpe_1_4.kt")
        public void testAsThrowsNpe_1_4() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asThrowsNpe_1_4.kt");
        }

        @TestMetadata("asUnit.kt")
        public void testAsUnit() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asUnit.kt");
        }

        @TestMetadata("asWithGeneric.kt")
        public void testAsWithGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asWithGeneric.kt");
        }

        @TestMetadata("castGenericNull.kt")
        public void testCastGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/casts/castGenericNull.kt");
        }

        @TestMetadata("castToDefinitelyNotNullType.kt")
        public void testCastToDefinitelyNotNullType() throws Exception {
            runTest("compiler/testData/codegen/box/casts/castToDefinitelyNotNullType.kt");
        }

        @TestMetadata("dontCreateInconsistentTypeDuringStarProjectionSubstitution.kt")
        public void testDontCreateInconsistentTypeDuringStarProjectionSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/casts/dontCreateInconsistentTypeDuringStarProjectionSubstitution.kt");
        }

        @TestMetadata("intersectionTypeMultipleBounds.kt")
        public void testIntersectionTypeMultipleBounds() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBounds.kt");
        }

        @TestMetadata("intersectionTypeMultipleBoundsImplicitReceiver.kt")
        public void testIntersectionTypeMultipleBoundsImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBoundsImplicitReceiver.kt");
        }

        @TestMetadata("intersectionTypeSmartcast.kt")
        public void testIntersectionTypeSmartcast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeSmartcast.kt");
        }

        @TestMetadata("intersectionTypeWithMultipleBoundsAsReceiver.kt")
        public void testIntersectionTypeWithMultipleBoundsAsReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeWithMultipleBoundsAsReceiver.kt");
        }

        @TestMetadata("intersectionTypeWithoutGenericsAsReceiver.kt")
        public void testIntersectionTypeWithoutGenericsAsReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeWithoutGenericsAsReceiver.kt");
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/is.kt");
        }

        @TestMetadata("isNullablePrimitive.kt")
        public void testIsNullablePrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/casts/isNullablePrimitive.kt");
        }

        @TestMetadata("kt22714.kt")
        public void testKt22714() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt22714.kt");
        }

        @TestMetadata("kt48927_privateMethodOnDerivedCastToBase.kt")
        public void testKt48927_privateMethodOnDerivedCastToBase() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt48927_privateMethodOnDerivedCastToBase.kt");
        }

        @TestMetadata("kt50577.kt")
        public void testKt50577() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt50577.kt");
        }

        @TestMetadata("lambdaToUnitCast.kt")
        public void testLambdaToUnitCast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/lambdaToUnitCast.kt");
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/notIs.kt");
        }

        @TestMetadata("nullableSafeCastToTypeParameterWithInterfaceUpperBound.kt")
        public void testNullableSafeCastToTypeParameterWithInterfaceUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/casts/nullableSafeCastToTypeParameterWithInterfaceUpperBound.kt");
        }

        @TestMetadata("objectToPrimitiveWithAssertion.kt")
        public void testObjectToPrimitiveWithAssertion() throws Exception {
            runTest("compiler/testData/codegen/box/casts/objectToPrimitiveWithAssertion.kt");
        }

        @TestMetadata("unitAsAny.kt")
        public void testUnitAsAny() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsAny.kt");
        }

        @TestMetadata("unitAsInt.kt")
        public void testUnitAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsInt.kt");
        }

        @TestMetadata("unitAsSafeAny.kt")
        public void testUnitAsSafeAny() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsSafeAny.kt");
        }

        @TestMetadata("unitNullableCast.kt")
        public void testUnitNullableCast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitNullableCast.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/casts/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("asFunKBig.kt")
            public void testAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/asFunKBig.kt");
            }

            @TestMetadata("asFunKSmall.kt")
            public void testAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/asFunKSmall.kt");
            }

            @TestMetadata("isFunKBig.kt")
            public void testIsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/isFunKBig.kt");
            }

            @TestMetadata("isFunKSmall.kt")
            public void testIsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/isFunKSmall.kt");
            }

            @TestMetadata("javaTypeIsFunK.kt")
            public void testJavaTypeIsFunK() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/javaTypeIsFunK.kt");
            }

            @TestMetadata("reifiedAsFunKBig.kt")
            public void testReifiedAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKBig.kt");
            }

            @TestMetadata("reifiedAsFunKSmall.kt")
            public void testReifiedAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKSmall.kt");
            }

            @TestMetadata("reifiedIsFunKBig.kt")
            public void testReifiedIsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKBig.kt");
            }

            @TestMetadata("reifiedIsFunKSmall.kt")
            public void testReifiedIsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKSmall.kt");
            }

            @TestMetadata("reifiedSafeAsFunKBig.kt")
            public void testReifiedSafeAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKBig.kt");
            }

            @TestMetadata("reifiedSafeAsFunKSmall.kt")
            public void testReifiedSafeAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKSmall.kt");
            }

            @TestMetadata("safeAsFunKBig.kt")
            public void testSafeAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKBig.kt");
            }

            @TestMetadata("safeAsFunKSmall.kt")
            public void testSafeAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKSmall.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/javaInterop")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaInterop extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInJavaInterop() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/javaInterop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("castWithWrongType.kt")
            public void testCastWithWrongType() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/castWithWrongType.kt");
            }

            @TestMetadata("implicitNotNullWithWrongType.kt")
            public void testImplicitNotNullWithWrongType() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/implicitNotNullWithWrongType.kt");
            }

            @TestMetadata("instanceOfWithWrongType.kt")
            public void testInstanceOfWithWrongType() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/instanceOfWithWrongType.kt");
            }

            @TestMetadata("noNullCheckOnCollectionContains.kt")
            public void testNoNullCheckOnCollectionContains() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnCollectionContains.kt");
            }

            @TestMetadata("noNullCheckOnCollectionRemove.kt")
            public void testNoNullCheckOnCollectionRemove() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnCollectionRemove.kt");
            }

            @TestMetadata("noNullCheckOnListIndexOf.kt")
            public void testNoNullCheckOnListIndexOf() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnListIndexOf.kt");
            }

            @TestMetadata("noNullCheckOnListLastIndexOf.kt")
            public void testNoNullCheckOnListLastIndexOf() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnListLastIndexOf.kt");
            }

            @TestMetadata("noNullCheckOnMapContainsKey.kt")
            public void testNoNullCheckOnMapContainsKey() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapContainsKey.kt");
            }

            @TestMetadata("noNullCheckOnMapContainsValue.kt")
            public void testNoNullCheckOnMapContainsValue() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapContainsValue.kt");
            }

            @TestMetadata("noNullCheckOnMapGet.kt")
            public void testNoNullCheckOnMapGet() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapGet.kt");
            }

            @TestMetadata("noNullCheckOnMapRemove.kt")
            public void testNoNullCheckOnMapRemove() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapRemove.kt");
            }

            @TestMetadata("nullCheckOnMapGetOrDefault.kt")
            public void testNullCheckOnMapGetOrDefault() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/nullCheckOnMapGetOrDefault.kt");
            }

            @TestMetadata("nullCheckOnMapRemove2.kt")
            public void testNullCheckOnMapRemove2() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/nullCheckOnMapRemove2.kt");
            }

            @TestMetadata("safeCastWithWrongType.kt")
            public void testSafeCastWithWrongType() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/safeCastWithWrongType.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LiteralExpressionAsGenericArgument extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLiteralExpressionAsGenericArgument() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("binaryExpressionCast.kt")
            public void testBinaryExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/binaryExpressionCast.kt");
            }

            @TestMetadata("javaBox.kt")
            public void testJavaBox() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/javaBox.kt");
            }

            @TestMetadata("labeledExpressionCast.kt")
            public void testLabeledExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/labeledExpressionCast.kt");
            }

            @TestMetadata("parenthesizedExpressionCast.kt")
            public void testParenthesizedExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/parenthesizedExpressionCast.kt");
            }

            @TestMetadata("superConstructor.kt")
            public void testSuperConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/superConstructor.kt");
            }

            @TestMetadata("unaryExpressionCast.kt")
            public void testUnaryExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/unaryExpressionCast.kt");
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/vararg.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/mutableCollections")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MutableCollections extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMutableCollections() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/mutableCollections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("asWithMutable.kt")
            public void testAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/asWithMutable.kt");
            }

            @TestMetadata("isWithMutable.kt")
            public void testIsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/isWithMutable.kt");
            }

            @TestMetadata("mutabilityMarkerInterfaces.kt")
            public void testMutabilityMarkerInterfaces() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/mutabilityMarkerInterfaces.kt");
            }

            @TestMetadata("reifiedAsWithMutable.kt")
            public void testReifiedAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedAsWithMutable.kt");
            }

            @TestMetadata("reifiedIsWithMutable.kt")
            public void testReifiedIsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedIsWithMutable.kt");
            }

            @TestMetadata("reifiedSafeAsWithMutable.kt")
            public void testReifiedSafeAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedSafeAsWithMutable.kt");
            }

            @TestMetadata("safeAsWithMutable.kt")
            public void testSafeAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/safeAsWithMutable.kt");
            }

            @TestMetadata("weirdMutableCasts.kt")
            public void testWeirdMutableCasts() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/weirdMutableCasts.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/nativeCCEMessage")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NativeCCEMessage extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInNativeCCEMessage() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/nativeCCEMessage"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/checkcastOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CheckcastOptimization extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCheckcastOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/checkcastOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("kt19128.kt")
        public void testKt19128() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt19128.kt");
        }

        @TestMetadata("kt19246.kt")
        public void testKt19246() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt19246.kt");
        }

        @TestMetadata("kt47851.kt")
        public void testKt47851() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt47851.kt");
        }

        @TestMetadata("kt47851a.kt")
        public void testKt47851a() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt47851a.kt");
        }

        @TestMetadata("kt50215.kt")
        public void testKt50215() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt50215.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/classLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassLiteral extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInClassLiteral() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("bareArray.kt")
        public void testBareArray() throws Exception {
            runTest("compiler/testData/codegen/box/classLiteral/bareArray.kt");
        }

        @TestMetadata("primitiveKClassEquality.kt")
        public void testPrimitiveKClassEquality() throws Exception {
            runTest("compiler/testData/codegen/box/classLiteral/primitiveKClassEquality.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/classLiteral/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBound() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("javaIntrinsicWithSideEffect.kt")
            public void testJavaIntrinsicWithSideEffect() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/javaIntrinsicWithSideEffect.kt");
            }

            @TestMetadata("primitives.kt")
            public void testPrimitives() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/primitives.kt");
            }

            @TestMetadata("sideEffect.kt")
            public void testSideEffect() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/sideEffect.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/simple.kt");
            }

            @TestMetadata("smartCast.kt")
            public void testSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/smartCast.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/classLiteral/java")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Java extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInJava() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/java"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("java.kt")
            public void testJava() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/java.kt");
            }

            @TestMetadata("javaObjectType.kt")
            public void testJavaObjectType() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaObjectType.kt");
            }

            @TestMetadata("javaObjectTypeReified.kt")
            public void testJavaObjectTypeReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaObjectTypeReified.kt");
            }

            @TestMetadata("javaPrimitiveType.kt")
            public void testJavaPrimitiveType() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveType.kt");
            }

            @TestMetadata("javaPrimitiveTypeReified.kt")
            public void testJavaPrimitiveTypeReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveTypeReified.kt");
            }

            @TestMetadata("javaReified.kt")
            public void testJavaReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaReified.kt");
            }

            @TestMetadata("kt11943.kt")
            public void testKt11943() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/kt11943.kt");
            }

            @TestMetadata("objectSuperConstructorCall.kt")
            public void testObjectSuperConstructorCall() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/objectSuperConstructorCall.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/classes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Classes extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt40332.kt")
        public void ignoreKt40332() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt40332.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("boxPrimitiveTypeInClinitOfClassObject.kt")
        public void testBoxPrimitiveTypeInClinitOfClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/boxPrimitiveTypeInClinitOfClassObject.kt");
        }

        @TestMetadata("classCompanionInitializationWithJava.kt")
        public void testClassCompanionInitializationWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classCompanionInitializationWithJava.kt");
        }

        @TestMetadata("classNamedAsOldPackageFacade.kt")
        public void testClassNamedAsOldPackageFacade() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classNamedAsOldPackageFacade.kt");
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObject.kt");
        }

        @TestMetadata("classObjectAsExtensionReceiver.kt")
        public void testClassObjectAsExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectAsExtensionReceiver.kt");
        }

        @TestMetadata("classObjectAsStaticInitializer.kt")
        public void testClassObjectAsStaticInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectAsStaticInitializer.kt");
        }

        @TestMetadata("classObjectField.kt")
        public void testClassObjectField() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectField.kt");
        }

        @TestMetadata("classObjectInTrait.kt")
        public void testClassObjectInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectInTrait.kt");
        }

        @TestMetadata("classObjectNotOfEnum.kt")
        public void testClassObjectNotOfEnum() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectNotOfEnum.kt");
        }

        @TestMetadata("classObjectToString.kt")
        public void testClassObjectToString() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectToString.kt");
        }

        @TestMetadata("classObjectWithPrivateGenericMember.kt")
        public void testClassObjectWithPrivateGenericMember() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectWithPrivateGenericMember.kt");
        }

        @TestMetadata("classObjectsWithParentClasses.kt")
        public void testClassObjectsWithParentClasses() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectsWithParentClasses.kt");
        }

        @TestMetadata("comanionObjectFieldVsClassField.kt")
        public void testComanionObjectFieldVsClassField() throws Exception {
            runTest("compiler/testData/codegen/box/classes/comanionObjectFieldVsClassField.kt");
        }

        @TestMetadata("defaultObjectSameNamesAsInOuter.kt")
        public void testDefaultObjectSameNamesAsInOuter() throws Exception {
            runTest("compiler/testData/codegen/box/classes/defaultObjectSameNamesAsInOuter.kt");
        }

        @TestMetadata("delegateConstructorCallWithKeywords.kt")
        public void testDelegateConstructorCallWithKeywords() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegateConstructorCallWithKeywords.kt");
        }

        @TestMetadata("delegation2.kt")
        public void testDelegation2() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation2.kt");
        }

        @TestMetadata("delegation3.kt")
        public void testDelegation3() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation3.kt");
        }

        @TestMetadata("delegation4.kt")
        public void testDelegation4() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation4.kt");
        }

        @TestMetadata("delegationGenericArg.kt")
        public void testDelegationGenericArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericArg.kt");
        }

        @TestMetadata("delegationGenericArgUpperBound.kt")
        public void testDelegationGenericArgUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericArgUpperBound.kt");
        }

        @TestMetadata("delegationGenericLongArg.kt")
        public void testDelegationGenericLongArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericLongArg.kt");
        }

        @TestMetadata("delegationJava.kt")
        public void testDelegationJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationJava.kt");
        }

        @TestMetadata("delegationMethodsWithArgs.kt")
        public void testDelegationMethodsWithArgs() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationMethodsWithArgs.kt");
        }

        @TestMetadata("exceptionConstructor.kt")
        public void testExceptionConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/classes/exceptionConstructor.kt");
        }

        @TestMetadata("extensionFunWithDefaultParam.kt")
        public void testExtensionFunWithDefaultParam() throws Exception {
            runTest("compiler/testData/codegen/box/classes/extensionFunWithDefaultParam.kt");
        }

        @TestMetadata("extensionOnNamedClassObject.kt")
        public void testExtensionOnNamedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/extensionOnNamedClassObject.kt");
        }

        @TestMetadata("funDelegation.kt")
        public void testFunDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/funDelegation.kt");
        }

        @TestMetadata("implementComparableInSubclass.kt")
        public void testImplementComparableInSubclass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/implementComparableInSubclass.kt");
        }

        @TestMetadata("inheritSetAndHashSet.kt")
        public void testInheritSetAndHashSet() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritSetAndHashSet.kt");
        }

        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritance.kt");
        }

        @TestMetadata("inheritedInnerClass.kt")
        public void testInheritedInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritedInnerClass.kt");
        }

        @TestMetadata("inheritedMethod.kt")
        public void testInheritedMethod() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritedMethod.kt");
        }

        @TestMetadata("initializerBlock.kt")
        public void testInitializerBlock() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlock.kt");
        }

        @TestMetadata("initializerBlockDImpl.kt")
        public void testInitializerBlockDImpl() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlockDImpl.kt");
        }

        @TestMetadata("initializerBlockResetToDefault.kt")
        public void testInitializerBlockResetToDefault() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlockResetToDefault.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/innerClass.kt");
        }

        @TestMetadata("interfaceCompanionInitializationWithJava.kt")
        public void testInterfaceCompanionInitializationWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/interfaceCompanionInitializationWithJava.kt");
        }

        @TestMetadata("kt1018.kt")
        public void testKt1018() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1018.kt");
        }

        @TestMetadata("kt1120.kt")
        public void testKt1120() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1120.kt");
        }

        @TestMetadata("kt1134.kt")
        public void testKt1134() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1134.kt");
        }

        @TestMetadata("kt1157.kt")
        public void testKt1157() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1157.kt");
        }

        @TestMetadata("kt1247.kt")
        public void testKt1247() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1247.kt");
        }

        @TestMetadata("kt1345.kt")
        public void testKt1345() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1345.kt");
        }

        @TestMetadata("kt1439.kt")
        public void testKt1439() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1439.kt");
        }

        @TestMetadata("kt1535.kt")
        public void testKt1535() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1535.kt");
        }

        @TestMetadata("kt1538.kt")
        public void testKt1538() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1538.kt");
        }

        @TestMetadata("kt1578.kt")
        public void testKt1578() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1578.kt");
        }

        @TestMetadata("kt1611.kt")
        public void testKt1611() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1611.kt");
        }

        @TestMetadata("kt1721.kt")
        public void testKt1721() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1721.kt");
        }

        @TestMetadata("kt1726.kt")
        public void testKt1726() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1726.kt");
        }

        @TestMetadata("kt1759.kt")
        public void testKt1759() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1759.kt");
        }

        @TestMetadata("kt1891.kt")
        public void testKt1891() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1891.kt");
        }

        @TestMetadata("kt1918.kt")
        public void testKt1918() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1918.kt");
        }

        @TestMetadata("kt1976.kt")
        public void testKt1976() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1976.kt");
        }

        @TestMetadata("kt1980.kt")
        public void testKt1980() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1980.kt");
        }

        @TestMetadata("kt2224.kt")
        public void testKt2224() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2224.kt");
        }

        @TestMetadata("kt2288.kt")
        public void testKt2288() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2288.kt");
        }

        @TestMetadata("kt2384.kt")
        public void testKt2384() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2384.kt");
        }

        @TestMetadata("kt2390.kt")
        public void testKt2390() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2390.kt");
        }

        @TestMetadata("kt2391.kt")
        public void testKt2391() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2391.kt");
        }

        @TestMetadata("kt2395.kt")
        public void testKt2395() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2395.kt");
        }

        @TestMetadata("kt2417.kt")
        public void testKt2417() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2417.kt");
        }

        @TestMetadata("kt2477.kt")
        public void testKt2477() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2477.kt");
        }

        @TestMetadata("kt2480.kt")
        public void testKt2480() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2480.kt");
        }

        @TestMetadata("kt2482.kt")
        public void testKt2482() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2482.kt");
        }

        @TestMetadata("kt2485.kt")
        public void testKt2485() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2485.kt");
        }

        @TestMetadata("kt249.kt")
        public void testKt249() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt249.kt");
        }

        @TestMetadata("kt2532.kt")
        public void testKt2532() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2532.kt");
        }

        @TestMetadata("kt2566.kt")
        public void testKt2566() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2566.kt");
        }

        @TestMetadata("kt2566_2.kt")
        public void testKt2566_2() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2566_2.kt");
        }

        @TestMetadata("kt2607.kt")
        public void testKt2607() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2607.kt");
        }

        @TestMetadata("kt2626.kt")
        public void testKt2626() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2626.kt");
        }

        @TestMetadata("kt2711.kt")
        public void testKt2711() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2711.kt");
        }

        @TestMetadata("kt2784.kt")
        public void testKt2784() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2784.kt");
        }

        @TestMetadata("kt285.kt")
        public void testKt285() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt285.kt");
        }

        @TestMetadata("kt3001.kt")
        public void testKt3001() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3001.kt");
        }

        @TestMetadata("kt3114.kt")
        public void testKt3114() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3114.kt");
        }

        @TestMetadata("kt3414.kt")
        public void testKt3414() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3414.kt");
        }

        @TestMetadata("kt343.kt")
        public void testKt343() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt343.kt");
        }

        @TestMetadata("kt3546.kt")
        public void testKt3546() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3546.kt");
        }

        @TestMetadata("kt454.kt")
        public void testKt454() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt454.kt");
        }

        @TestMetadata("kt471.kt")
        public void testKt471() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt471.kt");
        }

        @TestMetadata("kt48.kt")
        public void testKt48() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt48.kt");
        }

        @TestMetadata("kt496.kt")
        public void testKt496() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt496.kt");
        }

        @TestMetadata("kt500.kt")
        public void testKt500() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt500.kt");
        }

        @TestMetadata("kt501.kt")
        public void testKt501() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt501.kt");
        }

        @TestMetadata("kt504.kt")
        public void testKt504() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt504.kt");
        }

        @TestMetadata("kt508.kt")
        public void testKt508() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt508.kt");
        }

        @TestMetadata("kt5347.kt")
        public void testKt5347() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt5347.kt");
        }

        @TestMetadata("kt6136.kt")
        public void testKt6136() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt6136.kt");
        }

        @TestMetadata("kt633.kt")
        public void testKt633() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt633.kt");
        }

        @TestMetadata("kt6816.kt")
        public void testKt6816() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt6816.kt");
        }

        @TestMetadata("kt707.kt")
        public void testKt707() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt707.kt");
        }

        @TestMetadata("kt723.kt")
        public void testKt723() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt723.kt");
        }

        @TestMetadata("kt725.kt")
        public void testKt725() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt725.kt");
        }

        @TestMetadata("kt8011.kt")
        public void testKt8011() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt8011.kt");
        }

        @TestMetadata("kt8011a.kt")
        public void testKt8011a() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt8011a.kt");
        }

        @TestMetadata("kt903.kt")
        public void testKt903() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt903.kt");
        }

        @TestMetadata("kt940.kt")
        public void testKt940() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt940.kt");
        }

        @TestMetadata("kt9642.kt")
        public void testKt9642() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt9642.kt");
        }

        @TestMetadata("namedClassObject.kt")
        public void testNamedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/namedClassObject.kt");
        }

        @TestMetadata("outerThis.kt")
        public void testOuterThis() throws Exception {
            runTest("compiler/testData/codegen/box/classes/outerThis.kt");
        }

        @TestMetadata("overloadBinaryOperator.kt")
        public void testOverloadBinaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadBinaryOperator.kt");
        }

        @TestMetadata("overloadPlusAssign.kt")
        public void testOverloadPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusAssign.kt");
        }

        @TestMetadata("overloadPlusAssignReturn.kt")
        public void testOverloadPlusAssignReturn() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusAssignReturn.kt");
        }

        @TestMetadata("overloadPlusToPlusAssign.kt")
        public void testOverloadPlusToPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusToPlusAssign.kt");
        }

        @TestMetadata("overloadUnaryOperator.kt")
        public void testOverloadUnaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadUnaryOperator.kt");
        }

        @TestMetadata("privateOuterFunctions.kt")
        public void testPrivateOuterFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateOuterFunctions.kt");
        }

        @TestMetadata("privateOuterProperty.kt")
        public void testPrivateOuterProperty() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateOuterProperty.kt");
        }

        @TestMetadata("privateToThis.kt")
        public void testPrivateToThis() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateToThis.kt");
        }

        @TestMetadata("propertyDelegation.kt")
        public void testPropertyDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/propertyDelegation.kt");
        }

        @TestMetadata("propertyInInitializer.kt")
        public void testPropertyInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/classes/propertyInInitializer.kt");
        }

        @TestMetadata("quotedClassName.kt")
        public void testQuotedClassName() throws Exception {
            runTest("compiler/testData/codegen/box/classes/quotedClassName.kt");
        }

        @TestMetadata("rightHandOverride.kt")
        public void testRightHandOverride() throws Exception {
            runTest("compiler/testData/codegen/box/classes/rightHandOverride.kt");
        }

        @TestMetadata("selfcreate.kt")
        public void testSelfcreate() throws Exception {
            runTest("compiler/testData/codegen/box/classes/selfcreate.kt");
        }

        @TestMetadata("simpleBox.kt")
        public void testSimpleBox() throws Exception {
            runTest("compiler/testData/codegen/box/classes/simpleBox.kt");
        }

        @TestMetadata("superConstructorCallWithComplexArg.kt")
        public void testSuperConstructorCallWithComplexArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/superConstructorCallWithComplexArg.kt");
        }

        @TestMetadata("typedDelegation.kt")
        public void testTypedDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/typedDelegation.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/classes/inner")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inner extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInner() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classes/inner"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("extensionWithOuter.kt")
            public void testExtensionWithOuter() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/extensionWithOuter.kt");
            }

            @TestMetadata("instantiateInDerived.kt")
            public void testInstantiateInDerived() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerived.kt");
            }

            @TestMetadata("instantiateInDerivedLabeled.kt")
            public void testInstantiateInDerivedLabeled() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerivedLabeled.kt");
            }

            @TestMetadata("instantiateInSameClass.kt")
            public void testInstantiateInSameClass() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInSameClass.kt");
            }

            @TestMetadata("kt6708.kt")
            public void testKt6708() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/kt6708.kt");
            }

            @TestMetadata("properOuter.kt")
            public void testProperOuter() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/properOuter.kt");
            }

            @TestMetadata("properSuperLinking.kt")
            public void testProperSuperLinking() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/properSuperLinking.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/closures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Closures extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt23881.kt")
        public void ignoreKt23881() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt23881.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInClosures() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousObjectAsLastExpressionInLambda.kt")
        public void testAnonymousObjectAsLastExpressionInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/closures/anonymousObjectAsLastExpressionInLambda.kt");
        }

        @TestMetadata("captureExtensionReceiver.kt")
        public void testCaptureExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/closures/captureExtensionReceiver.kt");
        }

        @TestMetadata("captureExtensionReceiverX2.kt")
        public void testCaptureExtensionReceiverX2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/captureExtensionReceiverX2.kt");
        }

        @TestMetadata("capturedLocalGenericFun.kt")
        public void testCapturedLocalGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/closures/capturedLocalGenericFun.kt");
        }

        @TestMetadata("closureInsideConstrucor.kt")
        public void testClosureInsideConstrucor() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureInsideConstrucor.kt");
        }

        @TestMetadata("closureOnTopLevel1.kt")
        public void testClosureOnTopLevel1() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureOnTopLevel1.kt");
        }

        @TestMetadata("closureOnTopLevel2.kt")
        public void testClosureOnTopLevel2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureOnTopLevel2.kt");
        }

        @TestMetadata("closureWithParameter.kt")
        public void testClosureWithParameter() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureWithParameter.kt");
        }

        @TestMetadata("closureWithParameterAndBoxing.kt")
        public void testClosureWithParameterAndBoxing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureWithParameterAndBoxing.kt");
        }

        @TestMetadata("crossinlineLocalDeclaration.kt")
        public void testCrossinlineLocalDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/closures/crossinlineLocalDeclaration.kt");
        }

        @TestMetadata("doubleEnclosedLocalVariable.kt")
        public void testDoubleEnclosedLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/doubleEnclosedLocalVariable.kt");
        }

        @TestMetadata("enclosingLocalVariable.kt")
        public void testEnclosingLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/enclosingLocalVariable.kt");
        }

        @TestMetadata("enclosingThis.kt")
        public void testEnclosingThis() throws Exception {
            runTest("compiler/testData/codegen/box/closures/enclosingThis.kt");
        }

        @TestMetadata("extensionClosure.kt")
        public void testExtensionClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/extensionClosure.kt");
        }

        @TestMetadata("kt10044.kt")
        public void testKt10044() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt10044.kt");
        }

        @TestMetadata("kt11634.kt")
        public void testKt11634() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634.kt");
        }

        @TestMetadata("kt11634_2.kt")
        public void testKt11634_2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_2.kt");
        }

        @TestMetadata("kt11634_3.kt")
        public void testKt11634_3() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_3.kt");
        }

        @TestMetadata("kt11634_4.kt")
        public void testKt11634_4() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_4.kt");
        }

        @TestMetadata("kt19389.kt")
        public void testKt19389() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt19389.kt");
        }

        @TestMetadata("kt19389_set.kt")
        public void testKt19389_set() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt19389_set.kt");
        }

        @TestMetadata("kt2151.kt")
        public void testKt2151() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt2151.kt");
        }

        @TestMetadata("kt3152.kt")
        public void testKt3152() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3152.kt");
        }

        @TestMetadata("kt3523.kt")
        public void testKt3523() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3523.kt");
        }

        @TestMetadata("kt3738.kt")
        public void testKt3738() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3738.kt");
        }

        @TestMetadata("kt3905.kt")
        public void testKt3905() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3905.kt");
        }

        @TestMetadata("kt4106.kt")
        public void testKt4106() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt4106.kt");
        }

        @TestMetadata("kt4137.kt")
        public void testKt4137() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt4137.kt");
        }

        @TestMetadata("kt47120.kt")
        public void testKt47120() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47120.kt");
        }

        @TestMetadata("kt47120a.kt")
        public void testKt47120a() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47120a.kt");
        }

        @TestMetadata("kt47840.kt")
        public void testKt47840() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47840.kt");
        }

        @TestMetadata("kt47894_inlineFunWithObjectWithNothing.kt")
        public void testKt47894_inlineFunWithObjectWithNothing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47894_inlineFunWithObjectWithNothing.kt");
        }

        @TestMetadata("kt5589.kt")
        public void testKt5589() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt5589.kt");
        }

        @TestMetadata("localClassFunClosure.kt")
        public void testLocalClassFunClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localClassFunClosure.kt");
        }

        @TestMetadata("localClassLambdaClosure.kt")
        public void testLocalClassLambdaClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localClassLambdaClosure.kt");
        }

        @TestMetadata("localFunInInit.kt")
        public void testLocalFunInInit() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunInInit.kt");
        }

        @TestMetadata("localFunctionInFunction.kt")
        public void testLocalFunctionInFunction() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInFunction.kt");
        }

        @TestMetadata("localFunctionInInitBlock.kt")
        public void testLocalFunctionInInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInInitBlock.kt");
        }

        @TestMetadata("localFunctionInInitializer.kt")
        public void testLocalFunctionInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInInitializer.kt");
        }

        @TestMetadata("localGenericFun.kt")
        public void testLocalGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localGenericFun.kt");
        }

        @TestMetadata("localReturn.kt")
        public void testLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localReturn.kt");
        }

        @TestMetadata("localReturnWithAutolabel.kt")
        public void testLocalReturnWithAutolabel() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localReturnWithAutolabel.kt");
        }

        @TestMetadata("noRefToOuter.kt")
        public void testNoRefToOuter() throws Exception {
            runTest("compiler/testData/codegen/box/closures/noRefToOuter.kt");
        }

        @TestMetadata("recursiveClosure.kt")
        public void testRecursiveClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/recursiveClosure.kt");
        }

        @TestMetadata("refsAreSerializable.kt")
        public void testRefsAreSerializable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/refsAreSerializable.kt");
        }

        @TestMetadata("simplestClosure.kt")
        public void testSimplestClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/simplestClosure.kt");
        }

        @TestMetadata("simplestClosureAndBoxing.kt")
        public void testSimplestClosureAndBoxing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/simplestClosureAndBoxing.kt");
        }

        @TestMetadata("staticLambda.kt")
        public void testStaticLambda() throws Exception {
            runTest("compiler/testData/codegen/box/closures/staticLambda.kt");
        }

        @TestMetadata("subclosuresWithinInitializers.kt")
        public void testSubclosuresWithinInitializers() throws Exception {
            runTest("compiler/testData/codegen/box/closures/subclosuresWithinInitializers.kt");
        }

        @TestMetadata("underscoreParameters.kt")
        public void testUnderscoreParameters() throws Exception {
            runTest("compiler/testData/codegen/box/closures/underscoreParameters.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/closures/captureInSuperConstructorCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CaptureInSuperConstructorCall extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCaptureInSuperConstructorCall() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/captureInSuperConstructorCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("constructorParameterAndLocalCapturedInLambdaInLocalClass.kt")
            public void testConstructorParameterAndLocalCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterAndLocalCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("constructorParameterCapturedInLambdaInLocalClass.kt")
            public void testConstructorParameterCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("constructorParameterCapturedInLambdaInLocalClass2.kt")
            public void testConstructorParameterCapturedInLambdaInLocalClass2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass2.kt");
            }

            @TestMetadata("kt13454.kt")
            public void testKt13454() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt13454.kt");
            }

            @TestMetadata("kt14148.kt")
            public void testKt14148() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt14148.kt");
            }

            @TestMetadata("kt4174.kt")
            public void testKt4174() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174.kt");
            }

            @TestMetadata("kt4174a.kt")
            public void testKt4174a() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174a.kt");
            }

            @TestMetadata("localCapturedInAnonymousObjectInLocalClass.kt")
            public void testLocalCapturedInAnonymousObjectInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass.kt");
            }

            @TestMetadata("localCapturedInAnonymousObjectInLocalClass2.kt")
            public void testLocalCapturedInAnonymousObjectInLocalClass2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass2.kt");
            }

            @TestMetadata("localCapturedInLambdaInInnerClassInLocalClass.kt")
            public void testLocalCapturedInLambdaInInnerClassInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInInnerClassInLocalClass.kt");
            }

            @TestMetadata("localCapturedInLambdaInLocalClass.kt")
            public void testLocalCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("localFunctionCapturedInLambda.kt")
            public void testLocalFunctionCapturedInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localFunctionCapturedInLambda.kt");
            }

            @TestMetadata("outerAndLocalCapturedInLocalClass.kt")
            public void testOuterAndLocalCapturedInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerAndLocalCapturedInLocalClass.kt");
            }

            @TestMetadata("outerCapturedAsImplicitThisInBoundReference.kt")
            public void testOuterCapturedAsImplicitThisInBoundReference() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedAsImplicitThisInBoundReference.kt");
            }

            @TestMetadata("outerCapturedInFunctionLiteral.kt")
            public void testOuterCapturedInFunctionLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInFunctionLiteral.kt");
            }

            @TestMetadata("outerCapturedInInlineLambda.kt")
            public void testOuterCapturedInInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda.kt");
            }

            @TestMetadata("outerCapturedInInlineLambda2.kt")
            public void testOuterCapturedInInlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda2.kt");
            }

            @TestMetadata("outerCapturedInLambda.kt")
            public void testOuterCapturedInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda.kt");
            }

            @TestMetadata("outerCapturedInLambda2.kt")
            public void testOuterCapturedInLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda2.kt");
            }

            @TestMetadata("outerCapturedInLambdaInSecondaryConstructor.kt")
            public void testOuterCapturedInLambdaInSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSecondaryConstructor.kt");
            }

            @TestMetadata("outerCapturedInLambdaInSubExpression.kt")
            public void testOuterCapturedInLambdaInSubExpression() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSubExpression.kt");
            }

            @TestMetadata("outerCapturedInLocalClass.kt")
            public void testOuterCapturedInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLocalClass.kt");
            }

            @TestMetadata("outerCapturedInNestedLambda.kt")
            public void testOuterCapturedInNestedLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedLambda.kt");
            }

            @TestMetadata("outerCapturedInNestedObject.kt")
            public void testOuterCapturedInNestedObject() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedObject.kt");
            }

            @TestMetadata("outerCapturedInObject.kt")
            public void testOuterCapturedInObject() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject.kt");
            }

            @TestMetadata("outerCapturedInObject2.kt")
            public void testOuterCapturedInObject2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject2.kt");
            }

            @TestMetadata("outerCapturedInPrimaryConstructorDefaultParameter.kt")
            public void testOuterCapturedInPrimaryConstructorDefaultParameter() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInPrimaryConstructorDefaultParameter.kt");
            }

            @TestMetadata("outerCapturedInSecondaryConstructorDefaultParameter.kt")
            public void testOuterCapturedInSecondaryConstructorDefaultParameter() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInSecondaryConstructorDefaultParameter.kt");
            }

            @TestMetadata("outerEnumEntryCapturedInLambdaInInnerClass.kt")
            public void testOuterEnumEntryCapturedInLambdaInInnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerEnumEntryCapturedInLambdaInInnerClass.kt");
            }

            @TestMetadata("properValueCapturedByClosure1.kt")
            public void testProperValueCapturedByClosure1() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure1.kt");
            }

            @TestMetadata("properValueCapturedByClosure2.kt")
            public void testProperValueCapturedByClosure2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure2.kt");
            }

            @TestMetadata("referenceToCapturedVariablesInMultipleLambdas.kt")
            public void testReferenceToCapturedVariablesInMultipleLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/referenceToCapturedVariablesInMultipleLambdas.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/captureOuterProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CaptureOuterProperty extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCaptureOuterProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/captureOuterProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("captureFunctionInProperty.kt")
            public void testCaptureFunctionInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/captureFunctionInProperty.kt");
            }

            @TestMetadata("inFunction.kt")
            public void testInFunction() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inFunction.kt");
            }

            @TestMetadata("inProperty.kt")
            public void testInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inProperty.kt");
            }

            @TestMetadata("inPropertyDeepObjectChain.kt")
            public void testInPropertyDeepObjectChain() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyDeepObjectChain.kt");
            }

            @TestMetadata("inPropertyFromSuperClass.kt")
            public void testInPropertyFromSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperClass.kt");
            }

            @TestMetadata("inPropertyFromSuperSuperClass.kt")
            public void testInPropertyFromSuperSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperSuperClass.kt");
            }

            @TestMetadata("kt4176.kt")
            public void testKt4176() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4176.kt");
            }

            @TestMetadata("kt4656.kt")
            public void testKt4656() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4656.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/capturedVarsOptimization")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CapturedVarsOptimization extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCapturedVarsOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("capturedInCrossinline.kt")
            public void testCapturedInCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInCrossinline.kt");
            }

            @TestMetadata("capturedInInlineOnlyAssign.kt")
            public void testCapturedInInlineOnlyAssign() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyAssign.kt");
            }

            @TestMetadata("capturedInInlineOnlyCAO.kt")
            public void testCapturedInInlineOnlyCAO() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyCAO.kt");
            }

            @TestMetadata("capturedInInlineOnlyIncrDecr.kt")
            public void testCapturedInInlineOnlyIncrDecr() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIncrDecr.kt");
            }

            @TestMetadata("capturedInInlineOnlyIndexedCAO.kt")
            public void testCapturedInInlineOnlyIndexedCAO() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIndexedCAO.kt");
            }

            @TestMetadata("capturedVarsOfSize2.kt")
            public void testCapturedVarsOfSize2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedVarsOfSize2.kt");
            }

            @TestMetadata("kt17200.kt")
            public void testKt17200() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17200.kt");
            }

            @TestMetadata("kt17588.kt")
            public void testKt17588() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17588.kt");
            }

            @TestMetadata("kt44347.kt")
            public void testKt44347() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt44347.kt");
            }

            @TestMetadata("kt45446.kt")
            public void testKt45446() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt45446.kt");
            }

            @TestMetadata("sharedSlotsWithCapturedVars.kt")
            public void testSharedSlotsWithCapturedVars() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
            }

            @TestMetadata("withCoroutines.kt")
            public void testWithCoroutines() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutines.kt");
            }

            @TestMetadata("withCoroutinesNoStdLib.kt")
            public void testWithCoroutinesNoStdLib() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutinesNoStdLib.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/closureInsideClosure")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClosureInsideClosure extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInClosureInsideClosure() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/closureInsideClosure"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("localFunInsideLocalFun.kt")
            public void testLocalFunInsideLocalFun() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFun.kt");
            }

            @TestMetadata("localFunInsideLocalFunDifferentSignatures.kt")
            public void testLocalFunInsideLocalFunDifferentSignatures() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFunDifferentSignatures.kt");
            }

            @TestMetadata("propertyAndFunctionNameClash.kt")
            public void testPropertyAndFunctionNameClash() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/propertyAndFunctionNameClash.kt");
            }

            @TestMetadata("threeLevels.kt")
            public void testThreeLevels() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevels.kt");
            }

            @TestMetadata("threeLevelsDifferentSignatures.kt")
            public void testThreeLevelsDifferentSignatures() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevelsDifferentSignatures.kt");
            }

            @TestMetadata("varAsFunInsideLocalFun.kt")
            public void testVarAsFunInsideLocalFun() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/varAsFunInsideLocalFun.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/collectionLiterals")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CollectionLiterals extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCollectionLiterals() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/collectionLiterals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("collectionLiteralsInArgumentPosition.kt")
        public void testCollectionLiteralsInArgumentPosition() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsInArgumentPosition.kt");
        }

        @TestMetadata("collectionLiteralsWithConstants.kt")
        public void testCollectionLiteralsWithConstants() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsWithConstants.kt");
        }

        @TestMetadata("collectionLiteralsWithVarargs.kt")
        public void testCollectionLiteralsWithVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsWithVarargs.kt");
        }

        @TestMetadata("defaultAnnotationParameterValues.kt")
        public void testDefaultAnnotationParameterValues() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/defaultAnnotationParameterValues.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/collections")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Collections extends AbstractLightAnalysisModeTest {
        @TestMetadata("internalRemoveFromJava.kt")
        public void ignoreInternalRemoveFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/internalRemoveFromJava.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("addCollectionStubWithCovariantOverride.kt")
        public void testAddCollectionStubWithCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/collections/addCollectionStubWithCovariantOverride.kt");
        }

        public void testAllFilesPresentInCollections() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/collections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("charSequence.kt")
        public void testCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/collections/charSequence.kt");
        }

        @TestMetadata("implementCollectionThroughKotlin.kt")
        public void testImplementCollectionThroughKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/implementCollectionThroughKotlin.kt");
        }

        @TestMetadata("inSetWithSmartCast.kt")
        public void testInSetWithSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inSetWithSmartCast.kt");
        }

        @TestMetadata("inheritFromAbstractMutableListInt.kt")
        public void testInheritFromAbstractMutableListInt() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inheritFromAbstractMutableListInt.kt");
        }

        @TestMetadata("inheritFromHashtable.kt")
        public void testInheritFromHashtable() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inheritFromHashtable.kt");
        }

        @TestMetadata("internalRemove.kt")
        public void testInternalRemove() throws Exception {
            runTest("compiler/testData/codegen/box/collections/internalRemove.kt");
        }

        @TestMetadata("irrelevantImplCharSequence.kt")
        public void testIrrelevantImplCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequence.kt");
        }

        @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
        public void testIrrelevantImplCharSequenceKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequenceKotlin.kt");
        }

        @TestMetadata("irrelevantImplMutableList.kt")
        public void testIrrelevantImplMutableList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableList.kt");
        }

        @TestMetadata("irrelevantImplMutableListKotlin.kt")
        public void testIrrelevantImplMutableListKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableListKotlin.kt");
        }

        @TestMetadata("irrelevantImplMutableListSubstitution.kt")
        public void testIrrelevantImplMutableListSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableListSubstitution.kt");
        }

        @TestMetadata("irrelevantRemoveAtOverrideInJava.kt")
        public void testIrrelevantRemoveAtOverrideInJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantRemoveAtOverrideInJava.kt");
        }

        @TestMetadata("irrelevantSizeOverrideInJava.kt")
        public void testIrrelevantSizeOverrideInJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantSizeOverrideInJava.kt");
        }

        @TestMetadata("javaCollectionWithRemovePrimitiveInt.kt")
        public void testJavaCollectionWithRemovePrimitiveInt() throws Exception {
            runTest("compiler/testData/codegen/box/collections/javaCollectionWithRemovePrimitiveInt.kt");
        }

        @TestMetadata("kt40305.kt")
        public void testKt40305() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt40305.kt");
        }

        @TestMetadata("kt41123.kt")
        public void testKt41123() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt41123.kt");
        }

        @TestMetadata("kt44233.kt")
        public void testKt44233() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt44233.kt");
        }

        @TestMetadata("kt48945.kt")
        public void testKt48945() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt48945.kt");
        }

        @TestMetadata("kt48945a.kt")
        public void testKt48945a() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt48945a.kt");
        }

        @TestMetadata("kt48945b.kt")
        public void testKt48945b() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt48945b.kt");
        }

        @TestMetadata("kt48945c.kt")
        public void testKt48945c() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt48945c.kt");
        }

        @TestMetadata("mutableList.kt")
        public void testMutableList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/mutableList.kt");
        }

        @TestMetadata("noStubsInJavaSuperClass.kt")
        public void testNoStubsInJavaSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/collections/noStubsInJavaSuperClass.kt");
        }

        @TestMetadata("platformValueContains.kt")
        public void testPlatformValueContains() throws Exception {
            runTest("compiler/testData/codegen/box/collections/platformValueContains.kt");
        }

        @TestMetadata("readOnlyList.kt")
        public void testReadOnlyList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/readOnlyList.kt");
        }

        @TestMetadata("readOnlyMap.kt")
        public void testReadOnlyMap() throws Exception {
            runTest("compiler/testData/codegen/box/collections/readOnlyMap.kt");
        }

        @TestMetadata("removeAtBridgeClashWithJava.kt")
        public void testRemoveAtBridgeClashWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeAtBridgeClashWithJava.kt");
        }

        @TestMetadata("removeAtInt.kt")
        public void testRemoveAtInt() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeAtInt.kt");
        }

        @TestMetadata("removeClash.kt")
        public void testRemoveClash() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClash.kt");
        }

        @TestMetadata("removeClashJava.kt")
        public void testRemoveClashJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClashJava.kt");
        }

        @TestMetadata("removeClashKotlin.kt")
        public void testRemoveClashKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClashKotlin.kt");
        }

        @TestMetadata("removeClashWithGenerics.kt")
        public void testRemoveClashWithGenerics() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClashWithGenerics.kt");
        }

        @TestMetadata("removeNullFromList.kt")
        public void testRemoveNullFromList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeNullFromList.kt");
        }

        @TestMetadata("removeOverriddenInJava.kt")
        public void testRemoveOverriddenInJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeOverriddenInJava.kt");
        }

        @TestMetadata("removeOverriddenInJava_Map.kt")
        public void testRemoveOverriddenInJava_Map() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeOverriddenInJava_Map.kt");
        }

        @TestMetadata("specialBridgeForGet.kt")
        public void testSpecialBridgeForGet() throws Exception {
            runTest("compiler/testData/codegen/box/collections/specialBridgeForGet.kt");
        }

        @TestMetadata("strList.kt")
        public void testStrList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/strList.kt");
        }

        @TestMetadata("toArrayInJavaClass.kt")
        public void testToArrayInJavaClass() throws Exception {
            runTest("compiler/testData/codegen/box/collections/toArrayInJavaClass.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/companion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Companion extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCompanion() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("delegatedPropertyOnCompanion.kt")
        public void testDelegatedPropertyOnCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/companion/delegatedPropertyOnCompanion.kt");
        }

        @TestMetadata("genericLambdaOnStringCompanion.kt")
        public void testGenericLambdaOnStringCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/companion/genericLambdaOnStringCompanion.kt");
        }

        @TestMetadata("inlineFunctionCompanionPropertyAccess.kt")
        public void testInlineFunctionCompanionPropertyAccess() throws Exception {
            runTest("compiler/testData/codegen/box/companion/inlineFunctionCompanionPropertyAccess.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/compatibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Compatibility extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCompatibility() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("privateCompanionObject.kt")
        public void testPrivateCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/compatibility/privateCompanionObject.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constants")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constants extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInConstants() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("comparisonFalse.kt")
        public void testComparisonFalse() throws Exception {
            runTest("compiler/testData/codegen/box/constants/comparisonFalse.kt");
        }

        @TestMetadata("comparisonTrue.kt")
        public void testComparisonTrue() throws Exception {
            runTest("compiler/testData/codegen/box/constants/comparisonTrue.kt");
        }

        @TestMetadata("constValFromAnotherModuleInConsVal.kt")
        public void testConstValFromAnotherModuleInConsVal() throws Exception {
            runTest("compiler/testData/codegen/box/constants/constValFromAnotherModuleInConsVal.kt");
        }

        @TestMetadata("constantsInWhen.kt")
        public void testConstantsInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/constants/constantsInWhen.kt");
        }

        @TestMetadata("divisionByZero.kt")
        public void testDivisionByZero() throws Exception {
            runTest("compiler/testData/codegen/box/constants/divisionByZero.kt");
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("compiler/testData/codegen/box/constants/float.kt");
        }

        @TestMetadata("foldingBinaryOpsUnsigned.kt")
        public void testFoldingBinaryOpsUnsigned() throws Exception {
            runTest("compiler/testData/codegen/box/constants/foldingBinaryOpsUnsigned.kt");
        }

        @TestMetadata("foldingBinaryOpsUnsignedConst.kt")
        public void testFoldingBinaryOpsUnsignedConst() throws Exception {
            runTest("compiler/testData/codegen/box/constants/foldingBinaryOpsUnsignedConst.kt");
        }

        @TestMetadata("kt9532.kt")
        public void testKt9532() throws Exception {
            runTest("compiler/testData/codegen/box/constants/kt9532.kt");
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("compiler/testData/codegen/box/constants/long.kt");
        }

        @TestMetadata("numberLiteralCoercionToInferredType.kt")
        public void testNumberLiteralCoercionToInferredType() throws Exception {
            runTest("compiler/testData/codegen/box/constants/numberLiteralCoercionToInferredType.kt");
        }

        @TestMetadata("privateConst.kt")
        public void testPrivateConst() throws Exception {
            runTest("compiler/testData/codegen/box/constants/privateConst.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constructor")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constructor extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInConstructor() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("genericConstructor.kt")
        public void testGenericConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/constructor/genericConstructor.kt");
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/constructor/secondaryConstructor.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constructorCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConstructorCall extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInConstructorCall() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constructorCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("breakInConstructorArguments.kt")
        public void testBreakInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/breakInConstructorArguments.kt");
        }

        @TestMetadata("continueInConstructorArguments.kt")
        public void testContinueInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/continueInConstructorArguments.kt");
        }

        @TestMetadata("earlyReturnInConstructorArguments.kt")
        public void testEarlyReturnInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/earlyReturnInConstructorArguments.kt");
        }

        @TestMetadata("inlineFunInConstructorCall.kt")
        public void testInlineFunInConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCall.kt");
        }

        @TestMetadata("inlineFunInConstructorCallEvaluationOrder.kt")
        public void testInlineFunInConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCallEvaluationOrder.kt");
        }

        @TestMetadata("inlineFunInInnerClassConstructorCall.kt")
        public void testInlineFunInInnerClassConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInInnerClassConstructorCall.kt");
        }

        @TestMetadata("inlineFunInLocalClassConstructorCall.kt")
        public void testInlineFunInLocalClassConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInLocalClassConstructorCall.kt");
        }

        @TestMetadata("kt49615.kt")
        public void testKt49615() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/kt49615.kt");
        }

        @TestMetadata("kt49615a.kt")
        public void testKt49615a() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/kt49615a.kt");
        }

        @TestMetadata("loopInInlineFun.kt")
        public void testLoopInInlineFun() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFun.kt");
        }

        @TestMetadata("loopInInlineFunInSuperConstructorCall.kt")
        public void testLoopInInlineFunInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFunInSuperConstructorCall.kt");
        }

        @TestMetadata("nestedConstructorCallWithJumpOutInConstructorArguments.kt")
        public void testNestedConstructorCallWithJumpOutInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/nestedConstructorCallWithJumpOutInConstructorArguments.kt");
        }

        @TestMetadata("nonLocalReturnInConstructorArguments.kt")
        public void testNonLocalReturnInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/nonLocalReturnInConstructorArguments.kt");
        }

        @TestMetadata("possiblyPoppedUnitializedValueInArguments.kt")
        public void testPossiblyPoppedUnitializedValueInArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/possiblyPoppedUnitializedValueInArguments.kt");
        }

        @TestMetadata("regularConstructorCallEvaluationOrder.kt")
        public void testRegularConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/regularConstructorCallEvaluationOrder.kt");
        }

        @TestMetadata("tryCatchInConstructorCallEvaluationOrder.kt")
        public void testTryCatchInConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/tryCatchInConstructorCallEvaluationOrder.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/contracts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Contracts extends AbstractLightAnalysisModeTest {
        @TestMetadata("nestedLambdaInNonInlineCallExactlyOnce.kt")
        public void ignoreNestedLambdaInNonInlineCallExactlyOnce() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/nestedLambdaInNonInlineCallExactlyOnce.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInContracts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("constructorArgument.kt")
        public void testConstructorArgument() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/constructorArgument.kt");
        }

        @TestMetadata("destructuredVariable.kt")
        public void testDestructuredVariable() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/destructuredVariable.kt");
        }

        @TestMetadata("exactlyOnceNotInline.kt")
        public void testExactlyOnceNotInline() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/exactlyOnceNotInline.kt");
        }

        @TestMetadata("exception.kt")
        public void testException() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/exception.kt");
        }

        @TestMetadata("fieldInConstructorParens.kt")
        public void testFieldInConstructorParens() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/fieldInConstructorParens.kt");
        }

        @TestMetadata("fieldReadInConstructor.kt")
        public void testFieldReadInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/fieldReadInConstructor.kt");
        }

        @TestMetadata("forLoop.kt")
        public void testForLoop() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/forLoop.kt");
        }

        @TestMetadata("functionParameter.kt")
        public void testFunctionParameter() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/functionParameter.kt");
        }

        @TestMetadata("kt39374.kt")
        public void testKt39374() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt39374.kt");
        }

        @TestMetadata("kt45236.kt")
        public void testKt45236() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt45236.kt");
        }

        @TestMetadata("kt47168.kt")
        public void testKt47168() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt47168.kt");
        }

        @TestMetadata("kt47300.kt")
        public void testKt47300() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt47300.kt");
        }

        @TestMetadata("lambdaParameter.kt")
        public void testLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/lambdaParameter.kt");
        }

        @TestMetadata("listAppend.kt")
        public void testListAppend() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/listAppend.kt");
        }

        @TestMetadata("valInWhen.kt")
        public void testValInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/valInWhen.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ControlStructures extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt47245.kt")
        public void ignoreKt47245() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt47245.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInControlStructures() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("bottles.kt")
        public void testBottles() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/bottles.kt");
        }

        @TestMetadata("breakInFinally.kt")
        public void testBreakInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/breakInFinally.kt");
        }

        @TestMetadata("breakInWhen.kt")
        public void testBreakInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/breakInWhen.kt");
        }

        @TestMetadata("compareBoxedIntegerToZero.kt")
        public void testCompareBoxedIntegerToZero() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/compareBoxedIntegerToZero.kt");
        }

        @TestMetadata("conditionOfEmptyIf.kt")
        public void testConditionOfEmptyIf() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/conditionOfEmptyIf.kt");
        }

        @TestMetadata("continueInExpr.kt")
        public void testContinueInExpr() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInExpr.kt");
        }

        @TestMetadata("continueInFor.kt")
        public void testContinueInFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInFor.kt");
        }

        @TestMetadata("continueInForCondition.kt")
        public void testContinueInForCondition() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInForCondition.kt");
        }

        @TestMetadata("continueInWhen.kt")
        public void testContinueInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInWhen.kt");
        }

        @TestMetadata("continueInWhile.kt")
        public void testContinueInWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInWhile.kt");
        }

        @TestMetadata("continueToLabelInFor.kt")
        public void testContinueToLabelInFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueToLabelInFor.kt");
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhile.kt");
        }

        @TestMetadata("doWhileFib.kt")
        public void testDoWhileFib() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhileFib.kt");
        }

        @TestMetadata("doWhileWithContinue.kt")
        public void testDoWhileWithContinue() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhileWithContinue.kt");
        }

        @TestMetadata("emptyDoWhile.kt")
        public void testEmptyDoWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyDoWhile.kt");
        }

        @TestMetadata("emptyFor.kt")
        public void testEmptyFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyFor.kt");
        }

        @TestMetadata("emptyWhile.kt")
        public void testEmptyWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyWhile.kt");
        }

        @TestMetadata("factorialTest.kt")
        public void testFactorialTest() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/factorialTest.kt");
        }

        @TestMetadata("finallyOnEmptyReturn.kt")
        public void testFinallyOnEmptyReturn() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/finallyOnEmptyReturn.kt");
        }

        @TestMetadata("forArrayList.kt")
        public void testForArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forArrayList.kt");
        }

        @TestMetadata("forArrayListMultiDecl.kt")
        public void testForArrayListMultiDecl() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forArrayListMultiDecl.kt");
        }

        @TestMetadata("forInCharSequence.kt")
        public void testForInCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInCharSequence.kt");
        }

        @TestMetadata("forInCharSequenceMut.kt")
        public void testForInCharSequenceMut() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceMut.kt");
        }

        @TestMetadata("forInSmartCastToArray.kt")
        public void testForInSmartCastToArray() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInSmartCastToArray.kt");
        }

        @TestMetadata("forLoopMemberExtensionAll.kt")
        public void testForLoopMemberExtensionAll() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionAll.kt");
        }

        @TestMetadata("forLoopMemberExtensionHasNext.kt")
        public void testForLoopMemberExtensionHasNext() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionHasNext.kt");
        }

        @TestMetadata("forLoopMemberExtensionNext.kt")
        public void testForLoopMemberExtensionNext() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionNext.kt");
        }

        @TestMetadata("forNullableCharInString.kt")
        public void testForNullableCharInString() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forNullableCharInString.kt");
        }

        @TestMetadata("forUserType.kt")
        public void testForUserType() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forUserType.kt");
        }

        @TestMetadata("ifConst1.kt")
        public void testIfConst1() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifConst1.kt");
        }

        @TestMetadata("ifConst2.kt")
        public void testIfConst2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifConst2.kt");
        }

        @TestMetadata("ifIncompatibleBranches.kt")
        public void testIfIncompatibleBranches() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifIncompatibleBranches.kt");
        }

        @TestMetadata("inRangeConditionsInWhen.kt")
        public void testInRangeConditionsInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/inRangeConditionsInWhen.kt");
        }

        @TestMetadata("kt12908.kt")
        public void testKt12908() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt12908.kt");
        }

        @TestMetadata("kt12908_2.kt")
        public void testKt12908_2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt12908_2.kt");
        }

        @TestMetadata("kt1441.kt")
        public void testKt1441() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1441.kt");
        }

        @TestMetadata("kt14839.kt")
        public void testKt14839() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt14839.kt");
        }

        @TestMetadata("kt15726.kt")
        public void testKt15726() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt15726.kt");
        }

        @TestMetadata("kt1688.kt")
        public void testKt1688() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1688.kt");
        }

        @TestMetadata("kt17110.kt")
        public void testKt17110() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17110.kt");
        }

        @TestMetadata("kt1742.kt")
        public void testKt1742() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1742.kt");
        }

        @TestMetadata("kt17590.kt")
        public void testKt17590() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17590.kt");
        }

        @TestMetadata("kt17590_long.kt")
        public void testKt17590_long() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17590_long.kt");
        }

        @TestMetadata("kt1899.kt")
        public void testKt1899() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1899.kt");
        }

        @TestMetadata("kt2147.kt")
        public void testKt2147() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2147.kt");
        }

        @TestMetadata("kt2259.kt")
        public void testKt2259() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2259.kt");
        }

        @TestMetadata("kt2291.kt")
        public void testKt2291() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2291.kt");
        }

        @TestMetadata("kt237.kt")
        public void testKt237() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt237.kt");
        }

        @TestMetadata("kt2416.kt")
        public void testKt2416() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2416.kt");
        }

        @TestMetadata("kt2423.kt")
        public void testKt2423() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2423.kt");
        }

        @TestMetadata("kt2577.kt")
        public void testKt2577() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2577.kt");
        }

        @TestMetadata("kt2597.kt")
        public void testKt2597() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2597.kt");
        }

        @TestMetadata("kt299.kt")
        public void testKt299() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt299.kt");
        }

        @TestMetadata("kt3087.kt")
        public void testKt3087() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3087.kt");
        }

        @TestMetadata("kt3203_1.kt")
        public void testKt3203_1() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3203_1.kt");
        }

        @TestMetadata("kt3203_2.kt")
        public void testKt3203_2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3203_2.kt");
        }

        @TestMetadata("kt3273.kt")
        public void testKt3273() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3273.kt");
        }

        @TestMetadata("kt3280.kt")
        public void testKt3280() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3280.kt");
        }

        @TestMetadata("kt3574.kt")
        public void testKt3574() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3574.kt");
        }

        @TestMetadata("kt416.kt")
        public void testKt416() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt416.kt");
        }

        @TestMetadata("kt42455.kt")
        public void testKt42455() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt42455.kt");
        }

        @TestMetadata("kt513.kt")
        public void testKt513() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt513.kt");
        }

        @TestMetadata("kt628.kt")
        public void testKt628() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt628.kt");
        }

        @TestMetadata("kt769.kt")
        public void testKt769() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt769.kt");
        }

        @TestMetadata("kt772.kt")
        public void testKt772() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt772.kt");
        }

        @TestMetadata("kt773.kt")
        public void testKt773() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt773.kt");
        }

        @TestMetadata("kt8148.kt")
        public void testKt8148() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148.kt");
        }

        @TestMetadata("kt8148_break.kt")
        public void testKt8148_break() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148_break.kt");
        }

        @TestMetadata("kt8148_continue.kt")
        public void testKt8148_continue() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148_continue.kt");
        }

        @TestMetadata("kt870.kt")
        public void testKt870() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt870.kt");
        }

        @TestMetadata("kt9022Return.kt")
        public void testKt9022Return() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt9022Return.kt");
        }

        @TestMetadata("kt9022Throw.kt")
        public void testKt9022Throw() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt9022Throw.kt");
        }

        @TestMetadata("kt910.kt")
        public void testKt910() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt910.kt");
        }

        @TestMetadata("kt958.kt")
        public void testKt958() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt958.kt");
        }

        @TestMetadata("longRange.kt")
        public void testLongRange() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/longRange.kt");
        }

        @TestMetadata("parameterWithNameForFunctionType.kt")
        public void testParameterWithNameForFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/parameterWithNameForFunctionType.kt");
        }

        @TestMetadata("quicksort.kt")
        public void testQuicksort() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/quicksort.kt");
        }

        @TestMetadata("tcbInEliminatedCondition.kt")
        public void testTcbInEliminatedCondition() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tcbInEliminatedCondition.kt");
        }

        @TestMetadata("tryCatchExpression.kt")
        public void testTryCatchExpression() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchExpression.kt");
        }

        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinally.kt");
        }

        @TestMetadata("tryCatchFinallyChain.kt")
        public void testTryCatchFinallyChain() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinallyChain.kt");
        }

        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryFinally.kt");
        }

        @TestMetadata("tryFinallyGeneric.kt")
        public void testTryFinallyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryFinallyGeneric.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BreakContinueInExpressions extends AbstractLightAnalysisModeTest {
            @TestMetadata("breakInLoopConditions.kt")
            public void ignoreBreakInLoopConditions() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInLoopConditions.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBreakContinueInExpressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("breakFromOuter.kt")
            public void testBreakFromOuter() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakFromOuter.kt");
            }

            @TestMetadata("breakInDoWhile.kt")
            public void testBreakInDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInDoWhile.kt");
            }

            @TestMetadata("breakInExpr.kt")
            public void testBreakInExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInExpr.kt");
            }

            @TestMetadata("continueInDoWhile.kt")
            public void testContinueInDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInDoWhile.kt");
            }

            @TestMetadata("continueInExpr.kt")
            public void testContinueInExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInExpr.kt");
            }

            @TestMetadata("inlineWithStack.kt")
            public void testInlineWithStack() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlineWithStack.kt");
            }

            @TestMetadata("innerLoopWithStack.kt")
            public void testInnerLoopWithStack() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/innerLoopWithStack.kt");
            }

            @TestMetadata("kt14581.kt")
            public void testKt14581() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt14581.kt");
            }

            @TestMetadata("kt16713.kt")
            public void testKt16713() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713.kt");
            }

            @TestMetadata("kt16713_2.kt")
            public void testKt16713_2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713_2.kt");
            }

            @TestMetadata("kt17384.kt")
            public void testKt17384() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt17384.kt");
            }

            @TestMetadata("kt45704_elvisInInlineFun.kt")
            public void testKt45704_elvisInInlineFun() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt45704_elvisInInlineFun.kt");
            }

            @TestMetadata("kt9022And.kt")
            public void testKt9022And() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022And.kt");
            }

            @TestMetadata("kt9022Or.kt")
            public void testKt9022Or() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022Or.kt");
            }

            @TestMetadata("pathologicalDoWhile.kt")
            public void testPathologicalDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/pathologicalDoWhile.kt");
            }

            @TestMetadata("popSizes.kt")
            public void testPopSizes() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/popSizes.kt");
            }

            @TestMetadata("tryFinally1.kt")
            public void testTryFinally1() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally1.kt");
            }

            @TestMetadata("tryFinally2.kt")
            public void testTryFinally2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally2.kt");
            }

            @TestMetadata("whileTrueBreak.kt")
            public void testWhileTrueBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/whileTrueBreak.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArray")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInArray extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("forInArraySpecializedToUntil.kt")
            public void testForInArraySpecializedToUntil() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArraySpecializedToUntil.kt");
            }

            @TestMetadata("forInArrayWithArrayPropertyUpdatedInLoopBody.kt")
            public void testForInArrayWithArrayPropertyUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayPropertyUpdatedInLoopBody.kt");
            }

            @TestMetadata("forInArrayWithArrayVarUpdatedInLoopBody13.kt")
            public void testForInArrayWithArrayVarUpdatedInLoopBody13() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayVarUpdatedInLoopBody13.kt");
            }

            @TestMetadata("forInDelegatedPropertyUpdatedInLoopBody.kt")
            public void testForInDelegatedPropertyUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDelegatedPropertyUpdatedInLoopBody.kt");
            }

            @TestMetadata("forInDoubleArrayWithUpcast.kt")
            public void testForInDoubleArrayWithUpcast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDoubleArrayWithUpcast.kt");
            }

            @TestMetadata("forInFieldUpdatedInLoopBody.kt")
            public void testForInFieldUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInFieldUpdatedInLoopBody.kt");
            }

            @TestMetadata("forInInlineClassArrayWithUpcast.kt")
            public void testForInInlineClassArrayWithUpcast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInInlineClassArrayWithUpcast.kt");
            }

            @TestMetadata("forIntArray.kt")
            public void testForIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forIntArray.kt");
            }

            @TestMetadata("forNullableIntArray.kt")
            public void testForNullableIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forNullableIntArray.kt");
            }

            @TestMetadata("forPrimitiveIntArray.kt")
            public void testForPrimitiveIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forPrimitiveIntArray.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInArrayWithIndex extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInArrayWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("forInArrayOfObjectArrayWithIndex.kt")
            public void testForInArrayOfObjectArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfObjectArrayWithIndex.kt");
            }

            @TestMetadata("forInArrayOfPrimArrayWithIndex.kt")
            public void testForInArrayOfPrimArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfPrimArrayWithIndex.kt");
            }

            @TestMetadata("forInArrayWithIndexBreakAndContinue.kt")
            public void testForInArrayWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexBreakAndContinue.kt");
            }

            @TestMetadata("forInArrayWithIndexContinuesAsUnmodified.kt")
            public void testForInArrayWithIndexContinuesAsUnmodified() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexContinuesAsUnmodified.kt");
            }

            @TestMetadata("forInArrayWithIndexNoElementVar.kt")
            public void testForInArrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInArrayWithIndexNoIndexOrElementVar.kt")
            public void testForInArrayWithIndexNoIndexOrElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoIndexOrElementVar.kt");
            }

            @TestMetadata("forInArrayWithIndexNoIndexVar.kt")
            public void testForInArrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInArrayWithIndexNotDestructured.kt")
            public void testForInArrayWithIndexNotDestructured() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNotDestructured.kt");
            }

            @TestMetadata("forInArrayWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInArrayWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexWithExplicitlyTypedIndexVariable.kt");
            }

            @TestMetadata("forInByteArrayWithIndex.kt")
            public void testForInByteArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndex.kt");
            }

            @TestMetadata("forInByteArrayWithIndexWithSmartCast.kt")
            public void testForInByteArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInEmptyArrayWithIndex.kt")
            public void testForInEmptyArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
            }

            @TestMetadata("forInGenericArrayOfIntsWithIndex.kt")
            public void testForInGenericArrayOfIntsWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndex.kt");
            }

            @TestMetadata("forInGenericArrayOfIntsWithIndexWithSmartCast.kt")
            public void testForInGenericArrayOfIntsWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInGenericArrayWithIndex.kt")
            public void testForInGenericArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayWithIndex.kt");
            }

            @TestMetadata("forInIntArrayWithIndex.kt")
            public void testForInIntArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndex.kt");
            }

            @TestMetadata("forInIntArrayWithIndexWithSmartCast.kt")
            public void testForInIntArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInObjectArrayWithIndex.kt")
            public void testForInObjectArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
            }

            @TestMetadata("forInShortArrayWithIndex.kt")
            public void testForInShortArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndex.kt");
            }

            @TestMetadata("forInShortArrayWithIndexWithSmartCast.kt")
            public void testForInShortArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndexWithSmartCast.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInCharSequenceWithIndex extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInCharSequenceWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("forInCharSeqWithIndexStops.kt")
            public void testForInCharSeqWithIndexStops() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSeqWithIndexStops.kt");
            }

            @TestMetadata("forInCharSequenceTypeParameterWithIndex.kt")
            public void testForInCharSequenceTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceTypeParameterWithIndex.kt");
            }

            @TestMetadata("forInCharSequenceWithIndex.kt")
            public void testForInCharSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
            }

            @TestMetadata("forInCharSequenceWithIndexBreakAndContinue.kt")
            public void testForInCharSequenceWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexBreakAndContinue.kt");
            }

            @TestMetadata("forInCharSequenceWithIndexCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexCheckSideEffects.kt");
            }

            @TestMetadata("forInCharSequenceWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexNoElementVarCheckSideEffects.kt");
            }

            @TestMetadata("forInCharSequenceWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @TestMetadata("forInEmptyStringWithIndex.kt")
            public void testForInEmptyStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
            }

            @TestMetadata("forInStringWithIndex.kt")
            public void testForInStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndex.kt");
            }

            @TestMetadata("forInStringWithIndexNoElementVar.kt")
            public void testForInStringWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInStringWithIndexNoIndexOrElementVar.kt")
            public void testForInStringWithIndexNoIndexOrElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexOrElementVar.kt");
            }

            @TestMetadata("forInStringWithIndexNoIndexVar.kt")
            public void testForInStringWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInStringWithIndexNotDestructured.kt")
            public void testForInStringWithIndexNotDestructured() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNotDestructured.kt");
            }

            @TestMetadata("forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIterableWithIndex extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInIterableWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("forInEmptyListWithIndex.kt")
            public void testForInEmptyListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInEmptyListWithIndex.kt");
            }

            @TestMetadata("forInIterableTypeParameterWithIndex.kt")
            public void testForInIterableTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
            }

            @TestMetadata("forInIterableWithIndexCheckSideEffects.kt")
            public void testForInIterableWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexCheckSideEffects.kt");
            }

            @TestMetadata("forInIterableWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInIterableWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexNoElementVarCheckSideEffects.kt");
            }

            @TestMetadata("forInIterableWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInIterableWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @TestMetadata("forInListWithIndex.kt")
            public void testForInListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndex.kt");
            }

            @TestMetadata("forInListWithIndexBreak.kt")
            public void testForInListWithIndexBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexBreak.kt");
            }

            @TestMetadata("forInListWithIndexBreakAndContinue.kt")
            public void testForInListWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexBreakAndContinue.kt");
            }

            @TestMetadata("forInListWithIndexContinue.kt")
            public void testForInListWithIndexContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexContinue.kt");
            }

            @TestMetadata("forInListWithIndexNoElementVar.kt")
            public void testForInListWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInListWithIndexNoIndexVar.kt")
            public void testForInListWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInListWithIndexThrowsCME.kt")
            public void testForInListWithIndexThrowsCME() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexThrowsCME.kt");
            }

            @TestMetadata("forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInListWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIterator extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractNext.kt")
            public void testAbstractNext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterator/abstractNext.kt");
            }

            public void testAllFilesPresentInForInIterator() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterator"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("primitiveIterator.kt")
            public void testPrimitiveIterator() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterator/primitiveIterator.kt");
            }

            @TestMetadata("uintIterator.kt")
            public void testUintIterator() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterator/uintIterator.kt");
            }

            @TestMetadata("unrelatedExtensionFunctionNext.kt")
            public void testUnrelatedExtensionFunctionNext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterator/unrelatedExtensionFunctionNext.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInSequenceWithIndex extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInSequenceWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("forInEmptySequenceWithIndex.kt")
            public void testForInEmptySequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
            }

            @TestMetadata("forInSequenceTypeParameterWithIndex.kt")
            public void testForInSequenceTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
            }

            @TestMetadata("forInSequenceWithIndex.kt")
            public void testForInSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndex.kt");
            }

            @TestMetadata("forInSequenceWithIndexBreakAndContinue.kt")
            public void testForInSequenceWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexBreakAndContinue.kt");
            }

            @TestMetadata("forInSequenceWithIndexCheckSideEffects.kt")
            public void testForInSequenceWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexCheckSideEffects.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoElementVar.kt")
            public void testForInSequenceWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInSequenceWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVarCheckSideEffects.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoIndexVar.kt")
            public void testForInSequenceWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInSequenceWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @TestMetadata("forInSequenceWithIndexThrowsCME.kt")
            public void testForInSequenceWithIndexThrowsCME() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
            }

            @TestMetadata("forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReturnsNothing extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInReturnsNothing() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/returnsNothing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("ifElse.kt")
            public void testIfElse() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/ifElse.kt");
            }

            @TestMetadata("inlineMethod.kt")
            public void testInlineMethod() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/inlineMethod.kt");
            }

            @TestMetadata("propertyGetter.kt")
            public void testPropertyGetter() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/propertyGetter.kt");
            }

            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/tryCatch.kt");
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/when.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/slowDsl")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SlowDsl extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSlowDsl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/slowDsl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("slowHtmlLikeDsl.kt")
            public void testSlowHtmlLikeDsl() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/slowDsl/slowHtmlLikeDsl.kt");
            }

            @TestMetadata("slowHtmlLikeDslNoInline.kt")
            public void testSlowHtmlLikeDslNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/slowDsl/slowHtmlLikeDslNoInline.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TryCatchInExpressions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInTryCatchInExpressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("catch.kt")
            public void testCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/catch.kt");
            }

            @TestMetadata("complexChain.kt")
            public void testComplexChain() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/complexChain.kt");
            }

            @TestMetadata("deadTryCatch.kt")
            public void testDeadTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/deadTryCatch.kt");
            }

            @TestMetadata("differentTypes.kt")
            public void testDifferentTypes() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/differentTypes.kt");
            }

            @TestMetadata("expectException.kt")
            public void testExpectException() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/expectException.kt");
            }

            @TestMetadata("finally.kt")
            public void testFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/finally.kt");
            }

            @TestMetadata("inlineTryCatch.kt")
            public void testInlineTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryCatch.kt");
            }

            @TestMetadata("inlineTryExpr.kt")
            public void testInlineTryExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryExpr.kt");
            }

            @TestMetadata("inlineTryFinally.kt")
            public void testInlineTryFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryFinally.kt");
            }

            @TestMetadata("kt17572.kt")
            public void testKt17572() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572.kt");
            }

            @TestMetadata("kt17572_2.kt")
            public void testKt17572_2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2.kt");
            }

            @TestMetadata("kt17572_2_ext.kt")
            public void testKt17572_2_ext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2_ext.kt");
            }

            @TestMetadata("kt17572_ext.kt")
            public void testKt17572_ext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_ext.kt");
            }

            @TestMetadata("kt17572_nested.kt")
            public void testKt17572_nested() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_nested.kt");
            }

            @TestMetadata("kt17573.kt")
            public void testKt17573() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573.kt");
            }

            @TestMetadata("kt17573_nested.kt")
            public void testKt17573_nested() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573_nested.kt");
            }

            @TestMetadata("kt8608.kt")
            public void testKt8608() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt8608.kt");
            }

            @TestMetadata("kt9644try.kt")
            public void testKt9644try() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt9644try.kt");
            }

            @TestMetadata("multipleCatchBlocks.kt")
            public void testMultipleCatchBlocks() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/multipleCatchBlocks.kt");
            }

            @TestMetadata("nonLocalReturnInTryFinally.kt")
            public void testNonLocalReturnInTryFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/nonLocalReturnInTryFinally.kt");
            }

            @TestMetadata("splitTry.kt")
            public void testSplitTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTry.kt");
            }

            @TestMetadata("splitTryCorner1.kt")
            public void testSplitTryCorner1() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner1.kt");
            }

            @TestMetadata("splitTryCorner2.kt")
            public void testSplitTryCorner2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner2.kt");
            }

            @TestMetadata("try.kt")
            public void testTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/try.kt");
            }

            @TestMetadata("tryAfterTry.kt")
            public void testTryAfterTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAfterTry.kt");
            }

            @TestMetadata("tryAndBreak.kt")
            public void testTryAndBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndBreak.kt");
            }

            @TestMetadata("tryAndContinue.kt")
            public void testTryAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndContinue.kt");
            }

            @TestMetadata("tryCatchAfterWhileTrue.kt")
            public void testTryCatchAfterWhileTrue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryCatchAfterWhileTrue.kt");
            }

            @TestMetadata("tryInsideCatch.kt")
            public void testTryInsideCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideCatch.kt");
            }

            @TestMetadata("tryInsideTry.kt")
            public void testTryInsideTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideTry.kt");
            }

            @TestMetadata("unmatchedInlineMarkers.kt")
            public void testUnmatchedInlineMarkers() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/unmatchedInlineMarkers.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Coroutines extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt21080.kt")
        public void ignoreKt21080() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt21080.kt");
        }

        @TestMetadata("kt24135.kt")
        public void ignoreKt24135() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt24135.kt");
        }

        @TestMetadata("kt49168.kt")
        public void ignoreKt49168() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt49168.kt");
        }

        @TestMetadata("kt51530.kt")
        public void ignoreKt51530() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt51530.kt");
        }

        @TestMetadata("suspendFunctionAsSupertype.kt")
        public void ignoreSuspendFunctionAsSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsSupertype.kt");
        }

        @TestMetadata("suspendInlineReference.kt")
        public void ignoreSuspendInlineReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInlineReference.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("32defaultParametersInSuspend.kt")
        public void test32defaultParametersInSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/32defaultParametersInSuspend.kt");
        }

        @TestMetadata("accessorForSuspend.kt")
        public void testAccessorForSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/accessorForSuspend.kt");
        }

        public void testAllFilesPresentInCoroutines() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("async.kt")
        public void testAsync() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/async.kt");
        }

        @TestMetadata("asyncException.kt")
        public void testAsyncException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncException.kt");
        }

        @TestMetadata("asyncIteratorNullMerge_1_3.kt")
        public void testAsyncIteratorNullMerge_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorNullMerge_1_3.kt");
        }

        @TestMetadata("asyncIteratorToList_1_3.kt")
        public void testAsyncIteratorToList_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorToList_1_3.kt");
        }

        @TestMetadata("asyncIterator_1_3.kt")
        public void testAsyncIterator_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIterator_1_3.kt");
        }

        @TestMetadata("await.kt")
        public void testAwait() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/await.kt");
        }

        @TestMetadata("beginWithException.kt")
        public void testBeginWithException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/beginWithException.kt");
        }

        @TestMetadata("beginWithExceptionNoHandleException.kt")
        public void testBeginWithExceptionNoHandleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/beginWithExceptionNoHandleException.kt");
        }

        @TestMetadata("builderInferenceAndGenericArrayAcessCall.kt")
        public void testBuilderInferenceAndGenericArrayAcessCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/builderInferenceAndGenericArrayAcessCall.kt");
        }

        @TestMetadata("captureInfixFun.kt")
        public void testCaptureInfixFun() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureInfixFun.kt");
        }

        @TestMetadata("captureMutableLocalVariableInsideCoroutineBlock.kt")
        public void testCaptureMutableLocalVariableInsideCoroutineBlock() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureMutableLocalVariableInsideCoroutineBlock.kt");
        }

        @TestMetadata("captureUnaryOperator.kt")
        public void testCaptureUnaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureUnaryOperator.kt");
        }

        @TestMetadata("capturedVarInSuspendLambda.kt")
        public void testCapturedVarInSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/capturedVarInSuspendLambda.kt");
        }

        @TestMetadata("castWithSuspend.kt")
        public void testCastWithSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/castWithSuspend.kt");
        }

        @TestMetadata("catchWithInlineInsideSuspend.kt")
        public void testCatchWithInlineInsideSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/catchWithInlineInsideSuspend.kt");
        }

        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coercionToUnit.kt");
        }

        @TestMetadata("controllerAccessFromInnerLambda.kt")
        public void testControllerAccessFromInnerLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/controllerAccessFromInnerLambda.kt");
        }

        @TestMetadata("coroutineContextInInlinedLambda.kt")
        public void testCoroutineContextInInlinedLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coroutineContextInInlinedLambda.kt");
        }

        @TestMetadata("coroutineToString.kt")
        public void testCoroutineToString() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coroutineToString.kt");
        }

        @TestMetadata("createCoroutineSafe.kt")
        public void testCreateCoroutineSafe() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/createCoroutineSafe.kt");
        }

        @TestMetadata("createCoroutinesOnManualInstances.kt")
        public void testCreateCoroutinesOnManualInstances() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/createCoroutinesOnManualInstances.kt");
        }

        @TestMetadata("crossInlineWithCapturedOuterReceiver.kt")
        public void testCrossInlineWithCapturedOuterReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/crossInlineWithCapturedOuterReceiver.kt");
        }

        @TestMetadata("defaultParametersInSuspend.kt")
        public void testDefaultParametersInSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/defaultParametersInSuspend.kt");
        }

        @TestMetadata("defaultParametersInSuspendWithJvmOverloads.kt")
        public void testDefaultParametersInSuspendWithJvmOverloads() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/defaultParametersInSuspendWithJvmOverloads.kt");
        }

        @TestMetadata("delegatedSuspendMember.kt")
        public void testDelegatedSuspendMember() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/delegatedSuspendMember.kt");
        }

        @TestMetadata("dispatchResume.kt")
        public void testDispatchResume() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/dispatchResume.kt");
        }

        @TestMetadata("doubleColonExpressionsGenerationInBuilderInference.kt")
        public void testDoubleColonExpressionsGenerationInBuilderInference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/doubleColonExpressionsGenerationInBuilderInference.kt");
        }

        @TestMetadata("emptyClosure.kt")
        public void testEmptyClosure() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/emptyClosure.kt");
        }

        @TestMetadata("emptyCommonConstraintSystemForCoroutineInferenceCall.kt")
        public void testEmptyCommonConstraintSystemForCoroutineInferenceCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/emptyCommonConstraintSystemForCoroutineInferenceCall.kt");
        }

        @TestMetadata("epam.kt")
        public void testEpam() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/epam.kt");
        }

        @TestMetadata("falseUnitCoercion.kt")
        public void testFalseUnitCoercion() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/falseUnitCoercion.kt");
        }

        @TestMetadata("generate.kt")
        public void testGenerate() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/generate.kt");
        }

        @TestMetadata("handleException.kt")
        public void testHandleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleException.kt");
        }

        @TestMetadata("handleResultCallEmptyBody.kt")
        public void testHandleResultCallEmptyBody() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultCallEmptyBody.kt");
        }

        @TestMetadata("handleResultNonUnitExpression.kt")
        public void testHandleResultNonUnitExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultNonUnitExpression.kt");
        }

        @TestMetadata("handleResultSuspended.kt")
        public void testHandleResultSuspended() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultSuspended.kt");
        }

        @TestMetadata("illegalState.kt")
        public void testIllegalState() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/illegalState.kt");
        }

        @TestMetadata("indirectInlineUsedAsNonInline.kt")
        public void testIndirectInlineUsedAsNonInline() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/indirectInlineUsedAsNonInline.kt");
        }

        @TestMetadata("inlineFunInGenericClass.kt")
        public void testInlineFunInGenericClass() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineFunInGenericClass.kt");
        }

        @TestMetadata("inlineFunctionInMultifileClass.kt")
        public void testInlineFunctionInMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineFunctionInMultifileClass.kt");
        }

        @TestMetadata("inlineFunctionInMultifileClassUnoptimized.kt")
        public void testInlineFunctionInMultifileClassUnoptimized() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineFunctionInMultifileClassUnoptimized.kt");
        }

        @TestMetadata("inlineGenericFunCalledFromSubclass.kt")
        public void testInlineGenericFunCalledFromSubclass() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineGenericFunCalledFromSubclass.kt");
        }

        @TestMetadata("inlineSuspendFunction.kt")
        public void testInlineSuspendFunction() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineSuspendFunction.kt");
        }

        @TestMetadata("inlineSuspendLambdaNonLocalReturn.kt")
        public void testInlineSuspendLambdaNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineSuspendLambdaNonLocalReturn.kt");
        }

        @TestMetadata("inlinedTryCatchFinally.kt")
        public void testInlinedTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlinedTryCatchFinally.kt");
        }

        @TestMetadata("innerSuspensionCalls.kt")
        public void testInnerSuspensionCalls() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/innerSuspensionCalls.kt");
        }

        @TestMetadata("instanceOfContinuation.kt")
        public void testInstanceOfContinuation() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/instanceOfContinuation.kt");
        }

        @TestMetadata("iterateOverArray.kt")
        public void testIterateOverArray() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/iterateOverArray.kt");
        }

        @TestMetadata("jvmStaticAndJvmInline.kt")
        public void testJvmStaticAndJvmInline() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/jvmStaticAndJvmInline.kt");
        }

        @TestMetadata("kt12958.kt")
        public void testKt12958() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt12958.kt");
        }

        @TestMetadata("kt15016.kt")
        public void testKt15016() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15016.kt");
        }

        @TestMetadata("kt15017.kt")
        public void testKt15017() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15017.kt");
        }

        @TestMetadata("kt15930.kt")
        public void testKt15930() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15930.kt");
        }

        @TestMetadata("kt21605.kt")
        public void testKt21605() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt21605.kt");
        }

        @TestMetadata("kt25912.kt")
        public void testKt25912() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt25912.kt");
        }

        @TestMetadata("kt28844.kt")
        public void testKt28844() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt28844.kt");
        }

        @TestMetadata("kt30858.kt")
        public void testKt30858() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt30858.kt");
        }

        @TestMetadata("kt31784.kt")
        public void testKt31784() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt31784.kt");
        }

        @TestMetadata("kt35967.kt")
        public void testKt35967() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt35967.kt");
        }

        @TestMetadata("kt38099.kt")
        public void testKt38099() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt38099.kt");
        }

        @TestMetadata("kt42028.kt")
        public void testKt42028() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt42028.kt");
        }

        @TestMetadata("kt42554.kt")
        public void testKt42554() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt42554.kt");
        }

        @TestMetadata("kt44221.kt")
        public void testKt44221() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44221.kt");
        }

        @TestMetadata("kt44710.kt")
        public void testKt44710() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44710.kt");
        }

        @TestMetadata("kt44781.kt")
        public void testKt44781() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44781.kt");
        }

        @TestMetadata("kt45377.kt")
        public void testKt45377() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt45377.kt");
        }

        @TestMetadata("kt46813.kt")
        public void testKt46813() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt46813.kt");
        }

        @TestMetadata("kt49317.kt")
        public void testKt49317() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt49317.kt");
        }

        @TestMetadata("kt49645.kt")
        public void testKt49645() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt49645.kt");
        }

        @TestMetadata("kt50277.kt")
        public void testKt50277() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt50277.kt");
        }

        @TestMetadata("kt51718.kt")
        public void testKt51718() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt51718.kt");
        }

        @TestMetadata("lastExpressionIsLoop.kt")
        public void testLastExpressionIsLoop() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastExpressionIsLoop.kt");
        }

        @TestMetadata("lastStatementInc.kt")
        public void testLastStatementInc() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastStatementInc.kt");
        }

        @TestMetadata("lastStementAssignment.kt")
        public void testLastStementAssignment() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastStementAssignment.kt");
        }

        @TestMetadata("lastUnitExpression.kt")
        public void testLastUnitExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastUnitExpression.kt");
        }

        @TestMetadata("localCallableRef.kt")
        public void testLocalCallableRef() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/localCallableRef.kt");
        }

        @TestMetadata("localDelegate.kt")
        public void testLocalDelegate() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/localDelegate.kt");
        }

        @TestMetadata("longRangeInSuspendCall.kt")
        public void testLongRangeInSuspendCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/longRangeInSuspendCall.kt");
        }

        @TestMetadata("longRangeInSuspendFun.kt")
        public void testLongRangeInSuspendFun() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/longRangeInSuspendFun.kt");
        }

        @TestMetadata("mergeNullAndString.kt")
        public void testMergeNullAndString() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/mergeNullAndString.kt");
        }

        @TestMetadata("multipleInvokeCalls.kt")
        public void testMultipleInvokeCalls() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCalls.kt");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda1.kt")
        public void testMultipleInvokeCallsInsideInlineLambda1() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda1.kt");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda2.kt")
        public void testMultipleInvokeCallsInsideInlineLambda2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda2.kt");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda3.kt")
        public void testMultipleInvokeCallsInsideInlineLambda3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda3.kt");
        }

        @TestMetadata("nestedTryCatch.kt")
        public void testNestedTryCatch() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nestedTryCatch.kt");
        }

        @TestMetadata("noSuspensionPoints.kt")
        public void testNoSuspensionPoints() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/noSuspensionPoints.kt");
        }

        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturn.kt");
        }

        @TestMetadata("nonLocalReturnFromInlineLambda.kt")
        public void testNonLocalReturnFromInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambda.kt");
        }

        @TestMetadata("nonLocalReturnFromInlineLambdaDeep.kt")
        public void testNonLocalReturnFromInlineLambdaDeep() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambdaDeep.kt");
        }

        @TestMetadata("nullableSuspendFunctionType.kt")
        public void testNullableSuspendFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nullableSuspendFunctionType.kt");
        }

        @TestMetadata("overrideDefaultArgument.kt")
        public void testOverrideDefaultArgument() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/overrideDefaultArgument.kt");
        }

        @TestMetadata("recursiveSuspend.kt")
        public void testRecursiveSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/recursiveSuspend.kt");
        }

        @TestMetadata("restrictedSuspendLambda.kt")
        public void testRestrictedSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/restrictedSuspendLambda.kt");
        }

        @TestMetadata("returnByLabel.kt")
        public void testReturnByLabel() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/returnByLabel.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simple.kt");
        }

        @TestMetadata("simpleException.kt")
        public void testSimpleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleException.kt");
        }

        @TestMetadata("simpleSuspendCallableReference.kt")
        public void testSimpleSuspendCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleSuspendCallableReference.kt");
        }

        @TestMetadata("simpleWithDefaultValue.kt")
        public void testSimpleWithDefaultValue() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleWithDefaultValue.kt");
        }

        @TestMetadata("simpleWithHandleResult.kt")
        public void testSimpleWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleWithHandleResult.kt");
        }

        @TestMetadata("statementLikeLastExpression.kt")
        public void testStatementLikeLastExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/statementLikeLastExpression.kt");
        }

        @TestMetadata("stopAfter.kt")
        public void testStopAfter() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/stopAfter.kt");
        }

        @TestMetadata("suspendCallInSuperInterfaceCallArguments.kt")
        public void testSuspendCallInSuperInterfaceCallArguments() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCallInSuperInterfaceCallArguments.kt");
        }

        @TestMetadata("suspendCallsInArguments.kt")
        public void testSuspendCallsInArguments() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCallsInArguments.kt");
        }

        @TestMetadata("suspendCoroutineFromStateMachine.kt")
        public void testSuspendCoroutineFromStateMachine() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCoroutineFromStateMachine.kt");
        }

        @TestMetadata("suspendCovariantJavaOverrides.kt")
        public void testSuspendCovariantJavaOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCovariantJavaOverrides.kt");
        }

        @TestMetadata("suspendDefaultImpl.kt")
        public void testSuspendDefaultImpl() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendDefaultImpl.kt");
        }

        @TestMetadata("suspendDelegation.kt")
        public void testSuspendDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendDelegation.kt");
        }

        @TestMetadata("suspendFromInlineLambda.kt")
        public void testSuspendFromInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFromInlineLambda.kt");
        }

        @TestMetadata("suspendFunImportedFromObject.kt")
        public void testSuspendFunImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunImportedFromObject.kt");
        }

        @TestMetadata("suspendFunctionAsSupertypeCall.kt")
        public void testSuspendFunctionAsSupertypeCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsSupertypeCall.kt");
        }

        @TestMetadata("suspendFunctionMethodReference.kt")
        public void testSuspendFunctionMethodReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionMethodReference.kt");
        }

        @TestMetadata("suspendImplBridge.kt")
        public void testSuspendImplBridge() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendImplBridge.kt");
        }

        @TestMetadata("suspendInCycle.kt")
        public void testSuspendInCycle() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInCycle.kt");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstruction.kt")
        public void testSuspendInTheMiddleOfObjectConstruction() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstruction.kt");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt")
        public void testSuspendInTheMiddleOfObjectConstructionEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstructionWithJumpOut.kt")
        public void testSuspendInTheMiddleOfObjectConstructionWithJumpOut() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionWithJumpOut.kt");
        }

        @TestMetadata("suspendJavaOverrides.kt")
        public void testSuspendJavaOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendJavaOverrides.kt");
        }

        @TestMetadata("suspendLambdaInInterface.kt")
        public void testSuspendLambdaInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendLambdaInInterface.kt");
        }

        @TestMetadata("suspendLambdaWithArgumentRearrangement.kt")
        public void testSuspendLambdaWithArgumentRearrangement() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendLambdaWithArgumentRearrangement.kt");
        }

        @TestMetadata("suspendReturningPlatformType.kt")
        public void testSuspendReturningPlatformType() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendReturningPlatformType.kt");
        }

        @TestMetadata("suspensionInsideSafeCall.kt")
        public void testSuspensionInsideSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCall.kt");
        }

        @TestMetadata("suspensionInsideSafeCallWithElvis.kt")
        public void testSuspensionInsideSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCallWithElvis.kt");
        }

        @TestMetadata("tailCallToNothing.kt")
        public void testTailCallToNothing() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tailCallToNothing.kt");
        }

        @TestMetadata("tryCatchFinallyWithHandleResult.kt")
        public void testTryCatchFinallyWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryCatchFinallyWithHandleResult.kt");
        }

        @TestMetadata("tryCatchWithHandleResult.kt")
        public void testTryCatchWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryCatchWithHandleResult.kt");
        }

        @TestMetadata("tryFinallyInsideInlineLambda.kt")
        public void testTryFinallyInsideInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryFinallyInsideInlineLambda.kt");
        }

        @TestMetadata("tryFinallyWithHandleResult.kt")
        public void testTryFinallyWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryFinallyWithHandleResult.kt");
        }

        @TestMetadata("varCaptuedInCoroutineIntrinsic.kt")
        public void testVarCaptuedInCoroutineIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varCaptuedInCoroutineIntrinsic.kt");
        }

        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varValueConflictsWithTable.kt");
        }

        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varValueConflictsWithTableSameSort.kt");
        }

        @TestMetadata("varargCallFromSuspend.kt")
        public void testVarargCallFromSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varargCallFromSuspend.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/bridges")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bridges extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBridges() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/bridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("interfaceGenericDefault.kt")
            public void testInterfaceGenericDefault() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/interfaceGenericDefault.kt");
            }

            @TestMetadata("interfaceSpecialization.kt")
            public void testInterfaceSpecialization() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/interfaceSpecialization.kt");
            }

            @TestMetadata("lambdaWithLongReceiver.kt")
            public void testLambdaWithLongReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/lambdaWithLongReceiver.kt");
            }

            @TestMetadata("lambdaWithMultipleParameters.kt")
            public void testLambdaWithMultipleParameters() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/lambdaWithMultipleParameters.kt");
            }

            @TestMetadata("mapSuspendAbstractClear.kt")
            public void testMapSuspendAbstractClear() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/mapSuspendAbstractClear.kt");
            }

            @TestMetadata("mapSuspendClear.kt")
            public void testMapSuspendClear() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/mapSuspendClear.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/controlFlow")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlFlow extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInControlFlow() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/controlFlow"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("breakFinally.kt")
            public void testBreakFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/breakFinally.kt");
            }

            @TestMetadata("breakStatement.kt")
            public void testBreakStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/breakStatement.kt");
            }

            @TestMetadata("complexChainSuspend.kt")
            public void testComplexChainSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/complexChainSuspend.kt");
            }

            @TestMetadata("doWhileStatement.kt")
            public void testDoWhileStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doWhileStatement.kt");
            }

            @TestMetadata("doWhileWithInline.kt")
            public void testDoWhileWithInline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doWhileWithInline.kt");
            }

            @TestMetadata("doubleBreak.kt")
            public void testDoubleBreak() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doubleBreak.kt");
            }

            @TestMetadata("finallyCatch.kt")
            public void testFinallyCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/finallyCatch.kt");
            }

            @TestMetadata("forContinue.kt")
            public void testForContinue() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forContinue.kt");
            }

            @TestMetadata("forStatement.kt")
            public void testForStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forStatement.kt");
            }

            @TestMetadata("forWithStep.kt")
            public void testForWithStep() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forWithStep.kt");
            }

            @TestMetadata("ifStatement.kt")
            public void testIfStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/ifStatement.kt");
            }

            @TestMetadata("kt22694_1_3.kt")
            public void testKt22694_1_3() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/kt22694_1_3.kt");
            }

            @TestMetadata("labeledWhile.kt")
            public void testLabeledWhile() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/labeledWhile.kt");
            }

            @TestMetadata("multipleCatchBlocksSuspend.kt")
            public void testMultipleCatchBlocksSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/multipleCatchBlocksSuspend.kt");
            }

            @TestMetadata("returnFromFinally.kt")
            public void testReturnFromFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/returnFromFinally.kt");
            }

            @TestMetadata("returnWithFinally.kt")
            public void testReturnWithFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/returnWithFinally.kt");
            }

            @TestMetadata("suspendInStringTemplate.kt")
            public void testSuspendInStringTemplate() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/suspendInStringTemplate.kt");
            }

            @TestMetadata("switchLikeWhen.kt")
            public void testSwitchLikeWhen() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/switchLikeWhen.kt");
            }

            @TestMetadata("throwFromCatch.kt")
            public void testThrowFromCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwFromCatch.kt");
            }

            @TestMetadata("throwFromFinally.kt")
            public void testThrowFromFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwFromFinally.kt");
            }

            @TestMetadata("throwInTryWithHandleResult.kt")
            public void testThrowInTryWithHandleResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwInTryWithHandleResult.kt");
            }

            @TestMetadata("whenWithSuspensions.kt")
            public void testWhenWithSuspensions() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/whenWithSuspensions.kt");
            }

            @TestMetadata("whileStatement.kt")
            public void testWhileStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/whileStatement.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/debug")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Debug extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDebug() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("debuggerMetadata.kt")
            public void testDebuggerMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/debuggerMetadata.kt");
            }

            @TestMetadata("elvisLineNumber.kt")
            public void testElvisLineNumber() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/elvisLineNumber.kt");
            }

            @TestMetadata("firstSuspensionPoint.kt")
            public void testFirstSuspensionPoint() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/firstSuspensionPoint.kt");
            }

            @TestMetadata("fqName.kt")
            public void testFqName() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/fqName.kt");
            }

            @TestMetadata("multipleSuspendCallsOnSameLine.kt")
            public void testMultipleSuspendCallsOnSameLine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/multipleSuspendCallsOnSameLine.kt");
            }

            @TestMetadata("runtimeDebugMetadata.kt")
            public void testRuntimeDebugMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/runtimeDebugMetadata.kt");
            }

            @TestMetadata("throwsOnSameLine.kt")
            public void testThrowsOnSameLine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/throwsOnSameLine.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FeatureIntersection extends AbstractLightAnalysisModeTest {
            @TestMetadata("funInterface.kt")
            public void ignoreFunInterface() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface.kt");
            }

            @TestMetadata("suspendFunctionAsSupertypeIsCheck.kt")
            public void ignoreSuspendFunctionAsSupertypeIsCheck() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionAsSupertypeIsCheck.kt");
            }

            @TestMetadata("suspendFunctionAsSupertypeIsCheckWithArity.kt")
            public void ignoreSuspendFunctionAsSupertypeIsCheckWithArity() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionAsSupertypeIsCheckWithArity.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFeatureIntersection() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("breakWithNonEmptyStack.kt")
            public void testBreakWithNonEmptyStack() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/breakWithNonEmptyStack.kt");
            }

            @TestMetadata("defaultExpect.kt")
            public void testDefaultExpect() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/defaultExpect.kt");
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/delegate.kt");
            }

            @TestMetadata("destructuringInLambdas.kt")
            public void testDestructuringInLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/destructuringInLambdas.kt");
            }

            @TestMetadata("inlineSuspendFinally.kt")
            public void testInlineSuspendFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/inlineSuspendFinally.kt");
            }

            @TestMetadata("interfaceMethodWithBody.kt")
            public void testInterfaceMethodWithBody() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/interfaceMethodWithBody.kt");
            }

            @TestMetadata("interfaceMethodWithBodyGeneric.kt")
            public void testInterfaceMethodWithBodyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/interfaceMethodWithBodyGeneric.kt");
            }

            @TestMetadata("overrideInInlineClass.kt")
            public void testOverrideInInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/overrideInInlineClass.kt");
            }

            @TestMetadata("overrideInInnerClass.kt")
            public void testOverrideInInnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/overrideInInnerClass.kt");
            }

            @TestMetadata("safeCallOnTwoReceivers.kt")
            public void testSafeCallOnTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceivers.kt");
            }

            @TestMetadata("safeCallOnTwoReceiversLong.kt")
            public void testSafeCallOnTwoReceiversLong() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceiversLong.kt");
            }

            @TestMetadata("suspendDestructuringInLambdas.kt")
            public void testSuspendDestructuringInLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendDestructuringInLambdas.kt");
            }

            @TestMetadata("suspendFunctionIsAs.kt")
            public void testSuspendFunctionIsAs() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionIsAs.kt");
            }

            @TestMetadata("suspendInlineSuspendFinally.kt")
            public void testSuspendInlineSuspendFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendInlineSuspendFinally.kt");
            }

            @TestMetadata("suspendOperatorPlus.kt")
            public void testSuspendOperatorPlus() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlus.kt");
            }

            @TestMetadata("suspendOperatorPlusAssign.kt")
            public void testSuspendOperatorPlusAssign() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusAssign.kt");
            }

            @TestMetadata("suspendOperatorPlusCallFromLambda.kt")
            public void testSuspendOperatorPlusCallFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusCallFromLambda.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallableReference extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInCallableReference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("bigArity.kt")
                public void testBigArity() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bigArity.kt");
                }

                @TestMetadata("fromJava.kt")
                public void testFromJava() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/fromJava.kt");
                }

                @TestMetadata("kt48732_genericSignature.kt")
                public void testKt48732_genericSignature() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/kt48732_genericSignature.kt");
                }

                @TestMetadata("lambdaParameterUsed.kt")
                public void testLambdaParameterUsed() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/lambdaParameterUsed.kt");
                }

                @TestMetadata("longArgs.kt")
                public void testLongArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/longArgs.kt");
                }

                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Bound extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInBound() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                    }

                    @TestMetadata("emptyLHS.kt")
                    public void testEmptyLHS() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound/emptyLHS.kt");
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Function extends AbstractLightAnalysisModeTest {
                    @TestMetadata("adapted.kt")
                    public void ignoreAdapted() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/adapted.kt");
                    }

                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInFunction() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                    }

                    @TestMetadata("genericCallableReferenceArguments.kt")
                    public void testGenericCallableReferenceArguments() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferenceArguments.kt");
                    }

                    @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
                    public void testGenericCallableReferencesWithNullableTypes() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
                    }

                    @TestMetadata("getArityViaFunctionImpl.kt")
                    public void testGetArityViaFunctionImpl() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/getArityViaFunctionImpl.kt");
                    }

                    @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Local extends AbstractLightAnalysisModeTest {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                        }

                        public void testAllFilesPresentInLocal() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                        }

                        @TestMetadata("equalsHashCode.kt")
                        public void testEqualsHashCode() throws Exception {
                            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local/equalsHashCode.kt");
                        }
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunInterface extends AbstractLightAnalysisModeTest {
                @TestMetadata("kt49294.kt")
                public void ignoreKt49294() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt49294.kt");
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInFunInterface() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("kt47549.kt")
                public void testKt47549() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt47549.kt");
                }

                @TestMetadata("kt47549_1.kt")
                public void testKt47549_1() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt47549_1.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JvmDefault extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                @TestMetadata("all.kt")
                public void testAll() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/all.kt");
                }

                public void testAllFilesPresentInJvmDefault() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Kt46007 extends AbstractLightAnalysisModeTest {
                    @TestMetadata("all-compatibility.kt")
                    public void ignoreAll_compatibility() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/all-compatibility.kt");
                    }

                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    @TestMetadata("all.kt")
                    public void testAll() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/all.kt");
                    }

                    public void testAllFilesPresentInKt46007() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                    }

                    @TestMetadata("disable.kt")
                    public void testDisable() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/disable.kt");
                    }

                    @TestMetadata("enable.kt")
                    public void testEnable() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/enable.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Tailrec extends AbstractLightAnalysisModeTest {
                @TestMetadata("kt38920_localTailrec.kt")
                public void ignoreKt38920_localTailrec() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/kt38920_localTailrec.kt");
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInTailrec() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("controlFlowIf.kt")
                public void testControlFlowIf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowIf.kt");
                }

                @TestMetadata("controlFlowWhen.kt")
                public void testControlFlowWhen() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowWhen.kt");
                }

                @TestMetadata("extention.kt")
                public void testExtention() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/extention.kt");
                }

                @TestMetadata("infixCall.kt")
                public void testInfixCall() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixCall.kt");
                }

                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixRecursiveCall.kt");
                }

                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realIteratorFoldl.kt");
                }

                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringEscape.kt");
                }

                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringRepeat.kt");
                }

                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/returnInParentheses.kt");
                }

                @TestMetadata("sum.kt")
                public void testSum() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/sum.kt");
                }

                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInBlockInParentheses.kt");
                }

                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInParentheses.kt");
                }

                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/whenWithIs.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineClasses extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("genericParameterResult.kt")
            public void testGenericParameterResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/genericParameterResult.kt");
            }

            @TestMetadata("kt47129.kt")
            public void testKt47129() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/kt47129.kt");
            }

            @TestMetadata("nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/nonLocalReturn.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/direct")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Direct extends AbstractLightAnalysisModeTest {
                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void ignoreBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxTypeParameterOfSuperType.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void ignoreBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxTypeParameterOfSuperTypeResult.kt");
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInDirect() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/direct"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxReturnValueOfSuspendLambda.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Any.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Int.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Long.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_NAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/bridgeGenerationCrossinline.kt");
                }

                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/bridgeGenerationNonInline.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/createMangling.kt");
                }

                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/createOverride.kt");
                }

                @TestMetadata("defaultStub.kt")
                public void testDefaultStub() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/defaultStub.kt");
                }

                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableAny.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny_null.kt")
                public void testGenericOverrideSuspendFun_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableAny_null.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableInt.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt_null.kt")
                public void testGenericOverrideSuspendFun_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableInt_null.kt");
                }

                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/interfaceDelegateWithInlineClass.kt");
                }

                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/invokeOperator.kt");
                }

                @TestMetadata("multifileBridge.kt")
                public void testMultifileBridge() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/multifileBridge.kt");
                }

                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun.kt");
                }

                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any_itf.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any_this.kt");
                }

                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Int.kt");
                }

                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/returnResult.kt");
                }

                @TestMetadata("syntheticAccessor.kt")
                public void testSyntheticAccessor() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/syntheticAccessor.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/resume")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Resume extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInResume() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/resume"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxReturnValueOfSuspendLambda.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void testBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxTypeParameterOfSuperType.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void testBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxTypeParameterOfSuperTypeResult.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Any.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Int.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Long.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_NAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/bridgeGenerationCrossinline.kt");
                }

                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/bridgeGenerationNonInline.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/createMangling.kt");
                }

                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/createOverride.kt");
                }

                @TestMetadata("defaultStub.kt")
                public void testDefaultStub() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/defaultStub.kt");
                }

                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableAny.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny_null.kt")
                public void testGenericOverrideSuspendFun_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableAny_null.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableInt.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt_null.kt")
                public void testGenericOverrideSuspendFun_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableInt_null.kt");
                }

                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/interfaceDelegateWithInlineClass.kt");
                }

                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/invokeOperator.kt");
                }

                @TestMetadata("multifileBridge.kt")
                public void testMultifileBridge() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/multifileBridge.kt");
                }

                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun.kt");
                }

                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any_itf.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any_this.kt");
                }

                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Int.kt");
                }

                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/returnResult.kt");
                }

                @TestMetadata("syntheticAccessor.kt")
                public void testSyntheticAccessor() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/syntheticAccessor.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ResumeWithException extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInResumeWithException() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxReturnValueOfSuspendLambda.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void testBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxTypeParameterOfSuperType.kt");
                }

                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void testBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxTypeParameterOfSuperTypeResult.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Any.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Int.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Long.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_NAny.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/bridgeGenerationCrossinline.kt");
                }

                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/bridgeGenerationNonInline.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/createMangling.kt");
                }

                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/createOverride.kt");
                }

                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Any.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Int.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_NullableAny.kt");
                }

                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_NullableInt.kt");
                }

                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/interfaceDelegateWithInlineClass.kt");
                }

                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/invokeOperator.kt");
                }

                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun.kt");
                }

                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any_itf.kt");
                }

                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any_this.kt");
                }

                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Int.kt");
                }

                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/returnResult.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntLikeVarSpilling extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/complicatedMerge.kt");
            }

            @TestMetadata("i2bResult.kt")
            public void testI2bResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/i2bResult.kt");
            }

            @TestMetadata("listThrowablePairInOneSlot.kt")
            public void testListThrowablePairInOneSlot() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/listThrowablePairInOneSlot.kt");
            }

            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
            }

            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
            }

            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/noVariableInTable.kt");
            }

            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
            }

            @TestMetadata("unusedCatchVar.kt")
            public void testUnusedCatchVar() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/unusedCatchVar.kt");
            }

            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
            }

            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
            }

            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInPutfield.kt");
            }

            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInVarStore.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/intrinsicSemantics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntrinsicSemantics extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInIntrinsicSemantics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intrinsicSemantics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("coroutineContext.kt")
            public void testCoroutineContext() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContext.kt");
            }

            @TestMetadata("coroutineContextReceiver.kt")
            public void testCoroutineContextReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiver.kt");
            }

            @TestMetadata("coroutineContextReceiverNotIntrinsic.kt")
            public void testCoroutineContextReceiverNotIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiverNotIntrinsic.kt");
            }

            @TestMetadata("intercepted.kt")
            public void testIntercepted() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/intercepted.kt");
            }

            @TestMetadata("resultExceptionOrNullInLambda.kt")
            public void testResultExceptionOrNullInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/resultExceptionOrNullInLambda.kt");
            }

            @TestMetadata("startCoroutine.kt")
            public void testStartCoroutine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutine.kt");
            }

            @TestMetadata("startCoroutineUninterceptedOrReturn.kt")
            public void testStartCoroutineUninterceptedOrReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturn.kt");
            }

            @TestMetadata("startCoroutineUninterceptedOrReturnInterception.kt")
            public void testStartCoroutineUninterceptedOrReturnInterception() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturnInterception.kt");
            }

            @TestMetadata("suspendCoroutineUninterceptedOrReturn.kt")
            public void testSuspendCoroutineUninterceptedOrReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/suspendCoroutineUninterceptedOrReturn.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/javaInterop")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaInterop extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInJavaInterop() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/javaInterop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("objectWithSeveralSuspends.kt")
            public void testObjectWithSeveralSuspends() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/objectWithSeveralSuspends.kt");
            }

            @TestMetadata("returnLambda.kt")
            public void testReturnLambda() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/returnLambda.kt");
            }

            @TestMetadata("returnObject.kt")
            public void testReturnObject() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/returnObject.kt");
            }

            @TestMetadata("severalCaptures.kt")
            public void testSeveralCaptures() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/severalCaptures.kt");
            }

            @TestMetadata("suspendInlineWithCrossinline.kt")
            public void testSuspendInlineWithCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/suspendInlineWithCrossinline.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalFunctions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/anonymous")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Anonymous extends AbstractLightAnalysisModeTest {
                @TestMetadata("simple.kt")
                public void ignoreSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/anonymous/simple.kt");
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInAnonymous() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/anonymous"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/named")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Named extends AbstractLightAnalysisModeTest {
                @TestMetadata("callTopLevelFromLocal.kt")
                public void ignoreCallTopLevelFromLocal() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/callTopLevelFromLocal.kt");
                }

                @TestMetadata("defaultArgument.kt")
                public void ignoreDefaultArgument() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/defaultArgument.kt");
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInNamed() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/named"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("capturedParameters.kt")
                public void testCapturedParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedParameters.kt");
                }

                @TestMetadata("capturedVariables.kt")
                public void testCapturedVariables() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedVariables.kt");
                }

                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/extension.kt");
                }

                @TestMetadata("infix.kt")
                public void testInfix() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/infix.kt");
                }

                @TestMetadata("insideLambda.kt")
                public void testInsideLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/insideLambda.kt");
                }

                @TestMetadata("nestedLocals.kt")
                public void testNestedLocals() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/nestedLocals.kt");
                }

                @TestMetadata("rec.kt")
                public void testRec() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/rec.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/simple.kt");
                }

                @TestMetadata("simpleSuspensionPoint.kt")
                public void testSimpleSuspensionPoint() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/simpleSuspensionPoint.kt");
                }

                @TestMetadata("stateMachine.kt")
                public void testStateMachine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/stateMachine.kt");
                }

                @TestMetadata("withArguments.kt")
                public void testWithArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/withArguments.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/multiModule")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiModule extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMultiModule() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("inlineCrossModule.kt")
            public void testInlineCrossModule() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineCrossModule.kt");
            }

            @TestMetadata("inlineFunctionWithOptionalParam.kt")
            public void testInlineFunctionWithOptionalParam() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineFunctionWithOptionalParam.kt");
            }

            @TestMetadata("inlineMultiModule.kt")
            public void testInlineMultiModule() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModule.kt");
            }

            @TestMetadata("inlineMultiModuleOverride.kt")
            public void testInlineMultiModuleOverride() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleOverride.kt");
            }

            @TestMetadata("inlineMultiModuleWithController.kt")
            public void testInlineMultiModuleWithController() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithController.kt");
            }

            @TestMetadata("inlineMultiModuleWithInnerInlining.kt")
            public void testInlineMultiModuleWithInnerInlining() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithInnerInlining.kt");
            }

            @TestMetadata("inlineTailCall.kt")
            public void testInlineTailCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineTailCall.kt");
            }

            @TestMetadata("inlineWithJava.kt")
            public void testInlineWithJava() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineWithJava.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/simple.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/redundantLocalsElimination")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RedundantLocalsElimination extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInRedundantLocalsElimination() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/redundantLocalsElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("ktor_receivedMessage.kt")
            public void testKtor_receivedMessage() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/redundantLocalsElimination/ktor_receivedMessage.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/reflect")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reflect extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInReflect() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/reflect"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("bigArity.kt")
            public void testBigArity() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/bigArity.kt");
            }

            @TestMetadata("callSuspend.kt")
            public void testCallSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/callSuspend.kt");
            }

            @TestMetadata("callSuspendBy.kt")
            public void testCallSuspendBy() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/callSuspendBy.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/stackUnwinding")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StackUnwinding extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInStackUnwinding() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/stackUnwinding"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("exception.kt")
            public void testException() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/exception.kt");
            }

            @TestMetadata("inlineSuspendFunction.kt")
            public void testInlineSuspendFunction() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/inlineSuspendFunction.kt");
            }

            @TestMetadata("rethrowInFinally.kt")
            public void testRethrowInFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinally.kt");
            }

            @TestMetadata("rethrowInFinallyWithSuspension.kt")
            public void testRethrowInFinallyWithSuspension() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinallyWithSuspension.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/simple.kt");
            }

            @TestMetadata("suspendInCycle.kt")
            public void testSuspendInCycle() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/suspendInCycle.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendConversion")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuspendConversion extends AbstractLightAnalysisModeTest {
            @TestMetadata("intersectionTypeToSubtypeConversion.kt")
            public void ignoreIntersectionTypeToSubtypeConversion() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/intersectionTypeToSubtypeConversion.kt");
            }

            @TestMetadata("onArgument.kt")
            public void ignoreOnArgument() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/onArgument.kt");
            }

            @TestMetadata("onInlineArgument.kt")
            public void ignoreOnInlineArgument() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/onInlineArgument.kt");
            }

            @TestMetadata("subtypeOfFunctionalTypeToSuspendConversion.kt")
            public void ignoreSubtypeOfFunctionalTypeToSuspendConversion() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/subtypeOfFunctionalTypeToSuspendConversion.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSuspendConversion() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendConversion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuspendFunctionAsCoroutine extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSuspendFunctionAsCoroutine() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("dispatchResume.kt")
            public void testDispatchResume() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/dispatchResume.kt");
            }

            @TestMetadata("handleException.kt")
            public void testHandleException() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/handleException.kt");
            }

            @TestMetadata("ifExpressionInsideCoroutine_1_3.kt")
            public void testIfExpressionInsideCoroutine_1_3() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/ifExpressionInsideCoroutine_1_3.kt");
            }

            @TestMetadata("inline.kt")
            public void testInline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inline.kt");
            }

            @TestMetadata("inlineTwoReceivers.kt")
            public void testInlineTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inlineTwoReceivers.kt");
            }

            @TestMetadata("member.kt")
            public void testMember() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/member.kt");
            }

            @TestMetadata("noinlineTwoReceivers.kt")
            public void testNoinlineTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/noinlineTwoReceivers.kt");
            }

            @TestMetadata("openFunWithJava.kt")
            public void testOpenFunWithJava() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/openFunWithJava.kt");
            }

            @TestMetadata("operators.kt")
            public void testOperators() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/operators.kt");
            }

            @TestMetadata("privateFunctions.kt")
            public void testPrivateFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateFunctions.kt");
            }

            @TestMetadata("privateInFile.kt")
            public void testPrivateInFile() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateInFile.kt");
            }

            @TestMetadata("returnNoSuspend.kt")
            public void testReturnNoSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/returnNoSuspend.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/simple.kt");
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCall.kt");
            }

            @TestMetadata("superCallAbstractClass.kt")
            public void testSuperCallAbstractClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallAbstractClass.kt");
            }

            @TestMetadata("superCallInterface.kt")
            public void testSuperCallInterface() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallInterface.kt");
            }

            @TestMetadata("superCallOverload.kt")
            public void testSuperCallOverload() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallOverload.kt");
            }

            @TestMetadata("withVariables.kt")
            public void testWithVariables() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/withVariables.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuspendFunctionTypeCall extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSuspendFunctionTypeCall() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/localVal.kt");
            }

            @TestMetadata("manyParameters.kt")
            public void testManyParameters() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParameters.kt");
            }

            @TestMetadata("manyParametersNoCapture.kt")
            public void testManyParametersNoCapture() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParametersNoCapture.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/simple.kt");
            }

            @TestMetadata("suspendModifier.kt")
            public void testSuspendModifier() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/suspendModifier.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TailCallOptimizations extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInTailCallOptimizations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("also.kt")
            public void testAlso() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/also.kt");
            }

            @TestMetadata("checkcast.kt")
            public void testCheckcast() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/checkcast.kt");
            }

            @TestMetadata("checkcast2.kt")
            public void testCheckcast2() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/checkcast2.kt");
            }

            @TestMetadata("crossinline.kt")
            public void testCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/crossinline.kt");
            }

            @TestMetadata("deferredAwaitSuspendImpl.kt")
            public void testDeferredAwaitSuspendImpl() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/deferredAwaitSuspendImpl.kt");
            }

            @TestMetadata("inlineWithStateMachine.kt")
            public void testInlineWithStateMachine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithStateMachine.kt");
            }

            @TestMetadata("inlineWithoutStateMachine.kt")
            public void testInlineWithoutStateMachine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithoutStateMachine.kt");
            }

            @TestMetadata("innerObjectRetransformation.kt")
            public void testInnerObjectRetransformation() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/innerObjectRetransformation.kt");
            }

            @TestMetadata("interfaceDelegation.kt")
            public void testInterfaceDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/interfaceDelegation.kt");
            }

            @TestMetadata("returnInlineClass.kt")
            public void testReturnInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/returnInlineClass.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/simple.kt");
            }

            @TestMetadata("tailCallIfReturnUnit.kt")
            public void testTailCallIfReturnUnit() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailCallIfReturnUnit.kt");
            }

            @TestMetadata("tailCallIntrinsics.kt")
            public void testTailCallIntrinsics() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailCallIntrinsics.kt");
            }

            @TestMetadata("tailSuspendUnitFun.kt")
            public void testTailSuspendUnitFun() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailSuspendUnitFun.kt");
            }

            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatch.kt");
            }

            @TestMetadata("tryCatchTailCall.kt")
            public void testTryCatchTailCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatchTailCall.kt");
            }

            @TestMetadata("unreachable.kt")
            public void testUnreachable() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unreachable.kt");
            }

            @TestMetadata("whenUnit.kt")
            public void testWhenUnit() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/whenUnit.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Unit extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInUnit() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("functionReference.kt")
                public void testFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/functionReference.kt");
                }

                @TestMetadata("inline.kt")
                public void testInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/inline.kt");
                }

                @TestMetadata("override.kt")
                public void testOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override.kt");
                }

                @TestMetadata("override2.kt")
                public void testOverride2() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override2.kt");
                }

                @TestMetadata("override3.kt")
                public void testOverride3() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override3.kt");
                }

                @TestMetadata("override4.kt")
                public void testOverride4() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override4.kt");
                }

                @TestMetadata("override5.kt")
                public void testOverride5() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override5.kt");
                }

                @TestMetadata("override6.kt")
                public void testOverride6() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override6.kt");
                }

                @TestMetadata("overrideCrossinline.kt")
                public void testOverrideCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/overrideCrossinline.kt");
                }

                @TestMetadata("overrideOverriden.kt")
                public void testOverrideOverriden() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/overrideOverriden.kt");
                }

                @TestMetadata("reflection.kt")
                public void testReflection() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/reflection.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/simple.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/tailOperations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TailOperations extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInTailOperations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("suspendWithIf.kt")
            public void testSuspendWithIf() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithIf.kt");
            }

            @TestMetadata("suspendWithTryCatch.kt")
            public void testSuspendWithTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithTryCatch.kt");
            }

            @TestMetadata("suspendWithWhen.kt")
            public void testSuspendWithWhen() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithWhen.kt");
            }

            @TestMetadata("tailInlining.kt")
            public void testTailInlining() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/tailInlining.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/unitTypeReturn")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnitTypeReturn extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInUnitTypeReturn() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/unitTypeReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("coroutineNonLocalReturn.kt")
            public void testCoroutineNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineNonLocalReturn.kt");
            }

            @TestMetadata("coroutineReturn.kt")
            public void testCoroutineReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineReturn.kt");
            }

            @TestMetadata("inlineUnitFunction.kt")
            public void testInlineUnitFunction() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/inlineUnitFunction.kt");
            }

            @TestMetadata("interfaceDelegation.kt")
            public void testInterfaceDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/interfaceDelegation.kt");
            }

            @TestMetadata("suspendNonLocalReturn.kt")
            public void testSuspendNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendNonLocalReturn.kt");
            }

            @TestMetadata("suspendReturn.kt")
            public void testSuspendReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendReturn.kt");
            }

            @TestMetadata("unitSafeCall.kt")
            public void testUnitSafeCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/unitSafeCall.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class VarSpilling extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInVarSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("fakeInlinerVariables.kt")
            public void testFakeInlinerVariables() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/fakeInlinerVariables.kt");
            }

            @TestMetadata("kt19475.kt")
            public void testKt19475() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt19475.kt");
            }

            @TestMetadata("kt38925.kt")
            public void testKt38925() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt38925.kt");
            }

            @TestMetadata("kt49834.kt")
            public void testKt49834() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt49834.kt");
            }

            @TestMetadata("lvtWithInlineOnly.kt")
            public void testLvtWithInlineOnly() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/lvtWithInlineOnly.kt");
            }

            @TestMetadata("nullSpilling.kt")
            public void testNullSpilling() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/nullSpilling.kt");
            }

            @TestMetadata("refinedIntTypesAnalysis.kt")
            public void testRefinedIntTypesAnalysis() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/refinedIntTypesAnalysis.kt");
            }

            @TestMetadata("safeCallElvis.kt")
            public void testSafeCallElvis() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/safeCallElvis.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/correctFrontendCode")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CorrectFrontendCode extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCorrectFrontendCode() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/correctFrontendCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("privateNestedClassInSuper.kt")
        public void testPrivateNestedClassInSuper() throws Exception {
            runTest("compiler/testData/codegen/box/correctFrontendCode/privateNestedClassInSuper.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/dataClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DataClasses extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDataClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("arrayParams.kt")
        public void testArrayParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/arrayParams.kt");
        }

        @TestMetadata("changingVarParam.kt")
        public void testChangingVarParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/changingVarParam.kt");
        }

        @TestMetadata("dataClassWithManyFields.kt")
        public void testDataClassWithManyFields() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/dataClassWithManyFields.kt");
        }

        @TestMetadata("doubleParam.kt")
        public void testDoubleParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/doubleParam.kt");
        }

        @TestMetadata("floatParam.kt")
        public void testFloatParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/floatParam.kt");
        }

        @TestMetadata("genericParam.kt")
        public void testGenericParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/genericParam.kt");
        }

        @TestMetadata("kt49715.kt")
        public void testKt49715() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt49715.kt");
        }

        @TestMetadata("kt49715_behaviorChange.kt")
        public void testKt49715_behaviorChange() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt49715_behaviorChange.kt");
        }

        @TestMetadata("kt5002.kt")
        public void testKt5002() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt5002.kt");
        }

        @TestMetadata("mixedParams.kt")
        public void testMixedParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/mixedParams.kt");
        }

        @TestMetadata("multiDeclaration.kt")
        public void testMultiDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/multiDeclaration.kt");
        }

        @TestMetadata("multiDeclarationFor.kt")
        public void testMultiDeclarationFor() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/multiDeclarationFor.kt");
        }

        @TestMetadata("nonTrivialFinalMemberInSuperClass.kt")
        public void testNonTrivialFinalMemberInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/nonTrivialFinalMemberInSuperClass.kt");
        }

        @TestMetadata("nonTrivialMemberInSuperClass.kt")
        public void testNonTrivialMemberInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/nonTrivialMemberInSuperClass.kt");
        }

        @TestMetadata("privateValParams.kt")
        public void testPrivateValParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/privateValParams.kt");
        }

        @TestMetadata("twoValParams.kt")
        public void testTwoValParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/twoValParams.kt");
        }

        @TestMetadata("twoVarParams.kt")
        public void testTwoVarParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/twoVarParams.kt");
        }

        @TestMetadata("typeParameterWithNonTrivialBound.kt")
        public void testTypeParameterWithNonTrivialBound() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/typeParameterWithNonTrivialBound.kt");
        }

        @TestMetadata("unitComponent.kt")
        public void testUnitComponent() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/unitComponent.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/components")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Components extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInComponents() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/components"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("kt49812.kt")
            public void testKt49812() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/components/kt49812.kt");
            }

            @TestMetadata("kt49936.kt")
            public void testKt49936() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/components/kt49936.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/copy")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Copy extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCopy() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/copy"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("constructorWithDefaultParam.kt")
            public void testConstructorWithDefaultParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/constructorWithDefaultParam.kt");
            }

            @TestMetadata("copyInObjectNestedDataClass.kt")
            public void testCopyInObjectNestedDataClass() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/copyInObjectNestedDataClass.kt");
            }

            @TestMetadata("kt12708.kt")
            public void testKt12708() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/kt12708.kt");
            }

            @TestMetadata("kt3033.kt")
            public void testKt3033() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/kt3033.kt");
            }

            @TestMetadata("valInConstructorParams.kt")
            public void testValInConstructorParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/valInConstructorParams.kt");
            }

            @TestMetadata("varInConstructorParams.kt")
            public void testVarInConstructorParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/varInConstructorParams.kt");
            }

            @TestMetadata("withGenericParameter.kt")
            public void testWithGenericParameter() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/withGenericParameter.kt");
            }

            @TestMetadata("withSecondaryConstructor.kt")
            public void testWithSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/withSecondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/equals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equals extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInEquals() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/equals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclared.kt");
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclaredWrongSignature.kt");
            }

            @TestMetadata("genericarray.kt")
            public void testGenericarray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/genericarray.kt");
            }

            @TestMetadata("intarray.kt")
            public void testIntarray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/intarray.kt");
            }

            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/null.kt");
            }

            @TestMetadata("nullother.kt")
            public void testNullother() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/nullother.kt");
            }

            @TestMetadata("sameinstance.kt")
            public void testSameinstance() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/sameinstance.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/hashCode")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class HashCode extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInHashCode() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclared.kt");
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclaredWrongSignature.kt");
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/array.kt");
            }

            @TestMetadata("boolean.kt")
            public void testBoolean() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/boolean.kt");
            }

            @TestMetadata("byte.kt")
            public void testByte() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/byte.kt");
            }

            @TestMetadata("char.kt")
            public void testChar() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/char.kt");
            }

            @TestMetadata("double.kt")
            public void testDouble() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/double.kt");
            }

            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/float.kt");
            }

            @TestMetadata("genericNull.kt")
            public void testGenericNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/genericNull.kt");
            }

            @TestMetadata("int.kt")
            public void testInt() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/int.kt");
            }

            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/long.kt");
            }

            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/null.kt");
            }

            @TestMetadata("short.kt")
            public void testShort() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/short.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/toString")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ToString extends AbstractLightAnalysisModeTest {
            @TestMetadata("primitiveArrays.kt")
            public void ignorePrimitiveArrays() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/primitiveArrays.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInToString() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/toString"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclared.kt");
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclaredWrongSignature.kt");
            }

            @TestMetadata("arrayParams.kt")
            public void testArrayParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/arrayParams.kt");
            }

            @TestMetadata("changingVarParam.kt")
            public void testChangingVarParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/changingVarParam.kt");
            }

            @TestMetadata("genericParam.kt")
            public void testGenericParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/genericParam.kt");
            }

            @TestMetadata("mixedParams.kt")
            public void testMixedParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/mixedParams.kt");
            }

            @TestMetadata("unitComponent.kt")
            public void testUnitComponent() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/unitComponent.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeadCodeElimination extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDeadCodeElimination() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("emptyVariableRange.kt")
        public void testEmptyVariableRange() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/emptyVariableRange.kt");
        }

        @TestMetadata("intersectingVariableRange.kt")
        public void testIntersectingVariableRange() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRange.kt");
        }

        @TestMetadata("intersectingVariableRangeInFinally.kt")
        public void testIntersectingVariableRangeInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRangeInFinally.kt");
        }

        @TestMetadata("kt14357.kt")
        public void testKt14357() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/kt14357.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DefaultArguments extends AbstractLightAnalysisModeTest {
        @TestMetadata("useNextParamInLambdaTailrec.kt")
        public void ignoreUseNextParamInLambdaTailrec() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useNextParamInLambdaTailrec.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("callDefaultFromInitializer.kt")
        public void testCallDefaultFromInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/callDefaultFromInitializer.kt");
        }

        @TestMetadata("captureInTailrec.kt")
        public void testCaptureInTailrec() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/captureInTailrec.kt");
        }

        @TestMetadata("complexInheritance.kt")
        public void testComplexInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/complexInheritance.kt");
        }

        @TestMetadata("implementedByFake.kt")
        public void testImplementedByFake() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake.kt");
        }

        @TestMetadata("implementedByFake2.kt")
        public void testImplementedByFake2() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake2.kt");
        }

        @TestMetadata("implementedByFake3.kt")
        public void testImplementedByFake3() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake3.kt");
        }

        @TestMetadata("inheritedFromInterfaceViaAbstractSuperclass.kt")
        public void testInheritedFromInterfaceViaAbstractSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/inheritedFromInterfaceViaAbstractSuperclass.kt");
        }

        @TestMetadata("kt36853.kt")
        public void testKt36853() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853.kt");
        }

        @TestMetadata("kt36853_fibonacci.kt")
        public void testKt36853_fibonacci() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853_fibonacci.kt");
        }

        @TestMetadata("kt36853_nestedObject.kt")
        public void testKt36853_nestedObject() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853_nestedObject.kt");
        }

        @TestMetadata("kt36853a.kt")
        public void testKt36853a() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853a.kt");
        }

        @TestMetadata("kt36972_companion.kt")
        public void testKt36972_companion() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36972_companion.kt");
        }

        @TestMetadata("kt36972_object.kt")
        public void testKt36972_object() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36972_object.kt");
        }

        @TestMetadata("kt46189.kt")
        public void testKt46189() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt46189.kt");
        }

        @TestMetadata("kt47073.kt")
        public void testKt47073() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt47073.kt");
        }

        @TestMetadata("kt47073_nested.kt")
        public void testKt47073_nested() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt47073_nested.kt");
        }

        @TestMetadata("kt48391.kt")
        public void testKt48391() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt48391.kt");
        }

        @TestMetadata("kt6382.kt")
        public void testKt6382() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt6382.kt");
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/protected.kt");
        }

        @TestMetadata("recursiveDefaultArguments.kt")
        public void testRecursiveDefaultArguments() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/recursiveDefaultArguments.kt");
        }

        @TestMetadata("referenceAsArg.kt")
        public void testReferenceAsArg() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/referenceAsArg.kt");
        }

        @TestMetadata("simpleFromOtherFile.kt")
        public void testSimpleFromOtherFile() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/simpleFromOtherFile.kt");
        }

        @TestMetadata("superCallCheck.kt")
        public void testSuperCallCheck() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/superCallCheck.kt");
        }

        @TestMetadata("superCallHandlerOrder.kt")
        public void testSuperCallHandlerOrder() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/superCallHandlerOrder.kt");
        }

        @TestMetadata("useNextParamInLambda.kt")
        public void testUseNextParamInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useNextParamInLambda.kt");
        }

        @TestMetadata("useThisInLambda.kt")
        public void testUseThisInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useThisInLambda.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/constructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructor extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInConstructor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/constructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("annotation.kt")
            public void testAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotation.kt");
            }

            @TestMetadata("annotationWithEmptyArray.kt")
            public void testAnnotationWithEmptyArray() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotationWithEmptyArray.kt");
            }

            @TestMetadata("checkIfConstructorIsSynthetic.kt")
            public void testCheckIfConstructorIsSynthetic() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/checkIfConstructorIsSynthetic.kt");
            }

            @TestMetadata("defArgs1.kt")
            public void testDefArgs1() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1.kt");
            }

            @TestMetadata("defArgs1InnerClass.kt")
            public void testDefArgs1InnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1InnerClass.kt");
            }

            @TestMetadata("defArgs2.kt")
            public void testDefArgs2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs2.kt");
            }

            @TestMetadata("doubleDefArgs1InnerClass.kt")
            public void testDoubleDefArgs1InnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/doubleDefArgs1InnerClass.kt");
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enum.kt");
            }

            @TestMetadata("enumWithOneDefArg.kt")
            public void testEnumWithOneDefArg() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithOneDefArg.kt");
            }

            @TestMetadata("enumWithTwoDefArgs.kt")
            public void testEnumWithTwoDefArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDefArgs.kt");
            }

            @TestMetadata("enumWithTwoDoubleDefArgs.kt")
            public void testEnumWithTwoDoubleDefArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDoubleDefArgs.kt");
            }

            @TestMetadata("innerClass32Args.kt")
            public void testInnerClass32Args() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/innerClass32Args.kt");
            }

            @TestMetadata("kt2852.kt")
            public void testKt2852() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt2852.kt");
            }

            @TestMetadata("kt30517.kt")
            public void testKt30517() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt30517.kt");
            }

            @TestMetadata("kt3060.kt")
            public void testKt3060() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt3060.kt");
            }

            @TestMetadata("manyArgs.kt")
            public void testManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/manyArgs.kt");
            }

            @TestMetadata("objectExpressionDelegatingToSecondaryConstructor.kt")
            public void testObjectExpressionDelegatingToSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/objectExpressionDelegatingToSecondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/convention")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Convention extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInConvention() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/convention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("incWithDefaultInGetter.kt")
            public void testIncWithDefaultInGetter() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaultInGetter.kt");
            }

            @TestMetadata("incWithDefaults.kt")
            public void testIncWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaults.kt");
            }

            @TestMetadata("kt16520.kt")
            public void testKt16520() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt16520.kt");
            }

            @TestMetadata("kt16520_old.kt")
            public void testKt16520_old() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt16520_old.kt");
            }

            @TestMetadata("kt9140.kt")
            public void testKt9140() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt9140.kt");
            }

            @TestMetadata("plusAssignWithDefaultInGetter.kt")
            public void testPlusAssignWithDefaultInGetter() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaultInGetter.kt");
            }

            @TestMetadata("plusAssignWithDefaults.kt")
            public void testPlusAssignWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaults.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractClass.kt")
            public void testAbstractClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/abstractClass.kt");
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("complexInheritance.kt")
            public void testComplexInheritance() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/complexInheritance.kt");
            }

            @TestMetadata("covariantOverride.kt")
            public void testCovariantOverride() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverride.kt");
            }

            @TestMetadata("covariantOverrideGeneric.kt")
            public void testCovariantOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverrideGeneric.kt");
            }

            @TestMetadata("defaultLambdaInline.kt")
            public void testDefaultLambdaInline() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/defaultLambdaInline.kt");
            }

            @TestMetadata("extensionFunctionManyArgs.kt")
            public void testExtensionFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extensionFunctionManyArgs.kt");
            }

            @TestMetadata("extentionFunction.kt")
            public void testExtentionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunction.kt");
            }

            @TestMetadata("extentionFunctionDouble.kt")
            public void testExtentionFunctionDouble() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDouble.kt");
            }

            @TestMetadata("extentionFunctionDoubleTwoArgs.kt")
            public void testExtentionFunctionDoubleTwoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDoubleTwoArgs.kt");
            }

            @TestMetadata("extentionFunctionInClassObject.kt")
            public void testExtentionFunctionInClassObject() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInClassObject.kt");
            }

            @TestMetadata("extentionFunctionInObject.kt")
            public void testExtentionFunctionInObject() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInObject.kt");
            }

            @TestMetadata("extentionFunctionWithOneDefArg.kt")
            public void testExtentionFunctionWithOneDefArg() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionWithOneDefArg.kt");
            }

            @TestMetadata("funInTrait.kt")
            public void testFunInTrait() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/funInTrait.kt");
            }

            @TestMetadata("funInTraitChain.kt")
            public void testFunInTraitChain() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/funInTraitChain.kt");
            }

            @TestMetadata("innerExtentionFunction.kt")
            public void testInnerExtentionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunction.kt");
            }

            @TestMetadata("innerExtentionFunctionDouble.kt")
            public void testInnerExtentionFunctionDouble() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDouble.kt");
            }

            @TestMetadata("innerExtentionFunctionDoubleTwoArgs.kt")
            public void testInnerExtentionFunctionDoubleTwoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDoubleTwoArgs.kt");
            }

            @TestMetadata("innerExtentionFunctionManyArgs.kt")
            public void testInnerExtentionFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionManyArgs.kt");
            }

            @TestMetadata("kt15971.kt")
            public void testKt15971() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971.kt");
            }

            @TestMetadata("kt15971_2.kt")
            public void testKt15971_2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971_2.kt");
            }

            @TestMetadata("kt15971_3.kt")
            public void testKt15971_3() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971_3.kt");
            }

            @TestMetadata("kt36188.kt")
            public void testKt36188() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt36188.kt");
            }

            @TestMetadata("kt36188_2.kt")
            public void testKt36188_2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt36188_2.kt");
            }

            @TestMetadata("kt5232.kt")
            public void testKt5232() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt5232.kt");
            }

            @TestMetadata("memberFunctionManyArgs.kt")
            public void testMemberFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/memberFunctionManyArgs.kt");
            }

            @TestMetadata("mixingNamedAndPositioned.kt")
            public void testMixingNamedAndPositioned() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/mixingNamedAndPositioned.kt");
            }

            @TestMetadata("topLevelManyArgs.kt")
            public void testTopLevelManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/topLevelManyArgs.kt");
            }

            @TestMetadata("trait.kt")
            public void testTrait() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/trait.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/private")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Private extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInPrivate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("memberExtensionFunction.kt")
            public void testMemberExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/memberExtensionFunction.kt");
            }

            @TestMetadata("memberFunction.kt")
            public void testMemberFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/memberFunction.kt");
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/primaryConstructor.kt");
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/secondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/signature")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Signature extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSignature() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("kt2789.kt")
            public void testKt2789() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt2789.kt");
            }

            @TestMetadata("kt9428.kt")
            public void testKt9428() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9428.kt");
            }

            @TestMetadata("kt9924.kt")
            public void testKt9924() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9924.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DelegatedProperty extends AbstractLightAnalysisModeTest {
        @TestMetadata("delegatedPropertyInEnum.kt")
        public void ignoreDelegatedPropertyInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegatedPropertyInEnum.kt");
        }

        @TestMetadata("genericDelegateUncheckedCast2.kt")
        public void ignoreGenericDelegateUncheckedCast2() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast2.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("accessTopLevelDelegatedPropertyInClinit.kt")
        public void testAccessTopLevelDelegatedPropertyInClinit() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/accessTopLevelDelegatedPropertyInClinit.kt");
        }

        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("beforeDeclarationContainerOptimization.kt")
        public void testBeforeDeclarationContainerOptimization() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/beforeDeclarationContainerOptimization.kt");
        }

        @TestMetadata("capturePropertyInClosure.kt")
        public void testCapturePropertyInClosure() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/capturePropertyInClosure.kt");
        }

        @TestMetadata("castGetReturnType.kt")
        public void testCastGetReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/castGetReturnType.kt");
        }

        @TestMetadata("castSetParameter.kt")
        public void testCastSetParameter() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/castSetParameter.kt");
        }

        @TestMetadata("delegateAsInnerClass.kt")
        public void testDelegateAsInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateAsInnerClass.kt");
        }

        @TestMetadata("delegateByOtherProperty.kt")
        public void testDelegateByOtherProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByOtherProperty.kt");
        }

        @TestMetadata("delegateByTopLevelFun.kt")
        public void testDelegateByTopLevelFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelFun.kt");
        }

        @TestMetadata("delegateByTopLevelProperty.kt")
        public void testDelegateByTopLevelProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelProperty.kt");
        }

        @TestMetadata("delegateForExtProperty.kt")
        public void testDelegateForExtProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtProperty.kt");
        }

        @TestMetadata("delegateForExtPropertyInClass.kt")
        public void testDelegateForExtPropertyInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtPropertyInClass.kt");
        }

        @TestMetadata("delegateToConstructorParameter.kt")
        public void testDelegateToConstructorParameter() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateToConstructorParameter.kt");
        }

        @TestMetadata("delegateWithPrivateSet.kt")
        public void testDelegateWithPrivateSet() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateWithPrivateSet.kt");
        }

        @TestMetadata("extensionDelegatesWithSameNames.kt")
        public void testExtensionDelegatesWithSameNames() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/extensionDelegatesWithSameNames.kt");
        }

        @TestMetadata("extensionPropertyAndExtensionGetValue.kt")
        public void testExtensionPropertyAndExtensionGetValue() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/extensionPropertyAndExtensionGetValue.kt");
        }

        @TestMetadata("functionRefDelefate.kt")
        public void testFunctionRefDelefate() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/functionRefDelefate.kt");
        }

        @TestMetadata("genericDelegate.kt")
        public void testGenericDelegate() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegate.kt");
        }

        @TestMetadata("genericDelegateUncheckedCast1.kt")
        public void testGenericDelegateUncheckedCast1() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast1.kt");
        }

        @TestMetadata("genericSetValueViaSyntheticAccessor.kt")
        public void testGenericSetValueViaSyntheticAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericSetValueViaSyntheticAccessor.kt");
        }

        @TestMetadata("getAsExtensionFun.kt")
        public void testGetAsExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFun.kt");
        }

        @TestMetadata("getAsExtensionFunInClass.kt")
        public void testGetAsExtensionFunInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFunInClass.kt");
        }

        @TestMetadata("getDelegateWithoutReflection.kt")
        public void testGetDelegateWithoutReflection() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getDelegateWithoutReflection.kt");
        }

        @TestMetadata("inClassVal.kt")
        public void testInClassVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inClassVal.kt");
        }

        @TestMetadata("inClassVar.kt")
        public void testInClassVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inClassVar.kt");
        }

        @TestMetadata("inTrait.kt")
        public void testInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inTrait.kt");
        }

        @TestMetadata("inferredPropertyType.kt")
        public void testInferredPropertyType() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inferredPropertyType.kt");
        }

        @TestMetadata("insideInlinedObjectMultiModule.kt")
        public void testInsideInlinedObjectMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/insideInlinedObjectMultiModule.kt");
        }

        @TestMetadata("javaDelegateTopLevel.kt")
        public void testJavaDelegateTopLevel() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/javaDelegateTopLevel.kt");
        }

        @TestMetadata("kt35707.kt")
        public void testKt35707() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt35707.kt");
        }

        @TestMetadata("kt37204.kt")
        public void testKt37204() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt37204.kt");
        }

        @TestMetadata("kt4138.kt")
        public void testKt4138() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt4138.kt");
        }

        @TestMetadata("kt45431.kt")
        public void testKt45431() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt45431.kt");
        }

        @TestMetadata("kt6722.kt")
        public void testKt6722() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt6722.kt");
        }

        @TestMetadata("kt9712.kt")
        public void testKt9712() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt9712.kt");
        }

        @TestMetadata("privateInSubClass.kt")
        public void testPrivateInSubClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateInSubClass.kt");
        }

        @TestMetadata("privateSetterKPropertyIsNotMutable.kt")
        public void testPrivateSetterKPropertyIsNotMutable() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateSetterKPropertyIsNotMutable.kt");
        }

        @TestMetadata("privateVar.kt")
        public void testPrivateVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateVar.kt");
        }

        @TestMetadata("propertyMetadataShouldBeCached.kt")
        public void testPropertyMetadataShouldBeCached() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/propertyMetadataShouldBeCached.kt");
        }

        @TestMetadata("protectedVarWithPrivateSet.kt")
        public void testProtectedVarWithPrivateSet() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/protectedVarWithPrivateSet.kt");
        }

        @TestMetadata("referenceEnclosingClassFieldInReceiver.kt")
        public void testReferenceEnclosingClassFieldInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/referenceEnclosingClassFieldInReceiver.kt");
        }

        @TestMetadata("referenceEnclosingClassFieldInReceiver2.kt")
        public void testReferenceEnclosingClassFieldInReceiver2() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/referenceEnclosingClassFieldInReceiver2.kt");
        }

        @TestMetadata("setAsExtensionFun.kt")
        public void testSetAsExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFun.kt");
        }

        @TestMetadata("setAsExtensionFunInClass.kt")
        public void testSetAsExtensionFunInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFunInClass.kt");
        }

        @TestMetadata("stackOverflowOnCallFromGetValue.kt")
        public void testStackOverflowOnCallFromGetValue() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/stackOverflowOnCallFromGetValue.kt");
        }

        @TestMetadata("topLevelVal.kt")
        public void testTopLevelVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVal.kt");
        }

        @TestMetadata("topLevelVar.kt")
        public void testTopLevelVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVar.kt");
        }

        @TestMetadata("twoPropByOneDelegete.kt")
        public void testTwoPropByOneDelegete() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/twoPropByOneDelegete.kt");
        }

        @TestMetadata("useKPropertyLater.kt")
        public void testUseKPropertyLater() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/useKPropertyLater.kt");
        }

        @TestMetadata("useReflectionOnKProperty.kt")
        public void testUseReflectionOnKProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/useReflectionOnKProperty.kt");
        }

        @TestMetadata("valByMapDelegatedProperty.kt")
        public void testValByMapDelegatedProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/valByMapDelegatedProperty.kt");
        }

        @TestMetadata("valInInnerClass.kt")
        public void testValInInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/valInInnerClass.kt");
        }

        @TestMetadata("varInInnerClass.kt")
        public void testVarInInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/varInInnerClass.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/delegateToAnother")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DelegateToAnother extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDelegateToAnother() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/delegateToAnother"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("custom.kt")
            public void testCustom() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/custom.kt");
            }

            @TestMetadata("genericJavaProperty.kt")
            public void testGenericJavaProperty() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/genericJavaProperty.kt");
            }

            @TestMetadata("kt49793_companionObject.kt")
            public void testKt49793_companionObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_companionObject.kt");
            }

            @TestMetadata("kt49793_interfaceCompanionObject.kt")
            public void testKt49793_interfaceCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_interfaceCompanionObject.kt");
            }

            @TestMetadata("kt49793_object.kt")
            public void testKt49793_object() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_object.kt");
            }

            @TestMetadata("kt50019_noOptimizedCallableReferences.kt")
            public void testKt50019_noOptimizedCallableReferences() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt50019_noOptimizedCallableReferences.kt");
            }

            @TestMetadata("mutable.kt")
            public void testMutable() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/mutable.kt");
            }

            @TestMetadata("openProperty.kt")
            public void testOpenProperty() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/openProperty.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/simple.kt");
            }

            @TestMetadata("withSideEffects.kt")
            public void testWithSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/withSideEffects.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/local")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Local extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLocal() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("capturedLocalVal.kt")
            public void testCapturedLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVal.kt");
            }

            @TestMetadata("capturedLocalValNoInline.kt")
            public void testCapturedLocalValNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalValNoInline.kt");
            }

            @TestMetadata("capturedLocalVar.kt")
            public void testCapturedLocalVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVar.kt");
            }

            @TestMetadata("capturedLocalVarNoInline.kt")
            public void testCapturedLocalVarNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVarNoInline.kt");
            }

            @TestMetadata("inlineGetValue.kt")
            public void testInlineGetValue() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineGetValue.kt");
            }

            @TestMetadata("inlineOperators.kt")
            public void testInlineOperators() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineOperators.kt");
            }

            @TestMetadata("kt12891.kt")
            public void testKt12891() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt12891.kt");
            }

            @TestMetadata("kt13557.kt")
            public void testKt13557() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt13557.kt");
            }

            @TestMetadata("kt16864.kt")
            public void testKt16864() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt16864.kt");
            }

            @TestMetadata("kt19690.kt")
            public void testKt19690() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt19690.kt");
            }

            @TestMetadata("kt21085.kt")
            public void testKt21085() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt21085.kt");
            }

            @TestMetadata("kt23117.kt")
            public void testKt23117() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt23117.kt");
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVal.kt");
            }

            @TestMetadata("localValNoExplicitType.kt")
            public void testLocalValNoExplicitType() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localValNoExplicitType.kt");
            }

            @TestMetadata("localVar.kt")
            public void testLocalVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVar.kt");
            }

            @TestMetadata("localVarNoExplicitType.kt")
            public void testLocalVarNoExplicitType() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVarNoExplicitType.kt");
            }

            @TestMetadata("useReflectionForLocalVarInLambda.kt")
            public void testUseReflectionForLocalVarInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/useReflectionForLocalVarInLambda.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OptimizedDelegatedProperties extends AbstractLightAnalysisModeTest {
            @TestMetadata("kt48825.kt")
            public void ignoreKt48825() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt48825.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInOptimizedDelegatedProperties() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("definedInSources.kt")
            public void testDefinedInSources() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/definedInSources.kt");
            }

            @TestMetadata("definedInSourcesWithNonNullParameter.kt")
            public void testDefinedInSourcesWithNonNullParameter() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/definedInSourcesWithNonNullParameter.kt");
            }

            @TestMetadata("inSeparateModule.kt")
            public void testInSeparateModule() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/inSeparateModule.kt");
            }

            @TestMetadata("inSeparateModuleWithNonNullParameter.kt")
            public void testInSeparateModuleWithNonNullParameter() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/inSeparateModuleWithNonNullParameter.kt");
            }

            @TestMetadata("kt40815.kt")
            public void testKt40815() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815.kt");
            }

            @TestMetadata("kt40815_2.kt")
            public void testKt40815_2() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815_2.kt");
            }

            @TestMetadata("kt40815_3.kt")
            public void testKt40815_3() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815_3.kt");
            }

            @TestMetadata("kt42253.kt")
            public void testKt42253() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt42253.kt");
            }

            @TestMetadata("lazy.kt")
            public void testLazy() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/lazy.kt");
            }

            @TestMetadata("mixedArgumentSizes.kt")
            public void testMixedArgumentSizes() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/mixedArgumentSizes.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/provideDelegate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProvideDelegate extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInProvideDelegate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("delegatedPropertyWithIdProvideDelegate.kt")
            public void testDelegatedPropertyWithIdProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/delegatedPropertyWithIdProvideDelegate.kt");
            }

            @TestMetadata("differentReceivers.kt")
            public void testDifferentReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/differentReceivers.kt");
            }

            @TestMetadata("evaluationOrder.kt")
            public void testEvaluationOrder() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrder.kt");
            }

            @TestMetadata("evaluationOrderVar.kt")
            public void testEvaluationOrderVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrderVar.kt");
            }

            @TestMetadata("extensionDelegated.kt")
            public void testExtensionDelegated() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/extensionDelegated.kt");
            }

            @TestMetadata("generic.kt")
            public void testGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/generic.kt");
            }

            @TestMetadata("genericDelegateWithNoAdditionalInfo.kt")
            public void testGenericDelegateWithNoAdditionalInfo() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/genericDelegateWithNoAdditionalInfo.kt");
            }

            @TestMetadata("genericProvideDelegateOnNumberLiteral.kt")
            public void testGenericProvideDelegateOnNumberLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/genericProvideDelegateOnNumberLiteral.kt");
            }

            @TestMetadata("hostCheck.kt")
            public void testHostCheck() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/hostCheck.kt");
            }

            @TestMetadata("inClass.kt")
            public void testInClass() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inClass.kt");
            }

            @TestMetadata("inlineProvideDelegate.kt")
            public void testInlineProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inlineProvideDelegate.kt");
            }

            @TestMetadata("jvmStaticInObject.kt")
            public void testJvmStaticInObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/jvmStaticInObject.kt");
            }

            @TestMetadata("kt15437.kt")
            public void testKt15437() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt15437.kt");
            }

            @TestMetadata("kt16441.kt")
            public void testKt16441() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt16441.kt");
            }

            @TestMetadata("kt18902.kt")
            public void testKt18902() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt18902.kt");
            }

            @TestMetadata("kt39588.kt")
            public void testKt39588() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt39588.kt");
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/local.kt");
            }

            @TestMetadata("localCaptured.kt")
            public void testLocalCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localCaptured.kt");
            }

            @TestMetadata("localDifferentReceivers.kt")
            public void testLocalDifferentReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localDifferentReceivers.kt");
            }

            @TestMetadata("memberExtension.kt")
            public void testMemberExtension() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/memberExtension.kt");
            }

            @TestMetadata("propertyMetadata.kt")
            public void testPropertyMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/propertyMetadata.kt");
            }

            @TestMetadata("provideDelegateByExtensionFunction.kt")
            public void testProvideDelegateByExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/provideDelegateByExtensionFunction.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/delegation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Delegation extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt30102_comparable.kt")
        public void ignoreKt30102_comparable() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/kt30102_comparable.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDelegation() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("byMiddleInterface.kt")
        public void testByMiddleInterface() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/byMiddleInterface.kt");
        }

        @TestMetadata("defaultOverride.kt")
        public void testDefaultOverride() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/defaultOverride.kt");
        }

        @TestMetadata("delegationAndInheritanceFromJava.kt")
        public void testDelegationAndInheritanceFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationAndInheritanceFromJava.kt");
        }

        @TestMetadata("delegationDifferentModule.kt")
        public void testDelegationDifferentModule() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationDifferentModule.kt");
        }

        @TestMetadata("delegationToMap.kt")
        public void testDelegationToMap() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationToMap.kt");
        }

        @TestMetadata("delegationToVal.kt")
        public void testDelegationToVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationToVal.kt");
        }

        @TestMetadata("delegationWithPrivateConstructor.kt")
        public void testDelegationWithPrivateConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationWithPrivateConstructor.kt");
        }

        @TestMetadata("diamond.kt")
        public void testDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/diamond.kt");
        }

        @TestMetadata("diamond2.kt")
        public void testDiamond2() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/diamond2.kt");
        }

        @TestMetadata("differentModules.kt")
        public void testDifferentModules() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/differentModules.kt");
        }

        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/genericProperty.kt");
        }

        @TestMetadata("hiddenSuperOverrideIn1.0.kt")
        public void testHiddenSuperOverrideIn1_0() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/hiddenSuperOverrideIn1.0.kt");
        }

        @TestMetadata("inClassDeclaration.kt")
        public void testInClassDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/inClassDeclaration.kt");
        }

        @TestMetadata("inDataClass.kt")
        public void testInDataClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/inDataClass.kt");
        }

        @TestMetadata("kt8154.kt")
        public void testKt8154() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/kt8154.kt");
        }

        @TestMetadata("mixed.kt")
        public void testMixed() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/mixed.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/simple.kt");
        }

        @TestMetadata("viaTypeAlias.kt")
        public void testViaTypeAlias() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/viaTypeAlias.kt");
        }

        @TestMetadata("withDefaultParameters.kt")
        public void testWithDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/withDefaultParameters.kt");
        }

        @TestMetadata("withDefaultsMultipleFilesOrder.kt")
        public void testWithDefaultsMultipleFilesOrder() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/withDefaultsMultipleFilesOrder.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/deprecated")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Deprecated extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDeprecated() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("deprecatedSinceKotlin.kt")
        public void testDeprecatedSinceKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/deprecated/deprecatedSinceKotlin.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DestructuringDeclInLambdaParam extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDestructuringDeclInLambdaParam() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/destructuringDeclInLambdaParam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("extensionComponents.kt")
        public void testExtensionComponents() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/extensionComponents.kt");
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/generic.kt");
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/inline.kt");
        }

        @TestMetadata("otherParameters.kt")
        public void testOtherParameters() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/otherParameters.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/simple.kt");
        }

        @TestMetadata("stdlibUsages.kt")
        public void testStdlibUsages() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/stdlibUsages.kt");
        }

        @TestMetadata("underscoreNames.kt")
        public void testUnderscoreNames() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/underscoreNames.kt");
        }

        @TestMetadata("withIndexed.kt")
        public void testWithIndexed() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/withIndexed.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/diagnostics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Diagnostics extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDiagnostics() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/diagnostics/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/inference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inference extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/inference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("kt6176.kt")
                public void testKt6176() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/inference/kt6176.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invoke extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInvoke() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnObjects extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInOnObjects() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                    }

                    @TestMetadata("invokeOnClassObject1.kt")
                    public void testInvokeOnClassObject1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject1.kt");
                    }

                    @TestMetadata("invokeOnClassObject2.kt")
                    public void testInvokeOnClassObject2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject2.kt");
                    }

                    @TestMetadata("invokeOnClassObjectOfNestedClass1.kt")
                    public void testInvokeOnClassObjectOfNestedClass1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass1.kt");
                    }

                    @TestMetadata("invokeOnClassObjectOfNestedClass2.kt")
                    public void testInvokeOnClassObjectOfNestedClass2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass2.kt");
                    }

                    @TestMetadata("invokeOnEnum1.kt")
                    public void testInvokeOnEnum1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum1.kt");
                    }

                    @TestMetadata("invokeOnEnum2.kt")
                    public void testInvokeOnEnum2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum2.kt");
                    }

                    @TestMetadata("invokeOnImportedEnum1.kt")
                    public void testInvokeOnImportedEnum1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum1.kt");
                    }

                    @TestMetadata("invokeOnImportedEnum2.kt")
                    public void testInvokeOnImportedEnum2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum2.kt");
                    }

                    @TestMetadata("invokeOnObject1.kt")
                    public void testInvokeOnObject1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject1.kt");
                    }

                    @TestMetadata("invokeOnObject2.kt")
                    public void testInvokeOnObject2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject2.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TailRecursion extends AbstractLightAnalysisModeTest {
                @TestMetadata("recursiveCallInInlineLambda.kt")
                public void ignoreRecursiveCallInInlineLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInInlineLambda.kt");
                }

                @TestMetadata("recursiveCallInInlineLambdaWithCapture.kt")
                public void ignoreRecursiveCallInInlineLambdaWithCapture() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInInlineLambdaWithCapture.kt");
                }

                @TestMetadata("tailrecWithExplicitCompanionObjectDispatcher.kt")
                public void ignoreTailrecWithExplicitCompanionObjectDispatcher() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailrecWithExplicitCompanionObjectDispatcher.kt");
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInTailRecursion() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/tailRecursion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs.kt");
                }

                @TestMetadata("defaultArgs2.kt")
                public void testDefaultArgs2() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs2.kt");
                }

                @TestMetadata("defaultArgsOverridden.kt")
                public void testDefaultArgsOverridden() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsOverridden.kt");
                }

                @TestMetadata("defaultArgsWithSideEffects.kt")
                public void testDefaultArgsWithSideEffects() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffects.kt");
                }

                @TestMetadata("defaultArgsWithSideEffects2.kt")
                public void testDefaultArgsWithSideEffects2() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffects2.kt");
                }

                @TestMetadata("defaultArgsWithSideEffectsOld.kt")
                public void testDefaultArgsWithSideEffectsOld() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffectsOld.kt");
                }

                @TestMetadata("extensionTailCall.kt")
                public void testExtensionTailCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/extensionTailCall.kt");
                }

                @TestMetadata("functionWithNoTails.kt")
                public void testFunctionWithNoTails() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNoTails.kt");
                }

                @TestMetadata("functionWithNonTailRecursions.kt")
                public void testFunctionWithNonTailRecursions() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNonTailRecursions.kt");
                }

                @TestMetadata("functionWithoutAnnotation.kt")
                public void testFunctionWithoutAnnotation() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithoutAnnotation.kt");
                }

                @TestMetadata("infixCall.kt")
                public void testInfixCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixCall.kt");
                }

                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixRecursiveCall.kt");
                }

                @TestMetadata("insideElvis.kt")
                public void testInsideElvis() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/insideElvis.kt");
                }

                @TestMetadata("kt47084_lambdaInDefaultArgument.kt")
                public void testKt47084_lambdaInDefaultArgument() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/kt47084_lambdaInDefaultArgument.kt");
                }

                @TestMetadata("labeledThisReferences.kt")
                public void testLabeledThisReferences() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/labeledThisReferences.kt");
                }

                @TestMetadata("loops.kt")
                public void testLoops() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/loops.kt");
                }

                @TestMetadata("multilevelBlocks.kt")
                public void testMultilevelBlocks() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/multilevelBlocks.kt");
                }

                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realIteratorFoldl.kt");
                }

                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringEscape.kt");
                }

                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringRepeat.kt");
                }

                @TestMetadata("recursiveCallInLambda.kt")
                public void testRecursiveCallInLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLambda.kt");
                }

                @TestMetadata("recursiveCallInLocalFunction.kt")
                public void testRecursiveCallInLocalFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLocalFunction.kt");
                }

                @TestMetadata("recursiveInnerFunction.kt")
                public void testRecursiveInnerFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveInnerFunction.kt");
                }

                @TestMetadata("returnIf.kt")
                public void testReturnIf() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnIf.kt");
                }

                @TestMetadata("returnInCatch.kt")
                public void testReturnInCatch() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInCatch.kt");
                }

                @TestMetadata("returnInFinally.kt")
                public void testReturnInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInFinally.kt");
                }

                @TestMetadata("returnInIfInFinally.kt")
                public void testReturnInIfInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInIfInFinally.kt");
                }

                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInParentheses.kt");
                }

                @TestMetadata("returnInTry.kt")
                public void testReturnInTry() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInTry.kt");
                }

                @TestMetadata("simpleBlock.kt")
                public void testSimpleBlock() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleBlock.kt");
                }

                @TestMetadata("simpleReturn.kt")
                public void testSimpleReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturn.kt");
                }

                @TestMetadata("simpleReturnWithElse.kt")
                public void testSimpleReturnWithElse() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturnWithElse.kt");
                }

                @TestMetadata("sum.kt")
                public void testSum() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/sum.kt");
                }

                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInBlockInParentheses.kt");
                }

                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInParentheses.kt");
                }

                @TestMetadata("tailRecursionInFinally.kt")
                public void testTailRecursionInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailRecursionInFinally.kt");
                }

                @TestMetadata("tailrecWithExplicitObjectDispatcher.kt")
                public void testTailrecWithExplicitObjectDispatcher() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailrecWithExplicitObjectDispatcher.kt");
                }

                @TestMetadata("thisReferences.kt")
                public void testThisReferences() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/thisReferences.kt");
                }

                @TestMetadata("unitBlocks.kt")
                public void testUnitBlocks() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/unitBlocks.kt");
                }

                @TestMetadata("whenWithCondition.kt")
                public void testWhenWithCondition() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithCondition.kt");
                }

                @TestMetadata("whenWithInRange.kt")
                public void testWhenWithInRange() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithInRange.kt");
                }

                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithIs.kt");
                }

                @TestMetadata("whenWithoutCondition.kt")
                public void testWhenWithoutCondition() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithoutCondition.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/diagnostics/vararg")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Vararg extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInVararg() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/vararg"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("kt4172.kt")
            public void testKt4172() throws Exception {
                runTest("compiler/testData/codegen/box/diagnostics/vararg/kt4172.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/differentDependencyVersion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DifferentDependencyVersion extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDifferentDependencyVersion() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/differentDependencyVersion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("kt51194_java.kt")
        public void testKt51194_java() throws Exception {
            runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_java.kt");
        }

        @TestMetadata("kt51194_javaAndKotlin.kt")
        public void testKt51194_javaAndKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_javaAndKotlin.kt");
        }

        @TestMetadata("kt51194_kotlin.kt")
        public void testKt51194_kotlin() throws Exception {
            runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_kotlin.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/directInvokeOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DirectInvokeOptimization extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDirectInvokeOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/directInvokeOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("boundInnerContructorRef.kt")
        public void testBoundInnerContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/boundInnerContructorRef.kt");
        }

        @TestMetadata("boundMemberRef.kt")
        public void testBoundMemberRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/boundMemberRef.kt");
        }

        @TestMetadata("capturingLambda.kt")
        public void testCapturingLambda() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/capturingLambda.kt");
        }

        @TestMetadata("contructorRef.kt")
        public void testContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/contructorRef.kt");
        }

        @TestMetadata("nestedLambdas.kt")
        public void testNestedLambdas() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/nestedLambdas.kt");
        }

        @TestMetadata("simpleAnonymousFun.kt")
        public void testSimpleAnonymousFun() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleAnonymousFun.kt");
        }

        @TestMetadata("simpleFunRef.kt")
        public void testSimpleFunRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleFunRef.kt");
        }

        @TestMetadata("simpleLambda.kt")
        public void testSimpleLambda() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleLambda.kt");
        }

        @TestMetadata("unboundInnerContructorRef.kt")
        public void testUnboundInnerContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/unboundInnerContructorRef.kt");
        }

        @TestMetadata("unboundMemberRef.kt")
        public void testUnboundMemberRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/unboundMemberRef.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/elvis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Elvis extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt24209.kt")
        public void ignoreKt24209() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/kt24209.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInElvis() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/elvis"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("genericElvisWithMoreSpecificLHS.kt")
        public void testGenericElvisWithMoreSpecificLHS() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericElvisWithMoreSpecificLHS.kt");
        }

        @TestMetadata("genericElvisWithNullLHS.kt")
        public void testGenericElvisWithNullLHS() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericElvisWithNullLHS.kt");
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericNull.kt");
        }

        @TestMetadata("kt6694ExactAnnotationForElvis.kt")
        public void testKt6694ExactAnnotationForElvis() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/kt6694ExactAnnotationForElvis.kt");
        }

        @TestMetadata("nullNullOk.kt")
        public void testNullNullOk() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/nullNullOk.kt");
        }

        @TestMetadata("ofNonNullableResultType.kt")
        public void testOfNonNullableResultType() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/ofNonNullableResultType.kt");
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/primitive.kt");
        }

        @TestMetadata("withReturn.kt")
        public void testWithReturn() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/withReturn.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractLightAnalysisModeTest {
        @TestMetadata("bigEnum.kt")
        public void ignoreBigEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/bigEnum.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("abstractMethodInEnum.kt")
        public void testAbstractMethodInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/abstractMethodInEnum.kt");
        }

        @TestMetadata("abstractNestedClass.kt")
        public void testAbstractNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/abstractNestedClass.kt");
        }

        public void testAllFilesPresentInEnum() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("annotatedParameter.kt")
        public void testAnnotatedParameter() throws Exception {
            runTest("compiler/testData/codegen/box/enum/annotatedParameter.kt");
        }

        @TestMetadata("annotatedParameter2.kt")
        public void testAnnotatedParameter2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/annotatedParameter2.kt");
        }

        @TestMetadata("asReturnExpression.kt")
        public void testAsReturnExpression() throws Exception {
            runTest("compiler/testData/codegen/box/enum/asReturnExpression.kt");
        }

        @TestMetadata("classForEnumEntry.kt")
        public void testClassForEnumEntry() throws Exception {
            runTest("compiler/testData/codegen/box/enum/classForEnumEntry.kt");
        }

        @TestMetadata("companionAccessingEnumValue.kt")
        public void testCompanionAccessingEnumValue() throws Exception {
            runTest("compiler/testData/codegen/box/enum/companionAccessingEnumValue.kt");
        }

        @TestMetadata("companionObjectInEnum.kt")
        public void testCompanionObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/companionObjectInEnum.kt");
        }

        @TestMetadata("constructorWithReordering.kt")
        public void testConstructorWithReordering() throws Exception {
            runTest("compiler/testData/codegen/box/enum/constructorWithReordering.kt");
        }

        @TestMetadata("declaringClassOnEnumObject.kt")
        public void testDeclaringClassOnEnumObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/declaringClassOnEnumObject.kt");
        }

        @TestMetadata("deepInnerClassInEnumEntryClass.kt")
        public void testDeepInnerClassInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass.kt");
        }

        @TestMetadata("deepInnerClassInEnumEntryClass2.kt")
        public void testDeepInnerClassInEnumEntryClass2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass2.kt");
        }

        @TestMetadata("emptyConstructor.kt")
        public void testEmptyConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/enum/emptyConstructor.kt");
        }

        @TestMetadata("emptyEnumValuesValueOf.kt")
        public void testEmptyEnumValuesValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/emptyEnumValuesValueOf.kt");
        }

        @TestMetadata("enumCompanionInit.kt")
        public void testEnumCompanionInit() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumCompanionInit.kt");
        }

        @TestMetadata("enumConstructorParameterClashWithDefaults.kt")
        public void testEnumConstructorParameterClashWithDefaults() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumConstructorParameterClashWithDefaults.kt");
        }

        @TestMetadata("enumEntryMembers.kt")
        public void testEnumEntryMembers() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryMembers.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor1.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor1() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor1.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor2.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor2.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor3.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor3() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor3.kt");
        }

        @TestMetadata("enumInheritedFromTrait.kt")
        public void testEnumInheritedFromTrait() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumInheritedFromTrait.kt");
        }

        @TestMetadata("enumMultiModule.kt")
        public void testEnumMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumMultiModule.kt");
        }

        @TestMetadata("enumShort.kt")
        public void testEnumShort() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumShort.kt");
        }

        @TestMetadata("enumValueOf.kt")
        public void testEnumValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumValueOf.kt");
        }

        @TestMetadata("enumWithLambdaParameter.kt")
        public void testEnumWithLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumWithLambdaParameter.kt");
        }

        @TestMetadata("getEnumEntityByOrdinal.kt")
        public void testGetEnumEntityByOrdinal() throws Exception {
            runTest("compiler/testData/codegen/box/enum/getEnumEntityByOrdinal.kt");
        }

        @TestMetadata("inPackage.kt")
        public void testInPackage() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inPackage.kt");
        }

        @TestMetadata("inclassobj.kt")
        public void testInclassobj() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inclassobj.kt");
        }

        @TestMetadata("initEntriesInCompanionObject.kt")
        public void testInitEntriesInCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInCompanionObject.kt");
        }

        @TestMetadata("initEntriesInCompanionObject2.kt")
        public void testInitEntriesInCompanionObject2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInCompanionObject2.kt");
        }

        @TestMetadata("initEntriesInValueOf.kt")
        public void testInitEntriesInValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInValueOf.kt");
        }

        @TestMetadata("initEnumAfterObjectAccess.kt")
        public void testInitEnumAfterObjectAccess() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEnumAfterObjectAccess.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inner.kt");
        }

        @TestMetadata("innerClassInEnumEntryClass.kt")
        public void testInnerClassInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassInEnumEntryClass.kt");
        }

        @TestMetadata("innerClassMethodInEnumEntryClass.kt")
        public void testInnerClassMethodInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass.kt");
        }

        @TestMetadata("innerClassMethodInEnumEntryClass2.kt")
        public void testInnerClassMethodInEnumEntryClass2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass2.kt");
        }

        @TestMetadata("innerWithExistingClassObject.kt")
        public void testInnerWithExistingClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerWithExistingClassObject.kt");
        }

        @TestMetadata("javaClassWithNestedEnum.kt")
        public void testJavaClassWithNestedEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaClassWithNestedEnum.kt");
        }

        @TestMetadata("javaEnumValueOf.kt")
        public void testJavaEnumValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValueOf.kt");
        }

        @TestMetadata("javaEnumValueOf2.kt")
        public void testJavaEnumValueOf2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValueOf2.kt");
        }

        @TestMetadata("javaEnumValues.kt")
        public void testJavaEnumValues() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValues.kt");
        }

        @TestMetadata("javaEnumValues2.kt")
        public void testJavaEnumValues2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValues2.kt");
        }

        @TestMetadata("javaEnumValues3.kt")
        public void testJavaEnumValues3() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValues3.kt");
        }

        @TestMetadata("kt1119.kt")
        public void testKt1119() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt1119.kt");
        }

        @TestMetadata("kt18731.kt")
        public void testKt18731() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt18731.kt");
        }

        @TestMetadata("kt18731_2.kt")
        public void testKt18731_2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt18731_2.kt");
        }

        @TestMetadata("kt20651.kt")
        public void testKt20651() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651.kt");
        }

        @TestMetadata("kt20651_inlineLambda.kt")
        public void testKt20651_inlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651_inlineLambda.kt");
        }

        @TestMetadata("kt20651a.kt")
        public void testKt20651a() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651a.kt");
        }

        @TestMetadata("kt20651b.kt")
        public void testKt20651b() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651b.kt");
        }

        @TestMetadata("kt2350.kt")
        public void testKt2350() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt2350.kt");
        }

        @TestMetadata("kt38996.kt")
        public void testKt38996() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt38996.kt");
        }

        @TestMetadata("kt44744.kt")
        public void testKt44744() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt44744.kt");
        }

        @TestMetadata("kt44744_innerClass.kt")
        public void testKt44744_innerClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt44744_innerClass.kt");
        }

        @TestMetadata("kt46605.kt")
        public void testKt46605() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt46605.kt");
        }

        @TestMetadata("kt7257.kt")
        public void testKt7257() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257.kt");
        }

        @TestMetadata("kt7257_anonObjectInit.kt")
        public void testKt7257_anonObjectInit() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectInit.kt");
        }

        @TestMetadata("kt7257_anonObjectMethod.kt")
        public void testKt7257_anonObjectMethod() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectMethod.kt");
        }

        @TestMetadata("kt7257_boundReference1.kt")
        public void testKt7257_boundReference1() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReference1.kt");
        }

        @TestMetadata("kt7257_boundReference2.kt")
        public void testKt7257_boundReference2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReference2.kt");
        }

        @TestMetadata("kt7257_boundReferenceWithImplicitReceiver.kt")
        public void testKt7257_boundReferenceWithImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReferenceWithImplicitReceiver.kt");
        }

        @TestMetadata("kt7257_explicitReceiver.kt")
        public void testKt7257_explicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_explicitReceiver.kt");
        }

        @TestMetadata("kt7257_fullyQualifiedReceiver.kt")
        public void testKt7257_fullyQualifiedReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_fullyQualifiedReceiver.kt");
        }

        @TestMetadata("kt7257_namedLocalFun.kt")
        public void testKt7257_namedLocalFun() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_namedLocalFun.kt");
        }

        @TestMetadata("kt7257_notInline.kt")
        public void testKt7257_notInline() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_notInline.kt");
        }

        @TestMetadata("kt9711.kt")
        public void testKt9711() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt9711.kt");
        }

        @TestMetadata("kt9711_2.kt")
        public void testKt9711_2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt9711_2.kt");
        }

        @TestMetadata("manyDefaultParameters.kt")
        public void testManyDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/enum/manyDefaultParameters.kt");
        }

        @TestMetadata("modifierFlags.kt")
        public void testModifierFlags() throws Exception {
            runTest("compiler/testData/codegen/box/enum/modifierFlags.kt");
        }

        @TestMetadata("nameClashWithCompanion.kt")
        public void testNameClashWithCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/enum/nameClashWithCompanion.kt");
        }

        @TestMetadata("nameConflict.kt")
        public void testNameConflict() throws Exception {
            runTest("compiler/testData/codegen/box/enum/nameConflict.kt");
        }

        @TestMetadata("noClassForSimpleEnum.kt")
        public void testNoClassForSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/noClassForSimpleEnum.kt");
        }

        @TestMetadata("objectInEnum.kt")
        public void testObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/objectInEnum.kt");
        }

        @TestMetadata("ordinal.kt")
        public void testOrdinal() throws Exception {
            runTest("compiler/testData/codegen/box/enum/ordinal.kt");
        }

        @TestMetadata("ordinalsWithEnumEntitiesOverrides.kt")
        public void testOrdinalsWithEnumEntitiesOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/enum/ordinalsWithEnumEntitiesOverrides.kt");
        }

        @TestMetadata("overloadedEnumValues.kt")
        public void testOverloadedEnumValues() throws Exception {
            runTest("compiler/testData/codegen/box/enum/overloadedEnumValues.kt");
        }

        @TestMetadata("overloadedEnumValuesStatic.kt")
        public void testOverloadedEnumValuesStatic() throws Exception {
            runTest("compiler/testData/codegen/box/enum/overloadedEnumValuesStatic.kt");
        }

        @TestMetadata("refToThis.kt")
        public void testRefToThis() throws Exception {
            runTest("compiler/testData/codegen/box/enum/refToThis.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simple.kt");
        }

        @TestMetadata("simpleJavaEnum.kt")
        public void testSimpleJavaEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simpleJavaEnum.kt");
        }

        @TestMetadata("simpleJavaEnumWithFunction.kt")
        public void testSimpleJavaEnumWithFunction() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simpleJavaEnumWithFunction.kt");
        }

        @TestMetadata("simpleJavaEnumWithStaticImport.kt")
        public void testSimpleJavaEnumWithStaticImport() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simpleJavaEnumWithStaticImport.kt");
        }

        @TestMetadata("simpleJavaInnerEnum.kt")
        public void testSimpleJavaInnerEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simpleJavaInnerEnum.kt");
        }

        @TestMetadata("sortEnumEntries.kt")
        public void testSortEnumEntries() throws Exception {
            runTest("compiler/testData/codegen/box/enum/sortEnumEntries.kt");
        }

        @TestMetadata("staticField.kt")
        public void testStaticField() throws Exception {
            runTest("compiler/testData/codegen/box/enum/staticField.kt");
        }

        @TestMetadata("staticMethod.kt")
        public void testStaticMethod() throws Exception {
            runTest("compiler/testData/codegen/box/enum/staticMethod.kt");
        }

        @TestMetadata("superCallInEnumLiteral.kt")
        public void testSuperCallInEnumLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/enum/superCallInEnumLiteral.kt");
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("compiler/testData/codegen/box/enum/toString.kt");
        }

        @TestMetadata("valueof.kt")
        public void testValueof() throws Exception {
            runTest("compiler/testData/codegen/box/enum/valueof.kt");
        }

        @TestMetadata("whenInObject.kt")
        public void testWhenInObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/whenInObject.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/enum/defaultCtor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultCtor extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultCtor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/enum/defaultCtor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("constructorWithDefaultArguments.kt")
            public void testConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithDefaultArguments.kt");
            }

            @TestMetadata("constructorWithVararg.kt")
            public void testConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithVararg.kt");
            }

            @TestMetadata("entryClassConstructorWithDefaultArguments.kt")
            public void testEntryClassConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithDefaultArguments.kt");
            }

            @TestMetadata("entryClassConstructorWithVarargs.kt")
            public void testEntryClassConstructorWithVarargs() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithVarargs.kt");
            }

            @TestMetadata("secondaryConstructorWithDefaultArguments.kt")
            public void testSecondaryConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithDefaultArguments.kt");
            }

            @TestMetadata("secondaryConstructorWithVararg.kt")
            public void testSecondaryConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithVararg.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/evaluate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Evaluate extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInEvaluate() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/evaluate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/char.kt");
        }

        @TestMetadata("divide.kt")
        public void testDivide() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/divide.kt");
        }

        @TestMetadata("floorDiv.kt")
        public void testFloorDiv() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/floorDiv.kt");
        }

        @TestMetadata("intrinsics.kt")
        public void testIntrinsics() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/intrinsics.kt");
        }

        @TestMetadata("kt9443.kt")
        public void testKt9443() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/kt9443.kt");
        }

        @TestMetadata("maxValue.kt")
        public void testMaxValue() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValue.kt");
        }

        @TestMetadata("maxValueByte.kt")
        public void testMaxValueByte() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValueByte.kt");
        }

        @TestMetadata("maxValueInt.kt")
        public void testMaxValueInt() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValueInt.kt");
        }

        @TestMetadata("minus.kt")
        public void testMinus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/minus.kt");
        }

        @TestMetadata("mod.kt")
        public void testMod() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/mod.kt");
        }

        @TestMetadata("multiply.kt")
        public void testMultiply() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/multiply.kt");
        }

        @TestMetadata("parenthesized.kt")
        public void testParenthesized() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/parenthesized.kt");
        }

        @TestMetadata("plus.kt")
        public void testPlus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/plus.kt");
        }

        @TestMetadata("rem.kt")
        public void testRem() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/rem.kt");
        }

        @TestMetadata("simpleCallBinary.kt")
        public void testSimpleCallBinary() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/simpleCallBinary.kt");
        }

        @TestMetadata("unaryMinus.kt")
        public void testUnaryMinus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/unaryMinus.kt");
        }

        @TestMetadata("unaryPlus.kt")
        public void testUnaryPlus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/unaryPlus.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/exclExcl")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExclExcl extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInExclExcl() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/genericNull.kt");
        }

        @TestMetadata("kt48440.kt")
        public void testKt48440() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/kt48440.kt");
        }

        @TestMetadata("kt48440_2.kt")
        public void testKt48440_2() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/kt48440_2.kt");
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/primitive.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionClasses extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInExtensionClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionFunctions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionFunctions extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInExtensionFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("classMethodCallExtensionSuper.kt")
        public void testClassMethodCallExtensionSuper() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/classMethodCallExtensionSuper.kt");
        }

        @TestMetadata("defaultMethodInterfaceCallExtensionSuper.kt")
        public void testDefaultMethodInterfaceCallExtensionSuper() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/defaultMethodInterfaceCallExtensionSuper.kt");
        }

        @TestMetadata("executionOrder.kt")
        public void testExecutionOrder() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/executionOrder.kt");
        }

        @TestMetadata("extensionFunctionAsSupertype.kt")
        public void testExtensionFunctionAsSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsSupertype.kt");
        }

        @TestMetadata("kt1061.kt")
        public void testKt1061() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1061.kt");
        }

        @TestMetadata("kt1249.kt")
        public void testKt1249() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1249.kt");
        }

        @TestMetadata("kt1290.kt")
        public void testKt1290() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1290.kt");
        }

        @TestMetadata("kt13312.kt")
        public void testKt13312() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt13312.kt");
        }

        @TestMetadata("kt1776.kt")
        public void testKt1776() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1776.kt");
        }

        @TestMetadata("kt1953.kt")
        public void testKt1953() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1953.kt");
        }

        @TestMetadata("kt1953_class.kt")
        public void testKt1953_class() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1953_class.kt");
        }

        @TestMetadata("kt23675.kt")
        public void testKt23675() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt23675.kt");
        }

        @TestMetadata("kt3285.kt")
        public void testKt3285() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3285.kt");
        }

        @TestMetadata("kt3298.kt")
        public void testKt3298() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3298.kt");
        }

        @TestMetadata("kt3646.kt")
        public void testKt3646() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3646.kt");
        }

        @TestMetadata("kt3969.kt")
        public void testKt3969() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3969.kt");
        }

        @TestMetadata("kt4228.kt")
        public void testKt4228() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt4228.kt");
        }

        @TestMetadata("kt475.kt")
        public void testKt475() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt475.kt");
        }

        @TestMetadata("kt5467.kt")
        public void testKt5467() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt5467.kt");
        }

        @TestMetadata("kt606.kt")
        public void testKt606() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt606.kt");
        }

        @TestMetadata("kt865.kt")
        public void testKt865() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt865.kt");
        }

        @TestMetadata("memberExtensionEqualsHashCodeToStringInInterface.kt")
        public void testMemberExtensionEqualsHashCodeToStringInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/memberExtensionEqualsHashCodeToStringInInterface.kt");
        }

        @TestMetadata("nested2.kt")
        public void testNested2() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/nested2.kt");
        }

        @TestMetadata("shared.kt")
        public void testShared() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/shared.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/simple.kt");
        }

        @TestMetadata("thisMethodInObjectLiteral.kt")
        public void testThisMethodInObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/thisMethodInObjectLiteral.kt");
        }

        @TestMetadata("virtual.kt")
        public void testVirtual() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/virtual.kt");
        }

        @TestMetadata("whenFail.kt")
        public void testWhenFail() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/whenFail.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/extensionFunctions/contextReceivers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ContextReceivers extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInContextReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FromKEEP extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInFromKEEP() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionProperties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionProperties extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("accessorForPrivateSetter.kt")
        public void testAccessorForPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/accessorForPrivateSetter.kt");
        }

        public void testAllFilesPresentInExtensionProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("genericValForPrimitiveType.kt")
        public void testGenericValForPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericValForPrimitiveType.kt");
        }

        @TestMetadata("genericValMultipleUpperBounds.kt")
        public void testGenericValMultipleUpperBounds() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericValMultipleUpperBounds.kt");
        }

        @TestMetadata("genericVarForPrimitiveType.kt")
        public void testGenericVarForPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericVarForPrimitiveType.kt");
        }

        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClass.kt");
        }

        @TestMetadata("inClassLongTypeInReceiver.kt")
        public void testInClassLongTypeInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassLongTypeInReceiver.kt");
        }

        @TestMetadata("inClassWithGetter.kt")
        public void testInClassWithGetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithGetter.kt");
        }

        @TestMetadata("inClassWithPrivateGetter.kt")
        public void testInClassWithPrivateGetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateGetter.kt");
        }

        @TestMetadata("inClassWithPrivateSetter.kt")
        public void testInClassWithPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateSetter.kt");
        }

        @TestMetadata("inClassWithSetter.kt")
        public void testInClassWithSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithSetter.kt");
        }

        @TestMetadata("kt46952.kt")
        public void testKt46952() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt46952.kt");
        }

        @TestMetadata("kt9897.kt")
        public void testKt9897() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt9897.kt");
        }

        @TestMetadata("kt9897_topLevel.kt")
        public void testKt9897_topLevel() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt9897_topLevel.kt");
        }

        @TestMetadata("nonAbstractInInterface.kt")
        public void testNonAbstractInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/nonAbstractInInterface.kt");
        }

        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/topLevel.kt");
        }

        @TestMetadata("topLevelLongTypeInReceiver.kt")
        public void testTopLevelLongTypeInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/topLevelLongTypeInReceiver.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/external")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class External extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInExternal() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/external"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("jvmStaticExternal.kt")
        public void testJvmStaticExternal() throws Exception {
            runTest("compiler/testData/codegen/box/external/jvmStaticExternal.kt");
        }

        @TestMetadata("jvmStaticExternalPrivate.kt")
        public void testJvmStaticExternalPrivate() throws Exception {
            runTest("compiler/testData/codegen/box/external/jvmStaticExternalPrivate.kt");
        }

        @TestMetadata("withDefaultArg.kt")
        public void testWithDefaultArg() throws Exception {
            runTest("compiler/testData/codegen/box/external/withDefaultArg.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fakeOverride")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FakeOverride extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFakeOverride() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fakeOverride"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("diamondFunction.kt")
        public void testDiamondFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/diamondFunction.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/function.kt");
        }

        @TestMetadata("internalFromFriendModule.kt")
        public void testInternalFromFriendModule() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/internalFromFriendModule.kt");
        }

        @TestMetadata("kt49371.kt")
        public void testKt49371() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/kt49371.kt");
        }

        @TestMetadata("privateFakeOverrides0.kt")
        public void testPrivateFakeOverrides0() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/privateFakeOverrides0.kt");
        }

        @TestMetadata("privateFakeOverrides1.kt")
        public void testPrivateFakeOverrides1() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/privateFakeOverrides1.kt");
        }

        @TestMetadata("propertyGetter.kt")
        public void testPropertyGetter() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/propertyGetter.kt");
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/propertySetter.kt");
        }

        @TestMetadata("varianceOverload.kt")
        public void testVarianceOverload() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/varianceOverload.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fieldRename")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FieldRename extends AbstractLightAnalysisModeTest {
        @TestMetadata("jvmFieldNoClash1.kt")
        public void ignoreJvmFieldNoClash1() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/jvmFieldNoClash1.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFieldRename() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fieldRename"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("constructorAndClassObject.kt")
        public void testConstructorAndClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/constructorAndClassObject.kt");
        }

        @TestMetadata("delegates.kt")
        public void testDelegates() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/delegates.kt");
        }

        @TestMetadata("genericPropertyWithItself.kt")
        public void testGenericPropertyWithItself() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/genericPropertyWithItself.kt");
        }

        @TestMetadata("jvmFieldNoClash2.kt")
        public void testJvmFieldNoClash2() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/jvmFieldNoClash2.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/finally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Finally extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFinally() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/finally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("breakAndOuterFinally.kt")
        public void testBreakAndOuterFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/breakAndOuterFinally.kt");
        }

        @TestMetadata("continueAndOuterFinally.kt")
        public void testContinueAndOuterFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/continueAndOuterFinally.kt");
        }

        @TestMetadata("finallyAndFinally.kt")
        public void testFinallyAndFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/finallyAndFinally.kt");
        }

        @TestMetadata("kt31923_break.kt")
        public void testKt31923_break() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_break.kt");
        }

        @TestMetadata("kt31923_continue.kt")
        public void testKt31923_continue() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_continue.kt");
        }

        @TestMetadata("kt31923_return.kt")
        public void testKt31923_return() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_return.kt");
        }

        @TestMetadata("kt31923_wrong.kt")
        public void testKt31923_wrong() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_wrong.kt");
        }

        @TestMetadata("kt3549.kt")
        public void testKt3549() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3549.kt");
        }

        @TestMetadata("kt3706.kt")
        public void testKt3706() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3706.kt");
        }

        @TestMetadata("kt3867.kt")
        public void testKt3867() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3867.kt");
        }

        @TestMetadata("kt3874.kt")
        public void testKt3874() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3874.kt");
        }

        @TestMetadata("kt3894.kt")
        public void testKt3894() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3894.kt");
        }

        @TestMetadata("kt4134.kt")
        public void testKt4134() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt4134.kt");
        }

        @TestMetadata("loopAndFinally.kt")
        public void testLoopAndFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/loopAndFinally.kt");
        }

        @TestMetadata("nestedFinallyAndNonFinallyTry.kt")
        public void testNestedFinallyAndNonFinallyTry() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry.kt");
        }

        @TestMetadata("nestedFinallyAndNonFinallyTry2.kt")
        public void testNestedFinallyAndNonFinallyTry2() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry2.kt");
        }

        @TestMetadata("nestedFinallyAndNonFinallyTry3.kt")
        public void testNestedFinallyAndNonFinallyTry3() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry3.kt");
        }

        @TestMetadata("nestedFinallyAndNonFinallyTry4.kt")
        public void testNestedFinallyAndNonFinallyTry4() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry4.kt");
        }

        @TestMetadata("notChainCatch.kt")
        public void testNotChainCatch() throws Exception {
            runTest("compiler/testData/codegen/box/finally/notChainCatch.kt");
        }

        @TestMetadata("objectInFinally.kt")
        public void testObjectInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/objectInFinally.kt");
        }

        @TestMetadata("someStuff.kt")
        public void testSomeStuff() throws Exception {
            runTest("compiler/testData/codegen/box/finally/someStuff.kt");
        }

        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/tryFinally.kt");
        }

        @TestMetadata("tryLoopTry.kt")
        public void testTryLoopTry() throws Exception {
            runTest("compiler/testData/codegen/box/finally/tryLoopTry.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fir")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Fir extends AbstractLightAnalysisModeTest {
        @TestMetadata("SuspendExtension.kt")
        public void ignoreSuspendExtension() throws Exception {
            runTest("compiler/testData/codegen/box/fir/SuspendExtension.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFir() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fir"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("ClassBuilder.kt")
        public void testClassBuilder() throws Exception {
            runTest("compiler/testData/codegen/box/fir/ClassBuilder.kt");
        }

        @TestMetadata("classCanNotBeCastedToVoid.kt")
        public void testClassCanNotBeCastedToVoid() throws Exception {
            runTest("compiler/testData/codegen/box/fir/classCanNotBeCastedToVoid.kt");
        }

        @TestMetadata("ConstValAccess.kt")
        public void testConstValAccess() throws Exception {
            runTest("compiler/testData/codegen/box/fir/ConstValAccess.kt");
        }

        @TestMetadata("differentSinceKotlin.kt")
        public void testDifferentSinceKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/fir/differentSinceKotlin.kt");
        }

        @TestMetadata("ExtensionAlias.kt")
        public void testExtensionAlias() throws Exception {
            runTest("compiler/testData/codegen/box/fir/ExtensionAlias.kt");
        }

        @TestMetadata("FakeOverrideBuilder.kt")
        public void testFakeOverrideBuilder() throws Exception {
            runTest("compiler/testData/codegen/box/fir/FakeOverrideBuilder.kt");
        }

        @TestMetadata("falsePositiveBoundSmartcast.kt")
        public void testFalsePositiveBoundSmartcast() throws Exception {
            runTest("compiler/testData/codegen/box/fir/falsePositiveBoundSmartcast.kt");
        }

        @TestMetadata("Fir2IrClassifierStorage.kt")
        public void testFir2IrClassifierStorage() throws Exception {
            runTest("compiler/testData/codegen/box/fir/Fir2IrClassifierStorage.kt");
        }

        @TestMetadata("flexibleIntegerLiterals.kt")
        public void testFlexibleIntegerLiterals() throws Exception {
            runTest("compiler/testData/codegen/box/fir/flexibleIntegerLiterals.kt");
        }

        @TestMetadata("incorrectBytecodeWithEnhancedNullability.kt")
        public void testIncorrectBytecodeWithEnhancedNullability() throws Exception {
            runTest("compiler/testData/codegen/box/fir/incorrectBytecodeWithEnhancedNullability.kt");
        }

        @TestMetadata("IrBuiltIns.kt")
        public void testIrBuiltIns() throws Exception {
            runTest("compiler/testData/codegen/box/fir/IrBuiltIns.kt");
        }

        @TestMetadata("KotlinDocumentationProvider.kt")
        public void testKotlinDocumentationProvider() throws Exception {
            runTest("compiler/testData/codegen/box/fir/KotlinDocumentationProvider.kt");
        }

        @TestMetadata("LookupTags.kt")
        public void testLookupTags() throws Exception {
            runTest("compiler/testData/codegen/box/fir/LookupTags.kt");
        }

        @TestMetadata("NameHighlighter.kt")
        public void testNameHighlighter() throws Exception {
            runTest("compiler/testData/codegen/box/fir/NameHighlighter.kt");
        }

        @TestMetadata("notFoundClasses.kt")
        public void testNotFoundClasses() throws Exception {
            runTest("compiler/testData/codegen/box/fir/notFoundClasses.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fullJdk")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FullJdk extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFullJdk() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("charBuffer.kt")
        public void testCharBuffer() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/charBuffer.kt");
        }

        @TestMetadata("ifInWhile.kt")
        public void testIfInWhile() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/ifInWhile.kt");
        }

        @TestMetadata("intCountDownLatchExtension.kt")
        public void testIntCountDownLatchExtension() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/intCountDownLatchExtension.kt");
        }

        @TestMetadata("kt31757.kt")
        public void testKt31757() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/kt31757.kt");
        }

        @TestMetadata("kt434.kt")
        public void testKt434() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/kt434.kt");
        }

        @TestMetadata("kt46540.kt")
        public void testKt46540() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/kt46540.kt");
        }

        @TestMetadata("platformTypeAssertionStackTrace.kt")
        public void testPlatformTypeAssertionStackTrace() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/platformTypeAssertionStackTrace.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/fullJdk/native")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Native extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInNative() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/native"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("nativePropertyAccessors.kt")
            public void testNativePropertyAccessors() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/nativePropertyAccessors.kt");
            }

            @TestMetadata("simpleNative.kt")
            public void testSimpleNative() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/simpleNative.kt");
            }

            @TestMetadata("topLevel.kt")
            public void testTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/topLevel.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/fullJdk/regressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Regressions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInRegressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/regressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("kt15112.kt")
            public void testKt15112() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/regressions/kt15112.kt");
            }

            @TestMetadata("kt1770.kt")
            public void testKt1770() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/regressions/kt1770.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/funInterface")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FunInterface extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt45444_privateFunInterface.kt")
        public void ignoreKt45444_privateFunInterface() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt45444_privateFunInterface.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFunInterface() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("basicFunInterface.kt")
        public void testBasicFunInterface() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterface.kt");
        }

        @TestMetadata("basicFunInterfaceConversion.kt")
        public void testBasicFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterfaceConversion.kt");
        }

        @TestMetadata("basicFunInterfaceConversionClash.kt")
        public void testBasicFunInterfaceConversionClash() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterfaceConversionClash.kt");
        }

        @TestMetadata("castFromAny.kt")
        public void testCastFromAny() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/castFromAny.kt");
        }

        @TestMetadata("contravariantIntersectionType.kt")
        public void testContravariantIntersectionType() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionType.kt");
        }

        @TestMetadata("contravariantIntersectionTypeWithNonTrivialCommonSupertype.kt")
        public void testContravariantIntersectionTypeWithNonTrivialCommonSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionTypeWithNonTrivialCommonSupertype.kt");
        }

        @TestMetadata("contravariantIntersectionTypeWithNonTrivialCommonSupertype2.kt")
        public void testContravariantIntersectionTypeWithNonTrivialCommonSupertype2() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionTypeWithNonTrivialCommonSupertype2.kt");
        }

        @TestMetadata("funConversionInVararg.kt")
        public void testFunConversionInVararg() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funConversionInVararg.kt");
        }

        @TestMetadata("funInterfaceCallInLambda.kt")
        public void testFunInterfaceCallInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceCallInLambda.kt");
        }

        @TestMetadata("funInterfaceInheritance.kt")
        public void testFunInterfaceInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceInheritance.kt");
        }

        @TestMetadata("funInterfaceWithReceiver.kt")
        public void testFunInterfaceWithReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceWithReceiver.kt");
        }

        @TestMetadata("inlinedSamWrapper.kt")
        public void testInlinedSamWrapper() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/inlinedSamWrapper.kt");
        }

        @TestMetadata("intersectionTypeToFunInterfaceConversion.kt")
        public void testIntersectionTypeToFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/intersectionTypeToFunInterfaceConversion.kt");
        }

        @TestMetadata("irrelevantPrivateDeclarations.kt")
        public void testIrrelevantPrivateDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/irrelevantPrivateDeclarations.kt");
        }

        @TestMetadata("kt44827_funInterface.kt")
        public void testKt44827_funInterface() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt44827_funInterface.kt");
        }

        @TestMetadata("kt46512_indyFunInterfaceOverCallableReference.kt")
        public void testKt46512_indyFunInterfaceOverCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt46512_indyFunInterfaceOverCallableReference.kt");
        }

        @TestMetadata("kt46908_functionSupertype.kt")
        public void testKt46908_functionSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt46908_functionSupertype.kt");
        }

        @TestMetadata("multimodule.kt")
        public void testMultimodule() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/multimodule.kt");
        }

        @TestMetadata("noOptimizedCallableReferences.kt")
        public void testNoOptimizedCallableReferences() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/noOptimizedCallableReferences.kt");
        }

        @TestMetadata("nonAbstractMethod.kt")
        public void testNonAbstractMethod() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/nonAbstractMethod.kt");
        }

        @TestMetadata("nullableSam.kt")
        public void testNullableSam() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/nullableSam.kt");
        }

        @TestMetadata("partialSam.kt")
        public void testPartialSam() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/partialSam.kt");
        }

        @TestMetadata("primitiveConversions.kt")
        public void testPrimitiveConversions() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/primitiveConversions.kt");
        }

        @TestMetadata("receiverEvaluatedOnce.kt")
        public void testReceiverEvaluatedOnce() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/receiverEvaluatedOnce.kt");
        }

        @TestMetadata("samConstructorExplicitInvocation.kt")
        public void testSamConstructorExplicitInvocation() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/samConstructorExplicitInvocation.kt");
        }

        @TestMetadata("samConversionToGenericInterfaceInGenericFun.kt")
        public void testSamConversionToGenericInterfaceInGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/samConversionToGenericInterfaceInGenericFun.kt");
        }

        @TestMetadata("subtypeOfFunctionalTypeToFunInterfaceConversion.kt")
        public void testSubtypeOfFunctionalTypeToFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/subtypeOfFunctionalTypeToFunInterfaceConversion.kt");
        }

        @TestMetadata("suspendFunInterfaceConversionCodegen.kt")
        public void testSuspendFunInterfaceConversionCodegen() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/suspendFunInterfaceConversionCodegen.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/funInterface/equality")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equality extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInEquality() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/funInterface/equality"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("functionReferencesBound.kt")
            public void testFunctionReferencesBound() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/functionReferencesBound.kt");
            }

            @TestMetadata("functionReferencesUnbound.kt")
            public void testFunctionReferencesUnbound() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/functionReferencesUnbound.kt");
            }

            @TestMetadata("lambdaRuntimeConversion.kt")
            public void testLambdaRuntimeConversion() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/lambdaRuntimeConversion.kt");
            }

            @TestMetadata("localFunctionReferences.kt")
            public void testLocalFunctionReferences() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/localFunctionReferences.kt");
            }

            @TestMetadata("simpleLambdas.kt")
            public void testSimpleLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/simpleLambdas.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/functions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Functions extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("coerceVoidToArray.kt")
        public void testCoerceVoidToArray() throws Exception {
            runTest("compiler/testData/codegen/box/functions/coerceVoidToArray.kt");
        }

        @TestMetadata("coerceVoidToObject.kt")
        public void testCoerceVoidToObject() throws Exception {
            runTest("compiler/testData/codegen/box/functions/coerceVoidToObject.kt");
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/functions/constructor.kt");
        }

        @TestMetadata("dataLocalVariable.kt")
        public void testDataLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/functions/dataLocalVariable.kt");
        }

        @TestMetadata("defaultargs.kt")
        public void testDefaultargs() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs.kt");
        }

        @TestMetadata("defaultargs1.kt")
        public void testDefaultargs1() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs1.kt");
        }

        @TestMetadata("defaultargs2.kt")
        public void testDefaultargs2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs2.kt");
        }

        @TestMetadata("defaultargs3.kt")
        public void testDefaultargs3() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs3.kt");
        }

        @TestMetadata("defaultargs4.kt")
        public void testDefaultargs4() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs4.kt");
        }

        @TestMetadata("defaultargs5.kt")
        public void testDefaultargs5() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs5.kt");
        }

        @TestMetadata("defaultargs6.kt")
        public void testDefaultargs6() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs6.kt");
        }

        @TestMetadata("defaultargs7.kt")
        public void testDefaultargs7() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs7.kt");
        }

        @TestMetadata("ea33909.kt")
        public void testEa33909() throws Exception {
            runTest("compiler/testData/codegen/box/functions/ea33909.kt");
        }

        @TestMetadata("fakeDescriptorWithSeveralOverridenOne.kt")
        public void testFakeDescriptorWithSeveralOverridenOne() throws Exception {
            runTest("compiler/testData/codegen/box/functions/fakeDescriptorWithSeveralOverridenOne.kt");
        }

        @TestMetadata("functionNtoString.kt")
        public void testFunctionNtoString() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoString.kt");
        }

        @TestMetadata("functionNtoStringGeneric.kt")
        public void testFunctionNtoStringGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoStringGeneric.kt");
        }

        @TestMetadata("functionNtoStringNoReflect.kt")
        public void testFunctionNtoStringNoReflect() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoStringNoReflect.kt");
        }

        @TestMetadata("infixRecursiveCall.kt")
        public void testInfixRecursiveCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/infixRecursiveCall.kt");
        }

        @TestMetadata("kt1038.kt")
        public void testKt1038() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1038.kt");
        }

        @TestMetadata("kt1199.kt")
        public void testKt1199() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1199.kt");
        }

        @TestMetadata("kt1413.kt")
        public void testKt1413() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1413.kt");
        }

        @TestMetadata("kt1649_1.kt")
        public void testKt1649_1() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1649_1.kt");
        }

        @TestMetadata("kt1649_2.kt")
        public void testKt1649_2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1649_2.kt");
        }

        @TestMetadata("kt1739.kt")
        public void testKt1739() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1739.kt");
        }

        @TestMetadata("kt2270.kt")
        public void testKt2270() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2270.kt");
        }

        @TestMetadata("kt2271.kt")
        public void testKt2271() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2271.kt");
        }

        @TestMetadata("kt2280.kt")
        public void testKt2280() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2280.kt");
        }

        @TestMetadata("kt2481.kt")
        public void testKt2481() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2481.kt");
        }

        @TestMetadata("kt2716.kt")
        public void testKt2716() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2716.kt");
        }

        @TestMetadata("kt2739.kt")
        public void testKt2739() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2739.kt");
        }

        @TestMetadata("kt2929.kt")
        public void testKt2929() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2929.kt");
        }

        @TestMetadata("kt3214.kt")
        public void testKt3214() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3214.kt");
        }

        @TestMetadata("kt3313.kt")
        public void testKt3313() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3313.kt");
        }

        @TestMetadata("kt3573.kt")
        public void testKt3573() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3573.kt");
        }

        @TestMetadata("kt3724.kt")
        public void testKt3724() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3724.kt");
        }

        @TestMetadata("kt395.kt")
        public void testKt395() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt395.kt");
        }

        @TestMetadata("kt47449.kt")
        public void testKt47449() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt47449.kt");
        }

        @TestMetadata("kt47527.kt")
        public void testKt47527() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt47527.kt");
        }

        @TestMetadata("kt48058.kt")
        public void testKt48058() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt48058.kt");
        }

        @TestMetadata("kt785.kt")
        public void testKt785() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt785.kt");
        }

        @TestMetadata("kt873.kt")
        public void testKt873() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt873.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/functions/localFunction.kt");
        }

        @TestMetadata("localReturnInsideFunctionExpression.kt")
        public void testLocalReturnInsideFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/box/functions/localReturnInsideFunctionExpression.kt");
        }

        @TestMetadata("max.kt")
        public void testMax() throws Exception {
            runTest("compiler/testData/codegen/box/functions/max.kt");
        }

        @TestMetadata("mutualInline.kt")
        public void testMutualInline() throws Exception {
            runTest("compiler/testData/codegen/box/functions/mutualInline.kt");
        }

        @TestMetadata("nothisnoclosure.kt")
        public void testNothisnoclosure() throws Exception {
            runTest("compiler/testData/codegen/box/functions/nothisnoclosure.kt");
        }

        @TestMetadata("overloadByInterfaceType.kt")
        public void testOverloadByInterfaceType() throws Exception {
            runTest("compiler/testData/codegen/box/functions/overloadByInterfaceType.kt");
        }

        @TestMetadata("prefixRecursiveCall.kt")
        public void testPrefixRecursiveCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/prefixRecursiveCall.kt");
        }

        @TestMetadata("recursiveCompareTo.kt")
        public void testRecursiveCompareTo() throws Exception {
            runTest("compiler/testData/codegen/box/functions/recursiveCompareTo.kt");
        }

        @TestMetadata("recursiveIncrementCall.kt")
        public void testRecursiveIncrementCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/recursiveIncrementCall.kt");
        }

        @TestMetadata("referencesStaticInnerClassMethod.kt")
        public void testReferencesStaticInnerClassMethod() throws Exception {
            runTest("compiler/testData/codegen/box/functions/referencesStaticInnerClassMethod.kt");
        }

        @TestMetadata("referencesStaticInnerClassMethodL2.kt")
        public void testReferencesStaticInnerClassMethodL2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/referencesStaticInnerClassMethodL2.kt");
        }

        @TestMetadata("typeParameterAsUpperBound.kt")
        public void testTypeParameterAsUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/functions/typeParameterAsUpperBound.kt");
        }

        @TestMetadata("typeParametersInLocalFunction.kt")
        public void testTypeParametersInLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/functions/typeParametersInLocalFunction.kt");
        }

        @TestMetadata("unrelatedUpperBounds.kt")
        public void testUnrelatedUpperBounds() throws Exception {
            runTest("compiler/testData/codegen/box/functions/unrelatedUpperBounds.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/functions/bigArity")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BigArity extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBigArity() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/bigArity"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("callFromJava.kt")
            public void testCallFromJava() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/callFromJava.kt");
            }

            @TestMetadata("callFunViaVararg.kt")
            public void testCallFunViaVararg() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/callFunViaVararg.kt");
            }

            @TestMetadata("callWithIncorrectNumberOfArguments.kt")
            public void testCallWithIncorrectNumberOfArguments() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/callWithIncorrectNumberOfArguments.kt");
            }

            @TestMetadata("function255.kt")
            public void testFunction255() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/function255.kt");
            }

            @TestMetadata("instanceOfCallableReference.kt")
            public void testInstanceOfCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/instanceOfCallableReference.kt");
            }

            @TestMetadata("invokeCallableReference.kt")
            public void testInvokeCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeCallableReference.kt");
            }

            @TestMetadata("invokeLambda.kt")
            public void testInvokeLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeLambda.kt");
            }

            @TestMetadata("invokeMemberCallableReference.kt")
            public void testInvokeMemberCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeMemberCallableReference.kt");
            }

            @TestMetadata("javaLambda.kt")
            public void testJavaLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/javaLambda.kt");
            }

            @TestMetadata("nestedBigArityFunCalls.kt")
            public void testNestedBigArityFunCalls() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/nestedBigArityFunCalls.kt");
            }

            @TestMetadata("subclass.kt")
            public void testSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/subclass.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/functionExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionExpression extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionExpression() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("functionExpression.kt")
            public void testFunctionExpression() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpression.kt");
            }

            @TestMetadata("functionExpressionWithThisReference.kt")
            public void testFunctionExpressionWithThisReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpressionWithThisReference.kt");
            }

            @TestMetadata("functionLiteralExpression.kt")
            public void testFunctionLiteralExpression() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionLiteralExpression.kt");
            }

            @TestMetadata("insideGenericLambda.kt")
            public void testInsideGenericLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/insideGenericLambda.kt");
            }

            @TestMetadata("underscoreParameters.kt")
            public void testUnderscoreParameters() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/underscoreParameters.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/invoke")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Invoke extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInvoke() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("castFunctionToExtension.kt")
            public void testCastFunctionToExtension() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/castFunctionToExtension.kt");
            }

            @TestMetadata("extensionInvokeOnExpr.kt")
            public void testExtensionInvokeOnExpr() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/extensionInvokeOnExpr.kt");
            }

            @TestMetadata("implicitInvokeInCompanionObjectWithFunctionalArgument.kt")
            public void testImplicitInvokeInCompanionObjectWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeInCompanionObjectWithFunctionalArgument.kt");
            }

            @TestMetadata("implicitInvokeWithFunctionLiteralArgument.kt")
            public void testImplicitInvokeWithFunctionLiteralArgument() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeWithFunctionLiteralArgument.kt");
            }

            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invoke.kt");
            }

            @TestMetadata("invokeOnExprByConvention.kt")
            public void testInvokeOnExprByConvention() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invokeOnExprByConvention.kt");
            }

            @TestMetadata("invokeOnSyntheticProperty.kt")
            public void testInvokeOnSyntheticProperty() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invokeOnSyntheticProperty.kt");
            }

            @TestMetadata("kt3189.kt")
            public void testKt3189() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3189.kt");
            }

            @TestMetadata("kt3190.kt")
            public void testKt3190() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3190.kt");
            }

            @TestMetadata("kt3297.kt")
            public void testKt3297() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3297.kt");
            }

            @TestMetadata("kt3450getAndInvoke.kt")
            public void testKt3450getAndInvoke() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3450getAndInvoke.kt");
            }

            @TestMetadata("kt3631invokeOnString.kt")
            public void testKt3631invokeOnString() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3631invokeOnString.kt");
            }

            @TestMetadata("kt3772.kt")
            public void testKt3772() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3772.kt");
            }

            @TestMetadata("kt3821invokeOnThis.kt")
            public void testKt3821invokeOnThis() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3821invokeOnThis.kt");
            }

            @TestMetadata("kt3822invokeOnThis.kt")
            public void testKt3822invokeOnThis() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3822invokeOnThis.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalFunctions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("boundTypeParameterInSupertype.kt")
            public void testBoundTypeParameterInSupertype() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/boundTypeParameterInSupertype.kt");
            }

            @TestMetadata("boundTypeParameterInVararg.kt")
            public void testBoundTypeParameterInVararg() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/boundTypeParameterInVararg.kt");
            }

            @TestMetadata("callBetweenLocalFunctions.kt")
            public void testCallBetweenLocalFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/callBetweenLocalFunctions.kt");
            }

            @TestMetadata("callInlineLocalInLambda.kt")
            public void testCallInlineLocalInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/callInlineLocalInLambda.kt");
            }

            @TestMetadata("captureUpperBoundedTypeParameter.kt")
            public void testCaptureUpperBoundedTypeParameter() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/captureUpperBoundedTypeParameter.kt");
            }

            @TestMetadata("definedWithinLambda.kt")
            public void testDefinedWithinLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambda.kt");
            }

            @TestMetadata("definedWithinLambdaInnerUsage1.kt")
            public void testDefinedWithinLambdaInnerUsage1() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage1.kt");
            }

            @TestMetadata("definedWithinLambdaInnerUsage2.kt")
            public void testDefinedWithinLambdaInnerUsage2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage2.kt");
            }

            @TestMetadata("kt2895.kt")
            public void testKt2895() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt2895.kt");
            }

            @TestMetadata("kt3308.kt")
            public void testKt3308() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3308.kt");
            }

            @TestMetadata("kt3978.kt")
            public void testKt3978() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978.kt");
            }

            @TestMetadata("kt3978_2.kt")
            public void testKt3978_2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978_2.kt");
            }

            @TestMetadata("kt4119.kt")
            public void testKt4119() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119.kt");
            }

            @TestMetadata("kt4119_2.kt")
            public void testKt4119_2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119_2.kt");
            }

            @TestMetadata("kt4514.kt")
            public void testKt4514() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4514.kt");
            }

            @TestMetadata("kt4777.kt")
            public void testKt4777() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4777.kt");
            }

            @TestMetadata("kt4783.kt")
            public void testKt4783() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4783.kt");
            }

            @TestMetadata("kt4784.kt")
            public void testKt4784() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4784.kt");
            }

            @TestMetadata("kt4989.kt")
            public void testKt4989() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4989.kt");
            }

            @TestMetadata("localExtensionOnNullableParameter.kt")
            public void testLocalExtensionOnNullableParameter() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localExtensionOnNullableParameter.kt");
            }

            @TestMetadata("localFunctionInConstructor.kt")
            public void testLocalFunctionInConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionInConstructor.kt");
            }

            @TestMetadata("localFunctionVsLocalVariable.kt")
            public void testLocalFunctionVsLocalVariable() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionVsLocalVariable.kt");
            }

            @TestMetadata("nameClash.kt")
            public void testNameClash() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/nameClash.kt");
            }

            @TestMetadata("nameClashAcrossDifferentContainers.kt")
            public void testNameClashAcrossDifferentContainers() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/nameClashAcrossDifferentContainers.kt");
            }

            @TestMetadata("overloadedLocalFunWithoutClosure.kt")
            public void testOverloadedLocalFunWithoutClosure() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunWithoutClosure.kt");
            }

            @TestMetadata("overloadedLocalFunction.kt")
            public void testOverloadedLocalFunction() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction.kt");
            }

            @TestMetadata("overloadedLocalFunction1.kt")
            public void testOverloadedLocalFunction1() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction1.kt");
            }

            @TestMetadata("overloadedLocalFunction2.kt")
            public void testOverloadedLocalFunction2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction2.kt");
            }

            @TestMetadata("overloadedLocalFunction3.kt")
            public void testOverloadedLocalFunction3() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction3.kt");
            }

            @TestMetadata("parameterAsDefaultValue.kt")
            public void testParameterAsDefaultValue() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/parameterAsDefaultValue.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/hashPMap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class HashPMap extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInHashPMap() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/hashPMap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("empty.kt")
        public void testEmpty() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/empty.kt");
        }

        @TestMetadata("manyNumbers.kt")
        public void testManyNumbers() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/manyNumbers.kt");
        }

        @TestMetadata("rewriteWithDifferent.kt")
        public void testRewriteWithDifferent() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/rewriteWithDifferent.kt");
        }

        @TestMetadata("rewriteWithEqual.kt")
        public void testRewriteWithEqual() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/rewriteWithEqual.kt");
        }

        @TestMetadata("simplePlusGet.kt")
        public void testSimplePlusGet() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/simplePlusGet.kt");
        }

        @TestMetadata("simplePlusMinus.kt")
        public void testSimplePlusMinus() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/simplePlusMinus.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/ieee754")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ieee754 extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInIeee754() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("anyCastToPrimitiveCompareTo1.kt")
        public void testAnyCastToPrimitiveCompareTo1() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyCastToPrimitiveCompareTo1.kt");
        }

        @TestMetadata("anyCastToPrimitiveCompareTo2.kt")
        public void testAnyCastToPrimitiveCompareTo2() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyCastToPrimitiveCompareTo2.kt");
        }

        @TestMetadata("anyToReal.kt")
        public void testAnyToReal() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyToReal.kt");
        }

        @TestMetadata("anyToReal_AgainstCompiled.kt")
        public void testAnyToReal_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyToReal_AgainstCompiled.kt");
        }

        @TestMetadata("asComparableToDouble.kt")
        public void testAsComparableToDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble.kt");
        }

        @TestMetadata("asComparableToDouble_properIeeeComparisons.kt")
        public void testAsComparableToDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("comparableToTWithT_properIeeeComparisons.kt")
        public void testComparableToTWithT_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableToTWithT_properIeeeComparisons.kt");
        }

        @TestMetadata("comparableTypeCast.kt")
        public void testComparableTypeCast() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableTypeCast.kt");
        }

        @TestMetadata("comparableTypeCast_AgainstCompiled.kt")
        public void testComparableTypeCast_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableTypeCast_AgainstCompiled.kt");
        }

        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/dataClass.kt");
        }

        @TestMetadata("differentTypesComparison.kt")
        public void testDifferentTypesComparison() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/differentTypesComparison.kt");
        }

        @TestMetadata("double.kt")
        public void testDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/double.kt");
        }

        @TestMetadata("equalsDouble.kt")
        public void testEqualsDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsDouble.kt");
        }

        @TestMetadata("equalsDouble_properIeeeComparisons.kt")
        public void testEqualsDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsFloat.kt")
        public void testEqualsFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsFloat.kt");
        }

        @TestMetadata("equalsFloat_properIeeeComparisons.kt")
        public void testEqualsFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNaN.kt")
        public void testEqualsNaN() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNaN.kt");
        }

        @TestMetadata("equalsNaN_properIeeeComparisons.kt")
        public void testEqualsNaN_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNaN_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNullableDouble.kt")
        public void testEqualsNullableDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble.kt");
        }

        @TestMetadata("equalsNullableDouble_properIeeeComparisons.kt")
        public void testEqualsNullableDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNullableFloat.kt")
        public void testEqualsNullableFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat.kt");
        }

        @TestMetadata("equalsNullableFloat_properIeeeComparisons.kt")
        public void testEqualsNullableFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("explicitCompareCall.kt")
        public void testExplicitCompareCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitCompareCall.kt");
        }

        @TestMetadata("explicitCompareCall_AgainstCompiled.kt")
        public void testExplicitCompareCall_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitCompareCall_AgainstCompiled.kt");
        }

        @TestMetadata("explicitEqualsCall.kt")
        public void testExplicitEqualsCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitEqualsCall.kt");
        }

        @TestMetadata("explicitEqualsCall_AgainstCompiled.kt")
        public void testExplicitEqualsCall_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitEqualsCall_AgainstCompiled.kt");
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/float.kt");
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/generic.kt");
        }

        @TestMetadata("generic_AgainstCompiled.kt")
        public void testGeneric_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/generic_AgainstCompiled.kt");
        }

        @TestMetadata("greaterDouble.kt")
        public void testGreaterDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterDouble.kt");
        }

        @TestMetadata("greaterDouble_properIeeeComparisons.kt")
        public void testGreaterDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("greaterFloat.kt")
        public void testGreaterFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterFloat.kt");
        }

        @TestMetadata("greaterFloat_properIeeeComparisons.kt")
        public void testGreaterFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/inline.kt");
        }

        @TestMetadata("kt48648_genericField.kt")
        public void testKt48648_genericField() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/kt48648_genericField.kt");
        }

        @TestMetadata("lessDouble.kt")
        public void testLessDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble.kt");
        }

        @TestMetadata("lessDouble_properIeeeAndNewInference.kt")
        public void testLessDouble_properIeeeAndNewInference() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeAndNewInference.kt");
        }

        @TestMetadata("lessDouble_properIeeeComparisons.kt")
        public void testLessDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("lessFloat.kt")
        public void testLessFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessFloat.kt");
        }

        @TestMetadata("lessFloat_properIeeeComparisons.kt")
        public void testLessFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("nullableAnyToReal.kt")
        public void testNullableAnyToReal() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableAnyToReal.kt");
        }

        @TestMetadata("nullableAnyToReal_AgainstCompiled.kt")
        public void testNullableAnyToReal_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableAnyToReal_AgainstCompiled.kt");
        }

        @TestMetadata("nullableDoubleEquals.kt")
        public void testNullableDoubleEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEquals.kt");
        }

        @TestMetadata("nullableDoubleEqualsLV13.kt")
        public void testNullableDoubleEqualsLV13() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEqualsLV13.kt");
        }

        @TestMetadata("nullableDoubleNotEquals.kt")
        public void testNullableDoubleNotEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleNotEquals.kt");
        }

        @TestMetadata("nullableFloatEquals.kt")
        public void testNullableFloatEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatEquals.kt");
        }

        @TestMetadata("nullableFloatNotEquals.kt")
        public void testNullableFloatNotEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatNotEquals.kt");
        }

        @TestMetadata("nullableIntEquals.kt")
        public void testNullableIntEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableIntEquals.kt");
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/safeCall.kt");
        }

        @TestMetadata("smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt")
        public void testSmartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDifferentTypes.kt")
        public void testSmartCastToDifferentTypes() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes.kt");
        }

        @TestMetadata("smartCastToDifferentTypesWithNumericPromotion.kt")
        public void testSmartCastToDifferentTypesWithNumericPromotion() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion.kt");
        }

        @TestMetadata("smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt")
        public void testSmartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDifferentTypes_properIeeeComparisons.kt")
        public void testSmartCastToDifferentTypes_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDoubleAndComparableToDouble.kt")
        public void testSmartCastToDoubleAndComparableToDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDoubleAndComparableToDouble.kt");
        }

        @TestMetadata("smartCastToInt.kt")
        public void testSmartCastToInt() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToInt.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when.kt");
        }

        @TestMetadata("whenNoSubject.kt")
        public void testWhenNoSubject() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNoSubject.kt");
        }

        @TestMetadata("whenNoSubject_properIeeeComparisons.kt")
        public void testWhenNoSubject_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNoSubject_properIeeeComparisons.kt");
        }

        @TestMetadata("whenNullableSmartCast.kt")
        public void testWhenNullableSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNullableSmartCast.kt");
        }

        @TestMetadata("when_properIeeeComparisons.kt")
        public void testWhen_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when_properIeeeComparisons.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/increment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Increment extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInIncrement() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/increment"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("argumentWithSideEffects.kt")
        public void testArgumentWithSideEffects() throws Exception {
            runTest("compiler/testData/codegen/box/increment/argumentWithSideEffects.kt");
        }

        @TestMetadata("arrayElement.kt")
        public void testArrayElement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/arrayElement.kt");
        }

        @TestMetadata("assignPlusOnSmartCast.kt")
        public void testAssignPlusOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/assignPlusOnSmartCast.kt");
        }

        @TestMetadata("augmentedAssignmentWithComplexRhs.kt")
        public void testAugmentedAssignmentWithComplexRhs() throws Exception {
            runTest("compiler/testData/codegen/box/increment/augmentedAssignmentWithComplexRhs.kt");
        }

        @TestMetadata("classNaryGetSet.kt")
        public void testClassNaryGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classNaryGetSet.kt");
        }

        @TestMetadata("classVarargGetSet.kt")
        public void testClassVarargGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classVarargGetSet.kt");
        }

        @TestMetadata("classVarargGetSetEvaluationOrder.kt")
        public void testClassVarargGetSetEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classVarargGetSetEvaluationOrder.kt");
        }

        @TestMetadata("classWithGetSet.kt")
        public void testClassWithGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classWithGetSet.kt");
        }

        @TestMetadata("extOnLong.kt")
        public void testExtOnLong() throws Exception {
            runTest("compiler/testData/codegen/box/increment/extOnLong.kt");
        }

        @TestMetadata("genericClassWithGetSet.kt")
        public void testGenericClassWithGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/genericClassWithGetSet.kt");
        }

        @TestMetadata("kt36956.kt")
        public void testKt36956() throws Exception {
            runTest("compiler/testData/codegen/box/increment/kt36956.kt");
        }

        @TestMetadata("memberExtOnLong.kt")
        public void testMemberExtOnLong() throws Exception {
            runTest("compiler/testData/codegen/box/increment/memberExtOnLong.kt");
        }

        @TestMetadata("mutableListElement.kt")
        public void testMutableListElement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/mutableListElement.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("compiler/testData/codegen/box/increment/nullable.kt");
        }

        @TestMetadata("postfixIncrementDoubleSmartCast.kt")
        public void testPostfixIncrementDoubleSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementDoubleSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnClass.kt")
        public void testPostfixIncrementOnClass() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClass.kt");
        }

        @TestMetadata("postfixIncrementOnClassSmartCast.kt")
        public void testPostfixIncrementOnClassSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClassSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnShortSmartCast.kt")
        public void testPostfixIncrementOnShortSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnShortSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnSmartCast.kt")
        public void testPostfixIncrementOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnSmartCast.kt");
        }

        @TestMetadata("postfixNullableClassIncrement.kt")
        public void testPostfixNullableClassIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixNullableClassIncrement.kt");
        }

        @TestMetadata("postfixNullableIncrement.kt")
        public void testPostfixNullableIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixNullableIncrement.kt");
        }

        @TestMetadata("prefixIncrementOnClass.kt")
        public void testPrefixIncrementOnClass() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClass.kt");
        }

        @TestMetadata("prefixIncrementOnClassSmartCast.kt")
        public void testPrefixIncrementOnClassSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClassSmartCast.kt");
        }

        @TestMetadata("prefixIncrementOnSmartCast.kt")
        public void testPrefixIncrementOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnSmartCast.kt");
        }

        @TestMetadata("prefixNullableClassIncrement.kt")
        public void testPrefixNullableClassIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixNullableClassIncrement.kt");
        }

        @TestMetadata("prefixNullableIncrement.kt")
        public void testPrefixNullableIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixNullableIncrement.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/inference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inference extends AbstractLightAnalysisModeTest {
        @TestMetadata("kt49838.kt")
        public void ignoreKt49838() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt49838.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInInference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("approximateNonTopLevelCapturedTypes.kt")
        public void testApproximateNonTopLevelCapturedTypes() throws Exception {
            runTest("compiler/testData/codegen/box/inference/approximateNonTopLevelCapturedTypes.kt");
        }

        @TestMetadata("builderInference.kt")
        public void testBuilderInference() throws Exception {
            runTest("compiler/testData/codegen/box/inference/builderInference.kt");
        }

        @TestMetadata("builderInferenceLeakingVariable.kt")
        public void testBuilderInferenceLeakingVariable() throws Exception {
            runTest("compiler/testData/codegen/box/inference/builderInferenceLeakingVariable.kt");
        }

        @TestMetadata("capturedStarProjection.kt")
        public void testCapturedStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/capturedStarProjection.kt");
        }

        @TestMetadata("capturedTypesSubstitutionIntoAbbreviation.kt")
        public void testCapturedTypesSubstitutionIntoAbbreviation() throws Exception {
            runTest("compiler/testData/codegen/box/inference/capturedTypesSubstitutionIntoAbbreviation.kt");
        }

        @TestMetadata("coercionToUnitForLambdaReturnTypeWithFlexibleConstraint.kt")
        public void testCoercionToUnitForLambdaReturnTypeWithFlexibleConstraint() throws Exception {
            runTest("compiler/testData/codegen/box/inference/coercionToUnitForLambdaReturnTypeWithFlexibleConstraint.kt");
        }

        @TestMetadata("coercionToUnitWithLastLambdaExpression.kt")
        public void testCoercionToUnitWithLastLambdaExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inference/coercionToUnitWithLastLambdaExpression.kt");
        }

        @TestMetadata("coerctionToUnitForLastExpressionWithStarProjection.kt")
        public void testCoerctionToUnitForLastExpressionWithStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/coerctionToUnitForLastExpressionWithStarProjection.kt");
        }

        @TestMetadata("earlyReturnInsideCrossinlineLambda.kt")
        public void testEarlyReturnInsideCrossinlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inference/earlyReturnInsideCrossinlineLambda.kt");
        }

        @TestMetadata("inferenceWithTypeVariableInsideCapturedType.kt")
        public void testInferenceWithTypeVariableInsideCapturedType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/inferenceWithTypeVariableInsideCapturedType.kt");
        }

        @TestMetadata("integerLiteralTypeInLamdaReturnType.kt")
        public void testIntegerLiteralTypeInLamdaReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/integerLiteralTypeInLamdaReturnType.kt");
        }

        @TestMetadata("intersectionTypeInArguments.kt")
        public void testIntersectionTypeInArguments() throws Exception {
            runTest("compiler/testData/codegen/box/inference/intersectionTypeInArguments.kt");
        }

        @TestMetadata("kt10822.kt")
        public void testKt10822() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt10822.kt");
        }

        @TestMetadata("kt26345.kt")
        public void testKt26345() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt26345.kt");
        }

        @TestMetadata("kt32429.kt")
        public void testKt32429() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt32429.kt");
        }

        @TestMetadata("kt35684.kt")
        public void testKt35684() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt35684.kt");
        }

        @TestMetadata("kt36446.kt")
        public void testKt36446() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt36446.kt");
        }

        @TestMetadata("kt38664.kt")
        public void testKt38664() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt38664.kt");
        }

        @TestMetadata("kt39824.kt")
        public void testKt39824() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt39824.kt");
        }

        @TestMetadata("kt42042.kt")
        public void testKt42042() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt42042.kt");
        }

        @TestMetadata("kt42130.kt")
        public void testKt42130() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt42130.kt");
        }

        @TestMetadata("kt45118.kt")
        public void testKt45118() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt45118.kt");
        }

        @TestMetadata("kt47316.kt")
        public void testKt47316() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt47316.kt");
        }

        @TestMetadata("kt51040.kt")
        public void testKt51040() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt51040.kt");
        }

        @TestMetadata("lambdaWithStarReturn.kt")
        public void testLambdaWithStarReturn() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lambdaWithStarReturn.kt");
        }

        @TestMetadata("lambdasWithExtensionFunctionType.kt")
        public void testLambdasWithExtensionFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lambdasWithExtensionFunctionType.kt");
        }

        @TestMetadata("lastExpressionOfLambdaWithNothingConstraint.kt")
        public void testLastExpressionOfLambdaWithNothingConstraint() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lastExpressionOfLambdaWithNothingConstraint.kt");
        }

        @TestMetadata("manyConstraintsDueToFlexibleRawTypes.kt")
        public void testManyConstraintsDueToFlexibleRawTypes() throws Exception {
            runTest("compiler/testData/codegen/box/inference/manyConstraintsDueToFlexibleRawTypes.kt");
        }

        @TestMetadata("manyFlexibleTypeParametersFromJavaAndConversions.kt")
        public void testManyFlexibleTypeParametersFromJavaAndConversions() throws Exception {
            runTest("compiler/testData/codegen/box/inference/manyFlexibleTypeParametersFromJavaAndConversions.kt");
        }

        @TestMetadata("mapCollectChainWithNullResult.kt")
        public void testMapCollectChainWithNullResult() throws Exception {
            runTest("compiler/testData/codegen/box/inference/mapCollectChainWithNullResult.kt");
        }

        @TestMetadata("noCoercionToUniForNullableLambdaReturnType.kt")
        public void testNoCoercionToUniForNullableLambdaReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/noCoercionToUniForNullableLambdaReturnType.kt");
        }

        @TestMetadata("noCoercionToUnitWithEqualityConstraintForNullableReturnType.kt")
        public void testNoCoercionToUnitWithEqualityConstraintForNullableReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/noCoercionToUnitWithEqualityConstraintForNullableReturnType.kt");
        }

        @TestMetadata("noNothingValueInsideSpecialCall.kt")
        public void testNoNothingValueInsideSpecialCall() throws Exception {
            runTest("compiler/testData/codegen/box/inference/noNothingValueInsideSpecialCall.kt");
        }

        @TestMetadata("plusAssignInsideLambda.kt")
        public void testPlusAssignInsideLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inference/plusAssignInsideLambda.kt");
        }

        @TestMetadata("recursiveConstraintInsideTypeArgumentWithStarProjection.kt")
        public void testRecursiveConstraintInsideTypeArgumentWithStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/recursiveConstraintInsideTypeArgumentWithStarProjection.kt");
        }

        @TestMetadata("referenceToCatchParameterFromLambdaExpression.kt")
        public void testReferenceToCatchParameterFromLambdaExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inference/referenceToCatchParameterFromLambdaExpression.kt");
        }

        @TestMetadata("specialCallsWithCallableReferences.kt")
        public void testSpecialCallsWithCallableReferences() throws Exception {
            runTest("compiler/testData/codegen/box/inference/specialCallsWithCallableReferences.kt");
        }

        @TestMetadata("substituteIntersectionTypeInsideCapType.kt")
        public void testSubstituteIntersectionTypeInsideCapType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/substituteIntersectionTypeInsideCapType.kt");
        }

        @TestMetadata("subtypingOfIntersectionIltInsideFlexible.kt")
        public void testSubtypingOfIntersectionIltInsideFlexible() throws Exception {
            runTest("compiler/testData/codegen/box/inference/subtypingOfIntersectionIltInsideFlexible.kt");
        }

        @TestMetadata("sumOfOverloads.kt")
        public void testSumOfOverloads() throws Exception {
            runTest("compiler/testData/codegen/box/inference/sumOfOverloads.kt");
        }

        @TestMetadata("suspendExtensionRecevierFromConstraint.kt")
        public void testSuspendExtensionRecevierFromConstraint() throws Exception {
            runTest("compiler/testData/codegen/box/inference/suspendExtensionRecevierFromConstraint.kt");
        }

        @TestMetadata("unsafeVarianceCodegen.kt")
        public void testUnsafeVarianceCodegen() throws Exception {
            runTest("compiler/testData/codegen/box/inference/unsafeVarianceCodegen.kt");
        }

        @TestMetadata("violatingUpperBoundForSelfType.kt")
        public void testViolatingUpperBoundForSelfType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/violatingUpperBoundForSelfType.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/inference/builderInference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BuilderInference extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBuilderInference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/builderInference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("builderCallAsReturnTypeInLocalClass.kt")
            public void testBuilderCallAsReturnTypeInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/builderCallAsReturnTypeInLocalClass.kt");
            }

            @TestMetadata("callableReferenceAndCoercionToUnit.kt")
            public void testCallableReferenceAndCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/callableReferenceAndCoercionToUnit.kt");
            }

            @TestMetadata("callableReferencesProperCompletion.kt")
            public void testCallableReferencesProperCompletion() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/callableReferencesProperCompletion.kt");
            }

            @TestMetadata("capturedTypes.kt")
            public void testCapturedTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/capturedTypes.kt");
            }

            @TestMetadata("changingResolveIfDontUseBuilderInferenceDisabledFeature.kt")
            public void testChangingResolveIfDontUseBuilderInferenceDisabledFeature() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/changingResolveIfDontUseBuilderInferenceDisabledFeature.kt");
            }

            @TestMetadata("commonSuperType.kt")
            public void testCommonSuperType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperType.kt");
            }

            @TestMetadata("commonSuperTypeContravariant.kt")
            public void testCommonSuperTypeContravariant() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperTypeContravariant.kt");
            }

            @TestMetadata("commonSuperTypeCovariant.kt")
            public void testCommonSuperTypeCovariant() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperTypeCovariant.kt");
            }

            @TestMetadata("commonSuperTypeInvariant.kt")
            public void testCommonSuperTypeInvariant() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperTypeInvariant.kt");
            }

            @TestMetadata("commonSuperTypeNullable.kt")
            public void testCommonSuperTypeNullable() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperTypeNullable.kt");
            }

            @TestMetadata("constraintsBetweenTwoStubVariables.kt")
            public void testConstraintsBetweenTwoStubVariables() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/constraintsBetweenTwoStubVariables.kt");
            }

            @TestMetadata("cstBasedOnTwoBuilderInferenceLambda.kt")
            public void testCstBasedOnTwoBuilderInferenceLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/cstBasedOnTwoBuilderInferenceLambda.kt");
            }

            @TestMetadata("intersect.kt")
            public void testIntersect() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/intersect.kt");
            }

            @TestMetadata("kt41164.kt")
            public void testKt41164() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt41164.kt");
            }

            @TestMetadata("kt42139.kt")
            public void testKt42139() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt42139.kt");
            }

            @TestMetadata("kt44241.kt")
            public void testKt44241() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt44241.kt");
            }

            @TestMetadata("kt45083.kt")
            public void testKt45083() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt45083.kt");
            }

            @TestMetadata("kt47052.kt")
            public void testKt47052() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt47052.kt");
            }

            @TestMetadata("kt47744.kt")
            public void testKt47744() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt47744.kt");
            }

            @TestMetadata("kt48445.kt")
            public void testKt48445() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt48445.kt");
            }

            @TestMetadata("kt48633.kt")
            public void testKt48633() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt48633.kt");
            }

            @TestMetadata("kt49887.kt")
            public void testKt49887() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt49887.kt");
            }

            @TestMetadata("kt51988.kt")
            public void testKt51988() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt51988.kt");
            }

            @TestMetadata("labaledCall.kt")
            public void testLabaledCall() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/labaledCall.kt");
            }

            @TestMetadata("lackOfNullCheckOnNullableInsideBuild.kt")
            public void testLackOfNullCheckOnNullableInsideBuild() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/lackOfNullCheckOnNullableInsideBuild.kt");
            }

            @TestMetadata("memberScope.kt")
            public void testMemberScope() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/memberScope.kt");
            }

            @TestMetadata("nullability.kt")
            public void testNullability() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/nullability.kt");
            }

            @TestMetadata("propagateInferenceSessionIntoDeclarationAnalyzers.kt")
            public void testPropagateInferenceSessionIntoDeclarationAnalyzers() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/propagateInferenceSessionIntoDeclarationAnalyzers.kt");
            }

            @TestMetadata("specialCallsWithCallableReferences.kt")
            public void testSpecialCallsWithCallableReferences() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferences.kt");
            }

            @TestMetadata("specialCallsWithCallableReferencesDontRewriteAtSlice.kt")
            public void testSpecialCallsWithCallableReferencesDontRewriteAtSlice() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferencesDontRewriteAtSlice.kt");
            }

            @TestMetadata("specialCallsWithCallableReferencesErrorType.kt")
            public void testSpecialCallsWithCallableReferencesErrorType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferencesErrorType.kt");
            }

            @TestMetadata("specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt")
            public void testSpecialCallsWithCallableReferencesNonStrictOnlyInputTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt");
            }

            @TestMetadata("specialCallsWithLambdas.kt")
            public void testSpecialCallsWithLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithLambdas.kt");
            }

            @TestMetadata("substituteStubTypeIntoCR.kt")
            public void testSubstituteStubTypeIntoCR() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substituteStubTypeIntoCR.kt");
            }

            @TestMetadata("substituteStubTypeIntolambdaParameterDescriptor.kt")
            public void testSubstituteStubTypeIntolambdaParameterDescriptor() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substituteStubTypeIntolambdaParameterDescriptor.kt");
            }

            @TestMetadata("substituteTypeVariableIntolambdaParameterDescriptor.kt")
            public void testSubstituteTypeVariableIntolambdaParameterDescriptor() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substituteTypeVariableIntolambdaParameterDescriptor.kt");
            }

            @TestMetadata("substitutelambdaExtensionReceiverType.kt")
            public void testSubstitutelambdaExtensionReceiverType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substitutelambdaExtensionReceiverType.kt");
            }

            @TestMetadata("topDownCompletionBreakedByNonBuilderInferenceSession.kt")
            public void testTopDownCompletionBreakedByNonBuilderInferenceSession() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionBreakedByNonBuilderInferenceSession.kt");
            }

            @TestMetadata("topDownCompletionWithThreeBuilderInferenceCalls.kt")
            public void testTopDownCompletionWithThreeBuilderInferenceCalls() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithThreeBuilderInferenceCalls.kt");
            }

            @TestMetadata("topDownCompletionWithThreeBuilderInferenceCallsSameLevel.kt")
            public void testTopDownCompletionWithThreeBuilderInferenceCallsSameLevel() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithThreeBuilderInferenceCallsSameLevel.kt");
            }

            @TestMetadata("topDownCompletionWithTwoBuilderInferenceCalls.kt")
            public void testTopDownCompletionWithTwoBuilderInferenceCalls() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithTwoBuilderInferenceCalls.kt");
            }

            @TestMetadata("withExpectedType.kt")
            public void testWithExpectedType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/withExpectedType.kt");
            }

            @TestMetadata("withoutAnnotation.kt")
            public void testWithoutAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/withoutAnnotation.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/inlineArgsInPlace")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineArgsInPlace extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInInlineArgsInPlace() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("arrayDequeRemoveAll.kt")
        public void testArrayDequeRemoveAll() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/arrayDequeRemoveAll.kt");
        }

        @TestMetadata("breakInArgumentExpression.kt")
        public void testBreakInArgumentExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/breakInArgumentExpression.kt");
        }

        @TestMetadata("continueInArgumentExpression.kt")
        public void testContinueInArgumentExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/continueInArgumentExpression.kt");
        }

        @TestMetadata("inlineCircularDedepency.kt")
        public void testInlineCircularDedepency() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/inlineCircularDedepency.kt");
        }

        @TestMetadata("kotlinReflect.kt")
        public void testKotlinReflect() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kotlinReflect.kt");
        }

        @TestMetadata("kt49370.kt")
        public void testKt49370() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kt49370.kt");
        }

        @TestMetadata("kt49407.kt")
        public void testKt49407() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kt49407.kt");
        }

        @TestMetadata("mapSet.kt")
        public void testMapSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/mapSet.kt");
        }

        @TestMetadata("mutableCollectionPlusAssign.kt")
        public void testMutableCollectionPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/mutableCollectionPlusAssign.kt");
        }

        @TestMetadata("noinlineParameter.kt")
        public void testNoinlineParameter() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/noinlineParameter.kt");
        }

        @TestMetadata("suspensionPointInsideArgument.kt")
        public void testSuspensionPointInsideArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/suspensionPointInsideArgument.kt");
        }

        @TestMetadata("withLogFile.kt")
        public void testWithLogFile() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/withLogFile.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineClasses extends AbstractLightAnalysisModeTest {
        @TestMetadata("anySuperCall.kt")
        public void ignoreAnySuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/anySuperCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("anySuperCallGeneric.kt")
        public void ignoreAnySuperCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/anySuperCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boundCallableReferencePassedToInlineFunctionGeneric.kt")
        public void ignoreBoundCallableReferencePassedToInlineFunctionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunctionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boundCallableReferencePassedToInlineFunctionGeneric2.kt")
        public void ignoreBoundCallableReferencePassedToInlineFunctionGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunctionGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableForFakeOverride.kt")
        public void ignoreBoxNullableForFakeOverride() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverride.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("classLiteralOnInlineClassGeneric.kt")
        public void ignoreClassLiteralOnInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classLiteralOnInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("customIterator.kt")
        public void ignoreCustomIterator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/customIterator.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksInlineClassNonNullGeneric.kt")
        public void ignoreEqualityChecksInlineClassNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksInlineClassNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedInlineClassNonNullGeneric.kt")
        public void ignoreEqualityChecksNegatedInlineClassNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedInlineClassNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderInlineClassGeneric.kt")
        public void ignoreEqualsEvaluationOrderInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassFieldHandlingGeneric.kt")
        public void ignoreInlineClassFieldHandlingGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFieldHandlingGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassWithCustomEquals.kt")
        public void ignoreInlineClassWithCustomEquals() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEquals.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassWithCustomEqualsGeneric.kt")
        public void ignoreInlineClassWithCustomEqualsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEqualsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("javaClassIntrinsicOnInlineClassesGeneric.kt")
        public void ignoreJavaClassIntrinsicOnInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaClassIntrinsicOnInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kclassInAnnotation.kt")
        public void ignoreKclassInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kclassInAnnotation.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kclassInAnnotationGeneric.kt")
        public void ignoreKclassInAnnotationGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kclassInAnnotationGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096Generic.kt")
        public void ignoreKt27096Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_enumGeneric.kt")
        public void ignoreKt27096_enumGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_enumGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_nullablePrimitiveGeneric.kt")
        public void ignoreKt27096_nullablePrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_nullablePrimitiveGeneric2.kt")
        public void ignoreKt27096_nullablePrimitiveGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitiveGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_nullableReferenceGeneric.kt")
        public void ignoreKt27096_nullableReferenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReferenceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_nullableReferenceGeneric2.kt")
        public void ignoreKt27096_nullableReferenceGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReferenceGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_primitiveGeneric.kt")
        public void ignoreKt27096_primitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_primitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_referenceGeneric.kt")
        public void ignoreKt27096_referenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_referenceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27132Generic.kt")
        public void ignoreKt27132Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27132Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt31994.kt")
        public void ignoreKt31994() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt31994.kt");
        }

        @TestMetadata("kt32793.kt")
        public void ignoreKt32793() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt32793.kt");
        }

        @TestMetadata("kt44701_jvmOverloads.kt")
        public void ignoreKt44701_jvmOverloads() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44701_jvmOverloads.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt44701_jvmOverloadsGeneric.kt")
        public void ignoreKt44701_jvmOverloadsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44701_jvmOverloadsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt44701_jvmOverloadsGeneric2.kt")
        public void ignoreKt44701_jvmOverloadsGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44701_jvmOverloadsGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt44867.kt")
        public void ignoreKt44867() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44867.kt");
        }

        @TestMetadata("kt44978.kt")
        public void ignoreKt44978() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44978.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt45991.kt")
        public void ignoreKt45991() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45991.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("mappingOfBoxedFlexibleInlineClassTypeGeneric.kt")
        public void ignoreMappingOfBoxedFlexibleInlineClassTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mappingOfBoxedFlexibleInlineClassTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("nullableWrapperEqualityGeneric.kt")
        public void ignoreNullableWrapperEqualityGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEqualityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("nullableWrapperEqualityGeneric2.kt")
        public void ignoreNullableWrapperEqualityGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEqualityGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("privateConstructorFunInterfaceMultiModuleGeneric.kt")
        public void ignorePrivateConstructorFunInterfaceMultiModuleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/privateConstructorFunInterfaceMultiModuleGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("safeAsOfTypeParameterWithInlineClassBound.kt")
        public void ignoreSafeAsOfTypeParameterWithInlineClassBound() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/safeAsOfTypeParameterWithInlineClassBound.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("safeAsOfTypeParameterWithInlineClassBoundGeneric.kt")
        public void ignoreSafeAsOfTypeParameterWithInlineClassBoundGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/safeAsOfTypeParameterWithInlineClassBoundGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("simpleSecondaryConstructor.kt")
        public void ignoreSimpleSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/simpleSecondaryConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("simpleSecondaryConstructorGeneric.kt")
        public void ignoreSimpleSecondaryConstructorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/simpleSecondaryConstructorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("toStringOfUnboxedNullable.kt")
        public void ignoreToStringOfUnboxedNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringOfUnboxedNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("toStringOfUnboxedNullableGeneric.kt")
        public void ignoreToStringOfUnboxedNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringOfUnboxedNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
            KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @TestMetadata("annotatedMemberExtensionProperty.kt")
        public void testAnnotatedMemberExtensionProperty() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/annotatedMemberExtensionProperty.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("annotatedMemberExtensionPropertyGeneric.kt")
        public void testAnnotatedMemberExtensionPropertyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/annotatedMemberExtensionPropertyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boundCallableReferencePassedToInlineFunction.kt")
        public void testBoundCallableReferencePassedToInlineFunction() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunction.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxImplDoesNotExecuteInSecondaryConstructor.kt")
        public void testBoxImplDoesNotExecuteInSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInSecondaryConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxImplDoesNotExecuteInSecondaryConstructorGeneric.kt")
        public void testBoxImplDoesNotExecuteInSecondaryConstructorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInSecondaryConstructorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxImplDoesNotExecuteInitBlock.kt")
        public void testBoxImplDoesNotExecuteInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInitBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxImplDoesNotExecuteInitBlockGeneric.kt")
        public void testBoxImplDoesNotExecuteInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInitBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableForFakeOverrideGeneric.kt")
        public void testBoxNullableForFakeOverrideGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverrideGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableForFakeOverrideGeneric2.kt")
        public void testBoxNullableForFakeOverrideGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverrideGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxResultInlineClassOfConstructorCall.kt")
        public void testBoxResultInlineClassOfConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxResultInlineClassOfConstructorCallGeneric.kt")
        public void testBoxResultInlineClassOfConstructorCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxResultInlineClassOfConstructorCallGeneric2.kt")
        public void testBoxResultInlineClassOfConstructorCallGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCallGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSet.kt")
        public void testBoxUnboxInlineClassesWithOperatorsGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSet.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSetGeneric.kt")
        public void testBoxUnboxInlineClassesWithOperatorsGetSetGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSetGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxUnboxOfInlineClassForCapturedVars.kt")
        public void testBoxUnboxOfInlineClassForCapturedVars() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVars.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("boxUnboxOfInlineClassForCapturedVarsGeneric.kt")
        public void testBoxUnboxOfInlineClassForCapturedVarsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVarsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("bridgeForFunctionReturningInlineClass.kt")
        public void testBridgeForFunctionReturningInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("bridgeForFunctionReturningInlineClassGeneric.kt")
        public void testBridgeForFunctionReturningInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("bridgeGenerationWithInlineClassOverAny.kt")
        public void testBridgeGenerationWithInlineClassOverAny() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("bridgeGenerationWithInlineClassOverAnyGeneric.kt")
        public void testBridgeGenerationWithInlineClassOverAnyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("bridgeGenerationWithInlineClassOverAnyGeneric2.kt")
        public void testBridgeGenerationWithInlineClassOverAnyGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAnyGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("bridgesWhenInlineClassImplementsGenericInterface.kt")
        public void testBridgesWhenInlineClassImplementsGenericInterface() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterface.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("bridgesWhenInlineClassImplementsGenericInterfaceGeneric.kt")
        public void testBridgesWhenInlineClassImplementsGenericInterfaceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterfaceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("callComputablePropertyInsideInlineClass.kt")
        public void testCallComputablePropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callComputablePropertyInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("callSpecializedEqualsViaReflection.kt")
        public void testCallSpecializedEqualsViaReflection() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpecializedEqualsViaReflection.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("callSpecializedEqualsViaReflectionGeneric.kt")
        public void testCallSpecializedEqualsViaReflectionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpecializedEqualsViaReflectionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("callSpeciallyOverriddenPropertyOfInlineClass.kt")
        public void testCallSpeciallyOverriddenPropertyOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpeciallyOverriddenPropertyOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("callSpeciallyOverriddenPropertyOfInlineClassGeneric.kt")
        public void testCallSpeciallyOverriddenPropertyOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpeciallyOverriddenPropertyOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("callableReferencesWithInlineClasses.kt")
        public void testCallableReferencesWithInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("callableReferencesWithInlineClassesGeneric.kt")
        public void testCallableReferencesWithInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("castInsideWhenExpression.kt")
        public void testCastInsideWhenExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpression.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("castInsideWhenExpressionGeneric.kt")
        public void testCastInsideWhenExpressionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpressionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctions.kt")
        public void testCheckBoxUnboxOfArgumentsOnInlinedFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctionsGeneric.kt")
        public void testCheckBoxUnboxOfArgumentsOnInlinedFunctionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingAfterAssertionOperator.kt")
        public void testCheckBoxingAfterAssertionOperator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperator.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingAfterAssertionOperatorGeneric.kt")
        public void testCheckBoxingAfterAssertionOperatorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperatorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingForComplexClassHierarchy.kt")
        public void testCheckBoxingForComplexClassHierarchy() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchy.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingForComplexClassHierarchyGeneric.kt")
        public void testCheckBoxingForComplexClassHierarchyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingForNonLocalAndLabeledReturns.kt")
        public void testCheckBoxingForNonLocalAndLabeledReturns() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturns.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingForNonLocalAndLabeledReturnsGeneric.kt")
        public void testCheckBoxingForNonLocalAndLabeledReturnsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturnsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingFromReturnTypeForInlineClasses.kt")
        public void testCheckBoxingFromReturnTypeForInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingFromReturnTypeForInlineClassesGeneric.kt")
        public void testCheckBoxingFromReturnTypeForInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingOnFunctionCalls.kt")
        public void testCheckBoxingOnFunctionCalls() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCalls.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingOnFunctionCallsGeneric.kt")
        public void testCheckBoxingOnFunctionCallsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCallsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingOnLocalVariableAssignments.kt")
        public void testCheckBoxingOnLocalVariableAssignments() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignments.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingOnLocalVariableAssignmentsGeneric.kt")
        public void testCheckBoxingOnLocalVariableAssignmentsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignmentsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt")
        public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric.kt")
        public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkCallingMembersInsideInlineClass.kt")
        public void testCheckCallingMembersInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkCallingMembersInsideInlineClassGeneric.kt")
        public void testCheckCallingMembersInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkCastToInlineClass.kt")
        public void testCheckCastToInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkCastToInlineClassGeneric.kt")
        public void testCheckCastToInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkForInstanceOfInlineClass.kt")
        public void testCheckForInstanceOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkForInstanceOfInlineClassGeneric.kt")
        public void testCheckForInstanceOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkLambdaWithInlineClassesInFunctionalType.kt")
        public void testCheckLambdaWithInlineClassesInFunctionalType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkLambdaWithInlineClassesInFunctionalTypeGeneric.kt")
        public void testCheckLambdaWithInlineClassesInFunctionalTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkUnboxingResultFromTypeVariable.kt")
        public void testCheckUnboxingResultFromTypeVariable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkUnboxingResultFromTypeVariableGeneric.kt")
        public void testCheckUnboxingResultFromTypeVariableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("checkUnboxingResultFromTypeVariableGeneric2.kt")
        public void testCheckUnboxingResultFromTypeVariableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("classInInlineClassInit.kt")
        public void testClassInInlineClassInit() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classInInlineClassInit.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("classInInlineClassInitGeneric.kt")
        public void testClassInInlineClassInitGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classInInlineClassInitGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("classLiteralOnInlineClass.kt")
        public void testClassLiteralOnInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classLiteralOnInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("computablePropertyInsideInlineClass.kt")
        public void testComputablePropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/computablePropertyInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("conformToComparableAndCallInterfaceMethod.kt")
        public void testConformToComparableAndCallInterfaceMethod() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethod.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("conformToComparableAndCallInterfaceMethodGeneric.kt")
        public void testConformToComparableAndCallInterfaceMethodGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethodGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("constructorCallableReference.kt")
        public void testConstructorCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorCallableReference.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("constructorCallableReferenceGeneric.kt")
        public void testConstructorCallableReferenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorCallableReferenceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("constructorImplVisibility.kt")
        public void testConstructorImplVisibility() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorImplVisibility.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("constructorImplVisibilityGeneric.kt")
        public void testConstructorImplVisibilityGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorImplVisibilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("correctBoxingForBranchExpressions.kt")
        public void testCorrectBoxingForBranchExpressions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("correctBoxingForBranchExpressionsGeneric.kt")
        public void testCorrectBoxingForBranchExpressionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("createInlineClassInArgumentPosition.kt")
        public void testCreateInlineClassInArgumentPosition() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPosition.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("createInlineClassInArgumentPositionGeneric.kt")
        public void testCreateInlineClassInArgumentPositionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPositionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("crossinlineWithInlineClassInParameter.kt")
        public void testCrossinlineWithInlineClassInParameter() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameter.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("crossinlineWithInlineClassInParameterGeneric.kt")
        public void testCrossinlineWithInlineClassInParameterGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameterGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("crossinlineWithInlineClassInParameterGeneric2.kt")
        public void testCrossinlineWithInlineClassInParameterGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameterGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("defaultFunctionsFromAnyForInlineClass.kt")
        public void testDefaultFunctionsFromAnyForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("defaultFunctionsFromAnyForInlineClassGeneric.kt")
        public void testDefaultFunctionsFromAnyForInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("defaultInterfaceMethodsInInlineClass.kt")
        public void testDefaultInterfaceMethodsInInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultInterfaceMethodsInInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("defaultInterfaceMethodsInInlineClassGeneric.kt")
        public void testDefaultInterfaceMethodsInInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultInterfaceMethodsInInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("defaultWithInlineClassArgument.kt")
        public void testDefaultWithInlineClassArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultWithInlineClassArgument.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("defaultWithInlineClassArgumentGeneric.kt")
        public void testDefaultWithInlineClassArgumentGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultWithInlineClassArgumentGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("elvisWithInlineClassAndNullConstant.kt")
        public void testElvisWithInlineClassAndNullConstant() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstant.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("elvisWithInlineClassAndNullConstantGeneric.kt")
        public void testElvisWithInlineClassAndNullConstantGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstantGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("emptyConstructorForInlineClass.kt")
        public void testEmptyConstructorForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("emptyConstructorForInlineClassGeneric.kt")
        public void testEmptyConstructorForInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksInlineClassNonNull.kt")
        public void testEqualityChecksInlineClassNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksInlineClassNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksMixedNullability.kt")
        public void testEqualityChecksMixedNullability() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksMixedNullability.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksMixedNullabilityGeneric.kt")
        public void testEqualityChecksMixedNullabilityGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksMixedNullabilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedInlineClassNonNull.kt")
        public void testEqualityChecksNegatedInlineClassNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedInlineClassNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedNonNull.kt")
        public void testEqualityChecksNegatedNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedNonNullGeneric.kt")
        public void testEqualityChecksNegatedNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedNullable.kt")
        public void testEqualityChecksNegatedNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedNullableGeneric.kt")
        public void testEqualityChecksNegatedNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedNullableGeneric2.kt")
        public void testEqualityChecksNegatedNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedPrimitive.kt")
        public void testEqualityChecksNegatedPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNegatedPrimitiveGeneric.kt")
        public void testEqualityChecksNegatedPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNonNull.kt")
        public void testEqualityChecksNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNonNullGeneric.kt")
        public void testEqualityChecksNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNullable.kt")
        public void testEqualityChecksNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNullableGeneric.kt")
        public void testEqualityChecksNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksNullableGeneric2.kt")
        public void testEqualityChecksNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksPrimitive.kt")
        public void testEqualityChecksPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityChecksPrimitiveGeneric.kt")
        public void testEqualityChecksPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClass.kt")
        public void testEqualityForBoxesOfNullableValuesOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClassGeneric.kt")
        public void testEqualityForBoxesOfNullableValuesOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsCallsLeftArgument.kt")
        public void testEqualsCallsLeftArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsCallsLeftArgument.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsCallsLeftArgumentGeneric.kt")
        public void testEqualsCallsLeftArgumentGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsCallsLeftArgumentGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderInlineClass.kt")
        public void testEqualsEvaluationOrderInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderNonNull.kt")
        public void testEqualsEvaluationOrderNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderNonNullGeneric.kt")
        public void testEqualsEvaluationOrderNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderNullable.kt")
        public void testEqualsEvaluationOrderNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderNullableGeneric.kt")
        public void testEqualsEvaluationOrderNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderNullableGeneric2.kt")
        public void testEqualsEvaluationOrderNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderPrimitive.kt")
        public void testEqualsEvaluationOrderPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsEvaluationOrderPrimitiveGeneric.kt")
        public void testEqualsEvaluationOrderPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsOperatorWithGenericCall.kt")
        public void testEqualsOperatorWithGenericCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("equalsOperatorWithGenericCallGeneric.kt")
        public void testEqualsOperatorWithGenericCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("extLambdaInInlineClassFun.kt")
        public void testExtLambdaInInlineClassFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("extLambdaInInlineClassFun2.kt")
        public void testExtLambdaInInlineClassFun2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("extLambdaInInlineClassFun2Generic.kt")
        public void testExtLambdaInInlineClassFun2Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("extLambdaInInlineClassFunGeneric.kt")
        public void testExtLambdaInInlineClassFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("fieldNameClash.kt")
        public void testFieldNameClash() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/fieldNameClash.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("fieldNameClashGeneric.kt")
        public void testFieldNameClashGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/fieldNameClashGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("funInterfaceDoubleSuffux.kt")
        public void testFunInterfaceDoubleSuffux() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/funInterfaceDoubleSuffux.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("funInterfaceDoubleSuffux2.kt")
        public void testFunInterfaceDoubleSuffux2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/funInterfaceDoubleSuffux2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/functionExpression.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("functionExpressionGeneric.kt")
        public void testFunctionExpressionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/functionExpressionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("genericInlineClassSynthMembers.kt")
        public void testGenericInlineClassSynthMembers() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/genericInlineClassSynthMembers.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("genericVararg2ndConstructor.kt")
        public void testGenericVararg2ndConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/genericVararg2ndConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("initBlock.kt")
        public void testInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/initBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("initBlockGeneric.kt")
        public void testInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/initBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassAsLastExpressionInInLambda.kt")
        public void testInlineClassAsLastExpressionInInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassAsLastExpressionInInLambdaGeneric.kt")
        public void testInlineClassAsLastExpressionInInLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt")
        public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointData() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric.kt")
        public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassFieldHandling.kt")
        public void testInlineClassFieldHandling() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFieldHandling.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassFunctionInvoke.kt")
        public void testInlineClassFunctionInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvoke.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassFunctionInvokeGeneric.kt")
        public void testInlineClassFunctionInvokeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvokeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassImplementsCollection.kt")
        public void testInlineClassImplementsCollection() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassImplementsCollection.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassImplementsCollectionGeneric.kt")
        public void testInlineClassImplementsCollectionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassImplementsCollectionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassInInitBlock.kt")
        public void testInlineClassInInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInInitBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassInInitBlockGeneric.kt")
        public void testInlineClassInInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInInitBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassInStringTemplate.kt")
        public void testInlineClassInStringTemplate() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplate.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassInStringTemplateGeneric.kt")
        public void testInlineClassInStringTemplateGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplateGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassPropertyReferenceGetAndSet.kt")
        public void testInlineClassPropertyReferenceGetAndSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSet.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassPropertyReferenceGetAndSetGeneric.kt")
        public void testInlineClassPropertyReferenceGetAndSetGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSetGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassValueCapturedInInlineLambda.kt")
        public void testInlineClassValueCapturedInInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassValueCapturedInInlineLambdaGeneric.kt")
        public void testInlineClassValueCapturedInInlineLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassValueCapturedInNonInlineLambda.kt")
        public void testInlineClassValueCapturedInNonInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassValueCapturedInNonInlineLambdaGeneric.kt")
        public void testInlineClassValueCapturedInNonInlineLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassValuesInsideStrings.kt")
        public void testInlineClassValuesInsideStrings() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStrings.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassValuesInsideStringsGeneric.kt")
        public void testInlineClassValuesInsideStringsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStringsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassWithDefaultFunctionsFromAny.kt")
        public void testInlineClassWithDefaultFunctionsFromAny() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassWithDefaultFunctionsFromAnyGeneric.kt")
        public void testInlineClassWithDefaultFunctionsFromAnyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassesAsInlineFunParameters.kt")
        public void testInlineClassesAsInlineFunParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassesAsInlineFunParametersGeneric.kt")
        public void testInlineClassesAsInlineFunParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassesCheckCast.kt")
        public void testInlineClassesCheckCast() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCast.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassesCheckCastGeneric.kt")
        public void testInlineClassesCheckCastGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCastGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassesInInlineLambdaParameters.kt")
        public void testInlineClassesInInlineLambdaParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassesInInlineLambdaParametersGeneric.kt")
        public void testInlineClassesInInlineLambdaParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassesRefTypesInInlineLambdaParameters.kt")
        public void testInlineClassesRefTypesInInlineLambdaParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineClassesRefTypesInInlineLambdaParametersGeneric.kt")
        public void testInlineClassesRefTypesInInlineLambdaParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineExtLambdaInInlineClassFun.kt")
        public void testInlineExtLambdaInInlineClassFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineExtLambdaInInlineClassFun2.kt")
        public void testInlineExtLambdaInInlineClassFun2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineExtLambdaInInlineClassFun2Generic.kt")
        public void testInlineExtLambdaInInlineClassFun2Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineExtLambdaInInlineClassFunGeneric.kt")
        public void testInlineExtLambdaInInlineClassFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineFunctionInsideInlineClass.kt")
        public void testInlineFunctionInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("inlineFunctionInsideInlineClassGeneric.kt")
        public void testInlineFunctionInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("iterateOverArrayOfInlineClassValues.kt")
        public void testIterateOverArrayOfInlineClassValues() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValues.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("iterateOverArrayOfInlineClassValuesGeneric.kt")
        public void testIterateOverArrayOfInlineClassValuesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValuesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("iterateOverListOfInlineClassValues.kt")
        public void testIterateOverListOfInlineClassValues() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValues.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("iterateOverListOfInlineClassValuesGeneric.kt")
        public void testIterateOverListOfInlineClassValuesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValuesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("javaClassIntrinsicOnInlineClasses.kt")
        public void testJavaClassIntrinsicOnInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaClassIntrinsicOnInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("javaPrimitiveTypeIC.kt")
        public void testJavaPrimitiveTypeIC() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaPrimitiveTypeIC.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("javaPrimitiveTypeICGeneric.kt")
        public void testJavaPrimitiveTypeICGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaPrimitiveTypeICGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmFieldInInlineClassCompanion.kt")
        public void testJvmFieldInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmFieldInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmFieldInInlineClassCompanionGeneric.kt")
        public void testJvmFieldInInlineClassCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmFieldInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmInline.kt")
        public void testJvmInline() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmInline.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
        public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValue() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmOverloadsOnTopLevelFunctionReturningInlineClassValueGeneric.kt")
        public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValueGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValueGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmStaticFunInInlineClassCompanion.kt")
        public void testJvmStaticFunInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticFunInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmStaticFunInInlineClassCompanionGeneric.kt")
        public void testJvmStaticFunInInlineClassCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticFunInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmStaticPropertyAccessorInInlineClassCompanion.kt")
        public void testJvmStaticPropertyAccessorInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticPropertyAccessorInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmStaticPropertyAccessorInInlineClassCompanionGeneric.kt")
        public void testJvmStaticPropertyAccessorInInlineClassCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticPropertyAccessorInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmStaticVarInInlineClassCompanion.kt")
        public void testJvmStaticVarInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticVarInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("jvmStaticVarInInlineClassCompanionGeneric.kt")
        public void testJvmStaticVarInInlineClassCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticVarInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt25246.kt")
        public void testKt25246() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25246.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt25750.kt")
        public void testKt25750() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25750.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt25750Generic.kt")
        public void testKt25750Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25750Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt25771.kt")
        public void testKt25771() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25771.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt26103.kt")
        public void testKt26103() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt26103_contravariantUnderlyingType.kt")
        public void testKt26103_contravariantUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_contravariantUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt26103_covariantUnderlyingType.kt")
        public void testKt26103_covariantUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_covariantUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt26103_original.kt")
        public void testKt26103_original() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_original.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096.kt")
        public void testKt27096() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_enum.kt")
        public void testKt27096_enum() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_enum.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_functional.kt")
        public void testKt27096_functional() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_functional.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_functionalGeneric.kt")
        public void testKt27096_functionalGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_functionalGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_innerClass.kt")
        public void testKt27096_innerClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_innerClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_nullablePrimitive.kt")
        public void testKt27096_nullablePrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_nullableReference.kt")
        public void testKt27096_nullableReference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReference.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_primitive.kt")
        public void testKt27096_primitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_primitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27096_reference.kt")
        public void testKt27096_reference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_reference.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27113.kt")
        public void testKt27113() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27113a.kt")
        public void testKt27113a() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113a.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27113aGeneric.kt")
        public void testKt27113aGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113aGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27132.kt")
        public void testKt27132() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27132.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27140.kt")
        public void testKt27140() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27140.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27140Generic.kt")
        public void testKt27140Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27140Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27705.kt")
        public void testKt27705() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27705.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27705Generic.kt")
        public void testKt27705Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27705Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27706.kt")
        public void testKt27706() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27706.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt27706Generic.kt")
        public void testKt27706Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27706Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt28405.kt")
        public void testKt28405() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28405.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt28585.kt")
        public void testKt28585() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28585.kt");
        }

        @TestMetadata("kt28879.kt")
        public void testKt28879() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28879.kt");
        }

        @TestMetadata("kt28920_javaObjectType.kt")
        public void testKt28920_javaObjectType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28920_javaObjectType.kt");
        }

        @TestMetadata("kt28920_javaPrimitiveType.kt")
        public void testKt28920_javaPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28920_javaPrimitiveType.kt");
        }

        @TestMetadata("kt33119.kt")
        public void testKt33119() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt33119.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt33119Generic.kt")
        public void testKt33119Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt33119Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt34268.kt")
        public void testKt34268() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt34268.kt");
        }

        @TestMetadata("kt34902.kt")
        public void testKt34902() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt34902.kt");
        }

        @TestMetadata("kt37998.kt")
        public void testKt37998() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt37998.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt37998Generic.kt")
        public void testKt37998Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt37998Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt38680.kt")
        public void testKt38680() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt38680Generic.kt")
        public void testKt38680Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt38680a.kt")
        public void testKt38680a() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680a.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt38680aGeneric.kt")
        public void testKt38680aGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680aGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt38680b.kt")
        public void testKt38680b() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680b.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt38680bGeneric.kt")
        public void testKt38680bGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680bGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt44141.kt")
        public void testKt44141() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44141.kt");
        }

        @TestMetadata("kt45084.kt")
        public void testKt45084() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45084.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt45084Generic.kt")
        public void testKt45084Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45084Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt46554.kt")
        public void testKt46554() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt46554.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt46554Generic.kt")
        public void testKt46554Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt46554Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt47609.kt")
        public void testKt47609() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt47609.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt47762.kt")
        public void testKt47762() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt47762.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt47762Generic.kt")
        public void testKt47762Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt47762Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt48993.kt")
        public void testKt48993() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt48993.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt48993Generic.kt")
        public void testKt48993Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt48993Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt51157.kt")
        public void testKt51157() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51157.kt");
        }

        @TestMetadata("kt51254.kt")
        public void testKt51254() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51254.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("kt51353.kt")
        public void testKt51353() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51353.kt");
        }

        @TestMetadata("kt51672.kt")
        public void testKt51672() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51672.kt");
        }

        @TestMetadata("mangledDefaultParameterFunction.kt")
        public void testMangledDefaultParameterFunction() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledDefaultParameterFunction.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("mangledDefaultParameterFunctionGeneric.kt")
        public void testMangledDefaultParameterFunctionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledDefaultParameterFunctionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("mangledSuperCalls.kt")
        public void testMangledSuperCalls() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledSuperCalls.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("mangledSuperCallsGeneric.kt")
        public void testMangledSuperCallsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledSuperCallsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("mapInlineClassesWithSuppressWildcardsMode.kt")
        public void testMapInlineClassesWithSuppressWildcardsMode() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mapInlineClassesWithSuppressWildcardsMode.kt");
        }

        @TestMetadata("mappingOfBoxedFlexibleInlineClassType.kt")
        public void testMappingOfBoxedFlexibleInlineClassType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mappingOfBoxedFlexibleInlineClassType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("multifileClass.kt")
        public void testMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/multifileClass.kt");
        }

        @TestMetadata("nestedInlineClass.kt")
        public void testNestedInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nestedInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("nestedInlineClassGeneric.kt")
        public void testNestedInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nestedInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("noAssertionsOnInlineClassBasedOnNullableType.kt")
        public void testNoAssertionsOnInlineClassBasedOnNullableType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noAssertionsOnInlineClassBasedOnNullableType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("noAssertionsOnInlineClassBasedOnNullableTypeGeneric.kt")
        public void testNoAssertionsOnInlineClassBasedOnNullableTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noAssertionsOnInlineClassBasedOnNullableTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("noReturnTypeMangling.kt")
        public void testNoReturnTypeMangling() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeMangling.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("noReturnTypeManglingGeneric.kt")
        public void testNoReturnTypeManglingGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeManglingGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("noReturnTypeManglingJvmName.kt")
        public void testNoReturnTypeManglingJvmName() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeManglingJvmName.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("noReturnTypeManglingJvmNameGeneric.kt")
        public void testNoReturnTypeManglingJvmNameGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeManglingJvmNameGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("nullableEqeqNonNull.kt")
        public void testNullableEqeqNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableEqeqNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("nullableEqeqNonNullGeneric.kt")
        public void testNullableEqeqNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableEqeqNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("nullableWrapperEquality.kt")
        public void testNullableWrapperEquality() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEquality.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("overrideReturnNothing.kt")
        public void testOverrideReturnNothing() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overrideReturnNothing.kt");
        }

        @TestMetadata("overridingFunCallingPrivateFun.kt")
        public void testOverridingFunCallingPrivateFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overridingFunCallingPrivateFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("overridingFunCallingPrivateFunGeneric.kt")
        public void testOverridingFunCallingPrivateFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overridingFunCallingPrivateFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("passInlineClassAsVararg.kt")
        public void testPassInlineClassAsVararg() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassAsVararg.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("passInlineClassAsVarargGeneric.kt")
        public void testPassInlineClassAsVarargGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassAsVarargGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("passInlineClassWithSpreadOperatorToVarargs.kt")
        public void testPassInlineClassWithSpreadOperatorToVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassWithSpreadOperatorToVarargs.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("passInlineClassWithSpreadOperatorToVarargsGeneric.kt")
        public void testPassInlineClassWithSpreadOperatorToVarargsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassWithSpreadOperatorToVarargsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("privateConstructorFunInterfaceMultiModule.kt")
        public void testPrivateConstructorFunInterfaceMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/privateConstructorFunInterfaceMultiModule.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("propertyLoweringOrder.kt")
        public void testPropertyLoweringOrder() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/propertyLoweringOrder.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("propertyLoweringOrderGeneric.kt")
        public void testPropertyLoweringOrderGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/propertyLoweringOrderGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("referToPropertyInCompanionObjectOfInlineClass.kt")
        public void testReferToPropertyInCompanionObjectOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToPropertyInCompanionObjectOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("referToPropertyInCompanionObjectOfInlineClassGeneric.kt")
        public void testReferToPropertyInCompanionObjectOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToPropertyInCompanionObjectOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("referToUnderlyingPropertyInsideInlineClass.kt")
        public void testReferToUnderlyingPropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("referToUnderlyingPropertyInsideInlineClassGeneric.kt")
        public void testReferToUnderlyingPropertyInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("referToUnderlyingPropertyOfInlineClass.kt")
        public void testReferToUnderlyingPropertyOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("referToUnderlyingPropertyOfInlineClassGeneric.kt")
        public void testReferToUnderlyingPropertyOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("removeInInlineCollectionOfInlineClassAsInt.kt")
        public void testRemoveInInlineCollectionOfInlineClassAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/removeInInlineCollectionOfInlineClassAsInt.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("result.kt")
        public void testResult() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/result.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("resultGeneric.kt")
        public void testResultGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("resultGeneric2.kt")
        public void testResultGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("resultInlining.kt")
        public void testResultInlining() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultInlining.kt");
        }

        @TestMetadata("resultRunCatchingOrElse.kt")
        public void testResultRunCatchingOrElse() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultRunCatchingOrElse.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("samWrapperDifferentModule.kt")
        public void testSamWrapperDifferentModule() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/samWrapperDifferentModule.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("samWrapperDifferentModuleGeneric.kt")
        public void testSamWrapperDifferentModuleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/samWrapperDifferentModuleGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("secondaryConstructorWithVararg.kt")
        public void testSecondaryConstructorWithVararg() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorWithVararg.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("secondaryConstructorWithVarargGeneric.kt")
        public void testSecondaryConstructorWithVarargGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorWithVarargGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("secondaryConstructorsInsideInlineClass.kt")
        public void testSecondaryConstructorsInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("secondaryConstructorsInsideInlineClassGeneric.kt")
        public void testSecondaryConstructorsInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("secondaryConstructorsInsideInlineClassWithPrimitiveCarrierType.kt")
        public void testSecondaryConstructorsInsideInlineClassWithPrimitiveCarrierType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassWithPrimitiveCarrierType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("secondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric.kt")
        public void testSecondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("smartCastOnThisOfInlineClassType.kt")
        public void testSmartCastOnThisOfInlineClassType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/smartCastOnThisOfInlineClassType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("smartCastOnThisOfInlineClassTypeGeneric.kt")
        public void testSmartCastOnThisOfInlineClassTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/smartCastOnThisOfInlineClassTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("stringPlus.kt")
        public void testStringPlus() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/stringPlus.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("stringPlusGeneric.kt")
        public void testStringPlusGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/stringPlusGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("toStringCallingPrivateFun.kt")
        public void testToStringCallingPrivateFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringCallingPrivateFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("toStringCallingPrivateFunGeneric.kt")
        public void testToStringCallingPrivateFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringCallingPrivateFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("typeChecksForInlineClasses.kt")
        public void testTypeChecksForInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/typeChecksForInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("typeChecksForInlineClassesGeneric.kt")
        public void testTypeChecksForInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/typeChecksForInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("UIntArraySortExample.kt")
        public void testUIntArraySortExample() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntArraySortExample.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("UIntArraySortExampleGeneric.kt")
        public void testUIntArraySortExampleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntArraySortExampleGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("UIntSafeAsInt.kt")
        public void testUIntSafeAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntSafeAsInt.kt");
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithNonNullUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNonNullUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI.kt")
        public void testUnboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2.kt")
        public void testUnboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithPrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxParameterOfSuspendLambdaBeforeInvoke.kt")
        public void testUnboxParameterOfSuspendLambdaBeforeInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxParameterOfSuspendLambdaBeforeInvoke.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxParameterOfSuspendLambdaBeforeInvokeGeneric.kt")
        public void testUnboxParameterOfSuspendLambdaBeforeInvokeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxParameterOfSuspendLambdaBeforeInvokeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxReceiverOnCallingMethodFromInlineClass.kt")
        public void testUnboxReceiverOnCallingMethodFromInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxReceiverOnCallingMethodFromInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxReceiverOnCallingMethodFromInlineClassGeneric.kt")
        public void testUnboxReceiverOnCallingMethodFromInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxReceiverOnCallingMethodFromInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxResultParameterWhenCapturingToCrossinlineLambda.kt")
        public void testUnboxResultParameterWhenCapturingToCrossinlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxResultParameterWhenCapturingToCrossinlineLambda.kt");
        }

        @TestMetadata("unboxValueFromPlatformType.kt")
        public void testUnboxValueFromPlatformType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueFromPlatformType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxValueFromPlatformTypeGeneric.kt")
        public void testUnboxValueFromPlatformTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueFromPlatformTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxValueOfAnyBeforeMethodInvocation.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocation() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocation.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxValueOfAnyBeforeMethodInvocationGeneric.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocationGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocationGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("unboxValueOfAnyBeforeMethodInvocationGeneric2.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocationGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocationGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("useInlineClassesInsideElvisOperator.kt")
        public void testUseInlineClassesInsideElvisOperator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineClassesInsideElvisOperator.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("useInlineClassesInsideElvisOperatorGeneric.kt")
        public void testUseInlineClassesInsideElvisOperatorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineClassesInsideElvisOperatorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("useInlineFunctionInsideInlineClass.kt")
        public void testUseInlineFunctionInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineFunctionInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("useInlineFunctionInsideInlineClassGeneric.kt")
        public void testUseInlineFunctionInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineFunctionInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("useOfInlineClassWithGenericMethodFromJava.kt")
        public void testUseOfInlineClassWithGenericMethodFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useOfInlineClassWithGenericMethodFromJava.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("useOfInlineClassWithGenericMethodFromJavaGeneric.kt")
        public void testUseOfInlineClassWithGenericMethodFromJavaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useOfInlineClassWithGenericMethodFromJavaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("useThisInsideInlineClass.kt")
        public void testUseThisInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useThisInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("useThisInsideInlineClassGeneric.kt")
        public void testUseThisInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useThisInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("whenWithSubject.kt")
        public void testWhenWithSubject() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/whenWithSubject.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("whenWithSubjectGeneric.kt")
        public void testWhenWithSubjectGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/whenWithSubjectGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BoxReturnValueInLambda extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBoxReturnValueInLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("boxAny.kt")
            public void testBoxAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxAnyGeneric.kt")
            public void testBoxAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxFunLiteralAny.kt")
            public void testBoxFunLiteralAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxFunLiteralAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxFunLiteralAnyGeneric.kt")
            public void testBoxFunLiteralAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxFunLiteralAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxInt.kt")
            public void testBoxInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxInt.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxIntGeneric.kt")
            public void testBoxIntGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxIntGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableAny.kt")
            public void testBoxNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableAnyGeneric.kt")
            public void testBoxNullableAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableAnyGeneric2.kt")
            public void testBoxNullableAnyGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableAnyNull.kt")
            public void testBoxNullableAnyNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableAnyNullGeneric.kt")
            public void testBoxNullableAnyNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableAnyNullGeneric2.kt")
            public void testBoxNullableAnyNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNullGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableInt.kt")
            public void testBoxNullableInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableInt.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableIntGeneric.kt")
            public void testBoxNullableIntGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableIntGeneric2.kt")
            public void testBoxNullableIntGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableIntNull.kt")
            public void testBoxNullableIntNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableIntNullGeneric.kt")
            public void testBoxNullableIntNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableIntNullGeneric2.kt")
            public void testBoxNullableIntNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNullGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableString.kt")
            public void testBoxNullableString() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableString.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableStringGeneric.kt")
            public void testBoxNullableStringGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableStringGeneric2.kt")
            public void testBoxNullableStringGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableStringNull.kt")
            public void testBoxNullableStringNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableStringNullGeneric.kt")
            public void testBoxNullableStringNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxNullableStringNullGeneric2.kt")
            public void testBoxNullableStringNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNullGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxString.kt")
            public void testBoxString() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxString.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxStringGeneric.kt")
            public void testBoxStringGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxStringGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt27586_1.kt")
            public void testKt27586_1() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/kt27586_1.kt");
            }

            @TestMetadata("kt27586_2.kt")
            public void testKt27586_2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/kt27586_2.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BoxReturnValueOnOverride extends AbstractLightAnalysisModeTest {
            @TestMetadata("boxReturnValueInDefaultMethod.kt")
            public void ignoreBoxReturnValueInDefaultMethod() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/boxReturnValueInDefaultMethod.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boxReturnValueInDefaultMethodGenericInt.kt")
            public void ignoreBoxReturnValueInDefaultMethodGenericInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/boxReturnValueInDefaultMethodGenericInt.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBoxReturnValueOnOverride() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("covariantOverrideChainErasedToAny.kt")
            public void testCovariantOverrideChainErasedToAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideChainErasedToAnyGeneric.kt")
            public void testCovariantOverrideChainErasedToAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideChainErasedToNullableAny.kt")
            public void testCovariantOverrideChainErasedToNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideChainErasedToNullableAnyGeneric.kt")
            public void testCovariantOverrideChainErasedToNullableAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideChainErasedToNullableAnyGeneric2.kt")
            public void testCovariantOverrideChainErasedToNullableAnyGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAnyGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideErasedToAny.kt")
            public void testCovariantOverrideErasedToAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideErasedToAnyGeneric.kt")
            public void testCovariantOverrideErasedToAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideErasedToInterface.kt")
            public void testCovariantOverrideErasedToInterface() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToInterface.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideErasedToInterfaceGeneric.kt")
            public void testCovariantOverrideErasedToInterfaceGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToInterfaceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideErasedToPrimitive.kt")
            public void testCovariantOverrideErasedToPrimitive() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideErasedToPrimitiveGeneric.kt")
            public void testCovariantOverrideErasedToPrimitiveGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideListVsMutableList.kt")
            public void testCovariantOverrideListVsMutableList() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideListVsMutableList.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideListVsMutableListGeneric.kt")
            public void testCovariantOverrideListVsMutableListGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideListVsMutableListGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideUnrelatedInterfaces.kt")
            public void testCovariantOverrideUnrelatedInterfaces() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideUnrelatedInterfaces.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("covariantOverrideUnrelatedInterfacesGeneric.kt")
            public void testCovariantOverrideUnrelatedInterfacesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideUnrelatedInterfacesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("genericOverride.kt")
            public void testGenericOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverride.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("genericOverrideGeneric.kt")
            public void testGenericOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("genericOverrideSpecialized.kt")
            public void testGenericOverrideSpecialized() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideSpecialized.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("genericOverrideSpecializedGeneric.kt")
            public void testGenericOverrideSpecializedGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideSpecializedGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassInOverriddenReturnTypes.kt")
            public void testInlineClassInOverriddenReturnTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/inlineClassInOverriddenReturnTypes.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassInOverriddenReturnTypesGeneric.kt")
            public void testInlineClassInOverriddenReturnTypesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/inlineClassInOverriddenReturnTypesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt28483.kt")
            public void testKt28483() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt28483Generic.kt")
            public void testKt28483Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt28483Generic2.kt")
            public void testKt28483Generic2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483Generic2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt31585.kt")
            public void testKt31585() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt31585.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt31585Generic.kt")
            public void testKt31585Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt31585Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt35234.kt")
            public void testKt35234() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt35234Generic.kt")
            public void testKt35234Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt35234a.kt")
            public void testKt35234a() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234a.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithInlineClass.kt")
            public void testOverrideGenericWithInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithInlineClassGeneric.kt")
            public void testOverrideGenericWithInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullAny.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG2.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNull.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullAny.kt")
            public void testOverrideNullableInlineClassWithNonNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullAnyGeneric.kt")
            public void testOverrideNullableInlineClassWithNonNullAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAny.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyGeneric.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyGeneric2.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyNull.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyNullGeneric.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("overrideNullableInlineClassWithNonNullNullableAnyNullGeneric2.kt")
            public void testOverrideNullableInlineClassWithNonNullNullableAnyNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideNullableInlineClassWithNonNullNullableAnyNullGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("relatedReturnTypes1a.kt")
            public void testRelatedReturnTypes1a() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes1a.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("relatedReturnTypes1aGeneric.kt")
            public void testRelatedReturnTypes1aGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes1aGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("relatedReturnTypes1b.kt")
            public void testRelatedReturnTypes1b() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes1b.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("relatedReturnTypes1bGeneric.kt")
            public void testRelatedReturnTypes1bGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes1bGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("relatedReturnTypes2a.kt")
            public void testRelatedReturnTypes2a() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes2a.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("relatedReturnTypes2aGeneric.kt")
            public void testRelatedReturnTypes2aGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes2aGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("relatedReturnTypes2b.kt")
            public void testRelatedReturnTypes2b() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes2b.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("relatedReturnTypes2bGeneric.kt")
            public void testRelatedReturnTypes2bGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/relatedReturnTypes2bGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("uncastInlineClassToAnyAndBack.kt")
            public void testUncastInlineClassToAnyAndBack() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/uncastInlineClassToAnyAndBack.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("uncastInlineClassToAnyAndBackGeneric.kt")
            public void testUncastInlineClassToAnyAndBackGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/uncastInlineClassToAnyAndBackGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("unrelatedGenerics.kt")
            public void testUnrelatedGenerics() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/unrelatedGenerics.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("unrelatedGenericsGeneric.kt")
            public void testUnrelatedGenericsGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/unrelatedGenericsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/callableReferences")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallableReferences extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCallableReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("boundInlineClassExtensionFun.kt")
            public void testBoundInlineClassExtensionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassExtensionFunGeneric.kt")
            public void testBoundInlineClassExtensionFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassExtensionVal.kt")
            public void testBoundInlineClassExtensionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassExtensionValGeneric.kt")
            public void testBoundInlineClassExtensionValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassMemberFun.kt")
            public void testBoundInlineClassMemberFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassMemberFunGeneric.kt")
            public void testBoundInlineClassMemberFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassMemberVal.kt")
            public void testBoundInlineClassMemberVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassMemberValGeneric.kt")
            public void testBoundInlineClassMemberValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassPrimaryVal.kt")
            public void testBoundInlineClassPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassPrimaryVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("boundInlineClassPrimaryValGeneric.kt")
            public void testBoundInlineClassPrimaryValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassPrimaryValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("constructorWithInlineClassParameters.kt")
            public void testConstructorWithInlineClassParameters() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/constructorWithInlineClassParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("constructorWithInlineClassParametersGeneric.kt")
            public void testConstructorWithInlineClassParametersGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/constructorWithInlineClassParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("equalsHashCodeToString.kt")
            public void testEqualsHashCodeToString() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/equalsHashCodeToString.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("equalsHashCodeToStringGeneric.kt")
            public void testEqualsHashCodeToStringGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/equalsHashCodeToStringGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("funWithInlineClassParameters.kt")
            public void testFunWithInlineClassParameters() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/funWithInlineClassParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("funWithInlineClassParametersGeneric.kt")
            public void testFunWithInlineClassParametersGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/funWithInlineClassParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassExtensionFun.kt")
            public void testInlineClassExtensionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassExtensionFunGeneric.kt")
            public void testInlineClassExtensionFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassExtensionVal.kt")
            public void testInlineClassExtensionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassExtensionValGeneric.kt")
            public void testInlineClassExtensionValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassInternalPrimaryVal.kt")
            public void testInlineClassInternalPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassInternalPrimaryVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassInternalPrimaryValGeneric.kt")
            public void testInlineClassInternalPrimaryValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassInternalPrimaryValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassMemberFun.kt")
            public void testInlineClassMemberFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassMemberFunGeneric.kt")
            public void testInlineClassMemberFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassMemberVal.kt")
            public void testInlineClassMemberVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassMemberValGeneric.kt")
            public void testInlineClassMemberValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrimaryConstructor.kt")
            public void testInlineClassPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrimaryConstructorGeneric.kt")
            public void testInlineClassPrimaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryConstructorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrimaryVal.kt")
            public void testInlineClassPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrimaryValGeneric.kt")
            public void testInlineClassPrimaryValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrivatePrimaryVal.kt")
            public void testInlineClassPrivatePrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrivatePrimaryVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrivatePrimaryValGeneric.kt")
            public void testInlineClassPrivatePrimaryValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrivatePrimaryValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassTypeBoundMemberVar.kt")
            public void testInlineClassTypeBoundMemberVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeBoundMemberVar.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassTypeBoundMemberVarGeneric.kt")
            public void testInlineClassTypeBoundMemberVarGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeBoundMemberVarGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassTypeMemberVar.kt")
            public void testInlineClassTypeMemberVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeMemberVar.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassTypeMemberVarGeneric.kt")
            public void testInlineClassTypeMemberVarGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeMemberVarGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassTypeTopLevelVar.kt")
            public void testInlineClassTypeTopLevelVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeTopLevelVar.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassTypeTopLevelVarGeneric.kt")
            public void testInlineClassTypeTopLevelVarGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeTopLevelVarGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt37986.kt")
            public void testKt37986() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/kt37986.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt37986Generic.kt")
            public void testKt37986Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/kt37986Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/callableReferences/let")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Let extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                    KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInLet() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/callableReferences/let"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/any.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("anyGeneric.kt")
                public void testAnyGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/anyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/anyN.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("anyNGeneric.kt")
                public void testAnyNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/anyNGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("anyNGeneric2.kt")
                public void testAnyNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/anyNGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("int.kt")
                public void testInt() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/int.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("intGeneric.kt")
                public void testIntGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/intGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("intN.kt")
                public void testIntN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/intN.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("intNGeneric.kt")
                public void testIntNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/intNGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("intNGeneric2.kt")
                public void testIntNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/intNGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("null.kt")
                public void testNull() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/null.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("nullGeneric.kt")
                public void testNullGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/nullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("result.kt")
                public void testResult() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/result.kt");
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/string.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("stringGeneric.kt")
                public void testStringGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/stringGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("stringN.kt")
                public void testStringN() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/stringN.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("stringNGeneric.kt")
                public void testStringNGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/stringNGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("stringNGeneric2.kt")
                public void testStringNGeneric2() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/let/stringNGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ContextsAndAccessors extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethod.kt")
            public void testAccessPrivateInlineClassCompanionMethod() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethod.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethod2.kt")
            public void testAccessPrivateInlineClassCompanionMethod2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethod2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethod2Generic.kt")
            public void testAccessPrivateInlineClassCompanionMethod2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethod2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethodGeneric.kt")
            public void testAccessPrivateInlineClassCompanionMethodGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethodGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromCompanion.kt")
            public void testAccessPrivateInlineClassConstructorFromCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromCompanionGeneric.kt")
            public void testAccessPrivateInlineClassConstructorFromCompanionGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromLambda.kt")
            public void testAccessPrivateInlineClassConstructorFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromLambdaGeneric.kt")
            public void testAccessPrivateInlineClassConstructorFromLambdaGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanion.kt")
            public void testAccessPrivateInlineClassMethodFromCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanion2.kt")
            public void testAccessPrivateInlineClassMethodFromCompanion2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanion2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanion2Generic.kt")
            public void testAccessPrivateInlineClassMethodFromCompanion2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanion2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanionGeneric.kt")
            public void testAccessPrivateInlineClassMethodFromCompanionGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambda.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambda2.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambda2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambda2Generic.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambda2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambda2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambdaGeneric.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambdaGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambda.kt")
            public void testAccessPrivateInlineClassMethodFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambda2.kt")
            public void testAccessPrivateInlineClassMethodFromLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambda2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambda2Generic.kt")
            public void testAccessPrivateInlineClassMethodFromLambda2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambda2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambdaGeneric.kt")
            public void testAccessPrivateInlineClassMethodFromLambdaGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateStaticInlineClassCompanionMethod.kt")
            public void testAccessPrivateStaticInlineClassCompanionMethod() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateStaticInlineClassCompanionMethod.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("accessPrivateStaticInlineClassCompanionMethodGeneric.kt")
            public void testAccessPrivateStaticInlineClassCompanionMethodGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateStaticInlineClassCompanionMethodGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            public void testAllFilesPresentInContextsAndAccessors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("captureInlineClassInstanceInLambda.kt")
            public void testCaptureInlineClassInstanceInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("captureInlineClassInstanceInLambda2.kt")
            public void testCaptureInlineClassInstanceInLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambda2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("captureInlineClassInstanceInLambda2Generic.kt")
            public void testCaptureInlineClassInstanceInLambda2Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambda2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("captureInlineClassInstanceInLambdaGeneric.kt")
            public void testCaptureInlineClassInstanceInLambdaGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("captureInlineClassInstanceInObject.kt")
            public void testCaptureInlineClassInstanceInObject() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInObject.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("captureInlineClassInstanceInObjectGeneric.kt")
            public void testCaptureInlineClassInstanceInObjectGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInObjectGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineLambdaInInlineClassFun.kt")
            public void testInlineLambdaInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/inlineLambdaInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineLambdaInInlineClassFunGeneric.kt")
            public void testInlineLambdaInInlineClassFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/inlineLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt26858.kt")
            public void testKt26858() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt26858.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt26858Generic.kt")
            public void testKt26858Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt26858Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt27513.kt")
            public void testKt27513() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt27513.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt27513Generic.kt")
            public void testKt27513Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt27513Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt30780.kt")
            public void testKt30780() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt30780.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt30780Generic.kt")
            public void testKt30780Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt30780Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("lambdaInInlineClassFun.kt")
            public void testLambdaInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/lambdaInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("lambdaInInlineClassFunGeneric.kt")
            public void testLambdaInInlineClassFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/lambdaInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("objectInInlineClassFun.kt")
            public void testObjectInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/objectInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("objectInInlineClassFunGeneric.kt")
            public void testObjectInInlineClassFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/objectInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("toPrivateCompanionFun.kt")
            public void testToPrivateCompanionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("toPrivateCompanionFunGeneric.kt")
            public void testToPrivateCompanionFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("toPrivateCompanionVal.kt")
            public void testToPrivateCompanionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionVal.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("toPrivateCompanionValGeneric.kt")
            public void testToPrivateCompanionValGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionValGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/defaultParameterValues")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultParameterValues extends AbstractLightAnalysisModeTest {
            @TestMetadata("inlineClassPrimaryConstructorWithInlineClassValueGeneric.kt")
            public void ignoreInlineClassPrimaryConstructorWithInlineClassValueGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructorWithInlineClassValueGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultParameterValues() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/defaultParameterValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("defaultConstructorParameterValuesOfInlineClassType.kt")
            public void testDefaultConstructorParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultConstructorParameterValuesOfInlineClassType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultConstructorParameterValuesOfInlineClassTypeGeneric.kt")
            public void testDefaultConstructorParameterValuesOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultConstructorParameterValuesOfInlineClassTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultInterfaceFunParameterValuesOfInlineClassType.kt")
            public void testDefaultInterfaceFunParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultInterfaceFunParameterValuesOfInlineClassType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultInterfaceFunParameterValuesOfInlineClassTypeGeneric.kt")
            public void testDefaultInterfaceFunParameterValuesOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultInterfaceFunParameterValuesOfInlineClassTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultParameterValuesOfInlineClassType.kt")
            public void testDefaultParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultParameterValuesOfInlineClassTypeBoxing.kt")
            public void testDefaultParameterValuesOfInlineClassTypeBoxing() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassTypeBoxing.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultParameterValuesOfInlineClassTypeBoxingGeneric.kt")
            public void testDefaultParameterValuesOfInlineClassTypeBoxingGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassTypeBoxingGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultParameterValuesOfInlineClassTypeGeneric.kt")
            public void testDefaultParameterValuesOfInlineClassTypeGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFun.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFunGeneric.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFunInInlineClass.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFunInInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFunInInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFunInInlineClassGeneric.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFunInInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFunInInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassFun.kt")
            public void testInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassFunGeneric.kt")
            public void testInlineClassFunGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrimaryConstructor.kt")
            public void testInlineClassPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrimaryConstructorGeneric.kt")
            public void testInlineClassPrimaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassPrimaryConstructorWithInlineClassValue.kt")
            public void testInlineClassPrimaryConstructorWithInlineClassValue() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructorWithInlineClassValue.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassSecondaryConstructor.kt")
            public void testInlineClassSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassSecondaryConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("inlineClassSecondaryConstructorGeneric.kt")
            public void testInlineClassSecondaryConstructorGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassSecondaryConstructorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt26554.kt")
            public void testKt26554() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/kt26554.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt27416.kt")
            public void testKt27416() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/kt27416.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt27416Generic.kt")
            public void testKt27416Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/kt27416Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DefaultWithDefaultParameter extends AbstractLightAnalysisModeTest {
                @TestMetadata("all.kt")
                public void ignoreAll() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter/all.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("allGeneric.kt")
                public void ignoreAllGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter/allGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("all-compatibility.kt")
                public void ignoreAll_compatibility() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter/all-compatibility.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("all-compatibilityGeneric.kt")
                public void ignoreAll_compatibilityGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter/all-compatibilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("compatibility.kt")
                public void ignoreCompatibility() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter/compatibility.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("compatibilityGeneric.kt")
                public void ignoreCompatibilityGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter/compatibilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("default.kt")
                public void ignoreDefault() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter/default.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("defaultGeneric.kt")
                public void ignoreDefaultGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter/defaultGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                    KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInDefaultWithDefaultParameter() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultWithDefaultParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OverrideFunctionWithDefaultParameter extends AbstractLightAnalysisModeTest {
                @TestMetadata("all.kt")
                public void ignoreAll() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter/all.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("allGeneric.kt")
                public void ignoreAllGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter/allGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("all-compatibility.kt")
                public void ignoreAll_compatibility() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter/all-compatibility.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("all-compatibilityGeneric.kt")
                public void ignoreAll_compatibilityGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter/all-compatibilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("compatibility.kt")
                public void ignoreCompatibility() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter/compatibility.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("compatibilityGeneric.kt")
                public void ignoreCompatibilityGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter/compatibilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("default.kt")
                public void ignoreDefault() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter/default.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                @TestMetadata("defaultGeneric.kt")
                public void ignoreDefaultGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter/defaultGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                    KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInOverrideFunctionWithDefaultParameter() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/overrideFunctionWithDefaultParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DelegationByUnderlyingType extends AbstractLightAnalysisModeTest {
            @TestMetadata("default.kt")
            public void ignoreDefault() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/default.kt");
            }

            @TestMetadata("defaultArgument.kt")
            public void ignoreDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/defaultArgument.kt");
            }

            @TestMetadata("defaultArgumentGeneric.kt")
            public void ignoreDefaultArgumentGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/defaultArgumentGeneric.kt");
            }

            @TestMetadata("defaultGeneric.kt")
            public void ignoreDefaultGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/defaultGeneric.kt");
            }

            @TestMetadata("simple.kt")
            public void ignoreSimple() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/simple.kt");
            }

            @TestMetadata("simpleGeneric.kt")
            public void ignoreSimpleGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType/simpleGeneric.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDelegationByUnderlyingType() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/delegationByUnderlyingType"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/funInterface")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunInterface extends AbstractLightAnalysisModeTest {
            @TestMetadata("argumentResult.kt")
            public void ignoreArgumentResult() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/argumentResult.kt");
            }

            @TestMetadata("kt51121.kt")
            public void ignoreKt51121() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/kt51121.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("kt51121_2.kt")
            public void ignoreKt51121_2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/kt51121_2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("mangledSamWrappers.kt")
            public void ignoreMangledSamWrappers() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/mangledSamWrappers.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("mangledSamWrappersGeneric.kt")
            public void ignoreMangledSamWrappersGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/mangledSamWrappersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("returnIC.kt")
            public void ignoreReturnIC() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/returnIC.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("returnICGeneric.kt")
            public void ignoreReturnICGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/returnICGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("returnICGeneric2.kt")
            public void ignoreReturnICGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/returnICGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("returnResult.kt")
            public void ignoreReturnResult() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/returnResult.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunInterface() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("argumentIC.kt")
            public void testArgumentIC() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/argumentIC.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("argumentICGeneric.kt")
            public void testArgumentICGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/argumentICGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("argumentICGeneric2.kt")
            public void testArgumentICGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/argumentICGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("javaSam.kt")
            public void testJavaSam() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/javaSam.kt");
            }

            @TestMetadata("javaSamReturnResult.kt")
            public void testJavaSamReturnResult() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/funInterface/javaSamReturnResult.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/functionNameMangling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionNameMangling extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTest(String testDataFilePath, java.util.function.Function<String, String> transformer) throws Exception {
                KotlinTestUtils.runTest(path -> doTestWithTransformer(path, transformer), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionNameMangling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/functionNameMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @TestMetadata("anonymousObjectInFunctionWithMangledName.kt")
            public void testAnonymousObjectInFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/anonymousObjectInFunctionWithMangledName.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("anonymousObjectInFunctionWithMangledNameGeneric.kt")
            public void testAnonymousObjectInFunctionWithMangledNameGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/anonymousObjectInFunctionWithMangledNameGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("extensionFunctionsDoNotClash.kt")
            public void testExtensionFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/extensionFunctionsDoNotClash.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("extensionFunctionsDoNotClashGeneric.kt")
            public void testExtensionFunctionsDoNotClashGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/extensionFunctionsDoNotClashGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("functionsWithDifferentNullabilityDoNotClash.kt")
            public void testFunctionsWithDifferentNullabilityDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/functionsWithDifferentNullabilityDoNotClash.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("functionsWithDifferentNullabilityDoNotClashGeneric.kt")
            public void testFunctionsWithDifferentNullabilityDoNotClashGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/functionsWithDifferentNullabilityDoNotClashGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("genericFunctionsDoNotClash.kt")
            public void testGenericFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/genericFunctionsDoNotClash.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("genericFunctionsDoNotClashGeneric.kt")
            public void testGenericFunctionsDoNotClashGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/genericFunctionsDoNotClashGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("genericSignatureOfFunctionWithMangledName.kt")
            public void testGenericSignatureOfFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/genericSignatureOfFunctionWithMangledName.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("genericSignatureOfFunctionWithMangledNameGeneric.kt")
            public void testGenericSignatureOfFunctionWithMangledNameGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/genericSignatureOfFunctionWithMangledNameGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("localClassInFunctionWithMangledName.kt")
            public void testLocalClassInFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/localClassInFunctionWithMangledName.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("localClassInFunctionWithMangledNameGeneric.kt")
            public void testLocalClassInFunctionWithMangledNameGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/localClassInFunctionWithMangledNameGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @TestMetadata("mangledFunctionsCanBeOverridden.kt")
            public void testMangledFunctionsCanBeOverridden() throws Exception {
                r