/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.cli;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class CliTestGenerated extends AbstractCliTest {
    @TestMetadata("compiler/testData/cli/jvm/readingConfigFromEnvironment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReadingConfigFromEnvironment extends AbstractCliTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doJvmTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInReadingConfigFromEnvironment() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/cli/jvm/readingConfigFromEnvironment"), Pattern.compile("^(.+)\\.args$"), null, false);
        }

        @TestMetadata("appendingArgs.args")
        public void testAppendingArgs() throws Exception {
            runTest("compiler/testData/cli/jvm/readingConfigFromEnvironment/appendingArgs.args");
        }

        @TestMetadata("overridingArgs.args")
        public void testOverridingArgs() throws Exception {
            runTest("compiler/testData/cli/jvm/readingConfigFromEnvironment/overridingArgs.args");
        }

        @TestMetadata("overridingLv.args")
        public void testOverridingLv() throws Exception {
            runTest("compiler/testData/cli/jvm/readingConfigFromEnvironment/overridingLv.args");
        }

        @TestMetadata("overridingXx.args")
        public void testOverridingXx() throws Exception {
            runTest("compiler/testData/cli/jvm/readingConfigFromEnvironment/overridingXx.args");
        }

        @TestMetadata("simple.args")
        public void testSimple() throws Exception {
            runTest("compiler/testData/cli/jvm/readingConfigFromEnvironment/simple.args");
        }
    }

    @TestMetadata("compiler/testData/cli/jvm")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jvm extends AbstractCliTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doJvmTest, this, testDataFilePath);
        }

        @TestMetadata("abiStabilityIncorrectValue.args")
        public void testAbiStabilityIncorrectValue() throws Exception {
            runTest("compiler/testData/cli/jvm/abiStabilityIncorrectValue.args");
        }

        @TestMetadata("abiStabilityUnstableWithOldBackend.args")
        public void testAbiStabilityUnstableWithOldBackend() throws Exception {
            runTest("compiler/testData/cli/jvm/abiStabilityUnstableWithOldBackend.args");
        }

        public void testAllFilesPresentInJvm() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/cli/jvm"), Pattern.compile("^(.+)\\.args$"), null, false);
        }

        @TestMetadata("apiAndLanguageVersionsUnsupported.args")
        public void testApiAndLanguageVersionsUnsupported() throws Exception {
            runTest("compiler/testData/cli/jvm/apiAndLanguageVersionsUnsupported.args");
        }

        @TestMetadata("apiVersion.args")
        public void testApiVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/apiVersion.args");
        }

        @TestMetadata("apiVersionAndSinceNewerKotlin.args")
        public void testApiVersionAndSinceNewerKotlin() throws Exception {
            runTest("compiler/testData/cli/jvm/apiVersionAndSinceNewerKotlin.args");
        }

        @TestMetadata("apiVersionGreaterThanLanguage.args")
        public void testApiVersionGreaterThanLanguage() throws Exception {
            runTest("compiler/testData/cli/jvm/apiVersionGreaterThanLanguage.args");
        }

        @TestMetadata("apiVersionInvalid.args")
        public void testApiVersionInvalid() throws Exception {
            runTest("compiler/testData/cli/jvm/apiVersionInvalid.args");
        }

        @TestMetadata("apiVersionLessThanLanguage.args")
        public void testApiVersionLessThanLanguage() throws Exception {
            runTest("compiler/testData/cli/jvm/apiVersionLessThanLanguage.args");
        }

        @TestMetadata("apiVersionLessThanLanguageUsingArgfile.args")
        public void testApiVersionLessThanLanguageUsingArgfile() throws Exception {
            runTest("compiler/testData/cli/jvm/apiVersionLessThanLanguageUsingArgfile.args");
        }

        @TestMetadata("apiVersionUnsupported.args")
        public void testApiVersionUnsupported() throws Exception {
            runTest("compiler/testData/cli/jvm/apiVersionUnsupported.args");
        }

        @TestMetadata("argfileWithEmptyArgument.args")
        public void testArgfileWithEmptyArgument() throws Exception {
            runTest("compiler/testData/cli/jvm/argfileWithEmptyArgument.args");
        }

        @TestMetadata("argfileWithEscaping.args")
        public void testArgfileWithEscaping() throws Exception {
            runTest("compiler/testData/cli/jvm/argfileWithEscaping.args");
        }

        @TestMetadata("argfileWithUnfinishedQuoteAndEscape.args")
        public void testArgfileWithUnfinishedQuoteAndEscape() throws Exception {
            runTest("compiler/testData/cli/jvm/argfileWithUnfinishedQuoteAndEscape.args");
        }

        @TestMetadata("argumentPassedMultipleTimes.args")
        public void testArgumentPassedMultipleTimes() throws Exception {
            runTest("compiler/testData/cli/jvm/argumentPassedMultipleTimes.args");
        }

        @TestMetadata("bothJvmIrAndOldBackend.args")
        public void testBothJvmIrAndOldBackend() throws Exception {
            runTest("compiler/testData/cli/jvm/bothJvmIrAndOldBackend.args");
        }

        @TestMetadata("builderInferenceByDefault.args")
        public void testBuilderInferenceByDefault() throws Exception {
            runTest("compiler/testData/cli/jvm/builderInferenceByDefault.args");
        }

        @TestMetadata("builderInferenceErrors.args")
        public void testBuilderInferenceErrors() throws Exception {
            runTest("compiler/testData/cli/jvm/builderInferenceErrors.args");
        }

        @TestMetadata("classAndFileClassClash.args")
        public void testClassAndFileClassClash() throws Exception {
            runTest("compiler/testData/cli/jvm/classAndFileClassClash.args");
        }

        @TestMetadata("classAndOtherFileClassClash.args")
        public void testClassAndOtherFileClassClash() throws Exception {
            runTest("compiler/testData/cli/jvm/classAndOtherFileClassClash.args");
        }

        @TestMetadata("classAndPartClash.args")
        public void testClassAndPartClash() throws Exception {
            runTest("compiler/testData/cli/jvm/classAndPartClash.args");
        }

        @TestMetadata("classAndTraitClash.args")
        public void testClassAndTraitClash() throws Exception {
            runTest("compiler/testData/cli/jvm/classAndTraitClash.args");
        }

        @TestMetadata("classpath.args")
        public void testClasspath() throws Exception {
            runTest("compiler/testData/cli/jvm/classpath.args");
        }

        @TestMetadata("compatqualDefault.args")
        public void testCompatqualDefault() throws Exception {
            runTest("compiler/testData/cli/jvm/compatqualDefault.args");
        }

        @TestMetadata("compatqualDisable.args")
        public void testCompatqualDisable() throws Exception {
            runTest("compiler/testData/cli/jvm/compatqualDisable.args");
        }

        @TestMetadata("compatqualEnable.args")
        public void testCompatqualEnable() throws Exception {
            runTest("compiler/testData/cli/jvm/compatqualEnable.args");
        }

        @TestMetadata("compatqualWrong.args")
        public void testCompatqualWrong() throws Exception {
            runTest("compiler/testData/cli/jvm/compatqualWrong.args");
        }

        @TestMetadata("conflictingOverloads.args")
        public void testConflictingOverloads() throws Exception {
            runTest("compiler/testData/cli/jvm/conflictingOverloads.args");
        }

        @TestMetadata("conflictingProjection.args")
        public void testConflictingProjection() throws Exception {
            runTest("compiler/testData/cli/jvm/conflictingProjection.args");
        }

        @TestMetadata("coroutinesEnable.args")
        public void testCoroutinesEnable() throws Exception {
            runTest("compiler/testData/cli/jvm/coroutinesEnable.args");
        }

        @TestMetadata("coroutinesError.args")
        public void testCoroutinesError() throws Exception {
            runTest("compiler/testData/cli/jvm/coroutinesError.args");
        }

        @TestMetadata("coroutinesErrorAndEnable.args")
        public void testCoroutinesErrorAndEnable() throws Exception {
            runTest("compiler/testData/cli/jvm/coroutinesErrorAndEnable.args");
        }

        @TestMetadata("coroutinesWarn.args")
        public void testCoroutinesWarn() throws Exception {
            runTest("compiler/testData/cli/jvm/coroutinesWarn.args");
        }

        @TestMetadata("deprecatedApiVersion.args")
        public void testDeprecatedApiVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/deprecatedApiVersion.args");
        }

        @TestMetadata("deprecatedLanguageUnsupportedApi.args")
        public void testDeprecatedLanguageUnsupportedApi() throws Exception {
            runTest("compiler/testData/cli/jvm/deprecatedLanguageUnsupportedApi.args");
        }

        @TestMetadata("deprecatedLanguageVersion.args")
        public void testDeprecatedLanguageVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/deprecatedLanguageVersion.args");
        }

        @TestMetadata("diagnosticsOrder.args")
        public void testDiagnosticsOrder() throws Exception {
            runTest("compiler/testData/cli/jvm/diagnosticsOrder.args");
        }

        @TestMetadata("disabledFeatureFromUnsupportedVersion.args")
        public void testDisabledFeatureFromUnsupportedVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/disabledFeatureFromUnsupportedVersion.args");
        }

        @TestMetadata("duplicateSources.args")
        public void testDuplicateSources() throws Exception {
            runTest("compiler/testData/cli/jvm/duplicateSources.args");
        }

        @TestMetadata("duplicateSourcesInModule.args")
        public void testDuplicateSourcesInModule() throws Exception {
            runTest("compiler/testData/cli/jvm/duplicateSourcesInModule.args");
        }

        @TestMetadata("emptySources.args")
        public void testEmptySources() throws Exception {
            runTest("compiler/testData/cli/jvm/emptySources.args");
        }

        @TestMetadata("experimentalDeprecated.args")
        public void testExperimentalDeprecated() throws Exception {
            runTest("compiler/testData/cli/jvm/experimentalDeprecated.args");
        }

        @TestMetadata("experimentalDeprecatedWarning.args")
        public void testExperimentalDeprecatedWarning() throws Exception {
            runTest("compiler/testData/cli/jvm/experimentalDeprecatedWarning.args");
        }

        @TestMetadata("experimentalIsNotAnnotation.args")
        public void testExperimentalIsNotAnnotation() throws Exception {
            runTest("compiler/testData/cli/jvm/experimentalIsNotAnnotation.args");
        }

        @TestMetadata("experimentalIsNotMarker.args")
        public void testExperimentalIsNotMarker() throws Exception {
            runTest("compiler/testData/cli/jvm/experimentalIsNotMarker.args");
        }

        @TestMetadata("experimentalNested.args")
        public void testExperimentalNested() throws Exception {
            runTest("compiler/testData/cli/jvm/experimentalNested.args");
        }

        @TestMetadata("experimentalUnresolved.args")
        public void testExperimentalUnresolved() throws Exception {
            runTest("compiler/testData/cli/jvm/experimentalUnresolved.args");
        }

        @TestMetadata("explicitlyDisableSamConversionsWithOldFlag.args")
        public void testExplicitlyDisableSamConversionsWithOldFlag() throws Exception {
            runTest("compiler/testData/cli/jvm/explicitlyDisableSamConversionsWithOldFlag.args");
        }

        @TestMetadata("explicitlyDisabledSamConversions.args")
        public void testExplicitlyDisabledSamConversions() throws Exception {
            runTest("compiler/testData/cli/jvm/explicitlyDisabledSamConversions.args");
        }

        @TestMetadata("expression1.args")
        public void testExpression1() throws Exception {
            runTest("compiler/testData/cli/jvm/expression1.args");
        }

        @TestMetadata("extendedCheckers.args")
        public void testExtendedCheckers() throws Exception {
            runTest("compiler/testData/cli/jvm/extendedCheckers.args");
        }

        @TestMetadata("extendedCheckersNoWarning.args")
        public void testExtendedCheckersNoWarning() throws Exception {
            runTest("compiler/testData/cli/jvm/extendedCheckersNoWarning.args");
        }

        @TestMetadata("extraArgumentPassedInObsoleteForm.args")
        public void testExtraArgumentPassedInObsoleteForm() throws Exception {
            runTest("compiler/testData/cli/jvm/extraArgumentPassedInObsoleteForm.args");
        }

        @TestMetadata("extraBooleanArgumentEqualsFalse.args")
        public void testExtraBooleanArgumentEqualsFalse() throws Exception {
            runTest("compiler/testData/cli/jvm/extraBooleanArgumentEqualsFalse.args");
        }

        @TestMetadata("extraBooleanArgumentEqualsNonsense.args")
        public void testExtraBooleanArgumentEqualsNonsense() throws Exception {
            runTest("compiler/testData/cli/jvm/extraBooleanArgumentEqualsNonsense.args");
        }

        @TestMetadata("extraBooleanArgumentEqualsTrue.args")
        public void testExtraBooleanArgumentEqualsTrue() throws Exception {
            runTest("compiler/testData/cli/jvm/extraBooleanArgumentEqualsTrue.args");
        }

        @TestMetadata("extraHelp.args")
        public void testExtraHelp() throws Exception {
            runTest("compiler/testData/cli/jvm/extraHelp.args");
        }

        @TestMetadata("fileClassAndMultifileClassClash.args")
        public void testFileClassAndMultifileClassClash() throws Exception {
            runTest("compiler/testData/cli/jvm/fileClassAndMultifileClassClash.args");
        }

        @TestMetadata("fileClassAndTImplClash.args")
        public void testFileClassAndTImplClash() throws Exception {
            runTest("compiler/testData/cli/jvm/fileClassAndTImplClash.args");
        }

        @TestMetadata("fileClassClashMultipleFiles.args")
        public void testFileClassClashMultipleFiles() throws Exception {
            runTest("compiler/testData/cli/jvm/fileClassClashMultipleFiles.args");
        }

        @TestMetadata("firDfa.args")
        public void testFirDfa() throws Exception {
            runTest("compiler/testData/cli/jvm/firDfa.args");
        }

        @TestMetadata("firError.args")
        public void testFirError() throws Exception {
            runTest("compiler/testData/cli/jvm/firError.args");
        }

        @TestMetadata("firHello.args")
        public void testFirHello() throws Exception {
            runTest("compiler/testData/cli/jvm/firHello.args");
        }

        @TestMetadata("firMultiplatformCompilationWithError.args")
        public void testFirMultiplatformCompilationWithError() throws Exception {
            runTest("compiler/testData/cli/jvm/firMultiplatformCompilationWithError.args");
        }

        @TestMetadata("firMultiplatformCompilationWithoutErrors.args")
        public void testFirMultiplatformCompilationWithoutErrors() throws Exception {
            runTest("compiler/testData/cli/jvm/firMultiplatformCompilationWithoutErrors.args");
        }

        @TestMetadata("firStdlibDependency.args")
        public void testFirStdlibDependency() throws Exception {
            runTest("compiler/testData/cli/jvm/firStdlibDependency.args");
        }

        @TestMetadata("firVsClassicAnnotation.args")
        public void testFirVsClassicAnnotation() throws Exception {
            runTest("compiler/testData/cli/jvm/firVsClassicAnnotation.args");
        }

        @TestMetadata("flagAllowingResultAsReturnType.args")
        public void testFlagAllowingResultAsReturnType() throws Exception {
            runTest("compiler/testData/cli/jvm/flagAllowingResultAsReturnType.args");
        }

        @TestMetadata("functionReferenceWithDefaultValuesFeatureIsEnabledWithNewInference.args")
        public void testFunctionReferenceWithDefaultValuesFeatureIsEnabledWithNewInference() throws Exception {
            runTest("compiler/testData/cli/jvm/functionReferenceWithDefaultValuesFeatureIsEnabledWithNewInference.args");
        }

        @TestMetadata("functionReferenceWithDefaultValuesFeatureIsEnabledWithXXNewInference.args")
        public void testFunctionReferenceWithDefaultValuesFeatureIsEnabledWithXXNewInference() throws Exception {
            runTest("compiler/testData/cli/jvm/functionReferenceWithDefaultValuesFeatureIsEnabledWithXXNewInference.args");
        }

        @TestMetadata("help.args")
        public void testHelp() throws Exception {
            runTest("compiler/testData/cli/jvm/help.args");
        }

        @TestMetadata("inapplicableLateinitModifier.args")
        public void testInapplicableLateinitModifier() throws Exception {
            runTest("compiler/testData/cli/jvm/inapplicableLateinitModifier.args");
        }

        @TestMetadata("inlineCycle.args")
        public void testInlineCycle() throws Exception {
            runTest("compiler/testData/cli/jvm/inlineCycle.args");
        }

        @TestMetadata("inlineCycle_ir.args")
        public void testInlineCycle_ir() throws Exception {
            runTest("compiler/testData/cli/jvm/inlineCycle_ir.args");
        }

        @TestMetadata("instanceAccessBeforeSuperCall.args")
        public void testInstanceAccessBeforeSuperCall() throws Exception {
            runTest("compiler/testData/cli/jvm/instanceAccessBeforeSuperCall.args");
        }

        @TestMetadata("internalArgDisableLanguageFeature.args")
        public void testInternalArgDisableLanguageFeature() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgDisableLanguageFeature.args");
        }

        @TestMetadata("internalArgEmptyFeatureName.args")
        public void testInternalArgEmptyFeatureName() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgEmptyFeatureName.args");
        }

        @TestMetadata("internalArgEnableLanguageFeature.args")
        public void testInternalArgEnableLanguageFeature() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgEnableLanguageFeature.args");
        }

        @TestMetadata("internalArgMissingModificator.args")
        public void testInternalArgMissingModificator() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgMissingModificator.args");
        }

        @TestMetadata("internalArgNoWarningForEnablingBugfix.args")
        public void testInternalArgNoWarningForEnablingBugfix() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgNoWarningForEnablingBugfix.args");
        }

        @TestMetadata("internalArgOverrideLanguageFeature.args")
        public void testInternalArgOverrideLanguageFeature() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgOverrideLanguageFeature.args");
        }

        @TestMetadata("internalArgOverrideOffLanguageFeature.args")
        public void testInternalArgOverrideOffLanguageFeature() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgOverrideOffLanguageFeature.args");
        }

        @TestMetadata("internalArgUnrecognizedFeature.args")
        public void testInternalArgUnrecognizedFeature() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgUnrecognizedFeature.args");
        }

        @TestMetadata("internalArgWrongPrefix.args")
        public void testInternalArgWrongPrefix() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgWrongPrefix.args");
        }

        @TestMetadata("internalArgumentOverrideExtraArgument.args")
        public void testInternalArgumentOverrideExtraArgument() throws Exception {
            runTest("compiler/testData/cli/jvm/internalArgumentOverrideExtraArgument.args");
        }

        @TestMetadata("invalidMetadataVersion.args")
        public void testInvalidMetadataVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/invalidMetadataVersion.args");
        }

        @TestMetadata("irSupported.args")
        public void testIrSupported() throws Exception {
            runTest("compiler/testData/cli/jvm/irSupported.args");
        }

        @TestMetadata("javaSrcWrongPackage.args")
        public void testJavaSrcWrongPackage() throws Exception {
            runTest("compiler/testData/cli/jvm/javaSrcWrongPackage.args");
        }

        @TestMetadata("javacKotlinJavaInterdependency.args")
        public void testJavacKotlinJavaInterdependency() throws Exception {
            runTest("compiler/testData/cli/jvm/javacKotlinJavaInterdependency.args");
        }

        @TestMetadata("jdkPathDoesNotExist.args")
        public void testJdkPathDoesNotExist() throws Exception {
            runTest("compiler/testData/cli/jvm/jdkPathDoesNotExist.args");
        }

        @TestMetadata("jdkRelease.args")
        public void testJdkRelease() throws Exception {
            runTest("compiler/testData/cli/jvm/jdkRelease.args");
        }

        @TestMetadata("jspecifyByLv15.args")
        public void testJspecifyByLv15() throws Exception {
            runTest("compiler/testData/cli/jvm/jspecifyByLv15.args");
        }

        @TestMetadata("jspecifyByLv16.args")
        public void testJspecifyByLv16() throws Exception {
            runTest("compiler/testData/cli/jvm/jspecifyByLv16.args");
        }

        @TestMetadata("jspecifyDefault.args")
        public void testJspecifyDefault() throws Exception {
            runTest("compiler/testData/cli/jvm/jspecifyDefault.args");
        }

        @TestMetadata("jspecifyIgnore.args")
        public void testJspecifyIgnore() throws Exception {
            runTest("compiler/testData/cli/jvm/jspecifyIgnore.args");
        }

        @TestMetadata("jspecifyStrict.args")
        public void testJspecifyStrict() throws Exception {
            runTest("compiler/testData/cli/jvm/jspecifyStrict.args");
        }

        @TestMetadata("jspecifyWarn.args")
        public void testJspecifyWarn() throws Exception {
            runTest("compiler/testData/cli/jvm/jspecifyWarn.args");
        }

        @TestMetadata("jsr305AllIgnore.args")
        public void testJsr305AllIgnore() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305AllIgnore.args");
        }

        @TestMetadata("jsr305DefaultMigration.args")
        public void testJsr305DefaultMigration() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305DefaultMigration.args");
        }

        @TestMetadata("jsr305DeprecatedEnable.args")
        public void testJsr305DeprecatedEnable() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305DeprecatedEnable.args");
        }

        @TestMetadata("jsr305DeprecatedIgnore.args")
        public void testJsr305DeprecatedIgnore() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305DeprecatedIgnore.args");
        }

        @TestMetadata("jsr305DeprecatedWarn.args")
        public void testJsr305DeprecatedWarn() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305DeprecatedWarn.args");
        }

        @TestMetadata("jsr305FqNameIgnore.args")
        public void testJsr305FqNameIgnore() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305FqNameIgnore.args");
        }

        @TestMetadata("jsr305FqNameStrict.args")
        public void testJsr305FqNameStrict() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305FqNameStrict.args");
        }

        @TestMetadata("jsr305Ignore.args")
        public void testJsr305Ignore() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305Ignore.args");
        }

        @TestMetadata("jsr305MigrationDefault.args")
        public void testJsr305MigrationDefault() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305MigrationDefault.args");
        }

        @TestMetadata("jsr305MigrationFqNameIgnore.args")
        public void testJsr305MigrationFqNameIgnore() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305MigrationFqNameIgnore.args");
        }

        @TestMetadata("jsr305MigrationIgnore.args")
        public void testJsr305MigrationIgnore() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305MigrationIgnore.args");
        }

        @TestMetadata("jsr305MigrationWarn.args")
        public void testJsr305MigrationWarn() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305MigrationWarn.args");
        }

        @TestMetadata("jsr305NoFlag.args")
        public void testJsr305NoFlag() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305NoFlag.args");
        }

        @TestMetadata("jsr305Strict.args")
        public void testJsr305Strict() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305Strict.args");
        }

        @TestMetadata("jsr305Warn.args")
        public void testJsr305Warn() throws Exception {
            runTest("compiler/testData/cli/jvm/jsr305Warn.args");
        }

        @TestMetadata("jvm6Target.args")
        public void testJvm6Target() throws Exception {
            runTest("compiler/testData/cli/jvm/jvm6Target.args");
        }

        @TestMetadata("jvm8Target.args")
        public void testJvm8Target() throws Exception {
            runTest("compiler/testData/cli/jvm/jvm8Target.args");
        }

        @TestMetadata("jvmDefaultAll.args")
        public void testJvmDefaultAll() throws Exception {
            runTest("compiler/testData/cli/jvm/jvmDefaultAll.args");
        }

        @TestMetadata("jvmIrByDefault1_4.args")
        public void testJvmIrByDefault1_4() throws Exception {
            runTest("compiler/testData/cli/jvm/jvmIrByDefault1_4.args");
        }

        @TestMetadata("jvmIrByDefault1_5.args")
        public void testJvmIrByDefault1_5() throws Exception {
            runTest("compiler/testData/cli/jvm/jvmIrByDefault1_5.args");
        }

        @TestMetadata("jvmRecordOk.args")
        public void testJvmRecordOk() throws Exception {
            runTest("compiler/testData/cli/jvm/jvmRecordOk.args");
        }

        @TestMetadata("jvmRecordWrongTarget.args")
        public void testJvmRecordWrongTarget() throws Exception {
            runTest("compiler/testData/cli/jvm/jvmRecordWrongTarget.args");
        }

        @TestMetadata("kotlinHomeWithoutStdlib.args")
        public void testKotlinHomeWithoutStdlib() throws Exception {
            runTest("compiler/testData/cli/jvm/kotlinHomeWithoutStdlib.args");
        }

        @TestMetadata("kotlinPackage.args")
        public void testKotlinPackage() throws Exception {
            runTest("compiler/testData/cli/jvm/kotlinPackage.args");
        }

        @TestMetadata("kt19628_13.args")
        public void testKt19628_13() throws Exception {
            runTest("compiler/testData/cli/jvm/kt19628_13.args");
        }

        @TestMetadata("kt19628_progressive.args")
        public void testKt19628_progressive() throws Exception {
            runTest("compiler/testData/cli/jvm/kt19628_progressive.args");
        }

        @TestMetadata("kt22304.args")
        public void testKt22304() throws Exception {
            runTest("compiler/testData/cli/jvm/kt22304.args");
        }

        @TestMetadata("kt48833_doNotSuppressVersionErrors.args")
        public void testKt48833_doNotSuppressVersionErrors() throws Exception {
            runTest("compiler/testData/cli/jvm/kt48833_doNotSuppressVersionErrors.args");
        }

        @TestMetadata("kt49209.args")
        public void testKt49209() throws Exception {
            runTest("compiler/testData/cli/jvm/kt49209.args");
        }

        @TestMetadata("kt51846_backendThreadsValidation1.args")
        public void testKt51846_backendThreadsValidation1() throws Exception {
            runTest("compiler/testData/cli/jvm/kt51846_backendThreadsValidation1.args");
        }

        @TestMetadata("kt51846_backendThreadsValidation2.args")
        public void testKt51846_backendThreadsValidation2() throws Exception {
            runTest("compiler/testData/cli/jvm/kt51846_backendThreadsValidation2.args");
        }

        @TestMetadata("kt51846_backendThreadsValidation3.args")
        public void testKt51846_backendThreadsValidation3() throws Exception {
            runTest("compiler/testData/cli/jvm/kt51846_backendThreadsValidation3.args");
        }

        @TestMetadata("languageVersion.args")
        public void testLanguageVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/languageVersion.args");
        }

        @TestMetadata("languageVersionInvalid.args")
        public void testLanguageVersionInvalid() throws Exception {
            runTest("compiler/testData/cli/jvm/languageVersionInvalid.args");
        }

        @TestMetadata("languageVersionUnsupported.args")
        public void testLanguageVersionUnsupported() throws Exception {
            runTest("compiler/testData/cli/jvm/languageVersionUnsupported.args");
        }

        @TestMetadata("legacySmartCastsAfterTry.args")
        public void testLegacySmartCastsAfterTry() throws Exception {
            runTest("compiler/testData/cli/jvm/legacySmartCastsAfterTry.args");
        }

        @TestMetadata("mixingArgfilesAndUsualArgs.args")
        public void testMixingArgfilesAndUsualArgs() throws Exception {
            runTest("compiler/testData/cli/jvm/mixingArgfilesAndUsualArgs.args");
        }

        @TestMetadata("modulesWithDependencyCycle.args")
        public void testModulesWithDependencyCycle() throws Exception {
            runTest("compiler/testData/cli/jvm/modulesWithDependencyCycle.args");
        }

        @TestMetadata("multipleTextRangesInDiagnosticsOrder.args")
        public void testMultipleTextRangesInDiagnosticsOrder() throws Exception {
            runTest("compiler/testData/cli/jvm/multipleTextRangesInDiagnosticsOrder.args");
        }

        @TestMetadata("newInferenceImpliesProgressiveModeForNI.args")
        public void testNewInferenceImpliesProgressiveModeForNI() throws Exception {
            runTest("compiler/testData/cli/jvm/newInferenceImpliesProgressiveModeForNI.args");
        }

        @TestMetadata("newInferenceImpliesSamConversions.args")
        public void testNewInferenceImpliesSamConversions() throws Exception {
            runTest("compiler/testData/cli/jvm/newInferenceImpliesSamConversions.args");
        }

        @TestMetadata("newInferenceWithOldFlagImpliesSamConversions.args")
        public void testNewInferenceWithOldFlagImpliesSamConversions() throws Exception {
            runTest("compiler/testData/cli/jvm/newInferenceWithOldFlagImpliesSamConversions.args");
        }

        @TestMetadata("newLineInPackage.args")
        public void testNewLineInPackage() throws Exception {
            runTest("compiler/testData/cli/jvm/newLineInPackage.args");
        }

        @TestMetadata("noReflect.args")
        public void testNoReflect() throws Exception {
            runTest("compiler/testData/cli/jvm/noReflect.args");
        }

        @TestMetadata("noStdlib.args")
        public void testNoStdlib() throws Exception {
            runTest("compiler/testData/cli/jvm/noStdlib.args");
        }

        @TestMetadata("nonExistingClassPathAndAnnotationsPath.args")
        public void testNonExistingClassPathAndAnnotationsPath() throws Exception {
            runTest("compiler/testData/cli/jvm/nonExistingClassPathAndAnnotationsPath.args");
        }

        @TestMetadata("nonExistingPhaseName.args")
        public void testNonExistingPhaseName() throws Exception {
            runTest("compiler/testData/cli/jvm/nonExistingPhaseName.args");
        }

        @TestMetadata("nonExistingSourcePath.args")
        public void testNonExistingSourcePath() throws Exception {
            runTest("compiler/testData/cli/jvm/nonExistingSourcePath.args");
        }

        @TestMetadata("nonLocalDisabled.args")
        public void testNonLocalDisabled() throws Exception {
            runTest("compiler/testData/cli/jvm/nonLocalDisabled.args");
        }

        @TestMetadata("nonLocalDisabled_ir.args")
        public void testNonLocalDisabled_ir() throws Exception {
            runTest("compiler/testData/cli/jvm/nonLocalDisabled_ir.args");
        }

        @TestMetadata("nonexistentPathInModule.args")
        public void testNonexistentPathInModule() throws Exception {
            runTest("compiler/testData/cli/jvm/nonexistentPathInModule.args");
        }

        @TestMetadata("nonexistentScript.args")
        public void testNonexistentScript() throws Exception {
            runTest("compiler/testData/cli/jvm/nonexistentScript.args");
        }

        @TestMetadata("nonexistingArgfile.args")
        public void testNonexistingArgfile() throws Exception {
            runTest("compiler/testData/cli/jvm/nonexistingArgfile.args");
        }

        @TestMetadata("nullabilityAnnotations.args")
        public void testNullabilityAnnotations() throws Exception {
            runTest("compiler/testData/cli/jvm/nullabilityAnnotations.args");
        }

        @TestMetadata("oldBackendLv16.args")
        public void testOldBackendLv16() throws Exception {
            runTest("compiler/testData/cli/jvm/oldBackendLv16.args");
        }

        @TestMetadata("optInEmptyMessage.args")
        public void testOptInEmptyMessage() throws Exception {
            runTest("compiler/testData/cli/jvm/optInEmptyMessage.args");
        }

        @TestMetadata("optInEmptyMessageFir.args")
        public void testOptInEmptyMessageFir() throws Exception {
            runTest("compiler/testData/cli/jvm/optInEmptyMessageFir.args");
        }

        @TestMetadata("optInOverrideMessage.args")
        public void testOptInOverrideMessage() throws Exception {
            runTest("compiler/testData/cli/jvm/optInOverrideMessage.args");
        }

        @TestMetadata("optInOverrideMessageFir.args")
        public void testOptInOverrideMessageFir() throws Exception {
            runTest("compiler/testData/cli/jvm/optInOverrideMessageFir.args");
        }

        @TestMetadata("pluginSimple.args")
        public void testPluginSimple() throws Exception {
            runTest("compiler/testData/cli/jvm/pluginSimple.args");
        }

        @TestMetadata("pluginWithK2Error.args")
        public void testPluginWithK2Error() throws Exception {
            runTest("compiler/testData/cli/jvm/pluginWithK2Error.args");
        }

        @TestMetadata("progressiveModeOff.args")
        public void testProgressiveModeOff() throws Exception {
            runTest("compiler/testData/cli/jvm/progressiveModeOff.args");
        }

        @TestMetadata("progressiveModeOn.args")
        public void testProgressiveModeOn() throws Exception {
            runTest("compiler/testData/cli/jvm/progressiveModeOn.args");
        }

        @TestMetadata("recordAsSingleFileRoot.args")
        public void testRecordAsSingleFileRoot() throws Exception {
            runTest("compiler/testData/cli/jvm/recordAsSingleFileRoot.args");
        }

        @TestMetadata("reportInternalDiagnosticNames.args")
        public void testReportInternalDiagnosticNames() throws Exception {
            runTest("compiler/testData/cli/jvm/reportInternalDiagnosticNames.args");
        }

        @TestMetadata("requireKotlinCompilerVersion.args")
        public void testRequireKotlinCompilerVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/requireKotlinCompilerVersion.args");
        }

        @TestMetadata("resultInReturnTypeSupportedByDefault15.args")
        public void testResultInReturnTypeSupportedByDefault15() throws Exception {
            runTest("compiler/testData/cli/jvm/resultInReturnTypeSupportedByDefault15.args");
        }

        @TestMetadata("resultInReturnTypeUnsupportedByDefault14.args")
        public void testResultInReturnTypeUnsupportedByDefault14() throws Exception {
            runTest("compiler/testData/cli/jvm/resultInReturnTypeUnsupportedByDefault14.args");
        }

        @TestMetadata("resultInReturnTypeWithEnabledInlineClasses.args")
        public void testResultInReturnTypeWithEnabledInlineClasses() throws Exception {
            runTest("compiler/testData/cli/jvm/resultInReturnTypeWithEnabledInlineClasses.args");
        }

        @TestMetadata("resultInReturnTypeWithEnabledInlineClassesXX.args")
        public void testResultInReturnTypeWithEnabledInlineClassesXX() throws Exception {
            runTest("compiler/testData/cli/jvm/resultInReturnTypeWithEnabledInlineClassesXX.args");
        }

        @TestMetadata("returnAsWhenKey.args")
        public void testReturnAsWhenKey() throws Exception {
            runTest("compiler/testData/cli/jvm/returnAsWhenKey.args");
        }

        @TestMetadata("sanitized-name.clash.args")
        public void testSanitized_name_clash() throws Exception {
            runTest("compiler/testData/cli/jvm/sanitized-name.clash.args");
        }

        @TestMetadata("selfUpperBoundInference.args")
        public void testSelfUpperBoundInference() throws Exception {
            runTest("compiler/testData/cli/jvm/selfUpperBoundInference.args");
        }

        @TestMetadata("signatureClash.args")
        public void testSignatureClash() throws Exception {
            runTest("compiler/testData/cli/jvm/signatureClash.args");
        }

        @TestMetadata("simple.args")
        public void testSimple() throws Exception {
            runTest("compiler/testData/cli/jvm/simple.args");
        }

        @TestMetadata("singleJavaFileRoots.args")
        public void testSingleJavaFileRoots() throws Exception {
            runTest("compiler/testData/cli/jvm/singleJavaFileRoots.args");
        }

        @TestMetadata("standaloneSamConversionsAreEnabledWithNewInference.args")
        public void testStandaloneSamConversionsAreEnabledWithNewInference() throws Exception {
            runTest("compiler/testData/cli/jvm/standaloneSamConversionsAreEnabledWithNewInference.args");
        }

        @TestMetadata("standaloneSamConversionsAreEnabledWithNewInferenceInternalFlag.args")
        public void testStandaloneSamConversionsAreEnabledWithNewInferenceInternalFlag() throws Exception {
            runTest("compiler/testData/cli/jvm/standaloneSamConversionsAreEnabledWithNewInferenceInternalFlag.args");
        }

        @TestMetadata("suppressAllWarningsJvm.args")
        public void testSuppressAllWarningsJvm() throws Exception {
            runTest("compiler/testData/cli/jvm/suppressAllWarningsJvm.args");
        }

        @TestMetadata("suspendInFunInterfaceDefault.args")
        public void testSuspendInFunInterfaceDefault() throws Exception {
            runTest("compiler/testData/cli/jvm/suspendInFunInterfaceDefault.args");
        }

        @TestMetadata("suspendInFunInterfaceIrDisabled.args")
        public void testSuspendInFunInterfaceIrDisabled() throws Exception {
            runTest("compiler/testData/cli/jvm/suspendInFunInterfaceIrDisabled.args");
        }

        @TestMetadata("suspendInFunInterfaceIrEnabled.args")
        public void testSuspendInFunInterfaceIrEnabled() throws Exception {
            runTest("compiler/testData/cli/jvm/suspendInFunInterfaceIrEnabled.args");
        }

        @TestMetadata("suspensionPointInMonitor.args")
        public void testSuspensionPointInMonitor() throws Exception {
            runTest("compiler/testData/cli/jvm/suspensionPointInMonitor.args");
        }

        @TestMetadata("syntheticAccessorForPropertiesSignatureClash.args")
        public void testSyntheticAccessorForPropertiesSignatureClash() throws Exception {
            runTest("compiler/testData/cli/jvm/syntheticAccessorForPropertiesSignatureClash.args");
        }

        @TestMetadata("syntheticAccessorPropertyAndFunSignatureClash.args")
        public void testSyntheticAccessorPropertyAndFunSignatureClash() throws Exception {
            runTest("compiler/testData/cli/jvm/syntheticAccessorPropertyAndFunSignatureClash.args");
        }

        @TestMetadata("syntheticAccessorSignatureClash.args")
        public void testSyntheticAccessorSignatureClash() throws Exception {
            runTest("compiler/testData/cli/jvm/syntheticAccessorSignatureClash.args");
        }

        @TestMetadata("unknownExtraFlags.args")
        public void testUnknownExtraFlags() throws Exception {
            runTest("compiler/testData/cli/jvm/unknownExtraFlags.args");
        }

        @TestMetadata("unrestrictedBuilderInference.args")
        public void testUnrestrictedBuilderInference() throws Exception {
            runTest("compiler/testData/cli/jvm/unrestrictedBuilderInference.args");
        }

        @TestMetadata("useDeclarationThatWasExperimentalWithoutExplicitImport.args")
        public void testUseDeclarationThatWasExperimentalWithoutExplicitImport() throws Exception {
            runTest("compiler/testData/cli/jvm/useDeclarationThatWasExperimentalWithoutExplicitImport.args");
        }

        @TestMetadata("useDeclarationThatWasExperimentalWithoutExplicitImportCommandLine.args")
        public void testUseDeclarationThatWasExperimentalWithoutExplicitImportCommandLine() throws Exception {
            runTest("compiler/testData/cli/jvm/useDeclarationThatWasExperimentalWithoutExplicitImportCommandLine.args");
        }

        @TestMetadata("useDeclarationThatWasExperimentalWithoutMarker.args")
        public void testUseDeclarationThatWasExperimentalWithoutMarker() throws Exception {
            runTest("compiler/testData/cli/jvm/useDeclarationThatWasExperimentalWithoutMarker.args");
        }

        @TestMetadata("useDeclarationThatWasExperimentalWithoutMarker2.args")
        public void testUseDeclarationThatWasExperimentalWithoutMarker2() throws Exception {
            runTest("compiler/testData/cli/jvm/useDeclarationThatWasExperimentalWithoutMarker2.args");
        }

        @TestMetadata("useMixedNamedArgumentsFlag.args")
        public void testUseMixedNamedArgumentsFlag() throws Exception {
            runTest("compiler/testData/cli/jvm/useMixedNamedArgumentsFlag.args");
        }

        @TestMetadata("variableInWhenSubject.args")
        public void testVariableInWhenSubject() throws Exception {
            runTest("compiler/testData/cli/jvm/variableInWhenSubject.args");
        }

        @TestMetadata("warningJdkWithNoJdk.args")
        public void testWarningJdkWithNoJdk() throws Exception {
            runTest("compiler/testData/cli/jvm/warningJdkWithNoJdk.args");
        }

        @TestMetadata("warningsInDummy.args")
        public void testWarningsInDummy() throws Exception {
            runTest("compiler/testData/cli/jvm/warningsInDummy.args");
        }

        @TestMetadata("werror.args")
        public void testWerror() throws Exception {
            runTest("compiler/testData/cli/jvm/werror.args");
        }

        @TestMetadata("werrorWithExplicitError.args")
        public void testWerrorWithExplicitError() throws Exception {
            runTest("compiler/testData/cli/jvm/werrorWithExplicitError.args");
        }

        @TestMetadata("werrorWithNoWarn.args")
        public void testWerrorWithNoWarn() throws Exception {
            runTest("compiler/testData/cli/jvm/werrorWithNoWarn.args");
        }

        @TestMetadata("werrorWithStrongWarning.args")
        public void testWerrorWithStrongWarning() throws Exception {
            runTest("compiler/testData/cli/jvm/werrorWithStrongWarning.args");
        }

        @TestMetadata("wrongAbiVersion.args")
        public void testWrongAbiVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongAbiVersion.args");
        }

        @TestMetadata("wrongAnnotationArgumentInCtor.args")
        public void testWrongAnnotationArgumentInCtor() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongAnnotationArgumentInCtor.args");
        }

        @TestMetadata("wrongArgument.args")
        public void testWrongArgument() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongArgument.args");
        }

        @TestMetadata("wrongJdkPath.args")
        public void testWrongJdkPath() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongJdkPath.args");
        }

        @TestMetadata("wrongJvmTargetVersion.args")
        public void testWrongJvmTargetVersion() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongJvmTargetVersion.args");
        }

        @TestMetadata("wrongScriptWithDirectory.args")
        public void testWrongScriptWithDirectory() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongScriptWithDirectory.args");
        }

        @TestMetadata("wrongScriptWithKtSource.args")
        public void testWrongScriptWithKtSource() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongScriptWithKtSource.args");
        }

        @TestMetadata("wrongScriptWithNoSource.args")
        public void testWrongScriptWithNoSource() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongScriptWithNoSource.args");
        }

        @TestMetadata("wrongXjsr305.args")
        public void testWrongXjsr305() throws Exception {
            runTest("compiler/testData/cli/jvm/wrongXjsr305.args");
        }
    }

    @TestMetadata("compiler/testData/cli/js")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Js extends AbstractCliTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doJsTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInJs() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/cli/js"), Pattern.compile("^(.+)\\.args$"), null, false);
        }

        @TestMetadata("createMetadata.args")
        public void testCreateMetadata() throws Exception {
            runTest("compiler/testData/cli/js/createMetadata.args");
        }

        @TestMetadata("emptySources.args")
        public void testEmptySources() throws Exception {
            runTest("compiler/testData/cli/js/emptySources.args");
        }

        @TestMetadata("fir.args")
        public void testFir() throws Exception {
            runTest("compiler/testData/cli/js/fir.args");
        }

        @TestMetadata("inlineCycle.args")
        public void testInlineCycle() throws Exception {
            runTest("compiler/testData/cli/js/inlineCycle.args");
        }

        @TestMetadata("jsExtraHelp.args")
        public void testJsExtraHelp() throws Exception {
            runTest("compiler/testData/cli/js/jsExtraHelp.args");
        }

        @TestMetadata("jsHelp.args")
        public void testJsHelp() throws Exception {
            runTest("compiler/testData/cli/js/jsHelp.args");
        }

        @TestMetadata("kotlinHomeWithoutStdlib.args")
        public void testKotlinHomeWithoutStdlib() throws Exception {
            runTest("compiler/testData/cli/js/kotlinHomeWithoutStdlib.args");
        }

        @TestMetadata("kotlinPackage.args")
        public void testKotlinPackage() throws Exception {
            runTest("compiler/testData/cli/js/kotlinPackage.args");
        }

        @TestMetadata("languageVersion.args")
        public void testLanguageVersion() throws Exception {
            runTest("compiler/testData/cli/js/languageVersion.args");
        }

        @TestMetadata("libraryDirNotFound.args")
        public void testLibraryDirNotFound() throws Exception {
            runTest("compiler/testData/cli/js/libraryDirNotFound.args");
        }

        @TestMetadata("moduleWithMetadataOnlyDependency.args")
        public void testModuleWithMetadataOnlyDependency() throws Exception {
            runTest("compiler/testData/cli/js/moduleWithMetadataOnlyDependency.args");
        }

        @TestMetadata("modulesWithSameNames.args")
        public void testModulesWithSameNames() throws Exception {
            runTest("compiler/testData/cli/js/modulesWithSameNames.args");
        }

        @TestMetadata("modulesWithSameNamesAndFunc.args")
        public void testModulesWithSameNamesAndFunc() throws Exception {
            runTest("compiler/testData/cli/js/modulesWithSameNamesAndFunc.args");
        }

        @TestMetadata("nonExistingKotlinHome.args")
        public void testNonExistingKotlinHome() throws Exception {
            runTest("compiler/testData/cli/js/nonExistingKotlinHome.args");
        }

        @TestMetadata("nonExistingSourcePath.args")
        public void testNonExistingSourcePath() throws Exception {
            runTest("compiler/testData/cli/js/nonExistingSourcePath.args");
        }

        @TestMetadata("notValidLibraryDir.args")
        public void testNotValidLibraryDir() throws Exception {
            runTest("compiler/testData/cli/js/notValidLibraryDir.args");
        }

        @TestMetadata("outputIsDirectory.args")
        public void testOutputIsDirectory() throws Exception {
            runTest("compiler/testData/cli/js/outputIsDirectory.args");
        }

        @TestMetadata("outputPostfixFileNotFound.args")
        public void testOutputPostfixFileNotFound() throws Exception {
            runTest("compiler/testData/cli/js/outputPostfixFileNotFound.args");
        }

        @TestMetadata("outputPrefixFileNotFound.args")
        public void testOutputPrefixFileNotFound() throws Exception {
            runTest("compiler/testData/cli/js/outputPrefixFileNotFound.args");
        }

        @TestMetadata("reifiedIntersectionType.args")
        public void testReifiedIntersectionType() throws Exception {
            runTest("compiler/testData/cli/js/reifiedIntersectionType.args");
        }

        @TestMetadata("simple2js.args")
        public void testSimple2js() throws Exception {
            runTest("compiler/testData/cli/js/simple2js.args");
        }

        @TestMetadata("sourceMap.args")
        public void testSourceMap() throws Exception {
            runTest("compiler/testData/cli/js/sourceMap.args");
        }

        @TestMetadata("sourceMapCharEscape.args")
        public void testSourceMapCharEscape() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapCharEscape.args");
        }

        @TestMetadata("sourceMapDuplicateRelativePaths.args")
        public void testSourceMapDuplicateRelativePaths() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapDuplicateRelativePaths.args");
        }

        @TestMetadata("sourceMapEmbedSources.args")
        public void testSourceMapEmbedSources() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapEmbedSources.args");
        }

        @TestMetadata("sourceMapPrefix.args")
        public void testSourceMapPrefix() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapPrefix.args");
        }

        @TestMetadata("sourceMapRelativeRoot.args")
        public void testSourceMapRelativeRoot() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapRelativeRoot.args");
        }

        @TestMetadata("sourceMapRootAuto.args")
        public void testSourceMapRootAuto() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapRootAuto.args");
        }

        @TestMetadata("sourceMapRootManual.args")
        public void testSourceMapRootManual() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapRootManual.args");
        }

        @TestMetadata("sourceMapRootMissing.args")
        public void testSourceMapRootMissing() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapRootMissing.args");
        }

        @TestMetadata("sourceMapRootMultiple.args")
        public void testSourceMapRootMultiple() throws Exception {
            runTest("compiler/testData/cli/js/sourceMapRootMultiple.args");
        }

        @TestMetadata("suppressAllWarningsJS.args")
        public void testSuppressAllWarningsJS() throws Exception {
            runTest("compiler/testData/cli/js/suppressAllWarningsJS.args");
        }

        @TestMetadata("withFolderAsLib.args")
        public void testWithFolderAsLib() throws Exception {
            runTest("compiler/testData/cli/js/withFolderAsLib.args");
        }

        @TestMetadata("withLib.args")
        public void testWithLib() throws Exception {
            runTest("compiler/testData/cli/js/withLib.args");
        }

        @TestMetadata("wrongAbiVersion.args")
        public void testWrongAbiVersion() throws Exception {
            runTest("compiler/testData/cli/js/wrongAbiVersion.args");
        }
    }

    @TestMetadata("compiler/testData/cli/js-dce")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Js_dce extends AbstractCliTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doJsDceTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInJs_dce() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/cli/js-dce"), Pattern.compile("^(.+)\\.args$"), null, false);
        }

        @TestMetadata("dceExtraHelp.args")
        public void testDceExtraHelp() throws Exception {
            runTest("compiler/testData/cli/js-dce/dceExtraHelp.args");
        }

        @TestMetadata("dceHelp.args")
        public void testDceHelp() throws Exception {
            runTest("compiler/testData/cli/js-dce/dceHelp.args");
        }

        @TestMetadata("emptySources.args")
        public void testEmptySources() throws Exception {
            runTest("compiler/testData/cli/js-dce/emptySources.args");
        }

        @TestMetadata("includeDeclarations.args")
        public void testIncludeDeclarations() throws Exception {
            runTest("compiler/testData/cli/js-dce/includeDeclarations.args");
        }

        @TestMetadata("invalidFilename.args")
        public void testInvalidFilename() throws Exception {
            runTest("compiler/testData/cli/js-dce/invalidFilename.args");
        }

        @TestMetadata("nonExistingSourcePath.args")
        public void testNonExistingSourcePath() throws Exception {
            runTest("compiler/testData/cli/js-dce/nonExistingSourcePath.args");
        }

        @TestMetadata("notFile.args")
        public void testNotFile() throws Exception {
            runTest("compiler/testData/cli/js-dce/notFile.args");
        }

        @TestMetadata("outputIsDirectory.args")
        public void testOutputIsDirectory() throws Exception {
            runTest("compiler/testData/cli/js-dce/outputIsDirectory.args");
        }

        @TestMetadata("parseError.args")
        public void testParseError() throws Exception {
            runTest("compiler/testData/cli/js-dce/parseError.args");
        }

        @TestMetadata("printReachability.args")
        public void testPrintReachability() throws Exception {
            runTest("compiler/testData/cli/js-dce/printReachability.args");
        }

        @TestMetadata("simple.args")
        public void testSimple() throws Exception {
            runTest("compiler/testData/cli/js-dce/simple.args");
        }

        @TestMetadata("withSourceMap.args")
        public void testWithSourceMap() throws Exception {
            runTest("compiler/testData/cli/js-dce/withSourceMap.args");
        }
    }

    @TestMetadata("compiler/testData/cli/metadata")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Metadata extends AbstractCliTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doMetadataTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInMetadata() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/cli/metadata"), Pattern.compile("^(.+)\\.args$"), null, false);
        }

        @TestMetadata("anonymousObjectType.args")
        public void testAnonymousObjectType() throws Exception {
            runTest("compiler/testData/cli/metadata/anonymousObjectType.args");
        }

        @TestMetadata("fir.args")
        public void testFir() throws Exception {
            runTest("compiler/testData/cli/metadata/fir.args");
        }

        @TestMetadata("inheritorOfExpectSealedClass.args")
        public void testInheritorOfExpectSealedClass() throws Exception {
            runTest("compiler/testData/cli/metadata/inheritorOfExpectSealedClass.args");
        }

        @TestMetadata("kotlinPackage.args")
        public void testKotlinPackage() throws Exception {
            runTest("compiler/testData/cli/metadata/kotlinPackage.args");
        }

        @TestMetadata("moduleName.args")
        public void testModuleName() throws Exception {
            runTest("compiler/testData/cli/metadata/moduleName.args");
        }

        @TestMetadata("optionalExpectationUsage.args")
        public void testOptionalExpectationUsage() throws Exception {
            runTest("compiler/testData/cli/metadata/optionalExpectationUsage.args");
        }
    }
}
