/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/bytecodeListing")
@TestDataPath("$PROJECT_ROOT")
public class IrBytecodeListingTestGenerated extends AbstractIrBytecodeListingTest {
    @Test
    @TestMetadata("accessorForProtectedPropertyWithPrivateSetter.kt")
    public void testAccessorForProtectedPropertyWithPrivateSetter() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetter.kt");
    }

    @Test
    @TestMetadata("accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt")
    public void testAccessorForProtectedPropertyWithPrivateSetterInObjectLiteral() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt");
    }

    @Test
    @TestMetadata("accessorForTopLevelMembers.kt")
    public void testAccessorForTopLevelMembers() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/accessorForTopLevelMembers.kt");
    }

    @Test
    @TestMetadata("accessorsForProtectedStaticJavaFieldInOtherPackage.kt")
    public void testAccessorsForProtectedStaticJavaFieldInOtherPackage() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/accessorsForProtectedStaticJavaFieldInOtherPackage.kt");
    }

    @Test
    public void testAllFilesPresentInBytecodeListing() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("anonymousObjectInGenericFun.kt")
    public void testAnonymousObjectInGenericFun() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/anonymousObjectInGenericFun.kt");
    }

    @Test
    @TestMetadata("callableNameIntrinsic.kt")
    public void testCallableNameIntrinsic() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/callableNameIntrinsic.kt");
    }

    @Test
    @TestMetadata("callableReferenceArrayConstructorArguments.kt")
    public void testCallableReferenceArrayConstructorArguments() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/callableReferenceArrayConstructorArguments.kt");
    }

    @Test
    @TestMetadata("cloneable.kt")
    public void testCloneable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/cloneable.kt");
    }

    @Test
    @TestMetadata("companionObjectVisibility_after.kt")
    public void testCompanionObjectVisibility_after() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_after.kt");
    }

    @Test
    @TestMetadata("companionObjectVisibility_before.kt")
    public void testCompanionObjectVisibility_before() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_before.kt");
    }

    @Test
    @TestMetadata("defaultImpls.kt")
    public void testDefaultImpls() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/defaultImpls.kt");
    }

    @Test
    @TestMetadata("delegationToJavaInterfaceWithWildcardType.kt")
    public void testDelegationToJavaInterfaceWithWildcardType() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/delegationToJavaInterfaceWithWildcardType.kt");
    }

    @Test
    @TestMetadata("deserializeLambdaMethod.kt")
    public void testDeserializeLambdaMethod() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/deserializeLambdaMethod.kt");
    }

    @Test
    @TestMetadata("enum.kt")
    public void testEnum() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/enum.kt");
    }

    @Test
    @TestMetadata("extension.kt")
    public void testExtension() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/extension.kt");
    }

    @Test
    @TestMetadata("fileClassWithPrivateDeclarationsOnly_after.kt")
    public void testFileClassWithPrivateDeclarationsOnly_after() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_after.kt");
    }

    @Test
    @TestMetadata("fileClassWithPrivateDeclarationsOnly_before.kt")
    public void testFileClassWithPrivateDeclarationsOnly_before() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_before.kt");
    }

    @Test
    @TestMetadata("immutableCollection.kt")
    public void testImmutableCollection() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/immutableCollection.kt");
    }

    @Test
    @TestMetadata("javaDeprecated.kt")
    public void testJavaDeprecated() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/javaDeprecated.kt");
    }

    @Test
    @TestMetadata("jvmOverloadsAndParametersAnnotations.kt")
    public void testJvmOverloadsAndParametersAnnotations() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsAndParametersAnnotations.kt");
    }

    @Test
    @TestMetadata("jvmOverloadsExternal.kt")
    public void testJvmOverloadsExternal() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsExternal.kt");
    }

    @Test
    @TestMetadata("jvmRecordStructure.kt")
    public void testJvmRecordStructure() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/jvmRecordStructure.kt");
    }

    @Test
    @TestMetadata("kt42137.kt")
    public void testKt42137() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/kt42137.kt");
    }

    @Test
    @TestMetadata("kt42879.kt")
    public void testKt42879() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/kt42879.kt");
    }

    @Test
    @TestMetadata("kt43217.kt")
    public void testKt43217() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/kt43217.kt");
    }

    @Test
    @TestMetadata("kt43440.kt")
    public void testKt43440() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/kt43440.kt");
    }

    @Test
    @TestMetadata("kt45853.kt")
    public void testKt45853() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/kt45853.kt");
    }

    @Test
    @TestMetadata("kt45853a.kt")
    public void testKt45853a() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/kt45853a.kt");
    }

    @Test
    @TestMetadata("kt45934.kt")
    public void testKt45934() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/kt45934.kt");
    }

    @Test
    @TestMetadata("kt47328.kt")
    public void testKt47328() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/kt47328.kt");
    }

    @Test
    @TestMetadata("noCollectionStubMethodsInInterface.kt")
    public void testNoCollectionStubMethodsInInterface() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/noCollectionStubMethodsInInterface.kt");
    }

    @Test
    @TestMetadata("noDelegationsToPrivateInterfaceMembers.kt")
    public void testNoDelegationsToPrivateInterfaceMembers() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/noDelegationsToPrivateInterfaceMembers.kt");
    }

    @Test
    @TestMetadata("noReceiverInCallableReferenceClasses.kt")
    public void testNoReceiverInCallableReferenceClasses() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/noReceiverInCallableReferenceClasses.kt");
    }

    @Test
    @TestMetadata("noRemoveAtInReadOnly.kt")
    public void testNoRemoveAtInReadOnly() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/noRemoveAtInReadOnly.kt");
    }

    @Test
    @TestMetadata("overrideWithPrimitiveUpperBound.kt")
    public void testOverrideWithPrimitiveUpperBound() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound.kt");
    }

    @Test
    @TestMetadata("overrideWithPrimitiveUpperBound2.kt")
    public void testOverrideWithPrimitiveUpperBound2() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound2.kt");
    }

    @Test
    @TestMetadata("privateCompanionFields.kt")
    public void testPrivateCompanionFields() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/privateCompanionFields.kt");
    }

    @Test
    @TestMetadata("privateDefaultImpls.kt")
    public void testPrivateDefaultImpls() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/privateDefaultImpls.kt");
    }

    @Test
    @TestMetadata("privateDefaultSetter.kt")
    public void testPrivateDefaultSetter() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/privateDefaultSetter.kt");
    }

    @Test
    @TestMetadata("privateNestedClassInInterface.kt")
    public void testPrivateNestedClassInInterface() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/privateNestedClassInInterface.kt");
    }

    @Test
    @TestMetadata("rawTypeInSignature.kt")
    public void testRawTypeInSignature() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/rawTypeInSignature.kt");
    }

    @Test
    @TestMetadata("strictfpFlag.kt")
    public void testStrictfpFlag() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/strictfpFlag.kt");
    }

    @Test
    @TestMetadata("synchronizedFlag.kt")
    public void testSynchronizedFlag() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/synchronizedFlag.kt");
    }

    @Test
    @TestMetadata("varargsBridge.kt")
    public void testVarargsBridge() throws Exception {
        runTest("compiler/testData/codegen/bytecodeListing/varargsBridge.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
        @Test
        public void testAllFilesPresentInAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("annotationCtorCallGenerateSynthetic.kt")
        public void testAnnotationCtorCallGenerateSynthetic() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallGenerateSynthetic.kt");
        }

        @Test
        @TestMetadata("annotationCtorCallNoSynthetic.kt")
        public void testAnnotationCtorCallNoSynthetic() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallNoSynthetic.kt");
        }

        @Test
        @TestMetadata("annotationsOnDelegatedMembers.kt")
        public void testAnnotationsOnDelegatedMembers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationsOnDelegatedMembers.kt");
        }

        @Test
        @TestMetadata("defaultTargets.kt")
        public void testDefaultTargets() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/defaultTargets.kt");
        }

        @Test
        @TestMetadata("deprecatedJvmOverloads.kt")
        public void testDeprecatedJvmOverloads() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/deprecatedJvmOverloads.kt");
        }

        @Test
        @TestMetadata("internalPropertyOrTypealias.kt")
        public void testInternalPropertyOrTypealias() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/internalPropertyOrTypealias.kt");
        }

        @Test
        @TestMetadata("JvmSynthetic.kt")
        public void testJvmSynthetic() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/JvmSynthetic.kt");
        }

        @Test
        @TestMetadata("kt27895.kt")
        public void testKt27895() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/kt27895.kt");
        }

        @Test
        @TestMetadata("kt43399.kt")
        public void testKt43399() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43399.kt");
        }

        @Test
        @TestMetadata("kt43459.kt")
        public void testKt43459() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43459.kt");
        }

        @Test
        @TestMetadata("kt9320.kt")
        public void testKt9320() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/kt9320.kt");
        }

        @Test
        @TestMetadata("literals.kt")
        public void testLiterals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/literals.kt");
        }

        @Test
        @TestMetadata("localClassWithCapturedParams.kt")
        public void testLocalClassWithCapturedParams() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/localClassWithCapturedParams.kt");
        }

        @Test
        @TestMetadata("noAdditionalAnnotationsInAccessors.kt")
        public void testNoAdditionalAnnotationsInAccessors() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/noAdditionalAnnotationsInAccessors.kt");
        }

        @Test
        @TestMetadata("noAnnotationsInSyntheticAccessors.kt")
        public void testNoAnnotationsInSyntheticAccessors() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/noAnnotationsInSyntheticAccessors.kt");
        }

        @Test
        @TestMetadata("onProperties.kt")
        public void testOnProperties() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/onProperties.kt");
        }

        @Test
        @TestMetadata("onReceiver.kt")
        public void testOnReceiver() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/onReceiver.kt");
        }

        @Test
        @TestMetadata("unsignedTypes.kt")
        public void testUnsignedTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/annotations/unsignedTypes.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/annotations/repeatable")
        @TestDataPath("$PROJECT_ROOT")
        public class Repeatable {
            @Test
            public void testAllFilesPresentInRepeatable() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("javaAnnotation.kt")
            public void testJavaAnnotation() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/javaAnnotation.kt");
            }

            @Test
            @TestMetadata("kotlinAnnotation.kt")
            public void testKotlinAnnotation() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotation.kt");
            }

            @Test
            @TestMetadata("kotlinAnnotationWithBothRepeatables.kt")
            public void testKotlinAnnotationWithBothRepeatables() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotationWithBothRepeatables.kt");
            }

            @Test
            @TestMetadata("kotlinSpecificTargets.kt")
            public void testKotlinSpecificTargets() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinSpecificTargets.kt");
            }

            @Test
            @TestMetadata("multipleRepeatableOrder.kt")
            public void testMultipleRepeatableOrder() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/multipleRepeatableOrder.kt");
            }

            @Test
            @TestMetadata("nonRepeatedAnnotationWithItsContainer.kt")
            public void testNonRepeatedAnnotationWithItsContainer() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/nonRepeatedAnnotationWithItsContainer.kt");
            }

            @Test
            @TestMetadata("propertyGetterUseSiteTarget.kt")
            public void testPropertyGetterUseSiteTarget() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/propertyGetterUseSiteTarget.kt");
            }

            @Test
            @TestMetadata("retentionAndTarget.kt")
            public void testRetentionAndTarget() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/retentionAndTarget.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReference {
        @Test
        @TestMetadata("adaptedReference.kt")
        public void testAdaptedReference() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/callableReference/adaptedReference.kt");
        }

        @Test
        public void testAllFilesPresentInCallableReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs")
    @TestDataPath("$PROJECT_ROOT")
    public class CollectionStubs {
        @Test
        @TestMetadata("abstractMapRedefiningGetAny.kt")
        public void testAbstractMapRedefiningGetAny() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractMapRedefiningGetAny.kt");
        }

        @Test
        public void testAllFilesPresentInCollectionStubs() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("collectionByDelegation.kt")
        public void testCollectionByDelegation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation.kt");
        }

        @Test
        @TestMetadata("collectionByDelegation2.kt")
        public void testCollectionByDelegation2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2.kt");
        }

        @Test
        @TestMetadata("collectionByDelegation2WithFullJdk.kt")
        public void testCollectionByDelegation2WithFullJdk() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2WithFullJdk.kt");
        }

        @Test
        @TestMetadata("collectionByDelegation3.kt")
        public void testCollectionByDelegation3() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3.kt");
        }

        @Test
        @TestMetadata("collectionByDelegation3WithFullJdk.kt")
        public void testCollectionByDelegation3WithFullJdk() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3WithFullJdk.kt");
        }

        @Test
        @TestMetadata("collectionByDelegationWithFullJdk.kt")
        public void testCollectionByDelegationWithFullJdk() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegationWithFullJdk.kt");
        }

        @Test
        @TestMetadata("collectionWithInternalRemove.kt")
        public void testCollectionWithInternalRemove() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionWithInternalRemove.kt");
        }

        @Test
        @TestMetadata("collectionsWithFullJdk.kt")
        public void testCollectionsWithFullJdk() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionsWithFullJdk.kt");
        }

        @Test
        @TestMetadata("customListIterator.kt")
        public void testCustomListIterator() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customListIterator.kt");
        }

        @Test
        @TestMetadata("customMutableListIterator.kt")
        public void testCustomMutableListIterator() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customMutableListIterator.kt");
        }

        @Test
        @TestMetadata("emptyList.kt")
        public void testEmptyList() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/emptyList.kt");
        }

        @Test
        @TestMetadata("extendingAbstractCollection.kt")
        public void testExtendingAbstractCollection() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/extendingAbstractCollection.kt");
        }

        @Test
        @TestMetadata("inheritingFromAbstractCollections.kt")
        public void testInheritingFromAbstractCollections() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractCollections.kt");
        }

        @Test
        @TestMetadata("inheritingFromAbstractMap.kt")
        public void testInheritingFromAbstractMap() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMap.kt");
        }

        @Test
        @TestMetadata("inheritingFromAbstractMutableList.kt")
        public void testInheritingFromAbstractMutableList() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMutableList.kt");
        }

        @Test
        @TestMetadata("intArrayList.kt")
        public void testIntArrayList() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/intArrayList.kt");
        }

        @Test
        @TestMetadata("kt44233.kt")
        public void testKt44233() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/kt44233.kt");
        }

        @Test
        @TestMetadata("ListAndSet.kt")
        public void testListAndSet() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/ListAndSet.kt");
        }

        @Test
        @TestMetadata("mapOfPrimitivesFullJdk.kt")
        public void testMapOfPrimitivesFullJdk() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/mapOfPrimitivesFullJdk.kt");
        }

        @Test
        @TestMetadata("noStubsForCollection.kt")
        public void testNoStubsForCollection() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForCollection.kt");
        }

        @Test
        @TestMetadata("noStubsForMapImplementations.kt")
        public void testNoStubsForMapImplementations() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMapImplementations.kt");
        }

        @Test
        @TestMetadata("noStubsForMutableSetIterators.kt")
        public void testNoStubsForMutableSetIterators() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMutableSetIterators.kt");
        }

        @Test
        @TestMetadata("noStubsForSetIterators.kt")
        public void testNoStubsForSetIterators() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForSetIterators.kt");
        }

        @Test
        @TestMetadata("noStubsInIterable.kt")
        public void testNoStubsInIterable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInIterable.kt");
        }

        @Test
        @TestMetadata("noStubsInJavaSuperClass.kt")
        public void testNoStubsInJavaSuperClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInJavaSuperClass.kt");
        }

        @Test
        @TestMetadata("noStubsInMutableIterable.kt")
        public void testNoStubsInMutableIterable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInMutableIterable.kt");
        }

        @Test
        @TestMetadata("observableMutableMap.kt")
        public void testObservableMutableMap() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/observableMutableMap.kt");
        }

        @Test
        @TestMetadata("stubForAbstractFun.kt")
        public void testStubForAbstractFun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFun.kt");
        }

        @Test
        @TestMetadata("stubForAbstractFunInAbstractClass.kt")
        public void testStubForAbstractFunInAbstractClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClass.kt");
        }

        @Test
        @TestMetadata("stubForAbstractFunInAbstractClassWithCovariantOverride.kt")
        public void testStubForAbstractFunInAbstractClassWithCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClassWithCovariantOverride.kt");
        }

        @Test
        @TestMetadata("stubForAbstractFunWithCovariantOverride.kt")
        public void testStubForAbstractFunWithCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunWithCovariantOverride.kt");
        }

        @Test
        @TestMetadata("stubLikeMethodSignatures.kt")
        public void testStubLikeMethodSignatures() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubLikeMethodSignatures.kt");
        }

        @Test
        @TestMetadata("stubsFromSuperclass.kt")
        public void testStubsFromSuperclass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclass.kt");
        }

        @Test
        @TestMetadata("stubsFromSuperclassNoBridges.kt")
        public void testStubsFromSuperclassNoBridges() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclassNoBridges.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures")
        @TestDataPath("$PROJECT_ROOT")
        public class AbstractStubSignatures {
            @Test
            public void testAllFilesPresentInAbstractStubSignatures() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("byteShortMap.kt")
            public void testByteShortMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMap.kt");
            }

            @Test
            @TestMetadata("byteShortMutableMap.kt")
            public void testByteShortMutableMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMutableMap.kt");
            }

            @Test
            @TestMetadata("collection.kt")
            public void testCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/collection.kt");
            }

            @Test
            @TestMetadata("genericCollection.kt")
            public void testGenericCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericCollection.kt");
            }

            @Test
            @TestMetadata("genericMap.kt")
            public void testGenericMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMap.kt");
            }

            @Test
            @TestMetadata("genericMutableCollection.kt")
            public void testGenericMutableCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableCollection.kt");
            }

            @Test
            @TestMetadata("genericMutableList.kt")
            public void testGenericMutableList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableList.kt");
            }

            @Test
            @TestMetadata("genericMutableMap.kt")
            public void testGenericMutableMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableMap.kt");
            }

            @Test
            @TestMetadata("genericStringMap.kt")
            public void testGenericStringMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMap.kt");
            }

            @Test
            @TestMetadata("genericStringMutableMap.kt")
            public void testGenericStringMutableMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMutableMap.kt");
            }

            @Test
            @TestMetadata("iterable.kt")
            public void testIterable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterable.kt");
            }

            @Test
            @TestMetadata("iterator.kt")
            public void testIterator() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterator.kt");
            }

            @Test
            @TestMetadata("list.kt")
            public void testList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/list.kt");
            }

            @Test
            @TestMetadata("listIterator.kt")
            public void testListIterator() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/listIterator.kt");
            }

            @Test
            @TestMetadata("mapEntry.kt")
            public void testMapEntry() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mapEntry.kt");
            }

            @Test
            @TestMetadata("mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableCollection.kt");
            }

            @Test
            @TestMetadata("mutableIterable.kt")
            public void testMutableIterable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterable.kt");
            }

            @Test
            @TestMetadata("mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterator.kt");
            }

            @Test
            @TestMetadata("mutableList.kt")
            public void testMutableList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableList.kt");
            }

            @Test
            @TestMetadata("mutableListIterator.kt")
            public void testMutableListIterator() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableListIterator.kt");
            }

            @Test
            @TestMetadata("mutableMapEntry.kt")
            public void testMutableMapEntry() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableMapEntry.kt");
            }

            @Test
            @TestMetadata("numberStringMap.kt")
            public void testNumberStringMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMap.kt");
            }

            @Test
            @TestMetadata("numberStringMutableMap.kt")
            public void testNumberStringMutableMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMutableMap.kt");
            }

            @Test
            @TestMetadata("set.kt")
            public void testSet() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/set.kt");
            }

            @Test
            @TestMetadata("specializedGenericMap.kt")
            public void testSpecializedGenericMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/specializedGenericMap.kt");
            }

            @Test
            @TestMetadata("stringGenericMap.kt")
            public void testStringGenericMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMap.kt");
            }

            @Test
            @TestMetadata("stringGenericMutableMap.kt")
            public void testStringGenericMutableMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMutableMap.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray")
        @TestDataPath("$PROJECT_ROOT")
        public class ToArray {
            @Test
            public void testAllFilesPresentInToArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("customNonGenericToArray.kt")
            public void testCustomNonGenericToArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/customNonGenericToArray.kt");
            }

            @Test
            @TestMetadata("internalGenericToArray.kt")
            public void testInternalGenericToArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/internalGenericToArray.kt");
            }

            @Test
            @TestMetadata("noToArrayInJava.kt")
            public void testNoToArrayInJava() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/noToArrayInJava.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/contextReceivers")
    @TestDataPath("$PROJECT_ROOT")
    public class ContextReceivers {
        @Test
        public void testAllFilesPresentInContextReceivers() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("class.kt")
        public void testClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/class.kt");
        }

        @Test
        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/function.kt");
        }

        @Test
        @TestMetadata("property.kt")
        public void testProperty() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/property.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP")
        @TestDataPath("$PROJECT_ROOT")
        public class FromKEEP {
            @Test
            public void testAllFilesPresentInFromKEEP() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("canvas.kt")
            public void testCanvas() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/canvas.kt");
            }

            @Test
            @TestMetadata("compareTo.kt")
            public void testCompareTo() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/compareTo.kt");
            }

            @Test
            @TestMetadata("dp.kt")
            public void testDp() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/dp.kt");
            }

            @Test
            @TestMetadata("functionalType.kt")
            public void testFunctionalType() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/functionalType.kt");
            }

            @Test
            @TestMetadata("monoidSum.kt")
            public void testMonoidSum() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/monoidSum.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    public class Coroutines {
        @Test
        public void testAllFilesPresentInCoroutines() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("coroutineContextIntrinsic.kt")
        public void testCoroutineContextIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineContextIntrinsic.kt");
        }

        @Test
        @TestMetadata("coroutineFields.kt")
        public void testCoroutineFields() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineFields.kt");
        }

        @Test
        @TestMetadata("oomInReturnUnit.kt")
        public void testOomInReturnUnit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/oomInReturnUnit.kt");
        }

        @Test
        @TestMetadata("privateAccessor.kt")
        public void testPrivateAccessor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateAccessor.kt");
        }

        @Test
        @TestMetadata("privateSuspendFun.kt")
        public void testPrivateSuspendFun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateSuspendFun.kt");
        }

        @Test
        @TestMetadata("suspendConversion.kt")
        public void testSuspendConversion() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendConversion.kt");
        }

        @Test
        @TestMetadata("suspendImpl.kt")
        public void testSuspendImpl() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendImpl.kt");
        }

        @Test
        @TestMetadata("suspendReifiedFun.kt")
        public void testSuspendReifiedFun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendReifiedFun.kt");
        }

        @Test
        @TestMetadata("tcoContinuation.kt")
        public void testTcoContinuation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/coroutines/tcoContinuation.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/coroutines/spilling")
        @TestDataPath("$PROJECT_ROOT")
        public class Spilling {
            @Test
            public void testAllFilesPresentInSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines/spilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("booleanParameter.kt")
            public void testBooleanParameter() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/booleanParameter.kt");
            }

            @Test
            @TestMetadata("component1.kt")
            public void testComponent1() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/component1.kt");
            }

            @Test
            @TestMetadata("destructured.kt")
            public void testDestructured() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/destructured.kt");
            }

            @Test
            @TestMetadata("field.kt")
            public void testField() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/field.kt");
            }

            @Test
            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/lambda.kt");
            }

            @Test
            @TestMetadata("select.kt")
            public void testSelect() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/select.kt");
            }

            @Test
            @TestMetadata("unreachable.kt")
            public void testUnreachable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/unreachable.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("functionInMultifileClass.kt")
        public void testFunctionInMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClass.kt");
        }

        @Test
        @TestMetadata("functionInMultifileClassWithInheritedParts.kt")
        public void testFunctionInMultifileClassWithInheritedParts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClassWithInheritedParts.kt");
        }

        @Test
        @TestMetadata("internalNameMangling.kt")
        public void testInternalNameMangling() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/internalNameMangling.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegatedProperty {
        @Test
        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("delegateMethodIsNonOverridable.kt")
        public void testDelegateMethodIsNonOverridable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegateMethodIsNonOverridable.kt");
        }

        @Test
        @TestMetadata("delegatedPropertiesInCompanionObject.kt")
        public void testDelegatedPropertiesInCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegatedPropertiesInCompanionObject.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/deprecated")
    @TestDataPath("$PROJECT_ROOT")
    public class Deprecated {
        @Test
        public void testAllFilesPresentInDeprecated() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("deprecatedClass.kt")
        public void testDeprecatedClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedClass.kt");
        }

        @Test
        @TestMetadata("deprecatedEnumEntryFields.kt")
        public void testDeprecatedEnumEntryFields() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedEnumEntryFields.kt");
        }

        @Test
        @TestMetadata("deprecatedInMultifileClass.kt")
        public void testDeprecatedInMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedInMultifileClass.kt");
        }

        @Test
        @TestMetadata("deprecatedLateinitVar.kt")
        public void testDeprecatedLateinitVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedLateinitVar.kt");
        }

        @Test
        @TestMetadata("deprecatedProperty.kt")
        public void testDeprecatedProperty() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedProperty.kt");
        }

        @Test
        @TestMetadata("hidden.kt")
        public void testHidden() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/hidden.kt");
        }

        @Test
        @TestMetadata("inheritingDeprecation.kt")
        public void testInheritingDeprecation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/inheritingDeprecation.kt");
        }

        @Test
        @TestMetadata("inlineClassTypesInSignature.kt")
        public void testInlineClassTypesInSignature() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/inlineClassTypesInSignature.kt");
        }

        @Test
        @TestMetadata("jvmStaticDeprecatedProperty.kt")
        public void testJvmStaticDeprecatedProperty() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/deprecated/jvmStaticDeprecatedProperty.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inline")
    @TestDataPath("$PROJECT_ROOT")
    public class Inline {
        @Test
        public void testAllFilesPresentInInline() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("genericReified.kt")
        public void testGenericReified() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/genericReified.kt");
        }

        @Test
        @TestMetadata("inlineOnly.kt")
        public void testInlineOnly() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnly.kt");
        }

        @Test
        @TestMetadata("InlineOnlyMultifile.kt")
        public void testInlineOnlyMultifile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyMultifile.kt");
        }

        @Test
        @TestMetadata("inlineOnlyProperty.kt")
        public void testInlineOnlyProperty() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnlyProperty.kt");
        }

        @Test
        @TestMetadata("InlineOnlyPropertyMultifile.kt")
        public void testInlineOnlyPropertyMultifile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyPropertyMultifile.kt");
        }

        @Test
        @TestMetadata("inlineReified.kt")
        public void testInlineReified() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReified.kt");
        }

        @Test
        @TestMetadata("InlineReifiedMultifile.kt")
        public void testInlineReifiedMultifile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedMultifile.kt");
        }

        @Test
        @TestMetadata("inlineReifiedProperty.kt")
        public void testInlineReifiedProperty() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedProperty.kt");
        }

        @Test
        @TestMetadata("InlineReifiedPropertyMultifile.kt")
        public void testInlineReifiedPropertyMultifile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedPropertyMultifile.kt");
        }

        @Test
        @TestMetadata("inlineReifiedPropertyVisibility.kt")
        public void testInlineReifiedPropertyVisibility() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedPropertyVisibility.kt");
        }

        @Test
        @TestMetadata("inlineReifiedVisibility.kt")
        public void testInlineReifiedVisibility() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedVisibility.kt");
        }

        @Test
        @TestMetadata("simpleNamed.kt")
        public void testSimpleNamed() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/simpleNamed.kt");
        }

        @Test
        @TestMetadata("suspendInlineReified.kt")
        public void testSuspendInlineReified() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inline/suspendInlineReified.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo")
        @TestDataPath("$PROJECT_ROOT")
        public class EnclosingInfo {
            @Test
            public void testAllFilesPresentInEnclosingInfo() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("crossinlineLambdaChain.kt")
            public void testCrossinlineLambdaChain() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/crossinlineLambdaChain.kt");
            }

            @Test
            @TestMetadata("kt10259.kt")
            public void testKt10259() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/kt10259.kt");
            }

            @Test
            @TestMetadata("lambdaInInitBlockNoPrimaryConstructor.kt")
            public void testLambdaInInitBlockNoPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInitBlockNoPrimaryConstructor.kt");
            }

            @Test
            @TestMetadata("lambdaInInnerClassConstructor.kt")
            public void testLambdaInInnerClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInnerClassConstructor.kt");
            }

            @Test
            @TestMetadata("transformedConstructor.kt")
            public void testTransformedConstructor() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructor.kt");
            }

            @Test
            @TestMetadata("transformedConstructorWithNestedInline.kt")
            public void testTransformedConstructorWithNestedInline() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructorWithNestedInline.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("annotatedPropertyWithInlineClassTypeInSignature.kt")
        public void testAnnotatedPropertyWithInlineClassTypeInSignature() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotatedPropertyWithInlineClassTypeInSignature.kt");
        }

        @Test
        @TestMetadata("annotationGetters.kt")
        public void testAnnotationGetters() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationGetters.kt");
        }

        @Test
        @TestMetadata("annotationsOnHiddenConstructor.kt")
        public void testAnnotationsOnHiddenConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationsOnHiddenConstructor.kt");
        }

        @Test
        @TestMetadata("companionObjectInsideInlineClass.kt")
        public void testCompanionObjectInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/companionObjectInsideInlineClass.kt");
        }

        @Test
        @TestMetadata("computablePropertiesInsideInlineClass.kt")
        public void testComputablePropertiesInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/computablePropertiesInsideInlineClass.kt");
        }

        @Test
        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructor.kt");
        }

        @Test
        @TestMetadata("constructorsWithDefaultParameterValues.kt")
        public void testConstructorsWithDefaultParameterValues() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructorsWithDefaultParameterValues.kt");
        }

        @Test
        @TestMetadata("defaultInterfaceMethodsInInlineClass.kt")
        public void testDefaultInterfaceMethodsInInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMethodsInInlineClass.kt");
        }

        @Test
        @TestMetadata("genericChild.kt")
        public void testGenericChild() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/genericChild.kt");
        }

        @Test
        @TestMetadata("hiddenConstructor.kt")
        public void testHiddenConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/hiddenConstructor.kt");
        }

        @Test
        @TestMetadata("inlineCharSequence.kt")
        public void testInlineCharSequence() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCharSequence.kt");
        }

        @Test
        @TestMetadata("inlineClassMembersVisibility.kt")
        public void testInlineClassMembersVisibility() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassMembersVisibility.kt");
        }

        @Test
        @TestMetadata("inlineClassTypeParametersInConstructor.kt")
        public void testInlineClassTypeParametersInConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassTypeParametersInConstructor.kt");
        }

        @Test
        @TestMetadata("inlineClassWithInlineClassUnderlyingType.kt")
        public void testInlineClassWithInlineClassUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithInlineClassUnderlyingType.kt");
        }

        @Test
        @TestMetadata("inlineClassWithManyKindsOfMembers.kt")
        public void testInlineClassWithManyKindsOfMembers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithManyKindsOfMembers.kt");
        }

        @Test
        @TestMetadata("jvmName.kt")
        public void testJvmName() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmName.kt");
        }

        @Test
        @TestMetadata("jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
        public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt");
        }

        @Test
        @TestMetadata("memberExtensionProperty.kt")
        public void testMemberExtensionProperty() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/memberExtensionProperty.kt");
        }

        @Test
        @TestMetadata("noArgConstructorForInlineClassParameter.kt")
        public void testNoArgConstructorForInlineClassParameter() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noArgConstructorForInlineClassParameter.kt");
        }

        @Test
        @TestMetadata("noBridgesForErasedInlineClass.kt")
        public void testNoBridgesForErasedInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noBridgesForErasedInlineClass.kt");
        }

        @Test
        @TestMetadata("nullabilityAnnotationsOnInlineClassMembers.kt")
        public void testNullabilityAnnotationsOnInlineClassMembers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
        }

        @Test
        @TestMetadata("nullabilityInExpansion.kt")
        public void testNullabilityInExpansion() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityInExpansion.kt");
        }

        @Test
        @TestMetadata("nullableAndNotNullPrimitive.kt")
        public void testNullableAndNotNullPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullableAndNotNullPrimitive.kt");
        }

        @Test
        @TestMetadata("overridingGenericMethodWithInlineClassParameterType.kt")
        public void testOverridingGenericMethodWithInlineClassParameterType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassParameterType.kt");
        }

        @Test
        @TestMetadata("overridingGenericMethodWithInlineClassReturnType.kt")
        public void testOverridingGenericMethodWithInlineClassReturnType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassReturnType.kt");
        }

        @Test
        @TestMetadata("primaryValsWithDifferentVisibilities.kt")
        public void testPrimaryValsWithDifferentVisibilities() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/primaryValsWithDifferentVisibilities.kt");
        }

        @Test
        @TestMetadata("publishedApiAnnotationOnInlineClassConstructor.kt")
        public void testPublishedApiAnnotationOnInlineClassConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/publishedApiAnnotationOnInlineClassConstructor.kt");
        }

        @Test
        @TestMetadata("shapeOfInlineClassWithPrimitive.kt")
        public void testShapeOfInlineClassWithPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/shapeOfInlineClassWithPrimitive.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers")
        @TestDataPath("$PROJECT_ROOT")
        public class DefaultInterfaceMembers {
            @Test
            public void testAllFilesPresentInDefaultInterfaceMembers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("javaDefaultInterfaceMember.kt")
            public void testJavaDefaultInterfaceMember() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/javaDefaultInterfaceMember.kt");
            }

            @Test
            @TestMetadata("jvmDefaultAll.kt")
            public void testJvmDefaultAll() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/jvmDefaultAll.kt");
            }

            @Test
            @TestMetadata("jvmDefaultEnable.kt")
            public void testJvmDefaultEnable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/jvmDefaultEnable.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineCollection {
            @Test
            public void testAllFilesPresentInInlineCollection() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("collection.kt")
            public void testCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/collection.kt");
            }

            @Test
            @TestMetadata("iterable.kt")
            public void testIterable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterable.kt");
            }

            @Test
            @TestMetadata("iterator.kt")
            public void testIterator() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterator.kt");
            }

            @Test
            @TestMetadata("list.kt")
            public void testList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/list.kt");
            }

            @Test
            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/map.kt");
            }

            @Test
            @TestMetadata("mapEntry.kt")
            public void testMapEntry() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mapEntry.kt");
            }

            @Test
            @TestMetadata("mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableCollection.kt");
            }

            @Test
            @TestMetadata("mutableIterable.kt")
            public void testMutableIterable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterable.kt");
            }

            @Test
            @TestMetadata("mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterator.kt");
            }

            @Test
            @TestMetadata("mutableList.kt")
            public void testMutableList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableList.kt");
            }

            @Test
            @TestMetadata("mutableMap.kt")
            public void testMutableMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMap.kt");
            }

            @Test
            @TestMetadata("mutableMapEntry.kt")
            public void testMutableMapEntry() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMapEntry.kt");
            }

            @Test
            @TestMetadata("mutableSet.kt")
            public void testMutableSet() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableSet.kt");
            }

            @Test
            @TestMetadata("set.kt")
            public void testSet() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/set.kt");
            }

            @Test
            @TestMetadata("UIntArrayWithFullJdk.kt")
            public void testUIntArrayWithFullJdk() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/UIntArrayWithFullJdk.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineCollectionOfInlineClass {
            @Test
            public void testAllFilesPresentInInlineCollectionOfInlineClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("collection.kt")
            public void testCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/collection.kt");
            }

            @Test
            @TestMetadata("iterable.kt")
            public void testIterable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterable.kt");
            }

            @Test
            @TestMetadata("iterator.kt")
            public void testIterator() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterator.kt");
            }

            @Test
            @TestMetadata("list.kt")
            public void testList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/list.kt");
            }

            @Test
            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/map.kt");
            }

            @Test
            @TestMetadata("mapEntry.kt")
            public void testMapEntry() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mapEntry.kt");
            }

            @Test
            @TestMetadata("mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableCollection.kt");
            }

            @Test
            @TestMetadata("mutableIterable.kt")
            public void testMutableIterable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterable.kt");
            }

            @Test
            @TestMetadata("mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterator.kt");
            }

            @Test
            @TestMetadata("mutableList.kt")
            public void testMutableList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableList.kt");
            }

            @Test
            @TestMetadata("mutableMap.kt")
            public void testMutableMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMap.kt");
            }

            @Test
            @TestMetadata("mutableMapEntry.kt")
            public void testMutableMapEntry() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMapEntry.kt");
            }

            @Test
            @TestMetadata("mutableSet.kt")
            public void testMutableSet() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet.kt");
            }

            @Test
            @TestMetadata("mutableSet2.kt")
            public void testMutableSet2() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet2.kt");
            }

            @Test
            @TestMetadata("set.kt")
            public void testSet() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/set.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult")
        @TestDataPath("$PROJECT_ROOT")
        public class ReturnResult {
            @Test
            public void testAllFilesPresentInReturnResult() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("class.kt")
            public void testClass() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/class.kt");
            }

            @Test
            @TestMetadata("classAnyOverride.kt")
            public void testClassAnyOverride() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classAnyOverride.kt");
            }

            @Test
            @TestMetadata("classGenericOverride.kt")
            public void testClassGenericOverride() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classGenericOverride.kt");
            }

            @Test
            @TestMetadata("classResultOverride.kt")
            public void testClassResultOverride() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classResultOverride.kt");
            }

            @Test
            @TestMetadata("interface.kt")
            public void testInterface() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/interface.kt");
            }

            @Test
            @TestMetadata("topLevel.kt")
            public void testTopLevel() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/topLevel.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430")
        @TestDataPath("$PROJECT_ROOT")
        public class StdlibManglingIn1430 {
            @Test
            public void testAllFilesPresentInStdlibManglingIn1430() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("new.kt")
            public void testNew() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/new.kt");
            }

            @Test
            @TestMetadata("old.kt")
            public void testOld() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/old.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    public class Jvm8 {
        @Test
        public void testAllFilesPresentInJvm8() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults")
        @TestDataPath("$PROJECT_ROOT")
        public class Defaults {
            @Test
            public void testAllFilesPresentInDefaults() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility")
            @TestDataPath("$PROJECT_ROOT")
            public class AllCompatibility {
                @Test
                public void testAllFilesPresentInAllCompatibility() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("deprecation.kt")
                public void testDeprecation() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecation.kt");
                }

                @Test
                @TestMetadata("deprecationWithDefault.kt")
                public void testDeprecationWithDefault() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecationWithDefault.kt");
                }

                @Test
                @TestMetadata("interfaceProperty.kt")
                public void testInterfaceProperty() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/interfaceProperty.kt");
                }

                @Test
                @TestMetadata("jvmDefaultWithoutCompatibility.kt")
                public void testJvmDefaultWithoutCompatibility() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/jvmDefaultWithoutCompatibility.kt");
                }

                @Test
                @TestMetadata("noDefaultImplsOnEmptySubInterface.kt")
                public void testNoDefaultImplsOnEmptySubInterface() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/noDefaultImplsOnEmptySubInterface.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization")
                @TestDataPath("$PROJECT_ROOT")
                public class Specialization {
                    @Test
                    public void testAllFilesPresentInSpecialization() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("primitiveAndAny.kt")
                    public void testPrimitiveAndAny() throws Exception {
                        runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndAny.kt");
                    }

                    @Test
                    @TestMetadata("primitiveAndNullable.kt")
                    public void testPrimitiveAndNullable() throws Exception {
                        runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndNullable.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/enable")
            @TestDataPath("$PROJECT_ROOT")
            public class Enable {
                @Test
                public void testAllFilesPresentInEnable() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/enable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("interfaceProperty.kt")
                public void testInterfaceProperty() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/enable/interfaceProperty.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl")
            @TestDataPath("$PROJECT_ROOT")
            public class NoDefaultImpl {
                @Test
                public void testAllFilesPresentInNoDefaultImpl() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("interfaceProperty.kt")
                public void testInterfaceProperty() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/interfaceProperty.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/jvmStatic")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmStatic {
        @Test
        public void testAllFilesPresentInJvmStatic() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("jvmStaticExternal.kt")
        public void testJvmStaticExternal() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticExternal.kt");
        }

        @Test
        @TestMetadata("jvmStaticPrivate.kt")
        public void testJvmStaticPrivate() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticPrivate.kt");
        }

        @Test
        @TestMetadata("jvmStaticWithDefaultParameters.kt")
        public void testJvmStaticWithDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticWithDefaultParameters.kt");
        }

        @Test
        @TestMetadata("kt31389.kt")
        public void testKt31389() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/kt31389.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/localFunctions")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalFunctions {
        @Test
        public void testAllFilesPresentInLocalFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("genericClass.kt")
        public void testGenericClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericClass.kt");
        }

        @Test
        @TestMetadata("genericInnerClass.kt")
        public void testGenericInnerClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericInnerClass.kt");
        }

        @Test
        @TestMetadata("genericLocalClass.kt")
        public void testGenericLocalClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericLocalClass.kt");
        }

        @Test
        @TestMetadata("inInitBlock.kt")
        public void testInInitBlock() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/localFunctions/inInitBlock.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/localFunctions/simple.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/main")
    @TestDataPath("$PROJECT_ROOT")
    public class Main {
        @Test
        public void testAllFilesPresentInMain() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/main"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("multifileSuspend.kt")
        public void testMultifileSuspend() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/main/multifileSuspend.kt");
        }

        @Test
        @TestMetadata("parameterlessMain.kt")
        public void testParameterlessMain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain.kt");
        }

        @Test
        @TestMetadata("parameterlessMain_before.kt")
        public void testParameterlessMain_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain_before.kt");
        }

        @Test
        @TestMetadata("suspendMain.kt")
        public void testSuspendMain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/main/suspendMain.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("emptyMultifileFacade.kt")
        public void testEmptyMultifileFacade() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/emptyMultifileFacade.kt");
        }

        @Test
        @TestMetadata("jvmSynthetic.kt")
        public void testJvmSynthetic() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/jvmSynthetic.kt");
        }

        @Test
        @TestMetadata("kt43519.kt")
        public void testKt43519() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/kt43519.kt");
        }

        @Test
        @TestMetadata("multiClassPartSourceMultipleParts.kt")
        public void testMultiClassPartSourceMultipleParts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceMultipleParts.kt");
        }

        @Test
        @TestMetadata("multiClassPartSourceSinglePart.kt")
        public void testMultiClassPartSourceSinglePart() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceSinglePart.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/multiplatform")
    @TestDataPath("$PROJECT_ROOT")
    public class Multiplatform {
        @Test
        public void testAllFilesPresentInMultiplatform() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("optionalExpectation.kt")
        public void testOptionalExpectation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/multiplatform/optionalExpectation.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations")
    @TestDataPath("$PROJECT_ROOT")
    public class NullabilityAnnotations {
        @Test
        public void testAllFilesPresentInNullabilityAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("lateInitNotNull.kt")
        public void testLateInitNotNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/lateInitNotNull.kt");
        }

        @Test
        @TestMetadata("nullabilityAnnotationsForReturnType.kt")
        public void testNullabilityAnnotationsForReturnType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsForReturnType.kt");
        }

        @Test
        @TestMetadata("nullabilityAnnotationsOnDelegatedMembers.kt")
        public void testNullabilityAnnotationsOnDelegatedMembers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsOnDelegatedMembers.kt");
        }

        @Test
        @TestMetadata("platformTypes.kt")
        public void testPlatformTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/platformTypes.kt");
        }

        @Test
        @TestMetadata("samAdapterForJavaInterfaceWithNullability.kt")
        public void testSamAdapterForJavaInterfaceWithNullability() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/samAdapterForJavaInterfaceWithNullability.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/sam")
    @TestDataPath("$PROJECT_ROOT")
    public class Sam {
        @Test
        public void testAllFilesPresentInSam() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callableRefGenericFunInterface.kt")
        public void testCallableRefGenericFunInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericFunInterface.kt");
        }

        @Test
        @TestMetadata("callableRefGenericSamInterface.kt")
        public void testCallableRefGenericSamInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericSamInterface.kt");
        }

        @Test
        @TestMetadata("callableRefSpecializedFunInterface.kt")
        public void testCallableRefSpecializedFunInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedFunInterface.kt");
        }

        @Test
        @TestMetadata("callableRefSpecializedSamInterface.kt")
        public void testCallableRefSpecializedSamInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedSamInterface.kt");
        }

        @Test
        @TestMetadata("genericFunInterface.kt")
        public void testGenericFunInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/genericFunInterface.kt");
        }

        @Test
        @TestMetadata("genericSamInterface.kt")
        public void testGenericSamInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/genericSamInterface.kt");
        }

        @Test
        @TestMetadata("indySamConversionViaProxyFun.kt")
        public void testIndySamConversionViaProxyFun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/indySamConversionViaProxyFun.kt");
        }

        @Test
        @TestMetadata("kt16650.kt")
        public void testKt16650() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/kt16650.kt");
        }

        @Test
        @TestMetadata("lambdaGenericFunInterface.kt")
        public void testLambdaGenericFunInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericFunInterface.kt");
        }

        @Test
        @TestMetadata("lambdaGenericSamInterface.kt")
        public void testLambdaGenericSamInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericSamInterface.kt");
        }

        @Test
        @TestMetadata("lambdaSpecializedFunInterface.kt")
        public void testLambdaSpecializedFunInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedFunInterface.kt");
        }

        @Test
        @TestMetadata("lambdaSpecializedSamInterface.kt")
        public void testLambdaSpecializedSamInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedSamInterface.kt");
        }

        @Test
        @TestMetadata("nonApproxToValidSupertype.kt")
        public void testNonApproxToValidSupertype() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype.kt");
        }

        @Test
        @TestMetadata("nonApproxToValidSupertype2.kt")
        public void testNonApproxToValidSupertype2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype2.kt");
        }

        @Test
        @TestMetadata("privateInlineSamAdapter.kt")
        public void testPrivateInlineSamAdapter() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/privateInlineSamAdapter.kt");
        }

        @Test
        @TestMetadata("reusedSamWrapperClasses.kt")
        public void testReusedSamWrapperClasses() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/reusedSamWrapperClasses.kt");
        }

        @Test
        @TestMetadata("samAdapterAndInlinedOne.kt")
        public void testSamAdapterAndInlinedOne() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterAndInlinedOne.kt");
        }

        @Test
        @TestMetadata("samAdapterInInlineLambda.kt")
        public void testSamAdapterInInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterInInlineLambda.kt");
        }

        @Test
        @TestMetadata("severalProxyFunsInInit.kt")
        public void testSeveralProxyFunsInInit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/severalProxyFunsInInit.kt");
        }

        @Test
        @TestMetadata("specializedFunInterface.kt")
        public void testSpecializedFunInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/specializedFunInterface.kt");
        }

        @Test
        @TestMetadata("specializedSamInterface.kt")
        public void testSpecializedSamInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/specializedSamInterface.kt");
        }

        @Test
        @TestMetadata("wrapperInlinedFromAnotherClass.kt")
        public void testWrapperInlinedFromAnotherClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sam/wrapperInlinedFromAnotherClass.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/sealed")
    @TestDataPath("$PROJECT_ROOT")
    public class Sealed {
        @Test
        public void testAllFilesPresentInSealed() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("annotationsOnSealedConstructor.kt")
        public void testAnnotationsOnSealedConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sealed/annotationsOnSealedConstructor.kt");
        }

        @Test
        @TestMetadata("permittedSubclasses_1_7.kt")
        public void testPermittedSubclasses_1_7() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sealed/permittedSubclasses_1_7.kt");
        }

        @Test
        @TestMetadata("sealedClassConstructor_1_4.kt")
        public void testSealedClassConstructor_1_4() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_4.kt");
        }

        @Test
        @TestMetadata("sealedClassConstructor_1_5.kt")
        public void testSealedClassConstructor_1_5() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_5.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/specialBridges")
    @TestDataPath("$PROJECT_ROOT")
    public class SpecialBridges {
        @Test
        @TestMetadata("abstractCollections.kt")
        public void testAbstractCollections() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractCollections.kt");
        }

        @Test
        @TestMetadata("abstractIterables.kt")
        public void testAbstractIterables() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractIterables.kt");
        }

        @Test
        @TestMetadata("abstractLists.kt")
        public void testAbstractLists() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractLists.kt");
        }

        @Test
        @TestMetadata("abstractListsWithJavaBase.kt")
        public void testAbstractListsWithJavaBase() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractListsWithJavaBase.kt");
        }

        @Test
        @TestMetadata("abstractMutableCollectionOfPrimitive.kt")
        public void testAbstractMutableCollectionOfPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableCollectionOfPrimitive.kt");
        }

        @Test
        @TestMetadata("abstractMutableListOfPrimitive.kt")
        public void testAbstractMutableListOfPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableListOfPrimitive.kt");
        }

        @Test
        @TestMetadata("abstractMutableLists.kt")
        public void testAbstractMutableLists() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableLists.kt");
        }

        @Test
        @TestMetadata("abstractSets.kt")
        public void testAbstractSets() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractSets.kt");
        }

        @Test
        public void testAllFilesPresentInSpecialBridges() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("charSequence.kt")
        public void testCharSequence() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/charSequence.kt");
        }

        @Test
        @TestMetadata("contains.kt")
        public void testContains() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/contains.kt");
        }

        @Test
        @TestMetadata("kt41123.kt")
        public void testKt41123() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt41123.kt");
        }

        @Test
        @TestMetadata("kt48945.kt")
        public void testKt48945() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt48945.kt");
        }

        @Test
        @TestMetadata("mutableCollectionOfPrimitive.kt")
        public void testMutableCollectionOfPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableCollectionOfPrimitive.kt");
        }

        @Test
        @TestMetadata("mutableListOfPrimitive.kt")
        public void testMutableListOfPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableListOfPrimitive.kt");
        }

        @Test
        @TestMetadata("noDefaultImplsOnEmptySubInterface.kt")
        public void testNoDefaultImplsOnEmptySubInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noDefaultImplsOnEmptySubInterface.kt");
        }

        @Test
        @TestMetadata("noSpecialBridgeIfPresentInSuperClass.kt")
        public void testNoSpecialBridgeIfPresentInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noSpecialBridgeIfPresentInSuperClass.kt");
        }

        @Test
        @TestMetadata("number.kt")
        public void testNumber() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/number.kt");
        }

        @Test
        @TestMetadata("redundantStubForSize.kt")
        public void testRedundantStubForSize() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/redundantStubForSize.kt");
        }

        @Test
        @TestMetadata("removeAtTwoSpecialBridges.kt")
        public void testRemoveAtTwoSpecialBridges() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/removeAtTwoSpecialBridges.kt");
        }

        @Test
        @TestMetadata("specialBridgeForGet.kt")
        public void testSpecialBridgeForGet() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/specialBridgeForGet.kt");
        }

        @Test
        @TestMetadata("unsignedArray.kt")
        public void testUnsignedArray() throws Exception {
            runTest("compiler/testData/codegen/bytecodeListing/specialBridges/unsignedArray.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/specialBridges/signatures")
        @TestDataPath("$PROJECT_ROOT")
        public class Signatures {
            @Test
            public void testAllFilesPresentInSignatures() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges/signatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("genericClass.kt")
            public void testGenericClass() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/genericClass.kt");
            }

            @Test
            @TestMetadata("implementsJavaMap.kt")
            public void testImplementsJavaMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMap.kt");
            }

            @Test
            @TestMetadata("implementsJavaMapWithCustomEntries.kt")
            public void testImplementsJavaMapWithCustomEntries() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMapWithCustomEntries.kt");
            }

            @Test
            @TestMetadata("implementsMap.kt")
            public void testImplementsMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsMap.kt");
            }

            @Test
            @TestMetadata("implementsSortedMap.kt")
            public void testImplementsSortedMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsSortedMap.kt");
            }

            @Test
            @TestMetadata("kt43610.kt")
            public void testKt43610() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/kt43610.kt");
            }

            @Test
            @TestMetadata("nonGenericClass.kt")
            public void testNonGenericClass() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/nonGenericClass.kt");
            }

            @Test
            @TestMetadata("partiallySpecializedClass.kt")
            public void testPartiallySpecializedClass() throws Exception {
                runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/partiallySpecializedClass.kt");
            }
        }
    }
}
