/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/boxInline")
@TestDataPath("$PROJECT_ROOT")
public class CompileKotlinAgainstInlineKotlinTestGenerated extends AbstractCompileKotlinAgainstInlineKotlinTest {
    @Test
    public void testAllFilesPresentInBoxInline() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
        @Test
        public void testAllFilesPresentInAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("annotationInstanceInlining.kt")
        public void testAnnotationInstanceInlining() throws Exception {
            runTest("compiler/testData/codegen/boxInline/annotations/annotationInstanceInlining.kt");
        }

        @Test
        @TestMetadata("instanceInAnonymousClass.kt")
        public void testInstanceInAnonymousClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/annotations/instanceInAnonymousClass.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject")
    @TestDataPath("$PROJECT_ROOT")
    public class AnonymousObject {
        @Test
        public void testAllFilesPresentInAnonymousObject() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("anonymousObjectInDefault.kt")
        public void testAnonymousObjectInDefault() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInDefault.kt");
        }

        @Test
        @TestMetadata("anonymousObjectOnCallSite.kt")
        public void testAnonymousObjectOnCallSite() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSite.kt");
        }

        @Test
        @TestMetadata("anonymousObjectOnCallSiteSuperParams.kt")
        public void testAnonymousObjectOnCallSiteSuperParams() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSiteSuperParams.kt");
        }

        @Test
        @TestMetadata("anonymousObjectOnDeclarationSite.kt")
        public void testAnonymousObjectOnDeclarationSite() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSite.kt");
        }

        @Test
        @TestMetadata("anonymousObjectOnDeclarationSiteSuperParams.kt")
        public void testAnonymousObjectOnDeclarationSiteSuperParams() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSiteSuperParams.kt");
        }

        @Test
        @TestMetadata("capturedLambdaInInline.kt")
        public void testCapturedLambdaInInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline.kt");
        }

        @Test
        @TestMetadata("capturedLambdaInInline2.kt")
        public void testCapturedLambdaInInline2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline2.kt");
        }

        @Test
        @TestMetadata("capturedLambdaInInline3.kt")
        public void testCapturedLambdaInInline3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline3.kt");
        }

        @Test
        @TestMetadata("capturedLambdaInInlineObject.kt")
        public void testCapturedLambdaInInlineObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInlineObject.kt");
        }

        @Test
        @TestMetadata("capturedLocalFun.kt")
        public void testCapturedLocalFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFun.kt");
        }

        @Test
        @TestMetadata("capturedLocalFunRef.kt")
        public void testCapturedLocalFunRef() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFunRef.kt");
        }

        @Test
        @TestMetadata("changingReturnType.kt")
        public void testChangingReturnType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/changingReturnType.kt");
        }

        @Test
        @TestMetadata("constructOriginalInRegenerated.kt")
        public void testConstructOriginalInRegenerated() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/constructOriginalInRegenerated.kt");
        }

        @Test
        @TestMetadata("constructorVisibility.kt")
        public void testConstructorVisibility() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibility.kt");
        }

        @Test
        @TestMetadata("constructorVisibilityInConstLambda.kt")
        public void testConstructorVisibilityInConstLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInConstLambda.kt");
        }

        @Test
        @TestMetadata("constructorVisibilityInLambda.kt")
        public void testConstructorVisibilityInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInLambda.kt");
        }

        @Test
        @TestMetadata("defineClass.kt")
        public void testDefineClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/defineClass.kt");
        }

        @Test
        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/functionExpression.kt");
        }

        @Test
        @TestMetadata("inlineCallInsideInlineLambda.kt")
        public void testInlineCallInsideInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/inlineCallInsideInlineLambda.kt");
        }

        @Test
        @TestMetadata("kt13133.kt")
        public void testKt13133() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13133.kt");
        }

        @Test
        @TestMetadata("kt13182.kt")
        public void testKt13182() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13182.kt");
        }

        @Test
        @TestMetadata("kt13374.kt")
        public void testKt13374() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13374.kt");
        }

        @Test
        @TestMetadata("kt14011.kt")
        public void testKt14011() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011.kt");
        }

        @Test
        @TestMetadata("kt14011_2.kt")
        public void testKt14011_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_2.kt");
        }

        @Test
        @TestMetadata("kt14011_3.kt")
        public void testKt14011_3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_3.kt");
        }

        @Test
        @TestMetadata("kt15751.kt")
        public void testKt15751() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt15751.kt");
        }

        @Test
        @TestMetadata("kt16193.kt")
        public void testKt16193() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt16193.kt");
        }

        @Test
        @TestMetadata("kt17972.kt")
        public void testKt17972() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972.kt");
        }

        @Test
        @TestMetadata("kt17972_2.kt")
        public void testKt17972_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_2.kt");
        }

        @Test
        @TestMetadata("kt17972_3.kt")
        public void testKt17972_3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_3.kt");
        }

        @Test
        @TestMetadata("kt17972_4.kt")
        public void testKt17972_4() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_4.kt");
        }

        @Test
        @TestMetadata("kt17972_5.kt")
        public void testKt17972_5() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_5.kt");
        }

        @Test
        @TestMetadata("kt17972_super.kt")
        public void testKt17972_super() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super.kt");
        }

        @Test
        @TestMetadata("kt17972_super2.kt")
        public void testKt17972_super2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super2.kt");
        }

        @Test
        @TestMetadata("kt17972_super3.kt")
        public void testKt17972_super3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super3.kt");
        }

        @Test
        @TestMetadata("kt19389.kt")
        public void testKt19389() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19389.kt");
        }

        @Test
        @TestMetadata("kt19399.kt")
        public void testKt19399() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19399.kt");
        }

        @Test
        @TestMetadata("kt19434.kt")
        public void testKt19434() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434.kt");
        }

        @Test
        @TestMetadata("kt19434_2.kt")
        public void testKt19434_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434_2.kt");
        }

        @Test
        @TestMetadata("kt19723.kt")
        public void testKt19723() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19723.kt");
        }

        @Test
        @TestMetadata("kt29595.kt")
        public void testKt29595() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt29595.kt");
        }

        @Test
        @TestMetadata("kt30696.kt")
        public void testKt30696() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt30696.kt");
        }

        @Test
        @TestMetadata("kt34656.kt")
        public void testKt34656() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt34656.kt");
        }

        @Test
        @TestMetadata("kt38197.kt")
        public void testKt38197() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt38197.kt");
        }

        @Test
        @TestMetadata("kt41174.kt")
        public void testKt41174() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt41174.kt");
        }

        @Test
        @TestMetadata("kt42815.kt")
        public void testKt42815() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815.kt");
        }

        @Test
        @TestMetadata("kt42815_delegated.kt")
        public void testKt42815_delegated() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815_delegated.kt");
        }

        @Test
        @TestMetadata("kt6007.kt")
        public void testKt6007() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6007.kt");
        }

        @Test
        @TestMetadata("kt6552.kt")
        public void testKt6552() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6552.kt");
        }

        @Test
        @TestMetadata("kt8133.kt")
        public void testKt8133() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt8133.kt");
        }

        @Test
        @TestMetadata("kt9064.kt")
        public void testKt9064() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064.kt");
        }

        @Test
        @TestMetadata("kt9064v2.kt")
        public void testKt9064v2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064v2.kt");
        }

        @Test
        @TestMetadata("kt9591.kt")
        public void testKt9591() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9591.kt");
        }

        @Test
        @TestMetadata("kt9877.kt")
        public void testKt9877() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877.kt");
        }

        @Test
        @TestMetadata("kt9877_2.kt")
        public void testKt9877_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877_2.kt");
        }

        @Test
        @TestMetadata("objectInLambdaCapturesAnotherObject.kt")
        public void testObjectInLambdaCapturesAnotherObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/objectInLambdaCapturesAnotherObject.kt");
        }

        @Test
        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall.kt");
        }

        @Test
        @TestMetadata("safeCall_2.kt")
        public void testSafeCall_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall_2.kt");
        }

        @Test
        @TestMetadata("sam.kt")
        public void testSam() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/sam.kt");
        }

        @Test
        @TestMetadata("sharedFromCrossinline.kt")
        public void testSharedFromCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/sharedFromCrossinline.kt");
        }

        @Test
        @TestMetadata("superConstructorWithObjectParameter.kt")
        public void testSuperConstructorWithObjectParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/superConstructorWithObjectParameter.kt");
        }

        @Test
        @TestMetadata("typeInfo.kt")
        public void testTypeInfo() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/typeInfo.kt");
        }

        @Test
        @TestMetadata("withInlineMethod.kt")
        public void testWithInlineMethod() throws Exception {
            runTest("compiler/testData/codegen/boxInline/anonymousObject/withInlineMethod.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumWhen")
        @TestDataPath("$PROJECT_ROOT")
        public class EnumWhen {
            @Test
            public void testAllFilesPresentInEnumWhen() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumWhen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("callSite.kt")
            public void testCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/callSite.kt");
            }

            @Test
            @TestMetadata("declSite.kt")
            public void testDeclSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSite.kt");
            }

            @Test
            @TestMetadata("declSiteSeveralMappings.kt")
            public void testDeclSiteSeveralMappings() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappings.kt");
            }

            @Test
            @TestMetadata("declSiteSeveralMappingsDifOrder.kt")
            public void testDeclSiteSeveralMappingsDifOrder() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappingsDifOrder.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing")
        @TestDataPath("$PROJECT_ROOT")
        public class ProperRecapturing {
            @Test
            public void testAllFilesPresentInProperRecapturing() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("inlineChain.kt")
            public void testInlineChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/inlineChain.kt");
            }

            @Test
            @TestMetadata("lambdaChain.kt")
            public void testLambdaChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain.kt");
            }

            @Test
            @TestMetadata("lambdaChainSimple.kt")
            public void testLambdaChainSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChainSimple.kt");
            }

            @Test
            @TestMetadata("lambdaChain_2.kt")
            public void testLambdaChain_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_2.kt");
            }

            @Test
            @TestMetadata("lambdaChain_3.kt")
            public void testLambdaChain_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_3.kt");
            }

            @Test
            @TestMetadata("noInlineLambda.kt")
            public void testNoInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/noInlineLambda.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass")
        @TestDataPath("$PROJECT_ROOT")
        public class ProperRecapturingInClass {
            @Test
            public void testAllFilesPresentInProperRecapturingInClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("inlineChain.kt")
            public void testInlineChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlineChain.kt");
            }

            @Test
            @TestMetadata("inlinelambdaChain.kt")
            public void testInlinelambdaChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlinelambdaChain.kt");
            }

            @Test
            @TestMetadata("lambdaChain.kt")
            public void testLambdaChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain.kt");
            }

            @Test
            @TestMetadata("lambdaChainSimple.kt")
            public void testLambdaChainSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple.kt");
            }

            @Test
            @TestMetadata("lambdaChainSimple_2.kt")
            public void testLambdaChainSimple_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple_2.kt");
            }

            @Test
            @TestMetadata("lambdaChain_2.kt")
            public void testLambdaChain_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_2.kt");
            }

            @Test
            @TestMetadata("lambdaChain_3.kt")
            public void testLambdaChain_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_3.kt");
            }

            @Test
            @TestMetadata("noCapturedThisOnCallSite.kt")
            public void testNoCapturedThisOnCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noCapturedThisOnCallSite.kt");
            }

            @Test
            @TestMetadata("noInlineLambda.kt")
            public void testNoInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noInlineLambda.kt");
            }

            @Test
            @TestMetadata("twoInlineLambda.kt")
            public void testTwoInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambda.kt");
            }

            @Test
            @TestMetadata("twoInlineLambdaComplex.kt")
            public void testTwoInlineLambdaComplex() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex.kt");
            }

            @Test
            @TestMetadata("twoInlineLambdaComplex_2.kt")
            public void testTwoInlineLambdaComplex_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex_2.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/sam")
        @TestDataPath("$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("anonymousObjectToSam.kt")
            public void testAnonymousObjectToSam() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/anonymousObjectToSam.kt");
            }

            @Test
            @TestMetadata("kt17091.kt")
            public void testKt17091() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt17091.kt");
            }

            @Test
            @TestMetadata("kt21671.kt")
            public void testKt21671() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671.kt");
            }

            @Test
            @TestMetadata("kt21671_2.kt")
            public void testKt21671_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_2.kt");
            }

            @Test
            @TestMetadata("kt21671_3.kt")
            public void testKt21671_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_3.kt");
            }

            @Test
            @TestMetadata("kt22304.kt")
            public void testKt22304() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt22304.kt");
            }

            @Test
            @TestMetadata("samOnCallSite.kt")
            public void testSamOnCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/samOnCallSite.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers")
        @TestDataPath("$PROJECT_ROOT")
        public class TwoCapturedReceivers {
            @Test
            public void testAllFilesPresentInTwoCapturedReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("kt8668.kt")
            public void testKt8668() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668.kt");
            }

            @Test
            @TestMetadata("kt8668_2.kt")
            public void testKt8668_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_2.kt");
            }

            @Test
            @TestMetadata("kt8668_3.kt")
            public void testKt8668_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_3.kt");
            }

            @Test
            @TestMetadata("kt8668_nested.kt")
            public void testKt8668_nested() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested.kt");
            }

            @Test
            @TestMetadata("kt8668_nested_2.kt")
            public void testKt8668_nested_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested_2.kt");
            }

            @Test
            @TestMetadata("twoDifferentDispatchReceivers.kt")
            public void testTwoDifferentDispatchReceivers() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoDifferentDispatchReceivers.kt");
            }

            @Test
            @TestMetadata("twoExtensionReceivers.kt")
            public void testTwoExtensionReceivers() throws Exception {
                runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoExtensionReceivers.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    public class ArgumentOrder {
        @Test
        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("boundFunctionReference.kt")
        public void testBoundFunctionReference() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference.kt");
        }

        @Test
        @TestMetadata("boundFunctionReference2.kt")
        public void testBoundFunctionReference2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference2.kt");
        }

        @Test
        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/captured.kt");
        }

        @Test
        @TestMetadata("capturedInExtension.kt")
        public void testCapturedInExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/capturedInExtension.kt");
        }

        @Test
        @TestMetadata("defaultParametersAndLastVararg.kt")
        public void testDefaultParametersAndLastVararg() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVararg.kt");
        }

        @Test
        @TestMetadata("defaultParametersAndLastVarargWithCorrectOrder.kt")
        public void testDefaultParametersAndLastVarargWithCorrectOrder() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVarargWithCorrectOrder.kt");
        }

        @Test
        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/extension.kt");
        }

        @Test
        @TestMetadata("extensionInClass.kt")
        public void testExtensionInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/extensionInClass.kt");
        }

        @Test
        @TestMetadata("lambdaMigration.kt")
        public void testLambdaMigration() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigration.kt");
        }

        @Test
        @TestMetadata("lambdaMigrationInClass.kt")
        public void testLambdaMigrationInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigrationInClass.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/simple.kt");
        }

        @Test
        @TestMetadata("simpleInClass.kt")
        public void testSimpleInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/simpleInClass.kt");
        }

        @Test
        @TestMetadata("varargAndDefaultParameters.kt")
        public void testVarargAndDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParameters.kt");
        }

        @Test
        @TestMetadata("varargAndDefaultParametersWithCorrectOrder.kt")
        public void testVarargAndDefaultParametersWithCorrectOrder() throws Exception {
            runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParametersWithCorrectOrder.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/arrayConvention")
    @TestDataPath("$PROJECT_ROOT")
    public class ArrayConvention {
        @Test
        public void testAllFilesPresentInArrayConvention() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/arrayConvention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("simpleAccess.kt")
        public void testSimpleAccess() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccess.kt");
        }

        @Test
        @TestMetadata("simpleAccessInClass.kt")
        public void testSimpleAccessInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessInClass.kt");
        }

        @Test
        @TestMetadata("simpleAccessWithDefault.kt")
        public void testSimpleAccessWithDefault() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefault.kt");
        }

        @Test
        @TestMetadata("simpleAccessWithDefaultInClass.kt")
        public void testSimpleAccessWithDefaultInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefaultInClass.kt");
        }

        @Test
        @TestMetadata("simpleAccessWithLambda.kt")
        public void testSimpleAccessWithLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambda.kt");
        }

        @Test
        @TestMetadata("simpleAccessWithLambdaInClass.kt")
        public void testSimpleAccessWithLambdaInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambdaInClass.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/assert")
    @TestDataPath("$PROJECT_ROOT")
    public class Assert {
        @Test
        public void testAllFilesPresentInAssert() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("jvmAssertInlineFunctionAssertionsDisabled.kt")
        public void testJvmAssertInlineFunctionAssertionsDisabled() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsDisabled.kt");
        }

        @Test
        @TestMetadata("jvmAssertInlineFunctionAssertionsEnabled.kt")
        public void testJvmAssertInlineFunctionAssertionsEnabled() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsEnabled.kt");
        }

        @Test
        @TestMetadata("jvmAssertInlineLambda.kt")
        public void testJvmAssertInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineLambda.kt");
        }

        @Test
        @TestMetadata("jvmClassInitializer.kt")
        public void testJvmClassInitializer() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmClassInitializer.kt");
        }

        @Test
        @TestMetadata("jvmCompanion.kt")
        public void testJvmCompanion() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmCompanion.kt");
        }

        @Test
        @TestMetadata("jvmCrossinlineLambda.kt")
        public void testJvmCrossinlineLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda.kt");
        }

        @Test
        @TestMetadata("jvmCrossinlineLambda2.kt")
        public void testJvmCrossinlineLambda2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda2.kt");
        }

        @Test
        @TestMetadata("jvmCrossinlineLambdaDeclarationSite.kt")
        public void testJvmCrossinlineLambdaDeclarationSite() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSite.kt");
        }

        @Test
        @TestMetadata("jvmCrossinlineLambdaDeclarationSiteOnly.kt")
        public void testJvmCrossinlineLambdaDeclarationSiteOnly() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSiteOnly.kt");
        }

        @Test
        @TestMetadata("jvmCrossinlineRedundant.kt")
        public void testJvmCrossinlineRedundant() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineRedundant.kt");
        }

        @Test
        @TestMetadata("jvmCrossinlineSAMDeclarationSite.kt")
        public void testJvmCrossinlineSAMDeclarationSite() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineSAMDeclarationSite.kt");
        }

        @Test
        @TestMetadata("jvmDoubleInline.kt")
        public void testJvmDoubleInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmDoubleInline.kt");
        }

        @Test
        @TestMetadata("jvmInlineIntoTwoMethods.kt")
        public void testJvmInlineIntoTwoMethods() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmInlineIntoTwoMethods.kt");
        }

        @Test
        @TestMetadata("jvmInlineUsedAsNoinline.kt")
        public void testJvmInlineUsedAsNoinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/assert/jvmInlineUsedAsNoinline.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/builders")
    @TestDataPath("$PROJECT_ROOT")
    public class Builders {
        @Test
        public void testAllFilesPresentInBuilders() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/builders"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("builders.kt")
        public void testBuilders() throws Exception {
            runTest("compiler/testData/codegen/boxInline/builders/builders.kt");
        }

        @Test
        @TestMetadata("buildersAndLambdaCapturing.kt")
        public void testBuildersAndLambdaCapturing() throws Exception {
            runTest("compiler/testData/codegen/boxInline/builders/buildersAndLambdaCapturing.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/bytecodePreprocessing")
    @TestDataPath("$PROJECT_ROOT")
    public class BytecodePreprocessing {
        @Test
        public void testAllFilesPresentInBytecodePreprocessing() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/bytecodePreprocessing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("apiVersionAtLeast1.kt")
        public void testApiVersionAtLeast1() throws Exception {
            runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/apiVersionAtLeast1.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReference {
        @Test
        @TestMetadata("adapted.kt")
        public void testAdapted() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/adapted.kt");
        }

        @Test
        public void testAllFilesPresentInCallableReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("classLevel.kt")
        public void testClassLevel() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/classLevel.kt");
        }

        @Test
        @TestMetadata("classLevel2.kt")
        public void testClassLevel2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/classLevel2.kt");
        }

        @Test
        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/constructor.kt");
        }

        @Test
        @TestMetadata("innerGenericConstuctor.kt")
        public void testInnerGenericConstuctor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/innerGenericConstuctor.kt");
        }

        @Test
        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/intrinsic.kt");
        }

        @Test
        @TestMetadata("jvmFieldProperty.kt")
        public void testJvmFieldProperty() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/jvmFieldProperty.kt");
        }

        @Test
        @TestMetadata("kt15449.kt")
        public void testKt15449() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/kt15449.kt");
        }

        @Test
        @TestMetadata("kt15751_2.kt")
        public void testKt15751_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/kt15751_2.kt");
        }

        @Test
        @TestMetadata("kt16411.kt")
        public void testKt16411() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/kt16411.kt");
        }

        @Test
        @TestMetadata("kt35101.kt")
        public void testKt35101() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/kt35101.kt");
        }

        @Test
        @TestMetadata("propertyIntrinsic.kt")
        public void testPropertyIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/propertyIntrinsic.kt");
        }

        @Test
        @TestMetadata("propertyReference.kt")
        public void testPropertyReference() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/propertyReference.kt");
        }

        @Test
        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/topLevel.kt");
        }

        @Test
        @TestMetadata("topLevelExtension.kt")
        public void testTopLevelExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/topLevelExtension.kt");
        }

        @Test
        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            runTest("compiler/testData/codegen/boxInline/callableReference/topLevelProperty.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/callableReference/adaptedReferences")
        @TestDataPath("$PROJECT_ROOT")
        public class AdaptedReferences {
            @Test
            public void testAllFilesPresentInAdaptedReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("inlineBound.kt")
            public void testInlineBound() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineBound.kt");
            }

            @Test
            @TestMetadata("inlineDefault.kt")
            public void testInlineDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineDefault.kt");
            }

            @Test
            @TestMetadata("inlineVararg.kt")
            public void testInlineVararg() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVararg.kt");
            }

            @Test
            @TestMetadata("inlineVarargAndDefault.kt")
            public void testInlineVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
            }

            @Test
            @TestMetadata("inlineVarargInts.kt")
            public void testInlineVarargInts() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargInts.kt");
            }

            @Test
            @TestMetadata("multipleCallableReferenceUsage.kt")
            public void testMultipleCallableReferenceUsage() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/multipleCallableReferenceUsage.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        public class Bound {
            @Test
            public void testAllFilesPresentInBound() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("classProperty.kt")
            public void testClassProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/classProperty.kt");
            }

            @Test
            @TestMetadata("doubleBoundToThis.kt")
            public void testDoubleBoundToThis() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/doubleBoundToThis.kt");
            }

            @Test
            @TestMetadata("emptyLhsFunction.kt")
            public void testEmptyLhsFunction() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsFunction.kt");
            }

            @Test
            @TestMetadata("emptyLhsOnInlineProperty.kt")
            public void testEmptyLhsOnInlineProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsOnInlineProperty.kt");
            }

            @Test
            @TestMetadata("emptyLhsProperty.kt")
            public void testEmptyLhsProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsProperty.kt");
            }

            @Test
            @TestMetadata("expression.kt")
            public void testExpression() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/expression.kt");
            }

            @Test
            @TestMetadata("extensionReceiver.kt")
            public void testExtensionReceiver() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/extensionReceiver.kt");
            }

            @Test
            @TestMetadata("filter.kt")
            public void testFilter() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/filter.kt");
            }

            @Test
            @TestMetadata("inlineValueParameterInsteadOfReceiver.kt")
            public void testInlineValueParameterInsteadOfReceiver() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/inlineValueParameterInsteadOfReceiver.kt");
            }

            @Test
            @TestMetadata("innerGenericConstuctor.kt")
            public void testInnerGenericConstuctor() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/innerGenericConstuctor.kt");
            }

            @Test
            @TestMetadata("intrinsic.kt")
            public void testIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/intrinsic.kt");
            }

            @Test
            @TestMetadata("jvmFieldProperty.kt")
            public void testJvmFieldProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/jvmFieldProperty.kt");
            }

            @Test
            @TestMetadata("kt18728.kt")
            public void testKt18728() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728.kt");
            }

            @Test
            @TestMetadata("kt18728_2.kt")
            public void testKt18728_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_2.kt");
            }

            @Test
            @TestMetadata("kt18728_3.kt")
            public void testKt18728_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_3.kt");
            }

            @Test
            @TestMetadata("kt18728_4.kt")
            public void testKt18728_4() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_4.kt");
            }

            @Test
            @TestMetadata("kt30933.kt")
            public void testKt30933() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt30933.kt");
            }

            @Test
            @TestMetadata("lambdaOnLhs.kt")
            public void testLambdaOnLhs() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/lambdaOnLhs.kt");
            }

            @Test
            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/map.kt");
            }

            @Test
            @TestMetadata("mixed.kt")
            public void testMixed() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/mixed.kt");
            }

            @Test
            @TestMetadata("objectProperty.kt")
            public void testObjectProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/objectProperty.kt");
            }

            @Test
            @TestMetadata("propertyImportedFromObject.kt")
            public void testPropertyImportedFromObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/propertyImportedFromObject.kt");
            }

            @Test
            @TestMetadata("sideEffect.kt")
            public void testSideEffect() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/sideEffect.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/simple.kt");
            }

            @Test
            @TestMetadata("simpleVal.kt")
            public void testSimpleVal() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal.kt");
            }

            @Test
            @TestMetadata("simpleVal2.kt")
            public void testSimpleVal2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal2.kt");
            }

            @Test
            @TestMetadata("topLevelExtensionProperty.kt")
            public void testTopLevelExtensionProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/callableReference/bound/topLevelExtensionProperty.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/capture")
    @TestDataPath("$PROJECT_ROOT")
    public class Capture {
        @Test
        public void testAllFilesPresentInCapture() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/capture"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("captureInlinable.kt")
        public void testCaptureInlinable() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/captureInlinable.kt");
        }

        @Test
        @TestMetadata("captureInlinableAndOther.kt")
        public void testCaptureInlinableAndOther() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/captureInlinableAndOther.kt");
        }

        @Test
        @TestMetadata("captureThisAndReceiver.kt")
        public void testCaptureThisAndReceiver() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/captureThisAndReceiver.kt");
        }

        @Test
        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/generics.kt");
        }

        @Test
        @TestMetadata("kt48230.kt")
        public void testKt48230() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/kt48230.kt");
        }

        @Test
        @TestMetadata("kt48230_2.kt")
        public void testKt48230_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/kt48230_2.kt");
        }

        @Test
        @TestMetadata("simpleCapturingInClass.kt")
        public void testSimpleCapturingInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInClass.kt");
        }

        @Test
        @TestMetadata("simpleCapturingInPackage.kt")
        public void testSimpleCapturingInPackage() throws Exception {
            runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInPackage.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/complex")
    @TestDataPath("$PROJECT_ROOT")
    public class Complex {
        @Test
        public void testAllFilesPresentInComplex() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("closureChain.kt")
        public void testClosureChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/closureChain.kt");
        }

        @Test
        @TestMetadata("forEachLine.kt")
        public void testForEachLine() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/forEachLine.kt");
        }

        @Test
        @TestMetadata("kt44429.kt")
        public void testKt44429() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/kt44429.kt");
        }

        @Test
        @TestMetadata("lambdaInLambda.kt")
        public void testLambdaInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/lambdaInLambda.kt");
        }

        @Test
        @TestMetadata("swapAndWith.kt")
        public void testSwapAndWith() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/swapAndWith.kt");
        }

        @Test
        @TestMetadata("swapAndWith2.kt")
        public void testSwapAndWith2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/swapAndWith2.kt");
        }

        @Test
        @TestMetadata("use.kt")
        public void testUse() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/use.kt");
        }

        @Test
        @TestMetadata("with.kt")
        public void testWith() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complex/with.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/complexStack")
    @TestDataPath("$PROJECT_ROOT")
    public class ComplexStack {
        @Test
        public void testAllFilesPresentInComplexStack() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complexStack"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("asCheck.kt")
        public void testAsCheck() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/asCheck.kt");
        }

        @Test
        @TestMetadata("asCheck2.kt")
        public void testAsCheck2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/asCheck2.kt");
        }

        @Test
        @TestMetadata("breakContinueInInlineLambdaArgument.kt")
        public void testBreakContinueInInlineLambdaArgument() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/breakContinueInInlineLambdaArgument.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simple.kt");
        }

        @Test
        @TestMetadata("simple2.kt")
        public void testSimple2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simple2.kt");
        }

        @Test
        @TestMetadata("simple3.kt")
        public void testSimple3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simple3.kt");
        }

        @Test
        @TestMetadata("simple4.kt")
        public void testSimple4() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simple4.kt");
        }

        @Test
        @TestMetadata("simpleExtension.kt")
        public void testSimpleExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/simpleExtension.kt");
        }

        @Test
        @TestMetadata("spillConstructorArgumentsAndInlineLambdaParameter.kt")
        public void testSpillConstructorArgumentsAndInlineLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/complexStack/spillConstructorArgumentsAndInlineLambdaParameter.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/contracts")
    @TestDataPath("$PROJECT_ROOT")
    public class Contracts {
        @Test
        public void testAllFilesPresentInContracts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("cfgDependendValInitialization.kt")
        public void testCfgDependendValInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/cfgDependendValInitialization.kt");
        }

        @Test
        @TestMetadata("complexInitializer.kt")
        public void testComplexInitializer() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/complexInitializer.kt");
        }

        @Test
        @TestMetadata("complexInitializerWithStackTransformation.kt")
        public void testComplexInitializerWithStackTransformation() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/complexInitializerWithStackTransformation.kt");
        }

        @Test
        @TestMetadata("crossinlineCallableReference.kt")
        public void testCrossinlineCallableReference() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/crossinlineCallableReference.kt");
        }

        @Test
        @TestMetadata("definiteLongValInitialization.kt")
        public void testDefiniteLongValInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/definiteLongValInitialization.kt");
        }

        @Test
        @TestMetadata("definiteNestedValInitialization.kt")
        public void testDefiniteNestedValInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/definiteNestedValInitialization.kt");
        }

        @Test
        @TestMetadata("definiteValInitInInitializer.kt")
        public void testDefiniteValInitInInitializer() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitInInitializer.kt");
        }

        @Test
        @TestMetadata("definiteValInitialization.kt")
        public void testDefiniteValInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitialization.kt");
        }

        @Test
        @TestMetadata("exactlyOnceCrossinline.kt")
        public void testExactlyOnceCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline.kt");
        }

        @Test
        @TestMetadata("exactlyOnceCrossinline2.kt")
        public void testExactlyOnceCrossinline2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline2.kt");
        }

        @Test
        @TestMetadata("exactlyOnceNoinline.kt")
        public void testExactlyOnceNoinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceNoinline.kt");
        }

        @Test
        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnWithCycle.kt")
        public void testNonLocalReturnWithCycle() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturnWithCycle.kt");
        }

        @Test
        @TestMetadata("propertyInitialization.kt")
        public void testPropertyInitialization() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/propertyInitialization.kt");
        }

        @Test
        @TestMetadata("valInitializationAndUsageInNestedLambda.kt")
        public void testValInitializationAndUsageInNestedLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/contracts/valInitializationAndUsageInNestedLambda.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/defaultValues")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultValues {
        @Test
        @TestMetadata("33Parameters.kt")
        public void test33Parameters() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/33Parameters.kt");
        }

        @Test
        @TestMetadata("33ParametersInConstructor.kt")
        public void test33ParametersInConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/33ParametersInConstructor.kt");
        }

        @Test
        public void testAllFilesPresentInDefaultValues() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("defaultInExtension.kt")
        public void testDefaultInExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/defaultInExtension.kt");
        }

        @Test
        @TestMetadata("defaultMethod.kt")
        public void testDefaultMethod() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethod.kt");
        }

        @Test
        @TestMetadata("defaultMethodInClass.kt")
        public void testDefaultMethodInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethodInClass.kt");
        }

        @Test
        @TestMetadata("defaultParamRemapping.kt")
        public void testDefaultParamRemapping() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/defaultParamRemapping.kt");
        }

        @Test
        @TestMetadata("inlineInDefaultParameter.kt")
        public void testInlineInDefaultParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/inlineInDefaultParameter.kt");
        }

        @Test
        @TestMetadata("inlineLambdaInNoInlineDefault.kt")
        public void testInlineLambdaInNoInlineDefault() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/inlineLambdaInNoInlineDefault.kt");
        }

        @Test
        @TestMetadata("kt11479.kt")
        public void testKt11479() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479.kt");
        }

        @Test
        @TestMetadata("kt11479InlinedDefaultParameter.kt")
        public void testKt11479InlinedDefaultParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479InlinedDefaultParameter.kt");
        }

        @Test
        @TestMetadata("kt14564.kt")
        public void testKt14564() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564.kt");
        }

        @Test
        @TestMetadata("kt14564_2.kt")
        public void testKt14564_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564_2.kt");
        }

        @Test
        @TestMetadata("kt16496.kt")
        public void testKt16496() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt16496.kt");
        }

        @Test
        @TestMetadata("kt18689.kt")
        public void testKt18689() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689.kt");
        }

        @Test
        @TestMetadata("kt18689_2.kt")
        public void testKt18689_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_2.kt");
        }

        @Test
        @TestMetadata("kt18689_3.kt")
        public void testKt18689_3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_3.kt");
        }

        @Test
        @TestMetadata("kt18689_4.kt")
        public void testKt18689_4() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_4.kt");
        }

        @Test
        @TestMetadata("kt5685.kt")
        public void testKt5685() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/kt5685.kt");
        }

        @Test
        @TestMetadata("simpleDefaultMethod.kt")
        public void testSimpleDefaultMethod() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/simpleDefaultMethod.kt");
        }

        @Test
        @TestMetadata("varArgNoInline.kt")
        public void testVarArgNoInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/defaultValues/varArgNoInline.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining")
        @TestDataPath("$PROJECT_ROOT")
        public class LambdaInlining {
            @Test
            public void testAllFilesPresentInLambdaInlining() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("checkLambdaClassIsPresent.kt")
            public void testCheckLambdaClassIsPresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassIsPresent.kt");
            }

            @Test
            @TestMetadata("checkLambdaClassesArePresent.kt")
            public void testCheckLambdaClassesArePresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassesArePresent.kt");
            }

            @Test
            @TestMetadata("checkObjectClassIsPresent.kt")
            public void testCheckObjectClassIsPresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkObjectClassIsPresent.kt");
            }

            @Test
            @TestMetadata("checkStaticLambdaClassIsPresent.kt")
            public void testCheckStaticLambdaClassIsPresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassIsPresent.kt");
            }

            @Test
            @TestMetadata("checkStaticLambdaClassesArePresent.kt")
            public void testCheckStaticLambdaClassesArePresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassesArePresent.kt");
            }

            @Test
            @TestMetadata("checkStaticObjectClassIsPresent.kt")
            public void testCheckStaticObjectClassIsPresent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticObjectClassIsPresent.kt");
            }

            @Test
            @TestMetadata("defaultAfterCapturing.kt")
            public void testDefaultAfterCapturing() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultAfterCapturing.kt");
            }

            @Test
            @TestMetadata("defaultCallInDefaultLambda.kt")
            public void testDefaultCallInDefaultLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultCallInDefaultLambda.kt");
            }

            @Test
            @TestMetadata("defaultLambdaInNoInline.kt")
            public void testDefaultLambdaInNoInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultLambdaInNoInline.kt");
            }

            @Test
            @TestMetadata("differentInvokeSignature.kt")
            public void testDifferentInvokeSignature() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/differentInvokeSignature.kt");
            }

            @Test
            @TestMetadata("genericLambda.kt")
            public void testGenericLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/genericLambda.kt");
            }

            @Test
            @TestMetadata("instanceCapturedInClass.kt")
            public void testInstanceCapturedInClass() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInClass.kt");
            }

            @Test
            @TestMetadata("instanceCapturedInInterface.kt")
            public void testInstanceCapturedInInterface() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInInterface.kt");
            }

            @Test
            @TestMetadata("jvmStaticDefault.kt")
            public void testJvmStaticDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/jvmStaticDefault.kt");
            }

            @Test
            @TestMetadata("kt21827.kt")
            public void testKt21827() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21827.kt");
            }

            @Test
            @TestMetadata("kt21946.kt")
            public void testKt21946() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21946.kt");
            }

            @Test
            @TestMetadata("kt24477.kt")
            public void testKt24477() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt24477.kt");
            }

            @Test
            @TestMetadata("kt25106.kt")
            public void testKt25106() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt25106.kt");
            }

            @Test
            @TestMetadata("kt26636.kt")
            public void testKt26636() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt26636.kt");
            }

            @Test
            @TestMetadata("lambdaTakesResult.kt")
            public void testLambdaTakesResult() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/lambdaTakesResult.kt");
            }

            @Test
            @TestMetadata("noInline.kt")
            public void testNoInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/noInline.kt");
            }

            @Test
            @TestMetadata("nonDefaultInlineInNoInline.kt")
            public void testNonDefaultInlineInNoInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/nonDefaultInlineInNoInline.kt");
            }

            @Test
            @TestMetadata("receiverClash.kt")
            public void testReceiverClash() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash.kt");
            }

            @Test
            @TestMetadata("receiverClash2.kt")
            public void testReceiverClash2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash2.kt");
            }

            @Test
            @TestMetadata("receiverClashInClass.kt")
            public void testReceiverClashInClass() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass.kt");
            }

            @Test
            @TestMetadata("receiverClashInClass2.kt")
            public void testReceiverClashInClass2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass2.kt");
            }

            @Test
            @TestMetadata("reordering.kt")
            public void testReordering() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/reordering.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simple.kt");
            }

            @Test
            @TestMetadata("simpleErased.kt")
            public void testSimpleErased() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErased.kt");
            }

            @Test
            @TestMetadata("simpleErasedStaticInstance.kt")
            public void testSimpleErasedStaticInstance() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErasedStaticInstance.kt");
            }

            @Test
            @TestMetadata("simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleExtension.kt");
            }

            @Test
            @TestMetadata("simpleGeneric.kt")
            public void testSimpleGeneric() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleGeneric.kt");
            }

            @Test
            @TestMetadata("simpleStaticInstance.kt")
            public void testSimpleStaticInstance() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleStaticInstance.kt");
            }

            @Test
            @TestMetadata("thisClash.kt")
            public void testThisClash() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClash.kt");
            }

            @Test
            @TestMetadata("thisClashInClass.kt")
            public void testThisClashInClass() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClashInClass.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences")
            @TestDataPath("$PROJECT_ROOT")
            public class CallableReferences {
                @Test
                public void testAllFilesPresentInCallableReferences() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("boundFunctionReference.kt")
                public void testBoundFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReference.kt");
                }

                @Test
                @TestMetadata("boundFunctionReferenceOnInt.kt")
                public void testBoundFunctionReferenceOnInt() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnInt.kt");
                }

                @Test
                @TestMetadata("boundFunctionReferenceOnLong.kt")
                public void testBoundFunctionReferenceOnLong() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnLong.kt");
                }

                @Test
                @TestMetadata("boundInlineClassMethod.kt")
                public void testBoundInlineClassMethod() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethod.kt");
                }

                @Test
                @TestMetadata("boundInlineClassMethodWithAny.kt")
                public void testBoundInlineClassMethodWithAny() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithAny.kt");
                }

                @Test
                @TestMetadata("boundInlineClassMethodWithInt.kt")
                public void testBoundInlineClassMethodWithInt() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithInt.kt");
                }

                @Test
                @TestMetadata("boundPropertyReference.kt")
                public void testBoundPropertyReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReference.kt");
                }

                @Test
                @TestMetadata("boundPropertyReferenceOnInt.kt")
                public void testBoundPropertyReferenceOnInt() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnInt.kt");
                }

                @Test
                @TestMetadata("boundPropertyReferenceOnLong.kt")
                public void testBoundPropertyReferenceOnLong() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnLong.kt");
                }

                @Test
                @TestMetadata("constuctorReference.kt")
                public void testConstuctorReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/constuctorReference.kt");
                }

                @Test
                @TestMetadata("defaultAfterBoundReference.kt")
                public void testDefaultAfterBoundReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/defaultAfterBoundReference.kt");
                }

                @Test
                @TestMetadata("differentInvokeSignature.kt")
                public void testDifferentInvokeSignature() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature.kt");
                }

                @Test
                @TestMetadata("differentInvokeSignature2.kt")
                public void testDifferentInvokeSignature2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature2.kt");
                }

                @Test
                @TestMetadata("differentInvokeSignature3.kt")
                public void testDifferentInvokeSignature3() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature3.kt");
                }

                @Test
                @TestMetadata("functionImportedFromObject.kt")
                public void testFunctionImportedFromObject() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionImportedFromObject.kt");
                }

                @Test
                @TestMetadata("functionReference.kt")
                public void testFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReference.kt");
                }

                @Test
                @TestMetadata("functionReferenceFromClass.kt")
                public void testFunctionReferenceFromClass() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromClass.kt");
                }

                @Test
                @TestMetadata("functionReferenceFromObject.kt")
                public void testFunctionReferenceFromObject() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromObject.kt");
                }

                @Test
                @TestMetadata("innerClassConstuctorReference.kt")
                public void testInnerClassConstuctorReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/innerClassConstuctorReference.kt");
                }

                @Test
                @TestMetadata("mutableBoundPropertyReferenceFromClass.kt")
                public void testMutableBoundPropertyReferenceFromClass() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutableBoundPropertyReferenceFromClass.kt");
                }

                @Test
                @TestMetadata("mutablePropertyReferenceFromClass.kt")
                public void testMutablePropertyReferenceFromClass() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutablePropertyReferenceFromClass.kt");
                }

                @Test
                @TestMetadata("privateFunctionReference.kt")
                public void testPrivateFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privateFunctionReference.kt");
                }

                @Test
                @TestMetadata("privatePropertyReference.kt")
                public void testPrivatePropertyReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privatePropertyReference.kt");
                }

                @Test
                @TestMetadata("propertyImportedFromObject.kt")
                public void testPropertyImportedFromObject() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyImportedFromObject.kt");
                }

                @Test
                @TestMetadata("propertyReference.kt")
                public void testPropertyReference() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReference.kt");
                }

                @Test
                @TestMetadata("propertyReferenceFromClass.kt")
                public void testPropertyReferenceFromClass() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromClass.kt");
                }

                @Test
                @TestMetadata("propertyReferenceFromObject.kt")
                public void testPropertyReferenceFromObject() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromObject.kt");
                }

                @Test
                @TestMetadata("withInlineClassParameter.kt")
                public void testWithInlineClassParameter() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/withInlineClassParameter.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/maskElimination")
        @TestDataPath("$PROJECT_ROOT")
        public class MaskElimination {
            @Test
            @TestMetadata("32Parameters.kt")
            public void test32Parameters() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/32Parameters.kt");
            }

            @Test
            @TestMetadata("33Parameters.kt")
            public void test33Parameters() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/33Parameters.kt");
            }

            @Test
            public void testAllFilesPresentInMaskElimination() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/maskElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("kt18792.kt")
            public void testKt18792() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt18792.kt");
            }

            @Test
            @TestMetadata("kt19679.kt")
            public void testKt19679() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679.kt");
            }

            @Test
            @TestMetadata("kt19679_2.kt")
            public void testKt19679_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_2.kt");
            }

            @Test
            @TestMetadata("kt19679_3.kt")
            public void testKt19679_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_3.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/simple.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegatedProperty {
        @Test
        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("kt16864.kt")
        public void testKt16864() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt16864.kt");
        }

        @Test
        @TestMetadata("kt48498.kt")
        public void testKt48498() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt48498.kt");
        }

        @Test
        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/local.kt");
        }

        @Test
        @TestMetadata("localDeclaredInLambda.kt")
        public void testLocalDeclaredInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/localDeclaredInLambda.kt");
        }

        @Test
        @TestMetadata("localInAnonymousObject.kt")
        public void testLocalInAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInAnonymousObject.kt");
        }

        @Test
        @TestMetadata("localInLambda.kt")
        public void testLocalInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInLambda.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/enclosingInfo")
    @TestDataPath("$PROJECT_ROOT")
    public class EnclosingInfo {
        @Test
        public void testAllFilesPresentInEnclosingInfo() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("anonymousInLambda.kt")
        public void testAnonymousInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enclosingInfo/anonymousInLambda.kt");
        }

        @Test
        @TestMetadata("inlineChain.kt")
        public void testInlineChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain.kt");
        }

        @Test
        @TestMetadata("inlineChain2.kt")
        public void testInlineChain2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain2.kt");
        }

        @Test
        @TestMetadata("objectInInlineFun.kt")
        public void testObjectInInlineFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enclosingInfo/objectInInlineFun.kt");
        }

        @Test
        @TestMetadata("transformedConstructor.kt")
        public void testTransformedConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructor.kt");
        }

        @Test
        @TestMetadata("transformedConstructorWithAdditionalObject.kt")
        public void testTransformedConstructorWithAdditionalObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithAdditionalObject.kt");
        }

        @Test
        @TestMetadata("transformedConstructorWithNestedInline.kt")
        public void testTransformedConstructorWithNestedInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithNestedInline.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/enum")
    @TestDataPath("$PROJECT_ROOT")
    public class Enum {
        @Test
        public void testAllFilesPresentInEnum() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("kt10569.kt")
        public void testKt10569() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/kt10569.kt");
        }

        @Test
        @TestMetadata("kt18254.kt")
        public void testKt18254() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/kt18254.kt");
        }

        @Test
        @TestMetadata("valueOf.kt")
        public void testValueOf() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOf.kt");
        }

        @Test
        @TestMetadata("valueOfCapturedType.kt")
        public void testValueOfCapturedType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOfCapturedType.kt");
        }

        @Test
        @TestMetadata("valueOfChain.kt")
        public void testValueOfChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOfChain.kt");
        }

        @Test
        @TestMetadata("valueOfChainCapturedType.kt")
        public void testValueOfChainCapturedType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOfChainCapturedType.kt");
        }

        @Test
        @TestMetadata("valueOfNonReified.kt")
        public void testValueOfNonReified() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valueOfNonReified.kt");
        }

        @Test
        @TestMetadata("values.kt")
        public void testValues() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/values.kt");
        }

        @Test
        @TestMetadata("valuesAsArray.kt")
        public void testValuesAsArray() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesAsArray.kt");
        }

        @Test
        @TestMetadata("valuesCapturedType.kt")
        public void testValuesCapturedType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesCapturedType.kt");
        }

        @Test
        @TestMetadata("valuesChain.kt")
        public void testValuesChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesChain.kt");
        }

        @Test
        @TestMetadata("valuesChainCapturedType.kt")
        public void testValuesChainCapturedType() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesChainCapturedType.kt");
        }

        @Test
        @TestMetadata("valuesNonReified.kt")
        public void testValuesNonReified() throws Exception {
            runTest("compiler/testData/codegen/boxInline/enum/valuesNonReified.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/functionExpression")
    @TestDataPath("$PROJECT_ROOT")
    public class FunctionExpression {
        @Test
        public void testAllFilesPresentInFunctionExpression() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/functionExpression/extension.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/inlineArgsInplace")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineArgsInplace {
        @Test
        public void testAllFilesPresentInInlineArgsInplace() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineArgsInplace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("callArgumentReordering.kt")
        public void testCallArgumentReordering() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineArgsInplace/callArgumentReordering.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("anonymousObject.kt")
        public void testAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/anonymousObject.kt");
        }

        @Test
        @TestMetadata("inlineClassWithInlineValReturningInlineClass.kt")
        public void testInlineClassWithInlineValReturningInlineClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineClassWithInlineValReturningInlineClass.kt");
        }

        @Test
        @TestMetadata("inlineFunctionInsideInlineClassesBox.kt")
        public void testInlineFunctionInsideInlineClassesBox() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineFunctionInsideInlineClassesBox.kt");
        }

        @Test
        @TestMetadata("noReturnTypeManglingFun.kt")
        public void testNoReturnTypeManglingFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFun.kt");
        }

        @Test
        @TestMetadata("noReturnTypeManglingFunJvmName.kt")
        public void testNoReturnTypeManglingFunJvmName() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFunJvmName.kt");
        }

        @Test
        @TestMetadata("noReturnTypeManglingVal.kt")
        public void testNoReturnTypeManglingVal() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingVal.kt");
        }

        @Test
        @TestMetadata("withReturnTypeManglingFun.kt")
        public void testWithReturnTypeManglingFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFun.kt");
        }

        @Test
        @TestMetadata("withReturnTypeManglingFunJvmName.kt")
        public void testWithReturnTypeManglingFunJvmName() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFunJvmName.kt");
        }

        @Test
        @TestMetadata("withReturnTypeManglingVal.kt")
        public void testWithReturnTypeManglingVal() throws Exception {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingVal.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter")
        @TestDataPath("$PROJECT_ROOT")
        public class UnboxGenericParameter {
            @Test
            public void testAllFilesPresentInUnboxGenericParameter() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface")
            @TestDataPath("$PROJECT_ROOT")
            public class FunInterface {
                @Test
                public void testAllFilesPresentInFunInterface() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/any.kt");
                }

                @Test
                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/anyN.kt");
                }

                @Test
                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/iface.kt");
                }

                @Test
                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/ifaceChild.kt");
                }

                @Test
                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/primitive.kt");
                }

                @Test
                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/string.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda")
            @TestDataPath("$PROJECT_ROOT")
            public class Lambda {
                @Test
                public void testAllFilesPresentInLambda() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/any.kt");
                }

                @Test
                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/anyN.kt");
                }

                @Test
                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/iface.kt");
                }

                @Test
                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/ifaceChild.kt");
                }

                @Test
                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/primitive.kt");
                }

                @Test
                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/string.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral")
            @TestDataPath("$PROJECT_ROOT")
            public class ObjectLiteral {
                @Test
                public void testAllFilesPresentInObjectLiteral() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("any.kt")
                public void testAny() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/any.kt");
                }

                @Test
                @TestMetadata("anyN.kt")
                public void testAnyN() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/anyN.kt");
                }

                @Test
                @TestMetadata("iface.kt")
                public void testIface() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/iface.kt");
                }

                @Test
                @TestMetadata("ifaceChild.kt")
                public void testIfaceChild() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/ifaceChild.kt");
                }

                @Test
                @TestMetadata("primitive.kt")
                public void testPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/primitive.kt");
                }

                @Test
                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/string.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/innerClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InnerClasses {
        @Test
        public void testAllFilesPresentInInnerClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("captureThisAndOuter.kt")
        public void testCaptureThisAndOuter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/captureThisAndOuter.kt");
        }

        @Test
        @TestMetadata("fakeOverride.kt")
        public void testFakeOverride() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/fakeOverride.kt");
        }

        @Test
        @TestMetadata("innerInlineFunCapturesOuter.kt")
        public void testInnerInlineFunCapturesOuter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuter.kt");
        }

        @Test
        @TestMetadata("innerInlineFunCapturesOuterByAnotherInlineFun.kt")
        public void testInnerInlineFunCapturesOuterByAnotherInlineFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterByAnotherInlineFun.kt");
        }

        @Test
        @TestMetadata("innerInlineFunCapturesOuterDeep.kt")
        public void testInnerInlineFunCapturesOuterDeep() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterDeep.kt");
        }

        @Test
        @TestMetadata("innerInlineFunCapturesOuterFunRef.kt")
        public void testInnerInlineFunCapturesOuterFunRef() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterFunRef.kt");
        }

        @Test
        @TestMetadata("innerInlineFunCapturesOuterWithInlineClass.kt")
        public void testInnerInlineFunCapturesOuterWithInlineClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterWithInlineClass.kt");
        }

        @Test
        @TestMetadata("innerLambda.kt")
        public void testInnerLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/innerLambda.kt");
        }

        @Test
        @TestMetadata("kt10259.kt")
        public void testKt10259() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/kt10259.kt");
        }

        @Test
        @TestMetadata("kt12126.kt")
        public void testKt12126() throws Exception {
            runTest("compiler/testData/codegen/boxInline/innerClasses/kt12126.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic")
    @TestDataPath("$PROJECT_ROOT")
    public class Invokedynamic {
        @Test
        public void testAllFilesPresentInInvokedynamic() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic/lambdas")
        @TestDataPath("$PROJECT_ROOT")
        public class Lambdas {
            @Test
            public void testAllFilesPresentInLambdas() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("crossinlineLambda1.kt")
            public void testCrossinlineLambda1() throws Exception {
                runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda1.kt");
            }

            @Test
            @TestMetadata("crossinlineLambda2.kt")
            public void testCrossinlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda2.kt");
            }

            @Test
            @TestMetadata("inlineFunInDifferentPackage.kt")
            public void testInlineFunInDifferentPackage() throws Exception {
                runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineFunInDifferentPackage.kt");
            }

            @Test
            @TestMetadata("inlineLambda1.kt")
            public void testInlineLambda1() throws Exception {
                runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineLambda1.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic/sam")
        @TestDataPath("$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("crossinlineLambda1.kt")
            public void testCrossinlineLambda1() throws Exception {
                runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda1.kt");
            }

            @Test
            @TestMetadata("crossinlineLambda2.kt")
            public void testCrossinlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda2.kt");
            }

            @Test
            @TestMetadata("inlineFunInDifferentPackage.kt")
            public void testInlineFunInDifferentPackage() throws Exception {
                runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineFunInDifferentPackage.kt");
            }

            @Test
            @TestMetadata("inlineLambda1.kt")
            public void testInlineLambda1() throws Exception {
                runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineLambda1.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/jvmName")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmName {
        @Test
        public void testAllFilesPresentInJvmName() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/jvmName/simple.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/jvmPackageName")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmPackageName {
        @Test
        public void testAllFilesPresentInJvmPackageName() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmPackageName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/jvmPackageName/simple.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/lambdaClassClash")
    @TestDataPath("$PROJECT_ROOT")
    public class LambdaClassClash {
        @Test
        public void testAllFilesPresentInLambdaClassClash() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaClassClash"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("lambdaClassClash.kt")
        public void testLambdaClassClash() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaClassClash/lambdaClassClash.kt");
        }

        @Test
        @TestMetadata("noInlineLambdaX2.kt")
        public void testNoInlineLambdaX2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaClassClash/noInlineLambdaX2.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/lambdaTransformation")
    @TestDataPath("$PROJECT_ROOT")
    public class LambdaTransformation {
        @Test
        public void testAllFilesPresentInLambdaTransformation() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaTransformation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("lambdaCloning.kt")
        public void testLambdaCloning() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaCloning.kt");
        }

        @Test
        @TestMetadata("lambdaInLambda2.kt")
        public void testLambdaInLambda2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambda2.kt");
        }

        @Test
        @TestMetadata("lambdaInLambdaNoInline.kt")
        public void testLambdaInLambdaNoInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambdaNoInline.kt");
        }

        @Test
        @TestMetadata("regeneratedLambdaName.kt")
        public void testRegeneratedLambdaName() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName.kt");
        }

        @Test
        @TestMetadata("regeneratedLambdaName2.kt")
        public void testRegeneratedLambdaName2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName2.kt");
        }

        @Test
        @TestMetadata("sameCaptured.kt")
        public void testSameCaptured() throws Exception {
            runTest("compiler/testData/codegen/boxInline/lambdaTransformation/sameCaptured.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/localFunInLambda")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalFunInLambda {
        @Test
        public void testAllFilesPresentInLocalFunInLambda() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/localFunInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("defaultParam.kt")
        public void testDefaultParam() throws Exception {
            runTest("compiler/testData/codegen/boxInline/localFunInLambda/defaultParam.kt");
        }

        @Test
        @TestMetadata("lambdaInLambdaCapturesAnotherFun.kt")
        public void testLambdaInLambdaCapturesAnotherFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/localFunInLambda/lambdaInLambdaCapturesAnotherFun.kt");
        }

        @Test
        @TestMetadata("localFunInLambda.kt")
        public void testLocalFunInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambda.kt");
        }

        @Test
        @TestMetadata("localFunInLambdaCapturesAnotherFun.kt")
        public void testLocalFunInLambdaCapturesAnotherFun() throws Exception {
            runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambdaCapturesAnotherFun.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/multiModule")
    @TestDataPath("$PROJECT_ROOT")
    public class MultiModule {
        @Test
        public void testAllFilesPresentInMultiModule() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("tryCatchWithRecursiveInline.kt")
        public void testTryCatchWithRecursiveInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/multiModule/tryCatchWithRecursiveInline.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("defaultArguments.kt")
        public void testDefaultArguments() throws Exception {
            runTest("compiler/testData/codegen/boxInline/multifileClasses/defaultArguments.kt");
        }

        @Test
        @TestMetadata("inlineFromOptimizedMultifileClass.kt")
        public void testInlineFromOptimizedMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOptimizedMultifileClass.kt");
        }

        @Test
        @TestMetadata("inlineFromOtherPackage.kt")
        public void testInlineFromOtherPackage() throws Exception {
            runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOtherPackage.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/multiplatform")
    @TestDataPath("$PROJECT_ROOT")
    public class Multiplatform {
        @Test
        public void testAllFilesPresentInMultiplatform() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/multiplatform/defaultArguments")
        @TestDataPath("$PROJECT_ROOT")
        public class DefaultArguments {
            @Test
            public void testAllFilesPresentInDefaultArguments() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("receiversAndParametersInLambda.kt")
            public void testReceiversAndParametersInLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/multiplatform/defaultArguments/receiversAndParametersInLambda.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/noInline")
    @TestDataPath("$PROJECT_ROOT")
    public class NoInline {
        @Test
        public void testAllFilesPresentInNoInline() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/noInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("extensionReceiver.kt")
        public void testExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/extensionReceiver.kt");
        }

        @Test
        @TestMetadata("lambdaAsGeneric.kt")
        public void testLambdaAsGeneric() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsGeneric.kt");
        }

        @Test
        @TestMetadata("lambdaAsNonFunction.kt")
        public void testLambdaAsNonFunction() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsNonFunction.kt");
        }

        @Test
        @TestMetadata("noInline.kt")
        public void testNoInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/noInline.kt");
        }

        @Test
        @TestMetadata("noInlineLambdaChain.kt")
        public void testNoInlineLambdaChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChain.kt");
        }

        @Test
        @TestMetadata("noInlineLambdaChainWithCapturedInline.kt")
        public void testNoInlineLambdaChainWithCapturedInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChainWithCapturedInline.kt");
        }

        @Test
        @TestMetadata("withoutInline.kt")
        public void testWithoutInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/noInline/withoutInline.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns")
    @TestDataPath("$PROJECT_ROOT")
    public class NonLocalReturns {
        @Test
        public void testAllFilesPresentInNonLocalReturns() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("explicitLocalReturn.kt")
        public void testExplicitLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/explicitLocalReturn.kt");
        }

        @Test
        @TestMetadata("fromArrayGenerator.kt")
        public void testFromArrayGenerator() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGenerator.kt");
        }

        @Test
        @TestMetadata("fromArrayGeneratorCatch.kt")
        public void testFromArrayGeneratorCatch() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorCatch.kt");
        }

        @Test
        @TestMetadata("fromArrayGeneratorNested.kt")
        public void testFromArrayGeneratorNested() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorNested.kt");
        }

        @Test
        @TestMetadata("fromArrayGeneratorWithCapture.kt")
        public void testFromArrayGeneratorWithCapture() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCapture.kt");
        }

        @Test
        @TestMetadata("fromArrayGeneratorWithCatch.kt")
        public void testFromArrayGeneratorWithCatch() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCatch.kt");
        }

        @Test
        @TestMetadata("fromArrayGeneratorWithFinally.kt")
        public void testFromArrayGeneratorWithFinally() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinally.kt");
        }

        @Test
        @TestMetadata("fromArrayGeneratorWithFinallyX2.kt")
        public void testFromArrayGeneratorWithFinallyX2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2.kt");
        }

        @Test
        @TestMetadata("fromArrayGeneratorWithFinallyX2_2.kt")
        public void testFromArrayGeneratorWithFinallyX2_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2_2.kt");
        }

        @Test
        @TestMetadata("fromInterfaceDefaultGetter.kt")
        public void testFromInterfaceDefaultGetter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromInterfaceDefaultGetter.kt");
        }

        @Test
        @TestMetadata("justReturnInLambda.kt")
        public void testJustReturnInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/justReturnInLambda.kt");
        }

        @Test
        @TestMetadata("kt5199.kt")
        public void testKt5199() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt5199.kt");
        }

        @Test
        @TestMetadata("kt8948.kt")
        public void testKt8948() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948.kt");
        }

        @Test
        @TestMetadata("kt8948v2.kt")
        public void testKt8948v2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948v2.kt");
        }

        @Test
        @TestMetadata("kt9304.kt")
        public void testKt9304() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt9304.kt");
        }

        @Test
        @TestMetadata("nestedNonLocals.kt")
        public void testNestedNonLocals() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nestedNonLocals.kt");
        }

        @Test
        @TestMetadata("noInlineLocalReturn.kt")
        public void testNoInlineLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/noInlineLocalReturn.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnFromOuterLambda.kt")
        public void testNonLocalReturnFromOuterLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nonLocalReturnFromOuterLambda.kt");
        }

        @Test
        @TestMetadata("propertyAccessors.kt")
        public void testPropertyAccessors() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/propertyAccessors.kt");
        }

        @Test
        @TestMetadata("returnFromFunctionExpr.kt")
        public void testReturnFromFunctionExpr() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/returnFromFunctionExpr.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simple.kt");
        }

        @Test
        @TestMetadata("simpleFunctional.kt")
        public void testSimpleFunctional() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleFunctional.kt");
        }

        @Test
        @TestMetadata("simpleVoid.kt")
        public void testSimpleVoid() throws Exception {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleVoid.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize")
        @TestDataPath("$PROJECT_ROOT")
        public class Deparenthesize {
            @Test
            public void testAllFilesPresentInDeparenthesize() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("bracket.kt")
            public void testBracket() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/bracket.kt");
            }

            @Test
            @TestMetadata("labeled.kt")
            public void testLabeled() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/labeled.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally")
        @TestDataPath("$PROJECT_ROOT")
        public class TryFinally {
            @Test
            public void testAllFilesPresentInTryFinally() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("kt16417.kt")
            public void testKt16417() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt16417.kt");
            }

            @Test
            @TestMetadata("kt20433.kt")
            public void testKt20433() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433.kt");
            }

            @Test
            @TestMetadata("kt20433_2.kt")
            public void testKt20433_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2.kt");
            }

            @Test
            @TestMetadata("kt20433_2_void.kt")
            public void testKt20433_2_void() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2_void.kt");
            }

            @Test
            @TestMetadata("kt20433_void.kt")
            public void testKt20433_void() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_void.kt");
            }

            @Test
            @TestMetadata("kt26384.kt")
            public void testKt26384() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384.kt");
            }

            @Test
            @TestMetadata("kt26384_2.kt")
            public void testKt26384_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384_2.kt");
            }

            @Test
            @TestMetadata("kt28546.kt")
            public void testKt28546() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt28546.kt");
            }

            @Test
            @TestMetadata("kt6956.kt")
            public void testKt6956() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt6956.kt");
            }

            @Test
            @TestMetadata("kt7273.kt")
            public void testKt7273() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt7273.kt");
            }

            @Test
            @TestMetadata("nonLocalReturnFromCatchBlock.kt")
            public void testNonLocalReturnFromCatchBlock() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromCatchBlock.kt");
            }

            @Test
            @TestMetadata("nonLocalReturnFromOuterLambda.kt")
            public void testNonLocalReturnFromOuterLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromOuterLambda.kt");
            }

            @Test
            @TestMetadata("nonLocalReturnToCatchBlock.kt")
            public void testNonLocalReturnToCatchBlock() throws Exception {
                runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnToCatchBlock.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite")
            @TestDataPath("$PROJECT_ROOT")
            public class CallSite {
                @Test
                public void testAllFilesPresentInCallSite() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("callSite.kt")
                public void testCallSite() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSite.kt");
                }

                @Test
                @TestMetadata("callSiteComplex.kt")
                public void testCallSiteComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSiteComplex.kt");
                }

                @Test
                @TestMetadata("exceptionTableSplit.kt")
                public void testExceptionTableSplit() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplit.kt");
                }

                @Test
                @TestMetadata("exceptionTableSplitNoReturn.kt")
                public void testExceptionTableSplitNoReturn() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplitNoReturn.kt");
                }

                @Test
                @TestMetadata("finallyInFinally.kt")
                public void testFinallyInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/finallyInFinally.kt");
                }

                @Test
                @TestMetadata("wrongVarInterval.kt")
                public void testWrongVarInterval() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/wrongVarInterval.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained")
            @TestDataPath("$PROJECT_ROOT")
            public class Chained {
                @Test
                public void testAllFilesPresentInChained() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("finallyInFinally.kt")
                public void testFinallyInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally.kt");
                }

                @Test
                @TestMetadata("finallyInFinally2.kt")
                public void testFinallyInFinally2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally2.kt");
                }

                @Test
                @TestMetadata("intReturn.kt")
                public void testIntReturn() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturn.kt");
                }

                @Test
                @TestMetadata("intReturnComplex.kt")
                public void testIntReturnComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex.kt");
                }

                @Test
                @TestMetadata("intReturnComplex2.kt")
                public void testIntReturnComplex2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex2.kt");
                }

                @Test
                @TestMetadata("intReturnComplex3.kt")
                public void testIntReturnComplex3() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex3.kt");
                }

                @Test
                @TestMetadata("intReturnComplex4.kt")
                public void testIntReturnComplex4() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex4.kt");
                }

                @Test
                @TestMetadata("nestedLambda.kt")
                public void testNestedLambda() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/nestedLambda.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite")
            @TestDataPath("$PROJECT_ROOT")
            public class DeclSite {
                @Test
                public void testAllFilesPresentInDeclSite() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("complex.kt")
                public void testComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/complex.kt");
                }

                @Test
                @TestMetadata("intReturn.kt")
                public void testIntReturn() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturn.kt");
                }

                @Test
                @TestMetadata("intReturnComplex.kt")
                public void testIntReturnComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturnComplex.kt");
                }

                @Test
                @TestMetadata("longReturn.kt")
                public void testLongReturn() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/longReturn.kt");
                }

                @Test
                @TestMetadata("nested.kt")
                public void testNested() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/nested.kt");
                }

                @Test
                @TestMetadata("returnInFinally.kt")
                public void testReturnInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInFinally.kt");
                }

                @Test
                @TestMetadata("returnInTry.kt")
                public void testReturnInTry() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTry.kt");
                }

                @Test
                @TestMetadata("returnInTryAndFinally.kt")
                public void testReturnInTryAndFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTryAndFinally.kt");
                }

                @Test
                @TestMetadata("severalInTry.kt")
                public void testSeveralInTry() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTry.kt");
                }

                @Test
                @TestMetadata("severalInTryComplex.kt")
                public void testSeveralInTryComplex() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTryComplex.kt");
                }

                @Test
                @TestMetadata("voidInlineFun.kt")
                public void testVoidInlineFun() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidInlineFun.kt");
                }

                @Test
                @TestMetadata("voidNonLocal.kt")
                public void testVoidNonLocal() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidNonLocal.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable")
            @TestDataPath("$PROJECT_ROOT")
            public class ExceptionTable {
                @Test
                public void testAllFilesPresentInExceptionTable() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("break.kt")
                public void testBreak() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/break.kt");
                }

                @Test
                @TestMetadata("continue.kt")
                public void testContinue() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/continue.kt");
                }

                @Test
                @TestMetadata("exceptionInFinally.kt")
                public void testExceptionInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/exceptionInFinally.kt");
                }

                @Test
                @TestMetadata("forInFinally.kt")
                public void testForInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/forInFinally.kt");
                }

                @Test
                @TestMetadata("innerAndExternal.kt")
                public void testInnerAndExternal() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternal.kt");
                }

                @Test
                @TestMetadata("innerAndExternalNested.kt")
                public void testInnerAndExternalNested() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalNested.kt");
                }

                @Test
                @TestMetadata("innerAndExternalSimple.kt")
                public void testInnerAndExternalSimple() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalSimple.kt");
                }

                @Test
                @TestMetadata("kt31653.kt")
                public void testKt31653() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653.kt");
                }

                @Test
                @TestMetadata("kt31653_2.kt")
                public void testKt31653_2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653_2.kt");
                }

                @Test
                @TestMetadata("kt31923.kt")
                public void testKt31923() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923.kt");
                }

                @Test
                @TestMetadata("kt31923_2.kt")
                public void testKt31923_2() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_2.kt");
                }

                @Test
                @TestMetadata("kt31923_wrong.kt")
                public void testKt31923_wrong() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_wrong.kt");
                }

                @Test
                @TestMetadata("nested.kt")
                public void testNested() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nested.kt");
                }

                @Test
                @TestMetadata("nestedWithReturns.kt")
                public void testNestedWithReturns() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturns.kt");
                }

                @Test
                @TestMetadata("nestedWithReturnsSimple.kt")
                public void testNestedWithReturnsSimple() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturnsSimple.kt");
                }

                @Test
                @TestMetadata("noFinally.kt")
                public void testNoFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/noFinally.kt");
                }

                @Test
                @TestMetadata("severalCatchClause.kt")
                public void testSeveralCatchClause() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/severalCatchClause.kt");
                }

                @Test
                @TestMetadata("simpleThrow.kt")
                public void testSimpleThrow() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/simpleThrow.kt");
                }

                @Test
                @TestMetadata("synchonized.kt")
                public void testSynchonized() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/synchonized.kt");
                }

                @Test
                @TestMetadata("throwInFinally.kt")
                public void testThrowInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/throwInFinally.kt");
                }

                @Test
                @TestMetadata("tryCatchInFinally.kt")
                public void testTryCatchInFinally() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/tryCatchInFinally.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables")
            @TestDataPath("$PROJECT_ROOT")
            public class Variables {
                @Test
                public void testAllFilesPresentInVariables() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
                }

                @Test
                @TestMetadata("kt7792.kt")
                public void testKt7792() throws Exception {
                    runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables/kt7792.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/optimizations")
    @TestDataPath("$PROJECT_ROOT")
    public class Optimizations {
        @Test
        public void testAllFilesPresentInOptimizations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/optimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("kt20844.kt")
        public void testKt20844() throws Exception {
            runTest("compiler/testData/codegen/boxInline/optimizations/kt20844.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/private")
    @TestDataPath("$PROJECT_ROOT")
    public class Private {
        @Test
        @TestMetadata("accessorForConst.kt")
        public void testAccessorForConst() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/accessorForConst.kt");
        }

        @Test
        @TestMetadata("accessorStability.kt")
        public void testAccessorStability() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/accessorStability.kt");
        }

        @Test
        @TestMetadata("accessorStabilityInClass.kt")
        public void testAccessorStabilityInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/accessorStabilityInClass.kt");
        }

        @Test
        public void testAllFilesPresentInPrivate() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("effectivePrivate.kt")
        public void testEffectivePrivate() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/effectivePrivate.kt");
        }

        @Test
        @TestMetadata("kt6453.kt")
        public void testKt6453() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/kt6453.kt");
        }

        @Test
        @TestMetadata("kt8094.kt")
        public void testKt8094() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/kt8094.kt");
        }

        @Test
        @TestMetadata("kt8095.kt")
        public void testKt8095() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/kt8095.kt");
        }

        @Test
        @TestMetadata("nestedInPrivateClass.kt")
        public void testNestedInPrivateClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass.kt");
        }

        @Test
        @TestMetadata("privateClass.kt")
        public void testPrivateClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/privateClass.kt");
        }

        @Test
        @TestMetadata("privateClassExtensionLambda.kt")
        public void testPrivateClassExtensionLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/privateClassExtensionLambda.kt");
        }

        @Test
        @TestMetadata("privateInInlineInMultiFileFacade.kt")
        public void testPrivateInInlineInMultiFileFacade() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/privateInInlineInMultiFileFacade.kt");
        }

        @Test
        @TestMetadata("privateInline.kt")
        public void testPrivateInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/private/privateInline.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/property")
    @TestDataPath("$PROJECT_ROOT")
    public class Property {
        @Test
        public void testAllFilesPresentInProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("augAssignmentAndInc.kt")
        public void testAugAssignmentAndInc() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndInc.kt");
        }

        @Test
        @TestMetadata("augAssignmentAndIncInClass.kt")
        public void testAugAssignmentAndIncInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClass.kt");
        }

        @Test
        @TestMetadata("augAssignmentAndIncInClassViaConvention.kt")
        public void testAugAssignmentAndIncInClassViaConvention() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClassViaConvention.kt");
        }

        @Test
        @TestMetadata("augAssignmentAndIncOnExtension.kt")
        public void testAugAssignmentAndIncOnExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtension.kt");
        }

        @Test
        @TestMetadata("augAssignmentAndIncOnExtensionInClass.kt")
        public void testAugAssignmentAndIncOnExtensionInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtensionInClass.kt");
        }

        @Test
        @TestMetadata("augAssignmentAndIncViaConvention.kt")
        public void testAugAssignmentAndIncViaConvention() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncViaConvention.kt");
        }

        @Test
        @TestMetadata("fromObject.kt")
        public void testFromObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/fromObject.kt");
        }

        @Test
        @TestMetadata("kt22649.kt")
        public void testKt22649() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/kt22649.kt");
        }

        @Test
        @TestMetadata("property.kt")
        public void testProperty() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/property.kt");
        }

        @Test
        @TestMetadata("reifiedVal.kt")
        public void testReifiedVal() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/reifiedVal.kt");
        }

        @Test
        @TestMetadata("reifiedVar.kt")
        public void testReifiedVar() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/reifiedVar.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/simple.kt");
        }

        @Test
        @TestMetadata("simpleExtension.kt")
        public void testSimpleExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/property/simpleExtension.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/reified")
    @TestDataPath("$PROJECT_ROOT")
    public class Reified {
        @Test
        public void testAllFilesPresentInReified() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/arrayConstructor.kt");
        }

        @Test
        @TestMetadata("arrayOf.kt")
        public void testArrayOf() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/arrayOf.kt");
        }

        @Test
        @TestMetadata("capturedLambda.kt")
        public void testCapturedLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/capturedLambda.kt");
        }

        @Test
        @TestMetadata("capturedLambda2.kt")
        public void testCapturedLambda2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/capturedLambda2.kt");
        }

        @Test
        @TestMetadata("dontSubstituteNonReified.kt")
        public void testDontSubstituteNonReified() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/dontSubstituteNonReified.kt");
        }

        @Test
        @TestMetadata("kt11081.kt")
        public void testKt11081() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt11081.kt");
        }

        @Test
        @TestMetadata("kt11677.kt")
        public void testKt11677() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt11677.kt");
        }

        @Test
        @TestMetadata("kt15956.kt")
        public void testKt15956() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt15956.kt");
        }

        @Test
        @TestMetadata("kt15997.kt")
        public void testKt15997() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt15997.kt");
        }

        @Test
        @TestMetadata("kt15997_2.kt")
        public void testKt15997_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt15997_2.kt");
        }

        @Test
        @TestMetadata("kt18977.kt")
        public void testKt18977() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt18977.kt");
        }

        @Test
        @TestMetadata("kt28234.kt")
        public void testKt28234() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt28234.kt");
        }

        @Test
        @TestMetadata("kt35511.kt")
        public void testKt35511() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt35511.kt");
        }

        @Test
        @TestMetadata("kt35511_try.kt")
        public void testKt35511_try() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt35511_try.kt");
        }

        @Test
        @TestMetadata("kt35511_try_valueOf.kt")
        public void testKt35511_try_valueOf() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_valueOf.kt");
        }

        @Test
        @TestMetadata("kt35511_try_values.kt")
        public void testKt35511_try_values() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_values.kt");
        }

        @Test
        @TestMetadata("kt44770.kt")
        public void testKt44770() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt44770.kt");
        }

        @Test
        @TestMetadata("kt44770_2.kt")
        public void testKt44770_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt44770_2.kt");
        }

        @Test
        @TestMetadata("kt46584.kt")
        public void testKt46584() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt46584.kt");
        }

        @Test
        @TestMetadata("kt46584_2.kt")
        public void testKt46584_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt46584_2.kt");
        }

        @Test
        @TestMetadata("kt6988.kt")
        public void testKt6988() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt6988.kt");
        }

        @Test
        @TestMetadata("kt6988_2.kt")
        public void testKt6988_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt6988_2.kt");
        }

        @Test
        @TestMetadata("kt6990.kt")
        public void testKt6990() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt6990.kt");
        }

        @Test
        @TestMetadata("kt7017.kt")
        public void testKt7017() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt7017.kt");
        }

        @Test
        @TestMetadata("kt8047.kt")
        public void testKt8047() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt8047.kt");
        }

        @Test
        @TestMetadata("kt8047_2.kt")
        public void testKt8047_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt8047_2.kt");
        }

        @Test
        @TestMetadata("kt9637.kt")
        public void testKt9637() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt9637.kt");
        }

        @Test
        @TestMetadata("kt9637_2.kt")
        public void testKt9637_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/kt9637_2.kt");
        }

        @Test
        @TestMetadata("nameClash.kt")
        public void testNameClash() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/nameClash.kt");
        }

        @Test
        @TestMetadata("nonCapturingObjectInLambda.kt")
        public void testNonCapturingObjectInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/nonCapturingObjectInLambda.kt");
        }

        @Test
        @TestMetadata("packages.kt")
        public void testPackages() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/packages.kt");
        }

        @Test
        @TestMetadata("singletonLambda.kt")
        public void testSingletonLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/reified/singletonLambda.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/reified/checkCast")
        @TestDataPath("$PROJECT_ROOT")
        public class CheckCast {
            @Test
            public void testAllFilesPresentInCheckCast() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/checkCast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("chain.kt")
            public void testChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/chain.kt");
            }

            @Test
            @TestMetadata("kt26435.kt")
            public void testKt26435() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435.kt");
            }

            @Test
            @TestMetadata("kt26435_2.kt")
            public void testKt26435_2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_2.kt");
            }

            @Test
            @TestMetadata("kt26435_3.kt")
            public void testKt26435_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_3.kt");
            }

            @Test
            @TestMetadata("kt8043.kt")
            public void testKt8043() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt8043.kt");
            }

            @Test
            @TestMetadata("maxStack.kt")
            public void testMaxStack() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/maxStack.kt");
            }

            @Test
            @TestMetadata("nullable.kt")
            public void testNullable() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/nullable.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple.kt");
            }

            @Test
            @TestMetadata("simpleSafe.kt")
            public void testSimpleSafe() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/simpleSafe.kt");
            }

            @Test
            @TestMetadata("simple_1_3.kt")
            public void testSimple_1_3() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple_1_3.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/reified/defaultLambda")
        @TestDataPath("$PROJECT_ROOT")
        public class DefaultLambda {
            @Test
            public void testAllFilesPresentInDefaultLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("chain.kt")
            public void testChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/chain.kt");
            }

            @Test
            @TestMetadata("nested.kt")
            public void testNested() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested.kt");
            }

            @Test
            @TestMetadata("nested2.kt")
            public void testNested2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2.kt");
            }

            @Test
            @TestMetadata("nested2Static.kt")
            public void testNested2Static() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2Static.kt");
            }

            @Test
            @TestMetadata("nestedStatic.kt")
            public void testNestedStatic() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nestedStatic.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/simple.kt");
            }

            @Test
            @TestMetadata("transitiveChain.kt")
            public void testTransitiveChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChain.kt");
            }

            @Test
            @TestMetadata("transitiveChainStatic.kt")
            public void testTransitiveChainStatic() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChainStatic.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/reified/isCheck")
        @TestDataPath("$PROJECT_ROOT")
        public class IsCheck {
            @Test
            public void testAllFilesPresentInIsCheck() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/isCheck"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("chain.kt")
            public void testChain() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/isCheck/chain.kt");
            }

            @Test
            @TestMetadata("nullable.kt")
            public void testNullable() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/isCheck/nullable.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/reified/isCheck/simple.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/signature")
    @TestDataPath("$PROJECT_ROOT")
    public class Signature {
        @Test
        public void testAllFilesPresentInSignature() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("inProjectionSubstitution.kt")
        public void testInProjectionSubstitution() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/inProjectionSubstitution.kt");
        }

        @Test
        @TestMetadata("outProjectionSubstitution.kt")
        public void testOutProjectionSubstitution() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/outProjectionSubstitution.kt");
        }

        @Test
        @TestMetadata("recursion.kt")
        public void testRecursion() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/recursion.kt");
        }

        @Test
        @TestMetadata("sameFormalParameterName.kt")
        public void testSameFormalParameterName() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/sameFormalParameterName.kt");
        }

        @Test
        @TestMetadata("sameReifiedFormalParameterName.kt")
        public void testSameReifiedFormalParameterName() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/sameReifiedFormalParameterName.kt");
        }

        @Test
        @TestMetadata("starProjectionSubstitution.kt")
        public void testStarProjectionSubstitution() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/starProjectionSubstitution.kt");
        }

        @Test
        @TestMetadata("typeParameterInLambda.kt")
        public void testTypeParameterInLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/typeParameterInLambda.kt");
        }

        @Test
        @TestMetadata("typeParametersSubstitution.kt")
        public void testTypeParametersSubstitution() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution.kt");
        }

        @Test
        @TestMetadata("typeParametersSubstitution2.kt")
        public void testTypeParametersSubstitution2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution2.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/signatureMangling")
    @TestDataPath("$PROJECT_ROOT")
    public class SignatureMangling {
        @Test
        public void testAllFilesPresentInSignatureMangling() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signatureMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/simple")
    @TestDataPath("$PROJECT_ROOT")
    public class Simple {
        @Test
        public void testAllFilesPresentInSimple() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/simple"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("captureAndArgumentIncompatibleTypes.kt")
        public void testCaptureAndArgumentIncompatibleTypes() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/captureAndArgumentIncompatibleTypes.kt");
        }

        @Test
        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/classObject.kt");
        }

        @Test
        @TestMetadata("destructuring.kt")
        public void testDestructuring() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/destructuring.kt");
        }

        @Test
        @TestMetadata("destructuringIndexClash.kt")
        public void testDestructuringIndexClash() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/destructuringIndexClash.kt");
        }

        @Test
        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/extension.kt");
        }

        @Test
        @TestMetadata("extensionLambda.kt")
        public void testExtensionLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/extensionLambda.kt");
        }

        @Test
        @TestMetadata("funImportedFromObject.kt")
        public void testFunImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/funImportedFromObject.kt");
        }

        @Test
        @TestMetadata("inlineCallInInlineLambda.kt")
        public void testInlineCallInInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/inlineCallInInlineLambda.kt");
        }

        @Test
        @TestMetadata("kt17431.kt")
        public void testKt17431() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/kt17431.kt");
        }

        @Test
        @TestMetadata("kt28547.kt")
        public void testKt28547() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/kt28547.kt");
        }

        @Test
        @TestMetadata("kt28547_2.kt")
        public void testKt28547_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/kt28547_2.kt");
        }

        @Test
        @TestMetadata("params.kt")
        public void testParams() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/params.kt");
        }

        @Test
        @TestMetadata("propImportedFromObject.kt")
        public void testPropImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/propImportedFromObject.kt");
        }

        @Test
        @TestMetadata("rootConstructor.kt")
        public void testRootConstructor() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/rootConstructor.kt");
        }

        @Test
        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/safeCall.kt");
        }

        @Test
        @TestMetadata("severalClosures.kt")
        public void testSeveralClosures() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/severalClosures.kt");
        }

        @Test
        @TestMetadata("severalUsage.kt")
        public void testSeveralUsage() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/severalUsage.kt");
        }

        @Test
        @TestMetadata("simpleDouble.kt")
        public void testSimpleDouble() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleDouble.kt");
        }

        @Test
        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleEnum.kt");
        }

        @Test
        @TestMetadata("simpleGenerics.kt")
        public void testSimpleGenerics() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleGenerics.kt");
        }

        @Test
        @TestMetadata("simpleInt.kt")
        public void testSimpleInt() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleInt.kt");
        }

        @Test
        @TestMetadata("simpleLambda.kt")
        public void testSimpleLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleLambda.kt");
        }

        @Test
        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/simpleObject.kt");
        }

        @Test
        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("compiler/testData/codegen/boxInline/simple/vararg.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/smap")
    @TestDataPath("$PROJECT_ROOT")
    public class Smap {
        @Test
        public void testAllFilesPresentInSmap() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("assertion.kt")
        public void testAssertion() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/assertion.kt");
        }

        @Test
        @TestMetadata("classCycle.kt")
        public void testClassCycle() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/classCycle.kt");
        }

        @Test
        @TestMetadata("classFromDefaultPackage.kt")
        public void testClassFromDefaultPackage() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/classFromDefaultPackage.kt");
        }

        @Test
        @TestMetadata("crossroutines.kt")
        public void testCrossroutines() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/crossroutines.kt");
        }

        @Test
        @TestMetadata("defaultFunction.kt")
        public void testDefaultFunction() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/defaultFunction.kt");
        }

        @Test
        @TestMetadata("defaultFunctionWithInlineCall.kt")
        public void testDefaultFunctionWithInlineCall() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/defaultFunctionWithInlineCall.kt");
        }

        @Test
        @TestMetadata("forInline.kt")
        public void testForInline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/forInline.kt");
        }

        @Test
        @TestMetadata("interleavedFiles.kt")
        public void testInterleavedFiles() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/interleavedFiles.kt");
        }

        @Test
        @TestMetadata("kt23369.kt")
        public void testKt23369() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/kt23369.kt");
        }

        @Test
        @TestMetadata("kt23369_2.kt")
        public void testKt23369_2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/kt23369_2.kt");
        }

        @Test
        @TestMetadata("kt23369_3.kt")
        public void testKt23369_3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/kt23369_3.kt");
        }

        @Test
        @TestMetadata("kt35006.kt")
        public void testKt35006() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/kt35006.kt");
        }

        @Test
        @TestMetadata("multiFileFacade.kt")
        public void testMultiFileFacade() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/multiFileFacade.kt");
        }

        @Test
        @TestMetadata("oneFile.kt")
        public void testOneFile() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/oneFile.kt");
        }

        @Test
        @TestMetadata("rangeFolding.kt")
        public void testRangeFolding() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/rangeFolding.kt");
        }

        @Test
        @TestMetadata("rangeFoldingInClass.kt")
        public void testRangeFoldingInClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/rangeFoldingInClass.kt");
        }

        @Test
        @TestMetadata("smap.kt")
        public void testSmap() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/smap.kt");
        }

        @Test
        @TestMetadata("smapWithNewSyntax.kt")
        public void testSmapWithNewSyntax() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/smapWithNewSyntax.kt");
        }

        @Test
        @TestMetadata("smapWithOldSyntax.kt")
        public void testSmapWithOldSyntax() throws Exception {
            runTest("compiler/testData/codegen/boxInline/smap/smapWithOldSyntax.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/smap/anonymous")
        @TestDataPath("$PROJECT_ROOT")
        public class Anonymous {
            @Test
            public void testAllFilesPresentInAnonymous() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/anonymous"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("kt19175.kt")
            public void testKt19175() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/kt19175.kt");
            }

            @Test
            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambda.kt");
            }

            @Test
            @TestMetadata("lambdaOnCallSite.kt")
            public void testLambdaOnCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnCallSite.kt");
            }

            @Test
            @TestMetadata("lambdaOnInlineCallSite.kt")
            public void testLambdaOnInlineCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnInlineCallSite.kt");
            }

            @Test
            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/object.kt");
            }

            @Test
            @TestMetadata("objectOnCallSite.kt")
            public void testObjectOnCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnCallSite.kt");
            }

            @Test
            @TestMetadata("objectOnInlineCallSite.kt")
            public void testObjectOnInlineCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite.kt");
            }

            @Test
            @TestMetadata("objectOnInlineCallSite2.kt")
            public void testObjectOnInlineCallSite2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite2.kt");
            }

            @Test
            @TestMetadata("objectOnInlineCallSiteWithCapture.kt")
            public void testObjectOnInlineCallSiteWithCapture() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSiteWithCapture.kt");
            }

            @Test
            @TestMetadata("severalMappingsForDefaultFile.kt")
            public void testSeveralMappingsForDefaultFile() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/anonymous/severalMappingsForDefaultFile.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/smap/defaultLambda")
        @TestDataPath("$PROJECT_ROOT")
        public class DefaultLambda {
            @Test
            public void testAllFilesPresentInDefaultLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("defaultLambdaInAnonymous.kt")
            public void testDefaultLambdaInAnonymous() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/defaultLambdaInAnonymous.kt");
            }

            @Test
            @TestMetadata("inlinInDefault.kt")
            public void testInlinInDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlinInDefault.kt");
            }

            @Test
            @TestMetadata("inlinInDefault2.kt")
            public void testInlinInDefault2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlinInDefault2.kt");
            }

            @Test
            @TestMetadata("inlineAnonymousInDefault.kt")
            public void testInlineAnonymousInDefault() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault.kt");
            }

            @Test
            @TestMetadata("inlineAnonymousInDefault2.kt")
            public void testInlineAnonymousInDefault2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault2.kt");
            }

            @Test
            @TestMetadata("kt21827.kt")
            public void testKt21827() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/kt21827.kt");
            }

            @Test
            @TestMetadata("nested.kt")
            public void testNested() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/nested.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple.kt");
            }

            @Test
            @TestMetadata("simple2.kt")
            public void testSimple2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple2.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/smap/inlineOnly")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineOnly {
            @Test
            public void testAllFilesPresentInInlineOnly() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/inlineOnly"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("noSmap.kt")
            public void testNoSmap() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmap.kt");
            }

            @Test
            @TestMetadata("noSmapWithProperty.kt")
            public void testNoSmapWithProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmapWithProperty.kt");
            }

            @Test
            @TestMetadata("reified.kt")
            public void testReified() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reified.kt");
            }

            @Test
            @TestMetadata("reifiedProperty.kt")
            public void testReifiedProperty() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reifiedProperty.kt");
            }

            @Test
            @TestMetadata("stdlibInlineOnly.kt")
            public void testStdlibInlineOnly() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnly.kt");
            }

            @Test
            @TestMetadata("stdlibInlineOnlyOneLine.kt")
            public void testStdlibInlineOnlyOneLine() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnlyOneLine.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/smap/newsmap")
        @TestDataPath("$PROJECT_ROOT")
        public class Newsmap {
            @Test
            public void testAllFilesPresentInNewsmap() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/newsmap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("differentMapping.kt")
            public void testDifferentMapping() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/newsmap/differentMapping.kt");
            }

            @Test
            @TestMetadata("mappingInInlineFunLambda.kt")
            public void testMappingInInlineFunLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInInlineFunLambda.kt");
            }

            @Test
            @TestMetadata("mappingInSubInlineLambda.kt")
            public void testMappingInSubInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambda.kt");
            }

            @Test
            @TestMetadata("mappingInSubInlineLambdaSameFileInline.kt")
            public void testMappingInSubInlineLambdaSameFileInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambdaSameFileInline.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/smap/resolve")
        @TestDataPath("$PROJECT_ROOT")
        public class Resolve {
            @Test
            public void testAllFilesPresentInResolve() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/resolve"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("inlineComponent.kt")
            public void testInlineComponent() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineComponent.kt");
            }

            @Test
            @TestMetadata("inlineIterator.kt")
            public void testInlineIterator() throws Exception {
                runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineIterator.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/special")
    @TestDataPath("$PROJECT_ROOT")
    public class Special {
        @Test
        public void testAllFilesPresentInSpecial() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/special"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("identityCheck.kt")
        public void testIdentityCheck() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/identityCheck.kt");
        }

        @Test
        @TestMetadata("ifBranches.kt")
        public void testIfBranches() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/ifBranches.kt");
        }

        @Test
        @TestMetadata("iinc.kt")
        public void testIinc() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/iinc.kt");
        }

        @Test
        @TestMetadata("inlineChain.kt")
        public void testInlineChain() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/inlineChain.kt");
        }

        @Test
        @TestMetadata("loopInStoreLoadChains.kt")
        public void testLoopInStoreLoadChains() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains.kt");
        }

        @Test
        @TestMetadata("loopInStoreLoadChains2.kt")
        public void testLoopInStoreLoadChains2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains2.kt");
        }

        @Test
        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/plusAssign.kt");
        }

        @Test
        @TestMetadata("stackHeightBug.kt")
        public void testStackHeightBug() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/stackHeightBug.kt");
        }

        @Test
        @TestMetadata("unusedInlineLambda.kt")
        public void testUnusedInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/special/unusedInlineLambda.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/stackOnReturn")
    @TestDataPath("$PROJECT_ROOT")
    public class StackOnReturn {
        @Test
        public void testAllFilesPresentInStackOnReturn() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/stackOnReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("elvis.kt")
        public void testElvis() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/elvis.kt");
        }

        @Test
        @TestMetadata("ifThenElse.kt")
        public void testIfThenElse() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/ifThenElse.kt");
        }

        @Test
        @TestMetadata("kt11499.kt")
        public void testKt11499() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt11499.kt");
        }

        @Test
        @TestMetadata("kt17591.kt")
        public void testKt17591() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591.kt");
        }

        @Test
        @TestMetadata("kt17591a.kt")
        public void testKt17591a() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591a.kt");
        }

        @Test
        @TestMetadata("kt17591b.kt")
        public void testKt17591b() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591b.kt");
        }

        @Test
        @TestMetadata("mixedTypesOnStack1.kt")
        public void testMixedTypesOnStack1() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack1.kt");
        }

        @Test
        @TestMetadata("mixedTypesOnStack2.kt")
        public void testMixedTypesOnStack2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack2.kt");
        }

        @Test
        @TestMetadata("mixedTypesOnStack3.kt")
        public void testMixedTypesOnStack3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack3.kt");
        }

        @Test
        @TestMetadata("nonLocalReturn1.kt")
        public void testNonLocalReturn1() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn1.kt");
        }

        @Test
        @TestMetadata("nonLocalReturn2.kt")
        public void testNonLocalReturn2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn2.kt");
        }

        @Test
        @TestMetadata("nonLocalReturn3.kt")
        public void testNonLocalReturn3() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn3.kt");
        }

        @Test
        @TestMetadata("poppedLocalReturn.kt")
        public void testPoppedLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn.kt");
        }

        @Test
        @TestMetadata("poppedLocalReturn2.kt")
        public void testPoppedLocalReturn2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn2.kt");
        }

        @Test
        @TestMetadata("returnLong.kt")
        public void testReturnLong() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/returnLong.kt");
        }

        @Test
        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/boxInline/stackOnReturn/tryFinally.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/suspend")
    @TestDataPath("$PROJECT_ROOT")
    public class Suspend {
        @Test
        public void testAllFilesPresentInSuspend() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("capturedVariables.kt")
        public void testCapturedVariables() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/capturedVariables.kt");
        }

        @Test
        @TestMetadata("crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt")
        public void testCrossinlineSuspendLambdaInsideCrossinlineSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt");
        }

        @Test
        @TestMetadata("debugMetadataCrossinline.kt")
        public void testDebugMetadataCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/debugMetadataCrossinline.kt");
        }

        @Test
        @TestMetadata("delegatedProperties.kt")
        public void testDelegatedProperties() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/delegatedProperties.kt");
        }

        @Test
        @TestMetadata("doubleRegenerationWithNonSuspendingLambda.kt")
        public void testDoubleRegenerationWithNonSuspendingLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/doubleRegenerationWithNonSuspendingLambda.kt");
        }

        @Test
        @TestMetadata("enclodingMethod.kt")
        public void testEnclodingMethod() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/enclodingMethod.kt");
        }

        @Test
        @TestMetadata("fileNameInMetadata.kt")
        public void testFileNameInMetadata() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/fileNameInMetadata.kt");
        }

        @Test
        @TestMetadata("inlineOrdinaryOfCrossinlineSuspend.kt")
        public void testInlineOrdinaryOfCrossinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfCrossinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlineOrdinaryOfNoinlineSuspend.kt")
        public void testInlineOrdinaryOfNoinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfNoinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlinePassthrough.kt")
        public void testInlinePassthrough() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthrough.kt");
        }

        @Test
        @TestMetadata("inlineSuspendContinuation.kt")
        public void testInlineSuspendContinuation() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendContinuation.kt");
        }

        @Test
        @TestMetadata("inlineSuspendInMultifileClass.kt")
        public void testInlineSuspendInMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendInMultifileClass.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfCrossinlineOrdinary.kt")
        public void testInlineSuspendOfCrossinlineOrdinary() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineOrdinary.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfCrossinlineSuspend.kt")
        public void testInlineSuspendOfCrossinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfNoinlineOrdinary.kt")
        public void testInlineSuspendOfNoinlineOrdinary() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineOrdinary.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfNoinlineSuspend.kt")
        public void testInlineSuspendOfNoinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfOrdinary.kt")
        public void testInlineSuspendOfOrdinary() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfOrdinary.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfSuspend.kt")
        public void testInlineSuspendOfSuspend() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfSuspend.kt");
        }

        @Test
        @TestMetadata("jvmName.kt")
        public void testJvmName() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/jvmName.kt");
        }

        @Test
        @TestMetadata("kt26658.kt")
        public void testKt26658() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/kt26658.kt");
        }

        @Test
        @TestMetadata("kt52198.kt")
        public void testKt52198() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/kt52198.kt");
        }

        @Test
        @TestMetadata("maxStackWithCrossinline.kt")
        public void testMaxStackWithCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/maxStackWithCrossinline.kt");
        }

        @Test
        @TestMetadata("multipleLocals.kt")
        public void testMultipleLocals() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/multipleLocals.kt");
        }

        @Test
        @TestMetadata("multipleSuspensionPoints.kt")
        public void testMultipleSuspensionPoints() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/multipleSuspensionPoints.kt");
        }

        @Test
        @TestMetadata("nestedMethodWith2XParameter.kt")
        public void testNestedMethodWith2XParameter() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/nestedMethodWith2XParameter.kt");
        }

        @Test
        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata("nonSuspendCrossinline.kt")
        public void testNonSuspendCrossinline() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/nonSuspendCrossinline.kt");
        }

        @Test
        @TestMetadata("returnValue.kt")
        public void testReturnValue() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/returnValue.kt");
        }

        @Test
        @TestMetadata("tryCatchReceiver.kt")
        public void testTryCatchReceiver() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/tryCatchReceiver.kt");
        }

        @Test
        @TestMetadata("tryCatchStackTransform.kt")
        public void testTryCatchStackTransform() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/tryCatchStackTransform.kt");
        }

        @Test
        @TestMetadata("twiceRegeneratedAnonymousObject.kt")
        public void testTwiceRegeneratedAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedAnonymousObject.kt");
        }

        @Test
        @TestMetadata("twiceRegeneratedSuspendLambda.kt")
        public void testTwiceRegeneratedSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedSuspendLambda.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/suspend/callableReference")
        @TestDataPath("$PROJECT_ROOT")
        public class CallableReference {
            @Test
            public void testAllFilesPresentInCallableReference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("isAsReified.kt")
            public void testIsAsReified() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified.kt");
            }

            @Test
            @TestMetadata("isAsReified2.kt")
            public void testIsAsReified2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified2.kt");
            }

            @Test
            @TestMetadata("nonTailCall.kt")
            public void testNonTailCall() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/nonTailCall.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/simple.kt");
            }

            @Test
            @TestMetadata("unitReturn.kt")
            public void testUnitReturn() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/callableReference/unitReturn.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/suspend/defaultParameter")
        @TestDataPath("$PROJECT_ROOT")
        public class DefaultParameter {
            @Test
            public void testAllFilesPresentInDefaultParameter() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/defaultParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("defaultInlineLambda.kt")
            public void testDefaultInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineLambda.kt");
            }

            @Test
            @TestMetadata("defaultInlineReference.kt")
            public void testDefaultInlineReference() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineReference.kt");
            }

            @Test
            @TestMetadata("defaultValueCrossinline.kt")
            public void testDefaultValueCrossinline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueCrossinline.kt");
            }

            @Test
            @TestMetadata("defaultValueInClass.kt")
            public void testDefaultValueInClass() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInClass.kt");
            }

            @Test
            @TestMetadata("defaultValueInline.kt")
            public void testDefaultValueInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInline.kt");
            }

            @Test
            @TestMetadata("defaultValueInlineFromMultiFileFacade.kt")
            public void testDefaultValueInlineFromMultiFileFacade() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInlineFromMultiFileFacade.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/suspend/inlineClass")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineClass {
            @Test
            public void testAllFilesPresentInInlineClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("returnBoxedFromLambda.kt")
            public void testReturnBoxedFromLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnBoxedFromLambda.kt");
            }

            @Test
            @TestMetadata("returnUnboxedDirect.kt")
            public void testReturnUnboxedDirect() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedDirect.kt");
            }

            @Test
            @TestMetadata("returnUnboxedFromLambda.kt")
            public void testReturnUnboxedFromLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedFromLambda.kt");
            }

            @Test
            @TestMetadata("returnUnboxedResume.kt")
            public void testReturnUnboxedResume() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedResume.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineUsedAsNoinline {
            @Test
            public void testAllFilesPresentInInlineUsedAsNoinline() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("inlineOnly.kt")
            public void testInlineOnly() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/inlineOnly.kt");
            }

            @Test
            @TestMetadata("simpleNamed.kt")
            public void testSimpleNamed() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/simpleNamed.kt");
            }

            @Test
            @TestMetadata("withCapturedInlineLambda.kt")
            public void testWithCapturedInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda.kt");
            }

            @Test
            @TestMetadata("withCapturedInlineLambda2.kt")
            public void testWithCapturedInlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda2.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/suspend/receiver")
        @TestDataPath("$PROJECT_ROOT")
        public class Receiver {
            @Test
            public void testAllFilesPresentInReceiver() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/receiver"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("inlineOrdinaryOfCrossinlineSuspend.kt")
            public void testInlineOrdinaryOfCrossinlineSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfCrossinlineSuspend.kt");
            }

            @Test
            @TestMetadata("inlineOrdinaryOfNoinlineSuspend.kt")
            public void testInlineOrdinaryOfNoinlineSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfNoinlineSuspend.kt");
            }

            @Test
            @TestMetadata("inlineSuspendOfCrossinlineOrdinary.kt")
            public void testInlineSuspendOfCrossinlineOrdinary() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineOrdinary.kt");
            }

            @Test
            @TestMetadata("inlineSuspendOfCrossinlineSuspend.kt")
            public void testInlineSuspendOfCrossinlineSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineSuspend.kt");
            }

            @Test
            @TestMetadata("inlineSuspendOfNoinlineOrdinary.kt")
            public void testInlineSuspendOfNoinlineOrdinary() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineOrdinary.kt");
            }

            @Test
            @TestMetadata("inlineSuspendOfNoinlineSuspend.kt")
            public void testInlineSuspendOfNoinlineSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineSuspend.kt");
            }

            @Test
            @TestMetadata("inlineSuspendOfOrdinary.kt")
            public void testInlineSuspendOfOrdinary() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfOrdinary.kt");
            }

            @Test
            @TestMetadata("inlineSuspendOfSuspend.kt")
            public void testInlineSuspendOfSuspend() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfSuspend.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/suspend/stateMachine")
        @TestDataPath("$PROJECT_ROOT")
        public class StateMachine {
            @Test
            public void testAllFilesPresentInStateMachine() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("crossingCoroutineBoundaries.kt")
            public void testCrossingCoroutineBoundaries() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/crossingCoroutineBoundaries.kt");
            }

            @Test
            @TestMetadata("independentInline.kt")
            public void testIndependentInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/independentInline.kt");
            }

            @Test
            @TestMetadata("innerLambda.kt")
            public void testInnerLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambda.kt");
            }

            @Test
            @TestMetadata("innerLambdaInsideLambda.kt")
            public void testInnerLambdaInsideLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaInsideLambda.kt");
            }

            @Test
            @TestMetadata("innerLambdaWithoutCrossinline.kt")
            public void testInnerLambdaWithoutCrossinline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaWithoutCrossinline.kt");
            }

            @Test
            @TestMetadata("innerMadness.kt")
            public void testInnerMadness() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadness.kt");
            }

            @Test
            @TestMetadata("innerMadnessCallSite.kt")
            public void testInnerMadnessCallSite() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadnessCallSite.kt");
            }

            @Test
            @TestMetadata("innerObject.kt")
            public void testInnerObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObject.kt");
            }

            @Test
            @TestMetadata("innerObjectInsideInnerObject.kt")
            public void testInnerObjectInsideInnerObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectInsideInnerObject.kt");
            }

            @Test
            @TestMetadata("innerObjectRetransformation.kt")
            public void testInnerObjectRetransformation() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectRetransformation.kt");
            }

            @Test
            @TestMetadata("innerObjectSeveralFunctions.kt")
            public void testInnerObjectSeveralFunctions() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectSeveralFunctions.kt");
            }

            @Test
            @TestMetadata("innerObjectWithoutCapturingCrossinline.kt")
            public void testInnerObjectWithoutCapturingCrossinline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectWithoutCapturingCrossinline.kt");
            }

            @Test
            @TestMetadata("insideObject.kt")
            public void testInsideObject() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/insideObject.kt");
            }

            @Test
            @TestMetadata("kt30708.kt")
            public void testKt30708() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/kt30708.kt");
            }

            @Test
            @TestMetadata("lambdaTransformation.kt")
            public void testLambdaTransformation() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/lambdaTransformation.kt");
            }

            @Test
            @TestMetadata("normalInline.kt")
            public void testNormalInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/normalInline.kt");
            }

            @Test
            @TestMetadata("numberOfSuspentions.kt")
            public void testNumberOfSuspentions() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/numberOfSuspentions.kt");
            }

            @Test
            @TestMetadata("objectInsideLambdas.kt")
            public void testObjectInsideLambdas() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/objectInsideLambdas.kt");
            }

            @Test
            @TestMetadata("oneInlineTwoCaptures.kt")
            public void testOneInlineTwoCaptures() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/oneInlineTwoCaptures.kt");
            }

            @Test
            @TestMetadata("passLambda.kt")
            public void testPassLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passLambda.kt");
            }

            @Test
            @TestMetadata("passParameter.kt")
            public void testPassParameter() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameter.kt");
            }

            @Test
            @TestMetadata("passParameterLambda.kt")
            public void testPassParameterLambda() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameterLambda.kt");
            }

            @Test
            @TestMetadata("unreachableSuspendMarker.kt")
            public void testUnreachableSuspendMarker() throws Exception {
                runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/unreachableSuspendMarker.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/syntheticAccessors")
    @TestDataPath("$PROJECT_ROOT")
    public class SyntheticAccessors {
        @Test
        public void testAllFilesPresentInSyntheticAccessors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("constField.kt")
        public void testConstField() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/constField.kt");
        }

        @Test
        @TestMetadata("packagePrivateMembers.kt")
        public void testPackagePrivateMembers() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/packagePrivateMembers.kt");
        }

        @Test
        @TestMetadata("propertyModifiers.kt")
        public void testPropertyModifiers() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/propertyModifiers.kt");
        }

        @Test
        @TestMetadata("protectedMembers.kt")
        public void testProtectedMembers() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembers.kt");
        }

        @Test
        @TestMetadata("protectedMembersFromSuper.kt")
        public void testProtectedMembersFromSuper() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembersFromSuper.kt");
        }

        @Test
        @TestMetadata("superCall.kt")
        public void testSuperCall() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCall.kt");
        }

        @Test
        @TestMetadata("superCallFromMultipleSubclasses.kt")
        public void testSuperCallFromMultipleSubclasses() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCallFromMultipleSubclasses.kt");
        }

        @Test
        @TestMetadata("superProperty.kt")
        public void testSuperProperty() throws Exception {
            runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superProperty.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda")
        @TestDataPath("$PROJECT_ROOT")
        public class WithinInlineLambda {
            @Test
            public void testAllFilesPresentInWithinInlineLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
            }

            @Test
            @TestMetadata("directFieldAccess.kt")
            public void testDirectFieldAccess() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccess.kt");
            }

            @Test
            @TestMetadata("directFieldAccessInCrossInline.kt")
            public void testDirectFieldAccessInCrossInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccessInCrossInline.kt");
            }

            @Test
            @TestMetadata("privateCall.kt")
            public void testPrivateCall() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateCall.kt");
            }

            @Test
            @TestMetadata("privateInCrossInline.kt")
            public void testPrivateInCrossInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInCrossInline.kt");
            }

            @Test
            @TestMetadata("privateInDefaultStubArgument.kt")
            public void testPrivateInDefaultStubArgument() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInDefaultStubArgument.kt");
            }

            @Test
            @TestMetadata("protectedInCrossinline.kt")
            public void testProtectedInCrossinline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedInCrossinline.kt");
            }

            @Test
            @TestMetadata("protectedMembersFromSuper.kt")
            public void testProtectedMembersFromSuper() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedMembersFromSuper.kt");
            }

            @Test
            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superCall.kt");
            }

            @Test
            @TestMetadata("superInCrossInline.kt")
            public void testSuperInCrossInline() throws Exception {
                runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superInCrossInline.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/trait")
    @TestDataPath("$PROJECT_ROOT")
    public class Trait {
        @Test
        public void testAllFilesPresentInTrait() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/trait"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("trait.kt")
        public void testTrait() throws Exception {
            runTest("compiler/testData/codegen/boxInline/trait/trait.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/tryCatchFinally")
    @TestDataPath("$PROJECT_ROOT")
    public class TryCatchFinally {
        @Test
        public void testAllFilesPresentInTryCatchFinally() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/tryCatchFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("kt5863.kt")
        public void testKt5863() throws Exception {
            runTest("compiler/testData/codegen/boxInline/tryCatchFinally/kt5863.kt");
        }

        @Test
        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch.kt");
        }

        @Test
        @TestMetadata("tryCatch2.kt")
        public void testTryCatch2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch2.kt");
        }

        @Test
        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatchFinally.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/varargs")
    @TestDataPath("$PROJECT_ROOT")
    public class Varargs {
        @Test
        public void testAllFilesPresentInVarargs() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true);
        }

        @Test
        @TestMetadata("kt17653.kt")
        public void testKt17653() throws Exception {
            runTest("compiler/testData/codegen/boxInline/varargs/kt17653.kt");
        }

        @Test
        @TestMetadata("varargAndDefaultParameters.kt")
        public void testVarargAndDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters.kt");
        }

        @Test
        @TestMetadata("varargAndDefaultParameters2.kt")
        public void testVarargAndDefaultParameters2() throws Exception {
            runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters2.kt");
        }
    }
}
