/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
public class ForeignAnnotationsCompiledJavaWithPsiClassReadingTestGenerated extends AbstractForeignAnnotationsCompiledJavaWithPsiClassReadingTest {
    @Nested
    @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests")
    @TestDataPath("$PROJECT_ROOT")
    public class Tests {
        @Test
        public void testAllFilesPresentInTests() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
        }

        @Test
        @TestMetadata("androidRecently.kt")
        public void testAndroidRecently() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/androidRecently.kt");
        }

        @Test
        @TestMetadata("androidSdk.kt")
        public void testAndroidSdk() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/androidSdk.kt");
        }

        @Test
        @TestMetadata("android_support.kt")
        public void testAndroid_support() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/android_support.kt");
        }

        @Test
        @TestMetadata("androidx.kt")
        public void testAndroidx() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/androidx.kt");
        }

        @Test
        @TestMetadata("aosp.kt")
        public void testAosp() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/aosp.kt");
        }

        @Test
        @TestMetadata("checkerFramework.kt")
        public void testCheckerFramework() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/checkerFramework.kt");
        }

        @Test
        @TestMetadata("eclipse.kt")
        public void testEclipse() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/eclipse.kt");
        }

        @Test
        @TestMetadata("findBugsSimple.kt")
        public void testFindBugsSimple() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/findBugsSimple.kt");
        }

        @Test
        @TestMetadata("irrelevantQualifierNicknames.kt")
        public void testIrrelevantQualifierNicknames() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/irrelevantQualifierNicknames.kt");
        }

        @Test
        @TestMetadata("kt47833.kt")
        public void testKt47833() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/kt47833.kt");
        }

        @Test
        @TestMetadata("kt47920.kt")
        public void testKt47920() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/kt47920.kt");
        }

        @Test
        @TestMetadata("kt48316_multiModuleAnnotationDefault.kt")
        public void testKt48316_multiModuleAnnotationDefault() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/kt48316_multiModuleAnnotationDefault.kt");
        }

        @Test
        @TestMetadata("lombokSimple.kt")
        public void testLombokSimple() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/lombokSimple.kt");
        }

        @Test
        @TestMetadata("multiple.kt")
        public void testMultiple() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/multiple.kt");
        }

        @Test
        @TestMetadata("rxjava.kt")
        public void testRxjava() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/rxjava.kt");
        }

        @Test
        @TestMetadata("rxjava3Default.kt")
        public void testRxjava3Default() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/rxjava3Default.kt");
        }

        @Test
        @TestMetadata("rxjava3Errors.kt")
        public void testRxjava3Errors() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/rxjava3Errors.kt");
        }

        @Test
        @TestMetadata("rxjava3Ignore.kt")
        public void testRxjava3Ignore() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/rxjava3Ignore.kt");
        }

        @Test
        @TestMetadata("rxjava3Warnings.kt")
        public void testRxjava3Warnings() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/rxjava3Warnings.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305")
        @TestDataPath("$PROJECT_ROOT")
        public class Jsr305 {
            @Test
            public void testAllFilesPresentInJsr305() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("dontIgnoreAnnotationsWithoutTarget.kt")
            public void testDontIgnoreAnnotationsWithoutTarget() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/dontIgnoreAnnotationsWithoutTarget.kt");
            }

            @Test
            @TestMetadata("nonNullNever.kt")
            public void testNonNullNever() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nonNullNever.kt");
            }

            @Test
            @TestMetadata("nullabilityNicknames.kt")
            public void testNullabilityNicknames() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityNicknames.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/simple.kt");
            }

            @Test
            @TestMetadata("strange.kt")
            public void testStrange() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/strange.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/ignore")
            @TestDataPath("$PROJECT_ROOT")
            public class Ignore {
                @Test
                public void testAllFilesPresentInIgnore() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/ignore"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("parametersAreNonnullByDefault.kt")
                public void testParametersAreNonnullByDefault() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/ignore/parametersAreNonnullByDefault.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings")
            @TestDataPath("$PROJECT_ROOT")
            public class NullabilityWarnings {
                @Test
                public void testAllFilesPresentInNullabilityWarnings() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("elvis.kt")
                public void testElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/elvis.kt");
                }

                @Test
                @TestMetadata("localInference.kt")
                public void testLocalInference() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/localInference.kt");
                }

                @Test
                @TestMetadata("nullabilityGenerics.kt")
                public void testNullabilityGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/nullabilityGenerics.kt");
                }

                @Test
                @TestMetadata("nullabilityNicknames.kt")
                public void testNullabilityNicknames() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/nullabilityNicknames.kt");
                }

                @Test
                @TestMetadata("safeCalls.kt")
                public void testSafeCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/safeCalls.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/simple.kt");
                }

                @Test
                @TestMetadata("strange.kt")
                public void testStrange() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/strange.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes")
                @TestDataPath("$PROJECT_ROOT")
                public class FromPlatformTypes {
                    @Test
                    public void testAllFilesPresentInFromPlatformTypes() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("arithmetic.kt")
                    public void testArithmetic() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/arithmetic.kt");
                    }

                    @Test
                    @TestMetadata("array.kt")
                    public void testArray() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/array.kt");
                    }

                    @Test
                    @TestMetadata("assignToVar.kt")
                    public void testAssignToVar() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/assignToVar.kt");
                    }

                    @Test
                    @TestMetadata("conditions.kt")
                    public void testConditions() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/conditions.kt");
                    }

                    @Test
                    @TestMetadata("dataFlowInfo.kt")
                    public void testDataFlowInfo() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/dataFlowInfo.kt");
                    }

                    @Test
                    @TestMetadata("defaultParameters.kt")
                    public void testDefaultParameters() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/defaultParameters.kt");
                    }

                    @Test
                    @TestMetadata("delegatedProperties.kt")
                    public void testDelegatedProperties() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/delegatedProperties.kt");
                    }

                    @Test
                    @TestMetadata("delegation.kt")
                    public void testDelegation() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/delegation.kt");
                    }

                    @Test
                    @TestMetadata("derefenceExtension.kt")
                    public void testDerefenceExtension() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/derefenceExtension.kt");
                    }

                    @Test
                    @TestMetadata("derefenceMember.kt")
                    public void testDerefenceMember() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/derefenceMember.kt");
                    }

                    @Test
                    @TestMetadata("expectedType.kt")
                    public void testExpectedType() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/expectedType.kt");
                    }

                    @Test
                    @TestMetadata("for.kt")
                    public void testFor() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/for.kt");
                    }

                    @Test
                    @TestMetadata("functionArguments.kt")
                    public void testFunctionArguments() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/functionArguments.kt");
                    }

                    @Test
                    @TestMetadata("invoke.kt")
                    public void testInvoke() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/invoke.kt");
                    }

                    @Test
                    @TestMetadata("kt6829.kt")
                    public void testKt6829() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/kt6829.kt");
                    }

                    @Test
                    @TestMetadata("multiDeclaration.kt")
                    public void testMultiDeclaration() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/multiDeclaration.kt");
                    }

                    @Test
                    @TestMetadata("passToJava.kt")
                    public void testPassToJava() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/passToJava.kt");
                    }

                    @Test
                    @TestMetadata("primitiveArray.kt")
                    public void testPrimitiveArray() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/primitiveArray.kt");
                    }

                    @Test
                    @TestMetadata("throw.kt")
                    public void testThrow() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/throw.kt");
                    }

                    @Test
                    @TestMetadata("uselessElvisRightIsNull.kt")
                    public void testUselessElvisRightIsNull() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/fromPlatformTypes/uselessElvisRightIsNull.kt");
                    }
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault")
                @TestDataPath("$PROJECT_ROOT")
                public class TypeQualifierDefault {
                    @Test
                    public void testAllFilesPresentInTypeQualifierDefault() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("equalsOnNonNull.kt")
                    public void testEqualsOnNonNull() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault/equalsOnNonNull.kt");
                    }

                    @Test
                    @TestMetadata("fieldsAreNullable.kt")
                    public void testFieldsAreNullable() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault/fieldsAreNullable.kt");
                    }

                    @Test
                    @TestMetadata("nullabilityFromOverridden.kt")
                    public void testNullabilityFromOverridden() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault/nullabilityFromOverridden.kt");
                    }

                    @Test
                    @TestMetadata("overridingDefaultQualifier.kt")
                    public void testOverridingDefaultQualifier() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault/overridingDefaultQualifier.kt");
                    }

                    @Test
                    @TestMetadata("parametersAreNonnullByDefault.kt")
                    public void testParametersAreNonnullByDefault() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault/parametersAreNonnullByDefault.kt");
                    }

                    @Test
                    @TestMetadata("parametersAreNonnullByDefaultPackage.kt")
                    public void testParametersAreNonnullByDefaultPackage() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault/parametersAreNonnullByDefaultPackage.kt");
                    }

                    @Test
                    @TestMetadata("springNullable.kt")
                    public void testSpringNullable() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault/springNullable.kt");
                    }

                    @Test
                    @TestMetadata("springNullablePackage.kt")
                    public void testSpringNullablePackage() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/nullabilityWarnings/typeQualifierDefault/springNullablePackage.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault")
            @TestDataPath("$PROJECT_ROOT")
            public class TypeQualifierDefault {
                @Test
                public void testAllFilesPresentInTypeQualifierDefault() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("fieldsAreNullable.kt")
                public void testFieldsAreNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/fieldsAreNullable.kt");
                }

                @Test
                @TestMetadata("forceFlexibility.kt")
                public void testForceFlexibility() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/forceFlexibility.kt");
                }

                @Test
                @TestMetadata("forceFlexibleOverOverrides.kt")
                public void testForceFlexibleOverOverrides() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/forceFlexibleOverOverrides.kt");
                }

                @Test
                @TestMetadata("nullabilityFromOverridden.kt")
                public void testNullabilityFromOverridden() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/nullabilityFromOverridden.kt");
                }

                @Test
                @TestMetadata("overridingDefaultQualifier.kt")
                public void testOverridingDefaultQualifier() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/overridingDefaultQualifier.kt");
                }

                @Test
                @TestMetadata("parametersAreNonnullByDefault.kt")
                public void testParametersAreNonnullByDefault() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/parametersAreNonnullByDefault.kt");
                }

                @Test
                @TestMetadata("parametersAreNonnullByDefaultPackage.kt")
                public void testParametersAreNonnullByDefaultPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/parametersAreNonnullByDefaultPackage.kt");
                }

                @Test
                @TestMetadata("springNullable.kt")
                public void testSpringNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/springNullable.kt");
                }

                @Test
                @TestMetadata("springNullablePackage.kt")
                public void testSpringNullablePackage() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305/typeQualifierDefault/springNullablePackage.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings")
        @TestDataPath("$PROJECT_ROOT")
        public class Jsr305NullabilityWarnings {
            @Test
            public void testAllFilesPresentInJsr305NullabilityWarnings() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration")
            @TestDataPath("$PROJECT_ROOT")
            public class Migration {
                @Test
                public void testAllFilesPresentInMigration() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("customMigration.kt")
                public void testCustomMigration() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/customMigration.kt");
                }

                @Test
                @TestMetadata("globalIgnore.kt")
                public void testGlobalIgnore() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/globalIgnore.kt");
                }

                @Test
                @TestMetadata("globalWarningMigrationIgnore.kt")
                public void testGlobalWarningMigrationIgnore() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/globalWarningMigrationIgnore.kt");
                }

                @Test
                @TestMetadata("migrationError.kt")
                public void testMigrationError() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/migrationError.kt");
                }

                @Test
                @TestMetadata("migrationIgnore.kt")
                public void testMigrationIgnore() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/migrationIgnore.kt");
                }

                @Test
                @TestMetadata("migrationWarning.kt")
                public void testMigrationWarning() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/migrationWarning.kt");
                }

                @Test
                @TestMetadata("overrideConflicts.kt")
                public void testOverrideConflicts() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/overrideConflicts.kt");
                }

                @Test
                @TestMetadata("specialCollision.kt")
                public void testSpecialCollision() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/specialCollision.kt");
                }

                @Test
                @TestMetadata("stateRefinement.kt")
                public void testStateRefinement() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/jsr305NullabilityWarnings/migration/stateRefinement.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/tests/typeQualifierDefault")
        @TestDataPath("$PROJECT_ROOT")
        public class TypeQualifierDefault {
            @Test
            public void testAllFilesPresentInTypeQualifierDefault() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/tests/typeQualifierDefault"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("defaultAndNicknameMigrationPolicy.kt")
            public void testDefaultAndNicknameMigrationPolicy() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/tests/typeQualifierDefault/defaultAndNicknameMigrationPolicy.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests")
    @TestDataPath("$PROJECT_ROOT")
    public class Java8Tests {
        @Test
        public void testAllFilesPresentInJava8Tests() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
        }

        @Test
        @TestMetadata("checkerFramework.kt")
        public void testCheckerFramework() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/checkerFramework.kt");
        }

        @Test
        @TestMetadata("eclipse.kt")
        public void testEclipse() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/eclipse.kt");
        }

        @Test
        @TestMetadata("typeUseOnObject.kt")
        public void testTypeUseOnObject() throws Exception {
            runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/typeUseOnObject.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify")
        @TestDataPath("$PROJECT_ROOT")
        public class Jspecify {
            @Test
            public void testAllFilesPresentInJspecify() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("default.kt")
            public void testDefault() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/default.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode")
            @TestDataPath("$PROJECT_ROOT")
            public class StrictMode {
                @Test
                public void testAllFilesPresentInStrictMode() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("AnnotatedBoundsOfWildcard.kt")
                public void testAnnotatedBoundsOfWildcard() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/AnnotatedBoundsOfWildcard.kt");
                }

                @Test
                @TestMetadata("Captured.kt")
                public void testCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/Captured.kt");
                }

                @Test
                @TestMetadata("Defaults.kt")
                public void testDefaults() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/Defaults.kt");
                }

                @Test
                @TestMetadata("IgnoreAnnotations.kt")
                public void testIgnoreAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/IgnoreAnnotations.kt");
                }

                @Test
                @TestMetadata("kt47396.kt")
                public void testKt47396() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/kt47396.kt");
                }

                @Test
                @TestMetadata("kt47422.kt")
                public void testKt47422() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/kt47422.kt");
                }

                @Test
                @TestMetadata("kt47437.kt")
                public void testKt47437() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/kt47437.kt");
                }

                @Test
                @TestMetadata("kt48261.kt")
                public void testKt48261() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/kt48261.kt");
                }

                @Test
                @TestMetadata("NonPlatformTypeParameter.kt")
                public void testNonPlatformTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/NonPlatformTypeParameter.kt");
                }

                @Test
                @TestMetadata("NullnessUnspecifiedTypeParameter.kt")
                public void testNullnessUnspecifiedTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/NullnessUnspecifiedTypeParameter.kt");
                }

                @Test
                @TestMetadata("SelfType.kt")
                public void testSelfType() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/SelfType.kt");
                }

                @Test
                @TestMetadata("Simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/Simple.kt");
                }

                @Test
                @TestMetadata("TypeArgumentsFromParameterBounds.kt")
                public void testTypeArgumentsFromParameterBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/TypeArgumentsFromParameterBounds.kt");
                }

                @Test
                @TestMetadata("TypeParameterBounds.kt")
                public void testTypeParameterBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/TypeParameterBounds.kt");
                }

                @Test
                @TestMetadata("UnannotatedWildcard.kt")
                public void testUnannotatedWildcard() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/UnannotatedWildcard.kt");
                }

                @Test
                @TestMetadata("WildcardsWithDefault.kt")
                public void testWildcardsWithDefault() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/strictMode/WildcardsWithDefault.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode")
            @TestDataPath("$PROJECT_ROOT")
            public class WarnMode {
                @Test
                public void testAllFilesPresentInWarnMode() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("AnnotatedBoundsOfWildcard.kt")
                public void testAnnotatedBoundsOfWildcard() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/AnnotatedBoundsOfWildcard.kt");
                }

                @Test
                @TestMetadata("Captured.kt")
                public void testCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/Captured.kt");
                }

                @Test
                @TestMetadata("Defaults.kt")
                public void testDefaults() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/Defaults.kt");
                }

                @Test
                @TestMetadata("IgnoreAnnotations.kt")
                public void testIgnoreAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/IgnoreAnnotations.kt");
                }

                @Test
                @TestMetadata("kt47899.kt")
                public void testKt47899() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/kt47899.kt");
                }

                @Test
                @TestMetadata("NonPlatformTypeParameter.kt")
                public void testNonPlatformTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/NonPlatformTypeParameter.kt");
                }

                @Test
                @TestMetadata("NullnessUnspecifiedTypeParameter.kt")
                public void testNullnessUnspecifiedTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/NullnessUnspecifiedTypeParameter.kt");
                }

                @Test
                @TestMetadata("OverrideOfAnnotated.kt")
                public void testOverrideOfAnnotated() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/OverrideOfAnnotated.kt");
                }

                @Test
                @TestMetadata("SelfType.kt")
                public void testSelfType() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/SelfType.kt");
                }

                @Test
                @TestMetadata("Simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/Simple.kt");
                }

                @Test
                @TestMetadata("TypeArgumentsFromParameterBounds.kt")
                public void testTypeArgumentsFromParameterBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/TypeArgumentsFromParameterBounds.kt");
                }

                @Test
                @TestMetadata("TypeParameterBounds.kt")
                public void testTypeParameterBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/TypeParameterBounds.kt");
                }

                @Test
                @TestMetadata("UnannotatedWildcard.kt")
                public void testUnannotatedWildcard() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/UnannotatedWildcard.kt");
                }

                @Test
                @TestMetadata("WildcardsWithDefault.kt")
                public void testWildcardsWithDefault() throws Exception {
                    runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jspecify/warnMode/WildcardsWithDefault.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305")
        @TestDataPath("$PROJECT_ROOT")
        public class Jsr305 {
            @Test
            public void testAllFilesPresentInJsr305() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("defaultAnnotationAppliedToType.kt")
            public void testDefaultAnnotationAppliedToType() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305/defaultAnnotationAppliedToType.kt");
            }

            @Test
            @TestMetadata("defaultAnnotationAppliedToTypeForCompiledJava.kt")
            public void testDefaultAnnotationAppliedToTypeForCompiledJava() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305/defaultAnnotationAppliedToTypeForCompiledJava.kt");
            }

            @Test
            @TestMetadata("overrideWithTypeUseInClasspath.kt")
            public void testOverrideWithTypeUseInClasspath() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305/overrideWithTypeUseInClasspath.kt");
            }

            @Test
            @TestMetadata("overrideWithTypeUseInClasspathWithArray.kt")
            public void testOverrideWithTypeUseInClasspathWithArray() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305/overrideWithTypeUseInClasspathWithArray.kt");
            }

            @Test
            @TestMetadata("springNullableWithTypeUse.kt")
            public void testSpringNullableWithTypeUse() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305/springNullableWithTypeUse.kt");
            }

            @Test
            @TestMetadata("typeArguments.kt")
            public void testTypeArguments() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305/typeArguments.kt");
            }

            @Test
            @TestMetadata("typeUseVsMethodConflict.kt")
            public void testTypeUseVsMethodConflict() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/jsr305/typeUseVsMethodConflict.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc")
        @TestDataPath("$PROJECT_ROOT")
        public class Misc {
            @Test
            public void testAllFilesPresentInMisc() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("annotatedTypeArguments.kt")
            public void testAnnotatedTypeArguments() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/annotatedTypeArguments.kt");
            }

            @Test
            @TestMetadata("classTypeParameterBound.kt")
            public void testClassTypeParameterBound() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/classTypeParameterBound.kt");
            }

            @Test
            @TestMetadata("classTypeParameterBoundWithWarnings.kt")
            public void testClassTypeParameterBoundWithWarnings() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/classTypeParameterBoundWithWarnings.kt");
            }

            @Test
            @TestMetadata("enhancedRecursiveStarProjection.kt")
            public void testEnhancedRecursiveStarProjection() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/enhancedRecursiveStarProjection.kt");
            }

            @Test
            @TestMetadata("kt48261.kt")
            public void testKt48261() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/kt48261.kt");
            }

            @Test
            @TestMetadata("methodWithTypeParameter.kt")
            public void testMethodWithTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/methodWithTypeParameter.kt");
            }

            @Test
            @TestMetadata("notNullVarargsOverrides.kt")
            public void testNotNullVarargsOverrides() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/notNullVarargsOverrides.kt");
            }

            @Test
            @TestMetadata("nullableVarargsOverrides.kt")
            public void testNullableVarargsOverrides() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/nullableVarargsOverrides.kt");
            }

            @Test
            @TestMetadata("returnType.kt")
            public void testReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/returnType.kt");
            }

            @Test
            @TestMetadata("returnTypeDifferentConstructor.kt")
            public void testReturnTypeDifferentConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/returnTypeDifferentConstructor.kt");
            }

            @Test
            @TestMetadata("returnTypeOverrideInKotlin.kt")
            public void testReturnTypeOverrideInKotlin() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/returnTypeOverrideInKotlin.kt");
            }

            @Test
            @TestMetadata("returnTypeWithWarnings.kt")
            public void testReturnTypeWithWarnings() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/returnTypeWithWarnings.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/simple.kt");
            }

            @Test
            @TestMetadata("useTypeParameterAnnotationToEnhanceItsUsages.kt")
            public void testUseTypeParameterAnnotationToEnhanceItsUsages() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/useTypeParameterAnnotationToEnhanceItsUsages.kt");
            }

            @Test
            @TestMetadata("valueParameter.kt")
            public void testValueParameter() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/valueParameter.kt");
            }

            @Test
            @TestMetadata("valueParameterWithWarnings.kt")
            public void testValueParameterWithWarnings() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/valueParameterWithWarnings.kt");
            }

            @Test
            @TestMetadata("warningsBasedOnEnhancedBasedType.kt")
            public void testWarningsBasedOnEnhancedBasedType() throws Exception {
                runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java8Tests/misc/warningsBasedOnEnhancedBasedType.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests")
    @TestDataPath("$PROJECT_ROOT")
    public class Java11Tests {
        @Test
        public void testAllFilesPresentInJava11Tests() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify")
        @TestDataPath("$PROJECT_ROOT")
        public class Jspecify {
            @Test
            public void testAllFilesPresentInJspecify() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations")
            @TestDataPath("$PROJECT_ROOT")
            public class ModuleAnnotations {
                @Test
                public void testAllFilesPresentInModuleAnnotations() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict")
                @TestDataPath("$PROJECT_ROOT")
                public class Strict {
                    @Test
                    public void testAllFilesPresentInStrict() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("basic.kt")
                    public void testBasic() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/basic.kt");
                    }

                    @Test
                    @TestMetadata("composeWithClassDefaultAnnotation.kt")
                    public void testComposeWithClassDefaultAnnotation() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/composeWithClassDefaultAnnotation.kt");
                    }

                    @Test
                    @TestMetadata("composeWithPackageDefaultAnnotation.kt")
                    public void testComposeWithPackageDefaultAnnotation() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/composeWithPackageDefaultAnnotation.kt");
                    }

                    @Test
                    @TestMetadata("dependentModulesNoNullMarked.kt")
                    public void testDependentModulesNoNullMarked() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/dependentModulesNoNullMarked.kt");
                    }

                    @Test
                    @TestMetadata("dependentModulesNullMarked.kt")
                    public void testDependentModulesNullMarked() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/dependentModulesNullMarked.kt");
                    }

                    @Test
                    @TestMetadata("dontPropagateModuleAnnotationToAnotherModuleWithSamePackage.kt")
                    public void testDontPropagateModuleAnnotationToAnotherModuleWithSamePackage() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/dontPropagateModuleAnnotationToAnotherModuleWithSamePackage.kt");
                    }

                    @Test
                    @TestMetadata("dotNamedModule.kt")
                    public void testDotNamedModule() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/dotNamedModule.kt");
                    }

                    @Test
                    @TestMetadata("inheritanceAcrossModules.kt")
                    public void testInheritanceAcrossModules() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/inheritanceAcrossModules.kt");
                    }

                    @Test
                    @TestMetadata("nestedClasses.kt")
                    public void testNestedClasses() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/nestedClasses.kt");
                    }

                    @Test
                    @TestMetadata("overrideAtDeclarationLevel.kt")
                    public void testOverrideAtDeclarationLevel() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/overrideAtDeclarationLevel.kt");
                    }

                    @Test
                    @TestMetadata("severalModulesDifferentPackages.kt")
                    public void testSeveralModulesDifferentPackages() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/strict/severalModulesDifferentPackages.kt");
                    }
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn")
                @TestDataPath("$PROJECT_ROOT")
                public class Warn {
                    @Test
                    public void testAllFilesPresentInWarn() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn"), Pattern.compile("^(.+)\\.kt$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("basic.kt")
                    public void testBasic() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/basic.kt");
                    }

                    @Test
                    @TestMetadata("composeWithClassDefaultAnnotation.kt")
                    public void testComposeWithClassDefaultAnnotation() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/composeWithClassDefaultAnnotation.kt");
                    }

                    @Test
                    @TestMetadata("composeWithPackageDefaultAnnotation.kt")
                    public void testComposeWithPackageDefaultAnnotation() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/composeWithPackageDefaultAnnotation.kt");
                    }

                    @Test
                    @TestMetadata("dependentModulesNoNullMarked.kt")
                    public void testDependentModulesNoNullMarked() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/dependentModulesNoNullMarked.kt");
                    }

                    @Test
                    @TestMetadata("dependentModulesNullMarked.kt")
                    public void testDependentModulesNullMarked() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/dependentModulesNullMarked.kt");
                    }

                    @Test
                    @TestMetadata("dontPropagateModuleAnnotationToAnotherModuleWithSamePackage.kt")
                    public void testDontPropagateModuleAnnotationToAnotherModuleWithSamePackage() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/dontPropagateModuleAnnotationToAnotherModuleWithSamePackage.kt");
                    }

                    @Test
                    @TestMetadata("dotNamedModule.kt")
                    public void testDotNamedModule() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/dotNamedModule.kt");
                    }

                    @Test
                    @TestMetadata("inheritanceAcrossModules.kt")
                    public void testInheritanceAcrossModules() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/inheritanceAcrossModules.kt");
                    }

                    @Test
                    @TestMetadata("nestedClasses.kt")
                    public void testNestedClasses() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/nestedClasses.kt");
                    }

                    @Test
                    @TestMetadata("overrideAtDeclarationLevel.kt")
                    public void testOverrideAtDeclarationLevel() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/overrideAtDeclarationLevel.kt");
                    }

                    @Test
                    @TestMetadata("severalModulesDifferentPackages.kt")
                    public void testSeveralModulesDifferentPackages() throws Exception {
                        runTest("compiler/testData/diagnostics/foreignAnnotationsTests/java11Tests/jspecify/moduleAnnotations/warn/severalModulesDifferentPackages.kt");
                    }
                }
            }
        }
    }
}
